/*--------------------------------------------------------------------------*\

    FILE....: vpb_ioctl.h
    TYPE....: C Header File
    AUTHOR..: David Rowe
    DATE....: 22/9/99

    This file defines the interface between the kernel mode 
    device driver and the user mode driver code.  This interface
    supports both ISA and PCI cards with the same kernel mode
    driver.


         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2007 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#ifndef __IOCTL__
#define __IOCTL__


typedef struct {
  unsigned short port;
  void		*data;
  int            length;
  int	         dsp_addr;
  int            pci_num;
} VPB_DATA;
#define	VPB_IOC_MAGIC	'v'


#ifdef __FreeBSD__
//#ifndef KERNEL
//#include <sys/types.h>
//#endif
#include <sys/ioccom.h>

/* PCI commands */
#define VPB_IOC_PCI_BLOCK_WRITE    _IOW(VPB_IOC_MAGIC, 5, VPB_DATA)
#define VPB_IOC_PCI_BLOCK_READ     _IOW(VPB_IOC_MAGIC, 6, VPB_DATA)
#define VPB_IOC_PCI_DSP_RESET      _IOW(VPB_IOC_MAGIC, 7, VPB_DATA)
#define VPB_IOC_PCI_DSP_RUN        _IOW(VPB_IOC_MAGIC, 8, VPB_DATA)
#define VPB_IOC_PCI_GET_NUM_CARDS  _IOW(VPB_IOC_MAGIC, 9, VPB_DATA)
#define VPB_IOC_PCI_BLOCK_EEREAD   _IOW(VPB_IOC_MAGIC, 10, VPB_DATA)
//reserved
#define VPB_IOC_PCI_BLOCK_IICWRITE _IOW(VPB_IOC_MAGIC, 12, VPB_DATA)
#define VPB_IOC_PCI_BLOCK_IICREAD  _IOW(VPB_IOC_MAGIC, 13, VPB_DATA)

#else

/* PCI commands */
#define VPB_IOC_PCI_BLOCK_WRITE    _IO(VPB_IOC_MAGIC, 5)
#define VPB_IOC_PCI_BLOCK_READ     _IO(VPB_IOC_MAGIC, 6)
#define VPB_IOC_PCI_DSP_RESET      _IO(VPB_IOC_MAGIC, 7)
#define VPB_IOC_PCI_DSP_RUN        _IO(VPB_IOC_MAGIC, 8)
#define VPB_IOC_PCI_GET_NUM_CARDS  _IO(VPB_IOC_MAGIC, 9)
#define VPB_IOC_PCI_BLOCK_EEREAD   _IO(VPB_IOC_MAGIC, 10)
// reserved
#define VPB_IOC_PCI_BLOCK_IICWRITE    _IO(VPB_IOC_MAGIC, 12)
#define VPB_IOC_PCI_BLOCK_IICREAD     _IO(VPB_IOC_MAGIC, 13)

#endif

#endif


