/* typereference.c generated by valac, the Vala compiler
 * generated from typereference.vala, do not modify */

/* typereference.vala
 *
 * Copyright (C) 2008-2011  Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */


#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <vala.h>

enum  {
	VALADOC_API_TYPEREFERENCE_0_PROPERTY,
	VALADOC_API_TYPEREFERENCE_DATA_TYPE_PROPERTY,
	VALADOC_API_TYPEREFERENCE_PASS_OWNERSHIP_PROPERTY,
	VALADOC_API_TYPEREFERENCE_IS_OWNED_PROPERTY,
	VALADOC_API_TYPEREFERENCE_IS_WEAK_PROPERTY,
	VALADOC_API_TYPEREFERENCE_IS_UNOWNED_PROPERTY,
	VALADOC_API_TYPEREFERENCE_IS_DYNAMIC_PROPERTY,
	VALADOC_API_TYPEREFERENCE_IS_NULLABLE_PROPERTY,
	VALADOC_API_TYPEREFERENCE_NUM_PROPERTIES
};
static GParamSpec* valadoc_api_typereference_properties[VALADOC_API_TYPEREFERENCE_NUM_PROPERTIES];
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _valadoc_api_signature_builder_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_api_signature_builder_unref (var), NULL)))

struct _ValadocApiTypeReferencePrivate {
	ValaArrayList* type_arguments;
	gchar* dbus_type_signature;
	ValadocApiOwnership ownership;
	ValadocApiItem* _data_type;
	gboolean _pass_ownership;
	gboolean _is_dynamic;
	gboolean _is_nullable;
};


static gint ValadocApiTypeReference_private_offset;
static gpointer valadoc_api_typereference_parent_class = NULL;

static void valadoc_api_typereference_set_pass_ownership (ValadocApiTypeReference* self,
                                                   gboolean value);
static void valadoc_api_typereference_set_is_nullable (ValadocApiTypeReference* self,
                                                gboolean value);
static void valadoc_api_typereference_set_is_dynamic (ValadocApiTypeReference* self,
                                               gboolean value);
static ValadocContentInline* valadoc_api_typereference_real_build_signature (ValadocApiItem* base);
static void valadoc_api_typereference_finalize (GObject * obj);
static void _vala_valadoc_api_typereference_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_valadoc_api_typereference_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);


static inline gpointer
valadoc_api_typereference_get_instance_private (ValadocApiTypeReference* self)
{
	return G_STRUCT_MEMBER_P (self, ValadocApiTypeReference_private_offset);
}


ValadocApiTypeReference*
valadoc_api_typereference_construct (GType object_type,
                                     ValadocApiItem* parent,
                                     ValadocApiOwnership ownership,
                                     gboolean pass_ownership,
                                     gboolean is_dynamic,
                                     gboolean is_nullable,
                                     const gchar* dbus_type_signature,
                                     ValaDataType* data)
{
	ValadocApiTypeReference * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (parent != NULL, NULL);
	self = (ValadocApiTypeReference*) valadoc_api_item_construct (object_type, (ValaCodeNode*) data);
	_tmp0_ = g_strdup (dbus_type_signature);
	_g_free0 (self->priv->dbus_type_signature);
	self->priv->dbus_type_signature = _tmp0_;
	valadoc_api_typereference_set_pass_ownership (self, pass_ownership);
	valadoc_api_typereference_set_is_nullable (self, is_nullable);
	valadoc_api_typereference_set_is_dynamic (self, is_dynamic);
	self->priv->ownership = ownership;
	valadoc_api_item_set_parent ((ValadocApiItem*) self, parent);
	return self;
}


ValadocApiTypeReference*
valadoc_api_typereference_new (ValadocApiItem* parent,
                               ValadocApiOwnership ownership,
                               gboolean pass_ownership,
                               gboolean is_dynamic,
                               gboolean is_nullable,
                               const gchar* dbus_type_signature,
                               ValaDataType* data)
{
	return valadoc_api_typereference_construct (VALADOC_API_TYPE_TYPEREFERENCE, parent, ownership, pass_ownership, is_dynamic, is_nullable, dbus_type_signature, data);
}


/**
 * Returns a copy of the list of generic type arguments.
 *
 * @return type argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaCollection*
valadoc_api_typereference_get_type_arguments (ValadocApiTypeReference* self)
{
	ValaCollection* result = NULL;
	ValaArrayList* _tmp0_;
	ValaCollection* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_arguments;
	_tmp1_ = _vala_iterable_ref0 ((ValaCollection*) _tmp0_);
	result = _tmp1_;
	return result;
}


void
valadoc_api_typereference_add_type_argument (ValadocApiTypeReference* self,
                                             ValadocApiTypeReference* type_ref)
{
	ValaArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type_ref != NULL);
	_tmp0_ = self->priv->type_arguments;
	vala_collection_add ((ValaCollection*) _tmp0_, type_ref);
}


gchar*
valadoc_api_typereference_get_dbus_type_signature (ValadocApiTypeReference* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->dbus_type_signature;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * {@inheritDoc}
 */
static ValadocContentInline*
valadoc_api_typereference_real_build_signature (ValadocApiItem* base)
{
	ValadocApiTypeReference * self;
	ValadocContentInline* result = NULL;
	ValadocApiSignatureBuilder* signature = NULL;
	ValadocApiSignatureBuilder* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	ValadocApiItem* _tmp12_;
	ValaArrayList* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gboolean _tmp43_;
	ValadocApiSignatureBuilder* _tmp45_;
	ValadocContentRun* _tmp46_;
	self = (ValadocApiTypeReference*) base;
	_tmp0_ = valadoc_api_signature_builder_new ();
	signature = _tmp0_;
	_tmp1_ = self->priv->_is_dynamic;
	if (_tmp1_) {
		ValadocApiSignatureBuilder* _tmp2_;
		_tmp2_ = signature;
		valadoc_api_signature_builder_append_keyword (_tmp2_, "dynamic", TRUE);
	}
	_tmp3_ = valadoc_api_typereference_get_is_weak (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		ValadocApiSignatureBuilder* _tmp5_;
		_tmp5_ = signature;
		valadoc_api_signature_builder_append_keyword (_tmp5_, "weak", TRUE);
	} else {
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = valadoc_api_typereference_get_is_owned (self);
		_tmp7_ = _tmp6_;
		if (_tmp7_) {
			ValadocApiSignatureBuilder* _tmp8_;
			_tmp8_ = signature;
			valadoc_api_signature_builder_append_keyword (_tmp8_, "owned", TRUE);
		} else {
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp9_ = valadoc_api_typereference_get_is_unowned (self);
			_tmp10_ = _tmp9_;
			if (_tmp10_) {
				ValadocApiSignatureBuilder* _tmp11_;
				_tmp11_ = signature;
				valadoc_api_signature_builder_append_keyword (_tmp11_, "unowned", TRUE);
			}
		}
	}
	_tmp12_ = self->priv->_data_type;
	if (_tmp12_ == NULL) {
		ValadocApiSignatureBuilder* _tmp13_;
		_tmp13_ = signature;
		valadoc_api_signature_builder_append_keyword (_tmp13_, "void", TRUE);
	} else {
		ValadocApiItem* _tmp14_;
		_tmp14_ = self->priv->_data_type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALADOC_API_TYPE_SYMBOL)) {
			ValadocApiSignatureBuilder* _tmp15_;
			ValadocApiItem* _tmp16_;
			_tmp15_ = signature;
			_tmp16_ = self->priv->_data_type;
			valadoc_api_signature_builder_append_type (_tmp15_, (ValadocApiNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALADOC_API_TYPE_SYMBOL, ValadocApiSymbol), TRUE);
		} else {
			ValadocApiSignatureBuilder* _tmp17_;
			ValadocApiItem* _tmp18_;
			ValadocContentInline* _tmp19_;
			ValadocContentInline* _tmp20_;
			_tmp17_ = signature;
			_tmp18_ = self->priv->_data_type;
			_tmp19_ = valadoc_api_item_get_signature (_tmp18_);
			_tmp20_ = _tmp19_;
			valadoc_api_signature_builder_append_content (_tmp17_, _tmp20_, TRUE);
		}
	}
	_tmp21_ = self->priv->type_arguments;
	_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
	_tmp23_ = _tmp22_;
	if (_tmp23_ > 0) {
		ValadocApiSignatureBuilder* _tmp24_;
		gboolean first = FALSE;
		ValadocApiSignatureBuilder* _tmp42_;
		_tmp24_ = signature;
		valadoc_api_signature_builder_append (_tmp24_, "<", FALSE);
		first = TRUE;
		{
			ValaArrayList* _param_list = NULL;
			ValaArrayList* _tmp25_;
			ValaArrayList* _tmp26_;
			gint _param_size = 0;
			ValaArrayList* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gint _param_index = 0;
			_tmp25_ = self->priv->type_arguments;
			_tmp26_ = _vala_iterable_ref0 (_tmp25_);
			_param_list = _tmp26_;
			_tmp27_ = _param_list;
			_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
			_tmp29_ = _tmp28_;
			_param_size = _tmp29_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				ValadocApiItem* param = NULL;
				ValaArrayList* _tmp33_;
				gint _tmp34_;
				gpointer _tmp35_;
				gboolean _tmp36_;
				ValadocApiSignatureBuilder* _tmp38_;
				ValadocApiItem* _tmp39_;
				ValadocContentInline* _tmp40_;
				ValadocContentInline* _tmp41_;
				_tmp30_ = _param_index;
				_param_index = _tmp30_ + 1;
				_tmp31_ = _param_index;
				_tmp32_ = _param_size;
				if (!(_tmp31_ < _tmp32_)) {
					break;
				}
				_tmp33_ = _param_list;
				_tmp34_ = _param_index;
				_tmp35_ = vala_list_get ((ValaList*) _tmp33_, _tmp34_);
				param = (ValadocApiItem*) ((ValadocApiTypeReference*) _tmp35_);
				_tmp36_ = first;
				if (!_tmp36_) {
					ValadocApiSignatureBuilder* _tmp37_;
					_tmp37_ = signature;
					valadoc_api_signature_builder_append (_tmp37_, ",", FALSE);
				}
				_tmp38_ = signature;
				_tmp39_ = param;
				_tmp40_ = valadoc_api_item_get_signature (_tmp39_);
				_tmp41_ = _tmp40_;
				valadoc_api_signature_builder_append_content (_tmp38_, _tmp41_, FALSE);
				first = FALSE;
				_g_object_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp42_ = signature;
		valadoc_api_signature_builder_append (_tmp42_, ">", FALSE);
	}
	_tmp43_ = self->priv->_is_nullable;
	if (_tmp43_) {
		ValadocApiSignatureBuilder* _tmp44_;
		_tmp44_ = signature;
		valadoc_api_signature_builder_append (_tmp44_, "?", FALSE);
	}
	_tmp45_ = signature;
	_tmp46_ = valadoc_api_signature_builder_get (_tmp45_);
	result = (ValadocContentInline*) _tmp46_;
	_valadoc_api_signature_builder_unref0 (signature);
	return result;
}


ValadocApiItem*
valadoc_api_typereference_get_data_type (ValadocApiTypeReference* self)
{
	ValadocApiItem* result;
	ValadocApiItem* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


void
valadoc_api_typereference_set_data_type (ValadocApiTypeReference* self,
                                         ValadocApiItem* value)
{
	g_return_if_fail (self != NULL);
	if (valadoc_api_typereference_get_data_type (self) != value) {
		ValadocApiItem* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_data_type);
		self->priv->_data_type = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_api_typereference_properties[VALADOC_API_TYPEREFERENCE_DATA_TYPE_PROPERTY]);
	}
}


gboolean
valadoc_api_typereference_get_pass_ownership (ValadocApiTypeReference* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_pass_ownership;
	result = _tmp0_;
	return result;
}


static void
valadoc_api_typereference_set_pass_ownership (ValadocApiTypeReference* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	if (valadoc_api_typereference_get_pass_ownership (self) != value) {
		self->priv->_pass_ownership = value;
		g_object_notify_by_pspec ((GObject *) self, valadoc_api_typereference_properties[VALADOC_API_TYPEREFERENCE_PASS_OWNERSHIP_PROPERTY]);
	}
}


gboolean
valadoc_api_typereference_get_is_owned (ValadocApiTypeReference* self)
{
	gboolean result;
	ValadocApiOwnership _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->ownership;
	result = _tmp0_ == VALADOC_API_OWNERSHIP_OWNED;
	return result;
}


gboolean
valadoc_api_typereference_get_is_weak (ValadocApiTypeReference* self)
{
	gboolean result;
	ValadocApiOwnership _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->ownership;
	result = _tmp0_ == VALADOC_API_OWNERSHIP_WEAK;
	return result;
}


gboolean
valadoc_api_typereference_get_is_unowned (ValadocApiTypeReference* self)
{
	gboolean result;
	ValadocApiOwnership _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->ownership;
	result = _tmp0_ == VALADOC_API_OWNERSHIP_UNOWNED;
	return result;
}


gboolean
valadoc_api_typereference_get_is_dynamic (ValadocApiTypeReference* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_dynamic;
	result = _tmp0_;
	return result;
}


static void
valadoc_api_typereference_set_is_dynamic (ValadocApiTypeReference* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	if (valadoc_api_typereference_get_is_dynamic (self) != value) {
		self->priv->_is_dynamic = value;
		g_object_notify_by_pspec ((GObject *) self, valadoc_api_typereference_properties[VALADOC_API_TYPEREFERENCE_IS_DYNAMIC_PROPERTY]);
	}
}


gboolean
valadoc_api_typereference_get_is_nullable (ValadocApiTypeReference* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_nullable;
	result = _tmp0_;
	return result;
}


static void
valadoc_api_typereference_set_is_nullable (ValadocApiTypeReference* self,
                                           gboolean value)
{
	g_return_if_fail (self != NULL);
	if (valadoc_api_typereference_get_is_nullable (self) != value) {
		self->priv->_is_nullable = value;
		g_object_notify_by_pspec ((GObject *) self, valadoc_api_typereference_properties[VALADOC_API_TYPEREFERENCE_IS_NULLABLE_PROPERTY]);
	}
}


static void
valadoc_api_typereference_class_init (ValadocApiTypeReferenceClass * klass)
{
	valadoc_api_typereference_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ValadocApiTypeReference_private_offset);
	((ValadocApiItemClass *) klass)->build_signature = (ValadocContentInline* (*) (ValadocApiItem*)) valadoc_api_typereference_real_build_signature;
	G_OBJECT_CLASS (klass)->get_property = _vala_valadoc_api_typereference_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_valadoc_api_typereference_set_property;
	G_OBJECT_CLASS (klass)->finalize = valadoc_api_typereference_finalize;
	/**
	 * The referred data type.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_TYPEREFERENCE_DATA_TYPE_PROPERTY, valadoc_api_typereference_properties[VALADOC_API_TYPEREFERENCE_DATA_TYPE_PROPERTY] = g_param_spec_object ("data-type", "data-type", "data-type", VALADOC_API_TYPE_ITEM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_TYPEREFERENCE_PASS_OWNERSHIP_PROPERTY, valadoc_api_typereference_properties[VALADOC_API_TYPEREFERENCE_PASS_OWNERSHIP_PROPERTY] = g_param_spec_boolean ("pass-ownership", "pass-ownership", "pass-ownership", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Specifies that the expression is owned.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_TYPEREFERENCE_IS_OWNED_PROPERTY, valadoc_api_typereference_properties[VALADOC_API_TYPEREFERENCE_IS_OWNED_PROPERTY] = g_param_spec_boolean ("is-owned", "is-owned", "is-owned", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Specifies that the expression is weak.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_TYPEREFERENCE_IS_WEAK_PROPERTY, valadoc_api_typereference_properties[VALADOC_API_TYPEREFERENCE_IS_WEAK_PROPERTY] = g_param_spec_boolean ("is-weak", "is-weak", "is-weak", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Specifies that the expression is unwoned.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_TYPEREFERENCE_IS_UNOWNED_PROPERTY, valadoc_api_typereference_properties[VALADOC_API_TYPEREFERENCE_IS_UNOWNED_PROPERTY] = g_param_spec_boolean ("is-unowned", "is-unowned", "is-unowned", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Specifies that the expression is dynamic.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_TYPEREFERENCE_IS_DYNAMIC_PROPERTY, valadoc_api_typereference_properties[VALADOC_API_TYPEREFERENCE_IS_DYNAMIC_PROPERTY] = g_param_spec_boolean ("is-dynamic", "is-dynamic", "is-dynamic", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Specifies that the expression may be null.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_TYPEREFERENCE_IS_NULLABLE_PROPERTY, valadoc_api_typereference_properties[VALADOC_API_TYPEREFERENCE_IS_NULLABLE_PROPERTY] = g_param_spec_boolean ("is-nullable", "is-nullable", "is-nullable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}


static void
valadoc_api_typereference_instance_init (ValadocApiTypeReference * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = valadoc_api_typereference_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALADOC_API_TYPE_TYPEREFERENCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	self->priv->type_arguments = _tmp1_;
}


static void
valadoc_api_typereference_finalize (GObject * obj)
{
	ValadocApiTypeReference * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_API_TYPE_TYPEREFERENCE, ValadocApiTypeReference);
	_vala_iterable_unref0 (self->priv->type_arguments);
	_g_free0 (self->priv->dbus_type_signature);
	_g_object_unref0 (self->priv->_data_type);
	G_OBJECT_CLASS (valadoc_api_typereference_parent_class)->finalize (obj);
}


/**
 * A reference to a data type.
 */
GType
valadoc_api_typereference_get_type (void)
{
	static volatile gsize valadoc_api_typereference_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_api_typereference_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValadocApiTypeReferenceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_api_typereference_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocApiTypeReference), 0, (GInstanceInitFunc) valadoc_api_typereference_instance_init, NULL };
		GType valadoc_api_typereference_type_id;
		valadoc_api_typereference_type_id = g_type_register_static (VALADOC_API_TYPE_ITEM, "ValadocApiTypeReference", &g_define_type_info, 0);
		ValadocApiTypeReference_private_offset = g_type_add_instance_private (valadoc_api_typereference_type_id, sizeof (ValadocApiTypeReferencePrivate));
		g_once_init_leave (&valadoc_api_typereference_type_id__volatile, valadoc_api_typereference_type_id);
	}
	return valadoc_api_typereference_type_id__volatile;
}


static void
_vala_valadoc_api_typereference_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	ValadocApiTypeReference * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_API_TYPE_TYPEREFERENCE, ValadocApiTypeReference);
	switch (property_id) {
		case VALADOC_API_TYPEREFERENCE_DATA_TYPE_PROPERTY:
		g_value_set_object (value, valadoc_api_typereference_get_data_type (self));
		break;
		case VALADOC_API_TYPEREFERENCE_PASS_OWNERSHIP_PROPERTY:
		g_value_set_boolean (value, valadoc_api_typereference_get_pass_ownership (self));
		break;
		case VALADOC_API_TYPEREFERENCE_IS_OWNED_PROPERTY:
		g_value_set_boolean (value, valadoc_api_typereference_get_is_owned (self));
		break;
		case VALADOC_API_TYPEREFERENCE_IS_WEAK_PROPERTY:
		g_value_set_boolean (value, valadoc_api_typereference_get_is_weak (self));
		break;
		case VALADOC_API_TYPEREFERENCE_IS_UNOWNED_PROPERTY:
		g_value_set_boolean (value, valadoc_api_typereference_get_is_unowned (self));
		break;
		case VALADOC_API_TYPEREFERENCE_IS_DYNAMIC_PROPERTY:
		g_value_set_boolean (value, valadoc_api_typereference_get_is_dynamic (self));
		break;
		case VALADOC_API_TYPEREFERENCE_IS_NULLABLE_PROPERTY:
		g_value_set_boolean (value, valadoc_api_typereference_get_is_nullable (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_valadoc_api_typereference_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	ValadocApiTypeReference * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_API_TYPE_TYPEREFERENCE, ValadocApiTypeReference);
	switch (property_id) {
		case VALADOC_API_TYPEREFERENCE_DATA_TYPE_PROPERTY:
		valadoc_api_typereference_set_data_type (self, g_value_get_object (value));
		break;
		case VALADOC_API_TYPEREFERENCE_PASS_OWNERSHIP_PROPERTY:
		valadoc_api_typereference_set_pass_ownership (self, g_value_get_boolean (value));
		break;
		case VALADOC_API_TYPEREFERENCE_IS_DYNAMIC_PROPERTY:
		valadoc_api_typereference_set_is_dynamic (self, g_value_get_boolean (value));
		break;
		case VALADOC_API_TYPEREFERENCE_IS_NULLABLE_PROPERTY:
		valadoc_api_typereference_set_is_nullable (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



