// Copyright 2012-2018 The Rust Project Developers. See the COPYRIGHT
// file at the top-level directory of this distribution and at
// http://rust-lang.org/COPYRIGHT.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

// NOTE: The following code was generated by "scripts/unicode.py", do not edit directly

#![allow(missing_docs)]
use crate::quick_check::IsNormalized;
use crate::quick_check::IsNormalized::*;

#[allow(unused)]
pub const UNICODE_VERSION: (u64, u64, u64) = (9, 0, 0);

pub(crate) const CANONICAL_COMBINING_CLASS_SALT: &[u16] = &[
    0x0,
    0x5,
    0x224,
    0xd1,
    0x11e,
    0x25c,
    0x11,
    0x3,
    0x0,
    0x6,
    0x6f,
    0x0,
    0x50,
    0x9b,
    0x6,
    0x0,
    0x0,
    0x0,
    0x1,
    0x3,
    0x7b,
    0x3,
    0x0,
    0x12,
    0x83,
    0x0,
    0x3c,
    0x1,
    0x0,
    0x0,
    0x31,
    0x2,
    0x0,
    0x51,
    0x3c,
    0x0,
    0x1,
    0x1,
    0x3,
    0x0,
    0x1,
    0x5,
    0xd,
    0xe,
    0x0,
    0x3e,
    0x5,
    0x1e,
    0x0,
    0x8,
    0x13,
    0x7,
    0x0,
    0xd8,
    0x0,
    0x0,
    0x0,
    0x0,
    0x11,
    0x1,
    0x4,
    0x1c,
    0x0,
    0x36,
    0x0,
    0x0,
    0x9,
    0x4b,
    0x0,
    0x0,
    0x5c,
    0x4,
    0x7,
    0x2,
    0x1a,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x7,
    0x1,
    0xd,
    0x36,
    0x2c,
    0x0,
    0x7,
    0x1,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x7,
    0x18,
    0x0,
    0x9,
    0x0,
    0x7,
    0xc,
    0x1,
    0x2b,
    0x0,
    0x2,
    0xf,
    0x39,
    0x19,
    0x0,
    0x2,
    0x6,
    0x6,
    0x2,
    0x0,
    0x0,
    0x4,
    0x0,
    0x0,
    0x0,
    0xe,
    0x2,
    0x5,
    0x3c,
    0xc,
    0x0,
    0xb,
    0x0,
    0x0,
    0x0,
    0xf,
    0x0,
    0x1,
    0x4,
    0x0,
    0x31,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0xc,
    0xc,
    0x0,
    0x1d,
    0x27,
    0x6,
    0x9,
    0x32,
    0x7,
    0x8,
    0x0,
    0x0,
    0x7,
    0x4,
    0x0,
    0x3,
    0x10,
    0x4,
    0x0,
    0x0,
    0x13,
    0x3,
    0x0,
    0x10,
    0x0,
    0x38,
    0x2,
    0x15,
    0x0,
    0x0,
    0x2,
    0xa,
    0x1,
    0x6,
    0x9,
    0x4,
    0x2,
    0x4,
    0x2,
    0x0,
    0x2,
    0x49,
    0x0,
    0x0,
    0x0,
    0x2,
    0x3,
    0x2,
    0x0,
    0x0,
    0xc,
    0x0,
    0x0,
    0x5,
    0x0,
    0x0,
    0x0,
    0x0,
    0xe,
    0x25,
    0x0,
    0x0,
    0x0,
    0x23,
    0x7,
    0x3,
    0x0,
    0x1,
    0x4,
    0x1d,
    0x0,
    0x4,
    0x4,
    0x3,
    0x1,
    0x0,
    0x14,
    0x0,
    0x1,
    0x8,
    0x13,
    0x21,
    0x16,
    0x4,
    0x0,
    0x0,
    0x0,
    0xb,
    0x5,
    0x0,
    0xd,
    0x7,
    0x0,
    0x0,
    0x7,
    0x0,
    0x0,
    0x1,
    0x2,
    0xf,
    0xa,
    0x1,
    0x10,
    0x1,
    0x4,
    0x9,
    0x0,
    0x6,
    0x10,
    0x11,
    0x2,
    0x6,
    0x4,
    0xf,
    0x1,
    0xa,
    0x15,
    0x0,
    0x2,
    0xb,
    0x0,
    0x2,
    0x0,
    0x1,
    0xe,
    0x19,
    0x5,
    0x8,
    0x0,
    0x2,
    0x6,
    0xd,
    0xa,
    0x9,
    0x7,
    0x3,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x1,
    0x0,
    0x2,
    0xa,
    0x0,
    0x1,
    0x0,
    0x2,
    0x1,
    0x2,
    0x0,
    0x0,
    0x0,
    0x7,
    0x3,
    0x0,
    0x0,
    0x4,
    0x5,
    0x0,
    0xb,
    0x1,
    0x0,
    0x3,
    0x3,
    0xa,
    0x0,
    0x2,
    0x1,
    0x1,
    0x0,
    0x6,
    0x6,
    0x1,
    0xc,
    0x3,
    0x0,
    0x3,
    0x0,
    0x9,
    0x1,
    0x5,
    0x2,
    0x3,
    0xf,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x3,
    0x3,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x9,
    0x0,
    0x0,
    0x5,
    0x2,
    0x4,
    0x2,
    0x1,
    0x0,
    0x3,
    0x2,
    0x0,
    0x4,
    0x0,
    0x18,
    0x2,
    0x1,
    0x0,
    0x1,
    0x6,
    0x3,
    0x10,
    0x8,
    0x4,
    0x0,
    0x5,
    0x13,
    0x1,
    0x5,
    0x2,
    0x2,
    0x1,
    0x2,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x6,
    0x0,
    0x0,
    0x0,
    0x14,
    0x7,
    0x0,
    0x3,
    0x0,
    0x2,
    0x1,
    0x0,
    0x2,
    0x3,
    0x2,
    0x0,
    0x4,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x3,
    0x0,
    0x1,
    0x2,
    0x1,
    0x4,
    0x0,
    0x3,
    0x0,
    0x0,
    0x1,
    0x0,
    0x4,
    0x0,
    0x0,
    0x1,
    0x1,
    0xa,
    0x9,
    0x0,
    0x0,
    0x5,
    0x13,
    0x1,
    0x1,
    0x0,
    0xc,
    0x4,
    0xb,
    0x1,
    0x0,
    0x8,
    0x1,
    0x2,
    0x8,
    0x3,
    0x0,
    0x8,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x4,
    0x4,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x2,
    0x2,
    0xe,
    0x2,
    0x1,
    0x1,
    0x4,
    0x0,
    0x7,
    0x0,
    0x0,
    0x3,
    0x1,
    0x0,
    0x2,
    0x2,
    0x1,
    0x0,
    0x3,
    0x3,
    0x0,
    0x3,
    0x3,
    0x0,
    0x0,
    0x0,
    0x6,
    0x1,
    0x0,
    0x7,
    0x3,
    0x1,
    0x5,
    0x1,
    0x0,
    0xc,
    0x1,
    0x0,
    0x0,
    0x1,
    0x1,
    0x2,
    0xf,
    0x1,
    0x0,
    0xa,
    0x2,
    0x2,
    0xc,
    0x2,
    0x3,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x0,
    0x9,
    0x7,
    0x0,
    0x1,
    0x2,
    0x0,
    0x1,
    0x7,
    0x0,
    0x6,
    0x0,
    0x0,
    0x5,
    0x0,
    0x9,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x3,
    0x1,
    0x2,
    0x6,
    0x0,
    0x7,
    0x1,
    0x3,
    0x0,
    0x5,
    0x1,
    0x1,
    0x1,
    0x0,
    0x2,
    0x1,
    0x2,
    0x3,
    0x0,
    0x4,
    0x0,
    0x5,
    0x2,
    0x2,
    0x2,
    0x0,
    0x1,
    0x1,
    0x1,
    0x3,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x5,
    0x2,
    0x0,
    0x0,
    0x3,
    0x2,
    0x0,
    0x0,
    0x2,
    0x0,
    0x3,
    0x1,
    0x3,
    0x4,
    0x1,
    0x4,
    0x1,
    0x0,
    0x5,
    0x2,
    0x0,
    0x2,
    0x2,
    0x0,
    0x1,
    0x0,
    0x4,
    0x1,
    0x7,
    0x4,
    0x4,
    0x2,
    0x0,
    0x0,
    0x1,
    0x4,
    0x0,
    0x1,
    0x0,
    0x1,
    0x0,
    0x5,
    0x1,
    0x2,
    0x0,
    0x1,
    0x1,
    0x2,
    0x7,
    0x2,
    0x1,
    0x3,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x8,
    0x3,
    0x2,
    0x8,
    0x3,
    0x3,
    0x1,
    0x3,
    0x1,
    0x0,
    0x1,
    0x0,
    0x3,
    0x8,
    0x5,
    0x3,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x2,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x9,
    0x0,
    0x0,
    0x0,
    0x2,
    0x2,
    0x4,
    0x1,
    0x1,
    0x0,
    0x0,
    0x8,
    0x2,
    0x1,
    0x1,
    0x7,
    0x4,
    0x0,
    0x3,
    0x1,
    0x5,
    0x0,
    0x1,
    0x0,
    0x1,
    0x4,
    0x4,
    0x1,
    0x1,
    0x0,
    0x1,
    0x4,
    0x4,
    0xb,
    0x0,
    0x2,
    0x2,
    0x1,
    0x2,
    0x5,
    0x3,
    0x3,
    0x0,
    0x0,
    0x2,
    0x4,
    0x3,
    0x0,
    0xa,
    0x0,
    0x3,
    0x0,
    0x4,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x1,
    0x1,
    0x0,
    0x1,
    0x0,
    0x3,
    0x2,
    0x0,
    0x0,
    0x2,
    0x0,
    0x3,
    0x0,
    0x1,
    0x1,
    0x4,
    0x1,
    0x0,
    0x5,
    0x0,
    0x2,
    0x1,
    0x1,
    0x2,
    0x1,
    0x1,
    0x1,
    0x2,
    0x0,
    0x1,
    0x1,
    0x2,
    0x2,
    0x2,
    0x1,
    0x3,
    0x8,
    0x0,
    0x0,
    0x4,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x2,
    0x4,
    0x0,
    0x3,
    0x0,
    0x1,
    0x1,
    0x1,
    0x2,
    0x0,
    0x5,
    0x0,
    0x0,
    0x1,
    0x1,
    0x3,
    0x2,
    0x9,
    0x0,
    0x4,
    0x3,
    0x1,
    0x1,
    0x0,
    0x1,
    0x1,
    0x3,
    0x1,
    0x3,
    0x5,
    0x0,
    0x1,
    0x2,
    0x5,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x2,
    0x0,
];
pub(crate) const CANONICAL_COMBINING_CLASS_KV: &[u32] = &[
    0x34AE6,
    0x348DC,
    0xFE24E6,
    0x2DEBE6,
    0xA67CE6,
    0xE496B,
    0x593E6,
    0x102E0DC,
    0x20E7E6,
    0xFE26E6,
    0xA8EDE6,
    0x342E6,
    0x6EADC,
    0xA6F0E6,
    0x1D243E6,
    0xA8EBE6,
    0xEB876,
    0x1AB8DC,
    0x1AB0E6,
    0x1BAA09,
    0xFE2DDC,
    0x322CA,
    0x1144607,
    0x1D170D8,
    0x1DD5E6,
    0x1CE301,
    0xF7484,
    0x1B6DE6,
    0x59ADE,
    0x30DE6,
    0x305E6,
    0x65DE6,
    0x5B812,
    0xFE2BDC,
    0x1123607,
    0x302EE0,
    0x749E6,
    0x1A75E6,
    0x111C009,
    0x1E02AE6,
    0x6E8E6,
    0x108DDC,
    0x1DECE6,
    0x351E6,
    0x954E6,
    0x2DE9E6,
    0x8FDE6,
    0xECA7A,
    0x1136CE6,
    0x1AB9DC,
    0x1DC3E6,
    0x1D1ADE6,
    0xA8EAE6,
    0x5ADDE,
    0x825E6,
    0xAABEE6,
    0x11102E6,
    0xA8E9E6,
    0x8E3DC,
    0x2DE4E6,
    0x315E8,
    0x111CA07,
    0x1CD7DC,
    0x1E8D3DC,
    0x10A3ADC,
    0x6E1E6,
    0x6E4E6,
    0x358E8,
    0x487E6,
    0x35DEA,
    0x65020,
    0xA8EEE6,
    0x1DE5E6,
    0x5B711,
    0x819E6,
    0x16B30E6,
    0x16AF301,
    0x9BC07,
    0x1DDAE6,
    0x35FE9,
    0xE4B6B,
    0x744DC,
    0x327CA,
    0x5B40E,
    0x1DF4E6,
    0x331DC,
    0x612E6,
    0x1D1AAE6,
    0x1E00DE6,
    0xF7B82,
    0x1B6EE6,
    0x1DF1E6,
    0x1D16FD8,
    0xF7181,
    0x1D16801,
    0x1E8D6DC,
    0x367E6,
    0x36DE6,
    0x1CE0E6,
    0x6D8E6,
    0x1CDAE6,
    0x32FDC,
    0x5C712,
    0xC4D09,
    0x598E6,
    0x81FE6,
    0x10AE6DC,
    0x2DFFE6,
    0x5A5DC,
    0x1DE1E6,
    0x316DC,
    0x2DE1E6,
    0x1E945E6,
    0xF18DC,
    0x743E6,
    0xD4D09,
    0x2DF0E6,
    0x18A9E4,
    0x17D209,
    0xA8E6E6,
    0x6DCE6,
    0x1DE3E6,
    0x302ADA,
    0x300E6,
    0xF35DC,
    0x30BE6,
    0x33EE6,
    0x73AE6,
    0x1CF8E6,
    0xF8409,
    0x317DC,
    0x483E6,
    0x85ADC,
    0x5AFE6,
    0x115C007,
    0x307E6,
    0x1CDDDC,
    0x319DC,
    0x6DFE6,
    0x1DE4E6,
    0x952DC,
    0x1E009E6,
    0x345F0,
    0xA69FE6,
    0x1E017E6,
    0x1E8D5DC,
    0x1DD1E6,
    0xA67DE6,
    0x1D17EDC,
    0x1136AE6,
    0xA8E4E6,
    0x8FBE6,
    0x5B20C,
    0x333DC,
    0x36EE6,
    0x31AE8,
    0x1E949E6,
    0x5BF17,
    0x8FCE6,
    0x309E6,
    0x35BE6,
    0x485E6,
    0xF86E6,
    0x2DF8E6,
    0x364E6,
    0x1104609,
    0x5B00A,
    0x1144209,
    0xFE2CDC,
    0x31DDC,
    0x93C07,
    0x73FE6,
    0x6ECE6,
    0xA8E2E6,
    0x343E6,
    0x1E002E6,
    0xFE25E6,
    0x67023,
    0x8DFE6,
    0x5AADC,
    0x658E6,
    0x2DE6E6,
    0x6E0E6,
    0x1113409,
    0x1DC9E6,
    0x1DC6E6,
    0x1AB4E6,
    0x135EE6,
    0x1172B09,
    0x1D17BDC,
    0x739DC,
    0x10AE5E6,
    0x1136BE6,
    0x308E6,
    0x823E6,
    0x313E6,
    0x8E0E6,
    0x355DC,
    0x353DC,
    0x1D166D8,
    0x733E6,
    0x1B72E6,
    0x1CDEDC,
    0x1E012E6,
    0x2DF7E6,
    0x951E6,
    0xABC07,
    0x8D8E6,
    0x1E024E6,
    0x20D901,
    0x1E948E6,
    0x321CA,
    0x1E011E6,
    0x1DE8E6,
    0x35EEA,
    0x20E8DC,
    0x16AF401,
    0x1D189E6,
    0x1E946E6,
    0x20DCE6,
    0xF83E6,
    0x2DF4E6,
    0x6EDDC,
    0xFE29DC,
    0x31EDC,
    0x1DFCE9,
    0x64D1D,
    0x344E6,
    0x352E6,
    0x732E6,
    0x1D186E6,
    0x1CD401,
    0x309A08,
    0x81DE6,
    0x11368E6,
    0x8E7E6,
    0x1DDEE6,
    0xA9B307,
    0x596DC,
    0x347DC,
    0x659E6,
    0xA3C07,
    0x5C219,
    0x2CEFE6,
    0x8F7E6,
    0x65CDC,
    0x32CDC,
    0x1B6BE6,
    0x33FE6,
    0x1AB7DC,
    0x1ABBE6,
    0x616E6,
    0xB3C07,
    0x59DE6,
    0x1E947E6,
    0x1AB1E6,
    0x73BDC,
    0xFE23E6,
    0x65AE6,
    0x2DE2E6,
    0xAAB7E6,
    0x8D7E6,
    0x610E6,
    0x33501,
    0x2DEEE6,
    0xA80609,
    0x73DE6,
    0x5A2DC,
    0xFE2FE6,
    0x1DC7E6,
    0x6E7E6,
    0x595E6,
    0x1DDDE6,
    0xA8F0E6,
    0x2DF1E6,
    0x36BE6,
    0x11372E6,
    0x16AF201,
    0x1DFDDC,
    0xAAB0E6,
    0x1DEFE6,
    0x1ABADC,
    0x7EDE6,
    0x103A09,
    0x346E6,
    0x1E000E6,
    0x656DC,
    0x361EA,
    0x1A78E6,
    0x5BC15,
    0x1E006E6,
    0x1DFEE6,
    0x1DCCE6,
    0x310E6,
    0x1DE7E6,
    0x1DC8E6,
    0x103909,
    0x1BE607,
    0x731DC,
    0x312E6,
    0x829E6,
    0x5C118,
    0x32ADC,
    0x1E026E6,
    0x1A76E6,
    0x8E1E6,
    0x1E01EE6,
    0x1DEDE6,
    0xA8E3E6,
    0x1B73E6,
    0x359DC,
    0xFE21E6,
    0x1E028E6,
    0xA6F1E6,
    0x1ABCE6,
    0x73CDC,
    0x11374E6,
    0x5ACE6,
    0x20EFDC,
    0x1CF4E6,
    0x332DC,
    0xFE2ADC,
    0x326DC,
    0x818E6,
    0x1DDCE6,
    0x59BDC,
    0x16B32E6,
    0x34DDC,
    0x31BD8,
    0xA677E6,
    0x1E003E6,
    0xDCA09,
    0x5A7DC,
    0x1DCDEA,
    0x1DFFDC,
    0x36AE6,
    0x30FE6,
    0x2DE5E6,
    0x33801,
    0x135DE6,
    0x193AE6,
    0xE3967,
    0xCCD09,
    0x1DD3E6,
    0x2DE3E6,
    0x33601,
    0x11371E6,
    0x20DBE6,
    0x657E6,
    0x311E6,
    0xFC6DC,
    0x20D301,
    0x65FDC,
    0x1E014E6,
    0x65BE6,
    0x2DFEE6,
    0x16B33E6,
    0x1CE401,
    0x304E6,
    0x8F21D,
    0x16AF101,
    0x1D188E6,
    0x1E01BE6,
    0x10A38E6,
    0x1CD5DC,
    0x730E6,
    0xEC87A,
    0x306E6,
    0x2DE0E6,
    0x61A20,
    0x5A1E6,
    0x82DE6,
    0x1D172D8,
    0x34EDC,
    0x745E6,
    0xA8E0E6,
    0x654E6,
    0x2DFAE6,
    0x11100E6,
    0x33DE6,
    0x1DC2DC,
    0x615E6,
    0x1CEDDC,
    0x1A17E6,
    0x1CE801,
    0x6EBE6,
    0xFE20E6,
    0x735E6,
    0x1E027E6,
    0x1DCFDC,
    0x1DF5E6,
    0x7F0E6,
    0x8EEDC,
    0x484E6,
    0x318DC,
    0x1E8D0DC,
    0x5A6DC,
    0x32EDC,
    0x748DC,
    0x591DC,
    0x737DC,
    0xAAC1E6,
    0x1E00AE6,
    0x1B3407,
    0x6D6E6,
    0xA679E6,
    0x8DDE6,
    0xF87E6,
    0x2CF1E6,
    0x1DD0CA,
    0x2DF2E6,
    0x1AB2E6,
    0x30CE6,
    0x1D180DC,
    0x365E6,
    0x323DC,
    0x1D16ED8,
    0x7F1E6,
    0x8F6DC,
    0xABED09,
    0xC5554,
    0xA8EFE6,
    0x1A7AE6,
    0x11C3F09,
    0x592E6,
    0x8E9DC,
    0x354DC,
    0x5B610,
    0x1CD1E6,
    0x1D1ACE6,
    0x1E01FE6,
    0x1DFBE6,
    0x116B707,
    0x357E6,
    0x1D1ABE6,
    0x366E6,
    0x5B50F,
    0xAAB4DC,
    0x20E501,
    0xA66FE6,
    0x340E6,
    0x171409,
    0x816E6,
    0x8FFE6,
    0x1D17CDC,
    0x826E6,
    0x1CDFDC,
    0x2DFBE6,
    0x329DC,
    0x362E9,
    0x302DDE,
    0x820E6,
    0x1E00FE6,
    0x1D16701,
    0x1A6009,
    0x11101E6,
    0x135FE6,
    0x1B6FE6,
    0x1B71E6,
    0xF7282,
    0x599E6,
    0x2DFDE6,
    0x1E018E6,
    0x655DC,
    0xA67BE6,
    0x114C307,
    0x2DE8E6,
    0x11366E6,
    0x1037AE6,
    0x736E6,
    0xFE27DC,
    0x20D1E6,
    0x8DAE6,
    0x114C209,
    0x1E01DE6,
    0xA95309,
    0x64E1E,
    0x2D7F09,
    0x1CDBE6,
    0x350E6,
    0x8F8E6,
    0xA676E6,
    0x16AF001,
    0x20D6E6,
    0x1113309,
    0x1D181DC,
    0x5B913,
    0x59EE6,
    0x115BF09,
    0x5A0E6,
    0x65222,
    0x1E020E6,
    0xF82E6,
    0x302E6,
    0x2DEDE6,
    0x6E2E6,
    0x110B909,
    0x2CF0E6,
    0x1E004E6,
    0x1CF9E6,
    0x65EE6,
    0x1E8D2DC,
    0x35ADC,
    0xA8E7E6,
    0x5C5DC,
    0xF39D8,
    0xF8082,
    0x1E944E6,
    0xA8E1E6,
    0x1DCBE6,
    0x8ECE6,
    0x1D165D8,
    0x1DD7E6,
    0xB4D09,
    0x7F3E6,
    0x314E6,
    0x827E6,
    0x33401,
    0x1CD2E6,
    0x368E6,
    0x8DBE6,
    0xA4D09,
    0x363E6,
    0xF19DC,
    0x6DAE6,
    0x324DC,
    0x81BE6,
    0x193BDC,
    0x36FE6,
    0x1DF3E6,
    0x64C1C,
    0xF37DC,
    0x1DC1E6,
    0x1D171D8,
    0x1163F09,
    0x1117307,
    0x8EFDC,
    0x1D244E6,
    0x33BDC,
    0x486E6,
    0xE486B,
    0x17DDE6,
    0x1E015E6,
    0x71124,
    0x1DE6E6,
    0x8E4E6,
    0x82CE6,
    0x613E6,
    0x5A3DC,
    0xF7D82,
    0xE4A6B,
    0x822E6,
    0x349DC,
    0x1A7BE6,
    0xF7A82,
    0x59FE6,
    0x1DEAE6,
    0x1DF0E6,
    0x1AB3E6,
    0xA8C409,
    0x302BE4,
    0x5B10B,
    0x2DF3E6,
    0x8DCE6,
    0xAAB2E6,
    0x2DE7E6,
    0x65121,
    0x1DE0E6,
    0xA8E5E6,
    0x1CE601,
    0x64B1B,
    0x16B36E6,
    0x7EFE6,
    0x10A0FE6,
    0xE3A09,
    0x746DC,
    0x1E016E6,
    0x31CDC,
    0x8FADC,
    0x1DD8E6,
    0x2DF6E6,
    0x20EEDC,
    0x653E6,
    0x1BC9E01,
    0x5BA13,
    0xE3867,
    0x5AEE4,
    0x1D16DE2,
    0xA92BDC,
    0x1E029E6,
    0x33701,
    0x1B6CDC,
    0x1E001E6,
    0x1DC4E6,
    0x1DD6E6,
    0x742DC,
    0x2DEAE6,
    0x173409,
    0x1CD8DC,
    0x20E9E6,
    0x11367E6,
    0x859DC,
    0x1E00EE6,
    0x20D7E6,
    0x1DEBE6,
    0x8EAE6,
    0xF7C82,
    0x1E010E6,
    0x1DEEE6,
    0x5A8E6,
    0x741E6,
    0xA675E6,
    0x1B70E6,
    0xA92DDC,
    0xA8ECE6,
    0x1E008E6,
    0x16B34E6,
    0x30AE6,
    0x20EDDC,
    0xC565B,
    0x1D242E6,
    0x1E023E6,
    0x1D187E6,
    0x5BB14,
    0x20D201,
    0x73EDC,
    0x1E005E6,
    0x339DC,
    0xA67AE6,
    0x81CE6,
    0x8FEE6,
    0x1E01CE6,
    0x1D18ADC,
    0x20EB01,
    0xAAF609,
    0x2DF5E6,
    0x64F1F,
    0x1DC0E6,
    0x302CE8,
    0x116B609,
    0x35CE9,
    0x1BF209,
    0x330DC,
    0x1AB5DC,
    0x1BAB09,
    0x8DEE6,
    0x32DDC,
    0x6181E,
    0x36CE6,
    0x112EA09,
    0x10378E6,
    0x1CD6DC,
    0x1A77E6,
    0x6191F,
    0x1B4409,
    0x7EEE6,
    0xA8E8E6,
    0x20F0E6,
    0x8D4E6,
    0x5B30D,
    0x1134D09,
    0x303E6,
    0x360EA,
    0x747E6,
    0x1DE2E6,
    0x11370E6,
    0x20EA01,
    0x1E013E6,
    0x328CA,
    0xAAB3E6,
    0x16B35E6,
    0x1107F09,
    0x738DC,
    0x112E907,
    0x10A3901,
    0x1A7FDC,
    0x1D17FDC,
    0x10A3F09,
    0x5C4E6,
    0x8EDDC,
    0x34BE6,
    0x11373E6,
    0x34CE6,
    0x617E6,
    0x8EBE6,
    0x31FDC,
    0xEB976,
    0x7EBE6,
    0x82AE6,
    0x74AE6,
    0x33CDC,
    0x1CE701,
    0x1D182DC,
    0x16B31E6,
    0x1DF2E6,
    0x94D09,
    0x821E6,
    0x1E00CE6,
    0x5A4DC,
    0x8F4E6,
    0x1DCED6,
    0x1D185E6,
    0x1DE9E6,
    0x2DECE6,
    0xCBC07,
    0x1DD4E6,
    0x2DF9E6,
    0x1D16901,
    0x369E6,
    0xEC97A,
    0x1123509,
    0x953E6,
    0xA678E6,
    0x1CE501,
    0xAAB8E6,
    0x10A0DDC,
    0x6E3DC,
    0x1BF309,
    0x8F11C,
    0x1A79E6,
    0x309908,
    0x614E6,
    0xFE2EE6,
    0x10379E6,
    0x11369E6,
    0x101FDDC,
    0x1DDBE6,
    0x302FE0,
    0x1939DE,
    0x20D801,
    0x2DFCE6,
    0xFE22E6,
    0x20E601,
    0x817E6,
    0x1E021E6,
    0xACD09,
    0x320DC,
    0x1DD2E6,
    0x356DC,
    0x341E6,
    0xFE28DC,
    0x20D5E6,
    0x20E1E6,
    0x7ECE6,
    0x301E6,
    0x1ABDDC,
    0x10377E6,
    0x594E6,
    0x8F5E6,
    0x7F2DC,
    0x8F9DC,
    0x1DC5E6,
    0xA8F1E6,
    0x5A9E6,
    0x8F3E6,
    0x1E00BE6,
    0x6D7E6,
    0x6D9E6,
    0x6DBE6,
    0x1CD9DC,
    0x1CE201,
    0x1E8D1DC,
    0x8D6E6,
    0x1CD0E6,
    0x81EE6,
    0x597E6,
    0x59CE6,
    0x1C3707,
    0x20D0E6,
    0x33ADC,
    0x82BE6,
    0x611E6,
    0x1A18DC,
    0xFB1E1A,
    0x8D9E6,
    0xA9C009,
    0xA92CDC,
    0x8E8E6,
    0x1133C07,
    0x740E6,
    0x10376E6,
    0x2DEFE6,
    0x325DC,
    0x1DDFE6,
    0x5ABE6,
    0xAABFE6,
    0x8E6DC,
    0x1D18BDC,
    0x8D5E6,
    0x1CDCDC,
    0x110BA07,
    0xECB7A,
    0xA674E6,
    0x20D4E6,
    0x1DD9E6,
    0x20DA01,
    0x1DCADC,
    0x103707,
    0xA69EE6,
    0x8E5E6,
    0xBCD09,
    0x20ECDC,
    0x30EE6,
    0x1E8D4DC,
    0x8F01B,
    0x734DC,
    0x1AB6DC,
    0x32BDC,
    0x1D17DDC,
    0x9CD09,
    0x5BD16,
    0x1A7CE6,
    0x85BDC,
    0x1E94A07,
];


pub(crate) const COMPOSITION_TABLE_SALT: &[u16] = &[
    0x0,
    0x0,
    0x0,
    0x0,
    0x25d,
    0x3,
    0x5d,
    0x0,
    0x2,
    0x9,
    0x4,
    0x87,
    0x6,
    0x135,
    0x1,
    0x0,
    0x0,
    0x4,
    0x3,
    0xe1,
    0x78,
    0x0,
    0x2,
    0x29,
    0x8,
    0x8f,
    0x24,
    0x0,
    0x0,
    0x0,
    0x31,
    0x0,
    0x0,
    0x6d,
    0x0,
    0x33,
    0x1,
    0x4c,
    0x0,
    0x1,
    0x0,
    0x0,
    0x8,
    0x7c,
    0x6,
    0x4c,
    0x45,
    0x2a,
    0x2,
    0x0,
    0x0,
    0x0,
    0xa,
    0x0,
    0x0,
    0x59,
    0x0,
    0x10,
    0x3,
    0x9,
    0xe,
    0x6,
    0x1,
    0xc,
    0x10,
    0x0,
    0x0,
    0x0,
    0x3d,
    0x0,
    0x0,
    0x2a,
    0x0,
    0x0,
    0x1,
    0x20,
    0xa,
    0x0,
    0x1,
    0xe,
    0x2,
    0x10,
    0x22,
    0x0,
    0x61,
    0x0,
    0x4,
    0x15,
    0x0,
    0x4,
    0x3,
    0x0,
    0x0,
    0x3,
    0x0,
    0xd,
    0x1,
    0x1,
    0x24,
    0x3,
    0x4,
    0x0,
    0x0,
    0x18,
    0x58,
    0x0,
    0x0,
    0xa,
    0x19,
    0x10,
    0x0,
    0x2,
    0x0,
    0x0,
    0x12,
    0x15,
    0x0,
    0xc,
    0x7,
    0x3,
    0x0,
    0x1a,
    0x7,
    0xc,
    0x1,
    0x5,
    0x4,
    0x21,
    0x1,
    0x2,
    0x0,
    0x0,
    0x1,
    0xa,
    0x0,
    0xa,
    0x0,
    0x4,
    0x9,
    0x5,
    0xd,
    0x5,
    0x0,
    0x3,
    0x6,
    0x26,
    0xb,
    0x0,
    0x4,
    0x6,
    0x0,
    0x13,
    0x0,
    0x0,
    0x4,
    0x1,
    0x0,
    0x0,
    0x0,
    0x24,
    0x1,
    0x1d,
    0x1,
    0x0,
    0x0,
    0x10,
    0x0,
    0x1,
    0x1,
    0x1,
    0x0,
    0x0,
    0xa,
    0x0,
    0xd,
    0x0,
    0x10,
    0x0,
    0x6,
    0x5,
    0x0,
    0x0,
    0x9,
    0x3,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x1,
    0x2,
    0x0,
    0x0,
    0x16,
    0x1,
    0x2,
    0x0,
    0x1,
    0x0,
    0x6,
    0x1,
    0x25,
    0x5,
    0x0,
    0xa,
    0xd,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x12,
    0x0,
    0x0,
    0x1,
    0x0,
    0x1,
    0x0,
    0x1,
    0x0,
    0x4,
    0x9,
    0x0,
    0x1,
    0x4,
    0x0,
    0x4,
    0x1,
    0x6,
    0xb,
    0x3,
    0x6,
    0x7,
    0x0,
    0x0,
    0x0,
    0xd,
    0xf,
    0xe,
    0x0,
    0x1,
    0x1,
    0x4,
    0xf,
    0x10,
    0x0,
    0x5,
    0x0,
    0x19,
    0x1,
    0xe,
    0x0,
    0x8,
    0x1,
    0x3,
    0x0,
    0x0,
    0x5,
    0x1,
    0x0,
    0x0,
    0x11,
    0x0,
    0x4,
    0x5,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x1,
    0x0,
    0x0,
    0x2,
    0x1,
    0x1,
    0x5,
    0x8,
    0x0,
    0x0,
    0xc,
    0xa,
    0x0,
    0x6,
    0x9,
    0x3,
    0x1,
    0x6,
    0x1,
    0x0,
    0x1b,
    0x1,
    0xe,
    0x0,
    0x8,
    0x5,
    0x3,
    0x15,
    0x0,
    0x2,
    0x7,
    0xb,
    0x3,
    0x0,
    0xa,
    0x3,
    0x0,
    0x6,
    0x0,
    0xa,
    0x0,
    0x1,
    0x3,
    0x8,
    0x0,
    0x9,
    0x0,
    0x1,
    0x2,
    0x0,
    0x5,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x17,
    0x0,
    0x0,
    0x2,
    0x0,
    0x5,
    0x16,
    0x0,
    0x10,
    0x3,
    0x4,
    0x11,
    0x1,
    0x3,
    0x0,
    0x0,
    0x0,
    0x4,
    0x1,
    0x0,
    0x5,
    0x0,
    0x2,
    0x1,
    0x0,
    0x2,
    0x0,
    0x2,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x12,
    0x1,
    0x4,
    0xa,
    0xb,
    0x4,
    0x0,
    0x2,
    0x0,
    0x3,
    0x0,
    0x4,
    0x5,
    0x0,
    0x0,
    0x11,
    0x1,
    0x6,
    0x6,
    0x0,
    0x2,
    0x0,
    0x1,
    0x0,
    0x4,
    0x0,
    0x0,
    0x1,
    0x1,
    0x7,
    0x0,
    0x3,
    0xa,
    0x0,
    0x1,
    0xa,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0xd,
    0x5,
    0x1,
    0x1,
    0x0,
    0x0,
    0x5,
    0x6,
    0x8,
    0x4,
    0x5,
    0x0,
    0xb,
    0x0,
    0x4,
    0xb,
    0x0,
    0x0,
    0x1,
    0x5,
    0x0,
    0xb,
    0x0,
    0x6,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x4,
    0x0,
    0x6,
    0x0,
    0x0,
    0x7,
    0x13,
    0x4,
    0x19,
    0x3,
    0x1,
    0x0,
    0x1,
    0x6,
    0x6,
    0x0,
    0x0,
    0x0,
    0x0,
    0xc,
    0x2,
    0x3,
    0x0,
    0x4,
    0x0,
    0x1,
    0x0,
    0x1,
    0x5,
    0x1,
    0x1,
    0x2,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x9,
    0x0,
    0x0,
    0x7,
    0x1,
    0x9,
    0x6,
    0x4,
    0x1,
    0x5,
    0x0,
    0x1,
    0x2,
    0x8,
    0x0,
    0x9,
    0x0,
    0x0,
    0x1,
    0x3,
    0xb,
    0x0,
    0x1,
    0x0,
    0x0,
    0x5,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x2,
    0x1,
    0x2,
    0x0,
    0x0,
    0x0,
    0x4,
    0x1,
    0x0,
    0x6,
    0x2,
    0x5,
    0x8,
    0x12,
    0x0,
    0x0,
    0x0,
    0x3,
    0x1,
    0x0,
    0x0,
    0x0,
    0x2,
    0x3,
    0x3,
    0x0,
    0x0,
    0x1,
    0x0,
    0x1,
    0x0,
    0x3,
    0x0,
    0x0,
    0x2,
    0x1,
    0x4,
    0xd,
    0x0,
    0x0,
    0xb,
    0x0,
    0x1,
    0x0,
    0x0,
    0xc,
    0x0,
    0x0,
    0x0,
    0x5,
    0x8,
    0x2,
    0x0,
    0x2,
    0x1,
    0x6,
    0x1,
    0x1,
    0x1,
    0x0,
    0x2,
    0x0,
    0x5,
    0x1,
    0x1,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0xe,
    0x10,
    0x0,
    0x5,
    0x4,
    0x2,
    0x1,
    0x0,
    0x0,
    0x3,
    0x1,
    0x0,
    0x2,
    0x1,
    0x4,
    0x0,
    0x0,
    0x3,
    0x0,
    0x1,
    0x1,
    0x3,
    0x1,
    0x5,
    0x2,
    0x3,
    0x4,
    0x0,
    0x3,
    0x3,
    0x6,
    0x0,
    0x0,
    0x1,
    0x0,
    0x2,
    0xe,
    0x1,
    0x2,
    0x1,
    0x4,
    0x2,
    0x5,
    0x2,
    0x1,
    0x1,
    0x0,
    0x1,
    0x0,
    0x5,
    0x5,
    0x6,
    0x6,
    0x5,
    0x0,
    0x2,
    0x1,
    0x0,
    0x2,
    0x4,
    0x1,
    0x0,
    0x5,
    0x0,
    0x6,
    0x2,
    0x8,
    0x0,
    0x0,
    0x7,
    0x1,
    0x2,
    0x2,
    0x5,
    0x4,
    0x11,
    0x0,
    0x3,
    0x0,
    0x1,
    0x0,
    0x1,
    0x4,
    0x0,
    0x3,
    0x2,
    0x0,
    0x1,
    0x3,
    0x0,
    0xb,
    0x6,
    0x0,
    0x6,
    0x0,
    0x4,
    0x1,
    0x2,
    0x0,
    0x1,
    0x0,
    0x2,
    0x1,
    0x2,
    0x0,
    0x5,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x3,
    0x2,
    0x6,
    0x0,
    0x0,
    0x2,
    0x4,
    0x6,
    0x0,
    0x0,
    0x0,
    0x0,
    0xc,
    0xc,
    0x0,
    0x0,
    0x0,
    0x4,
    0x4,
    0x0,
    0x8,
    0x3,
    0x1,
    0x0,
    0x1,
    0x0,
    0x3,
    0x0,
    0x0,
    0x5,
    0x0,
    0x5,
    0x1,
    0x0,
    0x3,
    0x4,
    0x1,
    0x2,
    0x3,
    0x0,
    0x1,
    0x7,
    0x0,
    0x0,
    0x7,
    0x0,
    0x2,
    0x2,
    0x0,
    0x0,
    0x1,
    0x1,
    0x1,
    0x1,
    0xb,
    0x0,
    0x4,
    0x0,
    0x1,
    0x1,
    0x0,
    0x2,
    0x1,
    0x1,
    0x5,
    0x0,
    0x0,
    0x3,
    0x6,
    0x0,
    0x0,
    0x4,
    0x2,
    0x1,
    0x3,
    0x3,
    0xa,
    0x7,
    0x0,
    0x4,
    0x1,
    0x6,
    0x0,
    0x1,
    0x0,
    0x0,
    0x2,
    0x1,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x1,
    0x1,
    0x1,
    0x4,
    0x0,
    0x3,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x0,
    0x1,
    0x0,
    0x4,
    0x0,
    0x1,
    0x0,
    0x6,
    0x0,
    0x1,
    0x0,
    0x4,
    0x0,
    0x1,
    0x2,
    0x6,
    0x0,
    0x2,
    0x0,
    0x3,
    0x7,
    0x0,
    0x3,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x3,
    0x5,
    0x2,
    0x0,
    0x1,
    0x1,
    0x2,
    0x2,
    0x4,
    0x1,
    0x0,
    0x0,
    0x1,
    0x0,
    0x3,
    0x2,
    0x0,
    0x1,
    0x0,
    0x2,
    0x4,
    0x2,
    0x0,
    0x1,
    0x5,
    0x0,
    0x0,
    0x2,
    0x1,
    0x1,
    0x0,
    0x0,
    0x1,
    0x0,
    0x5,
    0x2,
    0x0,
    0x8,
    0x3,
    0x1,
    0x1,
    0x1,
    0x3,
    0x4,
    0x0,
    0x2,
    0x0,
    0x1,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x6,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x0,
    0x2,
    0x2,
    0x0,
    0x1,
    0x3,
    0x1,
    0x3,
    0x1,
    0x2,
    0x0,
    0x1,
    0x2,
    0x0,
    0x0,
    0x1,
    0x0,
    0x3,
    0x1,
    0x2,
    0x0,
    0x2,
    0x1,
    0x0,
    0x2,
    0x4,
    0x0,
    0x5,
    0x5,
    0x0,
    0x5,
    0x2,
    0x0,
    0x1,
    0x3,
    0x1,
    0x0,
    0x2,
    0x6,
    0x2,
    0x1,
    0x0,
    0x0,
    0x0,
    0x3,
];
pub(crate) const COMPOSITION_TABLE_KV: &[(u32, char)] = &[
    (0x64A0654, '\u{0626}'),
    (0x690309, '\u{1EC9}'),
    (0x650306, '\u{0115}'),
    (0x423030B, '\u{04F2}'),
    (0x47030C, '\u{01E6}'),
    (0x570301, '\u{1E82}'),
    (0xC50301, '\u{01FA}'),
    (0x21D20338, '\u{21CF}'),
    (0x430307, '\u{010A}'),
    (0x7A0307, '\u{017C}'),
    (0x49030C, '\u{01CF}'),
    (0x720307, '\u{1E59}'),
    (0x304B3099, '\u{304C}'),
    (0x1F610345, '\u{1FA1}'),
    (0x410307, '\u{0226}'),
    (0x6B0323, '\u{1E33}'),
    (0x3990304, '\u{1FD9}'),
    (0x1F490301, '\u{1F4D}'),
    (0x3CA0342, '\u{1FD7}'),
    (0x550304, '\u{016A}'),
    (0x30DB309A, '\u{30DD}'),
    (0x1F6E0345, '\u{1FAE}'),
    (0x420331, '\u{1E06}'),
    (0x41E0308, '\u{04E6}'),
    (0x410325, '\u{1E00}'),
    (0x520331, '\u{1E5E}'),
    (0x1FF60345, '\u{1FF7}'),
    (0x22720338, '\u{2274}'),
    (0x22480338, '\u{2249}'),
    (0x1FBF0301, '\u{1FCE}'),
    (0x30C63099, '\u{30C7}'),
    (0x760323, '\u{1E7F}'),
    (0x700307, '\u{1E57}'),
    (0x1F510301, '\u{1F55}'),
    (0x750328, '\u{0173}'),
    (0x305B3099, '\u{305C}'),
    (0x41030A, '\u{00C5}'),
    (0x1A10323, '\u{1EE3}'),
    (0x550311, '\u{0216}'),
    (0x530307, '\u{1E60}'),
    (0xDC030C, '\u{01D9}'),
    (0x4F0300, '\u{00D2}'),
    (0x6F0307, '\u{022F}'),
    (0x470301, '\u{01F4}'),
    (0x610309, '\u{1EA3}'),
    (0x1F080301, '\u{1F0C}'),
    (0x3B90301, '\u{03AF}'),
    (0x4330301, '\u{0453}'),
    (0x1F200345, '\u{1F90}'),
    (0x620307, '\u{1E03}'),
    (0x1F030345, '\u{1F83}'),
    (0x570308, '\u{1E84}'),
    (0x5A0307, '\u{017B}'),
    (0x30C13099, '\u{30C2}'),
    (0x1A10309, '\u{1EDF}'),
    (0x6270655, '\u{0625}'),
    (0x3BF0314, '\u{1F41}'),
    (0x670301, '\u{01F5}'),
    (0x39F0301, '\u{038C}'),
    (0xEA0301, '\u{1EBF}'),
    (0x63030C, '\u{010D}'),
    (0x1F000345, '\u{1F80}'),
    (0x4130301, '\u{0403}'),
    (0x4B0323, '\u{1E32}'),
    (0x790301, '\u{00FD}'),
    (0x770301, '\u{1E83}'),
    (0x1F0E0345, '\u{1F8E}'),
    (0x480308, '\u{1E26}'),
    (0x30A63099, '\u{30F4}'),
    (0x1020300, '\u{1EB0}'),
    (0x6C0301, '\u{013A}'),
    (0x450309, '\u{1EBA}'),
    (0x1F390301, '\u{1F3D}'),
    (0x690311, '\u{020B}'),
    (0x4230304, '\u{04EE}'),
    (0x61030C, '\u{01CE}'),
    (0x1F100300, '\u{1F12}'),
    (0x4380300, '\u{045D}'),
    (0x480323, '\u{1E24}'),
    (0x1B111B35, '\u{1B12}'),
    (0x430301, '\u{0106}'),
    (0x540323, '\u{1E6C}'),
    (0x490303, '\u{0128}'),
    (0x1EA10302, '\u{1EAD}'),
    (0x4350308, '\u{0451}'),
    (0x610307, '\u{0227}'),
    (0x1F000300, '\u{1F02}'),
    (0x6D0307, '\u{1E41}'),
    (0x760303, '\u{1E7D}'),
    (0x730327, '\u{015F}'),
    (0x470304, '\u{1E20}'),
    (0x470306, '\u{011E}'),
    (0x1F6D0345, '\u{1FAD}'),
    (0x6F0303, '\u{00F5}'),
    (0x6B0331, '\u{1E35}'),
    (0x720331, '\u{1E5F}'),
    (0x1B00300, '\u{1EEB}'),
    (0x1B0B1B35, '\u{1B0C}'),
    (0x55032D, '\u{1E76}'),
    (0x61030A, '\u{00E5}'),
    (0x30463099, '\u{3094}'),
    (0x1B3A1B35, '\u{1B3B}'),
    (0x55030A, '\u{016E}'),
    (0x928093C, '\u{0929}'),
    (0x3C90313, '\u{1F60}'),
    (0x650330, '\u{1E1B}'),
    (0x590303, '\u{1EF8}'),
    (0x450330, '\u{1E1A}'),
    (0x640331, '\u{1E0F}'),
    (0x3B90308, '\u{03CA}'),
    (0x309D3099, '\u{309E}'),
    (0x443030B, '\u{04F3}'),
    (0xB470B3E, '\u{0B4B}'),
    (0x6F030F, '\u{020D}'),
    (0x6E0323, '\u{1E47}'),
    (0x690308, '\u{00EF}'),
    (0x65032D, '\u{1E19}'),
    (0x15A0307, '\u{1E64}'),
    (0x1F180301, '\u{1F1C}'),
    (0x1F090301, '\u{1F0D}'),
    (0x1F270345, '\u{1F97}'),
    (0x7A0302, '\u{1E91}'),
    (0x590301, '\u{00DD}'),
    (0x4C0331, '\u{1E3A}'),
    (0x1F640345, '\u{1FA4}'),
    (0x1EB90302, '\u{1EC7}'),
    (0x1F240345, '\u{1F94}'),
    (0x1130300, '\u{1E15}'),
    (0x69030F, '\u{0209}'),
    (0x740331, '\u{1E6F}'),
    (0x1F480301, '\u{1F4C}'),
    (0x7A0331, '\u{1E95}'),
    (0x1F290345, '\u{1F99}'),
    (0xD40301, '\u{1ED0}'),
    (0xC40304, '\u{01DE}'),
    (0x3970301, '\u{0389}'),
    (0x72030C, '\u{0159}'),
    (0x1F110301, '\u{1F15}'),
    (0xF40309, '\u{1ED5}'),
    (0x450327, '\u{0228}'),
    (0x6F031B, '\u{01A1}'),
    (0xC60304, '\u{01E2}'),
    (0x3990308, '\u{03AA}'),
    (0x3CE0345, '\u{1FF4}'),
    (0x6D0301, '\u{1E3F}'),
    (0x1030309, '\u{1EB3}'),
    (0x6F0302, '\u{00F4}'),
    (0x73030C, '\u{0161}'),
    (0x750301, '\u{00FA}'),
    (0x1F690301, '\u{1F6D}'),
    (0x3A90301, '\u{038F}'),
    (0x3D0338, '\u{2260}'),
    (0x1FC60345, '\u{1FC7}'),
    (0x770300, '\u{1E81}'),
    (0x2280306, '\u{1E1C}'),
    (0x6C0331, '\u{1E3B}'),
    (0x30AD3099, '\u{30AE}'),
    (0x1EB80302, '\u{1EC6}'),
    (0x550302, '\u{00DB}'),
    (0xDD90DCF, '\u{0DDC}'),
    (0x3A50304, '\u{1FE9}'),
    (0x3A90314, '\u{1F69}'),
    (0x740327, '\u{0163}'),
    (0x530326, '\u{0218}'),
    (0x55030B, '\u{0170}'),
    (0x306F309A, '\u{3071}'),
    (0x6B0327, '\u{0137}'),
    (0x750330, '\u{1E75}'),
    (0x730301, '\u{015B}'),
    (0x1F300342, '\u{1F36}'),
    (0x470307, '\u{0120}'),
    (0xCC60CD5, '\u{0CC7}'),
    (0x1F690300, '\u{1F6B}'),
    (0x1030301, '\u{1EAF}'),
    (0x750311, '\u{0217}'),
    (0x930093C, '\u{0931}'),
    (0x30613099, '\u{3062}'),
    (0x770323, '\u{1E89}'),
    (0xF50301, '\u{1E4D}'),
    (0xFC0300, '\u{01DC}'),
    (0x49030F, '\u{0208}'),
    (0x690302, '\u{00EE}'),
    (0x1F230345, '\u{1F93}'),
    (0xF40300, '\u{1ED3}'),
    (0x44B0308, '\u{04F9}'),
    (0x1F2E0345, '\u{1F9E}'),
    (0x650300, '\u{00E8}'),
    (0x490308, '\u{00CF}'),
    (0x1F280301, '\u{1F2C}'),
    (0x1F180300, '\u{1F1A}'),
    (0x6270653, '\u{0622}'),
    (0x1F200301, '\u{1F24}'),
    (0x22030338, '\u{2204}'),
    (0x790304, '\u{0233}'),
    (0x1F390300, '\u{1F3B}'),
    (0x610325, '\u{1E01}'),
    (0x790309, '\u{1EF7}'),
    (0x1AF0303, '\u{1EEE}'),
    (0x6F0301, '\u{00F3}'),
    (0x640323, '\u{1E0D}'),
    (0x304F3099, '\u{3050}'),
    (0x1F010345, '\u{1F81}'),
    (0xCA0309, '\u{1EC2}'),
    (0x3D20308, '\u{03D4}'),
    (0x1F500301, '\u{1F54}'),
    (0x1F010300, '\u{1F03}'),
    (0x3A90345, '\u{1FFC}'),
    (0x4270308, '\u{04F4}'),
    (0x530302, '\u{015C}'),
    (0x520301, '\u{0154}'),
    (0x450306, '\u{0114}'),
    (0x530323, '\u{1E62}'),
    (0x670306, '\u{011F}'),
    (0x22760338, '\u{2278}'),
    (0x4350300, '\u{0450}'),
    (0x30B53099, '\u{30B6}'),
    (0x6F030B, '\u{0151}'),
    (0x4180304, '\u{04E2}'),
    (0x630307, '\u{010B}'),
    (0x3D20301, '\u{03D3}'),
    (0x227C0338, '\u{22E0}'),
    (0x610304, '\u{0101}'),
    (0xA80300, '\u{1FED}'),
    (0x440331, '\u{1E0E}'),
    (0x650311, '\u{0207}'),
    (0xF80301, '\u{01FF}'),
    (0x75030C, '\u{01D4}'),
    (0x530327, '\u{015E}'),
    (0x30573099, '\u{3058}'),
    (0x3B70345, '\u{1FC3}'),
    (0x69030C, '\u{01D0}'),
    (0x6E0327, '\u{0146}'),
    (0x780307, '\u{1E8B}'),
    (0x1F000342, '\u{1F06}'),
    (0x1B00303, '\u{1EEF}'),
    (0x470327, '\u{0122}'),
    (0xC20309, '\u{1EA8}'),
    (0x6C032D, '\u{1E3D}'),
    (0x304D3099, '\u{304E}'),
    (0x690303, '\u{0129}'),
    (0x1AF0323, '\u{1EF0}'),
    (0x4F0302, '\u{00D4}'),
    (0x1020301, '\u{1EAE}'),
    (0x4470308, '\u{04F5}'),
    (0x22A80338, '\u{22AD}'),
    (0x3C50300, '\u{1F7A}'),
    (0x3910313, '\u{1F08}'),
    (0x64032D, '\u{1E13}'),
    (0xCF0301, '\u{1E2E}'),
    (0x61030F, '\u{0201}'),
    (0x1EA10306, '\u{1EB7}'),
    (0x790323, '\u{1EF5}'),
    (0x21900338, '\u{219A}'),
    (0x1F250345, '\u{1F95}'),
    (0x4F0304, '\u{014C}'),
    (0x4F0306, '\u{014E}'),
    (0x30B33099, '\u{30B4}'),
    (0x440327, '\u{1E10}'),
    (0xB920BD7, '\u{0B94}'),
    (0x550308, '\u{00DC}'),
    (0x650323, '\u{1EB9}'),
    (0x307B3099, '\u{307C}'),
    (0x4F030C, '\u{01D1}'),
    (0x670304, '\u{1E21}'),
    (0x6A030C, '\u{01F0}'),
    (0x550323, '\u{1EE4}'),
    (0x1A10301, '\u{1EDB}'),
    (0x590323, '\u{1EF4}'),
    (0x410300, '\u{00C0}'),
    (0x30B93099, '\u{30BA}'),
    (0x4230308, '\u{04F0}'),
    (0x530301, '\u{015A}'),
    (0x30D8309A, '\u{30DA}'),
    (0x750309, '\u{1EE7}'),
    (0x550330, '\u{1E74}'),
    (0x520327, '\u{0156}'),
    (0x4370308, '\u{04DF}'),
    (0xCA0300, '\u{1EC0}'),
    (0x21940338, '\u{21AE}'),
    (0x3B10306, '\u{1FB0}'),
    (0x1F610342, '\u{1F67}'),
    (0x223C0338, '\u{2241}'),
    (0x30D23099, '\u{30D3}'),
    (0x1F6B0345, '\u{1FAB}'),
    (0x490307, '\u{0130}'),
    (0x410323, '\u{1EA0}'),
    (0x550309, '\u{1EE6}'),
    (0x75030B, '\u{0171}'),
    (0x30533099, '\u{3054}'),
    (0x305D3099, '\u{305E}'),
    (0x4C0323, '\u{1E36}'),
    (0x2260304, '\u{01E0}'),
    (0x475030F, '\u{0477}'),
    (0x490328, '\u{012E}'),
    (0x1F210300, '\u{1F23}'),
    (0x1F610301, '\u{1F65}'),
    (0x1F210342, '\u{1F27}'),
    (0x670302, '\u{011D}'),
    (0x4E0301, '\u{0143}'),
    (0x4E0303, '\u{00D1}'),
    (0x3990300, '\u{1FDA}'),
    (0x3BF0301, '\u{03CC}'),
    (0x4150300, '\u{0400}'),
    (0x3C90314, '\u{1F61}'),
    (0x22A20338, '\u{22AC}'),
    (0x30DB3099, '\u{30DC}'),
    (0x3A50314, '\u{1F59}'),
    (0x52030F, '\u{0210}'),
    (0x4E0323, '\u{1E46}'),
    (0x1F0D0345, '\u{1F8D}'),
    (0x1ECD0302, '\u{1ED9}'),
    (0xFC030C, '\u{01DA}'),
    (0xD60304, '\u{022A}'),
    (0x1F000301, '\u{1F04}'),
    (0x30CF3099, '\u{30D0}'),
    (0x4350306, '\u{04D7}'),
    (0x220B0338, '\u{220C}'),
    (0x590300, '\u{1EF2}'),
    (0x4170308, '\u{04DE}'),
    (0x6E030C, '\u{0148}'),
    (0x4C030C, '\u{013D}'),
    (0x1690301, '\u{1E79}'),
    (0x4100308, '\u{04D2}'),
    (0x1A00301, '\u{1EDA}'),
    (0x41030F, '\u{0200}'),
    (0x720301, '\u{0155}'),
    (0x450303, '\u{1EBC}'),
    (0x1B0D1B35, '\u{1B0E}'),
    (0x1120301, '\u{1E16}'),
    (0x4A0302, '\u{0134}'),
    (0x3BF0300, '\u{1F78}'),
    (0x30593099, '\u{305A}'),
    (0x4F030B, '\u{0150}'),
    (0x610328, '\u{0105}'),
    (0x30D83099, '\u{30D9}'),
    (0x1F2B0345, '\u{1F9B}'),
    (0x1F400301, '\u{1F44}'),
    (0x65030F, '\u{0205}'),
    (0x3AE0345, '\u{1FC4}'),
    (0x1680301, '\u{1E78}'),
    (0x740326, '\u{021B}'),
    (0x3B90342, '\u{1FD6}'),
    (0x1F6F0345, '\u{1FAF}'),
    (0x3A50301, '\u{038E}'),
    (0x1F090345, '\u{1F89}'),
    (0x550300, '\u{00D9}'),
    (0x41030C, '\u{01CD}'),
    (0x430327, '\u{00C7}'),
    (0x460307, '\u{1E1E}'),
    (0x3B50301, '\u{03AD}'),
    (0xD470D3E, '\u{0D4B}'),
    (0x610311, '\u{0203}'),
    (0xD50308, '\u{1E4E}'),
    (0x3C90300, '\u{1F7C}'),
    (0x4430306, '\u{045E}'),
    (0x1FFE0301, '\u{1FDE}'),
    (0x3990301, '\u{038A}'),
    (0x790307, '\u{1E8F}'),
    (0x1E5A0304, '\u{1E5C}'),
    (0x75030F, '\u{0215}'),
    (0x9C709BE, '\u{09CB}'),
    (0x1B071B35, '\u{1B08}'),
    (0x690330, '\u{1E2D}'),
    (0x307B309A, '\u{307D}'),
    (0x30C83099, '\u{30C9}'),
    (0x22B30338, '\u{22EB}'),
    (0x1B00301, '\u{1EE9}'),
    (0x790300, '\u{1EF3}'),
    (0x570307, '\u{1E86}'),
    (0x690328, '\u{012F}'),
    (0x5A0323, '\u{1E92}'),
    (0x3C50342, '\u{1FE6}'),
    (0x4F0309, '\u{1ECE}'),
    (0x1F290342, '\u{1F2F}'),
    (0x1A00300, '\u{1EDC}'),
    (0x1F2A0345, '\u{1F9A}'),
    (0x14D0301, '\u{1E53}'),
    (0x21D00338, '\u{21CD}'),
    (0x550328, '\u{0172}'),
    (0x680331, '\u{1E96}'),
    (0x68030C, '\u{021F}'),
    (0x4C0301, '\u{0139}'),
    (0x22860338, '\u{2288}'),
    (0x39F0314, '\u{1F49}'),
    (0x3A50306, '\u{1FE8}'),
    (0xB470B56, '\u{0B48}'),
    (0x30753099, '\u{3076}'),
    (0x1E5B0304, '\u{1E5D}'),
    (0x1F6A0345, '\u{1FAA}'),
    (0x540327, '\u{0162}'),
    (0x1020303, '\u{1EB4}'),
    (0x39F0313, '\u{1F48}'),
    (0x1F090342, '\u{1F0F}'),
    (0x4100306, '\u{04D0}'),
    (0x14D0300, '\u{1E51}'),
    (0x4430304, '\u{04EF}'),
    (0x21920338, '\u{219B}'),
    (0x22610338, '\u{2262}'),
    (0xF50304, '\u{022D}'),
    (0x3B90313, '\u{1F30}'),
    (0x6F0308, '\u{00F6}'),
    (0x730307, '\u{1E61}'),
    (0x75031B, '\u{01B0}'),
    (0x30B73099, '\u{30B8}'),
    (0x1E620307, '\u{1E68}'),
    (0x410306, '\u{0102}'),
    (0x3970314, '\u{1F29}'),
    (0x630302, '\u{0109}'),
    (0x6A0302, '\u{0135}'),
    (0xE50301, '\u{01FB}'),
    (0x730326, '\u{0219}'),
    (0x1F740345, '\u{1FC2}'),
    (0x650309, '\u{1EBB}'),
    (0x5A030C, '\u{017D}'),
    (0x22250338, '\u{2226}'),
    (0x3A90313, '\u{1F68}'),
    (0x720327, '\u{0157}'),
    (0x1F090300, '\u{1F0B}'),
    (0x4360308, '\u{04DD}'),
    (0x1F080345, '\u{1F88}'),
    (0x620331, '\u{1E07}'),
    (0x22730338, '\u{2275}'),
    (0x560323, '\u{1E7E}'),
    (0x4F0323, '\u{1ECC}'),
    (0x22E0304, '\u{0230}'),
    (0x6D50654, '\u{06C0}'),
    (0x3B10313, '\u{1F00}'),
    (0x4F0303, '\u{00D5}'),
    (0x1F010301, '\u{1F05}'),
    (0x650304, '\u{0113}'),
    (0x450323, '\u{1EB8}'),
    (0xBC60BBE, '\u{0BCA}'),
    (0x22650338, '\u{2271}'),
    (0x3910314, '\u{1F09}'),
    (0x1120300, '\u{1E14}'),
    (0x4E0307, '\u{1E44}'),
    (0x680308, '\u{1E27}'),
    (0x4F0311, '\u{020E}'),
    (0x550303, '\u{0168}'),
    (0x3A10314, '\u{1FEC}'),
    (0x3B10301, '\u{03AC}'),
    (0x55030F, '\u{0214}'),
    (0x3E0338, '\u{226F}'),
    (0x1610307, '\u{1E67}'),
    (0x1F040345, '\u{1F84}'),
    (0x450300, '\u{00C8}'),
    (0x1B091B35, '\u{1B0A}'),
    (0x30FD3099, '\u{30FE}'),
    (0x1F680301, '\u{1F6C}'),
    (0x650303, '\u{1EBD}'),
    (0x3B90304, '\u{1FD1}'),
    (0x9C709D7, '\u{09CC}'),
    (0x42B0308, '\u{04F8}'),
    (0x4E0327, '\u{0145}'),
    (0x1F630345, '\u{1FA3}'),
    (0x4380306, '\u{0439}'),
    (0x3B10314, '\u{1F01}'),
    (0x540326, '\u{021A}'),
    (0x740307, '\u{1E6B}'),
    (0x3C90301, '\u{03CE}'),
    (0x3990314, '\u{1F39}'),
    (0x30B13099, '\u{30B2}'),
    (0x750302, '\u{00FB}'),
    (0xCC60CD6, '\u{0CC8}'),
    (0x30BD3099, '\u{30BE}'),
    (0x6E0300, '\u{01F9}'),
    (0x1F390342, '\u{1F3F}'),
    (0x2270304, '\u{01E1}'),
    (0x22080338, '\u{2209}'),
    (0x4180306, '\u{0419}'),
    (0x44030C, '\u{010E}'),
    (0x75030A, '\u{016F}'),
    (0x6270654, '\u{0623}'),
    (0x750306, '\u{016D}'),
    (0x3B70300, '\u{1F74}'),
    (0x1F660345, '\u{1FA6}'),
    (0x1F690345, '\u{1FA9}'),
    (0x15B0307, '\u{1E65}'),
    (0x1F280342, '\u{1F2E}'),
    (0x1F700345, '\u{1FB2}'),
    (0x1F0F0345, '\u{1F8F}'),
    (0x540331, '\u{1E6E}'),
    (0x227B0338, '\u{2281}'),
    (0x22870338, '\u{2289}'),
    (0x1F010342, '\u{1F07}'),
    (0x3A50308, '\u{03AB}'),
    (0x1F650345, '\u{1FA5}'),
    (0xD40300, '\u{1ED2}'),
    (0xF60304, '\u{022B}'),
    (0xCBF0CD5, '\u{0CC0}'),
    (0x1F380342, '\u{1F3E}'),
    (0x22B20338, '\u{22EA}'),
    (0x72030F, '\u{0211}'),
    (0x30BF3099, '\u{30C0}'),
    (0x4E90308, '\u{04EB}'),
    (0x22830338, '\u{2285}'),
    (0x3CB0300, '\u{1FE2}'),
    (0xCA0301, '\u{1EBE}'),
    (0x590304, '\u{0232}'),
    (0x690301, '\u{00ED}'),
    (0x305F3099, '\u{3060}'),
    (0x440307, '\u{1E0A}'),
    (0x1ECC0302, '\u{1ED8}'),
    (0x1F210345, '\u{1F91}'),
    (0x410311, '\u{0202}'),
    (0x720311, '\u{0213}'),
    (0x3A50300, '\u{1FEA}'),
    (0x1F590300, '\u{1F5B}'),
    (0xE40304, '\u{01DF}'),
    (0x1F500300, '\u{1F52}'),
    (0x224D0338, '\u{226D}'),
    (0x6E0301, '\u{0144}'),
    (0x75032D, '\u{1E77}'),
    (0xF40301, '\u{1ED1}'),
    (0x3C90342, '\u{1FF6}'),
    (0x3B70301, '\u{03AE}'),
    (0x6E0307, '\u{1E45}'),
    (0x410304, '\u{0100}'),
    (0x1F190301, '\u{1F1D}'),
    (0x3B10304, '\u{1FB1}'),
    (0x3078309A, '\u{307A}'),
    (0x570323, '\u{1E88}'),
    (0x4430308, '\u{04F1}'),
    (0x45032D, '\u{1E18}'),
    (0x4150308, '\u{0401}'),
    (0x4F0328, '\u{01EA}'),
    (0x4D90308, '\u{04DB}'),
    (0x4060308, '\u{0407}'),
    (0xF40303, '\u{1ED7}'),
    (0x3B90306, '\u{1FD0}'),
    (0x650307, '\u{0117}'),
    (0x1F680342, '\u{1F6E}'),
    (0x4380304, '\u{04E3}'),
    (0x1F410300, '\u{1F43}'),
    (0x1FFE0300, '\u{1FDD}'),
    (0x4F0301, '\u{00D3}'),
    (0x640327, '\u{1E11}'),
    (0x2290306, '\u{1E1D}'),
    (0x7A0301, '\u{017A}'),
    (0x620323, '\u{1E05}'),
    (0x1F7C0345, '\u{1FF2}'),
    (0x1B00323, '\u{1EF1}'),
    (0x1F600301, '\u{1F64}'),
    (0x30663099, '\u{3067}'),
    (0x22640338, '\u{2270}'),
    (0x1F310300, '\u{1F33}'),
    (0x610323, '\u{1EA1}'),
    (0x1F480300, '\u{1F4A}'),
    (0x550301, '\u{00DA}'),
    (0xC460C56, '\u{0C48}'),
    (0x3CA0300, '\u{1FD2}'),
    (0x1B7030C, '\u{01EE}'),
    (0x720323, '\u{1E5B}'),
    (0x1F200342, '\u{1F26}'),
    (0x4300308, '\u{04D3}'),
    (0x22820338, '\u{2284}'),
    (0x1F590301, '\u{1F5D}'),
    (0x1F080342, '\u{1F0E}'),
    (0x440323, '\u{1E0C}'),
    (0x1025102E, '\u{1026}'),
    (0x3910304, '\u{1FB9}'),
    (0x4B0331, '\u{1E34}'),
    (0x690300, '\u{00EC}'),
    (0x48032E, '\u{1E2A}'),
    (0x630301, '\u{0107}'),
    (0x1F690342, '\u{1F6F}'),
    (0x3B50313, '\u{1F10}'),
    (0x30CF309A, '\u{30D1}'),
    (0x4E030C, '\u{0147}'),
    (0xB470B57, '\u{0B4C}'),
    (0x3910301, '\u{0386}'),
    (0x650328, '\u{0119}'),
    (0x1FBF0300, '\u{1FCD}'),
    (0x3B70342, '\u{1FC6}'),
    (0x450307, '\u{0116}'),
    (0x1F380301, '\u{1F3C}'),
    (0x3075309A, '\u{3077}'),
    (0x4B0301, '\u{1E30}'),
    (0x1030300, '\u{1EB1}'),
    (0xE20303, '\u{1EAB}'),
    (0x410302, '\u{00C2}'),
    (0x650308, '\u{00EB}'),
    (0x580307, '\u{1E8A}'),
    (0x54030C, '\u{0164}'),
    (0x3C50313, '\u{1F50}'),
    (0x3B50314, '\u{1F11}'),
    (0x1B3E1B35, '\u{1B40}'),
    (0x1F100301, '\u{1F14}'),
    (0x3072309A, '\u{3074}'),
    (0x1F280345, '\u{1F98}'),
    (0x22770338, '\u{2279}'),
    (0x227A0338, '\u{2280}'),
    (0x470302, '\u{011C}'),
    (0x450308, '\u{00CB}'),
    (0x550324, '\u{1E72}'),
    (0x1F2C0345, '\u{1F9C}'),
    (0x4B0327, '\u{0136}'),
    (0x490302, '\u{00CE}'),
    (0x680302, '\u{0125}'),
    (0x520307, '\u{1E58}'),
    (0x610301, '\u{00E1}'),
    (0x4B030C, '\u{01E8}'),
    (0x490309, '\u{1EC8}'),
    (0x6C030C, '\u{013E}'),
    (0x4D0307, '\u{1E40}'),
    (0x1E360304, '\u{1E38}'),
    (0x3C50304, '\u{1FE1}'),
    (0x79030A, '\u{1E99}'),
    (0x3970313, '\u{1F28}'),
    (0x54032D, '\u{1E70}'),
    (0x1F490300, '\u{1F4B}'),
    (0x1B421B35, '\u{1B43}'),
    (0x3B70313, '\u{1F20}'),
    (0xEF0301, '\u{1E2F}'),
    (0xE70301, '\u{1E09}'),
    (0x16A0308, '\u{1E7A}'),
    (0xCA0303, '\u{1EC4}'),
    (0x3B10300, '\u{1F70}'),
    (0x6D20654, '\u{06D3}'),
    (0x30D53099, '\u{30D6}'),
    (0x1F2F0345, '\u{1F9F}'),
    (0x3B50300, '\u{1F72}'),
    (0x750324, '\u{1E73}'),
    (0x4150306, '\u{04D6}'),
    (0x65030C, '\u{011B}'),
    (0x570302, '\u{0174}'),
    (0x1EA00306, '\u{1EB6}'),
    (0x1F070345, '\u{1F87}'),
    (0xA80301, '\u{0385}'),
    (0x790302, '\u{0177}'),
    (0x6E032D, '\u{1E4B}'),
    (0x6F030C, '\u{01D2}'),
    (0x3C90345, '\u{1FF3}'),
    (0x430302, '\u{0108}'),
    (0x790303, '\u{1EF9}'),
    (0x740323, '\u{1E6D}'),
    (0xE20309, '\u{1EA9}'),
    (0x1F300300, '\u{1F32}'),
    (0x6B0301, '\u{1E31}'),
    (0x22920338, '\u{22E3}'),
    (0x3950314, '\u{1F19}'),
    (0x1F290301, '\u{1F2D}'),
    (0x450328, '\u{0118}'),
    (0x1FB60345, '\u{1FB7}'),
    (0xD50304, '\u{022C}'),
    (0x4300306, '\u{04D1}'),
    (0xF50308, '\u{1E4F}'),
    (0x1EA00302, '\u{1EAC}'),
    (0x1F680300, '\u{1F6A}'),
    (0x3970300, '\u{1FCA}'),
    (0x450301, '\u{00C9}'),
    (0x690304, '\u{012B}'),
    (0xBC60BD7, '\u{0BCC}'),
    (0x6F0304, '\u{014D}'),
    (0x4F0308, '\u{00D6}'),
    (0xBC70BBE, '\u{0BCB}'),
    (0x55030C, '\u{01D3}'),
    (0x3AC0345, '\u{1FB4}'),
    (0x1FBF0342, '\u{1FCF}'),
    (0x30D2309A, '\u{30D4}'),
    (0x660307, '\u{1E1F}'),
    (0x4E0300, '\u{01F8}'),
    (0x790308, '\u{00FF}'),
    (0x68032E, '\u{1E2B}'),
    (0x64030C, '\u{010F}'),
    (0x4F0307, '\u{022E}'),
    (0x1F590342, '\u{1F5F}'),
    (0x30AF3099, '\u{30B0}'),
    (0xE60304, '\u{01E3}'),
    (0x3C50301, '\u{03CD}'),
    (0x770308, '\u{1E85}'),
    (0x3B90314, '\u{1F31}'),
    (0x750323, '\u{1EE5}'),
    (0x590309, '\u{1EF6}'),
    (0x292030C, '\u{01EF}'),
    (0x550306, '\u{016C}'),
    (0xE60301, '\u{01FD}'),
    (0x16B0308, '\u{1E7B}'),
    (0x4F030F, '\u{020C}'),
    (0x3BF0313, '\u{1F40}'),
    (0xD80301, '\u{01FE}'),
    (0xC20303, '\u{1EAA}'),
    (0x1F510300, '\u{1F53}'),
    (0x1B00309, '\u{1EED}'),
    (0x4E032D, '\u{1E4A}'),
    (0x6F0309, '\u{1ECF}'),
    (0x4180300, '\u{040D}'),
    (0x22A90338, '\u{22AE}'),
    (0x1F680345, '\u{1FA8}'),
    (0x1B3C1B35, '\u{1B3D}'),
    (0x1F400300, '\u{1F42}'),
    (0x1F0B0345, '\u{1F8B}'),
    (0x3C50306, '\u{1FE0}'),
    (0x44032D, '\u{1E12}'),
    (0xCCA0CD5, '\u{0CCB}'),
    (0xEA0303, '\u{1EC5}'),
    (0x4230306, '\u{040E}'),
    (0xC70301, '\u{1E08}'),
    (0x7A030C, '\u{017E}'),
    (0x670307, '\u{0121}'),
    (0x450311, '\u{0206}'),
    (0x6F0300, '\u{00F2}'),
    (0x30BB3099, '\u{30BC}'),
    (0x4180308, '\u{04E4}'),
    (0x30513099, '\u{3052}'),
    (0x6C0323, '\u{1E37}'),
    (0x3B70314, '\u{1F21}'),
    (0x77030A, '\u{1E98}'),
    (0x690323, '\u{1ECB}'),
    (0x610303, '\u{00E3}'),
    (0x30F13099, '\u{30F9}'),
    (0x3B10345, '\u{1FB3}'),
    (0xD460D3E, '\u{0D4A}'),
    (0x3B90300, '\u{1F76}'),
    (0x21D40338, '\u{21CE}'),
    (0x1F620345, '\u{1FA2}'),
    (0x770302, '\u{0175}'),
    (0xFC0304, '\u{01D6}'),
    (0x1130301, '\u{1E17}'),
    (0x30683099, '\u{3069}'),
    (0x1F600342, '\u{1F66}'),
    (0x680323, '\u{1E25}'),
    (0x3950313, '\u{1F18}'),
    (0xEA0300, '\u{1EC1}'),
    (0x3CB0342, '\u{1FE7}'),
    (0x22430338, '\u{2244}'),
    (0x30783099, '\u{3079}'),
    (0x3990313, '\u{1F38}'),
    (0x490330, '\u{1E2C}'),
    (0x770307, '\u{1E87}'),
    (0x650301, '\u{00E9}'),
    (0x680327, '\u{1E29}'),
    (0x22B50338, '\u{22ED}'),
    (0x3B10342, '\u{1FB6}'),
    (0x3910306, '\u{1FB8}'),
    (0x4D0301, '\u{1E3E}'),
    (0x410309, '\u{1EA2}'),
    (0x1B051B35, '\u{1B06}'),
    (0x3C0338, '\u{226E}'),
    (0x590308, '\u{0178}'),
    (0x1030303, '\u{1EB5}'),
    (0x480327, '\u{1E28}'),
    (0x6D0323, '\u{1E43}'),
    (0x30643099, '\u{3065}'),
    (0x4560308, '\u{0457}'),
    (0x590302, '\u{0176}'),
    (0x6C10654, '\u{06C2}'),
    (0x43A0301, '\u{045C}'),
    (0xE20300, '\u{1EA7}'),
    (0x3950301, '\u{0388}'),
    (0x630327, '\u{00E7}'),
    (0x17F0307, '\u{1E9B}'),
    (0x6480654, '\u{0624}'),
    (0x30AB3099, '\u{30AC}'),
    (0x1A00323, '\u{1EE2}'),
    (0x4D80308, '\u{04DA}'),
    (0x5A0331, '\u{1E94}'),
    (0x67030C, '\u{01E7}'),
    (0x39F0300, '\u{1FF8}'),
    (0x650327, '\u{0229}'),
    (0x490323, '\u{1ECA}'),
    (0x1F110300, '\u{1F13}'),
    (0x1F510342, '\u{1F57}'),
    (0x4D0323, '\u{1E42}'),
    (0x1F300301, '\u{1F34}'),
    (0x6C0327, '\u{013C}'),
    (0x1F050345, '\u{1F85}'),
    (0x1A10300, '\u{1EDD}'),
    (0x4160308, '\u{04DC}'),
    (0x640307, '\u{1E0B}'),
    (0x4C032D, '\u{1E3C}'),
    (0x3C10314, '\u{1FE5}'),
    (0x1EA0304, '\u{01EC}'),
    (0x1F080300, '\u{1F0A}'),
    (0x650302, '\u{00EA}'),
    (0x3910300, '\u{1FBA}'),
    (0x700301, '\u{1E55}'),
    (0x1F020345, '\u{1F82}'),
    (0x1020309, '\u{1EB2}'),
    (0x750303, '\u{0169}'),
    (0x1F0C0345, '\u{1F8C}'),
    (0x3CB0301, '\u{03B0}'),
    (0x740308, '\u{1E97}'),
    (0x3950300, '\u{1FC8}'),
    (0x227D0338, '\u{22E1}'),
    (0x7A0323, '\u{1E93}'),
    (0x6F0311, '\u{020F}'),
    (0x6F0328, '\u{01EB}'),
    (0x1F200300, '\u{1F22}'),
    (0x1F190300, '\u{1F1B}'),
    (0x560303, '\u{1E7C}'),
    (0x6B030C, '\u{01E9}'),
    (0x4E80308, '\u{04EA}'),
    (0x3A90300, '\u{1FFA}'),
    (0xA80342, '\u{1FC1}'),
    (0x4360306, '\u{04C2}'),
    (0xDC0301, '\u{01D7}'),
    (0x750304, '\u{016B}'),
    (0x22450338, '\u{2247}'),
    (0x490304, '\u{012A}'),
    (0x4380308, '\u{04E5}'),
    (0xD460D57, '\u{0D4C}'),
    (0x750300, '\u{00F9}'),
    (0x22B40338, '\u{22EC}'),
    (0x750308, '\u{00FC}'),
    (0x3C50314, '\u{1F51}'),
    (0x1600307, '\u{1E66}'),
    (0x4160306, '\u{04C1}'),
    (0x55031B, '\u{01AF}'),
    (0x22AB0338, '\u{22AF}'),
    (0x14C0300, '\u{1E50}'),
    (0x1F310342, '\u{1F37}'),
    (0x1F260345, '\u{1F96}'),
    (0x22910338, '\u{22E2}'),
    (0x500301, '\u{1E54}'),
    (0x4C0327, '\u{013B}'),
    (0x5A0301, '\u{0179}'),
    (0x420307, '\u{1E02}'),
    (0x3C10313, '\u{1FE4}'),
    (0x1F410301, '\u{1F45}'),
    (0x500307, '\u{1E56}'),
    (0x43030C, '\u{010C}'),
    (0x730323, '\u{1E63}'),
    (0x30553099, '\u{3056}'),
    (0x306F3099, '\u{3070}'),
    (0x44D0308, '\u{04ED}'),
    (0x1F670345, '\u{1FA7}'),
    (0x1AF0301, '\u{1EE8}'),
    (0x1F290300, '\u{1F2B}'),
    (0x1B3F1B35, '\u{1B41}'),
    (0x450302, '\u{00CA}'),
    (0x6F0306, '\u{014F}'),
    (0xFC0301, '\u{01D8}'),
    (0x30F23099, '\u{30FA}'),
    (0x1F2D0345, '\u{1F9D}'),
    (0x14C0301, '\u{1E52}'),
    (0x610308, '\u{00E4}'),
    (0x1F600345, '\u{1FA0}'),
    (0x1F0A0345, '\u{1F8A}'),
    (0x610306, '\u{0103}'),
    (0x1F600300, '\u{1F62}'),
    (0x1AF0300, '\u{1EEA}'),
    (0x43E0308, '\u{04E7}'),
    (0x22230338, '\u{2224}'),
    (0x3CA0301, '\u{0390}'),
    (0x30D5309A, '\u{30D7}'),
    (0x1F220345, '\u{1F92}'),
    (0xD50301, '\u{1E4C}'),
    (0x1F6C0345, '\u{1FAC}'),
    (0x540307, '\u{1E6A}'),
    (0x1E370304, '\u{1E39}'),
    (0xDD90DCA, '\u{0DDA}'),
    (0x1A10303, '\u{1EE1}'),
    (0x48030C, '\u{021E}'),
    (0xEA0309, '\u{1EC3}'),
    (0x52030C, '\u{0158}'),
    (0xD40303, '\u{1ED6}'),
    (0x45030C, '\u{011A}'),
    (0x30EF3099, '\u{30F7}'),
    (0x480302, '\u{0124}'),
    (0x520323, '\u{1E5A}'),
    (0xC20300, '\u{1EA6}'),
    (0x74032D, '\u{1E71}'),
    (0x42D0308, '\u{04EC}'),
    (0xDD90DDF, '\u{0DDE}'),
    (0x410308, '\u{00C4}'),
    (0x474030F, '\u{0476}'),
    (0xC60301, '\u{01FC}'),
    (0x1F310301, '\u{1F35}'),
    (0x1F610300, '\u{1F63}'),
    (0xCC60CC2, '\u{0CCA}'),
    (0xC20301, '\u{1EA4}'),
    (0x3C50308, '\u{03CB}'),
    (0xE20301, '\u{1EA5}'),
    (0x1F500342, '\u{1F56}'),
    (0x610300, '\u{00E0}'),
    (0x490311, '\u{020A}'),
    (0x670327, '\u{0123}'),
    (0x590307, '\u{1E8E}'),
    (0x3970345, '\u{1FCC}'),
    (0xD40309, '\u{1ED4}'),
    (0x1A00303, '\u{1EE0}'),
    (0x1FFE0342, '\u{1FDF}'),
    (0x41A0301, '\u{040C}'),
    (0x74030C, '\u{0165}'),
    (0xDC0300, '\u{01DB}'),
    (0x780308, '\u{1E8D}'),
    (0xDC0304, '\u{01D5}'),
    (0x610302, '\u{00E2}'),
    (0x5A0302, '\u{1E90}'),
    (0x933093C, '\u{0934}'),
    (0x4F031B, '\u{01A0}'),
    (0x520311, '\u{0212}'),
    (0x6E0303, '\u{00F1}'),
    (0x45030F, '\u{0204}'),
    (0x1AF0309, '\u{1EEC}'),
    (0x450304, '\u{0112}'),
    (0x1F210301, '\u{1F25}'),
    (0x22F0304, '\u{0231}'),
    (0x3990306, '\u{1FD8}'),
    (0x4E0331, '\u{1E48}'),
    (0x1F380300, '\u{1F3A}'),
    (0x490306, '\u{012C}'),
    (0x690306, '\u{012D}'),
    (0x1F060345, '\u{1F86}'),
    (0x490301, '\u{00CD}'),
    (0x570300, '\u{1E80}'),
    (0x30F03099, '\u{30F8}'),
    (0x53030C, '\u{0160}'),
    (0x490300, '\u{00CC}'),
    (0x30723099, '\u{3073}'),
    (0x1F280300, '\u{1F2A}'),
    (0x480307, '\u{1E22}'),
    (0x1A00309, '\u{1EDE}'),
    (0x1EB0304, '\u{01ED}'),
    (0x1E630307, '\u{1E69}'),
    (0x6F0323, '\u{1ECD}'),
    (0x410303, '\u{00C3}'),
    (0x3910345, '\u{1FBC}'),
    (0x410328, '\u{0104}'),
    (0x680307, '\u{1E23}'),
    (0x6E0331, '\u{1E49}'),
    (0xDDC0DCA, '\u{0DDD}'),
    (0x580308, '\u{1E8C}'),
    (0x410301, '\u{00C1}'),
    (0x30C43099, '\u{30C5}'),
    (0x420323, '\u{1E04}'),
    (0x730302, '\u{015D}'),
];

pub(crate) fn composition_table_astral(c1: char, c2: char) -> Option<char> {
    match (c1, c2) {
        ('\u{11099}', '\u{110BA}') => Some('\u{1109A}'),
        ('\u{1109B}', '\u{110BA}') => Some('\u{1109C}'),
        ('\u{110A5}', '\u{110BA}') => Some('\u{110AB}'),
        ('\u{11131}', '\u{11127}') => Some('\u{1112E}'),
        ('\u{11132}', '\u{11127}') => Some('\u{1112F}'),
        ('\u{11347}', '\u{1133E}') => Some('\u{1134B}'),
        ('\u{11347}', '\u{11357}') => Some('\u{1134C}'),
        ('\u{114B9}', '\u{114B0}') => Some('\u{114BC}'),
        ('\u{114B9}', '\u{114BA}') => Some('\u{114BB}'),
        ('\u{114B9}', '\u{114BD}') => Some('\u{114BE}'),
        ('\u{115B8}', '\u{115AF}') => Some('\u{115BA}'),
        ('\u{115B9}', '\u{115AF}') => Some('\u{115BB}'),
        _ => None,
    }
}

pub(crate) const CANONICAL_DECOMPOSED_SALT: &[u16] = &[
    0x58b,
    0x18,
    0x0,
    0x0,
    0x308,
    0x293,
    0x0,
    0x1be,
    0x1ca,
    0x13,
    0x0,
    0x4,
    0x0,
    0x82,
    0xc0,
    0x66,
    0x4,
    0x0,
    0x4f,
    0x91,
    0x22,
    0x2f,
    0x6,
    0x10,
    0x2,
    0x7b,
    0x45,
    0x1,
    0x2,
    0x33,
    0x6,
    0x0,
    0x0,
    0x25,
    0xc,
    0xf3,
    0x0,
    0x5f,
    0x3,
    0x0,
    0x0,
    0x0,
    0x8,
    0x0,
    0x6,
    0x63,
    0x21,
    0x0,
    0x2a,
    0x0,
    0x0,
    0xab,
    0xc,
    0x0,
    0x0,
    0x3d,
    0x2b,
    0x0,
    0x0,
    0x67,
    0x0,
    0x1,
    0x8,
    0x3,
    0x0,
    0x0,
    0x2,
    0x0,
    0x53,
    0x4,
    0x0,
    0x84,
    0x0,
    0x30,
    0x0,
    0x0,
    0x5,
    0x6,
    0x70,
    0x9,
    0x42,
    0x1,
    0x6d,
    0x2,
    0x2f,
    0x0,
    0x1a,
    0x0,
    0x11,
    0x2,
    0x0,
    0x1b,
    0x1,
    0x0,
    0x6,
    0x0,
    0x1b,
    0x0,
    0xb,
    0x0,
    0x0,
    0x15,
    0x0,
    0x0,
    0x5f,
    0x0,
    0x5,
    0x0,
    0x37,
    0xc,
    0x0,
    0x5,
    0x3,
    0x48,
    0x17,
    0x9,
    0x21,
    0x7,
    0x4,
    0x1,
    0x0,
    0x53,
    0xaa,
    0x0,
    0x3,
    0x0,
    0x0,
    0x25,
    0x10,
    0x1f,
    0x2e,
    0x48,
    0x0,
    0x1,
    0x0,
    0x19,
    0x1,
    0x2,
    0x0,
    0x1,
    0x4,
    0x0,
    0x0,
    0x22,
    0x0,
    0x2,
    0x4,
    0x0,
    0x0,
    0x7,
    0x11,
    0x1b,
    0x1a,
    0x11,
    0x10,
    0x8,
    0x2,
    0x2a,
    0x4,
    0x0,
    0x35,
    0x19,
    0xd,
    0x0,
    0x5,
    0x27,
    0x0,
    0x3,
    0x5,
    0x0,
    0x1c,
    0x2,
    0x26,
    0x1,
    0x0,
    0x0,
    0x7,
    0x2f,
    0x5,
    0x3c,
    0x0,
    0xb,
    0x8,
    0x0,
    0x0,
    0x1a,
    0x19,
    0x2,
    0x6,
    0x0,
    0x1,
    0x0,
    0xe,
    0x2,
    0x18,
    0x3,
    0x2,
    0x3,
    0x8,
    0x0,
    0x9,
    0xf,
    0x4e,
    0x0,
    0x27,
    0xe,
    0xd,
    0x0,
    0x18,
    0x0,
    0x1a,
    0x0,
    0x0,
    0x5,
    0x1,
    0x2,
    0x0,
    0x3,
    0x2e,
    0x2a,
    0x1b,
    0x0,
    0x0,
    0x4,
    0x0,
    0x25,
    0x1b,
    0x7,
    0x0,
    0x0,
    0x42,
    0xa,
    0x8,
    0x1,
    0x1,
    0x0,
    0x6,
    0x5,
    0x16,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x4,
    0x23,
    0x3,
    0xc,
    0x1,
    0x7,
    0x9,
    0x9,
    0x0,
    0x1,
    0x9,
    0x2,
    0x2,
    0x4,
    0x0,
    0x7,
    0x1,
    0x6,
    0xa,
    0xc,
    0x3,
    0x20,
    0x0,
    0x12,
    0x1,
    0x1,
    0x2,
    0x4,
    0x8,
    0x8,
    0x1b,
    0x4,
    0x1,
    0x10,
    0x0,
    0xb,
    0x0,
    0x5,
    0x0,
    0x5,
    0x0,
    0xc,
    0x0,
    0x14,
    0x0,
    0x33,
    0x0,
    0x0,
    0x0,
    0x0,
    0xd,
    0x0,
    0x0,
    0x35,
    0x5,
    0x0,
    0x0,
    0x0,
    0x15,
    0x0,
    0x0,
    0x7,
    0x4,
    0x0,
    0x3b,
    0x1,
    0x1,
    0x1,
    0x0,
    0x6,
    0x0,
    0x4,
    0x18,
    0x0,
    0x0,
    0x3,
    0xd,
    0xc,
    0x2,
    0x4,
    0x1,
    0x1,
    0x1,
    0x0,
    0x10,
    0x0,
    0x8,
    0x36,
    0x9,
    0x1,
    0xb,
    0x3,
    0xb,
    0x3,
    0x0,
    0x0,
    0xf,
    0x6,
    0x0,
    0x0,
    0x7,
    0x2,
    0x3f,
    0xa,
    0x0,
    0x0,
    0x1e,
    0x0,
    0x0,
    0x1,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x1a,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x9,
    0x1,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x8,
    0x0,
    0x0,
    0x1,
    0x0,
    0x7,
    0x0,
    0xa,
    0x5,
    0xf,
    0x10,
    0x1,
    0x0,
    0x6,
    0x1,
    0x2,
    0x7,
    0x9,
    0x3,
    0x1,
    0xe,
    0x7,
    0x0,
    0x0,
    0x1,
    0x8,
    0x1,
    0xd,
    0x0,
    0x0,
    0x1,
    0x2,
    0xb,
    0x0,
    0x3,
    0x6,
    0x0,
    0x9,
    0xe,
    0x2,
    0x0,
    0x7,
    0x32,
    0x8,
    0x0,
    0x0,
    0x4,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1e,
    0x0,
    0x0,
    0x0,
    0x9,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x2,
    0x7,
    0x0,
    0x0,
    0x6,
    0xb,
    0x14,
    0xb,
    0xc,
    0x0,
    0x2,
    0x4,
    0x1,
    0x2,
    0x10,
    0x1,
    0x1,
    0x1,
    0x4,
    0x3,
    0x1,
    0xb,
    0x8,
    0x4,
    0x1,
    0x4,
    0x4,
    0x0,
    0x18,
    0x0,
    0x0,
    0x0,
    0x2c,
    0xe,
    0x7,
    0x2,
    0x6,
    0x2,
    0x13,
    0x6,
    0x4,
    0x2,
    0x0,
    0x1d,
    0x12,
    0x6,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0xa,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0xa,
    0x2,
    0x0,
    0x0,
    0xe,
    0x4,
    0x1,
    0x0,
    0x9,
    0x1,
    0x2,
    0x2,
    0x7,
    0x0,
    0x0,
    0x2,
    0x4,
    0x6,
    0x0,
    0x9,
    0x0,
    0x5,
    0x0,
    0x0,
    0x1,
    0x1a,
    0x9,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x4,
    0xd,
    0x8,
    0x17,
    0x7,
    0x0,
    0x0,
    0x5,
    0xe,
    0x12,
    0xa,
    0x0,
    0x1b,
    0x7,
    0x0,
    0x0,
    0x11,
    0x1,
    0x4,
    0x9,
    0x0,
    0x1,
    0x0,
    0x0,
    0x3,
    0x0,
    0x9,
    0x0,
    0x2,
    0xc,
    0x4,
    0x1,
    0x15,
    0x4,
    0x0,
    0x4,
    0x3,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x12,
    0x2,
    0x5,
    0x2,
    0x1,
    0x5,
    0x9,
    0x0,
    0x0,
    0x8,
    0x0,
    0x1,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0x1,
    0x7,
    0x1,
    0x0,
    0x0,
    0x9,
    0x0,
    0x3,
    0xb,
    0x2,
    0x6,
    0x4,
    0x0,
    0x0,
    0x5,
    0x0,
    0xa,
    0x2,
    0x9,
    0x8,
    0x0,
    0x0,
    0x7,
    0x0,
    0x1d,
    0xa,
    0x3,
    0x0,
    0x8,
    0x0,
    0xc,
    0x1,
    0x1,
    0x0,
    0x0,
    0x4,
    0x7,
    0x0,
    0x4,
    0x16,
    0x3,
    0x1,
    0x8,
    0xd,
    0x0,
    0x3,
    0x4,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x6,
    0x6,
    0x0,
    0x2,
    0x0,
    0x0,
    0x9,
    0x8,
    0xb,
    0x0,
    0x0,
    0x0,
    0x0,
    0x12,
    0x0,
    0x0,
    0x4,
    0x1,
    0x0,
    0xc,
    0x5,
    0x3,
    0xb,
    0x4,
    0x0,
    0x0,
    0x3,
    0x1,
    0x7,
    0x1,
    0x0,
    0x0,
    0xa,
    0x5,
    0x0,
    0x9,
    0x0,
    0x0,
    0x14,
    0x0,
    0xc,
    0x0,
    0x6,
    0x0,
    0x3,
    0x2,
    0x0,
    0x5,
    0x3,
    0x0,
    0x5,
    0x1,
    0x12,
    0x0,
    0x0,
    0x1,
    0x0,
    0x2,
    0x0,
    0x0,
    0x7,
    0x0,
    0x0,
    0x0,
    0x0,
    0x6,
    0xd,
    0x1,
    0x6,
    0x0,
    0xb,
    0x1,
    0x2,
    0x0,
    0x0,
    0x3,
    0x0,
    0x1,
    0x4,
    0x0,
    0x0,
    0x0,
    0x9,
    0x0,
    0x0,
    0x5,
    0x7,
    0x0,
    0x0,
    0xc,
    0x2,
    0x0,
    0x3,
    0x17,
    0x2,
    0x0,
    0x3,
    0x0,
    0xe,
    0x0,
    0xe,
    0x7,
    0x0,
    0x9,
    0x5,
    0x1,
    0x2,
    0x1,
    0x3,
    0x0,
    0x0,
    0x0,
    0x3,
    0x3,
    0x2,
    0x1,
    0x2,
    0x0,
    0x7,
    0x5,
    0x0,
    0x8,
    0x3,
    0x1,
    0x0,
    0x7,
    0x1,
    0x0,
    0xc,
    0x0,
    0x1,
    0x5,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x6,
    0x0,
    0x0,
    0x0,
    0x8,
    0xd,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x6,
    0x1,
    0xd,
    0x2,
    0x0,
    0x0,
    0x4,
    0x6,
    0x0,
    0x6,
    0x1,
    0x6,
    0x1,
    0x2,
    0x8,
    0x4,
    0x2,
    0x2,
    0x2,
    0x4,
    0x0,
    0x0,
    0x14,
    0x11,
    0x0,
    0x0,
    0x8,
    0x1,
    0x2,
    0x2,
    0x2,
    0x7,
    0x1,
    0x0,
    0x0,
    0x4,
    0xa,
    0x0,
    0x0,
    0x0,
    0x0,
    0x7,
    0x0,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x3,
    0x5,
    0x3,
    0x4,
    0x0,
    0x0,
    0x3,
    0x5,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x1a,
    0x0,
    0x6,
    0x0,
    0x4,
    0x6,
    0x4,
    0x0,
    0x1,
    0x1,
    0x5,
    0x1,
    0x4,
    0x6,
    0x0,
    0x4,
    0x1,
    0x0,
    0x9,
    0x1,
    0x5,
    0x5,
    0x1,
    0x9,
    0x2,
    0x6,
    0x3,
    0x0,
    0x8,
    0x0,
    0x0,
    0x1,
    0x5,
    0x9,
    0x12,
    0x1,
    0x2,
    0x8,
    0x0,
    0x6,
    0x1,
    0x0,
    0xd,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0xb,
    0x0,
    0xb,
    0x1,
    0x2,
    0x0,
    0x0,
    0x3,
    0x0,
    0x3,
    0x0,
    0x2,
    0x5,
    0x1,
    0x1,
    0x7,
    0x1,
    0x2,
    0x3,
    0xa,
    0x7,
    0x8,
    0xa,
    0x1,
    0x0,
    0x1,
    0x12,
    0x2,
    0x4,
    0x0,
    0x2,
    0x6,
    0x2,
    0x9,
    0x0,
    0x6,
    0x0,
    0x2,
    0x1,
    0x0,
    0x1,
    0x4,
    0x0,
    0x0,
    0x0,
    0x12,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x5,
    0x2,
    0x0,
    0x3,
    0x0,
    0x1,
    0x1,
    0x3,
    0x0,
    0x2,
    0x0,
    0x1,
    0x4,
    0x0,
    0x5,
    0x1,
    0x1,
    0x1,
    0x2,
    0x8,
    0x4,
    0x1,
    0x1,
    0x2,
    0x0,
    0x2,
    0x0,
    0x2,
    0x3,
    0x1,
    0x0,
    0xc,
    0x1,
    0x0,
    0x0,
    0x0,
    0xd,
    0x3,
    0x0,
    0x4,
    0x1,
    0x0,
    0x2,
    0x7,
    0x11,
    0x0,
    0x5,
    0x0,
    0x9,
    0x2,
    0x0,
    0x2,
    0x1,
    0x4,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x5,
    0x2,
    0x0,
    0x0,
    0x2,
    0x1,
    0x0,
    0x0,
    0x2,
    0x0,
    0x5,
    0x1,
    0x0,
    0x1,
    0x3,
    0x0,
    0x2,
    0xc,
    0x1,
    0x2,
    0x5,
    0x0,
    0x3,
    0x2,
    0x5,
    0x0,
    0x5,
    0x1,
    0x0,
    0x0,
    0x1,
    0x1,
    0x0,
    0x4,
    0x0,
    0x0,
    0xb,
    0x3,
    0x6,
    0x0,
    0x0,
    0x0,
    0x0,
    0x5,
    0x3,
    0x0,
    0x4,
    0x0,
    0x3,
    0xb,
    0x0,
    0x0,
    0x3,
    0x2,
    0x3,
    0x4,
    0x3,
    0x6,
    0x9,
    0x2,
    0x0,
    0x1,
    0x1,
    0x8,
    0x4,
    0x8,
    0x0,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x5,
    0x1,
    0x1,
    0xa,
    0x7,
    0x9,
    0x8,
    0x9,
    0x2,
    0x0,
    0x0,
    0x3,
    0x5,
    0x1,
    0x6,
    0x6,
    0x1,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x2,
    0x1,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x2,
    0x1,
    0x0,
    0x0,
    0x7,
    0x8,
    0x0,
    0x0,
    0xe,
    0x2,
    0x0,
    0x0,
    0x0,
    0x1,
    0x6,
    0x0,
    0x1,
    0x0,
    0x0,
    0x5,
    0x0,
    0x1,
    0x1,
    0x3,
    0x1,
    0x0,
    0x5,
    0x0,
    0x0,
    0x5,
    0x3,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x3,
    0x11,
    0x2,
    0x5,
    0x3,
    0x0,
    0x0,
    0x1,
    0x3,
    0x2,
    0x5,
    0x1,
    0xa,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x3,
    0x1,
    0x5,
    0x2,
    0x2,
    0x0,
    0x8,
    0x1,
    0x2,
    0x0,
    0x0,
    0x6,
    0x6,
    0x6,
    0x2,
    0xc,
    0x0,
    0x1,
    0x1,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x8,
    0x1,
    0x0,
    0x0,
    0x0,
    0xc,
    0x0,
    0x2,
    0x0,
    0x2,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x2,
    0x4,
    0x8,
    0x7,
    0x6,
    0x1,
    0x2,
    0x0,
    0x1,
    0x2,
    0xb,
    0x3,
    0x2,
    0x4,
    0x0,
    0xa,
    0x1,
    0x3,
    0xc,
    0x1,
    0x0,
    0x3,
    0x1,
    0x0,
    0xd,
    0x0,
    0x1,
    0x1,
    0x1,
    0x0,
    0x8,
    0x4,
    0x2,
    0x0,
    0x1,
    0x1,
    0x6,
    0x7,
    0x1,
    0x4,
    0x0,
    0x1,
    0xd,
    0x2,
    0x2,
    0x0,
    0x2,
    0x1,
    0x0,
    0x1,
    0x2,
    0x5,
    0x1,
    0x1,
    0x1,
    0x0,
    0x2,
    0xa,
    0x4,
    0x1,
    0x4,
    0x2,
    0x1,
    0x1,
    0x1,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x1,
    0x4,
    0x3,
    0x0,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x0,
    0xb,
    0x1,
    0x0,
    0x0,
    0x2,
    0x0,
    0x1,
    0x1,
    0x1,
    0x0,
    0x3,
    0x5,
    0x0,
    0xb,
    0x1,
    0x3,
    0x1,
    0x0,
    0x1,
    0x1,
    0x0,
    0x3,
    0x6,
    0x0,
    0x0,
    0x6,
    0x0,
    0x1,
    0x3,
    0x0,
    0x4,
    0x4,
    0x1,
    0x2,
    0x2,
    0x1,
    0x1,
    0x4,
    0x1,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x5,
    0x3,
    0x4,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x5,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x4,
    0x2,
    0x2,
    0x4,
    0x0,
    0x2,
    0x4,
    0x0,
    0x0,
    0x1,
    0x2,
    0x5,
    0x2,
    0x1,
    0x1,
    0x1,
    0x1,
    0x2,
    0x7,
    0x0,
    0x1,
    0x5,
    0x1,
    0x1,
    0x0,
    0x1,
    0x0,
    0x2,
    0x2,
    0x3,
    0x1,
    0x2,
    0x2,
    0x5,
    0x1,
    0xa,
    0x1,
    0x4,
    0x6,
    0x0,
    0x0,
    0x2,
    0x1,
    0x0,
    0x0,
    0x1,
    0x3,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0xe,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0x3,
    0x0,
    0x0,
    0x2,
    0x2,
    0x8,
    0x0,
    0x2,
    0xe,
    0x3,
    0x0,
    0x2,
    0x0,
    0x0,
    0x3,
    0x0,
    0x1,
    0x7,
    0x0,
    0xd,
    0x7,
    0x1,
    0x2,
    0x2,
    0x0,
    0x1,
    0x3,
    0x1,
    0x2,
    0x1,
    0x9,
    0x4,
    0x3,
    0x1,
    0x2,
    0x5,
    0x0,
    0x0,
    0x4,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x4,
    0x0,
    0x1,
    0x8,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x0,
    0x3,
    0x0,
    0x2,
    0x0,
    0x2,
    0xc,
    0x0,
    0x3,
    0x9,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x3,
    0x2,
    0x9,
    0x1,
    0x0,
    0x2,
    0x1,
    0x0,
    0x1,
    0xb,
    0x0,
    0x7,
    0x1,
    0x2,
    0x1,
    0x0,
    0x0,
    0xd,
    0x1,
    0x0,
    0x3,
    0x1,
    0x0,
    0x2,
    0x0,
    0x1,
    0x1,
    0x2,
    0x2,
    0x3,
    0x2,
    0x1,
    0x1,
    0x2,
    0x3,
    0x2,
    0x2,
    0x0,
    0x9,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x0,
    0x4,
    0x1,
    0x1,
    0x1,
    0x0,
    0x5,
    0x8,
    0x2,
    0x2,
    0x0,
    0x0,
    0x0,
    0x1,
    0x2,
    0x1,
    0x4,
    0x4,
    0x3,
    0x1,
    0x4,
    0x8,
    0x2,
    0x1,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x1,
    0x0,
    0x4,
    0x0,
    0x0,
    0x1,
    0x0,
    0x1,
    0x3,
    0x0,
    0x2,
    0x5,
    0x0,
    0x5,
    0x3,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x2,
    0x3,
    0x0,
    0x2,
    0x0,
    0x1,
    0x1,
    0x3,
    0x0,
    0x2,
    0x2,
    0x1,
    0x0,
    0x2,
    0x4,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x2,
    0x1,
    0xb,
    0x0,
    0x4,
    0x1,
    0x1,
    0x1,
    0x0,
    0x2,
    0x1,
    0x1,
    0x3,
    0x0,
    0x0,
    0x2,
    0x1,
    0x3,
    0x7,
    0x1,
    0x3,
    0x1,
    0x0,
    0x9,
    0x3,
    0x0,
    0x2,
    0x0,
    0x1,
    0x3,
    0x0,
    0x0,
    0x0,
    0x3,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0xd,
    0x3,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x8,
    0x1,
    0x0,
    0x1,
    0x8,
    0x6,
    0x0,
    0x1,
    0x2,
    0x1,
    0x1,
    0x0,
    0x2,
    0x0,
    0x0,
    0x5,
    0x0,
    0x1,
    0x4,
    0x0,
    0x1,
    0x1,
    0x0,
    0x4,
    0x0,
    0x1,
    0x4,
    0x5,
    0x2,
    0x1,
    0x5,
    0x0,
    0x0,
    0x0,
    0x0,
    0x6,
    0x2,
    0xa,
    0x2,
    0x1,
    0x4,
    0x6,
    0x6,
    0x2,
    0x1,
    0x1,
    0x0,
    0x4,
    0x1,
    0x2,
    0x0,
    0x8,
    0x1,
    0x1,
    0x2,
    0x3,
    0x0,
    0x3,
    0x4,
    0x0,
    0x1,
    0x1,
    0x3,
    0x1,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0x1,
    0x1,
    0x1,
    0x0,
    0x0,
    0x2,
    0x1,
    0x4,
    0x2,
    0x3,
    0x4,
    0x2,
    0x0,
    0x1,
    0x2,
    0x1,
    0x1,
    0x2,
    0x1,
    0x1,
    0x1,
    0x0,
    0x0,
    0x8,
    0x4,
    0x0,
    0x4,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x5,
    0x0,
    0x1,
    0x1,
    0x4,
    0x2,
    0xa,
    0x5,
    0x0,
    0x0,
    0x1,
    0x1,
    0x1,
    0x1,
    0x0,
    0x0,
    0x2,
    0x2,
    0x2,
    0x2,
    0x1,
    0x1,
    0x4,
    0x1,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x6,
    0x0,
    0x1,
    0x1,
    0x4,
    0x1,
    0x2,
    0x1,
    0x0,
    0x2,
    0x0,
    0x3,
    0x3,
    0x7,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x5,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x2,
    0x0,
    0x1,
    0x2,
    0x4,
    0x1,
    0x1,
    0x6,
    0x3,
    0x0,
    0x0,
    0x2,
    0x2,
    0x4,
    0x0,
    0x2,
    0x1,
    0x3,
    0x2,
    0x4,
    0x1,
    0x2,
    0x2,
    0x0,
    0x0,
    0x0,
    0x7,
    0x2,
    0x3,
    0x0,
    0x0,
    0x2,
    0x4,
    0x0,
    0x1,
    0x0,
    0x0,
    0xb,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x4,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x1,
    0x5,
    0x1,
    0x2,
    0x2,
    0x1,
    0x1,
    0x0,
    0x0,
    0x1,
    0x0,
    0x3,
    0x3,
    0x6,
    0x2,
    0x0,
    0x4,
    0x3,
    0x1,
    0x4,
    0x0,
    0x4,
    0x4,
    0x1,
    0x0,
    0x2,
    0x1,
    0x1,
    0x1,
    0x4,
    0x0,
    0x2,
    0x1,
    0x0,
    0x0,
    0x0,
    0x2,
    0x2,
    0x0,
    0x1,
    0x0,
    0x6,
    0x0,
    0x0,
    0x1,
    0x1,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x2,
    0x1,
    0x1,
    0x0,
    0x0,
    0x5,
    0x6,
    0x2,
    0x0,
    0x5,
    0x0,
    0x1,
    0x2,
    0x2,
    0x5,
    0x1,
    0x1,
    0x2,
    0x0,
    0x1,
    0x2,
    0x1,
    0x1,
    0x4,
    0x1,
    0x1,
    0x1,
    0x2,
    0x3,
    0x2,
    0x5,
    0x3,
    0x0,
    0x0,
    0x0,
    0x1,
    0x1,
    0x3,
    0x0,
    0x1,
    0x0,
    0x1,
    0x1,
    0x0,
    0x3,
    0x4,
];
pub(crate) const CANONICAL_DECOMPOSED_KV: &[(u32, &'static [char])] = &[
    (0xfa08, &['\u{884C}']),
    (0x2f869, &['\u{5B08}']),
    (0x2247, &['\u{2245}', '\u{0338}']),
    (0x1f2e, &['\u{0397}', '\u{0313}', '\u{0342}']),
    (0x2000, &['\u{2002}']),
    (0x1e3c, &['\u{004C}', '\u{032D}']),
    (0x164, &['\u{0054}', '\u{030C}']),
    (0x2f95b, &['\u{7A4F}']),
    (0xf965, &['\u{4FBF}']),
    (0x1f3d, &['\u{0399}', '\u{0314}', '\u{0301}']),
    (0x2f83a, &['\u{53F1}']),
    (0x95b, &['\u{091C}', '\u{093C}']),
    (0x1faf, &['\u{03A9}', '\u{0314}', '\u{0342}', '\u{0345}']),
    (0x1f0c, &['\u{0391}', '\u{0313}', '\u{0301}']),
    (0xf916, &['\u{70D9}']),
    (0x4df, &['\u{0437}', '\u{0308}']),
    (0x1e2, &['\u{00C6}', '\u{0304}']),
    (0x229, &['\u{0065}', '\u{0327}']),
    (0xcc, &['\u{0049}', '\u{0300}']),
    (0xfa66, &['\u{8FB6}']),
    (0x1f39, &['\u{0399}', '\u{0314}']),
    (0x1e7a, &['\u{0055}', '\u{0304}', '\u{0308}']),
    (0x1f6c, &['\u{03A9}', '\u{0313}', '\u{0301}']),
    (0x2f9ef, &['\u{4995}']),
    (0x2f8ce, &['\u{3B19}']),
    (0xf970, &['\u{6BBA}']),
    (0x211, &['\u{0072}', '\u{030F}']),
    (0xfa17, &['\u{76CA}']),
    (0xfa95, &['\u{6B79}']),
    (0xf974, &['\u{82E5}']),
    (0x1ea9, &['\u{0061}', '\u{0302}', '\u{0309}']),
    (0x4ec, &['\u{042D}', '\u{0308}']),
    (0x2f833, &['\u{537F}']),
    (0x231, &['\u{006F}', '\u{0307}', '\u{0304}']),
    (0xf96c, &['\u{585E}']),
    (0xfa5e, &['\u{8279}']),
    (0x1ee7, &['\u{0075}', '\u{0309}']),
    (0x1e72, &['\u{0055}', '\u{0324}']),
    (0x2f914, &['\u{701E}']),
    (0x1f64, &['\u{03C9}', '\u{0313}', '\u{0301}']),
    (0x343, &['\u{0313}']),
    (0x16c, &['\u{0055}', '\u{0306}']),
    (0xf94c, &['\u{6A13}']),
    (0x2f925, &['\u{7295}']),
    (0xf92f, &['\u{52DE}']),
    (0x1ff8, &['\u{039F}', '\u{0300}']),
    (0xf73, &['\u{0F71}', '\u{0F72}']),
    (0x1e15, &['\u{0065}', '\u{0304}', '\u{0300}']),
    (0xf930, &['\u{64C4}']),
    (0xf9ca, &['\u{6D41}']),
    (0x1f3b, &['\u{0399}', '\u{0314}', '\u{0300}']),
    (0x1fa2, &['\u{03C9}', '\u{0313}', '\u{0300}', '\u{0345}']),
    (0x2f9f6, &['\u{29145}']),
    (0x1fc2, &['\u{03B7}', '\u{0300}', '\u{0345}']),
    (0x2f8c7, &['\u{3A6C}']),
    (0xfabc, &['\u{8B01}']),
    (0xfa3f, &['\u{618E}']),
    (0x2f9b9, &['\u{870E}']),
    (0x1e73, &['\u{0075}', '\u{0324}']),
    (0xfa9d, &['\u{77A7}']),
    (0x2f952, &['\u{25626}']),
    (0xfa5f, &['\u{8457}']),
    (0x3060, &['\u{305F}', '\u{3099}']),
    (0x2f849, &['\u{55B3}']),
    (0x13e, &['\u{006C}', '\u{030C}']),
    (0xf99c, &['\u{5217}']),
    (0x129, &['\u{0069}', '\u{0303}']),
    (0xfa63, &['\u{8B39}']),
    (0x2f8c0, &['\u{63C5}']),
    (0x1e93, &['\u{007A}', '\u{0323}']),
    (0x2fa15, &['\u{9EBB}']),
    (0xfb43, &['\u{05E3}', '\u{05BC}']),
    (0x2f9d6, &['\u{8D1B}']),
    (0xfa50, &['\u{7956}']),
    (0xf9ab, &['\u{5DBA}']),
    (0x2fa02, &['\u{98E2}']),
    (0x16d, &['\u{0075}', '\u{0306}']),
    (0x21b, &['\u{0074}', '\u{0326}']),
    (0x1ea8, &['\u{0041}', '\u{0302}', '\u{0309}']),
    (0x1e64, &['\u{0053}', '\u{0301}', '\u{0307}']),
    (0xfa94, &['\u{6756}']),
    (0x1f1a, &['\u{0395}', '\u{0313}', '\u{0300}']),
    (0x22eb, &['\u{22B3}', '\u{0338}']),
    (0x3073, &['\u{3072}', '\u{3099}']),
    (0xfad7, &['\u{27ED3}']),
    (0xf93d, &['\u{7DA0}']),
    (0xf9e0, &['\u{6613}']),
    (0x2f870, &['\u{5BF3}']),
    (0xdde, &['\u{0DD9}', '\u{0DDF}']),
    (0x1fa9, &['\u{03A9}', '\u{0314}', '\u{0345}']),
    (0xfa2f, &['\u{96B7}']),
    (0xf90a, &['\u{91D1}']),
    (0xf937, &['\u{8DEF}']),
    (0x2f842, &['\u{5510}']),
    (0x307d, &['\u{307B}', '\u{309A}']),
    (0x1ef0, &['\u{0055}', '\u{031B}', '\u{0323}']),
    (0x1eb8, &['\u{0045}', '\u{0323}']),
    (0x1e6c, &['\u{0054}', '\u{0323}']),
    (0xfaca, &['\u{97FF}']),
    (0xf97b, &['\u{7CE7}']),
    (0x2f9fd, &['\u{29496}']),
    (0x2f86e, &['\u{5BD8}']),
    (0x2f817, &['\u{5197}']),
    (0xf93b, &['\u{788C}']),
    (0x1fa, &['\u{0041}', '\u{030A}', '\u{0301}']),
    (0x115ba, &['\u{115B8}', '\u{115AF}']),
    (0x1f73, &['\u{03B5}', '\u{0301}']),
    (0xa5a, &['\u{0A17}', '\u{0A3C}']),
    (0x1ede, &['\u{004F}', '\u{031B}', '\u{0309}']),
    (0x2f8f6, &['\u{6BBB}']),
    (0xf928, &['\u{5ECA}']),
    (0x1fd0, &['\u{03B9}', '\u{0306}']),
    (0xf975, &['\u{63A0}']),
    (0x125, &['\u{0068}', '\u{0302}']),
    (0x1e2e, &['\u{0049}', '\u{0308}', '\u{0301}']),
    (0x387, &['\u{00B7}']),
    (0x1d162, &['\u{1D158}', '\u{1D165}', '\u{1D170}']),
    (0x2289, &['\u{2287}', '\u{0338}']),
    (0x2270, &['\u{2264}', '\u{0338}']),
    (0x1f1c, &['\u{0395}', '\u{0313}', '\u{0301}']),
    (0xfb4a, &['\u{05EA}', '\u{05BC}']),
    (0x1e24, &['\u{0048}', '\u{0323}']),
    (0x2f824, &['\u{3515}']),
    (0xf907, &['\u{9F9C}']),
    (0x2f857, &['\u{5831}']),
    (0x1e0d, &['\u{0064}', '\u{0323}']),
    (0x1f4a, &['\u{039F}', '\u{0313}', '\u{0300}']),
    (0xf9f9, &['\u{7C92}']),
    (0xf94b, &['\u{5C62}']),
    (0x1e51, &['\u{006F}', '\u{0304}', '\u{0300}']),
    (0x4f2, &['\u{0423}', '\u{030B}']),
    (0x1e36, &['\u{004C}', '\u{0323}']),
    (0x2f9b6, &['\u{8669}']),
    (0x4f4, &['\u{0427}', '\u{0308}']),
    (0x2f890, &['\u{5EFE}']),
    (0x2f97b, &['\u{264DA}']),
    (0x2f917, &['\u{704A}']),
    (0x38e, &['\u{03A5}', '\u{0301}']),
    (0xf9dd, &['\u{5229}']),
    (0x2f84f, &['\u{5674}']),
    (0x1f9a, &['\u{0397}', '\u{0313}', '\u{0300}', '\u{0345}']),
    (0x1d1bc, &['\u{1D1BA}', '\u{1D165}']),
    (0x21cf, &['\u{21D2}', '\u{0338}']),
    (0xf921, &['\u{5D50}']),
    (0x1ee5, &['\u{0075}', '\u{0323}']),
    (0x2f99f, &['\u{8457}']),
    (0xf9b5, &['\u{4F8B}']),
    (0xf9df, &['\u{5C65}']),
    (0x1eaf, &['\u{0061}', '\u{0306}', '\u{0301}']),
    (0x1e43, &['\u{006D}', '\u{0323}']),
    (0x2f975, &['\u{262D9}']),
    (0x1fb2, &['\u{03B1}', '\u{0300}', '\u{0345}']),
    (0x1e22, &['\u{0048}', '\u{0307}']),
    (0x1eea, &['\u{0055}', '\u{031B}', '\u{0300}']),
    (0x1ef4, &['\u{0059}', '\u{0323}']),
    (0x1f75, &['\u{03B7}', '\u{0301}']),
    (0x1d4, &['\u{0075}', '\u{030C}']),
    (0xa33, &['\u{0A32}', '\u{0A3C}']),
    (0x1e08, &['\u{0043}', '\u{0327}', '\u{0301}']),
    (0xf75, &['\u{0F71}', '\u{0F74}']),
    (0x2f892, &['\u{22331}']),
    (0x1e1b, &['\u{0065}', '\u{0330}']),
    (0x11d, &['\u{0067}', '\u{0302}']),
    (0x2f8fa, &['\u{6C4E}']),
    (0xfb36, &['\u{05D6}', '\u{05BC}']),
    (0xf957, &['\u{7DBE}']),
    (0x2f828, &['\u{52FA}']),
    (0x1e4a, &['\u{004E}', '\u{032D}']),
    (0xfa4d, &['\u{7949}']),
    (0x122, &['\u{0047}', '\u{0327}']),
    (0xf9f8, &['\u{7B20}']),
    (0x2f8e1, &['\u{6852}']),
    (0x1b41, &['\u{1B3F}', '\u{1B35}']),
    (0x2f8e7, &['\u{3B9D}']),
    (0x12a, &['\u{0049}', '\u{0304}']),
    (0x2f9a0, &['\u{8353}']),
    (0xf9a9, &['\u{56F9}']),
    (0xfabd, &['\u{8AFE}']),
    (0xf9eb, &['\u{533F}']),
    (0xfaa2, &['\u{7506}']),
    (0xfa76, &['\u{52C7}']),
    (0xf973, &['\u{62FE}']),
    (0x1e42, &['\u{004D}', '\u{0323}']),
    (0x114, &['\u{0045}', '\u{0306}']),
    (0x1fa8, &['\u{03A9}', '\u{0313}', '\u{0345}']),
    (0xf93, &['\u{0F92}', '\u{0FB7}']),
    (0xfad9, &['\u{9F8E}']),
    (0x2f9cd, &['\u{46BE}']),
    (0x1e58, &['\u{0052}', '\u{0307}']),
    (0x2f9d0, &['\u{8AED}']),
    (0xfa8f, &['\u{6452}']),
    (0xf952, &['\u{52D2}']),
    (0xfa6d, &['\u{8218}']),
    (0xfb48, &['\u{05E8}', '\u{05BC}']),
    (0x2f812, &['\u{2051C}']),
    (0x205, &['\u{0065}', '\u{030F}']),
    (0x2f8b3, &['\u{621B}']),
    (0xa5e, &['\u{0A2B}', '\u{0A3C}']),
    (0x1e82, &['\u{0057}', '\u{0301}']),
    (0xf991, &['\u{649A}']),
    (0x2f839, &['\u{53EB}']),
    (0x1e88, &['\u{0057}', '\u{0323}']),
    (0xfab8, &['\u{8996}']),
    (0x1ec, &['\u{004F}', '\u{0328}', '\u{0304}']),
    (0x1eeb, &['\u{0075}', '\u{031B}', '\u{0300}']),
    (0xf9d9, &['\u{6144}']),
    (0x1fc9, &['\u{0395}', '\u{0301}']),
    (0x2f94e, &['\u{784E}']),
    (0xfa45, &['\u{6D77}']),
    (0x1f06, &['\u{03B1}', '\u{0313}', '\u{0342}']),
    (0x2f90d, &['\u{23ED1}']),
    (0xbcc, &['\u{0BC6}', '\u{0BD7}']),
    (0x1fe4, &['\u{03C1}', '\u{0313}']),
    (0xfac3, &['\u{9072}']),
    (0x1f27, &['\u{03B7}', '\u{0314}', '\u{0342}']),
    (0xf909, &['\u{5951}']),
    (0xcb, &['\u{0045}', '\u{0308}']),
    (0x1f51, &['\u{03C5}', '\u{0314}']),
    (0xfa99, &['\u{6ECB}']),
    (0x143, &['\u{004E}', '\u{0301}']),
    (0x2f90f, &['\u{6F6E}']),
    (0xf988, &['\u{9E97}']),
    (0x2f959, &['\u{7A40}']),
    (0xf978, &['\u{5169}']),
    (0x1e8e, &['\u{0059}', '\u{0307}']),
    (0x109, &['\u{0063}', '\u{0302}']),
    (0x1e06, &['\u{0042}', '\u{0331}']),
    (0x2f81e, &['\u{5203}']),
    (0x1eb2, &['\u{0041}', '\u{0306}', '\u{0309}']),
    (0x1ecf, &['\u{006F}', '\u{0309}']),
    (0x1e10, &['\u{0044}', '\u{0327}']),
    (0x1e48, &['\u{004E}', '\u{0331}']),
    (0x2f8dd, &['\u{233C3}']),
    (0x1e1d, &['\u{0065}', '\u{0327}', '\u{0306}']),
    (0xfacf, &['\u{2284A}']),
    (0x2f9a8, &['\u{84F1}']),
    (0x2f875, &['\u{5C22}']),
    (0xf9fa, &['\u{72C0}']),
    (0x304c, &['\u{304B}', '\u{3099}']),
    (0x2f94d, &['\u{2541D}']),
    (0xf9c3, &['\u{907C}']),
    (0x2f9c4, &['\u{8863}']),
    (0xfa36, &['\u{559D}']),
    (0x2f9a3, &['\u{83DC}']),
    (0x2f984, &['\u{440B}']),
    (0x1134b, &['\u{11347}', '\u{1133E}']),
    (0x1f5d, &['\u{03A5}', '\u{0314}', '\u{0301}']),
    (0x2f9ab, &['\u{273CA}']),
    (0x2f8f1, &['\u{6B54}']),
    (0x1ec1, &['\u{0065}', '\u{0302}', '\u{0300}']),
    (0xf9b8, &['\u{96B8}']),
    (0x400, &['\u{0415}', '\u{0300}']),
    (0x1edf, &['\u{006F}', '\u{031B}', '\u{0309}']),
    (0x1f84, &['\u{03B1}', '\u{0313}', '\u{0301}', '\u{0345}']),
    (0x934, &['\u{0933}', '\u{093C}']),
    (0x2f98a, &['\u{2339C}']),
    (0x2278, &['\u{2276}', '\u{0338}']),
    (0x1e21, &['\u{0067}', '\u{0304}']),
    (0x2271, &['\u{2265}', '\u{0338}']),
    (0x1ffb, &['\u{03A9}', '\u{0301}']),
    (0x30bc, &['\u{30BB}', '\u{3099}']),
    (0x2fa03, &['\u{4B33}']),
    (0x1f05, &['\u{03B1}', '\u{0314}', '\u{0301}']),
    (0x1ee4, &['\u{0055}', '\u{0323}']),
    (0x2f8a2, &['\u{391C}']),
    (0xf90c, &['\u{5948}']),
    (0xfaa1, &['\u{7471}']),
    (0x16b, &['\u{0075}', '\u{0304}']),
    (0x1d1bd, &['\u{1D1B9}', '\u{1D165}', '\u{1D16E}']),
    (0xf969, &['\u{6578}']),
    (0x2f911, &['\u{23F8E}']),
    (0x2f873, &['\u{5C06}']),
    (0x2f965, &['\u{25C80}']),
    (0xcd, &['\u{0049}', '\u{0301}']),
    (0x2f835, &['\u{7070}']),
    (0xf902, &['\u{8ECA}']),
    (0x1f32, &['\u{03B9}', '\u{0313}', '\u{0300}']),
    (0x1f56, &['\u{03C5}', '\u{0313}', '\u{0342}']),
    (0x2f8f8, &['\u{21D0B}']),
    (0xf9c5, &['\u{6688}']),
    (0x1ec7, &['\u{0065}', '\u{0323}', '\u{0302}']),
    (0xf97e, &['\u{91CF}']),
    (0xfb4e, &['\u{05E4}', '\u{05BF}']),
    (0xf90f, &['\u{7F85}']),
    (0x623, &['\u{0627}', '\u{0654}']),
    (0x2f8cc, &['\u{66F8}']),
    (0x2f82e, &['\u{535A}']),
    (0x161, &['\u{0073}', '\u{030C}']),
    (0x2f972, &['\u{26228}']),
    (0x1f13, &['\u{03B5}', '\u{0314}', '\u{0300}']),
    (0xf996, &['\u{7DF4}']),
    (0x388, &['\u{0395}', '\u{0301}']),
    (0xf9a6, &['\u{7C3E}']),
    (0x3074, &['\u{3072}', '\u{309A}']),
    (0x1d5, &['\u{0055}', '\u{0308}', '\u{0304}']),
    (0x1eac, &['\u{0041}', '\u{0323}', '\u{0302}']),
    (0x2274, &['\u{2272}', '\u{0338}']),
    (0x1fdb, &['\u{0399}', '\u{0301}']),
    (0x3071, &['\u{306F}', '\u{309A}']),
    (0x1f9e, &['\u{0397}', '\u{0313}', '\u{0342}', '\u{0345}']),
    (0x1f6b, &['\u{03A9}', '\u{0314}', '\u{0300}']),
    (0x2f988, &['\u{267B5}']),
    (0x2f8a4, &['\u{226D4}']),
    (0xf948, &['\u{8CC2}']),
    (0xf9ed, &['\u{541D}']),
    (0xfaba, &['\u{8AF8}']),
    (0x1fcf, &['\u{1FBF}', '\u{0342}']),
    (0xe9, &['\u{0065}', '\u{0301}']),
    (0x1f30, &['\u{03B9}', '\u{0313}']),
    (0x1f87, &['\u{03B1}', '\u{0314}', '\u{0342}', '\u{0345}']),
    (0xf968, &['\u{6CCC}']),
    (0x2f84b, &['\u{5716}']),
    (0xf9a5, &['\u{6BAE}']),
    (0x2f93d, &['\u{25044}']),
    (0x30b4, &['\u{30B3}', '\u{3099}']),
    (0xf9b9, &['\u{60E1}']),
    (0x1f36, &['\u{03B9}', '\u{0313}', '\u{0342}']),
    (0xff, &['\u{0079}', '\u{0308}']),
    (0x2fa12, &['\u{2A105}']),
    (0x1fbb, &['\u{0391}', '\u{0301}']),
    (0x2f920, &['\u{7228}']),
    (0xfa81, &['\u{5B28}']),
    (0x1b43, &['\u{1B42}', '\u{1B35}']),
    (0xf987, &['\u{9A6A}']),
    (0x4e6, &['\u{041E}', '\u{0308}']),
    (0x3af, &['\u{03B9}', '\u{0301}']),
    (0x2f96c, &['\u{7D63}']),
    (0x2f97d, &['\u{8060}']),
    (0x215, &['\u{0075}', '\u{030F}']),
    (0xfb4c, &['\u{05D1}', '\u{05BF}']),
    (0xf98c, &['\u{6B77}']),
    (0xb48, &['\u{0B47}', '\u{0B56}']),
    (0x2f885, &['\u{5E28}']),
    (0xfa79, &['\u{5555}']),
    (0x1e87, &['\u{0077}', '\u{0307}']),
    (0x2f971, &['\u{4334}']),
    (0x45e, &['\u{0443}', '\u{0306}']),
    (0x2f92c, &['\u{3EB8}']),
    (0xfab3, &['\u{8352}']),
    (0x30c5, &['\u{30C4}', '\u{3099}']),
    (0x1f10, &['\u{03B5}', '\u{0313}']),
    (0xfa86, &['\u{60D8}']),
    (0x1e7, &['\u{0067}', '\u{030C}']),
    (0x2f8a1, &['\u{393A}']),
    (0xfa5a, &['\u{7F72}']),
    (0x1fce, &['\u{1FBF}', '\u{0301}']),
    (0x232a, &['\u{3009}']),
    (0x2f964, &['\u{4227}']),
    (0xf933, &['\u{76E7}']),
    (0x2f938, &['\u{7570}']),
    (0x2f872, &['\u{5BFF}']),
    (0x1f50, &['\u{03C5}', '\u{0313}']),
    (0x2fa0b, &['\u{9C40}']),
    (0xfb1d, &['\u{05D9}', '\u{05B4}']),
    (0x3aa, &['\u{0399}', '\u{0308}']),
    (0xf981, &['\u{5973}']),
    (0x2f8e2, &['\u{6885}']),
    (0x1ebd, &['\u{0065}', '\u{0303}']),
    (0x1e0b, &['\u{0064}', '\u{0307}']),
    (0xfb3a, &['\u{05DA}', '\u{05BC}']),
    (0x1e62, &['\u{0053}', '\u{0323}']),
    (0x2f85d, &['\u{591A}']),
    (0xfa4e, &['\u{7948}']),
    (0x1f22, &['\u{03B7}', '\u{0313}', '\u{0300}']),
    (0x2fa16, &['\u{4D56}']),
    (0x2f855, &['\u{578B}']),
    (0x2f98f, &['\u{8291}']),
    (0x2f9f3, &['\u{96C3}']),
    (0x1f6f, &['\u{03A9}', '\u{0314}', '\u{0342}']),
    (0x1e7f, &['\u{0076}', '\u{0323}']),
    (0x2f8d1, &['\u{3AE4}']),
    (0xfa9f, &['\u{72AF}']),
    (0x1f0, &['\u{006A}', '\u{030C}']),
    (0x1ea4, &['\u{0041}', '\u{0302}', '\u{0301}']),
    (0x14c, &['\u{004F}', '\u{0304}']),
    (0x1ea6, &['\u{0041}', '\u{0302}', '\u{0300}']),
    (0x2f9c9, &['\u{88FA}']),
    (0x1f92, &['\u{03B7}', '\u{0313}', '\u{0300}', '\u{0345}']),
    (0x2f94f, &['\u{788C}']),
    (0xf963, &['\u{5317}']),
    (0xf905, &['\u{4E32}']),
    (0xfa8c, &['\u{6234}']),
    (0x2f8d0, &['\u{3B08}']),
    (0xfac0, &['\u{8B8A}']),
    (0x226e, &['\u{003C}', '\u{0338}']),
    (0x1fc6, &['\u{03B7}', '\u{0342}']),
    (0x1fb0, &['\u{03B1}', '\u{0306}']),
    (0xb94, &['\u{0B92}', '\u{0BD7}']),
    (0x2f93f, &['\u{4008}']),
    (0x2f810, &['\u{5164}']),
    (0x4ef, &['\u{0443}', '\u{0304}']),
    (0x1fda, &['\u{0399}', '\u{0300}']),
    (0x2f864, &['\u{5A27}']),
    (0x145, &['\u{004E}', '\u{0327}']),
    (0x2f955, &['\u{256C5}']),
    (0x1fbc, &['\u{0391}', '\u{0345}']),
    (0xfab6, &['\u{8941}']),
    (0x1e60, &['\u{0053}', '\u{0307}']),
    (0x2f86a, &['\u{5B3E}']),
    (0xcca, &['\u{0CC6}', '\u{0CC2}']),
    (0xeb, &['\u{0065}', '\u{0308}']),
    (0x17b, &['\u{005A}', '\u{0307}']),
    (0x30ac, &['\u{30AB}', '\u{3099}']),
    (0x2f949, &['\u{4039}']),
    (0x214, &['\u{0055}', '\u{030F}']),
    (0x2f8d5, &['\u{669C}']),
    (0x2f825, &['\u{52C7}']),
    (0x2fa19, &['\u{9F05}']),
    (0x1e8, &['\u{004B}', '\u{030C}']),
    (0x22ed, &['\u{22B5}', '\u{0338}']),
    (0x2f83e, &['\u{5448}']),
    (0x2f9ce, &['\u{46C7}']),
    (0xf986, &['\u{95AD}']),
    (0x1fcb, &['\u{0397}', '\u{0301}']),
    (0x119, &['\u{0065}', '\u{0328}']),
    (0xe5, &['\u{0061}', '\u{030A}']),
    (0x4e4, &['\u{0418}', '\u{0308}']),
    (0x2f8be, &['\u{22BF1}']),
    (0x2f823, &['\u{5277}']),
    (0xfaa0, &['\u{732A}']),
    (0x2f8e6, &['\u{6914}']),
    (0x1f08, &['\u{0391}', '\u{0313}']),
    (0x2001, &['\u{2003}']),
    (0xf9cc, &['\u{7409}']),
    (0x2f88f, &['\u{2A392}']),
    (0x1f0d, &['\u{0391}', '\u{0314}', '\u{0301}']),
    (0x1e2c, &['\u{0049}', '\u{0330}']),
    (0xf926, &['\u{81D8}']),
    (0xfa51, &['\u{795D}']),
    (0xf9b0, &['\u{8046}']),
    (0x453, &['\u{0433}', '\u{0301}']),
    (0x1e74, &['\u{0055}', '\u{0330}']),
    (0x2f977, &['\u{2633E}']),
    (0x2f87f, &['\u{5D6B}']),
    (0x1e20, &['\u{0047}', '\u{0304}']),
    (0xf989, &['\u{9ECE}']),
    (0x176, &['\u{0059}', '\u{0302}']),
    (0x2f989, &['\u{23393}']),
    (0xfb34, &['\u{05D4}', '\u{05BC}']),
    (0x2fa10, &['\u{2A0CE}']),
    (0xf96e, &['\u{8449}']),
    (0x1fb9, &['\u{0391}', '\u{0304}']),
    (0x4de, &['\u{0417}', '\u{0308}']),
    (0x2fa0e, &['\u{4CED}']),
    (0xf964, &['\u{78FB}']),
    (0x2f87e, &['\u{5D6E}']),
    (0x4e7, &['\u{043E}', '\u{0308}']),
    (0x2f8fe, &['\u{6C67}']),
    (0x1d2, &['\u{006F}', '\u{030C}']),
    (0x1f41, &['\u{03BF}', '\u{0314}']),
    (0x1f77, &['\u{03B9}', '\u{0301}']),
    (0x1fa4, &['\u{03C9}', '\u{0313}', '\u{0301}', '\u{0345}']),
    (0xfa8d, &['\u{63C4}']),
    (0x1f8f, &['\u{0391}', '\u{0314}', '\u{0342}', '\u{0345}']),
    (0x2f997, &['\u{26B3C}']),
    (0x1eb, &['\u{006F}', '\u{0328}']),
    (0x1e4f, &['\u{006F}', '\u{0303}', '\u{0308}']),
    (0xf993, &['\u{7149}']),
    (0xfa9e, &['\u{7235}']),
    (0x1ebc, &['\u{0045}', '\u{0303}']),
    (0x2f8bf, &['\u{6422}']),
    (0xf9cb, &['\u{6E9C}']),
    (0x2f8d4, &['\u{6700}']),
    (0x2281, &['\u{227B}', '\u{0338}']),
    (0x1e0e, &['\u{0044}', '\u{0331}']),
    (0xf95d, &['\u{8AFE}']),
    (0x2f8a5, &['\u{60C7}']),
    (0x22f, &['\u{006F}', '\u{0307}']),
    (0x2f850, &['\u{5207}']),
    (0x2f826, &['\u{52C9}']),
    (0xf972, &['\u{6C88}']),
    (0x1e25, &['\u{0068}', '\u{0323}']),
    (0x4c2, &['\u{0436}', '\u{0306}']),
    (0x2f852, &['\u{57CE}']),
    (0x1d1bf, &['\u{1D1B9}', '\u{1D165}', '\u{1D16F}']),
    (0x390, &['\u{03B9}', '\u{0308}', '\u{0301}']),
    (0x40e, &['\u{0423}', '\u{0306}']),
    (0x419, &['\u{0418}', '\u{0306}']),
    (0x2f8e9, &['\u{69A3}']),
    (0xf959, &['\u{9675}']),
    (0x1f25, &['\u{03B7}', '\u{0314}', '\u{0301}']),
    (0xfa31, &['\u{50E7}']),
    (0x124, &['\u{0048}', '\u{0302}']),
    (0xfa34, &['\u{52E4}']),
    (0x2f967, &['\u{42A0}']),
    (0x1e9, &['\u{006B}', '\u{030C}']),
    (0x1f74, &['\u{03B7}', '\u{0300}']),
    (0x2f910, &['\u{23F5E}']),
    (0xfa8b, &['\u{61F2}']),
    (0x1ee3, &['\u{006F}', '\u{031B}', '\u{0323}']),
    (0x1e8c, &['\u{0058}', '\u{0308}']),
    (0x3ad, &['\u{03B5}', '\u{0301}']),
    (0xfa2c, &['\u{9928}']),
    (0x2f8b9, &['\u{633D}']),
    (0xf99b, &['\u{934A}']),
    (0xe8, &['\u{0065}', '\u{0300}']),
    (0x179, &['\u{005A}', '\u{0301}']),
    (0x2fa00, &['\u{9829}']),
    (0x2f94a, &['\u{778B}']),
    (0x1d15e, &['\u{1D157}', '\u{1D165}']),
    (0x114bc, &['\u{114B9}', '\u{114B0}']),
    (0x1fd, &['\u{00E6}', '\u{0301}']),
    (0x2f8c6, &['\u{6477}']),
    (0xf69, &['\u{0F40}', '\u{0FB5}']),
    (0x1d1bb, &['\u{1D1B9}', '\u{1D165}']),
    (0x10f, &['\u{0064}', '\u{030C}']),
    (0x1e63, &['\u{0073}', '\u{0323}']),
    (0x1fd3, &['\u{03B9}', '\u{0308}', '\u{0301}']),
    (0x1fb6, &['\u{03B1}', '\u{0342}']),
    (0x2f8cb, &['\u{65E3}']),
    (0x2f92b, &['\u{73A5}']),
    (0x2f9a9, &['\u{84F3}']),
    (0x386, &['\u{0391}', '\u{0301}']),
    (0x2f95f, &['\u{7AEE}']),
    (0x4d7, &['\u{0435}', '\u{0306}']),
    (0x1f53, &['\u{03C5}', '\u{0314}', '\u{0300}']),
    (0x1e17, &['\u{0065}', '\u{0304}', '\u{0301}']),
    (0x2f907, &['\u{6D34}']),
    (0x2f980, &['\u{2335F}']),
    (0xf94a, &['\u{58D8}']),
    (0x2f88e, &['\u{5ECA}']),
    (0xf917, &['\u{73DE}']),
    (0x2f88c, &['\u{5EB3}']),
    (0x1f09, &['\u{0391}', '\u{0314}']),
    (0x2f815, &['\u{518D}']),
    (0x2f9ca, &['\u{34BB}']),
    (0x307c, &['\u{307B}', '\u{3099}']),
    (0x2f9f9, &['\u{4A76}']),
    (0xfa01, &['\u{5EA6}']),
    (0x106, &['\u{0043}', '\u{0301}']),
    (0x1ebf, &['\u{0065}', '\u{0302}', '\u{0301}']),
    (0x1f38, &['\u{0399}', '\u{0313}']),
    (0x2f99c, &['\u{8323}']),
    (0x1fe8, &['\u{03A5}', '\u{0306}']),
    (0x1ef5, &['\u{0079}', '\u{0323}']),
    (0x2f82d, &['\u{5351}']),
    (0x1e00, &['\u{0041}', '\u{0325}']),
    (0x1edb, &['\u{006F}', '\u{031B}', '\u{0301}']),
    (0xfac2, &['\u{8F38}']),
    (0x22e0, &['\u{227C}', '\u{0338}']),
    (0x1f9d, &['\u{0397}', '\u{0314}', '\u{0301}', '\u{0345}']),
    (0x2f9af, &['\u{4561}']),
    (0x1fa3, &['\u{03C9}', '\u{0314}', '\u{0300}', '\u{0345}']),
    (0x1ed1, &['\u{006F}', '\u{0302}', '\u{0301}']),
    (0xf76, &['\u{0FB2}', '\u{0F80}']),
    (0x2f8e3, &['\u{2346D}']),
    (0x1fcc, &['\u{0397}', '\u{0345}']),
    (0x1f54, &['\u{03C5}', '\u{0313}', '\u{0301}']),
    (0xf98d, &['\u{8F62}']),
    (0x13c, &['\u{006C}', '\u{0327}']),
    (0x1f89, &['\u{0391}', '\u{0314}', '\u{0345}']),
    (0xfb35, &['\u{05D5}', '\u{05BC}']),
    (0x2f80e, &['\u{514D}']),
    (0x2f887, &['\u{5E69}']),
    (0xfa0a, &['\u{898B}']),
    (0x2f91b, &['\u{20525}']),
    (0x22e, &['\u{004F}', '\u{0307}']),
    (0x1eee, &['\u{0055}', '\u{031B}', '\u{0303}']),
    (0x15c, &['\u{0053}', '\u{0302}']),
    (0x2f8fb, &['\u{23CBC}']),
    (0xe3, &['\u{0061}', '\u{0303}']),
    (0x1f01, &['\u{03B1}', '\u{0314}']),
    (0x3079, &['\u{3078}', '\u{3099}']),
    (0x2f974, &['\u{4359}']),
    (0x2f882, &['\u{5DE2}']),
    (0x2f99b, &['\u{83AD}']),
    (0x220c, &['\u{220B}', '\u{0338}']),
    (0x1e75, &['\u{0075}', '\u{0330}']),
    (0xfa46, &['\u{6E1A}']),
    (0x2f922, &['\u{7250}']),
    (0x30ba, &['\u{30B9}', '\u{3099}']),
    (0xf9cd, &['\u{7559}']),
    (0x3058, &['\u{3057}', '\u{3099}']),
    (0xfa05, &['\u{6D1E}']),
    (0x2f9b2, &['\u{456B}']),
    (0xf9ac, &['\u{601C}']),
    (0xfa7e, &['\u{5944}']),
    (0x1f2d, &['\u{0397}', '\u{0314}', '\u{0301}']),
    (0x2f867, &['\u{36EE}']),
    (0x1f8c, &['\u{0391}', '\u{0313}', '\u{0301}', '\u{0345}']),
    (0xf97d, &['\u{8AD2}']),
    (0x1e76, &['\u{0055}', '\u{032D}']),
    (0x2f8f4, &['\u{6B9F}']),
    (0x2226, &['\u{2225}', '\u{0338}']),
    (0x1e7d, &['\u{0076}', '\u{0303}']),
    (0xfac8, &['\u{9756}']),
    (0x1a0, &['\u{004F}', '\u{031B}']),
    (0x2f802, &['\u{4E41}']),
    (0x1f8a, &['\u{0391}', '\u{0313}', '\u{0300}', '\u{0345}']),
    (0x1e13, &['\u{0064}', '\u{032D}']),
    (0xfa2b, &['\u{98FC}']),
    (0x2f8c5, &['\u{649D}']),
    (0x2f91f, &['\u{243AB}']),
    (0xfa73, &['\u{4F80}']),
    (0x14e, &['\u{004F}', '\u{0306}']),
    (0xf998, &['\u{8F26}']),
    (0xf94d, &['\u{6DDA}']),
    (0xfad5, &['\u{25249}']),
    (0xf92b, &['\u{72FC}']),
    (0x2f853, &['\u{57F4}']),
    (0x1e98, &['\u{0077}', '\u{030A}']),
    (0xfa8a, &['\u{6160}']),
    (0xfa69, &['\u{97FF}']),
    (0x230, &['\u{004F}', '\u{0307}', '\u{0304}']),
    (0x1fe3, &['\u{03C5}', '\u{0308}', '\u{0301}']),
    (0x1f12, &['\u{03B5}', '\u{0313}', '\u{0300}']),
    (0x2f9c7, &['\u{88DE}']),
    (0x2241, &['\u{223C}', '\u{0338}']),
    (0xfa10, &['\u{585A}']),
    (0xf9af, &['\u{7F9A}']),
    (0xfa80, &['\u{5A62}']),
    (0xf9e2, &['\u{68A8}']),
    (0x1fed, &['\u{00A8}', '\u{0300}']),
    (0x2f926, &['\u{24735}']),
    (0xce, &['\u{0049}', '\u{0302}']),
    (0x21f, &['\u{0068}', '\u{030C}']),
    (0xfa92, &['\u{6717}']),
    (0xfa65, &['\u{8D08}']),
    (0x1fba, &['\u{0391}', '\u{0300}']),
    (0xf9a0, &['\u{88C2}']),
    (0x1f03, &['\u{03B1}', '\u{0314}', '\u{0300}']),
    (0x1d15f, &['\u{1D158}', '\u{1D165}']),
    (0xfabe, &['\u{8AED}']),
    (0x2f841, &['\u{54F6}']),
    (0x1fb1, &['\u{03B1}', '\u{0304}']),
    (0x2f819, &['\u{4ECC}']),
    (0xf95e, &['\u{4E39}']),
    (0xf9f5, &['\u{6DCB}']),
    (0x1f14, &['\u{03B5}', '\u{0313}', '\u{0301}']),
    (0x17c, &['\u{007A}', '\u{0307}']),
    (0x1e39, &['\u{006C}', '\u{0323}', '\u{0304}']),
    (0x1ef7, &['\u{0079}', '\u{0309}']),
    (0xfad1, &['\u{233D5}']),
    (0x1f18, &['\u{0395}', '\u{0313}']),
    (0xf57, &['\u{0F56}', '\u{0FB7}']),
    (0x148, &['\u{006E}', '\u{030C}']),
    (0x2f9a4, &['\u{26C36}']),
    (0x157, &['\u{0072}', '\u{0327}']),
    (0x385, &['\u{00A8}', '\u{0301}']),
    (0x30f4, &['\u{30A6}', '\u{3099}']),
    (0xfa90, &['\u{6556}']),
    (0x2f947, &['\u{771F}']),
    (0xf979, &['\u{51C9}']),
    (0x1de, &['\u{0041}', '\u{0308}', '\u{0304}']),
    (0x212a, &['\u{004B}']),
    (0x2f9e4, &['\u{9111}']),
    (0x1e18, &['\u{0045}', '\u{032D}']),
    (0x2f8eb, &['\u{6AA8}']),
    (0x1fe1, &['\u{03C5}', '\u{0304}']),
    (0x2f9ea, &['\u{927C}']),
    (0x228, &['\u{0045}', '\u{0327}']),
    (0x11b, &['\u{0065}', '\u{030C}']),
    (0x1f6d, &['\u{03A9}', '\u{0314}', '\u{0301}']),
    (0x11f, &['\u{0067}', '\u{0306}']),
    (0x2f93c, &['\u{24FB8}']),
    (0x2f94b, &['\u{4046}']),
    (0x1ed, &['\u{006F}', '\u{0328}', '\u{0304}']),
    (0xea, &['\u{0065}', '\u{0302}']),
    (0x38c, &['\u{039F}', '\u{0301}']),
    (0xfa0c, &['\u{5140}']),
    (0x154, &['\u{0052}', '\u{0301}']),
    (0x1f23, &['\u{03B7}', '\u{0314}', '\u{0300}']),
    (0x1f9c, &['\u{0397}', '\u{0313}', '\u{0301}', '\u{0345}']),
    (0x1f7c, &['\u{03C9}', '\u{0300}']),
    (0x1fa1, &['\u{03C9}', '\u{0314}', '\u{0345}']),
    (0x1e41, &['\u{006D}', '\u{0307}']),
    (0x2f8ed, &['\u{6ADB}']),
    (0x2f981, &['\u{43D5}']),
    (0x171, &['\u{0075}', '\u{030B}']),
    (0x1e16, &['\u{0045}', '\u{0304}', '\u{0301}']),
    (0x120, &['\u{0047}', '\u{0307}']),
    (0x1fcd, &['\u{1FBF}', '\u{0300}']),
    (0x2f915, &['\u{701B}']),
    (0xf935, &['\u{8606}']),
    (0x2f9b0, &['\u{26FB1}']),
    (0x2f937, &['\u{24C92}']),
    (0xf932, &['\u{7210}']),
    (0x219b, &['\u{2192}', '\u{0338}']),
    (0x2f86d, &['\u{5BC3}']),
    (0x151, &['\u{006F}', '\u{030B}']),
    (0x1e40, &['\u{004D}', '\u{0307}']),
    (0x135, &['\u{006A}', '\u{0302}']),
    (0x1ed7, &['\u{006F}', '\u{0302}', '\u{0303}']),
    (0x4e5, &['\u{0438}', '\u{0308}']),
    (0x1026, &['\u{1025}', '\u{102E}']),
    (0x2f84d, &['\u{5717}']),
    (0xfa3b, &['\u{5C64}']),
    (0x1f34, &['\u{03B9}', '\u{0313}', '\u{0301}']),
    (0x2f88d, &['\u{5EB6}']),
    (0x2f9cc, &['\u{27966}']),
    (0x2f906, &['\u{23D1E}']),
    (0xfa98, &['\u{6EDB}']),
    (0x2f901, &['\u{6D77}']),
    (0x304e, &['\u{304D}', '\u{3099}']),
    (0x1e96, &['\u{0068}', '\u{0331}']),
    (0xfa60, &['\u{8910}']),
    (0xfa62, &['\u{8B01}']),
    (0x2f8c3, &['\u{6469}']),
    (0x113, &['\u{0065}', '\u{0304}']),
    (0x1eca, &['\u{0049}', '\u{0323}']),
    (0x1e85, &['\u{0077}', '\u{0308}']),
    (0x2f99a, &['\u{8363}']),
    (0x15f, &['\u{0073}', '\u{0327}']),
    (0x2f8f7, &['\u{23A8D}']),
    (0x2fa13, &['\u{2A20E}']),
    (0x1e0c, &['\u{0044}', '\u{0323}']),
    (0xf1, &['\u{006E}', '\u{0303}']),
    (0x2f94c, &['\u{4096}']),
    (0xf919, &['\u{916A}']),
    (0x1eba, &['\u{0045}', '\u{0309}']),
    (0xfb32, &['\u{05D2}', '\u{05BC}']),
    (0x1ea2, &['\u{0041}', '\u{0309}']),
    (0xfa6b, &['\u{6075}']),
    (0xfa1c, &['\u{9756}']),
    (0x2f821, &['\u{5246}']),
    (0x1dc, &['\u{0075}', '\u{0308}', '\u{0300}']),
    (0xf9b2, &['\u{96F6}']),
    (0xf94e, &['\u{6F0F}']),
    (0x2f929, &['\u{738B}']),
    (0x1f0b, &['\u{0391}', '\u{0314}', '\u{0300}']),
    (0x305e, &['\u{305D}', '\u{3099}']),
    (0x1e78, &['\u{0055}', '\u{0303}', '\u{0301}']),
    (0x1b3b, &['\u{1B3A}', '\u{1B35}']),
    (0x175, &['\u{0077}', '\u{0302}']),
    (0x11c, &['\u{0047}', '\u{0302}']),
    (0x2f982, &['\u{80B2}']),
    (0xf945, &['\u{807E}']),
    (0x2f973, &['\u{26247}']),
    (0xfa3a, &['\u{58A8}']),
    (0x3cd, &['\u{03C5}', '\u{0301}']),
    (0x2f9d5, &['\u{8CC1}']),
    (0xf967, &['\u{4E0D}']),
    (0x1b0e, &['\u{1B0D}', '\u{1B35}']),
    (0xfad3, &['\u{4018}']),
    (0x2f836, &['\u{53CA}']),
    (0xf92d, &['\u{4F86}']),
    (0x1f4b, &['\u{039F}', '\u{0314}', '\u{0300}']),
    (0xfa49, &['\u{722B}']),
    (0xfa89, &['\u{618E}']),
    (0xf9a8, &['\u{4EE4}']),
    (0xf91d, &['\u{6B04}']),
    (0x2f803, &['\u{20122}']),
    (0x1e27, &['\u{0068}', '\u{0308}']),
    (0xf938, &['\u{9732}']),
    (0xfa9c, &['\u{716E}']),
    (0x2f919, &['\u{7077}']),
    (0x1ed5, &['\u{006F}', '\u{0302}', '\u{0309}']),
    (0x2f843, &['\u{5553}']),
    (0xf985, &['\u{792A}']),
    (0xf97c, &['\u{826F}']),
    (0x2f8ba, &['\u{62FC}']),
    (0x147, &['\u{004E}', '\u{030C}']),
    (0x2f9ba, &['\u{86E2}']),
    (0x1ef8, &['\u{0059}', '\u{0303}']),
    (0x1e8a, &['\u{0058}', '\u{0307}']),
    (0x1f5b, &['\u{03A5}', '\u{0314}', '\u{0300}']),
    (0x2f950, &['\u{78CC}']),
    (0x177, &['\u{0079}', '\u{0302}']),
    (0xfa6c, &['\u{242EE}']),
    (0xe2, &['\u{0061}', '\u{0302}']),
    (0x1e89, &['\u{0077}', '\u{0323}']),
    (0xfa74, &['\u{5145}']),
    (0x1f59, &['\u{03A5}', '\u{0314}']),
    (0x30d7, &['\u{30D5}', '\u{309A}']),
    (0xfa70, &['\u{4E26}']),
    (0xfb41, &['\u{05E1}', '\u{05BC}']),
    (0x2f879, &['\u{5CC0}']),
    (0x2f8b7, &['\u{6350}']),
    (0xf9db, &['\u{7387}']),
    (0x624, &['\u{0648}', '\u{0654}']),
    (0xf900, &['\u{8C48}']),
    (0x16f, &['\u{0075}', '\u{030A}']),
    (0x1f97, &['\u{03B7}', '\u{0314}', '\u{0342}', '\u{0345}']),
    (0x2f931, &['\u{7485}']),
    (0x2f956, &['\u{798F}']),
    (0xf91e, &['\u{721B}']),
    (0x2f9aa, &['\u{8516}']),
    (0x1af, &['\u{0055}', '\u{031B}']),
    (0xfb2c, &['\u{05E9}', '\u{05BC}', '\u{05C1}']),
    (0x1e66, &['\u{0053}', '\u{030C}', '\u{0307}']),
    (0x2f903, &['\u{6D69}']),
    (0x2f963, &['\u{7BC9}']),
    (0x2f8ea, &['\u{69EA}']),
    (0x1f11, &['\u{03B5}', '\u{0314}']),
    (0x1fb3, &['\u{03B1}', '\u{0345}']),
    (0x1f29, &['\u{0397}', '\u{0314}']),
    (0x1eb0, &['\u{0041}', '\u{0306}', '\u{0300}']),
    (0x1ff6, &['\u{03C9}', '\u{0342}']),
    (0x2f9fc, &['\u{4AB2}']),
    (0x1ee9, &['\u{0075}', '\u{031B}', '\u{0301}']),
    (0xf939, &['\u{9B6F}']),
    (0xd2, &['\u{004F}', '\u{0300}']),
    (0xfb44, &['\u{05E4}', '\u{05BC}']),
    (0x2f8c8, &['\u{654F}']),
    (0x2f9e8, &['\u{92D7}']),
    (0x1f33, &['\u{03B9}', '\u{0314}', '\u{0300}']),
    (0xf936, &['\u{865C}']),
    (0x1fec, &['\u{03A1}', '\u{0314}']),
    (0xf9aa, &['\u{5BE7}']),
    (0xfa37, &['\u{5606}']),
    (0x2f927, &['\u{24814}']),
    (0x17d, &['\u{005A}', '\u{030C}']),
    (0x1e70, &['\u{0054}', '\u{032D}']),
    (0x2f948, &['\u{774A}']),
    (0x3076, &['\u{3075}', '\u{3099}']),
    (0x2f954, &['\u{2569A}']),
    (0xfa2, &['\u{0FA1}', '\u{0FB7}']),
    (0x107, &['\u{0063}', '\u{0301}']),
    (0x2f809, &['\u{5099}']),
    (0x2f936, &['\u{753E}']),
    (0x1eae, &['\u{0041}', '\u{0306}', '\u{0301}']),
    (0x340, &['\u{0300}']),
    (0x1e01, &['\u{0061}', '\u{0325}']),
    (0x1f1b, &['\u{0395}', '\u{0314}', '\u{0300}']),
    (0x2f829, &['\u{5305}']),
    (0x103, &['\u{0061}', '\u{0306}']),
    (0xfa1e, &['\u{7FBD}']),
    (0x2f95e, &['\u{25AA7}']),
    (0xf92c, &['\u{90CE}']),
    (0x1e12, &['\u{0044}', '\u{032D}']),
    (0xf9d5, &['\u{5D19}']),
    (0x2f939, &['\u{2219F}']),
    (0xf913, &['\u{908F}']),
    (0x1f42, &['\u{03BF}', '\u{0313}', '\u{0300}']),
    (0xf3, &['\u{006F}', '\u{0301}']),
    (0xf911, &['\u{87BA}']),
    (0x2f87d, &['\u{21DE6}']),
    (0x1fae, &['\u{03A9}', '\u{0313}', '\u{0342}', '\u{0345}']),
    (0x2f847, &['\u{5599}']),
    (0x1e1c, &['\u{0045}', '\u{0327}', '\u{0306}']),
    (0x11e, &['\u{0047}', '\u{0306}']),
    (0x1f91, &['\u{03B7}', '\u{0314}', '\u{0345}']),
    (0xa59, &['\u{0A16}', '\u{0A3C}']),
    (0x1f0e, &['\u{0391}', '\u{0313}', '\u{0342}']),
    (0x1e95, &['\u{007A}', '\u{0331}']),
    (0x2f92a, &['\u{3EAC}']),
    (0x219, &['\u{0073}', '\u{0326}']),
    (0x2f8d9, &['\u{671B}']),
    (0x2f913, &['\u{7039}']),
    (0x206, &['\u{0045}', '\u{0311}']),
    (0x3cb, &['\u{03C5}', '\u{0308}']),
    (0xf9dc, &['\u{9686}']),
    (0xfb2d, &['\u{05E9}', '\u{05BC}', '\u{05C2}']),
    (0x22b, &['\u{006F}', '\u{0308}', '\u{0304}']),
    (0xf92e, &['\u{51B7}']),
    (0xf9e6, &['\u{7F79}']),
    (0x1f8e, &['\u{0391}', '\u{0313}', '\u{0342}', '\u{0345}']),
    (0x2f806, &['\u{4FBB}']),
    (0xfa84, &['\u{5F69}']),
    (0x2f8b4, &['\u{625D}']),
    (0x2f9cb, &['\u{278AE}']),
    (0x15d, &['\u{0073}', '\u{0302}']),
    (0x1ee6, &['\u{0055}', '\u{0309}']),
    (0x1e6e, &['\u{0054}', '\u{0331}']),
    (0xfa2d, &['\u{9DB4}']),
    (0x30f7, &['\u{30EF}', '\u{3099}']),
    (0xf977, &['\u{4EAE}']),
    (0xfac4, &['\u{9199}']),
    (0xf9, &['\u{0075}', '\u{0300}']),
    (0x2f89c, &['\u{5F9A}']),
    (0x2f908, &['\u{6E2F}']),
    (0xf9e3, &['\u{6CE5}']),
    (0x1fe2, &['\u{03C5}', '\u{0308}', '\u{0300}']),
    (0xed, &['\u{0069}', '\u{0301}']),
    (0x12f, &['\u{0069}', '\u{0328}']),
    (0x4ed, &['\u{044D}', '\u{0308}']),
    (0x2f9d4, &['\u{8CAB}']),
    (0x110ab, &['\u{110A5}', '\u{110BA}']),
    (0x2f9e6, &['\u{911B}']),
    (0x2285, &['\u{2283}', '\u{0338}']),
    (0xfa4a, &['\u{7422}']),
    (0x1e79, &['\u{0075}', '\u{0303}', '\u{0301}']),
    (0x3054, &['\u{3053}', '\u{3099}']),
    (0xfa5b, &['\u{8005}']),
    (0x4f3, &['\u{0443}', '\u{030B}']),
    (0x2f8b2, &['\u{6210}']),
    (0x1f7b, &['\u{03C5}', '\u{0301}']),
    (0x1f7a, &['\u{03C5}', '\u{0300}']),
    (0x1e5c, &['\u{0052}', '\u{0323}', '\u{0304}']),
    (0x174, &['\u{0057}', '\u{0302}']),
    (0x134, &['\u{004A}', '\u{0302}']),
    (0x1db, &['\u{0055}', '\u{0308}', '\u{0300}']),
    (0x1fa7, &['\u{03C9}', '\u{0314}', '\u{0342}', '\u{0345}']),
    (0x2fa0d, &['\u{4CCE}']),
    (0x1a1, &['\u{006F}', '\u{031B}']),
    (0x21cd, &['\u{21D0}', '\u{0338}']),
    (0x1e4b, &['\u{006E}', '\u{032D}']),
    (0x40c, &['\u{041A}', '\u{0301}']),
    (0x2f8b0, &['\u{61F2}']),
    (0x2f92d, &['\u{3EB8}']),
    (0x2f8d7, &['\u{43D9}']),
    (0xf9fb, &['\u{7099}']),
    (0x2f878, &['\u{5C6E}']),
    (0x217, &['\u{0075}', '\u{0311}']),
    (0x1eb7, &['\u{0061}', '\u{0323}', '\u{0306}']),
    (0xc8, &['\u{0045}', '\u{0300}']),
    (0xfa16, &['\u{732A}']),
    (0x2f9e2, &['\u{9094}']),
    (0x625, &['\u{0627}', '\u{0655}']),
    (0x1e1, &['\u{0061}', '\u{0307}', '\u{0304}']),
    (0x165, &['\u{0074}', '\u{030C}']),
    (0x1e28, &['\u{0048}', '\u{0327}']),
    (0x1fb7, &['\u{03B1}', '\u{0342}', '\u{0345}']),
    (0x1f8d, &['\u{0391}', '\u{0314}', '\u{0301}', '\u{0345}']),
    (0x2f8f2, &['\u{3C4E}']),
    (0x2f9df, &['\u{8F38}']),
    (0x2288, &['\u{2286}', '\u{0338}']),
    (0x2f859, &['\u{214E4}']),
    (0x2f883, &['\u{382F}']),
    (0x1f3e, &['\u{0399}', '\u{0313}', '\u{0342}']),
    (0x22ad, &['\u{22A8}', '\u{0338}']),
    (0x2f85e, &['\u{5922}']),
    (0x2f9b5, &['\u{8667}']),
    (0xe7, &['\u{0063}', '\u{0327}']),
    (0x1e6a, &['\u{0054}', '\u{0307}']),
    (0x1f95, &['\u{03B7}', '\u{0314}', '\u{0301}', '\u{0345}']),
    (0x2f9da, &['\u{8DCB}']),
    (0x1e7b, &['\u{0075}', '\u{0304}', '\u{0308}']),
    (0x2f814, &['\u{5167}']),
    (0xf9bf, &['\u{6A02}']),
    (0x1e90, &['\u{005A}', '\u{0302}']),
    (0x1eaa, &['\u{0041}', '\u{0302}', '\u{0303}']),
    (0xf81, &['\u{0F71}', '\u{0F80}']),
    (0xf9f1, &['\u{96A3}']),
    (0x1e31, &['\u{006B}', '\u{0301}']),
    (0x2f97a, &['\u{8005}']),
    (0x2f966, &['\u{7CD2}']),
    (0x2f834, &['\u{20A2C}']),
    (0x1f4, &['\u{0047}', '\u{0301}']),
    (0x1fad, &['\u{03A9}', '\u{0314}', '\u{0301}', '\u{0345}']),
    (0x1f43, &['\u{03BF}', '\u{0314}', '\u{0300}']),
    (0xfa83, &['\u{5ED9}']),
    (0x2f863, &['\u{5A1B}']),
    (0x1f8b, &['\u{0391}', '\u{0314}', '\u{0300}', '\u{0345}']),
    (0x1df, &['\u{0061}', '\u{0308}', '\u{0304}']),
    (0xfa04, &['\u{5B85}']),
    (0xbca, &['\u{0BC6}', '\u{0BBE}']),
    (0x626, &['\u{064A}', '\u{0654}']),
    (0x210, &['\u{0052}', '\u{030F}']),
    (0x2f8a6, &['\u{6148}']),
    (0x2fa1b, &['\u{9F16}']),
    (0xfa78, &['\u{559D}']),
    (0x95f, &['\u{092F}', '\u{093C}']),
    (0x2f9d8, &['\u{27F2F}']),
    (0x1ea5, &['\u{0061}', '\u{0302}', '\u{0301}']),
    (0xddd, &['\u{0DD9}', '\u{0DCF}', '\u{0DCA}']),
    (0x30d0, &['\u{30CF}', '\u{3099}']),
    (0x374, &['\u{02B9}']),
    (0x2f9b8, &['\u{8688}']),
    (0x2f886, &['\u{5E3D}']),
    (0x1e91, &['\u{007A}', '\u{0302}']),
    (0xda, &['\u{0055}', '\u{0301}']),
    (0x2f888, &['\u{3862}']),
    (0x2f851, &['\u{58EE}']),
    (0x2f862, &['\u{59EC}']),
    (0x1b0a, &['\u{1B09}', '\u{1B35}']),
    (0xf9e4, &['\u{7406}']),
    (0xf906, &['\u{53E5}']),
    (0x1e68, &['\u{0053}', '\u{0323}', '\u{0307}']),
    (0x1f86, &['\u{03B1}', '\u{0313}', '\u{0342}', '\u{0345}']),
    (0x2f921, &['\u{7235}']),
    (0xf947, &['\u{78CA}']),
    (0x1fd9, &['\u{0399}', '\u{0304}']),
    (0x2f9e0, &['\u{285D2}']),
    (0x2f860, &['\u{216A8}']),
    (0x1eed, &['\u{0075}', '\u{031B}', '\u{0309}']),
    (0xfd, &['\u{0079}', '\u{0301}']),
    (0xfa30, &['\u{4FAE}']),
    (0xfaa4, &['\u{761D}']),
    (0x2f9a1, &['\u{83CA}']),
    (0x2f918, &['\u{707D}']),
    (0x95d, &['\u{0922}', '\u{093C}']),
    (0xf9d1, &['\u{516D}']),
    (0xf9bb, &['\u{50DA}']),
    (0x1ecd, &['\u{006F}', '\u{0323}']),
    (0xf982, &['\u{5EEC}']),
    (0x1f26, &['\u{03B7}', '\u{0313}', '\u{0342}']),
    (0x1e6, &['\u{0047}', '\u{030C}']),
    (0xfa0b, &['\u{5ED3}']),
    (0xf96d, &['\u{7701}']),
    (0x3d3, &['\u{03D2}', '\u{0301}']),
    (0x1f5f, &['\u{03A5}', '\u{0314}', '\u{0342}']),
    (0xf942, &['\u{58DF}']),
    (0x1e1f, &['\u{0066}', '\u{0307}']),
    (0xddc, &['\u{0DD9}', '\u{0DCF}']),
    (0x1fb, &['\u{0061}', '\u{030A}', '\u{0301}']),
    (0x1e7e, &['\u{0056}', '\u{0323}']),
    (0x162, &['\u{0054}', '\u{0327}']),
    (0x30f9, &['\u{30F1}', '\u{3099}']),
    (0xf9ae, &['\u{7469}']),
    (0xf997, &['\u{806F}']),
    (0x2f8bb, &['\u{6368}']),
    (0xd9, &['\u{0055}', '\u{0300}']),
    (0x1d1be, &['\u{1D1BA}', '\u{1D165}', '\u{1D16E}']),
    (0xfb4b, &['\u{05D5}', '\u{05B9}']),
    (0xfa7a, &['\u{5599}']),
    (0xf9d6, &['\u{6DEA}']),
    (0xf90e, &['\u{7669}']),
    (0xc5, &['\u{0041}', '\u{030A}']),
    (0x2f9dd, &['\u{208DE}']),
    (0x2f98e, &['\u{446B}']),
    (0xfa53, &['\u{798E}']),
    (0xf9c9, &['\u{67F3}']),
    (0x2f80c, &['\u{349E}']),
    (0x1f02, &['\u{03B1}', '\u{0313}', '\u{0300}']),
    (0x2fa0f, &['\u{9D67}']),
    (0xfac6, &['\u{967C}']),
    (0x15e, &['\u{0053}', '\u{0327}']),
    (0xfabf, &['\u{8B39}']),
    (0x30c0, &['\u{30BF}', '\u{3099}']),
    (0x4d3, &['\u{0430}', '\u{0308}']),
    (0x1f72, &['\u{03B5}', '\u{0300}']),
    (0x22af, &['\u{22AB}', '\u{0338}']),
    (0x30d1, &['\u{30CF}', '\u{309A}']),
    (0x2f837, &['\u{53DF}']),
    (0xfa96, &['\u{6BBA}']),
    (0x14d, &['\u{006F}', '\u{0304}']),
    (0x1f7d, &['\u{03C9}', '\u{0301}']),
    (0xf923, &['\u{85CD}']),
    (0xf9f0, &['\u{85FA}']),
    (0x1f0f, &['\u{0391}', '\u{0314}', '\u{0342}']),
    (0x1ed9, &['\u{006F}', '\u{0323}', '\u{0302}']),
    (0xee, &['\u{0069}', '\u{0302}']),
    (0x30c2, &['\u{30C1}', '\u{3099}']),
    (0xf5, &['\u{006F}', '\u{0303}']),
    (0x2f990, &['\u{828B}']),
    (0x1f78, &['\u{03BF}', '\u{0300}']),
    (0xec, &['\u{0069}', '\u{0300}']),
    (0x2f969, &['\u{7CE3}']),
    (0x2f898, &['\u{261DA}']),
    (0x1eb5, &['\u{0061}', '\u{0306}', '\u{0303}']),
    (0x155, &['\u{0072}', '\u{0301}']),
    (0x2f994, &['\u{82B3}']),
    (0x20e, &['\u{004F}', '\u{0311}']),
    (0x2f8af, &['\u{61DE}']),
    (0x1d6, &['\u{0075}', '\u{0308}', '\u{0304}']),
    (0x22e2, &['\u{2291}', '\u{0338}']),
    (0x2f985, &['\u{813E}']),
    (0x1f85, &['\u{03B1}', '\u{0314}', '\u{0301}', '\u{0345}']),
    (0xf9be, &['\u{6599}']),
    (0x1ec4, &['\u{0045}', '\u{0302}', '\u{0303}']),
    (0x2f9c3, &['\u{8860}']),
    (0x1e44, &['\u{004E}', '\u{0307}']),
    (0x1f67, &['\u{03C9}', '\u{0314}', '\u{0342}']),
    (0xf9de, &['\u{540F}']),
    (0x2f9a5, &['\u{26D6B}']),
    (0x1fea, &['\u{03A5}', '\u{0300}']),
    (0x2f9f2, &['\u{49E6}']),
    (0x1ffc, &['\u{03A9}', '\u{0345}']),
    (0x457, &['\u{0456}', '\u{0308}']),
    (0xfa0d, &['\u{55C0}']),
    (0x2f9d2, &['\u{8C55}']),
    (0x22c, &['\u{004F}', '\u{0303}', '\u{0304}']),
    (0xf91b, &['\u{4E82}']),
    (0x1e50, &['\u{004F}', '\u{0304}', '\u{0300}']),
    (0x1faa, &['\u{03A9}', '\u{0313}', '\u{0300}', '\u{0345}']),
    (0x2fa0a, &['\u{9B12}']),
    (0x2284, &['\u{2282}', '\u{0338}']),
    (0x2f81d, &['\u{51F5}']),
    (0x1e30, &['\u{004B}', '\u{0301}']),
    (0x1f76, &['\u{03B9}', '\u{0300}']),
    (0x16e, &['\u{0055}', '\u{030A}']),
    (0xf9e5, &['\u{75E2}']),
    (0xfac, &['\u{0FAB}', '\u{0FB7}']),
    (0x2f8ac, &['\u{61B2}']),
    (0x95e, &['\u{092B}', '\u{093C}']),
    (0xcc8, &['\u{0CC6}', '\u{0CD6}']),
    (0x450, &['\u{0435}', '\u{0300}']),
    (0x4da, &['\u{04D8}', '\u{0308}']),
    (0x1fdd, &['\u{1FFE}', '\u{0300}']),
    (0x45d, &['\u{0438}', '\u{0300}']),
    (0x2f8d8, &['\u{6717}']),
    (0xfa82, &['\u{5ED2}']),
    (0x4eb, &['\u{04E9}', '\u{0308}']),
    (0x1b0, &['\u{0075}', '\u{031B}']),
    (0x1fd2, &['\u{03B9}', '\u{0308}', '\u{0300}']),
    (0x3ac, &['\u{03B1}', '\u{0301}']),
    (0x1ee0, &['\u{004F}', '\u{031B}', '\u{0303}']),
    (0x112, &['\u{0045}', '\u{0304}']),
    (0x2f81b, &['\u{51B5}']),
    (0xf951, &['\u{964B}']),
    (0x1e38, &['\u{004C}', '\u{0323}', '\u{0304}']),
    (0xdc, &['\u{0055}', '\u{0308}']),
    (0x2f940, &['\u{76F4}']),
    (0x128, &['\u{0049}', '\u{0303}']),
    (0x2f84e, &['\u{5651}']),
    (0x2f807, &['\u{5002}']),
    (0x9dc, &['\u{09A1}', '\u{09BC}']),
    (0xf931, &['\u{6AD3}']),
    (0xfc, &['\u{0075}', '\u{0308}']),
    (0xf9b3, &['\u{9748}']),
    (0x1109a, &['\u{11099}', '\u{110BA}']),
    (0x30b2, &['\u{30B1}', '\u{3099}']),
    (0xfa77, &['\u{52FA}']),
    (0x2f8c2, &['\u{3A2E}']),
    (0x2f928, &['\u{737A}']),
    (0xd4, &['\u{004F}', '\u{0302}']),
    (0x4d0, &['\u{0410}', '\u{0306}']),
    (0x1112e, &['\u{11131}', '\u{11127}']),
    (0x1e5e, &['\u{0052}', '\u{0331}']),
    (0xfab4, &['\u{83EF}']),
    (0xf918, &['\u{843D}']),
    (0x30d6, &['\u{30D5}', '\u{3099}']),
    (0x2f968, &['\u{7CE8}']),
    (0xf91f, &['\u{862D}']),
    (0x1e09, &['\u{0063}', '\u{0327}', '\u{0301}']),
    (0xfb33, &['\u{05D3}', '\u{05BC}']),
    (0x1e56, &['\u{0050}', '\u{0307}']),
    (0xf903, &['\u{8CC8}']),
    (0x1ed0, &['\u{004F}', '\u{0302}', '\u{0301}']),
    (0x1fa0, &['\u{03C9}', '\u{0313}', '\u{0345}']),
    (0xfb3c, &['\u{05DC}', '\u{05BC}']),
    (0xe4, &['\u{0061}', '\u{0308}']),
    (0x2f9e5, &['\u{2872E}']),
    (0x1e8d, &['\u{0078}', '\u{0308}']),
    (0xfb30, &['\u{05D0}', '\u{05BC}']),
    (0xcc7, &['\u{0CC6}', '\u{0CD5}']),
    (0x2f9dc, &['\u{8DF0}']),
    (0x305c, &['\u{305B}', '\u{3099}']),
    (0x108, &['\u{0043}', '\u{0302}']),
    (0x2f8ae, &['\u{61AF}']),
    (0x1f88, &['\u{0391}', '\u{0313}', '\u{0345}']),
    (0x2f9bb, &['\u{8779}']),
    (0x1e4c, &['\u{004F}', '\u{0303}', '\u{0301}']),
    (0x1b3d, &['\u{1B3C}', '\u{1B35}']),
    (0x1109c, &['\u{1109B}', '\u{110BA}']),
    (0xdda, &['\u{0DD9}', '\u{0DCA}']),
    (0x22ac, &['\u{22A2}', '\u{0338}']),
    (0xfa20, &['\u{8612}']),
    (0xf90d, &['\u{61F6}']),
    (0x1f04, &['\u{03B1}', '\u{0313}', '\u{0301}']),
    (0xf922, &['\u{6FEB}']),
    (0x1f37, &['\u{03B9}', '\u{0314}', '\u{0342}']),
    (0xfa9b, &['\u{701E}']),
    (0xfa88, &['\u{6108}']),
    (0x1e3f, &['\u{006D}', '\u{0301}']),
    (0x1e67, &['\u{0073}', '\u{030C}', '\u{0307}']),
    (0x2f8fc, &['\u{6CBF}']),
    (0x1ed4, &['\u{004F}', '\u{0302}', '\u{0309}']),
    (0x2f9f7, &['\u{2921A}']),
    (0x2f9ac, &['\u{8564}']),
    (0x4f9, &['\u{044B}', '\u{0308}']),
    (0x3062, &['\u{3061}', '\u{3099}']),
    (0x401, &['\u{0415}', '\u{0308}']),
    (0x1fd6, &['\u{03B9}', '\u{0342}']),
    (0xf9bd, &['\u{5C3F}']),
    (0x2f8f0, &['\u{238A7}']),
    (0x1e45, &['\u{006E}', '\u{0307}']),
    (0xface, &['\u{9F9C}']),
    (0xfaa9, &['\u{774A}']),
    (0x17e, &['\u{007A}', '\u{030C}']),
    (0x1fc, &['\u{00C6}', '\u{0301}']),
    (0xfa02, &['\u{62D3}']),
    (0xf927, &['\u{881F}']),
    (0x1ec3, &['\u{0065}', '\u{0302}', '\u{0309}']),
    (0x200, &['\u{0041}', '\u{030F}']),
    (0xf93f, &['\u{9304}']),
    (0x2f81f, &['\u{34DF}']),
    (0xf943, &['\u{5F04}']),
    (0x1e8f, &['\u{0079}', '\u{0307}']),
    (0x136, &['\u{004B}', '\u{0327}']),
    (0x1f9, &['\u{006E}', '\u{0300}']),
    (0xf9a2, &['\u{5EC9}']),
    (0x2f8ad, &['\u{61A4}']),
    (0xf912, &['\u{88F8}']),
    (0x2f8ab, &['\u{618E}']),
    (0x1fab, &['\u{03A9}', '\u{0314}', '\u{0300}', '\u{0345}']),
    (0x1e37, &['\u{006C}', '\u{0323}']),
    (0x6c0, &['\u{06D5}', '\u{0654}']),
    (0x1d9, &['\u{0055}', '\u{0308}', '\u{030C}']),
    (0x1e80, &['\u{0057}', '\u{0300}']),
    (0x407, &['\u{0406}', '\u{0308}']),
    (0xfac5, &['\u{9276}']),
    (0x2f961, &['\u{25BAB}']),
    (0x2f9e9, &['\u{92D8}']),
    (0x344, &['\u{0308}', '\u{0301}']),
    (0xfa38, &['\u{5668}']),
    (0x2f935, &['\u{24C36}']),
    (0x6c2, &['\u{06C1}', '\u{0654}']),
    (0x1f28, &['\u{0397}', '\u{0313}']),
    (0x1e71, &['\u{0074}', '\u{032D}']),
    (0xf96b, &['\u{53C3}']),
    (0xf9f3, &['\u{9E9F}']),
    (0x2f970, &['\u{7E45}']),
    (0xc2, &['\u{0041}', '\u{0302}']),
    (0x1f4d, &['\u{039F}', '\u{0314}', '\u{0301}']),
    (0x1ef9, &['\u{0079}', '\u{0303}']),
    (0x2f830, &['\u{537D}']),
    (0x2f9bf, &['\u{45D7}']),
    (0xfa2e, &['\u{90DE}']),
    (0x30da, &['\u{30D8}', '\u{309A}']),
    (0x1fe, &['\u{00D8}', '\u{0301}']),
    (0xf9f4, &['\u{6797}']),
    (0x9df, &['\u{09AF}', '\u{09BC}']),
    (0x1d160, &['\u{1D158}', '\u{1D165}', '\u{1D16E}']),
    (0x1e6b, &['\u{0074}', '\u{0307}']),
    (0xfa48, &['\u{716E}']),
    (0x1eb6, &['\u{0041}', '\u{0323}', '\u{0306}']),
    (0x2f866, &['\u{5A66}']),
    (0x1e0a, &['\u{0044}', '\u{0307}']),
    (0x2f868, &['\u{36FC}']),
    (0xf9bc, &['\u{5BEE}']),
    (0xfb2e, &['\u{05D0}', '\u{05B7}']),
    (0x1fc8, &['\u{0395}', '\u{0300}']),
    (0xf9e7, &['\u{88CF}']),
    (0xf915, &['\u{6D1B}']),
    (0xf99f, &['\u{70C8}']),
    (0x30dd, &['\u{30DB}', '\u{309A}']),
    (0x1f6a, &['\u{03A9}', '\u{0313}', '\u{0300}']),
    (0xfabb, &['\u{8ACB}']),
    (0x118, &['\u{0045}', '\u{0328}']),
    (0x2f9ec, &['\u{9415}']),
    (0x139, &['\u{004C}', '\u{0301}']),
    (0x1ef2, &['\u{0059}', '\u{0300}']),
    (0xfa72, &['\u{5168}']),
    (0x1e11, &['\u{0064}', '\u{0327}']),
    (0xd4c, &['\u{0D46}', '\u{0D57}']),
    (0x1f98, &['\u{0397}', '\u{0313}', '\u{0345}']),
    (0x2279, &['\u{2277}', '\u{0338}']),
    (0x2f95c, &['\u{2597C}']),
    (0x2f91a, &['\u{70AD}']),
    (0x1e3b, &['\u{006C}', '\u{0331}']),
    (0xcc0, &['\u{0CBF}', '\u{0CD5}']),
    (0x2f85a, &['\u{58F2}']),
    (0x21ce, &['\u{21D4}', '\u{0338}']),
    (0xf9ff, &['\u{523A}']),
    (0x30d3, &['\u{30D2}', '\u{3099}']),
    (0x2f871, &['\u{21B18}']),
    (0xc3, &['\u{0041}', '\u{0303}']),
    (0x4dd, &['\u{0436}', '\u{0308}']),
    (0x2f902, &['\u{6D41}']),
    (0xa5b, &['\u{0A1C}', '\u{0A3C}']),
    (0x1e92, &['\u{005A}', '\u{0323}']),
    (0x1f65, &['\u{03C9}', '\u{0314}', '\u{0301}']),
    (0xf4, &['\u{006F}', '\u{0302}']),
    (0xf9ea, &['\u{96E2}']),
    (0xf9d7, &['\u{8F2A}']),
    (0x2f84c, &['\u{5606}']),
    (0x1e2f, &['\u{0069}', '\u{0308}', '\u{0301}']),
    (0xfa4f, &['\u{7950}']),
    (0x2f98c, &['\u{8204}']),
    (0xfa59, &['\u{7E41}']),
    (0xf92a, &['\u{6D6A}']),
    (0x3ab, &['\u{03A5}', '\u{0308}']),
    (0xf9c2, &['\u{84FC}']),
    (0x22ec, &['\u{22B4}', '\u{0338}']),
    (0x2f995, &['\u{82BD}']),
    (0xf9d8, &['\u{5F8B}']),
    (0xf9b6, &['\u{79AE}']),
    (0x1ee1, &['\u{006F}', '\u{031B}', '\u{0303}']),
    (0xfa5c, &['\u{81ED}']),
    (0x4f5, &['\u{0447}', '\u{0308}']),
    (0x116, &['\u{0045}', '\u{0307}']),
    (0x1e3a, &['\u{004C}', '\u{0331}']),
    (0xfb47, &['\u{05E7}', '\u{05BC}']),
    (0x2f992, &['\u{52B3}']),
    (0x2f98d, &['\u{8F9E}']),
    (0x11a, &['\u{0045}', '\u{030C}']),
    (0x2f820, &['\u{523B}']),
    (0x1fe9, &['\u{03A5}', '\u{0304}']),
    (0xf908, &['\u{9F9C}']),
    (0xf95f, &['\u{5BE7}']),
    (0x4d1, &['\u{0430}', '\u{0306}']),
    (0x1e5f, &['\u{0072}', '\u{0331}']),
    (0xd3, &['\u{004F}', '\u{0301}']),
    (0x3069, &['\u{3068}', '\u{3099}']),
    (0x2f944, &['\u{25133}']),
    (0xf944, &['\u{7C60}']),
    (0xf9a1, &['\u{8AAA}']),
    (0x1d0, &['\u{0069}', '\u{030C}']),
    (0x1f9b, &['\u{0397}', '\u{0314}', '\u{0300}', '\u{0345}']),
    (0x2fa04, &['\u{9929}']),
    (0x2f96b, &['\u{25F86}']),
    (0x1f1d, &['\u{0395}', '\u{0314}', '\u{0301}']),
    (0x101, &['\u{0061}', '\u{0304}']),
    (0x1d163, &['\u{1D158}', '\u{1D165}', '\u{1D171}']),
    (0x2f8f5, &['\u{6BBA}']),
    (0x1ea7, &['\u{0061}', '\u{0302}', '\u{0300}']),
    (0x2f9c2, &['\u{45F9}']),
    (0xfacb, &['\u{980B}']),
    (0x1ea1, &['\u{0061}', '\u{0323}']),
    (0x226f, &['\u{003E}', '\u{0338}']),
    (0x2f8a3, &['\u{6094}']),
    (0xf9c7, &['\u{5289}']),
    (0x2f85c, &['\u{5906}']),
    (0x1e57, &['\u{0070}', '\u{0307}']),
    (0x1fc3, &['\u{03B7}', '\u{0345}']),
    (0x1ff2, &['\u{03C9}', '\u{0300}', '\u{0345}']),
    (0x2f8ec, &['\u{236A3}']),
    (0x218, &['\u{0053}', '\u{0326}']),
    (0x3065, &['\u{3064}', '\u{3099}']),
    (0x216, &['\u{0055}', '\u{0311}']),
    (0xfa7c, &['\u{585A}']),
    (0x1e9b, &['\u{017F}', '\u{0307}']),
    (0x209, &['\u{0069}', '\u{030F}']),
    (0xf999, &['\u{84EE}']),
    (0x1fd1, &['\u{03B9}', '\u{0304}']),
    (0x1e29, &['\u{0068}', '\u{0327}']),
    (0x2f90a, &['\u{3D33}']),
    (0xf2, &['\u{006F}', '\u{0300}']),
    (0xf956, &['\u{7A1C}']),
    (0x2f9de, &['\u{8ED4}']),
    (0x2209, &['\u{2208}', '\u{0338}']),
    (0xf925, &['\u{62C9}']),
    (0x1da, &['\u{0075}', '\u{0308}', '\u{030C}']),
    (0xf914, &['\u{6A02}']),
    (0xfa3e, &['\u{6168}']),
    (0x1ec9, &['\u{0069}', '\u{0309}']),
    (0x117, &['\u{0065}', '\u{0307}']),
    (0x2f9fe, &['\u{980B}']),
    (0x1f2c, &['\u{0397}', '\u{0313}', '\u{0301}']),
    (0x2f804, &['\u{4F60}']),
    (0x1e52, &['\u{004F}', '\u{0304}', '\u{0301}']),
    (0x2249, &['\u{2248}', '\u{0338}']),
    (0x123, &['\u{0067}', '\u{0327}']),
    (0x1cf, &['\u{0049}', '\u{030C}']),
    (0x1f44, &['\u{03BF}', '\u{0313}', '\u{0301}']),
    (0x13b, &['\u{004C}', '\u{0327}']),
    (0x227, &['\u{0061}', '\u{0307}']),
    (0x1d3, &['\u{0055}', '\u{030C}']),
    (0x2f999, &['\u{831D}']),
    (0x1e2d, &['\u{0069}', '\u{0330}']),
    (0x2f80b, &['\u{50CF}']),
    (0x2f840, &['\u{54A2}']),
    (0x1e02, &['\u{0042}', '\u{0307}']),
    (0x1f62, &['\u{03C9}', '\u{0313}', '\u{0300}']),
    (0x1e35, &['\u{006B}', '\u{0331}']),
    (0xd4a, &['\u{0D46}', '\u{0D3E}']),
    (0xfa7, &['\u{0FA6}', '\u{0FB7}']),
    (0x2f91d, &['\u{24263}']),
    (0x1e5a, &['\u{0052}', '\u{0323}']),
    (0x2f942, &['\u{250F2}']),
    (0x30ae, &['\u{30AD}', '\u{3099}']),
    (0x1e55, &['\u{0070}', '\u{0301}']),
    (0x160, &['\u{0053}', '\u{030C}']),
    (0xc1, &['\u{0041}', '\u{0301}']),
    (0x2f8d2, &['\u{5192}']),
    (0x2f91e, &['\u{719C}']),
    (0x2f93b, &['\u{24FA1}']),
    (0x1eb3, &['\u{0061}', '\u{0306}', '\u{0309}']),
    (0x40d, &['\u{0418}', '\u{0300}']),
    (0xfa7f, &['\u{5954}']),
    (0x2f822, &['\u{5272}']),
    (0x2f8c4, &['\u{647E}']),
    (0xf9e1, &['\u{674E}']),
    (0x20b, &['\u{0069}', '\u{0311}']),
    (0xfa, &['\u{0075}', '\u{0301}']),
    (0x2f9cf, &['\u{8AA0}']),
    (0x2f8a7, &['\u{614C}']),
    (0x137, &['\u{006B}', '\u{0327}']),
    (0xf9ad, &['\u{73B2}']),
    (0xfab0, &['\u{7DF4}']),
    (0x1d1c0, &['\u{1D1BA}', '\u{1D165}', '\u{1D16F}']),
    (0xf9b4, &['\u{9818}']),
    (0x439, &['\u{0438}', '\u{0306}']),
    (0x21ae, &['\u{2194}', '\u{0338}']),
    (0x1e34, &['\u{004B}', '\u{0331}']),
    (0x1d1, &['\u{004F}', '\u{030C}']),
    (0xfa25, &['\u{9038}']),
    (0xfa54, &['\u{7A40}']),
    (0xfaaa, &['\u{7740}']),
    (0xfac9, &['\u{97DB}']),
    (0x2f80f, &['\u{5154}']),
    (0x2f85b, &['\u{58F7}']),
    (0xf9b1, &['\u{9234}']),
    (0xf962, &['\u{7570}']),
    (0x22a, &['\u{004F}', '\u{0308}', '\u{0304}']),
    (0x1f35, &['\u{03B9}', '\u{0314}', '\u{0301}']),
    (0x2280, &['\u{227A}', '\u{0338}']),
    (0x2f996, &['\u{82E6}']),
    (0x1ea, &['\u{004F}', '\u{0328}']),
    (0x2f89f, &['\u{5FF9}']),
    (0x1ea0, &['\u{0041}', '\u{0323}']),
    (0xf99a, &['\u{9023}']),
    (0x1ed8, &['\u{004F}', '\u{0323}', '\u{0302}']),
    (0x1f20, &['\u{03B7}', '\u{0313}']),
    (0x3d4, &['\u{03D2}', '\u{0308}']),
    (0x4d6, &['\u{0415}', '\u{0306}']),
    (0xf95c, &['\u{6A02}']),
    (0x1e03, &['\u{0062}', '\u{0307}']),
    (0x2f962, &['\u{7BC6}']),
    (0x2fa1d, &['\u{2A600}']),
    (0x2f943, &['\u{25119}']),
    (0x2f98b, &['\u{8201}']),
    (0xf9a7, &['\u{7375}']),
    (0x2fa05, &['\u{99A7}']),
    (0xfad2, &['\u{3B9D}']),
    (0x2f897, &['\u{232B8}']),
    (0x2fa08, &['\u{4BCE}']),
    (0x2f9ae, &['\u{455D}']),
    (0xfa44, &['\u{6885}']),
    (0x2f8bc, &['\u{6383}']),
    (0x2f96a, &['\u{7D00}']),
    (0x2f8a8, &['\u{614E}']),
    (0x2f8cd, &['\u{6649}']),
    (0xfb1f, &['\u{05F2}', '\u{05B7}']),
    (0x2f88b, &['\u{5EB0}']),
    (0x2f811, &['\u{5177}']),
    (0x1b06, &['\u{1B05}', '\u{1B35}']),
    (0x1fef, &['\u{0060}']),
    (0x2f899, &['\u{5F62}']),
    (0x2f83b, &['\u{5406}']),
    (0x1e47, &['\u{006E}', '\u{0323}']),
    (0x2f90b, &['\u{6ECB}']),
    (0xfa8e, &['\u{641C}']),
    (0xf901, &['\u{66F4}']),
    (0x1e2a, &['\u{0048}', '\u{032E}']),
    (0x1e99, &['\u{0079}', '\u{030A}']),
    (0xf941, &['\u{8AD6}']),
    (0x1fe5, &['\u{03C1}', '\u{0314}']),
    (0x1d161, &['\u{1D158}', '\u{1D165}', '\u{1D16F}']),
    (0xf958, &['\u{83F1}']),
    (0xf924, &['\u{8964}']),
    (0xf96f, &['\u{8AAA}']),
    (0x6d3, &['\u{06D2}', '\u{0654}']),
    (0x1ec6, &['\u{0045}', '\u{0323}', '\u{0302}']),
    (0xfaad, &['\u{7BC0}']),
    (0x1d7, &['\u{0055}', '\u{0308}', '\u{0301}']),
    (0x1e81, &['\u{0077}', '\u{0300}']),
    (0xfa42, &['\u{65E2}']),
    (0xfa85, &['\u{5FAD}']),
    (0x1ecb, &['\u{0069}', '\u{0323}']),
    (0x2f92f, &['\u{745C}']),
    (0xf9fc, &['\u{8B58}']),
    (0xfaaf, &['\u{7D5B}']),
    (0xfa71, &['\u{51B5}']),
    (0x1f90, &['\u{03B7}', '\u{0313}', '\u{0345}']),
    (0xdd, &['\u{0059}', '\u{0301}']),
    (0xfb2f, &['\u{05D0}', '\u{05B8}']),
    (0xfa91, &['\u{6674}']),
    (0x1eb4, &['\u{0041}', '\u{0306}', '\u{0303}']),
    (0x2f930, &['\u{7471}']),
    (0xf966, &['\u{5FA9}']),
    (0x1feb, &['\u{03A5}', '\u{0301}']),
    (0xfac1, &['\u{8D08}']),
    (0x2f86f, &['\u{5BE7}']),
    (0xf99d, &['\u{52A3}']),
    (0x2f93a, &['\u{7610}']),
    (0x2fa18, &['\u{9EFE}']),
    (0x451, &['\u{0435}', '\u{0308}']),
    (0x1f52, &['\u{03C5}', '\u{0313}', '\u{0300}']),
    (0xccb, &['\u{0CC6}', '\u{0CC2}', '\u{0CD5}']),
    (0x232, &['\u{0059}', '\u{0304}']),
    (0x12d, &['\u{0069}', '\u{0306}']),
    (0x1ea3, &['\u{0061}', '\u{0309}']),
    (0xf93c, &['\u{797F}']),
    (0x1fbe, &['\u{03B9}']),
    (0xf9fd, &['\u{4EC0}']),
    (0xfa40, &['\u{61F2}']),
    (0x2fa11, &['\u{4CF8}']),
    (0xfad6, &['\u{25CD0}']),
    (0x2f9f0, &['\u{95B7}']),
    (0x2f95a, &['\u{7A4A}']),
    (0x2f91c, &['\u{7145}']),
    (0x1e3d, &['\u{006C}', '\u{032D}']),
    (0x2f87a, &['\u{5C8D}']),
    (0x1fdf, &['\u{1FFE}', '\u{0342}']),
    (0xf98a, &['\u{529B}']),
    (0xf950, &['\u{7E37}']),
    (0x173, &['\u{0075}', '\u{0328}']),
    (0x1f2a, &['\u{0397}', '\u{0313}', '\u{0300}']),
    (0xfa1b, &['\u{798F}']),
    (0x1ed6, &['\u{004F}', '\u{0302}', '\u{0303}']),
    (0x2f978, &['\u{7F95}']),
    (0x2f97f, &['\u{8070}']),
    (0x1ef, &['\u{0292}', '\u{030C}']),
    (0x1e65, &['\u{0073}', '\u{0301}', '\u{0307}']),
    (0x226, &['\u{0041}', '\u{0307}']),
    (0x2f848, &['\u{55AB}']),
    (0x1ff, &['\u{00F8}', '\u{0301}']),
    (0x21a, &['\u{0054}', '\u{0326}']),
    (0xc0, &['\u{0041}', '\u{0300}']),
    (0xdb, &['\u{0055}', '\u{0302}']),
    (0x3ce, &['\u{03C9}', '\u{0301}']),
    (0x20d, &['\u{006F}', '\u{030F}']),
    (0x1d164, &['\u{1D158}', '\u{1D165}', '\u{1D172}']),
    (0x212b, &['\u{0041}', '\u{030A}']),
    (0x2f846, &['\u{5584}']),
    (0x2f805, &['\u{4FAE}']),
    (0x159, &['\u{0072}', '\u{030C}']),
    (0x2f9f1, &['\u{28D77}']),
    (0x1f40, &['\u{03BF}', '\u{0313}']),
    (0x2f958, &['\u{412F}']),
    (0x1fe6, &['\u{03C5}', '\u{0342}']),
    (0xfaae, &['\u{7C7B}']),
    (0x2275, &['\u{2273}', '\u{0338}']),
    (0xfa15, &['\u{51DE}']),
    (0x1fc1, &['\u{00A8}', '\u{0342}']),
    (0xd5, &['\u{004F}', '\u{0303}']),
    (0xfad0, &['\u{22844}']),
    (0x4c1, &['\u{0416}', '\u{0306}']),
    (0x2f976, &['\u{7F7A}']),
    (0x1e19, &['\u{0065}', '\u{032D}']),
    (0x1f71, &['\u{03B1}', '\u{0301}']),
    (0x1f9f, &['\u{0397}', '\u{0314}', '\u{0342}', '\u{0345}']),
    (0x2f81c, &['\u{291DF}']),
    (0x1e05, &['\u{0062}', '\u{0323}']),
    (0xfa26, &['\u{90FD}']),
    (0x1fac, &['\u{03A9}', '\u{0313}', '\u{0301}', '\u{0345}']),
    (0x2f88a, &['\u{387C}']),
    (0x1fde, &['\u{1FFE}', '\u{0301}']),
    (0x1e97, &['\u{0074}', '\u{0308}']),
    (0xf98b, &['\u{66C6}']),
    (0x2f816, &['\u{2054B}']),
    (0x2f9eb, &['\u{93F9}']),
    (0x1e6d, &['\u{0074}', '\u{0323}']),
    (0xfa12, &['\u{6674}']),
    (0x2f9b1, &['\u{270D2}']),
    (0xfa43, &['\u{6691}']),
    (0xfa2a, &['\u{98EF}']),
    (0x4e2, &['\u{0418}', '\u{0304}']),
    (0x1f5, &['\u{0067}', '\u{0301}']),
    (0x1e5d, &['\u{0072}', '\u{0323}', '\u{0304}']),
    (0x1fc7, &['\u{03B7}', '\u{0342}', '\u{0345}']),
    (0x1f00, &['\u{03B1}', '\u{0313}']),
    (0x2f96f, &['\u{7E02}']),
    (0xfa3c, &['\u{5C6E}']),
    (0x2f99d, &['\u{83BD}']),
    (0x2f8d6, &['\u{80AD}']),
    (0x1f70, &['\u{03B1}', '\u{0300}']),
    (0x2f9f8, &['\u{4A6E}']),
    (0x10d, &['\u{0063}', '\u{030C}']),
    (0xfb46, &['\u{05E6}', '\u{05BC}']),
    (0x1ebe, &['\u{0045}', '\u{0302}', '\u{0301}']),
    (0xfa93, &['\u{671B}']),
    (0xf9c0, &['\u{71CE}']),
    (0xb4c, &['\u{0B47}', '\u{0B57}']),
    (0x1f57, &['\u{03C5}', '\u{0314}', '\u{0342}']),
    (0x3ca, &['\u{03B9}', '\u{0308}']),
    (0x1e7c, &['\u{0056}', '\u{0303}']),
    (0xfa22, &['\u{8AF8}']),
    (0x1ff3, &['\u{03C9}', '\u{0345}']),
    (0x1e2b, &['\u{0068}', '\u{032E}']),
    (0xf9ec, &['\u{6EBA}']),
    (0x1e04, &['\u{0042}', '\u{0323}']),
    (0xfb9, &['\u{0F90}', '\u{0FB5}']),
    (0x1e0, &['\u{0041}', '\u{0307}', '\u{0304}']),
    (0x2f90c, &['\u{6EC7}']),
    (0xc48, &['\u{0C46}', '\u{0C56}']),
    (0x3067, &['\u{3066}', '\u{3099}']),
    (0x2f9c6, &['\u{88D7}']),
    (0x2f8f3, &['\u{6B72}']),
    (0x12c, &['\u{0049}', '\u{0306}']),
    (0x2f8a9, &['\u{614C}']),
    (0x2f83d, &['\u{5438}']),
    (0x170, &['\u{0055}', '\u{030B}']),
    (0x2244, &['\u{2243}', '\u{0338}']),
    (0xf9d4, &['\u{502B}']),
    (0x2f89d, &['\u{5FCD}']),
    (0x233, &['\u{0079}', '\u{0304}']),
    (0xfa75, &['\u{5180}']),
    (0x2f84a, &['\u{55C2}']),
    (0x1ef1, &['\u{0075}', '\u{031B}', '\u{0323}']),
    (0x1e61, &['\u{0073}', '\u{0307}']),
    (0x219a, &['\u{2190}', '\u{0338}']),
    (0x30d9, &['\u{30D8}', '\u{3099}']),
    (0x202, &['\u{0041}', '\u{0311}']),
    (0x1f24, &['\u{03B7}', '\u{0313}', '\u{0301}']),
    (0x2126, &['\u{03A9}']),
    (0x204, &['\u{0045}', '\u{030F}']),
    (0x931, &['\u{0930}', '\u{093C}']),
    (0xfa68, &['\u{96E3}']),
    (0xf93e, &['\u{83C9}']),
    (0x3077, &['\u{3075}', '\u{309A}']),
    (0x341, &['\u{0301}']),
    (0x1e6f, &['\u{0074}', '\u{0331}']),
    (0x2f8e4, &['\u{688E}']),
    (0x2f83f, &['\u{5468}']),
    (0xf9ef, &['\u{7498}']),
    (0xf976, &['\u{7565}']),
    (0xf9c6, &['\u{962E}']),
    (0xfa97, &['\u{6D41}']),
    (0x114bb, &['\u{114B9}', '\u{114BA}']),
    (0x2f916, &['\u{3D96}']),
    (0x1f99, &['\u{0397}', '\u{0314}', '\u{0345}']),
    (0x30d4, &['\u{30D2}', '\u{309A}']),
    (0x2f932, &['\u{74CA}']),
    (0xb4b, &['\u{0B47}', '\u{0B3E}']),
    (0x201, &['\u{0061}', '\u{030F}']),
    (0x20c, &['\u{004F}', '\u{030F}']),
    (0x13a, &['\u{006C}', '\u{0301}']),
    (0x30f8, &['\u{30F0}', '\u{3099}']),
    (0x2f858, &['\u{58AC}']),
    (0x2f8e8, &['\u{6942}']),
    (0xf954, &['\u{51DC}']),
    (0x2f900, &['\u{6D3E}']),
    (0x2fa1c, &['\u{9F3B}']),
    (0xfb40, &['\u{05E0}', '\u{05BC}']),
    (0x1f69, &['\u{03A9}', '\u{0314}']),
    (0xfac7, &['\u{96E3}']),
    (0x1e77, &['\u{0075}', '\u{032D}']),
    (0x1ce, &['\u{0061}', '\u{030C}']),
    (0xf934, &['\u{8001}']),
    (0xf94f, &['\u{7D2F}']),
    (0x22ea, &['\u{22B2}', '\u{0338}']),
    (0xf920, &['\u{9E1E}']),
    (0x2f9f4, &['\u{5DB2}']),
    (0x1f2b, &['\u{0397}', '\u{0314}', '\u{0300}']),
    (0x2f979, &['\u{7FFA}']),
    (0x2f86c, &['\u{219C8}']),
    (0x1e1e, &['\u{0046}', '\u{0307}']),
    (0x144, &['\u{006E}', '\u{0301}']),
    (0x2f8e5, &['\u{681F}']),
    (0xfaa8, &['\u{76F4}']),
    (0x3094, &['\u{3046}', '\u{3099}']),
    (0x1ed3, &['\u{006F}', '\u{0302}', '\u{0300}']),
    (0x2f934, &['\u{7524}']),
    (0xfa41, &['\u{654F}']),
    (0xf9c8, &['\u{677B}']),
    (0x2f89b, &['\u{38E3}']),
    (0x1e94, &['\u{005A}', '\u{0331}']),
    (0x1e83, &['\u{0077}', '\u{0301}']),
    (0xf9c1, &['\u{7642}']),
    (0x1f60, &['\u{03C9}', '\u{0313}']),
    (0xfa1a, &['\u{7965}']),
    (0x2f9fb, &['\u{2940A}']),
    (0x2f9c8, &['\u{4635}']),
    (0xb5d, &['\u{0B22}', '\u{0B3C}']),
    (0x4f1, &['\u{0443}', '\u{0308}']),
    (0x2f9bd, &['\u{876B}']),
    (0x17a, &['\u{007A}', '\u{0301}']),
    (0x1f79, &['\u{03BF}', '\u{0301}']),
    (0xca, &['\u{0045}', '\u{0302}']),
    (0x2f813, &['\u{34B9}']),
    (0x1f31, &['\u{03B9}', '\u{0314}']),
    (0x2f880, &['\u{5D7C}']),
    (0x2224, &['\u{2223}', '\u{0338}']),
    (0x2adc, &['\u{2ADD}', '\u{0338}']),
    (0x2f8ff, &['\u{6D16}']),
    (0x1112f, &['\u{11132}', '\u{11127}']),
    (0xfa35, &['\u{5351}']),
    (0x1b0c, &['\u{1B0B}', '\u{1B35}']),
    (0x1e53, &['\u{006F}', '\u{0304}', '\u{0301}']),
    (0x1eb9, &['\u{0065}', '\u{0323}']),
    (0xf960, &['\u{6012}']),
    (0x2f8b1, &['\u{61F6}']),
    (0x1ee8, &['\u{0055}', '\u{031B}', '\u{0301}']),
    (0xf992, &['\u{6F23}']),
    (0x4f8, &['\u{042B}', '\u{0308}']),
    (0x2f9a6, &['\u{26CD5}']),
    (0x2f808, &['\u{507A}']),
    (0x2f8d3, &['\u{5195}']),
    (0x16a, &['\u{0055}', '\u{0304}']),
    (0x1e4d, &['\u{006F}', '\u{0303}', '\u{0301}']),
    (0x1f96, &['\u{03B7}', '\u{0313}', '\u{0342}', '\u{0345}']),
    (0x115bb, &['\u{115B9}', '\u{115AF}']),
    (0xf9f7, &['\u{7ACB}']),
    (0x2f9c5, &['\u{27667}']),
    (0x10b, &['\u{0063}', '\u{0307}']),
    (0x1b12, &['\u{1B11}', '\u{1B35}']),
    (0x30be, &['\u{30BD}', '\u{3099}']),
    (0x2f987, &['\u{267A7}']),
    (0x2f876, &['\u{3781}']),
    (0xfb2b, &['\u{05E9}', '\u{05C2}']),
    (0xfaab, &['\u{78CC}']),
    (0x1fd7, &['\u{03B9}', '\u{0308}', '\u{0342}']),
    (0x2f89e, &['\u{5FD7}']),
    (0xfa39, &['\u{5840}']),
    (0x2fa07, &['\u{99FE}']),
    (0x2f8ee, &['\u{3C18}']),
    (0x30b0, &['\u{30AF}', '\u{3099}']),
    (0x2f895, &['\u{5F22}']),
    (0x1e3, &['\u{00E6}', '\u{0304}']),
    (0x114be, &['\u{114B9}', '\u{114BD}']),
    (0xcf, &['\u{0049}', '\u{0308}']),
    (0xfaa7, &['\u{76DB}']),
    (0x45c, &['\u{043A}', '\u{0301}']),
    (0x2f8c9, &['\u{656C}']),
    (0xfa18, &['\u{793C}']),
    (0xf9da, &['\u{6817}']),
    (0x2f983, &['\u{8103}']),
    (0x2f891, &['\u{22331}']),
    (0xf99e, &['\u{54BD}']),
    (0x403, &['\u{0413}', '\u{0301}']),
    (0x10c, &['\u{0043}', '\u{030C}']),
    (0x476, &['\u{0474}', '\u{030F}']),
    (0x389, &['\u{0397}', '\u{0301}']),
    (0x2f8df, &['\u{67FA}']),
    (0xfa07, &['\u{8F3B}']),
    (0xfab7, &['\u{8986}']),
    (0x1e5b, &['\u{0072}', '\u{0323}']),
    (0xf98e, &['\u{5E74}']),
    (0xfa7b, &['\u{55E2}']),
    (0xfa67, &['\u{9038}']),
    (0xf946, &['\u{7262}']),
    (0x121, &['\u{0067}', '\u{0307}']),
    (0x2f946, &['\u{771F}']),
    (0x2204, &['\u{2203}', '\u{0338}']),
    (0xfa7d, &['\u{58B3}']),
    (0xf4d, &['\u{0F4C}', '\u{0FB7}']),
    (0x2fa09, &['\u{29B30}']),
    (0xfa1d, &['\u{7CBE}']),
    (0xfb, &['\u{0075}', '\u{0302}']),
    (0x1f3c, &['\u{0399}', '\u{0313}', '\u{0301}']),
    (0x307a, &['\u{3078}', '\u{309A}']),
    (0xfa52, &['\u{798D}']),
    (0xfb39, &['\u{05D9}', '\u{05BC}']),
    (0x1f82, &['\u{03B1}', '\u{0313}', '\u{0300}', '\u{0345}']),
    (0x1e26, &['\u{0048}', '\u{0308}']),
    (0x3050, &['\u{304F}', '\u{3099}']),
    (0x2f96e, &['\u{7DC7}']),
    (0x305a, &['\u{3059}', '\u{3099}']),
    (0x2fa17, &['\u{9EF9}']),
    (0xf95a, &['\u{8B80}']),
    (0xf9d3, &['\u{9678}']),
    (0x30fe, &['\u{30FD}', '\u{3099}']),
    (0x2f865, &['\u{59D8}']),
    (0x1b40, &['\u{1B3E}', '\u{1B35}']),
    (0x212, &['\u{0052}', '\u{0311}']),
    (0xfb4d, &['\u{05DB}', '\u{05BF}']),
    (0x1f2f, &['\u{0397}', '\u{0314}', '\u{0342}']),
    (0xf93a, &['\u{9DFA}']),
    (0xf910, &['\u{863F}']),
    (0xf949, &['\u{96F7}']),
    (0xfa19, &['\u{795E}']),
    (0xfab1, &['\u{7F3E}']),
    (0x2f923, &['\u{24608}']),
    (0x2f861, &['\u{216EA}']),
    (0x2f97c, &['\u{26523}']),
    (0x1f63, &['\u{03C9}', '\u{0314}', '\u{0300}']),
    (0x1f48, &['\u{039F}', '\u{0313}']),
    (0x2f845, &['\u{5584}']),
    (0xf9ce, &['\u{786B}']),
    (0xfab9, &['\u{8ABF}']),
    (0xfa47, &['\u{6F22}']),
    (0x2f8aa, &['\u{617A}']),
    (0xfa00, &['\u{5207}']),
    (0xf990, &['\u{6200}']),
    (0x2f884, &['\u{5DFD}']),
    (0x1f68, &['\u{03A9}', '\u{0313}']),
    (0x2f9b7, &['\u{86A9}']),
    (0x9cc, &['\u{09C7}', '\u{09D7}']),
    (0xfa09, &['\u{964D}']),
    (0x2f8dc, &['\u{6753}']),
    (0x1fd8, &['\u{0399}', '\u{0306}']),
    (0x226d, &['\u{224D}', '\u{0338}']),
    (0x4e3, &['\u{0438}', '\u{0304}']),
    (0x1e59, &['\u{0072}', '\u{0307}']),
    (0xfa03, &['\u{7CD6}']),
    (0x2f993, &['\u{82B1}']),
    (0x2f894, &['\u{5F22}']),
    (0x10a, &['\u{0043}', '\u{0307}']),
    (0x163, &['\u{0074}', '\u{0327}']),
    (0xf940, &['\u{9E7F}']),
    (0x2f951, &['\u{40E3}']),
    (0x2f896, &['\u{38C7}']),
    (0x1fee, &['\u{00A8}', '\u{0301}']),
    (0x2fa06, &['\u{99C2}']),
    (0x1e54, &['\u{0050}', '\u{0301}']),
    (0xf96a, &['\u{7D22}']),
    (0x1ec0, &['\u{0045}', '\u{0302}', '\u{0300}']),
    (0xfb3b, &['\u{05DB}', '\u{05BC}']),
    (0x2f8e0, &['\u{6785}']),
    (0xa36, &['\u{0A38}', '\u{0A3C}']),
    (0xbcb, &['\u{0BC7}', '\u{0BBE}']),
    (0x2f9bc, &['\u{8728}']),
    (0xfa6a, &['\u{983B}']),
    (0x2f827, &['\u{52E4}']),
    (0xfa55, &['\u{7A81}']),
    (0x2f8f9, &['\u{23AFA}']),
    (0x13d, &['\u{004C}', '\u{030C}']),
    (0x1ef6, &['\u{0059}', '\u{0309}']),
    (0x20a, &['\u{0049}', '\u{0311}']),
    (0x2f881, &['\u{5DE1}']),
    (0x1134c, &['\u{11347}', '\u{11357}']),
    (0x2f8b8, &['\u{22B0C}']),
    (0x1f61, &['\u{03C9}', '\u{0314}']),
    (0xfa64, &['\u{8CD3}']),
    (0x2f9be, &['\u{8786}']),
    (0x2f9ed, &['\u{28BFA}']),
    (0x1e33, &['\u{006B}', '\u{0323}']),
    (0x2f801, &['\u{4E38}']),
    (0x14f, &['\u{006F}', '\u{0306}']),
    (0xf97a, &['\u{6881}']),
    (0x1ec8, &['\u{0049}', '\u{0309}']),
    (0x4ee, &['\u{0423}', '\u{0304}']),
    (0x207, &['\u{0065}', '\u{0311}']),
    (0xf995, &['\u{79CA}']),
    (0x1e8b, &['\u{0078}', '\u{0307}']),
    (0x2f893, &['\u{8201}']),
    (0xf984, &['\u{6FFE}']),
    (0xf9cf, &['\u{7D10}']),
    (0x2f90e, &['\u{6DF9}']),
    (0x1e07, &['\u{0062}', '\u{0331}']),
    (0x30fa, &['\u{30F2}', '\u{3099}']),
    (0xfab2, &['\u{8005}']),
    (0x2f9db, &['\u{8DBC}']),
    (0x1f3a, &['\u{0399}', '\u{0313}', '\u{0300}']),
    (0xfa32, &['\u{514D}']),
    (0x1e49, &['\u{006E}', '\u{0331}']),
    (0x2f96d, &['\u{4301}']),
    (0x2f9a7, &['\u{452B}']),
    (0x22e3, &['\u{2292}', '\u{0338}']),
    (0xf9ba, &['\u{4E86}']),
    (0x1f15, &['\u{03B5}', '\u{0314}', '\u{0301}']),
    (0x2f8db, &['\u{675E}']),
    (0xf5c, &['\u{0F5B}', '\u{0FB7}']),
    (0x1fe0, &['\u{03C5}', '\u{0306}']),
    (0x1e69, &['\u{0073}', '\u{0323}', '\u{0307}']),
    (0x15b, &['\u{0073}', '\u{0301}']),
    (0x38a, &['\u{0399}', '\u{0301}']),
    (0x2f832, &['\u{537F}']),
    (0x21e, &['\u{0048}', '\u{030C}']),
    (0xf9fe, &['\u{8336}']),
    (0x169, &['\u{0075}', '\u{0303}']),
    (0x2f9e3, &['\u{90F1}']),
    (0x1ece, &['\u{004F}', '\u{0309}']),
    (0x2262, &['\u{2261}', '\u{0338}']),
    (0x1f94, &['\u{03B7}', '\u{0313}', '\u{0301}', '\u{0345}']),
    (0x1ef3, &['\u{0079}', '\u{0300}']),
    (0xf9d0, &['\u{985E}']),
    (0x2f8bd, &['\u{63E4}']),
    (0x30dc, &['\u{30DB}', '\u{3099}']),
    (0x115, &['\u{0065}', '\u{0306}']),
    (0x2f9b4, &['\u{865C}']),
    (0x1e84, &['\u{0057}', '\u{0308}']),
    (0x213, &['\u{0072}', '\u{0311}']),
    (0xf9f2, &['\u{9C57}']),
    (0xf91a, &['\u{99F1}']),
    (0xfa61, &['\u{8996}']),
    (0x38f, &['\u{03A9}', '\u{0301}']),
    (0xf9e8, &['\u{88E1}']),
    (0xf78, &['\u{0FB3}', '\u{0F80}']),
    (0x2f844, &['\u{5563}']),
    (0xfab5, &['\u{8779}']),
    (0x2f905, &['\u{6D85}']),
    (0x178, &['\u{0059}', '\u{0308}']),
    (0xfa5d, &['\u{8279}']),
    (0xfb2a, &['\u{05E9}', '\u{05C1}']),
    (0xf9b7, &['\u{91B4}']),
    (0x1ffa, &['\u{03A9}', '\u{0300}']),
    (0x2f85f, &['\u{5962}']),
    (0x1f8, &['\u{004E}', '\u{0300}']),
    (0x1f6e, &['\u{03A9}', '\u{0313}', '\u{0342}']),
    (0x1fe7, &['\u{03C5}', '\u{0308}', '\u{0342}']),
    (0x1fb4, &['\u{03B1}', '\u{0301}', '\u{0345}']),
    (0x2f874, &['\u{5F53}']),
    (0xfb38, &['\u{05D8}', '\u{05BC}']),
    (0x4f0, &['\u{0423}', '\u{0308}']),
    (0x2f8fd, &['\u{6CCD}']),
    (0x1e32, &['\u{004B}', '\u{0323}']),
    (0x1eab, &['\u{0061}', '\u{0302}', '\u{0303}']),
    (0xfa9a, &['\u{6F22}']),
    (0xfb49, &['\u{05E9}', '\u{05BC}']),
    (0xf9d2, &['\u{622E}']),
    (0x2f9fa, &['\u{97E0}']),
    (0x622, &['\u{0627}', '\u{0653}']),
    (0xfa4b, &['\u{7891}']),
    (0xfa56, &['\u{7BC0}']),
    (0x1ecc, &['\u{004F}', '\u{0323}']),
    (0x1f45, &['\u{03BF}', '\u{0314}', '\u{0301}']),
    (0xfa06, &['\u{66B4}']),
    (0xd4b, &['\u{0D47}', '\u{0D3E}']),
    (0xfad8, &['\u{9F43}']),
    (0x2f97e, &['\u{265A8}']),
    (0xe1, &['\u{0061}', '\u{0301}']),
    (0x1edd, &['\u{006F}', '\u{031B}', '\u{0300}']),
    (0x1cd, &['\u{0041}', '\u{030C}']),
    (0xf52, &['\u{0F51}', '\u{0FB7}']),
    (0x3056, &['\u{3055}', '\u{3099}']),
    (0xfacc, &['\u{983B}']),
    (0x15a, &['\u{0053}', '\u{0301}']),
    (0x2f957, &['\u{79EB}']),
    (0x1d8, &['\u{0075}', '\u{0308}', '\u{0301}']),
    (0x1fc4, &['\u{03B7}', '\u{0301}', '\u{0345}']),
    (0x3b0, &['\u{03C5}', '\u{0308}', '\u{0301}']),
    (0x30c9, &['\u{30C8}', '\u{3099}']),
    (0x10e, &['\u{0044}', '\u{030C}']),
    (0x2fa01, &['\u{295B6}']),
    (0x1ffd, &['\u{00B4}']),
    (0xf980, &['\u{5442}']),
    (0xfaa6, &['\u{76CA}']),
    (0x2f9c1, &['\u{8801}']),
    (0xc4, &['\u{0041}', '\u{0308}']),
    (0x1e0f, &['\u{0064}', '\u{0331}']),
    (0x2f8de, &['\u{3B49}']),
    (0x2f953, &['\u{7956}']),
    (0x1eef, &['\u{0075}', '\u{031B}', '\u{0303}']),
    (0xfaa3, &['\u{753B}']),
    (0x2f889, &['\u{22183}']),
    (0x4dc, &['\u{0416}', '\u{0308}']),
    (0x1f66, &['\u{03C9}', '\u{0313}', '\u{0342}']),
    (0x2f924, &['\u{7280}']),
    (0x2f8cf, &['\u{6691}']),
    (0x172, &['\u{0055}', '\u{0328}']),
    (0x2f909, &['\u{6E6E}']),
    (0xf9a3, &['\u{5FF5}']),
    (0x104, &['\u{0041}', '\u{0328}']),
    (0x2f991, &['\u{829D}']),
    (0x22ae, &['\u{22A9}', '\u{0338}']),
    (0x1fca, &['\u{0397}', '\u{0300}']),
    (0xf971, &['\u{8FB0}']),
    (0x1f3f, &['\u{0399}', '\u{0314}', '\u{0342}']),
    (0x20f, &['\u{006F}', '\u{0311}']),
    (0x2f856, &['\u{5832}']),
    (0x30b6, &['\u{30B5}', '\u{3099}']),
    (0x1ff9, &['\u{039F}', '\u{0301}']),
    (0x1eb1, &['\u{0061}', '\u{0306}', '\u{0300}']),
    (0x1f07, &['\u{03B1}', '\u{0314}', '\u{0342}']),
    (0x1ebb, &['\u{0065}', '\u{0309}']),
    (0x2f99e, &['\u{83E7}']),
    (0x2260, &['\u{003D}', '\u{0338}']),
    (0x146, &['\u{006E}', '\u{0327}']),
    (0x2f9ff, &['\u{980B}']),
    (0x929, &['\u{0928}', '\u{093C}']),
    (0xf91c, &['\u{5375}']),
    (0xf929, &['\u{6717}']),
    (0x1e14, &['\u{0045}', '\u{0304}', '\u{0300}']),
    (0x477, &['\u{0475}', '\u{030F}']),
    (0x102, &['\u{0041}', '\u{0306}']),
    (0x2f800, &['\u{4E3D}']),
    (0x2f9a2, &['\u{83CC}']),
    (0x2fa1a, &['\u{9F0F}']),
    (0x95a, &['\u{0917}', '\u{093C}']),
    (0xc7, &['\u{0043}', '\u{0327}']),
    (0xf97f, &['\u{52F5}']),
    (0x2f960, &['\u{4202}']),
    (0x12b, &['\u{0069}', '\u{0304}']),
    (0x309e, &['\u{309D}', '\u{3099}']),
    (0xf95b, &['\u{62CF}']),
    (0x2f92e, &['\u{7447}']),
    (0x1f55, &['\u{03C5}', '\u{0314}', '\u{0301}']),
    (0x4d2, &['\u{0410}', '\u{0308}']),
    (0xf9d, &['\u{0F9C}', '\u{0FB7}']),
    (0xf994, &['\u{7489}']),
    (0x1e4e, &['\u{004F}', '\u{0303}', '\u{0308}']),
    (0x2f83c, &['\u{549E}']),
    (0x2f80d, &['\u{2063A}']),
    (0x2f941, &['\u{250F3}']),
    (0x168, &['\u{0055}', '\u{0303}']),
    (0x9dd, &['\u{09A2}', '\u{09BC}']),
    (0x3070, &['\u{306F}', '\u{3099}']),
    (0xf9e9, &['\u{91CC}']),
    (0xe0, &['\u{0061}', '\u{0300}']),
    (0x1fa5, &['\u{03C9}', '\u{0314}', '\u{0301}', '\u{0345}']),
    (0x1fa6, &['\u{03C9}', '\u{0313}', '\u{0342}', '\u{0345}']),
    (0xfaac, &['\u{7AB1}']),
    (0xfa87, &['\u{614E}']),
    (0x105, &['\u{0061}', '\u{0328}']),
    (0x100, &['\u{0041}', '\u{0304}']),
    (0xfa33, &['\u{52C9}']),
    (0x2f8c1, &['\u{63A9}']),
    (0xf9ee, &['\u{71D0}']),
    (0x30c7, &['\u{30C6}', '\u{3099}']),
    (0x203, &['\u{0061}', '\u{0311}']),
    (0x2f877, &['\u{5C60}']),
    (0x2f9d3, &['\u{27CA8}']),
    (0xfb3e, &['\u{05DE}', '\u{05BC}']),
    (0x2f854, &['\u{580D}']),
    (0x2f82f, &['\u{5373}']),
    (0x208, &['\u{0049}', '\u{030F}']),
    (0xf90b, &['\u{5587}']),
    (0x2f87c, &['\u{5D43}']),
    (0xf9a4, &['\u{637B}']),
    (0x1ec5, &['\u{0065}', '\u{0302}', '\u{0303}']),
    (0x3cc, &['\u{03BF}', '\u{0301}']),
    (0xfaa5, &['\u{761F}']),
    (0xf6, &['\u{006F}', '\u{0308}']),
    (0x22e1, &['\u{227D}', '\u{0338}']),
    (0x1ee2, &['\u{004F}', '\u{031B}', '\u{0323}']),
    (0xf9c4, &['\u{9F8D}']),
    (0x1eda, &['\u{004F}', '\u{031B}', '\u{0301}']),
    (0xfa3d, &['\u{6094}']),
    (0x1f0a, &['\u{0391}', '\u{0313}', '\u{0300}']),
    (0xfad4, &['\u{4039}']),
    (0x95c, &['\u{0921}', '\u{093C}']),
    (0x1ff7, &['\u{03C9}', '\u{0342}', '\u{0345}']),
    (0x2f86b, &['\u{5B3E}']),
    (0x2f9d1, &['\u{8B8A}']),
    (0x1f83, &['\u{03B1}', '\u{0314}', '\u{0300}', '\u{0345}']),
    (0xf9f6, &['\u{81E8}']),
    (0x2f9b3, &['\u{8650}']),
    (0xf983, &['\u{65C5}']),
    (0xef, &['\u{0069}', '\u{0308}']),
    (0xf98f, &['\u{6190}']),
    (0x156, &['\u{0052}', '\u{0327}']),
    (0x1f4c, &['\u{039F}', '\u{0313}', '\u{0301}']),
    (0x958, &['\u{0915}', '\u{093C}']),
    (0x2f9f5, &['\u{9723}']),
    (0x2f9d9, &['\u{20804}']),
    (0x2f831, &['\u{537F}']),
    (0x2f9ee, &['\u{958B}']),
    (0x2f89a, &['\u{5F6B}']),
    (0xf955, &['\u{51CC}']),
    (0x2fa14, &['\u{2A291}']),
    (0x2f80a, &['\u{50E7}']),
    (0x1f49, &['\u{039F}', '\u{0314}']),
    (0x2f82c, &['\u{5349}']),
    (0x2f945, &['\u{771E}']),
    (0x2f998, &['\u{82E5}']),
    (0x1e1a, &['\u{0045}', '\u{0330}']),
    (0x2f82a, &['\u{5306}']),
    (0x2f93e, &['\u{3FFC}']),
    (0x22d, &['\u{006F}', '\u{0303}', '\u{0304}']),
    (0x1f81, &['\u{03B1}', '\u{0314}', '\u{0345}']),
    (0x1ed2, &['\u{004F}', '\u{0302}', '\u{0300}']),
    (0x1f21, &['\u{03B7}', '\u{0314}']),
    (0x2f9d7, &['\u{8D77}']),
    (0x1ead, &['\u{0061}', '\u{0323}', '\u{0302}']),
    (0xfb31, &['\u{05D1}', '\u{05BC}']),
    (0x2f8da, &['\u{6721}']),
    (0xb5c, &['\u{0B21}', '\u{0B3C}']),
    (0x2f9e7, &['\u{9238}']),
    (0x2f904, &['\u{6D78}']),
    (0x959, &['\u{0916}', '\u{093C}']),
    (0x158, &['\u{0052}', '\u{030C}']),
    (0x2f8ca, &['\u{2300A}']),
    (0x1b08, &['\u{1B07}', '\u{1B35}']),
    (0x2f9ad, &['\u{26F2C}']),
    (0x1e3e, &['\u{004D}', '\u{0301}']),
    (0x2f838, &['\u{20B63}']),
    (0x2f8ef, &['\u{6B21}']),
    (0x1ee, &['\u{01B7}', '\u{030C}']),
    (0xf953, &['\u{808B}']),
    (0x2329, &['\u{3008}']),
    (0xf961, &['\u{7387}']),
    (0x150, &['\u{004F}', '\u{030B}']),
    (0xfa58, &['\u{7E09}']),
    (0x1e46, &['\u{004E}', '\u{0323}']),
    (0x12e, &['\u{0049}', '\u{0328}']),
    (0x1f19, &['\u{0395}', '\u{0314}']),
    (0x2f82b, &['\u{5317}']),
    (0x2fa0c, &['\u{9CFD}']),
    (0x1edc, &['\u{004F}', '\u{031B}', '\u{0300}']),
    (0xfacd, &['\u{9B12}']),
    (0x2f8a0, &['\u{6081}']),
    (0x1f80, &['\u{03B1}', '\u{0313}', '\u{0345}']),
    (0x1eec, &['\u{0055}', '\u{031B}', '\u{0309}']),
    (0x2f9e1, &['\u{285ED}']),
    (0x2f8b6, &['\u{62D4}']),
    (0x1f93, &['\u{03B7}', '\u{0314}', '\u{0300}', '\u{0345}']),
    (0x2f986, &['\u{5AB5}']),
    (0x30b8, &['\u{30B7}', '\u{3099}']),
    (0x37e, &['\u{003B}']),
    (0x1fb8, &['\u{0391}', '\u{0306}']),
    (0xc9, &['\u{0045}', '\u{0301}']),
    (0x1e86, &['\u{0057}', '\u{0307}']),
    (0xfa57, &['\u{7DF4}']),
    (0x2f95d, &['\u{25AA7}']),
    (0x130, &['\u{0049}', '\u{0307}']),
    (0x2f933, &['\u{3F1B}']),
    (0x2f912, &['\u{6FC6}']),
    (0x4db, &['\u{04D9}', '\u{0308}']),
    (0x2f9c0, &['\u{87E1}']),
    (0xf904, &['\u{6ED1}']),
    (0x2f81a, &['\u{51AC}']),
    (0x4ea, &['\u{04E8}', '\u{0308}']),
    (0x3ae, &['\u{03B7}', '\u{0301}']),
    (0xf43, &['\u{0F42}', '\u{0FB7}']),
    (0x1ff4, &['\u{03C9}', '\u{0301}', '\u{0345}']),
    (0x1e23, &['\u{0068}', '\u{0307}']),
    (0xd6, &['\u{004F}', '\u{0308}']),
    (0x2f8b5, &['\u{62B1}']),
    (0x2f87b, &['\u{21DE4}']),
    (0x9cb, &['\u{09C7}', '\u{09BE}']),
    (0x1ec2, &['\u{0045}', '\u{0302}', '\u{0309}']),
    (0xfa4c, &['\u{793E}']),
    (0x3052, &['\u{3051}', '\u{3099}']),
    (0xd1, &['\u{004E}', '\u{0303}']),
    (0x2f818, &['\u{51A4}']),
];

pub(crate) const COMPATIBILITY_DECOMPOSED_SALT: &[u16] = &[
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x66,
    0x9d7,
    0x2cc,
    0x3,
    0xe3,
    0x5,
    0x0,
    0x0,
    0x1e,
    0x105,
    0x2,
    0x3,
    0x11,
    0x0,
    0x161,
    0x0,
    0x44,
    0x0,
    0x5,
    0x0,
    0x7d,
    0x0,
    0x0,
    0x0,
    0x0,
    0xa,
    0x122,
    0x1d,
    0x81,
    0x10,
    0x203,
    0x0,
    0x12,
    0x0,
    0xa,
    0x45,
    0x2,
    0x222,
    0x0,
    0x7a,
    0x12,
    0x13,
    0x3d,
    0x0,
    0x0,
    0x5,
    0x8e,
    0x0,
    0x0,
    0x137,
    0xd5,
    0x150,
    0x8,
    0x0,
    0x0,
    0x6,
    0x50,
    0x80,
    0x0,
    0x1,
    0x15,
    0x8,
    0xd6,
    0x88,
    0x4c,
    0x17,
    0x34,
    0x0,
    0x0,
    0x17b,
    0x7,
    0x1,
    0x18,
    0x26,
    0x4,
    0x1,
    0x0,
    0x46,
    0x9,
    0xa,
    0x2,
    0x0,
    0x1a,
    0x0,
    0x0,
    0x7,
    0x25,
    0x3a,
    0x78,
    0x0,
    0x52,
    0x0,
    0x9,
    0x0,
    0x45,
    0x7,
    0xc,
    0x5,
    0x25,
    0x97,
    0x6,
    0x7,
    0x0,
    0x0,
    0xd,
    0x59,
    0x0,
    0x3e,
    0x6,
    0x0,
    0x5b,
    0x4d,
    0x17,
    0xd,
    0x0,
    0x12,
    0xe,
    0xe,
    0x0,
    0x0,
    0xd,
    0x19,
    0x1b,
    0x19,
    0x9,
    0x0,
    0xa7,
    0x2,
    0x0,
    0x0,
    0x0,
    0x17,
    0x12c,
    0x0,
    0x0,
    0x4d,
    0xe,
    0x11,
    0x45,
    0x0,
    0x1,
    0x0,
    0x0,
    0x3,
    0x11,
    0x13,
    0xb,
    0xd,
    0x1,
    0x1f,
    0x3,
    0x1,
    0x0,
    0x5,
    0x2,
    0x3,
    0x0,
    0x7b,
    0x5,
    0xa,
    0x0,
    0x2c,
    0x0,
    0x1,
    0x80,
    0x87,
    0x0,
    0x7d,
    0x0,
    0x49,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x3c,
    0x1f,
    0x0,
    0x2,
    0xd,
    0x72,
    0x0,
    0x0,
    0x8,
    0x7,
    0x16,
    0x7,
    0x0,
    0x18,
    0x7,
    0x0,
    0x25,
    0x0,
    0x28,
    0x0,
    0x49,
    0x1f,
    0x3,
    0x0,
    0x2f,
    0x4,
    0x0,
    0x11,
    0x0,
    0x41,
    0x0,
    0x39,
    0x28,
    0x0,
    0xa,
    0x0,
    0x0,
    0x3,
    0xf,
    0x1,
    0x0,
    0x4,
    0x2,
    0x1b,
    0x0,
    0x0,
    0x0,
    0x24,
    0x1,
    0x1b,
    0x0,
    0x13,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x9,
    0x0,
    0x0,
    0x5,
    0x0,
    0x30,
    0x3,
    0x9,
    0x0,
    0x0,
    0x1,
    0x3,
    0x3,
    0x1,
    0x0,
    0x2,
    0x0,
    0x15,
    0x1,
    0x27,
    0x0,
    0x0,
    0x12,
    0x1,
    0x3,
    0x23,
    0x9,
    0x0,
    0x22,
    0x0,
    0x1,
    0x3,
    0x0,
    0x11,
    0x2,
    0x1,
    0x7,
    0x2e,
    0x1b,
    0x18,
    0x2,
    0x32,
    0x44,
    0xe,
    0x1e,
    0x0,
    0x1,
    0x0,
    0xb,
    0x0,
    0x1,
    0xe,
    0x0,
    0x1,
    0x6,
    0x0,
    0x0,
    0x72,
    0x1,
    0x0,
    0x0,
    0x6,
    0x0,
    0x0,
    0x13,
    0x0,
    0x0,
    0x19,
    0x0,
    0x2,
    0x0,
    0x7,
    0x3,
    0x0,
    0x2,
    0x0,
    0x8,
    0x1,
    0x4,
    0x2,
    0x0,
    0x1,
    0x49,
    0x13,
    0x1,
    0x8,
    0x1b,
    0x3,
    0x20,
    0x1,
    0x5,
    0x4,
    0x0,
    0x1c,
    0x4d,
    0x4,
    0x0,
    0x0,
    0x1,
    0x25,
    0x2,
    0x0,
    0x2e,
    0x0,
    0x4,
    0x0,
    0x0,
    0xd,
    0x14,
    0x0,
    0x0,
    0x5,
    0x56,
    0x19,
    0x15,
    0x4,
    0x0,
    0x6,
    0x0,
    0x2,
    0x14,
    0x6,
    0x7,
    0x7,
    0x3,
    0x1,
    0x0,
    0x1e,
    0x7,
    0xf,
    0x9,
    0x6,
    0x13,
    0x0,
    0x0,
    0x3,
    0x1,
    0x7,
    0x0,
    0xb,
    0xa,
    0x4,
    0x0,
    0x0,
    0x0,
    0x1,
    0x4,
    0x0,
    0x15,
    0x1b,
    0x11,
    0x6,
    0x1e,
    0x9,
    0x1,
    0x0,
    0x0,
    0x3,
    0x7,
    0x43,
    0x0,
    0x1,
    0x4,
    0x0,
    0x14,
    0x16,
    0x0,
    0x1e,
    0x1,
    0x16,
    0x5,
    0x17,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x11,
    0xe,
    0x0,
    0x0,
    0x1,
    0x0,
    0x9,
    0x0,
    0x0,
    0x21,
    0x27,
    0x61,
    0x3,
    0x0,
    0x0,
    0x1,
    0x1a,
    0x27,
    0xe,
    0x8,
    0x1b,
    0x1,
    0x1c,
    0x1b,
    0x0,
    0x2,
    0x3,
    0x0,
    0x4,
    0x0,
    0x0,
    0x1c,
    0x0,
    0x0,
    0x1f,
    0x0,
    0x0,
    0x3,
    0x0,
    0x1b,
    0x1,
    0x7,
    0x12,
    0x2,
    0x1,
    0x0,
    0x5,
    0x0,
    0x0,
    0x4,
    0xc,
    0xb,
    0x0,
    0x1a,
    0x30,
    0x0,
    0x12,
    0xa,
    0x5,
    0x0,
    0x16,
    0x2,
    0x16,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x1,
    0xd,
    0x0,
    0x8,
    0x0,
    0x0,
    0x1a,
    0x0,
    0xb,
    0x1,
    0x1,
    0x47,
    0x0,
    0x4,
    0xc,
    0x0,
    0x4,
    0xa,
    0xa,
    0x0,
    0x0,
    0x0,
    0x0,
    0x7,
    0x12,
    0x3,
    0x0,
    0x0,
    0x5,
    0x8,
    0x2,
    0x0,
    0x4,
    0x1b,
    0x0,
    0x6,
    0x0,
    0x5,
    0x0,
    0x10,
    0x0,
    0x1,
    0x1,
    0x3,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x1,
    0x11,
    0x13,
    0xf,
    0x2,
    0x0,
    0xe,
    0x15,
    0x0,
    0x7,
    0xc,
    0x28,
    0x2,
    0x6f,
    0x17,
    0x5,
    0x3,
    0x11,
    0x19,
    0x9,
    0x7,
    0xf,
    0x0,
    0x7,
    0x0,
    0x4,
    0x0,
    0x3,
    0x16,
    0x1e,
    0x6,
    0x0,
    0x2b,
    0x1,
    0x21,
    0x3,
    0x1,
    0x4,
    0x9,
    0x10,
    0x0,
    0x5,
    0x1d,
    0x3,
    0xe,
    0x1d,
    0x0,
    0x6,
    0x0,
    0x2,
    0x7,
    0x0,
    0x2,
    0x2,
    0xc,
    0x1,
    0x5,
    0x14,
    0x3,
    0x0,
    0x21,
    0x3,
    0x0,
    0x0,
    0x2,
    0x0,
    0x3,
    0x0,
    0x11,
    0x0,
    0x1b,
    0x3e,
    0x0,
    0xe,
    0x1,
    0x0,
    0x7,
    0x0,
    0x3,
    0x0,
    0xc,
    0x0,
    0x0,
    0x1,
    0x6,
    0x3d,
    0x9,
    0x4,
    0x0,
    0x2,
    0x0,
    0xa,
    0x0,
    0x4,
    0x1,
    0x5,
    0x1,
    0x3,
    0x0,
    0x5,
    0x8,
    0x0,
    0x4,
    0x0,
    0x0,
    0x0,
    0x8,
    0x0,
    0x0,
    0x1,
    0x4,
    0x0,
    0x1f,
    0x1,
    0xc,
    0x5,
    0x2,
    0x1,
    0x3,
    0x8,
    0x2,
    0x0,
    0x0,
    0x2,
    0x1,
    0x0,
    0x1,
    0x0,
    0x0,
    0xd,
    0x0,
    0xe,
    0x0,
    0x25,
    0x11,
    0x0,
    0x9,
    0x1,
    0x0,
    0x2,
    0x4,
    0x1,
    0x0,
    0x12,
    0x0,
    0x1,
    0x0,
    0x1a,
    0x0,
    0x15,
    0x1,
    0x10,
    0x1,
    0x0,
    0x0,
    0x0,
    0xd,
    0x2,
    0x0,
    0x5,
    0x12,
    0x5,
    0x0,
    0x3,
    0x3,
    0x13,
    0x0,
    0x19,
    0x11,
    0xa,
    0x0,
    0x0,
    0x0,
    0x1,
    0x5,
    0x8,
    0x2e,
    0x4,
    0x0,
    0x2,
    0x0,
    0x7,
    0x1,
    0x3,
    0x0,
    0x5,
    0x0,
    0xb,
    0xa,
    0x3,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x30,
    0x4,
    0x0,
    0x1,
    0x0,
    0x2,
    0x0,
    0x1,
    0x4,
    0x0,
    0x0,
    0x9,
    0x0,
    0x4,
    0x5,
    0x19,
    0x6,
    0x1,
    0x1,
    0x9,
    0x1,
    0x2,
    0x2,
    0x0,
    0x0,
    0x30,
    0x19,
    0x1,
    0x5,
    0x0,
    0x4,
    0xf,
    0x4,
    0x3,
    0x0,
    0x0,
    0x14,
    0x2,
    0x0,
    0x1,
    0xa,
    0x15,
    0xc,
    0x7,
    0x20,
    0x0,
    0x0,
    0x3,
    0x2,
    0x0,
    0x0,
    0x0,
    0x3,
    0xb,
    0x6,
    0xc,
    0x12,
    0x7,
    0x15,
    0x8,
    0x2,
    0x2,
    0x0,
    0x1,
    0x6,
    0x5,
    0x0,
    0x0,
    0x5,
    0x21,
    0x0,
    0xa,
    0x8,
    0x5,
    0x15,
    0x1,
    0x0,
    0x1,
    0x8,
    0x0,
    0x3,
    0x1,
    0x4,
    0x3,
    0x0,
    0x0,
    0x4,
    0x0,
    0x0,
    0x1,
    0x10,
    0x2,
    0x3,
    0x0,
    0x20,
    0x6,
    0x1,
    0x0,
    0x17,
    0x0,
    0x6,
    0x0,
    0x0,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x10,
    0x0,
    0x13,
    0x1,
    0x13,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1e,
    0x0,
    0x0,
    0x1,
    0x4,
    0x7,
    0x0,
    0x0,
    0x4,
    0x1c,
    0x3,
    0x7,
    0x5,
    0x2,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x3,
    0x0,
    0x6,
    0x1,
    0x1,
    0x7,
    0x0,
    0xd,
    0x0,
    0x0,
    0x1,
    0x1,
    0x2,
    0x0,
    0x0,
    0x5,
    0x2,
    0x3,
    0x4,
    0x0,
    0xd,
    0x9,
    0x4,
    0x2,
    0xe,
    0x0,
    0x0,
    0xa,
    0x2,
    0x0,
    0x0,
    0xf,
    0x0,
    0x0,
    0x1,
    0xa,
    0x2,
    0x0,
    0x2,
    0x1,
    0x0,
    0x9,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x3,
    0xa,
    0x0,
    0x3,
    0x0,
    0x2,
    0x5,
    0x5,
    0x1,
    0x6,
    0x2,
    0x0,
    0x5,
    0x1,
    0x0,
    0x1,
    0xa,
    0x0,
    0x2,
    0x27,
    0x1,
    0x0,
    0x3,
    0x0,
    0x0,
    0x1,
    0x7,
    0x3,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x1,
    0x0,
    0x0,
    0x2,
    0x9,
    0x0,
    0x3,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x7,
    0x1,
    0x0,
    0x2,
    0x2,
    0x2,
    0x3,
    0x1,
    0x4,
    0x3,
    0x2,
    0x7,
    0xb,
    0x0,
    0x0,
    0xe,
    0x1,
    0xd,
    0x1,
    0x0,
    0x8,
    0xa,
    0x15,
    0x0,
    0x0,
    0x14,
    0x4,
    0x0,
    0x0,
    0x7,
    0xc,
    0x1,
    0x0,
    0x0,
    0x8,
    0x7,
    0x0,
    0x4,
    0x6,
    0x9,
    0x2,
    0xb,
    0x2,
    0x0,
    0x6,
    0x7,
    0x4,
    0x1d,
    0x0,
    0x0,
    0xc,
    0x3,
    0x0,
    0x4,
    0x0,
    0x1b,
    0x1,
    0x12,
    0x0,
    0x0,
    0x6,
    0x11,
    0x1,
    0x1,
    0x1,
    0x9,
    0xa,
    0x0,
    0x10,
    0x4,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x8,
    0x0,
    0x1b,
    0xb,
    0x1,
    0x0,
    0xf,
    0x2,
    0x0,
    0x7,
    0xe,
    0x4,
    0x0,
    0xb,
    0x0,
    0x8,
    0x5,
    0x1,
    0x0,
    0x1,
    0x7,
    0x0,
    0x0,
    0x2,
    0x3,
    0x0,
    0x0,
    0x6,
    0x0,
    0x0,
    0x4,
    0x1,
    0x0,
    0xb,
    0x0,
    0x0,
    0x4,
    0x9,
    0x13,
    0x0,
    0x6,
    0x6,
    0x2,
    0x0,
    0x8,
    0x6,
    0x3,
    0x5,
    0x0,
    0x2,
    0x0,
    0x0,
    0x5,
    0xa,
    0x6,
    0x1,
    0x0,
    0x0,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x2,
    0x2,
    0x0,
    0x2,
    0x2,
    0x1,
    0xd,
    0x0,
    0x5,
    0x6,
    0x4,
    0x0,
    0x0,
    0x0,
    0x1c,
    0x0,
    0x0,
    0x18,
    0x2,
    0x8,
    0x2,
    0xb,
    0x0,
    0x0,
    0x1,
    0x3,
    0x6,
    0x1,
    0x0,
    0x1,
    0x3,
    0x0,
    0x0,
    0x5,
    0xa,
    0x9,
    0x0,
    0x1,
    0x3,
    0x0,
    0x0,
    0x1,
    0x3,
    0x9,
    0x1,
    0x25,
    0x0,
    0x1,
    0x9,
    0x2,
    0x1b,
    0x0,
    0x5,
    0x4,
    0x1,
    0xa,
    0xf,
    0x6,
    0x1,
    0xf,
    0x17,
    0x0,
    0xd,
    0x4,
    0x1,
    0x1,
    0x4,
    0x0,
    0x4,
    0x0,
    0x0,
    0x5,
    0x8,
    0x2,
    0x8,
    0x3,
    0x1,
    0x2,
    0x0,
    0x5,
    0x0,
    0x1,
    0x10,
    0x5,
    0x5,
    0x2,
    0x0,
    0x7,
    0x9,
    0x7,
    0x1,
    0x0,
    0x2,
    0x0,
    0x9,
    0x0,
    0x0,
    0x0,
    0x1,
    0x3,
    0xb,
    0x0,
    0x0,
    0x0,
    0x1,
    0xa,
    0x1,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x3,
    0x11,
    0x1,
    0x4,
    0x0,
    0x0,
    0x0,
    0x7,
    0xc,
    0x1,
    0x0,
    0x18,
    0xa,
    0x3,
    0x3,
    0x1,
    0x0,
    0x10,
    0x0,
    0x3,
    0x8,
    0x0,
    0x2,
    0x0,
    0xa,
    0x7,
    0x1,
    0x1,
    0x2,
    0xa,
    0x2,
    0x8,
    0x2,
    0x0,
    0x1,
    0x1,
    0x0,
    0x6,
    0x2,
    0x2,
    0x3,
    0x0,
    0x0,
    0xb,
    0x8,
    0x0,
    0x0,
    0x1,
    0x5,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0xf,
    0x3,
    0x0,
    0x2,
    0x2,
    0x0,
    0x0,
    0x0,
    0x9,
    0x6,
    0x0,
    0x2,
    0x0,
    0x2,
    0x2,
    0x4,
    0x2,
    0x17,
    0x0,
    0x1,
    0x4,
    0x3,
    0x6,
    0x0,
    0x1,
    0x2,
    0x1,
    0x6,
    0x3,
    0xa,
    0x0,
    0x0,
    0x0,
    0x9,
    0x3,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x6,
    0x2,
    0x0,
    0x7,
    0x0,
    0x2,
    0x1,
    0xf,
    0x0,
    0x0,
    0x0,
    0x4,
    0x3,
    0xa,
    0x0,
    0x0,
    0x0,
    0x0,
    0x11,
    0x5,
    0x9,
    0x7,
    0x1,
    0x7,
    0x5,
    0x1,
    0x0,
    0x0,
    0x0,
    0xc,
    0x1,
    0x7,
    0x0,
    0x0,
    0x2,
    0x1,
    0x0,
    0x0,
    0x0,
    0x7,
    0x2,
    0x7,
    0x15,
    0xe,
    0x2,
    0x9,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x5,
    0x3,
    0x1,
    0x4,
    0x1,
    0x0,
    0x7,
    0x1,
    0x1,
    0x1,
    0x3,
    0xc,
    0x2,
    0x2,
    0x1,
    0x6,
    0x2,
    0x2,
    0x0,
    0x3,
    0x1,
    0x0,
    0x1,
    0x5,
    0x1,
    0x6,
    0x0,
    0x0,
    0x0,
    0x0,
    0x5,
    0x11,
    0x2,
    0x1,
    0x2,
    0x9,
    0x0,
    0xe,
    0x2,
    0x0,
    0x8,
    0x2,
    0xd,
    0x1,
    0x2,
    0x4,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x5,
    0x0,
    0xa,
    0xa,
    0x1,
    0x6,
    0x7,
    0x1,
    0x0,
    0x2,
    0x4,
    0xd,
    0x1,
    0x0,
    0x0,
    0x6,
    0x3,
    0x2,
    0x2,
    0x2,
    0x0,
    0x6,
    0x0,
    0x4,
    0x3,
    0x6,
    0x9,
    0x1,
    0x1,
    0xe,
    0x0,
    0xe,
    0x2,
    0x0,
    0x3,
    0x0,
    0x5,
    0x10,
    0xf,
    0x0,
    0x1,
    0x8,
    0x3,
    0x0,
    0x0,
    0x2,
    0xb,
    0x3,
    0x0,
    0x3,
    0x3,
    0x3,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x2,
    0x0,
    0x5,
    0x3,
    0x4,
    0x1,
    0x1,
    0x3,
    0x0,
    0x6,
    0x0,
    0x1,
    0x4,
    0x0,
    0x4,
    0x0,
    0x1,
    0x0,
    0x0,
    0x3,
    0x0,
    0xe,
    0x0,
    0x0,
    0x0,
    0x2,
    0x1,
    0x1,
    0x0,
    0x9,
    0x3,
    0x0,
    0x0,
    0x0,
    0x6,
    0x1,
    0x0,
    0x7,
    0x4,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x2,
    0xe,
    0x0,
    0x3,
    0x3,
    0x5,
    0x3,
    0x0,
    0x3,
    0x1,
    0x1,
    0x4,
    0x4,
    0x0,
    0x6,
    0x5,
    0x5,
    0x4,
    0x1,
    0x3,
    0x0,
    0x0,
    0x0,
    0x5,
    0x5,
    0x0,
    0x1,
    0x0,
    0x1,
    0x0,
    0x0,
    0x4,
    0x8,
    0x0,
    0x2,
    0x0,
    0x1,
    0x4,
    0x5,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0xa,
    0xa,
    0x0,
    0x3,
    0x2,
    0x1,
    0x0,
    0x0,
    0x4,
    0x5,
    0x3,
    0x0,
    0x15,
    0x23,
    0x4,
    0x0,
    0x2,
    0x0,
    0x2,
    0x2,
    0x6,
    0x1,
    0x3,
    0x3,
    0x1,
    0x0,
    0x5,
    0x6,
    0xa,
    0x1,
    0x11,
    0x5,
    0x0,
    0xd,
    0x4,
    0x2,
    0x1,
    0x0,
    0x2,
    0xa,
    0x1,
    0x0,
    0x0,
    0x4,
    0x2,
    0x7,
    0x3,
    0x2,
    0x0,
    0x0,
    0x0,
    0x1,
    0x2,
    0x1,
    0x1,
    0x2,
    0x1,
    0x0,
    0x2,
    0x2,
    0x6,
    0xa,
    0x0,
    0x2,
    0x1,
    0x5,
    0x3,
    0x0,
    0x2,
    0x2,
    0x3,
    0x0,
    0x8,
    0x7,
    0x1,
    0x2,
    0x3,
    0x3,
    0x1a,
    0x2,
    0x1,
    0x10,
    0x0,
    0x2,
    0x1,
    0x0,
    0x4,
    0xa,
    0x2,
    0x6,
    0x0,
    0x1,
    0x1,
    0xc,
    0xf,
    0x0,
    0x1,
    0x5,
    0x0,
    0x1,
    0x0,
    0x1,
    0x0,
    0x8,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x3,
    0x2,
    0x1,
    0x0,
    0x3,
    0x5,
    0x0,
    0x9,
    0x3,
    0x0,
    0x2,
    0x0,
    0x0,
    0x1,
    0x0,
    0x1,
    0x4,
    0x1,
    0x0,
    0x0,
    0x5,
    0x1,
    0x1f,
    0x5,
    0x4,
    0x0,
    0x3,
    0x2,
    0x15,
    0x7,
    0x0,
    0x0,
    0xc,
    0x0,
    0x0,
    0x0,
    0x4,
    0x7,
    0x2,
    0x9,
    0x0,
    0x9,
    0x1,
    0xc,
    0x3,
    0x1,
    0xa,
    0x0,
    0x0,
    0x4,
    0x0,
    0x2,
    0x7,
    0x4,
    0x0,
    0x0,
    0x2,
    0x0,
    0x2,
    0x3,
    0x0,
    0x0,
    0x4,
    0x0,
    0x2,
    0x1,
    0x0,
    0x7,
    0x0,
    0x1,
    0x5,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x6,
    0x7,
    0x0,
    0x0,
    0xb,
    0xe,
    0x6,
    0x4,
    0x0,
    0x0,
    0x0,
    0x2,
    0xc,
    0x1,
    0x1,
    0x3,
    0x3,
    0x9,
    0x0,
    0x1,
    0x5,
    0x2,
    0x4,
    0x0,
    0x4,
    0x1,
    0x0,
    0x4,
    0x3,
    0x1,
    0x0,
    0x0,
    0x0,
    0x2,
    0x9,
    0x6,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x3,
    0x2,
    0x1,
    0x5,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x7,
    0x0,
    0x2,
    0x7,
    0x2,
    0x4,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x5,
    0x6,
    0x1,
    0x0,
    0x4,
    0x2,
    0x4,
    0x1,
    0x0,
    0x5,
    0x1,
    0x0,
    0x6,
    0x0,
    0x0,
    0x1,
    0x5,
    0x0,
    0x1,
    0x8,
    0x3,
    0x0,
    0x4,
    0x4,
    0x9,
    0x1,
    0x2,
    0x0,
    0x1,
    0x1,
    0x0,
    0x1,
    0xe,
    0x2,
    0x1,
    0x0,
    0x4,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x3,
    0x0,
    0x0,
    0x1,
    0x2,
    0x5,
    0x9,
    0x0,
    0x0,
    0x7,
    0x0,
    0x0,
    0x5,
    0x3,
    0x1,
    0x0,
    0x4,
    0xc,
    0x1,
    0xd,
    0x5,
    0x2,
    0x4,
    0x1,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x1,
    0x0,
    0x2,
    0x0,
    0x0,
    0x2,
    0x0,
    0x2,
    0x3,
    0x0,
    0x4,
    0x0,
    0x2,
    0x0,
    0x2,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x13,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x6,
    0x1,
    0x1,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x2,
    0x4,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x2,
    0x2,
    0x0,
    0x0,
    0x5,
    0x1,
    0x1,
    0x1,
    0x2,
    0x1,
    0x1,
    0x2,
    0x3,
    0x2,
    0x2,
    0x0,
    0x1,
    0x6,
    0x3,
    0x0,
    0x7,
    0x0,
    0x0,
    0x1,
    0x8,
    0x2,
    0x1,
    0x3,
    0x2,
    0x0,
    0x0,
    0x0,
    0x2,
    0xa,
    0x0,
    0x2,
    0x0,
    0xc,
    0x0,
    0x1,
    0x6,
    0x0,
    0x3,
    0xa,
    0x8,
    0x3,
    0x0,
    0x0,
    0x6,
    0x0,
    0x1,
    0x0,
    0x1,
    0x2,
    0x5,
    0x0,
    0x5,
    0x3,
    0x2,
    0x4,
    0x0,
    0x5,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x1,
    0x5,
    0x1,
    0x0,
    0x1,
    0x5,
    0x0,
    0x1,
    0x8,
    0x2,
    0x1,
    0x1,
    0x2,
    0x0,
    0x2,
    0x0,
    0x2,
    0x0,
    0x0,
    0x16,
    0x2,
    0x0,
    0x0,
    0x2,
    0x2,
    0x0,
    0x1,
    0x3,
    0x0,
    0x0,
    0x0,
    0x7,
    0x2,
    0x0,
    0x1,
    0x1,
    0x1,
    0x1,
    0x0,
    0x0,
    0x3,
    0x1,
    0x3,
    0x4,
    0x2,
    0x0,
    0x1,
    0x1,
    0x2,
    0x8,
    0x0,
    0x3,
    0x1,
    0x1,
    0x2,
    0xe,
    0x2,
    0x2,
    0x0,
    0x0,
    0x7,
    0x1,
    0x0,
    0x0,
    0x2,
    0x0,
    0x2,
    0x0,
    0x2,
    0x0,
    0x6,
    0x2,
    0x0,
    0x4,
    0x1,
    0x0,
    0x0,
    0x1,
    0x3,
    0x0,
    0x1,
    0x8,
    0x2,
    0x5,
    0x0,
    0x7,
    0x0,
    0x2,
    0x0,
    0x9,
    0x0,
    0x0,
    0x6,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x2,
    0x3,
    0x2,
    0x3,
    0x3,
    0x0,
    0x3,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x4,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x3,
    0x3,
    0x2,
    0x0,
    0x0,
    0xa,
    0x1,
    0x0,
    0x2,
    0x2,
    0x10,
    0x0,
    0x2,
    0x2,
    0x1,
    0x4,
    0xa,
    0x5,
    0x1,
    0x1,
    0x0,
    0x1,
    0x6,
    0x5,
    0x0,
    0x2,
    0x4,
    0x2,
    0x3,
    0x0,
    0x9,
    0x0,
    0x13,
    0x8,
    0x0,
    0x0,
    0x1,
    0x0,
    0x6,
    0x9,
    0x1,
    0x0,
    0x0,
    0x5,
    0x0,
    0x3,
    0x0,
    0x2,
    0x4,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x1,
    0x7,
    0x1,
    0x3,
    0x0,
    0x2,
    0x5,
    0x1,
    0x3,
    0x5,
    0x5,
    0xc,
    0x1,
    0x2,
    0x0,
    0x0,
    0x4,
    0x1,
    0x0,
    0x0,
    0x1,
    0x12,
    0x1,
    0x1,
    0x6,
    0x2,
    0x0,
    0x9,
    0xa,
    0x2,
    0x1,
    0x4,
    0x2,
    0x0,
    0x5,
    0x1,
    0x1,
    0x1,
    0x2,
    0x0,
    0x0,
    0x0,
    0x12,
    0x2,
    0x0,
    0x2,
    0x6,
    0x0,
    0x4,
    0x5,
    0x3,
    0x6,
    0x2,
    0x1,
    0x1,
    0x2,
    0x7,
    0x1,
    0x0,
    0x0,
    0x2,
    0x5,
    0xd,
    0x0,
    0xa,
    0x4,
    0x0,
    0x1,
    0x0,
    0x1,
    0x2,
    0x1,
    0x7,
    0x2,
    0x6,
    0x2,
    0x1,
    0x1,
    0x2,
    0x14,
    0x5,
    0x0,
    0x1,
    0x0,
    0x0,
    0x2,
    0x0,
    0x2,
    0x2,
    0x0,
    0x1,
    0x2,
    0x0,
    0x0,
    0x3,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x3,
    0x0,
    0x2,
    0x2,
    0x2,
    0x0,
    0x0,
    0x9,
    0x0,
    0x6,
    0x0,
    0x1,
    0x0,
    0x4,
    0x2,
    0x3,
    0x1,
    0x0,
    0x2,
    0x0,
    0x1,
    0x1,
    0x4,
    0x0,
    0x1,
    0x7,
    0x4,
    0x3,
    0x5,
    0x0,
    0x0,
    0x5,
    0x4,
    0x2,
    0x6,
    0x6,
    0x4,
    0x9,
    0x0,
    0x0,
    0x5,
    0x0,
    0x0,
    0x2,
    0x2,
    0x0,
    0x3,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x4,
    0x1,
    0x1,
    0x0,
    0x2,
    0x2,
    0x3,
    0x0,
    0x0,
    0x1,
    0x1,
    0x3,
    0x5,
    0x1,
    0x8,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x1,
    0x6,
    0x0,
    0x3,
    0x2,
    0x0,
    0x1,
    0x0,
    0x3,
    0x1,
    0x1,
    0x3,
    0x2,
    0x2,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x3,
    0x4,
    0x0,
    0xf,
    0x2,
    0x1,
    0x5,
    0x0,
    0x0,
    0x1,
    0x0,
    0x4,
    0x1,
    0x0,
    0x0,
    0x3,
    0x1,
    0x1,
    0x4,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x0,
    0x5,
    0xd,
    0x3,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x6,
    0x1,
    0x0,
    0x7,
    0x4,
    0x0,
    0x2,
    0x0,
    0x3,
    0x6,
    0x2,
    0x0,
    0x3,
    0x1,
    0x0,
    0x2,
    0x4,
    0x2,
    0x2,
    0x2,
    0x6,
    0x0,
    0x0,
    0x1,
    0x0,
    0x1,
    0x2,
    0x17,
    0x1,
    0x0,
    0x0,
    0x0,
    0x2,
    0x2,
    0x4,
    0x2,
    0x0,
    0x0,
    0xa,
    0x0,
    0x2,
    0x2,
    0x2,
    0x3,
    0x1,
    0x1,
    0x1,
    0x2,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0xb,
    0x1,
    0x1,
    0x1,
    0xb,
    0x0,
    0x0,
    0x2,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x7,
    0x0,
    0x0,
    0x1,
    0x14,
    0x0,
    0x0,
    0x4,
    0x0,
    0x0,
    0x1,
    0x3,
    0x0,
    0x4,
    0x1,
    0xb,
    0x5,
    0xa,
    0x0,
    0x1,
    0x2,
    0x0,
    0x4,
    0x0,
    0x1,
    0x1,
    0x3,
    0x0,
    0x2,
    0x8,
    0x3,
    0x2,
    0x0,
    0x0,
    0x6,
    0x5,
    0x4,
    0x6,
    0x0,
    0x1,
    0x1,
    0x1,
    0x4,
    0x0,
    0x3,
    0x3,
    0x1,
    0x2,
    0xa,
    0x3,
    0x2,
    0x1,
    0x0,
    0x7,
    0x0,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x2,
    0x2,
    0x0,
    0x0,
    0x1,
    0x2,
    0x1,
    0x5,
    0x1,
    0x3,
    0x0,
    0x3,
    0x2,
    0x1,
    0x3,
    0x0,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x2,
    0x2,
    0x0,
    0x2,
    0x2,
    0x1,
    0x3,
    0x4,
    0x4,
    0x1,
    0x1,
    0x2,
    0x0,
    0x0,
    0x1,
    0x2,
    0x7,
    0x5,
    0x2,
    0x1,
    0x5,
    0x0,
    0x4,
    0x3,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x2,
    0x1,
    0x1,
    0x6,
    0x3,
    0x0,
    0x0,
    0x1,
    0x1,
    0x1,
    0x0,
    0x0,
    0x1,
    0x1,
    0x4,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x7,
    0x0,
    0x3,
    0x2,
    0x3,
    0x2,
    0x1,
    0x0,
    0x1,
    0x1,
    0x0,
    0x2,
    0x2,
    0xa,
    0x1,
    0x0,
    0x0,
    0x0,
    0x3,
    0x8,
    0xa,
    0x3,
    0x3,
    0x1,
    0x2,
    0x0,
    0x4,
    0x1,
    0x0,
    0x0,
    0x7,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x6,
    0x0,
    0x2,
    0x0,
    0x1,
    0x1,
    0x2,
    0xe,
    0x2,
    0x1,
    0x1,
    0x1,
    0x2,
    0x0,
    0x0,
    0x4,
    0x1,
    0x0,
    0x0,
    0x6,
    0x6,
    0x1,
    0x1,
    0x0,
    0x1,
    0x2,
    0x8,
    0x3,
    0x0,
    0x1,
    0x5,
    0x1,
    0x0,
    0x2,
    0x1,
    0x4,
    0x2,
    0x0,
    0x1,
    0x9,
    0x0,
    0x0,
    0x1,
    0x0,
    0x2,
    0x0,
    0x4,
    0x1,
    0x0,
    0x2,
    0x1,
    0x0,
    0x1,
    0x1,
    0x5,
    0x1,
    0x0,
    0x3,
    0x0,
    0x9,
    0x1,
    0x1,
    0x7,
    0x0,
    0x2,
    0x1,
    0x6,
    0x0,
    0x5,
    0x0,
    0x8,
    0x11,
    0x0,
    0x6,
    0x1,
    0x7,
    0x0,
    0x2,
    0x0,
    0x4,
    0x1,
    0x1,
    0x0,
    0x4,
    0x4,
    0x5,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x0,
    0x3,
    0x0,
    0x0,
    0x9,
    0x0,
    0x0,
    0x8,
    0x1,
    0x5,
    0x1,
    0x0,
    0x1,
    0x1,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x7,
    0x1,
    0x0,
    0x6,
    0x1,
    0x5,
    0xa,
    0x2,
    0x3,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x3,
    0x2,
    0x0,
    0x0,
    0x13,
    0x0,
    0x0,
    0x3,
    0x0,
    0x2,
    0x0,
    0x0,
    0x1,
    0x0,
    0xb,
    0x1,
    0x2,
    0x0,
    0x0,
    0x1,
    0x0,
    0x1,
    0x3,
    0x1,
    0x1,
    0xd,
    0x3,
    0x5,
    0x1,
    0x0,
    0x1,
    0x7,
    0x0,
    0x3,
    0x1,
    0x1,
    0x8,
    0x0,
    0x3,
    0x8,
    0x3,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x5,
    0x2,
    0x2,
    0x2,
    0x0,
    0x2,
    0x1,
    0x0,
    0x2,
    0x1,
    0x0,
    0x0,
    0x1,
    0x2,
    0x5,
    0x0,
    0x3,
    0x2,
    0x0,
    0x2,
    0x0,
    0x0,
    0x4,
    0x0,
    0x1,
    0x3,
    0x5,
    0x0,
    0x2,
    0x1,
    0x8,
    0x1,
    0x3,
    0x1,
    0x0,
    0x8,
    0x3,
    0x1,
    0x4,
    0x0,
    0x0,
    0x1,
    0x7,
    0x0,
    0x2,
    0x0,
    0x7,
    0x2,
    0x0,
    0x1,
    0x1,
    0x1,
    0x6,
    0x2,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x3,
    0x2,
    0x1,
    0x0,
    0x3,
    0x1,
    0x1,
    0x1,
    0x0,
    0x2,
    0x1,
    0x3,
    0x2,
    0x0,
    0x1,
    0x1,
    0x2,
    0x1,
    0x0,
    0x1,
    0x1,
    0x1,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x1,
    0x1,
    0x1,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x1,
    0x3,
    0x2,
    0x4,
    0x1,
    0x0,
    0x1,
    0x1,
    0x0,
    0x3,
    0x0,
    0x0,
    0x1,
    0x5,
    0x3,
    0x0,
    0x0,
    0x2,
    0x4,
    0x9,
    0x0,
    0x5,
    0x3,
    0x1,
    0x0,
    0x1,
    0x3,
    0x2,
    0x3,
    0x1,
    0x1,
    0x0,
    0x3,
    0x1,
    0x1,
    0x2,
    0x1,
    0x2,
    0x0,
    0x3,
    0x7,
    0x1,
    0x1,
    0x0,
    0x1,
    0x2,
    0x3,
    0x0,
    0xe,
    0x2,
    0x1,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x2,
    0x3,
    0x0,
    0x1,
    0x0,
    0x1,
    0x1,
    0x0,
    0x2,
    0x1,
    0x0,
    0x0,
    0xa,
    0x0,
    0x0,
    0x0,
    0x3,
    0x3,
    0x2,
    0x7,
    0x1,
    0x1,
    0x1,
    0x2,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x3,
    0x2,
    0x0,
    0x2,
    0x3,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x4,
    0x0,
    0x1,
    0x0,
    0x1,
    0x1,
    0x0,
    0x3,
    0x5,
    0x1,
    0x0,
    0x1,
    0x0,
    0x0,
    0x2,
    0x3,
    0x0,
    0x3,
    0x1,
    0x0,
    0x2,
    0x7,
    0x1,
    0x1,
    0x2,
    0x7,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x0,
    0x0,
    0x4,
    0x2,
    0x2,
    0x7,
    0x2,
    0x4,
    0x2,
    0x1,
    0x5,
    0x2,
    0x0,
    0x1,
    0x0,
    0x1,
    0x1,
    0x6,
    0x0,
    0x0,
    0x5,
    0x5,
    0x1,
    0x1,
    0x4,
    0x2,
    0x0,
    0x0,
    0x0,
    0x3,
    0x3,
    0x1,
    0x1,
    0x5,
    0x1,
    0x1,
    0x1,
    0x0,
    0x0,
    0x4,
    0x2,
    0x0,
    0x0,
    0x0,
    0x4,
    0x2,
    0x1,
    0x0,
    0x1,
    0x0,
    0x1,
    0x2,
    0x3,
    0x2,
    0x3,
    0x0,
    0x1,
    0x0,
    0x3,
    0x4,
    0x5,
    0x0,
    0x1,
    0x1,
    0x1,
    0x3,
    0xa,
    0x1,
    0x3,
    0x1,
    0x0,
    0x1,
    0x2,
    0x3,
    0x7,
    0x0,
    0x3,
    0x1,
    0x1,
    0x0,
    0x3,
    0x0,
    0x8,
    0xa,
    0x1,
    0x3,
    0x0,
    0x0,
    0x1,
    0x4,
    0x0,
    0x7,
    0x0,
    0x0,
    0x1,
    0x1,
    0x0,
    0x3,
    0x5,
    0x0,
    0x1,
    0x1,
    0x4,
    0x4,
    0x0,
    0x0,
    0x5,
    0x1,
    0x1,
    0x3,
    0x0,
    0x4,
    0x1,
    0x2,
    0x4,
    0x2,
    0x3,
    0x0,
    0x2,
    0x1,
    0x1,
    0x2,
    0x0,
    0x2,
    0x1,
    0x1,
    0x1,
    0x3,
    0x1,
    0x4,
    0x3,
    0x20,
    0x4,
    0x0,
    0x1,
    0x0,
    0x5,
    0x0,
    0x3,
    0x2,
    0x1,
    0x0,
    0x2,
    0x4,
    0x5,
    0x0,
    0x2,
    0x6,
    0x0,
    0x0,
    0x1,
    0x1,
    0x0,
    0x1,
    0x0,
    0x0,
    0x2,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x5,
    0x0,
    0x0,
    0x3,
    0x4,
    0x1,
    0x0,
    0x0,
    0x0,
    0x2,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x2,
    0x0,
    0x0,
    0x1,
    0x5,
    0x0,
    0x4,
    0x0,
    0x0,
    0x0,
    0x0,
    0x3,
    0x2,
    0x3,
    0x0,
    0x0,
    0x1,
    0x1,
    0x0,
    0x7,
    0x3,
    0x0,
    0x5,
    0x6,
    0x0,
    0x2,
    0x0,
    0x2,
    0x1,
    0x1,
    0x4,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x1,
    0x4,
    0x0,
    0x1,
    0x1,
    0x1,
    0x0,
    0x0,
    0x1,
    0x3,
    0xf,
    0x0,
    0x3,
    0x0,
    0x2,
    0x0,
    0x3,
    0x2,
    0x5,
    0x2,
    0x0,
    0x2,
    0x1,
    0x0,
    0x0,
    0x1,
    0x6,
    0x1,
    0x0,
    0x1,
    0x3,
    0x0,
    0x1,
    0x3,
    0x0,
    0x2,
    0x1,
    0x3,
    0x4,
    0x4,
    0x1,
    0x1,
    0x1,
    0x1,
    0x0,
    0x1,
    0x1,
    0x0,
    0x1,
    0x1,
    0x1,
    0x0,
    0x3,
    0x3,
    0x2,
    0x1,
    0x0,
    0x4,
    0x2,
    0x2,
    0x4,
    0x1,
    0x0,
    0x0,
    0x1,
    0x1,
    0x2,
    0x1,
    0x0,
    0x2,
    0x0,
    0x3,
    0x7,
    0x1,
    0x4,
    0x1,
    0x3,
    0x1,
    0x1,
    0x5,
    0x5,
    0x0,
    0x3,
    0x0,
    0x0,
    0x1,
    0x0,
    0x1,
    0x1,
    0x1,
    0x3,
    0x0,
    0x0,
    0x1,
    0x1,
    0x2,
    0x0,
    0x3,
    0x0,
    0x1,
    0x7,
    0x2,
    0x0,
    0x2,
    0x0,
    0x1,
    0x0,
    0x1,
    0x0,
    0x5,
    0xd,
    0x1,
    0x0,
    0x0,
    0x0,
    0x3,
    0x5,
    0x0,
    0x1,
    0x3,
    0x1,
    0x0,
    0x0,
    0x2,
    0x1,
    0x2,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x2,
    0x1,
    0x0,
    0x2,
    0x3,
    0x1,
    0x1,
    0x0,
    0x2,
    0x5,
    0x1,
    0x3,
    0x1,
    0x1,
    0x1,
    0x1,
    0x0,
    0x0,
    0x2,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x2,
    0x2,
    0x3,
    0x1,
    0x0,
    0x1,
    0x6,
    0x0,
    0x1,
    0x4,
    0x0,
    0x1,
    0x0,
    0x6,
    0x1,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x6,
    0x0,
    0x2,
    0x1,
    0x0,
    0x0,
    0x1,
    0x2,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x1,
    0x0,
    0x3,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x3,
    0x2,
    0x0,
    0x0,
    0x0,
    0x2,
    0x3,
    0x1,
    0x1,
    0x0,
    0x3,
    0x0,
    0x0,
    0x1,
    0x0,
    0x2,
    0x2,
    0x2,
    0x2,
    0x1,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x2,
    0x1,
    0x1,
    0x0,
    0x4,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x0,
    0x1,
    0x4,
    0x1,
    0x1,
    0x1,
    0x0,
    0x7,
    0x0,
    0x0,
    0x3,
    0x4,
    0x0,
    0x4,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x5,
    0x0,
    0x3,
    0x4,
    0x3,
    0x0,
    0x1,
    0x2,
    0x1,
    0x2,
    0x1,
    0x1,
    0x4,
    0x4,
    0x2,
    0x2,
    0x2,
    0x5,
    0x0,
    0x3,
    0x1,
    0x2,
    0x0,
    0x0,
    0x2,
    0x0,
    0x1,
    0x2,
    0x0,
    0x4,
    0x1,
    0x0,
    0x1,
    0x4,
    0x1,
    0x0,
    0x5,
    0x4,
    0x3,
    0x1,
    0x0,
    0x1,
    0x0,
    0x1,
    0x0,
    0x1,
    0x2,
    0x0,
    0x1,
    0x0,
    0x1,
    0x0,
    0x1,
    0x0,
    0x3,
    0x7,
    0x0,
    0x2,
    0x0,
    0x1,
    0x0,
    0x1,
    0x2,
    0x9,
    0x1,
    0x3,
    0x3,
    0x1,
    0x0,
    0x3,
    0x0,
    0x2,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x3,
    0x1,
    0x0,
    0x0,
    0x8,
    0x2,
    0x3,
    0x1,
    0x2,
    0x1,
    0x3,
    0x0,
    0x3,
    0x0,
    0x0,
    0x3,
    0x0,
    0x1,
    0x0,
    0x1,
    0x2,
    0x3,
    0x6,
    0x4,
    0x0,
    0x2,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x1,
    0x4,
    0x1,
    0x1,
    0x0,
    0x5,
    0x1,
    0x0,
];
pub(crate) const COMPATIBILITY_DECOMPOSED_KV: &[(u32, &'static [char])] = &[
    (0x2f1f, &['\u{571F}']),
    (0x1d430, &['\u{0077}']),
    (0xfca0, &['\u{0628}', '\u{0647}']),
    (0x1d769, &['\u{03A4}']),
    (0x1d59, &['\u{1D1D}']),
    (0xfd72, &['\u{0637}', '\u{0645}', '\u{062D}']),
    (0x1d5a3, &['\u{0044}']),
    (0x1d4e2, &['\u{0053}']),
    (0xfbae, &['\u{06D2}']),
    (0x3396, &['\u{006D}', '\u{006C}']),
    (0x1d51a, &['\u{0057}']),
    (0x1d600, &['\u{0073}']),
    (0xfcff, &['\u{062D}', '\u{0649}']),
    (0xffea, &['\u{2191}']),
    (0x1d4b1, &['\u{0056}']),
    (0x207d, &['\u{0028}']),
    (0x1d5e0, &['\u{004D}']),
    (0x1ee6e, &['\u{0633}']),
    (0xfbec, &['\u{064A}', '\u{0654}', '\u{06D5}']),
    (0x33de, &['\u{0056}', '\u{2215}', '\u{006D}']),
    (0x2177, &['\u{0076}', '\u{0069}', '\u{0069}', '\u{0069}']),
    (0x1d4d3, &['\u{0044}']),
    (0x1ee8e, &['\u{0633}']),
    (0x1d695, &['\u{006C}']),
    (0xfed8, &['\u{0642}']),
    (0xfb7f, &['\u{0687}']),
    (0x247f, &['\u{0028}', '\u{0031}', '\u{0032}', '\u{0029}']),
    (0x33e0, &['\u{0031}', '\u{65E5}']),
    (0x2f0e, &['\u{51AB}']),
    (0xffac, &['\u{11B2}']),
    (0xff9b, &['\u{30ED}']),
    (0x2f4f, &['\u{6BCB}']),
    (0x1d4cb, &['\u{0076}']),
    (0x2148, &['\u{0069}']),
    (0x338a, &['\u{0070}', '\u{0046}']),
    (0x1d73c, &['\u{03B7}']),
    (0x1da8, &['\u{029D}']),
    (0xfeba, &['\u{0635}']),
    (0xff54, &['\u{0074}']),
    (0x1d48e, &['\u{006D}']),
    (0x1ee10, &['\u{0641}']),
    (0x1eeb3, &['\u{0631}']),
    (0x1d44e, &['\u{0061}']),
    (0x1d580, &['\u{0055}']),
    (0x1d7b4, &['\u{03BB}']),
    (0x2f4e, &['\u{6BB3}']),
    (0x1d594, &['\u{006F}']),
    (0x3224, &['\u{0028}', '\u{4E94}', '\u{0029}']),
    (0xffdb, &['\u{1174}']),
    (0x1d7ff, &['\u{0039}']),
    (0x3132, &['\u{1101}']),
    (0xfee9, &['\u{0647}']),
    (0x2fa2, &['\u{9091}']),
    (0xffbb, &['\u{110F}']),
    (0x1d46e, &['\u{0047}']),
    (0xfc7e, &['\u{0642}', '\u{0649}']),
    (0x1d560, &['\u{006F}']),
    (0xfd05, &['\u{0635}', '\u{0649}']),
    (0x325b, &['\u{0033}', '\u{0031}']),
    (0x1d77d, &['\u{03BE}']),
    (0x2170, &['\u{0069}']),
    (0x1d681, &['\u{0052}']),
    (0x3382, &['\u{03BC}', '\u{0041}']),
    (0x1d60a, &['\u{0043}']),
    (0xfbaf, &['\u{06D2}']),
    (0x2f24, &['\u{5927}']),
    (0x213f, &['\u{03A0}']),
    (0x1d43, &['\u{0061}']),
    (0xfec2, &['\u{0637}']),
    (0x33d5, &['\u{006D}', '\u{0069}', '\u{006C}']),
    (0xfb67, &['\u{0679}']),
    (0x1d446, &['\u{0053}']),
    (0x1d7a1, &['\u{0398}']),
    (0x2f7b, &['\u{7FBD}']),
    (0xff7d, &['\u{30B9}']),
    (0xfea2, &['\u{062D}']),
    (0xfca7, &['\u{062C}', '\u{062D}']),
    (0x1d484, &['\u{0063}']),
    (0xfc19, &['\u{062E}', '\u{062C}']),
    (0xfd99, &['\u{0646}', '\u{062C}', '\u{0649}']),
    (0xfb78, &['\u{0683}']),
    (0xfe58, &['\u{2014}']),
    (0x32ee, &['\u{30DE}']),
    (0x1f236, &['\u{6709}']),
    (0x1d466, &['\u{0079}']),
    (0x32bb, &['\u{0034}', '\u{0036}']),
    (0x1f14e, &['\u{0050}', '\u{0050}', '\u{0056}']),
    (0x1ee37, &['\u{062E}']),
    (0x2490, &['\u{0039}', '\u{002E}']),
    (0xff8a, &['\u{30CF}']),
    (0x1d576, &['\u{004B}']),
    (0xff6a, &['\u{30A7}']),
    (0xff40, &['\u{0060}']),
    (0x1f124, &['\u{0028}', '\u{0055}', '\u{0029}']),
    (0x2db, &['\u{0020}', '\u{0328}']),
    (0x3230, &['\u{0028}', '\u{65E5}', '\u{0029}']),
    (0x1d5cd, &['\u{0074}']),
    (0x1d7b1, &['\u{03B8}']),
    (0x2f26, &['\u{5B50}']),
    (0x323a, &['\u{0028}', '\u{547C}', '\u{0029}']),
    (0x1d706, &['\u{03BB}']),
    (0x33cf, &['\u{006B}', '\u{0074}']),
    (0x325a, &['\u{0033}', '\u{0030}']),
    (0xfb8e, &['\u{06A9}']),
    (0xfe5b, &['\u{007B}']),
    (0x1d5b6, &['\u{0057}']),
    (0xfd3b, &['\u{0638}', '\u{0645}']),
    (0x1ee4e, &['\u{0633}']),
    (0xfe98, &['\u{062A}']),
    (0x1d5ea, &['\u{0057}']),
    (0x1d563, &['\u{0072}']),
    (0x334c, &['\u{30E1}', '\u{30AB}', '\u{3099}', '\u{30C8}', '\u{30F3}']),
    (0xfee2, &['\u{0645}']),
    (0x1f141, &['\u{0052}']),
    (0x2f06, &['\u{4E8C}']),
    (0x32cf, &['\u{004C}', '\u{0054}', '\u{0044}']),
    (0x2466, &['\u{0037}']),
    (0xfb13, &['\u{0574}', '\u{0576}']),
    (0x1d49c, &['\u{0041}']),
    (0x1d63c, &['\u{0041}']),
    (0x1f220, &['\u{521D}']),
    (0x2f8b, &['\u{8278}']),
    (0x2048, &['\u{003F}', '\u{0021}']),
    (0x32d5, &['\u{30AB}']),
    (0x1d423, &['\u{006A}']),
    (0xfc49, &['\u{0645}', '\u{0649}']),
    (0x32d3, &['\u{30A8}']),
    (0xff53, &['\u{0073}']),
    (0x222c, &['\u{222B}', '\u{222B}']),
    (0x248a, &['\u{0033}', '\u{002E}']),
    (0x32c6, &['\u{0037}', '\u{6708}']),
    (0x208c, &['\u{003D}']),
    (0x1d680, &['\u{0051}']),
    (0xfb71, &['\u{06A6}']),
    (0x1d773, &['\u{03B4}']),
    (0xfc09, &['\u{0628}', '\u{0649}']),
    (0xfcd7, &['\u{0647}', '\u{062C}']),
    (0x1d46d, &['\u{0046}']),
    (0x2f74, &['\u{7ACB}']),
    (0xfbe5, &['\u{06D0}']),
    (0x32b1, &['\u{0033}', '\u{0036}']),
    (0xfda0, &['\u{062A}', '\u{062C}', '\u{0649}']),
    (0x1da0, &['\u{0066}']),
    (0x1d50e, &['\u{004B}']),
    (0xfca8, &['\u{062C}', '\u{0645}']),
    (0x1d7a2, &['\u{03A3}']),
    (0x3261, &['\u{1102}']),
    (0x1d51, &['\u{014B}']),
    (0x1d6c8, &['\u{03B7}']),
    (0x1d51f, &['\u{0062}']),
    (0x1d689, &['\u{005A}']),
    (0x1d793, &['\u{0394}']),
    (0x319e, &['\u{5730}']),
    (0x3282, &['\u{4E09}']),
    (0x3374, &['\u{0062}', '\u{0061}', '\u{0072}']),
    (0x3194, &['\u{4E09}']),
    (0xffad, &['\u{11B3}']),
    (0x1f139, &['\u{004A}']),
    (0x2f59, &['\u{723F}']),
    (0x3290, &['\u{65E5}']),
    (0x1d429, &['\u{0070}']),
    (0x3246, &['\u{6587}']),
    (0x1d5c6, &['\u{006D}']),
    (0x1d45c, &['\u{006F}']),
    (0x1d7b5, &['\u{03BC}']),
    (0x2f11, &['\u{5200}']),
    (0x2fb4, &['\u{9801}']),
    (0x1d781, &['\u{03C2}']),
    (0x1ee21, &['\u{0628}']),
    (0x1ee47, &['\u{062D}']),
    (0xff43, &['\u{0063}']),
    (0x316f, &['\u{11DD}']),
    (0xfef7, &['\u{0644}', '\u{0627}', '\u{0654}']),
    (0x1d7aa, &['\u{03B1}']),
    (0x2f7d, &['\u{800C}']),
    (0x207c, &['\u{003D}']),
    (0x33ec, &['\u{0031}', '\u{0033}', '\u{65E5}']),
    (0x1d6db, &['\u{2202}']),
    (0x2fb0, &['\u{9769}']),
    (0x1ee0f, &['\u{0639}']),
    (0x33ee, &['\u{0031}', '\u{0035}', '\u{65E5}']),
    (0x3202, &['\u{0028}', '\u{1103}', '\u{0029}']),
    (0x1d4d2, &['\u{0043}']),
    (0x1d694, &['\u{006B}']),
    (0x1d7b9, &['\u{03C0}']),
    (0x3299, &['\u{79D8}']),
    (0x1d6b6, &['\u{039F}']),
    (0x338f, &['\u{006B}', '\u{0067}']),
    (0x1d7ea, &['\u{0038}']),
    (0x1d4b0, &['\u{0055}']),
    (0x315d, &['\u{116F}']),
    (0x33d9, &['\u{0050}', '\u{0050}', '\u{004D}']),
    (0x1d5a8, &['\u{0049}']),
    (0x24d5, &['\u{0066}']),
    (0x1d510, &['\u{004D}']),
    (0xfcae, &['\u{0633}', '\u{062D}']),
    (0x2121, &['\u{0054}', '\u{0045}', '\u{004C}']),
    (0xfd5a, &['\u{062D}', '\u{0645}', '\u{064A}']),
    (0x1d41e, &['\u{0065}']),
    (0x1d514, &['\u{0051}']),
    (0xff85, &['\u{30CA}']),
    (0xfdc1, &['\u{0641}', '\u{0645}', '\u{064A}']),
    (0x1d6d2, &['\u{03C1}']),
    (0xfc72, &['\u{062A}', '\u{0645}']),
    (0x1d7fd, &['\u{0037}']),
    (0xfd94, &['\u{0647}', '\u{0645}', '\u{0645}']),
    (0x1d76c, &['\u{03A7}']),
    (0x333e, &['\u{30DB}', '\u{3099}', '\u{30EB}', '\u{30C8}']),
    (0x1d67a, &['\u{004B}']),
    (0x217e, &['\u{0064}']),
    (0x2b7, &['\u{0077}']),
    (0x1d458, &['\u{006B}']),
    (0xfbfa, &['\u{064A}', '\u{0654}', '\u{0649}']),
    (0xfeb3, &['\u{0633}']),
    (0xfb5f, &['\u{067A}']),
    (0xfb79, &['\u{0683}']),
    (0x315a, &['\u{116C}']),
    (0x1d4a9, &['\u{004E}']),
    (0x1d47a, &['\u{0053}']),
    (0x1c4, &['\u{0044}', '\u{005A}', '\u{030C}']),
    (0x3156, &['\u{1168}']),
    (0x24c8, &['\u{0053}']),
    (0x1d418, &['\u{0059}']),
    (0x2f6c, &['\u{76EE}']),
    (0x1d475, &['\u{004E}']),
    (0x1d768, &['\u{03A3}']),
    (0x1d6d7, &['\u{03C6}']),
    (0x1f22e, &['\u{53F3}']),
    (0x1d7c9, &['\u{03C0}']),
    (0x2086, &['\u{0036}']),
    (0x1d64, &['\u{0075}']),
    (0x2006, &['\u{0020}']),
    (0xfc69, &['\u{064A}', '\u{0654}', '\u{064A}']),
    (0x1d5fa, &['\u{006D}']),
    (0x2f0a, &['\u{5165}']),
    (0xfe4a, &['\u{0020}', '\u{0305}']),
    (0xfe6a, &['\u{0025}']),
    (0x1d6c2, &['\u{03B1}']),
    (0xfd7d, &['\u{0641}', '\u{062E}', '\u{0645}']),
    (0x3370, &['\u{0032}', '\u{0034}', '\u{70B9}']),
    (0x326f, &['\u{1102}', '\u{1161}']),
    (0x3183, &['\u{11F2}']),
    (0xfb00, &['\u{0066}', '\u{0066}']),
    (0xff12, &['\u{0032}']),
    (0x1d439, &['\u{0046}']),
    (0x1d5ff, &['\u{0072}']),
    (0x1ee1b, &['\u{063A}']),
    (0xfcee, &['\u{0646}', '\u{0645}']),
    (0xfbf6, &['\u{064A}', '\u{0654}', '\u{06D0}']),
    (0x1d4be, &['\u{0069}']),
    (0x2f8f, &['\u{884C}']),
    (0x1f211, &['\u{5B57}']),
    (0x3182, &['\u{11F1}']),
    (0x1d760, &['\u{039B}']),
    (0xfe5e, &['\u{3015}']),
    (0x1ee32, &['\u{0642}']),
    (0x3225, &['\u{0028}', '\u{516D}', '\u{0029}']),
    (0xfb03, &['\u{0066}', '\u{0066}', '\u{0069}']),
    (0x1ee15, &['\u{062A}']),
    (0x1d4af, &['\u{0054}']),
    (0x24c7, &['\u{0052}']),
    (0x1d7ed, &['\u{0031}']),
    (0x1d63b, &['\u{007A}']),
    (0x303a, &['\u{5345}']),
    (0x1d486, &['\u{0065}']),
    (0x2467, &['\u{0038}']),
    (0x2fc8, &['\u{9EC3}']),
    (0x1d4d9, &['\u{004A}']),
    (0x3d1, &['\u{03B8}']),
    (0xfce9, &['\u{0634}', '\u{0645}']),
    (0x32cd, &['\u{0065}', '\u{0072}', '\u{0067}']),
    (0xfb54, &['\u{067B}']),
    (0x1d7de, &['\u{0036}']),
    (0x2496, &['\u{0031}', '\u{0035}', '\u{002E}']),
    (0x217b, &['\u{0078}', '\u{0069}', '\u{0069}']),
    (0x3390, &['\u{0048}', '\u{007A}']),
    (0x338b, &['\u{006E}', '\u{0046}']),
    (0xfc75, &['\u{062A}', '\u{064A}']),
    (0xfc6b, &['\u{0628}', '\u{0632}']),
    (0x1eea8, &['\u{0637}']),
    (0x24af, &['\u{0028}', '\u{0074}', '\u{0029}']),
    (0x1f223, &['\u{8CA9}']),
    (0xff7a, &['\u{30B3}']),
    (0xff95, &['\u{30E6}']),
    (0xfdac, &['\u{0644}', '\u{062C}', '\u{064A}']),
    (0x33c3, &['\u{0042}', '\u{0071}']),
    (0x32f2, &['\u{30E2}']),
    (0x3308, &['\u{30A8}', '\u{30FC}', '\u{30AB}', '\u{30FC}']),
    (0x1f241, &['\u{3014}', '\u{4E09}', '\u{3015}']),
    (0x1d2e, &['\u{0042}']),
    (0x1d40f, &['\u{0050}']),
    (0x3f1, &['\u{03C1}']),
    (0x2078, &['\u{0038}']),
    (0x1d66c, &['\u{0077}']),
    (0xfb8d, &['\u{0691}']),
    (0x320b, &['\u{0028}', '\u{1110}', '\u{0029}']),
    (0x1d6d6, &['\u{03C5}']),
    (0x1d573, &['\u{0048}']),
    (0x1d6c9, &['\u{03B8}']),
    (0x3330, &['\u{30D2}', '\u{309A}', '\u{30B3}']),
    (0x2093, &['\u{0078}']),
    (0x1d43d, &['\u{004A}']),
    (0xff9a, &['\u{30EC}']),
    (0xfb21, &['\u{05D0}']),
    (0xfc26, &['\u{0637}', '\u{062D}']),
    (0x2f20, &['\u{58EB}']),
    (0x3294, &['\u{540D}']),
    (0x339a, &['\u{006E}', '\u{006D}']),
    (0xfcbc, &['\u{063A}', '\u{062C}']),
    (0x314c, &['\u{1110}']),
    (0x321e, &['\u{0028}', '\u{110B}', '\u{1169}', '\u{1112}', '\u{116E}', '\u{0029}']),
    (0xfb8b, &['\u{0698}']),
    (0x212c, &['\u{0042}']),
    (0x1d687, &['\u{0058}']),
    (0x1d488, &['\u{0067}']),
    (0x2f68, &['\u{7676}']),
    (0xfe83, &['\u{0627}', '\u{0654}']),
    (0x1d59c, &['\u{0077}']),
    (0xfd55, &['\u{062A}', '\u{0645}', '\u{062C}']),
    (0x1f145, &['\u{0056}']),
    (0x1d5d2, &['\u{0079}']),
    (0x3328, &['\u{30CA}', '\u{30CE}']),
    (0xff97, &['\u{30E9}']),
    (0x216c, &['\u{004C}']),
    (0xfd35, &['\u{0633}', '\u{062D}']),
    (0x1d796, &['\u{0397}']),
    (0x2fb7, &['\u{98DF}']),
    (0xfcdd, &['\u{064A}', '\u{0645}']),
    (0xfe38, &['\u{007D}']),
    (0x1ee72, &['\u{0642}']),
    (0x1d5d3, &['\u{007A}']),
    (0x33c6, &['\u{0043}', '\u{2215}', '\u{006B}', '\u{0067}']),
    (0x330f, &['\u{30AB}', '\u{3099}', '\u{30F3}', '\u{30DE}']),
    (0x32eb, &['\u{30D5}']),
    (0xfef5, &['\u{0644}', '\u{0627}', '\u{0653}']),
    (0xfd56, &['\u{062A}', '\u{0645}', '\u{062D}']),
    (0x1d44c, &['\u{0059}']),
    (0x1d5f3, &['\u{0066}']),
    (0x2479, &['\u{0028}', '\u{0036}', '\u{0029}']),
    (0xfb92, &['\u{06AF}']),
    (0x2098, &['\u{006D}']),
    (0x1fdf, &['\u{0020}', '\u{0314}', '\u{0342}']),
    (0xfed5, &['\u{0642}']),
    (0xfc1f, &['\u{0633}', '\u{0645}']),
    (0xfc18, &['\u{062D}', '\u{0645}']),
    (0x3140, &['\u{111A}']),
    (0xfeac, &['\u{0630}']),
    (0x3155, &['\u{1167}']),
    (0xfcc0, &['\u{0641}', '\u{062E}']),
    (0x1dbb, &['\u{007A}']),
    (0x33bd, &['\u{006D}', '\u{0057}']),
    (0x1d666, &['\u{0071}']),
    (0x2124, &['\u{005A}']),
    (0x3d0, &['\u{03B2}']),
    (0x33d2, &['\u{006C}', '\u{006F}', '\u{0067}']),
    (0x1f112, &['\u{0028}', '\u{0043}', '\u{0029}']),
    (0x1d37, &['\u{004B}']),
    (0x2057, &['\u{2032}', '\u{2032}', '\u{2032}', '\u{2032}']),
    (0x2105, &['\u{0063}', '\u{002F}', '\u{006F}']),
    (0x1d65a, &['\u{0065}']),
    (0xfee5, &['\u{0646}']),
    (0x385, &['\u{0020}', '\u{0308}', '\u{0301}']),
    (0x2f71, &['\u{79B8}']),
    (0x1f103, &['\u{0032}', '\u{002C}']),
    (0xfe13, &['\u{003A}']),
    (0x1d7ab, &['\u{03B2}']),
    (0x3203, &['\u{0028}', '\u{1105}', '\u{0029}']),
    (0x1d7d7, &['\u{0039}']),
    (0x1d476, &['\u{004F}']),
    (0x33dc, &['\u{0053}', '\u{0076}']),
    (0xfcb4, &['\u{0636}', '\u{062C}']),
    (0xff49, &['\u{0069}']),
    (0x32a6, &['\u{4E0B}']),
    (0xfea6, &['\u{062E}']),
    (0x32ac, &['\u{76E3}']),
    (0x1d51b, &['\u{0058}']),
    (0xff1e, &['\u{003E}']),
    (0xffe6, &['\u{20A9}']),
    (0xffc7, &['\u{1166}']),
    (0xaa, &['\u{0061}']),
    (0xffee, &['\u{25CB}']),
    (0x1d777, &['\u{03B8}']),
    (0xfcd2, &['\u{0646}', '\u{062C}']),
    (0x1d5de, &['\u{004B}']),
    (0xfba9, &['\u{06C1}']),
    (0x1d47b, &['\u{0054}']),
    (0x1f227, &['\u{6295}']),
    (0xfd71, &['\u{0637}', '\u{0645}', '\u{062D}']),
    (0x207b, &['\u{2212}']),
    (0x33d6, &['\u{006D}', '\u{006F}', '\u{006C}']),
    (0x3345, &['\u{30DE}', '\u{30C3}', '\u{30CF}']),
    (0x1ee5b, &['\u{063A}']),
    (0x2f5c, &['\u{725B}']),
    (0x1d472, &['\u{004B}']),
    (0x1d41c, &['\u{0063}']),
    (0x1f235, &['\u{6E80}']),
    (0x1d6de, &['\u{03BA}']),
    (0x677, &['\u{06C7}', '\u{0674}']),
    (0x1d7c2, &['\u{03C9}']),
    (0x2fa3, &['\u{9149}']),
    (0xfd59, &['\u{062C}', '\u{0645}', '\u{062D}']),
    (0xfe34, &['\u{005F}']),
    (0xff22, &['\u{0042}']),
    (0x1d501, &['\u{0078}']),
    (0x1d799, &['\u{039A}']),
    (0x1d75d, &['\u{0398}']),
    (0x1d492, &['\u{0071}']),
    (0x1f147, &['\u{0058}']),
    (0xfbf9, &['\u{064A}', '\u{0654}', '\u{0649}']),
    (0x1d6d8, &['\u{03C7}']),
    (0x1d4ac, &['\u{0051}']),
    (0xfecd, &['\u{063A}']),
    (0x1d726, &['\u{039B}']),
    (0xfc2c, &['\u{063A}', '\u{0645}']),
    (0x1d74a, &['\u{03C5}']),
    (0x1d6f3, &['\u{0398}']),
    (0xfce7, &['\u{0633}', '\u{0645}']),
    (0x322e, &['\u{0028}', '\u{91D1}', '\u{0029}']),
    (0x33b1, &['\u{006E}', '\u{0073}']),
    (0x3154, &['\u{1166}']),
    (0xfe89, &['\u{064A}', '\u{0654}']),
    (0x2047, &['\u{003F}', '\u{003F}']),
    (0x3266, &['\u{1109}']),
    (0x1d7b2, &['\u{03B9}']),
    (0xfed0, &['\u{063A}']),
    (0x2fce, &['\u{9F13}']),
    (0xffdc, &['\u{1175}']),
    (0x1ee4d, &['\u{0646}']),
    (0x1f214, &['\u{4E8C}']),
    (0x2485, &['\u{0028}', '\u{0031}', '\u{0038}', '\u{0029}']),
    (0x2ef3, &['\u{9F9F}']),
    (0xffe2, &['\u{00AC}']),
    (0x222f, &['\u{222E}', '\u{222E}']),
    (0x336d, &['\u{0032}', '\u{0031}', '\u{70B9}']),
    (0x1d70a, &['\u{03BF}']),
    (0x2fb3, &['\u{97F3}']),
    (0x24e8, &['\u{0079}']),
    (0x1ee82, &['\u{062C}']),
    (0xffa6, &['\u{11AD}']),
    (0x3303, &['\u{30A2}', '\u{30FC}', '\u{30EB}']),
    (0x24ac, &['\u{0028}', '\u{0071}', '\u{0029}']),
    (0x2470, &['\u{0031}', '\u{0037}']),
    (0x1eea3, &['\u{062F}']),
    (0xff8b, &['\u{30D2}']),
    (0xfb70, &['\u{06A6}']),
    (0x320f, &['\u{0028}', '\u{1102}', '\u{1161}', '\u{0029}']),
    (0x3281, &['\u{4E8C}']),
    (0x1d79c, &['\u{039D}']),
    (0xffa0, &['\u{1160}']),
    (0x1d78c, &['\u{03BA}']),
    (0xff0d, &['\u{002D}']),
    (0x1d7c0, &['\u{03C7}']),
    (0x587, &['\u{0565}', '\u{0582}']),
    (0x24da, &['\u{006B}']),
    (0x1d58, &['\u{0075}']),
    (0xfdbc, &['\u{0644}', '\u{062C}', '\u{0645}']),
    (0x2471, &['\u{0031}', '\u{0038}']),
    (0x20a8, &['\u{0052}', '\u{0073}']),
    (0x32e2, &['\u{30C6}']),
    (0x2c7d, &['\u{0056}']),
    (0x3312, &['\u{30AD}', '\u{30E5}', '\u{30EA}', '\u{30FC}']),
    (0x329d, &['\u{512A}']),
    (0x1d3e, &['\u{0050}']),
    (0x325f, &['\u{0033}', '\u{0035}']),
    (0x1d4f, &['\u{006B}']),
    (0x320c, &['\u{0028}', '\u{1111}', '\u{0029}']),
    (0xffaf, &['\u{11B5}']),
    (0x1d406, &['\u{0047}']),
    (0xfcca, &['\u{0644}', '\u{062D}']),
    (0x2d6f, &['\u{2D61}']),
    (0x33e1, &['\u{0032}', '\u{65E5}']),
    (0x1d415, &['\u{0056}']),
    (0x1d770, &['\u{03B1}']),
    (0x1ee49, &['\u{064A}']),
    (0x1d79f, &['\u{03A0}']),
    (0xfca5, &['\u{062A}', '\u{0647}']),
    (0xff13, &['\u{0033}']),
    (0x3253, &['\u{0032}', '\u{0033}']),
    (0xfed6, &['\u{0642}']),
    (0x1d6b2, &['\u{039B}']),
    (0xfdfc, &['\u{0631}', '\u{06CC}', '\u{0627}', '\u{0644}']),
    (0xff46, &['\u{0066}']),
    (0x3343, &['\u{30DE}', '\u{30A4}', '\u{30AF}', '\u{30ED}']),
    (0x3322, &['\u{30BB}', '\u{30F3}', '\u{30C1}']),
    (0xfcfa, &['\u{063A}', '\u{064A}']),
    (0xfd28, &['\u{0634}', '\u{0645}']),
    (0x1d7f3, &['\u{0037}']),
    (0x3376, &['\u{0070}', '\u{0063}']),
    (0x1f202, &['\u{30B5}']),
    (0x1d619, &['\u{0052}']),
    (0xfcd4, &['\u{0646}', '\u{062E}']),
    (0x33c8, &['\u{0064}', '\u{0042}']),
    (0x32ca, &['\u{0031}', '\u{0031}', '\u{6708}']),
    (0x1ee0b, &['\u{0644}']),
    (0xfdc7, &['\u{0646}', '\u{062C}', '\u{064A}']),
    (0xffc5, &['\u{1164}']),
    (0x1d6dc, &['\u{03B5}']),
    (0x2106, &['\u{0063}', '\u{002F}', '\u{0075}']),
    (0xfe9b, &['\u{062B}']),
    (0xfd08, &['\u{0636}', '\u{064A}']),
    (0xfc7b, &['\u{062B}', '\u{064A}']),
    (0x2025, &['\u{002E}', '\u{002E}']),
    (0xfe17, &['\u{3016}']),
    (0x330d, &['\u{30AB}', '\u{30ED}', '\u{30EA}', '\u{30FC}']),
    (0x1d4d4, &['\u{0045}']),
    (0xfb5a, &['\u{0680}']),
    (0x1d648, &['\u{004D}']),
    (0x33bb, &['\u{006E}', '\u{0057}']),
    (0x328e, &['\u{91D1}']),
    (0x1d795, &['\u{0396}']),
    (0x2488, &['\u{0031}', '\u{002E}']),
    (0xfc4c, &['\u{0646}', '\u{062D}']),
    (0x1d597, &['\u{0072}']),
    (0xfce3, &['\u{062A}', '\u{0645}']),
    (0x314d, &['\u{1111}']),
    (0x2f87, &['\u{821B}']),
    (0xfc9b, &['\u{064A}', '\u{0654}', '\u{0647}']),
    (0x3173, &['\u{1120}']),
    (0xff78, &['\u{30AF}']),
    (0xfce0, &['\u{064A}', '\u{0654}', '\u{0647}']),
    (0x1d4e7, &['\u{0058}']),
    (0x676, &['\u{0648}', '\u{0674}']),
    (0x1d5be, &['\u{0065}']),
    (0x1d60c, &['\u{0045}']),
    (0xedd, &['\u{0EAB}', '\u{0EA1}']),
    (0x2f5d, &['\u{72AC}']),
    (0x1d46b, &['\u{0044}']),
    (0xff24, &['\u{0044}']),
    (0x1d605, &['\u{0078}']),
    (0xfe49, &['\u{0020}', '\u{0305}']),
    (0xffcf, &['\u{116C}']),
    (0x2f0b, &['\u{516B}']),
    (0xfdf2, &['\u{0627}', '\u{0644}', '\u{0644}', '\u{0647}']),
    (0x1d60f, &['\u{0048}']),
    (0xfef3, &['\u{064A}']),
    (0x1d616, &['\u{004F}']),
    (0x1fc0, &['\u{0020}', '\u{0342}']),
    (0xfee7, &['\u{0646}']),
    (0x3d2, &['\u{03A5}']),
    (0x1d524, &['\u{0067}']),
    (0xfebd, &['\u{0636}']),
    (0x2f2b, &['\u{5C38}']),
    (0x33fb, &['\u{0032}', '\u{0038}', '\u{65E5}']),
    (0x2f7f, &['\u{8033}']),
    (0x24df, &['\u{0070}']),
    (0x1f148, &['\u{0059}']),
    (0x1ee2c, &['\u{0645}']),
    (0x212d, &['\u{0043}']),
    (0x2475, &['\u{0028}', '\u{0032}', '\u{0029}']),
    (0x1f222, &['\u{751F}']),
    (0x1c7, &['\u{004C}', '\u{004A}']),
    (0x1d57b, &['\u{0050}']),
    (0x1d608, &['\u{0041}']),
    (0x33b6, &['\u{03BC}', '\u{0056}']),
    (0x2079, &['\u{0039}']),
    (0x1d5e8, &['\u{0055}']),
    (0x1d62f, &['\u{006E}']),
    (0x2175, &['\u{0076}', '\u{0069}']),
    (0xff3b, &['\u{005B}']),
    (0x1d721, &['\u{0396}']),
    (0x3215, &['\u{0028}', '\u{110B}', '\u{1161}', '\u{0029}']),
    (0xffed, &['\u{25A0}']),
    (0xfe7f, &['\u{0640}', '\u{0652}']),
    (0xfea7, &['\u{062E}']),
    (0x1d55d, &['\u{006C}']),
    (0x1f228, &['\u{6355}']),
    (0xfba7, &['\u{06C1}']),
    (0xfd39, &['\u{0634}', '\u{062E}']),
    (0x1d6aa, &['\u{0393}']),
    (0xfb6c, &['\u{06A4}']),
    (0x1d4df, &['\u{0050}']),
    (0xff25, &['\u{0045}']),
    (0x1d48, &['\u{0064}']),
    (0xfbb0, &['\u{06D2}', '\u{0654}']),
    (0x1d704, &['\u{03B9}']),
    (0x1f102, &['\u{0031}', '\u{002C}']),
    (0x3333, &['\u{30D5}', '\u{30A3}', '\u{30FC}', '\u{30C8}']),
    (0x33c7, &['\u{0043}', '\u{006F}', '\u{002E}']),
    (0x2b2, &['\u{006A}']),
    (0x1f13c, &['\u{004D}']),
    (0x1d7f9, &['\u{0033}']),
    (0xfce2, &['\u{0628}', '\u{0647}']),
    (0x1d44b, &['\u{0058}']),
    (0x1d7c7, &['\u{03C6}']),
    (0x32b6, &['\u{0034}', '\u{0031}']),
    (0x3218, &['\u{0028}', '\u{110F}', '\u{1161}', '\u{0029}']),
    (0x2110, &['\u{0049}']),
    (0x1d636, &['\u{0075}']),
    (0x330a, &['\u{30AA}', '\u{30FC}', '\u{30E0}']),
    (0xfed4, &['\u{0641}']),
    (0x2f60, &['\u{74DC}']),
    (0x2119, &['\u{0050}']),
    (0x32e5, &['\u{30CB}']),
    (0xff23, &['\u{0043}']),
    (0x1eebb, &['\u{063A}']),
    (0x1d43b, &['\u{0048}']),
    (0x1da6, &['\u{026A}']),
    (0x1d450, &['\u{0063}']),
    (0x1d61b, &['\u{0054}']),
    (0x1d670, &['\u{0041}']),
    (0x1d52f, &['\u{0072}']),
    (0xfc44, &['\u{0644}', '\u{064A}']),
    (0x24a1, &['\u{0028}', '\u{0066}', '\u{0029}']),
    (0x1d7dc, &['\u{0034}']),
    (0x1d4f3, &['\u{006A}']),
    (0x2f1d, &['\u{53E3}']),
    (0x1d78b, &['\u{03B8}']),
    (0x1ee3b, &['\u{063A}']),
    (0xff16, &['\u{0036}']),
    (0x3384, &['\u{006B}', '\u{0041}']),
    (0x322c, &['\u{0028}', '\u{6C34}', '\u{0029}']),
    (0xfd00, &['\u{062D}', '\u{064A}']),
    (0x1d66, &['\u{03B2}']),
    (0x2162, &['\u{0049}', '\u{0049}', '\u{0049}']),
    (0x1d4f5, &['\u{006C}']),
    (0xfb9b, &['\u{06B1}']),
    (0xffd7, &['\u{1172}']),
    (0x1d5d, &['\u{03B2}']),
    (0x32fa, &['\u{30ED}']),
    (0x32db, &['\u{30B7}']),
    (0x1ee01, &['\u{0628}']),
    (0xfe41, &['\u{300C}']),
    (0x1d5df, &['\u{004C}']),
    (0x1f108, &['\u{0037}', '\u{002C}']),
    (0xff8e, &['\u{30DB}']),
    (0xff19, &['\u{0039}']),
    (0x1d751, &['\u{03B8}']),
    (0xfcf6, &['\u{0637}', '\u{064A}']),
    (0x2f9e, &['\u{8ECA}']),
    (0x1d5b8, &['\u{0059}']),
    (0x1d6d1, &['\u{03C0}']),
    (0x33cd, &['\u{004B}', '\u{004B}']),
    (0xfedf, &['\u{0644}']),
    (0x2fc5, &['\u{9E7F}']),
    (0x2f3d, &['\u{6208}']),
    (0xfe18, &['\u{3017}']),
    (0x1d490, &['\u{006F}']),
    (0x1d7c5, &['\u{03B8}']),
    (0x1d7e9, &['\u{0037}']),
    (0x1ee57, &['\u{062E}']),
    (0x2076, &['\u{0036}']),
    (0x2b8, &['\u{0079}']),
    (0xfd16, &['\u{063A}', '\u{064A}']),
    (0xfb95, &['\u{06AF}']),
    (0x1d73d, &['\u{03B8}']),
    (0xff2d, &['\u{004D}']),
    (0x1f13a, &['\u{004B}']),
    (0xfb88, &['\u{0688}']),
    (0x1f14b, &['\u{004D}', '\u{0056}']),
    (0x32e1, &['\u{30C4}']),
    (0x1d601, &['\u{0074}']),
    (0x208e, &['\u{0029}']),
    (0x1d69f, &['\u{0076}']),
    (0xfe7b, &['\u{0640}', '\u{0650}']),
    (0xfdbb, &['\u{0643}', '\u{0645}', '\u{0645}']),
    (0x1d5c2, &['\u{0069}']),
    (0x2f30, &['\u{5DF1}']),
    (0x1d52b, &['\u{006E}']),
    (0xff0c, &['\u{002C}']),
    (0x2f34, &['\u{5E7F}']),
    (0xff50, &['\u{0070}']),
    (0x24a7, &['\u{0028}', '\u{006C}', '\u{0029}']),
    (0xfb68, &['\u{0679}']),
    (0x213c, &['\u{03C0}']),
    (0x24e1, &['\u{0072}']),
    (0x1d49a, &['\u{0079}']),
    (0xfe37, &['\u{007B}']),
    (0x1d61d, &['\u{0056}']),
    (0xff6d, &['\u{30E5}']),
    (0x1d6fd, &['\u{03B2}']),
    (0x1d6d9, &['\u{03C8}']),
    (0xfbdf, &['\u{06CB}']),
    (0x1d730, &['\u{03A5}']),
    (0x3338, &['\u{30D8}', '\u{309A}', '\u{30CB}', '\u{30D2}']),
    (0x1d523, &['\u{0066}']),
    (0x3175, &['\u{1123}']),
    (0xfc30, &['\u{0641}', '\u{0645}']),
    (0x3355, &['\u{30EC}', '\u{30E0}']),
    (0x1d5dd, &['\u{004A}']),
    (0x1ee64, &['\u{0647}']),
    (0x24ad, &['\u{0028}', '\u{0072}', '\u{0029}']),
    (0x1d611, &['\u{004A}']),
    (0x331f, &['\u{30B5}', '\u{30A4}', '\u{30AF}', '\u{30EB}']),
    (0x1d77b, &['\u{03BC}']),
    (0x2f2a, &['\u{5C22}']),
    (0x1eeaf, &['\u{0639}']),
    (0x1d56b, &['\u{007A}']),
    (0x217c, &['\u{006C}']),
    (0x1d7e4, &['\u{0032}']),
    (0x2f70, &['\u{793A}']),
    (0x2157, &['\u{0033}', '\u{2044}', '\u{0035}']),
    (0x1d5b5, &['\u{0056}']),
    (0xfd53, &['\u{062A}', '\u{062D}', '\u{0645}']),
    (0x1d5e2, &['\u{004F}']),
    (0x1d5da, &['\u{0047}']),
    (0x1d691, &['\u{0068}']),
    (0x1ee6f, &['\u{0639}']),
    (0x1f23a, &['\u{55B6}']),
    (0x675, &['\u{0627}', '\u{0674}']),
    (0xfd6f, &['\u{0636}', '\u{062E}', '\u{0645}']),
    (0xfb9a, &['\u{06B1}']),
    (0x1f117, &['\u{0028}', '\u{0048}', '\u{0029}']),
    (0x33e5, &['\u{0036}', '\u{65E5}']),
    (0xb8, &['\u{0020}', '\u{0327}']),
    (0x1d6c3, &['\u{03B2}']),
    (0xfd73, &['\u{0637}', '\u{0645}', '\u{0645}']),
    (0x1d5d5, &['\u{0042}']),
    (0x1d454, &['\u{0067}']),
    (0x33d0, &['\u{006C}', '\u{006D}']),
    (0x1d5ce, &['\u{0075}']),
    (0xfc4b, &['\u{0646}', '\u{062C}']),
    (0x332b, &['\u{30CF}', '\u{309A}', '\u{30FC}', '\u{30BB}', '\u{30F3}', '\u{30C8}']),
    (0x1f16a, &['\u{004D}', '\u{0043}']),
    (0x1d7af, &['\u{03B6}']),
    (0xfc90, &['\u{0649}', '\u{0670}']),
    (0x1d68c, &['\u{0063}']),
    (0x1d6f1, &['\u{03A0}']),
    (0xfd6c, &['\u{0634}', '\u{0645}', '\u{0645}']),
    (0x211d, &['\u{0052}']),
    (0xfccc, &['\u{0644}', '\u{0645}']),
    (0xfc21, &['\u{0635}', '\u{0645}']),
    (0x1d7fe, &['\u{0038}']),
    (0x1d6b0, &['\u{0399}']),
    (0x2fb2, &['\u{97ED}']),
    (0x1d653, &['\u{0058}']),
    (0x3187, &['\u{1184}']),
    (0xfe36, &['\u{0029}']),
    (0x3205, &['\u{0028}', '\u{1107}', '\u{0029}']),
    (0xfcd3, &['\u{0646}', '\u{062D}']),
    (0x1d495, &['\u{0074}']),
    (0x1d658, &['\u{0063}']),
    (0x1d7cf, &['\u{0031}']),
    (0x1d5f1, &['\u{0064}']),
    (0x1f201, &['\u{30B3}', '\u{30B3}']),
    (0x32d2, &['\u{30A6}']),
    (0x33fa, &['\u{0032}', '\u{0037}', '\u{65E5}']),
    (0x1d6ec, &['\u{039B}']),
    (0x1d69d, &['\u{0074}']),
    (0xfcba, &['\u{0639}', '\u{062C}']),
    (0x33f8, &['\u{0032}', '\u{0035}', '\u{65E5}']),
    (0x1d5bf, &['\u{0066}']),
    (0x3378, &['\u{0064}', '\u{006D}', '\u{0032}']),
    (0x1eeb4, &['\u{0634}']),
    (0x1f217, &['\u{5929}']),
    (0x2f99, &['\u{8C9D}']),
    (0x1d705, &['\u{03BA}']),
    (0x1d71b, &['\u{03C0}']),
    (0x1d665, &['\u{0070}']),
    (0x1d4fc, &['\u{0073}']),
    (0xfb6b, &['\u{06A4}']),
    (0x2469, &['\u{0031}', '\u{0030}']),
    (0x33a1, &['\u{006D}', '\u{0032}']),
    (0x1d4a5, &['\u{004A}']),
    (0x2f9c, &['\u{8DB3}']),
    (0x1f14c, &['\u{0053}', '\u{0044}']),
    (0xffb9, &['\u{110D}']),
    (0xfc64, &['\u{064A}', '\u{0654}', '\u{0631}']),
    (0x32d8, &['\u{30B1}']),
    (0x1d543, &['\u{004C}']),
    (0xfda7, &['\u{062C}', '\u{0645}', '\u{0649}']),
    (0x3366, &['\u{0031}', '\u{0034}', '\u{70B9}']),
    (0x1d414, &['\u{0055}']),
    (0x24b9, &['\u{0044}']),
    (0x1d54b, &['\u{0054}']),
    (0x3277, &['\u{110E}', '\u{1161}']),
    (0x32a8, &['\u{53F3}']),
    (0xfefc, &['\u{0644}', '\u{0627}']),
    (0x2fbc, &['\u{9AD8}']),
    (0x24c0, &['\u{004B}']),
    (0x1ee2d, &['\u{0646}']),
    (0x1d6c4, &['\u{03B3}']),
    (0x1d407, &['\u{0048}']),
    (0x1f140, &['\u{0051}']),
    (0x328f, &['\u{571F}']),
    (0x1d7ac, &['\u{03B3}']),
    (0x249b, &['\u{0032}', '\u{0030}', '\u{002E}']),
    (0x1f126, &['\u{0028}', '\u{0057}', '\u{0029}']),
    (0x1da2, &['\u{0261}']),
    (0x1d49e, &['\u{0043}']),
    (0x3189, &['\u{1188}']),
    (0x2107, &['\u{0190}']),
    (0x205f, &['\u{0020}']),
    (0x1d6e0, &['\u{03C1}']),
    (0x2f77, &['\u{7CF8}']),
    (0x2fba, &['\u{99AC}']),
    (0x32ad, &['\u{4F01}']),
    (0x1d468, &['\u{0041}']),
    (0x3147, &['\u{110B}']),
    (0x3184, &['\u{1157}']),
    (0x1d5d7, &['\u{0044}']),
    (0x1d57f, &['\u{0054}']),
    (0x3236, &['\u{0028}', '\u{8CA1}', '\u{0029}']),
    (0xfea5, &['\u{062E}']),
    (0x321b, &['\u{0028}', '\u{1112}', '\u{1161}', '\u{0029}']),
    (0x32f0, &['\u{30E0}']),
    (0x1d4f9, &['\u{0070}']),
    (0x1d4c0, &['\u{006B}']),
    (0x3279, &['\u{1110}', '\u{1161}']),
    (0x321d, &['\u{0028}', '\u{110B}', '\u{1169}', '\u{110C}', '\u{1165}', '\u{11AB}', '\u{0029}']),
    (0x1d6c7, &['\u{03B6}']),
    (0x3375, &['\u{006F}', '\u{0056}']),
    (0x1d537, &['\u{007A}']),
    (0x319d, &['\u{5929}']),
    (0x1fc1, &['\u{0020}', '\u{0308}', '\u{0342}']),
    (0x331d, &['\u{30B3}', '\u{30EB}', '\u{30CA}']),
    (0x1d4ae, &['\u{0053}']),
    (0x32e0, &['\u{30C1}']),
    (0xfd21, &['\u{0635}', '\u{0649}']),
    (0x32e4, &['\u{30CA}']),
    (0xfcf7, &['\u{0639}', '\u{0649}']),
    (0x3038, &['\u{5341}']),
    (0x313d, &['\u{11B3}']),
    (0x1d620, &['\u{0059}']),
    (0x1d7e1, &['\u{0039}']),
    (0x1d7d0, &['\u{0032}']),
    (0xfdc2, &['\u{0628}', '\u{062D}', '\u{064A}']),
    (0x1d6ba, &['\u{03A3}']),
    (0x1d7f1, &['\u{0035}']),
    (0x3232, &['\u{0028}', '\u{6709}', '\u{0029}']),
    (0x1ee1d, &['\u{06BA}']),
    (0x2f75, &['\u{7AF9}']),
    (0x33b3, &['\u{006D}', '\u{0073}']),
    (0x338e, &['\u{006D}', '\u{0067}']),
    (0xff0f, &['\u{002F}']),
    (0x1d782, &['\u{03C3}']),
    (0x1f107, &['\u{0036}', '\u{002C}']),
    (0x3305, &['\u{30A4}', '\u{30F3}', '\u{30C1}']),
    (0x3196, &['\u{4E0A}']),
    (0xfda9, &['\u{0635}', '\u{062D}', '\u{064A}']),
    (0x3199, &['\u{7532}']),
    (0x33cb, &['\u{0048}', '\u{0050}']),
    (0x1d614, &['\u{004D}']),
    (0xfc88, &['\u{0645}', '\u{0627}']),
    (0x1ee00, &['\u{0627}']),
    (0x1d6a0, &['\u{0077}']),
    (0x1d9c, &['\u{0063}']),
    (0x1d651, &['\u{0056}']),
    (0xfea9, &['\u{062F}']),
    (0xffcc, &['\u{1169}']),
    (0x1d419, &['\u{005A}']),
    (0x1d6bf, &['\u{03A8}']),
    (0x2f10, &['\u{51F5}']),
    (0x339e, &['\u{006B}', '\u{006D}']),
    (0x1d641, &['\u{0046}']),
    (0xfe63, &['\u{002D}']),
    (0x3288, &['\u{4E5D}']),
    (0x1d77e, &['\u{03BF}']),
    (0x1d49b, &['\u{007A}']),
    (0x2f03, &['\u{4E3F}']),
    (0xa7f9, &['\u{0153}']),
    (0xff26, &['\u{0046}']),
    (0x1d758, &['\u{0393}']),
    (0x1d54, &['\u{1D16}']),
    (0xfc77, &['\u{062B}', '\u{0632}']),
    (0x1d6fa, &['\u{03A9}']),
    (0xfdb8, &['\u{0646}', '\u{062C}', '\u{062D}']),
    (0x1d748, &['\u{03C3}']),
    (0x2e1, &['\u{006C}']),
    (0xff36, &['\u{0056}']),
    (0x1d5ec, &['\u{0059}']),
    (0x3168, &['\u{11C8}']),
    (0x2011, &['\u{2010}']),
    (0x222d, &['\u{222B}', '\u{222B}', '\u{222B}']),
    (0x384, &['\u{0020}', '\u{0301}']),
    (0x1f122, &['\u{0028}', '\u{0053}', '\u{0029}']),
    (0x1d52e, &['\u{0071}']),
    (0xfdc4, &['\u{0639}', '\u{062C}', '\u{0645}']),
    (0xfd61, &['\u{0633}', '\u{0645}', '\u{062C}']),
    (0x3320, &['\u{30B5}', '\u{30F3}', '\u{30C1}', '\u{30FC}', '\u{30E0}']),
    (0xffaa, &['\u{11B0}']),
    (0x33e7, &['\u{0038}', '\u{65E5}']),
    (0x1d553, &['\u{0062}']),
    (0x1d5aa, &['\u{004B}']),
    (0xfe62, &['\u{002B}']),
    (0x1d4ec, &['\u{0063}']),
    (0x24de, &['\u{006F}']),
    (0xfc8e, &['\u{0646}', '\u{0649}']),
    (0x2b1, &['\u{0266}']),
    (0xfe55, &['\u{003A}']),
    (0x32bd, &['\u{0034}', '\u{0038}']),
    (0x2f5a, &['\u{7247}']),
    (0x1d33, &['\u{0047}']),
    (0x1ee29, &['\u{064A}']),
    (0x2f23, &['\u{5915}']),
    (0x2103, &['\u{00B0}', '\u{0043}']),
    (0x1f22b, &['\u{904A}']),
    (0x246e, &['\u{0031}', '\u{0035}']),
    (0x32f3, &['\u{30E4}']),
    (0xfe72, &['\u{0020}', '\u{064C}']),
    (0x1d70c, &['\u{03C1}']),
    (0xedc, &['\u{0EAB}', '\u{0E99}']),
    (0x2171, &['\u{0069}', '\u{0069}']),
    (0x3157, &['\u{1169}']),
    (0x1d417, &['\u{0058}']),
    (0x1ee8b, &['\u{0644}']),
    (0x1d4fd, &['\u{0074}']),
    (0x2f4c, &['\u{6B62}']),
    (0x1d74c, &['\u{03C7}']),
    (0x1d731, &['\u{03A6}']),
    (0x2173, &['\u{0069}', '\u{0076}']),
    (0xff47, &['\u{0067}']),
    (0x33f5, &['\u{0032}', '\u{0032}', '\u{65E5}']),
    (0x339d, &['\u{0063}', '\u{006D}']),
    (0x1d75c, &['\u{0397}']),
    (0x2487, &['\u{0028}', '\u{0032}', '\u{0030}', '\u{0029}']),
    (0xfdfa, &['\u{0635}', '\u{0644}', '\u{0649}', '\u{0020}', '\u{0627}', '\u{0644}', '\u{0644}', '\u{0647}', '\u{0020}', '\u{0639}', '\u{0644}', '\u{064A}', '\u{0647}', '\u{0020}', '\u{0648}', '\u{0633}', '\u{0644}', '\u{0645}']),
    (0xff66, &['\u{30F2}']),
    (0x1d58d, &['\u{0068}']),
    (0xff33, &['\u{0053}']),
    (0x1d5c7, &['\u{006E}']),
    (0x335c, &['\u{0034}', '\u{70B9}']),
    (0x320d, &['\u{0028}', '\u{1112}', '\u{0029}']),
    (0xfda5, &['\u{062C}', '\u{0645}', '\u{064A}']),
    (0x32f9, &['\u{30EC}']),
    (0x3314, &['\u{30AD}', '\u{30ED}']),
    (0x3241, &['\u{0028}', '\u{4F11}', '\u{0029}']),
    (0x1d621, &['\u{005A}']),
    (0x1d635, &['\u{0074}']),
    (0x326c, &['\u{1111}']),
    (0x1d683, &['\u{0054}']),
    (0x1ee84, &['\u{0647}']),
    (0xfc4a, &['\u{0645}', '\u{064A}']),
    (0x1fdd, &['\u{0020}', '\u{0314}', '\u{0300}']),
    (0xff98, &['\u{30EA}']),
    (0x1d9e, &['\u{00F0}']),
    (0x210c, &['\u{0048}']),
    (0xff6c, &['\u{30E3}']),
    (0x3377, &['\u{0064}', '\u{006D}']),
    (0x1d6da, &['\u{03C9}']),
    (0x1d746, &['\u{03C1}']),
    (0xfceb, &['\u{0643}', '\u{0644}']),
    (0x1eeac, &['\u{0645}']),
    (0xfcf4, &['\u{0640}', '\u{0650}', '\u{0651}']),
    (0x32d4, &['\u{30AA}']),
    (0x1d7dd, &['\u{0035}']),
    (0x1d70b, &['\u{03C0}']),
    (0xfdb5, &['\u{0644}', '\u{062D}', '\u{0645}']),
    (0x3388, &['\u{0063}', '\u{0061}', '\u{006C}']),
    (0x3264, &['\u{1106}']),
    (0xff7b, &['\u{30B5}']),
    (0x1d692, &['\u{0069}']),
    (0x2f38, &['\u{5F13}']),
    (0x1d790, &['\u{0391}']),
    (0x2f31, &['\u{5DFE}']),
    (0x2152, &['\u{0031}', '\u{2044}', '\u{0031}', '\u{0030}']),
    (0xfe30, &['\u{002E}', '\u{002E}']),
    (0x1f232, &['\u{7981}']),
    (0x2e0, &['\u{0263}']),
    (0x1d668, &['\u{0073}']),
    (0x2146, &['\u{0064}']),
    (0x32b8, &['\u{0034}', '\u{0033}']),
    (0xa8, &['\u{0020}', '\u{0308}']),
    (0x2074, &['\u{0034}']),
    (0x1d5ef, &['\u{0062}']),
    (0x323f, &['\u{0028}', '\u{5354}', '\u{0029}']),
    (0x1f149, &['\u{005A}']),
    (0x1d470, &['\u{0049}']),
    (0x1f3, &['\u{0064}', '\u{007A}']),
    (0xfc56, &['\u{064A}', '\u{062D}']),
    (0xfbe7, &['\u{06D0}']),
    (0x2fa0, &['\u{8FB0}']),
    (0x33d4, &['\u{006D}', '\u{0062}']),
    (0x1d654, &['\u{0059}']),
    (0xfcfe, &['\u{0634}', '\u{064A}']),
    (0x2f47, &['\u{65E5}']),
    (0xfbdd, &['\u{06C7}', '\u{0674}']),
    (0xfd52, &['\u{062A}', '\u{062D}', '\u{062C}']),
    (0xfe15, &['\u{0021}']),
    (0xfe8e, &['\u{0627}']),
    (0x24e9, &['\u{007A}']),
    (0x3039, &['\u{5344}']),
    (0xfe65, &['\u{003E}']),
    (0x33a0, &['\u{0063}', '\u{006D}', '\u{0032}']),
    (0xfd9c, &['\u{064A}', '\u{0645}', '\u{0645}']),
    (0xffbe, &['\u{1112}']),
    (0xfc31, &['\u{0641}', '\u{0649}']),
    (0x1f125, &['\u{0028}', '\u{0056}', '\u{0029}']),
    (0x334a, &['\u{30DF}', '\u{30EA}', '\u{30CF}', '\u{3099}', '\u{30FC}', '\u{30EB}']),
    (0x1d7e6, &['\u{0034}']),
    (0x1d68, &['\u{03C1}']),
    (0x2e2, &['\u{0073}']),
    (0xff80, &['\u{30BF}']),
    (0x1d42e, &['\u{0075}']),
    (0xfe44, &['\u{300F}']),
    (0x1f132, &['\u{0043}']),
    (0x1d6b7, &['\u{03A0}']),
    (0xfef8, &['\u{0644}', '\u{0627}', '\u{0654}']),
    (0xfd78, &['\u{0639}', '\u{0645}', '\u{0649}']),
    (0x1d7f5, &['\u{0039}']),
    (0x24d0, &['\u{0061}']),
    (0xfd50, &['\u{062A}', '\u{062C}', '\u{0645}']),
    (0x32f4, &['\u{30E6}']),
    (0x1d6e8, &['\u{0397}']),
    (0x1d520, &['\u{0063}']),
    (0x328d, &['\u{6728}']),
    (0xfd37, &['\u{0634}', '\u{062C}']),
    (0xa7f8, &['\u{0126}']),
    (0x2fc4, &['\u{9E75}']),
    (0x210f, &['\u{0127}']),
    (0x10fc, &['\u{10DC}']),
    (0xfdb0, &['\u{064A}', '\u{0645}', '\u{064A}']),
    (0x1ee87, &['\u{062D}']),
    (0x1ee70, &['\u{0641}']),
    (0x316b, &['\u{11D3}']),
    (0x3285, &['\u{516D}']),
    (0xfcb7, &['\u{0636}', '\u{0645}']),
    (0xffb2, &['\u{1107}']),
    (0x1d68b, &['\u{0062}']),
    (0xfd6b, &['\u{0634}', '\u{0645}', '\u{062E}']),
    (0x1ee35, &['\u{062A}']),
    (0x32d6, &['\u{30AD}']),
    (0x149, &['\u{02BC}', '\u{006E}']),
    (0xfbb1, &['\u{06D2}', '\u{0654}']),
    (0x1f14d, &['\u{0053}', '\u{0053}']),
    (0x1d56a, &['\u{0079}']),
    (0x1d4b8, &['\u{0063}']),
    (0x1d7da, &['\u{0032}']),
    (0xfcfc, &['\u{0633}', '\u{064A}']),
    (0x1d761, &['\u{039C}']),
    (0x2097, &['\u{006C}']),
    (0xfca3, &['\u{062A}', '\u{062E}']),
    (0x33e3, &['\u{0034}', '\u{65E5}']),
    (0x1d753, &['\u{03C6}']),
    (0x1d657, &['\u{0062}']),
    (0xfd34, &['\u{0633}', '\u{062C}']),
    (0x1d55b, &['\u{006A}']),
    (0x1eeae, &['\u{0633}']),
    (0x1d62d, &['\u{006C}']),
    (0xfedc, &['\u{0643}']),
    (0xffb6, &['\u{110A}']),
    (0x1d469, &['\u{0042}']),
    (0x3186, &['\u{1159}']),
    (0x216d, &['\u{0043}']),
    (0x2092, &['\u{006F}']),
    (0x24b3, &['\u{0028}', '\u{0078}', '\u{0029}']),
    (0xfc6e, &['\u{0628}', '\u{0649}']),
    (0x3f5, &['\u{03B5}']),
    (0x32f8, &['\u{30EB}']),
    (0xffb8, &['\u{110C}']),
    (0x3237, &['\u{0028}', '\u{795D}', '\u{0029}']),
    (0xfec0, &['\u{0636}']),
    (0x3351, &['\u{30EA}', '\u{30C3}', '\u{30C8}', '\u{30EB}']),
    (0xfcc5, &['\u{0643}', '\u{062D}']),
    (0x3329, &['\u{30CE}', '\u{30C3}', '\u{30C8}']),
    (0xfe5c, &['\u{007D}']),
    (0x2f9b, &['\u{8D70}']),
    (0x24d2, &['\u{0063}']),
    (0xfd75, &['\u{0639}', '\u{062C}', '\u{0645}']),
    (0x33e4, &['\u{0035}', '\u{65E5}']),
    (0xe33, &['\u{0E4D}', '\u{0E32}']),
    (0x1d5fd, &['\u{0070}']),
    (0x2494, &['\u{0031}', '\u{0033}', '\u{002E}']),
    (0x2f80, &['\u{807F}']),
    (0x2dd, &['\u{0020}', '\u{030B}']),
    (0x32a1, &['\u{4F11}']),
    (0x328c, &['\u{6C34}']),
    (0x309c, &['\u{0020}', '\u{309A}']),
    (0x1d7fb, &['\u{0035}']),
    (0xfd7b, &['\u{063A}', '\u{0645}', '\u{0649}']),
    (0xfb61, &['\u{067A}']),
    (0x3323, &['\u{30BB}', '\u{30F3}', '\u{30C8}']),
    (0x3280, &['\u{4E00}']),
    (0x1f138, &['\u{0049}']),
    (0xfc89, &['\u{0645}', '\u{0645}']),
    (0xfb02, &['\u{0066}', '\u{006C}']),
    (0x2111, &['\u{0049}']),
    (0x1f22a, &['\u{4E09}']),
    (0x1d772, &['\u{03B3}']),
    (0x315f, &['\u{1171}']),
    (0x1d4d, &['\u{0067}']),
    (0xfd89, &['\u{0645}', '\u{062D}', '\u{062C}']),
    (0x3135, &['\u{11AC}']),
    (0x1db9, &['\u{028B}']),
    (0xfb97, &['\u{06B3}']),
    (0x1d4d6, &['\u{0047}']),
    (0x2fb6, &['\u{98DB}']),
    (0x1ee59, &['\u{0636}']),
    (0x1d743, &['\u{03BE}']),
    (0xfd11, &['\u{0637}', '\u{0649}']),
    (0xff1f, &['\u{003F}']),
    (0x24b5, &['\u{0028}', '\u{007A}', '\u{0029}']),
    (0x1dac, &['\u{0271}']),
    (0xfcb8, &['\u{0637}', '\u{062D}']),
    (0x317f, &['\u{1140}']),
    (0x2037, &['\u{2035}', '\u{2035}', '\u{2035}']),
    (0x1d5f8, &['\u{006B}']),
    (0x3150, &['\u{1162}']),
    (0x1d5c9, &['\u{0070}']),
    (0x1d57e, &['\u{0053}']),
    (0x32bc, &['\u{0034}', '\u{0037}']),
    (0x133, &['\u{0069}', '\u{006A}']),
    (0x1f245, &['\u{3014}', '\u{6253}', '\u{3015}']),
    (0x213e, &['\u{0393}']),
    (0x1d78d, &['\u{03C6}']),
    (0x2f1b, &['\u{53B6}']),
    (0x1d5e1, &['\u{004E}']),
    (0x1d4f1, &['\u{0068}']),
    (0x1d498, &['\u{0077}']),
    (0xfed2, &['\u{0641}']),
    (0x3306, &['\u{30A6}', '\u{30A9}', '\u{30F3}']),
    (0x2473, &['\u{0032}', '\u{0030}']),
    (0x1d504, &['\u{0041}']),
    (0xfc62, &['\u{0020}', '\u{0650}', '\u{0651}']),
    (0x3214, &['\u{0028}', '\u{1109}', '\u{1161}', '\u{0029}']),
    (0x32c2, &['\u{0033}', '\u{6708}']),
    (0x1d52c, &['\u{006F}']),
    (0x24ca, &['\u{0055}']),
    (0x1d533, &['\u{0076}']),
    (0x1d6a, &['\u{03C7}']),
    (0x1d4f7, &['\u{006E}']),
    (0x3158, &['\u{116A}']),
    (0xffca, &['\u{1167}']),
    (0x1eeb8, &['\u{0630}']),
    (0xfbe1, &['\u{06C5}']),
    (0xfc32, &['\u{0641}', '\u{064A}']),
    (0x1d625, &['\u{0064}']),
    (0xfee3, &['\u{0645}']),
    (0xfdb7, &['\u{0643}', '\u{0645}', '\u{064A}']),
    (0x1d6d3, &['\u{03C2}']),
    (0x1d7a8, &['\u{03A9}']),
    (0x1ee7b, &['\u{063A}']),
    (0xfb25, &['\u{05DC}']),
    (0x24a5, &['\u{0028}', '\u{006A}', '\u{0029}']),
    (0x1d4b3, &['\u{0058}']),
    (0x322f, &['\u{0028}', '\u{571F}', '\u{0029}']),
    (0x3399, &['\u{0066}', '\u{006D}']),
    (0x1d65d, &['\u{0068}']),
    (0xfc74, &['\u{062A}', '\u{0649}']),
    (0x1d5a5, &['\u{0046}']),
    (0x33f2, &['\u{0031}', '\u{0039}', '\u{65E5}']),
    (0x1d74f, &['\u{2202}']),
    (0xfd66, &['\u{0635}', '\u{0645}', '\u{0645}']),
    (0x3221, &['\u{0028}', '\u{4E8C}', '\u{0029}']),
    (0xff30, &['\u{0050}']),
    (0x1d512, &['\u{004F}']),
    (0x1d632, &['\u{0071}']),
    (0x1db2, &['\u{0278}']),
    (0xfb82, &['\u{068D}']),
    (0xffa9, &['\u{1105}']),
    (0x1d711, &['\u{03C6}']),
    (0x3317, &['\u{30AD}', '\u{30ED}', '\u{30EF}', '\u{30C3}', '\u{30C8}']),
    (0xa69d, &['\u{044C}']),
    (0x1d640, &['\u{0045}']),
    (0x1da4, &['\u{0268}']),
    (0x1f11d, &['\u{0028}', '\u{004E}', '\u{0029}']),
    (0xfdbf, &['\u{062D}', '\u{062C}', '\u{064A}']),
    (0x1d732, &['\u{03A7}']),
    (0x1f11a, &['\u{0028}', '\u{004B}', '\u{0029}']),
    (0x24b1, &['\u{0028}', '\u{0076}', '\u{0029}']),
    (0x2f3e, &['\u{6236}']),
    (0x1d6e7, &['\u{0396}']),
    (0x1d43e, &['\u{004B}']),
    (0xff87, &['\u{30CC}']),
    (0x1d66e, &['\u{0079}']),
    (0x1ee88, &['\u{0637}']),
    (0xfed7, &['\u{0642}']),
    (0xff52, &['\u{0072}']),
    (0x1d420, &['\u{0067}']),
    (0x1f238, &['\u{7533}']),
    (0x3176, &['\u{1127}']),
    (0x2f39, &['\u{5F50}']),
    (0x1d698, &['\u{006F}']),
    (0x1db8, &['\u{1D1C}']),
    (0x1d61f, &['\u{0058}']),
    (0x1ee6a, &['\u{0643}']),
    (0x1d67b, &['\u{004C}']),
    (0x213d, &['\u{03B3}']),
    (0x1ee4f, &['\u{0639}']),
    (0x249c, &['\u{0028}', '\u{0061}', '\u{0029}']),
    (0x2fa4, &['\u{91C6}']),
    (0x2f1e, &['\u{56D7}']),
    (0xff86, &['\u{30CB}']),
    (0x1d624, &['\u{0063}']),
    (0x1d577, &['\u{004C}']),
    (0xfbd5, &['\u{06AD}']),
    (0x3341, &['\u{30DB}', '\u{30FC}', '\u{30EB}']),
    (0x1d4b9, &['\u{0064}']),
    (0x1d6e2, &['\u{0391}']),
    (0x1f111, &['\u{0028}', '\u{0042}', '\u{0029}']),
    (0xffb0, &['\u{111A}']),
    (0x1d7f7, &['\u{0031}']),
    (0x1d6b3, &['\u{039C}']),
    (0x24db, &['\u{006C}']),
    (0x1d570, &['\u{0045}']),
    (0x1ee99, &['\u{0636}']),
    (0x1d590, &['\u{006B}']),
    (0x1d5c1, &['\u{0068}']),
    (0xfb77, &['\u{0683}']),
    (0x1d723, &['\u{0398}']),
    (0x1d7a5, &['\u{03A6}']),
    (0x1f120, &['\u{0028}', '\u{0051}', '\u{0029}']),
    (0x1d72c, &['\u{03A1}']),
    (0xffbc, &['\u{1110}']),
    (0x1d5c4, &['\u{006B}']),
    (0xfe86, &['\u{0648}', '\u{0654}']),
    (0x1d7ad, &['\u{03B4}']),
    (0x1d633, &['\u{0072}']),
    (0x32e7, &['\u{30CD}']),
    (0x2f4b, &['\u{6B20}']),
    (0x1fcd, &['\u{0020}', '\u{0313}', '\u{0300}']),
    (0x3188, &['\u{1185}']),
    (0x33c5, &['\u{0063}', '\u{0064}']),
    (0xffeb, &['\u{2192}']),
    (0x2491, &['\u{0031}', '\u{0030}', '\u{002E}']),
    (0xfe16, &['\u{003F}']),
    (0x1d754, &['\u{03C1}']),
    (0x1d7ef, &['\u{0033}']),
    (0x1d6ce, &['\u{03BD}']),
    (0x330e, &['\u{30AB}', '\u{3099}', '\u{30ED}', '\u{30F3}']),
    (0xfea8, &['\u{062E}']),
    (0x1d434, &['\u{0041}']),
    (0x1d483, &['\u{0062}']),
    (0x1d443, &['\u{0050}']),
    (0xff1c, &['\u{003C}']),
    (0x210a, &['\u{0067}']),
    (0x2fd5, &['\u{9FA0}']),
    (0x1d6a4, &['\u{0131}']),
    (0x1dbd, &['\u{0291}']),
    (0xfb6a, &['\u{06A4}']),
    (0xfc2b, &['\u{063A}', '\u{062C}']),
    (0x1d4de, &['\u{004F}']),
    (0xfd2e, &['\u{0634}', '\u{062D}']),
    (0x328b, &['\u{706B}']),
    (0x1d552, &['\u{0061}']),
    (0xfea3, &['\u{062D}']),
    (0x330b, &['\u{30AB}', '\u{30A4}', '\u{30EA}']),
    (0xfb5b, &['\u{0680}']),
    (0x1d40a, &['\u{004B}']),
    (0x1f21c, &['\u{524D}']),
    (0x2460, &['\u{0031}']),
    (0x1d541, &['\u{004A}']),
    (0x3271, &['\u{1105}', '\u{1161}']),
    (0x2122, &['\u{0054}', '\u{004D}']),
    (0x1ee19, &['\u{0636}']),
    (0xff01, &['\u{0021}']),
    (0x3216, &['\u{0028}', '\u{110C}', '\u{1161}', '\u{0029}']),
    (0xfcc1, &['\u{0641}', '\u{0645}']),
    (0x1fbf, &['\u{0020}', '\u{0313}']),
    (0x216e, &['\u{0044}']),
    (0x2fb9, &['\u{9999}']),
    (0xbd, &['\u{0031}', '\u{2044}', '\u{0032}']),
    (0xff3c, &['\u{005C}']),
    (0x1d66f, &['\u{007A}']),
    (0x1ee14, &['\u{0634}']),
    (0x1d48a, &['\u{0069}']),
    (0xffb5, &['\u{1109}']),
    (0xfd38, &['\u{0634}', '\u{062D}']),
    (0x2f81, &['\u{8089}']),
    (0x1d610, &['\u{0049}']),
    (0xfcbf, &['\u{0641}', '\u{062D}']),
    (0x1d64e, &['\u{0053}']),
    (0xfe3c, &['\u{3011}']),
    (0x1d4c3, &['\u{006E}']),
    (0x3162, &['\u{1174}']),
    (0x2f65, &['\u{7530}']),
    (0xfd96, &['\u{0646}', '\u{062D}', '\u{0649}']),
    (0x1d5e7, &['\u{0054}']),
    (0xffb7, &['\u{110B}']),
    (0x207a, &['\u{002B}']),
    (0x3d5, &['\u{03C6}']),
    (0x1d445, &['\u{0052}']),
    (0x32d0, &['\u{30A2}']),
    (0x2f09, &['\u{513F}']),
    (0x1ee6d, &['\u{0646}']),
    (0x2fb5, &['\u{98A8}']),
    (0xfeea, &['\u{0647}']),
    (0xfee0, &['\u{0644}']),
    (0x1f1, &['\u{0044}', '\u{005A}']),
    (0xfba0, &['\u{06BB}']),
    (0xfbf5, &['\u{064A}', '\u{0654}', '\u{06C8}']),
    (0x1d43c, &['\u{0049}']),
    (0xfc4e, &['\u{0646}', '\u{0645}']),
    (0xfbe0, &['\u{06C5}']),
    (0x2483, &['\u{0028}', '\u{0031}', '\u{0036}', '\u{0029}']),
    (0x33f1, &['\u{0031}', '\u{0038}', '\u{65E5}']),
    (0x3165, &['\u{1114}']),
    (0x1d56, &['\u{0070}']),
    (0xfb9d, &['\u{06B1}']),
    (0xfc24, &['\u{0636}', '\u{062E}']),
    (0xfc54, &['\u{0647}', '\u{064A}']),
    (0x1d763, &['\u{039E}']),
    (0xfda8, &['\u{0633}', '\u{062E}', '\u{0649}']),
    (0x1d6eb, &['\u{039A}']),
    (0x1f11c, &['\u{0028}', '\u{004D}', '\u{0029}']),
    (0xfe8b, &['\u{064A}', '\u{0654}']),
    (0x2f57, &['\u{7236}']),
    (0x1d518, &['\u{0055}']),
    (0x1d784, &['\u{03C5}']),
    (0xfce5, &['\u{062B}', '\u{0645}']),
    (0x2f96, &['\u{8C46}']),
    (0xfc39, &['\u{0643}', '\u{062D}']),
    (0xfc48, &['\u{0645}', '\u{0645}']),
    (0xfedb, &['\u{0643}']),
    (0x2495, &['\u{0031}', '\u{0034}', '\u{002E}']),
    (0x1ee71, &['\u{0635}']),
    (0x3272, &['\u{1106}', '\u{1161}']),
    (0x2f9a, &['\u{8D64}']),
    (0x333d, &['\u{30DB}', '\u{309A}', '\u{30A4}', '\u{30F3}', '\u{30C8}']),
    (0xfcb0, &['\u{0633}', '\u{0645}']),
    (0xfd02, &['\u{062C}', '\u{064A}']),
    (0x1d7eb, &['\u{0039}']),
    (0xfdba, &['\u{0644}', '\u{062C}', '\u{0645}']),
    (0x1ee86, &['\u{0632}']),
    (0x1d66b, &['\u{0076}']),
    (0xff9e, &['\u{3099}']),
    (0x1f225, &['\u{5439}']),
    (0x2499, &['\u{0031}', '\u{0038}', '\u{002E}']),
    (0xfce8, &['\u{0633}', '\u{0647}']),
    (0x1f11b, &['\u{0028}', '\u{004C}', '\u{0029}']),
    (0x1d505, &['\u{0042}']),
    (0x1d767, &['\u{0398}']),
    (0x33ce, &['\u{004B}', '\u{004D}']),
    (0x2f01, &['\u{4E28}']),
    (0xfc3f, &['\u{0644}', '\u{062C}']),
    (0x3222, &['\u{0028}', '\u{4E09}', '\u{0029}']),
    (0x33d8, &['\u{0070}', '\u{002E}', '\u{006D}', '\u{002E}']),
    (0x1ee12, &['\u{0642}']),
    (0x3335, &['\u{30D5}', '\u{30E9}', '\u{30F3}']),
    (0x32aa, &['\u{5B97}']),
    (0xfbf4, &['\u{064A}', '\u{0654}', '\u{06C8}']),
    (0xff4d, &['\u{006D}']),
    (0xba, &['\u{006F}']),
    (0x1d6bb, &['\u{03A4}']),
    (0xff03, &['\u{0023}']),
    (0x1d6b9, &['\u{0398}']),
    (0x318d, &['\u{119E}']),
    (0x1d48f, &['\u{006E}']),
    (0x2017, &['\u{0020}', '\u{0333}']),
    (0x1d48d, &['\u{006C}']),
    (0x32b5, &['\u{0034}', '\u{0030}']),
    (0x132, &['\u{0049}', '\u{004A}']),
    (0x2f16, &['\u{5338}']),
    (0x319b, &['\u{4E19}']),
    (0x337f, &['\u{682A}', '\u{5F0F}', '\u{4F1A}', '\u{793E}']),
    (0x313c, &['\u{11B2}']),
    (0xfb7d, &['\u{0686}']),
    (0x3394, &['\u{0054}', '\u{0048}', '\u{007A}']),
    (0x1d42c, &['\u{0073}']),
    (0x1d47e, &['\u{0057}']),
    (0xfebf, &['\u{0636}']),
    (0x33ed, &['\u{0031}', '\u{0034}', '\u{65E5}']),
    (0x1f114, &['\u{0028}', '\u{0045}', '\u{0029}']),
    (0x1f231, &['\u{6253}']),
    (0xff51, &['\u{0071}']),
    (0x1d7c6, &['\u{03BA}']),
    (0x309f, &['\u{3088}', '\u{308A}']),
    (0x1d7d9, &['\u{0031}']),
    (0xfeee, &['\u{0648}']),
    (0x2135, &['\u{05D0}']),
    (0x1d493, &['\u{0072}']),
    (0x1d45a, &['\u{006D}']),
    (0x1d650, &['\u{0055}']),
    (0x1d54d, &['\u{0056}']),
    (0xfd25, &['\u{0634}', '\u{062C}']),
    (0x2024, &['\u{002E}']),
    (0x24cf, &['\u{005A}']),
    (0x1ee2b, &['\u{0644}']),
    (0x2faf, &['\u{9762}']),
    (0x2b3, &['\u{0072}']),
    (0x1d58b, &['\u{0066}']),
    (0xfb01, &['\u{0066}', '\u{0069}']),
    (0xfece, &['\u{063A}']),
    (0x24e2, &['\u{0073}']),
    (0xfd7a, &['\u{063A}', '\u{0645}', '\u{064A}']),
    (0x1d669, &['\u{0074}']),
    (0x2f37, &['\u{5F0B}']),
    (0x1f248, &['\u{3014}', '\u{6557}', '\u{3015}']),
    (0xff5b, &['\u{007B}']),
    (0x215e, &['\u{0037}', '\u{2044}', '\u{0038}']),
    (0xfef2, &['\u{064A}']),
    (0x2f6f, &['\u{77F3}']),
    (0x1d78a, &['\u{03B5}']),
    (0x3357, &['\u{30EF}', '\u{30C3}', '\u{30C8}']),
    (0x1d5cc, &['\u{0073}']),
    (0x2b5, &['\u{027B}']),
    (0x3258, &['\u{0032}', '\u{0038}']),
    (0xfca4, &['\u{062A}', '\u{0645}']),
    (0x3287, &['\u{516B}']),
    (0x1f210, &['\u{624B}']),
    (0x33be, &['\u{006B}', '\u{0057}']),
    (0xfc99, &['\u{064A}', '\u{0654}', '\u{062E}']),
    (0x1d596, &['\u{0071}']),
    (0x1d4f8, &['\u{006F}']),
    (0xfec9, &['\u{0639}']),
    (0x1f22c, &['\u{5DE6}']),
    (0x2a75, &['\u{003D}', '\u{003D}']),
    (0xfe76, &['\u{0020}', '\u{064E}']),
    (0xff1d, &['\u{003D}']),
    (0x217f, &['\u{006D}']),
    (0xfb04, &['\u{0066}', '\u{0066}', '\u{006C}']),
    (0x336a, &['\u{0031}', '\u{0038}', '\u{70B9}']),
    (0xfe4e, &['\u{005F}']),
    (0x248b, &['\u{0034}', '\u{002E}']),
    (0x1d4c9, &['\u{0074}']),
    (0x1d567, &['\u{0076}']),
    (0x1d511, &['\u{004E}']),
    (0x1d7ee, &['\u{0032}']),
    (0xff8c, &['\u{30D5}']),
    (0x1d65c, &['\u{0067}']),
    (0x315c, &['\u{116E}']),
    (0x1d52d, &['\u{0070}']),
    (0x33ef, &['\u{0031}', '\u{0036}', '\u{65E5}']),
    (0x1d659, &['\u{0064}']),
    (0x248e, &['\u{0037}', '\u{002E}']),
    (0x3137, &['\u{1103}']),
    (0xfe8f, &['\u{0628}']),
    (0x1d4ee, &['\u{0065}']),
    (0xffe0, &['\u{00A2}']),
    (0x2172, &['\u{0069}', '\u{0069}', '\u{0069}']),
    (0x1d5b1, &['\u{0052}']),
    (0xff27, &['\u{0047}']),
    (0xfd9a, &['\u{0646}', '\u{0645}', '\u{064A}']),
    (0x1d766, &['\u{03A1}']),
    (0x3380, &['\u{0070}', '\u{0041}']),
    (0xfd1c, &['\u{062D}', '\u{064A}']),
    (0xfe35, &['\u{0028}']),
    (0x1f219, &['\u{6620}']),
    (0x1d62a, &['\u{0069}']),
    (0x1d4dd, &['\u{004E}']),
    (0x33b2, &['\u{03BC}', '\u{0073}']),
    (0xfcb2, &['\u{0635}', '\u{062E}']),
    (0x1d464, &['\u{0077}']),
    (0x2080, &['\u{0030}']),
    (0x1d71c, &['\u{0391}']),
    (0x2128, &['\u{005A}']),
    (0x2f9d, &['\u{8EAB}']),
    (0xfced, &['\u{0644}', '\u{0645}']),
    (0xff71, &['\u{30A2}']),
    (0x2a74, &['\u{003A}', '\u{003A}', '\u{003D}']),
    (0x1d764, &['\u{039F}']),
    (0x1f116, &['\u{0028}', '\u{0047}', '\u{0029}']),
    (0x3336, &['\u{30D8}', '\u{30AF}', '\u{30BF}', '\u{30FC}', '\u{30EB}']),
    (0x1d7e2, &['\u{0030}']),
    (0x1ee69, &['\u{064A}']),
    (0x2036, &['\u{2035}', '\u{2035}']),
    (0x1fbd, &['\u{0020}', '\u{0313}']),
    (0x1d5fb, &['\u{006E}']),
    (0xfd57, &['\u{062A}', '\u{0645}', '\u{062E}']),
    (0x2115, &['\u{004E}']),
    (0xff4b, &['\u{006B}']),
    (0xfdf5, &['\u{0635}', '\u{0644}', '\u{0639}', '\u{0645}']),
    (0x24d7, &['\u{0068}']),
    (0x32cb, &['\u{0031}', '\u{0032}', '\u{6708}']),
    (0x1d6e3, &['\u{0392}']),
    (0x32ec, &['\u{30D8}']),
    (0xfd8d, &['\u{0645}', '\u{062C}', '\u{0645}']),
    (0x3204, &['\u{0028}', '\u{1106}', '\u{0029}']),
    (0x331e, &['\u{30B3}', '\u{30FC}', '\u{30DB}', '\u{309A}']),
    (0x3365, &['\u{0031}', '\u{0033}', '\u{70B9}']),
    (0xff45, &['\u{0065}']),
    (0x1ee17, &['\u{062E}']),
    (0xfe9a, &['\u{062B}']),
    (0x1d606, &['\u{0079}']),
    (0x32b3, &['\u{0033}', '\u{0038}']),
    (0x1d7d5, &['\u{0037}']),
    (0xfe64, &['\u{003C}']),
    (0x1d496, &['\u{0075}']),
    (0x2f84, &['\u{81F3}']),
    (0xfbac, &['\u{06BE}']),
    (0x1d478, &['\u{0051}']),
    (0x1d5af, &['\u{0050}']),
    (0x1c9, &['\u{006C}', '\u{006A}']),
    (0x1d45, &['\u{0251}']),
    (0x2fc3, &['\u{9CE5}']),
    (0x1d708, &['\u{03BD}']),
    (0xfe11, &['\u{3001}']),
    (0x1d64f, &['\u{0054}']),
    (0xfd95, &['\u{0646}', '\u{062D}', '\u{0645}']),
    (0x1d5d4, &['\u{0041}']),
    (0x1eea9, &['\u{064A}']),
    (0x33a3, &['\u{006D}', '\u{006D}', '\u{0033}']),
    (0x1d502, &['\u{0079}']),
    (0x1d41d, &['\u{0064}']),
    (0x1ee75, &['\u{062A}']),
    (0x1d489, &['\u{0068}']),
    (0xffd6, &['\u{1171}']),
    (0x1d64d, &['\u{0052}']),
    (0x33a5, &['\u{006D}', '\u{0033}']),
    (0x1d5ab, &['\u{004C}']),
    (0x1d7d3, &['\u{0035}']),
    (0x1d73f, &['\u{03BA}']),
    (0x1d6cb, &['\u{03BA}']),
    (0x1d717, &['\u{03B8}']),
    (0xff1b, &['\u{003B}']),
    (0xfc8d, &['\u{0646}', '\u{0646}']),
    (0xfc65, &['\u{064A}', '\u{0654}', '\u{0632}']),
    (0x1d703, &['\u{03B8}']),
    (0xfb91, &['\u{06A9}']),
    (0xfd12, &['\u{0637}', '\u{064A}']),
    (0xfc63, &['\u{0020}', '\u{0651}', '\u{0670}']),
    (0x1d44f, &['\u{0062}']),
    (0x249f, &['\u{0028}', '\u{0064}', '\u{0029}']),
    (0x1da3, &['\u{0265}']),
    (0x1d6df, &['\u{03C6}']),
    (0xff4e, &['\u{006E}']),
    (0x2f02, &['\u{4E36}']),
    (0x3363, &['\u{0031}', '\u{0031}', '\u{70B9}']),
    (0x2f3c, &['\u{5FC3}']),
    (0x3192, &['\u{4E00}']),
    (0xfd92, &['\u{0645}', '\u{062C}', '\u{062E}']),
    (0x1f105, &['\u{0034}', '\u{002C}']),
    (0x1cc, &['\u{006E}', '\u{006A}']),
    (0xfd6a, &['\u{0634}', '\u{0645}', '\u{062E}']),
    (0x2140, &['\u{2211}']),
    (0xfeda, &['\u{0643}']),
    (0x1f230, &['\u{8D70}']),
    (0xfd6e, &['\u{0636}', '\u{062D}', '\u{0649}']),
    (0x24ce, &['\u{0059}']),
    (0xfb52, &['\u{067B}']),
    (0xfd60, &['\u{0633}', '\u{0645}', '\u{062D}']),
    (0x1f123, &['\u{0028}', '\u{0054}', '\u{0029}']),
    (0xfbf0, &['\u{064A}', '\u{0654}', '\u{06C7}']),
    (0xfbdb, &['\u{06C8}']),
    (0x1d5ad, &['\u{004E}']),
    (0x1d9b, &['\u{0252}']),
    (0x1f104, &['\u{0033}', '\u{002C}']),
    (0x1f21b, &['\u{6599}']),
    (0x2f0f, &['\u{51E0}']),
    (0x2f61, &['\u{74E6}']),
    (0x2484, &['\u{0028}', '\u{0031}', '\u{0037}', '\u{0029}']),
    (0x1d462, &['\u{0075}']),
    (0x1f129, &['\u{0028}', '\u{005A}', '\u{0029}']),
    (0x1d4ce, &['\u{0079}']),
    (0x1d55, &['\u{1D17}']),
    (0xfc5d, &['\u{0649}', '\u{0670}']),
    (0x1ee1f, &['\u{066F}']),
    (0xfe33, &['\u{005F}']),
    (0xfc01, &['\u{064A}', '\u{0654}', '\u{062D}']),
    (0x3233, &['\u{0028}', '\u{793E}', '\u{0029}']),
    (0xfb23, &['\u{05D4}']),
    (0xfc15, &['\u{062C}', '\u{062D}']),
    (0x1d55f, &['\u{006E}']),
    (0x2faa, &['\u{96B6}']),
    (0x1d525, &['\u{0068}']),
    (0xfdbe, &['\u{062C}', '\u{062D}', '\u{064A}']),
    (0x1d762, &['\u{039D}']),
    (0xfe88, &['\u{0627}', '\u{0655}']),
    (0x1d433, &['\u{007A}']),
    (0xfb6d, &['\u{06A4}']),
    (0xfd22, &['\u{0635}', '\u{064A}']),
    (0x3141, &['\u{1106}']),
    (0x32ab, &['\u{5B66}']),
    (0x1d56d, &['\u{0042}']),
    (0x1d630, &['\u{006F}']),
    (0x1db4, &['\u{0283}']),
    (0x1f224, &['\u{58F0}']),
    (0xfc5f, &['\u{0020}', '\u{064D}', '\u{0651}']),
    (0x1d69c, &['\u{0073}']),
    (0x1f136, &['\u{0047}']),
    (0xfd7c, &['\u{0641}', '\u{062E}', '\u{0645}']),
    (0xfd9e, &['\u{0628}', '\u{062E}', '\u{064A}']),
    (0x24e3, &['\u{0074}']),
    (0x3159, &['\u{116B}']),
    (0x3284, &['\u{4E94}']),
    (0x1d4b7, &['\u{0062}']),
    (0x1d7a6, &['\u{03A7}']),
    (0xff38, &['\u{0058}']),
    (0x1d7c8, &['\u{03C1}']),
    (0xb9, &['\u{0031}']),
    (0x3139, &['\u{1105}']),
    (0xfc7a, &['\u{062B}', '\u{0649}']),
    (0xfe3b, &['\u{3010}']),
    (0x2088, &['\u{0038}']),
    (0x1ee02, &['\u{062C}']),
    (0x3263, &['\u{1105}']),
    (0xffc4, &['\u{1163}']),
    (0x1d584, &['\u{0059}']),
    (0x1ee85, &['\u{0648}']),
    (0xfe3f, &['\u{3008}']),
    (0x3332, &['\u{30D5}', '\u{30A1}', '\u{30E9}', '\u{30C3}', '\u{30C8}', '\u{3099}']),
    (0xff7e, &['\u{30BB}']),
    (0x24cc, &['\u{0057}']),
    (0x1d5a9, &['\u{004A}']),
    (0x1c6, &['\u{0064}', '\u{007A}', '\u{030C}']),
    (0x1d791, &['\u{0392}']),
    (0x326d, &['\u{1112}']),
    (0x1d53, &['\u{0254}']),
    (0x314a, &['\u{110E}']),
    (0x2049, &['\u{0021}', '\u{003F}']),
    (0x2178, &['\u{0069}', '\u{0078}']),
    (0x1d41a, &['\u{0061}']),
    (0xfb7c, &['\u{0686}']),
    (0x1ee94, &['\u{0634}']),
    (0x215d, &['\u{0035}', '\u{2044}', '\u{0038}']),
    (0xfda4, &['\u{062A}', '\u{0645}', '\u{0649}']),
    (0xfd87, &['\u{0644}', '\u{0645}', '\u{062D}']),
    (0x1d43f, &['\u{004C}']),
    (0x2fcd, &['\u{9F0E}']),
    (0xfeb6, &['\u{0634}']),
    (0x1d56c, &['\u{0041}']),
    (0x1d65f, &['\u{006A}']),
    (0x3393, &['\u{0047}', '\u{0048}', '\u{007A}']),
    (0x334f, &['\u{30E4}', '\u{30FC}', '\u{30EB}']),
    (0x1d477, &['\u{0050}']),
    (0xfd0b, &['\u{0634}', '\u{062E}']),
    (0x208a, &['\u{002B}']),
    (0x2f1a, &['\u{5382}']),
    (0xfd0d, &['\u{0634}', '\u{0631}']),
    (0xfd26, &['\u{0634}', '\u{062D}']),
    (0x1d54a, &['\u{0053}']),
    (0x2fcf, &['\u{9F20}']),
    (0xfe92, &['\u{0628}']),
    (0xfe4c, &['\u{0020}', '\u{0305}']),
    (0xff96, &['\u{30E8}']),
    (0xfe96, &['\u{062A}']),
    (0x327a, &['\u{1111}', '\u{1161}']),
    (0x335b, &['\u{0033}', '\u{70B9}']),
    (0xff4c, &['\u{006C}']),
    (0x1d561, &['\u{0070}']),
    (0x1f21a, &['\u{7121}']),
    (0xfeb5, &['\u{0634}']),
    (0xff7c, &['\u{30B7}']),
    (0x2f48, &['\u{66F0}']),
    (0x33d3, &['\u{006C}', '\u{0078}']),
    (0x33a9, &['\u{0050}', '\u{0061}']),
    (0x1d67d, &['\u{004E}']),
    (0x1ee2f, &['\u{0639}']),
    (0x1d70f, &['\u{03C4}']),
    (0x1ee7e, &['\u{06A1}']),
    (0x335f, &['\u{0037}', '\u{70B9}']),
    (0x1d602, &['\u{0075}']),
    (0x1d5b3, &['\u{0054}']),
    (0x1d57c, &['\u{0051}']),
    (0x1d6a3, &['\u{007A}']),
    (0x1d5cb, &['\u{0072}']),
    (0x1d76f, &['\u{2207}']),
    (0x1d4e8, &['\u{0059}']),
    (0x1d58e, &['\u{0069}']),
    (0x320a, &['\u{0028}', '\u{110F}', '\u{0029}']),
    (0x1d644, &['\u{0049}']),
    (0x1d474, &['\u{004D}']),
    (0x1eeab, &['\u{0644}']),
    (0xff29, &['\u{0049}']),
    (0x3297, &['\u{795D}']),
    (0x1ee83, &['\u{062F}']),
    (0xff32, &['\u{0052}']),
    (0x1ee0a, &['\u{0643}']),
    (0xffab, &['\u{11B1}']),
    (0x1d725, &['\u{039A}']),
    (0x1d460, &['\u{0073}']),
    (0xfcc2, &['\u{0642}', '\u{062D}']),
    (0x1d63a, &['\u{0079}']),
    (0x1d408, &['\u{0049}']),
    (0x33bf, &['\u{004D}', '\u{0057}']),
    (0x1d664, &['\u{006F}']),
    (0x1d6dd, &['\u{03B8}']),
    (0x1d54e, &['\u{0057}']),
    (0x1d7f2, &['\u{0036}']),
    (0xff37, &['\u{0057}']),
    (0x33e9, &['\u{0031}', '\u{0030}', '\u{65E5}']),
    (0xfebe, &['\u{0636}']),
    (0xfee8, &['\u{0646}']),
    (0x3200, &['\u{0028}', '\u{1100}', '\u{0029}']),
    (0x1d61a, &['\u{0053}']),
    (0x1d9d, &['\u{0255}']),
    (0xfcad, &['\u{0633}', '\u{062C}']),
    (0x1f212, &['\u{53CC}']),
    (0xfc66, &['\u{064A}', '\u{0654}', '\u{0645}']),
    (0x1d5a1, &['\u{0042}']),
    (0xfcc9, &['\u{0644}', '\u{062C}']),
    (0x1d71f, &['\u{0394}']),
    (0x1d425, &['\u{006C}']),
    (0x1d508, &['\u{0045}']),
    (0x3326, &['\u{30C8}', '\u{3099}', '\u{30EB}']),
    (0xfd5b, &['\u{062D}', '\u{0645}', '\u{0649}']),
    (0xff08, &['\u{0028}']),
    (0x1d745, &['\u{03C0}']),
    (0x3386, &['\u{004D}', '\u{0042}']),
    (0x3315, &['\u{30AD}', '\u{30ED}', '\u{30AF}', '\u{3099}', '\u{30E9}', '\u{30E0}']),
    (0x1ee31, &['\u{0635}']),
    (0x32b2, &['\u{0033}', '\u{0037}']),
    (0x3358, &['\u{0030}', '\u{70B9}']),
    (0x1d7bb, &['\u{03C2}']),
    (0x1d73a, &['\u{03B5}']),
    (0x3274, &['\u{1109}', '\u{1161}']),
    (0xfc7f, &['\u{0642}', '\u{064A}']),
    (0x1d747, &['\u{03C2}']),
    (0xfcf8, &['\u{0639}', '\u{064A}']),
    (0xfe60, &['\u{0026}']),
    (0x1d4e1, &['\u{0052}']),
    (0x1d494, &['\u{0073}']),
    (0x3292, &['\u{6709}']),
    (0xfd3d, &['\u{0627}', '\u{064B}']),
    (0xfd29, &['\u{0634}', '\u{0631}']),
    (0x3149, &['\u{110D}']),
    (0xfbab, &['\u{06BE}']),
    (0x1f247, &['\u{3014}', '\u{52DD}', '\u{3015}']),
    (0xfdb6, &['\u{0639}', '\u{0645}', '\u{064A}']),
    (0xfebc, &['\u{0635}']),
    (0x2095, &['\u{0068}']),
    (0x1d57a, &['\u{004F}']),
    (0x1eeb6, &['\u{062B}']),
    (0x1d6ca, &['\u{03B9}']),
    (0x210e, &['\u{0068}']),
    (0x1d652, &['\u{0057}']),
    (0xfec3, &['\u{0637}']),
    (0xfbeb, &['\u{064A}', '\u{0654}', '\u{0627}']),
    (0x1d702, &['\u{03B7}']),
    (0x1d615, &['\u{004E}']),
    (0x2f0c, &['\u{5182}']),
    (0x3185, &['\u{1158}']),
    (0x1d42a, &['\u{0071}']),
    (0x247b, &['\u{0028}', '\u{0038}', '\u{0029}']),
    (0x2f7e, &['\u{8012}']),
    (0xfd2a, &['\u{0633}', '\u{0631}']),
    (0x209a, &['\u{0070}']),
    (0xfb72, &['\u{0684}']),
    (0x1d503, &['\u{007A}']),
    (0xff5a, &['\u{007A}']),
    (0x334e, &['\u{30E4}', '\u{30FC}', '\u{30C8}', '\u{3099}']),
    (0xfbda, &['\u{06C6}']),
    (0x1ee36, &['\u{062B}']),
    (0xff5c, &['\u{007C}']),
    (0x1d722, &['\u{0397}']),
    (0x1d79b, &['\u{039C}']),
    (0x1d720, &['\u{0395}']),
    (0x2f05, &['\u{4E85}']),
    (0xfb16, &['\u{057E}', '\u{0576}']),
    (0xfc80, &['\u{0643}', '\u{0627}']),
    (0xfec1, &['\u{0637}']),
    (0x2fa7, &['\u{9577}']),
    (0xfc84, &['\u{0643}', '\u{064A}']),
    (0x1ee34, &['\u{0634}']),
    (0x1d4c1, &['\u{006C}']),
    (0x33ca, &['\u{0068}', '\u{0061}']),
    (0x1f143, &['\u{0054}']),
    (0x24b4, &['\u{0028}', '\u{0079}', '\u{0029}']),
    (0x24c9, &['\u{0054}']),
    (0x1d5b7, &['\u{0058}']),
    (0x248f, &['\u{0038}', '\u{002E}']),
    (0xff84, &['\u{30C8}']),
    (0x3324, &['\u{30BF}', '\u{3099}', '\u{30FC}', '\u{30B9}']),
    (0x1d5f0, &['\u{0063}']),
    (0x2147, &['\u{0065}']),
    (0x24a4, &['\u{0028}', '\u{0069}', '\u{0029}']),
    (0x3251, &['\u{0032}', '\u{0031}']),
    (0xfc92, &['\u{064A}', '\u{0632}']),
    (0xfcdf, &['\u{064A}', '\u{0654}', '\u{0645}']),
    (0xfe9c, &['\u{062B}']),
    (0x1d740, &['\u{03BB}']),
    (0x1f240, &['\u{3014}', '\u{672C}', '\u{3015}']),
    (0x2f07, &['\u{4EA0}']),
    (0x3373, &['\u{0041}', '\u{0055}']),
    (0xff18, &['\u{0038}']),
    (0xfd1b, &['\u{062D}', '\u{0649}']),
    (0x1f250, &['\u{5F97}']),
    (0xff60, &['\u{2986}']),
    (0xfd06, &['\u{0635}', '\u{064A}']),
    (0x2fca, &['\u{9ED1}']),
    (0xfbe3, &['\u{06C9}']),
    (0x32ea, &['\u{30D2}']),
    (0x1d6f0, &['\u{039F}']),
    (0xfc7d, &['\u{0641}', '\u{064A}']),
    (0xfb87, &['\u{068E}']),
    (0x24bb, &['\u{0046}']),
    (0x1ee74, &['\u{0634}']),
    (0xfbd4, &['\u{06AD}']),
    (0xfeab, &['\u{0630}']),
    (0x3170, &['\u{11DF}']),
    (0xfd7f, &['\u{0642}', '\u{0645}', '\u{0645}']),
    (0x1ee06, &['\u{0632}']),
    (0xfdfb, &['\u{062C}', '\u{0644}', '\u{0020}', '\u{062C}', '\u{0644}', '\u{0627}', '\u{0644}', '\u{0647}']),
    (0xfbe4, &['\u{06D0}']),
    (0xfb85, &['\u{068C}']),
    (0x1f216, &['\u{89E3}']),
    (0x1d5c8, &['\u{006F}']),
    (0xfcdb, &['\u{064A}', '\u{062D}']),
    (0xfc6f, &['\u{0628}', '\u{064A}']),
    (0x327b, &['\u{1112}', '\u{1161}']),
    (0x2f04, &['\u{4E59}']),
    (0x1d7f6, &['\u{0030}']),
    (0xfca9, &['\u{062D}', '\u{062C}']),
    (0xff2e, &['\u{004E}']),
    (0x2f6b, &['\u{76BF}']),
    (0x1d4f6, &['\u{006D}']),
    (0xfdae, &['\u{064A}', '\u{062D}', '\u{064A}']),
    (0x1d672, &['\u{0043}']),
    (0xfef6, &['\u{0644}', '\u{0627}', '\u{0653}']),
    (0x32af, &['\u{5354}']),
    (0xfcb9, &['\u{0638}', '\u{0645}']),
    (0xfbd6, &['\u{06AD}']),
    (0x1d7f4, &['\u{0038}']),
    (0x1d4e9, &['\u{005A}']),
    (0x32c7, &['\u{0038}', '\u{6708}']),
    (0x32dc, &['\u{30B9}']),
    (0x1d530, &['\u{0073}']),
    (0x33cc, &['\u{0069}', '\u{006E}']),
    (0x1ee80, &['\u{0627}']),
    (0xfcf3, &['\u{0640}', '\u{064F}', '\u{0651}']),
    (0x333b, &['\u{30D8}', '\u{309A}', '\u{30FC}', '\u{30B7}', '\u{3099}']),
    (0x1d5a0, &['\u{0041}']),
    (0xfd70, &['\u{0636}', '\u{062E}', '\u{0645}']),
    (0xb4, &['\u{0020}', '\u{0301}']),
    (0xfd2d, &['\u{0634}', '\u{062C}']),
    (0x1eeba, &['\u{0638}']),
    (0x1f229, &['\u{4E00}']),
    (0x2158, &['\u{0034}', '\u{2044}', '\u{0035}']),
    (0x1d737, &['\u{03B2}']),
    (0xfc5a, &['\u{064A}', '\u{064A}']),
    (0x1eeb0, &['\u{0641}']),
    (0x1d35, &['\u{0049}']),
    (0x1d7a7, &['\u{03A8}']),
    (0x1d771, &['\u{03B2}']),
    (0x1d639, &['\u{0078}']),
    (0x2083, &['\u{0033}']),
    (0x322a, &['\u{0028}', '\u{6708}', '\u{0029}']),
    (0x1d516, &['\u{0053}']),
    (0xfc35, &['\u{0642}', '\u{0649}']),
    (0x1fde, &['\u{0020}', '\u{0314}', '\u{0301}']),
    (0x1d69e, &['\u{0075}']),
    (0x339f, &['\u{006D}', '\u{006D}', '\u{0032}']),
    (0xfecf, &['\u{063A}']),
    (0x323d, &['\u{0028}', '\u{4F01}', '\u{0029}']),
    (0xff07, &['\u{0027}']),
    (0x1f127, &['\u{0028}', '\u{0058}', '\u{0029}']),
    (0xff41, &['\u{0061}']),
    (0x315b, &['\u{116D}']),
    (0x2f8a, &['\u{8272}']),
    (0x1d712, &['\u{03C7}']),
    (0xfe99, &['\u{062B}']),
    (0xfed1, &['\u{0641}']),
    (0xfcc8, &['\u{0643}', '\u{0645}']),
    (0x323b, &['\u{0028}', '\u{5B66}', '\u{0029}']),
    (0x30ff, &['\u{30B3}', '\u{30C8}']),
    (0xfb96, &['\u{06B3}']),
    (0x329e, &['\u{5370}']),
    (0x1d49, &['\u{0065}']),
    (0xfb5e, &['\u{067A}']),
    (0x2f27, &['\u{5B80}']),
    (0x2f8c, &['\u{864D}']),
    (0x2f56, &['\u{722A}']),
    (0x1d507, &['\u{0044}']),
    (0xfc94, &['\u{064A}', '\u{0646}']),
    (0x1d63f, &['\u{0044}']),
    (0xfd67, &['\u{0634}', '\u{062D}', '\u{0645}']),
    (0xff09, &['\u{0029}']),
    (0x1d5a4, &['\u{0045}']),
    (0xfed3, &['\u{0641}']),
    (0x1d39, &['\u{004D}']),
    (0x1d61c, &['\u{0055}']),
    (0x2497, &['\u{0031}', '\u{0036}', '\u{002E}']),
    (0xff91, &['\u{30E0}']),
    (0x2f78, &['\u{7F36}']),
    (0x33b4, &['\u{0070}', '\u{0056}']),
    (0x1eea7, &['\u{062D}']),
    (0x2486, &['\u{0028}', '\u{0031}', '\u{0039}', '\u{0029}']),
    (0xfc36, &['\u{0642}', '\u{064A}']),
    (0x2f25, &['\u{5973}']),
    (0x2f98, &['\u{8C78}']),
    (0x2477, &['\u{0028}', '\u{0034}', '\u{0029}']),
    (0xfc27, &['\u{0637}', '\u{0645}']),
    (0x1ee96, &['\u{062B}']),
    (0xfdab, &['\u{0636}', '\u{062D}', '\u{064A}']),
    (0x1f242, &['\u{3014}', '\u{4E8C}', '\u{3015}']),
    (0x3385, &['\u{004B}', '\u{0042}']),
    (0x1d59b, &['\u{0076}']),
    (0xfc45, &['\u{0645}', '\u{062C}']),
    (0x1d6f2, &['\u{03A1}']),
    (0x1d54c, &['\u{0055}']),
    (0x24a6, &['\u{0028}', '\u{006B}', '\u{0029}']),
    (0x1d5ed, &['\u{005A}']),
    (0x1d4d8, &['\u{0049}']),
    (0x3293, &['\u{793E}']),
    (0x2f36, &['\u{5EFE}']),
    (0xfcea, &['\u{0634}', '\u{0647}']),
    (0x1f121, &['\u{0028}', '\u{0052}', '\u{0029}']),
    (0x2149, &['\u{006A}']),
    (0xfbf8, &['\u{064A}', '\u{0654}', '\u{06D0}']),
    (0xfeca, &['\u{0639}']),
    (0x1d5ca, &['\u{0071}']),
    (0x1d5b9, &['\u{005A}']),
    (0xfe70, &['\u{0020}', '\u{064B}']),
    (0x318b, &['\u{1192}']),
    (0xff42, &['\u{0062}']),
    (0x1d43a, &['\u{0047}']),
    (0x1d7ba, &['\u{03C1}']),
    (0x1ee7a, &['\u{0638}']),
    (0x325d, &['\u{0033}', '\u{0033}']),
    (0x1d452, &['\u{0065}']),
    (0x317c, &['\u{112F}']),
    (0x1d424, &['\u{006B}']),
    (0xfcbb, &['\u{0639}', '\u{0645}']),
    (0x1d58a, &['\u{0065}']),
    (0x327d, &['\u{110C}', '\u{116E}', '\u{110B}', '\u{1174}']),
    (0x24c6, &['\u{0051}']),
    (0xfdad, &['\u{0644}', '\u{0645}', '\u{064A}']),
    (0x32f1, &['\u{30E1}']),
    (0xfe3a, &['\u{3015}']),
    (0x2498, &['\u{0031}', '\u{0037}', '\u{002E}']),
    (0xfb9f, &['\u{06BA}']),
    (0xfd7e, &['\u{0642}', '\u{0645}', '\u{062D}']),
    (0x336f, &['\u{0032}', '\u{0033}', '\u{70B9}']),
    (0xfebb, &['\u{0635}']),
    (0xffe5, &['\u{00A5}']),
    (0x1ee22, &['\u{062C}']),
    (0xff5e, &['\u{007E}']),
    (0x1d735, &['\u{2207}']),
    (0xfcc3, &['\u{0642}', '\u{0645}']),
    (0x2f42, &['\u{6587}']),
    (0xfee4, &['\u{0645}']),
    (0x2f17, &['\u{5341}']),
    (0x2091, &['\u{0065}']),
    (0x24ab, &['\u{0028}', '\u{0070}', '\u{0029}']),
    (0x1d7e7, &['\u{0035}']),
    (0x33db, &['\u{0073}', '\u{0072}']),
    (0x1dbc, &['\u{0290}']),
    (0x1f109, &['\u{0038}', '\u{002C}']),
    (0x3255, &['\u{0032}', '\u{0035}']),
    (0x1d5f9, &['\u{006C}']),
    (0x1d4bf, &['\u{006A}']),
    (0x2f9f, &['\u{8F9B}']),
    (0x319a, &['\u{4E59}']),
    (0x3275, &['\u{110B}', '\u{1161}']),
    (0xfd20, &['\u{062E}', '\u{064A}']),
    (0x1d40b, &['\u{004C}']),
    (0x2f2f, &['\u{5DE5}']),
    (0x1d422, &['\u{0069}']),
    (0xfc2e, &['\u{0641}', '\u{062D}']),
    (0xff04, &['\u{0024}']),
    (0x1eeb1, &['\u{0635}']),
    (0x3350, &['\u{30E6}', '\u{30A2}', '\u{30F3}']),
    (0x3367, &['\u{0031}', '\u{0035}', '\u{70B9}']),
    (0x337e, &['\u{660E}', '\u{6CBB}']),
    (0xbe, &['\u{0033}', '\u{2044}', '\u{0034}']),
    (0xfbfd, &['\u{06CC}']),
    (0x2f5f, &['\u{7389}']),
    (0x3348, &['\u{30DF}', '\u{30AF}', '\u{30ED}', '\u{30F3}']),
    (0xff11, &['\u{0031}']),
    (0x32c9, &['\u{0031}', '\u{0030}', '\u{6708}']),
    (0x1ee90, &['\u{0641}']),
    (0x1d6f7, &['\u{03A6}']),
    (0x247e, &['\u{0028}', '\u{0031}', '\u{0031}', '\u{0029}']),
    (0xfeaa, &['\u{062F}']),
    (0x1d68d, &['\u{0064}']),
    (0x317a, &['\u{112D}']),
    (0x1d42b, &['\u{0072}']),
    (0x3f2, &['\u{03C2}']),
    (0x2f18, &['\u{535C}']),
    (0x3347, &['\u{30DE}', '\u{30F3}', '\u{30B7}', '\u{30E7}', '\u{30F3}']),
    (0x1d65, &['\u{0076}']),
    (0x1d775, &['\u{03B6}']),
    (0x1d554, &['\u{0063}']),
    (0xff65, &['\u{30FB}']),
    (0x249e, &['\u{0028}', '\u{0063}', '\u{0029}']),
    (0x2f22, &['\u{590A}']),
    (0x1d571, &['\u{0046}']),
    (0x1d46a, &['\u{0043}']),
    (0x1d53d, &['\u{0046}']),
    (0x2099, &['\u{006E}']),
    (0xfc52, &['\u{0647}', '\u{0645}']),
    (0x1d534, &['\u{0077}']),
    (0xfd81, &['\u{0644}', '\u{062D}', '\u{064A}']),
    (0x1d701, &['\u{03B6}']),
    (0xfe69, &['\u{0024}']),
    (0x1d75a, &['\u{0395}']),
    (0xfbaa, &['\u{06BE}']),
    (0x2f21, &['\u{5902}']),
    (0xff1a, &['\u{003A}']),
    (0x3276, &['\u{110C}', '\u{1161}']),
    (0xfc60, &['\u{0020}', '\u{064E}', '\u{0651}']),
    (0x1d6a8, &['\u{0391}']),
    (0x1d778, &['\u{03B9}']),
    (0xfcc7, &['\u{0643}', '\u{0644}']),
    (0x1d574, &['\u{0049}']),
    (0x3359, &['\u{0031}', '\u{70B9}']),
    (0xfd1f, &['\u{062E}', '\u{0649}']),
    (0x3179, &['\u{112C}']),
    (0x1eea2, &['\u{062C}']),
    (0x3267, &['\u{110B}']),
    (0x24ea, &['\u{0030}']),
    (0x318a, &['\u{1191}']),
    (0x3278, &['\u{110F}', '\u{1161}']),
    (0x1d31, &['\u{0045}']),
    (0x1d686, &['\u{0057}']),
    (0x32a5, &['\u{4E2D}']),
    (0x2f2c, &['\u{5C6E}']),
    (0xfcd1, &['\u{0645}', '\u{0645}']),
    (0x1d500, &['\u{0077}']),
    (0xfc0b, &['\u{062A}', '\u{062C}']),
    (0x327c, &['\u{110E}', '\u{1161}', '\u{11B7}', '\u{1100}', '\u{1169}']),
    (0xff14, &['\u{0034}']),
    (0x1d74d, &['\u{03C8}']),
    (0xfe71, &['\u{0640}', '\u{064B}']),
    (0xff99, &['\u{30EB}']),
    (0xfdc3, &['\u{0643}', '\u{0645}', '\u{0645}']),
    (0x2f95, &['\u{8C37}']),
    (0x1f113, &['\u{0028}', '\u{0044}', '\u{0029}']),
    (0x1d481, &['\u{005A}']),
    (0x2155, &['\u{0031}', '\u{2044}', '\u{0035}']),
    (0x1daa, &['\u{1D85}']),
    (0x1d7cb, &['\u{03DD}']),
    (0xfc13, &['\u{062B}', '\u{0649}']),
    (0x2f6a, &['\u{76AE}']),
    (0xfb8c, &['\u{0691}']),
    (0x2f5b, &['\u{7259}']),
    (0xfc96, &['\u{064A}', '\u{064A}']),
    (0x1d728, &['\u{039D}']),
    (0x1d565, &['\u{0074}']),
    (0x1ee6c, &['\u{0645}']),
    (0x1fcf, &['\u{0020}', '\u{0313}', '\u{0342}']),
    (0x1f142, &['\u{0053}']),
    (0x1f115, &['\u{0028}', '\u{0046}', '\u{0029}']),
    (0x1d544, &['\u{004D}']),
    (0x1db7, &['\u{028A}']),
    (0x1eeb7, &['\u{062E}']),
    (0xfec4, &['\u{0637}']),
    (0x678, &['\u{064A}', '\u{0674}']),
    (0xfbee, &['\u{064A}', '\u{0654}', '\u{0648}']),
    (0xfc4f, &['\u{0646}', '\u{0649}']),
    (0xfead, &['\u{0631}']),
    (0x2002, &['\u{0020}']),
    (0xfda6, &['\u{062C}', '\u{062D}', '\u{0649}']),
    (0x1d431, &['\u{0078}']),
    (0xfeb9, &['\u{0635}']),
    (0x1d757, &['\u{0392}']),
    (0x1ee07, &['\u{062D}']),
    (0x1d36, &['\u{004A}']),
    (0x1d724, &['\u{0399}']),
    (0xfd09, &['\u{0634}', '\u{062C}']),
    (0x1ee05, &['\u{0648}']),
    (0x1d7c3, &['\u{2202}']),
    (0x1d4c8, &['\u{0073}']),
    (0x1d30, &['\u{0044}']),
    (0x2b0, &['\u{0068}']),
    (0x1d7c1, &['\u{03C8}']),
    (0x1f234, &['\u{5408}']),
    (0xffe1, &['\u{00A3}']),
    (0x2468, &['\u{0039}']),
    (0x1d416, &['\u{0057}']),
    (0x1d569, &['\u{0078}']),
    (0xfc87, &['\u{0644}', '\u{064A}']),
    (0x215c, &['\u{0033}', '\u{2044}', '\u{0038}']),
    (0x1ee4b, &['\u{0644}']),
    (0xfe6b, &['\u{0040}']),
    (0x313b, &['\u{11B1}']),
    (0x1d7ae, &['\u{03B5}']),
    (0x1d6bc, &['\u{03A5}']),
    (0x1ee62, &['\u{062C}']),
    (0x1ee79, &['\u{0636}']),
    (0xfc57, &['\u{064A}', '\u{062E}']),
    (0x2f3a, &['\u{5F61}']),
    (0xfdf9, &['\u{0635}', '\u{0644}', '\u{0649}']),
    (0x1ee24, &['\u{0647}']),
    (0x1ee03, &['\u{062F}']),
    (0x2f19, &['\u{5369}']),
    (0xfb27, &['\u{05E8}']),
    (0xfd23, &['\u{0636}', '\u{0649}']),
    (0x1ee2a, &['\u{0643}']),
    (0x2a76, &['\u{003D}', '\u{003D}', '\u{003D}']),
    (0xff69, &['\u{30A5}']),
    (0x246f, &['\u{0031}', '\u{0036}']),
    (0x2f13, &['\u{52F9}']),
    (0xfd07, &['\u{0636}', '\u{0649}']),
    (0x1d59f, &['\u{007A}']),
    (0x1ee52, &['\u{0642}']),
    (0xfe77, &['\u{0640}', '\u{064E}']),
    (0x2153, &['\u{0031}', '\u{2044}', '\u{0033}']),
    (0xfc4d, &['\u{0646}', '\u{062E}']),
    (0xfeaf, &['\u{0632}']),
    (0x33f4, &['\u{0032}', '\u{0031}', '\u{65E5}']),
    (0xfd8a, &['\u{0645}', '\u{062D}', '\u{0645}']),
    (0x1d69b, &['\u{0072}']),
    (0x1d713, &['\u{03C8}']),
    (0xfc93, &['\u{064A}', '\u{0645}']),
    (0x3344, &['\u{30DE}', '\u{30A4}', '\u{30EB}']),
    (0x1d7a4, &['\u{03A5}']),
    (0x1d47f, &['\u{0058}']),
    (0x1d546, &['\u{004F}']),
    (0xfba1, &['\u{06BB}']),
    (0x1d736, &['\u{03B1}']),
    (0xfc3c, &['\u{0643}', '\u{0645}']),
    (0xfb59, &['\u{067E}']),
    (0xfb4f, &['\u{05D0}', '\u{05DC}']),
    (0xfeef, &['\u{0649}']),
    (0x33c9, &['\u{0047}', '\u{0079}']),
    (0x207f, &['\u{006E}']),
    (0xff3a, &['\u{005A}']),
    (0x1d673, &['\u{0044}']),
    (0x1f119, &['\u{0028}', '\u{004A}', '\u{0029}']),
    (0xfc1c, &['\u{0633}', '\u{062C}']),
    (0x1d649, &['\u{004E}']),
    (0x1d589, &['\u{0064}']),
    (0x3231, &['\u{0028}', '\u{682A}', '\u{0029}']),
    (0x3138, &['\u{1104}']),
    (0x247d, &['\u{0028}', '\u{0031}', '\u{0030}', '\u{0029}']),
    (0xfcd9, &['\u{0647}', '\u{0670}']),
    (0x1dae, &['\u{0272}']),
    (0x1d7be, &['\u{03C5}']),
    (0x33df, &['\u{0041}', '\u{2215}', '\u{006D}']),
    (0x337a, &['\u{0049}', '\u{0055}']),
    (0x2f5e, &['\u{7384}']),
    (0xa770, &['\u{A76F}']),
    (0x1ee8f, &['\u{0639}']),
    (0x32b9, &['\u{0034}', '\u{0034}']),
    (0x1d44, &['\u{0250}']),
    (0x1f2, &['\u{0044}', '\u{007A}']),
    (0x1d463, &['\u{0076}']),
    (0x3346, &['\u{30DE}', '\u{30EB}', '\u{30AF}']),
    (0x1d7a0, &['\u{03A1}']),
    (0x2096, &['\u{006B}']),
    (0x1d76a, &['\u{03A5}']),
    (0xff48, &['\u{0068}']),
    (0x1d532, &['\u{0075}']),
    (0x24e0, &['\u{0071}']),
    (0xfd5d, &['\u{0633}', '\u{062C}', '\u{062D}']),
    (0x2134, &['\u{006F}']),
    (0xfd1e, &['\u{062C}', '\u{064A}']),
    (0x1f226, &['\u{6F14}']),
    (0xffda, &['\u{1173}']),
    (0x1d69, &['\u{03C6}']),
    (0xff21, &['\u{0041}']),
    (0x3145, &['\u{1109}']),
    (0x3136, &['\u{11AD}']),
    (0xfbf2, &['\u{064A}', '\u{0654}', '\u{06C6}']),
    (0xfdf6, &['\u{0631}', '\u{0633}', '\u{0648}', '\u{0644}']),
    (0x1d68e, &['\u{0065}']),
    (0x1d46f, &['\u{0048}']),
    (0xffe9, &['\u{2190}']),
    (0xfbd7, &['\u{06C7}']),
    (0x3133, &['\u{11AA}']),
    (0xfd33, &['\u{0637}', '\u{0645}']),
    (0x1f13e, &['\u{004F}']),
    (0xffba, &['\u{110E}']),
    (0x1d50, &['\u{006D}']),
    (0xff17, &['\u{0037}']),
    (0x24d9, &['\u{006A}']),
    (0xfc8c, &['\u{0646}', '\u{0645}']),
    (0x1d797, &['\u{0398}']),
    (0xfc06, &['\u{0628}', '\u{062D}']),
    (0x1d529, &['\u{006C}']),
    (0x213b, &['\u{0046}', '\u{0041}', '\u{0058}']),
    (0x2167, &['\u{0056}', '\u{0049}', '\u{0049}', '\u{0049}']),
    (0x1d75b, &['\u{0396}']),
    (0x1d4b, &['\u{025B}']),
    (0x2f00, &['\u{4E00}']),
    (0xaf, &['\u{0020}', '\u{0304}']),
    (0x2f92, &['\u{898B}']),
    (0xfc85, &['\u{0644}', '\u{0645}']),
    (0xfe61, &['\u{002A}']),
    (0x1d671, &['\u{0042}']),
    (0x1d411, &['\u{0052}']),
    (0x1d42f, &['\u{0076}']),
    (0x3244, &['\u{554F}']),
    (0x1d51c, &['\u{0059}']),
    (0xff92, &['\u{30E1}']),
    (0x3395, &['\u{03BC}', '\u{006C}']),
    (0x1d674, &['\u{0045}']),
    (0xfbe6, &['\u{06D0}']),
    (0x1da7, &['\u{1D7B}']),
    (0x33a4, &['\u{0063}', '\u{006D}', '\u{0033}']),
    (0xfbea, &['\u{064A}', '\u{0654}', '\u{0627}']),
    (0x2001, &['\u{0020}']),
    (0x1d6cf, &['\u{03BE}']),
    (0x2f28, &['\u{5BF8}']),
    (0xfe81, &['\u{0627}', '\u{0653}']),
    (0x1d7d8, &['\u{0030}']),
    (0x1d78, &['\u{043D}']),
    (0x2f85, &['\u{81FC}']),
    (0x3310, &['\u{30AD}', '\u{3099}', '\u{30AB}', '\u{3099}']),
    (0x1d7bd, &['\u{03C4}']),
    (0x3259, &['\u{0032}', '\u{0039}']),
    (0x1f200, &['\u{307B}', '\u{304B}']),
    (0xff57, &['\u{0077}']),
    (0x1d517, &['\u{0054}']),
    (0x1d62b, &['\u{006A}']),
    (0x1d5e, &['\u{03B3}']),
    (0x1d55e, &['\u{006D}']),
    (0xff82, &['\u{30C4}']),
    (0x1f221, &['\u{7D42}']),
    (0xfd93, &['\u{0647}', '\u{0645}', '\u{062C}']),
    (0xfeb0, &['\u{0632}']),
    (0x1d4c5, &['\u{0070}']),
    (0x1d792, &['\u{0393}']),
    (0x334d, &['\u{30E1}', '\u{30FC}', '\u{30C8}', '\u{30EB}']),
    (0x2113, &['\u{006C}']),
    (0x1d58c, &['\u{0067}']),
    (0xff15, &['\u{0035}']),
    (0xfcfd, &['\u{0634}', '\u{0649}']),
    (0x1d6a9, &['\u{0392}']),
    (0xffd5, &['\u{1170}']),
    (0x1ee1c, &['\u{066E}']),
    (0xfccb, &['\u{0644}', '\u{062E}']),
    (0x1d595, &['\u{0070}']),
    (0x1d426, &['\u{006D}']),
    (0x1d5f, &['\u{03B4}']),
    (0x1d655, &['\u{005A}']),
    (0x1d6b5, &['\u{039E}']),
    (0xfe48, &['\u{005D}']),
    (0xffb1, &['\u{1106}']),
    (0x1ffe, &['\u{0020}', '\u{0314}']),
    (0xfdf3, &['\u{0627}', '\u{0643}', '\u{0628}', '\u{0631}']),
    (0x1d6af, &['\u{0398}']),
    (0x1ee1e, &['\u{06A1}']),
    (0x1d5f2, &['\u{0065}']),
    (0x325c, &['\u{0033}', '\u{0032}']),
    (0x1d77c, &['\u{03BD}']),
    (0x3383, &['\u{006D}', '\u{0041}']),
    (0xfb22, &['\u{05D3}']),
    (0x24a8, &['\u{0028}', '\u{006D}', '\u{0029}']),
    (0x24c4, &['\u{004F}']),
    (0x3142, &['\u{1107}']),
    (0x24d8, &['\u{0069}']),
    (0xfd9f, &['\u{062A}', '\u{062C}', '\u{064A}']),
    (0xfc5e, &['\u{0020}', '\u{064C}', '\u{0651}']),
    (0x1f213, &['\u{30C6}', '\u{3099}']),
    (0xfe4b, &['\u{0020}', '\u{0305}']),
    (0x3238, &['\u{0028}', '\u{52B4}', '\u{0029}']),
    (0x1d41b, &['\u{0062}']),
    (0x1ee0e, &['\u{0633}']),
    (0x24aa, &['\u{0028}', '\u{006F}', '\u{0029}']),
    (0x3209, &['\u{0028}', '\u{110E}', '\u{0029}']),
    (0xfc79, &['\u{062B}', '\u{0646}']),
    (0xfd85, &['\u{0644}', '\u{062E}', '\u{0645}']),
    (0x1d64a, &['\u{004F}']),
    (0x32fb, &['\u{30EF}']),
    (0x2d8, &['\u{0020}', '\u{0306}']),
    (0x338c, &['\u{03BC}', '\u{0046}']),
    (0xffae, &['\u{11B4}']),
    (0x2493, &['\u{0031}', '\u{0032}', '\u{002E}']),
    (0x1f128, &['\u{0028}', '\u{0059}', '\u{0029}']),
    (0x1ee95, &['\u{062A}']),
    (0x2fab, &['\u{96B9}']),
    (0x2fc7, &['\u{9EBB}']),
    (0xfcd6, &['\u{0646}', '\u{0647}']),
    (0x2164, &['\u{0056}']),
    (0xff83, &['\u{30C6}']),
    (0x2f94, &['\u{8A00}']),
    (0x1d6ed, &['\u{039C}']),
    (0xfc25, &['\u{0636}', '\u{0645}']),
    (0xfb63, &['\u{067F}']),
    (0xfc3a, &['\u{0643}', '\u{062E}']),
    (0x3262, &['\u{1103}']),
    (0x1d7fa, &['\u{0034}']),
    (0x336c, &['\u{0032}', '\u{0030}', '\u{70B9}']),
    (0x24ae, &['\u{0028}', '\u{0073}', '\u{0029}']),
    (0x1d4aa, &['\u{004F}']),
    (0x1d755, &['\u{03C0}']),
    (0x32f5, &['\u{30E8}']),
    (0xfea0, &['\u{062C}']),
    (0xffa8, &['\u{1104}']),
    (0xfe68, &['\u{005C}']),
    (0x1d556, &['\u{0065}']),
    (0x2156, &['\u{0032}', '\u{2044}', '\u{0035}']),
    (0xfe93, &['\u{0629}']),
    (0x1d6f5, &['\u{03A4}']),
    (0xfbfb, &['\u{064A}', '\u{0654}', '\u{0649}']),
    (0x33b0, &['\u{0070}', '\u{0073}']),
    (0x2d9, &['\u{0020}', '\u{0307}']),
    (0x1d44d, &['\u{005A}']),
    (0x1f14a, &['\u{0048}', '\u{0056}']),
    (0xfbdc, &['\u{06C8}']),
    (0xff2a, &['\u{004A}']),
    (0x3220, &['\u{0028}', '\u{4E00}', '\u{0029}']),
    (0x1d63d, &['\u{0042}']),
    (0x1d6e9, &['\u{0398}']),
    (0xfdc0, &['\u{0645}', '\u{062C}', '\u{064A}']),
    (0x1d7a3, &['\u{03A4}']),
    (0x1d622, &['\u{0061}']),
    (0xff9c, &['\u{30EF}']),
    (0x3268, &['\u{110C}']),
    (0x1da5, &['\u{0269}']),
    (0x3226, &['\u{0028}', '\u{4E03}', '\u{0029}']),
    (0x33b9, &['\u{004D}', '\u{0056}']),
    (0x1d451, &['\u{0064}']),
    (0x1d5d0, &['\u{0077}']),
    (0xff6e, &['\u{30E7}']),
    (0x2f15, &['\u{531A}']),
    (0x32e6, &['\u{30CC}']),
    (0xfb28, &['\u{05EA}']),
    (0xfd27, &['\u{0634}', '\u{062E}']),
    (0xfcf1, &['\u{064A}', '\u{0647}']),
    (0x32c5, &['\u{0036}', '\u{6708}']),
    (0x1d568, &['\u{0077}']),
    (0x1d626, &['\u{0065}']),
    (0xfd82, &['\u{0644}', '\u{062D}', '\u{0649}']),
    (0x331c, &['\u{30B1}', '\u{30FC}', '\u{30B9}']),
    (0x1d513, &['\u{0050}']),
    (0x33ad, &['\u{0072}', '\u{0061}', '\u{0064}']),
    (0xfcaf, &['\u{0633}', '\u{062E}']),
    (0x1d5cf, &['\u{0076}']),
    (0x32a4, &['\u{4E0A}']),
    (0xffbd, &['\u{1111}']),
    (0x1d7a9, &['\u{2207}']),
    (0xff2c, &['\u{004C}']),
    (0x1d5e6, &['\u{0053}']),
    (0x2f54, &['\u{6C34}']),
    (0x1ee08, &['\u{0637}']),
    (0x2179, &['\u{0078}']),
    (0x1db0, &['\u{0274}']),
    (0x1d4ea, &['\u{0061}']),
    (0x1d5c5, &['\u{006C}']),
    (0x1d7e5, &['\u{0033}']),
    (0x1d4f2, &['\u{0069}']),
    (0x1d65e, &['\u{0069}']),
    (0x1d679, &['\u{004A}']),
    (0xfcd0, &['\u{0645}', '\u{062E}']),
    (0xfb64, &['\u{067F}']),
    (0xfc10, &['\u{062A}', '\u{064A}']),
    (0xffa7, &['\u{1103}']),
    (0x1dba, &['\u{028C}']),
    (0xfcef, &['\u{0646}', '\u{0647}']),
    (0x3379, &['\u{0064}', '\u{006D}', '\u{0033}']),
    (0x1d74b, &['\u{03C6}']),
    (0x247c, &['\u{0028}', '\u{0039}', '\u{0029}']),
    (0x1da9, &['\u{026D}']),
    (0x1d7ec, &['\u{0030}']),
    (0x1f106, &['\u{0035}', '\u{002C}']),
    (0xfe31, &['\u{2014}']),
    (0x1d2d, &['\u{00C6}']),
    (0x3252, &['\u{0032}', '\u{0032}']),
    (0x33c0, &['\u{006B}', '\u{03A9}']),
    (0xfb6e, &['\u{06A6}']),
    (0xfc51, &['\u{0647}', '\u{062C}']),
    (0xfcdc, &['\u{064A}', '\u{062E}']),
    (0x32a9, &['\u{533B}']),
    (0x32c8, &['\u{0039}', '\u{6708}']),
    (0xfb05, &['\u{0073}', '\u{0074}']),
    (0x1d688, &['\u{0059}']),
    (0x32ce, &['\u{0065}', '\u{0056}']),
    (0x2094, &['\u{0259}']),
    (0x1d6fc, &['\u{03B1}']),
    (0x32f6, &['\u{30E9}']),
    (0x1f135, &['\u{0046}']),
    (0x1dbe, &['\u{0292}']),
    (0x1d5e5, &['\u{0052}']),
    (0xfdf0, &['\u{0635}', '\u{0644}', '\u{06D2}']),
    (0xfda1, &['\u{062A}', '\u{062E}', '\u{064A}']),
    (0x1d7bf, &['\u{03C6}']),
    (0x3316, &['\u{30AD}', '\u{30ED}', '\u{30E1}', '\u{30FC}', '\u{30C8}', '\u{30EB}']),
    (0x3391, &['\u{006B}', '\u{0048}', '\u{007A}']),
    (0xfc5b, &['\u{0630}', '\u{0670}']),
    (0x1d41f, &['\u{0066}']),
    (0xfc17, &['\u{062D}', '\u{062C}']),
    (0xfcda, &['\u{064A}', '\u{062C}']),
    (0x249a, &['\u{0031}', '\u{0039}', '\u{002E}']),
    (0x3289, &['\u{5341}']),
    (0x2fd1, &['\u{9F4A}']),
    (0xfb98, &['\u{06B3}']),
    (0x1d538, &['\u{0041}']),
    (0xfb58, &['\u{067E}']),
    (0x3197, &['\u{4E2D}']),
    (0xfc02, &['\u{064A}', '\u{0654}', '\u{0645}']),
    (0xff44, &['\u{0064}']),
    (0x1d678, &['\u{0049}']),
    (0x3254, &['\u{0032}', '\u{0034}']),
    (0xfd5c, &['\u{0633}', '\u{062D}', '\u{062C}']),
    (0x1d6cd, &['\u{03BC}']),
    (0x330c, &['\u{30AB}', '\u{30E9}', '\u{30C3}', '\u{30C8}']),
    (0x3307, &['\u{30A8}', '\u{30B9}', '\u{30AF}', '\u{30FC}', '\u{30C8}', '\u{3099}']),
    (0x1d7df, &['\u{0037}']),
    (0xfc43, &['\u{0644}', '\u{0649}']),
    (0x1d643, &['\u{0048}']),
    (0x3146, &['\u{110A}']),
    (0x1e9a, &['\u{0061}', '\u{02BE}']),
    (0xfb99, &['\u{06B3}']),
    (0xfd14, &['\u{0639}', '\u{064A}']),
    (0x1d4d1, &['\u{0042}']),
    (0xfc42, &['\u{0644}', '\u{0645}']),
    (0x1d50d, &['\u{004A}']),
    (0x2e9f, &['\u{6BCD}']),
    (0xfd8b, &['\u{0645}', '\u{062D}', '\u{064A}']),
    (0x3250, &['\u{0050}', '\u{0054}', '\u{0045}']),
    (0x1f251, &['\u{53EF}']),
    (0xfc33, &['\u{0642}', '\u{062D}']),
    (0x1ee27, &['\u{062D}']),
    (0x1d585, &['\u{005A}']),
    (0x209b, &['\u{0073}']),
    (0x319f, &['\u{4EBA}']),
    (0xff56, &['\u{0076}']),
    (0xfdb4, &['\u{0642}', '\u{0645}', '\u{062D}']),
    (0xfd31, &['\u{0633}', '\u{0647}']),
    (0x1f233, &['\u{7A7A}']),
    (0xfc2a, &['\u{0639}', '\u{0645}']),
    (0x1d7ce, &['\u{0030}']),
    (0xfc2f, &['\u{0641}', '\u{062E}']),
    (0x1d59d, &['\u{0078}']),
    (0x1d53b, &['\u{0044}']),
    (0x1d68f, &['\u{0066}']),
    (0x3181, &['\u{114C}']),
    (0xff39, &['\u{0059}']),
    (0x24ba, &['\u{0045}']),
    (0x3302, &['\u{30A2}', '\u{30F3}', '\u{30D8}', '\u{309A}', '\u{30A2}']),
    (0x210b, &['\u{0048}']),
    (0xfe3d, &['\u{300A}']),
    (0x1ee30, &['\u{0641}']),
    (0xff81, &['\u{30C1}']),
    (0xff5d, &['\u{007D}']),
    (0xf0c, &['\u{0F0B}']),
    (0x32ae, &['\u{8CC7}']),
    (0x2000, &['\u{0020}']),
    (0xfc81, &['\u{0643}', '\u{0644}']),
    (0xfb60, &['\u{067A}']),
    (0x3160, &['\u{1172}']),
    (0x1d79a, &['\u{039B}']),
    (0x32a2, &['\u{5199}']),
    (0x1d521, &['\u{0064}']),
    (0xffb4, &['\u{1121}']),
    (0x3362, &['\u{0031}', '\u{0030}', '\u{70B9}']),
    (0xfd3c, &['\u{0627}', '\u{064B}']),
    (0x332c, &['\u{30CF}', '\u{309A}', '\u{30FC}', '\u{30C4}']),
    (0x1f12b, &['\u{0043}']),
    (0x33fe, &['\u{0033}', '\u{0031}', '\u{65E5}']),
    (0x2034, &['\u{2032}', '\u{2032}', '\u{2032}']),
    (0xfba2, &['\u{06BB}']),
    (0x1d631, &['\u{0070}']),
    (0x33f7, &['\u{0032}', '\u{0034}', '\u{65E5}']),
    (0xfd2c, &['\u{0636}', '\u{0631}']),
    (0x1d5f4, &['\u{0067}']),
    (0xff76, &['\u{30AB}']),
    (0xfc22, &['\u{0636}', '\u{062C}']),
    (0x1f12d, &['\u{0043}', '\u{0044}']),
    (0x2f64, &['\u{7528}']),
    (0x1d6e6, &['\u{0395}']),
    (0x313f, &['\u{11B5}']),
    (0x1d742, &['\u{03BD}']),
    (0x1d6ae, &['\u{0397}']),
    (0x3000, &['\u{0020}']),
    (0x1f22d, &['\u{4E2D}']),
    (0x1d427, &['\u{006E}']),
    (0x3311, &['\u{30AD}', '\u{3099}', '\u{30CB}', '\u{30FC}']),
    (0xfc97, &['\u{064A}', '\u{0654}', '\u{062C}']),
    (0x24e7, &['\u{0078}']),
    (0x2100, &['\u{0061}', '\u{002F}', '\u{0063}']),
    (0x3369, &['\u{0031}', '\u{0037}', '\u{70B9}']),
    (0x1d42, &['\u{0057}']),
    (0x1ee13, &['\u{0631}']),
    (0x1d437, &['\u{0044}']),
    (0xfc73, &['\u{062A}', '\u{0646}']),
    (0xfc16, &['\u{062C}', '\u{0645}']),
    (0xfd62, &['\u{0633}', '\u{0645}', '\u{0645}']),
    (0x1d4cf, &['\u{007A}']),
    (0xfd64, &['\u{0635}', '\u{062D}', '\u{062D}']),
    (0x2f89, &['\u{826E}']),
    (0x1d6be, &['\u{03A7}']),
    (0xfb93, &['\u{06AF}']),
    (0xfd17, &['\u{0633}', '\u{0649}']),
    (0x333a, &['\u{30D8}', '\u{309A}', '\u{30F3}', '\u{30B9}']),
    (0xfd5e, &['\u{0633}', '\u{062C}', '\u{0649}']),
    (0xff73, &['\u{30A6}']),
    (0x2f0d, &['\u{5196}']),
    (0x3212, &['\u{0028}', '\u{1106}', '\u{1161}', '\u{0029}']),
    (0x32c0, &['\u{0031}', '\u{6708}']),
    (0x215f, &['\u{0031}', '\u{2044}']),
    (0x2f62, &['\u{7518}']),
    (0xfc04, &['\u{064A}', '\u{0654}', '\u{064A}']),
    (0xfb57, &['\u{067E}']),
    (0x1f215, &['\u{591A}']),
    (0x1f101, &['\u{0030}', '\u{002C}']),
    (0x329b, &['\u{5973}']),
    (0x1d465, &['\u{0078}']),
    (0xff06, &['\u{0026}']),
    (0xff3f, &['\u{005F}']),
    (0x1d634, &['\u{0073}']),
    (0x3242, &['\u{0028}', '\u{81EA}', '\u{0029}']),
    (0xfe14, &['\u{003B}']),
    (0x1f21e, &['\u{518D}']),
    (0xfc59, &['\u{064A}', '\u{0649}']),
    (0xfe43, &['\u{300E}']),
    (0x1d57, &['\u{0074}']),
    (0x1d7d1, &['\u{0033}']),
    (0x1d744, &['\u{03BF}']),
    (0xfb86, &['\u{068E}']),
    (0x1d4da, &['\u{004B}']),
    (0xfb06, &['\u{0073}', '\u{0074}']),
    (0x1d661, &['\u{006C}']),
    (0x1eeb2, &['\u{0642}']),
    (0x2f49, &['\u{6708}']),
    (0xfcfb, &['\u{0633}', '\u{0649}']),
    (0xfd51, &['\u{062A}', '\u{062D}', '\u{062C}']),
    (0xfb8f, &['\u{06A9}']),
    (0x24be, &['\u{0049}']),
    (0x1d4cc, &['\u{0077}']),
    (0xfdc5, &['\u{0635}', '\u{0645}', '\u{0645}']),
    (0x1d638, &['\u{0077}']),
    (0x2b4, &['\u{0279}']),
    (0x33ae, &['\u{0072}', '\u{0061}', '\u{0064}', '\u{2215}', '\u{0073}']),
    (0xfdf7, &['\u{0639}', '\u{0644}', '\u{064A}', '\u{0647}']),
    (0x1d5fe, &['\u{0071}']),
    (0x337b, &['\u{5E73}', '\u{6210}']),
    (0x1ee0c, &['\u{0645}']),
    (0xfb29, &['\u{002B}']),
    (0xff0b, &['\u{002B}']),
    (0x1d707, &['\u{03BC}']),
    (0x1d623, &['\u{0062}']),
    (0x322b, &['\u{0028}', '\u{706B}', '\u{0029}']),
    (0x32d9, &['\u{30B3}']),
    (0xfca2, &['\u{062A}', '\u{062D}']),
    (0x1d77f, &['\u{03C0}']),
    (0x1d550, &['\u{0059}']),
    (0xfcf0, &['\u{064A}', '\u{0645}']),
    (0xfb80, &['\u{0687}']),
    (0x1d6b8, &['\u{03A1}']),
    (0x3d3, &['\u{03A5}', '\u{0301}']),
    (0xb3, &['\u{0033}']),
    (0x2482, &['\u{0028}', '\u{0031}', '\u{0035}', '\u{0029}']),
    (0x2f69, &['\u{767D}']),
    (0x2176, &['\u{0076}', '\u{0069}', '\u{0069}']),
    (0xffc2, &['\u{1161}']),
    (0xb2, &['\u{0032}']),
    (0x1d693, &['\u{006A}']),
    (0xfc98, &['\u{064A}', '\u{0654}', '\u{062D}']),
    (0x2f55, &['\u{706B}']),
    (0x2fa1, &['\u{8FB5}']),
    (0x1d38, &['\u{004C}']),
    (0xffa3, &['\u{11AA}']),
    (0x1d436, &['\u{0043}']),
    (0xfd83, &['\u{0644}', '\u{062C}', '\u{062C}']),
    (0xfc34, &['\u{0642}', '\u{0645}']),
    (0xfc95, &['\u{064A}', '\u{0649}']),
    (0x1d78f, &['\u{03C0}']),
    (0x1d588, &['\u{0063}']),
    (0xfcec, &['\u{0643}', '\u{0645}']),
    (0x332a, &['\u{30CF}', '\u{30A4}', '\u{30C4}']),
    (0x1d4ed, &['\u{0064}']),
    (0x32fe, &['\u{30F2}']),
    (0x2230, &['\u{222E}', '\u{222E}', '\u{222E}']),
    (0x336e, &['\u{0032}', '\u{0032}', '\u{70B9}']),
    (0x3177, &['\u{1129}']),
    (0x335e, &['\u{0036}', '\u{70B9}']),
    (0xfeed, &['\u{0648}']),
    (0x1d5db, &['\u{0048}']),
    (0x1f12a, &['\u{3014}', '\u{0053}', '\u{3015}']),
    (0x1d72e, &['\u{03A3}']),
    (0x248c, &['\u{0035}', '\u{002E}']),
    (0xff6b, &['\u{30A9}']),
    (0xfef1, &['\u{064A}']),
    (0x3f9, &['\u{03A3}']),
    (0xfedd, &['\u{0644}']),
    (0x24b6, &['\u{0041}']),
    (0x32c3, &['\u{0034}', '\u{6708}']),
    (0x1d79d, &['\u{039E}']),
    (0x1d7d4, &['\u{0036}']),
    (0xff61, &['\u{3002}']),
    (0x1d6f4, &['\u{03A3}']),
    (0x337d, &['\u{5927}', '\u{6B63}']),
    (0xfd04, &['\u{062E}', '\u{064A}']),
    (0xfe57, &['\u{0021}']),
    (0x33c4, &['\u{0063}', '\u{0063}']),
    (0x216b, &['\u{0058}', '\u{0049}', '\u{0049}']),
    (0x3389, &['\u{006B}', '\u{0063}', '\u{0061}', '\u{006C}']),
    (0x1d53c, &['\u{0045}']),
    (0x1d73b, &['\u{03B6}']),
    (0x1eea1, &['\u{0628}']),
    (0x1d4e5, &['\u{0056}']),
    (0x3219, &['\u{0028}', '\u{1110}', '\u{1161}', '\u{0029}']),
    (0x1d4cd, &['\u{0078}']),
    (0x2f08, &['\u{4EBA}']),
    (0x2136, &['\u{05D1}']),
    (0xff2b, &['\u{004B}']),
    (0xff90, &['\u{30DF}']),
    (0x1db1, &['\u{0275}']),
    (0x1eea6, &['\u{0632}']),
    (0x32ed, &['\u{30DB}']),
    (0xf77, &['\u{0FB2}', '\u{0F71}', '\u{0F80}']),
    (0x1d72f, &['\u{03A4}']),
    (0x2e4, &['\u{0295}']),
    (0x33ab, &['\u{004D}', '\u{0050}', '\u{0061}']),
    (0xfef0, &['\u{0649}']),
    (0x1f134, &['\u{0045}']),
    (0xfdbd, &['\u{0646}', '\u{062C}', '\u{062D}']),
    (0x1d6bd, &['\u{03A6}']),
    (0x316c, &['\u{11D7}']),
    (0x1d6cc, &['\u{03BB}']),
    (0x32fd, &['\u{30F1}']),
    (0x1d509, &['\u{0046}']),
    (0x24a3, &['\u{0028}', '\u{0068}', '\u{0029}']),
    (0x33ac, &['\u{0047}', '\u{0050}', '\u{0061}']),
    (0xfc86, &['\u{0644}', '\u{0649}']),
    (0x2fc6, &['\u{9EA5}']),
    (0x2084, &['\u{0034}']),
    (0x1d44a, &['\u{0057}']),
    (0x1d756, &['\u{0391}']),
    (0xfc5c, &['\u{0631}', '\u{0670}']),
    (0x318c, &['\u{1194}']),
    (0xfe7c, &['\u{0020}', '\u{0651}']),
    (0xfc41, &['\u{0644}', '\u{062E}']),
    (0x1d609, &['\u{0042}']),
    (0x2f73, &['\u{7A74}']),
    (0x1eeb9, &['\u{0636}']),
    (0x3349, &['\u{30DF}', '\u{30EA}']),
    (0x1ca, &['\u{004E}', '\u{004A}']),
    (0xfd9d, &['\u{064A}', '\u{0645}', '\u{0645}']),
    (0xfba8, &['\u{06C1}']),
    (0x1d6a2, &['\u{0079}']),
    (0x3381, &['\u{006E}', '\u{0041}']),
    (0xfe79, &['\u{0640}', '\u{064F}']),
    (0x1d4ca, &['\u{0075}']),
    (0x1f218, &['\u{4EA4}']),
    (0x1d627, &['\u{0066}']),
    (0x1d7d2, &['\u{0034}']),
    (0x1d592, &['\u{006D}']),
    (0x1d682, &['\u{0053}']),
    (0x1d526, &['\u{0069}']),
    (0xfb5d, &['\u{0680}']),
    (0x32b0, &['\u{591C}']),
    (0x1d575, &['\u{004A}']),
    (0xfb6f, &['\u{06A6}']),
    (0x24dd, &['\u{006E}']),
    (0xfd1a, &['\u{0634}', '\u{064A}']),
    (0xff9d, &['\u{30F3}']),
    (0x1d5b2, &['\u{0053}']),
    (0x1f10a, &['\u{0039}', '\u{002C}']),
    (0x1f21f, &['\u{65B0}']),
    (0x1d794, &['\u{0395}']),
    (0xfdb3, &['\u{0646}', '\u{062D}', '\u{064A}']),
    (0xfb83, &['\u{068D}']),
    (0x3321, &['\u{30B7}', '\u{30EA}', '\u{30F3}', '\u{30AF}', '\u{3099}']),
    (0xff10, &['\u{0030}']),
    (0x1d60e, &['\u{0047}']),
    (0xfbad, &['\u{06BE}']),
    (0x1ee92, &['\u{0642}']),
    (0xfd8f, &['\u{0645}', '\u{062E}', '\u{0645}']),
    (0x2f4a, &['\u{6728}']),
    (0xfcd8, &['\u{0647}', '\u{0645}']),
    (0x1d647, &['\u{004C}']),
    (0x2f40, &['\u{652F}']),
    (0x1d64b, &['\u{0050}']),
    (0xfbef, &['\u{064A}', '\u{0654}', '\u{0648}']),
    (0x1dbf, &['\u{03B8}']),
    (0x33a6, &['\u{006B}', '\u{006D}', '\u{0033}']),
    (0x1d759, &['\u{0394}']),
    (0x1d76d, &['\u{03A8}']),
    (0x33c1, &['\u{004D}', '\u{03A9}']),
    (0xff28, &['\u{0048}']),
    (0xfbe8, &['\u{0649}']),
    (0xfea1, &['\u{062D}']),
    (0x1d4e4, &['\u{0055}']),
    (0x2f41, &['\u{6534}']),
    (0x3300, &['\u{30A2}', '\u{30CF}', '\u{309A}', '\u{30FC}', '\u{30C8}']),
    (0xfe3e, &['\u{300B}']),
    (0x1d539, &['\u{0042}']),
    (0x2f72, &['\u{79BE}']),
    (0x1d67, &['\u{03B3}']),
    (0x1d51e, &['\u{0061}']),
    (0x24a0, &['\u{0028}', '\u{0065}', '\u{0029}']),
    (0xfb56, &['\u{067E}']),
    (0x24bd, &['\u{0048}']),
    (0x1d3a, &['\u{004E}']),
    (0x1d559, &['\u{0068}']),
    (0x1ee16, &['\u{062B}']),
    (0x3296, &['\u{8CA1}']),
    (0xfc9c, &['\u{0628}', '\u{062C}']),
    (0xfe7d, &['\u{0640}', '\u{0651}']),
    (0x3291, &['\u{682A}']),
    (0x1d4a, &['\u{0259}']),
    (0x24d3, &['\u{0064}']),
    (0xffcd, &['\u{116A}']),
    (0x1ee67, &['\u{062D}']),
    (0x1ee7c, &['\u{066E}']),
    (0x1d7b7, &['\u{03BE}']),
    (0x1d72a, &['\u{039F}']),
    (0x1d50f, &['\u{004C}']),
    (0x2003, &['\u{0020}']),
    (0x2090, &['\u{0061}']),
    (0x1f118, &['\u{0028}', '\u{0049}', '\u{0029}']),
    (0xfd5f, &['\u{0633}', '\u{0645}', '\u{062D}']),
    (0x2189, &['\u{0030}', '\u{2044}', '\u{0033}']),
    (0x1d5bd, &['\u{0064}']),
    (0xfbf1, &['\u{064A}', '\u{0654}', '\u{06C7}']),
    (0x1d656, &['\u{0061}']),
    (0x2464, &['\u{0035}']),
    (0x1d461, &['\u{0074}']),
    (0xfb5c, &['\u{0680}']),
    (0xfe47, &['\u{005B}']),
    (0x329a, &['\u{7537}']),
    (0x1ee42, &['\u{062C}']),
    (0x1d6f9, &['\u{03A8}']),
    (0xfe19, &['\u{002E}', '\u{002E}', '\u{002E}']),
    (0x1f190, &['\u{0044}', '\u{004A}']),
    (0xfb75, &['\u{0684}']),
    (0x3361, &['\u{0039}', '\u{70B9}']),
    (0xfc23, &['\u{0636}', '\u{062D}']),
    (0xfb51, &['\u{0671}']),
    (0x33fd, &['\u{0033}', '\u{0030}', '\u{65E5}']),
    (0xff58, &['\u{0078}']),
    (0x1d7f8, &['\u{0032}']),
    (0x2f44, &['\u{65A4}']),
    (0x1d404, &['\u{0045}']),
    (0x2081, &['\u{0031}']),
    (0xfe9d, &['\u{062C}']),
    (0xf79, &['\u{0FB3}', '\u{0F71}', '\u{0F80}']),
    (0x1d70e, &['\u{03C3}']),
    (0x316a, &['\u{11CE}']),
    (0x1d52, &['\u{006F}']),
    (0x1d6b4, &['\u{039D}']),
    (0xff4f, &['\u{006F}']),
    (0x32ef, &['\u{30DF}']),
    (0x3213, &['\u{0028}', '\u{1107}', '\u{1161}', '\u{0029}']),
    (0xfb14, &['\u{0574}', '\u{0565}']),
    (0x329c, &['\u{9069}']),
    (0x1f137, &['\u{0048}']),
    (0xfc12, &['\u{062B}', '\u{0645}']),
    (0x2e3, &['\u{0078}']),
    (0x1d675, &['\u{0046}']),
    (0x209c, &['\u{0074}']),
    (0x3354, &['\u{30EB}', '\u{30FC}', '\u{30D5}', '\u{3099}', '\u{30EB}']),
    (0x211a, &['\u{0051}']),
    (0x1ee5f, &['\u{066F}']),
    (0xff63, &['\u{300D}']),
    (0x339c, &['\u{006D}', '\u{006D}']),
    (0xfb7b, &['\u{0686}']),
    (0x3318, &['\u{30AF}', '\u{3099}', '\u{30E9}', '\u{30E0}']),
    (0x24cd, &['\u{0058}']),
    (0x2da, &['\u{0020}', '\u{030A}']),
    (0x1d69a, &['\u{0071}']),
    (0x2476, &['\u{0028}', '\u{0033}', '\u{0029}']),
    (0x2f3f, &['\u{624B}']),
    (0x1ee09, &['\u{064A}']),
    (0xfb62, &['\u{067F}']),
    (0x335a, &['\u{0032}', '\u{70B9}']),
    (0x1d7fc, &['\u{0036}']),
    (0xffa2, &['\u{1101}']),
    (0x1ffd, &['\u{0020}', '\u{0301}']),
    (0x1d581, &['\u{0056}']),
    (0x32da, &['\u{30B5}']),
    (0xfd9b, &['\u{0646}', '\u{0645}', '\u{0649}']),
    (0x2f52, &['\u{6C0F}']),
    (0x33eb, &['\u{0031}', '\u{0032}', '\u{65E5}']),
    (0x1d4b2, &['\u{0057}']),
    (0x1ee11, &['\u{0635}']),
    (0x326a, &['\u{110F}']),
    (0x1d61e, &['\u{0057}']),
    (0xfc1a, &['\u{062E}', '\u{062D}']),
    (0xfd86, &['\u{0644}', '\u{062E}', '\u{0645}']),
    (0x1d714, &['\u{03C9}']),
    (0x2fa5, &['\u{91CC}']),
    (0xfb24, &['\u{05DB}']),
    (0x1ee9b, &['\u{063A}']),
    (0x1d3c, &['\u{004F}']),
    (0x2089, &['\u{0039}']),
    (0xfc91, &['\u{064A}', '\u{0631}']),
    (0xfbd8, &['\u{06C7}']),
    (0xfecb, &['\u{0639}']),
    (0xfe52, &['\u{002E}']),
    (0x1d660, &['\u{006B}']),
    (0x1d6d4, &['\u{03C3}']),
    (0x2005, &['\u{0020}']),
    (0xff62, &['\u{300C}']),
    (0xfe74, &['\u{0020}', '\u{064D}']),
    (0x1d74e, &['\u{03C9}']),
    (0x1d5e9, &['\u{0056}']),
    (0x2f50, &['\u{6BD4}']),
    (0x2f35, &['\u{5EF4}']),
    (0xfb9c, &['\u{06B1}']),
    (0x1f11f, &['\u{0028}', '\u{0050}', '\u{0029}']),
    (0x1d5e4, &['\u{0051}']),
    (0x246a, &['\u{0031}', '\u{0031}']),
    (0x1d45b, &['\u{006E}']),
    (0xfc0c, &['\u{062A}', '\u{062D}']),
    (0x1f22f, &['\u{6307}']),
    (0x3243, &['\u{0028}', '\u{81F3}', '\u{0029}']),
    (0x3228, &['\u{0028}', '\u{4E5D}', '\u{0029}']),
    (0x337c, &['\u{662D}', '\u{548C}']),
    (0x32c1, &['\u{0032}', '\u{6708}']),
    (0x33af, &['\u{0072}', '\u{0061}', '\u{0064}', '\u{2215}', '\u{0073}', '\u{0032}']),
    (0xff64, &['\u{3001}']),
    (0x1daf, &['\u{0273}']),
    (0x1d750, &['\u{03B5}']),
    (0xff31, &['\u{0051}']),
    (0x1d4bd, &['\u{0068}']),
    (0xfb89, &['\u{0688}']),
    (0x1d5a, &['\u{026F}']),
    (0xffa5, &['\u{11AC}']),
    (0x33d1, &['\u{006C}', '\u{006E}']),
    (0x207e, &['\u{0029}']),
    (0x1db3, &['\u{0282}']),
    (0x24bc, &['\u{0047}']),
    (0x2fbb, &['\u{9AA8}']),
    (0x1d5a7, &['\u{0048}']),
    (0x3036, &['\u{3012}']),
    (0xfd97, &['\u{0646}', '\u{062C}', '\u{0645}']),
    (0xfc11, &['\u{062B}', '\u{062C}']),
    (0x1dad, &['\u{0270}']),
    (0xfbd3, &['\u{06AD}']),
    (0x1d54f, &['\u{0058}']),
    (0xfd0f, &['\u{0635}', '\u{0631}']),
    (0x1f146, &['\u{0057}']),
    (0x33a8, &['\u{006D}', '\u{2215}', '\u{0073}', '\u{0032}']),
    (0x319c, &['\u{4E01}']),
    (0x2f82, &['\u{81E3}']),
    (0x1f144, &['\u{0055}']),
    (0xfe82, &['\u{0627}', '\u{0653}']),
    (0x1d527, &['\u{006A}']),
    (0x1d6ad, &['\u{0396}']),
    (0x2f8e, &['\u{8840}']),
    (0xfd68, &['\u{0634}', '\u{062D}', '\u{0645}']),
    (0x1d435, &['\u{0042}']),
    (0xfc40, &['\u{0644}', '\u{062D}']),
    (0x339b, &['\u{03BC}', '\u{006D}']),
    (0x2112, &['\u{004C}']),
    (0xfc76, &['\u{062B}', '\u{0631}']),
    (0xfcbe, &['\u{0641}', '\u{062C}']),
    (0x3342, &['\u{30DB}', '\u{30FC}', '\u{30F3}']),
    (0x1d6e1, &['\u{03C0}']),
    (0x1d72b, &['\u{03A0}']),
    (0x2f46, &['\u{65E0}']),
    (0x1d41, &['\u{0055}']),
    (0xfd03, &['\u{062E}', '\u{0649}']),
    (0xfec7, &['\u{0638}']),
    (0x1d67e, &['\u{004F}']),
    (0x1d75e, &['\u{0399}']),
    (0x1d522, &['\u{0065}']),
    (0xfdc6, &['\u{0633}', '\u{062E}', '\u{064A}']),
    (0x3143, &['\u{1108}']),
    (0xffd4, &['\u{116F}']),
    (0x32dd, &['\u{30BB}']),
    (0x2137, &['\u{05D2}']),
    (0xfca6, &['\u{062B}', '\u{0645}']),
    (0xfd69, &['\u{0634}', '\u{062C}', '\u{064A}']),
    (0x2166, &['\u{0056}', '\u{0049}', '\u{0049}']),
    (0xfbd9, &['\u{06C6}']),
    (0x2fa9, &['\u{961C}']),
    (0x3206, &['\u{0028}', '\u{1109}', '\u{0029}']),
    (0xfbe2, &['\u{06C9}']),
    (0x1d676, &['\u{0047}']),
    (0x1d5bb, &['\u{0062}']),
    (0xfd74, &['\u{0637}', '\u{0645}', '\u{064A}']),
    (0x2151, &['\u{0031}', '\u{2044}', '\u{0039}']),
    (0xffe8, &['\u{2502}']),
    (0x1e9b, &['\u{0073}', '\u{0307}']),
    (0x3269, &['\u{110E}']),
    (0xfc9e, &['\u{0628}', '\u{062E}']),
    (0x1d4e6, &['\u{0057}']),
    (0x1d6c1, &['\u{2207}']),
    (0x1eea5, &['\u{0648}']),
    (0x1d6c6, &['\u{03B5}']),
    (0x3d4, &['\u{03A5}', '\u{0308}']),
    (0xfc82, &['\u{0643}', '\u{0645}']),
    (0x1ee98, &['\u{0630}']),
    (0xfcf9, &['\u{063A}', '\u{0649}']),
    (0x3313, &['\u{30AD}', '\u{3099}', '\u{30EB}', '\u{30BF}', '\u{3099}', '\u{30FC}']),
    (0x1d4c7, &['\u{0072}']),
    (0xff20, &['\u{0040}']),
    (0x32de, &['\u{30BD}']),
    (0xfd32, &['\u{0634}', '\u{0647}']),
    (0x1da1, &['\u{025F}']),
    (0xfe66, &['\u{003D}']),
    (0xab5c, &['\u{A727}']),
    (0xfd0e, &['\u{0633}', '\u{0631}']),
    (0x1d48b, &['\u{006A}']),
    (0x24b2, &['\u{0028}', '\u{0077}', '\u{0029}']),
    (0xfe5f, &['\u{0023}']),
    (0xff6f, &['\u{30C3}']),
    (0x1d741, &['\u{03BC}']),
    (0x32a7, &['\u{5DE6}']),
    (0x1d4a2, &['\u{0047}']),
    (0x203e, &['\u{0020}', '\u{0305}']),
    (0x1d598, &['\u{0073}']),
    (0x323c, &['\u{0028}', '\u{76E3}', '\u{0029}']),
    (0x247a, &['\u{0028}', '\u{0037}', '\u{0029}']),
    (0x1ee8c, &['\u{0645}']),
    (0xfb50, &['\u{0671}']),
    (0x2fd4, &['\u{9F9C}']),
    (0x1d71a, &['\u{03C1}']),
    (0x1d402, &['\u{0043}']),
    (0x1d6a1, &['\u{0078}']),
    (0x3166, &['\u{1115}']),
    (0x1d2c, &['\u{0041}']),
    (0x1d7b8, &['\u{03BF}']),
    (0x1d42d, &['\u{0074}']),
    (0x2168, &['\u{0049}', '\u{0058}']),
    (0x1d4ff, &['\u{0076}']),
    (0x320e, &['\u{0028}', '\u{1100}', '\u{1161}', '\u{0029}']),
    (0xfc67, &['\u{064A}', '\u{0654}', '\u{0646}']),
    (0xfeb7, &['\u{0634}']),
    (0xff34, &['\u{0054}']),
    (0xfc05, &['\u{0628}', '\u{062C}']),
    (0x3f0, &['\u{03BA}']),
    (0x32be, &['\u{0034}', '\u{0039}']),
    (0x1d444, &['\u{0051}']),
    (0x33a7, &['\u{006D}', '\u{2215}', '\u{0073}']),
    (0x32cc, &['\u{0048}', '\u{0067}']),
    (0x332e, &['\u{30D2}', '\u{309A}', '\u{30A2}', '\u{30B9}', '\u{30C8}', '\u{30EB}']),
    (0xff5f, &['\u{2985}']),
    (0x2174, &['\u{0076}']),
    (0x1ee97, &['\u{062E}']),
    (0x2fbf, &['\u{9B2F}']),
    (0x3169, &['\u{11CC}']),
    (0x326e, &['\u{1100}', '\u{1161}']),
    (0xfb69, &['\u{0679}']),
    (0x1ee0d, &['\u{0646}']),
    (0x2f33, &['\u{5E7A}']),
    (0x13f, &['\u{004C}', '\u{00B7}']),
    (0x1fce, &['\u{0020}', '\u{0313}', '\u{0301}']),
    (0x3163, &['\u{1175}']),
    (0xff4a, &['\u{006A}']),
    (0xff72, &['\u{30A4}']),
    (0xff0e, &['\u{002E}']),
    (0xfda2, &['\u{062A}', '\u{062E}', '\u{0649}']),
    (0xff94, &['\u{30E4}']),
    (0x1d7f0, &['\u{0034}']),
    (0x3331, &['\u{30D2}', '\u{3099}', '\u{30EB}']),
    (0x1d709, &['\u{03BE}']),
    (0x2101, &['\u{0061}', '\u{002F}', '\u{0073}']),
    (0x1ee1a, &['\u{0638}']),
    (0x1ee77, &['\u{062E}']),
    (0xfc0d, &['\u{062A}', '\u{062E}']),
    (0xfcce, &['\u{0645}', '\u{062C}']),
    (0x1d6a5, &['\u{0237}']),
    (0x33c2, &['\u{0061}', '\u{002E}', '\u{006D}', '\u{002E}']),
    (0xfd01, &['\u{062C}', '\u{0649}']),
    (0x1d56f, &['\u{0044}']),
    (0x2008, &['\u{0020}']),
    (0xfc78, &['\u{062B}', '\u{0645}']),
    (0x3227, &['\u{0028}', '\u{516B}', '\u{0029}']),
    (0x1d447, &['\u{0054}']),
    (0x3223, &['\u{0028}', '\u{56DB}', '\u{0029}']),
    (0x249d, &['\u{0028}', '\u{0062}', '\u{0029}']),
    (0x1d5fc, &['\u{006F}']),
    (0x1d50a, &['\u{0047}']),
    (0x3397, &['\u{0064}', '\u{006C}']),
    (0x1d719, &['\u{03C6}']),
    (0xfd30, &['\u{0634}', '\u{0645}']),
    (0x3319, &['\u{30AF}', '\u{3099}', '\u{30E9}', '\u{30E0}', '\u{30C8}', '\u{30F3}']),
    (0xfc9d, &['\u{0628}', '\u{062D}']),
    (0xfc3e, &['\u{0643}', '\u{064A}']),
    (0x1d783, &['\u{03C4}']),
    (0x1d491, &['\u{0070}']),
    (0x3172, &['\u{111E}']),
    (0xfbfe, &['\u{06CC}']),
    (0x1d4dc, &['\u{004D}']),
    (0x1d646, &['\u{004B}']),
    (0x1d5d6, &['\u{0043}']),
    (0x33dd, &['\u{0057}', '\u{0062}']),
    (0x1d540, &['\u{0049}']),
    (0xfce6, &['\u{062B}', '\u{0647}']),
    (0x1d5dc, &['\u{0049}']),
    (0xfcde, &['\u{064A}', '\u{0647}']),
    (0x2082, &['\u{0032}']),
    (0x1d5c0, &['\u{0067}']),
    (0x3152, &['\u{1164}']),
    (0x1d5b4, &['\u{0055}']),
    (0xfc38, &['\u{0643}', '\u{062C}']),
    (0x1d789, &['\u{2202}']),
    (0x1d441, &['\u{004E}']),
    (0x2f6e, &['\u{77E2}']),
    (0x2f45, &['\u{65B9}']),
    (0x1d4ef, &['\u{0066}']),
    (0x1f239, &['\u{5272}']),
    (0x326b, &['\u{1110}']),
    (0x1d699, &['\u{0070}']),
    (0x2f32, &['\u{5E72}']),
    (0x1f130, &['\u{0041}']),
    (0x335d, &['\u{0035}', '\u{70B9}']),
    (0xab5f, &['\u{AB52}']),
    (0x24e5, &['\u{0076}']),
    (0x1d6fe, &['\u{03B3}']),
    (0xfb17, &['\u{0574}', '\u{056D}']),
    (0x1d586, &['\u{0061}']),
    (0x1d62, &['\u{0069}']),
    (0xfe90, &['\u{0628}']),
    (0x1d787, &['\u{03C8}']),
    (0x33f0, &['\u{0031}', '\u{0037}', '\u{65E5}']),
    (0x2138, &['\u{05D3}']),
    (0xfc20, &['\u{0635}', '\u{062D}']),
    (0x3298, &['\u{52B4}']),
    (0xfd24, &['\u{0636}', '\u{064A}']),
    (0xab5d, &['\u{AB37}']),
    (0x1ee9a, &['\u{0638}']),
    (0xfc53, &['\u{0647}', '\u{0649}']),
    (0x1d76e, &['\u{03A9}']),
    (0xfe50, &['\u{002C}']),
    (0xff9f, &['\u{309A}']),
    (0x1d482, &['\u{0061}']),
    (0x2102, &['\u{0043}']),
    (0xff2f, &['\u{004F}']),
    (0xfc1d, &['\u{0633}', '\u{062D}']),
    (0xfe54, &['\u{003B}']),
    (0x3286, &['\u{4E03}']),
    (0xfc0f, &['\u{062A}', '\u{0649}']),
    (0x333c, &['\u{30D8}', '\u{3099}', '\u{30FC}', '\u{30BF}']),
    (0xfc55, &['\u{064A}', '\u{062C}']),
    (0x1d4a6, &['\u{004B}']),
    (0x217a, &['\u{0078}', '\u{0069}']),
    (0x3353, &['\u{30EB}', '\u{30D2}', '\u{309A}', '\u{30FC}']),
    (0x1cb, &['\u{004E}', '\u{006A}']),
    (0x331b, &['\u{30AF}', '\u{30ED}', '\u{30FC}', '\u{30CD}']),
    (0x3240, &['\u{0028}', '\u{796D}', '\u{0029}']),
    (0x1d473, &['\u{004C}']),
    (0xfd88, &['\u{0644}', '\u{0645}', '\u{062D}']),
    (0x1d456, &['\u{0069}']),
    (0x1d593, &['\u{006E}']),
    (0x1d785, &['\u{03C6}']),
    (0x1d4c2, &['\u{006D}']),
    (0x1d6ab, &['\u{0394}']),
    (0xfdf8, &['\u{0648}', '\u{0633}', '\u{0644}', '\u{0645}']),
    (0xff02, &['\u{0022}']),
    (0x3229, &['\u{0028}', '\u{5341}', '\u{0029}']),
    (0xfba4, &['\u{06D5}', '\u{0654}']),
    (0xfbed, &['\u{064A}', '\u{0654}', '\u{06D5}']),
    (0xfe7e, &['\u{0020}', '\u{0652}']),
    (0xfbf7, &['\u{064A}', '\u{0654}', '\u{06D0}']),
    (0x215a, &['\u{0035}', '\u{2044}', '\u{0036}']),
    (0x3167, &['\u{11C7}']),
    (0xfb9e, &['\u{06BA}']),
    (0xfecc, &['\u{0639}']),
    (0xfc61, &['\u{0020}', '\u{064F}', '\u{0651}']),
    (0x1d700, &['\u{03B5}']),
    (0x1d4fe, &['\u{0075}']),
    (0x1d459, &['\u{006C}']),
    (0x1d6e5, &['\u{0394}']),
    (0xfba3, &['\u{06BB}']),
    (0xfc46, &['\u{0645}', '\u{062D}']),
    (0x334b, &['\u{30E1}', '\u{30AB}', '\u{3099}']),
    (0x1d499, &['\u{0078}']),
    (0xfb81, &['\u{0687}']),
    (0x1d7e3, &['\u{0031}']),
    (0x1d5c, &['\u{1D25}']),
    (0x1d4b5, &['\u{005A}']),
    (0x1d45e, &['\u{0071}']),
    (0x1d55c, &['\u{006B}']),
    (0x24a2, &['\u{0028}', '\u{0067}', '\u{0029}']),
    (0x1f131, &['\u{0042}']),
    (0xfe9e, &['\u{062C}']),
    (0x1d4e3, &['\u{0054}']),
    (0xfbfc, &['\u{06CC}']),
    (0x1d479, &['\u{0052}']),
    (0x2dc, &['\u{0020}', '\u{0303}']),
    (0xfdf4, &['\u{0645}', '\u{062D}', '\u{0645}', '\u{062F}']),
    (0x1d412, &['\u{0053}']),
    (0xffcb, &['\u{1168}']),
    (0x3171, &['\u{111D}']),
    (0xfc8b, &['\u{0646}', '\u{0632}']),
    (0xfcf5, &['\u{0637}', '\u{0649}']),
    (0x2f79, &['\u{7F51}']),
    (0x323e, &['\u{0028}', '\u{8CC7}', '\u{0029}']),
    (0x246c, &['\u{0031}', '\u{0033}']),
    (0xfd76, &['\u{0639}', '\u{0645}', '\u{0645}']),
    (0x1d6c0, &['\u{03A9}']),
    (0x2fbd, &['\u{9ADF}']),
    (0x1d607, &['\u{007A}']),
    (0x2fae, &['\u{975E}']),
    (0xfd8e, &['\u{0645}', '\u{062E}', '\u{062C}']),
    (0x2f6d, &['\u{77DB}']),
    (0xfcb3, &['\u{0635}', '\u{0645}']),
    (0x33f3, &['\u{0032}', '\u{0030}', '\u{65E5}']),
    (0x1dab, &['\u{029F}']),
    (0xfcab, &['\u{062E}', '\u{062C}']),
    (0x1d32, &['\u{018E}']),
    (0x216f, &['\u{004D}']),
    (0xffb3, &['\u{1108}']),
    (0x1d613, &['\u{004C}']),
    (0x1d5ae, &['\u{004F}']),
    (0xfb8a, &['\u{0698}']),
    (0x1f14f, &['\u{0057}', '\u{0043}']),
    (0x3372, &['\u{0064}', '\u{0061}']),
    (0xfec5, &['\u{0638}']),
    (0x1d66a, &['\u{0075}']),
    (0x1d485, &['\u{0064}']),
    (0xfba6, &['\u{06C1}']),
    (0x2070, &['\u{0030}']),
    (0x2f7a, &['\u{7F8A}']),
    (0x2131, &['\u{0046}']),
    (0x1ee8d, &['\u{0646}']),
    (0x1f110, &['\u{0028}', '\u{0041}', '\u{0029}']),
    (0x2133, &['\u{004D}']),
    (0x3180, &['\u{1147}']),
    (0xfdb2, &['\u{0642}', '\u{0645}', '\u{064A}']),
    (0x2109, &['\u{00B0}', '\u{0046}']),
    (0x1d542, &['\u{004B}']),
    (0x2075, &['\u{0035}']),
    (0xfe59, &['\u{0028}']),
    (0xfd19, &['\u{0634}', '\u{0649}']),
    (0x1d75f, &['\u{039A}']),
    (0x24c2, &['\u{004D}']),
    (0x1d6ac, &['\u{0395}']),
    (0x2f43, &['\u{6597}']),
    (0xfd1d, &['\u{062C}', '\u{0649}']),
    (0xfc2d, &['\u{0641}', '\u{062C}']),
    (0x2f7c, &['\u{8001}']),
    (0xff3e, &['\u{005E}']),
    (0x1d776, &['\u{03B7}']),
    (0x1d9f, &['\u{025C}']),
    (0x1f237, &['\u{6708}']),
    (0x3256, &['\u{0032}', '\u{0036}']),
    (0x332d, &['\u{30CF}', '\u{3099}', '\u{30FC}', '\u{30EC}', '\u{30EB}']),
    (0x1d629, &['\u{0068}']),
    (0x1ee54, &['\u{0634}']),
    (0xff59, &['\u{0079}']),
    (0x1f12c, &['\u{0052}']),
    (0x1d519, &['\u{0056}']),
    (0x33b5, &['\u{006E}', '\u{0056}']),
    (0x3392, &['\u{004D}', '\u{0048}', '\u{007A}']),
    (0xffd2, &['\u{116D}']),
    (0x317d, &['\u{1132}']),
    (0xb5, &['\u{03BC}']),
    (0x1d557, &['\u{0066}']),
    (0xfc68, &['\u{064A}', '\u{0654}', '\u{0649}']),
    (0xfce1, &['\u{0628}', '\u{0645}']),
    (0x3174, &['\u{1122}']),
    (0x3217, &['\u{0028}', '\u{110E}', '\u{1161}', '\u{0029}']),
    (0xff55, &['\u{0075}']),
    (0xfeb2, &['\u{0633}']),
    (0x1d71e, &['\u{0393}']),
    (0xfdb1, &['\u{0645}', '\u{0645}', '\u{064A}']),
    (0x1d400, &['\u{0041}']),
    (0x1f244, &['\u{3014}', '\u{70B9}', '\u{3015}']),
    (0xfc0e, &['\u{062A}', '\u{0645}']),
    (0x32b4, &['\u{0033}', '\u{0039}']),
    (0xfb74, &['\u{0684}']),
    (0xfd18, &['\u{0633}', '\u{064A}']),
    (0xfe87, &['\u{0627}', '\u{0655}']),
    (0x1d5b0, &['\u{0051}']),
    (0x33e2, &['\u{0033}', '\u{65E5}']),
    (0xfd13, &['\u{0639}', '\u{0649}']),
    (0x1d685, &['\u{0056}']),
    (0x2087, &['\u{0037}']),
    (0xfbde, &['\u{06CB}']),
    (0x1d47, &['\u{0062}']),
    (0x309b, &['\u{0020}', '\u{3099}']),
    (0x1d690, &['\u{0067}']),
    (0x1d6c5, &['\u{03B4}']),
    (0xfef9, &['\u{0644}', '\u{0627}', '\u{0655}']),
    (0x2154, &['\u{0032}', '\u{2044}', '\u{0033}']),
    (0xfd54, &['\u{062A}', '\u{062E}', '\u{0645}']),
    (0x1d6ef, &['\u{039E}']),
    (0x316e, &['\u{111C}']),
    (0x1fee, &['\u{0020}', '\u{0308}', '\u{0301}']),
    (0x1d448, &['\u{0055}']),
    (0xfb26, &['\u{05DD}']),
    (0x1d68a, &['\u{0061}']),
    (0x24a9, &['\u{0028}', '\u{006E}', '\u{0029}']),
    (0x1d45d, &['\u{0070}']),
    (0x1d733, &['\u{03A8}']),
    (0x2f97, &['\u{8C55}']),
    (0x1f11e, &['\u{0028}', '\u{004F}', '\u{0029}']),
    (0x2f3b, &['\u{5F73}']),
    (0xfdaf, &['\u{064A}', '\u{062C}', '\u{064A}']),
    (0xfc8a, &['\u{0646}', '\u{0631}']),
    (0xffec, &['\u{2193}']),
    (0x1d62c, &['\u{006B}']),
    (0xfee6, &['\u{0646}']),
    (0xff93, &['\u{30E2}']),
    (0xfe10, &['\u{002C}']),
    (0x1d46, &['\u{1D02}']),
    (0xff8f, &['\u{30DE}']),
    (0x1d5a2, &['\u{0043}']),
    (0x1d583, &['\u{0058}']),
    (0x1d684, &['\u{0055}']),
    (0x1ee81, &['\u{0628}']),
    (0x17f, &['\u{0073}']),
    (0x37a, &['\u{0020}', '\u{0345}']),
    (0x2474, &['\u{0028}', '\u{0031}', '\u{0029}']),
    (0xff7f, &['\u{30BD}']),
    (0x1f133, &['\u{0044}']),
    (0x32a0, &['\u{9805}']),
    (0xfd63, &['\u{0633}', '\u{0645}', '\u{0645}']),
    (0x1d739, &['\u{03B4}']),
    (0x1d558, &['\u{0067}']),
    (0xfc6d, &['\u{0628}', '\u{0646}']),
    (0x1d667, &['\u{0072}']),
    (0x2f1c, &['\u{53C8}']),
    (0xfefa, &['\u{0644}', '\u{0627}', '\u{0655}']),
    (0x1ee5d, &['\u{06BA}']),
    (0x1f13d, &['\u{004E}']),
    (0x1d555, &['\u{0064}']),
    (0x3207, &['\u{0028}', '\u{110B}', '\u{0029}']),
    (0x1d7ca, &['\u{03DC}']),
    (0x1d6b1, &['\u{039A}']),
    (0x317e, &['\u{1136}']),
    (0xfe95, &['\u{062A}']),
    (0x1d438, &['\u{0045}']),
    (0x3195, &['\u{56DB}']),
    (0x1d727, &['\u{039C}']),
    (0x1d662, &['\u{006D}']),
    (0x325e, &['\u{0033}', '\u{0034}']),
    (0xfcd5, &['\u{0646}', '\u{0645}']),
    (0x1d677, &['\u{0048}']),
    (0x1d7db, &['\u{0033}']),
    (0x3134, &['\u{1102}']),
    (0x1d6fb, &['\u{2207}']),
    (0x212f, &['\u{0065}']),
    (0x3193, &['\u{4E8C}']),
    (0x1d780, &['\u{03C1}']),
    (0x2c7c, &['\u{006A}']),
    (0x1d59a, &['\u{0075}']),
    (0xfe4d, &['\u{005F}']),
    (0x24c3, &['\u{004E}']),
    (0x2026, &['\u{002E}', '\u{002E}', '\u{002E}']),
    (0x217d, &['\u{0063}']),
    (0x211c, &['\u{0052}']),
    (0x2f58, &['\u{723B}']),
    (0x1d40e, &['\u{004F}']),
    (0x1d76b, &['\u{03A6}']),
    (0xfd2f, &['\u{0634}', '\u{062E}']),
    (0x1d710, &['\u{03C5}']),
    (0xffa4, &['\u{1102}']),
    (0xfc1e, &['\u{0633}', '\u{062E}']),
    (0x24c5, &['\u{0050}']),
    (0x24cb, &['\u{0056}']),
    (0x3339, &['\u{30D8}', '\u{30EB}', '\u{30C4}']),
    (0x1d4eb, &['\u{0062}']),
    (0xfd77, &['\u{0639}', '\u{0645}', '\u{0645}']),
    (0xfc00, &['\u{064A}', '\u{0654}', '\u{062C}']),
    (0x3337, &['\u{30D8}', '\u{309A}', '\u{30BD}']),
    (0x248d, &['\u{0036}', '\u{002E}']),
    (0xfd65, &['\u{0635}', '\u{062D}', '\u{062D}']),
    (0x315e, &['\u{1170}']),
    (0x1d566, &['\u{0075}']),
    (0x2fcc, &['\u{9EFD}']),
    (0x1d4d5, &['\u{0046}']),
    (0x1d5a6, &['\u{0047}']),
    (0x3309, &['\u{30AA}', '\u{30F3}', '\u{30B9}']),
    (0x1d637, &['\u{0076}']),
    (0x24c1, &['\u{004C}']),
    (0xfc58, &['\u{064A}', '\u{0645}']),
    (0x1d57d, &['\u{0052}']),
    (0xfc37, &['\u{0643}', '\u{0627}']),
    (0xff0a, &['\u{002A}']),
    (0xfda3, &['\u{062A}', '\u{0645}', '\u{064A}']),
    (0xff68, &['\u{30A3}']),
    (0x1d432, &['\u{0079}']),
    (0xab5e, &['\u{026B}']),
    (0x2a0c, &['\u{222B}', '\u{222B}', '\u{222B}', '\u{222B}']),
    (0xfd2b, &['\u{0635}', '\u{0631}']),
    (0x2161, &['\u{0049}', '\u{0049}']),
    (0x3398, &['\u{006B}', '\u{006C}']),
    (0x2489, &['\u{0032}', '\u{002E}']),
    (0x333f, &['\u{30DB}', '\u{30F3}']),
    (0x24e6, &['\u{0077}']),
    (0x202f, &['\u{0020}']),
    (0xfcaa, &['\u{062D}', '\u{0645}']),
    (0x2139, &['\u{0069}']),
    (0x1d449, &['\u{0056}']),
    (0x3148, &['\u{110C}']),
    (0xfccf, &['\u{0645}', '\u{062D}']),
    (0x1d531, &['\u{0074}']),
    (0x33aa, &['\u{006B}', '\u{0050}', '\u{0061}']),
    (0xfd6d, &['\u{0634}', '\u{0645}', '\u{0645}']),
    (0x316d, &['\u{11D9}']),
    (0x1d53e, &['\u{0047}']),
    (0x3356, &['\u{30EC}', '\u{30F3}', '\u{30C8}', '\u{30B1}', '\u{3099}', '\u{30F3}']),
    (0x1d749, &['\u{03C4}']),
    (0xfb7e, &['\u{0687}']),
    (0x1d5d9, &['\u{0046}']),
    (0x2492, &['\u{0031}', '\u{0031}', '\u{002E}']),
    (0x2130, &['\u{0045}']),
    (0x1d6f6, &['\u{03A5}']),
    (0x1d5b, &['\u{0076}']),
    (0x2fc2, &['\u{9B5A}']),
    (0x1d6e4, &['\u{0393}']),
    (0x1d7e8, &['\u{0036}']),
    (0xff88, &['\u{30CD}']),
    (0x1d61, &['\u{03C7}']),
    (0xfb15, &['\u{0574}', '\u{056B}']),
    (0x32d1, &['\u{30A4}']),
    (0x1d7bc, &['\u{03C3}']),
    (0x313e, &['\u{11B4}']),
    (0x33ea, &['\u{0031}', '\u{0031}', '\u{65E5}']),
    (0xfc6c, &['\u{0628}', '\u{0645}']),
    (0x2fac, &['\u{96E8}']),
    (0xfbf3, &['\u{064A}', '\u{0654}', '\u{06C6}']),
    (0x1d6ff, &['\u{03B4}']),
    (0xfe78, &['\u{0020}', '\u{064F}']),
    (0x329f, &['\u{6CE8}']),
    (0x2f2e, &['\u{5DDB}']),
    (0x3371, &['\u{0068}', '\u{0050}', '\u{0061}']),
    (0x24b7, &['\u{0042}']),
    (0x1ee18, &['\u{0630}']),
    (0xfc3b, &['\u{0643}', '\u{0644}']),
    (0x1d63e, &['\u{0043}']),
    (0x1d47d, &['\u{0056}']),
    (0x1d72d, &['\u{0398}']),
    (0x1d579, &['\u{004E}']),
    (0x2fb8, &['\u{9996}']),
    (0x2461, &['\u{0032}']),
    (0x2077, &['\u{0037}']),
    (0xfb7a, &['\u{0686}']),
    (0x2f2d, &['\u{5C71}']),
    (0x32e9, &['\u{30CF}']),
    (0x1d4f4, &['\u{006B}']),
    (0x1d45f, &['\u{0072}']),
    (0x1d66d, &['\u{0078}']),
    (0x3334, &['\u{30D5}', '\u{3099}', '\u{30C3}', '\u{30B7}', '\u{30A7}', '\u{30EB}']),
    (0xfc6a, &['\u{0628}', '\u{0631}']),
    (0xeb3, &['\u{0ECD}', '\u{0EB2}']),
    (0x1d71d, &['\u{0392}']),
    (0x1d471, &['\u{004A}']),
    (0x3295, &['\u{7279}']),
    (0x1d7b3, &['\u{03BA}']),
    (0x1d60, &['\u{03C6}']),
    (0x2b6, &['\u{0281}']),
    (0x3387, &['\u{0047}', '\u{0042}']),
    (0x321c, &['\u{0028}', '\u{110C}', '\u{116E}', '\u{0029}']),
    (0xfe5d, &['\u{3014}']),
    (0x32ba, &['\u{0034}', '\u{0035}']),
    (0x24bf, &['\u{004A}']),
    (0xfeb8, &['\u{0634}']),
    (0xfc83, &['\u{0643}', '\u{0649}']),
    (0x1d67c, &['\u{004D}']),
    (0x2fc0, &['\u{9B32}']),
    (0x33f9, &['\u{0032}', '\u{0036}', '\u{65E5}']),
    (0x3178, &['\u{112B}']),
    (0x1ee89, &['\u{064A}']),
    (0xfd79, &['\u{063A}', '\u{0645}', '\u{0645}']),
    (0x3210, &['\u{0028}', '\u{1103}', '\u{1161}', '\u{0029}']),
    (0xfcf2, &['\u{0640}', '\u{064E}', '\u{0651}']),
    (0x1d591, &['\u{006C}']),
    (0x1d604, &['\u{0077}']),
    (0xfe9f, &['\u{062C}']),
    (0xff3d, &['\u{005D}']),
    (0x3235, &['\u{0028}', '\u{7279}', '\u{0029}']),
    (0x1d49f, &['\u{0044}']),
    (0xfbe9, &['\u{0649}']),
    (0x33bc, &['\u{03BC}', '\u{0057}']),
    (0x3161, &['\u{1173}']),
    (0x1d77a, &['\u{03BB}']),
    (0xfe5a, &['\u{0029}']),
    (0x1d697, &['\u{006E}']),
    (0xfb53, &['\u{067B}']),
    (0x1d58f, &['\u{006A}']),
    (0x1ee93, &['\u{0631}']),
    (0xfe56, &['\u{003F}']),
    (0x3201, &['\u{0028}', '\u{1102}', '\u{0029}']),
    (0x1ee91, &['\u{0635}']),
    (0x1d40d, &['\u{004E}']),
    (0x2150, &['\u{0031}', '\u{2044}', '\u{0037}']),
    (0x210d, &['\u{0048}']),
    (0x1f13f, &['\u{0050}']),
    (0x1d734, &['\u{03A9}']),
    (0x1d5d1, &['\u{0078}']),
    (0x3340, &['\u{30DB}', '\u{309A}', '\u{30F3}', '\u{30C8}', '\u{3099}']),
    (0x1d599, &['\u{0074}']),
    (0x1d409, &['\u{004A}']),
    (0xfc1b, &['\u{062E}', '\u{0645}']),
    (0x1f23b, &['\u{914D}']),
    (0xfc47, &['\u{0645}', '\u{062E}']),
    (0x3257, &['\u{0032}', '\u{0037}']),
    (0x2169, &['\u{0058}']),
    (0x246d, &['\u{0031}', '\u{0034}']),
    (0x1d612, &['\u{004B}']),
    (0xfb55, &['\u{067B}']),
    (0xfe84, &['\u{0627}', '\u{0654}']),
    (0x1d798, &['\u{0399}']),
    (0x216a, &['\u{0058}', '\u{0049}']),
    (0x2fc9, &['\u{9ECD}']),
    (0xfe80, &['\u{0621}']),
    (0x1d428, &['\u{006F}']),
    (0x2159, &['\u{0031}', '\u{2044}', '\u{0036}']),
    (0x3283, &['\u{56DB}']),
    (0x1d480, &['\u{0059}']),
    (0xfeeb, &['\u{0647}']),
    (0x1d536, &['\u{0079}']),
    (0xff67, &['\u{30A1}']),
    (0x3144, &['\u{1121}']),
    (0x1d738, &['\u{03B3}']),
    (0xfefb, &['\u{0644}', '\u{0627}']),
    (0x1d6ea, &['\u{0399}']),
    (0x1d6ee, &['\u{039D}']),
    (0xfec6, &['\u{0638}']),
    (0x1d64c, &['\u{0051}']),
    (0xfba5, &['\u{06D5}', '\u{0654}']),
    (0x2033, &['\u{2032}', '\u{2032}']),
    (0xfe8c, &['\u{064A}', '\u{0654}']),
    (0x2fd3, &['\u{9F8D}']),
    (0x32e3, &['\u{30C8}']),
    (0x1d48c, &['\u{006B}']),
    (0xff8d, &['\u{30D8}']),
    (0x1d4d0, &['\u{0041}']),
    (0x1d403, &['\u{0044}']),
    (0x1d7e0, &['\u{0038}']),
    (0xfeb1, &['\u{0633}']),
    (0x24e4, &['\u{0075}']),
    (0xfb76, &['\u{0683}']),
    (0x2f76, &['\u{7C73}']),
    (0x2465, &['\u{0036}']),
    (0x2163, &['\u{0049}', '\u{0056}']),
    (0x1d4ab, &['\u{0050}']),
    (0xfcb5, &['\u{0636}', '\u{062D}']),
    (0x2f66, &['\u{758B}']),
    (0x211b, &['\u{0052}']),
    (0x1d5f6, &['\u{0069}']),
    (0x2fb1, &['\u{97CB}']),
    (0x1ee2e, &['\u{0633}']),
    (0x2071, &['\u{0069}']),
    (0x1d4bb, &['\u{0066}']),
    (0x33fc, &['\u{0032}', '\u{0039}', '\u{65E5}']),
    (0x2fc1, &['\u{9B3C}']),
    (0x1d4fb, &['\u{0072}']),
    (0x2478, &['\u{0028}', '\u{0035}', '\u{0029}']),
    (0xbc, &['\u{0031}', '\u{2044}', '\u{0034}']),
    (0x1d6f8, &['\u{03A7}']),
    (0x1d535, &['\u{0078}']),
    (0x1d5bc, &['\u{0063}']),
    (0x2165, &['\u{0056}', '\u{0049}']),
    (0xff35, &['\u{0055}']),
    (0x24b0, &['\u{0028}', '\u{0075}', '\u{0029}']),
    (0x322d, &['\u{0028}', '\u{6728}', '\u{0029}']),
    (0x1d413, &['\u{0054}']),
    (0x1d65b, &['\u{0066}']),
    (0x2463, &['\u{0034}']),
    (0x1eeb5, &['\u{062A}']),
    (0x208b, &['\u{2212}']),
    (0x32d7, &['\u{30AF}']),
    (0x1d67f, &['\u{0050}']),
    (0x2f91, &['\u{897E}']),
    (0x246b, &['\u{0031}', '\u{0032}']),
    (0x2fa6, &['\u{91D1}']),
    (0x1d628, &['\u{0067}']),
    (0x2f8d, &['\u{866B}']),
    (0xfec8, &['\u{0638}']),
    (0x1d788, &['\u{03C9}']),
    (0x1d715, &['\u{2202}']),
    (0xfcac, &['\u{062E}', '\u{0645}']),
    (0x1d774, &['\u{03B5}']),
    (0xfef4, &['\u{064A}']),
    (0x1d401, &['\u{0042}']),
    (0x32e8, &['\u{30CE}']),
    (0x328a, &['\u{6708}']),
    (0x33f6, &['\u{0032}', '\u{0033}', '\u{65E5}']),
    (0x1d70d, &['\u{03C2}']),
    (0x1d642, &['\u{0047}']),
    (0xfcbd, &['\u{063A}', '\u{0645}']),
    (0x3304, &['\u{30A4}', '\u{30CB}', '\u{30F3}', '\u{30AF}', '\u{3099}']),
    (0x3198, &['\u{4E0B}']),
    (0xffc6, &['\u{1165}']),
    (0x3265, &['\u{1107}']),
    (0x33e8, &['\u{0039}', '\u{65E5}']),
    (0xfccd, &['\u{0644}', '\u{0647}']),
    (0x2f53, &['\u{6C14}']),
    (0x1d410, &['\u{0051}']),
    (0x1d5e3, &['\u{0050}']),
    (0xfee1, &['\u{0645}']),
    (0xfc07, &['\u{0628}', '\u{062E}']),
    (0x2f51, &['\u{6BDB}']),
    (0xffa1, &['\u{1100}']),
    (0xfe12, &['\u{3002}']),
    (0x33e6, &['\u{0037}', '\u{65E5}']),
    (0x33d7, &['\u{0050}', '\u{0048}']),
    (0x1d40c, &['\u{004D}']),
    (0x1fed, &['\u{0020}', '\u{0308}', '\u{0300}']),
    (0x1d6d5, &['\u{03C4}']),
    (0x2f4d, &['\u{6B79}']),
    (0xfd98, &['\u{0646}', '\u{062C}', '\u{0645}']),
    (0x32c4, &['\u{0035}', '\u{6708}']),
    (0xffe3, &['\u{0020}', '\u{0304}']),
    (0x1d40, &['\u{0054}']),
    (0xfb65, &['\u{067F}']),
    (0x3208, &['\u{0028}', '\u{110C}', '\u{0029}']),
    (0x32fc, &['\u{30F0}']),
    (0xfe94, &['\u{0629}']),
    (0x32a3, &['\u{6B63}']),
    (0x1d34, &['\u{0048}']),
    (0xfe85, &['\u{0648}', '\u{0654}']),
    (0x200a, &['\u{0020}']),
    (0x1d617, &['\u{0050}']),
    (0x2fcb, &['\u{9EF9}']),
    (0x318e, &['\u{11A1}']),
    (0x32df, &['\u{30BF}']),
    (0x327e, &['\u{110B}', '\u{116E}']),
    (0xfea4, &['\u{062D}']),
    (0x2f83, &['\u{81EA}']),
    (0xffe4, &['\u{00A6}']),
    (0xfce4, &['\u{062A}', '\u{0647}']),
    (0x1f13b, &['\u{004C}']),
    (0x24d1, &['\u{0062}']),
    (0x24d6, &['\u{0067}']),
    (0x1d578, &['\u{004D}']),
    (0xfc9a, &['\u{064A}', '\u{0654}', '\u{0645}']),
    (0x32f7, &['\u{30EA}']),
    (0xfc70, &['\u{062A}', '\u{0631}']),
    (0x1d4c, &['\u{025C}']),
    (0xfb84, &['\u{068C}']),
    (0x1d4d7, &['\u{0048}']),
    (0x2f88, &['\u{821F}']),
    (0xfe97, &['\u{062A}']),
    (0xff70, &['\u{30FC}']),
    (0xfd58, &['\u{062C}', '\u{0645}', '\u{062D}']),
    (0x314b, &['\u{110F}']),
    (0x1d62e, &['\u{006D}']),
    (0x2fad, &['\u{9751}']),
    (0x2f14, &['\u{5315}']),
    (0xfc50, &['\u{0646}', '\u{064A}']),
    (0x336b, &['\u{0031}', '\u{0039}', '\u{70B9}']),
    (0x3234, &['\u{0028}', '\u{540D}', '\u{0029}']),
    (0x2fd2, &['\u{9F52}']),
    (0x1f243, &['\u{3014}', '\u{5B89}', '\u{3015}']),
    (0x1d442, &['\u{004F}']),
    (0x140, &['\u{006C}', '\u{00B7}']),
    (0x32bf, &['\u{0035}', '\u{0030}']),
    (0x1f100, &['\u{0030}', '\u{002E}']),
    (0xffce, &['\u{116B}']),
    (0xfdf1, &['\u{0642}', '\u{0644}', '\u{06D2}']),
    (0x3131, &['\u{1100}']),
    (0x33da, &['\u{0050}', '\u{0052}']),
    (0x314e, &['\u{1112}']),
    (0xfe8a, &['\u{064A}', '\u{0654}']),
    (0x3153, &['\u{1165}']),
    (0x2120, &['\u{0053}', '\u{004D}']),
    (0xfed9, &['\u{0643}']),
    (0x1d3f, &['\u{0052}']),
    (0x1d716, &['\u{03B5}']),
    (0x317b, &['\u{112E}']),
    (0x3260, &['\u{1100}']),
    (0xfc03, &['\u{064A}', '\u{0654}', '\u{0649}']),
    (0x1d421, &['\u{0068}']),
    (0xfd15, &['\u{063A}', '\u{0649}']),
    (0xfcc4, &['\u{0643}', '\u{062C}']),
    (0xfc7c, &['\u{0641}', '\u{0649}']),
    (0x1d73e, &['\u{03B9}']),
    (0x1d440, &['\u{004D}']),
    (0x2fa8, &['\u{9580}']),
    (0x33ba, &['\u{0070}', '\u{0057}']),
    (0xfe40, &['\u{3009}']),
    (0xfb20, &['\u{05E2}']),
    (0xfdb9, &['\u{0645}', '\u{062E}', '\u{064A}']),
    (0x1d5eb, &['\u{0058}']),
    (0x32b7, &['\u{0034}', '\u{0032}']),
    (0x1d618, &['\u{0051}']),
    (0x1d79e, &['\u{039F}']),
    (0x1d572, &['\u{0047}']),
    (0xfd8c, &['\u{0645}', '\u{062C}', '\u{062D}']),
    (0x2480, &['\u{0028}', '\u{0031}', '\u{0033}', '\u{0029}']),
    (0x3301, &['\u{30A2}', '\u{30EB}', '\u{30D5}', '\u{30A1}']),
    (0x1d5ee, &['\u{0061}']),
    (0xfdaa, &['\u{0634}', '\u{062D}', '\u{064A}']),
    (0xfcc6, &['\u{0643}', '\u{062E}']),
    (0x1d56e, &['\u{0043}']),
    (0x1ee39, &['\u{0636}']),
    (0x2f29, &['\u{5C0F}']),
    (0x1d3d, &['\u{0222}']),
    (0x3273, &['\u{1107}', '\u{1161}']),
    (0x1d60b, &['\u{0044}']),
    (0xfd36, &['\u{0633}', '\u{062E}']),
    (0x3368, &['\u{0031}', '\u{0036}', '\u{70B9}']),
    (0x1d4fa, &['\u{0071}']),
    (0x1db6, &['\u{0289}']),
    (0x1d779, &['\u{03BA}']),
    (0x1d5ba, &['\u{0061}']),
    (0x1eead, &['\u{0646}']),
    (0x2116, &['\u{004E}', '\u{006F}']),
    (0x338d, &['\u{03BC}', '\u{0067}']),
    (0x24d4, &['\u{0065}']),
    (0x1d405, &['\u{0046}']),
    (0xfc08, &['\u{0628}', '\u{0645}']),
    (0x1d497, &['\u{0076}']),
    (0x33ff, &['\u{0067}', '\u{0061}', '\u{006C}']),
    (0x1d582, &['\u{0057}']),
    (0xfede, &['\u{0644}']),
    (0x1d603, &['\u{0076}']),
    (0x2004, &['\u{0020}']),
    (0x3239, &['\u{0028}', '\u{4EE3}', '\u{0029}']),
    (0xfb94, &['\u{06AF}']),
    (0x2f63, &['\u{751F}']),
    (0x1d46c, &['\u{0045}']),
    (0x1d4c6, &['\u{0071}']),
    (0x203c, &['\u{0021}', '\u{0021}']),
    (0xff75, &['\u{30AA}']),
    (0xff79, &['\u{30B1}']),
    (0x215b, &['\u{0031}', '\u{2044}', '\u{0038}']),
    (0x2462, &['\u{0033}']),
    (0xfca1, &['\u{062A}', '\u{062C}']),
    (0xfc28, &['\u{0638}', '\u{0645}']),
    (0xff77, &['\u{30AD}']),
    (0x1ee51, &['\u{0635}']),
    (0x3360, &['\u{0038}', '\u{70B9}']),
    (0x1d78e, &['\u{03C1}']),
    (0x2145, &['\u{0044}']),
    (0x1d7b6, &['\u{03BD}']),
    (0x1c8, &['\u{004C}', '\u{006A}']),
    (0x3364, &['\u{0031}', '\u{0032}', '\u{70B9}']),
    (0xfc9f, &['\u{0628}', '\u{0645}']),
    (0xfd3a, &['\u{0637}', '\u{0645}']),
    (0xfb73, &['\u{0684}']),
    (0x1d55a, &['\u{0069}']),
    (0xffc3, &['\u{1162}']),
    (0x1d564, &['\u{0073}']),
    (0x3352, &['\u{30EA}', '\u{30E9}']),
    (0x1d52a, &['\u{006D}']),
    (0x1d5d8, &['\u{0045}']),
    (0x1d4f0, &['\u{0067}']),
    (0xffd3, &['\u{116E}']),
    (0x1f12e, &['\u{0057}', '\u{005A}']),
    (0x1ee76, &['\u{062B}']),
    (0x1d59e, &['\u{0079}']),
    (0xfe39, &['\u{3014}']),
    (0xff74, &['\u{30A8}']),
    (0x3164, &['\u{1160}']),
    (0xfb90, &['\u{06A9}']),
    (0x314f, &['\u{1161}']),
    (0x1d47c, &['\u{0055}']),
    (0x1d467, &['\u{007A}']),
    (0x1d5c3, &['\u{006A}']),
    (0x2f93, &['\u{89D2}']),
    (0x1d60d, &['\u{0046}']),
    (0x3245, &['\u{5E7C}']),
    (0xff05, &['\u{0025}']),
    (0x1d457, &['\u{006A}']),
    (0x1d696, &['\u{006D}']),
    (0x1d7b0, &['\u{03B7}']),
    (0xfe7a, &['\u{0020}', '\u{0650}']),
    (0x1d6d0, &['\u{03BF}']),
    (0xfe42, &['\u{300D}']),
    (0xfe91, &['\u{0628}']),
    (0x1d786, &['\u{03C7}']),
    (0x33b8, &['\u{006B}', '\u{0056}']),
    (0x2f90, &['\u{8863}']),
    (0xfc29, &['\u{0639}', '\u{062C}']),
    (0x1c5, &['\u{0044}', '\u{007A}', '\u{030C}']),
    (0x33a2, &['\u{006B}', '\u{006D}', '\u{0032}']),
    (0x1d645, &['\u{004A}']),
    (0xfc71, &['\u{062A}', '\u{0632}']),
    (0xfbff, &['\u{06CC}']),
    (0x1d752, &['\u{03BA}']),
    (0xfe32, &['\u{2013}']),
    (0x2fbe, &['\u{9B25}']),
    (0x2085, &['\u{0035}']),
    (0x2009, &['\u{0020}']),
    (0x1d4e0, &['\u{0051}']),
    (0x2f86, &['\u{820C}']),
    (0xfeae, &['\u{0631}']),
    (0x313a, &['\u{11B0}']),
    (0xfb66, &['\u{0679}']),
    (0x2f67, &['\u{7592}']),
    (0x1d5ac, &['\u{004D}']),
    (0x3f4, &['\u{0398}']),
    (0x1d718, &['\u{03BA}']),
    (0x1d4db, &['\u{004C}']),
    (0x332f, &['\u{30D2}', '\u{309A}', '\u{30AF}', '\u{30EB}']),
    (0xfc0a, &['\u{0628}', '\u{064A}']),
    (0xfd0a, &['\u{0634}', '\u{062D}']),
    (0x1d63, &['\u{0072}']),
    (0x1f21d, &['\u{5F8C}']),
    (0x1d5f7, &['\u{006A}']),
    (0x3270, &['\u{1103}', '\u{1161}']),
    (0x24b8, &['\u{0043}']),
    (0xfd80, &['\u{0644}', '\u{062D}', '\u{0645}']),
    (0x1d587, &['\u{0062}']),
    (0xa69c, &['\u{044A}']),
    (0xfd0c, &['\u{0634}', '\u{0645}']),
    (0x2fd0, &['\u{9F3B}']),
    (0x2007, &['\u{0020}']),
    (0xfd84, &['\u{0644}', '\u{062C}', '\u{062C}']),
    (0x331a, &['\u{30AF}', '\u{30EB}', '\u{30BB}', '\u{3099}', '\u{30A4}', '\u{30ED}']),
    (0x1d562, &['\u{0071}']),
    (0xfc3d, &['\u{0643}', '\u{0649}']),
    (0x1d4b4, &['\u{0059}']),
    (0x1f246, &['\u{3014}', '\u{76D7}', '\u{3015}']),
    (0x3247, &['\u{7B8F}']),
    (0x2160, &['\u{0049}']),
    (0xfe4f, &['\u{005F}']),
    (0x3211, &['\u{0028}', '\u{1105}', '\u{1161}', '\u{0029}']),
    (0x2481, &['\u{0028}', '\u{0031}', '\u{0034}', '\u{0029}']),
    (0x1d528, &['\u{006B}']),
    (0x1f16b, &['\u{004D}', '\u{0044}']),
    (0xfc8f, &['\u{0646}', '\u{064A}']),
    (0xfd10, &['\u{0636}', '\u{0631}']),
    (0x208d, &['\u{0028}']),
    (0x3151, &['\u{1163}']),
    (0x1d453, &['\u{0066}']),
    (0xfc14, &['\u{062B}', '\u{064A}']),
    (0xfeec, &['\u{0647}']),
    (0x3325, &['\u{30C6}', '\u{3099}', '\u{30B7}']),
    (0xfeb4, &['\u{0633}']),
    (0x2f12, &['\u{529B}']),
    (0x1db5, &['\u{01AB}']),
    (0x3327, &['\u{30C8}', '\u{30F3}']),
    (0xfe8d, &['\u{0627}']),
    (0x24dc, &['\u{006D}']),
    (0x1d765, &['\u{03A0}']),
    (0x1d729, &['\u{039E}']),
    (0x321a, &['\u{0028}', '\u{1111}', '\u{1161}', '\u{0029}']),
    (0xa0, &['\u{0020}']),
    (0xfcb6, &['\u{0636}', '\u{062E}']),
    (0xfe51, &['\u{3001}']),
    (0x1d7c4, &['\u{03B5}']),
    (0x1d7d6, &['\u{0038}']),
    (0x1d4b6, &['\u{0061}']),
    (0x1d663, &['\u{006E}']),
    (0x33b7, &['\u{006D}', '\u{0056}']),
    (0x1d487, &['\u{0066}']),
    (0xfcb1, &['\u{0635}', '\u{062D}']),
    (0x1ee61, &['\u{0628}']),
    (0x2472, &['\u{0031}', '\u{0039}']),
    (0x3d6, &['\u{03C0}']),
    (0x1ee68, &['\u{0637}']),
    (0xff89, &['\u{30CE}']),
    (0x1d5f5, &['\u{0068}']),
];

pub(crate) const COMBINING_MARK_SALT: &[u16] = &[
    0x0,
    0x2,
    0x0,
    0x4,
    0x2,
    0x43f,
    0x1,
    0x477,
    0x96,
    0x13,
    0x4,
    0x0,
    0x0,
    0x0,
    0x149,
    0x0,
    0x0,
    0x4,
    0x36,
    0x0,
    0x8,
    0x0,
    0x152,
    0x0,
    0x0,
    0x2,
    0x100,
    0x204,
    0x0,
    0x0,
    0x2d,
    0x4,
    0x0,
    0x70,
    0x161,
    0x0,
    0xca,
    0xc,
    0x0,
    0x0,
    0x0,
    0x3e,
    0x2,
    0x1,
    0x68,
    0x0,
    0x3,
    0xd,
    0x75,
    0xcf,
    0x0,
    0x18,
    0x3,
    0x0,
    0x39,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x3,
    0x3,
    0x0,
    0x0,
    0x5,
    0x0,
    0x2c,
    0x31,
    0x0,
    0x0,
    0x41,
    0x1,
    0xd,
    0x30,
    0x0,
    0x0,
    0x10,
    0x10,
    0x0,
    0x42,
    0x1,
    0x53,
    0x0,
    0x0,
    0x7e,
    0x1,
    0x2e,
    0x0,
    0x2a,
    0x0,
    0x2,
    0x0,
    0x4e,
    0xd,
    0x60,
    0x0,
    0x7,
    0x2,
    0x79,
    0x3,
    0x41,
    0x0,
    0x0,
    0xb,
    0x0,
    0x21,
    0x3,
    0x2a,
    0x0,
    0x52,
    0x7,
    0x1a,
    0x0,
    0x1a,
    0x18,
    0xee,
    0x0,
    0x10,
    0x13,
    0x1a,
    0x18,
    0x0,
    0x2,
    0x1,
    0x58,
    0x1,
    0x7,
    0x0,
    0x6,
    0x9,
    0xa,
    0x4,
    0x64,
    0x2b,
    0x12,
    0x0,
    0x3,
    0xe,
    0x0,
    0x0,
    0x0,
    0x7,
    0x4,
    0x17,
    0x4,
    0x0,
    0x40,
    0x13,
    0x43,
    0xa,
    0x15,
    0x22,
    0x0,
    0x0,
    0x2,
    0xb,
    0x0,
    0x0,
    0x4,
    0x0,
    0x6,
    0x0,
    0x0,
    0xa,
    0xd,
    0x18,
    0x5,
    0x46,
    0x0,
    0x0,
    0x0,
    0x3,
    0x21,
    0x29,
    0x41,
    0x0,
    0x2,
    0x8,
    0x0,
    0xe,
    0x3a,
    0xe,
    0x38,
    0x13,
    0x30,
    0x1,
    0x4e,
    0x7,
    0x16,
    0xf,
    0x2,
    0x11,
    0x18,
    0x0,
    0x0,
    0x5,
    0xb,
    0x0,
    0x6,
    0x1,
    0x0,
    0x2,
    0x1,
    0x5,
    0x0,
    0x0,
    0x8,
    0x13,
    0x28,
    0x1,
    0x4,
    0x0,
    0x1e,
    0x1,
    0x0,
    0x0,
    0x0,
    0x2,
    0x4,
    0x0,
    0x0,
    0x12,
    0x4,
    0x2,
    0xe,
    0x1,
    0x10,
    0x0,
    0x0,
    0x1,
    0x3,
    0x0,
    0xa,
    0x4f,
    0x4,
    0x17,
    0x0,
    0x20,
    0x0,
    0x9,
    0x7,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x7,
    0x0,
    0xb,
    0x2,
    0x1a,
    0x0,
    0x21,
    0x0,
    0xa,
    0xc,
    0x0,
    0x0,
    0x0,
    0x0,
    0x22,
    0x4,
    0x2,
    0x3,
    0x1,
    0x20,
    0x1,
    0x6,
    0x1d,
    0x0,
    0x6,
    0x0,
    0x0,
    0x0,
    0x2,
    0x4,
    0x0,
    0x2,
    0x5,
    0x38,
    0x0,
    0x10,
    0x0,
    0x8,
    0xa,
    0x0,
    0x0,
    0x4,
    0x0,
    0x1,
    0x0,
    0xf,
    0x0,
    0x3,
    0x1,
    0x0,
    0x1,
    0x6,
    0x0,
    0x0,
    0x1f,
    0x0,
    0x0,
    0xb,
    0x4,
    0x2,
    0x0,
    0x1c,
    0xb,
    0x0,
    0x8,
    0x0,
    0x11,
    0x8,
    0x2,
    0xb,
    0x0,
    0x2,
    0x7,
    0x1,
    0x0,
    0x0,
    0x25,
    0x2,
    0x0,
    0x0,
    0x0,
    0xd,
    0x0,
    0xb,
    0x0,
    0x0,
    0x0,
    0x7,
    0x0,
    0x4,
    0x3,
    0x4,
    0x1,
    0x0,
    0xc,
    0x0,
    0x0,
    0x2,
    0x2,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0xb,
    0x23,
    0x0,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x11,
    0x0,
    0x0,
    0x0,
    0x0,
    0x4,
    0x8,
    0xc,
    0x0,
    0x0,
    0x1,
    0x8,
    0x18,
    0x0,
    0x0,
    0x2,
    0x0,
    0x4,
    0x0,
    0x28,
    0x16,
    0x1,
    0x4,
    0x0,
    0xb,
    0x0,
    0xa,
    0x0,
    0x1,
    0x1,
    0x0,
    0x2,
    0x1,
    0x0,
    0x0,
    0x4,
    0x5,
    0x0,
    0xa,
    0x9,
    0x27,
    0xc,
    0x2,
    0x0,
    0x0,
    0x8,
    0x0,
    0x5,
    0x8,
    0xb,
    0x1,
    0x4d,
    0x0,
    0x6,
    0x4,
    0x4,
    0x0,
    0x22,
    0x32,
    0x3,
    0x45,
    0x0,
    0x7,
    0xa,
    0x0,
    0x9,
    0x3a,
    0x1,
    0x0,
    0x0,
    0x4,
    0x2,
    0xd,
    0x0,
    0x21,
    0x0,
    0x1,
    0x16,
    0x1,
    0x0,
    0x12,
    0x0,
    0x0,
    0x6,
    0x5,
    0x2,
    0x19,
    0x9,
    0x0,
    0x0,
    0x2,
    0x7,
    0x6,
    0x0,
    0x4,
    0x0,
    0xd,
    0x0,
    0xb,
    0x9,
    0xd,
    0x3,
    0x1,
    0x14,
    0x0,
    0x1,
    0x19,
    0x4,
    0x0,
    0x1,
    0x4,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0x2c,
    0xb,
    0x8,
    0x0,
    0x4,
    0x1,
    0x0,
    0x2,
    0x0,
    0x0,
    0xf,
    0x12,
    0x2,
    0x0,
    0xa,
    0x3,
    0x9,
    0x0,
    0x7,
    0x1,
    0x0,
    0x0,
    0xf,
    0x0,
    0x0,
    0x6,
    0x0,
    0x14,
    0x2,
    0x15,
    0x6,
    0x3,
    0x0,
    0x0,
    0x0,
    0x9,
    0x0,
    0x0,
    0x0,
    0x12,
    0x0,
    0x1,
    0x3,
    0x0,
    0x15,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1f,
    0x0,
    0x5,
    0x3,
    0x1,
    0x1,
    0x3,
    0x1,
    0x8,
    0x2,
    0x0,
    0x1,
    0x2,
    0xd,
    0x3,
    0x4,
    0xd,
    0x0,
    0x5,
    0x0,
    0x16,
    0x0,
    0x0,
    0x0,
    0x2,
    0x3,
    0x2,
    0x0,
    0x7,
    0x0,
    0x0,
    0x5,
    0x11,
    0x3,
    0x0,
    0x4,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x2,
    0xd,
    0x5,
    0x2,
    0x0,
    0x2,
    0x17,
    0x7,
    0x5,
    0x2,
    0x10,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0xd,
    0x0,
    0x1,
    0x0,
    0x3,
    0x7,
    0x6,
    0x51,
    0x0,
    0x0,
    0x1,
    0xc,
    0x2,
    0x3,
    0x2,
    0x7,
    0x0,
    0x1,
    0x2,
    0x0,
    0x16,
    0x0,
    0x4,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x2,
    0x4,
    0x2,
    0x0,
    0x4,
    0x5,
    0x2,
    0x0,
    0x0,
    0x4,
    0x0,
    0x1e,
    0x0,
    0x4,
    0x1,
    0x11,
    0x19,
    0x7,
    0x1,
    0x10,
    0x11,
    0x7,
    0x3,
    0x1,
    0x0,
    0x0,
    0x1,
    0x0,
    0x1,
    0x0,
    0x3,
    0x6,
    0xb,
    0x0,
    0x2,
    0x4,
    0x3,
    0x6,
    0x1,
    0x11,
    0x1,
    0x0,
    0x10,
    0x0,
    0x1,
    0x7,
    0x3,
    0x3,
    0xc,
    0x1,
    0x4,
    0x18,
    0x0,
    0x0,
    0x1,
    0x6,
    0x0,
    0x7,
    0x4,
    0x3,
    0x3,
    0x0,
    0x4,
    0x5,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x9,
    0x0,
    0x5,
    0xe,
    0x8,
    0x1,
    0x7,
    0x5,
    0x0,
    0x7,
    0x4,
    0x1,
    0x1b,
    0x0,
    0x2,
    0x0,
    0x15,
    0x2,
    0x0,
    0x3,
    0x12,
    0x1,
    0x0,
    0x2,
    0x0,
    0x0,
    0x7,
    0x0,
    0x2,
    0x0,
    0x2,
    0x4,
    0x11,
    0x1,
    0x5,
    0x1,
    0x0,
    0x0,
    0xd,
    0x0,
    0x2,
    0x1,
    0x4,
    0x5,
    0x2,
    0x0,
    0x16,
    0x1,
    0xc,
    0x0,
    0x4,
    0x3,
    0x0,
    0x3,
    0x1,
    0x0,
    0x0,
    0x4,
    0x0,
    0x4,
    0xc,
    0x0,
    0x1d,
    0x1,
    0x0,
    0x1,
    0x19,
    0x0,
    0x1,
    0x2,
    0x3,
    0x0,
    0x0,
    0x1,
    0x1,
    0x0,
    0xa,
    0x5,
    0x0,
    0xb,
    0x5,
    0x0,
    0x4,
    0x3,
    0x2,
    0x0,
    0x17,
    0x9,
    0x0,
    0x1,
    0x2,
    0x3,
    0x0,
    0x1a,
    0x2,
    0x0,
    0x2,
    0xc,
    0x7,
    0x0,
    0x4,
    0x2,
    0x0,
    0x0,
    0x0,
    0x1,
    0x2,
    0x4,
    0x7,
    0x0,
    0x0,
    0x1,
    0xe,
    0x0,
    0x5,
    0x1,
    0x0,
    0x1,
    0x2,
    0x1,
    0x4,
    0x3,
    0xc,
    0x6,
    0xc,
    0x5,
    0x7,
    0x0,
    0x1,
    0x8,
    0x9,
    0x1,
    0x0,
    0x1b,
    0xb,
    0x9,
    0x1,
    0x4,
    0x4,
    0x9,
    0x3,
    0x0,
    0x2,
    0x4,
    0x3,
    0x0,
    0x3,
    0x2,
    0xa,
    0x2,
    0x15,
    0x3,
    0x2,
    0x0,
    0x0,
    0xb,
    0x1a,
    0x1,
    0x2,
    0x6,
    0x4,
    0x0,
    0xa,
    0x3,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0xc,
    0x17,
    0x0,
    0x0,
    0x4,
    0x0,
    0x0,
    0x0,
    0x2,
    0x3,
    0x0,
    0xd,
    0x14,
    0x2,
    0x3,
    0x7,
    0xe,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x7,
    0x9,
    0x6,
    0x0,
    0x0,
    0x7,
    0x1,
    0x6,
    0x0,
    0x2,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x9,
    0xb,
    0xe,
    0x1,
    0x11,
    0x1,
    0x2,
    0x6,
    0x4,
    0x4,
    0x1,
    0x0,
    0x0,
    0x8,
    0x1,
    0x1,
    0x1,
    0x0,
    0x4,
    0x2,
    0x0,
    0x0,
    0x1,
    0x0,
    0x1,
    0x2,
    0x0,
    0x6,
    0x5,
    0x1,
    0x3,
    0x7,
    0x0,
    0x0,
    0x4,
    0x1,
    0x0,
    0x0,
    0x13,
    0x2,
    0x2,
    0x8,
    0x0,
    0x4,
    0x3,
    0x0,
    0x5,
    0x0,
    0x0,
    0x0,
    0x1,
    0x1,
    0x6,
    0x0,
    0x1,
    0x1e,
    0x0,
    0x0,
    0x9,
    0x2,
    0x1,
    0x8,
    0x1,
    0x1,
    0x2,
    0x1,
    0x1,
    0x1,
    0x1,
    0x0,
    0x0,
    0xd,
    0x1,
    0x1,
    0x3,
    0x2,
    0x1,
    0x6,
    0x8,
    0xd,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x7,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x7,
    0x0,
    0x2,
    0x13,
    0x0,
    0xe,
    0x0,
    0x0,
    0x1,
    0x0,
    0x1,
    0x0,
    0x4,
    0x0,
    0x4,
    0x2,
    0x0,
    0x1,
    0x0,
    0x2,
    0x0,
    0x1,
    0x1,
    0x7,
    0x0,
    0x1,
    0x1,
    0x0,
    0x1,
    0x7,
    0x2,
    0x4,
    0x5,
    0x3,
    0x0,
    0x11,
    0x6,
    0x0,
    0x2,
    0x6,
    0x1,
    0x2,
    0x4,
    0x0,
    0x1,
    0x2,
    0x1,
    0x0,
    0x1,
    0x0,
    0x0,
    0x2,
    0x2,
    0x4,
    0x5,
    0x0,
    0x2,
    0xa,
    0x2,
    0xb,
    0x0,
    0xb,
    0x4,
    0x0,
    0x8,
    0xc,
    0x0,
    0x1,
    0x1,
    0x2,
    0x7,
    0x0,
    0x0,
    0x0,
    0x6,
    0xa,
    0x3,
    0x3,
    0x7,
    0x2,
    0x0,
    0x9,
    0x2,
    0x0,
    0x0,
    0x4,
    0x2,
    0x4,
    0x4,
    0x0,
    0x2,
    0x0,
    0x5,
    0x2,
    0x5,
    0x1,
    0x3,
    0x1,
    0x1,
    0x1,
    0x0,
    0x1,
    0x0,
    0x8,
    0x0,
    0x3,
    0x4,
    0x0,
    0x0,
    0x0,
    0x1,
    0x1,
    0x4,
    0x1,
    0x1,
    0x1,
    0x2,
    0x1,
    0xa,
    0x3,
    0x0,
    0x0,
    0x1,
    0x9,
    0x1,
    0x3,
    0x0,
    0x0,
    0xd,
    0x2,
    0xb,
    0x1,
    0x1,
    0x0,
    0x3,
    0x0,
    0x9,
    0x0,
    0x1,
    0x8,
    0x0,
    0x2,
    0x2,
    0x3,
    0x0,
    0x3,
    0x6,
    0x0,
    0x0,
    0x1,
    0x1,
    0x8,
    0x1,
    0x0,
    0x1,
    0x4,
    0x1,
    0x2,
    0x3,
    0x2,
    0x2,
    0x0,
    0x1,
    0x1,
    0x0,
    0x1,
    0x3,
    0x3,
    0x0,
    0x3,
    0x0,
    0x1,
    0x2,
    0x6,
    0x0,
    0x4,
    0x1,
    0x0,
    0x0,
    0xa,
    0x2,
    0x3,
    0x1,
    0x6,
    0x0,
    0x0,
    0x1,
    0x1,
    0x3,
    0x5,
    0x0,
    0xf,
    0x3,
    0x3,
    0x1,
    0x2,
    0x1,
    0x2,
    0x0,
    0x1,
    0x3,
    0x5,
    0x6,
    0x1,
    0x0,
    0x5,
    0x1,
    0x1,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x8,
    0x8,
    0x7,
    0x3,
    0x2,
    0x0,
    0x0,
    0x1,
    0x1,
    0x7,
    0x0,
    0x1,
    0x1,
    0x0,
    0x5,
    0x2,
    0x8,
    0x0,
    0x0,
    0x3,
    0x9,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x8,
    0x7,
    0x0,
    0x6,
    0x1,
    0x2,
    0x4,
    0x0,
    0x0,
    0x1,
    0x2,
    0x3,
    0x1,
    0x0,
    0x1,
    0x0,
    0x1,
    0x0,
    0x9,
    0x0,
    0x6,
    0x0,
    0x2,
    0x0,
    0x4,
    0x4,
    0x3,
    0x0,
    0x0,
    0x7,
    0x8,
    0x0,
    0x8,
    0x3,
    0x0,
    0x5,
    0x0,
    0x5,
    0x0,
    0x1,
    0x0,
    0xc,
    0x6,
    0x4,
    0x0,
    0x7,
    0x0,
    0x3,
    0x0,
    0x0,
    0x1,
    0x0,
    0x5,
    0x0,
    0x0,
    0x5,
    0x1,
    0x3,
    0xd,
    0x1,
    0x0,
    0x2,
    0x2,
    0x1,
    0x9,
    0x4,
    0x0,
    0x0,
    0x0,
    0x1,
    0x1,
    0x5,
    0x0,
    0x2,
    0x0,
    0x17,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x2,
    0x1,
    0x0,
    0x5,
    0x1,
    0x1,
    0x2,
    0x2,
    0x0,
    0x2,
    0x0,
    0x0,
    0x1,
    0x1,
    0x1,
    0x6,
    0x0,
    0x2,
    0x3,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x4,
    0x4,
    0x16,
    0x3,
    0x1,
    0x0,
    0x6,
    0x2,
    0x2,
    0x5,
    0x0,
    0x0,
    0x2,
    0x8,
    0x0,
    0x1,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x1,
    0x1,
    0x2,
    0x4,
    0x0,
    0x2,
    0x7,
    0x2,
    0x0,
    0x1,
    0x6,
    0x1,
    0x1,
    0x1,
    0x0,
    0x3,
    0x1,
    0x0,
    0x3,
    0x1,
    0x9,
    0x1,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x2,
    0x0,
    0xe,
    0x4,
    0x0,
    0x0,
    0x1,
    0x1,
    0x7,
    0x0,
    0x2,
    0x2,
    0x0,
    0x2,
    0x0,
    0x1,
    0x7,
    0x0,
    0x0,
    0x6,
    0x5,
    0x0,
    0x3,
    0x3,
    0x0,
    0x1,
    0x1,
    0x0,
    0x2,
    0x2,
    0x4,
    0x5,
    0x1,
    0x2,
    0x1,
    0x0,
    0x1,
    0x1,
    0x0,
    0x1,
    0x1,
    0x7,
    0x4,
    0x1,
    0x4,
    0x1,
    0x6,
    0x2,
    0x2,
    0x0,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x1,
    0x2,
    0x5,
    0x6,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x1,
    0x2,
    0x0,
    0x9,
    0x8,
    0x1,
    0x0,
    0x2,
    0x0,
    0x0,
    0x1,
    0x11,
    0x1,
    0x0,
    0x1,
    0x4,
    0x0,
    0x0,
    0x9,
    0x0,
    0x0,
    0x1,
    0x2,
    0x4,
    0x0,
    0x0,
    0x0,
    0x1,
    0x1,
    0x1,
    0x1,
    0x0,
    0x2,
    0x0,
    0x5,
    0x6,
    0x3,
    0x1,
    0x0,
    0x1,
    0x3,
    0x2,
    0x0,
    0x2,
    0x1,
    0x2,
    0x0,
    0x5,
    0x3,
    0x0,
    0x3,
    0x4,
    0x1,
    0x0,
    0x0,
    0x1,
    0x3,
    0x0,
    0x1,
    0x5,
    0x5,
    0x2,
    0x0,
    0x1,
    0x1,
    0x1,
    0x0,
    0x0,
    0x5,
    0x0,
    0x0,
    0x5,
    0x2,
    0x5,
    0x0,
    0x1,
    0x0,
    0x1,
    0x2,
    0x0,
    0x0,
    0x2,
    0x1,
    0x0,
    0x1,
    0x4,
    0x0,
    0x1,
    0x1,
    0x1,
    0x2,
    0x6,
    0x1,
    0xa,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x3,
    0x0,
    0x5,
    0x1,
    0x0,
    0x0,
    0x0,
    0x3,
    0x2,
    0x1,
    0x1,
    0x1,
    0x0,
    0x2,
    0x2,
    0x3,
    0x0,
    0x0,
    0x1,
    0x1,
    0x0,
    0x2,
    0x0,
    0x3,
    0x7,
    0xa,
    0x0,
    0x0,
    0x9,
    0x0,
    0x8,
    0x1,
    0x1,
    0x3,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x7,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x0,
    0x2,
    0x2,
    0x2,
    0x6,
    0x1,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x2,
    0x1,
    0x0,
    0xa,
    0xa,
    0x0,
    0x0,
    0x4,
    0x3,
    0x1,
    0x1,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x4,
    0x7,
    0x3,
    0x1,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x4,
    0x2,
    0x1,
    0x0,
    0x6,
    0x4,
    0x3,
    0x0,
    0x2,
    0x4,
    0x3,
    0x0,
    0x7,
    0x4,
    0x0,
    0x1,
    0x3,
    0x5,
    0x2,
    0x0,
    0x2,
    0x4,
    0x2,
    0x0,
    0x4,
    0x1,
    0x6,
    0x0,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x3,
    0x1,
    0x0,
    0x1,
    0x3,
    0x3,
    0x0,
    0x0,
    0x2,
    0x5,
    0x0,
    0x1,
    0x0,
    0x0,
    0x4,
    0x1,
    0x1,
    0x2,
    0xe,
    0x1,
    0x2,
    0x5,
    0x1,
    0x1,
    0x0,
    0x1,
    0x1,
    0x11,
    0x1,
    0x9,
    0x2,
    0x0,
    0xf,
    0x0,
    0x4,
    0x2,
    0x3,
    0x1,
    0x2,
    0x3,
    0x3,
    0x1,
    0x2,
    0x3,
    0x9,
    0x1,
    0x0,
    0x1,
    0x3,
    0x0,
    0x2,
    0x7,
    0xa,
    0x1,
    0x1,
    0x3,
    0x9,
    0x1,
    0x2,
    0x0,
    0x0,
    0x0,
    0x3,
    0x0,
    0x5,
    0x0,
    0x4,
    0x1,
    0x2,
    0x0,
    0x0,
    0x2,
    0x0,
    0x6,
    0x1,
    0x1,
    0x2,
    0x0,
    0x1,
    0x1,
    0x0,
    0x8,
    0x1,
    0x4,
    0x4,
    0x1,
    0x0,
    0x3,
    0x0,
    0x3,
    0x3,
    0x0,
    0x1,
    0x0,
    0xa,
    0x0,
    0x4,
    0x1,
    0x2,
    0x8,
    0x4,
    0x0,
    0x1,
    0xb,
    0x2,
    0xb,
    0x2,
    0x6,
    0x5,
    0x1,
    0x3,
    0x0,
    0x1,
    0x3,
    0x0,
    0x2,
    0x3,
    0x0,
    0x1,
    0x1,
    0x1,
    0x3,
    0x0,
    0x3,
    0x1,
    0x1,
    0x2,
    0x8,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x1,
    0x0,
    0x1,
    0x1,
    0x0,
    0x3,
    0x1,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x5,
    0x6,
    0x0,
    0x0,
    0x2,
    0x4,
    0x4,
    0x3,
    0x2,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x2,
    0x5,
    0x3,
    0x1,
    0x3,
    0x3,
    0x2,
    0xd,
    0x3,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x4,
    0x3,
    0x0,
    0x0,
    0x1,
    0x4,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x1,
    0x0,
    0x1,
    0x2,
    0x0,
    0x5,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x2,
    0x7,
    0x1,
    0x0,
    0x2,
    0x2,
    0x3,
    0x0,
    0x0,
    0x1,
    0x6,
    0x2,
    0x0,
    0x1,
    0x2,
    0x5,
    0x1,
    0x1,
    0x2,
    0x1,
    0x3,
    0x0,
    0x1,
    0x0,
    0x0,
    0x2,
    0x1,
    0x3,
    0x3,
    0x4,
    0x3,
    0x1,
    0x1,
    0x1,
    0x1,
    0x12,
    0x0,
    0x3,
    0x1,
    0x1,
    0x1,
    0x0,
    0x1,
    0x1,
    0x2,
    0x6,
    0x0,
    0x0,
    0x0,
    0x1,
    0x1,
    0x2,
    0x4,
    0x5,
    0x2,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x1,
    0x0,
    0x1,
    0x5,
    0x2,
    0x0,
    0x0,
    0x2,
    0x0,
    0x4,
    0x0,
    0x1,
    0x0,
    0x1,
    0x2,
    0x0,
    0x1,
    0x0,
    0x3,
    0x0,
    0x0,
    0xc,
    0x1,
    0x0,
    0x0,
    0x0,
    0x2,
    0x1,
    0x0,
    0x1,
    0x0,
    0x2,
    0x9,
    0x0,
    0x0,
    0x4,
    0x0,
    0x5,
    0x2,
    0x4,
    0x7,
    0x3,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0xc,
    0x4,
    0x1,
    0x4,
    0x1,
    0x1,
    0x1,
    0x1,
    0x3,
    0x5,
    0x2,
    0x6,
    0x0,
    0x2,
    0x2,
    0x6,
    0x2,
    0x2,
    0x2,
    0x1,
    0x0,
    0x4,
    0x2,
    0x0,
    0x4,
    0x0,
    0x2,
    0x0,
    0x1,
    0x0,
    0x1,
    0x1,
    0x0,
    0x2,
    0x0,
    0x5,
    0x3,
    0x3,
    0x1,
    0x1,
    0x0,
    0x2,
    0x2,
    0x0,
    0x2,
    0x1,
    0x1,
    0x1,
    0x1,
    0x0,
    0x1,
    0x1,
    0x0,
    0x1,
    0x1,
    0x1,
    0x0,
    0x0,
    0x1,
    0x3,
    0x0,
    0x2,
    0x3,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x3,
    0x0,
];
pub(crate) const COMBINING_MARK_KV: &[u32] = &[
    0x1a6c,
    0x115dd,
    0x0e3a,
    0x1da01,
    0x11cb1,
    0x115bd,
    0x0faf,
    0xe01dc,
    0x1da41,
    0x11374,
    0xfe00,
    0xa67c,
    0x1c36,
    0x0b42,
    0xfe04,
    0x16f7d,
    0x180b,
    0x2dfe,
    0x0e4a,
    0x101fd,
    0xe017e,
    0x102f,
    0x082b,
    0x0fa2,
    0x05a2,
    0x1ab2,
    0x06e3,
    0x1dd7,
    0x0f79,
    0x1ba4,
    0x16f70,
    0x1bf3,
    0x16f6b,
    0x034d,
    0xa675,
    0xa6f0,
    0x2cf0,
    0x0c40,
    0xe0186,
    0xe0153,
    0x0faa,
    0x1a74,
    0x0332,
    0xa8bb,
    0x111b7,
    0x1ab8,
    0x105e,
    0x1a6d,
    0x0b44,
    0x1924,
    0xa94b,
    0xfe2d,
    0x1da50,
    0xe01c3,
    0x1cdb,
    0x0322,
    0x0c02,
    0x1e023,
    0x1b73,
    0x1da30,
    0x1089,
    0xa802,
    0x193b,
    0x11634,
    0x1da47,
    0xa8b7,
    0x0eb7,
    0x11041,
    0x1057,
    0xe0150,
    0x1b6d,
    0xe0185,
    0x1b71,
    0x0619,
    0x11081,
    0x030d,
    0xe017f,
    0x1a79,
    0xe01a3,
    0x11636,
    0x1ce0,
    0x065d,
    0x0320,
    0xa92a,
    0x1da04,
    0xe01ce,
    0x08f6,
    0x111be,
    0x1dee,
    0xe0141,
    0x11236,
    0x2de3,
    0x10376,
    0x1e947,
    0x1dc5,
    0x0486,
    0x1a75,
    0x1033,
    0x111c0,
    0x09c8,
    0x16f5d,
    0x1d182,
    0x11366,
    0xfe05,
    0xe0155,
    0x1036,
    0xe0168,
    0x1ba1,
    0xe01ca,
    0x1cf2,
    0x1dec,
    0x17d1,
    0x1163c,
    0x0f8e,
    0xa8bf,
    0x0954,
    0x2de9,
    0x1bab,
    0xe0198,
    0x0dd8,
    0xa9b7,
    0x0eca,
    0xa8c5,
    0x0fbc,
    0x08dc,
    0x1c29,
    0xa8e2,
    0x1da3e,
    0x0e48,
    0x1abd,
    0x1da42,
    0x1143d,
    0x1e01b,
    0x08e4,
    0xe01c0,
    0xe0163,
    0x0acc,
    0x0d44,
    0xe012e,
    0x07aa,
    0x0825,
    0x0901,
    0x0ac7,
    0xaabe,
    0xe01b3,
    0x11c9c,
    0xe01c7,
    0x0820,
    0x1da5b,
    0x08e8,
    0x11044,
    0x16b33,
    0x1a5d,
    0xa826,
    0x2de4,
    0x11cab,
    0x16f74,
    0xa8e8,
    0x17bb,
    0x1171f,
    0x11232,
    0x0364,
    0x1daab,
    0x0c81,
    0x1a5a,
    0x10a3a,
    0x1dc4,
    0x1def,
    0x17bc,
    0x0cc1,
    0x16f71,
    0x073b,
    0xe018c,
    0x0358,
    0x0fb0,
    0x1b41,
    0x0487,
    0x1da33,
    0x1ab1,
    0x0bc0,
    0x11c3e,
    0x102c,
    0x1cd0,
    0x11c95,
    0x1da0a,
    0xa8ee,
    0x1a5b,
    0x0738,
    0x033c,
    0x20d5,
    0x1da54,
    0x0819,
    0x0b43,
    0x16b30,
    0x11726,
    0x16af3,
    0x0b40,
    0xe015b,
    0x0f9e,
    0x16f6d,
    0x0f7f,
    0xe0101,
    0x1b36,
    0xa9be,
    0x0359,
    0x09cb,
    0x1ddd,
    0x114b6,
    0x0c48,
    0x114c1,
    0x0744,
    0x1bf0,
    0x11181,
    0x0327,
    0x0e38,
    0x0bcc,
    0x1d16d,
    0x0340,
    0x116b3,
    0x11002,
    0x1e946,
    0x1da49,
    0x0c44,
    0x1da2e,
    0x2df0,
    0x1103f,
    0x0337,
    0x0b03,
    0xe01b7,
    0x11373,
    0x1c33,
    0xaa36,
    0x0ccc,
    0x11c32,
    0x07ad,
    0x17cd,
    0xa8b4,
    0x11ca5,
    0x07ef,
    0xe014d,
    0x1073,
    0x0f71,
    0x1d168,
    0xa69e,
    0x1ab9,
    0x0b3f,
    0x110b0,
    0xe01bb,
    0x032b,
    0x1134c,
    0x036d,
    0x11367,
    0x1e010,
    0x302b,
    0x1a6a,
    0x16f64,
    0x11130,
    0x10a0f,
    0x11133,
    0x1da1a,
    0x10a0e,
    0x0735,
    0x032f,
    0xa928,
    0x05c7,
    0x20de,
    0xa825,
    0xe0114,
    0xa94d,
    0xe01c6,
    0x1da0d,
    0xe01d7,
    0xe01a0,
    0x05bd,
    0x17ce,
    0x1a57,
    0x0a82,
    0x20e8,
    0x059d,
    0xe011c,
    0xe012d,
    0x07ae,
    0x1a68,
    0x0e4e,
    0x0316,
    0x16f73,
    0x103a,
    0xa670,
    0x1163f,
    0x1e008,
    0xe0191,
    0x16f76,
    0x1143f,
    0x085b,
    0x1a7f,
    0x09be,
    0x0d4d,
    0x0fa3,
    0xa927,
    0x0bbf,
    0xe01e8,
    0x114bf,
    0x0746,
    0x1cd1,
    0x1da75,
    0x0596,
    0xa67a,
    0x0f9c,
    0x16f77,
    0x11630,
    0xa8bd,
    0x17ba,
    0x0304,
    0x1de3,
    0x059f,
    0xe01a8,
    0x0fae,
    0x111b3,
    0x11728,
    0x0357,
    0x116ac,
    0x073c,
    0x11cad,
    0x1da61,
    0x2df9,
    0x20f0,
    0xa981,
    0x1da62,
    0x2deb,
    0x16f52,
    0x1cf8,
    0x112e4,
    0x1e8d3,
    0x1163e,
    0x0cc3,
    0x034e,
    0x1dcb,
    0xe016b,
    0x16f7c,
    0x1c2b,
    0x17b6,
    0x112e8,
    0x1da1d,
    0x05af,
    0x1143b,
    0x1da10,
    0xe01d8,
    0x1da9b,
    0x094e,
    0x0366,
    0x05c4,
    0x1cdd,
    0x10a05,
    0xabec,
    0x20e2,
    0x0319,
    0x0f9d,
    0xa9bd,
    0x111bc,
    0x11c9a,
    0xa9e5,
    0x0d62,
    0x065a,
    0x1bad,
    0x0956,
    0x1714,
    0x0345,
    0x11caf,
    0xa69f,
    0x110b5,
    0xe0122,
    0x1e017,
    0x0c3f,
    0x0a3e,
    0x1cdf,
    0x0abe,
    0x1dd1,
    0x0c83,
    0x2cf1,
    0x06d7,
    0x1930,
    0x0f97,
    0x1032,
    0x0f76,
    0x09c4,
    0x1da57,
    0x030f,
    0x1daa1,
    0x1b35,
    0x0d3f,
    0x08fb,
    0x1034,
    0xe014c,
    0x05b2,
    0x2d7f,
    0x1daa6,
    0x302f,
    0x11001,
    0x11ca1,
    0x0bbe,
    0x1dc8,
    0x09bf,
    0x1ab6,
    0x0b4d,
    0x2dee,
    0x0dd0,
    0xfe2a,
    0xe0190,
    0x0dd6,
    0x17b5,
    0x1a58,
    0x16f65,
    0xe0171,
    0xe01bd,
    0x0485,
    0x1d165,
    0x1c37,
    0x1beb,
    0x2dec,
    0xe018e,
    0x0949,
    0x1a5e,
    0xe016c,
    0x18a9,
    0x05b9,
    0x1067,
    0x1e005,
    0x11046,
    0x0d43,
    0x11c3c,
    0xfe23,
    0x08e6,
    0x1ce4,
    0x094d,
    0x0341,
    0xfe0f,
    0x1a55,
    0xa947,
    0x06e2,
    0x0f7d,
    0xaab0,
    0x1a59,
    0x102e,
    0x114c2,
    0x0e4c,
    0x073d,
    0x105f,
    0x112e1,
    0xe01c5,
    0xe0167,
    0x07ab,
    0x1d244,
    0x1e002,
    0x103b,
    0x0cbf,
    0xfe25,
    0x1b82,
    0xa8ed,
    0x10a3f,
    0x0595,
    0x1e8d4,
    0x05aa,
    0xe0113,
    0x0b41,
    0x2de2,
    0x1da25,
    0x1cf3,
    0x1bac,
    0x08d4,
    0x06e0,
    0x111bd,
    0x16f92,
    0x0f83,
    0x20d6,
    0xa823,
    0x1da3d,
    0xe0127,
    0xe0151,
    0x05b7,
    0x1ab4,
    0x0d40,
    0x1712,
    0x0336,
    0x1c35,
    0x1086,
    0xe0156,
    0x1da5d,
    0x1072,
    0xaac1,
    0x1da68,
    0x1c30,
    0x0329,
    0xaa2e,
    0x10ae5,
    0x035a,
    0xa679,
    0xfe07,
    0x11c9b,
    0x1083,
    0x1de9,
    0x1da0b,
    0xe01d5,
    0x0f3f,
    0x0342,
    0x0fb7,
    0x1936,
    0x102d,
    0x0d42,
    0x1dce,
    0x1063,
    0xe0193,
    0xe013c,
    0x06dc,
    0x0cc4,
    0x16f72,
    0x0733,
    0x1da60,
    0x11440,
    0x1b72,
    0x11342,
    0xa827,
    0xa8c0,
    0x0a3f,
    0x1e012,
    0xe019b,
    0x2df7,
    0x108d,
    0x08d6,
    0xfe01,
    0x115b8,
    0x0951,
    0x1b6e,
    0x1dcd,
    0x1e004,
    0x08d8,
    0x11723,
    0x036b,
    0xe011e,
    0x11c3d,
    0x10379,
    0x20d9,
    0x11c31,
    0x1ab0,
    0x1ce8,
    0x0321,
    0x103e,
    0x0ac9,
    0x11233,
    0x20e9,
    0xa948,
    0x112e0,
    0xa9bc,
    0x0326,
    0x07a9,
    0x1da55,
    0x16f5c,
    0xe017c,
    0x1da69,
    0x116b1,
    0x0eb5,
    0x11102,
    0x0a75,
    0x16f75,
    0x1c2e,
    0x093b,
    0xe01be,
    0xa672,
    0x0348,
    0xe01c4,
    0x2df4,
    0xfe21,
    0x111cc,
    0x0d57,
    0x06ed,
    0x08ec,
    0xfe29,
    0xe014b,
    0x0cd6,
    0xfe09,
    0x0303,
    0x1daa7,
    0xabe8,
    0x0fa7,
    0x0ecc,
    0x16f90,
    0x17d2,
    0x1d16e,
    0xe0183,
    0xe010a,
    0xa8ec,
    0x1d171,
    0x1da44,
    0x16af0,
    0x1d186,
    0x11cb4,
    0xa8e0,
    0x0940,
    0x11180,
    0x0acd,
    0xa8c1,
    0x1daa3,
    0xaa2d,
    0x1ce7,
    0xe017b,
    0x11368,
    0xa953,
    0xe0179,
    0x16f69,
    0x1886,
    0xa92d,
    0xe01c2,
    0x033b,
    0xe0145,
    0x0362,
    0x1daa9,
    0x0f84,
    0x0317,
    0x0483,
    0x0610,
    0x11cae,
    0xe0194,
    0xaaef,
    0x1da0e,
    0x1d172,
    0x0f78,
    0x0f9a,
    0x1da67,
    0x1c32,
    0x0b3e,
    0x036a,
    0xa8ea,
    0xa8e4,
    0x1112e,
    0x11234,
    0x032c,
    0x106a,
    0x0368,
    0xe01b8,
    0xa824,
    0x0ac2,
    0x16f61,
    0x05a5,
    0x05a7,
    0x0a40,
    0x1934,
    0x1a71,
    0x1068,
    0x1da29,
    0x0fb1,
    0x11640,
    0x302a,
    0x1e013,
    0x11724,
    0x05ab,
    0x0ec8,
    0x0f99,
    0xe01ac,
    0x1163d,
    0x1e006,
    0x1064,
    0x082a,
    0x0d82,
    0x1ced,
    0x0dde,
    0x1927,
    0xe01d4,
    0x16f59,
    0x11637,
    0xa8ba,
    0xaa35,
    0x1da3b,
    0x115be,
    0x135f,
    0x08d7,
    0x1773,
    0x16f5b,
    0xabe6,
    0x0902,
    0x1e018,
    0x1171d,
    0x16f8f,
    0x0ac5,
    0x180c,
    0x08f8,
    0x115b2,
    0x1103e,
    0x08e1,
    0x0903,
    0x111b4,
    0x1dd6,
    0x1031,
    0x20da,
    0x10a02,
    0x1da14,
    0x1dc7,
    0xaab2,
    0x0653,
    0x1da58,
    0x1daa8,
    0x17bd,
    0x0f90,
    0x0e4b,
    0x115b3,
    0xa8f0,
    0xe01a9,
    0x114b7,
    0xe0118,
    0x0cd5,
    0x115bf,
    0x111ca,
    0x11632,
    0xa8b5,
    0xe0120,
    0x1133c,
    0x036e,
    0x0740,
    0x1a70,
    0x1062,
    0xa94e,
    0x1122d,
    0x059c,
    0xaa32,
    0x20e4,
    0x0b48,
    0x0cc8,
    0x1a6b,
    0xe0136,
    0xe0192,
    0x17c9,
    0xe0126,
    0x17c7,
    0xe018d,
    0x1da2a,
    0xe01df,
    0x0fb3,
    0x1e000,
    0x11340,
    0x05b0,
    0xe0109,
    0x05c5,
    0x11363,
    0x1136b,
    0x11639,
    0x20dd,
    0x0fc6,
    0xa8b6,
    0x11134,
    0x05bf,
    0xfe2c,
    0x1e027,
    0xe0180,
    0xaab8,
    0x11c35,
    0x0fa4,
    0x0fa0,
    0x0821,
    0x114ba,
    0xe0159,
    0x20d8,
    0x1df0,
    0xe015f,
    0x1dfe,
    0x1734,
    0xe0111,
    0xaa2c,
    0x0b4c,
    0x0333,
    0x1b3a,
    0x16f60,
    0xe0174,
    0x0e34,
    0x0312,
    0xa8c4,
    0x034c,
    0xe01e2,
    0x0829,
    0x1daa2,
    0x11348,
    0x0957,
    0x1dc6,
    0x064e,
    0x0fb5,
    0x0ac3,
    0x0fb4,
    0xe01d3,
    0x1da09,
    0x1d17d,
    0xa8e6,
    0x1e01e,
    0xe0148,
    0xa8be,
    0x102e0,
    0x17c6,
    0x0363,
    0x16f66,
    0xe0132,
    0x1bef,
    0xe01ab,
    0x1daa4,
    0x20ed,
    0x05bb,
    0x1de1,
    0x0ac4,
    0x1cde,
    0x1e028,
    0x1da16,
    0x11437,
    0x114b0,
    0x094a,
    0xa678,
    0x1da66,
    0x09c3,
    0x1bee,
    0xa952,
    0x0fb9,
    0x036f,
    0x1171e,
    0xe01b5,
    0xe016d,
    0x11082,
    0x20ef,
    0x05b6,
    0x1cf4,
    0x0599,
    0x112e7,
    0x1b3f,
    0x0e37,
    0x1e01c,
    0x0cca,
    0x1d169,
    0xe0188,
    0x0bca,
    0xa676,
    0xe0121,
    0xabed,
    0x1ddc,
    0x1da12,
    0x0cbe,
    0x059b,
    0x16b32,
    0x0816,
    0x109c,
    0x0dd2,
    0x0827,
    0x1dd9,
    0x10a03,
    0x031b,
    0x1b44,
    0x20d2,
    0xa677,
    0x0b62,
    0x1e003,
    0xabe7,
    0x0dca,
    0x11303,
    0xa806,
    0xe01ad,
    0x031d,
    0x1030,
    0x0f8f,
    0xe018a,
    0xaa4c,
    0x0ebc,
    0xe0175,
    0x0dda,
    0x1b39,
    0x1136c,
    0x111b8,
    0x112ea,
    0x2de5,
    0xe01b9,
    0x032a,
    0x11c34,
    0x114b1,
    0x0618,
    0x0bc6,
    0x0743,
    0x193a,
    0x1b00,
    0x0e39,
    0x1ab5,
    0x0eb6,
    0x1da2f,
    0x1da40,
    0x17c4,
    0x17cc,
    0x1134b,
    0x1de2,
    0xe01d2,
    0x1da08,
    0xe0135,
    0x0ac8,
    0x0cc7,
    0x1da00,
    0xe01d9,
    0xe015d,
    0x1da0f,
    0x0657,
    0x20eb,
    0x16b34,
    0x0311,
    0x064f,
    0x16f58,
    0xa8e3,
    0x110b2,
    0x0df2,
    0xfe2f,
    0x0305,
    0x17dd,
    0x1e945,
    0x11301,
    0x0ce2,
    0x17c8,
    0x0bcb,
    0x0fa6,
    0x09c2,
    0x1172b,
    0xa671,
    0x0941,
    0x1752,
    0x1ba9,
    0x0bc7,
    0x1926,
    0x0fb8,
    0x1da6a,
    0x08f2,
    0x093c,
    0x16f51,
    0x11729,
    0x302c,
    0x1d188,
    0xaa2a,
    0x0736,
    0x1de7,
    0x114c0,
    0x1da4c,
    0xaaeb,
    0x1da24,
    0xe0104,
    0x20e7,
    0x1da1f,
    0xe01e9,
    0x0d63,
    0x0731,
    0xe017d,
    0x16f7b,
    0x16f63,
    0x116b5,
    0x0306,
    0x2dfd,
    0x1daae,
    0xe01da,
    0xa66f,
    0x0301,
    0x1133f,
    0x05a1,
    0x1e944,
    0x1dd3,
    0xe010b,
    0x10a0c,
    0x1082,
    0x116ae,
    0x0ddd,
    0x1935,
    0x11c2f,
    0x11371,
    0x0d4b,
    0x16f54,
    0x1bed,
    0x0823,
    0x1e026,
    0x16f56,
    0x07f1,
    0x1b40,
    0x11357,
    0x114c3,
    0x033d,
    0x0351,
    0x11720,
    0x11c39,
    0x1ce6,
    0x11038,
    0x0615,
    0x2de8,
    0x0ae3,
    0x11042,
    0x1a17,
    0x0352,
    0x1c2a,
    0x1112a,
    0x08fe,
    0x11c3b,
    0x06eb,
    0x0b01,
    0xe019e,
    0xe0165,
    0x0367,
    0x112e3,
    0x0c82,
    0xe01ae,
    0x11237,
    0x1df3,
    0x1de5,
    0x1abe,
    0x074a,
    0x16f62,
    0xe01c9,
    0x1ba6,
    0x0dcf,
    0xe019f,
    0x0eb9,
    0x11c38,
    0xe012a,
    0x0484,
    0xe0172,
    0x0318,
    0x094b,
    0x11369,
    0x1e8d0,
    0x111b9,
    0x05a6,
    0x093a,
    0x0ae2,
    0x1058,
    0x106d,
    0x1da5c,
    0xfe0c,
    0x0612,
    0x094f,
    0x1cda,
    0x0ccb,
    0x0b56,
    0xe0178,
    0x1da56,
    0x0cc2,
    0x0817,
    0x0cc0,
    0xe017a,
    0x0a83,
    0x06d8,
    0x1b34,
    0x06d6,
    0x1a61,
    0x0cbc,
    0xe01b4,
    0x0742,
    0xe0119,
    0x08dd,
    0x1dd2,
    0x1dc1,
    0x1e8d6,
    0xe0161,
    0xaa7d,
    0x1a77,
    0x0300,
    0xa8b9,
    0xe0170,
    0xfe0b,
    0x2df2,
    0xe012c,
    0x17c1,
    0x0f96,
    0x1df2,
    0x10a01,
    0xe01e4,
    0x1d180,
    0xabe5,
    0x0365,
    0x0fad,
    0x1d17b,
    0x1da3c,
    0x115af,
    0x1ab7,
    0x081f,
    0x08f1,
    0x07b0,
    0x0eb1,
    0x032d,
    0x116b4,
    0x05b4,
    0x09e3,
    0x1b6c,
    0x1732,
    0x1b04,
    0x1d1aa,
    0x11438,
    0x0614,
    0x11344,
    0x0b02,
    0x0307,
    0x11c3f,
    0x11230,
    0xe01c8,
    0x05a3,
    0x033e,
    0xa926,
    0xe0197,
    0x1da15,
    0x1dda,
    0x0354,
    0xe014a,
    0x110b7,
    0x16f57,
    0x112e5,
    0x1060,
    0x11c96,
    0x035e,
    0xe014e,
    0x1a5c,
    0xe0181,
    0xa80b,
    0x07f0,
    0x0fa5,
    0x1923,
    0x11ca4,
    0xe01de,
    0x11435,
    0x0ac1,
    0x20d0,
    0x11343,
    0x1d1ab,
    0x1069,
    0xa951,
    0x05b5,
    0x11ca2,
    0xaa31,
    0x1ce2,
    0xabea,
    0x1da2c,
    0x0e36,
    0x0611,
    0x1087,
    0x1b42,
    0xa983,
    0x1da4e,
    0x0b82,
    0x1da32,
    0xe0138,
    0x1c2f,
    0x0328,
    0x2dfa,
    0x1713,
    0x11372,
    0x08ff,
    0x1d17c,
    0xe019a,
    0x1038,
    0x1be7,
    0x0826,
    0x0c62,
    0x0df3,
    0x16f5f,
    0x035c,
    0x11cb2,
    0x1cd9,
    0x11127,
    0x1938,
    0xe015c,
    0x09d7,
    0x1da59,
    0x0b57,
    0x11443,
    0xa9b9,
    0x1da0c,
    0xe01d6,
    0x1e00f,
    0x1da63,
    0x17cb,
    0x1d167,
    0x108a,
    0x1a60,
    0x110b1,
    0x1e949,
    0x10a0d,
    0x0d01,
    0x1da06,
    0xe01d0,
    0x20d7,
    0xe01e7,
    0x0f19,
    0x1a73,
    0x16f6f,
    0x302e,
    0x1dcc,
    0x16f6a,
    0x036c,
    0x1123e,
    0x111ba,
    0x114bb,
    0x0fab,
    0x08f7,
    0x0fa1,
    0x0fa9,
    0x115b0,
    0x1103a,
    0xa67b,
    0x0344,
    0x035f,
    0x09e2,
    0x114b9,
    0x1ba3,
    0x11c9f,
    0x110b8,
    0x031a,
    0xe01db,
    0xa929,
    0xe01e5,
    0x1da1b,
    0x0324,
    0x1da4f,
    0x17c0,
    0x0f18,
    0xa8f1,
    0xaaf5,
    0xe0182,
    0x0a4d,
    0x0945,
    0x16af4,
    0x081b,
    0xaa43,
    0x115dc,
    0x1de4,
    0x1e01d,
    0x17b4,
    0xe0184,
    0xe01a2,
    0xe0147,
    0x20ea,
    0x1de0,
    0xe01af,
    0xa92c,
    0x0734,
    0x1b6b,
    0x110b6,
    0x10a39,
    0x1a65,
    0x05bc,
    0xe01a5,
    0x0d4c,
    0x0c01,
    0x1daad,
    0xa94f,
    0x1b37,
    0x1c2d,
    0x08fd,
    0x115b9,
    0xaabf,
    0x1da18,
    0x05b3,
    0x0963,
    0x1d181,
    0x1088,
    0x1ba2,
    0xe01ba,
    0x0953,
    0x0654,
    0x0abf,
    0xe011f,
    0xe0106,
    0x05a0,
    0xe01cf,
    0x11c3a,
    0x1cd2,
    0x065c,
    0xe010d,
    0x0308,
    0x1143e,
    0x1da53,
    0x0658,
    0x030c,
    0x11444,
    0x20d4,
    0xe0100,
    0x1a76,
    0x0a03,
    0xe0130,
    0x1da2d,
    0x11631,
    0xe0157,
    0x1b70,
    0x1da1e,
    0x114bc,
    0x17c5,
    0x16f5a,
    0x1163b,
    0x0f75,
    0x192b,
    0x1cf9,
    0xaaec,
    0x065e,
    0x0350,
    0x07af,
    0xa980,
    0x1056,
    0x034a,
    0x030e,
    0x2de0,
    0xa8e7,
    0x1e014,
    0x1da9e,
    0x08db,
    0x11cb6,
    0x111bb,
    0x1da26,
    0x0dd3,
    0x1035,
    0x1c24,
    0x0e49,
    0x08fc,
    0x0a4c,
    0x0c47,
    0x1da84,
    0xa9b5,
    0x0f80,
    0x1da5f,
    0x1172a,
    0x1dfc,
    0x0ddc,
    0xe015a,
    0xe0177,
    0x0818,
    0xe015e,
    0x1a63,
    0xa8c3,
    0x0591,
    0x1b01,
    0x0c43,
    0x0314,
    0xe01a6,
    0xfe22,
    0x1d187,
    0x11235,
    0x0acb,
    0xe0195,
    0x1da03,
    0xe01cd,
    0x1e00a,
    0x1d243,
    0xaaee,
    0x1da45,
    0x1da13,
    0xe01dd,
    0xe0112,
    0x08ee,
    0x1134d,
    0x1e00e,
    0x0b47,
    0x0f93,
    0x1dde,
    0x0659,
    0x0593,
    0x0616,
    0x1da5a,
    0x11446,
    0x0737,
    0x1ce1,
    0xe012f,
    0x1e009,
    0x1dd5,
    0x0360,
    0x073f,
    0x116af,
    0x08f9,
    0x08e5,
    0x1122c,
    0xe0108,
    0xfe2e,
    0x0bc2,
    0xe0133,
    0x081d,
    0x0489,
    0x0eb8,
    0x11c98,
    0x0302,
    0x1c31,
    0x0741,
    0x1133e,
    0xe0110,
    0x11173,
    0x0fb6,
    0x08f3,
    0x0942,
    0x08ef,
    0x11445,
    0x115b5,
    0x0347,
    0x1da19,
    0x0f72,
    0x114bd,
    0x1d17e,
    0x08de,
    0x0749,
    0x20d3,
    0x06ea,
    0x0b3c,
    0x0dd4,
    0x0d47,
    0x0f74,
    0x06d9,
    0x0f9f,
    0x0711,
    0x07ac,
    0x11c30,
    0xe0107,
    0xa9bf,
    0x08ed,
    0x0309,
    0x16f7a,
    0x1a66,
    0x11362,
    0x1e00d,
    0x1112b,
    0x1e8d1,
    0x0a70,
    0x1da65,
    0x034b,
    0x1e011,
    0x20e1,
    0x2df8,
    0x0e35,
    0xe011a,
    0x16f7e,
    0x05c2,
    0xaa7c,
    0x08da,
    0x1a7b,
    0x1e02a,
    0x106c,
    0x0f7a,
    0x10378,
    0x103c,
    0x20e3,
    0x1da9f,
    0x1a67,
    0x1e029,
    0x0d03,
    0x1da21,
    0x0948,
    0x11039,
    0xa8ef,
    0x1da02,
    0xe01cc,
    0x0f95,
    0x1733,
    0x0f73,
    0xa8e9,
    0xabe4,
    0x05b1,
    0x1daaa,
    0x2df3,
    0x1daaf,
    0x0592,
    0xaa4d,
    0x1a78,
    0x061a,
    0x2de7,
    0x1d1ad,
    0x11727,
    0x1da05,
    0x1d18b,
    0xe01ea,
    0x1da20,
    0xe01b6,
    0x17c2,
    0xaa34,
    0x109d,
    0x0739,
    0x065f,
    0x1885,
    0x064b,
    0x1b3b,
    0x1e8d5,
    0x0e47,
    0x1dc2,
    0xfe20,
    0x0335,
    0xe013b,
    0xe0158,
    0xa67d,
    0xe01ed,
    0x11635,
    0xfe28,
    0x0ebb,
    0x1da34,
    0x1b6f,
    0x103d,
    0x031c,
    0x1b3e,
    0x17b8,
    0x0944,
    0x1a6e,
    0xe01e0,
    0x1da31,
    0x112df,
    0x108c,
    0x2df6,
    0xe0149,
    0x20ee,
    0x0946,
    0x1b80,
    0x09c1,
    0x06e7,
    0x20e5,
    0x16f6e,
    0x10a38,
    0x1d166,
    0x05ba,
    0x0c42,
    0x0361,
    0x0e4d,
    0x11c99,
    0x2dff,
    0xa949,
    0x1103c,
    0x1939,
    0xe016e,
    0x1074,
    0x09c7,
    0xa9b4,
    0x0488,
    0x20e0,
    0xaa7b,
    0xe019c,
    0xe018b,
    0x09bc,
    0xe01ec,
    0x106b,
    0x11045,
    0x0f94,
    0x07ed,
    0xe0189,
    0x1da2b,
    0x1929,
    0xa9b8,
    0xe016a,
    0x1bc9d,
    0x109a,
    0x2dea,
    0x1037a,
    0x0656,
    0x0c3e,
    0x0346,
    0x1143a,
    0x1cd4,
    0x1c26,
    0x11436,
    0x0331,
    0xe016f,
    0x192a,
    0xe0154,
    0x0859,
    0x0325,
    0x0c55,
    0xe01b0,
    0x111bf,
    0xe013f,
    0xaa30,
    0x102b,
    0x17be,
    0x1abc,
    0x1b38,
    0xe013a,
    0x20dc,
    0x0c4a,
    0x1da28,
    0x0323,
    0x0955,
    0x1da5e,
    0x1da43,
    0x1aba,
    0x0c63,
    0xe018f,
    0x07ee,
    0xa94a,
    0xaab3,
    0x114b5,
    0x1be9,
    0x08e7,
    0x06e8,
    0x1772,
    0x1136a,
    0x108b,
    0x111b5,
    0x1a72,
    0x302d,
    0xe01e6,
    0x1da1c,
    0x2ded,
    0x0a4b,
    0x0597,
    0xe0123,
    0x08e0,
    0x11441,
    0xe0128,
    0x0c56,
    0x1b3d,
    0x1da4b,
    0x1bec,
    0x17d0,
    0x1d242,
    0xa8e1,
    0x114b2,
    0x094c,
    0x1bf1,
    0x115bb,
    0x16af1,
    0x035b,
    0xe0187,
    0x0bc8,
    0x11c93,
    0x11043,
    0x073e,
    0x0d48,
    0x064c,
    0x033f,
    0x0a3c,
    0xa950,
    0x0bd7,
    0x11638,
    0x073a,
    0xe0125,
    0x081c,
    0x0c00,
    0x07a8,
    0xe01eb,
    0xe0146,
    0x11725,
    0x1da52,
    0x05b8,
    0xe0105,
    0x17b7,
    0x0598,
    0xe010f,
    0x1bc9e,
    0x111cb,
    0xaaf6,
    0x135e,
    0x2df5,
    0x0822,
    0x1931,
    0xe012b,
    0x08e3,
    0x1dc0,
    0x07f3,
    0x1da48,
    0x116b0,
    0x1da11,
    0x16af2,
    0x116b6,
    0x06e4,
    0xfe27,
    0x16f6c,
    0x1c25,
    0x11129,
    0x0655,
    0x1e00b,
    0x0943,
    0x111b6,
    0x1112f,
    0x1c28,
    0x1da27,
    0x115b1,
    0x1da23,
    0x059e,
    0xe01e3,
    0x1a62,
    0x1dc3,
    0x20df,
    0x0f81,
    0xe0169,
    0x0abc,
    0x07ec,
    0x1921,
    0xe0143,
    0x11439,
    0x085a,
    0x11347,
    0xe01ef,
    0x0982,
    0x20db,
    0x032e,
    0x065b,
    0x10ae6,
    0x11341,
    0x0356,
    0xe0137,
    0x08d9,
    0x07a7,
    0x0fbb,
    0x1112d,
    0x0952,
    0x1c27,
    0x1103b,
    0x114be,
    0x1c34,
    0x0ddb,
    0x1a56,
    0xaa33,
    0xa9b6,
    0x1d18a,
    0x1a18,
    0x0732,
    0x09cc,
    0x1da9d,
    0x1071,
    0x1df1,
    0xe0129,
    0x309a,
    0xfe0a,
    0x0747,
    0x2de1,
    0x1cd5,
    0x17d3,
    0x1084,
    0x0a71,
    0x11370,
    0x0b63,
    0x1d170,
    0x0a51,
    0x0f86,
    0xa880,
    0x1928,
    0x1ba5,
    0x1da6c,
    0xe011b,
    0x1bf2,
    0x16b35,
    0x1da35,
    0x0a42,
    0xe0124,
    0x1107f,
    0xe019d,
    0x0f39,
    0x0355,
    0x0f77,
    0x0313,
    0x0bc1,
    0x030a,
    0x11633,
    0x1e020,
    0x1122e,
    0x1b3c,
    0x1be8,
    0x0983,
    0x1dc9,
    0x0670,
    0x11100,
    0x115b4,
    0x082d,
    0x114b4,
    0xe0140,
    0x0730,
    0x11722,
    0xabe9,
    0xaab7,
    0x11cb0,
    0x1b81,
    0xe0139,
    0x0349,
    0x05ae,
    0x0617,
    0x1e016,
    0x08eb,
    0x16f53,
    0x0745,
    0x1da36,
    0x031f,
    0x0652,
    0x1df4,
    0xfe0e,
    0xe0199,
    0x06db,
    0x05a9,
    0x08fa,
    0x20e6,
    0x1df5,
    0xe01a4,
    0x1059,
    0xe0164,
    0x0dd9,
    0x11131,
    0x064d,
    0x0a01,
    0x20d1,
    0xe014f,
    0xa8e5,
    0xa8c2,
    0x0981,
    0xa6f1,
    0x0f35,
    0x2dfb,
    0xfe0d,
    0x135d,
    0xe0115,
    0x093e,
    0x1e00c,
    0x11ca9,
    0xa8bc,
    0xe0102,
    0x05a4,
    0x1e01f,
    0x08f4,
    0xe0176,
    0x05ac,
    0x0fa8,
    0x16f5e,
    0x10a06,
    0x1dd0,
    0x1d185,
    0x16f79,
    0x17bf,
    0x16f68,
    0xe0117,
    0x0900,
    0x0a81,
    0xfe02,
    0x1dd4,
    0x1ba8,
    0xfb1e,
    0x3099,
    0x1e8d2,
    0x11128,
    0x11c92,
    0x17cf,
    0x0369,
    0x1cdc,
    0x08df,
    0x0748,
    0x0ec9,
    0xe01bf,
    0x17c3,
    0x1dcf,
    0x1112c,
    0x1143c,
    0x06da,
    0x1922,
    0x0d83,
    0x11cac,
    0x1ce5,
    0x0a41,
    0x11c33,
    0xa9bb,
    0x034f,
    0x11231,
    0x11000,
    0x11442,
    0x07a6,
    0x11ca3,
    0xfe06,
    0xa9ba,
    0x0f82,
    0x0d46,
    0x11101,
    0x0339,
    0x05c1,
    0x2de6,
    0x11c94,
    0x0ccd,
    0x0a48,
    0x11132,
    0x16f55,
    0x0343,
    0x110b9,
    0x1039,
    0x1da6b,
    0x1c2c,
    0xe01bc,
    0xe01c1,
    0x1085,
    0x082c,
    0x0947,
    0x09c0,
    0x1ddb,
    0x06e1,
    0x1a1a,
    0x031e,
    0xaab4,
    0xe01a1,
    0xfe26,
    0xe010e,
    0x1ce3,
    0x1163a,
    0x2dfc,
    0x0f87,
    0xe0173,
    0x1e015,
    0x1d189,
    0x035d,
    0x0ddf,
    0xfe24,
    0x11040,
    0x11300,
    0x1e021,
    0x11302,
    0xe01e1,
    0x0651,
    0x1da17,
    0x1920,
    0x115ba,
    0x0962,
    0x06df,
    0xa9b3,
    0x08ea,
    0x1cd8,
    0x0f7e,
    0x11721,
    0x116b2,
    0x11182,
    0x0c4c,
    0xe013e,
    0xe0160,
    0x1cd7,
    0x1a6f,
    0xfe03,
    0xe0116,
    0x1daac,
    0x11cb3,
    0x093f,
    0xa881,
    0xe0131,
    0x0fac,
    0x0a02,
    0x0d41,
    0x10377,
    0x114b3,
    0x112e2,
    0x0594,
    0x08f5,
    0xe0134,
    0x0334,
    0x2cef,
    0x07f2,
    0x0c4d,
    0x11caa,
    0x16b36,
    0x0f91,
    0x16f67,
    0x0c4b,
    0x1abb,
    0x0315,
    0x0c03,
    0xe013d,
    0x1de8,
    0xe0103,
    0x0fba,
    0x1dfd,
    0x11ca0,
    0x0f3e,
    0x16b31,
    0xfe2b,
    0x0a47,
    0x1da46,
    0xe0152,
    0x1de6,
    0x1ba7,
    0x1a64,
    0x11c9e,
    0x0f9b,
    0x0e31,
    0x110b3,
    0x0330,
    0x0b4b,
    0x1932,
    0x108f,
    0xaa2b,
    0x17ca,
    0x1dea,
    0x0310,
    0x2df1,
    0x1da4d,
    0x081e,
    0x112e6,
    0x030b,
    0xe01a7,
    0xaa2f,
    0x115c0,
    0xe0196,
    0x1daa5,
    0x1da51,
    0x11080,
    0x1937,
    0x033a,
    0x1dfb,
    0x1d16f,
    0x1dd8,
    0x0ce3,
    0x0f92,
    0x1b02,
    0x0dd1,
    0x1ab3,
    0x06ec,
    0x0c46,
    0x0fb2,
    0x115bc,
    0xe0162,
    0x1a69,
    0x0ecd,
    0x180d,
    0xa9c0,
    0x1e024,
    0x0f7c,
    0x0eb4,
    0xa8b8,
    0xa92b,
    0x11ca6,
    0x116ab,
    0xaa29,
    0x110b4,
    0xa982,
    0x1d1ac,
    0x059a,
    0x16f91,
    0x1753,
    0x0c41,
    0x109b,
    0xabe3,
    0xe0144,
    0x1ddf,
    0x05ad,
    0xe0142,
    0x11cb5,
    0x1122f,
    0xe010c,
    0x1b03,
    0x1925,
    0x1deb,
    0x1dff,
    0x11c97,
    0xe01b2,
    0x0f8d,
    0x0ac0,
    0x08d5,
    0x1a1b,
    0xa8eb,
    0xe011d,
    0x110ba,
    0x0613,
    0x1e001,
    0x0f37,
    0x0ecb,
    0xa674,
    0x1da9c,
    0x17b9,
    0x16f78,
    0x08e9,
    0x1da22,
    0x0353,
    0x1103d,
    0xe01aa,
    0x116ad,
    0x1baa,
    0x1dca,
    0x1cd6,
    0x1037,
    0xfe08,
    0x0338,
    0x05a8,
    0x1933,
    0xe01ee,
    0x0d4a,
    0x0bcd,
    0x11c9d,
    0xaaed,
    0x20ec,
    0x0cc6,
    0x116b7,
    0xe0166,
    0x1e948,
    0xe01b1,
    0x1b43,
    0x1a19,
    0x1bea,
    0x08f0,
    0x1da4a,
    0x0650,
    0x1da3f,
    0x1d17f,
    0xa94c,
    0x07eb,
    0x1da64,
    0x0d02,
    0x1ded,
    0x114b8,
    0xe01cb,
    0x112e9,
    0x09cd,
    0x1da07,
    0xe01d1,
    0x11c36,
    0x1a7c,
    0x1a7a,
    0x1be6,
    0x2def,
    0x0d3e,
    0x0f7b,
    0x1e94a,
    0x11ca7,
];


#[inline]
#[allow(ellipsis_inclusive_range_patterns)]
pub fn qc_nfc(c: char) -> IsNormalized {
    match c {
        '\u{0340}'...'\u{0341}' => No,
        '\u{0343}'...'\u{0344}' => No,
        '\u{0374}' => No,
        '\u{037E}' => No,
        '\u{0387}' => No,
        '\u{0958}'...'\u{095F}' => No,
        '\u{09DC}'...'\u{09DD}' => No,
        '\u{09DF}' => No,
        '\u{0A33}' => No,
        '\u{0A36}' => No,
        '\u{0A59}'...'\u{0A5B}' => No,
        '\u{0A5E}' => No,
        '\u{0B5C}'...'\u{0B5D}' => No,
        '\u{0F43}' => No,
        '\u{0F4D}' => No,
        '\u{0F52}' => No,
        '\u{0F57}' => No,
        '\u{0F5C}' => No,
        '\u{0F69}' => No,
        '\u{0F73}' => No,
        '\u{0F75}'...'\u{0F76}' => No,
        '\u{0F78}' => No,
        '\u{0F81}' => No,
        '\u{0F93}' => No,
        '\u{0F9D}' => No,
        '\u{0FA2}' => No,
        '\u{0FA7}' => No,
        '\u{0FAC}' => No,
        '\u{0FB9}' => No,
        '\u{1F71}' => No,
        '\u{1F73}' => No,
        '\u{1F75}' => No,
        '\u{1F77}' => No,
        '\u{1F79}' => No,
        '\u{1F7B}' => No,
        '\u{1F7D}' => No,
        '\u{1FBB}' => No,
        '\u{1FBE}' => No,
        '\u{1FC9}' => No,
        '\u{1FCB}' => No,
        '\u{1FD3}' => No,
        '\u{1FDB}' => No,
        '\u{1FE3}' => No,
        '\u{1FEB}' => No,
        '\u{1FEE}'...'\u{1FEF}' => No,
        '\u{1FF9}' => No,
        '\u{1FFB}' => No,
        '\u{1FFD}' => No,
        '\u{2000}'...'\u{2001}' => No,
        '\u{2126}' => No,
        '\u{212A}'...'\u{212B}' => No,
        '\u{2329}' => No,
        '\u{232A}' => No,
        '\u{2ADC}' => No,
        '\u{F900}'...'\u{FA0D}' => No,
        '\u{FA10}' => No,
        '\u{FA12}' => No,
        '\u{FA15}'...'\u{FA1E}' => No,
        '\u{FA20}' => No,
        '\u{FA22}' => No,
        '\u{FA25}'...'\u{FA26}' => No,
        '\u{FA2A}'...'\u{FA6D}' => No,
        '\u{FA70}'...'\u{FAD9}' => No,
        '\u{FB1D}' => No,
        '\u{FB1F}' => No,
        '\u{FB2A}'...'\u{FB36}' => No,
        '\u{FB38}'...'\u{FB3C}' => No,
        '\u{FB3E}' => No,
        '\u{FB40}'...'\u{FB41}' => No,
        '\u{FB43}'...'\u{FB44}' => No,
        '\u{FB46}'...'\u{FB4E}' => No,
        '\u{1D15E}'...'\u{1D164}' => No,
        '\u{1D1BB}'...'\u{1D1C0}' => No,
        '\u{2F800}'...'\u{2FA1D}' => No,
        '\u{0300}'...'\u{0304}' => Maybe,
        '\u{0306}'...'\u{030C}' => Maybe,
        '\u{030F}' => Maybe,
        '\u{0311}' => Maybe,
        '\u{0313}'...'\u{0314}' => Maybe,
        '\u{031B}' => Maybe,
        '\u{0323}'...'\u{0328}' => Maybe,
        '\u{032D}'...'\u{032E}' => Maybe,
        '\u{0330}'...'\u{0331}' => Maybe,
        '\u{0338}' => Maybe,
        '\u{0342}' => Maybe,
        '\u{0345}' => Maybe,
        '\u{0653}'...'\u{0655}' => Maybe,
        '\u{093C}' => Maybe,
        '\u{09BE}' => Maybe,
        '\u{09D7}' => Maybe,
        '\u{0B3E}' => Maybe,
        '\u{0B56}' => Maybe,
        '\u{0B57}' => Maybe,
        '\u{0BBE}' => Maybe,
        '\u{0BD7}' => Maybe,
        '\u{0C56}' => Maybe,
        '\u{0CC2}' => Maybe,
        '\u{0CD5}'...'\u{0CD6}' => Maybe,
        '\u{0D3E}' => Maybe,
        '\u{0D57}' => Maybe,
        '\u{0DCA}' => Maybe,
        '\u{0DCF}' => Maybe,
        '\u{0DDF}' => Maybe,
        '\u{102E}' => Maybe,
        '\u{1161}'...'\u{1175}' => Maybe,
        '\u{11A8}'...'\u{11C2}' => Maybe,
        '\u{1B35}' => Maybe,
        '\u{3099}'...'\u{309A}' => Maybe,
        '\u{110BA}' => Maybe,
        '\u{11127}' => Maybe,
        '\u{1133E}' => Maybe,
        '\u{11357}' => Maybe,
        '\u{114B0}' => Maybe,
        '\u{114BA}' => Maybe,
        '\u{114BD}' => Maybe,
        '\u{115AF}' => Maybe,
        _ => Yes,
    }
}

#[inline]
#[allow(ellipsis_inclusive_range_patterns)]
pub fn qc_nfkc(c: char) -> IsNormalized {
    match c {
        '\u{00A0}' => No,
        '\u{00A8}' => No,
        '\u{00AA}' => No,
        '\u{00AF}' => No,
        '\u{00B2}'...'\u{00B3}' => No,
        '\u{00B4}' => No,
        '\u{00B5}' => No,
        '\u{00B8}' => No,
        '\u{00B9}' => No,
        '\u{00BA}' => No,
        '\u{00BC}'...'\u{00BE}' => No,
        '\u{0132}'...'\u{0133}' => No,
        '\u{013F}'...'\u{0140}' => No,
        '\u{0149}' => No,
        '\u{017F}' => No,
        '\u{01C4}'...'\u{01CC}' => No,
        '\u{01F1}'...'\u{01F3}' => No,
        '\u{02B0}'...'\u{02B8}' => No,
        '\u{02D8}'...'\u{02DD}' => No,
        '\u{02E0}'...'\u{02E4}' => No,
        '\u{0340}'...'\u{0341}' => No,
        '\u{0343}'...'\u{0344}' => No,
        '\u{0374}' => No,
        '\u{037A}' => No,
        '\u{037E}' => No,
        '\u{0384}'...'\u{0385}' => No,
        '\u{0387}' => No,
        '\u{03D0}'...'\u{03D6}' => No,
        '\u{03F0}'...'\u{03F2}' => No,
        '\u{03F4}'...'\u{03F5}' => No,
        '\u{03F9}' => No,
        '\u{0587}' => No,
        '\u{0675}'...'\u{0678}' => No,
        '\u{0958}'...'\u{095F}' => No,
        '\u{09DC}'...'\u{09DD}' => No,
        '\u{09DF}' => No,
        '\u{0A33}' => No,
        '\u{0A36}' => No,
        '\u{0A59}'...'\u{0A5B}' => No,
        '\u{0A5E}' => No,
        '\u{0B5C}'...'\u{0B5D}' => No,
        '\u{0E33}' => No,
        '\u{0EB3}' => No,
        '\u{0EDC}'...'\u{0EDD}' => No,
        '\u{0F0C}' => No,
        '\u{0F43}' => No,
        '\u{0F4D}' => No,
        '\u{0F52}' => No,
        '\u{0F57}' => No,
        '\u{0F5C}' => No,
        '\u{0F69}' => No,
        '\u{0F73}' => No,
        '\u{0F75}'...'\u{0F79}' => No,
        '\u{0F81}' => No,
        '\u{0F93}' => No,
        '\u{0F9D}' => No,
        '\u{0FA2}' => No,
        '\u{0FA7}' => No,
        '\u{0FAC}' => No,
        '\u{0FB9}' => No,
        '\u{10FC}' => No,
        '\u{1D2C}'...'\u{1D2E}' => No,
        '\u{1D30}'...'\u{1D3A}' => No,
        '\u{1D3C}'...'\u{1D4D}' => No,
        '\u{1D4F}'...'\u{1D6A}' => No,
        '\u{1D78}' => No,
        '\u{1D9B}'...'\u{1DBF}' => No,
        '\u{1E9A}'...'\u{1E9B}' => No,
        '\u{1F71}' => No,
        '\u{1F73}' => No,
        '\u{1F75}' => No,
        '\u{1F77}' => No,
        '\u{1F79}' => No,
        '\u{1F7B}' => No,
        '\u{1F7D}' => No,
        '\u{1FBB}' => No,
        '\u{1FBD}' => No,
        '\u{1FBE}' => No,
        '\u{1FBF}'...'\u{1FC1}' => No,
        '\u{1FC9}' => No,
        '\u{1FCB}' => No,
        '\u{1FCD}'...'\u{1FCF}' => No,
        '\u{1FD3}' => No,
        '\u{1FDB}' => No,
        '\u{1FDD}'...'\u{1FDF}' => No,
        '\u{1FE3}' => No,
        '\u{1FEB}' => No,
        '\u{1FED}'...'\u{1FEF}' => No,
        '\u{1FF9}' => No,
        '\u{1FFB}' => No,
        '\u{1FFD}'...'\u{1FFE}' => No,
        '\u{2000}'...'\u{200A}' => No,
        '\u{2011}' => No,
        '\u{2017}' => No,
        '\u{2024}'...'\u{2026}' => No,
        '\u{202F}' => No,
        '\u{2033}'...'\u{2034}' => No,
        '\u{2036}'...'\u{2037}' => No,
        '\u{203C}' => No,
        '\u{203E}' => No,
        '\u{2047}'...'\u{2049}' => No,
        '\u{2057}' => No,
        '\u{205F}' => No,
        '\u{2070}' => No,
        '\u{2071}' => No,
        '\u{2074}'...'\u{2079}' => No,
        '\u{207A}'...'\u{207C}' => No,
        '\u{207D}' => No,
        '\u{207E}' => No,
        '\u{207F}' => No,
        '\u{2080}'...'\u{2089}' => No,
        '\u{208A}'...'\u{208C}' => No,
        '\u{208D}' => No,
        '\u{208E}' => No,
        '\u{2090}'...'\u{209C}' => No,
        '\u{20A8}' => No,
        '\u{2100}'...'\u{2101}' => No,
        '\u{2102}' => No,
        '\u{2103}' => No,
        '\u{2105}'...'\u{2106}' => No,
        '\u{2107}' => No,
        '\u{2109}' => No,
        '\u{210A}'...'\u{2113}' => No,
        '\u{2115}' => No,
        '\u{2116}' => No,
        '\u{2119}'...'\u{211D}' => No,
        '\u{2120}'...'\u{2122}' => No,
        '\u{2124}' => No,
        '\u{2126}' => No,
        '\u{2128}' => No,
        '\u{212A}'...'\u{212D}' => No,
        '\u{212F}'...'\u{2131}' => No,
        '\u{2133}'...'\u{2134}' => No,
        '\u{2135}'...'\u{2138}' => No,
        '\u{2139}' => No,
        '\u{213B}' => No,
        '\u{213C}'...'\u{213F}' => No,
        '\u{2140}' => No,
        '\u{2145}'...'\u{2149}' => No,
        '\u{2150}'...'\u{215F}' => No,
        '\u{2160}'...'\u{217F}' => No,
        '\u{2189}' => No,
        '\u{222C}'...'\u{222D}' => No,
        '\u{222F}'...'\u{2230}' => No,
        '\u{2329}' => No,
        '\u{232A}' => No,
        '\u{2460}'...'\u{249B}' => No,
        '\u{249C}'...'\u{24E9}' => No,
        '\u{24EA}' => No,
        '\u{2A0C}' => No,
        '\u{2A74}'...'\u{2A76}' => No,
        '\u{2ADC}' => No,
        '\u{2C7C}'...'\u{2C7D}' => No,
        '\u{2D6F}' => No,
        '\u{2E9F}' => No,
        '\u{2EF3}' => No,
        '\u{2F00}'...'\u{2FD5}' => No,
        '\u{3000}' => No,
        '\u{3036}' => No,
        '\u{3038}'...'\u{303A}' => No,
        '\u{309B}'...'\u{309C}' => No,
        '\u{309F}' => No,
        '\u{30FF}' => No,
        '\u{3131}'...'\u{318E}' => No,
        '\u{3192}'...'\u{3195}' => No,
        '\u{3196}'...'\u{319F}' => No,
        '\u{3200}'...'\u{321E}' => No,
        '\u{3220}'...'\u{3229}' => No,
        '\u{322A}'...'\u{3247}' => No,
        '\u{3250}' => No,
        '\u{3251}'...'\u{325F}' => No,
        '\u{3260}'...'\u{327E}' => No,
        '\u{3280}'...'\u{3289}' => No,
        '\u{328A}'...'\u{32B0}' => No,
        '\u{32B1}'...'\u{32BF}' => No,
        '\u{32C0}'...'\u{32FE}' => No,
        '\u{3300}'...'\u{33FF}' => No,
        '\u{A69C}'...'\u{A69D}' => No,
        '\u{A770}' => No,
        '\u{A7F8}'...'\u{A7F9}' => No,
        '\u{AB5C}'...'\u{AB5F}' => No,
        '\u{F900}'...'\u{FA0D}' => No,
        '\u{FA10}' => No,
        '\u{FA12}' => No,
        '\u{FA15}'...'\u{FA1E}' => No,
        '\u{FA20}' => No,
        '\u{FA22}' => No,
        '\u{FA25}'...'\u{FA26}' => No,
        '\u{FA2A}'...'\u{FA6D}' => No,
        '\u{FA70}'...'\u{FAD9}' => No,
        '\u{FB00}'...'\u{FB06}' => No,
        '\u{FB13}'...'\u{FB17}' => No,
        '\u{FB1D}' => No,
        '\u{FB1F}'...'\u{FB28}' => No,
        '\u{FB29}' => No,
        '\u{FB2A}'...'\u{FB36}' => No,
        '\u{FB38}'...'\u{FB3C}' => No,
        '\u{FB3E}' => No,
        '\u{FB40}'...'\u{FB41}' => No,
        '\u{FB43}'...'\u{FB44}' => No,
        '\u{FB46}'...'\u{FBB1}' => No,
        '\u{FBD3}'...'\u{FD3D}' => No,
        '\u{FD50}'...'\u{FD8F}' => No,
        '\u{FD92}'...'\u{FDC7}' => No,
        '\u{FDF0}'...'\u{FDFB}' => No,
        '\u{FDFC}' => No,
        '\u{FE10}'...'\u{FE16}' => No,
        '\u{FE17}' => No,
        '\u{FE18}' => No,
        '\u{FE19}' => No,
        '\u{FE30}' => No,
        '\u{FE31}'...'\u{FE32}' => No,
        '\u{FE33}'...'\u{FE34}' => No,
        '\u{FE35}' => No,
        '\u{FE36}' => No,
        '\u{FE37}' => No,
        '\u{FE38}' => No,
        '\u{FE39}' => No,
        '\u{FE3A}' => No,
        '\u{FE3B}' => No,
        '\u{FE3C}' => No,
        '\u{FE3D}' => No,
        '\u{FE3E}' => No,
        '\u{FE3F}' => No,
        '\u{FE40}' => No,
        '\u{FE41}' => No,
        '\u{FE42}' => No,
        '\u{FE43}' => No,
        '\u{FE44}' => No,
        '\u{FE47}' => No,
        '\u{FE48}' => No,
        '\u{FE49}'...'\u{FE4C}' => No,
        '\u{FE4D}'...'\u{FE4F}' => No,
        '\u{FE50}'...'\u{FE52}' => No,
        '\u{FE54}'...'\u{FE57}' => No,
        '\u{FE58}' => No,
        '\u{FE59}' => No,
        '\u{FE5A}' => No,
        '\u{FE5B}' => No,
        '\u{FE5C}' => No,
        '\u{FE5D}' => No,
        '\u{FE5E}' => No,
        '\u{FE5F}'...'\u{FE61}' => No,
        '\u{FE62}' => No,
        '\u{FE63}' => No,
        '\u{FE64}'...'\u{FE66}' => No,
        '\u{FE68}' => No,
        '\u{FE69}' => No,
        '\u{FE6A}'...'\u{FE6B}' => No,
        '\u{FE70}'...'\u{FE72}' => No,
        '\u{FE74}' => No,
        '\u{FE76}'...'\u{FEFC}' => No,
        '\u{FF01}'...'\u{FF03}' => No,
        '\u{FF04}' => No,
        '\u{FF05}'...'\u{FF07}' => No,
        '\u{FF08}' => No,
        '\u{FF09}' => No,
        '\u{FF0A}' => No,
        '\u{FF0B}' => No,
        '\u{FF0C}' => No,
        '\u{FF0D}' => No,
        '\u{FF0E}'...'\u{FF0F}' => No,
        '\u{FF10}'...'\u{FF19}' => No,
        '\u{FF1A}'...'\u{FF1B}' => No,
        '\u{FF1C}'...'\u{FF1E}' => No,
        '\u{FF1F}'...'\u{FF20}' => No,
        '\u{FF21}'...'\u{FF3A}' => No,
        '\u{FF3B}' => No,
        '\u{FF3C}' => No,
        '\u{FF3D}' => No,
        '\u{FF3E}' => No,
        '\u{FF3F}' => No,
        '\u{FF40}' => No,
        '\u{FF41}'...'\u{FF5A}' => No,
        '\u{FF5B}' => No,
        '\u{FF5C}' => No,
        '\u{FF5D}' => No,
        '\u{FF5E}' => No,
        '\u{FF5F}' => No,
        '\u{FF60}' => No,
        '\u{FF61}' => No,
        '\u{FF62}' => No,
        '\u{FF63}' => No,
        '\u{FF64}'...'\u{FF65}' => No,
        '\u{FF66}'...'\u{FF6F}' => No,
        '\u{FF70}' => No,
        '\u{FF71}'...'\u{FF9D}' => No,
        '\u{FF9E}'...'\u{FF9F}' => No,
        '\u{FFA0}'...'\u{FFBE}' => No,
        '\u{FFC2}'...'\u{FFC7}' => No,
        '\u{FFCA}'...'\u{FFCF}' => No,
        '\u{FFD2}'...'\u{FFD7}' => No,
        '\u{FFDA}'...'\u{FFDC}' => No,
        '\u{FFE0}'...'\u{FFE1}' => No,
        '\u{FFE2}' => No,
        '\u{FFE3}' => No,
        '\u{FFE4}' => No,
        '\u{FFE5}'...'\u{FFE6}' => No,
        '\u{FFE8}' => No,
        '\u{FFE9}'...'\u{FFEC}' => No,
        '\u{FFED}'...'\u{FFEE}' => No,
        '\u{1D15E}'...'\u{1D164}' => No,
        '\u{1D1BB}'...'\u{1D1C0}' => No,
        '\u{1D400}'...'\u{1D454}' => No,
        '\u{1D456}'...'\u{1D49C}' => No,
        '\u{1D49E}'...'\u{1D49F}' => No,
        '\u{1D4A2}' => No,
        '\u{1D4A5}'...'\u{1D4A6}' => No,
        '\u{1D4A9}'...'\u{1D4AC}' => No,
        '\u{1D4AE}'...'\u{1D4B9}' => No,
        '\u{1D4BB}' => No,
        '\u{1D4BD}'...'\u{1D4C3}' => No,
        '\u{1D4C5}'...'\u{1D505}' => No,
        '\u{1D507}'...'\u{1D50A}' => No,
        '\u{1D50D}'...'\u{1D514}' => No,
        '\u{1D516}'...'\u{1D51C}' => No,
        '\u{1D51E}'...'\u{1D539}' => No,
        '\u{1D53B}'...'\u{1D53E}' => No,
        '\u{1D540}'...'\u{1D544}' => No,
        '\u{1D546}' => No,
        '\u{1D54A}'...'\u{1D550}' => No,
        '\u{1D552}'...'\u{1D6A5}' => No,
        '\u{1D6A8}'...'\u{1D6C0}' => No,
        '\u{1D6C1}' => No,
        '\u{1D6C2}'...'\u{1D6DA}' => No,
        '\u{1D6DB}' => No,
        '\u{1D6DC}'...'\u{1D6FA}' => No,
        '\u{1D6FB}' => No,
        '\u{1D6FC}'...'\u{1D714}' => No,
        '\u{1D715}' => No,
        '\u{1D716}'...'\u{1D734}' => No,
        '\u{1D735}' => No,
        '\u{1D736}'...'\u{1D74E}' => No,
        '\u{1D74F}' => No,
        '\u{1D750}'...'\u{1D76E}' => No,
        '\u{1D76F}' => No,
        '\u{1D770}'...'\u{1D788}' => No,
        '\u{1D789}' => No,
        '\u{1D78A}'...'\u{1D7A8}' => No,
        '\u{1D7A9}' => No,
        '\u{1D7AA}'...'\u{1D7C2}' => No,
        '\u{1D7C3}' => No,
        '\u{1D7C4}'...'\u{1D7CB}' => No,
        '\u{1D7CE}'...'\u{1D7FF}' => No,
        '\u{1EE00}'...'\u{1EE03}' => No,
        '\u{1EE05}'...'\u{1EE1F}' => No,
        '\u{1EE21}'...'\u{1EE22}' => No,
        '\u{1EE24}' => No,
        '\u{1EE27}' => No,
        '\u{1EE29}'...'\u{1EE32}' => No,
        '\u{1EE34}'...'\u{1EE37}' => No,
        '\u{1EE39}' => No,
        '\u{1EE3B}' => No,
        '\u{1EE42}' => No,
        '\u{1EE47}' => No,
        '\u{1EE49}' => No,
        '\u{1EE4B}' => No,
        '\u{1EE4D}'...'\u{1EE4F}' => No,
        '\u{1EE51}'...'\u{1EE52}' => No,
        '\u{1EE54}' => No,
        '\u{1EE57}' => No,
        '\u{1EE59}' => No,
        '\u{1EE5B}' => No,
        '\u{1EE5D}' => No,
        '\u{1EE5F}' => No,
        '\u{1EE61}'...'\u{1EE62}' => No,
        '\u{1EE64}' => No,
        '\u{1EE67}'...'\u{1EE6A}' => No,
        '\u{1EE6C}'...'\u{1EE72}' => No,
        '\u{1EE74}'...'\u{1EE77}' => No,
        '\u{1EE79}'...'\u{1EE7C}' => No,
        '\u{1EE7E}' => No,
        '\u{1EE80}'...'\u{1EE89}' => No,
        '\u{1EE8B}'...'\u{1EE9B}' => No,
        '\u{1EEA1}'...'\u{1EEA3}' => No,
        '\u{1EEA5}'...'\u{1EEA9}' => No,
        '\u{1EEAB}'...'\u{1EEBB}' => No,
        '\u{1F100}'...'\u{1F10A}' => No,
        '\u{1F110}'...'\u{1F12E}' => No,
        '\u{1F130}'...'\u{1F14F}' => No,
        '\u{1F16A}'...'\u{1F16B}' => No,
        '\u{1F190}' => No,
        '\u{1F200}'...'\u{1F202}' => No,
        '\u{1F210}'...'\u{1F23B}' => No,
        '\u{1F240}'...'\u{1F248}' => No,
        '\u{1F250}'...'\u{1F251}' => No,
        '\u{2F800}'...'\u{2FA1D}' => No,
        '\u{0300}'...'\u{0304}' => Maybe,
        '\u{0306}'...'\u{030C}' => Maybe,
        '\u{030F}' => Maybe,
        '\u{0311}' => Maybe,
        '\u{0313}'...'\u{0314}' => Maybe,
        '\u{031B}' => Maybe,
        '\u{0323}'...'\u{0328}' => Maybe,
        '\u{032D}'...'\u{032E}' => Maybe,
        '\u{0330}'...'\u{0331}' => Maybe,
        '\u{0338}' => Maybe,
        '\u{0342}' => Maybe,
        '\u{0345}' => Maybe,
        '\u{0653}'...'\u{0655}' => Maybe,
        '\u{093C}' => Maybe,
        '\u{09BE}' => Maybe,
        '\u{09D7}' => Maybe,
        '\u{0B3E}' => Maybe,
        '\u{0B56}' => Maybe,
        '\u{0B57}' => Maybe,
        '\u{0BBE}' => Maybe,
        '\u{0BD7}' => Maybe,
        '\u{0C56}' => Maybe,
        '\u{0CC2}' => Maybe,
        '\u{0CD5}'...'\u{0CD6}' => Maybe,
        '\u{0D3E}' => Maybe,
        '\u{0D57}' => Maybe,
        '\u{0DCA}' => Maybe,
        '\u{0DCF}' => Maybe,
        '\u{0DDF}' => Maybe,
        '\u{102E}' => Maybe,
        '\u{1161}'...'\u{1175}' => Maybe,
        '\u{11A8}'...'\u{11C2}' => Maybe,
        '\u{1B35}' => Maybe,
        '\u{3099}'...'\u{309A}' => Maybe,
        '\u{110BA}' => Maybe,
        '\u{11127}' => Maybe,
        '\u{1133E}' => Maybe,
        '\u{11357}' => Maybe,
        '\u{114B0}' => Maybe,
        '\u{114BA}' => Maybe,
        '\u{114BD}' => Maybe,
        '\u{115AF}' => Maybe,
        _ => Yes,
    }
}

#[inline]
#[allow(ellipsis_inclusive_range_patterns)]
pub fn qc_nfd(c: char) -> IsNormalized {
    match c {
        '\u{00C0}'...'\u{00C5}' => No,
        '\u{00C7}'...'\u{00CF}' => No,
        '\u{00D1}'...'\u{00D6}' => No,
        '\u{00D9}'...'\u{00DD}' => No,
        '\u{00E0}'...'\u{00E5}' => No,
        '\u{00E7}'...'\u{00EF}' => No,
        '\u{00F1}'...'\u{00F6}' => No,
        '\u{00F9}'...'\u{00FD}' => No,
        '\u{00FF}'...'\u{010F}' => No,
        '\u{0112}'...'\u{0125}' => No,
        '\u{0128}'...'\u{0130}' => No,
        '\u{0134}'...'\u{0137}' => No,
        '\u{0139}'...'\u{013E}' => No,
        '\u{0143}'...'\u{0148}' => No,
        '\u{014C}'...'\u{0151}' => No,
        '\u{0154}'...'\u{0165}' => No,
        '\u{0168}'...'\u{017E}' => No,
        '\u{01A0}'...'\u{01A1}' => No,
        '\u{01AF}'...'\u{01B0}' => No,
        '\u{01CD}'...'\u{01DC}' => No,
        '\u{01DE}'...'\u{01E3}' => No,
        '\u{01E6}'...'\u{01F0}' => No,
        '\u{01F4}'...'\u{01F5}' => No,
        '\u{01F8}'...'\u{021B}' => No,
        '\u{021E}'...'\u{021F}' => No,
        '\u{0226}'...'\u{0233}' => No,
        '\u{0340}'...'\u{0341}' => No,
        '\u{0343}'...'\u{0344}' => No,
        '\u{0374}' => No,
        '\u{037E}' => No,
        '\u{0385}' => No,
        '\u{0386}' => No,
        '\u{0387}' => No,
        '\u{0388}'...'\u{038A}' => No,
        '\u{038C}' => No,
        '\u{038E}'...'\u{0390}' => No,
        '\u{03AA}'...'\u{03B0}' => No,
        '\u{03CA}'...'\u{03CE}' => No,
        '\u{03D3}'...'\u{03D4}' => No,
        '\u{0400}'...'\u{0401}' => No,
        '\u{0403}' => No,
        '\u{0407}' => No,
        '\u{040C}'...'\u{040E}' => No,
        '\u{0419}' => No,
        '\u{0439}' => No,
        '\u{0450}'...'\u{0451}' => No,
        '\u{0453}' => No,
        '\u{0457}' => No,
        '\u{045C}'...'\u{045E}' => No,
        '\u{0476}'...'\u{0477}' => No,
        '\u{04C1}'...'\u{04C2}' => No,
        '\u{04D0}'...'\u{04D3}' => No,
        '\u{04D6}'...'\u{04D7}' => No,
        '\u{04DA}'...'\u{04DF}' => No,
        '\u{04E2}'...'\u{04E7}' => No,
        '\u{04EA}'...'\u{04F5}' => No,
        '\u{04F8}'...'\u{04F9}' => No,
        '\u{0622}'...'\u{0626}' => No,
        '\u{06C0}' => No,
        '\u{06C2}' => No,
        '\u{06D3}' => No,
        '\u{0929}' => No,
        '\u{0931}' => No,
        '\u{0934}' => No,
        '\u{0958}'...'\u{095F}' => No,
        '\u{09CB}'...'\u{09CC}' => No,
        '\u{09DC}'...'\u{09DD}' => No,
        '\u{09DF}' => No,
        '\u{0A33}' => No,
        '\u{0A36}' => No,
        '\u{0A59}'...'\u{0A5B}' => No,
        '\u{0A5E}' => No,
        '\u{0B48}' => No,
        '\u{0B4B}'...'\u{0B4C}' => No,
        '\u{0B5C}'...'\u{0B5D}' => No,
        '\u{0B94}' => No,
        '\u{0BCA}'...'\u{0BCC}' => No,
        '\u{0C48}' => No,
        '\u{0CC0}' => No,
        '\u{0CC7}'...'\u{0CC8}' => No,
        '\u{0CCA}'...'\u{0CCB}' => No,
        '\u{0D4A}'...'\u{0D4C}' => No,
        '\u{0DDA}' => No,
        '\u{0DDC}'...'\u{0DDE}' => No,
        '\u{0F43}' => No,
        '\u{0F4D}' => No,
        '\u{0F52}' => No,
        '\u{0F57}' => No,
        '\u{0F5C}' => No,
        '\u{0F69}' => No,
        '\u{0F73}' => No,
        '\u{0F75}'...'\u{0F76}' => No,
        '\u{0F78}' => No,
        '\u{0F81}' => No,
        '\u{0F93}' => No,
        '\u{0F9D}' => No,
        '\u{0FA2}' => No,
        '\u{0FA7}' => No,
        '\u{0FAC}' => No,
        '\u{0FB9}' => No,
        '\u{1026}' => No,
        '\u{1B06}' => No,
        '\u{1B08}' => No,
        '\u{1B0A}' => No,
        '\u{1B0C}' => No,
        '\u{1B0E}' => No,
        '\u{1B12}' => No,
        '\u{1B3B}' => No,
        '\u{1B3D}' => No,
        '\u{1B40}'...'\u{1B41}' => No,
        '\u{1B43}' => No,
        '\u{1E00}'...'\u{1E99}' => No,
        '\u{1E9B}' => No,
        '\u{1EA0}'...'\u{1EF9}' => No,
        '\u{1F00}'...'\u{1F15}' => No,
        '\u{1F18}'...'\u{1F1D}' => No,
        '\u{1F20}'...'\u{1F45}' => No,
        '\u{1F48}'...'\u{1F4D}' => No,
        '\u{1F50}'...'\u{1F57}' => No,
        '\u{1F59}' => No,
        '\u{1F5B}' => No,
        '\u{1F5D}' => No,
        '\u{1F5F}'...'\u{1F7D}' => No,
        '\u{1F80}'...'\u{1FB4}' => No,
        '\u{1FB6}'...'\u{1FBC}' => No,
        '\u{1FBE}' => No,
        '\u{1FC1}' => No,
        '\u{1FC2}'...'\u{1FC4}' => No,
        '\u{1FC6}'...'\u{1FCC}' => No,
        '\u{1FCD}'...'\u{1FCF}' => No,
        '\u{1FD0}'...'\u{1FD3}' => No,
        '\u{1FD6}'...'\u{1FDB}' => No,
        '\u{1FDD}'...'\u{1FDF}' => No,
        '\u{1FE0}'...'\u{1FEC}' => No,
        '\u{1FED}'...'\u{1FEF}' => No,
        '\u{1FF2}'...'\u{1FF4}' => No,
        '\u{1FF6}'...'\u{1FFC}' => No,
        '\u{1FFD}' => No,
        '\u{2000}'...'\u{2001}' => No,
        '\u{2126}' => No,
        '\u{212A}'...'\u{212B}' => No,
        '\u{219A}'...'\u{219B}' => No,
        '\u{21AE}' => No,
        '\u{21CD}' => No,
        '\u{21CE}'...'\u{21CF}' => No,
        '\u{2204}' => No,
        '\u{2209}' => No,
        '\u{220C}' => No,
        '\u{2224}' => No,
        '\u{2226}' => No,
        '\u{2241}' => No,
        '\u{2244}' => No,
        '\u{2247}' => No,
        '\u{2249}' => No,
        '\u{2260}' => No,
        '\u{2262}' => No,
        '\u{226D}'...'\u{2271}' => No,
        '\u{2274}'...'\u{2275}' => No,
        '\u{2278}'...'\u{2279}' => No,
        '\u{2280}'...'\u{2281}' => No,
        '\u{2284}'...'\u{2285}' => No,
        '\u{2288}'...'\u{2289}' => No,
        '\u{22AC}'...'\u{22AF}' => No,
        '\u{22E0}'...'\u{22E3}' => No,
        '\u{22EA}'...'\u{22ED}' => No,
        '\u{2329}' => No,
        '\u{232A}' => No,
        '\u{2ADC}' => No,
        '\u{304C}' => No,
        '\u{304E}' => No,
        '\u{3050}' => No,
        '\u{3052}' => No,
        '\u{3054}' => No,
        '\u{3056}' => No,
        '\u{3058}' => No,
        '\u{305A}' => No,
        '\u{305C}' => No,
        '\u{305E}' => No,
        '\u{3060}' => No,
        '\u{3062}' => No,
        '\u{3065}' => No,
        '\u{3067}' => No,
        '\u{3069}' => No,
        '\u{3070}'...'\u{3071}' => No,
        '\u{3073}'...'\u{3074}' => No,
        '\u{3076}'...'\u{3077}' => No,
        '\u{3079}'...'\u{307A}' => No,
        '\u{307C}'...'\u{307D}' => No,
        '\u{3094}' => No,
        '\u{309E}' => No,
        '\u{30AC}' => No,
        '\u{30AE}' => No,
        '\u{30B0}' => No,
        '\u{30B2}' => No,
        '\u{30B4}' => No,
        '\u{30B6}' => No,
        '\u{30B8}' => No,
        '\u{30BA}' => No,
        '\u{30BC}' => No,
        '\u{30BE}' => No,
        '\u{30C0}' => No,
        '\u{30C2}' => No,
        '\u{30C5}' => No,
        '\u{30C7}' => No,
        '\u{30C9}' => No,
        '\u{30D0}'...'\u{30D1}' => No,
        '\u{30D3}'...'\u{30D4}' => No,
        '\u{30D6}'...'\u{30D7}' => No,
        '\u{30D9}'...'\u{30DA}' => No,
        '\u{30DC}'...'\u{30DD}' => No,
        '\u{30F4}' => No,
        '\u{30F7}'...'\u{30FA}' => No,
        '\u{30FE}' => No,
        '\u{AC00}'...'\u{D7A3}' => No,
        '\u{F900}'...'\u{FA0D}' => No,
        '\u{FA10}' => No,
        '\u{FA12}' => No,
        '\u{FA15}'...'\u{FA1E}' => No,
        '\u{FA20}' => No,
        '\u{FA22}' => No,
        '\u{FA25}'...'\u{FA26}' => No,
        '\u{FA2A}'...'\u{FA6D}' => No,
        '\u{FA70}'...'\u{FAD9}' => No,
        '\u{FB1D}' => No,
        '\u{FB1F}' => No,
        '\u{FB2A}'...'\u{FB36}' => No,
        '\u{FB38}'...'\u{FB3C}' => No,
        '\u{FB3E}' => No,
        '\u{FB40}'...'\u{FB41}' => No,
        '\u{FB43}'...'\u{FB44}' => No,
        '\u{FB46}'...'\u{FB4E}' => No,
        '\u{1109A}' => No,
        '\u{1109C}' => No,
        '\u{110AB}' => No,
        '\u{1112E}'...'\u{1112F}' => No,
        '\u{1134B}'...'\u{1134C}' => No,
        '\u{114BB}'...'\u{114BC}' => No,
        '\u{114BE}' => No,
        '\u{115BA}'...'\u{115BB}' => No,
        '\u{1D15E}'...'\u{1D164}' => No,
        '\u{1D1BB}'...'\u{1D1C0}' => No,
        '\u{2F800}'...'\u{2FA1D}' => No,
        _ => Yes,
    }
}

#[inline]
#[allow(ellipsis_inclusive_range_patterns)]
pub fn qc_nfkd(c: char) -> IsNormalized {
    match c {
        '\u{00A0}' => No,
        '\u{00A8}' => No,
        '\u{00AA}' => No,
        '\u{00AF}' => No,
        '\u{00B2}'...'\u{00B3}' => No,
        '\u{00B4}' => No,
        '\u{00B5}' => No,
        '\u{00B8}' => No,
        '\u{00B9}' => No,
        '\u{00BA}' => No,
        '\u{00BC}'...'\u{00BE}' => No,
        '\u{00C0}'...'\u{00C5}' => No,
        '\u{00C7}'...'\u{00CF}' => No,
        '\u{00D1}'...'\u{00D6}' => No,
        '\u{00D9}'...'\u{00DD}' => No,
        '\u{00E0}'...'\u{00E5}' => No,
        '\u{00E7}'...'\u{00EF}' => No,
        '\u{00F1}'...'\u{00F6}' => No,
        '\u{00F9}'...'\u{00FD}' => No,
        '\u{00FF}'...'\u{010F}' => No,
        '\u{0112}'...'\u{0125}' => No,
        '\u{0128}'...'\u{0130}' => No,
        '\u{0132}'...'\u{0137}' => No,
        '\u{0139}'...'\u{0140}' => No,
        '\u{0143}'...'\u{0149}' => No,
        '\u{014C}'...'\u{0151}' => No,
        '\u{0154}'...'\u{0165}' => No,
        '\u{0168}'...'\u{017F}' => No,
        '\u{01A0}'...'\u{01A1}' => No,
        '\u{01AF}'...'\u{01B0}' => No,
        '\u{01C4}'...'\u{01DC}' => No,
        '\u{01DE}'...'\u{01E3}' => No,
        '\u{01E6}'...'\u{01F5}' => No,
        '\u{01F8}'...'\u{021B}' => No,
        '\u{021E}'...'\u{021F}' => No,
        '\u{0226}'...'\u{0233}' => No,
        '\u{02B0}'...'\u{02B8}' => No,
        '\u{02D8}'...'\u{02DD}' => No,
        '\u{02E0}'...'\u{02E4}' => No,
        '\u{0340}'...'\u{0341}' => No,
        '\u{0343}'...'\u{0344}' => No,
        '\u{0374}' => No,
        '\u{037A}' => No,
        '\u{037E}' => No,
        '\u{0384}'...'\u{0385}' => No,
        '\u{0386}' => No,
        '\u{0387}' => No,
        '\u{0388}'...'\u{038A}' => No,
        '\u{038C}' => No,
        '\u{038E}'...'\u{0390}' => No,
        '\u{03AA}'...'\u{03B0}' => No,
        '\u{03CA}'...'\u{03CE}' => No,
        '\u{03D0}'...'\u{03D6}' => No,
        '\u{03F0}'...'\u{03F2}' => No,
        '\u{03F4}'...'\u{03F5}' => No,
        '\u{03F9}' => No,
        '\u{0400}'...'\u{0401}' => No,
        '\u{0403}' => No,
        '\u{0407}' => No,
        '\u{040C}'...'\u{040E}' => No,
        '\u{0419}' => No,
        '\u{0439}' => No,
        '\u{0450}'...'\u{0451}' => No,
        '\u{0453}' => No,
        '\u{0457}' => No,
        '\u{045C}'...'\u{045E}' => No,
        '\u{0476}'...'\u{0477}' => No,
        '\u{04C1}'...'\u{04C2}' => No,
        '\u{04D0}'...'\u{04D3}' => No,
        '\u{04D6}'...'\u{04D7}' => No,
        '\u{04DA}'...'\u{04DF}' => No,
        '\u{04E2}'...'\u{04E7}' => No,
        '\u{04EA}'...'\u{04F5}' => No,
        '\u{04F8}'...'\u{04F9}' => No,
        '\u{0587}' => No,
        '\u{0622}'...'\u{0626}' => No,
        '\u{0675}'...'\u{0678}' => No,
        '\u{06C0}' => No,
        '\u{06C2}' => No,
        '\u{06D3}' => No,
        '\u{0929}' => No,
        '\u{0931}' => No,
        '\u{0934}' => No,
        '\u{0958}'...'\u{095F}' => No,
        '\u{09CB}'...'\u{09CC}' => No,
        '\u{09DC}'...'\u{09DD}' => No,
        '\u{09DF}' => No,
        '\u{0A33}' => No,
        '\u{0A36}' => No,
        '\u{0A59}'...'\u{0A5B}' => No,
        '\u{0A5E}' => No,
        '\u{0B48}' => No,
        '\u{0B4B}'...'\u{0B4C}' => No,
        '\u{0B5C}'...'\u{0B5D}' => No,
        '\u{0B94}' => No,
        '\u{0BCA}'...'\u{0BCC}' => No,
        '\u{0C48}' => No,
        '\u{0CC0}' => No,
        '\u{0CC7}'...'\u{0CC8}' => No,
        '\u{0CCA}'...'\u{0CCB}' => No,
        '\u{0D4A}'...'\u{0D4C}' => No,
        '\u{0DDA}' => No,
        '\u{0DDC}'...'\u{0DDE}' => No,
        '\u{0E33}' => No,
        '\u{0EB3}' => No,
        '\u{0EDC}'...'\u{0EDD}' => No,
        '\u{0F0C}' => No,
        '\u{0F43}' => No,
        '\u{0F4D}' => No,
        '\u{0F52}' => No,
        '\u{0F57}' => No,
        '\u{0F5C}' => No,
        '\u{0F69}' => No,
        '\u{0F73}' => No,
        '\u{0F75}'...'\u{0F79}' => No,
        '\u{0F81}' => No,
        '\u{0F93}' => No,
        '\u{0F9D}' => No,
        '\u{0FA2}' => No,
        '\u{0FA7}' => No,
        '\u{0FAC}' => No,
        '\u{0FB9}' => No,
        '\u{1026}' => No,
        '\u{10FC}' => No,
        '\u{1B06}' => No,
        '\u{1B08}' => No,
        '\u{1B0A}' => No,
        '\u{1B0C}' => No,
        '\u{1B0E}' => No,
        '\u{1B12}' => No,
        '\u{1B3B}' => No,
        '\u{1B3D}' => No,
        '\u{1B40}'...'\u{1B41}' => No,
        '\u{1B43}' => No,
        '\u{1D2C}'...'\u{1D2E}' => No,
        '\u{1D30}'...'\u{1D3A}' => No,
        '\u{1D3C}'...'\u{1D4D}' => No,
        '\u{1D4F}'...'\u{1D6A}' => No,
        '\u{1D78}' => No,
        '\u{1D9B}'...'\u{1DBF}' => No,
        '\u{1E00}'...'\u{1E9B}' => No,
        '\u{1EA0}'...'\u{1EF9}' => No,
        '\u{1F00}'...'\u{1F15}' => No,
        '\u{1F18}'...'\u{1F1D}' => No,
        '\u{1F20}'...'\u{1F45}' => No,
        '\u{1F48}'...'\u{1F4D}' => No,
        '\u{1F50}'...'\u{1F57}' => No,
        '\u{1F59}' => No,
        '\u{1F5B}' => No,
        '\u{1F5D}' => No,
        '\u{1F5F}'...'\u{1F7D}' => No,
        '\u{1F80}'...'\u{1FB4}' => No,
        '\u{1FB6}'...'\u{1FBC}' => No,
        '\u{1FBD}' => No,
        '\u{1FBE}' => No,
        '\u{1FBF}'...'\u{1FC1}' => No,
        '\u{1FC2}'...'\u{1FC4}' => No,
        '\u{1FC6}'...'\u{1FCC}' => No,
        '\u{1FCD}'...'\u{1FCF}' => No,
        '\u{1FD0}'...'\u{1FD3}' => No,
        '\u{1FD6}'...'\u{1FDB}' => No,
        '\u{1FDD}'...'\u{1FDF}' => No,
        '\u{1FE0}'...'\u{1FEC}' => No,
        '\u{1FED}'...'\u{1FEF}' => No,
        '\u{1FF2}'...'\u{1FF4}' => No,
        '\u{1FF6}'...'\u{1FFC}' => No,
        '\u{1FFD}'...'\u{1FFE}' => No,
        '\u{2000}'...'\u{200A}' => No,
        '\u{2011}' => No,
        '\u{2017}' => No,
        '\u{2024}'...'\u{2026}' => No,
        '\u{202F}' => No,
        '\u{2033}'...'\u{2034}' => No,
        '\u{2036}'...'\u{2037}' => No,
        '\u{203C}' => No,
        '\u{203E}' => No,
        '\u{2047}'...'\u{2049}' => No,
        '\u{2057}' => No,
        '\u{205F}' => No,
        '\u{2070}' => No,
        '\u{2071}' => No,
        '\u{2074}'...'\u{2079}' => No,
        '\u{207A}'...'\u{207C}' => No,
        '\u{207D}' => No,
        '\u{207E}' => No,
        '\u{207F}' => No,
        '\u{2080}'...'\u{2089}' => No,
        '\u{208A}'...'\u{208C}' => No,
        '\u{208D}' => No,
        '\u{208E}' => No,
        '\u{2090}'...'\u{209C}' => No,
        '\u{20A8}' => No,
        '\u{2100}'...'\u{2101}' => No,
        '\u{2102}' => No,
        '\u{2103}' => No,
        '\u{2105}'...'\u{2106}' => No,
        '\u{2107}' => No,
        '\u{2109}' => No,
        '\u{210A}'...'\u{2113}' => No,
        '\u{2115}' => No,
        '\u{2116}' => No,
        '\u{2119}'...'\u{211D}' => No,
        '\u{2120}'...'\u{2122}' => No,
        '\u{2124}' => No,
        '\u{2126}' => No,
        '\u{2128}' => No,
        '\u{212A}'...'\u{212D}' => No,
        '\u{212F}'...'\u{2131}' => No,
        '\u{2133}'...'\u{2134}' => No,
        '\u{2135}'...'\u{2138}' => No,
        '\u{2139}' => No,
        '\u{213B}' => No,
        '\u{213C}'...'\u{213F}' => No,
        '\u{2140}' => No,
        '\u{2145}'...'\u{2149}' => No,
        '\u{2150}'...'\u{215F}' => No,
        '\u{2160}'...'\u{217F}' => No,
        '\u{2189}' => No,
        '\u{219A}'...'\u{219B}' => No,
        '\u{21AE}' => No,
        '\u{21CD}' => No,
        '\u{21CE}'...'\u{21CF}' => No,
        '\u{2204}' => No,
        '\u{2209}' => No,
        '\u{220C}' => No,
        '\u{2224}' => No,
        '\u{2226}' => No,
        '\u{222C}'...'\u{222D}' => No,
        '\u{222F}'...'\u{2230}' => No,
        '\u{2241}' => No,
        '\u{2244}' => No,
        '\u{2247}' => No,
        '\u{2249}' => No,
        '\u{2260}' => No,
        '\u{2262}' => No,
        '\u{226D}'...'\u{2271}' => No,
        '\u{2274}'...'\u{2275}' => No,
        '\u{2278}'...'\u{2279}' => No,
        '\u{2280}'...'\u{2281}' => No,
        '\u{2284}'...'\u{2285}' => No,
        '\u{2288}'...'\u{2289}' => No,
        '\u{22AC}'...'\u{22AF}' => No,
        '\u{22E0}'...'\u{22E3}' => No,
        '\u{22EA}'...'\u{22ED}' => No,
        '\u{2329}' => No,
        '\u{232A}' => No,
        '\u{2460}'...'\u{249B}' => No,
        '\u{249C}'...'\u{24E9}' => No,
        '\u{24EA}' => No,
        '\u{2A0C}' => No,
        '\u{2A74}'...'\u{2A76}' => No,
        '\u{2ADC}' => No,
        '\u{2C7C}'...'\u{2C7D}' => No,
        '\u{2D6F}' => No,
        '\u{2E9F}' => No,
        '\u{2EF3}' => No,
        '\u{2F00}'...'\u{2FD5}' => No,
        '\u{3000}' => No,
        '\u{3036}' => No,
        '\u{3038}'...'\u{303A}' => No,
        '\u{304C}' => No,
        '\u{304E}' => No,
        '\u{3050}' => No,
        '\u{3052}' => No,
        '\u{3054}' => No,
        '\u{3056}' => No,
        '\u{3058}' => No,
        '\u{305A}' => No,
        '\u{305C}' => No,
        '\u{305E}' => No,
        '\u{3060}' => No,
        '\u{3062}' => No,
        '\u{3065}' => No,
        '\u{3067}' => No,
        '\u{3069}' => No,
        '\u{3070}'...'\u{3071}' => No,
        '\u{3073}'...'\u{3074}' => No,
        '\u{3076}'...'\u{3077}' => No,
        '\u{3079}'...'\u{307A}' => No,
        '\u{307C}'...'\u{307D}' => No,
        '\u{3094}' => No,
        '\u{309B}'...'\u{309C}' => No,
        '\u{309E}' => No,
        '\u{309F}' => No,
        '\u{30AC}' => No,
        '\u{30AE}' => No,
        '\u{30B0}' => No,
        '\u{30B2}' => No,
        '\u{30B4}' => No,
        '\u{30B6}' => No,
        '\u{30B8}' => No,
        '\u{30BA}' => No,
        '\u{30BC}' => No,
        '\u{30BE}' => No,
        '\u{30C0}' => No,
        '\u{30C2}' => No,
        '\u{30C5}' => No,
        '\u{30C7}' => No,
        '\u{30C9}' => No,
        '\u{30D0}'...'\u{30D1}' => No,
        '\u{30D3}'...'\u{30D4}' => No,
        '\u{30D6}'...'\u{30D7}' => No,
        '\u{30D9}'...'\u{30DA}' => No,
        '\u{30DC}'...'\u{30DD}' => No,
        '\u{30F4}' => No,
        '\u{30F7}'...'\u{30FA}' => No,
        '\u{30FE}' => No,
        '\u{30FF}' => No,
        '\u{3131}'...'\u{318E}' => No,
        '\u{3192}'...'\u{3195}' => No,
        '\u{3196}'...'\u{319F}' => No,
        '\u{3200}'...'\u{321E}' => No,
        '\u{3220}'...'\u{3229}' => No,
        '\u{322A}'...'\u{3247}' => No,
        '\u{3250}' => No,
        '\u{3251}'...'\u{325F}' => No,
        '\u{3260}'...'\u{327E}' => No,
        '\u{3280}'...'\u{3289}' => No,
        '\u{328A}'...'\u{32B0}' => No,
        '\u{32B1}'...'\u{32BF}' => No,
        '\u{32C0}'...'\u{32FE}' => No,
        '\u{3300}'...'\u{33FF}' => No,
        '\u{A69C}'...'\u{A69D}' => No,
        '\u{A770}' => No,
        '\u{A7F8}'...'\u{A7F9}' => No,
        '\u{AB5C}'...'\u{AB5F}' => No,
        '\u{AC00}'...'\u{D7A3}' => No,
        '\u{F900}'...'\u{FA0D}' => No,
        '\u{FA10}' => No,
        '\u{FA12}' => No,
        '\u{FA15}'...'\u{FA1E}' => No,
        '\u{FA20}' => No,
        '\u{FA22}' => No,
        '\u{FA25}'...'\u{FA26}' => No,
        '\u{FA2A}'...'\u{FA6D}' => No,
        '\u{FA70}'...'\u{FAD9}' => No,
        '\u{FB00}'...'\u{FB06}' => No,
        '\u{FB13}'...'\u{FB17}' => No,
        '\u{FB1D}' => No,
        '\u{FB1F}'...'\u{FB28}' => No,
        '\u{FB29}' => No,
        '\u{FB2A}'...'\u{FB36}' => No,
        '\u{FB38}'...'\u{FB3C}' => No,
        '\u{FB3E}' => No,
        '\u{FB40}'...'\u{FB41}' => No,
        '\u{FB43}'...'\u{FB44}' => No,
        '\u{FB46}'...'\u{FBB1}' => No,
        '\u{FBD3}'...'\u{FD3D}' => No,
        '\u{FD50}'...'\u{FD8F}' => No,
        '\u{FD92}'...'\u{FDC7}' => No,
        '\u{FDF0}'...'\u{FDFB}' => No,
        '\u{FDFC}' => No,
        '\u{FE10}'...'\u{FE16}' => No,
        '\u{FE17}' => No,
        '\u{FE18}' => No,
        '\u{FE19}' => No,
        '\u{FE30}' => No,
        '\u{FE31}'...'\u{FE32}' => No,
        '\u{FE33}'...'\u{FE34}' => No,
        '\u{FE35}' => No,
        '\u{FE36}' => No,
        '\u{FE37}' => No,
        '\u{FE38}' => No,
        '\u{FE39}' => No,
        '\u{FE3A}' => No,
        '\u{FE3B}' => No,
        '\u{FE3C}' => No,
        '\u{FE3D}' => No,
        '\u{FE3E}' => No,
        '\u{FE3F}' => No,
        '\u{FE40}' => No,
        '\u{FE41}' => No,
        '\u{FE42}' => No,
        '\u{FE43}' => No,
        '\u{FE44}' => No,
        '\u{FE47}' => No,
        '\u{FE48}' => No,
        '\u{FE49}'...'\u{FE4C}' => No,
        '\u{FE4D}'...'\u{FE4F}' => No,
        '\u{FE50}'...'\u{FE52}' => No,
        '\u{FE54}'...'\u{FE57}' => No,
        '\u{FE58}' => No,
        '\u{FE59}' => No,
        '\u{FE5A}' => No,
        '\u{FE5B}' => No,
        '\u{FE5C}' => No,
        '\u{FE5D}' => No,
        '\u{FE5E}' => No,
        '\u{FE5F}'...'\u{FE61}' => No,
        '\u{FE62}' => No,
        '\u{FE63}' => No,
        '\u{FE64}'...'\u{FE66}' => No,
        '\u{FE68}' => No,
        '\u{FE69}' => No,
        '\u{FE6A}'...'\u{FE6B}' => No,
        '\u{FE70}'...'\u{FE72}' => No,
        '\u{FE74}' => No,
        '\u{FE76}'...'\u{FEFC}' => No,
        '\u{FF01}'...'\u{FF03}' => No,
        '\u{FF04}' => No,
        '\u{FF05}'...'\u{FF07}' => No,
        '\u{FF08}' => No,
        '\u{FF09}' => No,
        '\u{FF0A}' => No,
        '\u{FF0B}' => No,
        '\u{FF0C}' => No,
        '\u{FF0D}' => No,
        '\u{FF0E}'...'\u{FF0F}' => No,
        '\u{FF10}'...'\u{FF19}' => No,
        '\u{FF1A}'...'\u{FF1B}' => No,
        '\u{FF1C}'...'\u{FF1E}' => No,
        '\u{FF1F}'...'\u{FF20}' => No,
        '\u{FF21}'...'\u{FF3A}' => No,
        '\u{FF3B}' => No,
        '\u{FF3C}' => No,
        '\u{FF3D}' => No,
        '\u{FF3E}' => No,
        '\u{FF3F}' => No,
        '\u{FF40}' => No,
        '\u{FF41}'...'\u{FF5A}' => No,
        '\u{FF5B}' => No,
        '\u{FF5C}' => No,
        '\u{FF5D}' => No,
        '\u{FF5E}' => No,
        '\u{FF5F}' => No,
        '\u{FF60}' => No,
        '\u{FF61}' => No,
        '\u{FF62}' => No,
        '\u{FF63}' => No,
        '\u{FF64}'...'\u{FF65}' => No,
        '\u{FF66}'...'\u{FF6F}' => No,
        '\u{FF70}' => No,
        '\u{FF71}'...'\u{FF9D}' => No,
        '\u{FF9E}'...'\u{FF9F}' => No,
        '\u{FFA0}'...'\u{FFBE}' => No,
        '\u{FFC2}'...'\u{FFC7}' => No,
        '\u{FFCA}'...'\u{FFCF}' => No,
        '\u{FFD2}'...'\u{FFD7}' => No,
        '\u{FFDA}'...'\u{FFDC}' => No,
        '\u{FFE0}'...'\u{FFE1}' => No,
        '\u{FFE2}' => No,
        '\u{FFE3}' => No,
        '\u{FFE4}' => No,
        '\u{FFE5}'...'\u{FFE6}' => No,
        '\u{FFE8}' => No,
        '\u{FFE9}'...'\u{FFEC}' => No,
        '\u{FFED}'...'\u{FFEE}' => No,
        '\u{1109A}' => No,
        '\u{1109C}' => No,
        '\u{110AB}' => No,
        '\u{1112E}'...'\u{1112F}' => No,
        '\u{1134B}'...'\u{1134C}' => No,
        '\u{114BB}'...'\u{114BC}' => No,
        '\u{114BE}' => No,
        '\u{115BA}'...'\u{115BB}' => No,
        '\u{1D15E}'...'\u{1D164}' => No,
        '\u{1D1BB}'...'\u{1D1C0}' => No,
        '\u{1D400}'...'\u{1D454}' => No,
        '\u{1D456}'...'\u{1D49C}' => No,
        '\u{1D49E}'...'\u{1D49F}' => No,
        '\u{1D4A2}' => No,
        '\u{1D4A5}'...'\u{1D4A6}' => No,
        '\u{1D4A9}'...'\u{1D4AC}' => No,
        '\u{1D4AE}'...'\u{1D4B9}' => No,
        '\u{1D4BB}' => No,
        '\u{1D4BD}'...'\u{1D4C3}' => No,
        '\u{1D4C5}'...'\u{1D505}' => No,
        '\u{1D507}'...'\u{1D50A}' => No,
        '\u{1D50D}'...'\u{1D514}' => No,
        '\u{1D516}'...'\u{1D51C}' => No,
        '\u{1D51E}'...'\u{1D539}' => No,
        '\u{1D53B}'...'\u{1D53E}' => No,
        '\u{1D540}'...'\u{1D544}' => No,
        '\u{1D546}' => No,
        '\u{1D54A}'...'\u{1D550}' => No,
        '\u{1D552}'...'\u{1D6A5}' => No,
        '\u{1D6A8}'...'\u{1D6C0}' => No,
        '\u{1D6C1}' => No,
        '\u{1D6C2}'...'\u{1D6DA}' => No,
        '\u{1D6DB}' => No,
        '\u{1D6DC}'...'\u{1D6FA}' => No,
        '\u{1D6FB}' => No,
        '\u{1D6FC}'...'\u{1D714}' => No,
        '\u{1D715}' => No,
        '\u{1D716}'...'\u{1D734}' => No,
        '\u{1D735}' => No,
        '\u{1D736}'...'\u{1D74E}' => No,
        '\u{1D74F}' => No,
        '\u{1D750}'...'\u{1D76E}' => No,
        '\u{1D76F}' => No,
        '\u{1D770}'...'\u{1D788}' => No,
        '\u{1D789}' => No,
        '\u{1D78A}'...'\u{1D7A8}' => No,
        '\u{1D7A9}' => No,
        '\u{1D7AA}'...'\u{1D7C2}' => No,
        '\u{1D7C3}' => No,
        '\u{1D7C4}'...'\u{1D7CB}' => No,
        '\u{1D7CE}'...'\u{1D7FF}' => No,
        '\u{1EE00}'...'\u{1EE03}' => No,
        '\u{1EE05}'...'\u{1EE1F}' => No,
        '\u{1EE21}'...'\u{1EE22}' => No,
        '\u{1EE24}' => No,
        '\u{1EE27}' => No,
        '\u{1EE29}'...'\u{1EE32}' => No,
        '\u{1EE34}'...'\u{1EE37}' => No,
        '\u{1EE39}' => No,
        '\u{1EE3B}' => No,
        '\u{1EE42}' => No,
        '\u{1EE47}' => No,
        '\u{1EE49}' => No,
        '\u{1EE4B}' => No,
        '\u{1EE4D}'...'\u{1EE4F}' => No,
        '\u{1EE51}'...'\u{1EE52}' => No,
        '\u{1EE54}' => No,
        '\u{1EE57}' => No,
        '\u{1EE59}' => No,
        '\u{1EE5B}' => No,
        '\u{1EE5D}' => No,
        '\u{1EE5F}' => No,
        '\u{1EE61}'...'\u{1EE62}' => No,
        '\u{1EE64}' => No,
        '\u{1EE67}'...'\u{1EE6A}' => No,
        '\u{1EE6C}'...'\u{1EE72}' => No,
        '\u{1EE74}'...'\u{1EE77}' => No,
        '\u{1EE79}'...'\u{1EE7C}' => No,
        '\u{1EE7E}' => No,
        '\u{1EE80}'...'\u{1EE89}' => No,
        '\u{1EE8B}'...'\u{1EE9B}' => No,
        '\u{1EEA1}'...'\u{1EEA3}' => No,
        '\u{1EEA5}'...'\u{1EEA9}' => No,
        '\u{1EEAB}'...'\u{1EEBB}' => No,
        '\u{1F100}'...'\u{1F10A}' => No,
        '\u{1F110}'...'\u{1F12E}' => No,
        '\u{1F130}'...'\u{1F14F}' => No,
        '\u{1F16A}'...'\u{1F16B}' => No,
        '\u{1F190}' => No,
        '\u{1F200}'...'\u{1F202}' => No,
        '\u{1F210}'...'\u{1F23B}' => No,
        '\u{1F240}'...'\u{1F248}' => No,
        '\u{1F250}'...'\u{1F251}' => No,
        '\u{2F800}'...'\u{2FA1D}' => No,
        _ => Yes,
    }
}

#[inline]
pub fn stream_safe_leading_nonstarters(c: char) -> usize {
    match c {
        '\u{0340}' => 1,
        '\u{0341}' => 1,
        '\u{0343}' => 1,
        '\u{0344}' => 2,
        '\u{0F73}' => 2,
        '\u{0F75}' => 2,
        '\u{0F81}' => 2,
        '\u{FF9E}' => 1,
        '\u{FF9F}' => 1,
        _ => 0,
    }
}

pub(crate) const TRAILING_NONSTARTERS_SALT: &[u16] = &[
    0x1bb,
    0x0,
    0x8,
    0x162,
    0x0,
    0x5,
    0x0,
    0x75,
    0x4,
    0x0,
    0x0,
    0x5,
    0x18,
    0x2,
    0x0,
    0x1,
    0x90,
    0x0,
    0x2,
    0x5f,
    0xc6,
    0x0,
    0x0,
    0x20,
    0x0,
    0x0,
    0x0,
    0x6,
    0x0,
    0x39,
    0x0,
    0x0,
    0x48,
    0x3,
    0x0,
    0x95,
    0xaf,
    0x30,
    0x6f,
    0x0,
    0x0,
    0x4,
    0x8,
    0x10b,
    0x13,
    0x0,
    0x2f,
    0x16,
    0x6d,
    0x1,
    0x3,
    0xe,
    0x0,
    0x2c,
    0x83,
    0x37,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x2,
    0x0,
    0x1,
    0x0,
    0x6,
    0x2,
    0x46,
    0xa,
    0xb,
    0x16,
    0x4c,
    0x0,
    0x0,
    0x0,
    0xe,
    0x1,
    0x0,
    0x7,
    0xf,
    0x26,
    0x2,
    0xb,
    0xb,
    0x3,
    0x6,
    0x1a,
    0x0,
    0x1,
    0x6,
    0x5,
    0x5c,
    0x6,
    0x8,
    0x0,
    0x0,
    0x0,
    0x4,
    0x59,
    0x9,
    0x20,
    0x3,
    0x0,
    0x4,
    0x1a,
    0x1,
    0x0,
    0xb,
    0x0,
    0x0,
    0x0,
    0x0,
    0x23,
    0x2,
    0x8,
    0x0,
    0x0,
    0x0,
    0x1,
    0x29,
    0x1a,
    0x20,
    0x6,
    0x15,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x13,
    0x14,
    0x3,
    0x1,
    0x14,
    0x1,
    0x1,
    0x0,
    0x3,
    0x4,
    0x0,
    0x5,
    0x8,
    0x3,
    0x2,
    0x1c,
    0x5,
    0x1,
    0x0,
    0x17,
    0x0,
    0x0,
    0x1b,
    0x0,
    0x6,
    0x0,
    0x3a,
    0x0,
    0x23,
    0x3,
    0x0,
    0x0,
    0x0,
    0x0,
    0x5,
    0x1,
    0x0,
    0x0,
    0x16,
    0x2d,
    0x3,
    0x1,
    0x4,
    0x14,
    0x0,
    0x0,
    0x16,
    0x2,
    0x3,
    0x9,
    0x0,
    0x56,
    0x0,
    0xd,
    0x0,
    0x4,
    0xd,
    0x0,
    0x2,
    0x10,
    0x0,
    0x0,
    0x0,
    0x3,
    0x23,
    0x0,
    0x0,
    0x0,
    0x6,
    0x13,
    0x10,
    0xd,
    0x5c,
    0x0,
    0x9,
    0xe,
    0x5,
    0x1,
    0x0,
    0xc,
    0xd,
    0x1,
    0x4,
    0x1,
    0x2,
    0x13,
    0x0,
    0x0,
    0x1,
    0xc,
    0xb,
    0x6,
    0x0,
    0x0,
    0x0,
    0x0,
    0xc,
    0x0,
    0x7,
    0x0,
    0xf,
    0x0,
    0x5,
    0x4,
    0x4,
    0x3,
    0x2,
    0x4,
    0x1,
    0x11,
    0x11,
    0xc,
    0x5,
    0x6,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x2,
    0x2,
    0xc,
    0x0,
    0x0,
    0x11,
    0x6,
    0x0,
    0x0,
    0x0,
    0x4,
    0x8,
    0x0,
    0x0,
    0x2,
    0x12,
    0x9,
    0x1,
    0x0,
    0x3,
    0x9,
    0x0,
    0x0,
    0x3,
    0x9,
    0x0,
    0x0,
    0x1,
    0x0,
    0xc,
    0x0,
    0x4,
    0x0,
    0x0,
    0x0,
    0x9,
    0x2,
    0x2,
    0x8,
    0x0,
    0x0,
    0x5,
    0x13,
    0x7,
    0xc,
    0x0,
    0x9,
    0x1,
    0x3a,
    0x1,
    0x1,
    0x9,
    0x0,
    0x0,
    0x0,
    0x9,
    0x1,
    0x4,
    0x12,
    0x0,
    0x7,
    0x4,
    0x5,
    0x0,
    0x1,
    0x1,
    0x0,
    0x0,
    0x2,
    0x1,
    0x0,
    0x0,
    0x7,
    0x1,
    0x0,
    0x12,
    0x2,
    0x1,
    0x6,
    0x1a,
    0x4,
    0x6,
    0x0,
    0x0,
    0x1,
    0x0,
    0x9,
    0x3,
    0x1,
    0x0,
    0x1,
    0x0,
    0x0,
    0x2,
    0x0,
    0x5,
    0xb,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x0,
    0xb,
    0x0,
    0x0,
    0x5,
    0x0,
    0x0,
    0x8,
    0x0,
    0x5,
    0x0,
    0x0,
    0x5,
    0x4,
    0xa,
    0x0,
    0x0,
    0x9,
    0x0,
    0xa,
    0x5,
    0x8,
    0x1,
    0x0,
    0x1c,
    0x2,
    0x1,
    0x3,
    0x0,
    0x1a,
    0x9,
    0x1,
    0x0,
    0x0,
    0x0,
    0x3,
    0x1,
    0x3,
    0x0,
    0x5,
    0x4,
    0x4,
    0xe,
    0x0,
    0x9,
    0x1,
    0x8,
    0x2,
    0x0,
    0x0,
    0x4,
    0x3,
    0x0,
    0x4,
    0xf,
    0x1,
    0x0,
    0x2,
    0x3,
    0x6,
    0x0,
    0x0,
    0x2,
    0x0,
    0x10,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x3,
    0x0,
    0x1,
    0x0,
    0x0,
    0x4,
    0x0,
    0x7,
    0x2,
    0x5,
    0x1,
    0x6,
    0x0,
    0x4,
    0x3,
    0xa,
    0x1,
    0xa,
    0x1,
    0x0,
    0x7,
    0x2,
    0x0,
    0x3,
    0x0,
    0x0,
    0x2b,
    0x8,
    0x1,
    0x0,
    0xe,
    0xa,
    0x0,
    0xb,
    0x0,
    0x0,
    0x4,
    0x1,
    0xb,
    0x6,
    0x0,
    0x0,
    0x3,
    0x0,
    0x1,
    0x1,
    0x6,
    0x2,
    0x2,
    0x0,
    0x1,
    0x1e,
    0x5,
    0xa,
    0x5,
    0x7,
    0x9,
    0x0,
    0x0,
    0x0,
    0xa,
    0x3,
    0x0,
    0x0,
    0x4,
    0x0,
    0x5,
    0x4,
    0x4,
    0x0,
    0x1,
    0x0,
    0x2,
    0x0,
    0x8,
    0x1,
    0x5,
    0x6,
    0x1,
    0x0,
    0x1,
    0x1,
    0x0,
    0x4,
    0x6,
    0x1,
    0x1,
    0x0,
    0x3,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x3,
    0x0,
    0x9,
    0x1,
    0xb,
    0x0,
    0x1,
    0x0,
    0x6,
    0x1,
    0x2,
    0x3,
    0x4,
    0x2,
    0x1,
    0x1,
    0x0,
    0x8,
    0x1,
    0x2,
    0x0,
    0x0,
    0x3,
    0x0,
    0x5,
    0xa,
    0x4,
    0x1,
    0x0,
    0x1,
    0x3,
    0x1,
    0x8,
    0x0,
    0x1,
    0x2,
    0x1,
    0x0,
    0x2,
    0xc,
    0x2,
    0x2,
    0x8,
    0xd,
    0x1,
    0x1,
    0x3,
    0x0,
    0x2,
    0x0,
    0x1,
    0x1,
    0x0,
    0x6,
    0x4,
    0x0,
    0x0,
    0x8,
    0x6,
    0x1,
    0x0,
    0x0,
    0x2,
    0x1,
    0xb,
    0x3,
    0x8,
    0x5,
    0x3,
    0x0,
    0x0,
    0x0,
    0x2,
    0x7,
    0x1,
    0x5,
    0x0,
    0x0,
    0x3,
    0x1,
    0x4,
    0x0,
    0x0,
    0x0,
    0xd,
    0x0,
    0x2,
    0x0,
    0x2,
    0x0,
    0x1,
    0x0,
    0x1,
    0x1,
    0x4,
    0x8,
    0x0,
    0x3,
    0x1,
    0x0,
    0x7,
    0x0,
    0x1,
    0x2,
    0x0,
    0x3,
    0x0,
    0x7,
    0x0,
    0x1,
    0x1,
    0x9,
    0x2,
    0x1,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x3,
    0x0,
    0x2,
    0x0,
    0x1,
    0x4,
    0x2,
    0x1,
    0x1,
    0x0,
    0x0,
    0x0,
    0x5,
    0x0,
    0x0,
    0x2,
    0x2,
    0x0,
    0x0,
    0x1,
    0x0,
    0x7,
    0x6,
    0x3,
    0x0,
    0x1,
    0x1,
    0x2,
    0x7,
    0x2,
    0x0,
    0x3,
    0x0,
    0x5,
    0x3,
    0x2,
    0x0,
    0x1,
    0x2,
    0x1,
    0x2,
    0x3,
    0x1,
    0x0,
    0x3,
    0x1,
    0x2,
    0x1,
    0x0,
    0x0,
    0x6,
    0x5,
    0xa,
    0x1,
    0x0,
    0x0,
    0x0,
    0x1,
    0x2,
    0x3,
    0x1,
    0x0,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x1,
    0x3,
    0x2,
    0x2,
    0x1,
    0x1,
    0x0,
    0x1,
    0x0,
    0x0,
    0x6,
    0x1,
    0x0,
    0x3,
    0x1,
    0x1,
    0x1,
    0x1,
    0x0,
    0x8,
    0x0,
    0x4,
    0x5,
    0x0,
    0x0,
    0x2,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x1,
    0x2,
    0x9,
    0x3,
    0x0,
    0x4,
    0x1,
    0x1,
    0xc,
    0x1,
    0x1,
    0x0,
    0x3,
    0x0,
    0x0,
    0x2,
    0x1,
    0x2,
    0x0,
    0xa,
    0x9,
    0x0,
    0x0,
    0x4,
    0x0,
    0x0,
    0x0,
    0x4,
    0x0,
    0x8,
    0x0,
    0x8,
    0x2,
    0x5,
    0x6,
    0x3,
    0x1,
    0x0,
    0x6,
    0x0,
    0x6,
    0x0,
    0x2,
    0x1,
    0x0,
    0x2,
    0x4,
    0x0,
    0x7,
    0x3,
    0x0,
    0xb,
    0x1,
    0x0,
    0x4,
    0x3,
    0x1,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x6,
    0x6,
    0x2,
    0x1,
    0x2,
    0x1,
    0x9,
    0x0,
    0x0,
    0x0,
    0x8,
    0x12,
    0x0,
    0x9,
    0x0,
    0x1,
    0x3,
    0x0,
    0x7,
    0x0,
    0x2,
    0x1,
    0x1,
    0x3,
    0x2,
    0x1,
    0x2,
    0x0,
    0x2,
    0x1,
    0x0,
    0x1,
    0x0,
    0x3,
    0x1,
    0x3,
    0x5,
    0x1,
    0x0,
    0x3,
    0x7,
    0x4,
    0x1,
    0x0,
    0x1,
    0x6,
    0x3,
    0x1,
    0x0,
    0x4,
    0x2,
    0x0,
    0x1,
    0x2,
    0x1,
    0x1,
    0x0,
    0x0,
    0x3,
    0x0,
    0x2,
    0x0,
    0x7,
    0x1,
    0x1,
    0x0,
    0x4,
    0x3,
    0x3,
    0x4,
    0x6,
    0x0,
    0x3,
    0x0,
    0x1,
    0x3,
    0x3,
    0x2,
    0x3,
    0x1,
    0x0,
    0x0,
    0x8,
    0x0,
    0x2,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x2,
    0x0,
    0x0,
    0x2,
    0x3,
    0x1,
    0x2,
    0x3,
    0x3,
    0x2,
    0x0,
    0x1,
    0x0,
    0x0,
    0x2,
    0x3,
    0x0,
    0xe,
    0x4,
    0x5,
    0x3,
    0x0,
    0x0,
    0x3,
    0x7,
    0x1,
    0x7,
    0x1,
    0x0,
    0x2,
    0x0,
    0x3,
    0x3,
    0x2,
    0x3,
    0x3,
    0x5,
    0x1,
    0x4,
    0x3,
    0x0,
    0x0,
    0x0,
    0x2,
    0x1,
    0x0,
    0x3,
    0x6,
    0x0,
    0x3,
    0x1,
    0x0,
    0x2,
    0x2,
    0x6,
    0x3,
    0x6,
    0x4,
    0x3,
    0x0,
    0x0,
    0x2,
    0x0,
    0x3,
    0x0,
    0x1,
    0x1,
    0x2,
    0x2,
    0x4,
    0x1,
    0x2,
    0x1,
    0x0,
    0x8,
    0x1,
    0x1,
    0x2,
    0x0,
    0x0,
    0x3,
    0x1,
    0x7,
    0x6,
    0x3,
    0x9,
    0x0,
    0x0,
    0x1,
    0x0,
    0x5,
    0x4,
    0x0,
    0x0,
    0x0,
    0x3,
    0x6,
    0x0,
    0x1,
    0x4,
    0x8,
    0x0,
    0x0,
    0x5,
    0x0,
    0x3,
    0x3,
    0x1,
    0x4,
    0x1,
    0x0,
    0x1,
    0x0,
    0x4,
    0x0,
    0x0,
    0x1,
    0x0,
    0x2,
    0x2,
    0x0,
    0x0,
    0x2,
    0x1,
    0x4,
    0x0,
    0x0,
    0x0,
    0x1,
    0x1,
    0x1,
    0x0,
    0x3,
    0x1,
    0x3,
    0x1,
    0x0,
    0x0,
    0x3,
    0x1,
    0x0,
    0x2,
    0x0,
    0x1,
    0x0,
    0x1,
    0x1,
    0x2,
    0x1,
    0x1,
    0x0,
    0x2,
    0x1,
    0x3,
    0x4,
    0x0,
    0x3,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x1,
    0x1,
    0x0,
    0x5,
    0x0,
    0x0,
    0x1,
    0x3,
    0x0,
    0x0,
    0x1,
    0x0,
    0x0,
    0x2,
    0x1,
    0x5,
    0x0,
    0x4,
    0x2,
    0x1,
    0x4,
    0x3,
    0x1,
    0x0,
    0x1,
    0x2,
    0x4,
];
pub(crate) const TRAILING_NONSTARTERS_KV: &[u32] = &[
    0x4EE01,
    0x1E4B01,
    0x1F1D02,
    0x1E3C01,
    0x224901,
    0x1FB101,
    0x1E6902,
    0xFE8401,
    0x1E1A01,
    0x22901,
    0xFC6202,
    0xFE7101,
    0x1E5A01,
    0xEC01,
    0x15001,
    0x1E8901,
    0x21CF01,
    0x1F1101,
    0x1E5002,
    0x1E7201,
    0x1FB901,
    0x34301,
    0x1FD901,
    0x1FF801,
    0x1F8C03,
    0xDA01,
    0x1E5302,
    0x1FA203,
    0x1FC202,
    0x334E01,
    0x1F4502,
    0x12B01,
    0xFB4401,
    0x220401,
    0x13E01,
    0x12901,
    0x1E9301,
    0x1F001,
    0x307701,
    0xFE7D01,
    0x21B01,
    0x1EA802,
    0x1E6402,
    0x40301,
    0x95801,
    0x1E3902,
    0x30AC01,
    0x1F3502,
    0x4F501,
    0x1E7101,
    0x4E701,
    0x10801,
    0x334B01,
    0x14E01,
    0x1EC901,
    0x1FA02,
    0x4ED01,
    0x4EB01,
    0x21701,
    0x1FD001,
    0x14601,
    0x1D101,
    0x34101,
    0x1E3401,
    0x304C01,
    0xE901,
    0x1F9403,
    0x330701,
    0x1E4001,
    0x1E3601,
    0x1E3101,
    0x22AD01,
    0x1E0701,
    0x1F5202,
    0xF601,
    0x1FEB01,
    0x1EE501,
    0x1F7201,
    0x1EAF02,
    0x1F6D02,
    0x1E2201,
    0x1EEA02,
    0x1E4D02,
    0xA3301,
    0x4F901,
    0x17401,
    0x11D01,
    0xFB3601,
    0x305C01,
    0x12201,
    0x1F8802,
    0x1E5D02,
    0x1EC102,
    0x13D01,
    0x1EF102,
    0x30F401,
    0x40701,
    0x1FA802,
    0x1EB402,
    0x1E5801,
    0x1E0501,
    0xE001,
    0xFB3301,
    0xEB01,
    0xA5E01,
    0x1F3202,
    0x20A01,
    0x20801,
    0x1FF702,
    0x1FC901,
    0x228001,
    0xE401,
    0x1F2101,
    0x21CE01,
    0xCB01,
    0x1F9F03,
    0x14301,
    0x306701,
    0x1E601,
    0x1E4601,
    0x45D01,
    0x1E1001,
    0x1E4801,
    0x1FF402,
    0x30D701,
    0x22E301,
    0x1EB801,
    0x12C01,
    0x331E01,
    0x1F7001,
    0x1F5D02,
    0x21901,
    0x10D01,
    0x1FB402,
    0xA801,
    0x1FE801,
    0x15401,
    0x4D301,
    0xFC01,
    0x1EE401,
    0x1F0901,
    0x16B01,
    0x1E1201,
    0x1E2E02,
    0x4C201,
    0xFB1F01,
    0x1F5602,
    0x4DA01,
    0x1EC02,
    0x228801,
    0x1ECB01,
    0x16101,
    0x1E9101,
    0x1ECE01,
    0x1F8002,
    0x307401,
    0xFE4901,
    0x307101,
    0x1D16202,
    0x1FC001,
    0x3CB01,
    0x1FCF02,
    0x1FBF01,
    0x1FBD01,
    0xFB3501,
    0x1D15E01,
    0xFE7F01,
    0x22E01,
    0x1E7701,
    0xFBB001,
    0xE101,
    0x30B001,
    0x22EA01,
    0x1F3F02,
    0x1C601,
    0x1E1E01,
    0x9DC01,
    0x1F6302,
    0x1FC01,
    0x4D001,
    0x1FDE02,
    0x1E1301,
    0x1FCE02,
    0x4F101,
    0x228101,
    0x1F0101,
    0xFB1D01,
    0xDB01,
    0x1E8701,
    0x224101,
    0xFB3A01,
    0x40101,
    0x1FC402,
    0xFE7B01,
    0x30BA01,
    0xFBA501,
    0x30F701,
    0x1FF301,
    0x14C01,
    0x1D16302,
    0x15701,
    0x17801,
    0x1F7901,
    0x306201,
    0x1EAE02,
    0x30B801,
    0x1F2302,
    0x1F4D02,
    0x17C01,
    0x15601,
    0x22D02,
    0xFC9001,
    0x1E3B01,
    0x1E6A01,
    0x1EBE02,
    0x17301,
    0x22ED01,
    0x10E01,
    0x1E8A01,
    0x1F6B02,
    0x6C201,
    0xFEF901,
    0x1EB901,
    0x1EB102,
    0x1F5702,
    0x1F0D02,
    0x305A01,
    0x1FD702,
    0x30AE01,
    0x1E2001,
    0x17601,
    0xFB3401,
    0x1F8E03,
    0xFB4D01,
    0xFE8101,
    0x1E6101,
    0x1FE302,
    0x1D201,
    0x1FA403,
    0x1EE002,
    0x1F7A01,
    0xFB2F01,
    0x1F5502,
    0xFEFA01,
    0x1D602,
    0xFA01,
    0xFE8501,
    0x22F01,
    0x4DB01,
    0x1E5F01,
    0x1E2701,
    0x39002,
    0x41901,
    0x30F801,
    0x16C01,
    0x12401,
    0xC701,
    0x1F9503,
    0x228401,
    0x1E8C01,
    0xF7502,
    0x1FC301,
    0x1F7C01,
    0xFE7201,
    0x20C01,
    0xFB4901,
    0x1FBB01,
    0x10F01,
    0x1FB601,
    0x1F8902,
    0x1FF01,
    0x1F2402,
    0x1F5302,
    0x1E1702,
    0x1D802,
    0x309E01,
    0xFE7A01,
    0x305E01,
    0x226E01,
    0x1FE702,
    0x1EBF02,
    0x1F3801,
    0x1E3201,
    0x1FFB01,
    0x1E6B01,
    0x1F9D03,
    0x222401,
    0x201701,
    0xF7601,
    0x1FCC01,
    0x1FA002,
    0x1F7401,
    0x1F2C02,
    0x40D01,
    0x1EEE02,
    0x15C01,
    0xE301,
    0xCC01,
    0xFB3801,
    0x333201,
    0x1E7501,
    0x334001,
    0x11501,
    0x1E3001,
    0x34402,
    0x17701,
    0x1E9201,
    0x1E2D01,
    0xCA01,
    0x1E7D01,
    0x13001,
    0x1F6801,
    0x3AA01,
    0x309C01,
    0x1F4001,
    0x3AC01,
    0x1EBA01,
    0x43901,
    0xFB4C01,
    0x1E201,
    0x1109A01,
    0x1DB02,
    0x1E4101,
    0x1FE001,
    0xCE01,
    0x21F01,
    0x4DF01,
    0x47701,
    0x1F0302,
    0x3D401,
    0x23201,
    0x1E1101,
    0x1FD202,
    0x14401,
    0x1F4C02,
    0x1EF301,
    0x10C01,
    0x30D001,
    0x1E4C02,
    0x1E2C01,
    0x1F1C02,
    0xFC5F02,
    0x1FE101,
    0x1EC502,
    0x22801,
    0x22E101,
    0x1EC002,
    0xEA01,
    0x1E0802,
    0x95A01,
    0x1F8303,
    0x1EE302,
    0x306901,
    0x17101,
    0x1E1602,
    0x212B01,
    0x1E6001,
    0x22EC01,
    0x219B01,
    0x1E8F01,
    0x1F4302,
    0x4E501,
    0x1FA303,
    0x1F3C02,
    0x16D01,
    0x30BE01,
    0x1FA603,
    0x1E9601,
    0xFD01,
    0x1F0602,
    0x1ED402,
    0x1D502,
    0x1A001,
    0x222601,
    0x9DF01,
    0xFB3201,
    0xFB4701,
    0x1E6301,
    0x1DC02,
    0x1E4701,
    0x30BC01,
    0x1D1BB01,
    0x1FC702,
    0x1D1BC01,
    0x309B01,
    0xF7702,
    0xFF9E01,
    0x1EA702,
    0x95901,
    0xE501,
    0x30B601,
    0xFCF402,
    0x21601,
    0x4EA01,
    0x20501,
    0x4F001,
    0xC4801,
    0x14701,
    0x1EF801,
    0x1F5B02,
    0x1EA001,
    0xE201,
    0x1F9303,
    0x1F5901,
    0xFB4B01,
    0x1F3001,
    0x1E8401,
    0x62401,
    0x1F9703,
    0xDC01,
    0x1E8B01,
    0x1EDF02,
    0x3B002,
    0x1C401,
    0x1ED502,
    0x1F2901,
    0x1F7D01,
    0x1EE902,
    0x30DA01,
    0xD201,
    0x1F6A02,
    0x1EA402,
    0x1EB01,
    0xFEF801,
    0x93101,
    0x307601,
    0x1F0A02,
    0x1F2702,
    0x1FD601,
    0x3AB01,
    0x1E0101,
    0xFB2C02,
    0x11C01,
    0x203E01,
    0x16001,
    0x21001,
    0x1E0B01,
    0xFE8901,
    0x1E1C02,
    0x1E1801,
    0x1F9102,
    0x1E9501,
    0x11901,
    0x45C01,
    0x30DC01,
    0xFB2D02,
    0x22B02,
    0x2D901,
    0x1D001,
    0xDDA01,
    0x15D01,
    0x1E6E01,
    0x1EA602,
    0x1E4A01,
    0x1EDA02,
    0x306501,
    0x4F401,
    0x306001,
    0x110AB01,
    0x228501,
    0x1E8E01,
    0x227801,
    0x4F301,
    0x1F0502,
    0x1F7101,
    0x1E5C02,
    0xAF01,
    0x1EC302,
    0xFE8C01,
    0x1E8501,
    0x1F9802,
    0x1EA01,
    0xFB4801,
    0xC801,
    0xFE7901,
    0x62501,
    0x16501,
    0xF101,
    0x11601,
    0x1FDF02,
    0x1FEC01,
    0x1F3E02,
    0x331001,
    0xE701,
    0x1FB202,
    0x22601,
    0x6D301,
    0x1EAA02,
    0x1E1B01,
    0x12301,
    0x1F7701,
    0x1FAD03,
    0x1EDC02,
    0x11401,
    0x1F8B03,
    0x14501,
    0x1FBC01,
    0x1E7902,
    0x95F01,
    0x1F2801,
    0xDDD01,
    0x1FFA01,
    0x1CD01,
    0xFE4A01,
    0xFE7E01,
    0x1AF01,
    0x17E01,
    0x1F8603,
    0x227401,
    0x1FB301,
    0x13401,
    0xFB4A01,
    0x1F2502,
    0x1FD302,
    0x1F21301,
    0x20B01,
    0x38C01,
    0xFE8701,
    0x1F3101,
    0x1F1402,
    0x1E1F01,
    0x1FB02,
    0x1E7E01,
    0x1E0201,
    0xFE4B01,
    0xD901,
    0x1F0001,
    0xF7302,
    0xC501,
    0x4E401,
    0xFCF302,
    0x1F5101,
    0x1FE601,
    0x30C001,
    0x4F801,
    0x12801,
    0x1EB202,
    0x1E0A01,
    0x1E0C01,
    0x1E4401,
    0xEE01,
    0x30C201,
    0x16F01,
    0x1EA502,
    0x30FA01,
    0x1EB502,
    0x1D1BE02,
    0x22E001,
    0x22E201,
    0x1D1C002,
    0x1EC402,
    0x1F6702,
    0x30FE01,
    0x1F3402,
    0xFE7001,
    0x1E2101,
    0x1F5F02,
    0x220C01,
    0x1D902,
    0x1E0601,
    0x13B01,
    0x1ED802,
    0x1EEB02,
    0xC201,
    0x45001,
    0x1FDD02,
    0x1E7601,
    0x1D16402,
    0x1B001,
    0x20401,
    0x11201,
    0x21301,
    0x3D301,
    0x1EC202,
    0x1EAB02,
    0x1FAE03,
    0x1EE01,
    0x1ED602,
    0x1E3701,
    0x309401,
    0xD401,
    0x1E5E01,
    0x1E0D01,
    0x30D601,
    0x1ED702,
    0x1F5001,
    0x1D401,
    0x1FFD01,
    0xFB3C01,
    0x1E8D01,
    0x21501,
    0x3AF01,
    0x224701,
    0x1ECA01,
    0x305801,
    0x1E7F01,
    0x22AC01,
    0x15B01,
    0x4D601,
    0x17A01,
    0x1ED02,
    0x1E6702,
    0x1E2801,
    0x20D01,
    0x1EBD01,
    0x1FD01,
    0xFB2E01,
    0x1E4501,
    0x1EF701,
    0x45E01,
    0x1F3B02,
    0x20001,
    0x1FCD02,
    0x38502,
    0x13601,
    0x20301,
    0x21201,
    0x1E9B01,
    0x1F401,
    0x1E8001,
    0x1FC102,
    0x1F7601,
    0x3CA01,
    0x16301,
    0x1FCB01,
    0x95C01,
    0x21101,
    0x1EF901,
    0x1E7B02,
    0x1E901,
    0x1E1D02,
    0x1EDE02,
    0x15F01,
    0x1F6402,
    0x10001,
    0x20F01,
    0x1E6602,
    0x40E01,
    0x38E01,
    0x1F0801,
    0x11801,
    0xFB3101,
    0x1D702,
    0x1ED102,
    0x305201,
    0x1E2A01,
    0x227001,
    0x1F8503,
    0x1FFE01,
    0x1EF002,
    0x4DD01,
    0x95D01,
    0x1F6502,
    0xF401,
    0x4D701,
    0x38601,
    0x2D801,
    0x1EC801,
    0x45701,
    0xFF01,
    0x22AF01,
    0x1EBC01,
    0x11E01,
    0x45301,
    0xFE7801,
    0x21E01,
    0xB5D01,
    0x12A01,
    0xF501,
    0xD301,
    0x1E6502,
    0x21A01,
    0x1F6E02,
    0x1FB001,
    0x62201,
    0x333B01,
    0x30D301,
    0x1EA101,
    0x226F01,
    0x1E0E01,
    0x15E01,
    0x1FF202,
    0x21801,
    0x1F8203,
    0x20901,
    0x1FD101,
    0x2DB01,
    0xF201,
    0xF7902,
    0xA5A01,
    0x1F0E02,
    0x1F1801,
    0x307C01,
    0xFC5C01,
    0x2ADC01,
    0xE801,
    0x15801,
    0x1FDB01,
    0x1F6C02,
    0x1EB002,
    0x1E2301,
    0x1F1502,
    0x11F01,
    0xFC6002,
    0x1FA902,
    0x1E5501,
    0x23102,
    0x1FE01,
    0x1E3D01,
    0x21AE01,
    0xFD3C01,
    0x38401,
    0x1EE701,
    0x13701,
    0xFB3001,
    0xEF01,
    0x1FA703,
    0x10A01,
    0x1F2B02,
    0x1D16002,
    0xF901,
    0xFEF501,
    0x40C01,
    0x22A02,
    0xF301,
    0x12D01,
    0x1F9A03,
    0x1E4201,
    0x1E102,
    0xA5B01,
    0x1EAC02,
    0x1E1502,
    0x1F9E03,
    0x1FD801,
    0x1F4A02,
    0x20201,
    0x1E9801,
    0x1E2401,
    0x1EE601,
    0x304E01,
    0x1E6C01,
    0xFE8A01,
    0xFB4001,
    0x1F2D02,
    0xFD3D01,
    0x1FC801,
    0x1FB801,
    0x1F3D02,
    0x1EF501,
    0x13901,
    0x1E8101,
    0x1F9C03,
    0x10301,
    0xA5901,
    0x1F9002,
    0x1ED902,
    0x1EF201,
    0x4E301,
    0xFEF701,
    0x1ECD01,
    0x11A01,
    0xFB2A01,
    0x1E301,
    0x1F6602,
    0x1FB702,
    0x1E2501,
    0x30C701,
    0x1F8102,
    0xCF01,
    0x1EEF02,
    0x1E9701,
    0x1F6F02,
    0x1F2A02,
    0x10901,
    0x1E5601,
    0x1E0001,
    0xFB4E01,
    0x1FC601,
    0xC001,
    0x220901,
    0xFE8801,
    0x1CE01,
    0xED01,
    0x15901,
    0x15A01,
    0x37A01,
    0x227501,
    0xD501,
    0x4C101,
    0x1E1901,
    0x30D101,
    0x10701,
    0x1FAC03,
    0x1EA301,
    0x1F2E02,
    0x14D01,
    0x1F4901,
    0x1E8801,
    0x1EB302,
    0x20701,
    0x1F7801,
    0x1F8D03,
    0xFBA401,
    0x1F9902,
    0x38801,
    0x1F2001,
    0xFB4101,
    0x1EC602,
    0x40001,
    0x1EB602,
    0x1E2B01,
    0x1E3A01,
    0x1C501,
    0x16201,
    0x17D01,
    0x1E8201,
    0x1F1B02,
    0x17001,
    0x224401,
    0x23301,
    0x1E2601,
    0x1F3302,
    0x10401,
    0x30D901,
    0x30F901,
    0x1F8A03,
    0x93401,
    0x3CD01,
    0x1FFC01,
    0x10101,
    0x1F5402,
    0xFB4601,
    0x3AD01,
    0x1F0402,
    0x1FF601,
    0x30B201,
    0x1F1001,
    0x1E7301,
    0x20E01,
    0x1E0301,
    0x1F6901,
    0xFEF601,
    0x95B01,
    0x227101,
    0x22701,
    0x1E3501,
    0x34001,
    0x1F0B02,
    0x1E701,
    0x1ED302,
    0x1F8403,
    0x1F2F02,
    0x1E8301,
    0x1F6001,
    0x62301,
    0xFC5D01,
    0x226001,
    0x22C02,
    0x1E3F01,
    0x1F7501,
    0x226201,
    0x1FDA01,
    0x20601,
    0xFE7701,
    0x305601,
    0x12101,
    0x1F2602,
    0x1E9001,
    0x95E01,
    0x12F01,
    0x1F9603,
    0x1E4901,
    0x10B01,
    0x1DF02,
    0x1D16102,
    0xFB2B01,
    0x1E0902,
    0x11701,
    0xFF9F01,
    0x1F7B01,
    0x1E9901,
    0x1F9203,
    0x1FCA01,
    0xB801,
    0x1A101,
    0x1F3901,
    0xFE7401,
    0xFC6102,
    0x1E5B01,
    0x92901,
    0xFE8301,
    0x1FE202,
    0x305401,
    0x1CF01,
    0x2DC01,
    0xFB01,
    0x307A01,
    0xFB3901,
    0x17501,
    0x305001,
    0x1E801,
    0x1FE901,
    0x1D301,
    0x307D01,
    0x1E2F02,
    0xFE4C01,
    0xF8102,
    0x1FA503,
    0x1FAB03,
    0x1EDB02,
    0x1F4801,
    0x1EED02,
    0x1F4402,
    0x1DA02,
    0xD101,
    0x1E6802,
    0x2DA01,
    0x30B401,
    0x1ECF01,
    0x1E5901,
    0x1E002,
    0x1E5701,
    0x1F0F02,
    0x17201,
    0x1FEE02,
    0x1E5401,
    0xC901,
    0xA3601,
    0x228901,
    0x1ECC01,
    0xB401,
    0x16901,
    0x1EF601,
    0x10501,
    0x1E7C01,
    0x1F8F03,
    0x1E3301,
    0x14F01,
    0x1EE802,
    0x1F4202,
    0x1E3E01,
    0xFC6302,
    0x1F501,
    0x16401,
    0x4F201,
    0x1F0202,
    0x1E0F01,
    0x1FEA01,
    0x1F1901,
    0xFC5B01,
    0x1D1BD02,
    0xC101,
    0x38A01,
    0x1EE102,
    0xD601,
    0x1E7802,
    0x1F7301,
    0x1E7A02,
    0x1EA902,
    0xFCD901,
    0x1F9B03,
    0x1F2202,
    0x10601,
    0x38F01,
    0xF7801,
    0x1D15F01,
    0x1F8703,
    0x1FE501,
    0x1EE202,
    0x1F801,
    0x307901,
    0xFE8201,
    0x1ED002,
    0x4E201,
    0x13501,
    0x1109C01,
    0xFCF202,
    0x1E6F01,
    0x21CD01,
    0x1EB702,
    0x4EF01,
    0x1E6201,
    0x1EDD02,
    0xFC5E02,
    0xDD01,
    0x1F6202,
    0x1F4B02,
    0x4E601,
    0x14801,
    0x1F3A02,
    0x1FAF03,
    0xC401,
    0x1EEC02,
    0x1F4101,
    0x1EC702,
    0x4DC01,
    0x16E01,
    0x1F1A02,
    0x307301,
    0x22AE01,
    0x38901,
    0x23002,
    0x13C01,
    0x1FF901,
    0x1F0702,
    0x1EBB01,
    0x12501,
    0x1F1202,
    0x1E2901,
    0x1E4301,
    0x10201,
    0x330401,
    0x6C001,
    0x11301,
    0x1EA201,
    0x1F3702,
    0x1FED02,
    0x4D201,
    0xFFE301,
    0x30D401,
    0x15101,
    0x307001,
    0x3AE01,
    0x1F901,
    0x1FA102,
    0x1E9401,
    0x332101,
    0xC301,
    0x17901,
    0x1DE02,
    0xFB3E01,
    0x1E5102,
    0x4DE01,
    0x62601,
    0x3CC01,
    0x2DD01,
    0x1F6101,
    0x15501,
    0x3CE01,
    0x30C901,
    0x1E7001,
    0x227901,
    0x30C501,
    0x12001,
    0xFE8601,
    0x1E4F02,
    0x13A01,
    0x1E7401,
    0x1F1302,
    0x1D1BF02,
    0x11B01,
    0x9DD01,
    0x22EB01,
    0x1E6D01,
    0x1E5202,
    0x1ED202,
    0x1F3602,
    0x1EAD02,
    0x1FE401,
    0xB5C01,
    0x1FBA01,
    0x1E4E02,
    0x16801,
    0xFE7C01,
    0x1FAA03,
    0x1E0401,
    0x20101,
    0x1EF01,
    0x12E01,
    0x1F0C02,
    0x1E1402,
    0xFE7601,
    0x1E3802,
    0xFB3B01,
    0xCD01,
    0x226D01,
    0x4D101,
    0x1E8601,
    0x45101,
    0x17B01,
    0x47601,
    0x4EC01,
    0x21401,
    0x1EF401,
    0x16A01,
    0x30DD01,
    0xFE8B01,
    0xFBB101,
    0x219A01,
    0xFB4301,
];


