// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _ShapeProcess_Context_HeaderFile
#define _ShapeProcess_Context_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_ShapeProcess_Context.hxx>

#include <Handle_Resource_Manager.hxx>
#include <Handle_TColStd_HSequenceOfHAsciiString.hxx>
#include <Handle_Message_Messenger.hxx>
#include <Handle_Message_ProgressIndicator.hxx>
#include <Standard_Integer.hxx>
#include <MMgt_TShared.hxx>
#include <Standard_CString.hxx>
#include <Standard_Boolean.hxx>
#include <Standard_Real.hxx>
class Resource_Manager;
class TColStd_HSequenceOfHAsciiString;
class Message_Messenger;
class Message_ProgressIndicator;
class TCollection_AsciiString;


//! Provides convenient interface to resource file
//! Allows to load resource file and get values of
//! attributes starting from some scope, for example
//! if scope is defined as "ToV4" and requested parameter
//! is "exec.op", value of "ToV4.exec.op" parameter from
//! the resource file will be returned
class ShapeProcess_Context : public MMgt_TShared
{

public:

  
  //! Creates an empty tool
  Standard_EXPORT ShapeProcess_Context();
  
  //! Creates a new tool and initialises by name of
  //! resource file and (if specified) starting scope
  //! Calls method Init()
  Standard_EXPORT ShapeProcess_Context(const Standard_CString file, const Standard_CString scope = "");
  
  //! Initialises a tool by loading resource file and
  //! (if specified) sets starting scope
  //! Returns False if resource file not found
  Standard_EXPORT   Standard_Boolean Init (const Standard_CString file, const Standard_CString scope = "") ;
  
  //! Loading Resource_Manager object if this object not
  //! equal internal static Resource_Manager object or
  //! internal static Resource_Manager object is null
  Standard_EXPORT   Handle(Resource_Manager) LoadResourceManager (const Standard_CString file) ;
  
  //! Returns internal Resource_Manager object
  Standard_EXPORT  const  Handle(Resource_Manager)& ResourceManager()  const;
  
  //! Set a new (sub)scope
  Standard_EXPORT   void SetScope (const Standard_CString scope) ;
  
  //! Go out of current scope
  Standard_EXPORT   void UnSetScope() ;
  
  //! Returns True if parameter is defined in the resource file
  Standard_EXPORT   Standard_Boolean IsParamSet (const Standard_CString param)  const;
  
  Standard_EXPORT   Standard_Boolean GetReal (const Standard_CString param, Standard_Real& val)  const;
  
  Standard_EXPORT   Standard_Boolean GetInteger (const Standard_CString param, Standard_Integer& val)  const;
  
  Standard_EXPORT   Standard_Boolean GetBoolean (const Standard_CString param, Standard_Boolean& val)  const;
  
  //! Get value of parameter as being of specific type
  //! Returns False if parameter is not defined or has a wrong type
  Standard_EXPORT   Standard_Boolean GetString (const Standard_CString param, TCollection_AsciiString& val)  const;
  
  Standard_EXPORT   Standard_Real RealVal (const Standard_CString param, const Standard_Real def)  const;
  
  Standard_EXPORT   Standard_Integer IntegerVal (const Standard_CString param, const Standard_Integer def)  const;
  
  Standard_EXPORT   Standard_Boolean BooleanVal (const Standard_CString param, const Standard_Boolean def)  const;
  
  //! Get value of parameter as being of specific type
  //! If parameter is not defined or does not have expected
  //! type, returns default value as specified
  Standard_EXPORT   Standard_CString StringVal (const Standard_CString param, const Standard_CString def)  const;
  
  //! Sets Messenger used for outputting messages.
  Standard_EXPORT   void SetMessenger (const Handle(Message_Messenger)& messenger) ;
  
  //! Returns Messenger used for outputting messages.
  Standard_EXPORT   Handle(Message_Messenger) Messenger()  const;
  
  //! Sets Progress Indicator.
  Standard_EXPORT   void SetProgress (const Handle(Message_ProgressIndicator)& theProgress) ;
  
  //! Returns Progress Indicator.
  Standard_EXPORT   Handle(Message_ProgressIndicator) Progress()  const;
  
  //! Sets trace level used for outputting messages
  //! - 0: no trace at all
  //! - 1: errors
  //! - 2: errors and warnings
  //! - 3: all messages
  //! Default is 1 : Errors traced
  Standard_EXPORT   void SetTraceLevel (const Standard_Integer tracelev) ;
  
  //! Returns trace level used for outputting messages.
  Standard_EXPORT   Standard_Integer TraceLevel()  const;




  DEFINE_STANDARD_RTTI(ShapeProcess_Context)

protected:




private: 


  Handle(Resource_Manager) myRC;
  Handle(TColStd_HSequenceOfHAsciiString) myScope;
  Handle(Message_Messenger) myMessenger;
  Handle(Message_ProgressIndicator) myProgress;
  Standard_Integer myTraceLev;


};







#endif // _ShapeProcess_Context_HeaderFile
