Change log for feature-check
============================

1.0.1 - 2021/12/17
------------------

- Use common test definitions for the various implementations,
  generated and kept in sync via the new fcheck-testdata internal tool.
- Python implementation:
  - code clean-up:
    - add a version to the dependency on the "hacking" Python library in
      the tox.ini test definitions to help out pip's resolver
    - use f-strings instead of str.format()
    - use black's default line length of 88 characters
  - add tests for comparisons against beta versions of features
  - actually install the py.typed marker file via the declarative
    setuptools configuration
- Rust implementation:
  - code clean-up:
    - honor clippy's "needless borrow" suggestions
    - add the `html_root_url` doc attribute
    - drop an unused internal structure field
    - get the crate version string from the Cargo manifest, one less place
      to update when bumping the version
    - move the module-level docs after the copyright notices
  - declare compatibility with the Rust 2021 edition with no changes
  - use the quick-error crate instead of writing boilerplate code

1.0.0 - 2021/06/24
------------------
- Perl implementation:
  - fix a 2 < 10 version int/string bug
  - fix a 3.0.beta2 < 3.0 version int/string bug
- Python implementation:
  - drop Python 2.x support
  - rework as more idiomatic Python 3.x
  - switch to a declarative setuptools config
  - add a PEP 517 pyproject.toml definition
  - reformat the source code using black
  - push the source into a src/ subdirectory
- Add a Rust implementation.

0.2.2 - 2019/01/09
------------------
- Fix the Python command-line tool's use of the standard Python
  JSON module if simplejson is not installed.
- Remove two unnecessary "pass" statements since the functions
  have a doc-string that serves as a null body.

0.2.1 - 2018/11/23
------------------

- Build universal Python wheels.
- Do not require the Python typing module, only use it when it is
  available, e.g. during type checking tests.

0.2.0 - 2018/11/22
------------------

- Reorganize the Python implementation:
  - break it into modules
  - add flake8 and pylint checks
  - add some simple unit tests
  - add type hints

0.1.1 - 2018/05/08
------------------

- Perl 5.10 does not understand the ellipsis unimplemented statement,
  so replace it with a die() statement with an internal error message

0.1.0 - 2018/04/22
------------------

- first public release

Comments: Peter Pentchev <roam@ringlet.net>
