/* test_data.cpp: implementation file for clipper test data */
//C Copyright (C) 2000-2006 Kevin Cowtan and University of York
//L
//L  This library is free software and is distributed under the terms
//L  and conditions of version 2.1 of the GNU Lesser General Public
//L  Licence (LGPL) with the following additional clause:
//L
//L     `You may also combine or link a "work that uses the Library" to
//L     produce a work containing portions of the Library, and distribute
//L     that work under terms of your choice, provided that you give
//L     prominent notice with each copy of the work that the specified
//L     version of the Library is used in it, and that you include or
//L     provide public access to the complete corresponding
//L     machine-readable source code for the Library including whatever
//L     changes were used in the work. (i.e. If you make changes to the
//L     Library you must distribute those, but you do not need to
//L     distribute source or object code to those portions of the work
//L     not covered by this licence.)'
//L
//L  Note that this clause grants an additional right and does not impose
//L  any additional restriction, and so does not affect compatibility
//L  with the GNU General Public Licence (GPL). If you wish to negotiate
//L  other terms, please contact the maintainer.
//L
//L  You can redistribute it and/or modify the library under the terms of
//L  the GNU Lesser General Public License as published by the Free Software
//L  Foundation; either version 2.1 of the License, or (at your option) any
//L  later version.
//L
//L  This library is distributed in the hope that it will be useful, but
//L  WITHOUT ANY WARRANTY; without even the implied warranty of
//L  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//L  Lesser General Public License for more details.
//L
//L  You should have received a copy of the CCP4 licence and/or GNU
//L  Lesser General Public License along with this library; if not, write
//L  to the CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
//L  The GNU Lesser General Public can also be obtained by writing to the
//L  Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
//L  MA 02111-1307 USA


#include "test_data.h"


namespace clipper {


namespace data {


double rnasecell[] = {64.8970,78.3230,38.7920,90.0000,90.0000,90.0000};

char rnasespgr[] = "P 2ac 2ab";

double rnasereso = 5.0;

struct TESThkldata { int h,k,l; float f,s,a,b,c,d; };

TESThkldata rnasehkldata[] = {
{0,0,2,29.2,87.7,0.01,-0,0,0},
{0,0,4,455.7,12.2,-65.09,-0,0,0},
{0,0,6,714.2,8.5,5.31,-0,0,0},
{0,1,1,1368.6,12.2,0,5.56,0,0},
{0,1,2,523.7,8.5,-0,-0.13,0,0},
{0,1,3,191,2.4,-0,-11.65,0,0},
{0,1,4,292.9,6.1,0,11.53,0,0},
{0,1,5,374.8,10.9,-0,-8.1,0,0},
{0,1,6,323.2,8.5,0,0.21,0,0},
{0,1,7,336.9,7.2,-0,-5.57,0,0},
{0,2,0,1485.6,17.1,-12.38,-0,0,0},
{0,2,1,1139.3,8.5,-9.22,-0,0,0},
{0,2,2,146.1,20.7,-0.77,-0,0,0},
{0,2,3,350.4,7.3,-0.09,-0,0,0},
{0,2,4,476.3,12.1,1.74,-0,0,0},
{0,2,5,103.1,2.4,-1.69,-0,0,0},
{0,2,6,243.3,4.8,6.89,-0,0,0},
{0,2,7,417.7,13.3,-16.66,-0,0,0},
{0,3,1,227.8,12.2,-0,-1.6,0,0},
{0,3,2,747.5,8.5,0,0.07,0,0},
{0,3,3,20.7,1.2,-0,-0.08,0,0},
{0,3,4,10.9,1.2,0,-0.32,0,0},
{0,3,5,397.7,8.5,-0,-1.59,0,0},
{0,3,6,670.4,10.9,-0,-0.26,0,0},
{0,3,7,534.7,10.9,0,2.3,0,0},
{0,4,0,471.4,6.1,-0.84,-0,0,0},
{0,4,1,248.4,12.2,0.38,-0,0,0},
{0,4,2,210.6,3.7,-8.84,-0,0,0},
{0,4,3,110.7,1.2,0.26,-0,0,0},
{0,4,4,216.1,3.6,0.72,-0,0,0},
{0,4,5,369.7,8.5,0.52,-0,0,0},
{0,4,6,241.9,3.6,-1.06,-0,0,0},
{0,4,7,182.2,2.4,-3.62,-0,0,0},
{0,5,1,415.1,8.5,-0,-29.92,0,0},
{0,5,2,197.1,2.4,-0,-0.55,0,0},
{0,5,3,111.8,2.4,0,5.59,0,0},
{0,5,4,140.8,2.4,0,-0.29,0,0},
{0,5,5,471.4,9.7,-0,-3.02,0,0},
{0,5,6,603.4,16.9,0,0.87,0,0},
{0,5,7,158,2.4,0,8.01,0,0},
{0,6,0,1390.9,12.2,-22.22,-0,0,0},
{0,6,1,132.6,2.4,-1.62,-0,0,0},
{0,6,2,193.3,2.4,-2.16,-0,0,0},
{0,6,3,223.5,4.9,1.36,-0,0,0},
{0,6,4,135.9,2.4,-7.14,-0,0,0},
{0,6,5,142.9,2.4,0.28,-0,0,0},
{0,6,6,15.7,2.4,0.31,-0,0,0},
{0,6,7,171.2,2.4,-5.76,-0,0,0},
{0,7,1,625,12.2,0,0.08,0,0},
{0,7,2,207.8,2.4,-0,-0.02,0,0},
{0,7,3,325.4,6.1,-0,-3.12,0,0},
{0,7,4,628,8.5,-0,-16.81,0,0},
{0,7,5,472,13.3,-0,-9.2,0,0},
{0,7,6,88.2,1.2,0,0.05,0,0},
{0,8,0,385.2,7.3,-18.35,-0,0,0},
{0,8,1,377.9,4.9,-2.97,-0,0,0},
{0,8,2,886.5,12.1,62.91,-0,0,0},
{0,8,3,287.5,6.1,0.19,-0,0,0},
{0,8,4,395,8.5,-5.48,-0,0,0},
{0,8,5,433,7.3,9.3,-0,0,0},
{0,8,6,292.1,4.8,-37.35,-0,0,0},
{0,9,1,108.1,1.2,0,2.84,0,0},
{0,9,2,525.4,12.1,0,0.23,0,0},
{0,9,3,293.4,6.1,0,0.19,0,0},
{0,9,4,173.1,3.6,0,0.57,0,0},
{0,9,5,436.3,7.3,-0,-2.15,0,0},
{0,9,6,410,7.2,-0,-0.54,0,0},
{0,10,0,10.9,6.1,0.15,-0,0,0},
{0,10,1,14.6,3.6,-0.22,-0,0,0},
{0,10,2,452.2,8.5,-11.34,-0,0,0},
{0,10,3,142.9,2.4,-6.06,-0,0,0},
{0,10,4,381,7.3,-0.81,-0,0,0},
{0,10,5,642.4,10.9,4.87,-0,0,0},
{0,11,1,77.6,2.4,0,0.21,0,0},
{0,11,2,93.3,2.4,0,-0.14,0,0},
{0,11,3,542.1,10.9,-0,-0.26,0,0},
{0,11,4,445.9,9.7,0,10.42,0,0},
{0,11,5,223.2,4.8,0,0.17,0,0},
{0,12,0,238.5,7.3,24.05,-0,0,0},
{0,12,1,130.7,2.4,2.01,-0,0,0},
{0,12,2,65.3,2.4,-0.08,-0,0,0},
{0,12,4,348.8,7.2,26.57,-0,0,0},
{0,13,1,72.5,2.4,0,2.07,0,0},
{0,13,2,235.6,4.8,0,0.08,0,0},
{0,13,3,414.1,8.5,-0,-49.34,0,0},
{0,13,4,517.2,10.9,0,0.73,0,0},
{0,14,0,588.2,16.9,2.04,-0,0,0},
{0,14,1,429.9,9.7,0.24,-0,0,0},
{0,14,2,26.6,3.6,0.78,-0,0,0},
{0,14,3,125.4,2.4,-6.07,-0,0,0},
{0,15,1,161.6,3.6,0,0.05,0,0},
{0,15,2,97.6,2.4,0,-0.06,0,0},
{1,0,1,129.2,6.1,0,1.42,0,0},
{1,0,2,406.8,6.1,-1.33,-0,0,0},
{1,0,3,9.7,2.4,-0,-0.06,0,0},
{1,0,4,295.3,6.1,-0.28,-0,0,0},
{1,0,5,346.9,7.3,0,1.6,0,0},
{1,0,6,283.3,6.1,-11.31,-0,0,0},
{1,0,7,170.3,3.6,0,0.79,0,0},
{1,1,1,386.3,6.1,2.57,-0.11,-0.45,0.23},
{1,1,2,339.8,6.1,-1.33,-3.81,3.49,-1.3},
{1,1,3,582.8,6.1,-10.31,-4.05,-3.72,-3.74},
{1,1,4,467.8,9.7,1.29,-0.24,-0.55,0.38},
{1,1,5,139.5,2.4,-2.02,-2.01,-0.46,-1.74},
{1,1,6,541.1,10.9,8.64,11.11,0.53,-3.76},
{1,1,7,422.6,6,1.41,3.07,0.15,-0.32},
{1,2,0,214.5,6.1,0,0.11,0,0},
{1,2,1,433.8,6.1,0.07,-0.11,-0.03,0.02},
{1,2,2,93.8,17,-0.27,-0.04,0.12,0.22},
{1,2,3,222.6,2.4,0.4,-1.61,1.38,0.36},
{1,2,4,432.5,6.1,-0.32,0.8,0.12,0.12},
{1,2,5,213.5,2.4,-0.08,-0.1,-0.01,-0.06},
{1,2,6,290.5,3.6,-21.13,10.63,-5.07,6.49},
{1,2,7,525.2,8.5,0.06,-8.51,2.34,0.66},
{1,3,0,342.4,6.1,-0,-5.24,0,0},
{1,3,1,430,6.1,-2.11,0.27,-0.53,-0.51},
{1,3,2,361.6,4.9,0.1,-1.42,0.55,0.15},
{1,3,3,841.7,8.5,-4.25,5.17,0.29,1.37},
{1,3,4,471.3,6.1,0.23,-1.35,0.77,2.63},
{1,3,5,605.1,8.5,16.61,-8.61,-3.84,4.99},
{1,3,6,280.7,2.4,-0.32,-0.92,0.38,-0.31},
{1,4,0,321.5,8.5,-0,-10.67,0,0},
{1,4,1,116.9,17,1.34,-0.3,-0.4,0.34},
{1,4,2,647.5,6.1,5.42,35.2,2.95,-0.92},
{1,4,3,235.9,2.4,7.29,7.79,0.47,-4.84},
{1,4,4,262.3,2.4,1.72,-17.01,5.54,1.13},
{1,4,5,50.9,1.2,-0.96,0.43,-0.23,0.1},
{1,4,6,205.6,2.4,1.69,1.42,2.13,-1.33},
{1,5,0,674.5,6.1,-0,-2.15,0,0},
{1,5,1,472.3,6.1,-3.35,1.06,-1.49,0.89},
{1,5,2,643.5,8.5,-6.1,13.27,1.33,1.54},
{1,5,3,223.6,2.4,-2.6,-2.64,0.08,-1.37},
{1,5,4,400.5,4.9,1.2,-1.52,-0.25,2.67},
{1,5,5,401,4.8,10.95,7.49,-0.28,-1.33},
{1,5,6,116.1,1.2,3.03,-4.71,0.73,1.69},
{1,5,7,190.6,2.4,0.91,0.96,-0.01,-0.09},
{1,6,0,53.5,1.2,-0,-0.42,0,0},
{1,6,1,166.7,2.4,5.09,-2.35,-1.56,2.06},
{1,6,2,155.6,2.4,-0.73,0.23,-0.19,0.33},
{1,6,3,402.1,10.9,0.02,-0.05,0.42,0.35},
{1,6,4,562.9,8.5,-1.87,-0.65,-0.33,-0.29},
{1,6,5,122.3,1.2,3.09,-3.26,0.12,2.49},
{1,6,6,161.9,1.2,-1.23,0.27,-0.12,0.77},
{1,6,7,136.2,1.2,-0.58,-3.86,1.91,-0.55},
{1,7,0,402.5,10.9,-0,-10.69,0,0},
{1,7,1,396.4,4.9,0.07,-0.46,0.16,0.14},
{1,7,2,534.7,12.2,0.64,0.67,0.02,-0.31},
{1,7,3,188.2,2.4,-4.2,4.86,0.04,1.55},
{1,7,4,173.4,1.2,-0.85,1.92,1.66,3.43},
{1,7,5,325.6,3.6,-2.92,-2.44,-0.79,-2.31},
{1,7,6,324.9,2.4,-8.48,-8.39,-0.01,-3.9},
{1,8,0,238.2,3.6,-0,-0.13,0,0},
{1,8,1,132.4,1.2,-0.13,-1.96,1.44,-0.27},
{1,8,2,365.5,4.9,5.76,14.55,3.92,-3.57},
{1,8,3,293.6,3.6,0.4,-0.92,0.43,0.29},
{1,8,4,77.5,1.2,0.34,0.44,0.08,-0.3},
{1,8,5,250.3,2.4,-0.33,-0.28,-0.01,-0.03},
{1,8,6,179.8,2.4,-1.45,-1.34,0.16,-0.6},
{1,9,0,78.9,1.2,-0,-3.32,0,0},
{1,9,1,103.2,1.2,0.08,0.17,-1.18,-0.57},
{1,9,2,252.4,2.4,0.22,-1.06,1.49,0.27},
{1,9,3,217,2.4,-20.15,2.6,-0.93,0.24},
{1,9,4,204.6,2.4,-3.65,-13.99,1.69,-1.03},
{1,9,5,761.3,10.9,-5.49,-2.47,-0.56,-0.84},
{1,9,6,109.7,1.2,0.29,0.96,0.02,-0.02},
{1,10,0,230.5,3.6,0,3.19,0,0},
{1,10,1,361.5,4.9,-2.24,14.11,2.49,0.22},
{1,10,2,337,3.6,-4.77,15.35,1.86,1.17},
{1,10,3,254.3,2.4,2.32,4.47,1.25,-1.53},
{1,10,4,327.8,3.6,-0.28,0.15,0.35,0.78},
{1,10,5,431,4.8,0.66,-2.6,1.05,0.33},
{1,11,0,37.6,2.4,-0,-0.68,0,0},
{1,11,1,315.1,3.6,-4.61,0.39,-1.27,0.12},
{1,11,2,444.5,4.8,0.68,-2.26,0.45,0.3},
{1,11,3,113.7,1.2,0.85,-1.34,0.02,0.09},
{1,11,4,211.4,2.4,4.86,6.04,0.49,-2.82},
{1,11,5,405.3,4.8,1.2,-0.64,0.41,1.54},
{1,12,0,323.2,4.8,0,42.78,0,0},
{1,12,1,256.6,2.4,6.63,1.87,-1.41,-1.3},
{1,12,2,414.9,4.8,1.6,0.38,-0.18,-0.1},
{1,12,3,461.7,4.8,-0.06,-0.31,-0.35,-0.52},
{1,12,4,143.6,1.2,-0.74,-3.67,0.42,-0.64},
{1,13,0,786,10.9,-0,-6.73,0,0},
{1,13,1,993.8,14.5,0.17,-0.33,0.01,0.01},
{1,13,4,442.4,4.8,-0.05,0.93,0.95,-1.03},
{1,14,0,22.9,3.6,0,0.38,0,0},
{1,14,1,601.3,7.2,-3.48,-0.29,-1.94,0.96},
{1,14,3,490.7,6,-1.95,1.03,-0.35,0.54},
{1,15,0,341.3,6,-0,-1.93,0,0},
{1,15,1,869.4,14.5,0.44,0.23,-0.42,-0.76},
{1,15,2,284.4,3.6,-0.46,-6.92,1.85,-0.32},
{2,0,0,615.4,6.1,-0.26,-0,0,0},
{2,0,1,350.9,6.1,-0,-10.85,0,0},
{2,0,2,93.8,14.6,-0.2,-0,0,0},
{2,0,3,305.3,4.9,-0,-20.16,0,0},
{2,0,4,82.6,1.2,-0.32,-0,0,0},
{2,0,5,282.6,3.6,-0,-24.07,0,0},
{2,0,6,107.7,1.2,12.98,-0,0,0},
{2,0,7,453.9,9.7,0,4.35,0,0},
{2,1,0,782.3,6.1,0.16,-0,0,0},
{2,1,1,166.9,8.5,-0.35,0.35,0.49,0},
{2,1,2,485.8,9.7,-0.14,-0.18,0.01,-0.05},
{2,1,3,172.7,1.2,-0.71,1.98,1.65,-0.03},
{2,1,4,302.5,3.6,-5.88,-5.46,-0.34,-0.9},
{2,1,5,160.1,2.4,11.63,-4.93,-3.56,3.8},
{2,1,6,367.9,4.8,3.85,2.07,-0.53,-0.98},
{2,2,0,64.6,20.7,-0.39,-0,0,0},
{2,2,1,269.2,6.1,0.09,0.38,-0.08,-0.27},
{2,2,2,411.5,6.1,-0.11,-0.18,0.27,0.02},
{2,2,3,467.1,9.7,-0.99,-0.91,-0.02,-0.38},
{2,2,4,253.9,2.4,-18.53,7.1,-6.63,5.64},
{2,2,5,403.8,4.9,0.57,0.03,-0.16,-0.56},
{2,2,6,210.5,2.4,4.5,14.42,4.52,-3.19},
{2,2,7,111,1.2,-0.35,0.48,0.03,0.05},
{2,3,0,248.5,6.1,0.59,-0,0,0},
{2,3,1,649.1,6.1,0.15,-0.06,-0.57,0.42},
{2,3,2,438.2,6.1,6.73,-1.03,-3.25,-0.35},
{2,3,3,520.5,6.1,-0.54,-0.17,-0.11,-0.15},
{2,3,4,188.2,2.4,4.63,2.45,-0.21,-0.48},
{2,3,5,66.7,1.2,3.55,-0.14,-0.77,0.13},
{2,3,6,398,4.8,0.06,0.59,0.05,-0.01},
{2,4,0,256.9,8.5,-6.68,-0,0,0},
{2,4,1,375,6.1,0.12,-0.02,-0.07,-0.11},
{2,4,2,856.6,8.5,-9.29,-9.01,-0.04,-1.4},
{2,4,3,367.1,3.6,-0.24,-0.33,0.04,-0.29},
{2,4,4,161.5,1.2,0.48,-0.06,-2.28,-1.77},
{2,4,5,391.4,3.6,7.89,0.56,-2.19,-0.77},
{2,4,6,240.7,2.4,3.24,4.64,0.84,-2.23},
{2,5,0,114.4,2.4,3.52,-0,0,0},
{2,5,1,333.4,4.9,1.85,0.11,-1.24,-0.51},
{2,5,2,317.4,4.9,23.69,0.5,-1.32,0.05},
{2,5,3,294.1,3.6,7.48,-3.57,-0.66,1.7},
{2,5,4,523,8.5,21.3,-3.75,-4.19,2.49},
{2,5,5,241.1,2.4,0.24,-0.37,0.02,0.05},
{2,5,6,201.9,2.4,0.17,0.01,-0.05,-0},
{2,6,0,19.5,3.6,0.1,-0,0,0},
{2,6,1,295.6,4.9,-1.03,0.86,-0.04,0.37},
{2,6,2,306.3,3.6,-5.49,-1.69,-2.45,-3.87},
{2,6,3,155.5,2.4,-0.35,-4.49,0.9,-0.37},
{2,6,4,409.9,4.9,4.6,0.8,-0.9,-0.37},
{2,6,5,457.7,6.1,-3.85,-1.4,-0.68,-0.6},
{2,6,7,303.7,2.4,0.93,7.03,2.04,-0.55},
{2,7,0,604.3,8.5,1.26,-0,0,0},
{2,7,1,459.5,13.4,6.83,-10.93,2.15,4.44},
{2,7,2,115.4,1.2,-0.38,0.86,0.15,0.13},
{2,7,3,258.5,3.6,-13.32,-11.94,-0.74,-8.65},
{2,7,4,327.3,3.6,-0.82,-1.03,-0.01,-0.6},
{2,7,5,428.3,4.8,-5.82,-8.82,1,-2.45},
{2,8,0,286.7,6.1,-8.1,-0,0,0},
{2,8,1,422.7,6.1,4.68,-24.93,10.73,3.91},
{2,8,2,233.1,3.6,1.27,0.77,-0.56,-0.74},
{2,8,3,120.1,2.4,-0.99,-5.01,2.11,-0.71},
{2,8,4,331.9,4.8,-11.14,7,-1.76,3.58},
{2,8,5,343.4,3.6,0.13,6.04,3.09,1.53},
{2,8,6,30.2,1.2,0.2,0.57,0.11,-0.09},
{2,9,0,380,8.5,-1.6,-0,0,0},
{2,9,1,166.3,2.4,8.22,2.58,-3.96,-2.51},
{2,9,2,106.7,1.2,-0.93,-1.73,0.53,-0.72},
{2,9,3,185.4,2.4,2.6,0.02,-2.81,0.51},
{2,9,4,61.7,1.2,-0.36,-0.85,0.36,-0.46},
{2,9,5,234.4,2.4,0.42,0.24,0.29,-0.34},
{2,9,6,256.8,2.4,-1.96,-5.44,1.47,-0.97},
{2,10,0,249.9,4.9,-8.43,-0,0,0},
{2,10,1,471.7,7.3,4.95,9.76,2.41,-1.74},
{2,10,2,32.7,2.4,0.4,-0.16,-0.11,0.1},
{2,10,3,122.3,1.2,-0.23,0.31,0.3,0.18},
{2,10,4,163.2,2.4,-1.26,-0.08,-0.99,-0.69},
{2,10,5,178.7,2.4,-1.36,-3.72,1.56,-1.74},
{2,11,0,481.1,9.7,4.82,-0,0,0},
{2,11,1,284.7,3.6,3.46,4.07,-0.25,-3.96},
{2,11,2,446.8,4.8,6.15,-0.2,-2.26,0.26},
{2,11,3,464.5,4.8,8.12,-3.56,-1.66,2.04},
{2,11,5,513.7,6,0.6,-0.88,0.08,0.45},
{2,12,0,346.2,6.1,-1.93,-0,0,0},
{2,12,1,188.8,2.4,2.88,-1.53,-0.54,0.44},
{2,12,2,264.9,3.6,-10.54,4.38,-0.32,0.46},
{2,12,3,409.6,4.8,2.27,1.7,-0.58,-2.07},
{2,12,4,35,2.4,0.33,0.11,-0.12,-0.08},
{2,13,0,37.5,2.4,0.18,-0,0,0},
{2,13,1,501.6,6,0.36,-0.58,0.08,0.24},
{2,13,2,270.6,3.6,-0.87,0.47,-4.83,0.59},
{2,13,3,379,4.8,-0.94,-1.65,0.35,-0.67},
{2,13,4,237.4,2.4,-6.67,-2.4,-0.62,-0.15},
{2,14,0,223.4,3.6,-8.18,-0,0,0},
{2,14,1,536,6,-0.16,0.63,0.3,-0.01},
{2,14,3,283.3,3.6,0.74,-1.53,0.33,0.69},
{2,15,0,1002,14.5,1.28,-0,0,0},
{2,15,1,315.9,3.6,1.19,2.28,0.85,-1.03},
{3,0,1,104.7,12.2,-0,-0.3,0,0},
{3,0,2,484.5,6.1,-0.01,-0,0,0},
{3,0,3,495,6.1,-0,-24.37,0,0},
{3,0,4,122.7,1.2,3.64,-0,0,0},
{3,0,5,61.8,1.2,-0,-0.06,0,0},
{3,0,6,549.3,8.5,3.26,-0,0,0},
{3,0,7,29,2.4,0,0.49,0,0},
{3,1,0,49.9,26.8,-0,-0.08,0,0},
{3,1,1,427.5,6.1,-1.86,-1.01,-0.17,-0.26},
{3,1,2,315.3,3.7,0.8,8.92,1.07,-0.18},
{3,1,3,537.5,9.7,5.27,-5.62,0.07,3.31},
{3,1,4,213.7,2.4,3.39,-8.67,2.31,2.06},
{3,1,5,389.2,4.8,1.03,-1.51,0.35,0.75},
{3,1,6,125.8,1.2,-0.18,0.22,0,0.11},
{3,2,0,263.1,6.1,-0,-1.74,0,0},
{3,2,1,96.2,17,0.05,0.01,-0.11,0.22},
{3,2,2,85.2,1.2,0.69,-1.93,0.33,0.38},
{3,2,3,581.2,12.2,-7.36,-6.15,-0.19,-5.89},
{3,2,4,133.6,1.2,-0.24,-1.69,0.4,-0.05},
{3,2,5,344.3,3.6,4.57,-2.31,-0.64,0.71},
{3,2,6,304.8,3.6,-5.7,6.18,0.15,3.02},
{3,2,7,377.7,6,-0.49,-1.05,2.51,-1.82},
{3,3,0,283.7,6.1,0,1.35,0,0},
{3,3,1,266.6,3.7,-1.87,-0.17,-0.11,-0.61},
{3,3,2,749.5,6.1,-3.52,-28.34,4.81,-0.98},
{3,3,3,967.6,8.5,-2.62,1.1,-0.64,0.8},
{3,3,4,437,3.6,-2.7,-1.48,-1.74,-1.18},
{3,3,5,489.6,6.1,11.05,-2.83,-2.76,1.34},
{3,3,6,445,4.8,-8.09,-15.83,1.87,-1.02},
{3,3,7,515.1,6,0.34,-0.79,0.18,0.12},
{3,4,0,25.6,2.4,0,0.21,0,0},
{3,4,1,372.4,4.9,-21.86,-6.87,-1.91,-2.29},
{3,4,2,285.8,3.6,0.44,-0.8,0.12,0.27},
{3,4,3,172.6,2.4,0.42,-0.72,0.32,1.79},
{3,4,4,466,6.1,0.2,-2.57,0.45,0.14},
{3,4,5,87.2,1.2,-0.26,-0.23,-0.74,-0.55},
{3,4,6,394.1,3.6,0.95,-0.26,-0.14,0.28},
{3,4,7,96.5,1.2,0.11,-0.14,0.42,0.49},
{3,5,0,49.9,1.2,-0,-2.38,0,0},
{3,5,1,223.8,3.6,-0.43,0.09,-0.4,0.25},
{3,5,2,418.2,6.1,-0.91,0.57,-0.2,0.46},
{3,5,3,490.7,13.4,-4.54,3.59,-0.44,1.38},
{3,5,4,232.9,2.4,7.67,-10.54,1.7,6.61},
{3,5,5,383.9,3.6,-0.34,-1,0.14,-0.1},
{3,5,6,349.2,3.6,2.76,-1.16,-2,1.27},
{3,5,7,231.4,2.4,1.56,-5.53,0.58,0.88},
{3,6,0,127.7,2.4,-0,-3.71,0,0},
{3,6,1,359.9,4.9,-1.13,-17.84,1.6,-0.15},
{3,6,2,473.9,9.7,5.6,5.49,0.26,-3.03},
{3,6,3,633.7,8.5,7.77,12.5,1.07,-2.5},
{3,6,4,412.2,4.8,0.43,-3.56,0.97,0.17},
{3,6,5,236,2.4,2.46,4.04,3.19,-2.99},
{3,6,6,72.5,1.2,0.34,0.13,-0.3,-0.3},
{3,7,0,455.8,9.7,0,2.01,0,0},
{3,7,1,334.2,4.9,-1.5,-0.1,-1.6,0.82},
{3,7,2,421.4,8.5,0.06,0.28,0.12,-0.05},
{3,7,3,406.5,8.5,4.31,1.81,-0.95,-2.76},
{3,7,4,768.2,8.5,0.66,-0.48,-0.28,0.59},
{3,7,5,347.2,4.8,1.84,3.91,0.44,-0.43},
{3,7,6,428.5,4.8,0.07,-0.54,0.14,0.2},
{3,8,0,115.4,2.4,0,0.3,0,0},
{3,8,1,252.6,3.6,-5.76,9.72,3.84,7},
{3,8,2,280.3,3.6,4.39,13.34,4.06,-2.95},
{3,8,3,489.8,7.3,-5.95,-3.22,-0.93,-1.4},
{3,8,4,152.6,2.4,-5.77,-0.01,-3.1,-0.01},
{3,8,5,353,4.8,-5.26,12.93,4.49,5.12},
{3,8,6,256.9,2.4,0.58,1.35,0.69,-0.52},
{3,9,0,135.9,2.4,0,0.09,0,0},
{3,9,1,440.4,6.1,-0,-0.22,-0.54,0.28},
{3,9,2,83.7,1.2,-0.29,3.91,1.11,0.03},
{3,9,3,266.5,3.6,-6.02,0.07,-2.82,0.15},
{3,9,4,526.3,7.3,0.48,2.46,0.58,-0.16},
{3,9,5,55.6,1.2,0.3,0.27,0.02,-0.28},
{3,9,6,460.4,4.8,0.63,-6.36,0.79,-0.02},
{3,10,0,310.4,6.1,-0,-14.82,0,0},
{3,10,1,180.6,2.4,-4.54,-4.37,-0.34,-2.11},
{3,10,2,266.5,3.6,1.52,-2.54,0.37,0.87},
{3,10,3,268.7,3.6,-14.18,0.79,-1.48,0.19},
{3,10,4,282.9,3.6,-2.68,-5.74,1.19,-1.26},
{3,10,5,113.4,1.2,1.97,4.14,1,-1.28},
{3,11,0,390,8.5,0,29.6,0,0},
{3,11,1,17,4.8,0.03,0.07,-0,-0.03},
{3,11,2,111.4,1.2,0.01,0.01,-0,-0},
{3,11,3,206.8,3.6,-9.24,7.04,-1.3,4.81},
{3,11,4,528.9,7.2,3.21,6.71,0.81,-1.95},
{3,11,5,242.3,3.6,0.86,-0.57,0,0.1},
{3,12,0,88.3,2.4,0,1.69,0,0},
{3,12,1,407.7,6,-6.65,7.43,1.1,5.06},
{3,12,2,217.6,3.6,2.34,-2.67,0.02,0.95},
{3,12,4,442.7,6,-0.2,0.18,0.38,0.17},
{3,13,0,87,2.4,0,0.05,0,0},
{3,13,1,261,3.6,-0.74,-1.56,1.04,-0.46},
{3,13,2,254.8,3.6,-0.25,0.12,-0.1,-0.03},
{3,13,3,388.5,6,-0,0.08,0.02,0.03},
{3,14,0,295.7,6,-0,-12.82,0,0},
{3,14,1,164.1,2.4,-2.86,3.18,-0.14,2.56},
{3,14,2,417.3,6,-0.41,0.04,-0.12,0},
{3,15,0,219.4,3.6,0,5.51,0,0},
{3,15,1,303.7,3.6,3.52,-0.31,-1.11,0.25},
{4,0,0,899.8,6.1,5.1,-0,0,0},
{4,0,1,214.3,3.7,0,2.2,0,0},
{4,0,2,174,2.4,3.61,-0,0,0},
{4,0,3,543.3,6.1,-0,-0.87,0,0},
{4,0,4,264.6,3.6,1.49,-0,0,0},
{4,0,5,141.8,2.4,-0,-5.22,0,0},
{4,0,6,216.5,3.6,-2.96,-0,0,0},
{4,0,7,228,3.6,-0,-0.78,0,0},
{4,1,0,210.6,3.7,-3.01,-0,0,0},
{4,1,1,764.5,6.1,-7.52,-0.05,-8.22,-0.32},
{4,1,2,450.2,6.1,0.38,-0.26,-1.82,0.61},
{4,1,3,230.9,2.4,-0.28,0.28,-1.01,1.11},
{4,1,4,239.1,2.4,-13.76,-9.99,-1.7,-2.56},
{4,1,5,237.5,2.4,-6.91,1.66,-7.28,2.11},
{4,1,6,154.8,1.2,-0.41,-0.19,-0.66,-0.22},
{4,1,7,235.2,2.4,0.6,0.59,-0.11,-0.11},
{4,2,0,774.3,6.1,2.33,-0,0,0},
{4,2,1,444.3,6.1,0.43,0.04,3.06,-1.35},
{4,2,2,573,12.2,0.18,-0.08,-0.04,0.06},
{4,2,3,398.6,3.6,-4.4,-22.53,8.71,-3.45},
{4,2,4,29.1,2.4,-0.58,0.18,-0.14,0.12},
{4,2,5,409.5,3.6,0.19,0.39,0.21,-0.27},
{4,2,6,182.6,2.4,0.49,-0.02,-0.26,0.02},
{4,3,0,1167.2,8.5,-8.28,-0,0,0},
{4,3,1,366.3,4.9,-2.72,-2,-0.4,-1.48},
{4,3,2,227.4,2.4,0,0,-0,-0.01},
{4,3,3,307.4,3.6,5.41,-5.98,0.86,4.74},
{4,3,4,422.3,4.9,-2.59,-1.72,-0.23,-1.06},
{4,3,5,284.7,2.4,-0.18,0.14,-0.03,0.11},
{4,3,6,382,3.6,0.08,0.19,0.12,-0.21},
{4,3,7,287,2.4,-5.76,1.96,-0.39,0.45},
{4,4,0,416.1,8.5,0.04,-0,0,0},
{4,4,1,835.7,6.1,5.12,3.86,-0.65,-1.39},
{4,4,2,781.7,6.1,-0.18,0.63,0.1,0.04},
{4,4,3,280.6,3.6,-0.01,-7.75,2.57,-0.15},
{4,4,4,615,6.1,1,13.39,5.06,-0.52},
{4,4,5,284.6,2.4,-0.52,0.1,-0.38,0.14},
{4,4,6,406,4.8,-0.06,4.55,0.68,-0.07},
{4,4,7,202.5,2.4,-2.36,-1.77,-0.35,-2.67},
{4,5,0,490.1,9.7,-1.17,-0,0,0},
{4,5,1,800.1,8.5,-2.13,-1.14,-1.49,-2.9},
{4,5,2,700,6.1,0.35,-0.11,-0.06,0.02},
{4,5,3,323,3.6,12.03,-17.32,2.54,7.1},
{4,5,4,270.4,3.6,-5.49,-2.44,-0.99,-1.21},
{4,5,5,219.1,2.4,-2.02,-0.3,-3.88,-0.65},
{4,5,6,252.4,2.4,-0.02,-0.08,0.01,-0},
{4,6,0,134.9,2.4,8.43,-0,0,0},
{4,6,1,533.5,8.5,-5.3,13.14,5.72,5.2},
{4,6,2,44.9,2.4,-0.45,0.29,-0.12,0.18},
{4,6,3,311.9,4.9,-1.23,21.4,10.96,1.27},
{4,6,4,328.4,3.6,-1.67,3.57,0.92,1.1},
{4,6,5,360.5,3.6,-3.72,8.51,2.54,2.47},
{4,6,6,540.8,6,0.1,-0.06,-0.02,-0},
{4,7,0,355.9,7.3,-35.26,-0,0,0},
{4,7,1,672.9,6.1,7.76,1.2,-1.92,-0.76},
{4,7,2,332.6,4.9,2.9,0.74,-3.56,-0.55},
{4,7,3,139.5,2.4,7.62,-2.62,-2.65,2.28},
{4,7,4,153.8,2.4,-6.94,3.32,-1.26,1.28},
{4,7,5,187.4,2.4,-4.74,1.27,-1.96,0.85},
{4,7,6,395.7,4.8,3.42,-1.29,-1.07,0.79},
{4,8,0,365.4,7.3,25.64,-0,0,0},
{4,8,1,487.9,7.3,0.15,-0.52,0.26,0.08},
{4,8,2,189.2,2.4,1.08,0.16,-0.19,-0.06},
{4,8,3,376.9,6.1,-0.6,-0.23,-0.2,-0.11},
{4,8,4,269.9,3.6,5.84,2.65,-1.11,-1.51},
{4,8,5,300.8,3.6,0.09,0.83,0.26,-0.04},
{4,8,6,247.2,2.4,-0.54,-0.27,-0.42,-0.03},
{4,9,0,168.6,4.9,-0.11,-0,0,0},
{4,9,1,229.2,4.9,0,-0.01,0.01,-0},
{4,9,2,300.6,4.8,3.11,-0.02,-1.93,0.86},
{4,9,3,165.9,2.4,14.31,0.33,-5.75,-0.24},
{4,9,4,255.2,3.6,0.9,-3.07,1.86,0.65},
{4,9,5,297,3.6,0.75,-0.27,-0.3,0.06},
{4,10,0,409.6,8.5,-8.06,-0,0,0},
{4,10,1,238.7,3.6,0.42,1.18,0.49,-0.88},
{4,10,2,289.4,4.8,0.06,0.15,-0.25,0.42},
{4,10,3,502.1,10.9,0.56,2.55,0.3,-0.15},
{4,10,4,256.1,3.6,-1.6,0.84,-0.08,0.17},
{4,10,5,496.9,6,0.36,0.08,0.27,-0.23},
{4,11,0,109,2.4,4.24,-0,0,0},
{4,11,1,445.5,6.1,-2.13,0.83,-0.58,0.57},
{4,11,2,604.9,9.7,7.23,-0.42,-1.37,0.15},
{4,11,3,70.1,1.2,0.7,1.18,0.19,-0.51},
{4,11,4,360.9,7.2,-5.7,-3.4,-0.95,-2.69},
{4,12,0,430.6,8.5,1.86,-0,0,0},
{4,12,1,194.7,2.4,0.44,2.07,2.3,-1.65},
{4,12,2,188.5,2.4,0.12,-0.34,0.09,0.04},
{4,12,3,161.8,2.4,-0.44,-2.62,1.16,-0.4},
{4,12,4,588.4,8.4,0.55,0.29,0.53,-0.5},
{4,13,0,224.7,4.8,0.03,-0,0,0},
{4,13,1,466.2,7.2,5.24,-3.15,-1.56,1.43},
{4,13,2,198,2.4,0.45,-0.12,-0.2,0.12},
{4,13,3,382.3,4.8,7.77,5.65,-0.75,-4.97},
{4,14,0,253.4,4.8,-0.85,-0,0,0},
{4,14,1,442.7,7.2,-2.06,1.33,0.97,1.76},
{4,14,2,483.4,7.2,0.05,-0.11,0.01,0.01},
{5,0,1,429.5,8.5,-0,-17.83,0,0},
{5,0,2,1364.3,12.2,-16.95,-0,0,0},
{5,0,3,258.7,3.6,-0,-17.04,0,0},
{5,0,4,84.9,1.2,-2.48,-0,0,0},
{5,0,5,65.4,2.4,-0,-0.58,0,0},
{5,0,6,73.7,2.4,0.45,-0,0,0},
{5,0,7,487,7.2,0,2.39,0,0},
{5,1,0,929.6,8.5,-0,-1.52,0,0},
{5,1,1,101,1.2,-0.52,0.5,0.2,0.46},
{5,1,2,437.7,6.1,-0.19,1.04,0.41,0.16},
{5,1,3,222.3,2.4,6.78,-4.36,-1.23,2.79},
{5,1,4,109.2,2.4,-0.95,-0.36,-0.26,-0.27},
{5,1,5,443.2,4.8,5.49,-0.69,-0.83,0.21},
{5,1,6,108.8,1.2,0,0,-0,-0.01},
{5,1,7,315.8,3.6,-2.81,2.32,-0.21,0.57},
{5,2,0,479.4,9.7,-0,-0.71,0,0},
{5,2,1,821.1,10.9,3.99,2.78,-1.86,-9.98},
{5,2,2,906.9,8.5,-1.75,10.49,1.8,0.56},
{5,2,3,614.6,6.1,8.57,-8.56,-0.4,4.49},
{5,2,4,439.1,3.6,1.18,-2.48,0.67,0.84},
{5,2,5,123.5,1.2,-1.77,-0.36,-1.35,-1.59},
{5,2,6,151,2.4,0.05,0.08,-0.09,0.14},
{5,2,7,198.9,2.4,0.36,-0.4,0.02,0.22},
{5,3,0,278.5,4.9,0,5.9,0,0},
{5,3,1,621.4,10.9,3.39,-0.55,-1.55,0.94},
{5,3,2,55.9,1.2,-0.45,1.94,0.35,0.16},
{5,3,3,603.5,8.5,-0.12,0.5,0.32,0.74},
{5,3,4,41.2,1.2,0.22,0.24,0.09,-0.22},
{5,3,5,94.4,1.2,-4.97,3.75,-0.41,1.79},
{5,3,6,124.4,1.2,-0.88,3.33,1.18,1.07},
{5,4,0,181.2,3.6,-0,-8.21,0,0},
{5,4,1,263.8,3.6,-0.28,8.1,1.21,0.36},
{5,4,2,507.9,7.3,-0.24,-0.33,0.09,-0.13},
{5,4,3,452.8,6.1,-0.16,-4.84,1.82,-0.28},
{5,4,4,209.7,2.4,-0.5,-1.22,0.48,-0.14},
{5,4,5,415.1,4.8,3.65,-7.97,2.13,2.5},
{5,4,6,178.7,2.4,-0.91,1.88,0.6,0.71},
{5,5,0,374.4,8.5,-0,-12.82,0,0},
{5,5,1,333,4.9,-1.25,0.65,-0.23,0.64},
{5,5,2,416.6,6.1,-2.12,-2.88,0.19,-2.15},
{5,5,3,145.6,1.2,-0.22,-3.06,1.53,-1.28},
{5,5,4,144.2,1.2,-1.41,5.24,0.93,0.47},
{5,5,5,245.6,2.4,0.38,1.57,1.03,-0.77},
{5,5,6,408,3.6,-0.59,0.77,-1.13,-0.79},
{5,6,0,349.9,7.3,-0,-0.39,0,0},
{5,6,1,183.4,2.4,2.1,1.51,-1.54,-1.5},
{5,6,2,463.7,7.3,-0.85,1.59,1.9,0.72},
{5,6,3,320.2,3.6,-3.36,1.87,-1.01,4.8},
{5,6,4,344,3.6,-0.85,-0.4,-0.07,-0.09},
{5,6,5,235.8,3.6,1.84,2.05,0.33,-0.81},
{5,6,6,248.5,2.4,-0.38,-0.11,-0.34,0},
{5,7,0,204,3.6,0,4.73,0,0},
{5,7,1,537.7,7.3,1.4,0.27,-0.69,-0.36},
{5,7,2,214.7,2.4,-1.31,-6.98,4.67,-1.55},
{5,7,3,596.3,12.1,-0.04,-0.13,0.04,-0.02},
{5,7,4,158.6,2.4,3,-3.34,0.52,2.41},
{5,7,5,529.2,6,-1.33,-0.41,-0.3,-0.07},
{5,7,6,401.5,4.8,-0.11,-0.09,0.29,-0.14},
{5,8,0,257.2,4.9,0,0.25,0,0},
{5,8,1,508.2,7.3,8.88,3.42,-2.25,-1.85},
{5,8,2,486.1,7.3,-2.28,-3.29,0.86,-2.26},
{5,8,3,312.5,4.8,5.51,-2.7,-0.61,0.79},
{5,8,4,476.5,6,4.96,0.88,-1.09,-0.52},
{5,8,5,345.3,3.6,3.43,7.66,0.2,-2.94},
{5,9,0,441.3,9.7,-0,-3.84,0,0},
{5,9,1,327.2,4.8,-0.57,0.96,0.24,0.27},
{5,9,2,193.8,2.4,-0.48,-0.41,0.98,0.09},
{5,9,3,507.1,7.3,3.65,0.71,-1.18,-0.48},
{5,9,4,315.4,4.8,0.23,0.75,0.14,-0.11},
{5,9,5,213.5,2.4,-0.15,-0.87,0.09,-0.03},
{5,10,0,197.4,3.6,-0,-3.5,0,0},
{5,10,1,182.9,2.4,-5.33,1.2,-2.13,1.59},
{5,10,2,344.9,4.8,-0.81,1.31,0.31,1.68},
{5,10,3,310.7,4.8,10.18,4.01,-2.87,-2.74},
{5,10,4,100.2,1.2,-1.91,3.78,0.87,1.18},
{5,10,5,362.8,4.8,10.54,-11.75,0.61,5.48},
{5,11,0,9.7,8.5,0,0.03,0,0},
{5,11,1,125.8,2.4,-3.48,2.41,-0.04,0.31},
{5,11,2,218.8,3.6,0.93,-3.55,1.87,1.17},
{5,11,3,181.2,2.4,-0.31,-0.2,-0.02,-0.27},
{5,11,4,358.3,4.8,-3.49,-8.08,4,-2.94},
{5,12,1,215.1,4.8,1.09,-1.65,0.28,1.02},
{5,12,2,378,4.8,-0.16,-0.06,-0.02,-0.01},
{5,12,3,73.6,2.4,0.19,1.92,0.68,-0.14},
{5,13,0,234.2,6,-0,-0.11,0,0},
{5,13,1,218.5,4.8,0.09,-0.39,0.22,-0.01},
{5,13,2,417.4,8.4,-1.14,0.81,-0.32,0.47},
{5,13,3,250.7,4.8,0.98,-3.47,0.89,0.57},
{5,14,0,542.6,10.9,0,0.18,0,0},
{5,14,1,614.8,12.1,0.09,-1.85,1.32,1.01},
{6,0,0,875.5,6.1,0.15,-0,0,0},
{6,0,1,351.3,7.3,0,0.61,0,0},
{6,0,2,462.9,9.7,-1.1,-0,0,0},
{6,0,3,32.8,1.2,0,0.03,0,0},
{6,0,4,441.3,6.1,0.29,-0,0,0},
{6,0,5,71.4,1.2,-0,-4.32,0,0},
{6,0,6,759.6,15.7,-6.73,-0,0,0},
{6,1,0,556.9,10.9,-6.62,-0,0,0},
{6,1,1,521.5,7.3,-6.27,-12.63,1.69,-3.18},
{6,1,2,345.1,4.9,1.78,-2.48,0.53,1.84},
{6,1,3,647,13.4,-4.65,4.99,0.49,5.28},
{6,1,4,247.3,2.4,6.23,-4,-2.15,3.8},
{6,1,5,612.3,8.5,-0.46,8.38,2.75,0.45},
{6,1,6,602.6,7.2,-1.64,8.92,1.23,0.41},
{6,2,0,31.6,4.9,-0.1,-0,0,0},
{6,2,1,373.2,6.1,-1.26,-3.9,1.61,-1.55},
{6,2,2,102,1.2,3.93,-0.94,-1.38,0.89},
{6,2,3,165.1,1.2,-0.04,0.38,-0,0.4},
{6,2,4,160,2.4,3.74,2.11,-2.53,-2.68},
{6,2,5,290.4,2.4,0.02,-0.13,1.71,0.61},
{6,2,6,257.2,2.4,-0.2,0.1,0.18,-0.15},
{6,3,0,437.6,8.5,-0.1,-0,0,0},
{6,3,1,386.4,4.9,-16.37,-10.53,-1.8,-2.84},
{6,3,2,174.9,2.4,2.2,-0.48,-0.55,0.22},
{6,3,3,26.7,2.4,-0.23,0.01,-0.09,0.04},
{6,3,4,235.1,2.4,-0.01,0.26,0.11,-0.23},
{6,3,5,349.6,3.6,7.63,4.89,-1.86,-3.64},
{6,3,6,514.2,6,-0.04,0.03,-0.06,0.06},
{6,4,0,323.2,6.1,13.92,-0,0,0},
{6,4,1,375.4,4.9,-0,1.14,0.21,0.03},
{6,4,2,829.2,17,0.14,0.65,0.53,-0.38},
{6,4,3,838.1,17,-7.86,2.7,-1.27,1.07},
{6,4,4,112.7,1.2,-3.77,0.81,-0.71,0.4},
{6,4,5,304.7,3.6,10.97,-1.73,-4.88,1.49},
{6,4,6,181,2.4,0.21,1.11,0.53,-0.57},
{6,5,0,167.6,3.6,-10.82,-0,0,0},
{6,5,1,205.2,2.4,-0.73,-0.2,-0.41,-1.02},
{6,5,2,422.3,4.9,4.78,0.41,-1.34,-0.31},
{6,5,3,180.7,2.4,-6.67,-3.2,-1.85,-2.35},
{6,5,4,181.6,2.4,-9.68,-4.98,-2.08,-2.87},
{6,5,6,314.8,3.6,-0.32,0.1,-0.03,0.03},
{6,6,0,177.2,3.6,1.96,-0,0,0},
{6,6,1,417.5,6.1,0.28,-6.39,1.72,0.15},
{6,6,2,146.8,2.4,-0.89,0.35,-2.68,-0.55},
{6,6,3,60.6,1.2,0.09,0.14,0.33,-0.33},
{6,6,4,214.2,2.4,-2.44,0.48,-1.51,0.48},
{6,6,5,224.7,2.4,2.17,1.07,-0.85,-1.3},
{6,6,6,127.8,1.2,-4.47,-0.88,-1.8,-0.82},
{6,7,0,144.4,3.6,-3.99,-0,0,0},
{6,7,1,322.6,4.9,1.72,-13.91,4.31,-0.42},
{6,7,2,275.2,3.6,-7.71,-3.84,-0.91,-2.02},
{6,7,3,500.2,7.3,0.22,3.03,3.76,0.46},
{6,7,4,85.9,1.2,-0.29,0.27,-0.44,0.11},
{6,7,5,32.6,2.4,-0,0.11,0.06,-0.06},
{6,8,0,134.6,2.4,7.13,-0,0,0},
{6,8,1,344.2,4.8,-0.2,-0.29,0.02,-0.05},
{6,8,2,381.6,4.8,3.05,-0.15,-2.24,-0.76},
{6,8,3,153.7,2.4,-0.02,0.11,0.53,-0.12},
{6,8,4,297.3,4.8,-0.73,-0.96,-0.04,-0.66},
{6,8,5,211.1,2.4,-0.03,-0.16,0.01,-0.01},
{6,9,0,603.2,12.1,-0,-0,0,0},
{6,9,1,415.4,6.1,4.31,-1.93,-1.41,1.92},
{6,9,2,268.7,3.6,-1.43,1.09,1.53,2.17},
{6,9,3,117.3,2.4,-0.85,-0.3,-0.29,-0.31},
{6,9,4,501.2,7.2,-0.44,1.74,0.39,0.22},
{6,9,5,353.2,3.6,8.72,-2.36,-4.28,2.5},
{6,10,0,3.6,13.3,0.08,-0,0,0},
{6,10,1,174.2,2.4,1.53,1.38,-0.2,-1.05},
{6,10,2,189.9,2.4,-4.25,0.51,-3.24,0.33},
{6,10,3,694.7,9.7,-0.18,0.09,0.05,-0.13},
{6,10,4,254.6,3.6,-0.16,0.75,0.18,0.14},
{6,11,0,258.7,4.8,2.64,-0,0,0},
{6,11,1,599.6,8.5,5.52,-11.85,2.59,3.11},
{6,11,2,403.5,6,1.07,-1.44,0.08,0.13},
{6,11,3,336.7,4.8,-5.6,-4.79,-0.25,-2.27},
{6,11,4,409.8,4.8,2.05,1.07,-1.3,-0.4},
{6,12,0,132.9,3.6,-0.5,-0,0,0},
{6,12,1,78.5,2.4,-0.99,-1.67,0.01,-0.15},
{6,12,2,255.9,3.6,-2.19,2.4,-3.27,3.08},
{6,12,3,185.7,2.4,-1.58,1.67,-0.53,2.32},
{6,13,0,530.8,10.9,1.97,-0,0,0},
{6,13,1,477.6,7.2,-0.42,0.38,-0.02,0.1},
{6,13,2,241.1,3.6,-0.06,-0.04,-0.16,-0.08},
{7,0,1,223.5,2.4,0,2.21,0,0},
{7,0,2,15.8,3.6,0.31,-0,0,0},
{7,0,3,179.5,2.4,0,8.67,0,0},
{7,0,4,221.6,2.4,5.26,-0,0,0},
{7,0,5,373.6,4.8,0,19.03,0,0},
{7,0,6,523.6,7.2,0.09,-0,0,0},
{7,1,0,195.6,3.6,0,0.65,0,0},
{7,1,1,188.3,2.4,-0.32,0.04,-0.06,0.09},
{7,1,2,378.7,4.9,-0.36,-1.13,4.89,1.16},
{7,1,3,286.2,3.6,-1,-3.48,0.7,-0.46},
{7,1,4,299.1,3.6,0.57,1.49,0.54,-0.49},
{7,1,5,742.3,15.7,-0.47,-0.14,-0.02,-0.02},
{7,1,6,246.1,2.4,-0.04,2.95,2.11,1.84},
{7,2,0,35.2,4.9,0,0.22,0,0},
{7,2,1,332.7,3.6,-0.35,3.6,0.85,0.16},
{7,2,2,128.7,1.2,0.47,9.71,0.86,0.07},
{7,2,3,675.4,9.7,3.91,-2.41,-0.8,1.53},
{7,2,4,109,1.2,0.09,1.09,0.54,-1.16},
{7,2,5,540.4,6,-0.18,-0.63,0.11,1.16},
{7,2,6,281.1,3.6,-3.51,-5.84,1.33,-2.09},
{7,3,0,191.9,3.6,0,0.19,0,0},
{7,3,1,173.6,2.4,-10.93,-2.53,-4.7,-2.49},
{7,3,2,71.6,1.2,-0.53,-0.26,-0.23,-0.46},
{7,3,3,503.1,6.1,-17.61,-2.88,-6.34,-2.27},
{7,3,4,279.7,2.4,3.03,-2.76,-0.01,0.82},
{7,3,5,372.2,3.6,-1.88,0.08,-2.51,-0.21},
{7,3,6,273.8,2.4,4.53,4.21,-0.14,-0.43},
{7,4,0,295,6.1,0,0.28,0,0},
{7,4,1,270.7,3.6,-5.7,-5.38,-0.08,-1.39},
{7,4,2,111.6,1.2,-0.72,1.3,0.69,0.72},
{7,4,3,676.2,9.7,4.04,-2.05,-2.4,4.45},
{7,4,4,387.3,3.6,1.34,1.72,0.06,-0.25},
{7,4,5,404.7,3.6,-0.25,-0.82,0.24,-0.21},
{7,4,6,520.8,4.8,-0.95,1.92,0.35,1.18},
{7,5,0,400.4,7.3,-0,-7.39,0,0},
{7,5,1,34,3.6,0.28,-0.21,-0.01,0.16},
{7,5,2,538.4,8.5,-2.16,-4.13,1.85,-3.74},
{7,5,3,402.2,4.8,-2.31,-0.7,-1.19,-0.81},
{7,5,4,752.5,10.9,-3.11,3.95,0.23,2.53},
{7,5,5,483.1,4.8,5.45,-2.56,-1.13,1.14},
{7,5,6,169.9,1.2,-8.24,-4.62,-2.12,-3.04},
{7,6,0,490,10.9,0,12.46,0,0},
{7,6,1,506.9,7.3,0.5,0.53,0.07,-0.58},
{7,6,2,404.8,6.1,-0.44,-6.1,1.86,-0.26},
{7,6,3,204.6,2.4,-5.51,0.7,-0.56,0.24},
{7,6,4,555,8.5,6.01,-8.09,0.75,2.38},
{7,6,5,783.4,8.4,0.01,0.99,0.33,0.06},
{7,7,0,129.7,2.4,0,6.71,0,0},
{7,7,1,513.8,7.3,7.01,-0.77,-3.12,0.37},
{7,7,2,112.6,2.4,0.33,-5.35,2.32,0.28},
{7,7,3,505.8,6,-1.46,1.6,-0.14,1.2},
{7,7,4,385.5,4.8,0.71,8.19,3.5,-0.62},
{7,7,5,521.1,7.2,-5.24,-0.4,-0.85,0.1},
{7,8,0,76.3,2.4,-0,-1.04,0,0},
{7,8,1,145.3,2.4,-0.17,0.47,0.18,0.15},
{7,8,2,191.2,2.4,1.49,3.52,2.16,-1.02},
{7,8,3,43.5,2.4,-0.06,-0.2,0.15,0.05},
{7,8,4,70,1.2,-0.77,0.75,-0.11,0.24},
{7,8,5,24.1,3.6,0.16,0.38,0,-0.01},
{7,9,0,58.1,2.4,0,1.77,0,0},
{7,9,1,187.6,2.4,-1,2.05,0.94,1.05},
{7,9,2,70.1,2.4,0.03,-0.01,0.02,0.01},
{7,9,3,367.3,4.8,0.68,0.2,0.08,-0.56},
{7,9,4,230.5,3.6,0.81,-4.28,0.91,0.56},
{7,10,0,302.3,8.5,-0,-6.81,0,0},
{7,10,1,280.5,6,0.32,1.13,0.58,-0.36},
{7,10,2,186.1,2.4,1.59,-5.81,1.18,0.46},
{7,10,3,191.9,2.4,2.13,5.06,0.74,-0.14},
{7,10,4,317,4.8,6.93,4.84,-1.13,-4.39},
{7,11,0,85.8,2.4,0,0.58,0,0},
{7,11,1,158.2,2.4,-2.24,-1.07,-1.22,-0.61},
{7,11,2,260.7,3.6,0.03,-0.26,0.57,0.12},
{7,11,3,349.7,4.8,0.47,-0.72,-2.02,-0.33},
{7,12,0,120.7,3.6,-0,-0.43,0,0},
{7,12,1,63.9,2.4,-1.27,1.2,-0,0.61},
{7,12,2,349.7,4.8,0.08,-2.51,0.35,-0.03},
{7,13,0,169.9,3.6,0,7.26,0,0},
{7,13,1,127.7,2.4,1.07,3.56,1.51,-0.76},
{8,0,0,299.8,8.5,35.42,-0,0,0},
{8,0,1,465.9,9.7,0,3.11,0,0},
{8,0,2,17,2.4,-0.46,-0,0,0},
{8,0,3,300.5,4.8,-0,-12.73,0,0},
{8,0,4,160.9,2.4,-10.4,-0,0,0},
{8,0,5,41.1,2.4,-0,-1.94,0,0},
{8,0,6,278.4,3.6,-0.45,-0,0,0},
{8,1,0,564.3,10.9,2.72,-0,0,0},
{8,1,1,78.9,1.2,0.75,1.77,0.75,-0.66},
{8,1,2,499.6,8.5,-0.8,-0.1,-1.13,0.16},
{8,1,3,127.2,1.2,0.93,2.4,1.34,-1.88},
{8,1,4,104,1.2,-0.26,-0.61,0.31,-0.44},
{8,1,5,154.6,1.2,0.81,1.18,0.31,-0.72},
{8,1,6,341.1,3.6,1.88,0.36,-0.3,-0.23},
{8,2,0,202.6,3.6,-0.1,-0,0,0},
{8,2,1,418.5,6.1,0.17,-1.35,1.08,1.46},
{8,2,2,166.1,2.4,-7.11,0.95,-1.58,0.33},
{8,2,3,110.2,1.2,-0.13,-0.77,1.27,0.16},
{8,2,4,235.9,2.4,-1.26,2.67,1.42,0.94},
{8,2,5,314,3.6,6.98,-2.13,-0.46,0.22},
{8,2,6,590.5,8.4,7.11,-0.09,-2.86,0.1},
{8,3,0,21.8,7.3,-0.8,-0,0,0},
{8,3,1,254.7,3.6,0.2,-0.01,-0.4,0.8},
{8,3,2,275.2,3.6,-0.93,-0.02,-0.74,0.47},
{8,3,3,195,2.4,-0.1,0.06,0.01,0.02},
{8,3,4,62.9,1.2,-0.63,0.91,0.16,0.39},
{8,3,5,591.6,7.2,-0.25,-0.05,0.14,0.32},
{8,4,0,84.9,3.6,-0.29,-0,0,0},
{8,4,1,134.6,2.4,0.48,0.35,-0.49,-0.76},
{8,4,2,422.9,4.8,-3.69,-0.59,-2.45,-0.4},
{8,4,3,162.2,2.4,0.04,0.06,0.02,-0.07},
{8,4,4,488.4,4.8,-0.01,-1.61,1.86,0.96},
{8,4,5,439.3,4.8,1.05,0.89,-0.19,-0.43},
{8,5,0,621.9,12.1,-22.18,-0,0,0},
{8,5,1,152.7,2.4,2.33,6.4,0.81,-0.44},
{8,5,2,265.3,3.6,-0.07,-0.81,0.28,-0.11},
{8,5,3,43.6,2.4,-0.11,0.38,0.18,0.06},
{8,5,4,339.6,3.6,3.05,0.16,-0.64,-0.2},
{8,5,5,349.9,3.6,-0.69,-2.01,0.79,-0.43},
{8,6,0,147.8,3.6,-15.24,-0,0,0},
{8,6,1,393.7,6.1,-0.81,4,0.76,0.5},
{8,6,2,185.2,2.4,0.9,0.12,-0.19,-0.07},
{8,6,3,251.6,2.4,-0.14,-1.42,1.17,-0.55},
{8,6,4,94.2,1.2,1.86,-0.51,-0.33,0.42},
{8,6,5,475.1,6,0.72,0.64,0.01,-0.2},
{8,7,0,261.5,4.8,-13.79,-0,0,0},
{8,7,1,854.7,8.5,2.76,-3.1,0.06,4.67},
{8,7,2,612.2,8.5,-0.19,0.09,-1.13,-0.85},
{8,7,3,91.9,2.4,0.22,0.63,0.67,-0.23},
{8,7,4,198,2.4,-1.08,0.16,-0.41,0.12},
{8,7,5,588.1,8.4,1.29,-0.94,-0.1,1.2},
{8,8,0,634,13.3,-2.19,-0,0,0},
{8,8,1,370.2,4.8,4.87,4.41,-0.16,-1.19},
{8,8,2,216.4,3.6,-10.31,0.31,-1.21,0.14},
{8,8,3,357.5,4.8,-1.58,2.78,1.48,0.48},
{8,8,4,200.2,2.4,0.45,-1.58,0.11,0.06},
{8,9,0,391.7,7.3,-1.4,-0,0,0},
{8,9,1,423.1,6,0.91,0.38,-0.31,-0.65},
{8,9,2,103.9,2.4,0.21,0.04,-0.01,-0.07},
{8,9,3,697.6,9.7,1.7,1.61,-0.14,-0.34},
{8,9,4,212.1,2.4,-0.39,-0.05,1.13,-0.65},
{8,10,0,205.4,3.6,1.82,-0,0,0},
{8,10,1,413,6,0.88,2.65,0.36,-0.28},
{8,10,2,95.4,2.4,2.34,0.23,-1.03,-0.27},
{8,10,3,818.8,22.9,3.39,-8.68,1.87,2.26},
{8,11,0,173.8,4.8,-4.86,-0,0,0},
{8,11,1,275.1,6,-0.21,0.05,0.01,-0.54},
{8,11,2,208.6,4.8,2.62,-2.56,-0.27,1.23},
{8,12,0,94,2.4,2.56,-0,0,0},
{8,12,1,249.5,3.6,-1.09,-1.76,0.39,-0.6},
{9,0,1,47.3,1.2,0,0.24,0,0},
{9,0,2,93.3,1.2,0.02,-0,0,0},
{9,0,3,710.3,12.1,-0,-0.48,0,0},
{9,0,4,271.9,3.6,-6.4,-0,0,0},
{9,1,0,81.2,2.4,0,0.51,0,0},
{9,1,1,242.4,3.6,6.54,1.25,-6.55,-1.03},
{9,1,2,260.4,2.4,1.02,2.19,1.33,-2.72},
{9,1,3,105.3,1.2,0.24,0.05,-0.6,-0.08},
{9,1,4,224.8,2.4,0.96,-4.82,1.48,0.63},
{9,1,5,416.2,3.6,8.46,1.64,-3.91,-1.57},
{9,2,0,143,3.6,0,0.72,0,0},
{9,2,1,201.2,2.4,1.96,1.2,-0.91,-2.52},
{9,2,2,187.7,2.4,-0.31,0.27,0.35,0.3},
{9,2,3,333.9,3.6,8.67,-8.67,0.02,7.03},
{9,2,4,242.9,2.4,-1.37,0.02,-0.37,0.03},
{9,2,5,513.8,7.2,1.27,-2.06,0.48,0.66},
{9,3,0,35.1,7.3,0,1.57,0,0},
{9,3,1,207.2,2.4,2.64,1.72,-0.24,-0.64},
{9,3,2,359.6,3.6,-0.17,-0.29,-0.88,-0.9},
{9,3,3,298.8,3.6,0.22,0.1,-0.57,-0.22},
{9,3,4,147.4,1.2,-0.39,-3.16,2.04,-0.27},
{9,3,5,168.8,1.2,2.2,1.22,-0.08,-0.2},
{9,4,0,340.4,7.3,-0,-1.98,0,0},
{9,4,1,467.5,6.1,-1.21,2.2,0.64,0.81},
{9,4,2,182.8,2.4,-0.99,-13.81,2.26,-0.06},
{9,4,3,166.9,2.4,-0.38,2.12,0.45,-0.06},
{9,4,4,175.1,2.4,-0.1,3.01,2.15,0.24},
{9,4,5,347.2,3.6,-0.21,0.07,-0.24,0.16},
{9,5,0,450.4,8.5,-0,-2.33,0,0},
{9,5,1,663.4,9.7,-2.07,3.73,0.73,1.36},
{9,5,2,157.3,2.4,1.63,6.32,3.35,-2.15},
{9,5,3,371.1,4.8,-0.67,-0.14,-0.39,0.03},
{9,5,4,549.2,6,-0.06,-0.95,0.22,-0.03},
{9,5,5,382,4.8,-1.21,1.81,0.6,0.56},
{9,6,0,611.1,12.1,0,0.55,0,0},
{9,6,1,340,4.8,3.18,-1.75,-0.47,0.88},
{9,6,2,199.5,3.6,-0.25,4.4,2.24,0.17},
{9,6,3,304.4,3.6,-0.03,-1.2,0.14,-1.49},
{9,6,4,417.4,4.8,0.79,-0.43,-0.03,0.04},
{9,7,0,88.3,2.4,0,0.21,0,0},
{9,7,1,273.3,3.6,0.22,0.01,-0.32,-0.36},
{9,7,2,168,2.4,-1.71,-3.44,0.24,-0.98},
{9,7,3,282.5,3.6,0.09,-0.19,0.05,0.06},
{9,7,4,303.8,3.6,-0.1,0.08,-0.06,0.24},
{9,8,0,49.6,4.8,-0,-0.07,0,0},
{9,8,1,180,2.4,1.39,-0.6,-0.4,0.58},
{9,8,2,301.9,4.8,0.15,-1.13,0.67,0.37},
{9,8,3,518.8,8.4,3,1.15,-0.64,-0.67},
{9,9,0,213.7,4.8,0,4.26,0,0},
{9,9,1,575.9,8.5,-14.09,-1.71,-6.77,-0.83},
{9,9,2,623.9,8.4,-0.15,0.04,0.5,0.1},
{9,9,3,699.2,9.6,-2.1,-0.04,-1.17,0.08},
{9,10,0,63.9,3.6,0,0.61,0,0},
{9,10,1,265.4,3.6,3.63,-1.92,-0.41,0.29},
{9,10,2,689.6,9.6,-0.01,-0.13,0.34,-0.06},
{9,11,0,49.4,3.6,0,0.19,0,0},
{9,11,1,174.7,2.4,-0.05,-0.22,0.08,-0.02},
{10,0,0,38.7,6.1,0.38,-0,0,0},
{10,0,1,121,2.4,-0,-2.3,0,0},
{10,0,2,225,3.6,-15.35,-0,0,0},
{10,0,3,350.5,4.8,-0,-11.28,0,0},
{10,0,4,135.2,2.4,1.4,-0,0,0},
{10,1,0,393.4,7.3,-1.63,-0,0,0},
{10,1,1,142.8,1.2,-3.74,0.6,-1.67,0.52},
{10,1,2,323,3.6,7.9,-7.23,0.11,0.61},
{10,1,3,336,3.6,0.44,1.24,0.29,-0.98},
{10,1,4,630,8.4,-2.32,-1.62,-0.31,-0.81},
{10,2,0,447.9,8.5,-7.57,-0,0,0},
{10,2,1,544.6,8.5,-0.28,0.47,0.11,0.29},
{10,2,2,344.7,4.8,-4.45,-0.11,-3.85,-1.14},
{10,2,3,234.4,2.4,0.3,-0.07,-0.09,0.05},
{10,2,4,342.7,4.8,4.64,-3.87,-0.24,1.67},
{10,3,0,265,4.8,-2.94,-0,0,0},
{10,3,1,359.3,4.8,1.74,3.13,1.35,-3.08},
{10,3,2,443.8,6,0.95,1.11,0.1,-0.5},
{10,3,3,212.6,2.4,-0.08,0.28,0.02,0.01},
{10,3,4,242.5,2.4,1.03,0.78,-0.1,-0.55},
{10,4,0,428.2,8.5,-9.69,-0,0,0},
{10,4,1,506.8,7.3,3,1.22,-1.09,-0.99},
{10,4,3,253.6,2.4,-6.01,1.3,-1.72,0.73},
{10,4,4,422.1,4.8,-7.34,0.26,-0.99,0.15},
{10,5,0,91.9,3.6,0.84,-0,0,0},
{10,5,1,50.8,4.8,0.16,0.57,0.05,-0.03},
{10,5,2,238,2.4,3.84,-1.35,-1.93,0.89},
{10,5,3,503.4,7.2,3.2,-3.87,0.12,1.95},
{10,5,4,184.4,2.4,4.83,-1.26,-1.87,1.12},
{10,6,1,122,2.4,-1.68,1.59,0.11,0.53},
{10,6,2,26.6,6,-0.03,-0.05,-0.01,-0.04},
{10,6,3,346.3,3.6,-3.76,-2.93,-0.79,-2.33},
{10,7,0,273,6,-0.06,-0,0,0},
{10,7,1,233.1,3.6,-0.58,-0.12,-0.2,-0.13},
{10,7,2,211.2,3.6,1.86,1.39,-0.54,-0.67},
{10,7,3,406.3,4.8,-1.18,-0.82,-0.41,-0.91},
{10,8,0,251.1,4.8,-5.96,-0,0,0},
{10,8,1,644.4,9.7,-0.27,-1.71,1.44,0.82},
{10,8,2,221.9,3.6,-5.17,1.27,-0.48,0.1},
{10,9,0,37.4,4.8,-0.14,-0,0,0},
{10,9,1,393.1,6,-0.27,-0.13,-0.14,-0.18},
{10,9,2,139.8,2.4,0.28,0.13,0.45,0.3},
{11,0,1,375.9,7.3,-0,-3.57,0,0},
{11,0,2,152.2,2.4,-1.14,-0,0,0},
{11,0,4,662.9,13.3,-1.78,-0,0,0},
{11,1,0,265.9,4.8,-0,-13.97,0,0},
{11,1,1,72.5,2.4,0.05,0.01,-0.04,-0.22},
{11,1,2,163.1,2.4,0.12,0.28,0.46,-0.47},
{11,1,3,359.6,3.6,0.9,-1.28,0.25,0.23},
{11,1,4,184.4,2.4,0.69,-6.04,0.95,0.52},
{11,2,0,117.2,3.6,0,0.02,0,0},
{11,2,1,357.7,4.8,0.31,-0.35,-0.14,0.47},
{11,2,2,159.4,2.4,-0.11,0.22,0.12,0.12},
{11,2,3,503.2,9.7,-0.02,0.1,0.22,-0.02},
{11,3,0,870,25.4,0,0.27,0,0},
{11,3,1,196.9,2.4,-0.24,1.42,0.54,0.26},
{11,3,2,285,3.6,2.54,-11.95,4.22,1.97},
{11,3,3,19.3,3.6,0.1,0.42,0.08,-0.03},
{11,4,0,126.8,4.8,0,0.64,0,0},
{11,4,1,144.9,2.4,-0.36,0.54,-1.55,-0.45},
{11,4,2,317.5,3.6,0.18,1.05,0.77,-0.2},
{11,4,3,125.4,1.2,0.33,0.23,-1.07,0.42},
{11,5,0,206.5,4.8,0,5.32,0,0},
{11,5,1,280.1,3.6,0.09,-2.61,0.41,-0.02},
{11,5,2,290.8,4.8,0.18,0.18,-0,-0.07},
{11,5,3,512.3,7.2,-0.3,0.1,-0.08,0.06},
{11,6,0,414,8.4,-0,-0.32,0,0},
{11,6,1,433.2,6,-2.74,-9.78,3.07,-2.06},
{11,6,2,305.1,3.6,0.06,0.04,0.05,0.3},
{11,7,0,208.7,4.8,0,1.77,0,0},
{11,7,1,432.9,6,0.83,-2.2,0.27,0.14},
{11,7,2,499,7.2,-1.09,1.91,0.26,0.28},
{11,8,0,165.1,3.6,0,4.09,0,0},
{11,8,1,343.4,4.8,1.93,-4.61,1.8,1.9},
{12,0,0,457.5,12.1,-1.25,-0,0,0},
{12,0,1,505.6,9.7,0,3.34,0,0},
{12,0,2,253.3,3.6,-8.27,-0,0,0},
{12,1,0,755.6,14.5,0.33,-0,0,0},
{12,1,1,260.7,3.6,-0.74,0.15,-0.19,0.08},
{12,1,2,513.8,7.2,-1.17,-0.08,-0.65,-0.28},
{12,2,0,47.1,12.1,1.32,-0,0,0},
{12,2,1,451.3,6,-0.46,0.51,0.03,0.19},
{12,2,2,162.8,2.4,-0.11,0.18,-0.18,-0.03},
{12,3,0,774.6,15.7,7.24,-0,0,0},
{12,3,1,308.8,3.6,-1.33,-3.83,0.28,-0.19},
{12,3,2,531.7,8.4,0.21,-0.31,-0.02,0.31},
{12,4,0,518.6,10.9,-0.12,-0,0,0},
{12,4,1,259.3,3.6,-0.64,-0.22,-0.1,-0.24},
{12,4,2,653.2,10.8,-0.37,1.13,0.18,0.13},
{12,5,0,350.8,7.2,-16.35,-0,0,0},
{12,5,1,242.3,3.6,-6.99,-5.89,-0.02,-0.96}};
int rnasehkldata_size = sizeof( rnasehkldata ) / sizeof( rnasehkldata[0] );


struct TESTxyzdata { const char* element; float x,y,z,u_iso,occ; };

TESTxyzdata rnasexyzdata[] = {
{"N",45.187,12.906,9.095,0.381,1},
{"O",42.435,14.184,8.265,0.725,1},
{"O",41.943,12.878,6.527,0.751,1},
{"C",42.812,13.495,7.237,0.716,1},
{"C",44.299,13.384,6.812,0.628,1},
{"C",45.241,12.515,7.674,0.452,1},
{"C",46.685,12.547,7.1,0.394,1},
{"O",47.612,13.255,7.476,0.323,1},
{"N",46.794,11.672,6.084,0.444,1},
{"C",48.093,9.185,6.279,0.39,1},
{"C",49.528,9.785,4.235,0.345,1},
{"C",48.253,10.056,5.021,0.423,1},
{"C",48.103,11.539,5.403,0.324,1},
{"C",48.199,12.621,4.353,0.371,1},
{"O",47.298,12.969,3.578,0.295,1},
{"N",49.407,13.203,4.322,0.314,1},
{"O",50.307,15.798,5.009,0.443,1},
{"C",50.798,15.174,3.823,0.309,1},
{"C",49.686,14.243,3.321,0.376,1},
{"C",50.037,13.673,1.946,0.372,1},
{"O",50.494,14.518,1.133,0.501,1},
{"N",49.876,12.516,1.386,0.289,1},
{"C",50.385,12.329,0.007,0.272,1},
{"C",51.491,11.238,0.211,0.245,1},
{"O",51.73,10.839,1.388,0.254,1},
{"N",51.932,10.774,-0.938,0.238,1},
{"C",53.4,7.466,-2.602,0.287,1},
{"O",51.293,8.136,-1.674,0.358,1},
{"C",52.564,8.674,-2.263,0.272,1},
{"C",52.967,9.734,-1.184,0.234,1},
{"C",54.232,10.484,-1.596,0.252,1},
{"O",54.092,11.564,-2.247,0.28,1},
{"N",55.4,10.028,-1.188,0.181,1},
{"C",58.59,12.293,-1.009,0.178,1},
{"C",57.502,10.963,0.829,0.174,1},
{"C",57.258,11.659,-0.505,0.178,1},
{"C",56.661,10.729,-1.577,0.143,1},
{"C",57.59,9.542,-1.997,0.126,1},
{"O",57.577,8.495,-1.285,0.134,1},
{"N",58.281,9.749,-3.068,0.119,1},
{"S",58.644,8.782,-6.092,0.165,1},
{"C",59.837,9.043,-4.746,0.142,1},
{"C",59.21,8.649,-3.442,0.103,1},
{"C",60.312,8.596,-2.377,0.112,1},
{"O",60.651,9.647,-1.84,0.16,1},
{"N",60.815,7.431,-2.09,0.132,1},
{"C",63.607,3.83,-0.269,0.105,1},
{"C",63.176,5.877,1.191,0.169,1},
{"C",63.43,5.308,-0.221,0.135,1},
{"C",62.261,5.661,-1.211,0.08,1},
{"C",61.937,7.18,-1.195,0.111,1},
{"C",63.176,8.04,-1.631,0.155,1},
{"O",63.948,8.686,-0.861,0.154,1},
{"N",63.363,8.068,-2.943,0.13,1},
{"O",63.713,9.243,-5.759,0.259,1},
{"C",64.674,8.507,-4.981,0.169,1},
{"C",64.514,8.842,-3.5,0.19,1},
{"C",64.317,10.294,-3.22,0.228,1},
{"O",65.387,10.965,-3.269,0.218,1},
{"N",63.169,10.881,-2.921,0.193,1},
{"C",61.602,12.757,-3.133,0.14,1},
{"C",62.995,12.289,-2.639,0.167,1},
{"C",63.211,12.599,-1.169,0.174,1},
{"O",63.29,13.785,-0.811,0.211,1},
{"N",63.302,11.641,-0.262,0.184,1},
{"C",60.774,11.852,2.374,0.187,1},
{"C",60.818,9.342,2.603,0.211,1},
{"C",61.313,10.545,1.786,0.189,1},
{"C",62.84,10.645,1.861,0.171,1},
{"C",63.485,11.896,1.176,0.195,1},
{"C",64.985,11.912,1.559,0.255,1},
{"O",65.787,11.418,0.738,0.244,1},
{"N",65.377,12.383,2.734,0.253,1},
{"C",65.547,13.634,4.727,0.287,1},
{"C",64.532,12.983,3.787,0.28,1},
{"C",66.753,12.736,4.607,0.245,1},
{"C",66.795,12.343,3.105,0.222,1},
{"C",67.258,10.934,2.971,0.167,1},
{"O",66.54,9.911,3.213,0.179,1},
{"N",68.557,10.718,2.673,0.205,1},
{"C",70.894,11.037,2.558,0.226,1},
{"C",69.548,11.794,2.401,0.245,1},
{"C",70.647,9.595,2.216,0.213,1},
{"C",69.137,9.388,2.567,0.172,1},
{"C",69.04,8.569,3.87,0.101,1},
{"O",69.036,7.364,3.707,0.129,1},
{"N",68.997,9.29,5.003,0.116,1},
{"O",71.736,11.345,6.212,0.266,1},
{"O",69.702,11.868,5.944,0.205,1},
{"C",70.522,11.17,6.519,0.263,1},
{"C",70.384,10.104,7.552,0.193,1},
{"C",69.09,9.366,7.421,0.169,1},
{"C",68.941,8.492,6.225,0.116,1},
{"C",67.573,7.764,6.267,0.132,1},
{"O",67.484,6.777,6.963,0.122,1},
{"N",66.525,8.231,5.537,0.14,1},
{"C",64.198,8.213,4.637,0.173,1},
{"C",65.261,7.483,5.499,0.138,1},
{"C",65.517,6.142,4.891,0.115,1},
{"O",64.95,5.016,5.254,0.131,1},
{"N",66.337,6.042,3.828,0.112,1},
{"C",68.026,3.62,1.336,0.151,1},
{"O",66.803,5.646,1.081,0.2,1},
{"C",67.634,4.924,1.96,0.117,1},
{"C",66.683,4.779,3.206,0.105,1},
{"C",67.365,3.862,4.215,0.112,1},
{"O",67.11,2.667,4.328,0.12,1},
{"N",68.294,4.448,4.995,0.107,1},
{"O",71.344,4.491,5.033,0.235,1},
{"O",71.576,6.14,6.464,0.224,1},
{"C",71.012,5.114,6.056,0.207,1},
{"C",69.889,4.552,6.864,0.119,1},
{"C",68.991,3.627,5.983,0.082,1},
{"C",68.07,2.929,6.986,0.133,1},
{"O",68.194,1.757,7.316,0.118,1},
{"N",67.127,3.773,7.507,0.154,1},
{"C",64.173,3.788,10.052,0.122,1},
{"O",66.054,5.414,9.591,0.185,1},
{"C",65.214,4.357,9.039,0.118,1},
{"C",66.155,3.218,8.491,0.114,1},
{"C",65.336,2.084,7.886,0.112,1},
{"O",65.11,1.058,8.519,0.155,1},
{"N",64.819,2.248,6.649,0.124,1},
{"C",61.239,2.046,5.537,0.193,1},
{"C",61.979,3.198,3.387,0.182,1},
{"C",62.376,2.75,4.761,0.212,1},
{"C",63.473,1.696,4.682,0.141,1},
{"C",64.001,1.2,6.043,0.12,1},
{"C",64.859,-0.017,5.907,0.127,1},
{"O",64.35,-1.148,6.105,0.141,1},
{"N",66.196,0.138,5.659,0.145,1},
{"N",68.987,0.221,2.623,0.28,1},
{"O",67.348,-1.203,2.864,0.325,1},
{"C",68.27,-0.562,3.439,0.267,1},
{"C",68.447,-0.802,4.924,0.232,1},
{"C",67.051,-1.079,5.55,0.149,1},
{"C",67.2,-1.819,6.871,0.108,1},
{"O",67.163,-3.037,6.741,0.156,1},
{"N",67.266,-1.005,7.918,0.129,1},
{"C",70.076,-1.137,10.322,0.213,1},
{"C",69.387,1.24,11.011,0.158,1},
{"C",69.151,0.07,10.087,0.172,1},
{"C",67.719,-0.52,10.244,0.147,1},
{"C",67.326,-1.591,9.212,0.124,1},
{"C",65.983,-2.268,9.531,0.122,1},
{"O",66.015,-3.313,10.152,0.13,1},
{"N",64.925,-1.607,9.123,0.151,1},
{"C",61.553,1.026,9.516,0.11,1},
{"C",62.444,-0.084,10.133,0.111,1},
{"C",62.484,-1.199,9.104,0.141,1},
{"C",61.121,-2.031,9.142,0.18,1},
{"C",63.624,-2.233,9.452,0.151,1},
{"C",63.504,-3.573,8.766,0.171,1},
{"O",63.034,-4.565,9.376,0.16,1},
{"N",63.954,-3.736,7.523,0.205,1},
{"C",64.324,-4.83,5.282,0.233,1},
{"C",63.905,-5.003,6.748,0.21,1},
{"C",64.764,-6.126,7.313,0.249,1},
{"O",64.43,-7.33,7.273,0.252,1},
{"N",65.894,-5.748,7.9,0.268,1},
{"O",68.431,-5,9.105,0.273,1},
{"C",68.311,-6.155,8.275,0.232,1},
{"C",66.882,-6.703,8.46,0.306,1},
{"C",66.642,-6.948,9.935,0.309,1},
{"O",67.385,-7.684,10.617,0.356,1},
{"N",65.645,-6.303,10.443,0.255,1},
{"O",63.298,-6.328,13.84,0.59,1},
{"O",63.18,-8.634,13.665,0.659,1},
{"C",63.587,-7.481,13.375,0.587,1},
{"C",64.621,-7.625,12.267,0.458,1},
{"C",65.233,-6.292,11.839,0.283,1},
{"C",66.345,-5.787,12.785,0.339,1},
{"O",66.638,-6.285,13.904,0.36,1},
{"N",66.907,-4.705,12.303,0.303,1},
{"C",67.898,-3.974,13.068,0.302,1},
{"C",69.268,-4.558,12.785,0.335,1},
{"O",69.485,-5.142,11.737,0.37,1},
{"N",70.112,-4.263,13.745,0.442,1},
{"C",71.981,-4.117,15.152,0.442,1},
{"C",71.517,-4.593,13.756,0.479,1},
{"C",70.748,-4.044,16.051,0.466,1},
{"C",69.783,-3.531,15.003,0.396,1},
{"C",69.784,-2.071,14.667,0.224,1},
{"O",70.15,-1.596,13.565,0.33,1},
{"N",69.276,-1.415,15.655,0.208,1},
{"C",66.116,-0.067,13.663,0.165,1},
{"C",65.221,-0.845,12.909,0.176,1},
{"C",64.727,-2.062,13.351,0.144,1},
{"C",65.116,-2.56,14.619,0.271,1},
{"C",66.002,-1.794,15.403,0.213,1},
{"C",66.495,-0.565,14.918,0.145,1},
{"C",67.468,0.28,15.771,0.204,1},
{"C",68.993,0.027,15.495,0.223,1},
{"C",69.888,0.817,16.42,0.234,1},
{"O",70.22,0.266,17.487,0.267,1},
{"N",70.124,2.016,15.959,0.19,1},
{"C",70.104,4,14.817,0.224,1},
{"C",69.709,2.554,14.649,0.17,1},
{"C",71.24,4.031,15.845,0.191,1},
{"C",70.969,2.865,16.768,0.206,1},
{"C",70.387,3.291,18.119,0.332,1},
{"O",71.2,3.68,19.02,0.27,1},
{"N",69.075,3.324,18.366,0.235,1},
{"O",70.317,9.853,17.956,0.27,1},
{"C",68.509,6.705,17.397,0.171,1},
{"C",69.167,7.888,17.108,0.197,1},
{"C",69.681,8.654,18.13,0.258,1},
{"C",69.525,8.209,19.465,0.271,1},
{"C",68.837,7.015,19.711,0.286,1},
{"C",68.299,6.231,18.67,0.24,1},
{"C",67.538,4.982,19.094,0.227,1},
{"C",68.345,3.786,19.558,0.228,1},
{"C",67.54,2.671,20.162,0.281,1},
{"O",66.976,1.859,19.394,0.225,1},
{"N",67.58,2.57,21.495,0.317,1},
{"O",67.73,-0.069,23.778,0.535,1},
{"C",67.135,1.251,23.649,0.44,1},
{"C",66.842,1.487,22.177,0.383,1},
{"C",65.31,1.659,21.92,0.295,1},
{"O",64.843,0.487,21.717,0.36,1},
{"N",64.764,2.836,21.841,0.324,1},
{"N",61.162,6.953,22.051,0.685,1},
{"O",62.125,7.583,23.911,0.656,1},
{"C",62.177,6.796,22.921,0.66,1},
{"C",63.169,5.699,22.539,0.609,1},
{"C",63.161,4.818,21.336,0.352,1},
{"C",63.409,3.272,21.506,0.431,1},
{"C",62.882,2.896,20.08,0.426,1},
{"O",61.728,3.162,19.668,0.357,1},
{"N",63.815,2.414,19.25,0.285,1},
{"O",64.605,4.4,16.742,0.226,1},
{"O",66.355,3.308,16.034,0.269,1},
{"C",65.196,3.337,16.578,0.191,1},
{"C",64.634,2.047,17.024,0.199,1},
{"C",63.429,2.092,17.907,0.22,1},
{"C",62.636,0.789,17.994,0.236,1},
{"O",63.011,-0.276,18.532,0.214,1},
{"N",61.425,0.936,17.384,0.197,1},
{"C",60.537,-0.235,17.325,0.174,1},
{"C",59.398,-0.157,18.358,0.166,1},
{"O",58.666,-1.102,18.39,0.23,1},
{"N",59.32,0.803,19.23,0.209,1},
{"C",58.829,3.418,20.749,0.209,1},
{"C",59.517,1.565,22.167,0.295,1},
{"C",58.434,2.021,21.209,0.154,1},
{"C",58.212,0.932,20.184,0.198,1},
{"C",56.952,1.275,19.323,0.175,1},
{"O",56.99,1.864,18.236,0.166,1},
{"N",55.854,1.009,20.026,0.21,1},
{"C",53.498,-0.768,20.331,0.295,1},
{"C",51.93,0.959,19.792,0.162,1},
{"C",53.322,0.717,20.349,0.195,1},
{"C",54.498,1.32,19.484,0.191,1},
{"C",54.314,2.798,19.365,0.152,1},
{"O",54.665,3.61,20.215,0.197,1},
{"N",53.67,3.193,18.262,0.138,1},
{"C",53.65,7.5,16.887,0.127,1},
{"C",53.152,8.791,16.643,0.157,1},
{"C",52.078,8.941,15.792,0.148,1},
{"C",51.479,7.834,15.165,0.17,1},
{"C",51.944,6.56,15.433,0.147,1},
{"C",53.042,6.394,16.302,0.163,1},
{"C",53.54,5.002,16.562,0.155,1},
{"C",53.242,4.545,18,0.137,1},
{"C",51.729,4.439,18.281,0.127,1},
{"O",51.128,3.609,17.588,0.14,1},
{"N",51.221,5.277,19.161,0.166,1},
{"N",50.589,6.236,23.989,0.343,1},
{"O",48.429,6.236,23.344,0.301,1},
{"C",49.63,5.882,23.166,0.334,1},
{"C",50.07,5.053,21.944,0.249,1},
{"C",49.557,5.912,20.812,0.186,1},
{"C",49.789,5.188,19.475,0.192,1},
{"C",48.774,5.803,18.52,0.192,1},
{"O",47.595,5.352,18.619,0.207,1},
{"N",49.216,6.722,17.695,0.149,1},
{"N",45.877,6.54,14.081,0.157,1},
{"O",47.378,8.223,14.272,0.163,1},
{"C",46.975,7.111,14.611,0.135,1},
{"C",47.699,6.393,15.739,0.133,1},
{"C",48.322,7.405,16.735,0.165,1},
{"C",47.22,8.132,17.551,0.196,1},
{"O",46.037,8.183,17.146,0.174,1},
{"N",47.583,8.642,18.686,0.21,1},
{"N",44.727,9.11,25.494,0.478,1},
{"N",46.471,7.611,25.64,0.392,1},
{"C",45.946,8.734,25.059,0.565,1},
{"N",46.727,9.307,24.165,0.568,1},
{"C",47.379,10.28,23.329,0.489,1},
{"C",46.745,10.42,21.962,0.415,1},
{"C",47.464,9.58,20.921,0.285,1},
{"C",46.654,9.31,19.633,0.225,1},
{"C",45.888,10.497,19.065,0.225,1},
{"O",44.673,10.68,19.414,0.195,1},
{"N",46.55,11.217,18.167,0.167,1},
{"O",48.658,13.097,20.141,0.289,1},
{"O",49.393,12.245,18.22,0.309,1},
{"C",48.68,13.024,18.883,0.285,1},
{"C",47.651,14.012,18.357,0.154,1},
{"C",46.954,13.419,17.129,0.202,1},
{"C",45.905,12.36,17.528,0.187,1},
{"C",45.052,12.047,16.307,0.166,1},
{"O",44.484,12.978,15.667,0.209,1},
{"N",44.984,10.789,15.978,0.162,1},
{"O",42.122,9.373,14.13,0.162,1},
{"C",42.715,10.324,15.155,0.203,1},
{"C",44.272,10.267,14.808,0.215,1},
{"C",44.735,10.875,13.487,0.235,1},
{"O",43.877,11.011,12.589,0.177,1},
{"N",46.024,11.223,13.224,0.176,1},
{"C",47.678,13.519,13.121,0.198,1},
{"C",48.216,13.051,10.699,0.216,1},
{"C",47.817,12.453,12.055,0.203,1},
{"C",46.52,11.709,11.943,0.158,1},
{"C",46.533,10.524,11.024,0.133,1},
{"O",46.109,10.726,9.903,0.186,1},
{"N",46.908,9.303,11.364,0.145,1},
{"C",49.747,8.489,9.579,0.192,1},
{"C",50.569,7.016,11.351,0.197,1},
{"C",49.408,7.951,10.947,0.175,1},
{"C",48.054,7.191,10.936,0.126,1},
{"C",46.879,8.136,10.559,0.114,1},
{"C",45.518,7.396,10.708,0.15,1},
{"O",44.821,7.556,11.703,0.155,1},
{"N",45.297,6.541,9.76,0.177,1},
{"C",45.035,5.504,7.685,0.218,1},
{"C",46.069,6.244,8.528,0.188,1},
{"C",44.19,4.694,8.649,0.184,1},
{"C",44.118,5.691,9.807,0.206,1},
{"C",44.032,4.977,11.141,0.208,1},
{"O",44.982,4.444,11.683,0.175,1},
{"N",42.784,4.878,11.669,0.181,1},
{"C",40.727,3.705,14.694,0.216,1},
{"O",40.692,5.765,13.21,0.234,1},
{"C",40.935,4.338,13.34,0.175,1},
{"C",42.454,4.119,12.878,0.146,1},
{"C",42.689,2.638,12.705,0.138,1},
{"O",42.2,1.965,11.759,0.138,1},
{"N",43.473,2.075,13.65,0.155,1},
{"N",43.802,-1.008,11.171,0.196,1},
{"O",44.539,0.139,9.406,0.189,1},
{"C",44.454,-0.081,10.717,0.183,1},
{"C",45.277,0.82,11.606,0.083,1},
{"C",45.335,0.509,13.034,0.095,1},
{"C",43.906,0.679,13.664,0.131,1},
{"C",43.982,0.112,15.06,0.141,1},
{"O",44.036,1.061,15.872,0.21,1},
{"N",44.094,-1.116,15.432,0.154,1},
{"O",45.148,-3.559,15.936,0.332,1},
{"C",44.2,-3.05,16.94,0.187,1},
{"C",44.237,-1.539,16.815,0.169,1},
{"C",45.593,-1.038,17.35,0.185,1},
{"O",46.536,-0.66,16.589,0.178,1},
{"N",45.717,-1.004,18.61,0.184,1},
{"O",51.36,-0.006,23.938,0.269,1},
{"C",48.474,0.724,21.895,0.19,1},
{"C",49.605,0.988,22.667,0.187,1},
{"C",50.205,-0.126,23.192,0.161,1},
{"C",49.724,-1.404,22.981,0.227,1},
{"C",48.591,-1.666,22.233,0.212,1},
{"C",47.951,-0.527,21.685,0.19,1},
{"C",46.682,-0.748,20.877,0.145,1},
{"C",46.918,-0.643,19.377,0.199,1},
{"C",48.025,-1.654,18.983,0.198,1},
{"O",47.822,-2.899,19.004,0.218,1},
{"N",49.196,-1.088,18.645,0.178,1},
{"C",50.312,-2.014,18.263,0.173,1},
{"C",50.423,-2.212,16.753,0.218,1},
{"O",51.308,-2.926,16.227,0.187,1},
{"N",49.521,-1.632,15.942,0.164,1},
{"O",47.703,-1.451,8.253,0.122,1},
{"C",48.577,-0.239,11.604,0.103,1},
{"C",48.44,-0.273,10.19,0.108,1},
{"C",47.735,-1.348,9.631,0.094,1},
{"C",47.274,-2.411,10.406,0.088,1},
{"C",47.354,-2.342,11.781,0.09,1},
{"C",48.033,-1.275,12.392,0.116,1},
{"C",48.184,-1.167,13.897,0.146,1},
{"C",49.484,-1.746,14.504,0.133,1},
{"C",50.632,-0.802,14.037,0.137,1},
{"O",51.214,-1.174,12.943,0.187,1},
{"N",50.916,0.278,14.691,0.109,1},
{"O",47.214,3.681,10.731,0.178,1},
{"C",50.511,2.861,11.945,0.106,1},
{"C",49.409,3.098,11.094,0.163,1},
{"C",48.157,3.392,11.662,0.184,1},
{"C",47.968,3.476,13.036,0.147,1},
{"C",49.067,3.227,13.874,0.142,1},
{"C",50.341,2.929,13.34,0.168,1},
{"C",51.515,2.674,14.261,0.094,1},
{"C",51.987,1.229,14.248,0.109,1},
{"C",53.199,1.148,15.207,0.157,1},
{"O",53.045,0.935,16.415,0.108,1},
{"N",54.388,1.288,14.58,0.137,1},
{"C",55.728,-1.536,17.123,0.232,1},
{"N",54.922,-2.588,17.243,0.197,1},
{"C",54.385,-2.75,16.053,0.22,1},
{"N",54.785,-1.876,15.135,0.141,1},
{"C",55.678,-1.123,15.82,0.128,1},
{"C",56.463,-0.004,15.272,0.118,1},
{"C",55.648,1.273,15.386,0.148,1},
{"C",56.544,2.421,14.935,0.147,1},
{"O",56.408,2.828,13.756,0.155,1},
{"N",57.336,2.993,15.823,0.117,1},
{"O",59.579,6.025,18.864,0.386,1},
{"O",60.775,6.477,17.038,0.348,1},
{"C",59.718,6.352,17.684,0.362,1},
{"C",58.355,6.494,17.026,0.366,1},
{"C",57.881,5.238,16.399,0.141,1},
{"C",58.142,4.175,15.409,0.121,1},
{"C",59.675,3.836,15.367,0.131,1},
{"O",60.169,3.079,16.219,0.104,1},
{"N",60.365,4.407,14.41,0.151,1},
{"O",59.803,-1.782,14.028,0.207,1},
{"C",60.181,1.701,12.947,0.139,1},
{"C",59.625,0.471,13.175,0.112,1},
{"C",60.357,-0.549,13.744,0.201,1},
{"C",61.723,-0.334,14.098,0.189,1},
{"C",62.28,0.901,13.853,0.113,1},
{"C",61.586,1.948,13.29,0.155,1},
{"C",62.143,3.329,12.992,0.147,1},
{"C",61.824,4.221,14.201,0.128,1},
{"C",62.441,5.543,13.937,0.16,1},
{"O",61.909,6.37,13.233,0.141,1},
{"N",63.597,5.869,14.524,0.147,1},
{"C",66.027,8.758,15.017,0.161,1},
{"O",65.025,6.84,16.428,0.17,1},
{"C",65.486,7.333,15.173,0.148,1},
{"C",64.211,7.158,14.217,0.146,1},
{"C",64.82,7.235,12.812,0.115,1},
{"O",65.383,6.237,12.353,0.156,1},
{"N",64.81,8.352,12.214,0.141,1},
{"C",63.603,8.395,9.458,0.11,1},
{"C",65.486,9.939,8.751,0.121,1},
{"C",64.629,9.437,9.904,0.118,1},
{"C",65.465,8.776,10.985,0.129,1},
{"C",66.502,9.771,11.594,0.126,1},
{"O",66.195,10.847,12.103,0.148,1},
{"N",67.775,9.291,11.518,0.191,1},
{"C",71.322,7.216,13.031,0.243,1},
{"C",70.193,8.254,13.115,0.141,1},
{"C",70.263,9.369,12.082,0.174,1},
{"C",71.433,10.415,12.272,0.205,1},
{"C",68.883,10.167,12.057,0.148,1},
{"C",68.965,11.468,11.25,0.118,1},
{"O",68.843,11.572,10.043,0.139,1},
{"N",69.072,12.563,11.991,0.127,1},
{"C",68.905,16.397,12.028,0.195,1},
{"O",67.038,14.797,12.177,0.195,1},
{"C",68.461,15.016,12.496,0.199,1},
{"C",69.29,13.927,11.671,0.182,1},
{"C",70.851,14.203,11.817,0.202,1},
{"O",71.386,14.227,12.961,0.194,1},
{"N",71.516,14.336,10.663,0.262,1},
{"C",72.196,14.272,8.389,0.261,1},
{"C",70.99,14.304,9.282,0.235,1},
{"C",73.293,14.909,9.217,0.287,1},
{"C",72.987,14.605,10.666,0.266,1},
{"C",73.307,15.826,11.542,0.215,1},
{"O",72.677,16.898,11.343,0.256,1},
{"N",74.236,15.623,12.475,0.26,1},
{"C",74.729,16.687,13.344,0.193,1},
{"C",73.881,16.822,14.558,0.256,1},
{"O",74.425,17.502,15.469,0.297,1},
{"N",72.705,16.22,14.708,0.221,1},
{"C",70.446,15.871,15.631,0.166,1},
{"C",71.915,16.398,15.916,0.178,1},
{"C",72.506,15.605,17.068,0.211,1},
{"O",72.947,14.443,16.976,0.19,1},
{"N",72.407,16.251,18.211,0.212,1},
{"N",71.474,21.044,21.543,0.209,1},
{"N",73.209,20.847,23.078,0.191,1},
{"C",72.637,20.461,21.915,0.212,1},
{"N",73.043,19.604,20.973,0.201,1},
{"C",74.297,18.827,21.055,0.173,1},
{"C",74.267,17.566,20.339,0.142,1},
{"C",73.109,16.648,20.661,0.199,1},
{"C",72.77,15.671,19.516,0.24,1},
{"C",71.582,14.817,19.98,0.266,1},
{"O",71.778,13.86,20.736,0.281,1},
{"N",70.369,15.153,19.528,0.242,1},
{"C",68.793,16.585,21.553,0.273,1},
{"O",67.664,16.225,19.468,0.233,1},
{"C",68.171,15.507,20.586,0.168,1},
{"C",69.165,14.432,20.001,0.23,1},
{"C",68.643,13.563,18.853,0.261,1},
{"O",69.196,13.572,17.697,0.235,1},
{"N",67.544,12.826,19.205,0.21,1},
{"N",62.174,8.847,19.899,0.439,1},
{"N",63.093,7.856,18.052,0.455,1},
{"C",63.214,8.47,19.22,0.406,1},
{"N",64.263,8.827,19.965,0.401,1},
{"C",65.575,8.601,19.412,0.303,1},
{"C",66.528,9.755,19.39,0.236,1},
{"C",66.089,10.974,18.684,0.242,1},
{"C",67.016,11.999,18.09,0.193,1},
{"C",66.323,12.846,17.01,0.241,1},
{"O",65.865,12.413,15.934,0.271,1},
{"N",66.185,14.15,17.225,0.222,1},
{"C",65.603,15.189,16.407,0.236,1},
{"C",64.093,14.863,16.151,0.259,1},
{"O",63.401,14.257,16.977,0.271,1},
{"N",63.697,15.277,14.958,0.222,1},
{"C",62.143,17.752,15.273,0.223,1},
{"O",62.482,17.19,12.915,0.221,1},
{"C",61.876,16.759,14.118,0.171,1},
{"C",62.305,15.258,14.484,0.276,1},
{"C",61.905,14.327,13.391,0.262,1},
{"O",60.66,14.273,13.16,0.222,1},
{"N",62.801,13.577,12.809,0.149,1},
{"N",66.222,17.376,8.125,0.349,1},
{"N",67.005,15.307,7.571,0.295,1},
{"C",66.168,16.057,8.25,0.333,1},
{"N",65.224,15.551,9.069,0.285,1},
{"C",64.927,14.123,9.236,0.188,1},
{"C",63.838,14.196,10.31,0.159,1},
{"C",63.543,12.743,10.647,0.147,1},
{"C",62.449,12.694,11.724,0.137,1},
{"C",62.22,11.317,12.265,0.161,1},
{"O",62.956,10.777,13.1,0.155,1},
{"N",61.159,10.695,11.688,0.136,1},
{"N",62.955,11.586,15.718,0.171,1},
{"N",62.242,11.786,17.865,0.185,1},
{"C",62.153,11.155,16.691,0.202,1},
{"N",61.245,10.159,16.55,0.191,1},
{"C",60.959,9.444,15.27,0.155,1},
{"C",59.976,10.194,14.396,0.147,1},
{"C",59.675,9.264,13.219,0.165,1},
{"C",60.773,9.332,12.088,0.121,1},
{"C",60.102,8.641,10.906,0.091,1},
{"O",59.57,9.267,9.965,0.137,1},
{"N",60.218,7.359,10.977,0.099,1},
{"C",61.836,5.441,7.183,0.176,1},
{"C",60.927,6.38,7.983,0.131,1},
{"C",60.303,5.498,9.151,0.183,1},
{"C",59.454,4.293,8.626,0.169,1},
{"C",59.521,6.468,10.068,0.165,1},
{"C",58.54,5.703,11,0.15,1},
{"O",58.921,5.08,11.986,0.14,1},
{"N",57.255,5.741,10.547,0.167,1},
{"C",55.913,6.925,13.641,0.178,1},
{"C",55.161,7.103,12.301,0.212,1},
{"C",54.833,5.797,11.552,0.164,1},
{"C",53.803,4.861,12.308,0.133,1},
{"C",56.146,4.982,11.184,0.158,1},
{"C",55.781,3.793,10.312,0.123,1},
{"O",55.304,3.967,9.165,0.168,1},
{"N",55.908,2.558,10.746,0.1,1},
{"S",56.184,-0.323,11.759,0.206,0.6},
{"S",58.035,0.284,9.688,0.237,0.4},
{"C",56.3,0.247,10.096,0.21,1},
{"C",55.424,1.471,9.904,0.147,1},
{"C",53.958,1.04,10.365,0.149,1},
{"O",53.645,1.139,11.597,0.127,1},
{"N",53.204,0.528,9.418,0.144,1},
{"C",51.868,-0.006,9.741,0.105,1},
{"C",52.057,-1.426,9.467,0.125,1},
{"O",53.009,-1.74,8.702,0.172,1},
{"N",51.21,-2.347,9.889,0.123,1},
{"O",48.481,-5.989,12.069,0.556,1},
{"O",49.006,-5.074,13.943,0.486,1},
{"C",49.308,-5.256,12.751,0.521,1},
{"C",50.545,-4.687,12.004,0.334,1},
{"C",50.367,-4.631,10.487,0.19,1},
{"C",51.323,-3.759,9.634,0.111,1},
{"C",51.136,-4.18,8.188,0.11,1},
{"O",51.578,-5.281,7.786,0.165,1},
{"N",50.537,-3.415,7.316,0.101,1},
{"C",49.34,-2.814,5.245,0.107,1},
{"C",50.322,-3.807,5.938,0.148,1},
{"C",51.625,-3.776,5.132,0.132,1},
{"O",52.579,-3.071,5.467,0.166,1},
{"N",51.595,-4.507,4.059,0.126,1},
{"C",53.526,-5.856,0.966,0.221,1},
{"O",52.218,-6.963,2.5,0.296,1},
{"C",52.35,-5.62,1.921,0.174,1},
{"C",52.676,-4.615,3.086,0.198,1},
{"C",53.035,-3.242,2.582,0.164,1},
{"O",52.186,-2.504,2.065,0.147,1},
{"N",54.322,-2.811,2.71,0.17,1},
{"N",57.068,-1.295,-0.658,0.34,1},
{"O",56.819,-3.475,-0.047,0.525,1},
{"C",56.354,-2.398,-0.389,0.356,1},
{"C",54.838,-2.246,-0.385,0.336,1},
{"C",54.487,-1.281,0.739,0.198,1},
{"C",54.752,-1.497,2.22,0.157,1},
{"C",54.094,-0.269,2.884,0.132,1},
{"O",54.156,0.831,2.266,0.156,1},
{"N",53.451,-0.393,4.032,0.106,1},
{"O",49.554,-0.294,7.145,0.095,1},
{"O",48.937,1.905,7.152,0.155,1},
{"C",49.574,0.879,6.87,0.052,1},
{"C",50.794,1.403,6.017,0.122,1},
{"C",51.66,0.218,5.537,0.097,1},
{"C",52.84,0.783,4.668,0.103,1},
{"C",53.885,1.459,5.562,0.109,1},
{"O",54.059,0.841,6.668,0.126,1},
{"N",54.446,2.584,5.084,0.099,1},
{"O",57.418,0.812,6.684,0.14,1},
{"O",57,0.573,4.594,0.158,1},
{"C",57.155,1.313,5.585,0.118,1},
{"C",56.949,2.787,5.575,0.137,1},
{"C",55.472,3.161,5.951,0.14,1},
{"C",55.277,4.61,5.758,0.103,1},
{"O",55.227,4.968,4.584,0.155,1},
{"N",55.27,5.393,6.776,0.108,1},
{"O",49.261,4.292,6.391,0.196,1},
{"C",51.732,7,6.341,0.146,1},
{"C",50.587,6.28,5.989,0.121,1},
{"C",50.377,5.07,6.709,0.149,1},
{"C",51.211,4.468,7.72,0.107,1},
{"C",52.324,5.271,8.025,0.112,1},
{"C",52.591,6.445,7.313,0.137,1},
{"C",53.861,7.252,7.664,0.103,1},
{"C",55.067,6.794,6.699,0.104,1},
{"C",56.325,7.573,7.268,0.145,1},
{"O",56.884,7.225,8.301,0.148,1},
{"N",56.598,8.642,6.577,0.127,1},
{"O",62.711,13.508,7.203,0.233,1},
{"C",60.895,10.311,6.738,0.176,1},
{"C",61.906,11.209,7.117,0.223,1},
{"C",61.775,12.567,6.865,0.237,1},
{"C",60.621,13.077,6.214,0.176,1},
{"C",59.61,12.154,5.871,0.159,1},
{"C",59.738,10.8,6.108,0.197,1},
{"C",58.55,9.884,5.752,0.179,1},
{"C",57.649,9.56,7.03,0.157,1},
{"C",57.003,10.812,7.622,0.134,1},
{"O",56.131,11.535,7.114,0.137,1},
{"N",57.658,11.186,8.749,0.126,1},
{"C",57.208,11.583,11.94,0.128,1},
{"O",56.338,13.704,11.221,0.158,1},
{"C",56.566,12.328,10.769,0.106,1},
{"C",57.366,12.46,9.403,0.118,1},
{"C",58.703,13.213,9.613,0.146,1},
{"O",59.625,12.597,10.195,0.16,1},
{"N",58.743,14.435,9.235,0.135,1},
{"C",59.928,15.317,9.443,0.162,1},
{"C",59.69,16.346,10.516,0.225,1},
{"O",60.62,17.144,10.762,0.214,1},
{"N",58.54,16.39,11.191,0.211,1},
{"O",55.552,16.631,11.17,0.198,1},
{"O",55.149,18.571,10.305,0.305,1},
{"C",55.866,17.845,10.969,0.28,1},
{"C",57.191,18.476,11.479,0.271,1},
{"C",58.123,17.429,12.145,0.171,1},
{"C",57.521,16.9,13.466,0.178,1},
{"O",56.658,17.459,14.111,0.231,1},
{"N",58.097,15.78,13.843,0.204,1},
{"C",59.341,14.282,18.035,0.398,1},
{"N",58.848,13.816,19.232,0.344,1},
{"C",57.625,14.28,19.411,0.406,1},
{"N",57.318,15.078,18.386,0.432,1},
{"C",58.391,15.097,17.49,0.339,1},
{"C",58.414,15.898,16.228,0.257,1},
{"C",57.854,15.024,15.051,0.214,1},
{"C",56.37,14.68,15.195,0.266,1},
{"O",55.758,15.12,16.187,0.193,1},
{"N",55.863,13.912,14.217,0.223,1},
{"O",58.211,9.356,17.463,0.241,1},
{"C",55.786,12.153,17.389,0.201,1},
{"C",56.805,11.326,17.851,0.207,1},
{"C",57.258,10.257,17.082,0.2,1},
{"C",56.628,9.949,15.868,0.212,1},
{"C",55.646,10.808,15.352,0.214,1},
{"C",55.212,11.908,16.12,0.178,1},
{"C",54.115,12.736,15.517,0.187,1},
{"C",54.495,13.396,14.173,0.264,1},
{"C",53.446,14.447,13.853,0.277,1},
{"O",52.289,14.031,14.08,0.315,1},
{"N",53.693,15.661,13.436,0.246,1},
{"C",53.279,18.055,13.045,0.233,1},
{"C",52.688,16.638,13.044,0.258,1},
{"C",52.058,16.24,11.674,0.305,1},
{"O",50.804,16.256,11.503,0.26,1},
{"N",52.837,15.887,10.651,0.245,1},
{"C",51.954,18.175,8.741,0.231,1},
{"O",54.01,16.995,8.18,0.264,1},
{"C",52.58,16.806,8.345,0.263,1},
{"C",52.392,15.56,9.294,0.229,1},
{"C",53.051,14.251,8.871,0.223,1},
{"O",54.093,14.003,9.511,0.193,1},
{"N",52.553,13.473,7.934,0.186,1},
{"C",53.405,10.223,10.303,0.237,1},
{"C",53.474,10.211,11.712,0.207,1},
{"C",52.572,11.01,12.444,0.207,1},
{"C",51.652,11.851,11.764,0.22,1},
{"C",51.572,11.8,10.396,0.222,1},
{"C",52.432,10.995,9.632,0.239,1},
{"C",52.347,10.962,8.128,0.147,1},
{"C",53.086,12.154,7.533,0.169,1},
{"C",52.897,12.061,6.044,0.179,1},
{"O",51.89,12.617,5.567,0.196,1},
{"N",53.798,11.349,5.449,0.161,1},
{"O",54.405,13.261,3.196,0.234,1},
{"C",54.688,11.885,3.123,0.147,1},
{"C",53.64,11.172,3.982,0.14,1},
{"C",53.848,9.683,3.894,0.145,1},
{"O",54.695,9.13,4.652,0.16,1},
{"N",53.129,9.031,2.996,0.13,1},
{"C",52.027,4.739,2.925,0.255,1},
{"C",51.591,5.377,0.455,0.348,1},
{"C",51.515,5.792,1.954,0.303,1},
{"C",52.26,7.067,1.955,0.158,1},
{"C",53.394,7.631,2.762,0.136,1},
{"C",54.681,7.541,1.811,0.101,1},
{"O",54.794,8.259,0.845,0.1,1},
{"N",55.469,6.557,2.206,0.085,1},
{"C",58.997,6.22,4.608,0.137,1},
{"C",58.191,6.967,3.461,0.138,1},
{"C",57.877,5.881,2.384,0.131,1},
{"C",59.154,5.548,1.534,0.164,1},
{"C",56.687,6.368,1.433,0.133,1},
{"C",56.454,5.354,0.318,0.111,1},
{"O",55.958,4.239,0.593,0.136,1},
{"N",56.892,5.802,-0.891,0.113,1},
{"O",56.611,3.525,-4.433,0.111,1},
{"O",55.398,5.107,-5.296,0.153,1},
{"C",56.108,4.66,-4.344,0.093,1},
{"C",56.227,5.659,-3.219,0.096,1},
{"C",56.871,4.899,-2.035,0.105,1},
{"C",58.344,4.396,-2.306,0.092,1},
{"O",59.143,5.224,-2.786,0.111,1},
{"N",58.569,3.184,-1.968,0.116,1},
{"N",61.131,-0.426,0.826,0.2,1},
{"O",59.258,0.205,1.871,0.26,1},
{"C",60.106,0.416,1.003,0.254,1},
{"C",60.053,1.643,0.158,0.15,1},
{"C",60.033,1.248,-1.326,0.074,1},
{"C",59.897,2.524,-2.158,0.129,1},
{"C",60.213,2.14,-3.581,0.179,1},
{"O",61.344,1.694,-3.895,0.15,1},
{"N",59.245,2.322,-4.48,0.144,1},
{"C",57.372,0.343,-5.593,0.109,1},
{"O",57.277,2.519,-6.806,0.197,1},
{"C",58.079,1.34,-6.504,0.155,1},
{"C",59.453,1.933,-5.874,0.142,1},
{"C",60.056,3.106,-6.639,0.143,1},
{"O",60.356,2.964,-7.848,0.191,1},
{"N",60.275,4.298,-6.105,0.13,1},
{"S",58.368,6.852,-6.278,0.147,1},
{"C",59.561,6.16,-7.475,0.162,1},
{"C",60.792,5.428,-6.832,0.164,1},
{"C",61.712,6.353,-6.019,0.155,1},
{"O",61.87,6.084,-4.84,0.143,1},
{"O",62.207,7.359,-6.59,0.158,1},
{"O",69.525,17.646,18.603,0.268,1},
{"O",69.766,19.578,17.208,0.269,1},
{"O",71.627,19.064,18.389,0.263,1},
{"O",69.815,20.036,19.556,0.311,1},
{"S",70.122,18.969,18.501,0.29,1},
{"N",13.897,16.109,23.054,0.258,1},
{"O",11.633,17.326,23.783,0.343,1},
{"O",11.574,19.581,24.046,0.448,1},
{"C",12.112,18.508,23.657,0.412,1},
{"C",13.425,18.614,22.895,0.306,1},
{"C",13.811,17.296,22.188,0.268,1},
{"C",15.2,17.498,21.52,0.31,1},
{"O",16.214,17.147,22.144,0.35,1},
{"N",15.161,18.029,20.309,0.283,1},
{"C",16.168,16.647,17.796,0.371,1},
{"C",17.492,18.644,17.267,0.27,1},
{"C",16.328,18.135,18.094,0.376,1},
{"C",16.42,18.405,19.599,0.372,1},
{"C",16.731,19.826,20.118,0.36,1},
{"O",15.822,20.71,20.108,0.332,1},
{"N",17.967,20.066,20.571,0.258,1},
{"O",19.191,20.339,22.852,0.401,1},
{"C",19.768,21.331,21.946,0.268,1},
{"C",18.411,21.353,21.141,0.3,1},
{"C",18.495,22.544,20.225,0.329,1},
{"O",18.674,23.67,20.755,0.393,1},
{"N",18.285,22.266,18.976,0.27,1},
{"C",18.323,23.441,18.036,0.327,1},
{"C",19.261,22.898,16.949,0.263,1},
{"O",19.499,21.672,16.963,0.275,1},
{"N",19.695,23.844,16.171,0.308,1},
{"C",20.844,23.617,12.436,0.493,1},
{"O",18.785,24.221,13.531,0.536,1},
{"C",20.226,24.272,13.686,0.492,1},
{"C",20.592,23.546,15.05,0.292,1},
{"C",21.999,24.103,15.316,0.284,1},
{"O",22.122,25.151,15.948,0.282,1},
{"N",22.822,23.278,14.668,0.218,1},
{"C",26.401,23.348,16.036,0.241,1},
{"C",25.145,21.299,15.108,0.144,1},
{"C",25.062,22.711,15.692,0.244,1},
{"C",24.253,23.688,14.767,0.261,1},
{"C",24.866,23.744,13.355,0.264,1},
{"O",24.662,22.782,12.589,0.225,1},
{"N",25.619,24.827,13.073,0.211,1},
{"S",25.687,27.581,11.402,0.216,1},
{"C",26.893,26.294,11.665,0.206,1},
{"C",26.313,24.876,11.811,0.165,1},
{"C",27.388,23.795,11.79,0.157,1},
{"O",28.096,23.562,12.77,0.172,1},
{"N",27.509,23.153,10.63,0.185,1},
{"C",29.463,20.159,7.276,0.218,1},
{"C",29.602,19.406,9.659,0.171,1},
{"C",29.633,20.6,8.709,0.188,1},
{"C",28.478,21.614,8.958,0.115,1},
{"C",28.52,22.134,10.386,0.192,1},
{"C",29.901,22.74,10.714,0.187,1},
{"O",30.841,22.129,11.198,0.207,1},
{"N",29.967,23.986,10.389,0.208,1},
{"O",30.495,27.099,10.605,0.232,1},
{"C",31.13,26.145,9.778,0.158,1},
{"C",31.165,24.795,10.55,0.268,1},
{"C",31.492,24.994,12.004,0.247,1},
{"O",32.724,25.126,12.252,0.336,1},
{"N",30.666,25.021,12.983,0.228,1},
{"C",29.582,25.705,15.066,0.161,1},
{"C",30.856,25.197,14.389,0.207,1},
{"C",31.306,23.86,14.991,0.228,1},
{"O",31.745,23.914,16.158,0.254,1},
{"N",31.206,22.718,14.308,0.174,1},
{"C",28.809,20.393,15.923,0.168,1},
{"C",28.51,19.333,13.563,0.204,1},
{"C",29.144,20.426,14.437,0.21,1},
{"C",30.69,20.311,14.213,0.169,1},
{"C",31.544,21.44,14.926,0.197,1},
{"C",33.025,21.078,14.779,0.229,1},
{"O",33.656,21.629,13.855,0.189,1},
{"N",33.502,20.102,15.565,0.221,1},
{"C",34.118,18.806,17.369,0.246,1},
{"C",32.864,19.349,16.605,0.193,1},
{"C",35.041,18.393,16.273,0.224,1},
{"C",34.909,19.603,15.343,0.228,1},
{"C",35.037,19.189,13.89,0.215,1},
{"O",34.124,18.669,13.16,0.194,1},
{"N",36.209,19.382,13.323,0.177,1},
{"C",38.486,19.579,12.99,0.233,1},
{"C",37.373,19.969,14.011,0.207,1},
{"C",37.878,19.43,11.647,0.229,1},
{"C",36.428,18.998,11.964,0.161,1},
{"C",36.144,17.529,11.701,0.187,1},
{"O",35.771,17.293,10.494,0.189,1},
{"N",36.252,16.575,12.594,0.144,1},
{"O",39.579,15.98,14.43,0.241,1},
{"O",37.69,16.577,15.267,0.205,1},
{"C",38.331,15.745,14.599,0.252,1},
{"C",37.867,14.469,13.911,0.185,1},
{"C",36.336,14.403,13.667,0.162,1},
{"C",35.975,15.16,12.387,0.162,1},
{"C",34.504,14.852,12.005,0.117,1},
{"O",34.196,13.848,11.377,0.171,1},
{"N",33.677,15.783,12.482,0.182,1},
{"C",31.47,17.021,12.818,0.089,1},
{"C",32.195,15.812,12.19,0.204,1},
{"C",31.998,15.794,10.657,0.181,1},
{"O",31.219,15.025,10.093,0.18,1},
{"N",32.803,16.644,9.958,0.158,1},
{"C",33.844,17.872,6.502,0.246,1},
{"O",32.946,19.068,8.484,0.243,1},
{"C",33.625,17.893,8.014,0.178,1},
{"C",32.779,16.668,8.514,0.127,1},
{"C",33.281,15.381,7.934,0.128,1},
{"O",32.775,14.873,6.927,0.149,1},
{"N",34.298,14.735,8.489,0.144,1},
{"O",37.39,14.619,7.785,0.299,1},
{"O",37.807,13.862,9.817,0.336,1},
{"C",37.151,13.882,8.776,0.288,1},
{"C",35.974,12.937,8.745,0.116,1},
{"C",34.792,13.482,7.915,0.165,1},
{"C",33.71,12.387,7.996,0.155,1},
{"O",33.675,11.576,7.071,0.171,1},
{"N",33.092,12.413,9.197,0.175,1},
{"C",30.406,10.231,11.008,0.113,1},
{"O",32.653,11.318,11.606,0.169,1},
{"C",31.436,11.32,10.787,0.185,1},
{"C",32.065,11.34,9.356,0.179,1},
{"C",30.91,11.534,8.348,0.157,1},
{"O",30.517,10.489,7.803,0.139,1},
{"N",30.493,12.797,8.205,0.201,1},
{"C",27.032,14.259,8.334,0.341,1},
{"C",27.995,16.664,7.996,0.341,1},
{"C",28.265,15.18,8.242,0.359,1},
{"C",29.077,14.586,7.111,0.253,1},
{"C",29.415,13.095,7.217,0.247,1},
{"C",29.876,12.588,5.831,0.284,1},
{"O",29.071,12.038,5.098,0.229,1},
{"N",31.136,12.809,5.482,0.188,1},
{"N",34.05,15.191,3.851,0.329,1},
{"O",32.018,14.834,2.817,0.464,1},
{"C",33.006,14.417,3.505,0.339,1},
{"C",33.091,12.975,3.942,0.249,1},
{"C",31.722,12.349,4.222,0.199,1},
{"C",31.692,10.846,4.187,0.217,1},
{"O",31.339,10.335,3.075,0.238,1},
{"N",32.03,10.049,5.182,0.181,1},
{"C",34.664,7.569,5.184,0.279,1},
{"C",34.662,7.569,7.692,0.271,1},
{"C",34.092,8.224,6.459,0.191,1},
{"C",32.583,8.018,6.376,0.229,1},
{"C",31.915,8.605,5.093,0.193,1},
{"C",30.465,8.088,4.964,0.216,1},
{"O",30.225,7.023,4.37,0.226,1},
{"N",29.599,8.86,5.617,0.216,1},
{"C",27.052,9.956,9.108,0.136,1},
{"C",27.555,8.943,8.069,0.172,1},
{"C",27.388,9.365,6.621,0.258,1},
{"C",25.922,9.062,6.261,0.25,1},
{"C",28.175,8.485,5.596,0.218,1},
{"C",27.708,8.591,4.139,0.241,1},
{"O",27.073,7.659,3.609,0.255,1},
{"N",28.047,9.673,3.486,0.228,1},
{"C",28.181,11.267,1.625,0.235,1},
{"C",27.658,9.901,2.078,0.262,1},
{"C",28.083,8.757,1.165,0.376,1},
{"O",27.268,8.216,0.361,0.361,1},
{"N",29.317,8.264,1.294,0.311,1},
{"O",32.041,7.143,1.536,0.414,1},
{"C",31.393,7.39,0.284,0.363,1},
{"C",29.878,7.182,0.46,0.31,1},
{"C",29.611,5.774,0.953,0.305,1},
{"O",30.006,4.8,0.298,0.33,1},
{"N",28.953,5.809,2.103,0.295,1},
{"O",27.012,2.802,4.015,0.475,1},
{"O",27.016,1.408,2.266,0.505,1},
{"C",27.192,2.551,2.775,0.488,1},
{"C",27.695,3.714,1.912,0.368,1},
{"C",28.65,4.56,2.774,0.266,1},
{"C",29.961,3.848,3.147,0.298,1},
{"O",30.112,2.631,2.985,0.237,1},
{"N",30.873,4.622,3.731,0.261,1},
{"C",32.088,3.905,4.208,0.235,1},
{"C",33.17,3.859,3.1,0.289,1},
{"O",33.092,4.59,2.105,0.299,1},
{"N",34.181,3.031,3.282,0.241,1},
{"C",35.765,1.558,2.468,0.239,1},
{"C",35.249,2.992,2.262,0.271,1},
{"C",35.658,1.339,3.94,0.283,1},
{"C",34.439,2.116,4.414,0.231,1},
{"C",34.568,2.842,5.752,0.236,1},
{"O",35.021,4.006,5.8,0.273,1},
{"N",34.062,2.339,6.865,0.21,1},
{"C",31.335,4.871,8.387,0.21,1},
{"C",30.269,5.53,7.7,0.294,1},
{"C",29.389,4.774,6.878,0.186,1},
{"C",29.623,3.412,6.752,0.234,1},
{"C",30.668,2.748,7.418,0.226,1},
{"C",31.526,3.501,8.247,0.203,1},
{"C",32.677,2.759,8.931,0.186,1},
{"C",34.02,3.033,8.154,0.242,1},
{"C",35.203,2.617,9.015,0.178,1},
{"O",35.532,1.413,8.884,0.196,1},
{"N",35.707,3.505,9.86,0.168,1},
{"C",36.196,5.408,11.153,0.244,1},
{"C",35.333,4.895,9.987,0.158,1},
{"C",37.277,4.369,11.369,0.187,1},
{"C",36.817,3.064,10.715,0.14,1},
{"C",36.487,2.033,11.765,0.183,1},
{"O",37.264,1.098,12.102,0.171,1},
{"N",35.303,2.149,12.446,0.173,1},
{"O",38.498,4.748,17.267,0.312,1},
{"C",35.635,4.123,15.129,0.161,1},
{"C",36.683,4.814,15.812,0.211,1},
{"C",37.534,4.048,16.622,0.329,1},
{"C",37.434,2.642,16.809,0.255,1},
{"C",36.379,2.017,16.114,0.284,1},
{"C",35.475,2.777,15.335,0.161,1},
{"C",34.391,2.004,14.677,0.122,1},
{"C",34.935,1.202,13.528,0.137,1},
{"C",33.881,0.23,13.069,0.126,1},
{"O",32.993,0.588,12.25,0.148,1},
{"N",33.99,-0.936,13.586,0.123,1},
{"O",33.501,-3.552,15.194,0.226,1},
{"C",33.456,-3.409,13.83,0.155,1},
{"C",33.031,-2.035,13.342,0.191,1},
{"C",31.61,-1.605,13.847,0.198,1},
{"O",30.645,-2.179,13.256,0.171,1},
{"N",31.479,-0.732,14.803,0.174,1},
{"N",28.262,-1.334,18.613,0.3,1},
{"O",29.124,-2.936,17.227,0.475,1},
{"C",29.256,-1.835,17.85,0.407,1},
{"C",30.559,-1.066,17.674,0.22,1},
{"C",30.531,0.226,16.849,0.21,1},
{"C",30.252,-0.189,15.397,0.155,1},
{"C",29.674,0.932,14.579,0.183,1},
{"O",28.557,1.428,14.885,0.253,1},
{"N",30.334,1.395,13.527,0.142,1},
{"O",31.375,4.459,13.62,0.177,1},
{"O",32.869,4.132,12.099,0.157,1},
{"C",31.729,3.936,12.515,0.162,1},
{"C",30.792,3.074,11.644,0.122,1},
{"C",29.817,2.454,12.67,0.15,1},
{"C",28.632,1.9,11.825,0.164,1},
{"O",28.81,0.852,11.22,0.144,1},
{"N",27.53,2.634,11.875,0.179,1},
{"C",26.351,2.246,11.06,0.199,1},
{"C",25.405,1.303,11.75,0.171,1},
{"O",24.557,0.69,11.06,0.283,1},
{"N",25.457,1.134,13.023,0.155,1},
{"C",25.392,0.735,16.144,0.177,1},
{"C",26.391,-1.22,14.752,0.213,1},
{"C",25.14,-0.322,15.092,0.211,1},
{"C",24.551,0.252,13.768,0.145,1},
{"C",23.284,1.158,13.974,0.177,1},
{"O",23.274,2.41,13.956,0.19,1},
{"N",22.198,0.37,14.178,0.215,1},
{"C",19.631,-0.58,13.217,0.248,1},
{"C",18.43,0.788,14.995,0.231,1},
{"C",19.717,0.06,14.558,0.215,1},
{"C",20.928,1.072,14.466,0.25,1},
{"C",21.037,1.78,15.807,0.189,1},
{"O",21.522,1.284,16.85,0.186,1},
{"N",20.518,2.945,15.793,0.175,1},
{"C",21.25,5.835,19.206,0.227,1},
{"C",20.933,6.625,20.345,0.226,1},
{"C",19.868,7.602,20.354,0.271,1},
{"C",19.106,7.79,19.185,0.226,1},
{"C",19.423,6.988,18.099,0.187,1},
{"C",20.464,6.024,18.067,0.172,1},
{"C",20.671,5.236,16.777,0.189,1},
{"C",20.352,3.75,17.006,0.23,1},
{"C",18.871,3.502,17.502,0.273,1},
{"O",17.933,3.903,16.777,0.257,1},
{"N",18.7,2.934,18.699,0.261,1},
{"N",18.983,-1.779,20.383,0.573,1},
{"O",17.555,-0.734,21.87,0.61,1},
{"C",18.096,-0.815,20.746,0.596,1},
{"C",17.768,0.234,19.672,0.471,1},
{"C",17.386,1.554,20.355,0.302,1},
{"C",17.375,2.652,19.263,0.349,1},
{"C",16.59,3.859,19.793,0.361,1},
{"O",15.357,3.69,19.992,0.329,1},
{"N",17.223,4.984,20.074,0.295,1},
{"N",13.756,8.385,19.408,0.197,1},
{"O",15.678,8.746,20.508,0.291,1},
{"C",14.943,7.991,19.825,0.284,1},
{"C",15.532,6.649,19.454,0.291,1},
{"C",16.457,6.138,20.568,0.301,1},
{"C",15.626,5.742,21.802,0.381,1},
{"O",14.526,6.262,21.972,0.324,1},
{"N",16.213,4.833,22.55,0.349,1},
{"N",17.324,3.937,29.123,0.637,1},
{"N",16.219,1.967,29.159,0.687,1},
{"C",17.153,2.722,28.53,0.666,1},
{"N",17.849,2.399,27.441,0.674,1},
{"C",18.085,1.833,26.119,0.648,1},
{"C",17.349,2.078,24.828,0.576,1},
{"C",16.634,3.354,24.605,0.372,1},
{"C",15.756,4.22,23.792,0.378,1},
{"C",15.312,5.38,24.696,0.386,1},
{"O",14.242,5.107,25.276,0.414,1},
{"N",15.881,6.547,24.853,0.371,1},
{"O",18.25,6.292,27.096,0.725,1},
{"O",18.71,6.541,24.893,0.745,1},
{"C",18.294,6.953,26.005,0.705,1},
{"C",17.714,8.337,26.302,0.646,1},
{"C",16.212,8.307,26.671,0.5,1},
{"C",15.227,7.544,25.765,0.407,1},
{"C",14.354,8.608,25.074,0.429,1},
{"O",14.116,9.656,25.765,0.478,1},
{"N",13.892,8.383,23.846,0.32,1},
{"O",11.194,7.867,22.896,0.568,1},
{"C",11.586,9.175,23.392,0.447,1},
{"C",13.095,9.287,23.048,0.321,1},
{"C",13.545,10.748,23.083,0.409,1},
{"O",12.732,11.736,23.191,0.353,1},
{"N",14.871,10.893,22.942,0.251,1},
{"C",17.153,12.029,24.741,0.364,1},
{"C",17.415,13.83,22.993,0.278,1},
{"C",16.868,12.436,23.305,0.321,1},
{"C",15.354,12.295,22.915,0.255,1},
{"C",14.962,12.81,21.537,0.188,1},
{"O",14.644,13.994,21.347,0.235,1},
{"N",15.1,11.903,20.544,0.256,1},
{"C",17.608,13.325,17.949,0.151,1},
{"C",18.005,10.923,17.368,0.196,1},
{"C",17.271,11.905,18.284,0.172,1},
{"C",15.764,11.582,18.128,0.219,1},
{"C",14.76,12.216,19.122,0.247,1},
{"C",13.295,11.696,18.913,0.258,1},
{"O",12.82,10.807,19.681,0.227,1},
{"N",12.671,12.253,17.889,0.257,1},
{"C",11.816,13.805,16.319,0.26,1},
{"C",13.173,13.322,16.955,0.292,1},
{"C",11.107,12.485,16.128,0.232,1},
{"C",11.298,11.848,17.527,0.226,1},
{"C",11.156,10.349,17.44,0.231,1},
{"O",12.034,9.658,16.827,0.208,1},
{"N",10.074,9.818,18.043,0.211,1},
{"C",7.979,6.615,18.745,0.211,1},
{"O",8.959,8.495,20.09,0.288,1},
{"C",8.485,8.027,18.807,0.223,1},
{"C",9.774,8.366,17.944,0.21,1},
{"C",9.533,7.938,16.509,0.168,1},
{"O",8.858,8.655,15.799,0.181,1},
{"N",10.166,6.883,16.04,0.232,1},
{"N",9.623,7.877,12.141,0.13,1},
{"O",10.481,9.992,12.179,0.225,1},
{"C",10.441,8.838,12.622,0.167,1},
{"C",11.319,8.276,13.717,0.156,1},
{"C",11.374,6.774,13.81,0.197,1},
{"C",10.182,6.314,14.696,0.216,1},
{"C",10.266,4.816,14.838,0.193,1},
{"O",10.576,4.404,15.979,0.217,1},
{"N",9.96,4.057,13.818,0.22,1},
{"O",8.258,2.005,12.569,0.328,1},
{"C",9.687,1.871,12.609,0.23,1},
{"C",10.111,2.59,13.911,0.26,1},
{"C",11.591,2.223,14.195,0.314,1},
{"O",12.531,2.987,13.871,0.22,1},
{"N",11.808,1.072,14.792,0.287,1},
{"O",18.259,-3.197,15.821,0.522,1},
{"C",15.293,-1.249,16.986,0.434,1},
{"C",16.564,-1.851,16.998,0.439,1},
{"C",17.022,-2.581,15.899,0.42,1},
{"C",16.214,-2.723,14.755,0.529,1},
{"C",14.949,-2.125,14.719,0.478,1},
{"C",14.484,-1.39,15.843,0.475,1},
{"C",13.082,-0.802,15.656,0.381,1},
{"C",13.181,0.566,14.981,0.288,1},
{"C",13.821,0.417,13.595,0.285,1},
{"O",13.281,-0.169,12.613,0.256,1},
{"N",15.014,1.028,13.469,0.275,1},
{"C",15.739,0.968,12.19,0.223,1},
{"C",15.763,2.225,11.396,0.21,1},
{"O",16.452,2.366,10.331,0.258,1},
{"N",15.043,3.253,11.829,0.194,1},
{"O",13.004,10.419,9.473,0.167,1},
{"C",14.42,7.881,11.642,0.165,1},
{"C",14.199,9.125,11.032,0.186,1},
{"C",13.196,9.234,10.066,0.166,1},
{"C",12.502,8.084,9.705,0.183,1},
{"C",12.713,6.87,10.289,0.189,1},
{"C",13.714,6.74,11.32,0.143,1},
{"C",13.907,5.408,11.933,0.145,1},
{"C",15.002,4.561,11.208,0.199,1},
{"C",16.33,5.362,11.359,0.136,1},
{"O",16.775,6.109,10.523,0.186,1},
{"N",16.916,5.176,12.51,0.207,1},
{"O",13.978,10.326,15.243,0.183,1},
{"C",16.991,8.604,14.133,0.155,1},
{"C",15.998,9.563,14.313,0.183,1},
{"C",14.867,9.256,15.104,0.206,1},
{"C",14.736,8.028,15.707,0.159,1},
{"C",15.721,7.04,15.478,0.175,1},
{"C",16.852,7.337,14.691,0.193,1},
{"C",17.922,6.277,14.478,0.182,1},
{"C",18.152,5.839,12.999,0.168,1},
{"C",19.352,4.888,12.958,0.146,1},
{"O",19.243,3.732,13.353,0.15,1},
{"N",20.474,5.491,12.595,0.175,1},
{"C",21.328,2.05,10.846,0.253,1},
{"N",20.279,1.517,10.212,0.305,1},
{"C",19.681,2.495,9.589,0.274,1},
{"N",20.318,3.697,9.82,0.204,1},
{"C",21.377,3.379,10.62,0.268,1},
{"C",22.385,4.326,11.222,0.154,1},
{"C",21.776,4.758,12.575,0.221,1},
{"C",22.859,5.674,13.229,0.168,1},
{"O",22.707,6.904,13.114,0.154,1},
{"N",23.813,4.892,13.824,0.149,1},
{"O",25.779,2.977,17.873,0.565,1},
{"O",26.172,5.188,18.119,0.468,1},
{"C",25.732,4.178,17.557,0.486,1},
{"C",24.999,4.31,16.215,0.276,1},
{"C",24.926,5.83,15.925,0.184,1},
{"C",24.831,5.86,14.468,0.143,1},
{"C",26.241,5.578,13.886,0.115,1},
{"O",26.543,4.467,13.43,0.122,1},
{"N",26.953,6.717,13.883,0.157,1},
{"O",24.876,4.663,8.531,0.26,1},
{"C",26.076,7.104,10.993,0.189,1},
{"C",25.214,6.379,10.157,0.186,1},
{"C",25.723,5.369,9.359,0.243,1},
{"C",27.065,4.992,9.341,0.155,1},
{"C",27.882,5.684,10.198,0.128,1},
{"C",27.431,6.714,10.995,0.18,1},
{"C",28.385,7.461,11.924,0.214,1},
{"C",28.338,6.742,13.292,0.158,1},
{"C",29.254,7.509,14.254,0.165,1},
{"O",28.865,8.519,14.897,0.131,1},
{"N",30.514,7.022,14.405,0.194,1},
{"C",33.673,7.212,16.671,0.128,1},
{"O",32.203,5.405,15.807,0.136,1},
{"C",32.754,6.678,15.533,0.129,1},
{"C",31.477,7.657,15.319,0.154,1},
{"C",31.982,8.971,14.727,0.094,1},
{"O",32.258,9.007,13.492,0.118,1},
{"N",32.17,9.991,15.497,0.129,1},
{"C",30.868,12.663,14.747,0.137,1},
{"C",33.157,13.78,15.354,0.146,1},
{"C",32.174,12.558,15.561,0.161,1},
{"C",32.861,11.244,15.243,0.152,1},
{"C",34.19,11.023,16.137,0.15,1},
{"O",34.141,11.04,17.381,0.165,1},
{"N",35.267,10.797,15.377,0.188,1},
{"C",38.308,8.317,13.434,0.147,1},
{"C",37.452,8.782,14.618,0.142,1},
{"C",37.712,10.186,15.175,0.149,1},
{"C",39.069,10.352,15.96,0.175,1},
{"C",36.523,10.555,16.155,0.184,1},
{"C",36.911,11.799,16.967,0.134,1},
{"O",36.762,12.974,16.509,0.156,1},
{"N",37.384,11.474,18.198,0.158,1},
{"C",37.831,13.434,21.526,0.196,1},
{"O",35.787,12.616,20.47,0.217,1},
{"C",37.244,12.392,20.575,0.203,1},
{"C",37.874,12.507,19.144,0.14,1},
{"C",39.43,12.31,19.199,0.17,1},
{"O",39.764,11.303,19.841,0.148,1},
{"N",40.182,13.208,18.568,0.162,1},
{"C",40.994,14.824,17.077,0.243,1},
{"C",39.741,14.394,17.844,0.208,1},
{"C",42.1,14.519,18.066,0.214,1},
{"C",41.64,13.184,18.639,0.199,1},
{"C",42.032,13.233,20.143,0.202,1},
{"O",41.463,14.058,20.91,0.183,1},
{"N",42.919,12.375,20.588,0.198,1},
{"C",43.363,12.311,21.953,0.21,1},
{"C",42.53,11.384,22.811,0.247,1},
{"O",43.136,11.165,23.868,0.229,1},
{"N",41.353,10.922,22.43,0.212,1},
{"C",39.222,9.967,23.023,0.152,1},
{"C",40.689,9.99,23.376,0.183,1},
{"C",41.307,8.593,23.236,0.198,1},
{"O",41.87,8.26,22.141,0.236,1},
{"N",41.232,7.72,24.241,0.151,1},
{"N",41.94,1.705,26.279,0.231,1},
{"N",40.139,2.709,27.311,0.22,1},
{"C",41.445,2.741,26.994,0.261,1},
{"N",42.283,3.761,27.329,0.234,1},
{"C",42.037,5.113,27.753,0.2,1},
{"C",41.701,6.112,26.69,0.212,1},
{"C",42.362,5.708,25.396,0.244,1},
{"C",41.749,6.381,24.14,0.155,1},
{"C",40.662,5.401,23.675,0.138,1},
{"O",40.959,4.218,23.431,0.163,1},
{"N",39.417,5.97,23.647,0.172,1},
{"C",37.754,4.599,25.686,0.199,1},
{"O",36.503,6.311,24.524,0.157,1},
{"C",37.146,5.001,24.323,0.179,1},
{"C",38.253,5.149,23.197,0.175,1},
{"C",37.647,5.844,21.971,0.162,1},
{"O",38.1,6.899,21.471,0.182,1},
{"N",36.533,5.203,21.585,0.176,1},
{"N",30.491,2.331,19.363,0.274,1},
{"N",30.684,4.02,17.816,0.271,1},
{"C",31.257,3.155,18.643,0.351,1},
{"N",32.593,3.073,18.804,0.383,1},
{"C",33.701,3.55,18.052,0.27,1},
{"C",34.864,3.767,19.017,0.314,1},
{"C",34.599,4.837,20.047,0.219,1},
{"C",35.692,5.774,20.522,0.197,1},
{"C",35.095,7.113,21.045,0.178,1},
{"O",34.602,7.903,20.233,0.206,1},
{"N",35.12,7.429,22.329,0.114,1},
{"C",34.69,8.677,22.908,0.143,1},
{"C",33.141,8.911,22.862,0.171,1},
{"O",32.389,7.93,22.776,0.202,1},
{"N",32.785,10.18,22.895,0.171,1},
{"C",31.772,10.327,25.614,0.201,1},
{"O",31.713,12.474,24.339,0.199,1},
{"C",31.175,11.149,24.421,0.135,1},
{"C",31.316,10.453,23.005,0.197,1},
{"C",30.683,11.176,21.865,0.193,1},
{"O",29.469,11.442,22.019,0.173,1},
{"N",31.407,11.5,20.821,0.12,1},
{"N",35.113,17.489,21.688,0.204,1},
{"N",35.63,16.864,19.592,0.153,1},
{"C",34.928,16.636,20.67,0.15,1},
{"N",34.092,15.602,20.759,0.18,1},
{"C",33.477,14.863,19.677,0.131,1},
{"C",32.519,13.868,20.304,0.126,1},
{"C",31.75,13.213,19.121,0.173,1},
{"C",30.785,12.241,19.719,0.13,1},
{"C",30.278,11.265,18.688,0.136,1},
{"O",30.909,10.245,18.355,0.109,1},
{"N",29.058,11.696,18.182,0.122,1},
{"N",31.332,8.075,19.76,0.171,1},
{"N",30.85,6.061,21.02,0.151,1},
{"C",30.594,6.976,20.06,0.201,1},
{"N",29.449,6.754,19.355,0.149,1},
{"C",28.876,7.634,18.363,0.082,1},
{"C",28.003,8.722,19.003,0.104,1},
{"C",27.516,9.691,17.939,0.059,1},
{"C",28.423,10.731,17.238,0.099,1},
{"C",27.575,11.603,16.331,0.121,1},
{"O",27.206,12.71,16.685,0.133,1},
{"N",27.41,10.977,15.227,0.169,1},
{"C",28.083,13.823,11.782,0.26,1},
{"C",27.697,13.247,13.142,0.203,1},
{"C",26.888,11.959,13.037,0.158,1},
{"C",25.789,12.219,12.002,0.166,1},
{"C",26.334,11.512,14.382,0.13,1},
{"C",25.289,10.443,14.117,0.145,1},
{"O",25.613,9.271,13.926,0.158,1},
{"N",24.066,10.875,14.304,0.147,1},
{"C",23.664,8.649,16.933,0.304,1},
{"C",22.487,9.571,16.774,0.221,1},
{"C",21.939,9.969,15.405,0.2,1},
{"C",20.707,9.114,14.865,0.235,1},
{"C",22.92,9.942,14.217,0.139,1},
{"C",22.182,10.385,12.955,0.132,1},
{"O",21.912,11.574,12.692,0.163,1},
{"N",21.945,9.47,12.059,0.165,1},
{"S",21.685,7.603,9.714,0.255,0.7},
{"S",23.398,9.942,8.972,0.231,0.3},
{"C",21.84,9.337,9.586,0.202,1},
{"C",21.206,9.913,10.845,0.192,1},
{"C",19.73,9.399,10.982,0.187,1},
{"O",19.464,8.341,11.608,0.196,1},
{"N",18.864,10.198,10.322,0.205,1},
{"C",17.462,9.671,10.344,0.231,1},
{"C",17.24,9.341,8.88,0.203,1},
{"O",18.117,9.636,8.047,0.265,1},
{"N",16.103,8.74,8.534,0.255,1},
{"O",14.579,3.972,7.853,0.547,1},
{"O",12.995,5.367,7.144,0.447,1},
{"C",14.144,5.087,7.467,0.496,1},
{"C",15.197,6.158,7.459,0.342,1},
{"C",14.75,7.46,6.797,0.238,1},
{"C",15.883,8.468,7.111,0.276,1},
{"C",15.571,9.712,6.334,0.312,1},
{"O",15.758,9.5,5.114,0.379,1},
{"N",15.152,10.859,6.834,0.299,1},
{"C",14.137,13.07,6.677,0.314,1},
{"C",14.895,11.984,5.918,0.311,1},
{"C",16.22,12.527,5.366,0.406,1},
{"O",17.365,12.212,5.717,0.36,1},
{"N",15.998,13.556,4.21,0.412,1},
{"C",15.889,13.729,1.302,0.432,1},
{"O",15.796,15.89,2.323,0.529,1},
{"C",16.652,14.771,2.121,0.503,1},
{"C",17.155,14.182,3.544,0.356,1},
{"C",17.822,15.159,4.607,0.341,1},
{"O",17.11,16.014,5.205,0.328,1},
{"N",19.165,15.038,4.775,0.376,1},
{"N",21.514,19.422,3.487,0.588,1},
{"O",21.533,17.127,3.251,0.458,1},
{"C",20.986,18.303,3.555,0.528,1},
{"C",19.548,18.199,4.065,0.532,1},
{"C",19.417,17.515,5.404,0.467,1},
{"C",19.81,16.043,5.668,0.35,1},
{"C",19.394,15.956,7.126,0.225,1},
{"O",19.703,16.873,7.913,0.276,1},
{"N",18.676,14.878,7.403,0.246,1},
{"O",14.982,12.074,9.66,0.205,1},
{"O",14.866,12.762,11.758,0.277,1},
{"C",15.322,12.786,10.623,0.225,1},
{"C",16.497,13.693,10.314,0.198,1},
{"C",17.135,13.644,8.918,0.171,1},
{"C",18.258,14.679,8.801,0.22,1},
{"C",19.498,14.097,9.493,0.206,1},
{"O",19.597,12.846,9.537,0.224,1},
{"N",20.46,14.881,9.966,0.217,1},
{"O",22.83,12.617,8.229,0.305,1},
{"O",22.524,14.498,7.392,0.283,1},
{"C",22.761,13.826,8.419,0.268,1},
{"C",22.935,14.578,9.75,0.258,1},
{"C",21.689,14.338,10.63,0.169,1},
{"C",21.793,15.113,11.911,0.124,1},
{"O",21.738,16.332,11.887,0.166,1},
{"N",21.928,14.388,12.993,0.144,1},
{"O",15.683,14.447,13.435,0.309,1},
{"C",18.821,15.441,15.061,0.164,1},
{"C",17.499,15.517,14.553,0.187,1},
{"C",16.98,14.38,13.895,0.248,1},
{"C",17.716,13.206,13.668,0.229,1},
{"C",19.057,13.179,14.121,0.211,1},
{"C",19.59,14.283,14.824,0.19,1},
{"C",21.04,14.238,15.316,0.122,1},
{"C",21.994,14.988,14.31,0.153,1},
{"C",23.431,14.815,14.878,0.143,1},
{"O",23.933,13.693,14.651,0.181,1},
{"N",23.846,15.772,15.608,0.138,1},
{"O",31.047,16.826,18.794,0.219,1},
{"C",28.48,16.08,16.195,0.202,1},
{"C",29.735,16.056,16.869,0.231,1},
{"C",29.882,16.772,18.07,0.243,1},
{"C",28.766,17.493,18.608,0.269,1},
{"C",27.524,17.515,17.901,0.208,1},
{"C",27.372,16.779,16.708,0.17,1},
{"C",26.01,16.848,16.004,0.155,1},
{"C",25.152,15.593,16.266,0.156,1},
{"C",24.927,15.454,17.767,0.17,1},
{"O",24.092,16.294,18.289,0.177,1},
{"N",25.7,14.574,18.376,0.148,1},
{"C",25.463,11.914,20.009,0.124,1},
{"O",25.093,13.392,21.884,0.134,1},
{"C",24.949,13.253,20.43,0.121,1},
{"C",25.718,14.483,19.845,0.166,1},
{"C",27.232,14.476,20.272,0.139,1},
{"O",28.018,13.681,19.724,0.16,1},
{"N",27.54,15.316,21.214,0.164,1},
{"C",28.973,15.337,21.68,0.18,1},
{"C",29.017,14.781,23.064,0.243,1},
{"O",30.04,14.697,23.755,0.23,1},
{"N",27.861,14.347,23.574,0.227,1},
{"O",25.114,14.616,24.424,0.193,1},
{"O",25.102,16.33,25.803,0.291,1},
{"C",25.638,15.304,25.326,0.247,1},
{"C",27.054,14.896,25.835,0.254,1},
{"C",27.758,13.826,24.98,0.21,1},
{"C",27.169,12.428,25.078,0.228,1},
{"O",26.589,12.078,26.161,0.281,1},
{"N",27.368,11.604,24.025,0.245,1},
{"C",28.74,7.34,24.2,0.452,1},
{"N",28.461,5.997,24.141,0.491,1},
{"C",27.338,5.856,24.845,0.45,1},
{"N",26.882,6.994,25.357,0.351,1},
{"C",27.784,7.968,24.948,0.39,1},
{"C",27.653,9.437,25.272,0.3,1},
{"C",26.935,10.201,24.067,0.322,1},
{"C",25.413,10.138,24.222,0.334,1},
{"O",24.871,9.543,25.206,0.288,1},
{"N",24.785,10.861,23.3,0.3,1},
{"O",26.112,5.917,20.047,0.451,1},
{"C",24.247,7.411,22.793,0.381,1},
{"C",25.037,6.56,22.028,0.481,1},
{"C",25.286,6.831,20.674,0.481,1},
{"C",24.719,7.945,20.039,0.375,1},
{"C",23.932,8.782,20.822,0.393,1},
{"C",23.676,8.544,22.175,0.316,1},
{"C",22.797,9.433,23.028,0.286,1},
{"C",23.297,10.882,23.223,0.355,1},
{"C",22.528,11.54,24.362,0.376,1},
{"O",21.329,11.199,24.514,0.393,1},
{"N",23.108,12.44,25.14,0.238,1},
{"C",23.167,13.629,27.299,0.272,1},
{"C",22.314,13.105,26.164,0.282,1},
{"C",21.588,14.224,25.422,0.295,1},
{"O",20.386,14.444,25.593,0.324,1},
{"N",22.231,14.967,24.552,0.246,1},
{"C",21.993,17.55,25.96,0.296,1},
{"O",23.344,17.746,24.037,0.237,1},
{"C",21.997,17.45,24.435,0.276,1},
{"C",21.62,16.079,23.796,0.191,1},
{"C",21.988,15.882,22.332,0.236,1},
{"O",22.977,15.181,21.926,0.219,1},
{"N",21.125,16.44,21.481,0.172,1},
{"C",21.571,13.059,18.913,0.212,1},
{"C",21.763,11.705,19.221,0.244,1},
{"C",21.088,11.196,20.332,0.193,1},
{"C",20.262,11.972,21.162,0.22,1},
{"C",20.054,13.268,20.824,0.208,1},
{"C",20.705,13.84,19.713,0.189,1},
{"C",20.405,15.285,19.375,0.154,1},
{"C",21.297,16.309,20.044,0.138,1},
{"C",20.992,17.643,19.414,0.177,1},
{"O",20.114,18.309,19.999,0.177,1},
{"N",21.653,17.95,18.327,0.146,1},
{"O",22.648,20.939,18.8,0.377,1},
{"C",22.628,20.147,17.655,0.268,1},
{"C",21.458,19.175,17.586,0.16,1},
{"C",21.324,18.712,16.123,0.147,1},
{"O",21.967,17.767,15.768,0.154,1},
{"N",20.407,19.344,15.395,0.147,1},
{"C",17.864,20.141,11.313,0.333,1},
{"C",18.359,17.675,11.728,0.308,1},
{"C",18.774,19.124,11.952,0.262,1},
{"C",18.845,19.411,13.478,0.192,1},
{"C",20.237,19.008,13.984,0.155,1},
{"C",21.39,19.809,13.233,0.165,1},
{"O",21.657,21.012,13.414,0.169,1},
{"N",22.137,19.089,12.407,0.178,1},
{"C",25.803,16.848,12.081,0.175,1},
{"C",24.804,17.954,12.548,0.125,1},
{"C",24.332,18.645,11.234,0.134,1},
{"C",25.413,19.476,10.479,0.189,1},
{"C",23.221,19.712,11.651,0.202,1},
{"C",22.702,20.412,10.39,0.208,1},
{"O",21.991,19.879,9.561,0.198,1},
{"N",23.142,21.664,10.295,0.2,1},
{"O",22.559,24.494,7.235,0.232,1},
{"O",21.711,25.889,8.598,0.295,1},
{"C",22.301,24.792,8.392,0.239,1},
{"C",22.564,23.886,9.594,0.155,1},
{"C",22.932,22.517,9.148,0.16,1},
{"C",24.27,22.598,8.362,0.146,1},
{"O",25.219,23.303,8.742,0.178,1},
{"N",24.237,21.884,7.297,0.159,1},
{"N",25.99,17.688,4.954,0.481,1},
{"O",24.286,17.229,6.406,0.378,1},
{"C",25.241,18.008,5.895,0.424,1},
{"C",25.365,19.351,6.575,0.306,1},
{"C",25.294,20.537,5.598,0.198,1},
{"C",25.445,21.8,6.41,0.179,1},
{"C",25.686,22.999,5.529,0.205,1},
{"O",26.633,22.939,4.741,0.248,1},
{"N",24.865,24.035,5.624,0.213,1},
{"C",22.994,24.497,3.511,0.26,1},
{"O",22.801,26.346,5.25,0.246,1},
{"C",23.61,25.693,4.237,0.197,1},
{"C",25.013,25.2,4.796,0.194,1},
{"C",25.702,26.348,5.483,0.175,1},
{"O",25.844,27.382,4.856,0.181,1},
{"N",26.087,26.129,6.699,0.177,1},
{"S",24.83,27.111,9.609,0.216,1},
{"C",25.787,28.063,8.333,0.181,1},
{"C",26.73,27.242,7.436,0.154,1},
{"C",27.914,26.73,8.276,0.182,1},
{"O",28.065,25.496,8.349,0.197,1},
{"O",28.487,27.688,8.839,0.213,1},
{"O",38.115,8.296,25.493,0.545,1},
{"O",40.251,8.969,26.756,0.589,1},
{"O",38.054,8.459,27.913,0.634,1},
{"O",38.578,10.575,26.544,0.637,1},
{"S",38.722,9.032,26.659,0.619,1}};
int rnasexyzdata_size = sizeof( rnasexyzdata ) / sizeof( rnasexyzdata[0] );


Test_data::Test_data() {
  Spacegroup spgr = Spacegroup( Spgr_descr( rnasespgr ) );
  Cell       cell = Cell( Cell_descr( rnasecell[0], rnasecell[1], rnasecell[2],
				      rnasecell[3], rnasecell[4], rnasecell[5] ) );
  Resolution reso( rnasereso - 1.0e-3 );
  std::vector<HKL> hkl;
  hklinfo.init( spgr, cell, reso, true );
  fsig.init( hklinfo, hklinfo.cell() );
  abcd.init( hklinfo, hklinfo.cell() );
  datatypes::F_sigF<float> fs;
  datatypes::ABCD<float>   hl;
  bool flag = true;
  for ( int i = 0; i < rnasehkldata_size; i++ ) {
    HKL hkl( rnasehkldata[i].h, rnasehkldata[i].k, rnasehkldata[i].l );
    fs.f() = rnasehkldata[i].f;
    fs.sigf() = rnasehkldata[i].s;
    hl.a() = rnasehkldata[i].a;
    hl.b() = rnasehkldata[i].b;
    hl.c() = rnasehkldata[i].c;
    hl.d() = rnasehkldata[i].d;
    flag = flag && fsig.set_data( hkl, fs );
    flag = flag && abcd.set_data( hkl, hl );
  }
  std::vector<Atom> v;
  for ( int i = 0; i < rnasexyzdata_size; i++ ) {
    Atom a = Atom::null();
    a.set_element( rnasexyzdata[i].element );
    a.set_coord_orth(
      Coord_orth( rnasexyzdata[i].x, rnasexyzdata[i].y, rnasexyzdata[i].z ) );
    a.set_u_iso( rnasexyzdata[i].u_iso );
    a.set_occupancy( rnasexyzdata[i].occ );
    v.push_back(a);
  }
  atoms = Atom_list( v );
  if ( flag == false )
    Message::message( Message_warn( "Self test: error filling data." ) );
}


} // namespace data


} // namespace clipper
