#include "progress.h"
#include "process_int.h"

#include <stdio.h>


namespace Progress
{
bool stdout_is_tty = 0;
bool silentMode = false;

bool ps_lhead = false;
int ps_nch = 0;
int ps_cval = -1;
const char *context = "";
const char *(*getContext)(void) = nullptr;

/**
 * parameter p_context:
 *          will be displayed in status message and indicates sub process for
 *          which the progress is displayed.
 */
void
setContextFunction(const char *(*func)(void) )
{
  getContext = func;
}

void
init()
{
  ps_lhead = false;
  ps_nch = 0;
  ps_cval = -1;

  if (getContext != nullptr){
      context = getContext();
  }
}
void
init(const char* p_context)
{
  ps_lhead = false;
  ps_nch = 0;
  ps_cval = -1;
  context = p_context;
}

void
update(double offset, double refval, double curval)
{
  if (silentMode) return;
  if (!stdout_is_tty) return;

  offset = offset < 0 ? 0 : offset;
  offset = offset > 1 ? 1 : offset;
  refval = refval < 0 ? 0 : refval;
  refval = refval > 1 ? 1 : refval;
  curval = curval < 0 ? 0 : curval;
  curval = curval > 1 ? 1 : curval;

  int ival = (offset + refval * curval) * 100;

  if (ps_cval == -1)
    {
      ps_nch = fprintf(stdout, "%s: %3d%%", context, 0);
      fflush(stdout);
      ps_lhead = true;
    }

  if (ival != ps_cval)
    {
      ps_cval = ival;
      fprintf(stdout, "\b\b\b\b%3d%%", ps_cval);
      fflush(stdout);
    }

  if (ps_cval == 100 && ps_lhead)
    {
      ps_lhead = false;
      while (ps_nch--) fprintf(stdout, "\b \b");
      fflush(stdout);
    }
}
}  // namespace Progress
