/*
 *  acm : an aerial combat simulator for X
 *  Copyright (C) 1991-1996  Riley Rainey
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 dated June, 1991.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program;  if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
 */

#include <string.h>
#include "pm.h"
#include "weapon_null.h"
#include "ccip.h"
#include "m61a1.h"
#include "aim9m.h"
#include "aim120.h"

#define weapon_IMPORT
#include "weapon.h"

#define WEAPONTYPES 5
/*
	Total no. defined weapons, i.e. size of wtbl[].
*/

static weapon_Type * wtbl[WEAPONTYPES];
/*
	Descriptions of different available weapons.
*/


static char * names[WEAPONTYPES] = {
	"----",
	"M61A1",
	"AIM-9M",
	"AIM-120",
	"MK82"
};


int weapon_nameToId(char * name)
{
	int i;

	for( i = 0; i < WEAPONTYPES; i++ )
		if( strcmp(name, names[i]) == 0 )
			return i;
	
	return -1;
}


char * weapon_idToName(int id)
{
	if( id < 0 || id >= WEAPONTYPES )
		return NULL;
	
	return names[id];
}


int
weapon_countOrdinance(craft * c, int id)
{

	register int i, count = 0;

	for (i = 0; i < c->cinfo->sCount; ++i) {
		if (c->station[i].id == id)
			++count;
	}

	return count;
}

int
weapon_getReadyStation(craft * c, int id)
{

	register int i;

	for (i = 0; i < c->cinfo->sCount; ++i) {
		if (c->station[i].id == id)
			return i;
	}

	return -1;
}

int
weapon_selectNextAvailable(craft * c)
{

	int n, m;

	m = c->curWeapon;
	n = (c->curWeapon + 1) % WEAPONTYPES;
	for (; n != m; n = (n + 1) % WEAPONTYPES) {
		if( n == weapon_NULL ){
			c->curWeapon = weapon_NULL;
			return 1;

		} else if (weapon_getReadyStation(c, n) >=0 && wtbl[n]->select != NULL){
			if ((*wtbl[n]->select) (c) == 1) {
				c->curWeapon = n;
				return 1;
			}
		}
	}

	return 0;  /* should never reach this point */
}

int
weapon_selectByName(craft * c, int id)
{
	if ((*wtbl[id]->select) (c) == 1) {
		c->curWeapon = id;
		return 1;
	}
	return 0;
}

int
weapon_fire(craft * c)
{
	return (*wtbl[c->curWeapon]->firePress) (c);
}

int
weapon_ceaseFire(craft * c)
{
	if (wtbl[c->curWeapon]->fireRelease != NULL)
		return (*wtbl[c->curWeapon]->fireRelease) (c);

	return 0;
}

int
weapon_displaySelected(craft * c, viewer * u, int fpm_x, int fpm_y)
{
	return (*wtbl[c->curWeapon]->display) (c, wtbl[c->curWeapon]->w, u,
		fpm_x, fpm_y);
}

int
weapon_update(craft * c)
{
	return (*wtbl[c->curWeapon]->update) (c);
}


void weapon_init()
{
	wtbl[weapon_NULL] = weapon_null_new();
	wtbl[weapon_M61A1] = m61a1_new();
	wtbl[weapon_MK82] = ccip_new();
	wtbl[weapon_AIM9M] = aim9m_new();
	wtbl[weapon_AIM120] = aim120_new();
}
