// GENERATED FILE - DO NOT EDIT.
// Generated by gen_restricted_traces.py using data from restricted_traces.json
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// restricted_traces_autogen: Types and enumerations for trace tests.

#include "restricted_traces_autogen.h"

#include "common/PackedEnums.h"

#include "angry_birds_2_1500/angry_birds_2_1500_capture_context3.h"
#include "candy_crush_500/candy_crush_500_capture_context2.h"
#include "egypt_1500/egypt_1500_capture_context6.h"
#include "manhattan_10/manhattan_10_capture_context6.h"
#include "subway_surfer_500/subway_surfer_500_capture_context4.h"
#include "temple_run_300/temple_run_300_capture_context3.h"
#include "trex_200/trex_200_capture_context6.h"

namespace angle
{
namespace
{
constexpr angle::PackedEnumMap<RestrictedTraceID, TraceInfo> kTraceInfos = {
    {RestrictedTraceID::angry_birds_2_1500,
     {angry_birds_2_1500::kReplayFrameStart, angry_birds_2_1500::kReplayFrameEnd,
      angry_birds_2_1500::kReplayDrawSurfaceWidth, angry_birds_2_1500::kReplayDrawSurfaceHeight,
      "angry_birds_2_1500"}},
    {RestrictedTraceID::candy_crush_500,
     {candy_crush_500::kReplayFrameStart, candy_crush_500::kReplayFrameEnd,
      candy_crush_500::kReplayDrawSurfaceWidth, candy_crush_500::kReplayDrawSurfaceHeight,
      "candy_crush_500"}},
    {RestrictedTraceID::egypt_1500,
     {egypt_1500::kReplayFrameStart, egypt_1500::kReplayFrameEnd,
      egypt_1500::kReplayDrawSurfaceWidth, egypt_1500::kReplayDrawSurfaceHeight, "egypt_1500"}},
    {RestrictedTraceID::manhattan_10,
     {manhattan_10::kReplayFrameStart, manhattan_10::kReplayFrameEnd,
      manhattan_10::kReplayDrawSurfaceWidth, manhattan_10::kReplayDrawSurfaceHeight,
      "manhattan_10"}},
    {RestrictedTraceID::subway_surfer_500,
     {subway_surfer_500::kReplayFrameStart, subway_surfer_500::kReplayFrameEnd,
      subway_surfer_500::kReplayDrawSurfaceWidth, subway_surfer_500::kReplayDrawSurfaceHeight,
      "subway_surfer_500"}},
    {RestrictedTraceID::temple_run_300,
     {temple_run_300::kReplayFrameStart, temple_run_300::kReplayFrameEnd,
      temple_run_300::kReplayDrawSurfaceWidth, temple_run_300::kReplayDrawSurfaceHeight,
      "temple_run_300"}},
    {RestrictedTraceID::trex_200,
     {trex_200::kReplayFrameStart, trex_200::kReplayFrameEnd, trex_200::kReplayDrawSurfaceWidth,
      trex_200::kReplayDrawSurfaceHeight, "trex_200"}}};
}

const TraceInfo &GetTraceInfo(RestrictedTraceID traceID)
{
    return kTraceInfos[traceID];
}

void ReplayFrame(RestrictedTraceID traceID, uint32_t frameIndex)
{
    switch (traceID)
    {
        case RestrictedTraceID::angry_birds_2_1500:
            angry_birds_2_1500::ReplayContext3Frame(frameIndex);
            break;
        case RestrictedTraceID::candy_crush_500:
            candy_crush_500::ReplayContext2Frame(frameIndex);
            break;
        case RestrictedTraceID::egypt_1500:
            egypt_1500::ReplayContext6Frame(frameIndex);
            break;
        case RestrictedTraceID::manhattan_10:
            manhattan_10::ReplayContext6Frame(frameIndex);
            break;
        case RestrictedTraceID::subway_surfer_500:
            subway_surfer_500::ReplayContext4Frame(frameIndex);
            break;
        case RestrictedTraceID::temple_run_300:
            temple_run_300::ReplayContext3Frame(frameIndex);
            break;
        case RestrictedTraceID::trex_200:
            trex_200::ReplayContext6Frame(frameIndex);
            break;
        default:
            fprintf(stderr, "Error in switch.\n");
            assert(0);
            break;
    }
}

void ResetReplay(RestrictedTraceID traceID)
{
    switch (traceID)
    {
        case RestrictedTraceID::angry_birds_2_1500:
            angry_birds_2_1500::ResetContext3Replay();
            break;
        case RestrictedTraceID::candy_crush_500:
            candy_crush_500::ResetContext2Replay();
            break;
        case RestrictedTraceID::egypt_1500:
            egypt_1500::ResetContext6Replay();
            break;
        case RestrictedTraceID::manhattan_10:
            manhattan_10::ResetContext6Replay();
            break;
        case RestrictedTraceID::subway_surfer_500:
            subway_surfer_500::ResetContext4Replay();
            break;
        case RestrictedTraceID::temple_run_300:
            temple_run_300::ResetContext3Replay();
            break;
        case RestrictedTraceID::trex_200:
            trex_200::ResetContext6Replay();
            break;
        default:
            fprintf(stderr, "Error in switch.\n");
            assert(0);
            break;
    }
}

void SetupReplay(RestrictedTraceID traceID)
{
    switch (traceID)
    {
        case RestrictedTraceID::angry_birds_2_1500:
            angry_birds_2_1500::SetupContext3Replay();
            break;
        case RestrictedTraceID::candy_crush_500:
            candy_crush_500::SetupContext2Replay();
            break;
        case RestrictedTraceID::egypt_1500:
            egypt_1500::SetupContext6Replay();
            break;
        case RestrictedTraceID::manhattan_10:
            manhattan_10::SetupContext6Replay();
            break;
        case RestrictedTraceID::subway_surfer_500:
            subway_surfer_500::SetupContext4Replay();
            break;
        case RestrictedTraceID::temple_run_300:
            temple_run_300::SetupContext3Replay();
            break;
        case RestrictedTraceID::trex_200:
            trex_200::SetupContext6Replay();
            break;
        default:
            fprintf(stderr, "Error in switch.\n");
            assert(0);
            break;
    }
}

void SetBinaryDataDir(RestrictedTraceID traceID, const char *dataDir)
{
    switch (traceID)
    {
        case RestrictedTraceID::angry_birds_2_1500:
            angry_birds_2_1500::SetBinaryDataDir(dataDir);
            break;
        case RestrictedTraceID::candy_crush_500:
            candy_crush_500::SetBinaryDataDir(dataDir);
            break;
        case RestrictedTraceID::egypt_1500:
            egypt_1500::SetBinaryDataDir(dataDir);
            break;
        case RestrictedTraceID::manhattan_10:
            manhattan_10::SetBinaryDataDir(dataDir);
            break;
        case RestrictedTraceID::subway_surfer_500:
            subway_surfer_500::SetBinaryDataDir(dataDir);
            break;
        case RestrictedTraceID::temple_run_300:
            temple_run_300::SetBinaryDataDir(dataDir);
            break;
        case RestrictedTraceID::trex_200:
            trex_200::SetBinaryDataDir(dataDir);
            break;
        default:
            fprintf(stderr, "Error in switch.\n");
            assert(0);
            break;
    }
}

void SetBinaryDataDecompressCallback(RestrictedTraceID traceID, DecompressCallback callback)
{
    switch (traceID)
    {
        case RestrictedTraceID::angry_birds_2_1500:
            angry_birds_2_1500::SetBinaryDataDecompressCallback(callback);
            break;
        case RestrictedTraceID::candy_crush_500:
            candy_crush_500::SetBinaryDataDecompressCallback(callback);
            break;
        case RestrictedTraceID::egypt_1500:
            egypt_1500::SetBinaryDataDecompressCallback(callback);
            break;
        case RestrictedTraceID::manhattan_10:
            manhattan_10::SetBinaryDataDecompressCallback(callback);
            break;
        case RestrictedTraceID::subway_surfer_500:
            subway_surfer_500::SetBinaryDataDecompressCallback(callback);
            break;
        case RestrictedTraceID::temple_run_300:
            temple_run_300::SetBinaryDataDecompressCallback(callback);
            break;
        case RestrictedTraceID::trex_200:
            trex_200::SetBinaryDataDecompressCallback(callback);
            break;
        default:
            fprintf(stderr, "Error in switch.\n");
            assert(0);
            break;
    }
}
}  // namespace angle
