/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.export.compressors;

import java.io.IOException;
import java.util.Collection;
import org.web3d.vrml.export.compressors.BitPacker;
import org.web3d.vrml.export.compressors.HuffmanNode;

class ShortHuffmanNode
extends HuffmanNode {
    short data;
    int dataLength;

    protected ShortHuffmanNode() {
    }

    protected ShortHuffmanNode(short s) {
        this.data = s;
    }

    public void setValue(short s) {
        this.data = s;
    }

    public short getValue() {
        return this.data;
    }

    public void writeData(BitPacker bitPacker, int n) throws IOException {
        bitPacker.pack(this.data, n);
    }

    void collectLeaves(int n, int n2, Collection collection) {
        this.tag = n;
        this.tagLength = n2;
        collection.add(this);
    }

    public String toString() {
        return "data: " + this.data + "\ntag 0x" + Integer.toBinaryString(this.tag) + " tag length " + this.tagLength + "\nfrequency: " + this.frequency;
    }

    public int hashCode() {
        return this.data;
    }

    public boolean equals(Object object) {
        if (object instanceof ShortHuffmanNode) {
            return this.data == ((ShortHuffmanNode)object).getValue();
        }
        return false;
    }
}

