pub trait Draw {
    fn draw(&self);
}

// ANCHOR: here
pub struct Screen<T: Draw> {
    pub components: Vec<T>,
}

impl<T> Screen<T>
where
    T: Draw,
{
    pub fn run(&self) {
        for component in self.components.iter() {
            component.draw();
        }
    }
}
// ANCHOR_END: here
