#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
TOP_SRCDIR=${TOP_SRCDIR-"../../../rheolef"}
SRCDIR=${SRCDIR-"$TOP_SRCDIR/nfem/ptst"}
GEODIR=$SRCDIR
NPROC_MAX=${NPROC_MAX-"3"}
. "${TOP_SRCDIR}/config/loop_mpirun.sh"

method_list="function expression"

status=0

for method in ${method_list}; do
  loop_mpirun "./field_reinterpolate_tst $GEODIR/line-3-bdry.geo $GEODIR/line-20-bdry.geo 1e-7 -$method >/dev/null 2>/dev/null"
  if test $? -ne 0; then status=1; fi

  loop_mpirun "./field_reinterpolate_tst $GEODIR/carre-10-bdry-v2 $GEODIR/carre-bamg-q-dom-v2 1e-7 -$method >/dev/null 2>/dev/null"
  if test $? -ne 0; then status=1; fi

  loop_mpirun "./field_reinterpolate_tst $GEODIR/cube-5-bdry-v2.geo $GEODIR/cube-H-6-dom-v2.geo 1e-7 -$method > /dev/null 2>/dev/null"
  if test $? -ne 0; then status=1; fi

  # TODO: nearest with distributed memory and 3D case:
  run "./field_reinterpolate_tst $GEODIR/circle_p1-v2.geo $GEODIR/circle-10-fix-P1.geo 0.006 >/dev/null 2>/dev/null"
  if test $? -ne 0; then status=1; fi
done

exit $status
