REMMINA(1)

# NAME

remmina -- Remmina the GTK+ Remote Desktop Client

# SYNOPSIS

remmina [-a|i|n|q|v] [-c FILE] [-e FILE] [-p TABINDEX] [-s SERVER] \
[-t PROTOCOL] [-x PLUGIN] [--update-profile] \
[--set-option OPTION[=VALUE]] [--display DISPLAY]

# DESCRIPTION

Remmina is a remote desktop client written in GTK+, aiming to be useful for
system administrators and travellers, who need to work with lots of remote
computers in front of either large monitors or tiny netbooks. Remmina
supports multiple network protocols in an integrated and consistent user
interface.

Currently RDP, VNC, SSH, SPICE, and WWW are supported.

Remmina is released in separated source packages:

- "remmina", the main GTK+ application
- "remmina-plugins", a set of plugins

Remmina is free and open-source software, released under GNU GPL license.

# FILES

${XDG_CONFIG_DIRS}/remmina.pref or ${XDG_CONFIG_HOME}/remmina/remmina.pref :

Remmina configuration files.

At the first Remmina execution the system wide Remmina configuration files,
will be copied in the ${XDG_CONFIG_HOME}

${XDG_DATA_DIRS}/FILE.remmina or ${XDG_DATA_HOME}/remmina/FILE.remmina :

Remmina profiles, the file name is autogenerated, but you can create
manually your own files with the FILE name you prefer. It's possible to
specify a custom profile name and location.

# OPTIONS

*-h, --help*
	Show help options

*-a*
	Show about dialog

*-c, --connect=FILE*
	Connect directly either to a desktop using options described in a file,
	or a supported URI (RDP, VNC, SSH or SPICE).++
The filetype can be ".remmina" or one supported by a plugin capable of
	importing files

*-e, --edit=FILE*
	Open and edit desktop connection using options described by file,
	file type can be either .remmina or one supported by a file
	import capable plugin

*-k, --kiosk*
	Start Remmina in kiosk mode (thin client)

*-n, --new*
	Create a new connection profile

*-p, --pref=TABINDEX*
	Show preferences dialog page

*-x, --plugin=PLUGIN*
	Execute the plugin

*-q, --quit*
	Quit the application

*-s, --server=SERVER*
	Use default server name (for *--new*)

*-t, --protocol=PROTOCOL*
	Use default protocol (for *--new*)

*-i, --icon*
	Start as tray icon

*-v, --version*
	Show the application's version

*--update-profile*
	Modify connection profile, require also *--set-option*

*--set-option OPTION[=VALUE]*
	Set one or more profile settings, to be used with *--update-pro-file*

*--encrypt-password*
	Encrypt a password

*--display=DISPLAY*
	X display to use

*--disable-news*
	Disable news notification

*--disable-toolbar*
	Disable toolbar

*--enable-fullscreen*
	Enable fullscreen

*--enable-extra-hardening*
	Enable extra hardening (disable closing confirmation, disable unsafe shortcut keys, hide tabs, hide search bar)++
List of disabled shortcut keys:++
fullscreen, autofit, prevtab and nexttab, scale, grab, minimize, viewonly, screenshot, disconnect, toolbar

*--no-tray-icon*
	Disable tray icon

# EXAMPLES

To connect using an exisitng connection profile use:
*remmina -c FILE.remmina*

To quick connect using a URI:

remmina -c rdp://username@server++
remmina -c rdp://domain\\\\username@server++
remmina -c vnc://username@server++
remmina -c vnc://server?VncUsername=username++
remmina -c ssh://user@server++
remmina -c spice://server

To quick connect using a URI along with an encrypted password:

remmina -c rdp://username:encrypted-password@server++
remmina -c vnc://username:encrypted-password@server++
remmina -c vnc://server?VncUsername=username\\&VncPassword=encrypted-password

To encrypt a password for use with a URI:

remmina --encrypt-password

To update username and password and set a different resolution mode of a
remmina connection profile use:

echo "ausername\napassword" | remmina --update-profile /PATH/TO/FOO.remmina --set-option username --set-option resolution_mode=2 --set-option password

# SEE ALSO

remmina-file-wrapper(1)

# AUTHORS

Antenore Gatta <antenore at simbiosi dot org> and
Giovanni Panozzo <giovanni at panozzo dot it>

See the THANKS file for a more detailed list.

Remmina was initially written by Vic Lee <llyzs@163.com>

This manual page was written by Antenore Gatta <antenore at simbiosi dot org>.

# COPYRIGHT

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any later
version.
