context("pair_measures")

get_val <- function(gr, fn) {
  gr %>% mutate(val = fn) %>% pull(val)
}
test_that("pair measures return correct type", {
  gr <- create_ring(5, directed = TRUE)
  expect_is(get_val(gr, node_adhesion_from(1)), 'numeric')
  expect_is(get_val(gr, node_adhesion_to(1)), 'numeric')
  expect_is(get_val(gr, node_cocitation_with(1)), 'numeric')
  expect_is(get_val(gr, node_cohesion_from(1)), 'numeric')
  expect_is(get_val(gr, node_cohesion_to(1)), 'numeric')
  expect_is(get_val(gr, node_distance_from(1)), 'numeric')
  expect_is(get_val(gr, node_distance_to(1)), 'numeric')
  expect_is(get_val(gr, node_max_flow_from(1)), 'numeric')
  expect_is(get_val(gr, node_max_flow_to(1)), 'numeric')
  expect_is(get_val(gr, node_similarity_with(1)), 'numeric')
})
test_that("pair measures return correct length", {
  gr <- create_ring(5, directed = TRUE)
  expect_length(get_val(gr, node_adhesion_from(1)), igraph::gorder(gr))
  expect_length(get_val(gr, node_adhesion_to(1)), igraph::gorder(gr))
  expect_length(get_val(gr, node_cocitation_with(1)), igraph::gorder(gr))
  expect_length(get_val(gr, node_cohesion_from(1)), igraph::gorder(gr))
  expect_length(get_val(gr, node_cohesion_to(1)), igraph::gorder(gr))
  expect_length(get_val(gr, node_distance_from(1)), igraph::gorder(gr))
  expect_length(get_val(gr, node_distance_to(1)), igraph::gorder(gr))
  expect_length(get_val(gr, node_max_flow_from(1)), igraph::gorder(gr))
  expect_length(get_val(gr, node_max_flow_to(1)), igraph::gorder(gr))
  expect_length(get_val(gr, node_similarity_with(1)), igraph::gorder(gr))
})
test_that("pair measures requires active nodes", {
  gr <- create_ring(5, directed = TRUE) %>% activate(edges)
  expect_error(get_val(gr, node_adhesion_from(1)))
  expect_error(get_val(gr, node_adhesion_to(1)))
  expect_error(get_val(gr, node_cocitation_with(1)))
  expect_error(get_val(gr, node_cohesion_from(1)))
  expect_error(get_val(gr, node_cohesion_to(1)))
  expect_error(get_val(gr, node_distance_from(1)))
  expect_error(get_val(gr, node_distance_to(1)))
  expect_error(get_val(gr, node_max_flow_from(1)))
  expect_error(get_val(gr, node_max_flow_to(1)))
  expect_error(get_val(gr, node_similarity_with(1)))
})
