% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wmatrix.R
\name{wmatrix_weights}
\alias{wmatrix_weights}
\alias{rowweights}
\alias{rowweights.linwmatrix}
\alias{rowweights.logwmatrix}
\alias{lrowweights}
\alias{lrowweights.logwmatrix}
\alias{lrowweights.linwmatrix}
\alias{rowweights<-}
\alias{rowweights<-.linwmatrix}
\alias{rowweights<-.logwmatrix}
\alias{lrowweights<-}
\alias{lrowweights<-.linwmatrix}
\alias{lrowweights<-.logwmatrix}
\alias{rowweights<-.matrix}
\alias{lrowweights<-.matrix}
\title{Set or extract weighted matrix row weights}
\usage{
rowweights(x, ...)

\method{rowweights}{linwmatrix}(x, ...)

\method{rowweights}{logwmatrix}(x, ...)

lrowweights(x, ...)

\method{lrowweights}{logwmatrix}(x, ...)

\method{lrowweights}{linwmatrix}(x, ...)

rowweights(x, ...) <- value

\method{rowweights}{linwmatrix}(x, update = TRUE, ...) <- value

\method{rowweights}{logwmatrix}(x, update = TRUE, ...) <- value

lrowweights(x, ...) <- value

\method{lrowweights}{linwmatrix}(x, update = TRUE, ...) <- value

\method{lrowweights}{logwmatrix}(x, update = TRUE, ...) <- value

\method{rowweights}{matrix}(x, ...) <- value

\method{lrowweights}{matrix}(x, ...) <- value
}
\arguments{
\item{x}{a \code{\link{linwmatrix}}, a \code{\link{logwmatrix}}, or a \code{\link{matrix}}; a
\code{\link{matrix}} is coerced to a weighted matrix of an appropriate
type.}

\item{...}{extra arguments for methods.}

\item{value}{weights to set, on the appropriate scale.}

\item{update}{if \code{TRUE} (the default), the old weights are updated
with the new weights (i.e., corresponding weights are multiplied
on linear scale or added on on log scale); otherwise, they are
overwritten.}
}
\value{
For the accessor functions, the row weights or the row
log-weights; otherwise, a weighted matrix with modified
weights. The type of weight (linear or logarithmic) is converted
to the required type and the type of weighting of the matrix is
preserved.
}
\description{
Set or extract weighted matrix row weights
}
