#python2_sitelib macro shim
%{!?python2_sitelib:%global python2_sitelib %(python -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}
#udev macro shim
%{!?_udevrulesdir:%global _udevrulesdir %{_sysconfdir}/udev/rules.d/ }

Name:		ola
Version:	0.10.7
Release:	1%{?dist}
Summary:	Open Lighting Architecture
Group:		Applications/Multimedia
License:	GPLv2 and LGPLv2
URL:		https://github.com/OpenLightingProject/ola
Source:		https://github.com/OpenLightingProject/ola/releases/download/%{version}/%{name}-%{version}.tar.gz

BuildRequires:	pkgconfig,pkgconfig(cppunit),pkgconfig(uuid),pkgconfig(avahi-client)
BuildRequires:	pkgconfig(libusb-1.0) >= 1.0.2,pkgconfig(libmicrohttpd) >= 0.4.0%{!?el6:,pkgconfig(systemd)}
BuildRequires:	libtool,bison,flex,python2-devel,openslp-devel,pkgconfig(libftdi%{!?el6:1}) >= 0.18
BuildRequires:	protobuf-devel >= 0.2,protobuf-compiler,protobuf-python,numpy
%if 0%{?fedora} >= 21
BuildRequires:	liblo-devel
%endif
Requires:	%{name}-data = %{version}-%{release}

%description
The Open Lighting Architecture is a framework for lighting control information.
It supports a range of protocols and over a dozen USB devices. It can run as a
standalone service, which is useful for converting signals between protocols,
or alternatively using the OLA API, it can be used as the back-end for lighting
control software. OLA runs on many different platforms including ARM, which
makes it a perfect fit for low cost Ethernet to DMX gateways.

%package devel
Requires:	%{name}%{?_isa} = %{version}-%{release}
Group:		Development/Libraries
Summary:	C/C++ Development files for OLA

%description devel
The OLA C/C++ library

%package -n python2-%{name}
Requires:	%{name} = %{version}-%{release}, protobuf-python
Group:		Development/Libraries
Summary:	Python Development files for OLA
BuildArch:	noarch
%{?python_provide:%python_provide python2-%{name}}

%description -n python2-%{name}
The OLA python library

%package rdm-tests
Requires:	%{name} = %{version}-%{release}, python2-%{name}, numpy
Group:		Development/Libraries
BuildArch:	noarch
Summary:	RDM test suite using OLA and python
Provides:	bundled(jquery) = 1.7.2, bundled(jquery-ui) = 1.8.21

%description rdm-tests
The rdm test suite for OLA

%package data
Group:		Development/Libraries
BuildArch:	noarch
Summary:	data for OLA
Provides:	bundled(bootstrap) = 3.3.2, bundled(jquery) = 2.1.3
Provides:	bundled(angularjs) = 1.3.14, bundled(angular-route) = 1.3.14

%description data
HTML, CSS, JS and RDM PIDs files for OLA

%prep
%setup -q -n %{name}-%{version}

%build
export LD_LIBRARY_PATH="%buildroot%{_libdir}"
autoreconf -i
%configure --enable-rdm-tests --enable-shared --disable-static
#only link as needed
sed -i -e 's! -shared ! -Wl,--as-needed\0!g' libtool
#rpath, please die
sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool
#we can't fix this upstream (I think)
sed -i "s|\$(LN_S) -f \$(bindir)\/|\$(LN_S) -f |g" Makefile
make %{!?el6:%{?_smp_mflags}} #el6 has problems with parallel building

%check
export LD_LIBRARY_PATH="%buildroot%{_libdir}"
make check %{!?el6:%{?_smp_mflags}} #el6 has problems with parallel building
find %buildroot -name "*\.la" -delete
find %buildroot -name "*\.a" -delete

%install
export LD_LIBRARY_PATH="%buildroot%{_libdir}"
%make_install
mkdir -p %buildroot/%{_udevrulesdir}
cp debian/ola.udev %buildroot/%{_udevrulesdir}

%post -p /sbin/ldconfig
%postun -p /sbin/ldconfig

%files
#license shim
%{!?_licensedir:%global license %doc}
%doc AUTHORS NEWS README
%{_bindir}/ola*
%{_bindir}/rdmpro_sniffer
%{_bindir}/usbpro_firmware
%{_libdir}/libola*\.so\.*
%{_mandir}/man1/**
%{_udevrulesdir}/ola.udev
%license LICENCE tools/rdm/static/MIT-LICENSE.txt javascript/new-src/README.md COPYING

%files devel
%doc README.developer
%{_includedir}/ola**
%{_libdir}/libola*\.so
%{_libdir}/pkgconfig/*

%files -n python2-%{name}
%dir %{python2_sitelib}/ola
%{python2_sitelib}/ola/*\.py*
%{python2_sitelib}/ola/rpc

%files rdm-tests
%{_bindir}/rdm_model_collector.py*
%{_bindir}/rdm_responder_test.py*
%{_bindir}/rdm_test_server.py*
%{_datadir}/ola/rdm-server
%{python2_sitelib}/ola/testing

%files data
%{_datadir}/olad
%dir %{_datadir}/ola
%{_datadir}/ola/pids

%changelog
* Thu Nov 12 2015 Dave Olsthoorn <dave.olsthoorn@gmail.com> - 0.9.8-1
- update to 0.9.8 full changelog here: https://github.com/OpenLightingProject/ola/releases/tag/0.9.8

* Sat Sep 19 2015 Dave Olsthoorn <dave.olsthoorn@gmail.com> - 0.9.7-1
- update to 0.9.7
- OLA now requires libusb

* Thu Aug 27 2009 Kevin Deldycke <kevin@deldycke.com> 0.3.1.trunk.20090827-1mdv2009.1
- Rename all project from lla to OLA
- Upgrade to the latest OLA 0.3.1 from the master branch of the git repository
- OLA now requires libmicrohttpd, libcppunit, protobuf and libctemplate
- Disable the --no-undefined option and make all undefined symbols weakly bound
- Add check step
- Rebuild RPM for Mandriva 2009.1

* Mon May 12 2008 Kevin Deldycke <kev@coolcavemen.com> 0.2.3.200710210908-1mdv2008.1
- Ported from Fedora Core 8 ( http://rpms.netmindz.net/FC8/SRPMS.netmindz/lla-0.2.3.200710210908-1.fc8.src.rpm ) to Mandriva 2008.1

* Sun Apr 29 2007 Will Tatam <will@netmindz.net> 0.1.3-1
- First Build
