// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Standard_HeaderFile
#define _Standard_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Standard_Address.hxx>
#include <Standard_Size.hxx>
#include <Standard_Integer.hxx>
class Standard_ErrorHandlerCallback;
class Standard_ErrorHandler;
class Standard_AncestorIterator;
class Standard_Storable;
class Standard_Persistent;
class Standard_GUID;
class Standard_Transient;
class Standard_Type;
class Standard_Failure;



class Standard 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Allocates memory blocks
  //! aSize - bytes to  allocate
  Standard_EXPORT static   Standard_Address Allocate (const Standard_Size aSize) ;
  
  //! Deallocates memory blocks
  //! aStorage - previously allocated memory block to be freed
  Standard_EXPORT static   void Free (const Standard_Address aStorage) ;
template <typename T> static inline void Free (T*& thePtr) { Free ((void*)thePtr); thePtr = 0; }
  
  //! Reallocates memory blocks
  //! aStorage - previously allocated memory block
  //! aNewSize - new size in bytes
  Standard_EXPORT static   Standard_Address Reallocate (const Standard_Address aStorage, const Standard_Size aNewSize) ;
  
  //! Allocates aligned memory blocks.
  //! Should be used with CPU instructions which require specific alignment.
  //! For example: SSE requires 16 bytes, AVX requires 32 bytes.
  //! @param theSize  bytes to allocate
  //! @param theAlign alignment in bytes
  Standard_EXPORT static   Standard_Address AllocateAligned (const Standard_Size theSize, const Standard_Size theAlign) ;
  
  //! Deallocates memory blocks
  //! @param thePtrAligned the memory block previously allocated with AllocateAligned()
  Standard_EXPORT static   void FreeAligned (const Standard_Address thePtrAligned) ;
template <typename T> static inline void FreeAligned (T*& thePtrAligned) { FreeAligned ((void* )thePtrAligned); thePtrAligned = 0; }
  
  //! Deallocates the storage retained on the free list
  //! and clears the list.
  //! Returns non-zero if some memory has been actually freed.
  Standard_EXPORT static   Standard_Integer Purge() ;




protected:





private:




friend class Standard_ErrorHandlerCallback;
friend class Standard_ErrorHandler;
friend class Standard_AncestorIterator;
friend class Standard_Storable;
friend class Standard_Persistent;
friend class Standard_GUID;
friend class Standard_Transient;
friend class Standard_Type;
friend class Standard_Failure;

};







#endif // _Standard_HeaderFile
