message("UNIX non APPLE environment")
message("Please run the configuration like this:")
message("cmake -G \"Unix Makefiles\" -DCMAKE_BUILD_TYPE=Debug ../development")

set(CMAKE_C_IMPLICIT_INCLUDE_DIRECTORIES /usr/include)
set(CMAKE_CXX_IMPLICIT_INCLUDE_DIRECTORIES /usr/include)

set(LINKER_FLAGS "-Wl,--no-as-needed")

find_package(PwizLite REQUIRED) 

find_package(ZLIB REQUIRED)

find_package(Zstd REQUIRED)

if(MAKE_TEST)

	find_package(QuaZip QUIET)
	if(NOT QUAZIP_FOUND)
		message(STATUS "QuaZip not yet found. Searching for it.")
		set(QuaZip_DIR ${CMAKE_MODULE_PATH})
		find_package(QuaZip REQUIRED)
	endif()

endif()


find_package(QCustomPlot REQUIRED)
# Per instructions of the lib author:
# https://www.qcustomplot.com/index.php/tutorials/settingup
message(STATUS "Setting definition -DQCUSTOMPLOT_USE_LIBRARY.")
if(NOT TARGET QCustomPlot::QCustomPlot)
	add_library(QCustomPlot::QCustomPlot UNKNOWN IMPORTED)
	set_target_properties(QCustomPlot::QCustomPlot PROPERTIES
		IMPORTED_LOCATION             "${QCustomPlot_LIBRARIES}"
		INTERFACE_INCLUDE_DIRECTORIES "${QCustomPlot_INCLUDE_DIR}"
		INTERFACE_COMPILE_DEFINITIONS QCUSTOMPLOT_USE_LIBRARY)
endif()


add_definitions(-fPIC)

# Install the cmake module
install(FILES ${CMAKE_MODULE_PATH}/FindPappsoMSpp.cmake 
	DESTINATION ${CMAKE_INSTALL_LIBDIR}/cmake/pappsomspp)

# Configure the cmake config
configure_file (${CMAKE_MODULE_PATH}/PappsoMSppConfig.cmake.in
	${CMAKE_BINARY_DIR}/PappsoMSppConfig.cmake)
# Install the cmake config
install(FILES ${CMAKE_BINARY_DIR}/PappsoMSppConfig.cmake 
	DESTINATION ${CMAKE_INSTALL_LIBDIR}/cmake/pappsomspp)

