
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2019 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQSqlRelationalTableModel.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QSqlRelationalTableModel>
#include <QChildEvent>
#include <QDataStream>
#include <QEvent>
#include <QMetaMethod>
#include <QMimeData>
#include <QModelIndex>
#include <QObject>
#include <QPersistentModelIndex>
#include <QSize>
#include <QSqlDatabase>
#include <QSqlError>
#include <QSqlIndex>
#include <QSqlQuery>
#include <QSqlRecord>
#include <QSqlRelation>
#include <QSqlTableModel>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtSqlCommon.h"
#include "gsiDeclQtSqlTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QSqlRelationalTableModel

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QSqlRelationalTableModel::staticMetaObject);
}


// void QSqlRelationalTableModel::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel *)cls)->clear ();
}


// QVariant QSqlRelationalTableModel::data(const QModelIndex &item, int role)


static void _init_f_data_c3054 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role", true, "Qt::DisplayRole");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_f_data_c3054 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (Qt::DisplayRole, heap);
  ret.write<QVariant > ((QVariant)((QSqlRelationalTableModel *)cls)->data (arg1, arg2));
}


// QSqlRelation QSqlRelationalTableModel::relation(int column)


static void _init_f_relation_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QSqlRelation > ();
}

static void _call_f_relation_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QSqlRelation > ((QSqlRelation)((QSqlRelationalTableModel *)cls)->relation (arg1));
}


// QSqlTableModel *QSqlRelationalTableModel::relationModel(int column)


static void _init_f_relationModel_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QSqlTableModel * > ();
}

static void _call_f_relationModel_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QSqlTableModel * > ((QSqlTableModel *)((QSqlRelationalTableModel *)cls)->relationModel (arg1));
}


// bool QSqlRelationalTableModel::removeColumns(int column, int count, const QModelIndex &parent)


static void _init_f_removeColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_removeColumns_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<bool > ((bool)((QSqlRelationalTableModel *)cls)->removeColumns (arg1, arg2, arg3));
}


// void QSqlRelationalTableModel::revertRow(int row)


static void _init_f_revertRow_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_revertRow_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel *)cls)->revertRow (arg1);
}


// bool QSqlRelationalTableModel::select()


static void _init_f_select_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_select_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlRelationalTableModel *)cls)->select ());
}


// bool QSqlRelationalTableModel::setData(const QModelIndex &item, const QVariant &value, int role)


static void _init_f_setData_5065 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role", true, "Qt::EditRole");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_setData_5065 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QVariant &arg2 = gsi::arg_reader<const QVariant & >() (args, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (Qt::EditRole, heap);
  ret.write<bool > ((bool)((QSqlRelationalTableModel *)cls)->setData (arg1, arg2, arg3));
}


// void QSqlRelationalTableModel::setJoinMode(QSqlRelationalTableModel::JoinMode joinMode)


static void _init_f_setJoinMode_3746 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("joinMode");
  decl->add_arg<const qt_gsi::Converter<QSqlRelationalTableModel::JoinMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setJoinMode_3746 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSqlRelationalTableModel::JoinMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QSqlRelationalTableModel::JoinMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel *)cls)->setJoinMode (qt_gsi::QtToCppAdaptor<QSqlRelationalTableModel::JoinMode>(arg1).cref());
}


// void QSqlRelationalTableModel::setRelation(int column, const QSqlRelation &relation)


static void _init_f_setRelation_3187 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("relation");
  decl->add_arg<const QSqlRelation & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setRelation_3187 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QSqlRelation &arg2 = gsi::arg_reader<const QSqlRelation & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel *)cls)->setRelation (arg1, arg2);
}


// void QSqlRelationalTableModel::setTable(const QString &tableName)


static void _init_f_setTable_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tableName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTable_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel *)cls)->setTable (arg1);
}


// static QString QSqlRelationalTableModel::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QSqlRelationalTableModel::tr (arg1, arg2, arg3));
}


// static QString QSqlRelationalTableModel::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QSqlRelationalTableModel::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QSqlRelationalTableModel () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("clear", "@brief Method void QSqlRelationalTableModel::clear()\nThis is a reimplementation of QSqlTableModel::clear", false, &_init_f_clear_0, &_call_f_clear_0);
  methods += new qt_gsi::GenericMethod ("data", "@brief Method QVariant QSqlRelationalTableModel::data(const QModelIndex &item, int role)\nThis is a reimplementation of QSqlTableModel::data", true, &_init_f_data_c3054, &_call_f_data_c3054);
  methods += new qt_gsi::GenericMethod ("relation", "@brief Method QSqlRelation QSqlRelationalTableModel::relation(int column)\n", true, &_init_f_relation_c767, &_call_f_relation_c767);
  methods += new qt_gsi::GenericMethod ("relationModel", "@brief Method QSqlTableModel *QSqlRelationalTableModel::relationModel(int column)\n", true, &_init_f_relationModel_c767, &_call_f_relationModel_c767);
  methods += new qt_gsi::GenericMethod ("removeColumns", "@brief Method bool QSqlRelationalTableModel::removeColumns(int column, int count, const QModelIndex &parent)\nThis is a reimplementation of QSqlTableModel::removeColumns", false, &_init_f_removeColumns_3713, &_call_f_removeColumns_3713);
  methods += new qt_gsi::GenericMethod ("revertRow", "@brief Method void QSqlRelationalTableModel::revertRow(int row)\nThis is a reimplementation of QSqlTableModel::revertRow", false, &_init_f_revertRow_767, &_call_f_revertRow_767);
  methods += new qt_gsi::GenericMethod ("select", "@brief Method bool QSqlRelationalTableModel::select()\nThis is a reimplementation of QSqlTableModel::select", false, &_init_f_select_0, &_call_f_select_0);
  methods += new qt_gsi::GenericMethod ("setData", "@brief Method bool QSqlRelationalTableModel::setData(const QModelIndex &item, const QVariant &value, int role)\nThis is a reimplementation of QSqlTableModel::setData", false, &_init_f_setData_5065, &_call_f_setData_5065);
  methods += new qt_gsi::GenericMethod ("setJoinMode", "@brief Method void QSqlRelationalTableModel::setJoinMode(QSqlRelationalTableModel::JoinMode joinMode)\n", false, &_init_f_setJoinMode_3746, &_call_f_setJoinMode_3746);
  methods += new qt_gsi::GenericMethod ("setRelation", "@brief Method void QSqlRelationalTableModel::setRelation(int column, const QSqlRelation &relation)\n", false, &_init_f_setRelation_3187, &_call_f_setRelation_3187);
  methods += new qt_gsi::GenericMethod ("setTable", "@brief Method void QSqlRelationalTableModel::setTable(const QString &tableName)\nThis is a reimplementation of QSqlTableModel::setTable", false, &_init_f_setTable_2025, &_call_f_setTable_2025);
  methods += gsi::qt_signal<int > ("beforeDelete(int)", "beforeDelete", gsi::arg("row"), "@brief Signal declaration for QSqlRelationalTableModel::beforeDelete(int row)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QSqlRecord & > ("beforeInsert(QSqlRecord &)", "beforeInsert", gsi::arg("record"), "@brief Signal declaration for QSqlRelationalTableModel::beforeInsert(QSqlRecord &record)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int, QSqlRecord & > ("beforeUpdate(int, QSqlRecord &)", "beforeUpdate", gsi::arg("row"), gsi::arg("record"), "@brief Signal declaration for QSqlRelationalTableModel::beforeUpdate(int row, QSqlRecord &record)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, const QModelIndex &, const QVector<int> & > ("dataChanged(const QModelIndex &, const QModelIndex &, const QVector<int> &)", "dataChanged", gsi::arg("topLeft"), gsi::arg("bottomRight"), gsi::arg("roles"), "@brief Signal declaration for QSqlRelationalTableModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QVector<int> &roles)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QSqlRelationalTableModel::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<Qt::Orientation>::target_type &, int, int > ("headerDataChanged(Qt::Orientation, int, int)", "headerDataChanged", gsi::arg("orientation"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QSqlRelationalTableModel::headerDataChanged(Qt::Orientation orientation, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QList<QPersistentModelIndex> &, const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & > ("layoutAboutToBeChanged(const QList<QPersistentModelIndex> &, QAbstractItemModel::LayoutChangeHint)", "layoutAboutToBeChanged", gsi::arg("parents"), gsi::arg("hint"), "@brief Signal declaration for QSqlRelationalTableModel::layoutAboutToBeChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QList<QPersistentModelIndex> &, const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & > ("layoutChanged(const QList<QPersistentModelIndex> &, QAbstractItemModel::LayoutChangeHint)", "layoutChanged", gsi::arg("parents"), gsi::arg("hint"), "@brief Signal declaration for QSqlRelationalTableModel::layoutChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int, QSqlRecord & > ("primeInsert(int, QSqlRecord &)", "primeInsert", gsi::arg("row"), gsi::arg("record"), "@brief Signal declaration for QSqlRelationalTableModel::primeInsert(int row, QSqlRecord &record)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QSqlRelationalTableModel::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QSqlRelationalTableModel::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QSqlTableModel> &qtdecl_QSqlTableModel ();

qt_gsi::QtNativeClass<QSqlRelationalTableModel> decl_QSqlRelationalTableModel (qtdecl_QSqlTableModel (), "QtSql", "QSqlRelationalTableModel_Native",
  methods_QSqlRelationalTableModel (),
  "@hide\n@alias QSqlRelationalTableModel");

GSI_QTSQL_PUBLIC gsi::Class<QSqlRelationalTableModel> &qtdecl_QSqlRelationalTableModel () { return decl_QSqlRelationalTableModel; }

}


class QSqlRelationalTableModel_Adaptor : public QSqlRelationalTableModel, public qt_gsi::QtObjectBase
{
public:

  virtual ~QSqlRelationalTableModel_Adaptor();

  //  [adaptor ctor] QSqlRelationalTableModel::QSqlRelationalTableModel(QObject *parent, QSqlDatabase db)
  QSqlRelationalTableModel_Adaptor() : QSqlRelationalTableModel()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSqlRelationalTableModel::QSqlRelationalTableModel(QObject *parent, QSqlDatabase db)
  QSqlRelationalTableModel_Adaptor(QObject *parent) : QSqlRelationalTableModel(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSqlRelationalTableModel::QSqlRelationalTableModel(QObject *parent, QSqlDatabase db)
  QSqlRelationalTableModel_Adaptor(QObject *parent, QSqlDatabase db) : QSqlRelationalTableModel(parent, db)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QSqlRelationalTableModel::beginInsertColumns(const QModelIndex &parent, int first, int last)
  void fp_QSqlRelationalTableModel_beginInsertColumns_3713 (const QModelIndex &parent, int first, int last) {
    QSqlRelationalTableModel::beginInsertColumns(parent, first, last);
  }

  //  [expose] void QSqlRelationalTableModel::beginInsertRows(const QModelIndex &parent, int first, int last)
  void fp_QSqlRelationalTableModel_beginInsertRows_3713 (const QModelIndex &parent, int first, int last) {
    QSqlRelationalTableModel::beginInsertRows(parent, first, last);
  }

  //  [expose] bool QSqlRelationalTableModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)
  bool fp_QSqlRelationalTableModel_beginMoveColumns_6659 (const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn) {
    return QSqlRelationalTableModel::beginMoveColumns(sourceParent, sourceFirst, sourceLast, destinationParent, destinationColumn);
  }

  //  [expose] bool QSqlRelationalTableModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)
  bool fp_QSqlRelationalTableModel_beginMoveRows_6659 (const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow) {
    return QSqlRelationalTableModel::beginMoveRows(sourceParent, sourceFirst, sourceLast, destinationParent, destinationRow);
  }

  //  [expose] void QSqlRelationalTableModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)
  void fp_QSqlRelationalTableModel_beginRemoveColumns_3713 (const QModelIndex &parent, int first, int last) {
    QSqlRelationalTableModel::beginRemoveColumns(parent, first, last);
  }

  //  [expose] void QSqlRelationalTableModel::beginRemoveRows(const QModelIndex &parent, int first, int last)
  void fp_QSqlRelationalTableModel_beginRemoveRows_3713 (const QModelIndex &parent, int first, int last) {
    QSqlRelationalTableModel::beginRemoveRows(parent, first, last);
  }

  //  [expose] void QSqlRelationalTableModel::beginResetModel()
  void fp_QSqlRelationalTableModel_beginResetModel_0 () {
    QSqlRelationalTableModel::beginResetModel();
  }

  //  [expose] void QSqlRelationalTableModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)
  void fp_QSqlRelationalTableModel_changePersistentIndex_4682 (const QModelIndex &from, const QModelIndex &to) {
    QSqlRelationalTableModel::changePersistentIndex(from, to);
  }

  //  [expose] void QSqlRelationalTableModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)
  void fp_QSqlRelationalTableModel_changePersistentIndexList_5912 (const QList<QModelIndex> &from, const QList<QModelIndex> &to) {
    QSqlRelationalTableModel::changePersistentIndexList(from, to);
  }

  //  [expose] QModelIndex QSqlRelationalTableModel::createIndex(int row, int column, void *data)
  QModelIndex fp_QSqlRelationalTableModel_createIndex_c2374 (int row, int column, void *data) const {
    return QSqlRelationalTableModel::createIndex(row, column, data);
  }

  //  [expose] QModelIndex QSqlRelationalTableModel::createIndex(int row, int column, quintptr id)
  QModelIndex fp_QSqlRelationalTableModel_createIndex_c2657 (int row, int column, quintptr id) const {
    return QSqlRelationalTableModel::createIndex(row, column, id);
  }

  //  [expose] bool QSqlRelationalTableModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)
  bool fp_QSqlRelationalTableModel_decodeData_5302 (int row, int column, const QModelIndex &parent, QDataStream &stream) {
    return QSqlRelationalTableModel::decodeData(row, column, parent, stream);
  }

  //  [expose] void QSqlRelationalTableModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)
  void fp_QSqlRelationalTableModel_encodeData_c4599 (const QList<QModelIndex> &indexes, QDataStream &stream) const {
    QSqlRelationalTableModel::encodeData(indexes, stream);
  }

  //  [expose] void QSqlRelationalTableModel::endInsertColumns()
  void fp_QSqlRelationalTableModel_endInsertColumns_0 () {
    QSqlRelationalTableModel::endInsertColumns();
  }

  //  [expose] void QSqlRelationalTableModel::endInsertRows()
  void fp_QSqlRelationalTableModel_endInsertRows_0 () {
    QSqlRelationalTableModel::endInsertRows();
  }

  //  [expose] void QSqlRelationalTableModel::endMoveColumns()
  void fp_QSqlRelationalTableModel_endMoveColumns_0 () {
    QSqlRelationalTableModel::endMoveColumns();
  }

  //  [expose] void QSqlRelationalTableModel::endMoveRows()
  void fp_QSqlRelationalTableModel_endMoveRows_0 () {
    QSqlRelationalTableModel::endMoveRows();
  }

  //  [expose] void QSqlRelationalTableModel::endRemoveColumns()
  void fp_QSqlRelationalTableModel_endRemoveColumns_0 () {
    QSqlRelationalTableModel::endRemoveColumns();
  }

  //  [expose] void QSqlRelationalTableModel::endRemoveRows()
  void fp_QSqlRelationalTableModel_endRemoveRows_0 () {
    QSqlRelationalTableModel::endRemoveRows();
  }

  //  [expose] void QSqlRelationalTableModel::endResetModel()
  void fp_QSqlRelationalTableModel_endResetModel_0 () {
    QSqlRelationalTableModel::endResetModel();
  }

  //  [expose] bool QSqlRelationalTableModel::isSignalConnected(const QMetaMethod &signal)
  bool fp_QSqlRelationalTableModel_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QSqlRelationalTableModel::isSignalConnected(signal);
  }

  //  [expose] QList<QModelIndex> QSqlRelationalTableModel::persistentIndexList()
  QList<QModelIndex> fp_QSqlRelationalTableModel_persistentIndexList_c0 () const {
    return QSqlRelationalTableModel::persistentIndexList();
  }

  //  [expose] QSqlRecord QSqlRelationalTableModel::primaryValues(int row)
  QSqlRecord fp_QSqlRelationalTableModel_primaryValues_c767 (int row) const {
    return QSqlRelationalTableModel::primaryValues(row);
  }

  //  [expose] int QSqlRelationalTableModel::receivers(const char *signal)
  int fp_QSqlRelationalTableModel_receivers_c1731 (const char *signal) const {
    return QSqlRelationalTableModel::receivers(signal);
  }

  //  [expose] void QSqlRelationalTableModel::resetInternalData()
  void fp_QSqlRelationalTableModel_resetInternalData_0 () {
    QSqlRelationalTableModel::resetInternalData();
  }

  //  [expose] QObject *QSqlRelationalTableModel::sender()
  QObject * fp_QSqlRelationalTableModel_sender_c0 () const {
    return QSqlRelationalTableModel::sender();
  }

  //  [expose] int QSqlRelationalTableModel::senderSignalIndex()
  int fp_QSqlRelationalTableModel_senderSignalIndex_c0 () const {
    return QSqlRelationalTableModel::senderSignalIndex();
  }

  //  [expose] void QSqlRelationalTableModel::setLastError(const QSqlError &error)
  void fp_QSqlRelationalTableModel_setLastError_2220 (const QSqlError &error) {
    QSqlRelationalTableModel::setLastError(error);
  }

  //  [expose] void QSqlRelationalTableModel::setPrimaryKey(const QSqlIndex &key)
  void fp_QSqlRelationalTableModel_setPrimaryKey_2202 (const QSqlIndex &key) {
    QSqlRelationalTableModel::setPrimaryKey(key);
  }

  //  [expose] void QSqlRelationalTableModel::setQuery(const QSqlQuery &query)
  void fp_QSqlRelationalTableModel_setQuery_2232 (const QSqlQuery &query) {
    QSqlRelationalTableModel::setQuery(query);
  }

  //  [emitter impl] void QSqlRelationalTableModel::beforeDelete(int row)
  void emitter_QSqlRelationalTableModel_beforeDelete_767(int row)
  {
    emit QSqlRelationalTableModel::beforeDelete(row);
  }

  //  [emitter impl] void QSqlRelationalTableModel::beforeInsert(QSqlRecord &record)
  void emitter_QSqlRelationalTableModel_beforeInsert_1610(QSqlRecord &record)
  {
    emit QSqlRelationalTableModel::beforeInsert(record);
  }

  //  [emitter impl] void QSqlRelationalTableModel::beforeUpdate(int row, QSqlRecord &record)
  void emitter_QSqlRelationalTableModel_beforeUpdate_2269(int row, QSqlRecord &record)
  {
    emit QSqlRelationalTableModel::beforeUpdate(row, record);
  }

  //  [adaptor impl] QModelIndex QSqlRelationalTableModel::buddy(const QModelIndex &index)
  QModelIndex cbs_buddy_c2395_0(const QModelIndex &index) const
  {
    return QSqlRelationalTableModel::buddy(index);
  }

  virtual QModelIndex buddy(const QModelIndex &index) const
  {
    if (cb_buddy_c2395_0.can_issue()) {
      return cb_buddy_c2395_0.issue<QSqlRelationalTableModel_Adaptor, QModelIndex, const QModelIndex &>(&QSqlRelationalTableModel_Adaptor::cbs_buddy_c2395_0, index);
    } else {
      return QSqlRelationalTableModel::buddy(index);
    }
  }

  //  [adaptor impl] bool QSqlRelationalTableModel::canDropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  bool cbs_canDropMimeData_c7425_0(const QMimeData *data, const qt_gsi::Converter<Qt::DropAction>::target_type & action, int row, int column, const QModelIndex &parent) const
  {
    return QSqlRelationalTableModel::canDropMimeData(data, qt_gsi::QtToCppAdaptor<Qt::DropAction>(action).cref(), row, column, parent);
  }

  virtual bool canDropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent) const
  {
    if (cb_canDropMimeData_c7425_0.can_issue()) {
      return cb_canDropMimeData_c7425_0.issue<QSqlRelationalTableModel_Adaptor, bool, const QMimeData *, const qt_gsi::Converter<Qt::DropAction>::target_type &, int, int, const QModelIndex &>(&QSqlRelationalTableModel_Adaptor::cbs_canDropMimeData_c7425_0, data, qt_gsi::CppToQtAdaptor<Qt::DropAction>(action), row, column, parent);
    } else {
      return QSqlRelationalTableModel::canDropMimeData(data, action, row, column, parent);
    }
  }

  //  [adaptor impl] bool QSqlRelationalTableModel::canFetchMore(const QModelIndex &parent)
  bool cbs_canFetchMore_c2395_1(const QModelIndex &parent) const
  {
    return QSqlRelationalTableModel::canFetchMore(parent);
  }

  virtual bool canFetchMore(const QModelIndex &parent) const
  {
    if (cb_canFetchMore_c2395_1.can_issue()) {
      return cb_canFetchMore_c2395_1.issue<QSqlRelationalTableModel_Adaptor, bool, const QModelIndex &>(&QSqlRelationalTableModel_Adaptor::cbs_canFetchMore_c2395_1, parent);
    } else {
      return QSqlRelationalTableModel::canFetchMore(parent);
    }
  }

  //  [adaptor impl] void QSqlRelationalTableModel::clear()
  void cbs_clear_0_0()
  {
    QSqlRelationalTableModel::clear();
  }

  virtual void clear()
  {
    if (cb_clear_0_0.can_issue()) {
      cb_clear_0_0.issue<QSqlRelationalTableModel_Adaptor>(&QSqlRelationalTableModel_Adaptor::cbs_clear_0_0);
    } else {
      QSqlRelationalTableModel::clear();
    }
  }

  //  [adaptor impl] int QSqlRelationalTableModel::columnCount(const QModelIndex &parent)
  int cbs_columnCount_c2395_1(const QModelIndex &parent) const
  {
    return QSqlRelationalTableModel::columnCount(parent);
  }

  virtual int columnCount(const QModelIndex &parent) const
  {
    if (cb_columnCount_c2395_1.can_issue()) {
      return cb_columnCount_c2395_1.issue<QSqlRelationalTableModel_Adaptor, int, const QModelIndex &>(&QSqlRelationalTableModel_Adaptor::cbs_columnCount_c2395_1, parent);
    } else {
      return QSqlRelationalTableModel::columnCount(parent);
    }
  }

  //  [adaptor impl] QVariant QSqlRelationalTableModel::data(const QModelIndex &item, int role)
  QVariant cbs_data_c3054_1(const QModelIndex &item, int role) const
  {
    return QSqlRelationalTableModel::data(item, role);
  }

  virtual QVariant data(const QModelIndex &item, int role) const
  {
    if (cb_data_c3054_1.can_issue()) {
      return cb_data_c3054_1.issue<QSqlRelationalTableModel_Adaptor, QVariant, const QModelIndex &, int>(&QSqlRelationalTableModel_Adaptor::cbs_data_c3054_1, item, role);
    } else {
      return QSqlRelationalTableModel::data(item, role);
    }
  }

  //  [emitter impl] void QSqlRelationalTableModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QVector<int> &roles)
  void emitter_QSqlRelationalTableModel_dataChanged_7048(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QVector<int> &roles)
  {
    emit QSqlRelationalTableModel::dataChanged(topLeft, bottomRight, roles);
  }

  //  [emitter impl] void QSqlRelationalTableModel::destroyed(QObject *)
  void emitter_QSqlRelationalTableModel_destroyed_1302(QObject *arg1)
  {
    emit QSqlRelationalTableModel::destroyed(arg1);
  }

  //  [adaptor impl] bool QSqlRelationalTableModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  bool cbs_dropMimeData_7425_0(const QMimeData *data, const qt_gsi::Converter<Qt::DropAction>::target_type & action, int row, int column, const QModelIndex &parent)
  {
    return QSqlRelationalTableModel::dropMimeData(data, qt_gsi::QtToCppAdaptor<Qt::DropAction>(action).cref(), row, column, parent);
  }

  virtual bool dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  {
    if (cb_dropMimeData_7425_0.can_issue()) {
      return cb_dropMimeData_7425_0.issue<QSqlRelationalTableModel_Adaptor, bool, const QMimeData *, const qt_gsi::Converter<Qt::DropAction>::target_type &, int, int, const QModelIndex &>(&QSqlRelationalTableModel_Adaptor::cbs_dropMimeData_7425_0, data, qt_gsi::CppToQtAdaptor<Qt::DropAction>(action), row, column, parent);
    } else {
      return QSqlRelationalTableModel::dropMimeData(data, action, row, column, parent);
    }
  }

  //  [adaptor impl] bool QSqlRelationalTableModel::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QSqlRelationalTableModel::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QSqlRelationalTableModel_Adaptor, bool, QEvent *>(&QSqlRelationalTableModel_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QSqlRelationalTableModel::event(arg1);
    }
  }

  //  [adaptor impl] bool QSqlRelationalTableModel::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QSqlRelationalTableModel::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QSqlRelationalTableModel_Adaptor, bool, QObject *, QEvent *>(&QSqlRelationalTableModel_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QSqlRelationalTableModel::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QSqlRelationalTableModel::fetchMore(const QModelIndex &parent)
  void cbs_fetchMore_2395_1(const QModelIndex &parent)
  {
    QSqlRelationalTableModel::fetchMore(parent);
  }

  virtual void fetchMore(const QModelIndex &parent)
  {
    if (cb_fetchMore_2395_1.can_issue()) {
      cb_fetchMore_2395_1.issue<QSqlRelationalTableModel_Adaptor, const QModelIndex &>(&QSqlRelationalTableModel_Adaptor::cbs_fetchMore_2395_1, parent);
    } else {
      QSqlRelationalTableModel::fetchMore(parent);
    }
  }

  //  [adaptor impl] QFlags<Qt::ItemFlag> QSqlRelationalTableModel::flags(const QModelIndex &index)
  QFlags<Qt::ItemFlag> cbs_flags_c2395_0(const QModelIndex &index) const
  {
    return QSqlRelationalTableModel::flags(index);
  }

  virtual QFlags<Qt::ItemFlag> flags(const QModelIndex &index) const
  {
    if (cb_flags_c2395_0.can_issue()) {
      return cb_flags_c2395_0.issue<QSqlRelationalTableModel_Adaptor, QFlags<Qt::ItemFlag>, const QModelIndex &>(&QSqlRelationalTableModel_Adaptor::cbs_flags_c2395_0, index);
    } else {
      return QSqlRelationalTableModel::flags(index);
    }
  }

  //  [adaptor impl] QVariant QSqlRelationalTableModel::headerData(int section, Qt::Orientation orientation, int role)
  QVariant cbs_headerData_c3231_1(int section, const qt_gsi::Converter<Qt::Orientation>::target_type & orientation, int role) const
  {
    return QSqlRelationalTableModel::headerData(section, qt_gsi::QtToCppAdaptor<Qt::Orientation>(orientation).cref(), role);
  }

  virtual QVariant headerData(int section, Qt::Orientation orientation, int role) const
  {
    if (cb_headerData_c3231_1.can_issue()) {
      return cb_headerData_c3231_1.issue<QSqlRelationalTableModel_Adaptor, QVariant, int, const qt_gsi::Converter<Qt::Orientation>::target_type &, int>(&QSqlRelationalTableModel_Adaptor::cbs_headerData_c3231_1, section, qt_gsi::CppToQtAdaptor<Qt::Orientation>(orientation), role);
    } else {
      return QSqlRelationalTableModel::headerData(section, orientation, role);
    }
  }

  //  [emitter impl] void QSqlRelationalTableModel::headerDataChanged(Qt::Orientation orientation, int first, int last)
  void emitter_QSqlRelationalTableModel_headerDataChanged_3231(Qt::Orientation orientation, int first, int last)
  {
    emit QSqlRelationalTableModel::headerDataChanged(orientation, first, last);
  }

  //  [adaptor impl] QModelIndex QSqlRelationalTableModel::index(int row, int column, const QModelIndex &parent)
  QModelIndex cbs_index_c3713_1(int row, int column, const QModelIndex &parent) const
  {
    return QSqlRelationalTableModel::index(row, column, parent);
  }

  virtual QModelIndex index(int row, int column, const QModelIndex &parent) const
  {
    if (cb_index_c3713_1.can_issue()) {
      return cb_index_c3713_1.issue<QSqlRelationalTableModel_Adaptor, QModelIndex, int, int, const QModelIndex &>(&QSqlRelationalTableModel_Adaptor::cbs_index_c3713_1, row, column, parent);
    } else {
      return QSqlRelationalTableModel::index(row, column, parent);
    }
  }

  //  [adaptor impl] bool QSqlRelationalTableModel::insertColumns(int column, int count, const QModelIndex &parent)
  bool cbs_insertColumns_3713_1(int column, int count, const QModelIndex &parent)
  {
    return QSqlRelationalTableModel::insertColumns(column, count, parent);
  }

  virtual bool insertColumns(int column, int count, const QModelIndex &parent)
  {
    if (cb_insertColumns_3713_1.can_issue()) {
      return cb_insertColumns_3713_1.issue<QSqlRelationalTableModel_Adaptor, bool, int, int, const QModelIndex &>(&QSqlRelationalTableModel_Adaptor::cbs_insertColumns_3713_1, column, count, parent);
    } else {
      return QSqlRelationalTableModel::insertColumns(column, count, parent);
    }
  }

  //  [adaptor impl] bool QSqlRelationalTableModel::insertRows(int row, int count, const QModelIndex &parent)
  bool cbs_insertRows_3713_1(int row, int count, const QModelIndex &parent)
  {
    return QSqlRelationalTableModel::insertRows(row, count, parent);
  }

  virtual bool insertRows(int row, int count, const QModelIndex &parent)
  {
    if (cb_insertRows_3713_1.can_issue()) {
      return cb_insertRows_3713_1.issue<QSqlRelationalTableModel_Adaptor, bool, int, int, const QModelIndex &>(&QSqlRelationalTableModel_Adaptor::cbs_insertRows_3713_1, row, count, parent);
    } else {
      return QSqlRelationalTableModel::insertRows(row, count, parent);
    }
  }

  //  [adaptor impl] QMap<int, QVariant> QSqlRelationalTableModel::itemData(const QModelIndex &index)
  QMap<int, QVariant> cbs_itemData_c2395_0(const QModelIndex &index) const
  {
    return QSqlRelationalTableModel::itemData(index);
  }

  virtual QMap<int, QVariant> itemData(const QModelIndex &index) const
  {
    if (cb_itemData_c2395_0.can_issue()) {
      return cb_itemData_c2395_0.issue<QSqlRelationalTableModel_Adaptor, QMap<int, QVariant>, const QModelIndex &>(&QSqlRelationalTableModel_Adaptor::cbs_itemData_c2395_0, index);
    } else {
      return QSqlRelationalTableModel::itemData(index);
    }
  }

  //  [emitter impl] void QSqlRelationalTableModel::layoutAboutToBeChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)
  void emitter_QSqlRelationalTableModel_layoutAboutToBeChanged_7947(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)
  {
    emit QSqlRelationalTableModel::layoutAboutToBeChanged(parents, hint);
  }

  //  [emitter impl] void QSqlRelationalTableModel::layoutChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)
  void emitter_QSqlRelationalTableModel_layoutChanged_7947(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)
  {
    emit QSqlRelationalTableModel::layoutChanged(parents, hint);
  }

  //  [adaptor impl] QList<QModelIndex> QSqlRelationalTableModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)
  QList<QModelIndex> cbs_match_c7932_2(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags) const
  {
    return QSqlRelationalTableModel::match(start, role, value, hits, flags);
  }

  virtual QList<QModelIndex> match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags) const
  {
    if (cb_match_c7932_2.can_issue()) {
      return cb_match_c7932_2.issue<QSqlRelationalTableModel_Adaptor, QList<QModelIndex>, const QModelIndex &, int, const QVariant &, int, QFlags<Qt::MatchFlag> >(&QSqlRelationalTableModel_Adaptor::cbs_match_c7932_2, start, role, value, hits, flags);
    } else {
      return QSqlRelationalTableModel::match(start, role, value, hits, flags);
    }
  }

  //  [adaptor impl] QMimeData *QSqlRelationalTableModel::mimeData(const QList<QModelIndex> &indexes)
  QMimeData * cbs_mimeData_c3010_0(const QList<QModelIndex> &indexes) const
  {
    return QSqlRelationalTableModel::mimeData(indexes);
  }

  virtual QMimeData * mimeData(const QList<QModelIndex> &indexes) const
  {
    if (cb_mimeData_c3010_0.can_issue()) {
      return cb_mimeData_c3010_0.issue<QSqlRelationalTableModel_Adaptor, QMimeData *, const QList<QModelIndex> &>(&QSqlRelationalTableModel_Adaptor::cbs_mimeData_c3010_0, indexes);
    } else {
      return QSqlRelationalTableModel::mimeData(indexes);
    }
  }

  //  [adaptor impl] QStringList QSqlRelationalTableModel::mimeTypes()
  QStringList cbs_mimeTypes_c0_0() const
  {
    return QSqlRelationalTableModel::mimeTypes();
  }

  virtual QStringList mimeTypes() const
  {
    if (cb_mimeTypes_c0_0.can_issue()) {
      return cb_mimeTypes_c0_0.issue<QSqlRelationalTableModel_Adaptor, QStringList>(&QSqlRelationalTableModel_Adaptor::cbs_mimeTypes_c0_0);
    } else {
      return QSqlRelationalTableModel::mimeTypes();
    }
  }

  //  [adaptor impl] bool QSqlRelationalTableModel::moveColumns(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)
  bool cbs_moveColumns_6659_0(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)
  {
    return QSqlRelationalTableModel::moveColumns(sourceParent, sourceColumn, count, destinationParent, destinationChild);
  }

  virtual bool moveColumns(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)
  {
    if (cb_moveColumns_6659_0.can_issue()) {
      return cb_moveColumns_6659_0.issue<QSqlRelationalTableModel_Adaptor, bool, const QModelIndex &, int, int, const QModelIndex &, int>(&QSqlRelationalTableModel_Adaptor::cbs_moveColumns_6659_0, sourceParent, sourceColumn, count, destinationParent, destinationChild);
    } else {
      return QSqlRelationalTableModel::moveColumns(sourceParent, sourceColumn, count, destinationParent, destinationChild);
    }
  }

  //  [adaptor impl] bool QSqlRelationalTableModel::moveRows(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)
  bool cbs_moveRows_6659_0(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)
  {
    return QSqlRelationalTableModel::moveRows(sourceParent, sourceRow, count, destinationParent, destinationChild);
  }

  virtual bool moveRows(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)
  {
    if (cb_moveRows_6659_0.can_issue()) {
      return cb_moveRows_6659_0.issue<QSqlRelationalTableModel_Adaptor, bool, const QModelIndex &, int, int, const QModelIndex &, int>(&QSqlRelationalTableModel_Adaptor::cbs_moveRows_6659_0, sourceParent, sourceRow, count, destinationParent, destinationChild);
    } else {
      return QSqlRelationalTableModel::moveRows(sourceParent, sourceRow, count, destinationParent, destinationChild);
    }
  }

  //  [emitter impl] void QSqlRelationalTableModel::primeInsert(int row, QSqlRecord &record)
  void emitter_QSqlRelationalTableModel_primeInsert_2269(int row, QSqlRecord &record)
  {
    emit QSqlRelationalTableModel::primeInsert(row, record);
  }

  //  [adaptor impl] QSqlTableModel *QSqlRelationalTableModel::relationModel(int column)
  QSqlTableModel * cbs_relationModel_c767_0(int column) const
  {
    return QSqlRelationalTableModel::relationModel(column);
  }

  virtual QSqlTableModel * relationModel(int column) const
  {
    if (cb_relationModel_c767_0.can_issue()) {
      return cb_relationModel_c767_0.issue<QSqlRelationalTableModel_Adaptor, QSqlTableModel *, int>(&QSqlRelationalTableModel_Adaptor::cbs_relationModel_c767_0, column);
    } else {
      return QSqlRelationalTableModel::relationModel(column);
    }
  }

  //  [adaptor impl] bool QSqlRelationalTableModel::removeColumns(int column, int count, const QModelIndex &parent)
  bool cbs_removeColumns_3713_1(int column, int count, const QModelIndex &parent)
  {
    return QSqlRelationalTableModel::removeColumns(column, count, parent);
  }

  virtual bool removeColumns(int column, int count, const QModelIndex &parent)
  {
    if (cb_removeColumns_3713_1.can_issue()) {
      return cb_removeColumns_3713_1.issue<QSqlRelationalTableModel_Adaptor, bool, int, int, const QModelIndex &>(&QSqlRelationalTableModel_Adaptor::cbs_removeColumns_3713_1, column, count, parent);
    } else {
      return QSqlRelationalTableModel::removeColumns(column, count, parent);
    }
  }

  //  [adaptor impl] bool QSqlRelationalTableModel::removeRows(int row, int count, const QModelIndex &parent)
  bool cbs_removeRows_3713_1(int row, int count, const QModelIndex &parent)
  {
    return QSqlRelationalTableModel::removeRows(row, count, parent);
  }

  virtual bool removeRows(int row, int count, const QModelIndex &parent)
  {
    if (cb_removeRows_3713_1.can_issue()) {
      return cb_removeRows_3713_1.issue<QSqlRelationalTableModel_Adaptor, bool, int, int, const QModelIndex &>(&QSqlRelationalTableModel_Adaptor::cbs_removeRows_3713_1, row, count, parent);
    } else {
      return QSqlRelationalTableModel::removeRows(row, count, parent);
    }
  }

  //  [adaptor impl] void QSqlRelationalTableModel::revert()
  void cbs_revert_0_0()
  {
    QSqlRelationalTableModel::revert();
  }

  virtual void revert()
  {
    if (cb_revert_0_0.can_issue()) {
      cb_revert_0_0.issue<QSqlRelationalTableModel_Adaptor>(&QSqlRelationalTableModel_Adaptor::cbs_revert_0_0);
    } else {
      QSqlRelationalTableModel::revert();
    }
  }

  //  [adaptor impl] void QSqlRelationalTableModel::revertRow(int row)
  void cbs_revertRow_767_0(int row)
  {
    QSqlRelationalTableModel::revertRow(row);
  }

  virtual void revertRow(int row)
  {
    if (cb_revertRow_767_0.can_issue()) {
      cb_revertRow_767_0.issue<QSqlRelationalTableModel_Adaptor, int>(&QSqlRelationalTableModel_Adaptor::cbs_revertRow_767_0, row);
    } else {
      QSqlRelationalTableModel::revertRow(row);
    }
  }

  //  [adaptor impl] QHash<int, QByteArray> QSqlRelationalTableModel::roleNames()
  QHash<int, QByteArray> cbs_roleNames_c0_0() const
  {
    return QSqlRelationalTableModel::roleNames();
  }

  virtual QHash<int, QByteArray> roleNames() const
  {
    if (cb_roleNames_c0_0.can_issue()) {
      return cb_roleNames_c0_0.issue<QSqlRelationalTableModel_Adaptor, QHash<int, QByteArray> >(&QSqlRelationalTableModel_Adaptor::cbs_roleNames_c0_0);
    } else {
      return QSqlRelationalTableModel::roleNames();
    }
  }

  //  [adaptor impl] int QSqlRelationalTableModel::rowCount(const QModelIndex &parent)
  int cbs_rowCount_c2395_1(const QModelIndex &parent) const
  {
    return QSqlRelationalTableModel::rowCount(parent);
  }

  virtual int rowCount(const QModelIndex &parent) const
  {
    if (cb_rowCount_c2395_1.can_issue()) {
      return cb_rowCount_c2395_1.issue<QSqlRelationalTableModel_Adaptor, int, const QModelIndex &>(&QSqlRelationalTableModel_Adaptor::cbs_rowCount_c2395_1, parent);
    } else {
      return QSqlRelationalTableModel::rowCount(parent);
    }
  }

  //  [adaptor impl] bool QSqlRelationalTableModel::select()
  bool cbs_select_0_0()
  {
    return QSqlRelationalTableModel::select();
  }

  virtual bool select()
  {
    if (cb_select_0_0.can_issue()) {
      return cb_select_0_0.issue<QSqlRelationalTableModel_Adaptor, bool>(&QSqlRelationalTableModel_Adaptor::cbs_select_0_0);
    } else {
      return QSqlRelationalTableModel::select();
    }
  }

  //  [adaptor impl] bool QSqlRelationalTableModel::selectRow(int row)
  bool cbs_selectRow_767_0(int row)
  {
    return QSqlRelationalTableModel::selectRow(row);
  }

  virtual bool selectRow(int row)
  {
    if (cb_selectRow_767_0.can_issue()) {
      return cb_selectRow_767_0.issue<QSqlRelationalTableModel_Adaptor, bool, int>(&QSqlRelationalTableModel_Adaptor::cbs_selectRow_767_0, row);
    } else {
      return QSqlRelationalTableModel::selectRow(row);
    }
  }

  //  [adaptor impl] bool QSqlRelationalTableModel::setData(const QModelIndex &item, const QVariant &value, int role)
  bool cbs_setData_5065_1(const QModelIndex &item, const QVariant &value, int role)
  {
    return QSqlRelationalTableModel::setData(item, value, role);
  }

  virtual bool setData(const QModelIndex &item, const QVariant &value, int role)
  {
    if (cb_setData_5065_1.can_issue()) {
      return cb_setData_5065_1.issue<QSqlRelationalTableModel_Adaptor, bool, const QModelIndex &, const QVariant &, int>(&QSqlRelationalTableModel_Adaptor::cbs_setData_5065_1, item, value, role);
    } else {
      return QSqlRelationalTableModel::setData(item, value, role);
    }
  }

  //  [adaptor impl] void QSqlRelationalTableModel::setEditStrategy(QSqlTableModel::EditStrategy strategy)
  void cbs_setEditStrategy_3163_0(const qt_gsi::Converter<QSqlTableModel::EditStrategy>::target_type & strategy)
  {
    QSqlRelationalTableModel::setEditStrategy(qt_gsi::QtToCppAdaptor<QSqlTableModel::EditStrategy>(strategy).cref());
  }

  virtual void setEditStrategy(QSqlTableModel::EditStrategy strategy)
  {
    if (cb_setEditStrategy_3163_0.can_issue()) {
      cb_setEditStrategy_3163_0.issue<QSqlRelationalTableModel_Adaptor, const qt_gsi::Converter<QSqlTableModel::EditStrategy>::target_type &>(&QSqlRelationalTableModel_Adaptor::cbs_setEditStrategy_3163_0, qt_gsi::CppToQtAdaptor<QSqlTableModel::EditStrategy>(strategy));
    } else {
      QSqlRelationalTableModel::setEditStrategy(strategy);
    }
  }

  //  [adaptor impl] void QSqlRelationalTableModel::setFilter(const QString &filter)
  void cbs_setFilter_2025_0(const QString &filter)
  {
    QSqlRelationalTableModel::setFilter(filter);
  }

  virtual void setFilter(const QString &filter)
  {
    if (cb_setFilter_2025_0.can_issue()) {
      cb_setFilter_2025_0.issue<QSqlRelationalTableModel_Adaptor, const QString &>(&QSqlRelationalTableModel_Adaptor::cbs_setFilter_2025_0, filter);
    } else {
      QSqlRelationalTableModel::setFilter(filter);
    }
  }

  //  [adaptor impl] bool QSqlRelationalTableModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)
  bool cbs_setHeaderData_5242_1(int section, const qt_gsi::Converter<Qt::Orientation>::target_type & orientation, const QVariant &value, int role)
  {
    return QSqlRelationalTableModel::setHeaderData(section, qt_gsi::QtToCppAdaptor<Qt::Orientation>(orientation).cref(), value, role);
  }

  virtual bool setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)
  {
    if (cb_setHeaderData_5242_1.can_issue()) {
      return cb_setHeaderData_5242_1.issue<QSqlRelationalTableModel_Adaptor, bool, int, const qt_gsi::Converter<Qt::Orientation>::target_type &, const QVariant &, int>(&QSqlRelationalTableModel_Adaptor::cbs_setHeaderData_5242_1, section, qt_gsi::CppToQtAdaptor<Qt::Orientation>(orientation), value, role);
    } else {
      return QSqlRelationalTableModel::setHeaderData(section, orientation, value, role);
    }
  }

  //  [adaptor impl] bool QSqlRelationalTableModel::setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)
  bool cbs_setItemData_5414_0(const QModelIndex &index, const QMap<int, QVariant> &roles)
  {
    return QSqlRelationalTableModel::setItemData(index, roles);
  }

  virtual bool setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)
  {
    if (cb_setItemData_5414_0.can_issue()) {
      return cb_setItemData_5414_0.issue<QSqlRelationalTableModel_Adaptor, bool, const QModelIndex &, const QMap<int, QVariant> &>(&QSqlRelationalTableModel_Adaptor::cbs_setItemData_5414_0, index, roles);
    } else {
      return QSqlRelationalTableModel::setItemData(index, roles);
    }
  }

  //  [adaptor impl] void QSqlRelationalTableModel::setRelation(int column, const QSqlRelation &relation)
  void cbs_setRelation_3187_0(int column, const QSqlRelation &relation)
  {
    QSqlRelationalTableModel::setRelation(column, relation);
  }

  virtual void setRelation(int column, const QSqlRelation &relation)
  {
    if (cb_setRelation_3187_0.can_issue()) {
      cb_setRelation_3187_0.issue<QSqlRelationalTableModel_Adaptor, int, const QSqlRelation &>(&QSqlRelationalTableModel_Adaptor::cbs_setRelation_3187_0, column, relation);
    } else {
      QSqlRelationalTableModel::setRelation(column, relation);
    }
  }

  //  [adaptor impl] void QSqlRelationalTableModel::setSort(int column, Qt::SortOrder order)
  void cbs_setSort_2340_0(int column, const qt_gsi::Converter<Qt::SortOrder>::target_type & order)
  {
    QSqlRelationalTableModel::setSort(column, qt_gsi::QtToCppAdaptor<Qt::SortOrder>(order).cref());
  }

  virtual void setSort(int column, Qt::SortOrder order)
  {
    if (cb_setSort_2340_0.can_issue()) {
      cb_setSort_2340_0.issue<QSqlRelationalTableModel_Adaptor, int, const qt_gsi::Converter<Qt::SortOrder>::target_type &>(&QSqlRelationalTableModel_Adaptor::cbs_setSort_2340_0, column, qt_gsi::CppToQtAdaptor<Qt::SortOrder>(order));
    } else {
      QSqlRelationalTableModel::setSort(column, order);
    }
  }

  //  [adaptor impl] void QSqlRelationalTableModel::setTable(const QString &tableName)
  void cbs_setTable_2025_0(const QString &tableName)
  {
    QSqlRelationalTableModel::setTable(tableName);
  }

  virtual void setTable(const QString &tableName)
  {
    if (cb_setTable_2025_0.can_issue()) {
      cb_setTable_2025_0.issue<QSqlRelationalTableModel_Adaptor, const QString &>(&QSqlRelationalTableModel_Adaptor::cbs_setTable_2025_0, tableName);
    } else {
      QSqlRelationalTableModel::setTable(tableName);
    }
  }

  //  [adaptor impl] QModelIndex QSqlRelationalTableModel::sibling(int row, int column, const QModelIndex &idx)
  QModelIndex cbs_sibling_c3713_0(int row, int column, const QModelIndex &idx) const
  {
    return QSqlRelationalTableModel::sibling(row, column, idx);
  }

  virtual QModelIndex sibling(int row, int column, const QModelIndex &idx) const
  {
    if (cb_sibling_c3713_0.can_issue()) {
      return cb_sibling_c3713_0.issue<QSqlRelationalTableModel_Adaptor, QModelIndex, int, int, const QModelIndex &>(&QSqlRelationalTableModel_Adaptor::cbs_sibling_c3713_0, row, column, idx);
    } else {
      return QSqlRelationalTableModel::sibling(row, column, idx);
    }
  }

  //  [adaptor impl] void QSqlRelationalTableModel::sort(int column, Qt::SortOrder order)
  void cbs_sort_2340_0(int column, const qt_gsi::Converter<Qt::SortOrder>::target_type & order)
  {
    QSqlRelationalTableModel::sort(column, qt_gsi::QtToCppAdaptor<Qt::SortOrder>(order).cref());
  }

  virtual void sort(int column, Qt::SortOrder order)
  {
    if (cb_sort_2340_0.can_issue()) {
      cb_sort_2340_0.issue<QSqlRelationalTableModel_Adaptor, int, const qt_gsi::Converter<Qt::SortOrder>::target_type &>(&QSqlRelationalTableModel_Adaptor::cbs_sort_2340_0, column, qt_gsi::CppToQtAdaptor<Qt::SortOrder>(order));
    } else {
      QSqlRelationalTableModel::sort(column, order);
    }
  }

  //  [adaptor impl] QSize QSqlRelationalTableModel::span(const QModelIndex &index)
  QSize cbs_span_c2395_0(const QModelIndex &index) const
  {
    return QSqlRelationalTableModel::span(index);
  }

  virtual QSize span(const QModelIndex &index) const
  {
    if (cb_span_c2395_0.can_issue()) {
      return cb_span_c2395_0.issue<QSqlRelationalTableModel_Adaptor, QSize, const QModelIndex &>(&QSqlRelationalTableModel_Adaptor::cbs_span_c2395_0, index);
    } else {
      return QSqlRelationalTableModel::span(index);
    }
  }

  //  [adaptor impl] bool QSqlRelationalTableModel::submit()
  bool cbs_submit_0_0()
  {
    return QSqlRelationalTableModel::submit();
  }

  virtual bool submit()
  {
    if (cb_submit_0_0.can_issue()) {
      return cb_submit_0_0.issue<QSqlRelationalTableModel_Adaptor, bool>(&QSqlRelationalTableModel_Adaptor::cbs_submit_0_0);
    } else {
      return QSqlRelationalTableModel::submit();
    }
  }

  //  [adaptor impl] QFlags<Qt::DropAction> QSqlRelationalTableModel::supportedDragActions()
  QFlags<Qt::DropAction> cbs_supportedDragActions_c0_0() const
  {
    return QSqlRelationalTableModel::supportedDragActions();
  }

  virtual QFlags<Qt::DropAction> supportedDragActions() const
  {
    if (cb_supportedDragActions_c0_0.can_issue()) {
      return cb_supportedDragActions_c0_0.issue<QSqlRelationalTableModel_Adaptor, QFlags<Qt::DropAction> >(&QSqlRelationalTableModel_Adaptor::cbs_supportedDragActions_c0_0);
    } else {
      return QSqlRelationalTableModel::supportedDragActions();
    }
  }

  //  [adaptor impl] QFlags<Qt::DropAction> QSqlRelationalTableModel::supportedDropActions()
  QFlags<Qt::DropAction> cbs_supportedDropActions_c0_0() const
  {
    return QSqlRelationalTableModel::supportedDropActions();
  }

  virtual QFlags<Qt::DropAction> supportedDropActions() const
  {
    if (cb_supportedDropActions_c0_0.can_issue()) {
      return cb_supportedDropActions_c0_0.issue<QSqlRelationalTableModel_Adaptor, QFlags<Qt::DropAction> >(&QSqlRelationalTableModel_Adaptor::cbs_supportedDropActions_c0_0);
    } else {
      return QSqlRelationalTableModel::supportedDropActions();
    }
  }

  //  [adaptor impl] void QSqlRelationalTableModel::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QSqlRelationalTableModel::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QSqlRelationalTableModel_Adaptor, QChildEvent *>(&QSqlRelationalTableModel_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QSqlRelationalTableModel::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QSqlRelationalTableModel::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QSqlRelationalTableModel::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QSqlRelationalTableModel_Adaptor, QEvent *>(&QSqlRelationalTableModel_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QSqlRelationalTableModel::customEvent(arg1);
    }
  }

  //  [adaptor impl] bool QSqlRelationalTableModel::deleteRowFromTable(int row)
  bool cbs_deleteRowFromTable_767_0(int row)
  {
    return QSqlRelationalTableModel::deleteRowFromTable(row);
  }

  virtual bool deleteRowFromTable(int row)
  {
    if (cb_deleteRowFromTable_767_0.can_issue()) {
      return cb_deleteRowFromTable_767_0.issue<QSqlRelationalTableModel_Adaptor, bool, int>(&QSqlRelationalTableModel_Adaptor::cbs_deleteRowFromTable_767_0, row);
    } else {
      return QSqlRelationalTableModel::deleteRowFromTable(row);
    }
  }

  //  [adaptor impl] void QSqlRelationalTableModel::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QSqlRelationalTableModel::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QSqlRelationalTableModel_Adaptor, const QMetaMethod &>(&QSqlRelationalTableModel_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QSqlRelationalTableModel::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] QModelIndex QSqlRelationalTableModel::indexInQuery(const QModelIndex &item)
  QModelIndex cbs_indexInQuery_c2395_0(const QModelIndex &item) const
  {
    return QSqlRelationalTableModel::indexInQuery(item);
  }

  virtual QModelIndex indexInQuery(const QModelIndex &item) const
  {
    if (cb_indexInQuery_c2395_0.can_issue()) {
      return cb_indexInQuery_c2395_0.issue<QSqlRelationalTableModel_Adaptor, QModelIndex, const QModelIndex &>(&QSqlRelationalTableModel_Adaptor::cbs_indexInQuery_c2395_0, item);
    } else {
      return QSqlRelationalTableModel::indexInQuery(item);
    }
  }

  //  [adaptor impl] bool QSqlRelationalTableModel::insertRowIntoTable(const QSqlRecord &values)
  bool cbs_insertRowIntoTable_2305_0(const QSqlRecord &values)
  {
    return QSqlRelationalTableModel::insertRowIntoTable(values);
  }

  virtual bool insertRowIntoTable(const QSqlRecord &values)
  {
    if (cb_insertRowIntoTable_2305_0.can_issue()) {
      return cb_insertRowIntoTable_2305_0.issue<QSqlRelationalTableModel_Adaptor, bool, const QSqlRecord &>(&QSqlRelationalTableModel_Adaptor::cbs_insertRowIntoTable_2305_0, values);
    } else {
      return QSqlRelationalTableModel::insertRowIntoTable(values);
    }
  }

  //  [adaptor impl] QString QSqlRelationalTableModel::orderByClause()
  QString cbs_orderByClause_c0_0() const
  {
    return QSqlRelationalTableModel::orderByClause();
  }

  virtual QString orderByClause() const
  {
    if (cb_orderByClause_c0_0.can_issue()) {
      return cb_orderByClause_c0_0.issue<QSqlRelationalTableModel_Adaptor, QString>(&QSqlRelationalTableModel_Adaptor::cbs_orderByClause_c0_0);
    } else {
      return QSqlRelationalTableModel::orderByClause();
    }
  }

  //  [adaptor impl] void QSqlRelationalTableModel::queryChange()
  void cbs_queryChange_0_0()
  {
    QSqlRelationalTableModel::queryChange();
  }

  virtual void queryChange()
  {
    if (cb_queryChange_0_0.can_issue()) {
      cb_queryChange_0_0.issue<QSqlRelationalTableModel_Adaptor>(&QSqlRelationalTableModel_Adaptor::cbs_queryChange_0_0);
    } else {
      QSqlRelationalTableModel::queryChange();
    }
  }

  //  [adaptor impl] QString QSqlRelationalTableModel::selectStatement()
  QString cbs_selectStatement_c0_0() const
  {
    return QSqlRelationalTableModel::selectStatement();
  }

  virtual QString selectStatement() const
  {
    if (cb_selectStatement_c0_0.can_issue()) {
      return cb_selectStatement_c0_0.issue<QSqlRelationalTableModel_Adaptor, QString>(&QSqlRelationalTableModel_Adaptor::cbs_selectStatement_c0_0);
    } else {
      return QSqlRelationalTableModel::selectStatement();
    }
  }

  //  [adaptor impl] void QSqlRelationalTableModel::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QSqlRelationalTableModel::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QSqlRelationalTableModel_Adaptor, QTimerEvent *>(&QSqlRelationalTableModel_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QSqlRelationalTableModel::timerEvent(arg1);
    }
  }

  //  [adaptor impl] bool QSqlRelationalTableModel::updateRowInTable(int row, const QSqlRecord &values)
  bool cbs_updateRowInTable_2964_0(int row, const QSqlRecord &values)
  {
    return QSqlRelationalTableModel::updateRowInTable(row, values);
  }

  virtual bool updateRowInTable(int row, const QSqlRecord &values)
  {
    if (cb_updateRowInTable_2964_0.can_issue()) {
      return cb_updateRowInTable_2964_0.issue<QSqlRelationalTableModel_Adaptor, bool, int, const QSqlRecord &>(&QSqlRelationalTableModel_Adaptor::cbs_updateRowInTable_2964_0, row, values);
    } else {
      return QSqlRelationalTableModel::updateRowInTable(row, values);
    }
  }

  gsi::Callback cb_buddy_c2395_0;
  gsi::Callback cb_canDropMimeData_c7425_0;
  gsi::Callback cb_canFetchMore_c2395_1;
  gsi::Callback cb_clear_0_0;
  gsi::Callback cb_columnCount_c2395_1;
  gsi::Callback cb_data_c3054_1;
  gsi::Callback cb_dropMimeData_7425_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_fetchMore_2395_1;
  gsi::Callback cb_flags_c2395_0;
  gsi::Callback cb_headerData_c3231_1;
  gsi::Callback cb_index_c3713_1;
  gsi::Callback cb_insertColumns_3713_1;
  gsi::Callback cb_insertRows_3713_1;
  gsi::Callback cb_itemData_c2395_0;
  gsi::Callback cb_match_c7932_2;
  gsi::Callback cb_mimeData_c3010_0;
  gsi::Callback cb_mimeTypes_c0_0;
  gsi::Callback cb_moveColumns_6659_0;
  gsi::Callback cb_moveRows_6659_0;
  gsi::Callback cb_relationModel_c767_0;
  gsi::Callback cb_removeColumns_3713_1;
  gsi::Callback cb_removeRows_3713_1;
  gsi::Callback cb_revert_0_0;
  gsi::Callback cb_revertRow_767_0;
  gsi::Callback cb_roleNames_c0_0;
  gsi::Callback cb_rowCount_c2395_1;
  gsi::Callback cb_select_0_0;
  gsi::Callback cb_selectRow_767_0;
  gsi::Callback cb_setData_5065_1;
  gsi::Callback cb_setEditStrategy_3163_0;
  gsi::Callback cb_setFilter_2025_0;
  gsi::Callback cb_setHeaderData_5242_1;
  gsi::Callback cb_setItemData_5414_0;
  gsi::Callback cb_setRelation_3187_0;
  gsi::Callback cb_setSort_2340_0;
  gsi::Callback cb_setTable_2025_0;
  gsi::Callback cb_sibling_c3713_0;
  gsi::Callback cb_sort_2340_0;
  gsi::Callback cb_span_c2395_0;
  gsi::Callback cb_submit_0_0;
  gsi::Callback cb_supportedDragActions_c0_0;
  gsi::Callback cb_supportedDropActions_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_deleteRowFromTable_767_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_indexInQuery_c2395_0;
  gsi::Callback cb_insertRowIntoTable_2305_0;
  gsi::Callback cb_orderByClause_c0_0;
  gsi::Callback cb_queryChange_0_0;
  gsi::Callback cb_selectStatement_c0_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_updateRowInTable_2964_0;
};

QSqlRelationalTableModel_Adaptor::~QSqlRelationalTableModel_Adaptor() { }

//  Constructor QSqlRelationalTableModel::QSqlRelationalTableModel(QObject *parent, QSqlDatabase db) (adaptor class)

static void _init_ctor_QSqlRelationalTableModel_Adaptor_2804 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("db", true, "QSqlDatabase()");
  decl->add_arg<QSqlDatabase > (argspec_1);
  decl->set_return_new<QSqlRelationalTableModel_Adaptor> ();
}

static void _call_ctor_QSqlRelationalTableModel_Adaptor_2804 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  QSqlDatabase arg2 = args ? gsi::arg_reader<QSqlDatabase >() (args, heap) : gsi::arg_maker<QSqlDatabase >() (QSqlDatabase(), heap);
  ret.write<QSqlRelationalTableModel_Adaptor *> (new QSqlRelationalTableModel_Adaptor (arg1, arg2));
}


// emitter void QSqlRelationalTableModel::beforeDelete(int row)

static void _init_emitter_beforeDelete_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_beforeDelete_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QSqlRelationalTableModel_Adaptor *)cls)->emitter_QSqlRelationalTableModel_beforeDelete_767 (arg1);
}


// emitter void QSqlRelationalTableModel::beforeInsert(QSqlRecord &record)

static void _init_emitter_beforeInsert_1610 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("record");
  decl->add_arg<QSqlRecord & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_beforeInsert_1610 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QSqlRecord &arg1 = gsi::arg_reader<QSqlRecord & >() (args, heap);
  ((QSqlRelationalTableModel_Adaptor *)cls)->emitter_QSqlRelationalTableModel_beforeInsert_1610 (arg1);
}


// emitter void QSqlRelationalTableModel::beforeUpdate(int row, QSqlRecord &record)

static void _init_emitter_beforeUpdate_2269 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("record");
  decl->add_arg<QSqlRecord & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_beforeUpdate_2269 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  QSqlRecord &arg2 = gsi::arg_reader<QSqlRecord & >() (args, heap);
  ((QSqlRelationalTableModel_Adaptor *)cls)->emitter_QSqlRelationalTableModel_beforeUpdate_2269 (arg1, arg2);
}


// exposed void QSqlRelationalTableModel::beginInsertColumns(const QModelIndex &parent, int first, int last)

static void _init_fp_beginInsertColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginInsertColumns_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->fp_QSqlRelationalTableModel_beginInsertColumns_3713 (arg1, arg2, arg3);
}


// exposed void QSqlRelationalTableModel::beginInsertRows(const QModelIndex &parent, int first, int last)

static void _init_fp_beginInsertRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginInsertRows_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->fp_QSqlRelationalTableModel_beginInsertRows_3713 (arg1, arg2, arg3);
}


// exposed bool QSqlRelationalTableModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)

static void _init_fp_beginMoveColumns_6659 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceFirst");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceLast");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationColumn");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_fp_beginMoveColumns_6659 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QSqlRelationalTableModel_Adaptor *)cls)->fp_QSqlRelationalTableModel_beginMoveColumns_6659 (arg1, arg2, arg3, arg4, arg5));
}


// exposed bool QSqlRelationalTableModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)

static void _init_fp_beginMoveRows_6659 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceFirst");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceLast");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationRow");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_fp_beginMoveRows_6659 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QSqlRelationalTableModel_Adaptor *)cls)->fp_QSqlRelationalTableModel_beginMoveRows_6659 (arg1, arg2, arg3, arg4, arg5));
}


// exposed void QSqlRelationalTableModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)

static void _init_fp_beginRemoveColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginRemoveColumns_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->fp_QSqlRelationalTableModel_beginRemoveColumns_3713 (arg1, arg2, arg3);
}


// exposed void QSqlRelationalTableModel::beginRemoveRows(const QModelIndex &parent, int first, int last)

static void _init_fp_beginRemoveRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginRemoveRows_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->fp_QSqlRelationalTableModel_beginRemoveRows_3713 (arg1, arg2, arg3);
}


// exposed void QSqlRelationalTableModel::beginResetModel()

static void _init_fp_beginResetModel_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_beginResetModel_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->fp_QSqlRelationalTableModel_beginResetModel_0 ();
}


// QModelIndex QSqlRelationalTableModel::buddy(const QModelIndex &index)

static void _init_cbs_buddy_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_buddy_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_buddy_c2395_0 (arg1));
}

static void _set_callback_cbs_buddy_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_buddy_c2395_0 = cb;
}


// bool QSqlRelationalTableModel::canDropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)

static void _init_cbs_canDropMimeData_c7425_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("row");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("column");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_canDropMimeData_c7425_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMimeData *arg1 = args.read<const QMimeData * > (heap);
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::DropAction>::target_type & > (heap);
  int arg3 = args.read<int > (heap);
  int arg4 = args.read<int > (heap);
  const QModelIndex &arg5 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_canDropMimeData_c7425_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_canDropMimeData_c7425_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_canDropMimeData_c7425_0 = cb;
}


// bool QSqlRelationalTableModel::canFetchMore(const QModelIndex &parent)

static void _init_cbs_canFetchMore_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_canFetchMore_c2395_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_canFetchMore_c2395_1 (arg1));
}

static void _set_callback_cbs_canFetchMore_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_canFetchMore_c2395_1 = cb;
}


// exposed void QSqlRelationalTableModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)

static void _init_fp_changePersistentIndex_4682 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_changePersistentIndex_4682 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->fp_QSqlRelationalTableModel_changePersistentIndex_4682 (arg1, arg2);
}


// exposed void QSqlRelationalTableModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)

static void _init_fp_changePersistentIndexList_5912 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<const QList<QModelIndex> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<const QList<QModelIndex> & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_changePersistentIndexList_5912 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QModelIndex> &arg1 = gsi::arg_reader<const QList<QModelIndex> & >() (args, heap);
  const QList<QModelIndex> &arg2 = gsi::arg_reader<const QList<QModelIndex> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->fp_QSqlRelationalTableModel_changePersistentIndexList_5912 (arg1, arg2);
}


// void QSqlRelationalTableModel::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QSqlRelationalTableModel::clear()

static void _init_cbs_clear_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_clear_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->cbs_clear_0_0 ();
}

static void _set_callback_cbs_clear_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_clear_0_0 = cb;
}


// int QSqlRelationalTableModel::columnCount(const QModelIndex &parent)

static void _init_cbs_columnCount_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_columnCount_c2395_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<int > ((int)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_columnCount_c2395_1 (arg1));
}

static void _set_callback_cbs_columnCount_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_columnCount_c2395_1 = cb;
}


// exposed QModelIndex QSqlRelationalTableModel::createIndex(int row, int column, void *data)

static void _init_fp_createIndex_c2374 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("data", true, "0");
  decl->add_arg<void * > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c2374 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  void *arg3 = args ? gsi::arg_reader<void * >() (args, heap) : gsi::arg_maker<void * >() (0, heap);
  ret.write<QModelIndex > ((QModelIndex)((QSqlRelationalTableModel_Adaptor *)cls)->fp_QSqlRelationalTableModel_createIndex_c2374 (arg1, arg2, arg3));
}


// exposed QModelIndex QSqlRelationalTableModel::createIndex(int row, int column, quintptr id)

static void _init_fp_createIndex_c2657 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("id");
  decl->add_arg<quintptr > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c2657 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  quintptr arg3 = gsi::arg_reader<quintptr >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QSqlRelationalTableModel_Adaptor *)cls)->fp_QSqlRelationalTableModel_createIndex_c2657 (arg1, arg2, arg3));
}


// void QSqlRelationalTableModel::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// QVariant QSqlRelationalTableModel::data(const QModelIndex &item, int role)

static void _init_cbs_data_c3054_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_cbs_data_c3054_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  ret.write<QVariant > ((QVariant)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_data_c3054_1 (arg1, arg2));
}

static void _set_callback_cbs_data_c3054_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_data_c3054_1 = cb;
}


// emitter void QSqlRelationalTableModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QVector<int> &roles)

static void _init_emitter_dataChanged_7048 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("topLeft");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("bottomRight");
  decl->add_arg<const QModelIndex & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("roles", true, "QVector<int>()");
  decl->add_arg<const QVector<int> & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_dataChanged_7048 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QVector<int> &arg3 = args ? gsi::arg_reader<const QVector<int> & >() (args, heap) : gsi::arg_maker<const QVector<int> & >() (QVector<int>(), heap);
  ((QSqlRelationalTableModel_Adaptor *)cls)->emitter_QSqlRelationalTableModel_dataChanged_7048 (arg1, arg2, arg3);
}


// exposed bool QSqlRelationalTableModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)

static void _init_fp_decodeData_5302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("stream");
  decl->add_arg<QDataStream & > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_fp_decodeData_5302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  QDataStream &arg4 = gsi::arg_reader<QDataStream & >() (args, heap);
  ret.write<bool > ((bool)((QSqlRelationalTableModel_Adaptor *)cls)->fp_QSqlRelationalTableModel_decodeData_5302 (arg1, arg2, arg3, arg4));
}


// bool QSqlRelationalTableModel::deleteRowFromTable(int row)

static void _init_cbs_deleteRowFromTable_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_deleteRowFromTable_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<bool > ((bool)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_deleteRowFromTable_767_0 (arg1));
}

static void _set_callback_cbs_deleteRowFromTable_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_deleteRowFromTable_767_0 = cb;
}


// emitter void QSqlRelationalTableModel::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QSqlRelationalTableModel_Adaptor *)cls)->emitter_QSqlRelationalTableModel_destroyed_1302 (arg1);
}


// void QSqlRelationalTableModel::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QSqlRelationalTableModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)

static void _init_cbs_dropMimeData_7425_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("row");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("column");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_dropMimeData_7425_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMimeData *arg1 = args.read<const QMimeData * > (heap);
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::DropAction>::target_type & > (heap);
  int arg3 = args.read<int > (heap);
  int arg4 = args.read<int > (heap);
  const QModelIndex &arg5 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_dropMimeData_7425_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_dropMimeData_7425_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_dropMimeData_7425_0 = cb;
}


// exposed void QSqlRelationalTableModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)

static void _init_fp_encodeData_c4599 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indexes");
  decl->add_arg<const QList<QModelIndex> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stream");
  decl->add_arg<QDataStream & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_encodeData_c4599 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QModelIndex> &arg1 = gsi::arg_reader<const QList<QModelIndex> & >() (args, heap);
  QDataStream &arg2 = gsi::arg_reader<QDataStream & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->fp_QSqlRelationalTableModel_encodeData_c4599 (arg1, arg2);
}


// exposed void QSqlRelationalTableModel::endInsertColumns()

static void _init_fp_endInsertColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endInsertColumns_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->fp_QSqlRelationalTableModel_endInsertColumns_0 ();
}


// exposed void QSqlRelationalTableModel::endInsertRows()

static void _init_fp_endInsertRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endInsertRows_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->fp_QSqlRelationalTableModel_endInsertRows_0 ();
}


// exposed void QSqlRelationalTableModel::endMoveColumns()

static void _init_fp_endMoveColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endMoveColumns_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->fp_QSqlRelationalTableModel_endMoveColumns_0 ();
}


// exposed void QSqlRelationalTableModel::endMoveRows()

static void _init_fp_endMoveRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endMoveRows_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->fp_QSqlRelationalTableModel_endMoveRows_0 ();
}


// exposed void QSqlRelationalTableModel::endRemoveColumns()

static void _init_fp_endRemoveColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endRemoveColumns_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->fp_QSqlRelationalTableModel_endRemoveColumns_0 ();
}


// exposed void QSqlRelationalTableModel::endRemoveRows()

static void _init_fp_endRemoveRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endRemoveRows_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->fp_QSqlRelationalTableModel_endRemoveRows_0 ();
}


// exposed void QSqlRelationalTableModel::endResetModel()

static void _init_fp_endResetModel_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endResetModel_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->fp_QSqlRelationalTableModel_endResetModel_0 ();
}


// bool QSqlRelationalTableModel::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QSqlRelationalTableModel::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QSqlRelationalTableModel::fetchMore(const QModelIndex &parent)

static void _init_cbs_fetchMore_2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fetchMore_2395_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->cbs_fetchMore_2395_1 (arg1);
}

static void _set_callback_cbs_fetchMore_2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_fetchMore_2395_1 = cb;
}


// QFlags<Qt::ItemFlag> QSqlRelationalTableModel::flags(const QModelIndex &index)

static void _init_cbs_flags_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QFlags<Qt::ItemFlag> > ();
}

static void _call_cbs_flags_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QFlags<Qt::ItemFlag> > ((QFlags<Qt::ItemFlag>)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_flags_c2395_0 (arg1));
}

static void _set_callback_cbs_flags_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_flags_c2395_0 = cb;
}


// QVariant QSqlRelationalTableModel::headerData(int section, Qt::Orientation orientation, int role)

static void _init_cbs_headerData_c3231_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QVariant > ();
}

static void _call_cbs_headerData_c3231_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > (heap);
  int arg3 = args.read<int > (heap);
  ret.write<QVariant > ((QVariant)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_headerData_c3231_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_headerData_c3231_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_headerData_c3231_1 = cb;
}


// emitter void QSqlRelationalTableModel::headerDataChanged(Qt::Orientation orientation, int first, int last)

static void _init_emitter_headerDataChanged_3231 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_headerDataChanged_3231 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::Orientation>::target_type & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QSqlRelationalTableModel_Adaptor *)cls)->emitter_QSqlRelationalTableModel_headerDataChanged_3231 (arg1, arg2, arg3);
}


// QModelIndex QSqlRelationalTableModel::index(int row, int column, const QModelIndex &parent)

static void _init_cbs_index_c3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_index_c3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_index_c3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_index_c3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_index_c3713_1 = cb;
}


// QModelIndex QSqlRelationalTableModel::indexInQuery(const QModelIndex &item)

static void _init_cbs_indexInQuery_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_indexInQuery_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_indexInQuery_c2395_0 (arg1));
}

static void _set_callback_cbs_indexInQuery_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_indexInQuery_c2395_0 = cb;
}


// bool QSqlRelationalTableModel::insertColumns(int column, int count, const QModelIndex &parent)

static void _init_cbs_insertColumns_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_insertColumns_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_insertColumns_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_insertColumns_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_insertColumns_3713_1 = cb;
}


// bool QSqlRelationalTableModel::insertRowIntoTable(const QSqlRecord &values)

static void _init_cbs_insertRowIntoTable_2305_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("values");
  decl->add_arg<const QSqlRecord & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_insertRowIntoTable_2305_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSqlRecord &arg1 = args.read<const QSqlRecord & > (heap);
  ret.write<bool > ((bool)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_insertRowIntoTable_2305_0 (arg1));
}

static void _set_callback_cbs_insertRowIntoTable_2305_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_insertRowIntoTable_2305_0 = cb;
}


// bool QSqlRelationalTableModel::insertRows(int row, int count, const QModelIndex &parent)

static void _init_cbs_insertRows_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_insertRows_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_insertRows_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_insertRows_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_insertRows_3713_1 = cb;
}


// exposed bool QSqlRelationalTableModel::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QSqlRelationalTableModel_Adaptor *)cls)->fp_QSqlRelationalTableModel_isSignalConnected_c2394 (arg1));
}


// QMap<int, QVariant> QSqlRelationalTableModel::itemData(const QModelIndex &index)

static void _init_cbs_itemData_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QMap<int, QVariant> > ();
}

static void _call_cbs_itemData_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QMap<int, QVariant> > ((QMap<int, QVariant>)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_itemData_c2395_0 (arg1));
}

static void _set_callback_cbs_itemData_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_itemData_c2395_0 = cb;
}


// emitter void QSqlRelationalTableModel::layoutAboutToBeChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)

static void _init_emitter_layoutAboutToBeChanged_7947 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parents", true, "QList<QPersistentModelIndex>()");
  decl->add_arg<const QList<QPersistentModelIndex> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint", true, "QAbstractItemModel::NoLayoutChangeHint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_layoutAboutToBeChanged_7947 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QPersistentModelIndex> &arg1 = args ? gsi::arg_reader<const QList<QPersistentModelIndex> & >() (args, heap) : gsi::arg_maker<const QList<QPersistentModelIndex> & >() (QList<QPersistentModelIndex>(), heap);
  const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QAbstractItemModel::LayoutChangeHint>(heap, QAbstractItemModel::NoLayoutChangeHint), heap);
  ((QSqlRelationalTableModel_Adaptor *)cls)->emitter_QSqlRelationalTableModel_layoutAboutToBeChanged_7947 (arg1, arg2);
}


// emitter void QSqlRelationalTableModel::layoutChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)

static void _init_emitter_layoutChanged_7947 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parents", true, "QList<QPersistentModelIndex>()");
  decl->add_arg<const QList<QPersistentModelIndex> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint", true, "QAbstractItemModel::NoLayoutChangeHint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_layoutChanged_7947 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QPersistentModelIndex> &arg1 = args ? gsi::arg_reader<const QList<QPersistentModelIndex> & >() (args, heap) : gsi::arg_maker<const QList<QPersistentModelIndex> & >() (QList<QPersistentModelIndex>(), heap);
  const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QAbstractItemModel::LayoutChangeHint>(heap, QAbstractItemModel::NoLayoutChangeHint), heap);
  ((QSqlRelationalTableModel_Adaptor *)cls)->emitter_QSqlRelationalTableModel_layoutChanged_7947 (arg1, arg2);
}


// QList<QModelIndex> QSqlRelationalTableModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)

static void _init_cbs_match_c7932_2 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("start");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("hits");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("flags");
  decl->add_arg<QFlags<Qt::MatchFlag> > (argspec_4);
  decl->set_return<QList<QModelIndex> > ();
}

static void _call_cbs_match_c7932_2 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  const QVariant &arg3 = args.read<const QVariant & > (heap);
  int arg4 = args.read<int > (heap);
  QFlags<Qt::MatchFlag> arg5 = args.read<QFlags<Qt::MatchFlag> > (heap);
  ret.write<QList<QModelIndex> > ((QList<QModelIndex>)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_match_c7932_2 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_match_c7932_2 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_match_c7932_2 = cb;
}


// QMimeData *QSqlRelationalTableModel::mimeData(const QList<QModelIndex> &indexes)

static void _init_cbs_mimeData_c3010_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indexes");
  decl->add_arg<const QList<QModelIndex> & > (argspec_0);
  decl->set_return<QMimeData * > ();
}

static void _call_cbs_mimeData_c3010_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QModelIndex> &arg1 = args.read<const QList<QModelIndex> & > (heap);
  ret.write<QMimeData * > ((QMimeData *)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_mimeData_c3010_0 (arg1));
}

static void _set_callback_cbs_mimeData_c3010_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_mimeData_c3010_0 = cb;
}


// QStringList QSqlRelationalTableModel::mimeTypes()

static void _init_cbs_mimeTypes_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_cbs_mimeTypes_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_mimeTypes_c0_0 ());
}

static void _set_callback_cbs_mimeTypes_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_mimeTypes_c0_0 = cb;
}


// bool QSqlRelationalTableModel::moveColumns(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)

static void _init_cbs_moveColumns_6659_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceColumn");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("count");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationChild");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_moveColumns_6659_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  int arg3 = args.read<int > (heap);
  const QModelIndex &arg4 = args.read<const QModelIndex & > (heap);
  int arg5 = args.read<int > (heap);
  ret.write<bool > ((bool)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_moveColumns_6659_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_moveColumns_6659_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_moveColumns_6659_0 = cb;
}


// bool QSqlRelationalTableModel::moveRows(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)

static void _init_cbs_moveRows_6659_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceRow");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("count");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationChild");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_moveRows_6659_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  int arg3 = args.read<int > (heap);
  const QModelIndex &arg4 = args.read<const QModelIndex & > (heap);
  int arg5 = args.read<int > (heap);
  ret.write<bool > ((bool)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_moveRows_6659_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_moveRows_6659_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_moveRows_6659_0 = cb;
}


// QString QSqlRelationalTableModel::orderByClause()

static void _init_cbs_orderByClause_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_cbs_orderByClause_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_orderByClause_c0_0 ());
}

static void _set_callback_cbs_orderByClause_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_orderByClause_c0_0 = cb;
}


// exposed QList<QModelIndex> QSqlRelationalTableModel::persistentIndexList()

static void _init_fp_persistentIndexList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QModelIndex> > ();
}

static void _call_fp_persistentIndexList_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QModelIndex> > ((QList<QModelIndex>)((QSqlRelationalTableModel_Adaptor *)cls)->fp_QSqlRelationalTableModel_persistentIndexList_c0 ());
}


// exposed QSqlRecord QSqlRelationalTableModel::primaryValues(int row)

static void _init_fp_primaryValues_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QSqlRecord > ();
}

static void _call_fp_primaryValues_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QSqlRecord > ((QSqlRecord)((QSqlRelationalTableModel_Adaptor *)cls)->fp_QSqlRelationalTableModel_primaryValues_c767 (arg1));
}


// emitter void QSqlRelationalTableModel::primeInsert(int row, QSqlRecord &record)

static void _init_emitter_primeInsert_2269 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("record");
  decl->add_arg<QSqlRecord & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_primeInsert_2269 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  QSqlRecord &arg2 = gsi::arg_reader<QSqlRecord & >() (args, heap);
  ((QSqlRelationalTableModel_Adaptor *)cls)->emitter_QSqlRelationalTableModel_primeInsert_2269 (arg1, arg2);
}


// void QSqlRelationalTableModel::queryChange()

static void _init_cbs_queryChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_queryChange_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->cbs_queryChange_0_0 ();
}

static void _set_callback_cbs_queryChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_queryChange_0_0 = cb;
}


// exposed int QSqlRelationalTableModel::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QSqlRelationalTableModel_Adaptor *)cls)->fp_QSqlRelationalTableModel_receivers_c1731 (arg1));
}


// QSqlTableModel *QSqlRelationalTableModel::relationModel(int column)

static void _init_cbs_relationModel_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QSqlTableModel * > ();
}

static void _call_cbs_relationModel_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<QSqlTableModel * > ((QSqlTableModel *)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_relationModel_c767_0 (arg1));
}

static void _set_callback_cbs_relationModel_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_relationModel_c767_0 = cb;
}


// bool QSqlRelationalTableModel::removeColumns(int column, int count, const QModelIndex &parent)

static void _init_cbs_removeColumns_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_removeColumns_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_removeColumns_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_removeColumns_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_removeColumns_3713_1 = cb;
}


// bool QSqlRelationalTableModel::removeRows(int row, int count, const QModelIndex &parent)

static void _init_cbs_removeRows_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_removeRows_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_removeRows_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_removeRows_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_removeRows_3713_1 = cb;
}


// exposed void QSqlRelationalTableModel::resetInternalData()

static void _init_fp_resetInternalData_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInternalData_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->fp_QSqlRelationalTableModel_resetInternalData_0 ();
}


// void QSqlRelationalTableModel::revert()

static void _init_cbs_revert_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_revert_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->cbs_revert_0_0 ();
}

static void _set_callback_cbs_revert_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_revert_0_0 = cb;
}


// void QSqlRelationalTableModel::revertRow(int row)

static void _init_cbs_revertRow_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_revertRow_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->cbs_revertRow_767_0 (arg1);
}

static void _set_callback_cbs_revertRow_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_revertRow_767_0 = cb;
}


// QHash<int, QByteArray> QSqlRelationalTableModel::roleNames()

static void _init_cbs_roleNames_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QHash<int, QByteArray> > ();
}

static void _call_cbs_roleNames_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QHash<int, QByteArray> > ((QHash<int, QByteArray>)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_roleNames_c0_0 ());
}

static void _set_callback_cbs_roleNames_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_roleNames_c0_0 = cb;
}


// int QSqlRelationalTableModel::rowCount(const QModelIndex &parent)

static void _init_cbs_rowCount_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_rowCount_c2395_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<int > ((int)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_rowCount_c2395_1 (arg1));
}

static void _set_callback_cbs_rowCount_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_rowCount_c2395_1 = cb;
}


// bool QSqlRelationalTableModel::select()

static void _init_cbs_select_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_select_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_select_0_0 ());
}

static void _set_callback_cbs_select_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_select_0_0 = cb;
}


// bool QSqlRelationalTableModel::selectRow(int row)

static void _init_cbs_selectRow_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_selectRow_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<bool > ((bool)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_selectRow_767_0 (arg1));
}

static void _set_callback_cbs_selectRow_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_selectRow_767_0 = cb;
}


// QString QSqlRelationalTableModel::selectStatement()

static void _init_cbs_selectStatement_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_cbs_selectStatement_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_selectStatement_c0_0 ());
}

static void _set_callback_cbs_selectStatement_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_selectStatement_c0_0 = cb;
}


// exposed QObject *QSqlRelationalTableModel::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QSqlRelationalTableModel_Adaptor *)cls)->fp_QSqlRelationalTableModel_sender_c0 ());
}


// exposed int QSqlRelationalTableModel::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSqlRelationalTableModel_Adaptor *)cls)->fp_QSqlRelationalTableModel_senderSignalIndex_c0 ());
}


// bool QSqlRelationalTableModel::setData(const QModelIndex &item, const QVariant &value, int role)

static void _init_cbs_setData_5065_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_setData_5065_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const QVariant &arg2 = args.read<const QVariant & > (heap);
  int arg3 = args.read<int > (heap);
  ret.write<bool > ((bool)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_setData_5065_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_setData_5065_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_setData_5065_1 = cb;
}


// void QSqlRelationalTableModel::setEditStrategy(QSqlTableModel::EditStrategy strategy)

static void _init_cbs_setEditStrategy_3163_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("strategy");
  decl->add_arg<const qt_gsi::Converter<QSqlTableModel::EditStrategy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setEditStrategy_3163_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSqlTableModel::EditStrategy>::target_type & arg1 = args.read<const qt_gsi::Converter<QSqlTableModel::EditStrategy>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->cbs_setEditStrategy_3163_0 (arg1);
}

static void _set_callback_cbs_setEditStrategy_3163_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_setEditStrategy_3163_0 = cb;
}


// void QSqlRelationalTableModel::setFilter(const QString &filter)

static void _init_cbs_setFilter_2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filter");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setFilter_2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->cbs_setFilter_2025_0 (arg1);
}

static void _set_callback_cbs_setFilter_2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_setFilter_2025_0 = cb;
}


// bool QSqlRelationalTableModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)

static void _init_cbs_setHeaderData_5242_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("role");
  decl->add_arg<int > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_cbs_setHeaderData_5242_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > (heap);
  const QVariant &arg3 = args.read<const QVariant & > (heap);
  int arg4 = args.read<int > (heap);
  ret.write<bool > ((bool)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_setHeaderData_5242_1 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_setHeaderData_5242_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_setHeaderData_5242_1 = cb;
}


// bool QSqlRelationalTableModel::setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)

static void _init_cbs_setItemData_5414_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("roles");
  decl->add_arg<const QMap<int, QVariant> & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_setItemData_5414_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const QMap<int, QVariant> &arg2 = args.read<const QMap<int, QVariant> & > (heap);
  ret.write<bool > ((bool)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_setItemData_5414_0 (arg1, arg2));
}

static void _set_callback_cbs_setItemData_5414_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_setItemData_5414_0 = cb;
}


// exposed void QSqlRelationalTableModel::setLastError(const QSqlError &error)

static void _init_fp_setLastError_2220 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("error");
  decl->add_arg<const QSqlError & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setLastError_2220 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSqlError &arg1 = gsi::arg_reader<const QSqlError & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->fp_QSqlRelationalTableModel_setLastError_2220 (arg1);
}


// exposed void QSqlRelationalTableModel::setPrimaryKey(const QSqlIndex &key)

static void _init_fp_setPrimaryKey_2202 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QSqlIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setPrimaryKey_2202 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSqlIndex &arg1 = gsi::arg_reader<const QSqlIndex & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->fp_QSqlRelationalTableModel_setPrimaryKey_2202 (arg1);
}


// exposed void QSqlRelationalTableModel::setQuery(const QSqlQuery &query)

static void _init_fp_setQuery_2232 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const QSqlQuery & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setQuery_2232 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSqlQuery &arg1 = gsi::arg_reader<const QSqlQuery & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->fp_QSqlRelationalTableModel_setQuery_2232 (arg1);
}


// void QSqlRelationalTableModel::setRelation(int column, const QSqlRelation &relation)

static void _init_cbs_setRelation_3187_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("relation");
  decl->add_arg<const QSqlRelation & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setRelation_3187_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const QSqlRelation &arg2 = args.read<const QSqlRelation & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->cbs_setRelation_3187_0 (arg1, arg2);
}

static void _set_callback_cbs_setRelation_3187_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_setRelation_3187_0 = cb;
}


// void QSqlRelationalTableModel::setSort(int column, Qt::SortOrder order)

static void _init_cbs_setSort_2340_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("order");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setSort_2340_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->cbs_setSort_2340_0 (arg1, arg2);
}

static void _set_callback_cbs_setSort_2340_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_setSort_2340_0 = cb;
}


// void QSqlRelationalTableModel::setTable(const QString &tableName)

static void _init_cbs_setTable_2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tableName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setTable_2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->cbs_setTable_2025_0 (arg1);
}

static void _set_callback_cbs_setTable_2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_setTable_2025_0 = cb;
}


// QModelIndex QSqlRelationalTableModel::sibling(int row, int column, const QModelIndex &idx)

static void _init_cbs_sibling_c3713_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("idx");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_sibling_c3713_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_sibling_c3713_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_sibling_c3713_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_sibling_c3713_0 = cb;
}


// void QSqlRelationalTableModel::sort(int column, Qt::SortOrder order)

static void _init_cbs_sort_2340_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("order");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_sort_2340_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->cbs_sort_2340_0 (arg1, arg2);
}

static void _set_callback_cbs_sort_2340_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_sort_2340_0 = cb;
}


// QSize QSqlRelationalTableModel::span(const QModelIndex &index)

static void _init_cbs_span_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QSize > ();
}

static void _call_cbs_span_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QSize > ((QSize)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_span_c2395_0 (arg1));
}

static void _set_callback_cbs_span_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_span_c2395_0 = cb;
}


// bool QSqlRelationalTableModel::submit()

static void _init_cbs_submit_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_submit_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_submit_0_0 ());
}

static void _set_callback_cbs_submit_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_submit_0_0 = cb;
}


// QFlags<Qt::DropAction> QSqlRelationalTableModel::supportedDragActions()

static void _init_cbs_supportedDragActions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::DropAction> > ();
}

static void _call_cbs_supportedDragActions_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::DropAction> > ((QFlags<Qt::DropAction>)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_supportedDragActions_c0_0 ());
}

static void _set_callback_cbs_supportedDragActions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_supportedDragActions_c0_0 = cb;
}


// QFlags<Qt::DropAction> QSqlRelationalTableModel::supportedDropActions()

static void _init_cbs_supportedDropActions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::DropAction> > ();
}

static void _call_cbs_supportedDropActions_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::DropAction> > ((QFlags<Qt::DropAction>)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_supportedDropActions_c0_0 ());
}

static void _set_callback_cbs_supportedDropActions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_supportedDropActions_c0_0 = cb;
}


// void QSqlRelationalTableModel::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlRelationalTableModel_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// bool QSqlRelationalTableModel::updateRowInTable(int row, const QSqlRecord &values)

static void _init_cbs_updateRowInTable_2964_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("values");
  decl->add_arg<const QSqlRecord & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_updateRowInTable_2964_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const QSqlRecord &arg2 = args.read<const QSqlRecord & > (heap);
  ret.write<bool > ((bool)((QSqlRelationalTableModel_Adaptor *)cls)->cbs_updateRowInTable_2964_0 (arg1, arg2));
}

static void _set_callback_cbs_updateRowInTable_2964_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlRelationalTableModel_Adaptor *)cls)->cb_updateRowInTable_2964_0 = cb;
}


namespace gsi
{

gsi::Class<QSqlRelationalTableModel> &qtdecl_QSqlRelationalTableModel ();

static gsi::Methods methods_QSqlRelationalTableModel_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSqlRelationalTableModel::QSqlRelationalTableModel(QObject *parent, QSqlDatabase db)\nThis method creates an object of class QSqlRelationalTableModel.", &_init_ctor_QSqlRelationalTableModel_Adaptor_2804, &_call_ctor_QSqlRelationalTableModel_Adaptor_2804);
  methods += new qt_gsi::GenericMethod ("emit_beforeDelete", "@brief Emitter for signal void QSqlRelationalTableModel::beforeDelete(int row)\nCall this method to emit this signal.", false, &_init_emitter_beforeDelete_767, &_call_emitter_beforeDelete_767);
  methods += new qt_gsi::GenericMethod ("emit_beforeInsert", "@brief Emitter for signal void QSqlRelationalTableModel::beforeInsert(QSqlRecord &record)\nCall this method to emit this signal.", false, &_init_emitter_beforeInsert_1610, &_call_emitter_beforeInsert_1610);
  methods += new qt_gsi::GenericMethod ("emit_beforeUpdate", "@brief Emitter for signal void QSqlRelationalTableModel::beforeUpdate(int row, QSqlRecord &record)\nCall this method to emit this signal.", false, &_init_emitter_beforeUpdate_2269, &_call_emitter_beforeUpdate_2269);
  methods += new qt_gsi::GenericMethod ("*beginInsertColumns", "@brief Method void QSqlRelationalTableModel::beginInsertColumns(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginInsertColumns_3713, &_call_fp_beginInsertColumns_3713);
  methods += new qt_gsi::GenericMethod ("*beginInsertRows", "@brief Method void QSqlRelationalTableModel::beginInsertRows(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginInsertRows_3713, &_call_fp_beginInsertRows_3713);
  methods += new qt_gsi::GenericMethod ("*beginMoveColumns", "@brief Method bool QSqlRelationalTableModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginMoveColumns_6659, &_call_fp_beginMoveColumns_6659);
  methods += new qt_gsi::GenericMethod ("*beginMoveRows", "@brief Method bool QSqlRelationalTableModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginMoveRows_6659, &_call_fp_beginMoveRows_6659);
  methods += new qt_gsi::GenericMethod ("*beginRemoveColumns", "@brief Method void QSqlRelationalTableModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginRemoveColumns_3713, &_call_fp_beginRemoveColumns_3713);
  methods += new qt_gsi::GenericMethod ("*beginRemoveRows", "@brief Method void QSqlRelationalTableModel::beginRemoveRows(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginRemoveRows_3713, &_call_fp_beginRemoveRows_3713);
  methods += new qt_gsi::GenericMethod ("*beginResetModel", "@brief Method void QSqlRelationalTableModel::beginResetModel()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginResetModel_0, &_call_fp_beginResetModel_0);
  methods += new qt_gsi::GenericMethod ("buddy", "@hide", true, &_init_cbs_buddy_c2395_0, &_call_cbs_buddy_c2395_0);
  methods += new qt_gsi::GenericMethod ("buddy", "@brief Virtual method QModelIndex QSqlRelationalTableModel::buddy(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_buddy_c2395_0, &_call_cbs_buddy_c2395_0, &_set_callback_cbs_buddy_c2395_0);
  methods += new qt_gsi::GenericMethod ("canDropMimeData", "@hide", true, &_init_cbs_canDropMimeData_c7425_0, &_call_cbs_canDropMimeData_c7425_0);
  methods += new qt_gsi::GenericMethod ("canDropMimeData", "@brief Virtual method bool QSqlRelationalTableModel::canDropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_canDropMimeData_c7425_0, &_call_cbs_canDropMimeData_c7425_0, &_set_callback_cbs_canDropMimeData_c7425_0);
  methods += new qt_gsi::GenericMethod ("canFetchMore", "@hide", true, &_init_cbs_canFetchMore_c2395_1, &_call_cbs_canFetchMore_c2395_1);
  methods += new qt_gsi::GenericMethod ("canFetchMore", "@brief Virtual method bool QSqlRelationalTableModel::canFetchMore(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_canFetchMore_c2395_1, &_call_cbs_canFetchMore_c2395_1, &_set_callback_cbs_canFetchMore_c2395_1);
  methods += new qt_gsi::GenericMethod ("*changePersistentIndex", "@brief Method void QSqlRelationalTableModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_changePersistentIndex_4682, &_call_fp_changePersistentIndex_4682);
  methods += new qt_gsi::GenericMethod ("*changePersistentIndexList", "@brief Method void QSqlRelationalTableModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_changePersistentIndexList_5912, &_call_fp_changePersistentIndexList_5912);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QSqlRelationalTableModel::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("clear", "@hide", false, &_init_cbs_clear_0_0, &_call_cbs_clear_0_0);
  methods += new qt_gsi::GenericMethod ("clear", "@brief Virtual method void QSqlRelationalTableModel::clear()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_clear_0_0, &_call_cbs_clear_0_0, &_set_callback_cbs_clear_0_0);
  methods += new qt_gsi::GenericMethod ("columnCount", "@hide", true, &_init_cbs_columnCount_c2395_1, &_call_cbs_columnCount_c2395_1);
  methods += new qt_gsi::GenericMethod ("columnCount", "@brief Virtual method int QSqlRelationalTableModel::columnCount(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_columnCount_c2395_1, &_call_cbs_columnCount_c2395_1, &_set_callback_cbs_columnCount_c2395_1);
  methods += new qt_gsi::GenericMethod ("*createIndex", "@brief Method QModelIndex QSqlRelationalTableModel::createIndex(int row, int column, void *data)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c2374, &_call_fp_createIndex_c2374);
  methods += new qt_gsi::GenericMethod ("*createIndex", "@brief Method QModelIndex QSqlRelationalTableModel::createIndex(int row, int column, quintptr id)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c2657, &_call_fp_createIndex_c2657);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QSqlRelationalTableModel::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("data", "@hide", true, &_init_cbs_data_c3054_1, &_call_cbs_data_c3054_1);
  methods += new qt_gsi::GenericMethod ("data", "@brief Virtual method QVariant QSqlRelationalTableModel::data(const QModelIndex &item, int role)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_data_c3054_1, &_call_cbs_data_c3054_1, &_set_callback_cbs_data_c3054_1);
  methods += new qt_gsi::GenericMethod ("emit_dataChanged", "@brief Emitter for signal void QSqlRelationalTableModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QVector<int> &roles)\nCall this method to emit this signal.", false, &_init_emitter_dataChanged_7048, &_call_emitter_dataChanged_7048);
  methods += new qt_gsi::GenericMethod ("*decodeData", "@brief Method bool QSqlRelationalTableModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_decodeData_5302, &_call_fp_decodeData_5302);
  methods += new qt_gsi::GenericMethod ("*deleteRowFromTable", "@hide", false, &_init_cbs_deleteRowFromTable_767_0, &_call_cbs_deleteRowFromTable_767_0);
  methods += new qt_gsi::GenericMethod ("*deleteRowFromTable", "@brief Virtual method bool QSqlRelationalTableModel::deleteRowFromTable(int row)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_deleteRowFromTable_767_0, &_call_cbs_deleteRowFromTable_767_0, &_set_callback_cbs_deleteRowFromTable_767_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QSqlRelationalTableModel::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QSqlRelationalTableModel::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("dropMimeData", "@hide", false, &_init_cbs_dropMimeData_7425_0, &_call_cbs_dropMimeData_7425_0);
  methods += new qt_gsi::GenericMethod ("dropMimeData", "@brief Virtual method bool QSqlRelationalTableModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropMimeData_7425_0, &_call_cbs_dropMimeData_7425_0, &_set_callback_cbs_dropMimeData_7425_0);
  methods += new qt_gsi::GenericMethod ("*encodeData", "@brief Method void QSqlRelationalTableModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_encodeData_c4599, &_call_fp_encodeData_c4599);
  methods += new qt_gsi::GenericMethod ("*endInsertColumns", "@brief Method void QSqlRelationalTableModel::endInsertColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endInsertColumns_0, &_call_fp_endInsertColumns_0);
  methods += new qt_gsi::GenericMethod ("*endInsertRows", "@brief Method void QSqlRelationalTableModel::endInsertRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endInsertRows_0, &_call_fp_endInsertRows_0);
  methods += new qt_gsi::GenericMethod ("*endMoveColumns", "@brief Method void QSqlRelationalTableModel::endMoveColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endMoveColumns_0, &_call_fp_endMoveColumns_0);
  methods += new qt_gsi::GenericMethod ("*endMoveRows", "@brief Method void QSqlRelationalTableModel::endMoveRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endMoveRows_0, &_call_fp_endMoveRows_0);
  methods += new qt_gsi::GenericMethod ("*endRemoveColumns", "@brief Method void QSqlRelationalTableModel::endRemoveColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endRemoveColumns_0, &_call_fp_endRemoveColumns_0);
  methods += new qt_gsi::GenericMethod ("*endRemoveRows", "@brief Method void QSqlRelationalTableModel::endRemoveRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endRemoveRows_0, &_call_fp_endRemoveRows_0);
  methods += new qt_gsi::GenericMethod ("*endResetModel", "@brief Method void QSqlRelationalTableModel::endResetModel()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endResetModel_0, &_call_fp_endResetModel_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QSqlRelationalTableModel::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QSqlRelationalTableModel::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("fetchMore", "@hide", false, &_init_cbs_fetchMore_2395_1, &_call_cbs_fetchMore_2395_1);
  methods += new qt_gsi::GenericMethod ("fetchMore", "@brief Virtual method void QSqlRelationalTableModel::fetchMore(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fetchMore_2395_1, &_call_cbs_fetchMore_2395_1, &_set_callback_cbs_fetchMore_2395_1);
  methods += new qt_gsi::GenericMethod ("flags", "@hide", true, &_init_cbs_flags_c2395_0, &_call_cbs_flags_c2395_0);
  methods += new qt_gsi::GenericMethod ("flags", "@brief Virtual method QFlags<Qt::ItemFlag> QSqlRelationalTableModel::flags(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_flags_c2395_0, &_call_cbs_flags_c2395_0, &_set_callback_cbs_flags_c2395_0);
  methods += new qt_gsi::GenericMethod ("headerData", "@hide", true, &_init_cbs_headerData_c3231_1, &_call_cbs_headerData_c3231_1);
  methods += new qt_gsi::GenericMethod ("headerData", "@brief Virtual method QVariant QSqlRelationalTableModel::headerData(int section, Qt::Orientation orientation, int role)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_headerData_c3231_1, &_call_cbs_headerData_c3231_1, &_set_callback_cbs_headerData_c3231_1);
  methods += new qt_gsi::GenericMethod ("emit_headerDataChanged", "@brief Emitter for signal void QSqlRelationalTableModel::headerDataChanged(Qt::Orientation orientation, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_headerDataChanged_3231, &_call_emitter_headerDataChanged_3231);
  methods += new qt_gsi::GenericMethod ("index", "@hide", true, &_init_cbs_index_c3713_1, &_call_cbs_index_c3713_1);
  methods += new qt_gsi::GenericMethod ("index", "@brief Virtual method QModelIndex QSqlRelationalTableModel::index(int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_index_c3713_1, &_call_cbs_index_c3713_1, &_set_callback_cbs_index_c3713_1);
  methods += new qt_gsi::GenericMethod ("*indexInQuery", "@hide", true, &_init_cbs_indexInQuery_c2395_0, &_call_cbs_indexInQuery_c2395_0);
  methods += new qt_gsi::GenericMethod ("*indexInQuery", "@brief Virtual method QModelIndex QSqlRelationalTableModel::indexInQuery(const QModelIndex &item)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_indexInQuery_c2395_0, &_call_cbs_indexInQuery_c2395_0, &_set_callback_cbs_indexInQuery_c2395_0);
  methods += new qt_gsi::GenericMethod ("insertColumns", "@hide", false, &_init_cbs_insertColumns_3713_1, &_call_cbs_insertColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("insertColumns", "@brief Virtual method bool QSqlRelationalTableModel::insertColumns(int column, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertColumns_3713_1, &_call_cbs_insertColumns_3713_1, &_set_callback_cbs_insertColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("*insertRowIntoTable", "@hide", false, &_init_cbs_insertRowIntoTable_2305_0, &_call_cbs_insertRowIntoTable_2305_0);
  methods += new qt_gsi::GenericMethod ("*insertRowIntoTable", "@brief Virtual method bool QSqlRelationalTableModel::insertRowIntoTable(const QSqlRecord &values)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertRowIntoTable_2305_0, &_call_cbs_insertRowIntoTable_2305_0, &_set_callback_cbs_insertRowIntoTable_2305_0);
  methods += new qt_gsi::GenericMethod ("insertRows", "@hide", false, &_init_cbs_insertRows_3713_1, &_call_cbs_insertRows_3713_1);
  methods += new qt_gsi::GenericMethod ("insertRows", "@brief Virtual method bool QSqlRelationalTableModel::insertRows(int row, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertRows_3713_1, &_call_cbs_insertRows_3713_1, &_set_callback_cbs_insertRows_3713_1);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QSqlRelationalTableModel::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("itemData", "@hide", true, &_init_cbs_itemData_c2395_0, &_call_cbs_itemData_c2395_0);
  methods += new qt_gsi::GenericMethod ("itemData", "@brief Virtual method QMap<int, QVariant> QSqlRelationalTableModel::itemData(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_itemData_c2395_0, &_call_cbs_itemData_c2395_0, &_set_callback_cbs_itemData_c2395_0);
  methods += new qt_gsi::GenericMethod ("emit_layoutAboutToBeChanged", "@brief Emitter for signal void QSqlRelationalTableModel::layoutAboutToBeChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)\nCall this method to emit this signal.", false, &_init_emitter_layoutAboutToBeChanged_7947, &_call_emitter_layoutAboutToBeChanged_7947);
  methods += new qt_gsi::GenericMethod ("emit_layoutChanged", "@brief Emitter for signal void QSqlRelationalTableModel::layoutChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)\nCall this method to emit this signal.", false, &_init_emitter_layoutChanged_7947, &_call_emitter_layoutChanged_7947);
  methods += new qt_gsi::GenericMethod ("match", "@hide", true, &_init_cbs_match_c7932_2, &_call_cbs_match_c7932_2);
  methods += new qt_gsi::GenericMethod ("match", "@brief Virtual method QList<QModelIndex> QSqlRelationalTableModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_match_c7932_2, &_call_cbs_match_c7932_2, &_set_callback_cbs_match_c7932_2);
  methods += new qt_gsi::GenericMethod ("mimeData", "@hide", true, &_init_cbs_mimeData_c3010_0, &_call_cbs_mimeData_c3010_0);
  methods += new qt_gsi::GenericMethod ("mimeData", "@brief Virtual method QMimeData *QSqlRelationalTableModel::mimeData(const QList<QModelIndex> &indexes)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeData_c3010_0, &_call_cbs_mimeData_c3010_0, &_set_callback_cbs_mimeData_c3010_0);
  methods += new qt_gsi::GenericMethod ("mimeTypes", "@hide", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0);
  methods += new qt_gsi::GenericMethod ("mimeTypes", "@brief Virtual method QStringList QSqlRelationalTableModel::mimeTypes()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0, &_set_callback_cbs_mimeTypes_c0_0);
  methods += new qt_gsi::GenericMethod ("moveColumns", "@hide", false, &_init_cbs_moveColumns_6659_0, &_call_cbs_moveColumns_6659_0);
  methods += new qt_gsi::GenericMethod ("moveColumns", "@brief Virtual method bool QSqlRelationalTableModel::moveColumns(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveColumns_6659_0, &_call_cbs_moveColumns_6659_0, &_set_callback_cbs_moveColumns_6659_0);
  methods += new qt_gsi::GenericMethod ("moveRows", "@hide", false, &_init_cbs_moveRows_6659_0, &_call_cbs_moveRows_6659_0);
  methods += new qt_gsi::GenericMethod ("moveRows", "@brief Virtual method bool QSqlRelationalTableModel::moveRows(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveRows_6659_0, &_call_cbs_moveRows_6659_0, &_set_callback_cbs_moveRows_6659_0);
  methods += new qt_gsi::GenericMethod ("*orderByClause", "@hide", true, &_init_cbs_orderByClause_c0_0, &_call_cbs_orderByClause_c0_0);
  methods += new qt_gsi::GenericMethod ("*orderByClause", "@brief Virtual method QString QSqlRelationalTableModel::orderByClause()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_orderByClause_c0_0, &_call_cbs_orderByClause_c0_0, &_set_callback_cbs_orderByClause_c0_0);
  methods += new qt_gsi::GenericMethod ("*persistentIndexList", "@brief Method QList<QModelIndex> QSqlRelationalTableModel::persistentIndexList()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_persistentIndexList_c0, &_call_fp_persistentIndexList_c0);
  methods += new qt_gsi::GenericMethod ("*primaryValues", "@brief Method QSqlRecord QSqlRelationalTableModel::primaryValues(int row)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_primaryValues_c767, &_call_fp_primaryValues_c767);
  methods += new qt_gsi::GenericMethod ("emit_primeInsert", "@brief Emitter for signal void QSqlRelationalTableModel::primeInsert(int row, QSqlRecord &record)\nCall this method to emit this signal.", false, &_init_emitter_primeInsert_2269, &_call_emitter_primeInsert_2269);
  methods += new qt_gsi::GenericMethod ("*queryChange", "@hide", false, &_init_cbs_queryChange_0_0, &_call_cbs_queryChange_0_0);
  methods += new qt_gsi::GenericMethod ("*queryChange", "@brief Virtual method void QSqlRelationalTableModel::queryChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_queryChange_0_0, &_call_cbs_queryChange_0_0, &_set_callback_cbs_queryChange_0_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QSqlRelationalTableModel::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("relationModel", "@hide", true, &_init_cbs_relationModel_c767_0, &_call_cbs_relationModel_c767_0);
  methods += new qt_gsi::GenericMethod ("relationModel", "@brief Virtual method QSqlTableModel *QSqlRelationalTableModel::relationModel(int column)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_relationModel_c767_0, &_call_cbs_relationModel_c767_0, &_set_callback_cbs_relationModel_c767_0);
  methods += new qt_gsi::GenericMethod ("removeColumns", "@hide", false, &_init_cbs_removeColumns_3713_1, &_call_cbs_removeColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("removeColumns", "@brief Virtual method bool QSqlRelationalTableModel::removeColumns(int column, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_removeColumns_3713_1, &_call_cbs_removeColumns_3713_1, &_set_callback_cbs_removeColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("removeRows", "@hide", false, &_init_cbs_removeRows_3713_1, &_call_cbs_removeRows_3713_1);
  methods += new qt_gsi::GenericMethod ("removeRows", "@brief Virtual method bool QSqlRelationalTableModel::removeRows(int row, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_removeRows_3713_1, &_call_cbs_removeRows_3713_1, &_set_callback_cbs_removeRows_3713_1);
  methods += new qt_gsi::GenericMethod ("*resetInternalData", "@brief Method void QSqlRelationalTableModel::resetInternalData()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInternalData_0, &_call_fp_resetInternalData_0);
  methods += new qt_gsi::GenericMethod ("revert", "@hide", false, &_init_cbs_revert_0_0, &_call_cbs_revert_0_0);
  methods += new qt_gsi::GenericMethod ("revert", "@brief Virtual method void QSqlRelationalTableModel::revert()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_revert_0_0, &_call_cbs_revert_0_0, &_set_callback_cbs_revert_0_0);
  methods += new qt_gsi::GenericMethod ("revertRow", "@hide", false, &_init_cbs_revertRow_767_0, &_call_cbs_revertRow_767_0);
  methods += new qt_gsi::GenericMethod ("revertRow", "@brief Virtual method void QSqlRelationalTableModel::revertRow(int row)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_revertRow_767_0, &_call_cbs_revertRow_767_0, &_set_callback_cbs_revertRow_767_0);
  methods += new qt_gsi::GenericMethod ("roleNames", "@hide", true, &_init_cbs_roleNames_c0_0, &_call_cbs_roleNames_c0_0);
  methods += new qt_gsi::GenericMethod ("roleNames", "@brief Virtual method QHash<int, QByteArray> QSqlRelationalTableModel::roleNames()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_roleNames_c0_0, &_call_cbs_roleNames_c0_0, &_set_callback_cbs_roleNames_c0_0);
  methods += new qt_gsi::GenericMethod ("rowCount", "@hide", true, &_init_cbs_rowCount_c2395_1, &_call_cbs_rowCount_c2395_1);
  methods += new qt_gsi::GenericMethod ("rowCount", "@brief Virtual method int QSqlRelationalTableModel::rowCount(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_rowCount_c2395_1, &_call_cbs_rowCount_c2395_1, &_set_callback_cbs_rowCount_c2395_1);
  methods += new qt_gsi::GenericMethod ("select", "@hide", false, &_init_cbs_select_0_0, &_call_cbs_select_0_0);
  methods += new qt_gsi::GenericMethod ("select", "@brief Virtual method bool QSqlRelationalTableModel::select()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_select_0_0, &_call_cbs_select_0_0, &_set_callback_cbs_select_0_0);
  methods += new qt_gsi::GenericMethod ("selectRow", "@hide", false, &_init_cbs_selectRow_767_0, &_call_cbs_selectRow_767_0);
  methods += new qt_gsi::GenericMethod ("selectRow", "@brief Virtual method bool QSqlRelationalTableModel::selectRow(int row)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_selectRow_767_0, &_call_cbs_selectRow_767_0, &_set_callback_cbs_selectRow_767_0);
  methods += new qt_gsi::GenericMethod ("*selectStatement", "@hide", true, &_init_cbs_selectStatement_c0_0, &_call_cbs_selectStatement_c0_0);
  methods += new qt_gsi::GenericMethod ("*selectStatement", "@brief Virtual method QString QSqlRelationalTableModel::selectStatement()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_selectStatement_c0_0, &_call_cbs_selectStatement_c0_0, &_set_callback_cbs_selectStatement_c0_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QSqlRelationalTableModel::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QSqlRelationalTableModel::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setData", "@hide", false, &_init_cbs_setData_5065_1, &_call_cbs_setData_5065_1);
  methods += new qt_gsi::GenericMethod ("setData", "@brief Virtual method bool QSqlRelationalTableModel::setData(const QModelIndex &item, const QVariant &value, int role)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setData_5065_1, &_call_cbs_setData_5065_1, &_set_callback_cbs_setData_5065_1);
  methods += new qt_gsi::GenericMethod ("setEditStrategy", "@hide", false, &_init_cbs_setEditStrategy_3163_0, &_call_cbs_setEditStrategy_3163_0);
  methods += new qt_gsi::GenericMethod ("setEditStrategy", "@brief Virtual method void QSqlRelationalTableModel::setEditStrategy(QSqlTableModel::EditStrategy strategy)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setEditStrategy_3163_0, &_call_cbs_setEditStrategy_3163_0, &_set_callback_cbs_setEditStrategy_3163_0);
  methods += new qt_gsi::GenericMethod ("setFilter", "@hide", false, &_init_cbs_setFilter_2025_0, &_call_cbs_setFilter_2025_0);
  methods += new qt_gsi::GenericMethod ("setFilter", "@brief Virtual method void QSqlRelationalTableModel::setFilter(const QString &filter)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setFilter_2025_0, &_call_cbs_setFilter_2025_0, &_set_callback_cbs_setFilter_2025_0);
  methods += new qt_gsi::GenericMethod ("setHeaderData", "@hide", false, &_init_cbs_setHeaderData_5242_1, &_call_cbs_setHeaderData_5242_1);
  methods += new qt_gsi::GenericMethod ("setHeaderData", "@brief Virtual method bool QSqlRelationalTableModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setHeaderData_5242_1, &_call_cbs_setHeaderData_5242_1, &_set_callback_cbs_setHeaderData_5242_1);
  methods += new qt_gsi::GenericMethod ("setItemData", "@hide", false, &_init_cbs_setItemData_5414_0, &_call_cbs_setItemData_5414_0);
  methods += new qt_gsi::GenericMethod ("setItemData", "@brief Virtual method bool QSqlRelationalTableModel::setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setItemData_5414_0, &_call_cbs_setItemData_5414_0, &_set_callback_cbs_setItemData_5414_0);
  methods += new qt_gsi::GenericMethod ("*setLastError", "@brief Method void QSqlRelationalTableModel::setLastError(const QSqlError &error)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setLastError_2220, &_call_fp_setLastError_2220);
  methods += new qt_gsi::GenericMethod ("*setPrimaryKey", "@brief Method void QSqlRelationalTableModel::setPrimaryKey(const QSqlIndex &key)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setPrimaryKey_2202, &_call_fp_setPrimaryKey_2202);
  methods += new qt_gsi::GenericMethod ("*setQuery", "@brief Method void QSqlRelationalTableModel::setQuery(const QSqlQuery &query)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setQuery_2232, &_call_fp_setQuery_2232);
  methods += new qt_gsi::GenericMethod ("setRelation", "@hide", false, &_init_cbs_setRelation_3187_0, &_call_cbs_setRelation_3187_0);
  methods += new qt_gsi::GenericMethod ("setRelation", "@brief Virtual method void QSqlRelationalTableModel::setRelation(int column, const QSqlRelation &relation)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setRelation_3187_0, &_call_cbs_setRelation_3187_0, &_set_callback_cbs_setRelation_3187_0);
  methods += new qt_gsi::GenericMethod ("setSort", "@hide", false, &_init_cbs_setSort_2340_0, &_call_cbs_setSort_2340_0);
  methods += new qt_gsi::GenericMethod ("setSort", "@brief Virtual method void QSqlRelationalTableModel::setSort(int column, Qt::SortOrder order)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setSort_2340_0, &_call_cbs_setSort_2340_0, &_set_callback_cbs_setSort_2340_0);
  methods += new qt_gsi::GenericMethod ("setTable", "@hide", false, &_init_cbs_setTable_2025_0, &_call_cbs_setTable_2025_0);
  methods += new qt_gsi::GenericMethod ("setTable", "@brief Virtual method void QSqlRelationalTableModel::setTable(const QString &tableName)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setTable_2025_0, &_call_cbs_setTable_2025_0, &_set_callback_cbs_setTable_2025_0);
  methods += new qt_gsi::GenericMethod ("sibling", "@hide", true, &_init_cbs_sibling_c3713_0, &_call_cbs_sibling_c3713_0);
  methods += new qt_gsi::GenericMethod ("sibling", "@brief Virtual method QModelIndex QSqlRelationalTableModel::sibling(int row, int column, const QModelIndex &idx)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sibling_c3713_0, &_call_cbs_sibling_c3713_0, &_set_callback_cbs_sibling_c3713_0);
  methods += new qt_gsi::GenericMethod ("sort", "@hide", false, &_init_cbs_sort_2340_0, &_call_cbs_sort_2340_0);
  methods += new qt_gsi::GenericMethod ("sort", "@brief Virtual method void QSqlRelationalTableModel::sort(int column, Qt::SortOrder order)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sort_2340_0, &_call_cbs_sort_2340_0, &_set_callback_cbs_sort_2340_0);
  methods += new qt_gsi::GenericMethod ("span", "@hide", true, &_init_cbs_span_c2395_0, &_call_cbs_span_c2395_0);
  methods += new qt_gsi::GenericMethod ("span", "@brief Virtual method QSize QSqlRelationalTableModel::span(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_span_c2395_0, &_call_cbs_span_c2395_0, &_set_callback_cbs_span_c2395_0);
  methods += new qt_gsi::GenericMethod ("submit", "@hide", false, &_init_cbs_submit_0_0, &_call_cbs_submit_0_0);
  methods += new qt_gsi::GenericMethod ("submit", "@brief Virtual method bool QSqlRelationalTableModel::submit()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_submit_0_0, &_call_cbs_submit_0_0, &_set_callback_cbs_submit_0_0);
  methods += new qt_gsi::GenericMethod ("supportedDragActions", "@hide", true, &_init_cbs_supportedDragActions_c0_0, &_call_cbs_supportedDragActions_c0_0);
  methods += new qt_gsi::GenericMethod ("supportedDragActions", "@brief Virtual method QFlags<Qt::DropAction> QSqlRelationalTableModel::supportedDragActions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportedDragActions_c0_0, &_call_cbs_supportedDragActions_c0_0, &_set_callback_cbs_supportedDragActions_c0_0);
  methods += new qt_gsi::GenericMethod ("supportedDropActions", "@hide", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0);
  methods += new qt_gsi::GenericMethod ("supportedDropActions", "@brief Virtual method QFlags<Qt::DropAction> QSqlRelationalTableModel::supportedDropActions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0, &_set_callback_cbs_supportedDropActions_c0_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QSqlRelationalTableModel::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateRowInTable", "@hide", false, &_init_cbs_updateRowInTable_2964_0, &_call_cbs_updateRowInTable_2964_0);
  methods += new qt_gsi::GenericMethod ("*updateRowInTable", "@brief Virtual method bool QSqlRelationalTableModel::updateRowInTable(int row, const QSqlRecord &values)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateRowInTable_2964_0, &_call_cbs_updateRowInTable_2964_0, &_set_callback_cbs_updateRowInTable_2964_0);
  return methods;
}

gsi::Class<QSqlRelationalTableModel_Adaptor> decl_QSqlRelationalTableModel_Adaptor (qtdecl_QSqlRelationalTableModel (), "QtSql", "QSqlRelationalTableModel",
  methods_QSqlRelationalTableModel_Adaptor (),
  "@qt\n@brief Binding of QSqlRelationalTableModel");

}


//  Implementation of the enum wrapper class for QSqlRelationalTableModel::JoinMode
namespace qt_gsi
{

static gsi::Enum<QSqlRelationalTableModel::JoinMode> decl_QSqlRelationalTableModel_JoinMode_Enum ("QtSql", "QSqlRelationalTableModel_JoinMode",
    gsi::enum_const ("InnerJoin", QSqlRelationalTableModel::InnerJoin, "@brief Enum constant QSqlRelationalTableModel::InnerJoin") +
    gsi::enum_const ("LeftJoin", QSqlRelationalTableModel::LeftJoin, "@brief Enum constant QSqlRelationalTableModel::LeftJoin"),
  "@qt\n@brief This class represents the QSqlRelationalTableModel::JoinMode enum");

static gsi::QFlagsClass<QSqlRelationalTableModel::JoinMode > decl_QSqlRelationalTableModel_JoinMode_Enums ("QtSql", "QSqlRelationalTableModel_QFlags_JoinMode",
  "@qt\n@brief This class represents the QFlags<QSqlRelationalTableModel::JoinMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QSqlRelationalTableModel> inject_QSqlRelationalTableModel_JoinMode_Enum_in_parent (decl_QSqlRelationalTableModel_JoinMode_Enum.defs ());
static gsi::ClassExt<QSqlRelationalTableModel> decl_QSqlRelationalTableModel_JoinMode_Enum_as_child (decl_QSqlRelationalTableModel_JoinMode_Enum, "JoinMode");
static gsi::ClassExt<QSqlRelationalTableModel> decl_QSqlRelationalTableModel_JoinMode_Enums_as_child (decl_QSqlRelationalTableModel_JoinMode_Enums, "QFlags_JoinMode");

}

