def create_tasks():
    from myqueue.task import task
    return [
        task('h2o.py', folder='water'),
        task('CO.py@8:15m', folder='wavefunctions'),
        task('Al_fcc.py@2:15m', folder='aluminium'),
        task('Al_bcc.py@2:15m', folder='aluminium'),
        task('Al_fcc_vs_bcc.py@2:15s', folder='aluminium'),
        task('Al_fcc_modified.py@2:15s', folder='aluminium'),
        task('initial.py@2:15m', folder='diffusion'),
        task('solution.py@2:15m', folder='diffusion'),
        task('densitydiff.py', folder='diffusion', deps='solution.py'),
        task('si.py@8:15m', folder='wannier'),
        task('wannier-si.py', folder='wannier', deps='si.py'),
        task('benzene.py@8:15m', folder='wannier'),
        task('wannier-benzene.py', folder='wannier', deps='benzene.py'),
        task('ag.py', folder='band_structure'),
        task('h2o.py@8:15m', folder='vibrations'),
        task('H2O_vib.py@8:15m', folder='vibrations', deps='h2o.py'),
        task('H2O_vib_2.py@4:15m', folder='vibrations', deps='H2O_vib.py'),
        task('ferro.py@4:15m', folder='iron'),
        task('anti.py@4:15m', folder='iron'),
        task('non.py@2:15m', folder='iron'),
        task('PBE.py', folder='iron', deps='ferro.py,anti.py,non.py'),
        task('test.py', folder='eels', deps='../band_structure/ag.py'),
        task('test.py', folder='gw'),
        task('si.pbe.py', folder='rpa'),
        task('si_pbe_exx.py@4:15m', folder='rpa', deps='si.pbe.py'),
        task('si.rpa_init_pbe.py', folder='rpa'),
        task('si.rpa.py@4:15m', folder='rpa', deps='si.rpa_init_pbe.py'),
        task('con_pw.py', folder='stress'),
        task('stress.py', folder='stress'),
        # task('pt_h2_tb_transport.py', folder='transport'),
        # task('pt_h2_lcao_manual.py', folder='transport'),
        # task('pt_h2_lcao_transport.py', folder='transport',
        #      deps='pt_h2_lcao_manual.py')
        ]
