//
// Copyright 2014, Sander van Harmelen
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package main

var layout = apiInfo{
	"LoadBalancerService": {
		"createLoadBalancerRule",
		"deleteLoadBalancerRule",
		"removeFromLoadBalancerRule",
		"assignToLoadBalancerRule",
		"createLBStickinessPolicy",
		"updateLBStickinessPolicy",
		"deleteLBStickinessPolicy",
		"listLoadBalancerRules",
		"listLBStickinessPolicies",
		"listLBHealthCheckPolicies",
		"createLBHealthCheckPolicy",
		"updateLBHealthCheckPolicy",
		"deleteLBHealthCheckPolicy",
		"listLoadBalancerRuleInstances",
		"updateLoadBalancerRule",
		"uploadSslCert",
		"deleteSslCert",
		"listSslCerts",
		"assignCertToLoadBalancer",
		"removeCertFromLoadBalancer",
		"addNetscalerLoadBalancer",
		"deleteNetscalerLoadBalancer",
		"configureNetscalerLoadBalancer",
		"listNetscalerLoadBalancers",
		"createGlobalLoadBalancerRule",
		"deleteGlobalLoadBalancerRule",
		"updateGlobalLoadBalancerRule",
		"listGlobalLoadBalancerRules",
		"assignToGlobalLoadBalancerRule",
		"removeFromGlobalLoadBalancerRule",
		"createLoadBalancer",
		"listLoadBalancers",
		"deleteLoadBalancer",
		"updateLoadBalancer",
	},
	"NetworkService": {
		"dedicatePublicIpRange",
		"releasePublicIpRange",
		"createNetwork",
		"deleteNetwork",
		"listNetworks",
		"restartNetwork",
		"updateNetwork",
		"createPhysicalNetwork",
		"deletePhysicalNetwork",
		"listPhysicalNetworks",
		"updatePhysicalNetwork",
		"listSupportedNetworkServices",
		"addNetworkServiceProvider",
		"deleteNetworkServiceProvider",
		"listNetworkServiceProviders",
		"updateNetworkServiceProvider",
		"createStorageNetworkIpRange",
		"deleteStorageNetworkIpRange",
		"listStorageNetworkIpRange",
		"updateStorageNetworkIpRange",
		"listPaloAltoFirewallNetworks",
		"listNetscalerLoadBalancerNetworks",
		"listNiciraNvpDeviceNetworks",
		"listNetworkIsolationMethods",
		"addOpenDaylightController",
		"deleteOpenDaylightController",
		"listOpenDaylightControllers",
	},
	"VirtualMachineService": {
		"deployVirtualMachine",
		"destroyVirtualMachine",
		"rebootVirtualMachine",
		"startVirtualMachine",
		"stopVirtualMachine",
		"resetPasswordForVirtualMachine",
		"updateVirtualMachine",
		"listVirtualMachines",
		"getVMPassword",
		"restoreVirtualMachine",
		"changeServiceForVirtualMachine",
		"scaleVirtualMachine",
		"assignVirtualMachine",
		"migrateVirtualMachine",
		"migrateVirtualMachineWithVolume",
		"recoverVirtualMachine",
		"expungeVirtualMachine",
		"cleanVMReservations",
		"addNicToVirtualMachine",
		"removeNicFromVirtualMachine",
		"updateDefaultNicForVirtualMachine",
	},
	"VPNService": {
		"createRemoteAccessVpn",
		"deleteRemoteAccessVpn",
		"listRemoteAccessVpns",
		"updateRemoteAccessVpn",
		"addVpnUser",
		"removeVpnUser",
		"listVpnUsers",
		"createVpnCustomerGateway",
		"createVpnGateway",
		"createVpnConnection",
		"deleteVpnCustomerGateway",
		"deleteVpnGateway",
		"deleteVpnConnection",
		"updateVpnCustomerGateway",
		"resetVpnConnection",
		"listVpnCustomerGateways",
		"listVpnGateways",
		"listVpnConnections",
		"updateVpnConnection",
		"updateVpnGateway",
	},
	"FirewallService": {
		"listPortForwardingRules",
		"createPortForwardingRule",
		"deletePortForwardingRule",
		"updatePortForwardingRule",
		"createFirewallRule",
		"deleteFirewallRule",
		"listFirewallRules",
		"updateFirewallRule",
		"createEgressFirewallRule",
		"deleteEgressFirewallRule",
		"listEgressFirewallRules",
		"updateEgressFirewallRule",
		"addPaloAltoFirewall",
		"deletePaloAltoFirewall",
		"configurePaloAltoFirewall",
		"listPaloAltoFirewalls",
	},
	"AutoScaleService": {
		"createCounter",
		"createCondition",
		"createAutoScalePolicy",
		"createAutoScaleVmProfile",
		"createAutoScaleVmGroup",
		"deleteCounter",
		"deleteCondition",
		"deleteAutoScalePolicy",
		"deleteAutoScaleVmProfile",
		"deleteAutoScaleVmGroup",
		"listCounters",
		"listConditions",
		"listAutoScalePolicies",
		"listAutoScaleVmProfiles",
		"listAutoScaleVmGroups",
		"enableAutoScaleVmGroup",
		"disableAutoScaleVmGroup",
		"updateAutoScalePolicy",
		"updateAutoScaleVmProfile",
		"updateAutoScaleVmGroup",
	},
	"VolumeService": {
		"attachVolume",
		"uploadVolume",
		"detachVolume",
		"createVolume",
		"deleteVolume",
		"listVolumes",
		"extractVolume",
		"migrateVolume",
		"resizeVolume",
		"updateVolume",
		"getSolidFireVolumeSize",
		"getSolidFireVolumeAccessGroupId",
		"getSolidFireVolumeIscsiName",
		"getUploadParamsForVolume",
	},
	"HostService": {
		"addHost",
		"reconnectHost",
		"updateHost",
		"deleteHost",
		"prepareHostForMaintenance",
		"cancelHostMaintenance",
		"listHosts",
		"listHostTags",
		"findHostsForMigration",
		"addSecondaryStorage",
		"updateHostPassword",
		"releaseHostReservation",
		"addBaremetalHost",
		"dedicateHost",
		"releaseDedicatedHost",
		"listDedicatedHosts",
		"addGloboDnsHost",
	},
	"VPCService": {
		"createVPC",
		"listVPCs",
		"deleteVPC",
		"updateVPC",
		"restartVPC",
		"createVPCOffering",
		"updateVPCOffering",
		"deleteVPCOffering",
		"listVPCOfferings",
		"createPrivateGateway",
		"listPrivateGateways",
		"deletePrivateGateway",
		"createStaticRoute",
		"deleteStaticRoute",
		"listStaticRoutes",
	},
	"TemplateService": {
		"createTemplate",
		"registerTemplate",
		"updateTemplate",
		"copyTemplate",
		"deleteTemplate",
		"listTemplates",
		"updateTemplatePermissions",
		"listTemplatePermissions",
		"extractTemplate",
		"prepareTemplate",
		"upgradeRouterTemplate",
		"getUploadParamsForTemplate",
	},
	"AccountService": {
		"createAccount",
		"deleteAccount",
		"updateAccount",
		"disableAccount",
		"enableAccount",
		"lockAccount",
		"listAccounts",
		"markDefaultZoneForAccount",
		"addAccountToProject",
		"deleteAccountFromProject",
		"listProjectAccounts",
		"getSolidFireAccountId",
	},
	"UserService": {
		"createUser",
		"deleteUser",
		"updateUser",
		"listUsers",
		"lockUser",
		"disableUser",
		"enableUser",
		"getUser",
		"getVirtualMachineUserData",
		"registerUserKeys",
		"listLdapUsers",
		"importLdapUsers",
	},
	"UsageService": {
		"addTrafficType",
		"deleteTrafficType",
		"listTrafficTypes",
		"updateTrafficType",
		"listTrafficTypeImplementors",
		"generateUsageRecords",
		"listUsageRecords",
		"listUsageTypes",
		"removeRawUsageRecords",
		"addTrafficMonitor",
		"deleteTrafficMonitor",
		"listTrafficMonitors",
	},
	"SnapshotService": {
		"createSnapshot",
		"listSnapshots",
		"deleteSnapshot",
		"createSnapshotPolicy",
		"updateSnapshotPolicy",
		"deleteSnapshotPolicies",
		"listSnapshotPolicies",
		"revertSnapshot",
		"listVMSnapshot",
		"createVMSnapshot",
		"deleteVMSnapshot",
		"revertToVMSnapshot",
	},
	"ZoneService": {
		"createZone",
		"updateZone",
		"deleteZone",
		"listZones",
		"dedicateZone",
		"releaseDedicatedZone",
		"listDedicatedZones",
	},
	"ISOService": {
		"attachIso",
		"detachIso",
		"listIsos",
		"registerIso",
		"updateIso",
		"deleteIso",
		"copyIso",
		"updateIsoPermissions",
		"listIsoPermissions",
		"extractIso",
	},
	"RouterService": {
		"startRouter",
		"rebootRouter",
		"stopRouter",
		"destroyRouter",
		"changeServiceForRouter",
		"listRouters",
		"listVirtualRouterElements",
		"configureVirtualRouterElement",
		"createVirtualRouterElement",
	},
	"ProjectService": {
		"createProject",
		"deleteProject",
		"updateProject",
		"activateProject",
		"suspendProject",
		"listProjects",
		"listProjectInvitations",
		"updateProjectInvitation",
		"deleteProjectInvitation",
	},
	"PoolService": {
		"listStoragePools",
		"createStoragePool",
		"updateStoragePool",
		"deleteStoragePool",
		"findStoragePoolsForMigration",
	},
	"NetworkACLService": {
		"createNetworkACL",
		"updateNetworkACLItem",
		"deleteNetworkACL",
		"listNetworkACLs",
		"createNetworkACLList",
		"deleteNetworkACLList",
		"replaceNetworkACLList",
		"listNetworkACLLists",
		"updateNetworkACLList",
	},
	"GuestOSService": {
		"listOsTypes",
		"listOsCategories",
		"addGuestOs",
		"updateGuestOs",
		"removeGuestOs",
		"listGuestOsMapping",
		"addGuestOsMapping",
		"updateGuestOsMapping",
		"removeGuestOsMapping",
	},
	"SystemVMService": {
		"startSystemVm",
		"rebootSystemVm",
		"stopSystemVm",
		"destroySystemVm",
		"listSystemVms",
		"migrateSystemVm",
		"changeServiceForSystemVm",
		"scaleSystemVm",
	},
	"ImageStoreService": {
		"addImageStore",
		"addImageStoreS3",
		"listImageStores",
		"deleteImageStore",
		"createSecondaryStagingStore",
		"listSecondaryStagingStores",
		"deleteSecondaryStagingStore",
		"updateCloudToUseObjectStore",
	},
	"BaremetalService": {
		"addBaremetalPxeKickStartServer",
		"addBaremetalPxePingServer",
		"addBaremetalDhcp",
		"listBaremetalDhcp",
		"listBaremetalPxeServers",
		"addBaremetalRct",
		"deleteBaremetalRct",
		"listBaremetalRct",
	},
	"AuthenticationService": {
		"login",
		"logout",
	},
	"SecurityGroupService": {
		"createSecurityGroup",
		"deleteSecurityGroup",
		"authorizeSecurityGroupIngress",
		"revokeSecurityGroupIngress",
		"authorizeSecurityGroupEgress",
		"revokeSecurityGroupEgress",
		"listSecurityGroups",
	},
	"QuotaService": {
		"quotaIsEnabled",
	},
	"PodService": {
		"createPod",
		"updatePod",
		"deletePod",
		"listPods",
		"dedicatePod",
		"releaseDedicatedPod",
		"listDedicatedPods",
	},
	"ConfigurationService": {
		"updateConfiguration",
		"listConfigurations",
		"listCapabilities",
		"listDeploymentPlanners",
		"listLdapConfigurations",
		"addLdapConfiguration",
		"deleteLdapConfiguration",
	},
	"ClusterService": {
		"addCluster",
		"deleteCluster",
		"updateCluster",
		"listClusters",
		"dedicateCluster",
		"releaseDedicatedCluster",
		"listDedicatedClusters",
	},
	"VLANService": {
		"createVlanIpRange",
		"deleteVlanIpRange",
		"listVlanIpRanges",
		"dedicateGuestVlanRange",
		"releaseDedicatedGuestVlanRange",
		"listDedicatedGuestVlanRanges",
	},
	"InternalLBService": {
		"configureInternalLoadBalancerElement",
		"createInternalLoadBalancerElement",
		"listInternalLoadBalancerElements",
		"stopInternalLoadBalancerVM",
		"startInternalLoadBalancerVM",
		"listInternalLoadBalancerVMs",
	},
	"DomainService": {
		"createDomain",
		"updateDomain",
		"deleteDomain",
		"listDomains",
		"listDomainChildren",
		"linkDomainToLdap",
	},
	"UCSService": {
		"addUcsManager",
		"listUcsManagers",
		"listUcsProfiles",
		"listUcsBlades",
		"associateUcsProfileToBlade",
	},
	"SSHService": {
		"resetSSHKeyForVirtualMachine",
		"registerSSHKeyPair",
		"createSSHKeyPair",
		"deleteSSHKeyPair",
		"listSSHKeyPairs",
	},
	"NATService": {
		"enableStaticNat",
		"createIpForwardingRule",
		"deleteIpForwardingRule",
		"listIpForwardingRules",
		"disableStaticNat",
	},
	"LimitService": {
		"updateResourceLimit",
		"updateResourceCount",
		"listResourceLimits",
		"getApiLimit",
		"resetApiLimit",
	},
	"AffinityGroupService": {
		"createAffinityGroup",
		"deleteAffinityGroup",
		"listAffinityGroups",
		"updateVMAffinityGroup",
		"listAffinityGroupTypes",
	},
	"VMGroupService": {
		"createInstanceGroup",
		"deleteInstanceGroup",
		"updateInstanceGroup",
		"listInstanceGroups",
	},
	"ServiceOfferingService": {
		"createServiceOffering",
		"deleteServiceOffering",
		"updateServiceOffering",
		"listServiceOfferings",
	},
	"ResourcetagsService": {
		"listStorageTags",
		"createTags",
		"deleteTags",
		"listTags",
	},
	"RegionService": {
		"addRegion",
		"updateRegion",
		"removeRegion",
		"listRegions",
	},
	"NicService": {
		"addIpToNic",
		"removeIpFromNic",
		"updateVmNicIp",
		"listNics",
	},
	"NetworkOfferingService": {
		"createNetworkOffering",
		"updateNetworkOffering",
		"deleteNetworkOffering",
		"listNetworkOfferings",
	},
	"EventService": {
		"listEvents",
		"listEventTypes",
		"archiveEvents",
		"deleteEvents",
	},
	"DiskOfferingService": {
		"createDiskOffering",
		"updateDiskOffering",
		"deleteDiskOffering",
		"listDiskOfferings",
	},
	"AlertService": {
		"listAlerts",
		"archiveAlerts",
		"deleteAlerts",
		"generateAlert",
	},
	"AddressService": {
		"associateIpAddress",
		"disassociateIpAddress",
		"listPublicIpAddresses",
		"updateIpAddress",
	},
	"StoragePoolService": {
		"listStorageProviders",
		"enableStorageMaintenance",
		"cancelStorageMaintenance",
	},
	"ResourcemetadataService": {
		"addResourceDetail",
		"removeResourceDetail",
		"listResourceDetails",
	},
	"PortableIPService": {
		"createPortableIpRange",
		"deletePortableIpRange",
		"listPortableIpRanges",
	},
	"NiciraNVPService": {
		"addNiciraNvpDevice",
		"deleteNiciraNvpDevice",
		"listNiciraNvpDevices",
	},
	"NetworkDeviceService": {
		"addNetworkDevice",
		"listNetworkDevice",
		"deleteNetworkDevice",
	},
	"HypervisorService": {
		"listHypervisors",
		"updateHypervisorCapabilities",
		"listHypervisorCapabilities",
	},
	"SwiftService": {
		"addSwift",
		"listSwifts",
	},
	"OvsElementService": {
		"configureOvsElement",
		"listOvsElements",
	},
	"AsyncjobService": {
		"queryAsyncJobResult",
		"listAsyncJobs",
	},
	"SystemCapacityService": {
		"listCapacity",
	},
	"LDAPService": {
		"ldapCreateAccount",
	},
	"CloudIdentifierService": {
		"getCloudIdentifier",
	},
	"CertificateService": {
		"uploadCustomCertificate",
	},
	"APIDiscoveryService": {
		"listApis",
	},
	"StratosphereSSPService": {
		"addStratosphereSsp",
	},
}

const api = `{
  "listapisresponse": {
    "api": [
      {
        "description": "Creates VPC offering",
        "isasync": true,
        "name": "createVPCOffering",
        "params": [
          {
            "description": "the name of the vpc offering",
            "length": 255,
            "name": "name",
            "required": true,
            "type": "string"
          },
          {
            "description": "desired service capabilities as part of vpc offering",
            "length": 255,
            "name": "servicecapabilitylist",
            "required": false,
            "since": "4.4",
            "type": "map"
          },
          {
            "description": "the display text of the vpc offering",
            "length": 255,
            "name": "displaytext",
            "required": true,
            "type": "string"
          },
          {
            "description": "services supported by the vpc offering",
            "length": 255,
            "name": "supportedservices",
            "required": true,
            "type": "list"
          },
          {
            "description": "provider to service mapping. If not specified, the provider for the service will be mapped to the default provider on the physical network",
            "length": 255,
            "name": "serviceproviderlist",
            "required": false,
            "type": "map"
          },
          {
            "description": "the ID of the service offering for the VPC router appliance",
            "length": 255,
            "name": "serviceofferingid",
            "related": "updateServiceOffering,listServiceOfferings,createServiceOffering",
            "required": false,
            "type": "uuid"
          }
        ],
        "related": "listVPCOfferings,updateVPCOffering",
        "response": [
          {
            "description": "the id of the vpc offering",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the list of supported services",
            "name": "service",
            "response": [
              {
                "description": "the service name",
                "name": "name",
                "type": "string"
              },
              {
                "description": "the list of capabilities",
                "name": "capability",
                "response": [
                  {
                    "description": "the capability name",
                    "name": "name",
                    "type": "string"
                  },
                  {
                    "description": "the capability value",
                    "name": "value",
                    "type": "string"
                  },
                  {
                    "description": "can this service capability value can be choosable while creatine network offerings",
                    "name": "canchooseservicecapability",
                    "type": "boolean"
                  }
                ],
                "type": "list"
              },
              {
                "description": "the service provider name",
                "name": "provider",
                "response": [
                  {
                    "description": "the destination physical network",
                    "name": "destinationphysicalnetworkid",
                    "type": "string"
                  },
                  {
                    "description": "uuid of the network provider",
                    "name": "id",
                    "type": "string"
                  },
                  {
                    "description": "true if individual services can be enabled/disabled",
                    "name": "canenableindividualservice",
                    "type": "boolean"
                  },
                  {
                    "description": "the physical network this belongs to",
                    "name": "physicalnetworkid",
                    "type": "string"
                  },
                  {
                    "description": "state of the network provider",
                    "name": "state",
                    "type": "string"
                  },
                  {
                    "description": "the provider name",
                    "name": "name",
                    "type": "string"
                  },
                  {
                    "description": "services for this provider",
                    "name": "servicelist",
                    "type": "list"
                  }
                ],
                "type": "list"
              }
            ],
            "type": "list"
          },
          {
            "description": "an alternate display text of the vpc offering.",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": " indicates if the vpc offering supports distributed router for one-hop forwarding",
            "name": "distributedvpcrouter",
            "type": "boolean"
          },
          {
            "description": "true if vpc offering is default, false otherwise",
            "name": "isdefault",
            "type": "boolean"
          },
          {
            "description": "the name of the vpc offering",
            "name": "name",
            "type": "string"
          },
          {
            "description": "state of the vpc offering. Can be Disabled/Enabled",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the date this vpc offering was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": " indicated if the offering can support region level vpc",
            "name": "supportsregionLevelvpc",
            "type": "boolean"
          }
        ]
      },
      {
        "description": "Creates an account from an LDAP user",
        "isasync": false,
        "name": "ldapCreateAccount",
        "params": [
          {
            "description": "User UUID, required for adding account from external provisioning system",
            "length": 255,
            "name": "userid",
            "required": false,
            "type": "string"
          },
          {
            "description": "Specifies a timezone for this command. For more information on the timezone parameter, see Time Zone Format.",
            "length": 255,
            "name": "timezone",
            "required": false,
            "type": "string"
          },
          {
            "description": "Account UUID, required for adding account from external provisioning system",
            "length": 255,
            "name": "accountid",
            "required": false,
            "type": "string"
          },
          {
            "description": "Type of the account.  Specify 0 for user, 1 for root admin, and 2 for domain admin",
            "length": 255,
            "name": "accounttype",
            "required": true,
            "type": "short"
          },
          {
            "description": "Network domain for the account's networks",
            "length": 255,
            "name": "networkdomain",
            "required": false,
            "type": "string"
          },
          {
            "description": "Unique username.",
            "length": 255,
            "name": "username",
            "required": true,
            "type": "string"
          },
          {
            "description": "Creates the user under the specified account. If no account is specified, the username will be used as the account name.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "details for account used to store specific parameters",
            "length": 255,
            "name": "accountdetails",
            "required": false,
            "type": "map"
          },
          {
            "description": "Creates the user under the specified domain.",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain,updateDomain",
            "required": false,
            "type": "uuid"
          }
        ],
        "related": "enableAccount,listAccounts,lockAccount,disableAccount,listAccounts,markDefaultZoneForAccount,createAccount,updateAccount",
        "response": [
          {
            "description": "the total number of templates which have been created by this account",
            "name": "templatetotal",
            "type": "long"
          },
          {
            "description": "the total number of virtual machines deployed by this account",
            "name": "vmtotal",
            "type": "long"
          },
          {
            "description": "name of the Domain the account belongs too",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the total memory (in MB) the account can own",
            "name": "memorylimit",
            "type": "string"
          },
          {
            "description": "the total number of public ip addresses allocated for this account",
            "name": "iptotal",
            "type": "long"
          },
          {
            "description": "the total number of networks available to be created for this account",
            "name": "networkavailable",
            "type": "string"
          },
          {
            "description": "the total number of vpcs the account can own",
            "name": "vpclimit",
            "type": "string"
          },
          {
            "description": "id of the Domain the account belongs too",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the total number of templates available to be created by this account",
            "name": "templateavailable",
            "type": "string"
          },
          {
            "description": "the total volume which can be used by this account",
            "name": "volumelimit",
            "type": "string"
          },
          {
            "description": "the total number of virtual machines running for this account",
            "name": "vmrunning",
            "type": "integer"
          },
          {
            "description": "the total number of public ip addresses available for this account to acquire",
            "name": "ipavailable",
            "type": "string"
          },
          {
            "description": "true if account is default, false otherwise",
            "name": "isdefault",
            "type": "boolean"
          },
          {
            "description": "the list of acl groups that account belongs to",
            "name": "groups",
            "type": "list"
          },
          {
            "description": "the total primary storage space (in GiB) available to be used for this account",
            "name": "primarystorageavailable",
            "type": "string"
          },
          {
            "description": "the total number of cpu cores the account can own",
            "name": "cpulimit",
            "type": "string"
          },
          {
            "description": "the id of the account",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the total number of projects being administrated by this account",
            "name": "projecttotal",
            "type": "long"
          },
          {
            "description": "the total number of projects available for administration by this account",
            "name": "projectavailable",
            "type": "string"
          },
          {
            "description": "the name of the account",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the total number of vpcs available to be created for this account",
            "name": "vpcavailable",
            "type": "string"
          },
          {
            "description": "the total secondary storage space (in GiB) the account can own",
            "name": "secondarystoragelimit",
            "type": "string"
          },
          {
            "description": "the total number of network traffic bytes sent",
            "name": "sentbytes",
            "type": "long"
          },
          {
            "description": "the state of the account",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the total number of snapshots stored by this account",
            "name": "snapshottotal",
            "type": "long"
          },
          {
            "description": "the total secondary storage space (in GiB) available to be used for this account",
            "name": "secondarystorageavailable",
            "type": "string"
          },
          {
            "description": "the total number of virtual machines stopped for this account",
            "name": "vmstopped",
            "type": "integer"
          },
          {
            "description": "the total primary storage space (in GiB) owned by account",
            "name": "primarystoragetotal",
            "type": "long"
          },
          {
            "description": "the total number of networks the account can own",
            "name": "networklimit",
            "type": "string"
          },
          {
            "description": "the total volume being used by this account",
            "name": "volumetotal",
            "type": "long"
          },
          {
            "description": "the total primary storage space (in GiB) the account can own",
            "name": "primarystoragelimit",
            "type": "string"
          },
          {
            "description": "the total number of virtual machines available for this account to acquire",
            "name": "vmavailable",
            "type": "string"
          },
          {
            "description": "the total number of virtual machines that can be deployed by this account",
            "name": "vmlimit",
            "type": "string"
          },
          {
            "description": "the total number of networks owned by account",
            "name": "networktotal",
            "type": "long"
          },
          {
            "description": "true if the account requires cleanup",
            "name": "iscleanuprequired",
            "type": "boolean"
          },
          {
            "description": "the total number of public ip addresses this account can acquire",
            "name": "iplimit",
            "type": "string"
          },
          {
            "description": "the list of users associated with account",
            "name": "user",
            "response": [
              {
                "description": "the secret key of the user",
                "name": "secretkey",
                "type": "string"
              },
              {
                "description": "the account type of the user",
                "name": "accounttype",
                "type": "short"
              },
              {
                "description": "the user firstname",
                "name": "firstname",
                "type": "string"
              },
              {
                "description": "the api key of the user",
                "name": "apikey",
                "type": "string"
              },
              {
                "description": "the account name of the user",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the timezone user was created in",
                "name": "timezone",
                "type": "string"
              },
              {
                "description": "the domain ID of the user",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the user email address",
                "name": "email",
                "type": "string"
              },
              {
                "description": "the date and time the user account was created",
                "name": "created",
                "type": "date"
              },
              {
                "description": "the user ID",
                "name": "id",
                "type": "string"
              },
              {
                "description": "the boolean value representing if the updating target is in caller's child domain",
                "name": "iscallerchilddomain",
                "type": "boolean"
              },
              {
                "description": "the user name",
                "name": "username",
                "type": "string"
              },
              {
                "description": "the domain name of the user",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "the user lastname",
                "name": "lastname",
                "type": "string"
              },
              {
                "description": "the user state",
                "name": "state",
                "type": "string"
              },
              {
                "description": "the account ID of the user",
                "name": "accountid",
                "type": "string"
              },
              {
                "description": "true if user is default, false otherwise",
                "name": "isdefault",
                "type": "boolean"
              }
            ],
            "type": "list"
          },
          {
            "description": "the total number of cpu cores available to be created for this account",
            "name": "cpuavailable",
            "type": "string"
          },
          {
            "description": "account type (admin, domain-admin, user)",
            "name": "accounttype",
            "type": "short"
          },
          {
            "description": "the total number of network traffic bytes received",
            "name": "receivedbytes",
            "type": "long"
          },
          {
            "description": "the total secondary storage space (in GiB) owned by account",
            "name": "secondarystoragetotal",
            "type": "long"
          },
          {
            "description": "the total number of snapshots which can be stored by this account",
            "name": "snapshotlimit",
            "type": "string"
          },
          {
            "description": "the total memory (in MB) available to be created for this account",
            "name": "memoryavailable",
            "type": "string"
          },
          {
            "description": "the network domain",
            "name": "networkdomain",
            "type": "string"
          },
          {
            "description": "the default zone of the account",
            "name": "defaultzoneid",
            "type": "string"
          },
          {
            "description": "the total number of projects the account can own",
            "name": "projectlimit",
            "type": "string"
          },
          {
            "description": "the total number of templates which can be created by this account",
            "name": "templatelimit",
            "type": "string"
          },
          {
            "description": "the total number of cpu cores owned by account",
            "name": "cputotal",
            "type": "long"
          },
          {
            "description": "the total number of snapshots available for this account",
            "name": "snapshotavailable",
            "type": "string"
          },
          {
            "description": "details for the account",
            "name": "accountdetails",
            "type": "map"
          },
          {
            "description": "the total volume available for this account",
            "name": "volumeavailable",
            "type": "string"
          },
          {
            "description": "the total number of vpcs owned by account",
            "name": "vpctotal",
            "type": "long"
          },
          {
            "description": "the total memory (in MB) owned by account",
            "name": "memorytotal",
            "type": "long"
          }
        ],
        "since": "4.2.0"
      },
      {
        "description": "Creates a new Pod.",
        "isasync": false,
        "name": "createPod",
        "params": [
          {
            "description": "the ending IP address for the Pod",
            "length": 255,
            "name": "endip",
            "required": false,
            "type": "string"
          },
          {
            "description": "the name of the Pod",
            "length": 255,
            "name": "name",
            "required": true,
            "type": "string"
          },
          {
            "description": "the starting IP address for the Pod",
            "length": 255,
            "name": "startip",
            "required": true,
            "type": "string"
          },
          {
            "description": "the Zone ID in which the Pod will be created",
            "length": 255,
            "name": "zoneid",
            "related": "createZone,updateZone,listZones,listZones",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "the gateway for the Pod",
            "length": 255,
            "name": "gateway",
            "required": true,
            "type": "string"
          },
          {
            "description": "the netmask for the Pod",
            "length": 255,
            "name": "netmask",
            "required": true,
            "type": "string"
          },
          {
            "description": "Allocation state of this Pod for allocation of new resources",
            "length": 255,
            "name": "allocationstate",
            "required": false,
            "type": "string"
          }
        ],
        "related": "updatePod,listPods",
        "response": [
          {
            "description": "the capacity of the Pod",
            "name": "capacity",
            "response": [
              {
                "description": "the Zone ID",
                "name": "zoneid",
                "type": "string"
              },
              {
                "description": "the Cluster ID",
                "name": "clusterid",
                "type": "string"
              },
              {
                "description": "the Pod ID",
                "name": "podid",
                "type": "string"
              },
              {
                "description": "the Cluster name",
                "name": "clustername",
                "type": "string"
              },
              {
                "description": "the percentage of capacity currently in use",
                "name": "percentused",
                "type": "string"
              },
              {
                "description": "the Pod name",
                "name": "podname",
                "type": "string"
              },
              {
                "description": "the total capacity available",
                "name": "capacitytotal",
                "type": "long"
              },
              {
                "description": "the capacity type",
                "name": "type",
                "type": "short"
              },
              {
                "description": "the Zone name",
                "name": "zonename",
                "type": "string"
              },
              {
                "description": "the capacity currently in use",
                "name": "capacityused",
                "type": "long"
              }
            ],
            "type": "list"
          },
          {
            "description": "the starting IP for the Pod",
            "name": "startip",
            "type": "string"
          },
          {
            "description": "the ending IP for the Pod",
            "name": "endip",
            "type": "string"
          },
          {
            "description": "the Zone ID of the Pod",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the gateway of the Pod",
            "name": "gateway",
            "type": "string"
          },
          {
            "description": "the netmask of the Pod",
            "name": "netmask",
            "type": "string"
          },
          {
            "description": "the allocation state of the Pod",
            "name": "allocationstate",
            "type": "string"
          },
          {
            "description": "the Zone name of the Pod",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the ID of the Pod",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the name of the Pod",
            "name": "name",
            "type": "string"
          }
        ]
      },
      {
        "description": "Safely removes raw records from cloud_usage table",
        "isasync": false,
        "name": "removeRawUsageRecords",
        "params": [
          {
            "description": "Specify the number of days (greater than zero) to remove records that are older than those number of days from today. For example, specifying 10 would result in removing all the records created before 10 days from today",
            "length": 255,
            "name": "interval",
            "required": true,
            "type": "integer"
          }
        ],
        "response": [
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          },
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          }
        ],
        "since": "4.6.0"
      },
      {
        "description": "Copies an ISO from one zone to another.",
        "isasync": true,
        "name": "copyIso",
        "params": [
          {
            "description": "Template ID.",
            "length": 255,
            "name": "id",
            "related": "listIsos,registerIso,listTemplates,updateTemplate,copyTemplate,copyIso,registerTemplate,registerTemplate,prepareTemplate,listTemplates,createTemplate,updateIso,registerIso,createTemplate,copyTemplate,listIsos,copyIso",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "ID of the zone the template is currently hosted on. If not specified and template is cross-zone, then we will sync this template to region wide image store.",
            "length": 255,
            "name": "sourcezoneid",
            "related": "createZone,updateZone,listZones,listZones",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "ID of the zone the template is being copied to.",
            "length": 255,
            "name": "destzoneid",
            "related": "createZone,updateZone,listZones,listZones",
            "required": true,
            "type": "uuid"
          }
        ],
        "related": "listIsos,registerIso,listTemplates,updateTemplate,copyTemplate,registerTemplate,registerTemplate,prepareTemplate,listTemplates,createTemplate,updateIso,registerIso,createTemplate,copyTemplate,listIsos,copyIso",
        "response": [
          {
            "description": "the account name to which the template belongs",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the status of the template",
            "name": "status",
            "type": "string"
          },
          {
            "description": "the list of resource tags associated with tempate",
            "name": "tags",
            "response": [
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "true if template is sshkey enabled, false otherwise",
            "name": "sshkeyenabled",
            "type": "boolean"
          },
          {
            "description": "the ID of the secondary storage host for the template",
            "name": "hostid",
            "type": "string"
          },
          {
            "description": "the template ID of the parent template if present",
            "name": "sourcetemplateid",
            "type": "string"
          },
          {
            "description": "checksum of the template",
            "name": "checksum",
            "type": "string"
          },
          {
            "description": "true if the ISO is bootable, false otherwise",
            "name": "bootable",
            "type": "boolean"
          },
          {
            "description": "the ID of the domain to which the template belongs",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the format of the template.",
            "name": "format",
            "type": "imageformat"
          },
          {
            "description": "the template name",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the tag of this template",
            "name": "templatetag",
            "type": "string"
          },
          {
            "description": "true if this template is a featured template, false otherwise",
            "name": "isfeatured",
            "type": "boolean"
          },
          {
            "description": "the hypervisor on which the template runs",
            "name": "hypervisor",
            "type": "string"
          },
          {
            "description": "true if the reset password feature is enabled, false otherwise",
            "name": "passwordenabled",
            "type": "boolean"
          },
          {
            "description": "true if the template is extractable, false otherwise",
            "name": "isextractable",
            "type": "boolean"
          },
          {
            "description": "the date this template was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "true if template contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory",
            "name": "isdynamicallyscalable",
            "type": "boolean"
          },
          {
            "description": "the ID of the zone for this template",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the date this template was removed",
            "name": "removed",
            "type": "date"
          },
          {
            "description": "the size of the template",
            "name": "size",
            "type": "long"
          },
          {
            "description": "the project name of the template",
            "name": "project",
            "type": "string"
          },
          {
            "description": "true if the template is ready to be deployed from, false otherwise.",
            "name": "isready",
            "type": "boolean"
          },
          {
            "description": "true if the template is managed across all Zones, false otherwise",
            "name": "crossZones",
            "type": "boolean"
          },
          {
            "description": "the name of the zone for this template",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the template display text",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "the ID of the OS type for this template.",
            "name": "ostypeid",
            "type": "string"
          },
          {
            "description": "true if this template is a public template, false otherwise",
            "name": "ispublic",
            "type": "boolean"
          },
          {
            "description": "additional key/value details tied with template",
            "name": "details",
            "type": "map"
          },
          {
            "description": "the name of the OS type for this template.",
            "name": "ostypename",
            "type": "string"
          },
          {
            "description": "the account id to which the template belongs",
            "name": "accountid",
            "type": "string"
          },
          {
            "description": "the project id of the template",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the template ID",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the type of the template",
            "name": "templatetype",
            "type": "string"
          },
          {
            "description": "the name of the secondary storage host for the template",
            "name": "hostname",
            "type": "string"
          },
          {
            "description": "the name of the domain to which the template belongs",
            "name": "domain",
            "type": "string"
          }
        ]
      },
      {
        "description": "Deletes a autoscale vm profile.",
        "isasync": true,
        "name": "deleteAutoScaleVmProfile",
        "params": [
          {
            "description": "the ID of the autoscale profile",
            "length": 255,
            "name": "id",
            "related": "updateAutoScaleVmProfile,listAutoScaleVmProfiles,createAutoScaleVmProfile",
            "required": true,
            "type": "uuid"
          }
        ],
        "response": [
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          }
        ]
      },
      {
        "description": "Deletes a storage pool.",
        "isasync": false,
        "name": "deleteStoragePool",
        "params": [
          {
            "description": "Force destroy storage pool (force expunge volumes in Destroyed state as a part of pool removal)",
            "length": 255,
            "name": "forced",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "Storage pool id",
            "length": 255,
            "name": "id",
            "related": "cancelStorageMaintenance,enableStorageMaintenance,createStoragePool,listStoragePools,updateStoragePool,findStoragePoolsForMigration",
            "required": true,
            "type": "uuid"
          }
        ],
        "response": [
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          }
        ]
      },
      {
        "description": "Lists hosts.",
        "isasync": false,
        "name": "listHosts",
        "params": [
          {
            "description": "list hosts by resource state. Resource state represents current state determined by admin of host, valule can be one of [Enabled, Disabled, Unmanaged, PrepareForMaintenance, ErrorInMaintenance, Maintenance, Error]",
            "length": 255,
            "name": "resourcestate",
            "required": false,
            "type": "string"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "the state of the host",
            "length": 255,
            "name": "state",
            "required": false,
            "type": "string"
          },
          {
            "description": "the Zone ID for the host",
            "length": 255,
            "name": "zoneid",
            "related": "createZone,updateZone,listZones,listZones",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "if true, list only hosts dedicated to HA",
            "length": 255,
            "name": "hahost",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "hypervisor type of host: XenServer,KVM,VMware,Hyperv,BareMetal,Simulator",
            "length": 255,
            "name": "hypervisor",
            "required": false,
            "type": "string"
          },
          {
            "description": "the Pod ID for the host",
            "length": 255,
            "name": "podid",
            "related": "updatePod,listPods",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "comma separated list of host details requested, value can be a list of [ min, all, capacity, events, stats]",
            "length": 255,
            "name": "details",
            "required": false,
            "type": "list"
          },
          {
            "description": "the host type",
            "length": 255,
            "name": "type",
            "required": false,
            "type": "string"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "the id of the host",
            "length": 255,
            "name": "id",
            "related": "addHost,reconnectHost,addBaremetalHost,cancelHostMaintenance,updateHost,prepareHostForMaintenance,listHosts",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "lists hosts existing in particular cluster",
            "length": 255,
            "name": "clusterid",
            "related": "listClusters,addCluster,updateCluster",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "lists hosts in the same cluster as this VM and flag hosts with enough CPU/RAm to host this VM",
            "length": 255,
            "name": "virtualmachineid",
            "related": "stopVirtualMachine,changeServiceForVirtualMachine,listVirtualMachines,detachIso,updateVMAffinityGroup,revertToVMSnapshot,deployVirtualMachine,migrateVirtualMachine,rebootVirtualMachine,recoverVirtualMachine,updateDefaultNicForVirtualMachine,migrateVirtualMachineWithVolume,addNicToVirtualMachine,updateVmNicIp,startVirtualMachine,listVirtualMachines,updateVirtualMachine,destroyVirtualMachine,removeNicFromVirtualMachine,removeNicFromVirtualMachine,deployVirtualMachine,destroyVirtualMachine,addNicToVirtualMachine,updateVirtualMachine,rebootVirtualMachine,updateVMAffinityGroup,revertToVMSnapshot,attachIso,resetPasswordForVirtualMachine,assignVirtualMachine,restoreVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,resetSSHKeyForVirtualMachine,resetPasswordForVirtualMachine,detachIso,changeServiceForVirtualMachine,attachIso,updateDefaultNicForVirtualMachine,startVirtualMachine,stopVirtualMachine",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "the name of the host",
            "length": 255,
            "name": "name",
            "required": false,
            "type": "string"
          }
        ],
        "related": "addHost,reconnectHost,addBaremetalHost,cancelHostMaintenance,updateHost,prepareHostForMaintenance",
        "response": [
          {
            "description": "the name of the host",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the amount of the host's memory currently allocated",
            "name": "memoryallocated",
            "type": "long"
          },
          {
            "description": "comma-separated list of tags for the host",
            "name": "hosttags",
            "type": "string"
          },
          {
            "description": "the host version",
            "name": "version",
            "type": "string"
          },
          {
            "description": "the cluster type of the cluster that host belongs to",
            "name": "clustertype",
            "type": "string"
          },
          {
            "description": "capabilities of the host",
            "name": "capabilities",
            "type": "string"
          },
          {
            "description": "true if this host has enough CPU and RAM capacity to migrate a VM to it, false otherwise",
            "name": "hasenoughcapacity",
            "type": "boolean"
          },
          {
            "description": "Host details in key/value pairs.",
            "name": "details",
            "type": "map"
          },
          {
            "description": "the CPU number of the host",
            "name": "cpunumber",
            "type": "integer"
          },
          {
            "description": "events available for the host",
            "name": "events",
            "type": "string"
          },
          {
            "description": "true if this host is suitable(has enough capacity and satisfies all conditions like hosttags, max guests vm limit etc) to migrate a VM to it , false otherwise",
            "name": "suitableformigration",
            "type": "boolean"
          },
          {
            "description": "the CPU speed of the host",
            "name": "cpuspeed",
            "type": "long"
          },
          {
            "description": "the total disk size of the host",
            "name": "disksizetotal",
            "type": "long"
          },
          {
            "description": "GPU cards present in the host",
            "name": "gpugroup",
            "response": [
              {
                "description": "the list of enabled vGPUs",
                "name": "vgpu",
                "response": [
                  {
                    "description": "Remaining capacity in terms of no. of more VMs that can be deployped with this vGPU type",
                    "name": "remainingcapacity",
                    "type": "long"
                  },
                  {
                    "description": "Maximum X resolution per display",
                    "name": "maxresolutionx",
                    "type": "long"
                  },
                  {
                    "description": "Maximum no. of vgpu per gpu card (pgpu)",
                    "name": "maxvgpuperpgpu",
                    "type": "long"
                  },
                  {
                    "description": "Model Name of vGPU",
                    "name": "vgputype",
                    "type": "string"
                  },
                  {
                    "description": "Maximum vgpu can be created with this vgpu type on the given gpu group",
                    "name": "maxcapacity",
                    "type": "long"
                  },
                  {
                    "description": "Maximum Y resolution per display",
                    "name": "maxresolutiony",
                    "type": "long"
                  },
                  {
                    "description": "Video RAM for this vGPU type",
                    "name": "videoram",
                    "type": "long"
                  },
                  {
                    "description": "Maximum displays per user",
                    "name": "maxheads",
                    "type": "long"
                  }
                ],
                "type": "list"
              },
              {
                "description": "GPU cards present in the host",
                "name": "gpugroupname",
                "type": "string"
              }
            ],
            "type": "list"
          },
          {
            "description": "the date and time the host was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "the Zone ID of the host",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the amount of the host's memory currently used",
            "name": "memoryused",
            "type": "long"
          },
          {
            "description": "the date and time the host was last pinged",
            "name": "lastpinged",
            "type": "date"
          },
          {
            "description": "the state of the host",
            "name": "state",
            "type": "status"
          },
          {
            "description": "the amount of the host's CPU after applying the cpu.overprovisioning.factor ",
            "name": "cpuwithoverprovisioning",
            "type": "string"
          },
          {
            "description": "the host hypervisor",
            "name": "hypervisor",
            "type": "hypervisortype"
          },
          {
            "description": "the Pod name of the host",
            "name": "podname",
            "type": "string"
          },
          {
            "description": "the cluster ID of the host",
            "name": "clusterid",
            "type": "string"
          },
          {
            "description": "the IP address of the host",
            "name": "ipaddress",
            "type": "string"
          },
          {
            "description": "the incoming network traffic on the host",
            "name": "networkkbsread",
            "type": "long"
          },
          {
            "description": "true if local storage is active, false otherwise",
            "name": "islocalstorageactive",
            "type": "boolean"
          },
          {
            "description": "the outgoing network traffic on the host",
            "name": "networkkbswrite",
            "type": "long"
          },
          {
            "description": "the amount of the host's CPU currently allocated",
            "name": "cpuallocated",
            "type": "string"
          },
          {
            "description": "the amount of the host's CPU currently used",
            "name": "cpuused",
            "type": "string"
          },
          {
            "description": "the cpu average load on the host",
            "name": "averageload",
            "type": "long"
          },
          {
            "description": "the date and time the host was removed",
            "name": "removed",
            "type": "date"
          },
          {
            "description": "the host type",
            "name": "type",
            "type": "type"
          },
          {
            "description": "the Zone name of the host",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the Pod ID of the host",
            "name": "podid",
            "type": "string"
          },
          {
            "description": "the resource state of the host",
            "name": "resourcestate",
            "type": "string"
          },
          {
            "description": "the number of CPU sockets on the host",
            "name": "cpusockets",
            "type": "integer"
          },
          {
            "description": "true if the host is Ha host (dedicated to vms started by HA process; false otherwise",
            "name": "hahost",
            "type": "boolean"
          },
          {
            "description": "the OS category ID of the host",
            "name": "oscategoryid",
            "type": "string"
          },
          {
            "description": "the OS category name of the host",
            "name": "oscategoryname",
            "type": "string"
          },
          {
            "description": "the cluster name of the host",
            "name": "clustername",
            "type": "string"
          },
          {
            "description": "the management server ID of the host",
            "name": "managementserverid",
            "type": "long"
          },
          {
            "description": "the host's currently allocated disk size",
            "name": "disksizeallocated",
            "type": "long"
          },
          {
            "description": "the memory total of the host",
            "name": "memorytotal",
            "type": "long"
          },
          {
            "description": "the ID of the host",
            "name": "id",
            "type": "string"
          },
          {
            "description": "true if the host is disconnected. False otherwise.",
            "name": "disconnected",
            "type": "date"
          },
          {
            "description": "the hypervisor version",
            "name": "hypervisorversion",
            "type": "string"
          }
        ]
      },
      {
        "description": "Updates a storage pool.",
        "isasync": false,
        "name": "updateStoragePool",
        "params": [
          {
            "description": "bytes CloudStack can provision from this storage pool",
            "length": 255,
            "name": "capacitybytes",
            "required": false,
            "type": "long"
          },
          {
            "description": "false to disable the pool for allocation of new volumes, true to enable it back.",
            "length": 255,
            "name": "enabled",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "comma-separated list of tags for the storage pool",
            "length": 255,
            "name": "tags",
            "required": false,
            "type": "list"
          },
          {
            "description": "the Id of the storage pool",
            "length": 255,
            "name": "id",
            "related": "cancelStorageMaintenance,enableStorageMaintenance,createStoragePool,listStoragePools,updateStoragePool,findStoragePoolsForMigration",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "IOPS CloudStack can provision from this storage pool",
            "length": 255,
            "name": "capacityiops",
            "required": false,
            "type": "long"
          }
        ],
        "related": "cancelStorageMaintenance,enableStorageMaintenance,createStoragePool,listStoragePools,findStoragePoolsForMigration",
        "response": [
          {
            "description": "the scope of the storage pool",
            "name": "scope",
            "type": "string"
          },
          {
            "description": "the Zone ID of the storage pool",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the name of the storage pool",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the ID of the storage pool",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the ID of the cluster for the storage pool",
            "name": "clusterid",
            "type": "string"
          },
          {
            "description": "the host's currently used disk size",
            "name": "disksizeused",
            "type": "long"
          },
          {
            "description": "true if this pool is suitable to migrate a volume, false otherwise",
            "name": "suitableformigration",
            "type": "boolean"
          },
          {
            "description": "the tags for the storage pool",
            "name": "tags",
            "type": "string"
          },
          {
            "description": "the date and time the storage pool was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "the storage pool path",
            "name": "path",
            "type": "string"
          },
          {
            "description": "the total disk size of the storage pool",
            "name": "disksizetotal",
            "type": "long"
          },
          {
            "description": "the name of the cluster for the storage pool",
            "name": "clustername",
            "type": "string"
          },
          {
            "description": "the Zone name of the storage pool",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the state of the storage pool",
            "name": "state",
            "type": "storagepoolstatus"
          },
          {
            "description": "the overprovisionfactor for the storage pool",
            "name": "overprovisionfactor",
            "type": "string"
          },
          {
            "description": "the storage pool capabilities",
            "name": "storagecapabilities",
            "type": "map"
          },
          {
            "description": "the Pod name of the storage pool",
            "name": "podname",
            "type": "string"
          },
          {
            "description": "IOPS CloudStack can provision from this storage pool",
            "name": "capacityiops",
            "type": "long"
          },
          {
            "description": "the IP address of the storage pool",
            "name": "ipaddress",
            "type": "string"
          },
          {
            "description": "the Pod ID of the storage pool",
            "name": "podid",
            "type": "string"
          },
          {
            "description": "the hypervisor type of the storage pool",
            "name": "hypervisor",
            "type": "string"
          },
          {
            "description": "the storage pool type",
            "name": "type",
            "type": "string"
          },
          {
            "description": "the host's currently allocated disk size",
            "name": "disksizeallocated",
            "type": "long"
          }
        ],
        "since": "3.0.0"
      },
      {
        "description": "Reboots a system VM.",
        "isasync": true,
        "name": "rebootSystemVm",
        "params": [
          {
            "description": "The ID of the system virtual machine",
            "length": 255,
            "name": "id",
            "related": "migrateSystemVm,stopSystemVm,changeServiceForSystemVm,rebootSystemVm,destroySystemVm,scaleSystemVm,listSystemVms,startSystemVm",
            "required": true,
            "type": "uuid"
          }
        ],
        "related": "migrateSystemVm,stopSystemVm,changeServiceForSystemVm,destroySystemVm,scaleSystemVm,listSystemVms,startSystemVm",
        "response": [
          {
            "description": "the gateway for the system VM",
            "name": "gateway",
            "type": "string"
          },
          {
            "description": "the hypervisor on which the template runs",
            "name": "hypervisor",
            "type": "string"
          },
          {
            "description": "the link local MAC address for the system vm",
            "name": "linklocalmacaddress",
            "type": "string"
          },
          {
            "description": "the public MAC address for the system VM",
            "name": "publicmacaddress",
            "type": "string"
          },
          {
            "description": "the network domain for the system VM",
            "name": "networkdomain",
            "type": "string"
          },
          {
            "description": "the host ID for the system VM",
            "name": "hostid",
            "type": "string"
          },
          {
            "description": "the Pod ID for the system VM",
            "name": "podid",
            "type": "string"
          },
          {
            "description": "the date and time the system VM was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "the job status associated with the system VM.  This is only displayed if the router listed is part of a currently running asynchronous job.",
            "name": "jobstatus",
            "type": "integer"
          },
          {
            "description": "the private IP address for the system VM",
            "name": "privateip",
            "type": "string"
          },
          {
            "description": "the public IP address for the system VM",
            "name": "publicip",
            "type": "string"
          },
          {
            "description": "the job ID associated with the system VM. This is only displayed if the router listed is part of a currently running asynchronous job.",
            "name": "jobid",
            "type": "string"
          },
          {
            "description": "the link local IP address for the system vm",
            "name": "linklocalip",
            "type": "string"
          },
          {
            "description": "the number of active console sessions for the console proxy system vm",
            "name": "activeviewersessions",
            "type": "integer"
          },
          {
            "description": "the link local netmask for the system vm",
            "name": "linklocalnetmask",
            "type": "string"
          },
          {
            "description": "the Zone ID for the system VM",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the second DNS for the system VM",
            "name": "dns2",
            "type": "string"
          },
          {
            "description": "the name of the system VM",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the private MAC address for the system VM",
            "name": "privatemacaddress",
            "type": "string"
          },
          {
            "description": "the private netmask for the system VM",
            "name": "privatenetmask",
            "type": "string"
          },
          {
            "description": "the first DNS for the system VM",
            "name": "dns1",
            "type": "string"
          },
          {
            "description": "the system VM type",
            "name": "systemvmtype",
            "type": "string"
          },
          {
            "description": "the hostname for the system VM",
            "name": "hostname",
            "type": "string"
          },
          {
            "description": "the ID of the system VM",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the state of the system VM",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the Zone name for the system VM",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the template ID for the system VM",
            "name": "templateid",
            "type": "string"
          },
          {
            "description": "the public netmask for the system VM",
            "name": "publicnetmask",
            "type": "string"
          }
        ]
      },
      {
        "description": "Import LDAP users",
        "isasync": false,
        "name": "importLdapUsers",
        "params": [
          {
            "description": "Specifies the domain to which the ldap users are to be imported. If no domain is specified, a domain will created using group parameter. If the group is also not specified, a domain name based on the OU information will be created. If no OU hierarchy exists, will be defaulted to ROOT domain",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain,updateDomain",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "Specifies a timezone for this command. For more information on the timezone parameter, see Time Zone Format.",
            "length": 255,
            "name": "timezone",
            "required": false,
            "type": "string"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "Creates the user under the specified account. If no account is specified, the username will be used as the account name.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "details for account used to store specific parameters",
            "length": 255,
            "name": "accountdetails",
            "required": false,
            "type": "map"
          },
          {
            "description": "Specifies the group name from which the ldap users are to be imported. If no group is specified, all the users will be imported.",
            "length": 255,
            "name": "group",
            "required": false,
            "type": "string"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "Type of the account.  Specify 0 for user, 1 for root admin, and 2 for domain admin",
            "length": 255,
            "name": "accounttype",
            "required": true,
            "type": "short"
          }
        ],
        "related": "listLdapUsers,searchLdap",
        "response": [
          {
            "description": "The user's firstname",
            "name": "firstname",
            "type": "string"
          },
          {
            "description": "The user's username",
            "name": "username",
            "type": "string"
          },
          {
            "description": "The user's domain",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "The user's lastname",
            "name": "lastname",
            "type": "string"
          },
          {
            "description": "The user's principle",
            "name": "principal",
            "type": "string"
          },
          {
            "description": "The user's email",
            "name": "email",
            "type": "string"
          }
        ],
        "since": "4.3.0"
      },
      {
        "description": "List dedicated zones.",
        "isasync": false,
        "name": "listDedicatedZones",
        "params": [
          {
            "description": "the ID of the domain associated with the zone",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain,updateDomain",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "the ID of the Zone",
            "length": 255,
            "name": "zoneid",
            "related": "createZone,updateZone,listZones,listZones",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list dedicated zones by affinity group",
            "length": 255,
            "name": "affinitygroupid",
            "related": "listAffinityGroups,createAffinityGroup",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "the name of the account associated with the zone. Must be used with domainId.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          }
        ],
        "related": "dedicateZone",
        "response": [
          {
            "description": "the domain ID to which the Zone is dedicated",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the Dedication Affinity Group ID of the zone",
            "name": "affinitygroupid",
            "type": "string"
          },
          {
            "description": "the Name of the Zone",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the ID of the Zone",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the ID of the dedicated resource",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the Account Id to which the Zone is dedicated",
            "name": "accountid",
            "type": "string"
          }
        ]
      },
      {
        "description": "Lists all available networks.",
        "isasync": false,
        "name": "listNetworks",
        "params": [
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "list resources by account. Must be used with the domainId parameter.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "the zone ID of the network",
            "length": 255,
            "name": "zoneid",
            "related": "createZone,updateZone,listZones,listZones",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list networks by ID",
            "length": 255,
            "name": "id",
            "related": "createNetwork,listNetscalerLoadBalancerNetworks,listPaloAltoFirewallNetworks,listNetworks,listNiciraNvpDeviceNetworks,listNetworks,updateNetwork,updateNetwork,createNetwork",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "true if need to list only networks which support specifying IP ranges",
            "length": 255,
            "name": "specifyipranges",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "list networks available for VM deployment",
            "length": 255,
            "name": "canusefordeploy",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "the type of the network. Supported values are: isolated and shared",
            "length": 255,
            "name": "type",
            "required": false,
            "type": "string"
          },
          {
            "description": "list only resources belonging to the domain specified",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain,updateDomain",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "List resources by tags (key/value pairs)",
            "length": 255,
            "name": "tags",
            "required": false,
            "type": "map"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "true if network is system, false otherwise",
            "length": 255,
            "name": "issystem",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "list networks by ACL (access control list) type. Supported values are account and domain",
            "length": 255,
            "name": "acltype",
            "required": false,
            "type": "string"
          },
          {
            "description": "List networks by VPC",
            "length": 255,
            "name": "vpcid",
            "related": "createVPC,updateVPC,listVPCs,listVPCs,restartVPC,createVPC,updateVPC",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list networks by restartRequired",
            "length": 255,
            "name": "restartrequired",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "type of the traffic",
            "length": 255,
            "name": "traffictype",
            "required": false,
            "type": "string"
          },
          {
            "description": "list resources by display flag; only ROOT admin is eligible to pass this parameter",
            "length": 255,
            "name": "displaynetwork",
            "required": false,
            "since": "4.4",
            "type": "boolean"
          },
          {
            "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false",
            "length": 255,
            "name": "listall",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "list networks by physical network id",
            "length": 255,
            "name": "physicalnetworkid",
            "related": "createPhysicalNetwork,updatePhysicalNetwork,listPhysicalNetworks",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "the network belongs to VPC",
            "length": 255,
            "name": "forvpc",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "list objects by project",
            "length": 255,
            "name": "projectid",
            "related": "activateProject,createProject,updateProject,suspendProject,listProjectAccounts,listProjects",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list networks supporting certain services",
            "length": 255,
            "name": "supportedservices",
            "required": false,
            "type": "list"
          },
          {
            "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
            "length": 255,
            "name": "isrecursive",
            "required": false,
            "type": "boolean"
          }
        ],
        "related": "createNetwork,listNetscalerLoadBalancerNetworks,listPaloAltoFirewallNetworks,listNiciraNvpDeviceNetworks,listNetworks,updateNetwork,updateNetwork,createNetwork",
        "response": [
          {
            "description": "network offering id the network is created from",
            "name": "networkofferingid",
            "type": "string"
          },
          {
            "description": "the network domain",
            "name": "networkdomain",
            "type": "string"
          },
          {
            "description": "state of the network",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the type of the network",
            "name": "type",
            "type": "string"
          },
          {
            "description": "VPC the network belongs to",
            "name": "vpcid",
            "type": "string"
          },
          {
            "description": "Broadcast domain type of the network",
            "name": "broadcastdomaintype",
            "type": "string"
          },
          {
            "description": "true if network supports specifying ip ranges, false otherwise",
            "name": "specifyipranges",
            "type": "boolean"
          },
          {
            "description": "list networks available for vm deployment",
            "name": "canusefordeploy",
            "type": "boolean"
          },
          {
            "description": "name of the network offering the network is created from",
            "name": "networkofferingname",
            "type": "string"
          },
          {
            "description": "the domain id of the network owner",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "true if network is system, false otherwise",
            "name": "issystem",
            "type": "boolean"
          },
          {
            "description": "acl type - access type to the network",
            "name": "acltype",
            "type": "string"
          },
          {
            "description": "Cloudstack managed address space, all CloudStack managed VMs get IP address from CIDR",
            "name": "cidr",
            "type": "string"
          },
          {
            "description": "zone id of the network",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "ACL Id associated with the VPC network",
            "name": "aclid",
            "type": "string"
          },
          {
            "description": "the network's netmask",
            "name": "netmask",
            "type": "string"
          },
          {
            "description": "display text of the network offering the network is created from",
            "name": "networkofferingdisplaytext",
            "type": "string"
          },
          {
            "description": "availability of the network offering the network is created from",
            "name": "networkofferingavailability",
            "type": "string"
          },
          {
            "description": "related to what other network configuration",
            "name": "related",
            "type": "string"
          },
          {
            "description": "the domain name of the network owner",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "If a network is enabled for 'streched l2 subnet' then represents zones on which network currently spans",
            "name": "zonesnetworkspans",
            "type": "set"
          },
          {
            "description": "the traffic type of the network",
            "name": "traffictype",
            "type": "string"
          },
          {
            "description": "true if network offering is ip conserve mode enabled",
            "name": "networkofferingconservemode",
            "type": "boolean"
          },
          {
            "description": "the project name of the address",
            "name": "project",
            "type": "string"
          },
          {
            "description": "the network's gateway",
            "name": "gateway",
            "type": "string"
          },
          {
            "description": "the physical network id",
            "name": "physicalnetworkid",
            "type": "string"
          },
          {
            "description": "The vlan of the network. This parameter is visible to ROOT admins only",
            "name": "vlan",
            "type": "string"
          },
          {
            "description": "true if network is default, false otherwise",
            "name": "isdefault",
            "type": "boolean"
          },
          {
            "description": "broadcast uri of the network. This parameter is visible to ROOT admins only",
            "name": "broadcasturi",
            "type": "string"
          },
          {
            "description": "the displaytext of the network",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "the name of the network",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the first DNS for the network",
            "name": "dns1",
            "type": "string"
          },
          {
            "description": "the list of services",
            "name": "service",
            "response": [
              {
                "description": "the list of capabilities",
                "name": "capability",
                "response": [
                  {
                    "description": "the capability name",
                    "name": "name",
                    "type": "string"
                  },
                  {
                    "description": "can this service capability value can be choosable while creatine network offerings",
                    "name": "canchooseservicecapability",
                    "type": "boolean"
                  },
                  {
                    "description": "the capability value",
                    "name": "value",
                    "type": "string"
                  }
                ],
                "type": "list"
              },
              {
                "description": "the service name",
                "name": "name",
                "type": "string"
              },
              {
                "description": "the service provider name",
                "name": "provider",
                "response": [
                  {
                    "description": "state of the network provider",
                    "name": "state",
                    "type": "string"
                  },
                  {
                    "description": "the destination physical network",
                    "name": "destinationphysicalnetworkid",
                    "type": "string"
                  },
                  {
                    "description": "the provider name",
                    "name": "name",
                    "type": "string"
                  },
                  {
                    "description": "the physical network this belongs to",
                    "name": "physicalnetworkid",
                    "type": "string"
                  },
                  {
                    "description": "services for this provider",
                    "name": "servicelist",
                    "type": "list"
                  },
                  {
                    "description": "true if individual services can be enabled/disabled",
                    "name": "canenableindividualservice",
                    "type": "boolean"
                  },
                  {
                    "description": "uuid of the network provider",
                    "name": "id",
                    "type": "string"
                  }
                ],
                "type": "list"
              }
            ],
            "type": "list"
          },
          {
            "description": "the network CIDR of the guest network configured with IP reservation. It is the summation of CIDR and RESERVED_IP_RANGE",
            "name": "networkcidr",
            "type": "string"
          },
          {
            "description": "the gateway of IPv6 network",
            "name": "ip6gateway",
            "type": "string"
          },
          {
            "description": "the project id of the ipaddress",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "an optional field, whether to the display the network to the end user or not.",
            "name": "displaynetwork",
            "type": "boolean"
          },
          {
            "description": "list networks that are persistent",
            "name": "ispersistent",
            "type": "boolean"
          },
          {
            "description": "the name of the zone the network belongs to",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the list of resource tags associated with network",
            "name": "tags",
            "response": [
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              },
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              }
            ],
            "type": "list"
          },
          {
            "description": "the second DNS for the network",
            "name": "dns2",
            "type": "string"
          },
          {
            "description": "true if users from subdomains can access the domain level network",
            "name": "subdomainaccess",
            "type": "boolean"
          },
          {
            "description": "the cidr of IPv6 network",
            "name": "ip6cidr",
            "type": "string"
          },
          {
            "description": "true network requires restart",
            "name": "restartrequired",
            "type": "boolean"
          },
          {
            "description": "the network's IP range not to be used by CloudStack guest VMs and can be used for non CloudStack purposes",
            "name": "reservediprange",
            "type": "string"
          },
          {
            "description": "the owner of the network",
            "name": "account",
            "type": "string"
          },
          {
            "description": "true if network can span multiple zones",
            "name": "strechedl2subnet",
            "type": "boolean"
          },
          {
            "description": "the id of the network",
            "name": "id",
            "type": "string"
          }
        ]
      },
      {
        "description": "Updates firewall rule ",
        "isasync": true,
        "name": "updateFirewallRule",
        "params": [
          {
            "description": "an optional field, in case you want to set a custom id to the resource. Allowed to Root Admins only",
            "length": 255,
            "name": "customid",
            "required": false,
            "since": "4.4",
            "type": "string"
          },
          {
            "description": "the ID of the firewall rule",
            "length": 255,
            "name": "id",
            "related": "listIpForwardingRules,listPortForwardingRules,updatePortForwardingRule,createPortForwardingRule,createIpForwardingRule",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "an optional field, whether to the display the rule to the end user or not",
            "length": 255,
            "name": "fordisplay",
            "required": false,
            "since": "4.4",
            "type": "boolean"
          }
        ],
        "related": "listFirewallRules,updateEgressFirewallRule,listEgressFirewallRules,createFirewallRule,createEgressFirewallRule",
        "response": [
          {
            "description": "type of the icmp message being sent",
            "name": "icmptype",
            "type": "integer"
          },
          {
            "description": "the starting port of firewall rule's port range",
            "name": "startport",
            "type": "integer"
          },
          {
            "description": "error code for this icmp message",
            "name": "icmpcode",
            "type": "integer"
          },
          {
            "description": "the list of resource tags associated with the rule",
            "name": "tags",
            "response": [
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              },
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              }
            ],
            "type": "list"
          },
          {
            "description": "the state of the rule",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the protocol of the firewall rule",
            "name": "protocol",
            "type": "string"
          },
          {
            "description": "the public ip address for the firewall rule",
            "name": "ipaddress",
            "type": "string"
          },
          {
            "description": "is rule for display to the regular user",
            "name": "fordisplay",
            "type": "boolean"
          },
          {
            "description": "the ID of the firewall rule",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the ending port of firewall rule's port range",
            "name": "endport",
            "type": "integer"
          },
          {
            "description": "the network id of the firewall rule",
            "name": "networkid",
            "type": "string"
          },
          {
            "description": "the cidr list to forward traffic from",
            "name": "cidrlist",
            "type": "string"
          },
          {
            "description": "the public ip address id for the firewall rule",
            "name": "ipaddressid",
            "type": "string"
          }
        ],
        "since": "4.4"
      },
      {
        "description": "Return true if the plugin is enabled",
        "isasync": false,
        "name": "quotaIsEnabled",
        "params": [],
        "related": "",
        "response": [
          {
            "description": "is quota service enabled",
            "name": "isenabled",
            "type": "boolean"
          }
        ],
        "since": "4.7.0"
      },
      {
        "description": "List hypervisors",
        "isasync": false,
        "name": "listHypervisors",
        "params": [
          {
            "description": "the zone id for listing hypervisors.",
            "length": 255,
            "name": "zoneid",
            "related": "createZone,updateZone,listZones,listZones",
            "required": false,
            "type": "uuid"
          }
        ],
        "related": "",
        "response": [
          {
            "description": "Hypervisor name",
            "name": "name",
            "type": "string"
          }
        ]
      },
      {
        "description": "Deletes account from the project",
        "isasync": true,
        "name": "deleteAccountFromProject",
        "params": [
          {
            "description": "name of the account to be removed from the project",
            "length": 255,
            "name": "account",
            "required": true,
            "type": "string"
          },
          {
            "description": "ID of the project to remove the account from",
            "length": 255,
            "name": "projectid",
            "related": "activateProject,createProject,updateProject,suspendProject,listProjectAccounts,listProjects",
            "required": true,
            "type": "uuid"
          }
        ],
        "response": [
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          }
        ],
        "since": "3.0.0"
      },
      {
        "description": "Get the SF Volume Access Group ID",
        "isasync": false,
        "name": "getSolidFireVolumeAccessGroupId",
        "params": [
          {
            "description": "Cluster UUID",
            "length": 255,
            "name": "clusterid",
            "required": true,
            "type": "string"
          },
          {
            "description": "Storage Pool UUID",
            "length": 255,
            "name": "storageid",
            "required": true,
            "type": "string"
          }
        ],
        "related": "",
        "response": [
          {
            "description": "SolidFire Volume Access Group Id",
            "name": "solidFireVolumeAccessGroupId",
            "type": "long"
          }
        ]
      },
      {
        "description": "Updates the information about Guest OS",
        "isasync": true,
        "name": "updateGuestOs",
        "params": [
          {
            "description": "Unique display name for Guest OS",
            "length": 255,
            "name": "osdisplayname",
            "required": true,
            "type": "string"
          },
          {
            "description": "UUID of the Guest OS",
            "length": 255,
            "name": "id",
            "related": "addGuestOs,listOsTypes,updateGuestOs",
            "required": true,
            "type": "uuid"
          }
        ],
        "related": "addGuestOs,listOsTypes",
        "response": [
          {
            "description": "the name/description of the OS type",
            "name": "description",
            "type": "string"
          },
          {
            "description": "the ID of the OS type",
            "name": "id",
            "type": "string"
          },
          {
            "description": "is the guest OS user defined",
            "name": "isuserdefined",
            "type": "string"
          },
          {
            "description": "the ID of the OS category",
            "name": "oscategoryid",
            "type": "string"
          }
        ],
        "since": "4.4.0"
      },
      {
        "description": "Updates resource limits for an account or domain.",
        "isasync": false,
        "name": "updateResourceLimit",
        "params": [
          {
            "description": "Update resource for a specified account. Must be used with the domainId parameter.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "Type of resource to update. Values are 0, 1, 2, 3, 4, 6, 7, 8, 9, 10 and 11. 0 - Instance. Number of instances a user can create. 1 - IP. Number of public IP addresses a user can own. 2 - Volume. Number of disk volumes a user can create. 3 - Snapshot. Number of snapshots a user can create. 4 - Template. Number of templates that a user can register/create. 6 - Network. Number of guest network a user can create. 7 - VPC. Number of VPC a user can create. 8 - CPU. Total number of CPU cores a user can use. 9 - Memory. Total Memory (in MB) a user can use. 10 - PrimaryStorage. Total primary storage space (in GiB) a user can use. 11 - SecondaryStorage. Total secondary storage space (in GiB) a user can use. ",
            "length": 255,
            "name": "resourcetype",
            "required": true,
            "type": "integer"
          },
          {
            "description": "Update resource limits for project",
            "length": 255,
            "name": "projectid",
            "related": "activateProject,createProject,updateProject,suspendProject,listProjectAccounts,listProjects",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "  Maximum resource limit.",
            "length": 255,
            "name": "max",
            "required": false,
            "type": "long"
          },
          {
            "description": "Update resource limits for all accounts in specified domain. If used with the account parameter, updates resource limits for a specified account in specified domain.",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain,updateDomain",
            "required": false,
            "type": "uuid"
          }
        ],
        "related": "listResourceLimits",
        "response": [
          {
            "description": "the project name of the resource limit",
            "name": "project",
            "type": "string"
          },
          {
            "description": "the domain ID of the resource limit",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the project id of the resource limit",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the domain name of the resource limit",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the maximum number of the resource. A -1 means the resource currently has no limit.",
            "name": "max",
            "type": "long"
          },
          {
            "description": "resource type. Values include 0, 1, 2, 3, 4, 6, 7, 8, 9, 10, 11. See the resourceType parameter for more information on these values.",
            "name": "resourcetype",
            "type": "string"
          },
          {
            "description": "the account of the resource limit",
            "name": "account",
            "type": "string"
          }
        ]
      },
      {
        "description": "Deletes a static route",
        "isasync": true,
        "name": "deleteStaticRoute",
        "params": [
          {
            "description": "the ID of the static route",
            "length": 255,
            "name": "id",
            "related": "createStaticRoute,listStaticRoutes",
            "required": true,
            "type": "uuid"
          }
        ],
        "response": [
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          },
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          }
        ]
      },
      {
        "description": "Release the dedication for the pod",
        "isasync": true,
        "name": "releaseDedicatedPod",
        "params": [
          {
            "description": "the ID of the Pod",
            "length": 255,
            "name": "podid",
            "related": "updatePod,listPods",
            "required": true,
            "type": "uuid"
          }
        ],
        "response": [
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          },
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          }
        ]
      },
      {
        "description": "Lists affinity groups",
        "isasync": false,
        "name": "listAffinityGroups",
        "params": [
          {
            "description": "lists affinity groups by virtual machine ID",
            "length": 255,
            "name": "virtualmachineid",
            "related": "stopVirtualMachine,changeServiceForVirtualMachine,listVirtualMachines,detachIso,updateVMAffinityGroup,revertToVMSnapshot,deployVirtualMachine,migrateVirtualMachine,rebootVirtualMachine,recoverVirtualMachine,updateDefaultNicForVirtualMachine,migrateVirtualMachineWithVolume,addNicToVirtualMachine,updateVmNicIp,startVirtualMachine,listVirtualMachines,updateVirtualMachine,destroyVirtualMachine,removeNicFromVirtualMachine,removeNicFromVirtualMachine,deployVirtualMachine,destroyVirtualMachine,addNicToVirtualMachine,updateVirtualMachine,rebootVirtualMachine,updateVMAffinityGroup,revertToVMSnapshot,attachIso,resetPasswordForVirtualMachine,assignVirtualMachine,restoreVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,resetSSHKeyForVirtualMachine,resetPasswordForVirtualMachine,detachIso,changeServiceForVirtualMachine,attachIso,updateDefaultNicForVirtualMachine,startVirtualMachine,stopVirtualMachine",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "lists affinity groups by name",
            "length": 255,
            "name": "name",
            "required": false,
            "type": "string"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false",
            "length": 255,
            "name": "listall",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "list the affinity group by the ID provided",
            "length": 255,
            "name": "id",
            "related": "listAffinityGroups,createAffinityGroup",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
            "length": 255,
            "name": "isrecursive",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "list objects by project",
            "length": 255,
            "name": "projectid",
            "related": "activateProject,createProject,updateProject,suspendProject,listProjectAccounts,listProjects",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list only resources belonging to the domain specified",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain,updateDomain",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list resources by account. Must be used with the domainId parameter.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "lists affinity groups by type",
            "length": 255,
            "name": "type",
            "required": false,
            "type": "string"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          }
        ],
        "related": "createAffinityGroup",
        "response": [
          {
            "description": "the description of the affinity group",
            "name": "description",
            "type": "string"
          },
          {
            "description": "the name of the affinity group",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the account owning the affinity group",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the project name of the affinity group",
            "name": "project",
            "type": "string"
          },
          {
            "description": "virtual machine IDs associated with this affinity group",
            "name": "virtualmachineIds",
            "type": "list"
          },
          {
            "description": "the ID of the affinity group",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the domain ID of the affinity group",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the project ID of the affinity group",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the domain name of the affinity group",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the type of the affinity group",
            "name": "type",
            "type": "string"
          }
        ]
      },
      {
        "description": "Register a public key in a keypair under a certain name",
        "isasync": false,
        "name": "registerSSHKeyPair",
        "params": [
          {
            "description": "an optional account for the ssh key. Must be used with domainId.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "an optional domainId for the ssh key. If the account parameter is used, domainId must also be used.",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain,updateDomain",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "an optional project for the ssh key",
            "length": 255,
            "name": "projectid",
            "related": "activateProject,createProject,updateProject,suspendProject,listProjectAccounts,listProjects",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "Public key material of the keypair",
            "length": 5120,
            "name": "publickey",
            "required": true,
            "type": "string"
          },
          {
            "description": "Name of the keypair",
            "length": 255,
            "name": "name",
            "required": true,
            "type": "string"
          }
        ],
        "related": "listSSHKeyPairs",
        "response": [
          {
            "description": "the owner of the keypair",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the domain name of the keypair owner",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the domain id of the keypair owner",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "Name of the keypair",
            "name": "name",
            "type": "string"
          },
          {
            "description": "Fingerprint of the public key",
            "name": "fingerprint",
            "type": "string"
          }
        ]
      },
      {
        "description": "Destroys a l2tp/ipsec remote access vpn",
        "isasync": true,
        "name": "deleteRemoteAccessVpn",
        "params": [
          {
            "description": "public ip address id of the vpn server",
            "length": 255,
            "name": "publicipid",
            "related": "associateIpAddress,restartNetwork,updateIpAddress,listPublicIpAddresses,listPublicIpAddresses,associateIpAddress",
            "required": true,
            "type": "uuid"
          }
        ],
        "response": [
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          },
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          }
        ]
      },
      {
        "description": "Updates network ACL list",
        "isasync": true,
        "name": "updateNetworkACLList",
        "params": [
          {
            "description": "an optional field, in case you want to set a custom id to the resource. Allowed to Root Admins only",
            "length": 255,
            "name": "customid",
            "required": false,
            "since": "4.4",
            "type": "string"
          },
          {
            "description": "an optional field, whether to the display the list to the end user or not",
            "length": 255,
            "name": "fordisplay",
            "required": false,
            "since": "4.4",
            "type": "boolean"
          },
          {
            "description": "the ID of the network ACL",
            "length": 255,
            "name": "id",
            "related": "listNetworkACLLists,createNetworkACLList",
            "required": true,
            "type": "uuid"
          }
        ],
        "response": [
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          }
        ],
        "since": "4.4"
      },
      {
        "description": "Delete one or more events.",
        "isasync": false,
        "name": "deleteEvents",
        "params": [
          {
            "description": "end date range to delete events (including) this date (use format \"yyyy-MM-dd\" or the new format \"yyyy-MM-ddThh:mm:ss\")",
            "length": 255,
            "name": "enddate",
            "required": false,
            "type": "date"
          },
          {
            "description": "delete by event type",
            "length": 255,
            "name": "type",
            "required": false,
            "type": "string"
          },
          {
            "description": "the IDs of the events",
            "length": 255,
            "name": "ids",
            "related": "listEvents",
            "required": false,
            "type": "list"
          },
          {
            "description": "start date range to delete events (including) this date (use format \"yyyy-MM-dd\" or the new format \"yyyy-MM-ddThh:mm:ss\")",
            "length": 255,
            "name": "startdate",
            "required": false,
            "type": "date"
          }
        ],
        "response": [
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          }
        ]
      },
      {
        "description": " delete a nicira nvp device",
        "isasync": true,
        "name": "deleteNiciraNvpDevice",
        "params": [
          {
            "description": "Nicira device ID",
            "length": 255,
            "name": "nvpdeviceid",
            "related": "addNiciraNvpDevice,listNiciraNvpDevices",
            "required": true,
            "type": "uuid"
          }
        ],
        "response": [
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          }
        ]
      },
      {
        "description": "Restore a VM to original template/ISO or new template/ISO",
        "isasync": true,
        "name": "restoreVirtualMachine",
        "params": [
          {
            "description": "Virtual Machine ID",
            "length": 255,
            "name": "virtualmachineid",
            "related": "stopVirtualMachine,changeServiceForVirtualMachine,listVirtualMachines,detachIso,updateVMAffinityGroup,revertToVMSnapshot,deployVirtualMachine,migrateVirtualMachine,rebootVirtualMachine,recoverVirtualMachine,updateDefaultNicForVirtualMachine,migrateVirtualMachineWithVolume,addNicToVirtualMachine,updateVmNicIp,startVirtualMachine,listVirtualMachines,updateVirtualMachine,destroyVirtualMachine,removeNicFromVirtualMachine,removeNicFromVirtualMachine,deployVirtualMachine,destroyVirtualMachine,addNicToVirtualMachine,updateVirtualMachine,rebootVirtualMachine,updateVMAffinityGroup,revertToVMSnapshot,attachIso,resetPasswordForVirtualMachine,assignVirtualMachine,restoreVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,resetSSHKeyForVirtualMachine,resetPasswordForVirtualMachine,detachIso,changeServiceForVirtualMachine,attachIso,updateDefaultNicForVirtualMachine,startVirtualMachine,stopVirtualMachine",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "an optional template Id to restore vm from the new template. This can be an ISO id in case of restore vm deployed using ISO",
            "length": 255,
            "name": "templateid",
            "related": "listIsos,registerIso,listTemplates,updateTemplate,copyTemplate,registerTemplate,registerTemplate,prepareTemplate,listTemplates,createTemplate,updateIso,registerIso,createTemplate,copyTemplate,listIsos,copyIso",
            "required": false,
            "type": "uuid"
          }
        ],
        "related": "stopVirtualMachine,changeServiceForVirtualMachine,listVirtualMachines,detachIso,updateVMAffinityGroup,revertToVMSnapshot,deployVirtualMachine,migrateVirtualMachine,rebootVirtualMachine,recoverVirtualMachine,updateDefaultNicForVirtualMachine,migrateVirtualMachineWithVolume,addNicToVirtualMachine,updateVmNicIp,startVirtualMachine,listVirtualMachines,updateVirtualMachine,destroyVirtualMachine,removeNicFromVirtualMachine,removeNicFromVirtualMachine,deployVirtualMachine,destroyVirtualMachine,addNicToVirtualMachine,updateVirtualMachine,rebootVirtualMachine,updateVMAffinityGroup,revertToVMSnapshot,attachIso,resetPasswordForVirtualMachine,assignVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,resetSSHKeyForVirtualMachine,resetPasswordForVirtualMachine,detachIso,changeServiceForVirtualMachine,attachIso,updateDefaultNicForVirtualMachine,startVirtualMachine,stopVirtualMachine",
        "response": [
          {
            "description": "the date when this virtual machine was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "the vgpu type used by the virtual machine",
            "name": "vgpu",
            "type": "string"
          },
          {
            "description": "true if vm contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory.",
            "name": "isdynamicallyscalable",
            "type": "boolean"
          },
          {
            "description": "public IP address id associated with vm via Static nat rule",
            "name": "publicip",
            "type": "string"
          },
          {
            "description": " an alternate display text of the template for the virtual machine",
            "name": "templatedisplaytext",
            "type": "string"
          },
          {
            "description": "the account associated with the virtual machine",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the outgoing network traffic on the host",
            "name": "networkkbswrite",
            "type": "long"
          },
          {
            "description": "the ID of the availablility zone for the virtual machine",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the speed of each cpu",
            "name": "cpuspeed",
            "type": "integer"
          },
          {
            "description": "Vm details in key/value pairs.",
            "name": "details",
            "type": "map"
          },
          {
            "description": "State of the Service from LB rule",
            "name": "servicestate",
            "type": "string"
          },
          {
            "description": "the ID of the domain in which the virtual machine exists",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "device ID of the root volume",
            "name": "rootdeviceid",
            "type": "long"
          },
          {
            "description": "the password (if exists) of the virtual machine",
            "name": "password",
            "type": "string"
          },
          {
            "description": "the list of nics associated with vm",
            "name": "nic",
            "response": [
              {
                "description": "the gateway of IPv6 network",
                "name": "ip6gateway",
                "type": "string"
              },
              {
                "description": "the IPv6 address of network",
                "name": "ip6address",
                "type": "string"
              },
              {
                "description": "Id of the vm to which the nic belongs",
                "name": "virtualmachineid",
                "type": "string"
              },
              {
                "description": "the ID of the nic",
                "name": "id",
                "type": "string"
              },
              {
                "description": "the broadcast uri of the nic",
                "name": "broadcasturi",
                "type": "string"
              },
              {
                "description": "the cidr of IPv6 network",
                "name": "ip6cidr",
                "type": "string"
              },
              {
                "description": "true if nic is default, false otherwise",
                "name": "isdefault",
                "type": "boolean"
              },
              {
                "description": "the Secondary ipv4 addr of nic",
                "name": "secondaryip",
                "type": "list"
              },
              {
                "description": "the gateway of the nic",
                "name": "gateway",
                "type": "string"
              },
              {
                "description": "the name of the corresponding network",
                "name": "networkname",
                "type": "string"
              },
              {
                "description": "the ip address of the nic",
                "name": "ipaddress",
                "type": "string"
              },
              {
                "description": "the traffic type of the nic",
                "name": "traffictype",
                "type": "string"
              },
              {
                "description": "true if nic is default, false otherwise",
                "name": "macaddress",
                "type": "string"
              },
              {
                "description": "the isolation uri of the nic",
                "name": "isolationuri",
                "type": "string"
              },
              {
                "description": "device id for the network when plugged into the virtual machine",
                "name": "deviceid",
                "type": "string"
              },
              {
                "description": "the ID of the corresponding network",
                "name": "networkid",
                "type": "string"
              },
              {
                "description": "the netmask of the nic",
                "name": "netmask",
                "type": "string"
              },
              {
                "description": "the type of the nic",
                "name": "type",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "the ID of the virtual machine",
            "name": "id",
            "type": "string"
          },
          {
            "description": "list of security groups associated with the virtual machine",
            "name": "securitygroup",
            "response": [
              {
                "description": "the name of the security group",
                "name": "name",
                "type": "string"
              },
              {
                "description": "the domain name of the security group",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "the project id of the group",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "the description of the security group",
                "name": "description",
                "type": "string"
              },
              {
                "description": "the account owning the security group",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the list of resource tags associated with the rule",
                "name": "tags",
                "response": [
                  {
                    "description": "the ID of the domain associated with the tag",
                    "name": "domainid",
                    "type": "string"
                  },
                  {
                    "description": "resource type",
                    "name": "resourcetype",
                    "type": "string"
                  },
                  {
                    "description": "customer associated with the tag",
                    "name": "customer",
                    "type": "string"
                  },
                  {
                    "description": "id of the resource",
                    "name": "resourceid",
                    "type": "string"
                  },
                  {
                    "description": "the project id the tag belongs to",
                    "name": "projectid",
                    "type": "string"
                  },
                  {
                    "description": "the domain associated with the tag",
                    "name": "domain",
                    "type": "string"
                  },
                  {
                    "description": "tag value",
                    "name": "value",
                    "type": "string"
                  },
                  {
                    "description": "the account associated with the tag",
                    "name": "account",
                    "type": "string"
                  },
                  {
                    "description": "tag key name",
                    "name": "key",
                    "type": "string"
                  },
                  {
                    "description": "the project name where tag belongs to",
                    "name": "project",
                    "type": "string"
                  }
                ],
                "type": "set"
              },
              {
                "description": "the list of egress rules associated with the security group",
                "name": "egressrule",
                "response": [
                  {
                    "description": "the starting IP of the security group rule",
                    "name": "startport",
                    "type": "integer"
                  },
                  {
                    "description": "security group name",
                    "name": "securitygroupname",
                    "type": "string"
                  },
                  {
                    "description": "the CIDR notation for the base IP address of the security group rule",
                    "name": "cidr",
                    "type": "string"
                  },
                  {
                    "description": "the id of the security group rule",
                    "name": "ruleid",
                    "type": "string"
                  },
                  {
                    "description": "the ending IP of the security group rule ",
                    "name": "endport",
                    "type": "integer"
                  },
                  {
                    "description": "the type of the ICMP message response",
                    "name": "icmptype",
                    "type": "integer"
                  },
                  {
                    "description": "account owning the security group rule",
                    "name": "account",
                    "type": "string"
                  },
                  {
                    "description": "the code for the ICMP message response",
                    "name": "icmpcode",
                    "type": "integer"
                  },
                  {
                    "description": "the protocol of the security group rule",
                    "name": "protocol",
                    "type": "string"
                  },
                  {
                    "description": "the list of resource tags associated with the rule",
                    "name": "tags",
                    "response": [
                      {
                        "description": "tag value",
                        "name": "value",
                        "type": "string"
                      },
                      {
                        "description": "the project id the tag belongs to",
                        "name": "projectid",
                        "type": "string"
                      },
                      {
                        "description": "tag key name",
                        "name": "key",
                        "type": "string"
                      },
                      {
                        "description": "customer associated with the tag",
                        "name": "customer",
                        "type": "string"
                      },
                      {
                        "description": "the account associated with the tag",
                        "name": "account",
                        "type": "string"
                      },
                      {
                        "description": "the domain associated with the tag",
                        "name": "domain",
                        "type": "string"
                      },
                      {
                        "description": "id of the resource",
                        "name": "resourceid",
                        "type": "string"
                      },
                      {
                        "description": "resource type",
                        "name": "resourcetype",
                        "type": "string"
                      },
                      {
                        "description": "the project name where tag belongs to",
                        "name": "project",
                        "type": "string"
                      },
                      {
                        "description": "the ID of the domain associated with the tag",
                        "name": "domainid",
                        "type": "string"
                      }
                    ],
                    "type": "set"
                  }
                ],
                "type": "set"
              },
              {
                "description": "the number of virtualmachines associated with this securitygroup",
                "name": "virtualmachinecount",
                "type": "integer"
              },
              {
                "description": "the list of virtualmachine ids associated with this securitygroup",
                "name": "virtualmachineids",
                "type": "set"
              },
              {
                "description": "the project name of the group",
                "name": "project",
                "type": "string"
              },
              {
                "description": "the ID of the security group",
                "name": "id",
                "type": "string"
              },
              {
                "description": "the domain ID of the security group",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the list of ingress rules associated with the security group",
                "name": "ingressrule",
                "response": [
                  {
                    "description": "the CIDR notation for the base IP address of the security group rule",
                    "name": "cidr",
                    "type": "string"
                  },
                  {
                    "description": "the protocol of the security group rule",
                    "name": "protocol",
                    "type": "string"
                  },
                  {
                    "description": "the ending IP of the security group rule ",
                    "name": "endport",
                    "type": "integer"
                  },
                  {
                    "description": "the id of the security group rule",
                    "name": "ruleid",
                    "type": "string"
                  },
                  {
                    "description": "the starting IP of the security group rule",
                    "name": "startport",
                    "type": "integer"
                  },
                  {
                    "description": "the type of the ICMP message response",
                    "name": "icmptype",
                    "type": "integer"
                  },
                  {
                    "description": "the code for the ICMP message response",
                    "name": "icmpcode",
                    "type": "integer"
                  },
                  {
                    "description": "account owning the security group rule",
                    "name": "account",
                    "type": "string"
                  },
                  {
                    "description": "the list of resource tags associated with the rule",
                    "name": "tags",
                    "response": [
                      {
                        "description": "customer associated with the tag",
                        "name": "customer",
                        "type": "string"
                      },
                      {
                        "description": "id of the resource",
                        "name": "resourceid",
                        "type": "string"
                      },
                      {
                        "description": "the account associated with the tag",
                        "name": "account",
                        "type": "string"
                      },
                      {
                        "description": "the domain associated with the tag",
                        "name": "domain",
                        "type": "string"
                      },
                      {
                        "description": "the project id the tag belongs to",
                        "name": "projectid",
                        "type": "string"
                      },
                      {
                        "description": "tag value",
                        "name": "value",
                        "type": "string"
                      },
                      {
                        "description": "the ID of the domain associated with the tag",
                        "name": "domainid",
                        "type": "string"
                      },
                      {
                        "description": "the project name where tag belongs to",
                        "name": "project",
                        "type": "string"
                      },
                      {
                        "description": "tag key name",
                        "name": "key",
                        "type": "string"
                      },
                      {
                        "description": "resource type",
                        "name": "resourcetype",
                        "type": "string"
                      }
                    ],
                    "type": "set"
                  },
                  {
                    "description": "security group name",
                    "name": "securitygroupname",
                    "type": "string"
                  }
                ],
                "type": "set"
              }
            ],
            "type": "set"
          },
          {
            "description": "the incoming network traffic on the vm",
            "name": "networkkbsread",
            "type": "long"
          },
          {
            "description": "the hypervisor on which the template runs",
            "name": "hypervisor",
            "type": "string"
          },
          {
            "description": "an alternate display text of the ISO attached to the virtual machine",
            "name": "isodisplaytext",
            "type": "string"
          },
          {
            "description": "the name of the ISO attached to the virtual machine",
            "name": "isoname",
            "type": "string"
          },
          {
            "description": "instance name of the user vm; this parameter is returned to the ROOT admin only",
            "name": "instancename",
            "type": "string"
          },
          {
            "description": "the project id of the vm",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the read (io) of disk on the vm",
            "name": "diskioread",
            "type": "long"
          },
          {
            "description": "the virtual network for the service offering",
            "name": "forvirtualnetwork",
            "type": "boolean"
          },
          {
            "description": "public IP address id associated with vm via Static nat rule",
            "name": "publicipid",
            "type": "string"
          },
          {
            "description": "the ID of the ISO attached to the virtual machine",
            "name": "isoid",
            "type": "string"
          },
          {
            "description": "the user's ID who deployed the virtual machine",
            "name": "userid",
            "type": "string"
          },
          {
            "description": "the name of the template for the virtual machine",
            "name": "templatename",
            "type": "string"
          },
          {
            "description": "the write (io) of disk on the vm",
            "name": "diskiowrite",
            "type": "long"
          },
          {
            "description": "the number of cpu this virtual machine is running with",
            "name": "cpunumber",
            "type": "integer"
          },
          {
            "description": "the write (bytes) of disk on the vm",
            "name": "diskkbswrite",
            "type": "long"
          },
          {
            "description": "true if high-availability is enabled, false otherwise",
            "name": "haenable",
            "type": "boolean"
          },
          {
            "description": "the ID of the host for the virtual machine",
            "name": "hostid",
            "type": "string"
          },
          {
            "description": "the memory allocated for the virtual machine",
            "name": "memory",
            "type": "integer"
          },
          {
            "description": "list of affinity groups associated with the virtual machine",
            "name": "affinitygroup",
            "response": [
              {
                "description": "the ID of the affinity group",
                "name": "id",
                "type": "string"
              },
              {
                "description": "the domain ID of the affinity group",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the domain name of the affinity group",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "virtual machine IDs associated with this affinity group",
                "name": "virtualmachineIds",
                "type": "list"
              },
              {
                "description": "the name of the affinity group",
                "name": "name",
                "type": "string"
              },
              {
                "description": "the project ID of the affinity group",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "the type of the affinity group",
                "name": "type",
                "type": "string"
              },
              {
                "description": "the description of the affinity group",
                "name": "description",
                "type": "string"
              },
              {
                "description": "the account owning the affinity group",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the project name of the affinity group",
                "name": "project",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "the state of the virtual machine",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the name of the virtual machine",
            "name": "name",
            "type": "string"
          },
          {
            "description": "ssh key-pair",
            "name": "keypair",
            "type": "string"
          },
          {
            "description": "the name of the availability zone for the virtual machine",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the project name of the vm",
            "name": "project",
            "type": "string"
          },
          {
            "description": "OS type id of the vm",
            "name": "ostypeid",
            "type": "long"
          },
          {
            "description": "user generated name. The name of the virtual machine is returned if no displayname exists.",
            "name": "displayname",
            "type": "string"
          },
          {
            "description": "the amount of the vm's CPU currently used",
            "name": "cpuused",
            "type": "string"
          },
          {
            "description": "the read (bytes) of disk on the vm",
            "name": "diskkbsread",
            "type": "long"
          },
          {
            "description": "an optional field whether to the display the vm to the end user or not.",
            "name": "displayvm",
            "type": "boolean"
          },
          {
            "description": "the name of the domain in which the virtual machine exists",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the name of the disk offering of the virtual machine",
            "name": "diskofferingname",
            "type": "string"
          },
          {
            "description": "the name of the service offering of the virtual machine",
            "name": "serviceofferingname",
            "type": "string"
          },
          {},
          {
            "description": "the name of the host for the virtual machine",
            "name": "hostname",
            "type": "string"
          },
          {
            "description": "the ID of the disk offering of the virtual machine",
            "name": "diskofferingid",
            "type": "string"
          },
          {
            "description": "the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.",
            "name": "templateid",
            "type": "string"
          },
          {
            "description": "device type of the root volume",
            "name": "rootdevicetype",
            "type": "string"
          },
          {
            "description": "the user's name who deployed the virtual machine",
            "name": "username",
            "type": "string"
          },
          {
            "description": "the group ID of the virtual machine",
            "name": "groupid",
            "type": "string"
          },
          {
            "description": "Os type ID of the virtual machine",
            "name": "guestosid",
            "type": "string"
          },
          {
            "description": "true if the password rest feature is enabled, false otherwise",
            "name": "passwordenabled",
            "type": "boolean"
          },
          {
            "description": "the ID of the service offering of the virtual machine",
            "name": "serviceofferingid",
            "type": "string"
          },
          {
            "description": "the list of resource tags associated with vm",
            "name": "tags",
            "response": [
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              },
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "the group name of the virtual machine",
            "name": "group",
            "type": "string"
          }
        ],
        "since": "3.0.0"
      },
      {
        "description": "List ucs blades",
        "isasync": false,
        "name": "listUcsBlades",
        "params": [
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "ucs manager id",
            "length": 255,
            "name": "ucsmanagerid",
            "related": "listUcsManagers,addUcsManager",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          }
        ],
        "related": "associateUcsProfileToBlade",
        "response": [
          {
            "description": "ucs blade id",
            "name": "id",
            "type": "string"
          },
          {
            "description": "associated ucs profile dn",
            "name": "profiledn",
            "type": "string"
          },
          {
            "description": "ucs blade dn",
            "name": "bladedn",
            "type": "string"
          },
          {
            "description": "cloudstack host id this blade associates to",
            "name": "hostid",
            "type": "string"
          },
          {
            "description": "ucs manager id",
            "name": "ucsmanagerid",
            "type": "string"
          }
        ]
      },
      {
        "description": "Deletes an ISO file.",
        "isasync": true,
        "name": "deleteIso",
        "params": [
          {
            "description": "the ID of the ISO file",
            "length": 255,
            "name": "id",
            "related": "listIsos,registerIso,listTemplates,updateTemplate,copyTemplate,registerTemplate,registerTemplate,prepareTemplate,listTemplates,createTemplate,updateIso,registerIso,createTemplate,copyTemplate,listIsos,copyIso",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "the ID of the zone of the ISO file. If not specified, the ISO will be deleted from all the zones",
            "length": 255,
            "name": "zoneid",
            "related": "createZone,updateZone,listZones,listZones",
            "required": false,
            "type": "uuid"
          }
        ],
        "response": [
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          },
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          }
        ]
      },
      {
        "description": "Updates a host.",
        "isasync": false,
        "name": "updateHost",
        "params": [
          {
            "description": "Change resource state of host, valid values are [Enable, Disable]. Operation may failed if host in states not allowing Enable/Disable",
            "length": 255,
            "name": "allocationstate",
            "required": false,
            "type": "string"
          },
          {
            "description": "the id of Os category to update the host with",
            "length": 255,
            "name": "oscategoryid",
            "related": "listOsCategories",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list of tags to be added to the host",
            "length": 255,
            "name": "hosttags",
            "required": false,
            "type": "list"
          },
          {
            "description": "the new uri for the secondary storage: nfs://host/path",
            "length": 255,
            "name": "url",
            "required": false,
            "type": "string"
          },
          {
            "description": "the ID of the host to update",
            "length": 255,
            "name": "id",
            "related": "addHost,reconnectHost,addBaremetalHost,cancelHostMaintenance,updateHost,prepareHostForMaintenance",
            "required": true,
            "type": "uuid"
          }
        ],
        "related": "addHost,reconnectHost,addBaremetalHost,cancelHostMaintenance,prepareHostForMaintenance",
        "response": [
          {
            "description": "true if local storage is active, false otherwise",
            "name": "islocalstorageactive",
            "type": "boolean"
          },
          {
            "description": "the host hypervisor",
            "name": "hypervisor",
            "type": "hypervisortype"
          },
          {
            "description": "the CPU number of the host",
            "name": "cpunumber",
            "type": "integer"
          },
          {
            "description": "the amount of the host's memory currently allocated",
            "name": "memoryallocated",
            "type": "long"
          },
          {
            "description": "true if this host is suitable(has enough capacity and satisfies all conditions like hosttags, max guests vm limit etc) to migrate a VM to it , false otherwise",
            "name": "suitableformigration",
            "type": "boolean"
          },
          {
            "description": "the amount of the host's CPU currently allocated",
            "name": "cpuallocated",
            "type": "string"
          },
          {
            "description": "the hypervisor version",
            "name": "hypervisorversion",
            "type": "string"
          },
          {
            "description": "the Pod ID of the host",
            "name": "podid",
            "type": "string"
          },
          {
            "description": "capabilities of the host",
            "name": "capabilities",
            "type": "string"
          },
          {
            "description": "true if this host has enough CPU and RAM capacity to migrate a VM to it, false otherwise",
            "name": "hasenoughcapacity",
            "type": "boolean"
          },
          {
            "description": "the date and time the host was removed",
            "name": "removed",
            "type": "date"
          },
          {
            "description": "the Pod name of the host",
            "name": "podname",
            "type": "string"
          },
          {
            "description": "Host details in key/value pairs.",
            "name": "details",
            "type": "map"
          },
          {
            "description": "the host type",
            "name": "type",
            "type": "type"
          },
          {
            "description": "the cpu average load on the host",
            "name": "averageload",
            "type": "long"
          },
          {
            "description": "the management server ID of the host",
            "name": "managementserverid",
            "type": "long"
          },
          {
            "description": "the cluster ID of the host",
            "name": "clusterid",
            "type": "string"
          },
          {
            "description": "the state of the host",
            "name": "state",
            "type": "status"
          },
          {
            "description": "the number of CPU sockets on the host",
            "name": "cpusockets",
            "type": "integer"
          },
          {
            "description": "the outgoing network traffic on the host",
            "name": "networkkbswrite",
            "type": "long"
          },
          {
            "description": "the host version",
            "name": "version",
            "type": "string"
          },
          {
            "description": "true if the host is disconnected. False otherwise.",
            "name": "disconnected",
            "type": "date"
          },
          {
            "description": "the Zone ID of the host",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the amount of the host's CPU currently used",
            "name": "cpuused",
            "type": "string"
          },
          {
            "description": "GPU cards present in the host",
            "name": "gpugroup",
            "response": [
              {
                "description": "the list of enabled vGPUs",
                "name": "vgpu",
                "response": [
                  {
                    "description": "Maximum no. of vgpu per gpu card (pgpu)",
                    "name": "maxvgpuperpgpu",
                    "type": "long"
                  },
                  {
                    "description": "Remaining capacity in terms of no. of more VMs that can be deployped with this vGPU type",
                    "name": "remainingcapacity",
                    "type": "long"
                  },
                  {
                    "description": "Maximum X resolution per display",
                    "name": "maxresolutionx",
                    "type": "long"
                  },
                  {
                    "description": "Maximum vgpu can be created with this vgpu type on the given gpu group",
                    "name": "maxcapacity",
                    "type": "long"
                  },
                  {
                    "description": "Model Name of vGPU",
                    "name": "vgputype",
                    "type": "string"
                  },
                  {
                    "description": "Maximum displays per user",
                    "name": "maxheads",
                    "type": "long"
                  },
                  {
                    "description": "Video RAM for this vGPU type",
                    "name": "videoram",
                    "type": "long"
                  },
                  {
                    "description": "Maximum Y resolution per display",
                    "name": "maxresolutiony",
                    "type": "long"
                  }
                ],
                "type": "list"
              },
              {
                "description": "GPU cards present in the host",
                "name": "gpugroupname",
                "type": "string"
              }
            ],
            "type": "list"
          },
          {
            "description": "the incoming network traffic on the host",
            "name": "networkkbsread",
            "type": "long"
          },
          {
            "description": "the date and time the host was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "the name of the host",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the IP address of the host",
            "name": "ipaddress",
            "type": "string"
          },
          {
            "description": "the resource state of the host",
            "name": "resourcestate",
            "type": "string"
          },
          {
            "description": "the OS category name of the host",
            "name": "oscategoryname",
            "type": "string"
          },
          {
            "description": "the CPU speed of the host",
            "name": "cpuspeed",
            "type": "long"
          },
          {
            "description": "the OS category ID of the host",
            "name": "oscategoryid",
            "type": "string"
          },
          {
            "description": "the Zone name of the host",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the cluster type of the cluster that host belongs to",
            "name": "clustertype",
            "type": "string"
          },
          {
            "description": "the cluster name of the host",
            "name": "clustername",
            "type": "string"
          },
          {
            "description": "the amount of the host's memory currently used",
            "name": "memoryused",
            "type": "long"
          },
          {
            "description": "the date and time the host was last pinged",
            "name": "lastpinged",
            "type": "date"
          },
          {
            "description": "the amount of the host's CPU after applying the cpu.overprovisioning.factor ",
            "name": "cpuwithoverprovisioning",
            "type": "string"
          },
          {
            "description": "the total disk size of the host",
            "name": "disksizetotal",
            "type": "long"
          },
          {
            "description": "true if the host is Ha host (dedicated to vms started by HA process; false otherwise",
            "name": "hahost",
            "type": "boolean"
          },
          {
            "description": "the ID of the host",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the memory total of the host",
            "name": "memorytotal",
            "type": "long"
          },
          {
            "description": "comma-separated list of tags for the host",
            "name": "hosttags",
            "type": "string"
          },
          {
            "description": "the host's currently allocated disk size",
            "name": "disksizeallocated",
            "type": "long"
          },
          {
            "description": "events available for the host",
            "name": "events",
            "type": "string"
          }
        ]
      },
      {
        "description": "Creates a egress firewall rule for a given network ",
        "isasync": true,
        "name": "createEgressFirewallRule",
        "params": [
          {
            "description": "the protocol for the firewall rule. Valid values are TCP/UDP/ICMP.",
            "length": 255,
            "name": "protocol",
            "required": true,
            "type": "string"
          },
          {
            "description": "error code for this icmp message",
            "length": 255,
            "name": "icmpcode",
            "required": false,
            "type": "integer"
          },
          {
            "description": "the network id of the port forwarding rule",
            "length": 255,
            "name": "networkid",
            "related": "createNetwork,listNetscalerLoadBalancerNetworks,listPaloAltoFirewallNetworks,listNiciraNvpDeviceNetworks,listNetworks,updateNetwork,updateNetwork,createNetwork",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "type of firewallrule: system/user",
            "length": 255,
            "name": "type",
            "required": false,
            "type": "string"
          },
          {
            "description": "an optional field, whether to the display the rule to the end user or not",
            "length": 255,
            "name": "fordisplay",
            "required": false,
            "since": "4.4",
            "type": "boolean"
          },
          {
            "description": "the cidr list to forward traffic from",
            "length": 255,
            "name": "cidrlist",
            "required": false,
            "type": "list"
          },
          {
            "description": "type of the icmp message being sent",
            "length": 255,
            "name": "icmptype",
            "required": false,
            "type": "integer"
          },
          {
            "description": "the ending port of firewall rule",
            "length": 255,
            "name": "endport",
            "required": false,
            "type": "integer"
          },
          {
            "description": "the starting port of firewall rule",
            "length": 255,
            "name": "startport",
            "required": false,
            "type": "integer"
          }
        ],
        "related": "listFirewallRules,updateEgressFirewallRule,listEgressFirewallRules,createFirewallRule",
        "response": [
          {
            "description": "the cidr list to forward traffic from",
            "name": "cidrlist",
            "type": "string"
          },
          {
            "description": "the starting port of firewall rule's port range",
            "name": "startport",
            "type": "integer"
          },
          {
            "description": "error code for this icmp message",
            "name": "icmpcode",
            "type": "integer"
          },
          {
            "description": "the ending port of firewall rule's port range",
            "name": "endport",
            "type": "integer"
          },
          {
            "description": "the ID of the firewall rule",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the public ip address for the firewall rule",
            "name": "ipaddress",
            "type": "string"
          },
          {
            "description": "the network id of the firewall rule",
            "name": "networkid",
            "type": "string"
          },
          {
            "description": "is rule for display to the regular user",
            "name": "fordisplay",
            "type": "boolean"
          },
          {
            "description": "the protocol of the firewall rule",
            "name": "protocol",
            "type": "string"
          },
          {
            "description": "the list of resource tags associated with the rule",
            "name": "tags",
            "response": [
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              }
            ],
            "type": "list"
          },
          {
            "description": "the public ip address id for the firewall rule",
            "name": "ipaddressid",
            "type": "string"
          },
          {
            "description": "the state of the rule",
            "name": "state",
            "type": "string"
          },
          {
            "description": "type of the icmp message being sent",
            "name": "icmptype",
            "type": "integer"
          }
        ]
      },
      {
        "description": "Get the SF volume size including Hypervisor Snapshot Reserve",
        "isasync": false,
        "name": "getSolidFireVolumeSize",
        "params": [
          {
            "description": "Volume UUID",
            "length": 255,
            "name": "volumeid",
            "required": true,
            "type": "string"
          },
          {
            "description": "Storage Pool UUID",
            "length": 255,
            "name": "storageid",
            "required": true,
            "type": "string"
          }
        ],
        "related": "",
        "response": [
          {
            "description": "SolidFire Volume Size Including Hypervisor Snapshot Reserve",
            "name": "solidFireVolumeSize",
            "type": "long"
          }
        ]
      },
      {
        "description": "Lists VPC offerings",
        "isasync": false,
        "name": "listVPCOfferings",
        "params": [
          {
            "description": "list VPC offerings by display text",
            "length": 255,
            "name": "displaytext",
            "required": false,
            "type": "string"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "list VPC offerings by state",
            "length": 255,
            "name": "state",
            "required": false,
            "type": "string"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "true if need to list only default VPC offerings. Default value is false",
            "length": 255,
            "name": "isdefault",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "list VPC offerings supporting certain services",
            "length": 255,
            "name": "supportedservices",
            "required": false,
            "type": "list"
          },
          {
            "description": "list VPC offerings by id",
            "length": 255,
            "name": "id",
            "related": "listVPCOfferings,updateVPCOffering",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list VPC offerings by name",
            "length": 255,
            "name": "name",
            "required": false,
            "type": "string"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          }
        ],
        "related": "updateVPCOffering",
        "response": [
          {
            "description": "the id of the vpc offering",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the date this vpc offering was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "state of the vpc offering. Can be Disabled/Enabled",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the name of the vpc offering",
            "name": "name",
            "type": "string"
          },
          {
            "description": "true if vpc offering is default, false otherwise",
            "name": "isdefault",
            "type": "boolean"
          },
          {
            "description": " indicates if the vpc offering supports distributed router for one-hop forwarding",
            "name": "distributedvpcrouter",
            "type": "boolean"
          },
          {
            "description": "the list of supported services",
            "name": "service",
            "response": [
              {
                "description": "the list of capabilities",
                "name": "capability",
                "response": [
                  {
                    "description": "can this service capability value can be choosable while creatine network offerings",
                    "name": "canchooseservicecapability",
                    "type": "boolean"
                  },
                  {
                    "description": "the capability name",
                    "name": "name",
                    "type": "string"
                  },
                  {
                    "description": "the capability value",
                    "name": "value",
                    "type": "string"
                  }
                ],
                "type": "list"
              },
              {
                "description": "the service provider name",
                "name": "provider",
                "response": [
                  {
                    "description": "the provider name",
                    "name": "name",
                    "type": "string"
                  },
                  {
                    "description": "state of the network provider",
                    "name": "state",
                    "type": "string"
                  },
                  {
                    "description": "true if individual services can be enabled/disabled",
                    "name": "canenableindividualservice",
                    "type": "boolean"
                  },
                  {
                    "description": "the destination physical network",
                    "name": "destinationphysicalnetworkid",
                    "type": "string"
                  },
                  {
                    "description": "the physical network this belongs to",
                    "name": "physicalnetworkid",
                    "type": "string"
                  },
                  {
                    "description": "services for this provider",
                    "name": "servicelist",
                    "type": "list"
                  },
                  {
                    "description": "uuid of the network provider",
                    "name": "id",
                    "type": "string"
                  }
                ],
                "type": "list"
              },
              {
                "description": "the service name",
                "name": "name",
                "type": "string"
              }
            ],
            "type": "list"
          },
          {
            "description": "an alternate display text of the vpc offering.",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": " indicated if the offering can support region level vpc",
            "name": "supportsregionLevelvpc",
            "type": "boolean"
          }
        ]
      },
      {
        "description": "Uploads a data disk.",
        "isasync": true,
        "name": "uploadVolume",
        "params": [
          {
            "description": "the MD5 checksum value of this volume",
            "length": 255,
            "name": "checksum",
            "required": false,
            "type": "string"
          },
          {
            "description": "the ID of the disk offering. This must be a custom sized offering since during uploadVolume volume size is unknown.",
            "length": 255,
            "name": "diskofferingid",
            "related": "listDiskOfferings,createDiskOffering,updateDiskOffering",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "the ID of the zone the volume is to be hosted on",
            "length": 255,
            "name": "zoneid",
            "related": "createZone,updateZone,listZones,listZones",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "the name of the volume",
            "length": 255,
            "name": "name",
            "required": true,
            "type": "string"
          },
          {
            "description": "the format for the volume. Possible values include QCOW2, OVA, and VHD.",
            "length": 255,
            "name": "format",
            "required": true,
            "type": "string"
          },
          {
            "description": "an optional domainId. If the account parameter is used, domainId must also be used.",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain,updateDomain",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "Upload volume for the project",
            "length": 255,
            "name": "projectid",
            "related": "activateProject,createProject,updateProject,suspendProject,listProjectAccounts,listProjects",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "the URL of where the volume is hosted. Possible URL include http:// and https://",
            "length": 255,
            "name": "url",
            "required": true,
            "type": "string"
          },
          {
            "description": "an optional accountName. Must be used with domainId.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "Image store uuid",
            "length": 255,
            "name": "imagestoreuuid",
            "required": false,
            "type": "string"
          }
        ],
        "related": "createVolume,updateVolume,uploadVolume,updateVolume,attachVolume,migrateVolume,createVolume,detachVolume,attachVolume,migrateVolume,resizeVolume,detachVolume,resizeVolume,listVolumes,listVolumes",
        "response": [
          {
            "description": "an optional field whether to the display the volume to the end user or not.",
            "name": "displayvolume",
            "type": "boolean"
          },
          {
            "description": "the date the disk volume was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "need quiesce vm or not when taking snapshot",
            "name": "quiescevm",
            "type": "boolean"
          },
          {
            "description": "name of the availability zone",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "ID of the service offering for root disk",
            "name": "serviceofferingid",
            "type": "string"
          },
          {
            "description": "name of the primary storage hosting the disk volume",
            "name": "storage",
            "type": "string"
          },
          {
            "description": "io requests write rate of the disk volume",
            "name": "diskIopsWriteRate",
            "type": "long"
          },
          {
            "description": "ID of the disk offering",
            "name": "diskofferingid",
            "type": "string"
          },
          {
            "description": "the display text of the service offering for root disk",
            "name": "serviceofferingdisplaytext",
            "type": "string"
          },
          {
            "description": "the status of the volume",
            "name": "status",
            "type": "string"
          },
          {
            "description": "an alternate display text of the ISO attached to the virtual machine",
            "name": "isodisplaytext",
            "type": "string"
          },
          {
            "description": "io requests read rate of the disk volume",
            "name": "diskIopsReadRate",
            "type": "long"
          },
          {
            "description": "the state of the disk volume",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the project id of the vpn",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": " an alternate display text of the template for the virtual machine",
            "name": "templatedisplaytext",
            "type": "string"
          },
          {
            "description": "state of the virtual machine",
            "name": "vmstate",
            "type": "string"
          },
          {
            "description": "id of the primary storage hosting the disk volume; returned to admin user only",
            "name": "storageid",
            "type": "string"
          },
          {
            "description": "ID of the availability zone",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the list of resource tags associated with volume",
            "name": "tags",
            "response": [
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              },
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              },
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "the ID of the domain associated with the disk volume",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "max iops of the disk volume",
            "name": "maxiops",
            "type": "long"
          },
          {
            "description": "shared or local storage",
            "name": "storagetype",
            "type": "string"
          },
          {
            "description": "display name of the virtual machine",
            "name": "vmdisplayname",
            "type": "string"
          },
          {
            "description": "name of the disk volume",
            "name": "name",
            "type": "string"
          },
          {
            "description": "name of the service offering for root disk",
            "name": "serviceofferingname",
            "type": "string"
          },
          {
            "description": "bytes read rate of the disk volume",
            "name": "diskBytesReadRate",
            "type": "long"
          },
          {
            "description": "Hypervisor the volume belongs to",
            "name": "hypervisor",
            "type": "string"
          },
          {
            "description": "the project name of the vpn",
            "name": "project",
            "type": "string"
          },
          {
            "description": "the chain info of the volume",
            "name": "chaininfo",
            "type": "string"
          },
          {
            "description": "bytes write rate of the disk volume",
            "name": "diskBytesWriteRate",
            "type": "long"
          },
          {
            "description": "the account associated with the disk volume",
            "name": "account",
            "type": "string"
          },
          {
            "description": "id of the virtual machine",
            "name": "virtualmachineid",
            "type": "string"
          },
          {
            "description": "the name of the template for the virtual machine",
            "name": "templatename",
            "type": "string"
          },
          {
            "description": "min iops of the disk volume",
            "name": "miniops",
            "type": "long"
          },
          {
            "description": "true if the volume is extractable, false otherwise",
            "name": "isextractable",
            "type": "boolean"
          },
          {
            "description": "the ID of the device on user vm the volume is attahed to. This tag is not returned when the volume is detached.",
            "name": "deviceid",
            "type": "long"
          },
          {
            "description": "type of the disk volume (ROOT or DATADISK)",
            "name": "type",
            "type": "string"
          },
          {
            "description": "the date the volume was attached to a VM instance",
            "name": "attached",
            "type": "date"
          },
          {
            "description": "ID of the snapshot from which this volume was created",
            "name": "snapshotid",
            "type": "string"
          },
          {
            "description": "the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.",
            "name": "templateid",
            "type": "string"
          },
          {
            "description": "name of the disk offering",
            "name": "diskofferingname",
            "type": "string"
          },
          {
            "description": "the domain associated with the disk volume",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "size of the disk volume",
            "name": "size",
            "type": "long"
          },
          {
            "description": "ID of the disk volume",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the ID of the ISO attached to the virtual machine",
            "name": "isoid",
            "type": "string"
          },
          {
            "description": "provisioning type used to create volumes.",
            "name": "provisioningtype",
            "type": "string"
          },
          {
            "description": "the name of the ISO attached to the virtual machine",
            "name": "isoname",
            "type": "string"
          },
          {
            "description": "the display text of the disk offering",
            "name": "diskofferingdisplaytext",
            "type": "string"
          },
          {
            "description": "the path of the volume",
            "name": "path",
            "type": "string"
          },
          {
            "description": "the boolean state of whether the volume is destroyed or not",
            "name": "destroyed",
            "type": "boolean"
          },
          {
            "description": "name of the virtual machine",
            "name": "vmname",
            "type": "string"
          }
        ]
      },
      {
        "description": "Lists security groups",
        "isasync": false,
        "name": "listSecurityGroups",
        "params": [
          {
            "description": "List resources by tags (key/value pairs)",
            "length": 255,
            "name": "tags",
            "required": false,
            "type": "map"
          },
          {
            "description": "lists security groups by virtual machine id",
            "length": 255,
            "name": "virtualmachineid",
            "related": "stopVirtualMachine,changeServiceForVirtualMachine,listVirtualMachines,detachIso,updateVMAffinityGroup,revertToVMSnapshot,deployVirtualMachine,migrateVirtualMachine,rebootVirtualMachine,recoverVirtualMachine,updateDefaultNicForVirtualMachine,migrateVirtualMachineWithVolume,addNicToVirtualMachine,updateVmNicIp,startVirtualMachine,listVirtualMachines,updateVirtualMachine,destroyVirtualMachine,removeNicFromVirtualMachine,removeNicFromVirtualMachine,deployVirtualMachine,destroyVirtualMachine,addNicToVirtualMachine,updateVirtualMachine,rebootVirtualMachine,updateVMAffinityGroup,revertToVMSnapshot,attachIso,resetPasswordForVirtualMachine,assignVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,resetSSHKeyForVirtualMachine,resetPasswordForVirtualMachine,detachIso,changeServiceForVirtualMachine,attachIso,updateDefaultNicForVirtualMachine,startVirtualMachine,stopVirtualMachine",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list the security group by the id provided",
            "length": 255,
            "name": "id",
            "related": "listSecurityGroups,createSecurityGroup",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "lists security groups by name",
            "length": 255,
            "name": "securitygroupname",
            "required": false,
            "type": "string"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false",
            "length": 255,
            "name": "listall",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "list objects by project",
            "length": 255,
            "name": "projectid",
            "related": "activateProject,createProject,updateProject,suspendProject,listProjectAccounts,listProjects",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "list resources by account. Must be used with the domainId parameter.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
            "length": 255,
            "name": "isrecursive",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "list only resources belonging to the domain specified",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain,updateDomain",
            "required": false,
            "type": "uuid"
          }
        ],
        "related": "createSecurityGroup",
        "response": [
          {
            "description": "the account owning the security group",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the list of ingress rules associated with the security group",
            "name": "ingressrule",
            "response": [
              {
                "description": "the code for the ICMP message response",
                "name": "icmpcode",
                "type": "integer"
              },
              {
                "description": "the list of resource tags associated with the rule",
                "name": "tags",
                "response": [
                  {
                    "description": "resource type",
                    "name": "resourcetype",
                    "type": "string"
                  },
                  {
                    "description": "the ID of the domain associated with the tag",
                    "name": "domainid",
                    "type": "string"
                  },
                  {
                    "description": "the account associated with the tag",
                    "name": "account",
                    "type": "string"
                  },
                  {
                    "description": "customer associated with the tag",
                    "name": "customer",
                    "type": "string"
                  },
                  {
                    "description": "tag value",
                    "name": "value",
                    "type": "string"
                  },
                  {
                    "description": "id of the resource",
                    "name": "resourceid",
                    "type": "string"
                  },
                  {
                    "description": "the project name where tag belongs to",
                    "name": "project",
                    "type": "string"
                  },
                  {
                    "description": "the domain associated with the tag",
                    "name": "domain",
                    "type": "string"
                  },
                  {
                    "description": "tag key name",
                    "name": "key",
                    "type": "string"
                  },
                  {
                    "description": "the project id the tag belongs to",
                    "name": "projectid",
                    "type": "string"
                  }
                ],
                "type": "set"
              },
              {
                "description": "the starting IP of the security group rule",
                "name": "startport",
                "type": "integer"
              },
              {
                "description": "the id of the security group rule",
                "name": "ruleid",
                "type": "string"
              },
              {
                "description": "account owning the security group rule",
                "name": "account",
                "type": "string"
              },
              {
                "description": "security group name",
                "name": "securitygroupname",
                "type": "string"
              },
              {
                "description": "the protocol of the security group rule",
                "name": "protocol",
                "type": "string"
              },
              {
                "description": "the CIDR notation for the base IP address of the security group rule",
                "name": "cidr",
                "type": "string"
              },
              {
                "description": "the type of the ICMP message response",
                "name": "icmptype",
                "type": "integer"
              },
              {
                "description": "the ending IP of the security group rule ",
                "name": "endport",
                "type": "integer"
              }
            ],
            "type": "set"
          },
          {
            "description": "the ID of the security group",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the list of resource tags associated with the rule",
            "name": "tags",
            "response": [
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              },
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "the domain name of the security group",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the description of the security group",
            "name": "description",
            "type": "string"
          },
          {
            "description": "the domain ID of the security group",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the project id of the group",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the name of the security group",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the number of virtualmachines associated with this securitygroup",
            "name": "virtualmachinecount",
            "type": "integer"
          },
          {
            "description": "the list of virtualmachine ids associated with this securitygroup",
            "name": "virtualmachineids",
            "type": "set"
          },
          {
            "description": "the list of egress rules associated with the security group",
            "name": "egressrule",
            "response": [
              {
                "description": "the CIDR notation for the base IP address of the security group rule",
                "name": "cidr",
                "type": "string"
              },
              {
                "description": "security group name",
                "name": "securitygroupname",
                "type": "string"
              },
              {
                "description": "the starting IP of the security group rule",
                "name": "startport",
                "type": "integer"
              },
              {
                "description": "the protocol of the security group rule",
                "name": "protocol",
                "type": "string"
              },
              {
                "description": "the type of the ICMP message response",
                "name": "icmptype",
                "type": "integer"
              },
              {
                "description": "the list of resource tags associated with the rule",
                "name": "tags",
                "response": [
                  {
                    "description": "the project id the tag belongs to",
                    "name": "projectid",
                    "type": "string"
                  },
                  {
                    "description": "tag value",
                    "name": "value",
                    "type": "string"
                  },
                  {
                    "description": "id of the resource",
                    "name": "resourceid",
                    "type": "string"
                  },
                  {
                    "description": "tag key name",
                    "name": "key",
                    "type": "string"
                  },
                  {
                    "description": "the account associated with the tag",
                    "name": "account",
                    "type": "string"
                  },
                  {
                    "description": "customer associated with the tag",
                    "name": "customer",
                    "type": "string"
                  },
                  {
                    "description": "the domain associated with the tag",
                    "name": "domain",
                    "type": "string"
                  },
                  {
                    "description": "resource type",
                    "name": "resourcetype",
                    "type": "string"
                  },
                  {
                    "description": "the ID of the domain associated with the tag",
                    "name": "domainid",
                    "type": "string"
                  },
                  {
                    "description": "the project name where tag belongs to",
                    "name": "project",
                    "type": "string"
                  }
                ],
                "type": "set"
              },
              {
                "description": "the id of the security group rule",
                "name": "ruleid",
                "type": "string"
              },
              {
                "description": "the code for the ICMP message response",
                "name": "icmpcode",
                "type": "integer"
              },
              {
                "description": "the ending IP of the security group rule ",
                "name": "endport",
                "type": "integer"
              },
              {
                "description": "account owning the security group rule",
                "name": "account",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "the project name of the group",
            "name": "project",
            "type": "string"
          }
        ]
      },
      {
        "description": "Lists storage tags",
        "isasync": false,
        "name": "listStorageTags",
        "params": [
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          }
        ],
        "related": "",
        "response": [
          {
            "description": "the ID of the storage tag",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the name of the storage tag",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the pool ID of the storage tag",
            "name": "poolid",
            "type": "long"
          }
        ]
      },
      {
        "description": "List template visibility and all accounts that have permissions to view this template.",
        "isasync": false,
        "name": "listTemplatePermissions",
        "params": [
          {
            "description": "the template ID",
            "length": 255,
            "name": "id",
            "related": "listIsoPermissions,listIsoPermissions,listTemplatePermissions,listTemplatePermissions",
            "required": true,
            "type": "uuid"
          }
        ],
        "related": "listIsoPermissions,listIsoPermissions,listTemplatePermissions",
        "response": [
          {
            "description": "true if this template is a public template, false otherwise",
            "name": "ispublic",
            "type": "boolean"
          },
          {
            "description": "the template ID",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the list of accounts the template is available for",
            "name": "account",
            "type": "list"
          },
          {
            "description": "the list of projects the template is available for",
            "name": "projectids",
            "type": "list"
          },
          {
            "description": "the ID of the domain to which the template belongs",
            "name": "domainid",
            "type": "string"
          }
        ]
      },
      {
        "description": "Destroyes a system virtual machine.",
        "isasync": true,
        "name": "destroySystemVm",
        "params": [
          {
            "description": "The ID of the system virtual machine",
            "length": 255,
            "name": "id",
            "related": "migrateSystemVm,stopSystemVm,changeServiceForSystemVm,destroySystemVm,scaleSystemVm,listSystemVms,startSystemVm",
            "required": true,
            "type": "uuid"
          }
        ],
        "related": "migrateSystemVm,stopSystemVm,changeServiceForSystemVm,scaleSystemVm,listSystemVms,startSystemVm",
        "response": [
          {
            "description": "the host ID for the system VM",
            "name": "hostid",
            "type": "string"
          },
          {
            "description": "the link local IP address for the system vm",
            "name": "linklocalip",
            "type": "string"
          },
          {
            "description": "the hostname for the system VM",
            "name": "hostname",
            "type": "string"
          },
          {
            "description": "the Zone name for the system VM",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the first DNS for the system VM",
            "name": "dns1",
            "type": "string"
          },
          {
            "description": "the name of the system VM",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the public MAC address for the system VM",
            "name": "publicmacaddress",
            "type": "string"
          },
          {
            "description": "the private MAC address for the system VM",
            "name": "privatemacaddress",
            "type": "string"
          },
          {
            "description": "the Pod ID for the system VM",
            "name": "podid",
            "type": "string"
          },
          {
            "description": "the job status associated with the system VM.  This is only displayed if the router listed is part of a currently running asynchronous job.",
            "name": "jobstatus",
            "type": "integer"
          },
          {
            "description": "the public IP address for the system VM",
            "name": "publicip",
            "type": "string"
          },
          {
            "description": "the ID of the system VM",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the Zone ID for the system VM",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the date and time the system VM was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "the link local netmask for the system vm",
            "name": "linklocalnetmask",
            "type": "string"
          },
          {
            "description": "the system VM type",
            "name": "systemvmtype",
            "type": "string"
          },
          {
            "description": "the job ID associated with the system VM. This is only displayed if the router listed is part of a currently running asynchronous job.",
            "name": "jobid",
            "type": "string"
          },
          {
            "description": "the hypervisor on which the template runs",
            "name": "hypervisor",
            "type": "string"
          },
          {
            "description": "the second DNS for the system VM",
            "name": "dns2",
            "type": "string"
          },
          {
            "description": "the public netmask for the system VM",
            "name": "publicnetmask",
            "type": "string"
          },
          {
            "description": "the network domain for the system VM",
            "name": "networkdomain",
            "type": "string"
          },
          {
            "description": "the number of active console sessions for the console proxy system vm",
            "name": "activeviewersessions",
            "type": "integer"
          },
          {
            "description": "the state of the system VM",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the private IP address for the system VM",
            "name": "privateip",
            "type": "string"
          },
          {
            "description": "the gateway for the system VM",
            "name": "gateway",
            "type": "string"
          },
          {
            "description": "the template ID for the system VM",
            "name": "templateid",
            "type": "string"
          },
          {
            "description": "the private netmask for the system VM",
            "name": "privatenetmask",
            "type": "string"
          },
          {
            "description": "the link local MAC address for the system vm",
            "name": "linklocalmacaddress",
            "type": "string"
          }
        ]
      },
      {
        "description": "Archive one or more events.",
        "isasync": false,
        "name": "archiveEvents",
        "params": [
          {
            "description": "archive by event type",
            "length": 255,
            "name": "type",
            "required": false,
            "type": "string"
          },
          {
            "description": "the IDs of the events",
            "length": 255,
            "name": "ids",
            "related": "listEvents",
            "required": false,
            "type": "list"
          },
          {
            "description": "end date range to archive events (including) this date (use format \"yyyy-MM-dd\" or the new format \"yyyy-MM-ddThh:mm:ss\")",
            "length": 255,
            "name": "enddate",
            "required": false,
            "type": "date"
          },
          {
            "description": "start date range to archive events (including) this date (use format \"yyyy-MM-dd\" or the new format \"yyyy-MM-ddThh:mm:ss\")",
            "length": 255,
            "name": "startdate",
            "required": false,
            "type": "date"
          }
        ],
        "response": [
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          },
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          }
        ]
      },
      {
        "description": "Adds Swift.",
        "isasync": false,
        "name": "addSwift",
        "params": [
          {
            "description": "the account for swift",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "the username for swift",
            "length": 255,
            "name": "username",
            "required": false,
            "type": "string"
          },
          {
            "description": "the URL for swift",
            "length": 255,
            "name": "url",
            "required": true,
            "type": "string"
          },
          {
            "description": " key for the user for swift",
            "length": 255,
            "name": "key",
            "required": false,
            "type": "string"
          }
        ],
        "related": "addImageStore,listSecondaryStagingStores,addSecondaryStorage,listImageStores,updateCloudToUseObjectStore,createSecondaryStagingStore,listSwifts,addImageStoreS3",
        "response": [
          {
            "description": "the name of the image store",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the url of the image store",
            "name": "url",
            "type": "string"
          },
          {
            "description": "the Zone ID of the image store",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the details of the image store",
            "name": "details",
            "type": "set"
          },
          {
            "description": "the protocol of the image store",
            "name": "protocol",
            "type": "string"
          },
          {
            "description": "the scope of the image store",
            "name": "scope",
            "type": "scopetype"
          },
          {
            "description": "the Zone name of the image store",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the ID of the image store",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the provider name of the image store",
            "name": "providername",
            "type": "string"
          }
        ],
        "since": "3.0.0"
      },
      {
        "description": "Deletes a secondary staging store .",
        "isasync": false,
        "name": "deleteSecondaryStagingStore",
        "params": [
          {
            "description": "the staging store ID",
            "length": 255,
            "name": "id",
            "related": "addImageStore,listSecondaryStagingStores,addSecondaryStorage,listImageStores,updateCloudToUseObjectStore,createSecondaryStagingStore,listSwifts,addImageStoreS3",
            "required": true,
            "type": "uuid"
          }
        ],
        "response": [
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          }
        ],
        "since": "4.2.0"
      },
      {
        "description": "Updates a load balancer",
        "isasync": true,
        "name": "updateLoadBalancer",
        "params": [
          {
            "description": "an optional field, in case you want to set a custom id to the resource. Allowed to Root Admins only",
            "length": 255,
            "name": "customid",
            "required": false,
            "since": "4.4",
            "type": "string"
          },
          {
            "description": "the ID of the load balancer",
            "length": 255,
            "name": "id",
            "related": "listIpForwardingRules,listPortForwardingRules,updatePortForwardingRule,createPortForwardingRule,createIpForwardingRule",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "an optional field, whether to the display the rule to the end user or not",
            "length": 255,
            "name": "fordisplay",
            "required": false,
            "since": "4.4",
            "type": "boolean"
          }
        ],
        "related": "listLoadBalancers,createLoadBalancer",
        "response": [
          {
            "description": "the load balancer algorithm (source, roundrobin, leastconn)",
            "name": "algorithm",
            "type": "string"
          },
          {
            "description": "Load Balancer source ip",
            "name": "sourceipaddress",
            "type": "string"
          },
          {
            "description": "the account of the Load Balancer",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the project id of the Load Balancer",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the project name of the Load Balancer",
            "name": "project",
            "type": "string"
          },
          {
            "description": "Load Balancer source ip network id",
            "name": "sourceipaddressnetworkid",
            "type": "string"
          },
          {
            "description": "is rule for display to the regular user",
            "name": "fordisplay",
            "type": "boolean"
          },
          {
            "description": "Load Balancer network id",
            "name": "networkid",
            "type": "string"
          },
          {
            "description": "the domain ID of the Load Balancer",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the list of instances associated with the Load Balancer",
            "name": "loadbalancerinstance",
            "response": [
              {
                "description": "the ip address of the instance",
                "name": "ipaddress",
                "type": "string"
              },
              {
                "description": "the name of the instance",
                "name": "name",
                "type": "string"
              },
              {
                "description": "the state of the instance",
                "name": "state",
                "type": "string"
              },
              {
                "description": "the instance ID",
                "name": "id",
                "type": "string"
              }
            ],
            "type": "list"
          },
          {
            "description": "the description of the Load Balancer",
            "name": "description",
            "type": "string"
          },
          {
            "description": "the name of the Load Balancer",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the domain of the Load Balancer",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the list of rules associated with the Load Balancer",
            "name": "loadbalancerrule",
            "response": [
              {
                "description": "instance port of the load balancer rule",
                "name": "instanceport",
                "type": "integer"
              },
              {
                "description": "source port of the load balancer rule",
                "name": "sourceport",
                "type": "integer"
              },
              {
                "description": "the state of the load balancer rule",
                "name": "state",
                "type": "string"
              }
            ],
            "type": "list"
          },
          {
            "description": "the Load Balancer ID",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the list of resource tags associated with the Load Balancer",
            "name": "tags",
            "response": [
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              },
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              }
            ],
            "type": "list"
          }
        ],
        "since": "4.4.0"
      },
      {
        "description": "Scale the service offering for a system vm (console proxy or secondary storage). The system vm must be in a \"Stopped\" state for this command to take effect.",
        "isasync": true,
        "name": "scaleSystemVm",
        "params": [
          {
            "description": "name value pairs of custom parameters for cpu, memory and cpunumber. example details[i].name=value",
            "length": 255,
            "name": "details",
            "required": false,
            "type": "map"
          },
          {
            "description": "the service offering ID to apply to the system vm",
            "length": 255,
            "name": "serviceofferingid",
            "related": "updateServiceOffering,listServiceOfferings,createServiceOffering",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "The ID of the system vm",
            "length": 255,
            "name": "id",
            "related": "migrateSystemVm,stopSystemVm,changeServiceForSystemVm,scaleSystemVm,listSystemVms,startSystemVm",
            "required": true,
            "type": "uuid"
          }
        ],
        "related": "migrateSystemVm,stopSystemVm,changeServiceForSystemVm,listSystemVms,startSystemVm",
        "response": [
          {
            "description": "the private IP address for the system VM",
            "name": "privateip",
            "type": "string"
          },
          {
            "description": "the link local IP address for the system vm",
            "name": "linklocalip",
            "type": "string"
          },
          {
            "description": "the ID of the system VM",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the public IP address for the system VM",
            "name": "publicip",
            "type": "string"
          },
          {
            "description": "the private netmask for the system VM",
            "name": "privatenetmask",
            "type": "string"
          },
          {
            "description": "the first DNS for the system VM",
            "name": "dns1",
            "type": "string"
          },
          {
            "description": "the system VM type",
            "name": "systemvmtype",
            "type": "string"
          },
          {
            "description": "the host ID for the system VM",
            "name": "hostid",
            "type": "string"
          },
          {
            "description": "the public MAC address for the system VM",
            "name": "publicmacaddress",
            "type": "string"
          },
          {
            "description": "the state of the system VM",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the hypervisor on which the template runs",
            "name": "hypervisor",
            "type": "string"
          },
          {
            "description": "the Zone ID for the system VM",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the public netmask for the system VM",
            "name": "publicnetmask",
            "type": "string"
          },
          {
            "description": "the date and time the system VM was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "the second DNS for the system VM",
            "name": "dns2",
            "type": "string"
          },
          {
            "description": "the template ID for the system VM",
            "name": "templateid",
            "type": "string"
          },
          {
            "description": "the gateway for the system VM",
            "name": "gateway",
            "type": "string"
          },
          {
            "description": "the name of the system VM",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the link local netmask for the system vm",
            "name": "linklocalnetmask",
            "type": "string"
          },
          {
            "description": "the link local MAC address for the system vm",
            "name": "linklocalmacaddress",
            "type": "string"
          },
          {
            "description": "the number of active console sessions for the console proxy system vm",
            "name": "activeviewersessions",
            "type": "integer"
          },
          {
            "description": "the job status associated with the system VM.  This is only displayed if the router listed is part of a currently running asynchronous job.",
            "name": "jobstatus",
            "type": "integer"
          },
          {
            "description": "the network domain for the system VM",
            "name": "networkdomain",
            "type": "string"
          },
          {
            "description": "the Zone name for the system VM",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the job ID associated with the system VM. This is only displayed if the router listed is part of a currently running asynchronous job.",
            "name": "jobid",
            "type": "string"
          },
          {
            "description": "the Pod ID for the system VM",
            "name": "podid",
            "type": "string"
          },
          {
            "description": "the hostname for the system VM",
            "name": "hostname",
            "type": "string"
          },
          {
            "description": "the private MAC address for the system VM",
            "name": "privatemacaddress",
            "type": "string"
          }
        ]
      },
      {
        "description": "Lists snapshot policies.",
        "isasync": false,
        "name": "listSnapshotPolicies",
        "params": [
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "list resources by display flag; only ROOT admin is eligible to pass this parameter",
            "length": 255,
            "name": "fordisplay",
            "required": false,
            "since": "4.4",
            "type": "boolean"
          },
          {
            "description": "the ID of the snapshot policy",
            "length": 255,
            "name": "id",
            "related": "listSnapshotPolicies,updateSnapshotPolicy,createSnapshotPolicy",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "the ID of the disk volume",
            "length": 255,
            "name": "volumeid",
            "related": "createVolume,updateVolume,uploadVolume,updateVolume,attachVolume,migrateVolume,createVolume,detachVolume,attachVolume,migrateVolume,resizeVolume,detachVolume,resizeVolume,listVolumes,listVolumes",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          }
        ],
        "related": "updateSnapshotPolicy,createSnapshotPolicy",
        "response": [
          {
            "description": "the ID of the snapshot policy",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the ID of the disk volume",
            "name": "volumeid",
            "type": "string"
          },
          {
            "description": "maximum number of snapshots retained",
            "name": "maxsnaps",
            "type": "int"
          },
          {
            "description": "the time zone of the snapshot policy",
            "name": "timezone",
            "type": "string"
          },
          {
            "description": "is this policy for display to the regular user",
            "name": "fordisplay",
            "type": "boolean"
          },
          {
            "description": "time the snapshot is scheduled to be taken.",
            "name": "schedule",
            "type": "string"
          },
          {
            "description": "the interval type of the snapshot policy",
            "name": "intervaltype",
            "type": "short"
          }
        ]
      },
      {
        "description": "Update site to site vpn customer gateway",
        "isasync": true,
        "name": "updateVpnCustomerGateway",
        "params": [
          {
            "description": "guest cidr of the customer gateway",
            "length": 255,
            "name": "cidrlist",
            "required": true,
            "type": "string"
          },
          {
            "description": "Lifetime of phase 1 VPN connection to the customer gateway, in seconds",
            "length": 255,
            "name": "ikelifetime",
            "required": false,
            "type": "long"
          },
          {
            "description": "If DPD is enabled for VPN connection",
            "length": 255,
            "name": "dpd",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "id of customer gateway",
            "length": 255,
            "name": "id",
            "related": "createVpnCustomerGateway,listVpnCustomerGateways,updateVpnCustomerGateway",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "ESP policy of the customer gateway",
            "length": 255,
            "name": "esppolicy",
            "required": true,
            "type": "string"
          },
          {
            "description": "the account associated with the gateway. Must be used with the domainId parameter.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "IPsec Preshared-Key of the customer gateway",
            "length": 255,
            "name": "ipsecpsk",
            "required": true,
            "type": "string"
          },
          {
            "description": "Force encapsulation for Nat Traversal",
            "length": 255,
            "name": "forceencap",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "name of this customer gateway",
            "length": 255,
            "name": "name",
            "required": false,
            "type": "string"
          },
          {
            "description": "public ip address id of the customer gateway",
            "length": 255,
            "name": "gateway",
            "required": true,
            "type": "string"
          },
          {
            "description": "IKE policy of the customer gateway",
            "length": 255,
            "name": "ikepolicy",
            "required": true,
            "type": "string"
          },
          {
            "description": "Lifetime of phase 2 VPN connection to the customer gateway, in seconds",
            "length": 255,
            "name": "esplifetime",
            "required": false,
            "type": "long"
          },
          {
            "description": "the domain ID associated with the gateway. If used with the account parameter returns the gateway associated with the account for the specified domain.",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain,updateDomain",
            "required": false,
            "type": "uuid"
          }
        ],
        "related": "createVpnCustomerGateway,listVpnCustomerGateways",
        "response": [
          {
            "description": "IKE policy of customer gateway",
            "name": "ikepolicy",
            "type": "string"
          },
          {
            "description": "guest ip of the customer gateway",
            "name": "ipaddress",
            "type": "string"
          },
          {
            "description": "the domain id of the owner",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "IPsec policy of customer gateway",
            "name": "esppolicy",
            "type": "string"
          },
          {
            "description": "name of the customer gateway",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the date and time the host was removed",
            "name": "removed",
            "type": "date"
          },
          {
            "description": "the domain name of the owner",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the project id",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the owner",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the project name",
            "name": "project",
            "type": "string"
          },
          {
            "description": "guest cidr list of the customer gateway",
            "name": "cidrlist",
            "type": "string"
          },
          {
            "description": "if Force NAT Encapsulation is enabled for customer gateway",
            "name": "forceencap",
            "type": "boolean"
          },
          {
            "description": "if DPD is enabled for customer gateway",
            "name": "dpd",
            "type": "boolean"
          },
          {
            "description": "Lifetime of ESP SA of customer gateway",
            "name": "esplifetime",
            "type": "long"
          },
          {
            "description": "public ip address id of the customer gateway",
            "name": "gateway",
            "type": "string"
          },
          {
            "description": "IPsec preshared-key of customer gateway",
            "name": "ipsecpsk",
            "type": "string"
          },
          {
            "description": "the vpn gateway ID",
            "name": "id",
            "type": "string"
          },
          {
            "description": "Lifetime of IKE SA of customer gateway",
            "name": "ikelifetime",
            "type": "long"
          }
        ]
      },
      {
        "description": "This deprecated function used to locks an account. Look for the API DisableAccount instead",
        "isasync": false,
        "name": "lockAccount",
        "params": [
          {
            "description": "Locks the specified account.",
            "length": 255,
            "name": "account",
            "required": true,
            "type": "string"
          },
          {
            "description": "Locks the specified account on this domain.",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain,updateDomain",
            "required": true,
            "type": "uuid"
          }
        ],
        "related": "enableAccount,listAccounts,disableAccount,listAccounts,markDefaultZoneForAccount,createAccount,updateAccount",
        "response": [
          {
            "description": "the total number of templates which can be created by this account",
            "name": "templatelimit",
            "type": "string"
          },
          {
            "description": "the total memory (in MB) available to be created for this account",
            "name": "memoryavailable",
            "type": "string"
          },
          {
            "description": "the total number of snapshots available for this account",
            "name": "snapshotavailable",
            "type": "string"
          },
          {
            "description": "the total memory (in MB) owned by account",
            "name": "memorytotal",
            "type": "long"
          },
          {
            "description": "the total number of virtual machines deployed by this account",
            "name": "vmtotal",
            "type": "long"
          },
          {
            "description": "the total number of virtual machines that can be deployed by this account",
            "name": "vmlimit",
            "type": "string"
          },
          {
            "description": "the list of users associated with account",
            "name": "user",
            "response": [
              {
                "description": "the user name",
                "name": "username",
                "type": "string"
              },
              {
                "description": "the user lastname",
                "name": "lastname",
                "type": "string"
              },
              {
                "description": "the boolean value representing if the updating target is in caller's child domain",
                "name": "iscallerchilddomain",
                "type": "boolean"
              },
              {
                "description": "the timezone user was created in",
                "name": "timezone",
                "type": "string"
              },
              {
                "description": "the api key of the user",
                "name": "apikey",
                "type": "string"
              },
              {
                "description": "the user ID",
                "name": "id",
                "type": "string"
              },
              {
                "description": "true if user is default, false otherwise",
                "name": "isdefault",
                "type": "boolean"
              },
              {
                "description": "the user state",
                "name": "state",
                "type": "string"
              },
              {
                "description": "the account name of the user",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the domain ID of the user",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the account type of the user",
                "name": "accounttype",
                "type": "short"
              },
              {
                "description": "the user firstname",
                "name": "firstname",
                "type": "string"
              },
              {
                "description": "the domain name of the user",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "the user email address",
                "name": "email",
                "type": "string"
              },
              {
                "description": "the date and time the user account was created",
                "name": "created",
                "type": "date"
              },
              {
                "description": "the secret key of the user",
                "name": "secretkey",
                "type": "string"
              },
              {
                "description": "the account ID of the user",
                "name": "accountid",
                "type": "string"
              }
            ],
            "type": "list"
          },
          {
            "description": "the total number of projects available for administration by this account",
            "name": "projectavailable",
            "type": "string"
          },
          {
            "description": "the total secondary storage space (in GiB) available to be used for this account",
            "name": "secondarystorageavailable",
            "type": "string"
          },
          {
            "description": "the total number of networks available to be created for this account",
            "name": "networkavailable",
            "type": "string"
          },
          {
            "description": "the total number of cpu cores available to be created for this account",
            "name": "cpuavailable",
            "type": "string"
          },
          {
            "description": "the total number of virtual machines available for this account to acquire",
            "name": "vmavailable",
            "type": "string"
          },
          {
            "description": "the total number of public ip addresses this account can acquire",
            "name": "iplimit",
            "type": "string"
          },
          {
            "description": "the total number of projects being administrated by this account",
            "name": "projecttotal",
            "type": "long"
          },
          {
            "description": "the total number of vpcs owned by account",
            "name": "vpctotal",
            "type": "long"
          },
          {
            "description": "the total number of vpcs available to be created for this account",
            "name": "vpcavailable",
            "type": "string"
          },
          {
            "description": "the state of the account",
            "name": "state",
            "type": "string"
          },
          {
            "description": "id of the Domain the account belongs too",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "true if account is default, false otherwise",
            "name": "isdefault",
            "type": "boolean"
          },
          {
            "description": "details for the account",
            "name": "accountdetails",
            "type": "map"
          },
          {
            "description": "the total number of cpu cores owned by account",
            "name": "cputotal",
            "type": "long"
          },
          {
            "description": "name of the Domain the account belongs too",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the total number of snapshots stored by this account",
            "name": "snapshottotal",
            "type": "long"
          },
          {
            "description": "the total volume available for this account",
            "name": "volumeavailable",
            "type": "string"
          },
          {
            "description": "true if the account requires cleanup",
            "name": "iscleanuprequired",
            "type": "boolean"
          },
          {
            "description": "the total number of templates which have been created by this account",
            "name": "templatetotal",
            "type": "long"
          },
          {
            "description": "the total number of network traffic bytes received",
            "name": "receivedbytes",
            "type": "long"
          },
          {
            "description": "the total primary storage space (in GiB) owned by account",
            "name": "primarystoragetotal",
            "type": "long"
          },
          {
            "description": "the total secondary storage space (in GiB) the account can own",
            "name": "secondarystoragelimit",
            "type": "string"
          },
          {
            "description": "the total volume which can be used by this account",
            "name": "volumelimit",
            "type": "string"
          },
          {
            "description": "the total number of virtual machines running for this account",
            "name": "vmrunning",
            "type": "integer"
          },
          {
            "description": "the total number of snapshots which can be stored by this account",
            "name": "snapshotlimit",
            "type": "string"
          },
          {
            "description": "the total number of networks owned by account",
            "name": "networktotal",
            "type": "long"
          },
          {
            "description": "the id of the account",
            "name": "id",
            "type": "string"
          },
          {
            "description": "account type (admin, domain-admin, user)",
            "name": "accounttype",
            "type": "short"
          },
          {
            "description": "the total number of templates available to be created by this account",
            "name": "templateavailable",
            "type": "string"
          },
          {
            "description": "the total number of virtual machines stopped for this account",
            "name": "vmstopped",
            "type": "integer"
          },
          {
            "description": "the list of acl groups that account belongs to",
            "name": "groups",
            "type": "list"
          },
          {
            "description": "the default zone of the account",
            "name": "defaultzoneid",
            "type": "string"
          },
          {
            "description": "the network domain",
            "name": "networkdomain",
            "type": "string"
          },
          {
            "description": "the total number of projects the account can own",
            "name": "projectlimit",
            "type": "string"
          },
          {
            "description": "the total primary storage space (in GiB) the account can own",
            "name": "primarystoragelimit",
            "type": "string"
          },
          {
            "description": "the total number of cpu cores the account can own",
            "name": "cpulimit",
            "type": "string"
          },
          {
            "description": "the total number of public ip addresses allocated for this account",
            "name": "iptotal",
            "type": "long"
          },
          {
            "description": "the name of the account",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the total number of public ip addresses available for this account to acquire",
            "name": "ipavailable",
            "type": "string"
          },
          {
            "description": "the total number of vpcs the account can own",
            "name": "vpclimit",
            "type": "string"
          },
          {
            "description": "the total memory (in MB) the account can own",
            "name": "memorylimit",
            "type": "string"
          },
          {
            "description": "the total number of networks the account can own",
            "name": "networklimit",
            "type": "string"
          },
          {
            "description": "the total secondary storage space (in GiB) owned by account",
            "name": "secondarystoragetotal",
            "type": "long"
          },
          {
            "description": "the total primary storage space (in GiB) available to be used for this account",
            "name": "primarystorageavailable",
            "type": "string"
          },
          {
            "description": "the total number of network traffic bytes sent",
            "name": "sentbytes",
            "type": "long"
          },
          {
            "description": "the total volume being used by this account",
            "name": "volumetotal",
            "type": "long"
          }
        ]
      },
      {
        "description": "Stops a router.",
        "isasync": true,
        "name": "stopRouter",
        "params": [
          {
            "description": "Force stop the VM. The caller knows the VM is stopped.",
            "length": 255,
            "name": "forced",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "the ID of the router",
            "length": 255,
            "name": "id",
            "related": "changeServiceForRouter,rebootRouter,destroyRouter,listInternalLoadBalancerVMs,startInternalLoadBalancerVM,stopRouter,stopInternalLoadBalancerVM,listRouters,startRouter",
            "required": true,
            "type": "uuid"
          }
        ],
        "related": "changeServiceForRouter,rebootRouter,destroyRouter,listInternalLoadBalancerVMs,startInternalLoadBalancerVM,stopInternalLoadBalancerVM,listRouters,startRouter",
        "response": [
          {
            "description": "the list of nics associated with the router",
            "name": "nic",
            "response": [
              {
                "description": "device id for the network when plugged into the virtual machine",
                "name": "deviceid",
                "type": "string"
              },
              {
                "description": "true if nic is default, false otherwise",
                "name": "isdefault",
                "type": "boolean"
              },
              {
                "description": "the isolation uri of the nic",
                "name": "isolationuri",
                "type": "string"
              },
              {
                "description": "the IPv6 address of network",
                "name": "ip6address",
                "type": "string"
              },
              {
                "description": "the ip address of the nic",
                "name": "ipaddress",
                "type": "string"
              },
              {
                "description": "the cidr of IPv6 network",
                "name": "ip6cidr",
                "type": "string"
              },
              {
                "description": "true if nic is default, false otherwise",
                "name": "macaddress",
                "type": "string"
              },
              {
                "description": "the broadcast uri of the nic",
                "name": "broadcasturi",
                "type": "string"
              },
              {
                "description": "Id of the vm to which the nic belongs",
                "name": "virtualmachineid",
                "type": "string"
              },
              {
                "description": "the traffic type of the nic",
                "name": "traffictype",
                "type": "string"
              },
              {
                "description": "the type of the nic",
                "name": "type",
                "type": "string"
              },
              {
                "description": "the gateway of the nic",
                "name": "gateway",
                "type": "string"
              },
              {
                "description": "the name of the corresponding network",
                "name": "networkname",
                "type": "string"
              },
              {
                "description": "the Secondary ipv4 addr of nic",
                "name": "secondaryip",
                "type": "list"
              },
              {
                "description": "the netmask of the nic",
                "name": "netmask",
                "type": "string"
              },
              {
                "description": "the ID of the nic",
                "name": "id",
                "type": "string"
              },
              {
                "description": "the ID of the corresponding network",
                "name": "networkid",
                "type": "string"
              },
              {
                "description": "the gateway of IPv6 network",
                "name": "ip6gateway",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "the hypervisor on which the template runs",
            "name": "hypervisor",
            "type": "string"
          },
          {
            "description": "the ID of the corresponding public network",
            "name": "publicnetworkid",
            "type": "string"
          },
          {
            "description": "the version of template",
            "name": "version",
            "type": "string"
          },
          {
            "description": "the account associated with the router",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the public IP address for the router",
            "name": "publicip",
            "type": "string"
          },
          {
            "description": "the name of the corresponding guest network",
            "name": "guestnetworkname",
            "type": "string"
          },
          {
            "description": "the public netmask for the router",
            "name": "publicnetmask",
            "type": "string"
          },
          {
            "description": "the Zone name for the router",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the link local netmask for the router",
            "name": "linklocalnetmask",
            "type": "string"
          },
          {
            "description": "VPC the router belongs to",
            "name": "vpcid",
            "type": "string"
          },
          {
            "description": "the name of VPC the router belongs to",
            "name": "vpcname",
            "type": "string"
          },
          {
            "description": "the network domain for the router",
            "name": "networkdomain",
            "type": "string"
          },
          {
            "description": "the first DNS for the router",
            "name": "dns1",
            "type": "string"
          },
          {
            "description": "the guest netmask for the router",
            "name": "guestnetmask",
            "type": "string"
          },
          {
            "description": "the ID of the corresponding guest network",
            "name": "guestnetworkid",
            "type": "string"
          },
          {
            "description": "the ID of the service offering of the virtual machine",
            "name": "serviceofferingid",
            "type": "string"
          },
          {
            "description": "the version of scripts",
            "name": "scriptsversion",
            "type": "string"
          },
          {
            "description": "the state of redundant virtual router",
            "name": "redundantstate",
            "type": "string"
          },
          {
            "description": "the id of the router",
            "name": "id",
            "type": "string"
          },
          {
            "description": "role of the domain router",
            "name": "role",
            "type": "string"
          },
          {
            "description": "the link local IP address for the router",
            "name": "linklocalip",
            "type": "string"
          },
          {
            "description": "the hostname for the router",
            "name": "hostname",
            "type": "string"
          },
          {
            "description": "the template ID for the router",
            "name": "templateid",
            "type": "string"
          },
          {
            "description": "the gateway for the router",
            "name": "gateway",
            "type": "string"
          },
          {
            "description": "the Zone ID for the router",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the state of the router",
            "name": "state",
            "type": "state"
          },
          {
            "description": "the name of the router",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the guest MAC address for the router",
            "name": "guestmacaddress",
            "type": "string"
          },
          {
            "description": "the second IPv6 DNS for the router",
            "name": "ip6dns2",
            "type": "string"
          },
          {
            "description": "the public MAC address for the router",
            "name": "publicmacaddress",
            "type": "string"
          },
          {
            "description": "the date and time the router was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "the host ID for the router",
            "name": "hostid",
            "type": "string"
          },
          {
            "description": "the guest IP address for the router",
            "name": "guestipaddress",
            "type": "string"
          },
          {
            "description": "the second DNS for the router",
            "name": "dns2",
            "type": "string"
          },
          {
            "description": "the Pod ID for the router",
            "name": "podid",
            "type": "string"
          },
          {
            "description": "true if the router template requires upgrader",
            "name": "requiresupgrade",
            "type": "boolean"
          },
          {
            "description": "the project id of the ipaddress",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the project name of the address",
            "name": "project",
            "type": "string"
          },
          {
            "description": "the domain ID associated with the router",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "if this router is an redundant virtual router",
            "name": "isredundantrouter",
            "type": "boolean"
          },
          {
            "description": "the ID of the corresponding link local network",
            "name": "linklocalnetworkid",
            "type": "string"
          },
          {
            "description": "the name of the service offering of the virtual machine",
            "name": "serviceofferingname",
            "type": "string"
          },
          {
            "description": "the first IPv6 DNS for the router",
            "name": "ip6dns1",
            "type": "string"
          },
          {
            "description": "the domain associated with the router",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the link local MAC address for the router",
            "name": "linklocalmacaddress",
            "type": "string"
          }
        ]
      },
      {
        "description": "Lists clusters.",
        "isasync": false,
        "name": "listClusters",
        "params": [
          {
            "description": "lists clusters by hypervisor type",
            "length": 255,
            "name": "hypervisor",
            "required": false,
            "type": "string"
          },
          {
            "description": "whether this cluster is managed by cloudstack",
            "length": 255,
            "name": "managedstate",
            "required": false,
            "type": "string"
          },
          {
            "description": "lists clusters by cluster type",
            "length": 255,
            "name": "clustertype",
            "required": false,
            "type": "string"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "lists clusters by Pod ID",
            "length": 255,
            "name": "podid",
            "related": "updatePod,listPods",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "flag to display the capacity of the clusters",
            "length": 255,
            "name": "showcapacities",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "lists clusters by Zone ID",
            "length": 255,
            "name": "zoneid",
            "related": "createZone,updateZone,listZones,listZones",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "lists clusters by the cluster ID",
            "length": 255,
            "name": "id",
            "related": "listClusters,addCluster,updateCluster",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "lists clusters by allocation state",
            "length": 255,
            "name": "allocationstate",
            "required": false,
            "type": "string"
          },
          {
            "description": "lists clusters by the cluster name",
            "length": 255,
            "name": "name",
            "required": false,
            "type": "string"
          }
        ],
        "related": "addCluster,updateCluster",
        "response": [
          {
            "description": "the cluster ID",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the type of the cluster",
            "name": "clustertype",
            "type": "string"
          },
          {
            "description": "Ovm3 VIP to use for pooling and/or clustering",
            "name": "ovm3vip",
            "type": "string"
          },
          {
            "description": "the Zone ID of the cluster",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "whether this cluster is managed by cloudstack",
            "name": "managedstate",
            "type": "string"
          },
          {
            "description": "the Zone name of the cluster",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the Pod ID of the cluster",
            "name": "podid",
            "type": "string"
          },
          {
            "description": "the allocation state of the cluster",
            "name": "allocationstate",
            "type": "string"
          },
          {
            "description": "the capacity of the Cluster",
            "name": "capacity",
            "response": [
              {
                "description": "the Zone ID",
                "name": "zoneid",
                "type": "string"
              },
              {
                "description": "the Zone name",
                "name": "zonename",
                "type": "string"
              },
              {
                "description": "the total capacity available",
                "name": "capacitytotal",
                "type": "long"
              },
              {
                "description": "the Cluster name",
                "name": "clustername",
                "type": "string"
              },
              {
                "description": "the Pod ID",
                "name": "podid",
                "type": "string"
              },
              {
                "description": "the Pod name",
                "name": "podname",
                "type": "string"
              },
              {
                "description": "the percentage of capacity currently in use",
                "name": "percentused",
                "type": "string"
              },
              {
                "description": "the capacity type",
                "name": "type",
                "type": "short"
              },
              {
                "description": "the capacity currently in use",
                "name": "capacityused",
                "type": "long"
              },
              {
                "description": "the Cluster ID",
                "name": "clusterid",
                "type": "string"
              }
            ],
            "type": "list"
          },
          {
            "description": "the cluster name",
            "name": "name",
            "type": "string"
          },
          {
            "description": "The memory overcommit ratio of the cluster",
            "name": "memoryovercommitratio",
            "type": "string"
          },
          {
            "description": "the Pod name of the cluster",
            "name": "podname",
            "type": "string"
          },
          {
            "description": "the hypervisor type of the cluster",
            "name": "hypervisortype",
            "type": "string"
          },
          {
            "description": "The cpu overcommit ratio of the cluster",
            "name": "cpuovercommitratio",
            "type": "string"
          }
        ]
      },
      {
        "description": "Deletes project invitation",
        "isasync": true,
        "name": "deleteProjectInvitation",
        "params": [
          {
            "description": "id of the invitation",
            "length": 255,
            "name": "id",
            "related": "listProjectInvitations",
            "required": true,
            "type": "uuid"
          }
        ],
        "response": [
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          }
        ],
        "since": "3.0.0"
      },
      {
        "description": "Lists project invitations and provides detailed information for listed invitations",
        "isasync": false,
        "name": "listProjectInvitations",
        "params": [
          {
            "description": "list by project id",
            "length": 255,
            "name": "projectid",
            "related": "activateProject,createProject,updateProject,suspendProject,listProjectAccounts,listProjects",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false",
            "length": 255,
            "name": "listall",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "list invitations by id",
            "length": 255,
            "name": "id",
            "related": "listProjectInvitations",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list only resources belonging to the domain specified",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain,updateDomain",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list invitations by state",
            "length": 255,
            "name": "state",
            "required": false,
            "type": "string"
          },
          {
            "description": "list resources by account. Must be used with the domainId parameter.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
            "length": 255,
            "name": "isrecursive",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "if true, list only active invitations - having Pending state and ones that are not timed out yet",
            "length": 255,
            "name": "activeonly",
            "required": false,
            "type": "boolean"
          }
        ],
        "related": "",
        "response": [
          {
            "description": "the id of the project",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the name of the project",
            "name": "project",
            "type": "string"
          },
          {
            "description": "the domain name where the project belongs to",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the domain id the project belongs to",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the account name of the project's owner",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the email the invitation was sent to",
            "name": "email",
            "type": "string"
          },
          {
            "description": "the id of the invitation",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the invitation state",
            "name": "state",
            "type": "string"
          }
        ],
        "since": "3.0.0"
      },
      {
        "description": "Lists all egress firewall rules for network ID.",
        "isasync": false,
        "name": "listEgressFirewallRules",
        "params": [
          {
            "description": "Lists rule with the specified ID.",
            "length": 255,
            "name": "id",
            "related": "listIpForwardingRules,listPortForwardingRules,updatePortForwardingRule,createPortForwardingRule,createIpForwardingRule",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false",
            "length": 255,
            "name": "listall",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "list resources by display flag; only ROOT admin is eligible to pass this parameter",
            "length": 255,
            "name": "fordisplay",
            "required": false,
            "since": "4.4",
            "type": "boolean"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "List resources by tags (key/value pairs)",
            "length": 255,
            "name": "tags",
            "required": false,
            "type": "map"
          },
          {
            "description": "list resources by account. Must be used with the domainId parameter.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "list objects by project",
            "length": 255,
            "name": "projectid",
            "related": "activateProject,createProject,updateProject,suspendProject,listProjectAccounts,listProjects",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "the network ID for the egress firewall services",
            "length": 255,
            "name": "networkid",
            "related": "createNetwork,listNetscalerLoadBalancerNetworks,listPaloAltoFirewallNetworks,listNiciraNvpDeviceNetworks,listNetworks,updateNetwork,updateNetwork,createNetwork",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
            "length": 255,
            "name": "isrecursive",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "list only resources belonging to the domain specified",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain,updateDomain",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "the ID of IP address of the firewall services",
            "length": 255,
            "name": "ipaddressid",
            "related": "associateIpAddress,restartNetwork,updateIpAddress,listPublicIpAddresses,listPublicIpAddresses,associateIpAddress",
            "required": false,
            "type": "uuid"
          }
        ],
        "related": "listFirewallRules,updateEgressFirewallRule,createFirewallRule",
        "response": [
          {
            "description": "type of the icmp message being sent",
            "name": "icmptype",
            "type": "integer"
          },
          {
            "description": "error code for this icmp message",
            "name": "icmpcode",
            "type": "integer"
          },
          {
            "description": "the starting port of firewall rule's port range",
            "name": "startport",
            "type": "integer"
          },
          {
            "description": "the public ip address for the firewall rule",
            "name": "ipaddress",
            "type": "string"
          },
          {
            "description": "the ID of the firewall rule",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the public ip address id for the firewall rule",
            "name": "ipaddressid",
            "type": "string"
          },
          {
            "description": "the network id of the firewall rule",
            "name": "networkid",
            "type": "string"
          },
          {
            "description": "the protocol of the firewall rule",
            "name": "protocol",
            "type": "string"
          },
          {
            "description": "the state of the rule",
            "name": "state",
            "type": "string"
          },
          {
            "description": "is rule for display to the regular user",
            "name": "fordisplay",
            "type": "boolean"
          },
          {
            "description": "the ending port of firewall rule's port range",
            "name": "endport",
            "type": "integer"
          },
          {
            "description": "the list of resource tags associated with the rule",
            "name": "tags",
            "response": [
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              }
            ],
            "type": "list"
          },
          {
            "description": "the cidr list to forward traffic from",
            "name": "cidrlist",
            "type": "string"
          }
        ]
      },
      {
        "description": "Deletes traffic type of a physical network",
        "isasync": true,
        "name": "deleteTrafficType",
        "params": [
          {
            "description": "traffic type id",
            "length": 255,
            "name": "id",
            "related": "addTrafficType,updateTrafficType",
            "required": true,
            "type": "uuid"
          }
        ],
        "response": [
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          }
        ],
        "since": "3.0.0"
      },
      {
        "description": "Updates a region",
        "isasync": false,
        "name": "updateRegion",
        "params": [
          {
            "description": "updates region with this name",
            "length": 255,
            "name": "name",
            "required": false,
            "type": "string"
          },
          {
            "description": "updates region with this end point",
            "length": 255,
            "name": "endpoint",
            "required": false,
            "type": "string"
          },
          {
            "description": "Id of region to update",
            "length": 255,
            "name": "id",
            "required": true,
            "type": "integer"
          }
        ],
        "related": "addRegion,listRegions",
        "response": [
          {
            "description": "the ID of the region",
            "name": "id",
            "type": "integer"
          },
          {
            "description": "true if security groups support is enabled, false otherwise",
            "name": "portableipserviceenabled",
            "type": "boolean"
          },
          {
            "description": "the end point of the region",
            "name": "endpoint",
            "type": "string"
          },
          {
            "description": "true if GSLB service is enabled in the region, false otherwise",
            "name": "gslbserviceenabled",
            "type": "boolean"
          },
          {
            "description": "the name of the region",
            "name": "name",
            "type": "string"
          }
        ]
      },
      {
        "description": "Lists all LDAP configurations",
        "isasync": false,
        "name": "listLdapConfigurations",
        "params": [
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "Port",
            "length": 255,
            "name": "port",
            "required": false,
            "type": "integer"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "Hostname",
            "length": 255,
            "name": "hostname",
            "required": false,
            "type": "string"
          }
        ],
        "related": "addLdapConfiguration,deleteLdapConfiguration",
        "response": [
          {
            "description": "port",
            "name": "port",
            "type": "int"
          },
          {
            "description": "hostname",
            "name": "hostname",
            "type": "string"
          }
        ],
        "since": "4.2.0"
      },
      {
        "description": "Lists secondary staging stores.",
        "isasync": false,
        "name": "listSecondaryStagingStores",
        "params": [
          {
            "description": "the Zone ID for the staging store",
            "length": 255,
            "name": "zoneid",
            "related": "createZone,updateZone,listZones,listZones",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "the ID of the staging store",
            "length": 255,
            "name": "id",
            "related": "addImageStore,listSecondaryStagingStores,addSecondaryStorage,listImageStores,updateCloudToUseObjectStore,createSecondaryStagingStore,listSwifts,addImageStoreS3",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "the name of the staging store",
            "length": 255,
            "name": "name",
            "required": false,
            "type": "string"
          },
          {
            "description": "the staging store provider",
            "length": 255,
            "name": "provider",
            "required": false,
            "type": "string"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "the staging store protocol",
            "length": 255,
            "name": "protocol",
            "required": false,
            "type": "string"
          }
        ],
        "related": "addImageStore,addSecondaryStorage,listImageStores,updateCloudToUseObjectStore,createSecondaryStagingStore,listSwifts,addImageStoreS3",
        "response": [
          {
            "description": "the ID of the image store",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the scope of the image store",
            "name": "scope",
            "type": "scopetype"
          },
          {
            "description": "the provider name of the image store",
            "name": "providername",
            "type": "string"
          },
          {
            "description": "the details of the image store",
            "name": "details",
            "type": "set"
          },
          {
            "description": "the protocol of the image store",
            "name": "protocol",
            "type": "string"
          },
          {
            "description": "the name of the image store",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the url of the image store",
            "name": "url",
            "type": "string"
          },
          {
            "description": "the Zone ID of the image store",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the Zone name of the image store",
            "name": "zonename",
            "type": "string"
          }
        ],
        "since": "4.2.0"
      },
      {
        "description": "Creates a l2tp/ipsec remote access vpn",
        "isasync": true,
        "name": "createRemoteAccessVpn",
        "params": [
          {
            "description": "an optional account for the VPN. Must be used with domainId.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "an optional domainId for the VPN. If the account parameter is used, domainId must also be used.",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain,updateDomain",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "if true, firewall rule for source/end public port is automatically created; if false - firewall rule has to be created explicitely. Has value true by default",
            "length": 255,
            "name": "openfirewall",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "an optional field, whether to the display the vpn to the end user or not",
            "length": 255,
            "name": "fordisplay",
            "required": false,
            "since": "4.4",
            "type": "boolean"
          },
          {
            "description": "the range of ip addresses to allocate to vpn clients. The first ip in the range will be taken by the vpn server",
            "length": 255,
            "name": "iprange",
            "required": false,
            "type": "string"
          },
          {
            "description": "public ip address id of the vpn server",
            "length": 255,
            "name": "publicipid",
            "related": "associateIpAddress,restartNetwork,updateIpAddress,listPublicIpAddresses,listPublicIpAddresses,associateIpAddress",
            "required": true,
            "type": "uuid"
          }
        ],
        "related": "updateRemoteAccessVpn,listRemoteAccessVpns",
        "response": [
          {
            "description": "the public ip address of the vpn server",
            "name": "publicipid",
            "type": "string"
          },
          {
            "description": "the range of ips to allocate to the clients",
            "name": "iprange",
            "type": "string"
          },
          {
            "description": "the domain name of the account of the remote access vpn",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the account of the remote access vpn",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the public ip address of the vpn server",
            "name": "publicip",
            "type": "string"
          },
          {
            "description": "the id of the remote access vpn",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the domain id of the account of the remote access vpn",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the project name of the vpn",
            "name": "project",
            "type": "string"
          },
          {
            "description": "the state of the rule",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the project id of the vpn",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "is vpn for display to the regular user",
            "name": "fordisplay",
            "type": "boolean"
          },
          {
            "description": "the ipsec preshared key",
            "name": "presharedkey",
            "type": "string"
          }
        ]
      },
      {
        "description": "Changes the service offering for a virtual machine. The virtual machine must be in a \"Stopped\" state for this command to take effect.",
        "isasync": false,
        "name": "changeServiceForVirtualMachine",
        "params": [
          {
            "description": "The ID of the virtual machine",
            "length": 255,
            "name": "id",
            "related": "stopVirtualMachine,changeServiceForVirtualMachine,listVirtualMachines,detachIso,updateVMAffinityGroup,revertToVMSnapshot,deployVirtualMachine,migrateVirtualMachine,rebootVirtualMachine,recoverVirtualMachine,updateDefaultNicForVirtualMachine,migrateVirtualMachineWithVolume,addNicToVirtualMachine,updateVmNicIp,startVirtualMachine,listVirtualMachines,updateVirtualMachine,destroyVirtualMachine,removeNicFromVirtualMachine,removeNicFromVirtualMachine,deployVirtualMachine,destroyVirtualMachine,addNicToVirtualMachine,updateVirtualMachine,rebootVirtualMachine,updateVMAffinityGroup,revertToVMSnapshot,attachIso,resetPasswordForVirtualMachine,assignVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,resetSSHKeyForVirtualMachine,resetPasswordForVirtualMachine,detachIso,changeServiceForVirtualMachine,attachIso,updateDefaultNicForVirtualMachine,startVirtualMachine,stopVirtualMachine",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "name value pairs of custom parameters for cpu, memory and cpunumber. example details[i].name=value",
            "length": 255,
            "name": "details",
            "required": false,
            "type": "map"
          },
          {
            "description": "the service offering ID to apply to the virtual machine",
            "length": 255,
            "name": "serviceofferingid",
            "related": "updateServiceOffering,listServiceOfferings,createServiceOffering",
            "required": true,
            "type": "uuid"
          }
        ],
        "related": "stopVirtualMachine,listVirtualMachines,detachIso,updateVMAffinityGroup,revertToVMSnapshot,deployVirtualMachine,migrateVirtualMachine,rebootVirtualMachine,recoverVirtualMachine,updateDefaultNicForVirtualMachine,migrateVirtualMachineWithVolume,addNicToVirtualMachine,updateVmNicIp,startVirtualMachine,listVirtualMachines,updateVirtualMachine,destroyVirtualMachine,removeNicFromVirtualMachine,removeNicFromVirtualMachine,deployVirtualMachine,destroyVirtualMachine,addNicToVirtualMachine,updateVirtualMachine,rebootVirtualMachine,updateVMAffinityGroup,revertToVMSnapshot,attachIso,resetPasswordForVirtualMachine,assignVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,resetSSHKeyForVirtualMachine,resetPasswordForVirtualMachine,detachIso,changeServiceForVirtualMachine,attachIso,updateDefaultNicForVirtualMachine,startVirtualMachine,stopVirtualMachine",
        "response": [
          {
            "description": "the name of the host for the virtual machine",
            "name": "hostname",
            "type": "string"
          },
          {
            "description": "the group ID of the virtual machine",
            "name": "groupid",
            "type": "string"
          },
          {
            "description": "the amount of the vm's CPU currently used",
            "name": "cpuused",
            "type": "string"
          },
          {
            "description": "the write (bytes) of disk on the vm",
            "name": "diskkbswrite",
            "type": "long"
          },
          {
            "description": "the speed of each cpu",
            "name": "cpuspeed",
            "type": "integer"
          },
          {
            "description": "the name of the service offering of the virtual machine",
            "name": "serviceofferingname",
            "type": "string"
          },
          {
            "description": "an alternate display text of the ISO attached to the virtual machine",
            "name": "isodisplaytext",
            "type": "string"
          },
          {
            "description": "the project name of the vm",
            "name": "project",
            "type": "string"
          },
          {
            "description": "the group name of the virtual machine",
            "name": "group",
            "type": "string"
          },
          {
            "description": "the ID of the virtual machine",
            "name": "id",
            "type": "string"
          },
          {
            "description": "public IP address id associated with vm via Static nat rule",
            "name": "publicipid",
            "type": "string"
          },
          {
            "description": "the hypervisor on which the template runs",
            "name": "hypervisor",
            "type": "string"
          },
          {
            "description": "public IP address id associated with vm via Static nat rule",
            "name": "publicip",
            "type": "string"
          },
          {
            "description": "the name of the virtual machine",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the name of the template for the virtual machine",
            "name": "templatename",
            "type": "string"
          },
          {
            "description": "the account associated with the virtual machine",
            "name": "account",
            "type": "string"
          },
          {
            "description": "user generated name. The name of the virtual machine is returned if no displayname exists.",
            "name": "displayname",
            "type": "string"
          },
          {
            "description": "list of security groups associated with the virtual machine",
            "name": "securitygroup",
            "response": [
              {
                "description": "the account owning the security group",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the list of virtualmachine ids associated with this securitygroup",
                "name": "virtualmachineids",
                "type": "set"
              },
              {
                "description": "the project name of the group",
                "name": "project",
                "type": "string"
              },
              {
                "description": "the project id of the group",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "the list of ingress rules associated with the security group",
                "name": "ingressrule",
                "response": [
                  {
                    "description": "the type of the ICMP message response",
                    "name": "icmptype",
                    "type": "integer"
                  },
                  {
                    "description": "the code for the ICMP message response",
                    "name": "icmpcode",
                    "type": "integer"
                  },
                  {
                    "description": "the ending IP of the security group rule ",
                    "name": "endport",
                    "type": "integer"
                  },
                  {
                    "description": "security group name",
                    "name": "securitygroupname",
                    "type": "string"
                  },
                  {
                    "description": "the CIDR notation for the base IP address of the security group rule",
                    "name": "cidr",
                    "type": "string"
                  },
                  {
                    "description": "the protocol of the security group rule",
                    "name": "protocol",
                    "type": "string"
                  },
                  {
                    "description": "the list of resource tags associated with the rule",
                    "name": "tags",
                    "response": [
                      {
                        "description": "the account associated with the tag",
                        "name": "account",
                        "type": "string"
                      },
                      {
                        "description": "the project name where tag belongs to",
                        "name": "project",
                        "type": "string"
                      },
                      {
                        "description": "the project id the tag belongs to",
                        "name": "projectid",
                        "type": "string"
                      },
                      {
                        "description": "the ID of the domain associated with the tag",
                        "name": "domainid",
                        "type": "string"
                      },
                      {
                        "description": "customer associated with the tag",
                        "name": "customer",
                        "type": "string"
                      },
                      {
                        "description": "id of the resource",
                        "name": "resourceid",
                        "type": "string"
                      },
                      {
                        "description": "the domain associated with the tag",
                        "name": "domain",
                        "type": "string"
                      },
                      {
                        "description": "tag key name",
                        "name": "key",
                        "type": "string"
                      },
                      {
                        "description": "resource type",
                        "name": "resourcetype",
                        "type": "string"
                      },
                      {
                        "description": "tag value",
                        "name": "value",
                        "type": "string"
                      }
                    ],
                    "type": "set"
                  },
                  {
                    "description": "account owning the security group rule",
                    "name": "account",
                    "type": "string"
                  },
                  {
                    "description": "the id of the security group rule",
                    "name": "ruleid",
                    "type": "string"
                  },
                  {
                    "description": "the starting IP of the security group rule",
                    "name": "startport",
                    "type": "integer"
                  }
                ],
                "type": "set"
              },
              {
                "description": "the list of resource tags associated with the rule",
                "name": "tags",
                "response": [
                  {
                    "description": "the project name where tag belongs to",
                    "name": "project",
                    "type": "string"
                  },
                  {
                    "description": "the ID of the domain associated with the tag",
                    "name": "domainid",
                    "type": "string"
                  },
                  {
                    "description": "tag key name",
                    "name": "key",
                    "type": "string"
                  },
                  {
                    "description": "the account associated with the tag",
                    "name": "account",
                    "type": "string"
                  },
                  {
                    "description": "the project id the tag belongs to",
                    "name": "projectid",
                    "type": "string"
                  },
                  {
                    "description": "tag value",
                    "name": "value",
                    "type": "string"
                  },
                  {
                    "description": "resource type",
                    "name": "resourcetype",
                    "type": "string"
                  },
                  {
                    "description": "the domain associated with the tag",
                    "name": "domain",
                    "type": "string"
                  },
                  {
                    "description": "customer associated with the tag",
                    "name": "customer",
                    "type": "string"
                  },
                  {
                    "description": "id of the resource",
                    "name": "resourceid",
                    "type": "string"
                  }
                ],
                "type": "set"
              },
              {
                "description": "the name of the security group",
                "name": "name",
                "type": "string"
              },
              {
                "description": "the description of the security group",
                "name": "description",
                "type": "string"
              },
              {
                "description": "the domain name of the security group",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "the number of virtualmachines associated with this securitygroup",
                "name": "virtualmachinecount",
                "type": "integer"
              },
              {
                "description": "the list of egress rules associated with the security group",
                "name": "egressrule",
                "response": [
                  {
                    "description": "the protocol of the security group rule",
                    "name": "protocol",
                    "type": "string"
                  },
                  {
                    "description": "the starting IP of the security group rule",
                    "name": "startport",
                    "type": "integer"
                  },
                  {
                    "description": "the id of the security group rule",
                    "name": "ruleid",
                    "type": "string"
                  },
                  {
                    "description": "the code for the ICMP message response",
                    "name": "icmpcode",
                    "type": "integer"
                  },
                  {
                    "description": "account owning the security group rule",
                    "name": "account",
                    "type": "string"
                  },
                  {
                    "description": "security group name",
                    "name": "securitygroupname",
                    "type": "string"
                  },
                  {
                    "description": "the type of the ICMP message response",
                    "name": "icmptype",
                    "type": "integer"
                  },
                  {
                    "description": "the ending IP of the security group rule ",
                    "name": "endport",
                    "type": "integer"
                  },
                  {
                    "description": "the CIDR notation for the base IP address of the security group rule",
                    "name": "cidr",
                    "type": "string"
                  },
                  {
                    "description": "the list of resource tags associated with the rule",
                    "name": "tags",
                    "response": [
                      {
                        "description": "id of the resource",
                        "name": "resourceid",
                        "type": "string"
                      },
                      {
                        "description": "the ID of the domain associated with the tag",
                        "name": "domainid",
                        "type": "string"
                      },
                      {
                        "description": "the domain associated with the tag",
                        "name": "domain",
                        "type": "string"
                      },
                      {
                        "description": "tag value",
                        "name": "value",
                        "type": "string"
                      },
                      {
                        "description": "the account associated with the tag",
                        "name": "account",
                        "type": "string"
                      },
                      {
                        "description": "customer associated with the tag",
                        "name": "customer",
                        "type": "string"
                      },
                      {
                        "description": "resource type",
                        "name": "resourcetype",
                        "type": "string"
                      },
                      {
                        "description": "tag key name",
                        "name": "key",
                        "type": "string"
                      },
                      {
                        "description": "the project name where tag belongs to",
                        "name": "project",
                        "type": "string"
                      },
                      {
                        "description": "the project id the tag belongs to",
                        "name": "projectid",
                        "type": "string"
                      }
                    ],
                    "type": "set"
                  }
                ],
                "type": "set"
              },
              {
                "description": "the ID of the security group",
                "name": "id",
                "type": "string"
              },
              {
                "description": "the domain ID of the security group",
                "name": "domainid",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "true if the password rest feature is enabled, false otherwise",
            "name": "passwordenabled",
            "type": "boolean"
          },
          {
            "description": "the outgoing network traffic on the host",
            "name": "networkkbswrite",
            "type": "long"
          },
          {
            "description": "the read (bytes) of disk on the vm",
            "name": "diskkbsread",
            "type": "long"
          },
          {
            "description": "the ID of the domain in which the virtual machine exists",
            "name": "domainid",
            "type": "string"
          },
          {},
          {
            "description": "State of the Service from LB rule",
            "name": "servicestate",
            "type": "string"
          },
          {
            "description": "the name of the availability zone for the virtual machine",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the state of the virtual machine",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the user's ID who deployed the virtual machine",
            "name": "userid",
            "type": "string"
          },
          {
            "description": "the memory allocated for the virtual machine",
            "name": "memory",
            "type": "integer"
          },
          {
            "description": "the project id of the vm",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the ID of the service offering of the virtual machine",
            "name": "serviceofferingid",
            "type": "string"
          },
          {
            "description": "the name of the ISO attached to the virtual machine",
            "name": "isoname",
            "type": "string"
          },
          {
            "description": "the date when this virtual machine was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "the ID of the availablility zone for the virtual machine",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the name of the disk offering of the virtual machine",
            "name": "diskofferingname",
            "type": "string"
          },
          {
            "description": "the write (io) of disk on the vm",
            "name": "diskiowrite",
            "type": "long"
          },
          {
            "description": "the ID of the host for the virtual machine",
            "name": "hostid",
            "type": "string"
          },
          {
            "description": "the virtual network for the service offering",
            "name": "forvirtualnetwork",
            "type": "boolean"
          },
          {
            "description": "the vgpu type used by the virtual machine",
            "name": "vgpu",
            "type": "string"
          },
          {
            "description": "the ID of the disk offering of the virtual machine",
            "name": "diskofferingid",
            "type": "string"
          },
          {
            "description": "Os type ID of the virtual machine",
            "name": "guestosid",
            "type": "string"
          },
          {
            "description": "true if high-availability is enabled, false otherwise",
            "name": "haenable",
            "type": "boolean"
          },
          {
            "description": "the number of cpu this virtual machine is running with",
            "name": "cpunumber",
            "type": "integer"
          },
          {
            "description": "the user's name who deployed the virtual machine",
            "name": "username",
            "type": "string"
          },
          {
            "description": "the read (io) of disk on the vm",
            "name": "diskioread",
            "type": "long"
          },
          {
            "description": "ssh key-pair",
            "name": "keypair",
            "type": "string"
          },
          {
            "description": "the list of nics associated with vm",
            "name": "nic",
            "response": [
              {
                "description": "the type of the nic",
                "name": "type",
                "type": "string"
              },
              {
                "description": "true if nic is default, false otherwise",
                "name": "macaddress",
                "type": "string"
              },
              {
                "description": "the cidr of IPv6 network",
                "name": "ip6cidr",
                "type": "string"
              },
              {
                "description": "the ID of the nic",
                "name": "id",
                "type": "string"
              },
              {
                "description": "the IPv6 address of network",
                "name": "ip6address",
                "type": "string"
              },
              {
                "description": "the ip address of the nic",
                "name": "ipaddress",
                "type": "string"
              },
              {
                "description": "the ID of the corresponding network",
                "name": "networkid",
                "type": "string"
              },
              {
                "description": "the broadcast uri of the nic",
                "name": "broadcasturi",
                "type": "string"
              },
              {
                "description": "Id of the vm to which the nic belongs",
                "name": "virtualmachineid",
                "type": "string"
              },
              {
                "description": "the gateway of the nic",
                "name": "gateway",
                "type": "string"
              },
              {
                "description": "the gateway of IPv6 network",
                "name": "ip6gateway",
                "type": "string"
              },
              {
                "description": "the name of the corresponding network",
                "name": "networkname",
                "type": "string"
              },
              {
                "description": "true if nic is default, false otherwise",
                "name": "isdefault",
                "type": "boolean"
              },
              {
                "description": "the isolation uri of the nic",
                "name": "isolationuri",
                "type": "string"
              },
              {
                "description": "the Secondary ipv4 addr of nic",
                "name": "secondaryip",
                "type": "list"
              },
              {
                "description": "the traffic type of the nic",
                "name": "traffictype",
                "type": "string"
              },
              {
                "description": "device id for the network when plugged into the virtual machine",
                "name": "deviceid",
                "type": "string"
              },
              {
                "description": "the netmask of the nic",
                "name": "netmask",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "Vm details in key/value pairs.",
            "name": "details",
            "type": "map"
          },
          {
            "description": "true if vm contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory.",
            "name": "isdynamicallyscalable",
            "type": "boolean"
          },
          {
            "description": "the ID of the ISO attached to the virtual machine",
            "name": "isoid",
            "type": "string"
          },
          {
            "description": "instance name of the user vm; this parameter is returned to the ROOT admin only",
            "name": "instancename",
            "type": "string"
          },
          {
            "description": "device ID of the root volume",
            "name": "rootdeviceid",
            "type": "long"
          },
          {
            "description": "the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.",
            "name": "templateid",
            "type": "string"
          },
          {
            "description": "device type of the root volume",
            "name": "rootdevicetype",
            "type": "string"
          },
          {
            "description": "the password (if exists) of the virtual machine",
            "name": "password",
            "type": "string"
          },
          {
            "description": "list of affinity groups associated with the virtual machine",
            "name": "affinitygroup",
            "response": [
              {
                "description": "the project ID of the affinity group",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "the name of the affinity group",
                "name": "name",
                "type": "string"
              },
              {
                "description": "the description of the affinity group",
                "name": "description",
                "type": "string"
              },
              {
                "description": "the type of the affinity group",
                "name": "type",
                "type": "string"
              },
              {
                "description": "the domain name of the affinity group",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "virtual machine IDs associated with this affinity group",
                "name": "virtualmachineIds",
                "type": "list"
              },
              {
                "description": "the project name of the affinity group",
                "name": "project",
                "type": "string"
              },
              {
                "description": "the domain ID of the affinity group",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the ID of the affinity group",
                "name": "id",
                "type": "string"
              },
              {
                "description": "the account owning the affinity group",
                "name": "account",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "the name of the domain in which the virtual machine exists",
            "name": "domain",
            "type": "string"
          },
          {
            "description": " an alternate display text of the template for the virtual machine",
            "name": "templatedisplaytext",
            "type": "string"
          },
          {
            "description": "the incoming network traffic on the vm",
            "name": "networkkbsread",
            "type": "long"
          },
          {
            "description": "OS type id of the vm",
            "name": "ostypeid",
            "type": "long"
          },
          {
            "description": "the list of resource tags associated with vm",
            "name": "tags",
            "response": [
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              },
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "an optional field whether to the display the vm to the end user or not.",
            "name": "displayvm",
            "type": "boolean"
          }
        ]
      },
      {
        "description": "Starts a router.",
        "isasync": true,
        "name": "startRouter",
        "params": [
          {
            "description": "the ID of the router",
            "length": 255,
            "name": "id",
            "related": "changeServiceForRouter,rebootRouter,destroyRouter,listInternalLoadBalancerVMs,startInternalLoadBalancerVM,stopInternalLoadBalancerVM,listRouters,startRouter",
            "required": true,
            "type": "uuid"
          }
        ],
        "related": "changeServiceForRouter,rebootRouter,destroyRouter,listInternalLoadBalancerVMs,startInternalLoadBalancerVM,stopInternalLoadBalancerVM,listRouters",
        "response": [
          {
            "description": "the project name of the address",
            "name": "project",
            "type": "string"
          },
          {
            "description": "the hostname for the router",
            "name": "hostname",
            "type": "string"
          },
          {
            "description": "if this router is an redundant virtual router",
            "name": "isredundantrouter",
            "type": "boolean"
          },
          {
            "description": "the state of redundant virtual router",
            "name": "redundantstate",
            "type": "string"
          },
          {
            "description": "the ID of the corresponding guest network",
            "name": "guestnetworkid",
            "type": "string"
          },
          {
            "description": "the version of template",
            "name": "version",
            "type": "string"
          },
          {
            "description": "true if the router template requires upgrader",
            "name": "requiresupgrade",
            "type": "boolean"
          },
          {
            "description": "the name of the service offering of the virtual machine",
            "name": "serviceofferingname",
            "type": "string"
          },
          {
            "description": "the Zone name for the router",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the state of the router",
            "name": "state",
            "type": "state"
          },
          {
            "description": "the domain ID associated with the router",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the second DNS for the router",
            "name": "dns2",
            "type": "string"
          },
          {
            "description": "the gateway for the router",
            "name": "gateway",
            "type": "string"
          },
          {
            "description": "the public MAC address for the router",
            "name": "publicmacaddress",
            "type": "string"
          },
          {
            "description": "the template ID for the router",
            "name": "templateid",
            "type": "string"
          },
          {
            "description": "the name of VPC the router belongs to",
            "name": "vpcname",
            "type": "string"
          },
          {
            "description": "the host ID for the router",
            "name": "hostid",
            "type": "string"
          },
          {
            "description": "the hypervisor on which the template runs",
            "name": "hypervisor",
            "type": "string"
          },
          {
            "description": "role of the domain router",
            "name": "role",
            "type": "string"
          },
          {
            "description": "the guest MAC address for the router",
            "name": "guestmacaddress",
            "type": "string"
          },
          {
            "description": "the account associated with the router",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the version of scripts",
            "name": "scriptsversion",
            "type": "string"
          },
          {
            "description": "the id of the router",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the name of the router",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the Pod ID for the router",
            "name": "podid",
            "type": "string"
          },
          {
            "description": "the ID of the corresponding link local network",
            "name": "linklocalnetworkid",
            "type": "string"
          },
          {
            "description": "the link local netmask for the router",
            "name": "linklocalnetmask",
            "type": "string"
          },
          {
            "description": "the first DNS for the router",
            "name": "dns1",
            "type": "string"
          },
          {
            "description": "the public IP address for the router",
            "name": "publicip",
            "type": "string"
          },
          {
            "description": "the guest IP address for the router",
            "name": "guestipaddress",
            "type": "string"
          },
          {
            "description": "the first IPv6 DNS for the router",
            "name": "ip6dns1",
            "type": "string"
          },
          {
            "description": "the domain associated with the router",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the link local IP address for the router",
            "name": "linklocalip",
            "type": "string"
          },
          {
            "description": "the public netmask for the router",
            "name": "publicnetmask",
            "type": "string"
          },
          {
            "description": "the Zone ID for the router",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the ID of the service offering of the virtual machine",
            "name": "serviceofferingid",
            "type": "string"
          },
          {
            "description": "the link local MAC address for the router",
            "name": "linklocalmacaddress",
            "type": "string"
          },
          {
            "description": "the name of the corresponding guest network",
            "name": "guestnetworkname",
            "type": "string"
          },
          {
            "description": "the second IPv6 DNS for the router",
            "name": "ip6dns2",
            "type": "string"
          },
          {
            "description": "the network domain for the router",
            "name": "networkdomain",
            "type": "string"
          },
          {
            "description": "the guest netmask for the router",
            "name": "guestnetmask",
            "type": "string"
          },
          {
            "description": "the date and time the router was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "the project id of the ipaddress",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "VPC the router belongs to",
            "name": "vpcid",
            "type": "string"
          },
          {
            "description": "the list of nics associated with the router",
            "name": "nic",
            "response": [
              {
                "description": "true if nic is default, false otherwise",
                "name": "macaddress",
                "type": "string"
              },
              {
                "description": "the Secondary ipv4 addr of nic",
                "name": "secondaryip",
                "type": "list"
              },
              {
                "description": "the isolation uri of the nic",
                "name": "isolationuri",
                "type": "string"
              },
              {
                "description": "the ID of the corresponding network",
                "name": "networkid",
                "type": "string"
              },
              {
                "description": "device id for the network when plugged into the virtual machine",
                "name": "deviceid",
                "type": "string"
              },
              {
                "description": "the broadcast uri of the nic",
                "name": "broadcasturi",
                "type": "string"
              },
              {
                "description": "the gateway of IPv6 network",
                "name": "ip6gateway",
                "type": "string"
              },
              {
                "description": "the IPv6 address of network",
                "name": "ip6address",
                "type": "string"
              },
              {
                "description": "the cidr of IPv6 network",
                "name": "ip6cidr",
                "type": "string"
              },
              {
                "description": "the type of the nic",
                "name": "type",
                "type": "string"
              },
              {
                "description": "true if nic is default, false otherwise",
                "name": "isdefault",
                "type": "boolean"
              },
              {
                "description": "the traffic type of the nic",
                "name": "traffictype",
                "type": "string"
              },
              {
                "description": "the netmask of the nic",
                "name": "netmask",
                "type": "string"
              },
              {
                "description": "the gateway of the nic",
                "name": "gateway",
                "type": "string"
              },
              {
                "description": "Id of the vm to which the nic belongs",
                "name": "virtualmachineid",
                "type": "string"
              },
              {
                "description": "the ID of the nic",
                "name": "id",
                "type": "string"
              },
              {
                "description": "the name of the corresponding network",
                "name": "networkname",
                "type": "string"
              },
              {
                "description": "the ip address of the nic",
                "name": "ipaddress",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "the ID of the corresponding public network",
            "name": "publicnetworkid",
            "type": "string"
          }
        ]
      },
      {
        "description": "Lists all available OS mappings for given hypervisor",
        "isasync": false,
        "name": "listGuestOsMapping",
        "params": [
          {
            "description": "list mapping by its UUID",
            "length": 255,
            "name": "id",
            "related": "listGuestOsMapping,addGuestOsMapping,updateGuestOsMapping",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list Guest OS mapping by hypervisor version. Must be used with hypervisor parameter",
            "length": 255,
            "name": "hypervisorversion",
            "required": false,
            "type": "string"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "list Guest OS mapping by hypervisor",
            "length": 255,
            "name": "hypervisor",
            "required": false,
            "type": "string"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "list mapping by Guest OS Type UUID",
            "length": 255,
            "name": "ostypeid",
            "related": "addGuestOs,listOsTypes",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          }
        ],
        "related": "addGuestOsMapping,updateGuestOsMapping",
        "response": [
          {
            "description": "the ID of the Guest OS mapping",
            "name": "id",
            "type": "string"
          },
          {
            "description": "hypervisor specific name for the Guest OS",
            "name": "osnameforhypervisor",
            "type": "string"
          },
          {
            "description": "standard display name for the Guest OS",
            "name": "osdisplayname",
            "type": "string"
          },
          {
            "description": "the ID of the Guest OS type",
            "name": "ostypeid",
            "type": "string"
          },
          {
            "description": "the hypervisor",
            "name": "hypervisor",
            "type": "string"
          },
          {
            "description": "version of the hypervisor for mapping",
            "name": "hypervisorversion",
            "type": "string"
          },
          {
            "description": "is the mapping user defined",
            "name": "isuserdefined",
            "type": "string"
          }
        ],
        "since": "4.4.0"
      },
      {
        "description": "List all public, private, and privileged templates.",
        "isasync": false,
        "name": "listTemplates",
        "params": [
          {
            "description": "List resources by tags (key/value pairs)",
            "length": 255,
            "name": "tags",
            "required": false,
            "type": "map"
          },
          {
            "description": "list objects by project",
            "length": 255,
            "name": "projectid",
            "related": "activateProject,createProject,updateProject,suspendProject,listProjectAccounts,listProjects",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "show removed templates as well",
            "length": 255,
            "name": "showremoved",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "list only resources belonging to the domain specified",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain,updateDomain",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "possible values are \"featured\", \"self\", \"selfexecutable\",\"sharedexecutable\",\"executable\", and \"community\". * featured : templates that have been marked as featured and public. * self : templates that have been registered or created by the calling user. * selfexecutable : same as self, but only returns templates that can be used to deploy a new VM. * sharedexecutable : templates ready to be deployed that have been granted to the calling user by another user. * executable : templates that are owned by the calling user, or public templates, that can be used to deploy a VM. * community : templates that have been marked as public but not featured. * all : all templates (only usable by admins).",
            "length": 255,
            "name": "templatefilter",
            "required": true,
            "type": "string"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
            "length": 255,
            "name": "isrecursive",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "list resources by account. Must be used with the domainId parameter.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "the template name",
            "length": 255,
            "name": "name",
            "required": false,
            "type": "string"
          },
          {
            "description": "the template ID",
            "length": 255,
            "name": "id",
            "related": "listIsos,registerIso,listTemplates,updateTemplate,copyTemplate,registerTemplate,registerTemplate,prepareTemplate,listTemplates,createTemplate,updateIso,registerIso,createTemplate,copyTemplate,listIsos,copyIso",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false",
            "length": 255,
            "name": "listall",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "list templates by zoneId",
            "length": 255,
            "name": "zoneid",
            "related": "createZone,updateZone,listZones,listZones",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "the hypervisor for which to restrict the search",
            "length": 255,
            "name": "hypervisor",
            "required": false,
            "type": "string"
          }
        ],
        "related": "listIsos,registerIso,updateTemplate,copyTemplate,registerTemplate,registerTemplate,prepareTemplate,listTemplates,createTemplate,updateIso,registerIso,createTemplate,copyTemplate,listIsos,copyIso",
        "response": [
          {
            "description": "true if this template is a public template, false otherwise",
            "name": "ispublic",
            "type": "boolean"
          },
          {
            "description": "true if the reset password feature is enabled, false otherwise",
            "name": "passwordenabled",
            "type": "boolean"
          },
          {
            "description": "the ID of the OS type for this template.",
            "name": "ostypeid",
            "type": "string"
          },
          {
            "description": "true if the ISO is bootable, false otherwise",
            "name": "bootable",
            "type": "boolean"
          },
          {
            "description": "the list of resource tags associated with tempate",
            "name": "tags",
            "response": [
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "the account id to which the template belongs",
            "name": "accountid",
            "type": "string"
          },
          {
            "description": "the ID of the domain to which the template belongs",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the project name of the template",
            "name": "project",
            "type": "string"
          },
          {
            "description": "the ID of the secondary storage host for the template",
            "name": "hostid",
            "type": "string"
          },
          {
            "description": "additional key/value details tied with template",
            "name": "details",
            "type": "map"
          },
          {
            "description": "the type of the template",
            "name": "templatetype",
            "type": "string"
          },
          {
            "description": "true if the template is ready to be deployed from, false otherwise.",
            "name": "isready",
            "type": "boolean"
          },
          {
            "description": "true if template is sshkey enabled, false otherwise",
            "name": "sshkeyenabled",
            "type": "boolean"
          },
          {
            "description": "the date this template was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "the name of the domain to which the template belongs",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "true if the template is extractable, false otherwise",
            "name": "isextractable",
            "type": "boolean"
          },
          {
            "description": "the template ID",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the size of the template",
            "name": "size",
            "type": "long"
          },
          {
            "description": "the name of the OS type for this template.",
            "name": "ostypename",
            "type": "string"
          },
          {
            "description": "the status of the template",
            "name": "status",
            "type": "string"
          },
          {
            "description": "true if this template is a featured template, false otherwise",
            "name": "isfeatured",
            "type": "boolean"
          },
          {
            "description": "true if template contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory",
            "name": "isdynamicallyscalable",
            "type": "boolean"
          },
          {
            "description": "the project id of the template",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the format of the template.",
            "name": "format",
            "type": "imageformat"
          },
          {
            "description": "the name of the secondary storage host for the template",
            "name": "hostname",
            "type": "string"
          },
          {
            "description": "the template name",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the tag of this template",
            "name": "templatetag",
            "type": "string"
          },
          {
            "description": "the date this template was removed",
            "name": "removed",
            "type": "date"
          },
          {
            "description": "the template ID of the parent template if present",
            "name": "sourcetemplateid",
            "type": "string"
          },
          {
            "description": "the account name to which the template belongs",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the hypervisor on which the template runs",
            "name": "hypervisor",
            "type": "string"
          },
          {
            "description": "true if the template is managed across all Zones, false otherwise",
            "name": "crossZones",
            "type": "boolean"
          },
          {
            "description": "the ID of the zone for this template",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the name of the zone for this template",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "checksum of the template",
            "name": "checksum",
            "type": "string"
          },
          {
            "description": "the template display text",
            "name": "displaytext",
            "type": "string"
          }
        ]
      },
      {
        "description": "Creates an autoscale policy for a provision or deprovision action, the action is taken when the all the conditions evaluates to true for the specified duration. The policy is in effect once it is attached to a autscale vm group.",
        "isasync": true,
        "name": "createAutoScalePolicy",
        "params": [
          {
            "description": "the cool down period for which the policy should not be evaluated after the action has been taken",
            "length": 255,
            "name": "quiettime",
            "required": false,
            "type": "integer"
          },
          {
            "description": "the action to be executed if all the conditions evaluate to true for the specified duration.",
            "length": 255,
            "name": "action",
            "required": true,
            "type": "string"
          },
          {
            "description": "the list of IDs of the conditions that are being evaluated on every interval",
            "length": 255,
            "name": "conditionids",
            "related": "listConditions,createCondition",
            "required": true,
            "type": "list"
          },
          {
            "description": "the duration for which the conditions have to be true before action is taken",
            "length": 255,
            "name": "duration",
            "required": true,
            "type": "integer"
          }
        ],
        "related": "listAutoScalePolicies,updateAutoScalePolicy",
        "response": [
          {
            "description": "the account owning the autoscale policy",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the project name of the autoscale policy",
            "name": "project",
            "type": "string"
          },
          {
            "description": "the domain ID of the autoscale policy",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the duration for which the conditions have to be true before action is taken",
            "name": "duration",
            "type": "integer"
          },
          {
            "description": "the action to be executed if all the conditions evaluate to true for the specified duration.",
            "name": "action",
            "type": "string"
          },
          {
            "description": "the domain name of the autoscale policy",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the list of IDs of the conditions that are being evaluated on every interval",
            "name": "conditions",
            "type": "list"
          },
          {
            "description": "the cool down period for which the policy should not be evaluated after the action has been taken",
            "name": "quiettime",
            "type": "integer"
          },
          {
            "description": "the project id autoscale policy",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the autoscale policy ID",
            "name": "id",
            "type": "string"
          }
        ]
      },
      {
        "description": "Lists physical networks",
        "isasync": false,
        "name": "listPhysicalNetworks",
        "params": [
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "search by name",
            "length": 255,
            "name": "name",
            "required": false,
            "type": "string"
          },
          {
            "description": "the Zone ID for the physical network",
            "length": 255,
            "name": "zoneid",
            "related": "createZone,updateZone,listZones,listZones",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list physical network by id",
            "length": 255,
            "name": "id",
            "related": "createPhysicalNetwork,updatePhysicalNetwork,listPhysicalNetworks",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          }
        ],
        "related": "createPhysicalNetwork,updatePhysicalNetwork",
        "response": [
          {
            "description": "state of the physical network",
            "name": "state",
            "type": "string"
          },
          {
            "description": "isolation methods",
            "name": "isolationmethods",
            "type": "string"
          },
          {
            "description": "zone id of the physical network",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the uuid of the physical network",
            "name": "id",
            "type": "string"
          },
          {
            "description": "comma separated tag",
            "name": "tags",
            "type": "string"
          },
          {
            "description": "name of the physical network",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the vlan of the physical network",
            "name": "vlan",
            "type": "string"
          },
          {
            "description": "the domain id of the physical network owner",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the speed of the physical network",
            "name": "networkspeed",
            "type": "string"
          },
          {
            "description": "Broadcast domain range of the physical network",
            "name": "broadcastdomainrange",
            "type": "string"
          }
        ],
        "since": "3.0.0"
      },
      {
        "description": "Lists all firewall rules for an IP address.",
        "isasync": false,
        "name": "listFirewallRules",
        "params": [
          {
            "description": "the ID of IP address of the firewall services",
            "length": 255,
            "name": "ipaddressid",
            "related": "associateIpAddress,restartNetwork,updateIpAddress,listPublicIpAddresses,listPublicIpAddresses,associateIpAddress",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list only resources belonging to the domain specified",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain,updateDomain",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "list resources by display flag; only ROOT admin is eligible to pass this parameter",
            "length": 255,
            "name": "fordisplay",
            "required": false,
            "since": "4.4",
            "type": "boolean"
          },
          {
            "description": "List resources by tags (key/value pairs)",
            "length": 255,
            "name": "tags",
            "required": false,
            "type": "map"
          },
          {
            "description": "list firewall rules for certain network",
            "length": 255,
            "name": "networkid",
            "related": "createNetwork,listNetscalerLoadBalancerNetworks,listPaloAltoFirewallNetworks,listNiciraNvpDeviceNetworks,listNetworks,updateNetwork,updateNetwork,createNetwork",
            "required": false,
            "since": "4.3",
            "type": "uuid"
          },
          {
            "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false",
            "length": 255,
            "name": "listall",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "list resources by account. Must be used with the domainId parameter.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "list objects by project",
            "length": 255,
            "name": "projectid",
            "related": "activateProject,createProject,updateProject,suspendProject,listProjectAccounts,listProjects",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "Lists rule with the specified ID.",
            "length": 255,
            "name": "id",
            "related": "listIpForwardingRules,listPortForwardingRules,updatePortForwardingRule,createPortForwardingRule,createIpForwardingRule",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
            "length": 255,
            "name": "isrecursive",
            "required": false,
            "type": "boolean"
          }
        ],
        "related": "updateEgressFirewallRule,createFirewallRule",
        "response": [
          {
            "description": "the list of resource tags associated with the rule",
            "name": "tags",
            "response": [
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              },
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              }
            ],
            "type": "list"
          },
          {
            "description": "type of the icmp message being sent",
            "name": "icmptype",
            "type": "integer"
          },
          {
            "description": "the ending port of firewall rule's port range",
            "name": "endport",
            "type": "integer"
          },
          {
            "description": "the state of the rule",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the starting port of firewall rule's port range",
            "name": "startport",
            "type": "integer"
          },
          {
            "description": "the ID of the firewall rule",
            "name": "id",
            "type": "string"
          },
          {
            "description": "error code for this icmp message",
            "name": "icmpcode",
            "type": "integer"
          },
          {
            "description": "the cidr list to forward traffic from",
            "name": "cidrlist",
            "type": "string"
          },
          {
            "description": "the protocol of the firewall rule",
            "name": "protocol",
            "type": "string"
          },
          {
            "description": "is rule for display to the regular user",
            "name": "fordisplay",
            "type": "boolean"
          },
          {
            "description": "the public ip address for the firewall rule",
            "name": "ipaddress",
            "type": "string"
          },
          {
            "description": "the public ip address id for the firewall rule",
            "name": "ipaddressid",
            "type": "string"
          },
          {
            "description": "the network id of the firewall rule",
            "name": "networkid",
            "type": "string"
          }
        ]
      },
      {
        "description": "Cleanups VM reservations in the database.",
        "isasync": true,
        "name": "cleanVMReservations",
        "params": [],
        "response": [
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          }
        ]
      },
      {
        "description": "Extracts an ISO",
        "isasync": true,
        "name": "extractIso",
        "params": [
          {
            "description": "the ID of the zone where the ISO is originally located",
            "length": 255,
            "name": "zoneid",
            "related": "createZone,updateZone,listZones,listZones",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "the URL to which the ISO would be extracted",
            "length": 255,
            "name": "url",
            "required": false,
            "type": "string"
          },
          {
            "description": "the ID of the ISO file",
            "length": 255,
            "name": "id",
            "related": "listIsos,registerIso,updateTemplate,copyTemplate,registerTemplate,registerTemplate,prepareTemplate,listTemplates,createTemplate,updateIso,registerIso,createTemplate,copyTemplate,listIsos,copyIso",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "the mode of extraction - HTTP_DOWNLOAD or FTP_UPLOAD",
            "length": 255,
            "name": "mode",
            "required": true,
            "type": "string"
          }
        ],
        "related": "extractTemplate,extractVolume",
        "response": [
          {
            "description": "the status of the extraction",
            "name": "status",
            "type": "string"
          },
          {
            "description": "if mode = upload then url of the uploaded entity. if mode = download the url from which the entity can be downloaded",
            "name": "url",
            "type": "string"
          },
          {
            "description": "the upload id of extracted object",
            "name": "extractId",
            "type": "string"
          },
          {
            "description": "zone ID the object was extracted from",
            "name": "zoneid",
            "type": "string"
          },
          {},
          {
            "description": "the name of the extracted object",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the time and date the object was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "the account id to which the extracted object belongs",
            "name": "accountid",
            "type": "string"
          },
          {
            "description": "the state of the extracted object",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the mode of extraction - upload or download",
            "name": "extractMode",
            "type": "string"
          },
          {
            "description": "the percentage of the entity uploaded to the specified location",
            "name": "uploadpercentage",
            "type": "integer"
          },
          {
            "description": "type of the storage",
            "name": "storagetype",
            "type": "string"
          },
          {
            "description": "",
            "name": "resultstring",
            "type": "string"
          },
          {
            "description": "the id of extracted object",
            "name": "id",
            "type": "string"
          },
          {
            "description": "zone name the object was extracted from",
            "name": "zonename",
            "type": "string"
          }
        ]
      },
      {
        "description": "Creates an affinity/anti-affinity group",
        "isasync": true,
        "name": "createAffinityGroup",
        "params": [
          {
            "description": "create affinity group for project",
            "length": 255,
            "name": "projectid",
            "related": "activateProject,createProject,updateProject,suspendProject,listProjectAccounts,listProjects",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "optional description of the affinity group",
            "length": 255,
            "name": "description",
            "required": false,
            "type": "string"
          },
          {
            "description": "Type of the affinity group from the available affinity/anti-affinity group types",
            "length": 255,
            "name": "type",
            "required": true,
            "type": "string"
          },
          {
            "description": "domainId of the account owning the affinity group",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain,updateDomain",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "name of the affinity group",
            "length": 255,
            "name": "name",
            "required": true,
            "type": "string"
          },
          {
            "description": "an account for the affinity group. Must be used with domainId.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          }
        ],
        "related": "",
        "response": [
          {
            "description": "the description of the affinity group",
            "name": "description",
            "type": "string"
          },
          {
            "description": "the name of the affinity group",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the domain name of the affinity group",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the type of the affinity group",
            "name": "type",
            "type": "string"
          },
          {
            "description": "the ID of the affinity group",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the project ID of the affinity group",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the account owning the affinity group",
            "name": "account",
            "type": "string"
          },
          {
            "description": "virtual machine IDs associated with this affinity group",
            "name": "virtualmachineIds",
            "type": "list"
          },
          {
            "description": "the domain ID of the affinity group",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the project name of the affinity group",
            "name": "project",
            "type": "string"
          }
        ]
      },
      {
        "description": "create secondary staging store.",
        "isasync": false,
        "name": "createSecondaryStagingStore",
        "params": [
          {
            "description": "the details for the staging store",
            "length": 255,
            "name": "details",
            "required": false,
            "type": "map"
          },
          {
            "description": "the URL for the staging store",
            "length": 255,
            "name": "url",
            "required": true,
            "type": "string"
          },
          {
            "description": "the staging store provider name",
            "length": 255,
            "name": "provider",
            "required": false,
            "type": "string"
          },
          {
            "description": "the Zone ID for the staging store",
            "length": 255,
            "name": "zoneid",
            "related": "createZone,updateZone,listZones,listZones",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "the scope of the staging store: zone only for now",
            "length": 255,
            "name": "scope",
            "required": false,
            "type": "string"
          }
        ],
        "related": "addImageStore,addSecondaryStorage,listImageStores,updateCloudToUseObjectStore,listSwifts,addImageStoreS3",
        "response": [
          {
            "description": "the name of the image store",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the Zone name of the image store",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the ID of the image store",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the url of the image store",
            "name": "url",
            "type": "string"
          },
          {
            "description": "the details of the image store",
            "name": "details",
            "type": "set"
          },
          {
            "description": "the provider name of the image store",
            "name": "providername",
            "type": "string"
          },
          {
            "description": "the protocol of the image store",
            "name": "protocol",
            "type": "string"
          },
          {
            "description": "the scope of the image store",
            "name": "scope",
            "type": "scopetype"
          },
          {
            "description": "the Zone ID of the image store",
            "name": "zoneid",
            "type": "string"
          }
        ]
      },
      {
        "description": "Lists all available Internal Load Balancer elements.",
        "isasync": false,
        "name": "listInternalLoadBalancerElements",
        "params": [
          {
            "description": "list internal load balancer elements by id",
            "length": 255,
            "name": "id",
            "related": "listInternalLoadBalancerElements,createInternalLoadBalancerElement,configureInternalLoadBalancerElement",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "list internal load balancer elements by enabled state",
            "length": 255,
            "name": "enabled",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "list internal load balancer elements by network service provider id",
            "length": 255,
            "name": "nspid",
            "related": "addNetworkServiceProvider,listTrafficTypes,listNetworkServiceProviders,updateNetworkServiceProvider",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          }
        ],
        "related": "createInternalLoadBalancerElement,configureInternalLoadBalancerElement",
        "response": [
          {
            "description": "the id of the internal load balancer element",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the physical network service provider id of the element",
            "name": "nspid",
            "type": "string"
          },
          {
            "description": "Enabled/Disabled the element",
            "name": "enabled",
            "type": "boolean"
          }
        ],
        "since": "4.2.0"
      },
      {
        "description": "Updates load balancer health check policy",
        "isasync": true,
        "name": "updateLBHealthCheckPolicy",
        "params": [
          {
            "description": "an optional field, whether to the display the policy to the end user or not",
            "length": 255,
            "name": "fordisplay",
            "required": false,
            "since": "4.4",
            "type": "boolean"
          },
          {
            "description": "an optional field, in case you want to set a custom id to the resource. Allowed to Root Admins only",
            "length": 255,
            "name": "customid",
            "required": false,
            "since": "4.4",
            "type": "string"
          },
          {
            "description": "ID of load balancer health check policy",
            "length": 255,
            "name": "id",
            "related": "listLBHealthCheckPolicies,createLBHealthCheckPolicy,updateLBHealthCheckPolicy",
            "required": true,
            "type": "uuid"
          }
        ],
        "related": "listLBHealthCheckPolicies,createLBHealthCheckPolicy",
        "response": [
          {
            "description": "the LB rule ID",
            "name": "lbruleid",
            "type": "string"
          },
          {
            "description": "the domain ID of the HealthCheck policy",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the list of healthcheckpolicies",
            "name": "healthcheckpolicy",
            "response": [
              {
                "description": "the pingpath  of the healthcheck policy",
                "name": "pingpath",
                "type": "string"
              },
              {
                "description": "the description of the healthcheck policy",
                "name": "description",
                "type": "string"
              },
              {
                "description": "Time to wait when receiving a response from the health check",
                "name": "responsetime",
                "type": "int"
              },
              {
                "description": "Number of consecutive health check failures before declaring an instance unhealthy.",
                "name": "unhealthcheckthresshold",
                "type": "int"
              },
              {
                "description": "Number of consecutive health check success before declaring an instance healthy",
                "name": "healthcheckthresshold",
                "type": "int"
              },
              {
                "description": "is policy for display to the regular user",
                "name": "fordisplay",
                "type": "boolean"
              },
              {
                "description": "Amount of time between health checks",
                "name": "healthcheckinterval",
                "type": "int"
              },
              {
                "description": "the state of the policy",
                "name": "state",
                "type": "string"
              },
              {
                "description": "the LB HealthCheck policy ID",
                "name": "id",
                "type": "string"
              }
            ],
            "type": "list"
          },
          {
            "description": "the domain of the HealthCheck policy",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the id of the zone the HealthCheck policy belongs to",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the account of the HealthCheck policy",
            "name": "account",
            "type": "string"
          }
        ],
        "since": "4.4"
      },
      {
        "description": "Reboots a virtual machine.",
        "isasync": true,
        "name": "rebootVirtualMachine",
        "params": [
          {
            "description": "The ID of the virtual machine",
            "length": 255,
            "name": "id",
            "related": "stopVirtualMachine,listVirtualMachines,detachIso,updateVMAffinityGroup,revertToVMSnapshot,deployVirtualMachine,migrateVirtualMachine,rebootVirtualMachine,recoverVirtualMachine,updateDefaultNicForVirtualMachine,migrateVirtualMachineWithVolume,addNicToVirtualMachine,updateVmNicIp,startVirtualMachine,listVirtualMachines,updateVirtualMachine,destroyVirtualMachine,removeNicFromVirtualMachine,removeNicFromVirtualMachine,deployVirtualMachine,destroyVirtualMachine,addNicToVirtualMachine,updateVirtualMachine,rebootVirtualMachine,updateVMAffinityGroup,revertToVMSnapshot,attachIso,resetPasswordForVirtualMachine,assignVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,resetSSHKeyForVirtualMachine,resetPasswordForVirtualMachine,detachIso,changeServiceForVirtualMachine,attachIso,updateDefaultNicForVirtualMachine,startVirtualMachine,stopVirtualMachine",
            "required": true,
            "type": "uuid"
          }
        ],
        "related": "stopVirtualMachine,listVirtualMachines,detachIso,updateVMAffinityGroup,revertToVMSnapshot,deployVirtualMachine,migrateVirtualMachine,recoverVirtualMachine,updateDefaultNicForVirtualMachine,migrateVirtualMachineWithVolume,addNicToVirtualMachine,updateVmNicIp,startVirtualMachine,listVirtualMachines,updateVirtualMachine,destroyVirtualMachine,removeNicFromVirtualMachine,removeNicFromVirtualMachine,deployVirtualMachine,destroyVirtualMachine,addNicToVirtualMachine,updateVirtualMachine,rebootVirtualMachine,updateVMAffinityGroup,revertToVMSnapshot,attachIso,resetPasswordForVirtualMachine,assignVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,resetSSHKeyForVirtualMachine,resetPasswordForVirtualMachine,detachIso,changeServiceForVirtualMachine,attachIso,updateDefaultNicForVirtualMachine,startVirtualMachine,stopVirtualMachine",
        "response": [
          {
            "description": "Vm details in key/value pairs.",
            "name": "details",
            "type": "map"
          },
          {
            "description": "the speed of each cpu",
            "name": "cpuspeed",
            "type": "integer"
          },
          {
            "description": "the name of the disk offering of the virtual machine",
            "name": "diskofferingname",
            "type": "string"
          },
          {
            "description": "device type of the root volume",
            "name": "rootdevicetype",
            "type": "string"
          },
          {
            "description": "the name of the virtual machine",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the project id of the vm",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": " an alternate display text of the template for the virtual machine",
            "name": "templatedisplaytext",
            "type": "string"
          },
          {
            "description": "the group ID of the virtual machine",
            "name": "groupid",
            "type": "string"
          },
          {
            "description": "the outgoing network traffic on the host",
            "name": "networkkbswrite",
            "type": "long"
          },
          {
            "description": "the ID of the ISO attached to the virtual machine",
            "name": "isoid",
            "type": "string"
          },
          {
            "description": "the state of the virtual machine",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the list of nics associated with vm",
            "name": "nic",
            "response": [
              {
                "description": "the ip address of the nic",
                "name": "ipaddress",
                "type": "string"
              },
              {
                "description": "true if nic is default, false otherwise",
                "name": "macaddress",
                "type": "string"
              },
              {
                "description": "the netmask of the nic",
                "name": "netmask",
                "type": "string"
              },
              {
                "description": "the isolation uri of the nic",
                "name": "isolationuri",
                "type": "string"
              },
              {
                "description": "the traffic type of the nic",
                "name": "traffictype",
                "type": "string"
              },
              {
                "description": "the cidr of IPv6 network",
                "name": "ip6cidr",
                "type": "string"
              },
              {
                "description": "the broadcast uri of the nic",
                "name": "broadcasturi",
                "type": "string"
              },
              {
                "description": "the ID of the nic",
                "name": "id",
                "type": "string"
              },
              {
                "description": "the type of the nic",
                "name": "type",
                "type": "string"
              },
              {
                "description": "the Secondary ipv4 addr of nic",
                "name": "secondaryip",
                "type": "list"
              },
              {
                "description": "the ID of the corresponding network",
                "name": "networkid",
                "type": "string"
              },
              {
                "description": "the name of the corresponding network",
                "name": "networkname",
                "type": "string"
              },
              {
                "description": "Id of the vm to which the nic belongs",
                "name": "virtualmachineid",
                "type": "string"
              },
              {
                "description": "the gateway of the nic",
                "name": "gateway",
                "type": "string"
              },
              {
                "description": "the IPv6 address of network",
                "name": "ip6address",
                "type": "string"
              },
              {
                "description": "true if nic is default, false otherwise",
                "name": "isdefault",
                "type": "boolean"
              },
              {
                "description": "the gateway of IPv6 network",
                "name": "ip6gateway",
                "type": "string"
              },
              {
                "description": "device id for the network when plugged into the virtual machine",
                "name": "deviceid",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.",
            "name": "templateid",
            "type": "string"
          },
          {
            "description": "the virtual network for the service offering",
            "name": "forvirtualnetwork",
            "type": "boolean"
          },
          {
            "description": "the amount of the vm's CPU currently used",
            "name": "cpuused",
            "type": "string"
          },
          {
            "description": "the list of resource tags associated with vm",
            "name": "tags",
            "response": [
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "the user's ID who deployed the virtual machine",
            "name": "userid",
            "type": "string"
          },
          {
            "description": "the name of the host for the virtual machine",
            "name": "hostname",
            "type": "string"
          },
          {
            "description": "the ID of the virtual machine",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the write (bytes) of disk on the vm",
            "name": "diskkbswrite",
            "type": "long"
          },
          {},
          {
            "description": "the name of the service offering of the virtual machine",
            "name": "serviceofferingname",
            "type": "string"
          },
          {
            "description": "ssh key-pair",
            "name": "keypair",
            "type": "string"
          },
          {
            "description": "the hypervisor on which the template runs",
            "name": "hypervisor",
            "type": "string"
          },
          {
            "description": "State of the Service from LB rule",
            "name": "servicestate",
            "type": "string"
          },
          {
            "description": "OS type id of the vm",
            "name": "ostypeid",
            "type": "long"
          },
          {
            "description": "the ID of the service offering of the virtual machine",
            "name": "serviceofferingid",
            "type": "string"
          },
          {
            "description": "the name of the ISO attached to the virtual machine",
            "name": "isoname",
            "type": "string"
          },
          {
            "description": "the name of the availability zone for the virtual machine",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the number of cpu this virtual machine is running with",
            "name": "cpunumber",
            "type": "integer"
          },
          {
            "description": "true if high-availability is enabled, false otherwise",
            "name": "haenable",
            "type": "boolean"
          },
          {
            "description": "the group name of the virtual machine",
            "name": "group",
            "type": "string"
          },
          {
            "description": "the ID of the availablility zone for the virtual machine",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the account associated with the virtual machine",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the incoming network traffic on the vm",
            "name": "networkkbsread",
            "type": "long"
          },
          {
            "description": "instance name of the user vm; this parameter is returned to the ROOT admin only",
            "name": "instancename",
            "type": "string"
          },
          {
            "description": "user generated name. The name of the virtual machine is returned if no displayname exists.",
            "name": "displayname",
            "type": "string"
          },
          {
            "description": "the date when this virtual machine was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "the name of the domain in which the virtual machine exists",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the vgpu type used by the virtual machine",
            "name": "vgpu",
            "type": "string"
          },
          {
            "description": "the read (io) of disk on the vm",
            "name": "diskioread",
            "type": "long"
          },
          {
            "description": "the project name of the vm",
            "name": "project",
            "type": "string"
          },
          {
            "description": "Os type ID of the virtual machine",
            "name": "guestosid",
            "type": "string"
          },
          {
            "description": "the memory allocated for the virtual machine",
            "name": "memory",
            "type": "integer"
          },
          {
            "description": "public IP address id associated with vm via Static nat rule",
            "name": "publicip",
            "type": "string"
          },
          {
            "description": "the ID of the disk offering of the virtual machine",
            "name": "diskofferingid",
            "type": "string"
          },
          {
            "description": "the read (bytes) of disk on the vm",
            "name": "diskkbsread",
            "type": "long"
          },
          {
            "description": "the password (if exists) of the virtual machine",
            "name": "password",
            "type": "string"
          },
          {
            "description": "list of affinity groups associated with the virtual machine",
            "name": "affinitygroup",
            "response": [
              {
                "description": "the domain ID of the affinity group",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the type of the affinity group",
                "name": "type",
                "type": "string"
              },
              {
                "description": "the ID of the affinity group",
                "name": "id",
                "type": "string"
              },
              {
                "description": "the name of the affinity group",
                "name": "name",
                "type": "string"
              },
              {
                "description": "the description of the affinity group",
                "name": "description",
                "type": "string"
              },
              {
                "description": "virtual machine IDs associated with this affinity group",
                "name": "virtualmachineIds",
                "type": "list"
              },
              {
                "description": "the account owning the affinity group",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the project name of the affinity group",
                "name": "project",
                "type": "string"
              },
              {
                "description": "the domain name of the affinity group",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "the project ID of the affinity group",
                "name": "projectid",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "true if the password rest feature is enabled, false otherwise",
            "name": "passwordenabled",
            "type": "boolean"
          },
          {
            "description": "an alternate display text of the ISO attached to the virtual machine",
            "name": "isodisplaytext",
            "type": "string"
          },
          {
            "description": "an optional field whether to the display the vm to the end user or not.",
            "name": "displayvm",
            "type": "boolean"
          },
          {
            "description": "the name of the template for the virtual machine",
            "name": "templatename",
            "type": "string"
          },
          {
            "description": "the ID of the domain in which the virtual machine exists",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the ID of the host for the virtual machine",
            "name": "hostid",
            "type": "string"
          },
          {
            "description": "true if vm contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory.",
            "name": "isdynamicallyscalable",
            "type": "boolean"
          },
          {
            "description": "device ID of the root volume",
            "name": "rootdeviceid",
            "type": "long"
          },
          {
            "description": "list of security groups associated with the virtual machine",
            "name": "securitygroup",
            "response": [
              {
                "description": "the description of the security group",
                "name": "description",
                "type": "string"
              },
              {
                "description": "the list of resource tags associated with the rule",
                "name": "tags",
                "response": [
                  {
                    "description": "the account associated with the tag",
                    "name": "account",
                    "type": "string"
                  },
                  {
                    "description": "the domain associated with the tag",
                    "name": "domain",
                    "type": "string"
                  },
                  {
                    "description": "resource type",
                    "name": "resourcetype",
                    "type": "string"
                  },
                  {
                    "description": "tag value",
                    "name": "value",
                    "type": "string"
                  },
                  {
                    "description": "the project name where tag belongs to",
                    "name": "project",
                    "type": "string"
                  },
                  {
                    "description": "id of the resource",
                    "name": "resourceid",
                    "type": "string"
                  },
                  {
                    "description": "tag key name",
                    "name": "key",
                    "type": "string"
                  },
                  {
                    "description": "the project id the tag belongs to",
                    "name": "projectid",
                    "type": "string"
                  },
                  {
                    "description": "the ID of the domain associated with the tag",
                    "name": "domainid",
                    "type": "string"
                  },
                  {
                    "description": "customer associated with the tag",
                    "name": "customer",
                    "type": "string"
                  }
                ],
                "type": "set"
              },
              {
                "description": "the name of the security group",
                "name": "name",
                "type": "string"
              },
              {
                "description": "the list of ingress rules associated with the security group",
                "name": "ingressrule",
                "response": [
                  {
                    "description": "the ending IP of the security group rule ",
                    "name": "endport",
                    "type": "integer"
                  },
                  {
                    "description": "the list of resource tags associated with the rule",
                    "name": "tags",
                    "response": [
                      {
                        "description": "tag value",
                        "name": "value",
                        "type": "string"
                      },
                      {
                        "description": "resource type",
                        "name": "resourcetype",
                        "type": "string"
                      },
                      {
                        "description": "the ID of the domain associated with the tag",
                        "name": "domainid",
                        "type": "string"
                      },
                      {
                        "description": "the account associated with the tag",
                        "name": "account",
                        "type": "string"
                      },
                      {
                        "description": "the project id the tag belongs to",
                        "name": "projectid",
                        "type": "string"
                      },
                      {
                        "description": "customer associated with the tag",
                        "name": "customer",
                        "type": "string"
                      },
                      {
                        "description": "the domain associated with the tag",
                        "name": "domain",
                        "type": "string"
                      },
                      {
                        "description": "tag key name",
                        "name": "key",
                        "type": "string"
                      },
                      {
                        "description": "the project name where tag belongs to",
                        "name": "project",
                        "type": "string"
                      },
                      {
                        "description": "id of the resource",
                        "name": "resourceid",
                        "type": "string"
                      }
                    ],
                    "type": "set"
                  },
                  {
                    "description": "the type of the ICMP message response",
                    "name": "icmptype",
                    "type": "integer"
                  },
                  {
                    "description": "the id of the security group rule",
                    "name": "ruleid",
                    "type": "string"
                  },
                  {
                    "description": "the starting IP of the security group rule",
                    "name": "startport",
                    "type": "integer"
                  },
                  {
                    "description": "account owning the security group rule",
                    "name": "account",
                    "type": "string"
                  },
                  {
                    "description": "the protocol of the security group rule",
                    "name": "protocol",
                    "type": "string"
                  },
                  {
                    "description": "the CIDR notation for the base IP address of the security group rule",
                    "name": "cidr",
                    "type": "string"
                  },
                  {
                    "description": "security group name",
                    "name": "securitygroupname",
                    "type": "string"
                  },
                  {
                    "description": "the code for the ICMP message response",
                    "name": "icmpcode",
                    "type": "integer"
                  }
                ],
                "type": "set"
              },
              {
                "description": "the ID of the security group",
                "name": "id",
                "type": "string"
              },
              {
                "description": "the project name of the group",
                "name": "project",
                "type": "string"
              },
              {
                "description": "the domain ID of the security group",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the domain name of the security group",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "the list of virtualmachine ids associated with this securitygroup",
                "name": "virtualmachineids",
                "type": "set"
              },
              {
                "description": "the list of egress rules associated with the security group",
                "name": "egressrule",
                "response": [
                  {
                    "description": "the protocol of the security group rule",
                    "name": "protocol",
                    "type": "string"
                  },
                  {
                    "description": "account owning the security group rule",
                    "name": "account",
                    "type": "string"
                  },
                  {
                    "description": "the type of the ICMP message response",
                    "name": "icmptype",
                    "type": "integer"
                  },
                  {
                    "description": "security group name",
                    "name": "securitygroupname",
                    "type": "string"
                  },
                  {
                    "description": "the CIDR notation for the base IP address of the security group rule",
                    "name": "cidr",
                    "type": "string"
                  },
                  {
                    "description": "the id of the security group rule",
                    "name": "ruleid",
                    "type": "string"
                  },
                  {
                    "description": "the code for the ICMP message response",
                    "name": "icmpcode",
                    "type": "integer"
                  },
                  {
                    "description": "the starting IP of the security group rule",
                    "name": "startport",
                    "type": "integer"
                  },
                  {
                    "description": "the ending IP of the security group rule ",
                    "name": "endport",
                    "type": "integer"
                  },
                  {
                    "description": "the list of resource tags associated with the rule",
                    "name": "tags",
                    "response": [
                      {
                        "description": "resource type",
                        "name": "resourcetype",
                        "type": "string"
                      },
                      {
                        "description": "the project id the tag belongs to",
                        "name": "projectid",
                        "type": "string"
                      },
                      {
                        "description": "the ID of the domain associated with the tag",
                        "name": "domainid",
                        "type": "string"
                      },
                      {
                        "description": "the account associated with the tag",
                        "name": "account",
                        "type": "string"
                      },
                      {
                        "description": "customer associated with the tag",
                        "name": "customer",
                        "type": "string"
                      },
                      {
                        "description": "tag key name",
                        "name": "key",
                        "type": "string"
                      },
                      {
                        "description": "the project name where tag belongs to",
                        "name": "project",
                        "type": "string"
                      },
                      {
                        "description": "tag value",
                        "name": "value",
                        "type": "string"
                      },
                      {
                        "description": "the domain associated with the tag",
                        "name": "domain",
                        "type": "string"
                      },
                      {
                        "description": "id of the resource",
                        "name": "resourceid",
                        "type": "string"
                      }
                    ],
                    "type": "set"
                  }
                ],
                "type": "set"
              },
              {
                "description": "the account owning the security group",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the number of virtualmachines associated with this securitygroup",
                "name": "virtualmachinecount",
                "type": "integer"
              },
              {
                "description": "the project id of the group",
                "name": "projectid",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "the write (io) of disk on the vm",
            "name": "diskiowrite",
            "type": "long"
          },
          {
            "description": "the user's name who deployed the virtual machine",
            "name": "username",
            "type": "string"
          },
          {
            "description": "public IP address id associated with vm via Static nat rule",
            "name": "publicipid",
            "type": "string"
          }
        ]
      },
      {
        "description": "Creates a load balancer rule",
        "isasync": true,
        "name": "createLoadBalancerRule",
        "params": [
          {
            "description": "The guest network this rule will be created for. Required when public Ip address is not associated with any Guest network yet (VPC case)",
            "length": 255,
            "name": "networkid",
            "related": "createNetwork,listNetscalerLoadBalancerNetworks,listPaloAltoFirewallNetworks,listNiciraNvpDeviceNetworks,listNetworks,updateNetwork,updateNetwork,createNetwork",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "an optional field, whether to the display the rule to the end user or not",
            "length": 255,
            "name": "fordisplay",
            "required": false,
            "since": "4.4",
            "type": "boolean"
          },
          {
            "description": "the account associated with the load balancer. Must be used with the domainId parameter.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "the CIDR list to forward traffic from",
            "length": 255,
            "name": "cidrlist",
            "required": false,
            "type": "list"
          },
          {
            "description": "if true, firewall rule for source/end public port is automatically created; if false - firewall rule has to be created explicitely. If not specified 1) defaulted to false when LB rule is being created for VPC guest network 2) in all other cases defaulted to true",
            "length": 255,
            "name": "openfirewall",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "the public port from where the network traffic will be load balanced from",
            "length": 255,
            "name": "publicport",
            "required": true,
            "type": "integer"
          },
          {
            "description": "name of the load balancer rule",
            "length": 255,
            "name": "name",
            "required": true,
            "type": "string"
          },
          {
            "description": "zone where the load balancer is going to be created. This parameter is required when LB service provider is ElasticLoadBalancerVm",
            "length": 255,
            "name": "zoneid",
            "related": "createZone,updateZone,listZones,listZones",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "the domain ID associated with the load balancer",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain,updateDomain",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "public IP address ID from where the network traffic will be load balanced from",
            "length": 255,
            "name": "publicipid",
            "related": "associateIpAddress,restartNetwork,updateIpAddress,listPublicIpAddresses,listPublicIpAddresses,associateIpAddress",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "the description of the load balancer rule",
            "length": 4096,
            "name": "description",
            "required": false,
            "type": "string"
          },
          {
            "description": "the private port of the private IP address/virtual machine where the network traffic will be load balanced to",
            "length": 255,
            "name": "privateport",
            "required": true,
            "type": "integer"
          },
          {
            "description": "The protocol for the LB",
            "length": 255,
            "name": "protocol",
            "required": false,
            "type": "string"
          },
          {
            "description": "load balancer algorithm (source, roundrobin, leastconn)",
            "length": 255,
            "name": "algorithm",
            "required": true,
            "type": "string"
          }
        ],
        "related": "updateLoadBalancerRule,listLoadBalancerRules",
        "response": [
          {
            "description": "the domain of the load balancer rule",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the protocol of the loadbalanacer rule",
            "name": "protocol",
            "type": "string"
          },
          {
            "description": "is rule for display to the regular user",
            "name": "fordisplay",
            "type": "boolean"
          },
          {
            "description": "the domain ID of the load balancer rule",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the load balancer algorithm (source, roundrobin, leastconn)",
            "name": "algorithm",
            "type": "string"
          },
          {
            "description": "the public port",
            "name": "publicport",
            "type": "string"
          },
          {
            "description": "the load balancer rule ID",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the public ip address",
            "name": "publicip",
            "type": "string"
          },
          {
            "description": "the id of the zone the rule belongs to",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the name of the load balancer",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the project name of the load balancer",
            "name": "project",
            "type": "string"
          },
          {
            "description": "the project id of the load balancer",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the state of the rule",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the account of the load balancer rule",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the private port",
            "name": "privateport",
            "type": "string"
          },
          {
            "description": "the cidr list to forward traffic from",
            "name": "cidrlist",
            "type": "string"
          },
          {
            "description": "the description of the load balancer",
            "name": "description",
            "type": "string"
          },
          {
            "description": "the list of resource tags associated with load balancer",
            "name": "tags",
            "response": [
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              },
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              }
            ],
            "type": "list"
          },
          {
            "description": "the id of the guest network the lb rule belongs to",
            "name": "networkid",
            "type": "string"
          },
          {
            "description": "the public ip address id",
            "name": "publicipid",
            "type": "string"
          }
        ]
      },
      {
        "description": "Adds a guest OS name to hypervisor OS name mapping",
        "isasync": true,
        "name": "addGuestOsMapping",
        "params": [
          {
            "description": "Hypervisor version to create the mapping for. Use 'default' for default versions",
            "length": 255,
            "name": "hypervisorversion",
            "required": true,
            "type": "string"
          },
          {
            "description": "OS name specific to the hypervisor",
            "length": 255,
            "name": "osnameforhypervisor",
            "required": true,
            "type": "string"
          },
          {
            "description": "UUID of Guest OS type. Either the UUID or Display Name must be passed",
            "length": 255,
            "name": "ostypeid",
            "related": "addGuestOs,listOsTypes",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "Display Name of Guest OS standard type. Either Display Name or UUID must be passed",
            "length": 255,
            "name": "osdisplayname",
            "required": false,
            "type": "string"
          },
          {
            "description": "Hypervisor type. One of : XenServer, KVM, VMWare",
            "length": 255,
            "name": "hypervisor",
            "required": true,
            "type": "string"
          }
        ],
        "related": "updateGuestOsMapping",
        "response": [
          {
            "description": "the ID of the Guest OS type",
            "name": "ostypeid",
            "type": "string"
          },
          {
            "description": "is the mapping user defined",
            "name": "isuserdefined",
            "type": "string"
          },
          {
            "description": "standard display name for the Guest OS",
            "name": "osdisplayname",
            "type": "string"
          },
          {
            "description": "the hypervisor",
            "name": "hypervisor",
            "type": "string"
          },
          {
            "description": "version of the hypervisor for mapping",
            "name": "hypervisorversion",
            "type": "string"
          },
          {
            "description": "the ID of the Guest OS mapping",
            "name": "id",
            "type": "string"
          },
          {
            "description": "hypervisor specific name for the Guest OS",
            "name": "osnameforhypervisor",
            "type": "string"
          }
        ],
        "since": "4.4.0"
      },
      {
        "description": "Updates a network offering.",
        "isasync": false,
        "name": "updateNetworkOffering",
        "params": [
          {
            "description": "the display text of the network offering",
            "length": 255,
            "name": "displaytext",
            "required": false,
            "type": "string"
          },
          {
            "description": "update state for the network offering",
            "length": 255,
            "name": "state",
            "required": false,
            "type": "string"
          },
          {
            "description": "the id of the network offering",
            "length": 255,
            "name": "id",
            "related": "listNetworkOfferings,createNetworkOffering,updateNetworkOffering",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "maximum number of concurrent connections supported by the network offering",
            "length": 255,
            "name": "maxconnections",
            "required": false,
            "type": "integer"
          },
          {
            "description": "the name of the network offering",
            "length": 255,
            "name": "name",
            "required": false,
            "type": "string"
          },
          {
            "description": "if true keepalive will be turned on in the loadbalancer. At the time of writing this has only an effect on haproxy; the mode http and httpclose options are unset in the haproxy conf file.",
            "length": 255,
            "name": "keepaliveenabled",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "the availability of network offering. Default value is Required for Guest Virtual network offering; Optional for Guest Direct network offering",
            "length": 255,
            "name": "availability",
            "required": false,
            "type": "string"
          },
          {
            "description": "sort key of the network offering, integer",
            "length": 255,
            "name": "sortkey",
            "required": false,
            "type": "integer"
          }
        ],
        "related": "listNetworkOfferings,createNetworkOffering",
        "response": [
          {
            "description": "guest type of the network offering, can be Shared or Isolated",
            "name": "guestiptype",
            "type": "string"
          },
          {
            "description": "true if network offering supports vlans, false otherwise",
            "name": "specifyvlan",
            "type": "boolean"
          },
          {
            "description": "the id of the network offering",
            "name": "id",
            "type": "string"
          },
          {
            "description": "an alternate display text of the network offering.",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "true if network offering supports specifying ip ranges, false otherwise",
            "name": "specifyipranges",
            "type": "boolean"
          },
          {
            "description": "the name of the network offering",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the tags for the network offering",
            "name": "tags",
            "type": "string"
          },
          {
            "description": "true if network offering is default, false otherwise",
            "name": "isdefault",
            "type": "boolean"
          },
          {
            "description": "additional key/value details tied with network offering",
            "name": "details",
            "type": "map"
          },
          {
            "description": "availability of the network offering",
            "name": "availability",
            "type": "string"
          },
          {
            "description": "true if network offering supports persistent networks, false otherwise",
            "name": "ispersistent",
            "type": "boolean"
          },
          {
            "description": "data transfer rate in megabits per second allowed.",
            "name": "networkrate",
            "type": "integer"
          },
          {
            "description": "the traffic type for the network offering, supported types are Public, Management, Control, Guest, Vlan or Storage.",
            "name": "traffictype",
            "type": "string"
          },
          {
            "description": "maximum number of concurrents connections to be handled by lb",
            "name": "maxconnections",
            "type": "integer"
          },
          {
            "description": "the ID of the service offering used by virtual router provider",
            "name": "serviceofferingid",
            "type": "string"
          },
          {
            "description": "the date this network offering was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "true if network offering is ip conserve mode enabled",
            "name": "conservemode",
            "type": "boolean"
          },
          {
            "description": "true if network offering can be used by VPC networks only",
            "name": "forvpc",
            "type": "boolean"
          },
          {
            "description": "the list of supported services",
            "name": "service",
            "response": [
              {
                "description": "the service provider name",
                "name": "provider",
                "response": [
                  {
                    "description": "the provider name",
                    "name": "name",
                    "type": "string"
                  },
                  {
                    "description": "state of the network provider",
                    "name": "state",
                    "type": "string"
                  },
                  {
                    "description": "services for this provider",
                    "name": "servicelist",
                    "type": "list"
                  },
                  {
                    "description": "true if individual services can be enabled/disabled",
                    "name": "canenableindividualservice",
                    "type": "boolean"
                  },
                  {
                    "description": "uuid of the network provider",
                    "name": "id",
                    "type": "string"
                  },
                  {
                    "description": "the physical network this belongs to",
                    "name": "physicalnetworkid",
                    "type": "string"
                  },
                  {
                    "description": "the destination physical network",
                    "name": "destinationphysicalnetworkid",
                    "type": "string"
                  }
                ],
                "type": "list"
              },
              {
                "description": "the list of capabilities",
                "name": "capability",
                "response": [
                  {
                    "description": "the capability name",
                    "name": "name",
                    "type": "string"
                  },
                  {
                    "description": "the capability value",
                    "name": "value",
                    "type": "string"
                  },
                  {
                    "description": "can this service capability value can be choosable while creatine network offerings",
                    "name": "canchooseservicecapability",
                    "type": "boolean"
                  }
                ],
                "type": "list"
              },
              {
                "description": "the service name",
                "name": "name",
                "type": "string"
              }
            ],
            "type": "list"
          },
          {
            "description": "state of the network offering. Can be Disabled/Enabled/Inactive",
            "name": "state",
            "type": "string"
          },
          {
            "description": "true if guest network default egress policy is allow; false if default egress policy is deny",
            "name": "egressdefaultpolicy",
            "type": "boolean"
          },
          {
            "description": "true if network offering supports network that span multiple zones",
            "name": "supportsstrechedl2subnet",
            "type": "boolean"
          }
        ]
      },
      {
        "description": "Stops a system VM.",
        "isasync": true,
        "name": "stopSystemVm",
        "params": [
          {
            "description": "The ID of the system virtual machine",
            "length": 255,
            "name": "id",
            "related": "migrateSystemVm,stopSystemVm,changeServiceForSystemVm,listSystemVms,startSystemVm",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "Force stop the VM.  The caller knows the VM is stopped.",
            "length": 255,
            "name": "forced",
            "required": false,
            "type": "boolean"
          }
        ],
        "related": "migrateSystemVm,changeServiceForSystemVm,listSystemVms,startSystemVm",
        "response": [
          {
            "description": "the date and time the system VM was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "the number of active console sessions for the console proxy system vm",
            "name": "activeviewersessions",
            "type": "integer"
          },
          {
            "description": "the Zone name for the system VM",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the private netmask for the system VM",
            "name": "privatenetmask",
            "type": "string"
          },
          {
            "description": "the link local MAC address for the system vm",
            "name": "linklocalmacaddress",
            "type": "string"
          },
          {
            "description": "the link local IP address for the system vm",
            "name": "linklocalip",
            "type": "string"
          },
          {
            "description": "the gateway for the system VM",
            "name": "gateway",
            "type": "string"
          },
          {
            "description": "the ID of the system VM",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the public netmask for the system VM",
            "name": "publicnetmask",
            "type": "string"
          },
          {
            "description": "the private MAC address for the system VM",
            "name": "privatemacaddress",
            "type": "string"
          },
          {
            "description": "the public MAC address for the system VM",
            "name": "publicmacaddress",
            "type": "string"
          },
          {
            "description": "the second DNS for the system VM",
            "name": "dns2",
            "type": "string"
          },
          {
            "description": "the Zone ID for the system VM",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the hypervisor on which the template runs",
            "name": "hypervisor",
            "type": "string"
          },
          {
            "description": "the state of the system VM",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the link local netmask for the system vm",
            "name": "linklocalnetmask",
            "type": "string"
          },
          {
            "description": "the public IP address for the system VM",
            "name": "publicip",
            "type": "string"
          },
          {
            "description": "the template ID for the system VM",
            "name": "templateid",
            "type": "string"
          },
          {
            "description": "the first DNS for the system VM",
            "name": "dns1",
            "type": "string"
          },
          {
            "description": "the job status associated with the system VM.  This is only displayed if the router listed is part of a currently running asynchronous job.",
            "name": "jobstatus",
            "type": "integer"
          },
          {
            "description": "the Pod ID for the system VM",
            "name": "podid",
            "type": "string"
          },
          {
            "description": "the network domain for the system VM",
            "name": "networkdomain",
            "type": "string"
          },
          {
            "description": "the hostname for the system VM",
            "name": "hostname",
            "type": "string"
          },
          {
            "description": "the private IP address for the system VM",
            "name": "privateip",
            "type": "string"
          },
          {
            "description": "the job ID associated with the system VM. This is only displayed if the router listed is part of a currently running asynchronous job.",
            "name": "jobid",
            "type": "string"
          },
          {
            "description": "the name of the system VM",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the host ID for the system VM",
            "name": "hostid",
            "type": "string"
          },
          {
            "description": "the system VM type",
            "name": "systemvmtype",
            "type": "string"
          }
        ]
      },
      {
        "description": "Updates a VPC",
        "isasync": true,
        "name": "updateVPC",
        "params": [
          {
            "description": "an optional field, in case you want to set a custom id to the resource. Allowed to Root Admins only",
            "length": 255,
            "name": "customid",
            "required": false,
            "since": "4.4",
            "type": "string"
          },
          {
            "description": "an optional field, whether to the display the vpc to the end user or not",
            "length": 255,
            "name": "fordisplay",
            "required": false,
            "since": "4.4",
            "type": "boolean"
          },
          {
            "description": "the display text of the VPC",
            "length": 255,
            "name": "displaytext",
            "required": false,
            "type": "string"
          },
          {
            "description": "the name of the VPC",
            "length": 255,
            "name": "name",
            "required": false,
            "type": "string"
          },
          {
            "description": "the id of the VPC",
            "length": 255,
            "name": "id",
            "related": "createVPC,updateVPC,listVPCs,listVPCs,restartVPC,createVPC,updateVPC",
            "required": true,
            "type": "uuid"
          }
        ],
        "related": "createVPC,listVPCs,listVPCs,restartVPC,createVPC,updateVPC",
        "response": [
          {
            "description": "is VPC uses distributed router for one hop forwarding and host based network ACL's",
            "name": "distributedvpcrouter",
            "type": "boolean"
          },
          {
            "description": "the name of the VPC",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the name of the zone the VPC belongs to",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the network domain of the VPC",
            "name": "networkdomain",
            "type": "string"
          },
          {
            "description": "the project name of the VPC",
            "name": "project",
            "type": "string"
          },
          {
            "description": "the list of resource tags associated with the project",
            "name": "tags",
            "response": [
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              },
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              }
            ],
            "type": "list"
          },
          {
            "description": "the list of networks belongign to the VPC",
            "name": "network",
            "response": [
              {
                "description": "true if network offering is ip conserve mode enabled",
                "name": "networkofferingconservemode",
                "type": "boolean"
              },
              {
                "description": "the project name of the address",
                "name": "project",
                "type": "string"
              },
              {
                "description": "true if network can span multiple zones",
                "name": "strechedl2subnet",
                "type": "boolean"
              },
              {
                "description": "the gateway of IPv6 network",
                "name": "ip6gateway",
                "type": "string"
              },
              {
                "description": "the type of the network",
                "name": "type",
                "type": "string"
              },
              {
                "description": "list networks available for vm deployment",
                "name": "canusefordeploy",
                "type": "boolean"
              },
              {
                "description": "the domain id of the network owner",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the first DNS for the network",
                "name": "dns1",
                "type": "string"
              },
              {
                "description": "the displaytext of the network",
                "name": "displaytext",
                "type": "string"
              },
              {
                "description": "the second DNS for the network",
                "name": "dns2",
                "type": "string"
              },
              {
                "description": "the network's netmask",
                "name": "netmask",
                "type": "string"
              },
              {
                "description": "true if users from subdomains can access the domain level network",
                "name": "subdomainaccess",
                "type": "boolean"
              },
              {
                "description": "list networks that are persistent",
                "name": "ispersistent",
                "type": "boolean"
              },
              {
                "description": "display text of the network offering the network is created from",
                "name": "networkofferingdisplaytext",
                "type": "string"
              },
              {
                "description": "the network domain",
                "name": "networkdomain",
                "type": "string"
              },
              {
                "description": "name of the network offering the network is created from",
                "name": "networkofferingname",
                "type": "string"
              },
              {
                "description": "related to what other network configuration",
                "name": "related",
                "type": "string"
              },
              {
                "description": "the domain name of the network owner",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "the physical network id",
                "name": "physicalnetworkid",
                "type": "string"
              },
              {
                "description": "the name of the zone the network belongs to",
                "name": "zonename",
                "type": "string"
              },
              {
                "description": "VPC the network belongs to",
                "name": "vpcid",
                "type": "string"
              },
              {
                "description": "true if network is default, false otherwise",
                "name": "isdefault",
                "type": "boolean"
              },
              {
                "description": "zone id of the network",
                "name": "zoneid",
                "type": "string"
              },
              {
                "description": "true if network is system, false otherwise",
                "name": "issystem",
                "type": "boolean"
              },
              {
                "description": "Broadcast domain type of the network",
                "name": "broadcastdomaintype",
                "type": "string"
              },
              {
                "description": "the cidr of IPv6 network",
                "name": "ip6cidr",
                "type": "string"
              },
              {
                "description": "the network's IP range not to be used by CloudStack guest VMs and can be used for non CloudStack purposes",
                "name": "reservediprange",
                "type": "string"
              },
              {
                "description": "Cloudstack managed address space, all CloudStack managed VMs get IP address from CIDR",
                "name": "cidr",
                "type": "string"
              },
              {
                "description": "true network requires restart",
                "name": "restartrequired",
                "type": "boolean"
              },
              {
                "description": "the id of the network",
                "name": "id",
                "type": "string"
              },
              {
                "description": "acl type - access type to the network",
                "name": "acltype",
                "type": "string"
              },
              {
                "description": "the owner of the network",
                "name": "account",
                "type": "string"
              },
              {
                "description": "The vlan of the network. This parameter is visible to ROOT admins only",
                "name": "vlan",
                "type": "string"
              },
              {
                "description": "the name of the network",
                "name": "name",
                "type": "string"
              },
              {
                "description": "broadcast uri of the network. This parameter is visible to ROOT admins only",
                "name": "broadcasturi",
                "type": "string"
              },
              {
                "description": "the list of services",
                "name": "service",
                "response": [
                  {
                    "description": "the list of capabilities",
                    "name": "capability",
                    "response": [
                      {
                        "description": "the capability value",
                        "name": "value",
                        "type": "string"
                      },
                      {
                        "description": "can this service capability value can be choosable while creatine network offerings",
                        "name": "canchooseservicecapability",
                        "type": "boolean"
                      },
                      {
                        "description": "the capability name",
                        "name": "name",
                        "type": "string"
                      }
                    ],
                    "type": "list"
                  },
                  {
                    "description": "the service provider name",
                    "name": "provider",
                    "response": [
                      {
                        "description": "true if individual services can be enabled/disabled",
                        "name": "canenableindividualservice",
                        "type": "boolean"
                      },
                      {
                        "description": "the destination physical network",
                        "name": "destinationphysicalnetworkid",
                        "type": "string"
                      },
                      {
                        "description": "services for this provider",
                        "name": "servicelist",
                        "type": "list"
                      },
                      {
                        "description": "uuid of the network provider",
                        "name": "id",
                        "type": "string"
                      },
                      {
                        "description": "the provider name",
                        "name": "name",
                        "type": "string"
                      },
                      {
                        "description": "the physical network this belongs to",
                        "name": "physicalnetworkid",
                        "type": "string"
                      },
                      {
                        "description": "state of the network provider",
                        "name": "state",
                        "type": "string"
                      }
                    ],
                    "type": "list"
                  },
                  {
                    "description": "the service name",
                    "name": "name",
                    "type": "string"
                  }
                ],
                "type": "list"
              },
              {
                "description": "availability of the network offering the network is created from",
                "name": "networkofferingavailability",
                "type": "string"
              },
              {
                "description": "If a network is enabled for 'streched l2 subnet' then represents zones on which network currently spans",
                "name": "zonesnetworkspans",
                "type": "set"
              },
              {
                "description": "network offering id the network is created from",
                "name": "networkofferingid",
                "type": "string"
              },
              {
                "description": "the project id of the ipaddress",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "true if network supports specifying ip ranges, false otherwise",
                "name": "specifyipranges",
                "type": "boolean"
              },
              {
                "description": "state of the network",
                "name": "state",
                "type": "string"
              },
              {
                "description": "the traffic type of the network",
                "name": "traffictype",
                "type": "string"
              },
              {
                "description": "the network's gateway",
                "name": "gateway",
                "type": "string"
              },
              {
                "description": "the network CIDR of the guest network configured with IP reservation. It is the summation of CIDR and RESERVED_IP_RANGE",
                "name": "networkcidr",
                "type": "string"
              },
              {
                "description": "ACL Id associated with the VPC network",
                "name": "aclid",
                "type": "string"
              },
              {
                "description": "the list of resource tags associated with network",
                "name": "tags",
                "response": [
                  {
                    "description": "resource type",
                    "name": "resourcetype",
                    "type": "string"
                  },
                  {
                    "description": "the project name where tag belongs to",
                    "name": "project",
                    "type": "string"
                  },
                  {
                    "description": "the ID of the domain associated with the tag",
                    "name": "domainid",
                    "type": "string"
                  },
                  {
                    "description": "id of the resource",
                    "name": "resourceid",
                    "type": "string"
                  },
                  {
                    "description": "tag key name",
                    "name": "key",
                    "type": "string"
                  },
                  {
                    "description": "customer associated with the tag",
                    "name": "customer",
                    "type": "string"
                  },
                  {
                    "description": "the domain associated with the tag",
                    "name": "domain",
                    "type": "string"
                  },
                  {
                    "description": "the account associated with the tag",
                    "name": "account",
                    "type": "string"
                  },
                  {
                    "description": "the project id the tag belongs to",
                    "name": "projectid",
                    "type": "string"
                  },
                  {
                    "description": "tag value",
                    "name": "value",
                    "type": "string"
                  }
                ],
                "type": "list"
              },
              {
                "description": "an optional field, whether to the display the network to the end user or not.",
                "name": "displaynetwork",
                "type": "boolean"
              }
            ],
            "type": "list"
          },
          {
            "description": "is vpc for display to the regular user",
            "name": "fordisplay",
            "type": "boolean"
          },
          {
            "description": "the cidr the VPC",
            "name": "cidr",
            "type": "string"
          },
          {
            "description": "zone id of the vpc",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "vpc offering id the VPC is created from",
            "name": "vpcofferingid",
            "type": "string"
          },
          {
            "description": "the owner of the VPC",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the domain id of the VPC owner",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the id of the VPC",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the date this VPC was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "true VPC requires restart",
            "name": "restartrequired",
            "type": "boolean"
          },
          {
            "description": "the list of supported services",
            "name": "service",
            "response": [
              {
                "description": "the list of capabilities",
                "name": "capability",
                "response": [
                  {
                    "description": "the capability name",
                    "name": "name",
                    "type": "string"
                  },
                  {
                    "description": "can this service capability value can be choosable while creatine network offerings",
                    "name": "canchooseservicecapability",
                    "type": "boolean"
                  },
                  {
                    "description": "the capability value",
                    "name": "value",
                    "type": "string"
                  }
                ],
                "type": "list"
              },
              {
                "description": "the service name",
                "name": "name",
                "type": "string"
              },
              {
                "description": "the service provider name",
                "name": "provider",
                "response": [
                  {
                    "description": "the provider name",
                    "name": "name",
                    "type": "string"
                  },
                  {
                    "description": "services for this provider",
                    "name": "servicelist",
                    "type": "list"
                  },
                  {
                    "description": "true if individual services can be enabled/disabled",
                    "name": "canenableindividualservice",
                    "type": "boolean"
                  },
                  {
                    "description": "state of the network provider",
                    "name": "state",
                    "type": "string"
                  },
                  {
                    "description": "uuid of the network provider",
                    "name": "id",
                    "type": "string"
                  },
                  {
                    "description": "the destination physical network",
                    "name": "destinationphysicalnetworkid",
                    "type": "string"
                  },
                  {
                    "description": "the physical network this belongs to",
                    "name": "physicalnetworkid",
                    "type": "string"
                  }
                ],
                "type": "list"
              }
            ],
            "type": "list"
          },
          {
            "description": "if this VPC has redundant router",
            "name": "redundantvpcrouter",
            "type": "boolean"
          },
          {
            "description": "an alternate display text of the VPC.",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "the domain name of the owner",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the project id of the VPC",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "state of the VPC. Can be Inactive/Enabled",
            "name": "state",
            "type": "string"
          },
          {
            "description": "true if VPC is region level",
            "name": "regionlevelvpc",
            "type": "boolean"
          }
        ]
      },
      {
        "description": "Deletes an egress firewall rule",
        "isasync": true,
        "name": "deleteEgressFirewallRule",
        "params": [
          {
            "description": "the ID of the firewall rule",
            "length": 255,
            "name": "id",
            "related": "listIpForwardingRules,listPortForwardingRules,updatePortForwardingRule,createPortForwardingRule,createIpForwardingRule",
            "required": true,
            "type": "uuid"
          }
        ],
        "response": [
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          }
        ]
      },
      {
        "description": "List resource detail(s)",
        "isasync": false,
        "name": "listResourceDetails",
        "params": [
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "list by resource id",
            "length": 255,
            "name": "resourceid",
            "required": false,
            "type": "string"
          },
          {
            "description": "list by key, value. Needs to be passed only along with key",
            "length": 255,
            "name": "value",
            "required": false,
            "since": "4.4",
            "type": "string"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
            "length": 255,
            "name": "isrecursive",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false",
            "length": 255,
            "name": "listall",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "list by key",
            "length": 255,
            "name": "key",
            "required": false,
            "type": "string"
          },
          {
            "description": "list objects by project",
            "length": 255,
            "name": "projectid",
            "related": "activateProject,createProject,updateProject,suspendProject,listProjectAccounts,listProjects",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list by resource type",
            "length": 255,
            "name": "resourcetype",
            "required": true,
            "type": "string"
          },
          {
            "description": "if set to true, only details marked with display=true, are returned. False by default",
            "length": 255,
            "name": "fordisplay",
            "required": false,
            "since": "4.3",
            "type": "boolean"
          },
          {
            "description": "list only resources belonging to the domain specified",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain,updateDomain",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list resources by account. Must be used with the domainId parameter.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          }
        ],
        "related": "listTags",
        "response": [
          {
            "description": "tag key name",
            "name": "key",
            "type": "string"
          },
          {
            "description": "id of the resource",
            "name": "resourceid",
            "type": "string"
          },
          {
            "description": "the project id the tag belongs to",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "customer associated with the tag",
            "name": "customer",
            "type": "string"
          },
          {
            "description": "resource type",
            "name": "resourcetype",
            "type": "string"
          },
          {
            "description": "the ID of the domain associated with the tag",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "tag value",
            "name": "value",
            "type": "string"
          },
          {
            "description": "the project name where tag belongs to",
            "name": "project",
            "type": "string"
          },
          {
            "description": "the account associated with the tag",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the domain associated with the tag",
            "name": "domain",
            "type": "string"
          }
        ],
        "since": "4.2"
      },
      {
        "description": "Dedicate an existing cluster",
        "isasync": true,
        "name": "dedicateCluster",
        "params": [
          {
            "description": "the name of the account which needs dedication. Must be used with domainId.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "the ID of the containing domain",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain,updateDomain",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "the ID of the Cluster",
            "length": 255,
            "name": "clusterid",
            "related": "addCluster,updateCluster",
            "required": true,
            "type": "uuid"
          }
        ],
        "related": "listDedicatedClusters",
        "response": [
          {
            "description": "the name of the cluster",
            "name": "clustername",
            "type": "string"
          },
          {
            "description": "the Dedication Affinity Group ID of the cluster",
            "name": "affinitygroupid",
            "type": "string"
          },
          {
            "description": "the ID of the dedicated resource",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the domain ID of the cluster",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the Account ID of the cluster",
            "name": "accountid",
            "type": "string"
          },
          {
            "description": "the ID of the cluster",
            "name": "clusterid",
            "type": "string"
          }
        ]
      },
      {
        "description": "Creates a network offering.",
        "isasync": false,
        "name": "createNetworkOffering",
        "params": [
          {
            "description": "services supported by the network offering",
            "length": 255,
            "name": "supportedservices",
            "required": true,
            "type": "list"
          },
          {
            "description": "true if guest network default egress policy is allow; false if default egress policy is deny",
            "length": 255,
            "name": "egressdefaultpolicy",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "true if network offering supports vlans",
            "length": 255,
            "name": "specifyvlan",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "if true keepalive will be turned on in the loadbalancer. At the time of writing this has only an effect on haproxy; the mode http and httpclose options are unset in the haproxy conf file.",
            "length": 255,
            "name": "keepaliveenabled",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "provider to service mapping. If not specified, the provider for the service will be mapped to the default provider on the physical network",
            "length": 255,
            "name": "serviceproviderlist",
            "required": false,
            "type": "map"
          },
          {
            "description": "data transfer rate in megabits per second allowed",
            "length": 255,
            "name": "networkrate",
            "required": false,
            "type": "integer"
          },
          {
            "description": "the availability of network offering. Default value is Optional",
            "length": 255,
            "name": "availability",
            "required": false,
            "type": "string"
          },
          {
            "description": "true if the network offering is IP conserve mode enabled",
            "length": 255,
            "name": "conservemode",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "maximum number of concurrent connections supported by the network offering",
            "length": 255,
            "name": "maxconnections",
            "required": false,
            "type": "integer"
          },
          {
            "description": "Network offering details in key/value pairs. Supported keys are internallbprovider/publiclbprovider with service provider as a value",
            "length": 255,
            "name": "details",
            "required": false,
            "since": "4.2.0",
            "type": "map"
          },
          {
            "description": "the name of the network offering",
            "length": 255,
            "name": "name",
            "required": true,
            "type": "string"
          },
          {
            "description": "guest type of the network offering: Shared or Isolated",
            "length": 255,
            "name": "guestiptype",
            "required": true,
            "type": "string"
          },
          {
            "description": "the tags for the network offering.",
            "length": 4096,
            "name": "tags",
            "required": false,
            "type": "string"
          },
          {
            "description": "true if network offering supports persistent networks; defaulted to false if not specified",
            "length": 255,
            "name": "ispersistent",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "the traffic type for the network offering. Supported type in current release is GUEST only",
            "length": 255,
            "name": "traffictype",
            "required": true,
            "type": "string"
          },
          {
            "description": "true if network offering supports specifying ip ranges; defaulted to false if not specified",
            "length": 255,
            "name": "specifyipranges",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "the service offering ID used by virtual router provider",
            "length": 255,
            "name": "serviceofferingid",
            "related": "updateServiceOffering,listServiceOfferings,createServiceOffering",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "the display text of the network offering",
            "length": 255,
            "name": "displaytext",
            "required": true,
            "type": "string"
          },
          {
            "description": "desired service capabilities as part of network offering",
            "length": 255,
            "name": "servicecapabilitylist",
            "required": false,
            "type": "map"
          }
        ],
        "related": "listNetworkOfferings",
        "response": [
          {
            "description": "the tags for the network offering",
            "name": "tags",
            "type": "string"
          },
          {
            "description": "true if network offering is ip conserve mode enabled",
            "name": "conservemode",
            "type": "boolean"
          },
          {
            "description": "the name of the network offering",
            "name": "name",
            "type": "string"
          },
          {
            "description": "additional key/value details tied with network offering",
            "name": "details",
            "type": "map"
          },
          {
            "description": "true if network offering supports specifying ip ranges, false otherwise",
            "name": "specifyipranges",
            "type": "boolean"
          },
          {
            "description": "true if network offering supports network that span multiple zones",
            "name": "supportsstrechedl2subnet",
            "type": "boolean"
          },
          {
            "description": "true if network offering supports vlans, false otherwise",
            "name": "specifyvlan",
            "type": "boolean"
          },
          {
            "description": "data transfer rate in megabits per second allowed.",
            "name": "networkrate",
            "type": "integer"
          },
          {
            "description": "availability of the network offering",
            "name": "availability",
            "type": "string"
          },
          {
            "description": "the ID of the service offering used by virtual router provider",
            "name": "serviceofferingid",
            "type": "string"
          },
          {
            "description": "the date this network offering was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "the list of supported services",
            "name": "service",
            "response": [
              {
                "description": "the list of capabilities",
                "name": "capability",
                "response": [
                  {
                    "description": "can this service capability value can be choosable while creatine network offerings",
                    "name": "canchooseservicecapability",
                    "type": "boolean"
                  },
                  {
                    "description": "the capability name",
                    "name": "name",
                    "type": "string"
                  },
                  {
                    "description": "the capability value",
                    "name": "value",
                    "type": "string"
                  }
                ],
                "type": "list"
              },
              {
                "description": "the service provider name",
                "name": "provider",
                "response": [
                  {
                    "description": "the physical network this belongs to",
                    "name": "physicalnetworkid",
                    "type": "string"
                  },
                  {
                    "description": "the provider name",
                    "name": "name",
                    "type": "string"
                  },
                  {
                    "description": "state of the network provider",
                    "name": "state",
                    "type": "string"
                  },
                  {
                    "description": "true if individual services can be enabled/disabled",
                    "name": "canenableindividualservice",
                    "type": "boolean"
                  },
                  {
                    "description": "uuid of the network provider",
                    "name": "id",
                    "type": "string"
                  },
                  {
                    "description": "services for this provider",
                    "name": "servicelist",
                    "type": "list"
                  },
                  {
                    "description": "the destination physical network",
                    "name": "destinationphysicalnetworkid",
                    "type": "string"
                  }
                ],
                "type": "list"
              },
              {
                "description": "the service name",
                "name": "name",
                "type": "string"
              }
            ],
            "type": "list"
          },
          {
            "description": "the traffic type for the network offering, supported types are Public, Management, Control, Guest, Vlan or Storage.",
            "name": "traffictype",
            "type": "string"
          },
          {
            "description": "maximum number of concurrents connections to be handled by lb",
            "name": "maxconnections",
            "type": "integer"
          },
          {
            "description": "state of the network offering. Can be Disabled/Enabled/Inactive",
            "name": "state",
            "type": "string"
          },
          {
            "description": "true if network offering can be used by VPC networks only",
            "name": "forvpc",
            "type": "boolean"
          },
          {
            "description": "guest type of the network offering, can be Shared or Isolated",
            "name": "guestiptype",
            "type": "string"
          },
          {
            "description": "true if network offering supports persistent networks, false otherwise",
            "name": "ispersistent",
            "type": "boolean"
          },
          {
            "description": "the id of the network offering",
            "name": "id",
            "type": "string"
          },
          {
            "description": "true if guest network default egress policy is allow; false if default egress policy is deny",
            "name": "egressdefaultpolicy",
            "type": "boolean"
          },
          {
            "description": "an alternate display text of the network offering.",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "true if network offering is default, false otherwise",
            "name": "isdefault",
            "type": "boolean"
          }
        ],
        "since": "3.0.0"
      },
      {
        "description": "Creates an IP forwarding rule",
        "isasync": true,
        "name": "createIpForwardingRule",
        "params": [
          {
            "description": "the public IP address ID of the forwarding rule, already associated via associateIp",
            "length": 255,
            "name": "ipaddressid",
            "related": "associateIpAddress,restartNetwork,updateIpAddress,listPublicIpAddresses,listPublicIpAddresses,associateIpAddress",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "the protocol for the rule. Valid values are TCP or UDP.",
            "length": 255,
            "name": "protocol",
            "required": true,
            "type": "string"
          },
          {
            "description": "if true, firewall rule for source/end public port is automatically created; if false - firewall rule has to be created explicitly. Has value true by default",
            "length": 255,
            "name": "openfirewall",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "the start port for the rule",
            "length": 255,
            "name": "startport",
            "required": true,
            "type": "integer"
          },
          {
            "description": "the end port for the rule",
            "length": 255,
            "name": "endport",
            "required": false,
            "type": "integer"
          },
          {
            "description": "the CIDR list to forward traffic from",
            "length": 255,
            "name": "cidrlist",
            "required": false,
            "type": "list"
          }
        ],
        "related": "listIpForwardingRules,listPortForwardingRules,updatePortForwardingRule,createPortForwardingRule",
        "response": [
          {
            "description": "the cidr list to forward traffic from",
            "name": "cidrlist",
            "type": "string"
          },
          {
            "description": "the public ip address for the port forwarding rule",
            "name": "ipaddress",
            "type": "string"
          },
          {
            "description": "the VM name for the port forwarding rule",
            "name": "virtualmachinename",
            "type": "string"
          },
          {
            "description": "the ID of the port forwarding rule",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the id of the guest network the port forwarding rule belongs to",
            "name": "networkid",
            "type": "string"
          },
          {
            "description": "the ending port of port forwarding rule's private port range",
            "name": "publicendport",
            "type": "string"
          },
          {
            "description": "the VM ID for the port forwarding rule",
            "name": "virtualmachineid",
            "type": "string"
          },
          {
            "description": "the vm ip address for the port forwarding rule",
            "name": "vmguestip",
            "type": "string"
          },
          {
            "description": "the ending port of port forwarding rule's private port range",
            "name": "privateendport",
            "type": "string"
          },
          {
            "description": "the protocol of the port forwarding rule",
            "name": "protocol",
            "type": "string"
          },
          {
            "description": "the starting port of port forwarding rule's public port range",
            "name": "publicport",
            "type": "string"
          },
          {
            "description": "the starting port of port forwarding rule's private port range",
            "name": "privateport",
            "type": "string"
          },
          {
            "description": "the VM display name for the port forwarding rule",
            "name": "virtualmachinedisplayname",
            "type": "string"
          },
          {
            "description": "the list of resource tags associated with the rule",
            "name": "tags",
            "response": [
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              }
            ],
            "type": "list"
          },
          {
            "description": "the public ip address id for the port forwarding rule",
            "name": "ipaddressid",
            "type": "string"
          },
          {
            "description": "the state of the rule",
            "name": "state",
            "type": "string"
          },
          {
            "description": "is firewall for display to the regular user",
            "name": "fordisplay",
            "type": "boolean"
          }
        ]
      },
      {
        "description": "Lists SSL certificates",
        "isasync": false,
        "name": "listSslCerts",
        "params": [
          {
            "description": "ID of SSL certificate",
            "length": 255,
            "name": "certid",
            "related": "uploadSslCert,listSslCerts",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "Account ID",
            "length": 255,
            "name": "accountid",
            "related": "enableAccount,listAccounts,disableAccount,listAccounts,markDefaultZoneForAccount,createAccount,updateAccount",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "Load balancer rule ID",
            "length": 255,
            "name": "lbruleid",
            "related": "listIpForwardingRules,listPortForwardingRules,updatePortForwardingRule,createPortForwardingRule",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "Project that owns the SSL certificate",
            "length": 255,
            "name": "projectid",
            "related": "activateProject,createProject,updateProject,suspendProject,listProjectAccounts,listProjects",
            "required": false,
            "type": "uuid"
          }
        ],
        "related": "uploadSslCert",
        "response": [
          {
            "description": "the project name of the certificate",
            "name": "project",
            "type": "string"
          },
          {
            "description": "the domain name of the network owner",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the project id of the certificate",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "certificate chain",
            "name": "certchain",
            "type": "string"
          },
          {
            "description": "certificate fingerprint",
            "name": "fingerprint",
            "type": "string"
          },
          {
            "description": "List of loabalancers this certificate is bound to",
            "name": "loadbalancerrulelist",
            "type": "list"
          },
          {
            "description": "SSL certificate ID",
            "name": "id",
            "type": "string"
          },
          {
            "description": "certificate",
            "name": "certificate",
            "type": "string"
          },
          {
            "description": "account for the certificate",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the domain id of the network owner",
            "name": "domainid",
            "type": "string"
          }
        ]
      },
      {
        "description": "List private gateways",
        "isasync": false,
        "name": "listPrivateGateways",
        "params": [
          {
            "description": "list private gateway by id",
            "length": 255,
            "name": "id",
            "related": "createPrivateGateway,listPrivateGateways",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list objects by project",
            "length": 255,
            "name": "projectid",
            "related": "activateProject,createProject,updateProject,suspendProject,listProjectAccounts,listProjects",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list gateways by vpc",
            "length": 255,
            "name": "vpcid",
            "related": "createVPC,listVPCs,listVPCs,restartVPC,createVPC,updateVPC",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "list gateways by state",
            "length": 255,
            "name": "state",
            "required": false,
            "type": "string"
          },
          {
            "description": "list gateways by vlan",
            "length": 255,
            "name": "vlan",
            "required": false,
            "type": "string"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "list gateways by ip address",
            "length": 255,
            "name": "ipaddress",
            "required": false,
            "type": "string"
          },
          {
            "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false",
            "length": 255,
            "name": "listall",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
            "length": 255,
            "name": "isrecursive",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "list only resources belonging to the domain specified",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain,updateDomain",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list resources by account. Must be used with the domainId parameter.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          }
        ],
        "related": "createPrivateGateway",
        "response": [
          {
            "description": "the physical network id",
            "name": "physicalnetworkid",
            "type": "string"
          },
          {
            "description": "the ID of the domain associated with the private gateway",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "VPC the private gateaway belongs to",
            "name": "vpcid",
            "type": "string"
          },
          {
            "description": "the domain associated with the private gateway",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "zone id of the private gateway",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the gateway",
            "name": "gateway",
            "type": "string"
          },
          {
            "description": "the account associated with the private gateway",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the private gateway's ip address",
            "name": "ipaddress",
            "type": "string"
          },
          {
            "description": "the network implementation uri for the private gateway",
            "name": "vlan",
            "type": "string"
          },
          {
            "description": "the private gateway's netmask",
            "name": "netmask",
            "type": "string"
          },
          {
            "description": "the name of the zone the private gateway belongs to",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the id of the private gateway",
            "name": "id",
            "type": "string"
          },
          {
            "description": "ACL Id set for private gateway",
            "name": "aclid",
            "type": "string"
          },
          {
            "description": "the project id of the private gateway",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the project name of the private gateway",
            "name": "project",
            "type": "string"
          },
          {
            "description": "Souce Nat enable status",
            "name": "sourcenatsupported",
            "type": "boolean"
          },
          {
            "description": "State of the gateway, can be Creating, Ready, Deleting",
            "name": "state",
            "type": "string"
          }
        ]
      },
      {
        "description": "Updates load balancer stickiness policy",
        "isasync": true,
        "name": "updateLBStickinessPolicy",
        "params": [
          {
            "description": "id of lb stickiness policy",
            "length": 255,
            "name": "id",
            "related": "updateLBStickinessPolicy,listLBStickinessPolicies,createLBStickinessPolicy",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "an optional field, whether to the display the policy to the end user or not",
            "length": 255,
            "name": "fordisplay",
            "required": false,
            "since": "4.4",
            "type": "boolean"
          },
          {
            "description": "an optional field, in case you want to set a custom id to the resource. Allowed to Root Admins only",
            "length": 255,
            "name": "customid",
            "required": false,
            "since": "4.4",
            "type": "string"
          }
        ],
        "related": "listLBStickinessPolicies,createLBStickinessPolicy",
        "response": [
          {
            "description": "the state of the policy",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the id of the zone the Stickiness policy belongs to",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the domain ID of the Stickiness policy",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the name of the Stickiness policy",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the list of stickinesspolicies",
            "name": "stickinesspolicy",
            "response": [
              {
                "description": "the params of the policy",
                "name": "params",
                "type": "map"
              },
              {
                "description": "the method name of the Stickiness policy",
                "name": "methodname",
                "type": "string"
              },
              {
                "description": "is policy for display to the regular user",
                "name": "fordisplay",
                "type": "boolean"
              },
              {
                "description": "the name of the Stickiness policy",
                "name": "name",
                "type": "string"
              },
              {
                "description": "the state of the policy",
                "name": "state",
                "type": "string"
              },
              {
                "description": "the description of the Stickiness policy",
                "name": "description",
                "type": "string"
              },
              {
                "description": "the LB Stickiness policy ID",
                "name": "id",
                "type": "string"
              }
            ],
            "type": "list"
          },
          {
            "description": "the LB rule ID",
            "name": "lbruleid",
            "type": "string"
          },
          {
            "description": "the domain of the Stickiness policy",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the account of the Stickiness policy",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the description of the Stickiness policy",
            "name": "description",
            "type": "string"
          }
        ],
        "since": "4.4"
      },
      {
        "description": "Update the default Ip of a VM Nic",
        "isasync": true,
        "name": "updateVmNicIp",
        "params": [
          {
            "description": "the ID of the nic to which you want to assign private IP",
            "length": 255,
            "name": "nicid",
            "related": "listNics",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "Secondary IP Address",
            "length": 255,
            "name": "ipaddress",
            "required": false,
            "type": "string"
          }
        ],
        "related": "stopVirtualMachine,listVirtualMachines,detachIso,updateVMAffinityGroup,revertToVMSnapshot,deployVirtualMachine,migrateVirtualMachine,recoverVirtualMachine,updateDefaultNicForVirtualMachine,migrateVirtualMachineWithVolume,addNicToVirtualMachine,startVirtualMachine,listVirtualMachines,updateVirtualMachine,destroyVirtualMachine,removeNicFromVirtualMachine,removeNicFromVirtualMachine,deployVirtualMachine,destroyVirtualMachine,addNicToVirtualMachine,updateVirtualMachine,rebootVirtualMachine,updateVMAffinityGroup,revertToVMSnapshot,attachIso,resetPasswordForVirtualMachine,assignVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,resetSSHKeyForVirtualMachine,resetPasswordForVirtualMachine,detachIso,changeServiceForVirtualMachine,attachIso,updateDefaultNicForVirtualMachine,startVirtualMachine,stopVirtualMachine",
        "response": [
          {
            "description": " an alternate display text of the template for the virtual machine",
            "name": "templatedisplaytext",
            "type": "string"
          },
          {
            "description": "Vm details in key/value pairs.",
            "name": "details",
            "type": "map"
          },
          {
            "description": "the write (bytes) of disk on the vm",
            "name": "diskkbswrite",
            "type": "long"
          },
          {
            "description": "the name of the host for the virtual machine",
            "name": "hostname",
            "type": "string"
          },
          {
            "description": "the ID of the availablility zone for the virtual machine",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "list of affinity groups associated with the virtual machine",
            "name": "affinitygroup",
            "response": [
              {
                "description": "the project name of the affinity group",
                "name": "project",
                "type": "string"
              },
              {
                "description": "the description of the affinity group",
                "name": "description",
                "type": "string"
              },
              {
                "description": "the type of the affinity group",
                "name": "type",
                "type": "string"
              },
              {
                "description": "the ID of the affinity group",
                "name": "id",
                "type": "string"
              },
              {
                "description": "the domain ID of the affinity group",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the project ID of the affinity group",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "the name of the affinity group",
                "name": "name",
                "type": "string"
              },
              {
                "description": "the domain name of the affinity group",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "virtual machine IDs associated with this affinity group",
                "name": "virtualmachineIds",
                "type": "list"
              },
              {
                "description": "the account owning the affinity group",
                "name": "account",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "the group name of the virtual machine",
            "name": "group",
            "type": "string"
          },
          {
            "description": "the write (io) of disk on the vm",
            "name": "diskiowrite",
            "type": "long"
          },
          {
            "description": "the ID of the virtual machine",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the account associated with the virtual machine",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the ID of the service offering of the virtual machine",
            "name": "serviceofferingid",
            "type": "string"
          },
          {
            "description": "the amount of the vm's CPU currently used",
            "name": "cpuused",
            "type": "string"
          },
          {
            "description": "the read (bytes) of disk on the vm",
            "name": "diskkbsread",
            "type": "long"
          },
          {
            "description": "the ID of the ISO attached to the virtual machine",
            "name": "isoid",
            "type": "string"
          },
          {
            "description": "the name of the service offering of the virtual machine",
            "name": "serviceofferingname",
            "type": "string"
          },
          {
            "description": "Os type ID of the virtual machine",
            "name": "guestosid",
            "type": "string"
          },
          {},
          {
            "description": "the name of the virtual machine",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the ID of the host for the virtual machine",
            "name": "hostid",
            "type": "string"
          },
          {
            "description": "the name of the disk offering of the virtual machine",
            "name": "diskofferingname",
            "type": "string"
          },
          {
            "description": "the list of resource tags associated with vm",
            "name": "tags",
            "response": [
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              },
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "OS type id of the vm",
            "name": "ostypeid",
            "type": "long"
          },
          {
            "description": "the list of nics associated with vm",
            "name": "nic",
            "response": [
              {
                "description": "the gateway of IPv6 network",
                "name": "ip6gateway",
                "type": "string"
              },
              {
                "description": "the netmask of the nic",
                "name": "netmask",
                "type": "string"
              },
              {
                "description": "the ip address of the nic",
                "name": "ipaddress",
                "type": "string"
              },
              {
                "description": "the cidr of IPv6 network",
                "name": "ip6cidr",
                "type": "string"
              },
              {
                "description": "the traffic type of the nic",
                "name": "traffictype",
                "type": "string"
              },
              {
                "description": "device id for the network when plugged into the virtual machine",
                "name": "deviceid",
                "type": "string"
              },
              {
                "description": "true if nic is default, false otherwise",
                "name": "macaddress",
                "type": "string"
              },
              {
                "description": "the gateway of the nic",
                "name": "gateway",
                "type": "string"
              },
              {
                "description": "the broadcast uri of the nic",
                "name": "broadcasturi",
                "type": "string"
              },
              {
                "description": "the Secondary ipv4 addr of nic",
                "name": "secondaryip",
                "type": "list"
              },
              {
                "description": "Id of the vm to which the nic belongs",
                "name": "virtualmachineid",
                "type": "string"
              },
              {
                "description": "the ID of the nic",
                "name": "id",
                "type": "string"
              },
              {
                "description": "the isolation uri of the nic",
                "name": "isolationuri",
                "type": "string"
              },
              {
                "description": "the name of the corresponding network",
                "name": "networkname",
                "type": "string"
              },
              {
                "description": "the type of the nic",
                "name": "type",
                "type": "string"
              },
              {
                "description": "the ID of the corresponding network",
                "name": "networkid",
                "type": "string"
              },
              {
                "description": "true if nic is default, false otherwise",
                "name": "isdefault",
                "type": "boolean"
              },
              {
                "description": "the IPv6 address of network",
                "name": "ip6address",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "public IP address id associated with vm via Static nat rule",
            "name": "publicipid",
            "type": "string"
          },
          {
            "description": "the state of the virtual machine",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the incoming network traffic on the vm",
            "name": "networkkbsread",
            "type": "long"
          },
          {
            "description": "the ID of the domain in which the virtual machine exists",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the vgpu type used by the virtual machine",
            "name": "vgpu",
            "type": "string"
          },
          {
            "description": "the user's name who deployed the virtual machine",
            "name": "username",
            "type": "string"
          },
          {
            "description": "ssh key-pair",
            "name": "keypair",
            "type": "string"
          },
          {
            "description": "the number of cpu this virtual machine is running with",
            "name": "cpunumber",
            "type": "integer"
          },
          {
            "description": "true if high-availability is enabled, false otherwise",
            "name": "haenable",
            "type": "boolean"
          },
          {
            "description": "State of the Service from LB rule",
            "name": "servicestate",
            "type": "string"
          },
          {
            "description": "an optional field whether to the display the vm to the end user or not.",
            "name": "displayvm",
            "type": "boolean"
          },
          {
            "description": "the project name of the vm",
            "name": "project",
            "type": "string"
          },
          {
            "description": "user generated name. The name of the virtual machine is returned if no displayname exists.",
            "name": "displayname",
            "type": "string"
          },
          {
            "description": "the virtual network for the service offering",
            "name": "forvirtualnetwork",
            "type": "boolean"
          },
          {
            "description": "the name of the domain in which the virtual machine exists",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the password (if exists) of the virtual machine",
            "name": "password",
            "type": "string"
          },
          {
            "description": "the project id of the vm",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the memory allocated for the virtual machine",
            "name": "memory",
            "type": "integer"
          },
          {
            "description": "the name of the ISO attached to the virtual machine",
            "name": "isoname",
            "type": "string"
          },
          {
            "description": "the hypervisor on which the template runs",
            "name": "hypervisor",
            "type": "string"
          },
          {
            "description": "the group ID of the virtual machine",
            "name": "groupid",
            "type": "string"
          },
          {
            "description": "device type of the root volume",
            "name": "rootdevicetype",
            "type": "string"
          },
          {
            "description": "the name of the availability zone for the virtual machine",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "public IP address id associated with vm via Static nat rule",
            "name": "publicip",
            "type": "string"
          },
          {
            "description": "instance name of the user vm; this parameter is returned to the ROOT admin only",
            "name": "instancename",
            "type": "string"
          },
          {
            "description": "an alternate display text of the ISO attached to the virtual machine",
            "name": "isodisplaytext",
            "type": "string"
          },
          {
            "description": "the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.",
            "name": "templateid",
            "type": "string"
          },
          {
            "description": "the user's ID who deployed the virtual machine",
            "name": "userid",
            "type": "string"
          },
          {
            "description": "true if vm contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory.",
            "name": "isdynamicallyscalable",
            "type": "boolean"
          },
          {
            "description": "true if the password rest feature is enabled, false otherwise",
            "name": "passwordenabled",
            "type": "boolean"
          },
          {
            "description": "the ID of the disk offering of the virtual machine",
            "name": "diskofferingid",
            "type": "string"
          },
          {
            "description": "the date when this virtual machine was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "the outgoing network traffic on the host",
            "name": "networkkbswrite",
            "type": "long"
          },
          {
            "description": "the read (io) of disk on the vm",
            "name": "diskioread",
            "type": "long"
          },
          {
            "description": "list of security groups associated with the virtual machine",
            "name": "securitygroup",
            "response": [
              {
                "description": "the name of the security group",
                "name": "name",
                "type": "string"
              },
              {
                "description": "the list of ingress rules associated with the security group",
                "name": "ingressrule",
                "response": [
                  {
                    "description": "the CIDR notation for the base IP address of the security group rule",
                    "name": "cidr",
                    "type": "string"
                  },
                  {
                    "description": "account owning the security group rule",
                    "name": "account",
                    "type": "string"
                  },
                  {
                    "description": "security group name",
                    "name": "securitygroupname",
                    "type": "string"
                  },
                  {
                    "description": "the list of resource tags associated with the rule",
                    "name": "tags",
                    "response": [
                      {
                        "description": "tag value",
                        "name": "value",
                        "type": "string"
                      },
                      {
                        "description": "id of the resource",
                        "name": "resourceid",
                        "type": "string"
                      },
                      {
                        "description": "the project name where tag belongs to",
                        "name": "project",
                        "type": "string"
                      },
                      {
                        "description": "tag key name",
                        "name": "key",
                        "type": "string"
                      },
                      {
                        "description": "resource type",
                        "name": "resourcetype",
                        "type": "string"
                      },
                      {
                        "description": "the domain associated with the tag",
                        "name": "domain",
                        "type": "string"
                      },
                      {
                        "description": "the project id the tag belongs to",
                        "name": "projectid",
                        "type": "string"
                      },
                      {
                        "description": "the ID of the domain associated with the tag",
                        "name": "domainid",
                        "type": "string"
                      },
                      {
                        "description": "the account associated with the tag",
                        "name": "account",
                        "type": "string"
                      },
                      {
                        "description": "customer associated with the tag",
                        "name": "customer",
                        "type": "string"
                      }
                    ],
                    "type": "set"
                  },
                  {
                    "description": "the id of the security group rule",
                    "name": "ruleid",
                    "type": "string"
                  },
                  {
                    "description": "the protocol of the security group rule",
                    "name": "protocol",
                    "type": "string"
                  },
                  {
                    "description": "the starting IP of the security group rule",
                    "name": "startport",
                    "type": "integer"
                  },
                  {
                    "description": "the type of the ICMP message response",
                    "name": "icmptype",
                    "type": "integer"
                  },
                  {
                    "description": "the code for the ICMP message response",
                    "name": "icmpcode",
                    "type": "integer"
                  },
                  {
                    "description": "the ending IP of the security group rule ",
                    "name": "endport",
                    "type": "integer"
                  }
                ],
                "type": "set"
              },
              {
                "description": "the project name of the group",
                "name": "project",
                "type": "string"
              },
              {
                "description": "the ID of the security group",
                "name": "id",
                "type": "string"
              },
              {
                "description": "the account owning the security group",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the project id of the group",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "the domain ID of the security group",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the list of resource tags associated with the rule",
                "name": "tags",
                "response": [
                  {
                    "description": "the project name where tag belongs to",
                    "name": "project",
                    "type": "string"
                  },
                  {
                    "description": "the account associated with the tag",
                    "name": "account",
                    "type": "string"
                  },
                  {
                    "description": "the project id the tag belongs to",
                    "name": "projectid",
                    "type": "string"
                  },
                  {
                    "description": "customer associated with the tag",
                    "name": "customer",
                    "type": "string"
                  },
                  {
                    "description": "the ID of the domain associated with the tag",
                    "name": "domainid",
                    "type": "string"
                  },
                  {
                    "description": "the domain associated with the tag",
                    "name": "domain",
                    "type": "string"
                  },
                  {
                    "description": "tag value",
                    "name": "value",
                    "type": "string"
                  },
                  {
                    "description": "tag key name",
                    "name": "key",
                    "type": "string"
                  },
                  {
                    "description": "id of the resource",
                    "name": "resourceid",
                    "type": "string"
                  },
                  {
                    "description": "resource type",
                    "name": "resourcetype",
                    "type": "string"
                  }
                ],
                "type": "set"
              },
              {
                "description": "the list of egress rules associated with the security group",
                "name": "egressrule",
                "response": [
                  {
                    "description": "the code for the ICMP message response",
                    "name": "icmpcode",
                    "type": "integer"
                  },
                  {
                    "description": "security group name",
                    "name": "securitygroupname",
                    "type": "string"
                  },
                  {
                    "description": "the id of the security group rule",
                    "name": "ruleid",
                    "type": "string"
                  },
                  {
                    "description": "the ending IP of the security group rule ",
                    "name": "endport",
                    "type": "integer"
                  },
                  {
                    "description": "the protocol of the security group rule",
                    "name": "protocol",
                    "type": "string"
                  },
                  {
                    "description": "the starting IP of the security group rule",
                    "name": "startport",
                    "type": "integer"
                  },
                  {
                    "description": "the CIDR notation for the base IP address of the security group rule",
                    "name": "cidr",
                    "type": "string"
                  },
                  {
                    "description": "the list of resource tags associated with the rule",
                    "name": "tags",
                    "response": [
                      {
                        "description": "resource type",
                        "name": "resourcetype",
                        "type": "string"
                      },
                      {
                        "description": "the domain associated with the tag",
                        "name": "domain",
                        "type": "string"
                      },
                      {
                        "description": "the project id the tag belongs to",
                        "name": "projectid",
                        "type": "string"
                      },
                      {
                        "description": "customer associated with the tag",
                        "name": "customer",
                        "type": "string"
                      },
                      {
                        "description": "tag value",
                        "name": "value",
                        "type": "string"
                      },
                      {
                        "description": "the account associated with the tag",
                        "name": "account",
                        "type": "string"
                      },
                      {
                        "description": "the project name where tag belongs to",
                        "name": "project",
                        "type": "string"
                      },
                      {
                        "description": "tag key name",
                        "name": "key",
                        "type": "string"
                      },
                      {
                        "description": "id of the resource",
                        "name": "resourceid",
                        "type": "string"
                      },
                      {
                        "description": "the ID of the domain associated with the tag",
                        "name": "domainid",
                        "type": "string"
                      }
                    ],
                    "type": "set"
                  },
                  {
                    "description": "the type of the ICMP message response",
                    "name": "icmptype",
                    "type": "integer"
                  },
                  {
                    "description": "account owning the security group rule",
                    "name": "account",
                    "type": "string"
                  }
                ],
                "type": "set"
              },
              {
                "description": "the description of the security group",
                "name": "description",
                "type": "string"
              },
              {
                "description": "the list of virtualmachine ids associated with this securitygroup",
                "name": "virtualmachineids",
                "type": "set"
              },
              {
                "description": "the number of virtualmachines associated with this securitygroup",
                "name": "virtualmachinecount",
                "type": "integer"
              },
              {
                "description": "the domain name of the security group",
                "name": "domain",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "the name of the template for the virtual machine",
            "name": "templatename",
            "type": "string"
          },
          {
            "description": "device ID of the root volume",
            "name": "rootdeviceid",
            "type": "long"
          },
          {
            "description": "the speed of each cpu",
            "name": "cpuspeed",
            "type": "integer"
          }
        ]
      },
      {
        "description": "Starts an existing internal lb vm.",
        "isasync": true,
        "name": "startInternalLoadBalancerVM",
        "params": [
          {
            "description": "the ID of the internal lb vm",
            "length": 255,
            "name": "id",
            "related": "changeServiceForRouter,rebootRouter,destroyRouter,listInternalLoadBalancerVMs,startInternalLoadBalancerVM,stopInternalLoadBalancerVM,listRouters",
            "required": true,
            "type": "uuid"
          }
        ],
        "related": "changeServiceForRouter,rebootRouter,destroyRouter,listInternalLoadBalancerVMs,stopInternalLoadBalancerVM,listRouters",
        "response": [
          {
            "description": "the Zone name for the router",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the first DNS for the router",
            "name": "dns1",
            "type": "string"
          },
          {
            "description": "the domain ID associated with the router",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the name of the corresponding guest network",
            "name": "guestnetworkname",
            "type": "string"
          },
          {
            "description": "the ID of the corresponding guest network",
            "name": "guestnetworkid",
            "type": "string"
          },
          {
            "description": "the domain associated with the router",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "VPC the router belongs to",
            "name": "vpcid",
            "type": "string"
          },
          {
            "description": "the id of the router",
            "name": "id",
            "type": "string"
          },
          {
            "description": "true if the router template requires upgrader",
            "name": "requiresupgrade",
            "type": "boolean"
          },
          {
            "description": "the link local MAC address for the router",
            "name": "linklocalmacaddress",
            "type": "string"
          },
          {
            "description": "the link local netmask for the router",
            "name": "linklocalnetmask",
            "type": "string"
          },
          {
            "description": "the hostname for the router",
            "name": "hostname",
            "type": "string"
          },
          {
            "description": "role of the domain router",
            "name": "role",
            "type": "string"
          },
          {
            "description": "the hypervisor on which the template runs",
            "name": "hypervisor",
            "type": "string"
          },
          {
            "description": "the template ID for the router",
            "name": "templateid",
            "type": "string"
          },
          {
            "description": "the network domain for the router",
            "name": "networkdomain",
            "type": "string"
          },
          {
            "description": "the state of the router",
            "name": "state",
            "type": "state"
          },
          {
            "description": "the guest IP address for the router",
            "name": "guestipaddress",
            "type": "string"
          },
          {
            "description": "the Zone ID for the router",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the second IPv6 DNS for the router",
            "name": "ip6dns2",
            "type": "string"
          },
          {
            "description": "the first IPv6 DNS for the router",
            "name": "ip6dns1",
            "type": "string"
          },
          {
            "description": "the link local IP address for the router",
            "name": "linklocalip",
            "type": "string"
          },
          {
            "description": "the account associated with the router",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the name of VPC the router belongs to",
            "name": "vpcname",
            "type": "string"
          },
          {
            "description": "the state of redundant virtual router",
            "name": "redundantstate",
            "type": "string"
          },
          {
            "description": "the public MAC address for the router",
            "name": "publicmacaddress",
            "type": "string"
          },
          {
            "description": "the name of the service offering of the virtual machine",
            "name": "serviceofferingname",
            "type": "string"
          },
          {
            "description": "the public IP address for the router",
            "name": "publicip",
            "type": "string"
          },
          {
            "description": "the project id of the ipaddress",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the public netmask for the router",
            "name": "publicnetmask",
            "type": "string"
          },
          {
            "description": "the host ID for the router",
            "name": "hostid",
            "type": "string"
          },
          {
            "description": "the Pod ID for the router",
            "name": "podid",
            "type": "string"
          },
          {
            "description": "the ID of the corresponding link local network",
            "name": "linklocalnetworkid",
            "type": "string"
          },
          {
            "description": "the guest MAC address for the router",
            "name": "guestmacaddress",
            "type": "string"
          },
          {
            "description": "the version of template",
            "name": "version",
            "type": "string"
          },
          {
            "description": "the list of nics associated with the router",
            "name": "nic",
            "response": [
              {
                "description": "true if nic is default, false otherwise",
                "name": "isdefault",
                "type": "boolean"
              },
              {
                "description": "the ID of the nic",
                "name": "id",
                "type": "string"
              },
              {
                "description": "the Secondary ipv4 addr of nic",
                "name": "secondaryip",
                "type": "list"
              },
              {
                "description": "the netmask of the nic",
                "name": "netmask",
                "type": "string"
              },
              {
                "description": "the IPv6 address of network",
                "name": "ip6address",
                "type": "string"
              },
              {
                "description": "device id for the network when plugged into the virtual machine",
                "name": "deviceid",
                "type": "string"
              },
              {
                "description": "the type of the nic",
                "name": "type",
                "type": "string"
              },
              {
                "description": "the cidr of IPv6 network",
                "name": "ip6cidr",
                "type": "string"
              },
              {
                "description": "Id of the vm to which the nic belongs",
                "name": "virtualmachineid",
                "type": "string"
              },
              {
                "description": "true if nic is default, false otherwise",
                "name": "macaddress",
                "type": "string"
              },
              {
                "description": "the name of the corresponding network",
                "name": "networkname",
                "type": "string"
              },
              {
                "description": "the traffic type of the nic",
                "name": "traffictype",
                "type": "string"
              },
              {
                "description": "the gateway of the nic",
                "name": "gateway",
                "type": "string"
              },
              {
                "description": "the isolation uri of the nic",
                "name": "isolationuri",
                "type": "string"
              },
              {
                "description": "the gateway of IPv6 network",
                "name": "ip6gateway",
                "type": "string"
              },
              {
                "description": "the ip address of the nic",
                "name": "ipaddress",
                "type": "string"
              },
              {
                "description": "the ID of the corresponding network",
                "name": "networkid",
                "type": "string"
              },
              {
                "description": "the broadcast uri of the nic",
                "name": "broadcasturi",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "the second DNS for the router",
            "name": "dns2",
            "type": "string"
          },
          {
            "description": "the gateway for the router",
            "name": "gateway",
            "type": "string"
          },
          {
            "description": "the guest netmask for the router",
            "name": "guestnetmask",
            "type": "string"
          },
          {
            "description": "the name of the router",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the date and time the router was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "the version of scripts",
            "name": "scriptsversion",
            "type": "string"
          },
          {
            "description": "if this router is an redundant virtual router",
            "name": "isredundantrouter",
            "type": "boolean"
          },
          {
            "description": "the ID of the service offering of the virtual machine",
            "name": "serviceofferingid",
            "type": "string"
          },
          {
            "description": "the ID of the corresponding public network",
            "name": "publicnetworkid",
            "type": "string"
          },
          {
            "description": "the project name of the address",
            "name": "project",
            "type": "string"
          }
        ]
      },
      {
        "description": "Lists all Pods.",
        "isasync": false,
        "name": "listPods",
        "params": [
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "flag to display the capacity of the pods",
            "length": 255,
            "name": "showcapacities",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "list Pods by Zone ID",
            "length": 255,
            "name": "zoneid",
            "related": "createZone,updateZone,listZones,listZones",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list Pods by ID",
            "length": 255,
            "name": "id",
            "related": "updatePod,listPods",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list Pods by name",
            "length": 255,
            "name": "name",
            "required": false,
            "type": "string"
          },
          {
            "description": "list pods by allocation state",
            "length": 255,
            "name": "allocationstate",
            "required": false,
            "type": "string"
          }
        ],
        "related": "updatePod",
        "response": [
          {
            "description": "the starting IP for the Pod",
            "name": "startip",
            "type": "string"
          },
          {
            "description": "the capacity of the Pod",
            "name": "capacity",
            "response": [
              {
                "description": "the capacity type",
                "name": "type",
                "type": "short"
              },
              {
                "description": "the Cluster name",
                "name": "clustername",
                "type": "string"
              },
              {
                "description": "the Pod ID",
                "name": "podid",
                "type": "string"
              },
              {
                "description": "the Pod name",
                "name": "podname",
                "type": "string"
              },
              {
                "description": "the Zone ID",
                "name": "zoneid",
                "type": "string"
              },
              {
                "description": "the capacity currently in use",
                "name": "capacityused",
                "type": "long"
              },
              {
                "description": "the Zone name",
                "name": "zonename",
                "type": "string"
              },
              {
                "description": "the Cluster ID",
                "name": "clusterid",
                "type": "string"
              },
              {
                "description": "the percentage of capacity currently in use",
                "name": "percentused",
                "type": "string"
              },
              {
                "description": "the total capacity available",
                "name": "capacitytotal",
                "type": "long"
              }
            ],
            "type": "list"
          },
          {
            "description": "the Zone ID of the Pod",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the netmask of the Pod",
            "name": "netmask",
            "type": "string"
          },
          {
            "description": "the Zone name of the Pod",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the ending IP for the Pod",
            "name": "endip",
            "type": "string"
          },
          {
            "description": "the allocation state of the Pod",
            "name": "allocationstate",
            "type": "string"
          },
          {
            "description": "the ID of the Pod",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the name of the Pod",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the gateway of the Pod",
            "name": "gateway",
            "type": "string"
          }
        ]
      },
      {
        "description": "Updates a disk offering.",
        "isasync": false,
        "name": "updateDiskOffering",
        "params": [
          {
            "description": "updates name of the disk offering with this value",
            "length": 255,
            "name": "name",
            "required": false,
            "type": "string"
          },
          {
            "description": "updates alternate display text of the disk offering with this value",
            "length": 4096,
            "name": "displaytext",
            "required": false,
            "type": "string"
          },
          {
            "description": "an optional field, whether to display the offering to the end user or not.",
            "length": 255,
            "name": "displayoffering",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "ID of the disk offering",
            "length": 255,
            "name": "id",
            "related": "listDiskOfferings,createDiskOffering,updateDiskOffering",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "sort key of the disk offering, integer",
            "length": 255,
            "name": "sortkey",
            "required": false,
            "type": "integer"
          }
        ],
        "related": "listDiskOfferings,createDiskOffering",
        "response": [
          {
            "description": "the max iops of the disk offering",
            "name": "maxiops",
            "type": "long"
          },
          {
            "description": "true if disk offering uses custom iops, false otherwise",
            "name": "iscustomizediops",
            "type": "boolean"
          },
          {
            "description": "the tags for the disk offering",
            "name": "tags",
            "type": "string"
          },
          {
            "description": "bytes write rate of the disk offering",
            "name": "diskBytesWriteRate",
            "type": "long"
          },
          {
            "description": "io requests read rate of the disk offering",
            "name": "diskIopsReadRate",
            "type": "long"
          },
          {
            "description": "Hypervisor snapshot reserve space as a percent of a volume (for managed storage using Xen or VMware)",
            "name": "hypervisorsnapshotreserve",
            "type": "integer"
          },
          {
            "description": "bytes read rate of the disk offering",
            "name": "diskBytesReadRate",
            "type": "long"
          },
          {
            "description": "the domain name this disk offering belongs to. Ignore this information as it is not currently applicable.",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the domain ID this disk offering belongs to. Ignore this information as it is not currently applicable.",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the date this disk offering was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "unique ID of the disk offering",
            "name": "id",
            "type": "string"
          },
          {
            "description": "an alternate display text of the disk offering.",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "the storage type for this disk offering",
            "name": "storagetype",
            "type": "string"
          },
          {
            "description": "the name of the disk offering",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the size of the disk offering in GB",
            "name": "disksize",
            "type": "long"
          },
          {
            "description": "io requests write rate of the disk offering",
            "name": "diskIopsWriteRate",
            "type": "long"
          },
          {
            "description": "the min iops of the disk offering",
            "name": "miniops",
            "type": "long"
          },
          {
            "description": "provisioning type used to create volumes. Valid values are thin, sparse, fat.",
            "name": "provisioningtype",
            "type": "string"
          },
          {
            "description": "true if disk offering uses custom size, false otherwise",
            "name": "iscustomized",
            "type": "boolean"
          },
          {
            "description": "the cache mode to use for this disk offering. none, writeback or writethrough",
            "name": "cacheMode",
            "type": "string"
          },
          {
            "description": "whether to display the offering to the end user or not.",
            "name": "displayoffering",
            "type": "boolean"
          }
        ]
      },
      {
        "description": "Adds account to a project",
        "isasync": true,
        "name": "addAccountToProject",
        "params": [
          {
            "description": "email to which invitation to the project is going to be sent",
            "length": 255,
            "name": "email",
            "required": false,
            "type": "string"
          },
          {
            "description": "name of the account to be added to the project",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "ID of the project to add the account to",
            "length": 255,
            "name": "projectid",
            "related": "activateProject,createProject,updateProject,suspendProject,listProjectAccounts,listProjects",
            "required": true,
            "type": "uuid"
          }
        ],
        "response": [
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          },
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          }
        ],
        "since": "3.0.0"
      },
      {
        "description": "Lists all available snapshots for the account.",
        "isasync": false,
        "name": "listSnapshots",
        "params": [
          {
            "description": "list only resources belonging to the domain specified",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain,updateDomain",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "valid values are HOURLY, DAILY, WEEKLY, and MONTHLY.",
            "length": 255,
            "name": "intervaltype",
            "required": false,
            "type": "string"
          },
          {
            "description": "list snapshots by zone id",
            "length": 255,
            "name": "zoneid",
            "related": "createZone,updateZone,listZones,listZones",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
            "length": 255,
            "name": "isrecursive",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "list objects by project",
            "length": 255,
            "name": "projectid",
            "related": "activateProject,createProject,updateProject,suspendProject,listProjectAccounts,listProjects",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false",
            "length": 255,
            "name": "listall",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "list resources by account. Must be used with the domainId parameter.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "lists snapshot by snapshot ID",
            "length": 255,
            "name": "id",
            "related": "revertSnapshot,createSnapshot,listSnapshots",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "valid values are MANUAL or RECURRING.",
            "length": 255,
            "name": "snapshottype",
            "required": false,
            "type": "string"
          },
          {
            "description": "List resources by tags (key/value pairs)",
            "length": 255,
            "name": "tags",
            "required": false,
            "type": "map"
          },
          {
            "description": "the ID of the disk volume",
            "length": 255,
            "name": "volumeid",
            "related": "createVolume,updateVolume,uploadVolume,updateVolume,attachVolume,migrateVolume,createVolume,detachVolume,attachVolume,migrateVolume,resizeVolume,detachVolume,resizeVolume,listVolumes,listVolumes",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "lists snapshot by snapshot name",
            "length": 255,
            "name": "name",
            "required": false,
            "type": "string"
          }
        ],
        "related": "revertSnapshot,createSnapshot",
        "response": [
          {
            "description": "the state of the snapshot. BackedUp means that snapshot is ready to be used; Creating - the snapshot is being allocated on the primary storage; BackingUp - the snapshot is being backed up on secondary storage",
            "name": "state",
            "type": "state"
          },
          {
            "description": "the list of resource tags associated with snapshot",
            "name": "tags",
            "response": [
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              },
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              }
            ],
            "type": "list"
          },
          {
            "description": "the project id of the snapshot",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "id of the availability zone",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the domain name of the snapshot's account",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the account associated with the snapshot",
            "name": "account",
            "type": "string"
          },
          {
            "description": "ID of the disk volume",
            "name": "volumeid",
            "type": "string"
          },
          {
            "description": "ID of the snapshot",
            "name": "id",
            "type": "string"
          },
          {
            "description": "physical size of backedup snapshot on image store",
            "name": "physicalsize",
            "type": "long"
          },
          {
            "description": "type of the disk volume",
            "name": "volumetype",
            "type": "string"
          },
          {
            "description": "  the date the snapshot was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "name of the snapshot",
            "name": "name",
            "type": "string"
          },
          {
            "description": "valid types are hourly, daily, weekly, monthy, template, and none.",
            "name": "intervaltype",
            "type": "string"
          },
          {
            "description": "name of the disk volume",
            "name": "volumename",
            "type": "string"
          },
          {
            "description": "the domain ID of the snapshot's account",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "indicates whether the underlying storage supports reverting the volume to this snapshot",
            "name": "revertable",
            "type": "boolean"
          },
          {
            "description": "the type of the snapshot",
            "name": "snapshottype",
            "type": "string"
          },
          {
            "description": "the project name of the snapshot",
            "name": "project",
            "type": "string"
          }
        ]
      },
      {
        "description": "Reset site to site vpn connection",
        "isasync": true,
        "name": "resetVpnConnection",
        "params": [
          {
            "description": "an optional account for connection. Must be used with domainId.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "id of vpn connection",
            "length": 255,
            "name": "id",
            "related": "resetVpnConnection,createVpnConnection,updateVpnConnection,listVpnConnections",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "an optional domainId for connection. If the account parameter is used, domainId must also be used.",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain,updateDomain",
            "required": false,
            "type": "uuid"
          }
        ],
        "related": "createVpnConnection,updateVpnConnection,listVpnConnections",
        "response": [
          {
            "description": "is connection for display to the regular user",
            "name": "fordisplay",
            "type": "boolean"
          },
          {
            "description": "the vpn gateway ID",
            "name": "s2svpngatewayid",
            "type": "string"
          },
          {
            "description": "the project id",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "if Force NAT Encapsulation is enabled for customer gateway",
            "name": "forceencap",
            "type": "boolean"
          },
          {
            "description": "the domain id of the owner",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "State of vpn connection",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the date and time the host was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "State of vpn connection",
            "name": "passive",
            "type": "boolean"
          },
          {
            "description": "the owner",
            "name": "account",
            "type": "string"
          },
          {
            "description": "Lifetime of ESP SA of customer gateway",
            "name": "esplifetime",
            "type": "long"
          },
          {
            "description": "IKE policy of the customer gateway",
            "name": "ikepolicy",
            "type": "string"
          },
          {
            "description": "IPsec Preshared-Key of the customer gateway",
            "name": "ipsecpsk",
            "type": "string"
          },
          {
            "description": "the connection ID",
            "name": "id",
            "type": "string"
          },
          {
            "description": "ESP policy of the customer gateway",
            "name": "esppolicy",
            "type": "string"
          },
          {
            "description": "public ip address id of the customer gateway",
            "name": "gateway",
            "type": "string"
          },
          {
            "description": "if DPD is enabled for customer gateway",
            "name": "dpd",
            "type": "boolean"
          },
          {
            "description": "the customer gateway ID",
            "name": "s2scustomergatewayid",
            "type": "string"
          },
          {
            "description": "Lifetime of IKE SA of customer gateway",
            "name": "ikelifetime",
            "type": "long"
          },
          {
            "description": "the project name",
            "name": "project",
            "type": "string"
          },
          {
            "description": "the date and time the host was removed",
            "name": "removed",
            "type": "date"
          },
          {
            "description": "guest cidr list of the customer gateway",
            "name": "cidrlist",
            "type": "string"
          },
          {
            "description": "the domain name of the owner",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the public IP address",
            "name": "publicip",
            "type": "string"
          }
        ]
      },
      {
        "description": "Deletes a keypair by name",
        "isasync": false,
        "name": "deleteSSHKeyPair",
        "params": [
          {
            "description": "the project associated with keypair",
            "length": 255,
            "name": "projectid",
            "related": "activateProject,createProject,updateProject,suspendProject,listProjectAccounts,listProjects",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "the domain ID associated with the keypair",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain,updateDomain",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "Name of the keypair",
            "length": 255,
            "name": "name",
            "required": true,
            "type": "string"
          },
          {
            "description": "the account associated with the keypair. Must be used with the domainId parameter.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          }
        ],
        "response": [
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          }
        ]
      },
      {
        "description": "Creates and automatically starts a virtual machine based on a service offering, disk offering, and template.",
        "isasync": true,
        "name": "createAutoScaleVmGroup",
        "params": [
          {
            "description": "list of scaleup autoscale policies",
            "length": 255,
            "name": "scaleuppolicyids",
            "related": "listAutoScalePolicies,updateAutoScalePolicy",
            "required": true,
            "type": "list"
          },
          {
            "description": "list of scaledown autoscale policies",
            "length": 255,
            "name": "scaledownpolicyids",
            "related": "listAutoScalePolicies,updateAutoScalePolicy",
            "required": true,
            "type": "list"
          },
          {
            "description": "the autoscale profile that contains information about the vms in the vm group.",
            "length": 255,
            "name": "vmprofileid",
            "related": "updateAutoScaleVmProfile,listAutoScaleVmProfiles,createAutoScaleVmProfile",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "the maximum number of members in the vmgroup, The number of instances in the vm group will be equal to or less than this number.",
            "length": 255,
            "name": "maxmembers",
            "required": true,
            "type": "integer"
          },
          {
            "description": "the minimum number of members in the vmgroup, the number of instances in the vm group will be equal to or more than this number.",
            "length": 255,
            "name": "minmembers",
            "required": true,
            "type": "integer"
          },
          {
            "description": "the ID of the load balancer rule",
            "length": 255,
            "name": "lbruleid",
            "related": "listIpForwardingRules,listPortForwardingRules,updatePortForwardingRule,createPortForwardingRule",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "an optional field, whether to the display the group to the end user or not",
            "length": 255,
            "name": "fordisplay",
            "required": false,
            "since": "4.4",
            "type": "boolean"
          },
          {
            "description": "the frequency at which the conditions have to be evaluated",
            "length": 255,
            "name": "interval",
            "required": false,
            "type": "integer"
          }
        ],
        "related": "enableAutoScaleVmGroup,disableAutoScaleVmGroup,updateAutoScaleVmGroup,listAutoScaleVmGroups",
        "response": [
          {
            "description": "the project id vm profile",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the domain name of the vm profile",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the frequency at which the conditions have to be evaluated",
            "name": "interval",
            "type": "int"
          },
          {
            "description": "the load balancer rule ID",
            "name": "lbruleid",
            "type": "string"
          },
          {
            "description": "the account owning the instance group",
            "name": "account",
            "type": "string"
          },
          {
            "description": "list of scaledown autoscale policies",
            "name": "scaledownpolicies",
            "type": "list"
          },
          {
            "description": "the autoscale vm group ID",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the maximum number of members in the vmgroup, The number of instances in the vm group will be equal to or less than this number.",
            "name": "maxmembers",
            "type": "int"
          },
          {
            "description": "the project name of the vm profile",
            "name": "project",
            "type": "string"
          },
          {
            "description": "list of scaleup autoscale policies",
            "name": "scaleuppolicies",
            "type": "list"
          },
          {
            "description": "the current state of the AutoScale Vm Group",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the autoscale profile that contains information about the vms in the vm group.",
            "name": "vmprofileid",
            "type": "string"
          },
          {
            "description": "the domain ID of the vm profile",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the minimum number of members in the vmgroup, the number of instances in the vm group will be equal to or more than this number.",
            "name": "minmembers",
            "type": "int"
          },
          {
            "description": "is group for display to the regular user",
            "name": "fordisplay",
            "type": "boolean"
          }
        ]
      },
      {
        "description": "add a baremetal ping pxe server",
        "isasync": true,
        "name": "addBaremetalPxePingServer",
        "params": [
          {
            "description": "the Physical Network ID",
            "length": 255,
            "name": "physicalnetworkid",
            "related": "createPhysicalNetwork,updatePhysicalNetwork",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "type of pxe device",
            "length": 255,
            "name": "pxeservertype",
            "required": true,
            "type": "string"
          },
          {
            "description": "Username of PING storage server",
            "length": 255,
            "name": "pingcifsusername",
            "required": false,
            "type": "string"
          },
          {
            "description": "Credentials to reach external pxe device",
            "length": 255,
            "name": "username",
            "required": true,
            "type": "string"
          },
          {
            "description": "Tftp root directory of PXE server",
            "length": 255,
            "name": "tftpdir",
            "required": true,
            "type": "string"
          },
          {
            "description": "Pod Id",
            "length": 255,
            "name": "podid",
            "related": "updatePod",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "URL of the external pxe device",
            "length": 255,
            "name": "url",
            "required": true,
            "type": "string"
          },
          {
            "description": "Password of PING storage server",
            "length": 255,
            "name": "pingcifspassword",
            "required": false,
            "type": "string"
          },
          {
            "description": "Credentials to reach external pxe device",
            "length": 255,
            "name": "password",
            "required": true,
            "type": "string"
          },
          {
            "description": "PING storage server ip",
            "length": 255,
            "name": "pingstorageserverip",
            "required": true,
            "type": "string"
          },
          {
            "description": "Root directory on PING storage server",
            "length": 255,
            "name": "pingdir",
            "required": true,
            "type": "string"
          }
        ],
        "related": "",
        "response": [
          {
            "description": "PING storage server ip",
            "name": "pingstorageserverip",
            "type": "string"
          },
          {
            "description": "Root directory on PING storage server",
            "name": "pingdir",
            "type": "string"
          },
          {
            "description": "Tftp root directory of PXE server",
            "name": "tftpdir",
            "type": "string"
          }
        ]
      },
      {
        "description": "Deletes a load balancer rule.",
        "isasync": true,
        "name": "deleteLoadBalancerRule",
        "params": [
          {
            "description": "the ID of the load balancer rule",
            "length": 255,
            "name": "id",
            "related": "listIpForwardingRules,listPortForwardingRules,updatePortForwardingRule,createPortForwardingRule",
            "required": true,
            "type": "uuid"
          }
        ],
        "response": [
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          },
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          }
        ]
      },
      {
        "description": "list portable IP ranges",
        "isasync": false,
        "name": "listPortableIpRanges",
        "params": [
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "Id of the portable ip range",
            "length": 255,
            "name": "id",
            "related": "createPortableIpRange,listPortableIpRanges",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "Id of a Region",
            "length": 255,
            "name": "regionid",
            "required": false,
            "type": "integer"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          }
        ],
        "related": "createPortableIpRange",
        "response": [
          {
            "description": "Region Id in which portable ip range is provisioned",
            "name": "regionid",
            "type": "integer"
          },
          {
            "description": "the end ip of the portable IP range",
            "name": "endip",
            "type": "string"
          },
          {
            "description": "List of portable IP and association with zone/network/vpc details that are part of GSLB rule",
            "name": "portableipaddress",
            "response": [
              {
                "description": "State of the ip address. Can be: Allocatin, Allocated and Releasing",
                "name": "state",
                "type": "string"
              },
              {
                "description": "the domain ID the portable IP address is associated with",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the account ID the portable IP address is associated with",
                "name": "accountid",
                "type": "string"
              },
              {
                "description": "the ID of the Network where ip belongs to",
                "name": "networkid",
                "type": "string"
              },
              {
                "description": "public IP address",
                "name": "ipaddress",
                "type": "string"
              },
              {
                "description": "the physical network this belongs to",
                "name": "physicalnetworkid",
                "type": "string"
              },
              {
                "description": "date the portal IP address was acquired",
                "name": "allocated",
                "type": "date"
              },
              {
                "description": "the ID of the zone the public IP address belongs to",
                "name": "zoneid",
                "type": "string"
              },
              {
                "description": "VPC the ip belongs to",
                "name": "vpcid",
                "type": "string"
              },
              {
                "description": "Region Id in which global load balancer is created",
                "name": "regionid",
                "type": "integer"
              }
            ],
            "type": "list"
          },
          {
            "description": "the netmask of the VLAN IP range",
            "name": "netmask",
            "type": "string"
          },
          {
            "description": "portable IP range ID",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the ID or VID of the VLAN.",
            "name": "vlan",
            "type": "string"
          },
          {
            "description": "the start ip of the portable IP range",
            "name": "startip",
            "type": "string"
          },
          {
            "description": "the gateway of the VLAN IP range",
            "name": "gateway",
            "type": "string"
          }
        ]
      },
      {
        "description": "Returns user data associated with the VM",
        "isasync": false,
        "name": "getVirtualMachineUserData",
        "params": [
          {
            "description": "The ID of the virtual machine",
            "length": 255,
            "name": "virtualmachineid",
            "related": "stopVirtualMachine,listVirtualMachines,detachIso,updateVMAffinityGroup,revertToVMSnapshot,deployVirtualMachine,migrateVirtualMachine,recoverVirtualMachine,updateDefaultNicForVirtualMachine,migrateVirtualMachineWithVolume,addNicToVirtualMachine,startVirtualMachine,listVirtualMachines,updateVirtualMachine,destroyVirtualMachine,removeNicFromVirtualMachine,removeNicFromVirtualMachine,deployVirtualMachine,destroyVirtualMachine,addNicToVirtualMachine,updateVirtualMachine,rebootVirtualMachine,updateVMAffinityGroup,revertToVMSnapshot,attachIso,resetPasswordForVirtualMachine,assignVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,resetSSHKeyForVirtualMachine,resetPasswordForVirtualMachine,detachIso,changeServiceForVirtualMachine,attachIso,updateDefaultNicForVirtualMachine,startVirtualMachine,stopVirtualMachine",
            "required": true,
            "type": "uuid"
          }
        ],
        "related": "",
        "response": [
          {
            "description": "the ID of the virtual machine",
            "name": "virtualmachineid",
            "type": "string"
          },
          {
            "description": "Base 64 encoded VM user data",
            "name": "userdata",
            "type": "string"
          }
        ],
        "since": "4.4"
      },
      {
        "description": "Lists all configurations.",
        "isasync": false,
        "name": "listConfigurations",
        "params": [
          {
            "description": "lists configuration by name",
            "length": 255,
            "name": "name",
            "required": false,
            "type": "string"
          },
          {
            "description": "lists configurations by category",
            "length": 255,
            "name": "category",
            "required": false,
            "type": "string"
          },
          {
            "description": "the ID of the Account to update the parameter value for corresponding account",
            "length": 255,
            "name": "accountid",
            "related": "enableAccount,listAccounts,disableAccount,listAccounts,markDefaultZoneForAccount,createAccount,updateAccount",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "the ID of the Storage pool to update the parameter value for corresponding storage pool",
            "length": 255,
            "name": "storageid",
            "related": "cancelStorageMaintenance,enableStorageMaintenance,createStoragePool,listStoragePools,findStoragePoolsForMigration",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "the ID of the Zone to update the parameter value for corresponding zone",
            "length": 255,
            "name": "zoneid",
            "related": "createZone,updateZone,listZones,listZones",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "the ID of the Cluster to update the parameter value for corresponding cluster",
            "length": 255,
            "name": "clusterid",
            "related": "addCluster,updateCluster",
            "required": false,
            "type": "uuid"
          }
        ],
        "related": "updateConfiguration",
        "response": [
          {
            "description": "the description of the configuration",
            "name": "description",
            "type": "string"
          },
          {
            "description": "the name of the configuration",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the category of the configuration",
            "name": "category",
            "type": "string"
          },
          {
            "description": "the value of the configuration",
            "name": "value",
            "type": "string"
          },
          {
            "description": "the value of the configuration",
            "name": "id",
            "type": "long"
          },
          {
            "description": "scope(zone/cluster/pool/account) of the parameter that needs to be updated",
            "name": "scope",
            "type": "string"
          }
        ]
      },
      {
        "description": "Disables static rule for given IP address",
        "isasync": true,
        "name": "disableStaticNat",
        "params": [
          {
            "description": "the public IP address ID for which static NAT feature is being disabled",
            "length": 255,
            "name": "ipaddressid",
            "related": "associateIpAddress,restartNetwork,updateIpAddress,listPublicIpAddresses,listPublicIpAddresses,associateIpAddress",
            "required": true,
            "type": "uuid"
          }
        ],
        "response": [
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          }
        ]
      },
      {
        "description": "Assigns secondary IP to NIC",
        "isasync": true,
        "name": "addIpToNic",
        "params": [
          {
            "description": "Secondary IP Address",
            "length": 255,
            "name": "ipaddress",
            "required": false,
            "type": "string"
          },
          {
            "description": "the ID of the nic to which you want to assign private IP",
            "length": 255,
            "name": "nicid",
            "related": "listNics",
            "required": true,
            "type": "uuid"
          }
        ],
        "related": "",
        "response": [
          {
            "description": "the ID of the secondary private IP addr",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the ID of the nic",
            "name": "nicid",
            "type": "string"
          },
          {
            "description": "Secondary IP address",
            "name": "ipaddress",
            "type": "string"
          },
          {
            "description": "the ID of the network",
            "name": "networkid",
            "type": "string"
          },
          {
            "description": "the ID of the vm",
            "name": "virtualmachineid",
            "type": "string"
          }
        ]
      },
      {
        "description": "Deletes a vm group",
        "isasync": false,
        "name": "deleteInstanceGroup",
        "params": [
          {
            "description": "the ID of the instance group",
            "length": 255,
            "name": "id",
            "related": "updateInstanceGroup,createInstanceGroup,listInstanceGroups",
            "required": true,
            "type": "uuid"
          }
        ],
        "response": [
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          },
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          }
        ]
      },
      {
        "description": "Deletes a host.",
        "isasync": false,
        "name": "deleteHost",
        "params": [
          {
            "description": "Force destroy local storage on this host. All VMs created on this local storage will be destroyed",
            "length": 255,
            "name": "forcedestroylocalstorage",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "Force delete the host. All HA enabled vms running on the host will be put to HA; HA disabled ones will be stopped",
            "length": 255,
            "name": "forced",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "the host ID",
            "length": 255,
            "name": "id",
            "related": "addHost,reconnectHost,addBaremetalHost,cancelHostMaintenance,prepareHostForMaintenance",
            "required": true,
            "type": "uuid"
          }
        ],
        "response": [
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          }
        ]
      },
      {
        "description": "Lists capabilities",
        "isasync": false,
        "name": "listCapabilities",
        "params": [],
        "related": "",
        "response": [
          {
            "description": "true if user and domain admins can set templates to be shared, false otherwise",
            "name": "userpublictemplateenabled",
            "type": "boolean"
          },
          {
            "description": "true if regular user is allowed to create projects",
            "name": "allowusercreateprojects",
            "type": "boolean"
          },
          {
            "description": "true if the user is allowed to view destroyed virtualmachines, false otherwise",
            "name": "allowuserviewdestroyedvm",
            "type": "boolean"
          },
          {
            "description": "time interval (in seconds) to reset api count",
            "name": "apilimitinterval",
            "type": "integer"
          },
          {
            "description": "true if the user can recover and expunge virtualmachines, false otherwise",
            "name": "allowuserexpungerecovervm",
            "type": "boolean"
          },
          {
            "description": "maximum size that can be specified when create disk from disk offering with custom size",
            "name": "customdiskofferingmaxsize",
            "type": "long"
          },
          {
            "description": "true if security groups support is enabled, false otherwise",
            "name": "securitygroupsenabled",
            "type": "boolean"
          },
          {
            "description": "true if region wide secondary is enabled, false otherwise",
            "name": "regionsecondaryenabled",
            "type": "boolean"
          },
          {
            "description": "If invitation confirmation is required when add account to project",
            "name": "projectinviterequired",
            "type": "boolean"
          },
          {
            "description": "minimum size that can be specified when create disk from disk offering with custom size",
            "name": "customdiskofferingminsize",
            "type": "long"
          },
          {
            "description": "version of the cloud stack",
            "name": "cloudstackversion",
            "type": "string"
          },
          {
            "description": "Max allowed number of api requests within the specified interval",
            "name": "apilimitmax",
            "type": "integer"
          },
          {
            "description": "true if snapshot is supported for KVM host, false otherwise",
            "name": "kvmsnapshotenabled",
            "type": "boolean"
          },
          {
            "description": "true if region supports elastic load balancer on basic zones",
            "name": "supportELB",
            "type": "string"
          }
        ]
      },
      {
        "description": "Release dedication of zone",
        "isasync": true,
        "name": "releaseDedicatedZone",
        "params": [
          {
            "description": "the ID of the Zone",
            "length": 255,
            "name": "zoneid",
            "related": "createZone,updateZone,listZones,listZones",
            "required": true,
            "type": "uuid"
          }
        ],
        "response": [
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          }
        ]
      },
      {
        "description": "Updates traffic type of a physical network",
        "isasync": true,
        "name": "updateTrafficType",
        "params": [
          {
            "description": "traffic type id",
            "length": 255,
            "name": "id",
            "related": "addTrafficType,updateTrafficType",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "The network name label of the physical device dedicated to this traffic on a Hyperv host",
            "length": 255,
            "name": "hypervnetworklabel",
            "required": false,
            "type": "string"
          },
          {
            "description": "The network name label of the physical device dedicated to this traffic on a XenServer host",
            "length": 255,
            "name": "xennetworklabel",
            "required": false,
            "type": "string"
          },
          {
            "description": "The network name label of the physical device dedicated to this traffic on a KVM host",
            "length": 255,
            "name": "kvmnetworklabel",
            "required": false,
            "type": "string"
          },
          {
            "description": "The network name label of the physical device dedicated to this traffic on a VMware host",
            "length": 255,
            "name": "vmwarenetworklabel",
            "required": false,
            "type": "string"
          },
          {
            "description": "The network name of the physical device dedicated to this traffic on an OVM3 host",
            "length": 255,
            "name": "ovm3networklabel",
            "required": false,
            "type": "string"
          }
        ],
        "related": "addTrafficType",
        "response": [
          {
            "description": "The network name label of the physical device dedicated to this traffic on a VMware host",
            "name": "vmwarenetworklabel",
            "type": "string"
          },
          {
            "description": "The network name of the physical device dedicated to this traffic on an OVM3 host",
            "name": "ovm3networklabel",
            "type": "string"
          },
          {
            "description": "the physical network this belongs to",
            "name": "physicalnetworkid",
            "type": "string"
          },
          {
            "description": "id of the network provider",
            "name": "id",
            "type": "string"
          },
          {
            "description": "The network name label of the physical device dedicated to this traffic on a XenServer host",
            "name": "xennetworklabel",
            "type": "string"
          },
          {
            "description": "The network name label of the physical device dedicated to this traffic on a KVM host",
            "name": "kvmnetworklabel",
            "type": "string"
          },
          {
            "description": "The network name label of the physical device dedicated to this traffic on a HyperV host",
            "name": "hypervnetworklabel",
            "type": "string"
          },
          {
            "description": "the trafficType to be added to the physical network",
            "name": "traffictype",
            "type": "string"
          }
        ],
        "since": "3.0.0"
      },
      {
        "description": "List Conditions for the specific user",
        "isasync": false,
        "name": "listConditions",
        "params": [
          {
            "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
            "length": 255,
            "name": "isrecursive",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false",
            "length": 255,
            "name": "listall",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "ID of the Condition.",
            "length": 255,
            "name": "id",
            "related": "listConditions,createCondition",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "Counter-id of the condition.",
            "length": 255,
            "name": "counterid",
            "related": "listCounters,createCounter",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list only resources belonging to the domain specified",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain,updateDomain",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list resources by account. Must be used with the domainId parameter.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "the ID of the policy",
            "length": 255,
            "name": "policyid",
            "related": "listAutoScalePolicies,updateAutoScalePolicy",
            "required": false,
            "type": "uuid"
          }
        ],
        "related": "createCondition",
        "response": [
          {
            "description": "the project id of the Condition.",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "Details of the Counter.",
            "name": "counter",
            "type": "list"
          },
          {
            "description": "the owner of the Condition.",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the project name of the Condition",
            "name": "project",
            "type": "string"
          },
          {
            "description": "Threshold Value for the counter.",
            "name": "threshold",
            "type": "long"
          },
          {
            "description": "the domain name of the owner.",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the domain id of the Condition owner",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the id of the Condition",
            "name": "id",
            "type": "string"
          },
          {
            "description": "zone id of counter",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "Relational Operator to be used with threshold.",
            "name": "relationaloperator",
            "type": "string"
          }
        ]
      },
      {
        "description": "Updates a network serviceProvider of a physical network",
        "isasync": true,
        "name": "updateNetworkServiceProvider",
        "params": [
          {
            "description": "network service provider id",
            "length": 255,
            "name": "id",
            "related": "addNetworkServiceProvider,listTrafficTypes,listNetworkServiceProviders,updateNetworkServiceProvider",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "Enabled/Disabled/Shutdown the physical network service provider",
            "length": 255,
            "name": "state",
            "required": false,
            "type": "string"
          },
          {
            "description": "the list of services to be enabled for this physical network service provider",
            "length": 255,
            "name": "servicelist",
            "required": false,
            "type": "list"
          }
        ],
        "related": "addNetworkServiceProvider,listTrafficTypes,listNetworkServiceProviders",
        "response": [
          {
            "description": "state of the network provider",
            "name": "state",
            "type": "string"
          },
          {
            "description": "uuid of the network provider",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the destination physical network",
            "name": "destinationphysicalnetworkid",
            "type": "string"
          },
          {
            "description": "the physical network this belongs to",
            "name": "physicalnetworkid",
            "type": "string"
          },
          {
            "description": "the provider name",
            "name": "name",
            "type": "string"
          },
          {
            "description": "services for this provider",
            "name": "servicelist",
            "type": "list"
          },
          {
            "description": "true if individual services can be enabled/disabled",
            "name": "canenableindividualservice",
            "type": "boolean"
          }
        ],
        "since": "3.0.0"
      },
      {
        "description": "Removes a virtual machine or a list of virtual machines from a load balancer rule.",
        "isasync": true,
        "name": "removeFromLoadBalancerRule",
        "params": [
          {
            "description": "the list of IDs of the virtual machines that are being removed from the load balancer rule (i.e. virtualMachineIds=1,2,3)",
            "length": 255,
            "name": "virtualmachineids",
            "related": "stopVirtualMachine,listVirtualMachines,detachIso,updateVMAffinityGroup,revertToVMSnapshot,deployVirtualMachine,migrateVirtualMachine,recoverVirtualMachine,updateDefaultNicForVirtualMachine,migrateVirtualMachineWithVolume,addNicToVirtualMachine,startVirtualMachine,listVirtualMachines,updateVirtualMachine,destroyVirtualMachine,removeNicFromVirtualMachine,removeNicFromVirtualMachine,deployVirtualMachine,destroyVirtualMachine,addNicToVirtualMachine,updateVirtualMachine,rebootVirtualMachine,updateVMAffinityGroup,revertToVMSnapshot,attachIso,resetPasswordForVirtualMachine,assignVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,resetSSHKeyForVirtualMachine,resetPasswordForVirtualMachine,detachIso,changeServiceForVirtualMachine,attachIso,updateDefaultNicForVirtualMachine,startVirtualMachine,stopVirtualMachine",
            "required": false,
            "type": "list"
          },
          {
            "description": "The ID of the load balancer rule",
            "length": 255,
            "name": "id",
            "related": "listIpForwardingRules,listPortForwardingRules,updatePortForwardingRule,createPortForwardingRule",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "VM ID and IP map, vmidipmap[0].vmid=1 vmidipmap[0].ip=10.1.1.75",
            "length": 255,
            "name": "vmidipmap",
            "required": false,
            "since": "4.4",
            "type": "map"
          }
        ],
        "response": [
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          }
        ]
      },
      {
        "description": "Lists vm groups",
        "isasync": false,
        "name": "listInstanceGroups",
        "params": [
          {
            "description": "list instance groups by ID",
            "length": 255,
            "name": "id",
            "related": "updateInstanceGroup,createInstanceGroup,listInstanceGroups",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list objects by project",
            "length": 255,
            "name": "projectid",
            "related": "activateProject,createProject,updateProject,suspendProject,listProjectAccounts,listProjects",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
            "length": 255,
            "name": "isrecursive",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "list resources by account. Must be used with the domainId parameter.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "list only resources belonging to the domain specified",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain,updateDomain",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list instance groups by name",
            "length": 255,
            "name": "name",
            "required": false,
            "type": "string"
          },
          {
            "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false",
            "length": 255,
            "name": "listall",
            "required": false,
            "type": "boolean"
          }
        ],
        "related": "updateInstanceGroup,createInstanceGroup",
        "response": [
          {
            "description": "time and date the instance group was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "the account owning the instance group",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the project name of the instance group",
            "name": "project",
            "type": "string"
          },
          {
            "description": "the domain ID of the instance group",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the ID of the instance group",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the project ID of the instance group",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the domain name of the instance group",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the name of the instance group",
            "name": "name",
            "type": "string"
          }
        ]
      },
      {
        "description": "Creates a static route",
        "isasync": true,
        "name": "createStaticRoute",
        "params": [
          {
            "description": "the gateway id we are creating static route for",
            "length": 255,
            "name": "gatewayid",
            "related": "createPrivateGateway",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "static route cidr",
            "length": 255,
            "name": "cidr",
            "required": true,
            "type": "string"
          }
        ],
        "related": "listStaticRoutes",
        "response": [
          {
            "description": "static route CIDR",
            "name": "cidr",
            "type": "string"
          },
          {
            "description": "the state of the static route",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the account associated with the static route",
            "name": "account",
            "type": "string"
          },
          {
            "description": "VPC the static route belongs to",
            "name": "vpcid",
            "type": "string"
          },
          {
            "description": "the ID of static route",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the project name of the static route",
            "name": "project",
            "type": "string"
          },
          {
            "description": "the ID of the domain associated with the static route",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the domain associated with the static route",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the project id of the static route",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the list of resource tags associated with static route",
            "name": "tags",
            "response": [
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              }
            ],
            "type": "list"
          },
          {
            "description": "VPC gateway the route is created for",
            "name": "gatewayid",
            "type": "string"
          }
        ]
      },
      {
        "description": "Adds traffic type to a physical network",
        "isasync": true,
        "name": "addTrafficType",
        "params": [
          {
            "description": "The network name of the physical device dedicated to this traffic on an OVM3 host",
            "length": 255,
            "name": "ovm3networklabel",
            "required": false,
            "type": "string"
          },
          {
            "description": "The network name label of the physical device dedicated to this traffic on a VMware host",
            "length": 255,
            "name": "vmwarenetworklabel",
            "required": false,
            "type": "string"
          },
          {
            "description": "The network name label of the physical device dedicated to this traffic on a Hyperv host",
            "length": 255,
            "name": "hypervnetworklabel",
            "required": false,
            "type": "string"
          },
          {
            "description": "The VLAN id to be used for Management traffic by VMware host",
            "length": 255,
            "name": "vlan",
            "required": false,
            "type": "string"
          },
          {
            "description": "the Physical Network ID",
            "length": 255,
            "name": "physicalnetworkid",
            "related": "createPhysicalNetwork,updatePhysicalNetwork",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "Used if physical network has multiple isolation types and traffic type is public. Choose which isolation method. Valid options currently 'vlan' or 'vxlan', defaults to 'vlan'.",
            "length": 255,
            "name": "isolationmethod",
            "required": false,
            "type": "string"
          },
          {
            "description": "The network name label of the physical device dedicated to this traffic on a XenServer host",
            "length": 255,
            "name": "xennetworklabel",
            "required": false,
            "type": "string"
          },
          {
            "description": "the trafficType to be added to the physical network",
            "length": 255,
            "name": "traffictype",
            "required": true,
            "type": "string"
          },
          {
            "description": "The network name label of the physical device dedicated to this traffic on a KVM host",
            "length": 255,
            "name": "kvmnetworklabel",
            "required": false,
            "type": "string"
          }
        ],
        "related": "",
        "response": [
          {
            "description": "The network name label of the physical device dedicated to this traffic on a VMware host",
            "name": "vmwarenetworklabel",
            "type": "string"
          },
          {
            "description": "id of the network provider",
            "name": "id",
            "type": "string"
          },
          {
            "description": "The network name label of the physical device dedicated to this traffic on a HyperV host",
            "name": "hypervnetworklabel",
            "type": "string"
          },
          {
            "description": "The network name of the physical device dedicated to this traffic on an OVM3 host",
            "name": "ovm3networklabel",
            "type": "string"
          },
          {
            "description": "The network name label of the physical device dedicated to this traffic on a XenServer host",
            "name": "xennetworklabel",
            "type": "string"
          },
          {
            "description": "the trafficType to be added to the physical network",
            "name": "traffictype",
            "type": "string"
          },
          {
            "description": "the physical network this belongs to",
            "name": "physicalnetworkid",
            "type": "string"
          },
          {
            "description": "The network name label of the physical device dedicated to this traffic on a KVM host",
            "name": "kvmnetworklabel",
            "type": "string"
          }
        ],
        "since": "3.0.0"
      },
      {
        "description": "Deletes a Private gateway",
        "isasync": true,
        "name": "deletePrivateGateway",
        "params": [
          {
            "description": "the ID of the private gateway",
            "length": 255,
            "name": "id",
            "related": "createPrivateGateway",
            "required": true,
            "type": "uuid"
          }
        ],
        "response": [
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          },
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          }
        ]
      },
      {
        "description": "List all virtual machine instances that are assigned to a load balancer rule.",
        "isasync": false,
        "name": "listLoadBalancerRuleInstances",
        "params": [
          {
            "description": "the ID of the load balancer rule",
            "length": 255,
            "name": "id",
            "related": "listIpForwardingRules,listPortForwardingRules,updatePortForwardingRule,createPortForwardingRule",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "true if load balancer rule VM IP information to be included; default is false",
            "length": 255,
            "name": "lbvmips",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "true if listing all virtual machines currently applied to the load balancer rule; default is true",
            "length": 255,
            "name": "applied",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          }
        ],
        "related": "listLoadBalancerRuleInstances",
        "response": [
          {
            "description": "the user vm set for lb rule",
            "name": "loadbalancerruleinstance",
            "type": "uservmresponse"
          },
          {
            "description": "IP addresses of the vm set of lb rule",
            "name": "lbvmipaddresses",
            "type": "list"
          }
        ]
      },
      {
        "description": "Removes a condition",
        "isasync": true,
        "name": "deleteCondition",
        "params": [
          {
            "description": "the ID of the condition.",
            "length": 255,
            "name": "id",
            "related": "createCondition",
            "required": true,
            "type": "uuid"
          }
        ],
        "response": [
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          }
        ]
      },
      {
        "description": "Updates a domain with a new name",
        "isasync": false,
        "name": "updateDomain",
        "params": [
          {
            "description": "updates domain with this name",
            "length": 255,
            "name": "name",
            "required": false,
            "type": "string"
          },
          {
            "description": "ID of domain to update",
            "length": 255,
            "name": "id",
            "related": "listDomains,listDomainChildren,listDomains,createDomain,updateDomain",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "Network domain for the domain's networks; empty string will update domainName with NULL value",
            "length": 255,
            "name": "networkdomain",
            "required": false,
            "type": "string"
          }
        ],
        "related": "listDomains,listDomainChildren,listDomains,createDomain",
        "response": [
          {
            "description": "the level of the domain",
            "name": "level",
            "type": "integer"
          },
          {
            "description": "the total number of virtual machines that can be deployed by this domain",
            "name": "vmlimit",
            "type": "string"
          },
          {
            "description": "the total number of cpu cores owned by domain",
            "name": "cputotal",
            "type": "long"
          },
          {
            "description": "the total primary storage space (in GiB) owned by domain",
            "name": "primarystoragetotal",
            "type": "long"
          },
          {
            "description": "the domain ID of the parent domain",
            "name": "parentdomainid",
            "type": "string"
          },
          {
            "description": "the domain name of the parent domain",
            "name": "parentdomainname",
            "type": "string"
          },
          {
            "description": "the total number of snapshots stored by this domain",
            "name": "snapshottotal",
            "type": "long"
          },
          {
            "description": "the total number of public ip addresses available for this domain to acquire",
            "name": "ipavailable",
            "type": "string"
          },
          {
            "description": "the total volume available for this domain",
            "name": "volumeavailable",
            "type": "string"
          },
          {
            "description": "the total number of templates which can be created by this domain",
            "name": "templatelimit",
            "type": "string"
          },
          {
            "description": "the total number of networks available to be created for this domain",
            "name": "networkavailable",
            "type": "string"
          },
          {
            "description": "the total number of public ip addresses allocated for this domain",
            "name": "iptotal",
            "type": "long"
          },
          {
            "description": "the total number of networks the domain can own",
            "name": "networklimit",
            "type": "string"
          },
          {
            "description": "the total number of networks owned by domain",
            "name": "networktotal",
            "type": "long"
          },
          {
            "description": "the total number of virtual machines deployed by this domain",
            "name": "vmtotal",
            "type": "long"
          },
          {
            "description": "the total number of snapshots which can be stored by this domain",
            "name": "snapshotlimit",
            "type": "string"
          },
          {
            "description": "the total number of projects being administrated by this domain",
            "name": "projecttotal",
            "type": "long"
          },
          {
            "description": "the total number of virtual machines available for this domain to acquire",
            "name": "vmavailable",
            "type": "string"
          },
          {
            "description": "the total number of vpcs owned by domain",
            "name": "vpctotal",
            "type": "long"
          },
          {
            "description": "the total volume being used by this domain",
            "name": "volumetotal",
            "type": "long"
          },
          {
            "description": "the total memory (in MB) owned by domain",
            "name": "memorytotal",
            "type": "long"
          },
          {
            "description": "the total memory (in MB) the domain can own",
            "name": "memorylimit",
            "type": "string"
          },
          {
            "description": "the path of the domain",
            "name": "path",
            "type": "string"
          },
          {
            "description": "the total number of snapshots available for this domain",
            "name": "snapshotavailable",
            "type": "string"
          },
          {
            "description": "the total number of vpcs the domain can own",
            "name": "vpclimit",
            "type": "string"
          },
          {
            "description": "the state of the domain",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the total primary storage space (in GiB) the domain can own",
            "name": "primarystoragelimit",
            "type": "string"
          },
          {
            "description": "the total primary storage space (in GiB) available to be used for this domain",
            "name": "primarystorageavailable",
            "type": "string"
          },
          {
            "description": "the network domain",
            "name": "networkdomain",
            "type": "string"
          },
          {
            "description": "the total secondary storage space (in GiB) available to be used for this domain",
            "name": "secondarystorageavailable",
            "type": "string"
          },
          {
            "description": "the ID of the domain",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the total volume which can be used by this domain",
            "name": "volumelimit",
            "type": "string"
          },
          {
            "description": "the total number of cpu cores available to be created for this domain",
            "name": "cpuavailable",
            "type": "string"
          },
          {
            "description": "the total number of templates available to be created by this domain",
            "name": "templateavailable",
            "type": "string"
          },
          {
            "description": "the total secondary storage space (in GiB) the domain can own",
            "name": "secondarystoragelimit",
            "type": "string"
          },
          {
            "description": "the total number of projects available for administration by this domain",
            "name": "projectavailable",
            "type": "string"
          },
          {
            "description": "whether the domain has one or more sub-domains",
            "name": "haschild",
            "type": "boolean"
          },
          {
            "description": "the total number of cpu cores the domain can own",
            "name": "cpulimit",
            "type": "string"
          },
          {
            "description": "the total number of vpcs available to be created for this domain",
            "name": "vpcavailable",
            "type": "string"
          },
          {
            "description": "the total number of templates which have been created by this domain",
            "name": "templatetotal",
            "type": "long"
          },
          {
            "description": "the total number of public ip addresses this domain can acquire",
            "name": "iplimit",
            "type": "string"
          },
          {
            "description": "the total number of projects the domain can own",
            "name": "projectlimit",
            "type": "string"
          },
          {
            "description": "the total secondary storage space (in GiB) owned by domain",
            "name": "secondarystoragetotal",
            "type": "long"
          },
          {
            "description": "the name of the domain",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the total memory (in MB) available to be created for this domain",
            "name": "memoryavailable",
            "type": "string"
          }
        ]
      },
      {
        "description": "Updates a physical network",
        "isasync": true,
        "name": "updatePhysicalNetwork",
        "params": [
          {
            "description": "the speed for the physical network[1G/10G]",
            "length": 255,
            "name": "networkspeed",
            "required": false,
            "type": "string"
          },
          {
            "description": "the VLAN for the physical network",
            "length": 255,
            "name": "vlan",
            "required": false,
            "type": "string"
          },
          {
            "description": "Enabled/Disabled",
            "length": 255,
            "name": "state",
            "required": false,
            "type": "string"
          },
          {
            "description": "physical network id",
            "length": 255,
            "name": "id",
            "related": "createPhysicalNetwork,updatePhysicalNetwork",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "Tag the physical network",
            "length": 255,
            "name": "tags",
            "required": false,
            "type": "list"
          }
        ],
        "related": "createPhysicalNetwork",
        "response": [
          {
            "description": "Broadcast domain range of the physical network",
            "name": "broadcastdomainrange",
            "type": "string"
          },
          {
            "description": "the vlan of the physical network",
            "name": "vlan",
            "type": "string"
          },
          {
            "description": "isolation methods",
            "name": "isolationmethods",
            "type": "string"
          },
          {
            "description": "the domain id of the physical network owner",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "comma separated tag",
            "name": "tags",
            "type": "string"
          },
          {
            "description": "the speed of the physical network",
            "name": "networkspeed",
            "type": "string"
          },
          {
            "description": "the uuid of the physical network",
            "name": "id",
            "type": "string"
          },
          {
            "description": "state of the physical network",
            "name": "state",
            "type": "string"
          },
          {
            "description": "name of the physical network",
            "name": "name",
            "type": "string"
          },
          {
            "description": "zone id of the physical network",
            "name": "zoneid",
            "type": "string"
          }
        ],
        "since": "3.0.0"
      },
      {
        "description": "Disables an AutoScale Vm Group",
        "isasync": true,
        "name": "disableAutoScaleVmGroup",
        "params": [
          {
            "description": "the ID of the autoscale group",
            "length": 255,
            "name": "id",
            "related": "enableAutoScaleVmGroup,disableAutoScaleVmGroup,updateAutoScaleVmGroup,listAutoScaleVmGroups",
            "required": true,
            "type": "uuid"
          }
        ],
        "related": "enableAutoScaleVmGroup,updateAutoScaleVmGroup,listAutoScaleVmGroups",
        "response": [
          {
            "description": "is group for display to the regular user",
            "name": "fordisplay",
            "type": "boolean"
          },
          {
            "description": "the account owning the instance group",
            "name": "account",
            "type": "string"
          },
          {
            "description": "list of scaledown autoscale policies",
            "name": "scaledownpolicies",
            "type": "list"
          },
          {
            "description": "the domain ID of the vm profile",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the minimum number of members in the vmgroup, the number of instances in the vm group will be equal to or more than this number.",
            "name": "minmembers",
            "type": "int"
          },
          {
            "description": "the maximum number of members in the vmgroup, The number of instances in the vm group will be equal to or less than this number.",
            "name": "maxmembers",
            "type": "int"
          },
          {
            "description": "the current state of the AutoScale Vm Group",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the autoscale profile that contains information about the vms in the vm group.",
            "name": "vmprofileid",
            "type": "string"
          },
          {
            "description": "the frequency at which the conditions have to be evaluated",
            "name": "interval",
            "type": "int"
          },
          {
            "description": "the load balancer rule ID",
            "name": "lbruleid",
            "type": "string"
          },
          {
            "description": "list of scaleup autoscale policies",
            "name": "scaleuppolicies",
            "type": "list"
          },
          {
            "description": "the project id vm profile",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the project name of the vm profile",
            "name": "project",
            "type": "string"
          },
          {
            "description": "the autoscale vm group ID",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the domain name of the vm profile",
            "name": "domain",
            "type": "string"
          }
        ]
      },
      {
        "description": "Creates a snapshot policy for the account.",
        "isasync": false,
        "name": "createSnapshotPolicy",
        "params": [
          {
            "description": "valid values are HOURLY, DAILY, WEEKLY, and MONTHLY",
            "length": 255,
            "name": "intervaltype",
            "required": true,
            "type": "string"
          },
          {
            "description": "Specifies a timezone for this command. For more information on the timezone parameter, see Time Zone Format.",
            "length": 255,
            "name": "timezone",
            "required": true,
            "type": "string"
          },
          {
            "description": "time the snapshot is scheduled to be taken. Format is:* if HOURLY, MM* if DAILY, MM:HH* if WEEKLY, MM:HH:DD (1-7)* if MONTHLY, MM:HH:DD (1-28)",
            "length": 255,
            "name": "schedule",
            "required": true,
            "type": "string"
          },
          {
            "description": "maximum number of snapshots to retain",
            "length": 255,
            "name": "maxsnaps",
            "required": true,
            "type": "integer"
          },
          {
            "description": "an optional field, whether to the display the policy to the end user or not",
            "length": 255,
            "name": "fordisplay",
            "required": false,
            "since": "4.4",
            "type": "boolean"
          },
          {
            "description": "the ID of the disk volume",
            "length": 255,
            "name": "volumeid",
            "related": "createVolume,updateVolume,uploadVolume,updateVolume,attachVolume,migrateVolume,createVolume,detachVolume,attachVolume,migrateVolume,resizeVolume,detachVolume,resizeVolume,listVolumes,listVolumes",
            "required": true,
            "type": "uuid"
          }
        ],
        "related": "updateSnapshotPolicy",
        "response": [
          {
            "description": "the ID of the disk volume",
            "name": "volumeid",
            "type": "string"
          },
          {
            "description": "is this policy for display to the regular user",
            "name": "fordisplay",
            "type": "boolean"
          },
          {
            "description": "the interval type of the snapshot policy",
            "name": "intervaltype",
            "type": "short"
          },
          {
            "description": "time the snapshot is scheduled to be taken.",
            "name": "schedule",
            "type": "string"
          },
          {
            "description": "the time zone of the snapshot policy",
            "name": "timezone",
            "type": "string"
          },
          {
            "description": "the ID of the snapshot policy",
            "name": "id",
            "type": "string"
          },
          {
            "description": "maximum number of snapshots retained",
            "name": "maxsnaps",
            "type": "int"
          }
        ]
      },
      {
        "description": "List system virtual machines.",
        "isasync": false,
        "name": "listSystemVms",
        "params": [
          {
            "description": "the name of the system VM",
            "length": 255,
            "name": "name",
            "required": false,
            "type": "string"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "the host ID of the system VM",
            "length": 255,
            "name": "hostid",
            "related": "addHost,reconnectHost,addBaremetalHost,cancelHostMaintenance,prepareHostForMaintenance",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "the storage ID where vm's volumes belong to",
            "length": 255,
            "name": "storageid",
            "related": "cancelStorageMaintenance,enableStorageMaintenance,createStoragePool,listStoragePools,findStoragePoolsForMigration",
            "required": false,
            "since": "3.0.1",
            "type": "uuid"
          },
          {
            "description": "the system VM type. Possible types are \"consoleproxy\" and \"secondarystoragevm\".",
            "length": 255,
            "name": "systemvmtype",
            "required": false,
            "type": "string"
          },
          {
            "description": "the state of the system VM",
            "length": 255,
            "name": "state",
            "required": false,
            "type": "string"
          },
          {
            "description": "the Pod ID of the system VM",
            "length": 255,
            "name": "podid",
            "related": "updatePod",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "the Zone ID of the system VM",
            "length": 255,
            "name": "zoneid",
            "related": "createZone,updateZone,listZones,listZones",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "the ID of the system VM",
            "length": 255,
            "name": "id",
            "related": "migrateSystemVm,changeServiceForSystemVm,listSystemVms,startSystemVm",
            "required": false,
            "type": "uuid"
          }
        ],
        "related": "migrateSystemVm,changeServiceForSystemVm,startSystemVm",
        "response": [
          {
            "description": "the date and time the system VM was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "the first DNS for the system VM",
            "name": "dns1",
            "type": "string"
          },
          {
            "description": "the Pod ID for the system VM",
            "name": "podid",
            "type": "string"
          },
          {
            "description": "the hostname for the system VM",
            "name": "hostname",
            "type": "string"
          },
          {
            "description": "the link local MAC address for the system vm",
            "name": "linklocalmacaddress",
            "type": "string"
          },
          {
            "description": "the hypervisor on which the template runs",
            "name": "hypervisor",
            "type": "string"
          },
          {
            "description": "the state of the system VM",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the link local IP address for the system vm",
            "name": "linklocalip",
            "type": "string"
          },
          {
            "description": "the link local netmask for the system vm",
            "name": "linklocalnetmask",
            "type": "string"
          },
          {
            "description": "the Zone name for the system VM",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the number of active console sessions for the console proxy system vm",
            "name": "activeviewersessions",
            "type": "integer"
          },
          {
            "description": "the ID of the system VM",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the second DNS for the system VM",
            "name": "dns2",
            "type": "string"
          },
          {
            "description": "the Zone ID for the system VM",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the public MAC address for the system VM",
            "name": "publicmacaddress",
            "type": "string"
          },
          {
            "description": "the network domain for the system VM",
            "name": "networkdomain",
            "type": "string"
          },
          {
            "description": "the private IP address for the system VM",
            "name": "privateip",
            "type": "string"
          },
          {
            "description": "the private netmask for the system VM",
            "name": "privatenetmask",
            "type": "string"
          },
          {
            "description": "the template ID for the system VM",
            "name": "templateid",
            "type": "string"
          },
          {
            "description": "the name of the system VM",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the system VM type",
            "name": "systemvmtype",
            "type": "string"
          },
          {
            "description": "the job ID associated with the system VM. This is only displayed if the router listed is part of a currently running asynchronous job.",
            "name": "jobid",
            "type": "string"
          },
          {
            "description": "the gateway for the system VM",
            "name": "gateway",
            "type": "string"
          },
          {
            "description": "the host ID for the system VM",
            "name": "hostid",
            "type": "string"
          },
          {
            "description": "the job status associated with the system VM.  This is only displayed if the router listed is part of a currently running asynchronous job.",
            "name": "jobstatus",
            "type": "integer"
          },
          {
            "description": "the private MAC address for the system VM",
            "name": "privatemacaddress",
            "type": "string"
          },
          {
            "description": "the public netmask for the system VM",
            "name": "publicnetmask",
            "type": "string"
          },
          {
            "description": "the public IP address for the system VM",
            "name": "publicip",
            "type": "string"
          }
        ]
      },
      {
        "description": "Creates a project",
        "isasync": true,
        "name": "createProject",
        "params": [
          {
            "description": "name of the project",
            "length": 255,
            "name": "name",
            "required": true,
            "type": "string"
          },
          {
            "description": "domain ID of the account owning a project",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "account who will be Admin for the project",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "display text of the project",
            "length": 255,
            "name": "displaytext",
            "required": true,
            "type": "string"
          }
        ],
        "related": "activateProject,updateProject,suspendProject,listProjectAccounts,listProjects",
        "response": [
          {
            "description": "the total number of virtual machines that can be deployed by this project",
            "name": "vmlimit",
            "type": "string"
          },
          {
            "description": "the total number of public ip addresses available for this project to acquire",
            "name": "ipavailable",
            "type": "string"
          },
          {
            "description": "the total number of networks the project can own",
            "name": "networklimit",
            "type": "string"
          },
          {
            "description": "the total number of virtual machines available for this project to acquire",
            "name": "vmavailable",
            "type": "string"
          },
          {
            "description": "the total volume being used by this project",
            "name": "volumetotal",
            "type": "long"
          },
          {
            "description": "the total number of public ip addresses allocated for this project",
            "name": "iptotal",
            "type": "long"
          },
          {
            "description": "the id of the project",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the total number of snapshots available for this project",
            "name": "snapshotavailable",
            "type": "string"
          },
          {
            "description": "the total number of networks available to be created for this project",
            "name": "networkavailable",
            "type": "string"
          },
          {
            "description": "the total number of templates which have been created by this project",
            "name": "templatetotal",
            "type": "long"
          },
          {
            "description": "the domain name where the project belongs to",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the total number of vpcs available to be created for this project",
            "name": "vpcavailable",
            "type": "string"
          },
          {
            "description": "the total primary storage space (in GiB) available to be used for this project",
            "name": "primarystorageavailable",
            "type": "string"
          },
          {
            "description": "the total number of networks owned by project",
            "name": "networktotal",
            "type": "long"
          },
          {
            "description": "the total memory (in MB) available to be created for this project",
            "name": "memoryavailable",
            "type": "string"
          },
          {
            "description": "the total number of vpcs the project can own",
            "name": "vpclimit",
            "type": "string"
          },
          {
            "description": "the name of the project",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the total number of cpu cores available to be created for this project",
            "name": "cpuavailable",
            "type": "string"
          },
          {
            "description": "the state of the project",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the total number of virtual machines deployed by this project",
            "name": "vmtotal",
            "type": "long"
          },
          {
            "description": "the total number of snapshots which can be stored by this project",
            "name": "snapshotlimit",
            "type": "string"
          },
          {
            "description": "the total number of cpu cores owned by project",
            "name": "cputotal",
            "type": "long"
          },
          {
            "description": "the total secondary storage space (in GiB) owned by project",
            "name": "secondarystoragetotal",
            "type": "long"
          },
          {
            "description": "the total number of templates available to be created by this project",
            "name": "templateavailable",
            "type": "string"
          },
          {
            "description": "the domain id the project belongs to",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the total memory (in MB) owned by project",
            "name": "memorytotal",
            "type": "long"
          },
          {
            "description": "the total number of cpu cores the project can own",
            "name": "cpulimit",
            "type": "string"
          },
          {
            "description": "the total memory (in MB) the project can own",
            "name": "memorylimit",
            "type": "string"
          },
          {
            "description": "the displaytext of the project",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "the total number of virtual machines stopped for this project",
            "name": "vmstopped",
            "type": "integer"
          },
          {
            "description": "the total secondary storage space (in GiB) the project can own",
            "name": "secondarystoragelimit",
            "type": "string"
          },
          {
            "description": "the total number of snapshots stored by this project",
            "name": "snapshottotal",
            "type": "long"
          },
          {
            "description": "the list of resource tags associated with vm",
            "name": "tags",
            "response": [
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              },
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              }
            ],
            "type": "list"
          },
          {
            "description": "the total primary storage space (in GiB) the project can own",
            "name": "primarystoragelimit",
            "type": "string"
          },
          {
            "description": "the total volume available for this project",
            "name": "volumeavailable",
            "type": "string"
          },
          {
            "description": "the total secondary storage space (in GiB) available to be used for this project",
            "name": "secondarystorageavailable",
            "type": "string"
          },
          {
            "description": "the total number of virtual machines running for this project",
            "name": "vmrunning",
            "type": "integer"
          },
          {
            "description": "the total number of templates which can be created by this project",
            "name": "templatelimit",
            "type": "string"
          },
          {
            "description": "the total number of vpcs owned by project",
            "name": "vpctotal",
            "type": "long"
          },
          {
            "description": "the account name of the project's owner",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the total primary storage space (in GiB) owned by project",
            "name": "primarystoragetotal",
            "type": "long"
          },
          {
            "description": "the total volume which can be used by this project",
            "name": "volumelimit",
            "type": "string"
          },
          {
            "description": "the total number of public ip addresses this project can acquire",
            "name": "iplimit",
            "type": "string"
          }
        ],
        "since": "3.0.0"
      },
      {
        "description": "Assigns a certificate to a load balancer rule",
        "isasync": true,
        "name": "assignCertToLoadBalancer",
        "params": [
          {
            "description": "the ID of the load balancer rule",
            "length": 255,
            "name": "lbruleid",
            "related": "listIpForwardingRules,listPortForwardingRules,updatePortForwardingRule,createPortForwardingRule",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "the ID of the certificate",
            "length": 255,
            "name": "certid",
            "related": "uploadSslCert",
            "required": true,
            "type": "uuid"
          }
        ],
        "response": [
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          }
        ]
      },
      {
        "description": "Detaches a disk volume from a virtual machine.",
        "isasync": true,
        "name": "detachVolume",
        "params": [
          {
            "description": "the ID of the virtual machine where the volume is detached from",
            "length": 255,
            "name": "virtualmachineid",
            "related": "stopVirtualMachine,listVirtualMachines,detachIso,updateVMAffinityGroup,revertToVMSnapshot,deployVirtualMachine,migrateVirtualMachine,recoverVirtualMachine,updateDefaultNicForVirtualMachine,migrateVirtualMachineWithVolume,addNicToVirtualMachine,startVirtualMachine,listVirtualMachines,updateVirtualMachine,destroyVirtualMachine,removeNicFromVirtualMachine,removeNicFromVirtualMachine,deployVirtualMachine,destroyVirtualMachine,addNicToVirtualMachine,updateVirtualMachine,rebootVirtualMachine,updateVMAffinityGroup,revertToVMSnapshot,attachIso,resetPasswordForVirtualMachine,assignVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,resetSSHKeyForVirtualMachine,resetPasswordForVirtualMachine,detachIso,changeServiceForVirtualMachine,attachIso,updateDefaultNicForVirtualMachine,startVirtualMachine,stopVirtualMachine",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "the ID of the disk volume",
            "length": 255,
            "name": "id",
            "related": "createVolume,updateVolume,uploadVolume,updateVolume,attachVolume,migrateVolume,createVolume,detachVolume,attachVolume,migrateVolume,resizeVolume,detachVolume,resizeVolume,listVolumes,listVolumes",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "the device ID on the virtual machine where volume is detached from",
            "length": 255,
            "name": "deviceid",
            "required": false,
            "type": "long"
          }
        ],
        "related": "createVolume,updateVolume,uploadVolume,updateVolume,attachVolume,migrateVolume,createVolume,attachVolume,migrateVolume,resizeVolume,detachVolume,resizeVolume,listVolumes,listVolumes",
        "response": [
          {
            "description": "min iops of the disk volume",
            "name": "miniops",
            "type": "long"
          },
          {
            "description": "shared or local storage",
            "name": "storagetype",
            "type": "string"
          },
          {
            "description": "name of the disk volume",
            "name": "name",
            "type": "string"
          },
          {
            "description": "io requests write rate of the disk volume",
            "name": "diskIopsWriteRate",
            "type": "long"
          },
          {
            "description": "ID of the service offering for root disk",
            "name": "serviceofferingid",
            "type": "string"
          },
          {
            "description": "the project id of the vpn",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the display text of the disk offering",
            "name": "diskofferingdisplaytext",
            "type": "string"
          },
          {
            "description": "the display text of the service offering for root disk",
            "name": "serviceofferingdisplaytext",
            "type": "string"
          },
          {
            "description": "the ID of the device on user vm the volume is attahed to. This tag is not returned when the volume is detached.",
            "name": "deviceid",
            "type": "long"
          },
          {
            "description": "size of the disk volume",
            "name": "size",
            "type": "long"
          },
          {
            "description": "the chain info of the volume",
            "name": "chaininfo",
            "type": "string"
          },
          {
            "description": "the ID of the domain associated with the disk volume",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "ID of the snapshot from which this volume was created",
            "name": "snapshotid",
            "type": "string"
          },
          {
            "description": "an alternate display text of the ISO attached to the virtual machine",
            "name": "isodisplaytext",
            "type": "string"
          },
          {
            "description": "the name of the template for the virtual machine",
            "name": "templatename",
            "type": "string"
          },
          {
            "description": "id of the primary storage hosting the disk volume; returned to admin user only",
            "name": "storageid",
            "type": "string"
          },
          {
            "description": "name of the primary storage hosting the disk volume",
            "name": "storage",
            "type": "string"
          },
          {
            "description": "the ID of the ISO attached to the virtual machine",
            "name": "isoid",
            "type": "string"
          },
          {
            "description": "id of the virtual machine",
            "name": "virtualmachineid",
            "type": "string"
          },
          {
            "description": "the date the disk volume was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "bytes write rate of the disk volume",
            "name": "diskBytesWriteRate",
            "type": "long"
          },
          {
            "description": "name of the disk offering",
            "name": "diskofferingname",
            "type": "string"
          },
          {
            "description": "the domain associated with the disk volume",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "Hypervisor the volume belongs to",
            "name": "hypervisor",
            "type": "string"
          },
          {
            "description": "name of the service offering for root disk",
            "name": "serviceofferingname",
            "type": "string"
          },
          {
            "description": "bytes read rate of the disk volume",
            "name": "diskBytesReadRate",
            "type": "long"
          },
          {
            "description": "ID of the availability zone",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "max iops of the disk volume",
            "name": "maxiops",
            "type": "long"
          },
          {
            "description": "the boolean state of whether the volume is destroyed or not",
            "name": "destroyed",
            "type": "boolean"
          },
          {
            "description": "name of the availability zone",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the status of the volume",
            "name": "status",
            "type": "string"
          },
          {
            "description": "the account associated with the disk volume",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.",
            "name": "templateid",
            "type": "string"
          },
          {
            "description": "the date the volume was attached to a VM instance",
            "name": "attached",
            "type": "date"
          },
          {
            "description": "the path of the volume",
            "name": "path",
            "type": "string"
          },
          {
            "description": "state of the virtual machine",
            "name": "vmstate",
            "type": "string"
          },
          {
            "description": "ID of the disk volume",
            "name": "id",
            "type": "string"
          },
          {
            "description": "display name of the virtual machine",
            "name": "vmdisplayname",
            "type": "string"
          },
          {
            "description": "true if the volume is extractable, false otherwise",
            "name": "isextractable",
            "type": "boolean"
          },
          {
            "description": "name of the virtual machine",
            "name": "vmname",
            "type": "string"
          },
          {
            "description": "the state of the disk volume",
            "name": "state",
            "type": "string"
          },
          {
            "description": "provisioning type used to create volumes.",
            "name": "provisioningtype",
            "type": "string"
          },
          {
            "description": "ID of the disk offering",
            "name": "diskofferingid",
            "type": "string"
          },
          {
            "description": "need quiesce vm or not when taking snapshot",
            "name": "quiescevm",
            "type": "boolean"
          },
          {
            "description": "the name of the ISO attached to the virtual machine",
            "name": "isoname",
            "type": "string"
          },
          {
            "description": "type of the disk volume (ROOT or DATADISK)",
            "name": "type",
            "type": "string"
          },
          {
            "description": "the project name of the vpn",
            "name": "project",
            "type": "string"
          },
          {
            "description": "io requests read rate of the disk volume",
            "name": "diskIopsReadRate",
            "type": "long"
          },
          {
            "description": "an optional field whether to the display the volume to the end user or not.",
            "name": "displayvolume",
            "type": "boolean"
          },
          {
            "description": " an alternate display text of the template for the virtual machine",
            "name": "templatedisplaytext",
            "type": "string"
          },
          {
            "description": "the list of resource tags associated with volume",
            "name": "tags",
            "response": [
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              },
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              }
            ],
            "type": "set"
          }
        ]
      },
      {
        "description": "Replaces ACL associated with a network or private gateway",
        "isasync": true,
        "name": "replaceNetworkACLList",
        "params": [
          {
            "description": "the ID of the private gateway",
            "length": 255,
            "name": "gatewayid",
            "related": "createPrivateGateway",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "the ID of the network",
            "length": 255,
            "name": "networkid",
            "related": "createNetwork,listNetscalerLoadBalancerNetworks,listPaloAltoFirewallNetworks,listNiciraNvpDeviceNetworks,listNetworks,updateNetwork,updateNetwork,createNetwork",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "the ID of the network ACL",
            "length": 255,
            "name": "aclid",
            "related": "listNetworkACLLists,createNetworkACLList",
            "required": true,
            "type": "uuid"
          }
        ],
        "response": [
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          },
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          }
        ]
      },
      {
        "description": "Marks a default zone for this account",
        "isasync": true,
        "name": "markDefaultZoneForAccount",
        "params": [
          {
            "description": "Name of the account that is to be marked.",
            "length": 255,
            "name": "account",
            "related": "enableAccount,listAccounts,disableAccount,listAccounts,markDefaultZoneForAccount,createAccount,updateAccount",
            "required": true,
            "type": "string"
          },
          {
            "description": "The Zone ID with which the account is to be marked.",
            "length": 255,
            "name": "zoneid",
            "related": "createZone,updateZone,listZones,listZones",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "Marks the account that belongs to the specified domain.",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain",
            "required": true,
            "type": "uuid"
          }
        ],
        "related": "enableAccount,listAccounts,disableAccount,listAccounts,createAccount,updateAccount",
        "response": [
          {
            "description": "the total secondary storage space (in GiB) the account can own",
            "name": "secondarystoragelimit",
            "type": "string"
          },
          {
            "description": "the total number of templates available to be created by this account",
            "name": "templateavailable",
            "type": "string"
          },
          {
            "description": "the total number of cpu cores the account can own",
            "name": "cpulimit",
            "type": "string"
          },
          {
            "description": "the total number of vpcs the account can own",
            "name": "vpclimit",
            "type": "string"
          },
          {
            "description": "the total primary storage space (in GiB) available to be used for this account",
            "name": "primarystorageavailable",
            "type": "string"
          },
          {
            "description": "the total number of networks owned by account",
            "name": "networktotal",
            "type": "long"
          },
          {
            "description": "the total number of cpu cores available to be created for this account",
            "name": "cpuavailable",
            "type": "string"
          },
          {
            "description": "account type (admin, domain-admin, user)",
            "name": "accounttype",
            "type": "short"
          },
          {
            "description": "the total number of snapshots stored by this account",
            "name": "snapshottotal",
            "type": "long"
          },
          {
            "description": "the list of users associated with account",
            "name": "user",
            "response": [
              {
                "description": "the user firstname",
                "name": "firstname",
                "type": "string"
              },
              {
                "description": "true if user is default, false otherwise",
                "name": "isdefault",
                "type": "boolean"
              },
              {
                "description": "the account name of the user",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the user email address",
                "name": "email",
                "type": "string"
              },
              {
                "description": "the timezone user was created in",
                "name": "timezone",
                "type": "string"
              },
              {
                "description": "the account type of the user",
                "name": "accounttype",
                "type": "short"
              },
              {
                "description": "the user ID",
                "name": "id",
                "type": "string"
              },
              {
                "description": "the secret key of the user",
                "name": "secretkey",
                "type": "string"
              },
              {
                "description": "the account ID of the user",
                "name": "accountid",
                "type": "string"
              },
              {
                "description": "the user lastname",
                "name": "lastname",
                "type": "string"
              },
              {
                "description": "the user state",
                "name": "state",
                "type": "string"
              },
              {
                "description": "the domain ID of the user",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the user name",
                "name": "username",
                "type": "string"
              },
              {
                "description": "the domain name of the user",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "the date and time the user account was created",
                "name": "created",
                "type": "date"
              },
              {
                "description": "the api key of the user",
                "name": "apikey",
                "type": "string"
              },
              {
                "description": "the boolean value representing if the updating target is in caller's child domain",
                "name": "iscallerchilddomain",
                "type": "boolean"
              }
            ],
            "type": "list"
          },
          {
            "description": "the id of the account",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the total primary storage space (in GiB) owned by account",
            "name": "primarystoragetotal",
            "type": "long"
          },
          {
            "description": "details for the account",
            "name": "accountdetails",
            "type": "map"
          },
          {
            "description": "name of the Domain the account belongs too",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the total memory (in MB) available to be created for this account",
            "name": "memoryavailable",
            "type": "string"
          },
          {
            "description": "the total volume which can be used by this account",
            "name": "volumelimit",
            "type": "string"
          },
          {
            "description": "the total number of virtual machines stopped for this account",
            "name": "vmstopped",
            "type": "integer"
          },
          {
            "description": "the total number of projects available for administration by this account",
            "name": "projectavailable",
            "type": "string"
          },
          {
            "description": "the total number of vpcs available to be created for this account",
            "name": "vpcavailable",
            "type": "string"
          },
          {
            "description": "the total volume available for this account",
            "name": "volumeavailable",
            "type": "string"
          },
          {
            "description": "the total number of cpu cores owned by account",
            "name": "cputotal",
            "type": "long"
          },
          {
            "description": "the name of the account",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the total number of virtual machines available for this account to acquire",
            "name": "vmavailable",
            "type": "string"
          },
          {
            "description": "the total number of templates which have been created by this account",
            "name": "templatetotal",
            "type": "long"
          },
          {
            "description": "the total number of network traffic bytes received",
            "name": "receivedbytes",
            "type": "long"
          },
          {
            "description": "the list of acl groups that account belongs to",
            "name": "groups",
            "type": "list"
          },
          {
            "description": "the total number of virtual machines that can be deployed by this account",
            "name": "vmlimit",
            "type": "string"
          },
          {
            "description": "the total secondary storage space (in GiB) owned by account",
            "name": "secondarystoragetotal",
            "type": "long"
          },
          {
            "description": "the total primary storage space (in GiB) the account can own",
            "name": "primarystoragelimit",
            "type": "string"
          },
          {
            "description": "the total number of network traffic bytes sent",
            "name": "sentbytes",
            "type": "long"
          },
          {
            "description": "the total number of templates which can be created by this account",
            "name": "templatelimit",
            "type": "string"
          },
          {
            "description": "the total number of virtual machines deployed by this account",
            "name": "vmtotal",
            "type": "long"
          },
          {
            "description": "the total number of projects being administrated by this account",
            "name": "projecttotal",
            "type": "long"
          },
          {
            "description": "the total volume being used by this account",
            "name": "volumetotal",
            "type": "long"
          },
          {
            "description": "the total memory (in MB) owned by account",
            "name": "memorytotal",
            "type": "long"
          },
          {
            "description": "the total memory (in MB) the account can own",
            "name": "memorylimit",
            "type": "string"
          },
          {
            "description": "the total number of public ip addresses this account can acquire",
            "name": "iplimit",
            "type": "string"
          },
          {
            "description": "the total number of public ip addresses available for this account to acquire",
            "name": "ipavailable",
            "type": "string"
          },
          {
            "description": "the default zone of the account",
            "name": "defaultzoneid",
            "type": "string"
          },
          {
            "description": "the total number of snapshots available for this account",
            "name": "snapshotavailable",
            "type": "string"
          },
          {
            "description": "true if account is default, false otherwise",
            "name": "isdefault",
            "type": "boolean"
          },
          {
            "description": "the total number of public ip addresses allocated for this account",
            "name": "iptotal",
            "type": "long"
          },
          {
            "description": "the total number of networks the account can own",
            "name": "networklimit",
            "type": "string"
          },
          {
            "description": "the state of the account",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the network domain",
            "name": "networkdomain",
            "type": "string"
          },
          {
            "description": "the total number of virtual machines running for this account",
            "name": "vmrunning",
            "type": "integer"
          },
          {
            "description": "the total secondary storage space (in GiB) available to be used for this account",
            "name": "secondarystorageavailable",
            "type": "string"
          },
          {
            "description": "the total number of networks available to be created for this account",
            "name": "networkavailable",
            "type": "string"
          },
          {
            "description": "the total number of vpcs owned by account",
            "name": "vpctotal",
            "type": "long"
          },
          {
            "description": "the total number of snapshots which can be stored by this account",
            "name": "snapshotlimit",
            "type": "string"
          },
          {
            "description": "id of the Domain the account belongs too",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the total number of projects the account can own",
            "name": "projectlimit",
            "type": "string"
          },
          {
            "description": "true if the account requires cleanup",
            "name": "iscleanuprequired",
            "type": "boolean"
          }
        ],
        "since": "4.0"
      },
      {
        "description": "Lists all LDAP Users",
        "isasync": false,
        "name": "listLdapUsers",
        "params": [
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "Determines whether all ldap users are returned or just non-cloudstack users",
            "length": 255,
            "name": "listtype",
            "required": false,
            "type": "string"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          }
        ],
        "related": "",
        "response": [
          {
            "description": "The user's firstname",
            "name": "firstname",
            "type": "string"
          },
          {
            "description": "The user's domain",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "The user's principle",
            "name": "principal",
            "type": "string"
          },
          {
            "description": "The user's email",
            "name": "email",
            "type": "string"
          },
          {
            "description": "The user's lastname",
            "name": "lastname",
            "type": "string"
          },
          {
            "description": "The user's username",
            "name": "username",
            "type": "string"
          }
        ],
        "since": "4.2.0"
      },
      {
        "description": "Changes the service offering for a system vm (console proxy or secondary storage). The system vm must be in a \"Stopped\" state for this command to take effect.",
        "isasync": false,
        "name": "changeServiceForSystemVm",
        "params": [
          {
            "description": "the service offering ID to apply to the system vm",
            "length": 255,
            "name": "serviceofferingid",
            "related": "updateServiceOffering,listServiceOfferings,createServiceOffering",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "The ID of the system vm",
            "length": 255,
            "name": "id",
            "related": "migrateSystemVm,changeServiceForSystemVm,startSystemVm",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "name value pairs of custom parameters for cpu, memory and cpunumber. example details[i].name=value",
            "length": 255,
            "name": "details",
            "required": false,
            "type": "map"
          }
        ],
        "related": "migrateSystemVm,startSystemVm",
        "response": [
          {
            "description": "the template ID for the system VM",
            "name": "templateid",
            "type": "string"
          },
          {
            "description": "the number of active console sessions for the console proxy system vm",
            "name": "activeviewersessions",
            "type": "integer"
          },
          {
            "description": "the second DNS for the system VM",
            "name": "dns2",
            "type": "string"
          },
          {
            "description": "the link local MAC address for the system vm",
            "name": "linklocalmacaddress",
            "type": "string"
          },
          {
            "description": "the host ID for the system VM",
            "name": "hostid",
            "type": "string"
          },
          {
            "description": "the link local netmask for the system vm",
            "name": "linklocalnetmask",
            "type": "string"
          },
          {
            "description": "the public netmask for the system VM",
            "name": "publicnetmask",
            "type": "string"
          },
          {
            "description": "the Zone name for the system VM",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the link local IP address for the system vm",
            "name": "linklocalip",
            "type": "string"
          },
          {
            "description": "the name of the system VM",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the hypervisor on which the template runs",
            "name": "hypervisor",
            "type": "string"
          },
          {
            "description": "the job ID associated with the system VM. This is only displayed if the router listed is part of a currently running asynchronous job.",
            "name": "jobid",
            "type": "string"
          },
          {
            "description": "the ID of the system VM",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the private MAC address for the system VM",
            "name": "privatemacaddress",
            "type": "string"
          },
          {
            "description": "the private netmask for the system VM",
            "name": "privatenetmask",
            "type": "string"
          },
          {
            "description": "the Pod ID for the system VM",
            "name": "podid",
            "type": "string"
          },
          {
            "description": "the state of the system VM",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the hostname for the system VM",
            "name": "hostname",
            "type": "string"
          },
          {
            "description": "the public MAC address for the system VM",
            "name": "publicmacaddress",
            "type": "string"
          },
          {
            "description": "the public IP address for the system VM",
            "name": "publicip",
            "type": "string"
          },
          {
            "description": "the system VM type",
            "name": "systemvmtype",
            "type": "string"
          },
          {
            "description": "the network domain for the system VM",
            "name": "networkdomain",
            "type": "string"
          },
          {
            "description": "the gateway for the system VM",
            "name": "gateway",
            "type": "string"
          },
          {
            "description": "the Zone ID for the system VM",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the private IP address for the system VM",
            "name": "privateip",
            "type": "string"
          },
          {
            "description": "the first DNS for the system VM",
            "name": "dns1",
            "type": "string"
          },
          {
            "description": "the date and time the system VM was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "the job status associated with the system VM.  This is only displayed if the router listed is part of a currently running asynchronous job.",
            "name": "jobstatus",
            "type": "integer"
          }
        ]
      },
      {
        "description": "List the IP forwarding rules",
        "isasync": false,
        "name": "listIpForwardingRules",
        "params": [
          {
            "description": "list the rule belonging to this public IP address",
            "length": 255,
            "name": "ipaddressid",
            "related": "associateIpAddress,restartNetwork,updateIpAddress,listPublicIpAddresses,listPublicIpAddresses,associateIpAddress",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list objects by project",
            "length": 255,
            "name": "projectid",
            "related": "activateProject,updateProject,suspendProject,listProjectAccounts,listProjects",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "Lists rule with the specified ID.",
            "length": 255,
            "name": "id",
            "related": "listIpForwardingRules,listPortForwardingRules,updatePortForwardingRule,createPortForwardingRule",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
            "length": 255,
            "name": "isrecursive",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false",
            "length": 255,
            "name": "listall",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "list resources by account. Must be used with the domainId parameter.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "Lists all rules applied to the specified VM.",
            "length": 255,
            "name": "virtualmachineid",
            "related": "stopVirtualMachine,listVirtualMachines,detachIso,updateVMAffinityGroup,revertToVMSnapshot,deployVirtualMachine,migrateVirtualMachine,recoverVirtualMachine,updateDefaultNicForVirtualMachine,migrateVirtualMachineWithVolume,addNicToVirtualMachine,startVirtualMachine,listVirtualMachines,updateVirtualMachine,destroyVirtualMachine,removeNicFromVirtualMachine,removeNicFromVirtualMachine,deployVirtualMachine,destroyVirtualMachine,addNicToVirtualMachine,updateVirtualMachine,rebootVirtualMachine,updateVMAffinityGroup,revertToVMSnapshot,attachIso,resetPasswordForVirtualMachine,assignVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,resetSSHKeyForVirtualMachine,resetPasswordForVirtualMachine,detachIso,changeServiceForVirtualMachine,attachIso,updateDefaultNicForVirtualMachine,startVirtualMachine,stopVirtualMachine",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list only resources belonging to the domain specified",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain",
            "required": false,
            "type": "uuid"
          }
        ],
        "related": "listPortForwardingRules,updatePortForwardingRule,createPortForwardingRule",
        "response": [
          {
            "description": "the protocol of the port forwarding rule",
            "name": "protocol",
            "type": "string"
          },
          {
            "description": "the VM display name for the port forwarding rule",
            "name": "virtualmachinedisplayname",
            "type": "string"
          },
          {
            "description": "the public ip address id for the port forwarding rule",
            "name": "ipaddressid",
            "type": "string"
          },
          {
            "description": "is firewall for display to the regular user",
            "name": "fordisplay",
            "type": "boolean"
          },
          {
            "description": "the VM name for the port forwarding rule",
            "name": "virtualmachinename",
            "type": "string"
          },
          {
            "description": "the starting port of port forwarding rule's private port range",
            "name": "privateport",
            "type": "string"
          },
          {
            "description": "the starting port of port forwarding rule's public port range",
            "name": "publicport",
            "type": "string"
          },
          {
            "description": "the ending port of port forwarding rule's private port range",
            "name": "publicendport",
            "type": "string"
          },
          {
            "description": "the state of the rule",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the list of resource tags associated with the rule",
            "name": "tags",
            "response": [
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              }
            ],
            "type": "list"
          },
          {
            "description": "the ending port of port forwarding rule's private port range",
            "name": "privateendport",
            "type": "string"
          },
          {
            "description": "the VM ID for the port forwarding rule",
            "name": "virtualmachineid",
            "type": "string"
          },
          {
            "description": "the public ip address for the port forwarding rule",
            "name": "ipaddress",
            "type": "string"
          },
          {
            "description": "the vm ip address for the port forwarding rule",
            "name": "vmguestip",
            "type": "string"
          },
          {
            "description": "the id of the guest network the port forwarding rule belongs to",
            "name": "networkid",
            "type": "string"
          },
          {
            "description": "the cidr list to forward traffic from",
            "name": "cidrlist",
            "type": "string"
          },
          {
            "description": "the ID of the port forwarding rule",
            "name": "id",
            "type": "string"
          }
        ]
      },
      {
        "description": "Deletes a vmsnapshot.",
        "isasync": true,
        "name": "deleteVMSnapshot",
        "params": [
          {
            "description": "The ID of the VM snapshot",
            "length": 255,
            "name": "vmsnapshotid",
            "related": "listVMSnapshot,createVMSnapshot",
            "required": true,
            "type": "uuid"
          }
        ],
        "response": [
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          }
        ],
        "since": "4.2.0"
      },
      {
        "description": "Creates an instant snapshot of a volume.",
        "isasync": true,
        "name": "createSnapshot",
        "params": [
          {
            "description": "The domain ID of the snapshot. If used with the account parameter, specifies a domain for the account associated with the disk volume.",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "The account of the snapshot. The account parameter must be used with the domainId parameter.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "the name of the snapshot",
            "length": 255,
            "name": "name",
            "required": false,
            "type": "string"
          },
          {
            "description": "policy id of the snapshot, if this is null, then use MANUAL_POLICY.",
            "length": 255,
            "name": "policyid",
            "related": "updateSnapshotPolicy",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "quiesce vm if true",
            "length": 255,
            "name": "quiescevm",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "The ID of the disk volume",
            "length": 255,
            "name": "volumeid",
            "related": "createVolume,updateVolume,uploadVolume,updateVolume,attachVolume,migrateVolume,createVolume,attachVolume,migrateVolume,resizeVolume,detachVolume,resizeVolume,listVolumes,listVolumes",
            "required": true,
            "type": "uuid"
          }
        ],
        "related": "revertSnapshot",
        "response": [
          {
            "description": "physical size of backedup snapshot on image store",
            "name": "physicalsize",
            "type": "long"
          },
          {
            "description": "the type of the snapshot",
            "name": "snapshottype",
            "type": "string"
          },
          {
            "description": "name of the disk volume",
            "name": "volumename",
            "type": "string"
          },
          {
            "description": "  the date the snapshot was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "the account associated with the snapshot",
            "name": "account",
            "type": "string"
          },
          {
            "description": "name of the snapshot",
            "name": "name",
            "type": "string"
          },
          {
            "description": "id of the availability zone",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "ID of the snapshot",
            "name": "id",
            "type": "string"
          },
          {
            "description": "ID of the disk volume",
            "name": "volumeid",
            "type": "string"
          },
          {
            "description": "valid types are hourly, daily, weekly, monthy, template, and none.",
            "name": "intervaltype",
            "type": "string"
          },
          {
            "description": "the domain name of the snapshot's account",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "indicates whether the underlying storage supports reverting the volume to this snapshot",
            "name": "revertable",
            "type": "boolean"
          },
          {
            "description": "the list of resource tags associated with snapshot",
            "name": "tags",
            "response": [
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              }
            ],
            "type": "list"
          },
          {
            "description": "type of the disk volume",
            "name": "volumetype",
            "type": "string"
          },
          {
            "description": "the domain ID of the snapshot's account",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the project id of the snapshot",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the project name of the snapshot",
            "name": "project",
            "type": "string"
          },
          {
            "description": "the state of the snapshot. BackedUp means that snapshot is ready to be used; Creating - the snapshot is being allocated on the primary storage; BackingUp - the snapshot is being backed up on secondary storage",
            "name": "state",
            "type": "state"
          }
        ]
      },
      {
        "description": "Starts a router.",
        "isasync": true,
        "name": "rebootRouter",
        "params": [
          {
            "description": "the ID of the router",
            "length": 255,
            "name": "id",
            "related": "changeServiceForRouter,rebootRouter,destroyRouter,listInternalLoadBalancerVMs,stopInternalLoadBalancerVM,listRouters",
            "required": true,
            "type": "uuid"
          }
        ],
        "related": "changeServiceForRouter,destroyRouter,listInternalLoadBalancerVMs,stopInternalLoadBalancerVM,listRouters",
        "response": [
          {
            "description": "the project name of the address",
            "name": "project",
            "type": "string"
          },
          {
            "description": "the domain associated with the router",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the state of redundant virtual router",
            "name": "redundantstate",
            "type": "string"
          },
          {
            "description": "the public MAC address for the router",
            "name": "publicmacaddress",
            "type": "string"
          },
          {
            "description": "the Zone name for the router",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the second DNS for the router",
            "name": "dns2",
            "type": "string"
          },
          {
            "description": "the public netmask for the router",
            "name": "publicnetmask",
            "type": "string"
          },
          {
            "description": "the first IPv6 DNS for the router",
            "name": "ip6dns1",
            "type": "string"
          },
          {
            "description": "the Pod ID for the router",
            "name": "podid",
            "type": "string"
          },
          {
            "description": "the ID of the corresponding public network",
            "name": "publicnetworkid",
            "type": "string"
          },
          {
            "description": "the ID of the service offering of the virtual machine",
            "name": "serviceofferingid",
            "type": "string"
          },
          {
            "description": "the guest MAC address for the router",
            "name": "guestmacaddress",
            "type": "string"
          },
          {
            "description": "the domain ID associated with the router",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the link local MAC address for the router",
            "name": "linklocalmacaddress",
            "type": "string"
          },
          {
            "description": "the guest IP address for the router",
            "name": "guestipaddress",
            "type": "string"
          },
          {
            "description": "the name of the corresponding guest network",
            "name": "guestnetworkname",
            "type": "string"
          },
          {
            "description": "the network domain for the router",
            "name": "networkdomain",
            "type": "string"
          },
          {
            "description": "the hostname for the router",
            "name": "hostname",
            "type": "string"
          },
          {
            "description": "the guest netmask for the router",
            "name": "guestnetmask",
            "type": "string"
          },
          {
            "description": "the state of the router",
            "name": "state",
            "type": "state"
          },
          {
            "description": "true if the router template requires upgrader",
            "name": "requiresupgrade",
            "type": "boolean"
          },
          {
            "description": "the Zone ID for the router",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the hypervisor on which the template runs",
            "name": "hypervisor",
            "type": "string"
          },
          {
            "description": "the project id of the ipaddress",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "role of the domain router",
            "name": "role",
            "type": "string"
          },
          {
            "description": "the version of scripts",
            "name": "scriptsversion",
            "type": "string"
          },
          {
            "description": "the ID of the corresponding link local network",
            "name": "linklocalnetworkid",
            "type": "string"
          },
          {
            "description": "the name of the service offering of the virtual machine",
            "name": "serviceofferingname",
            "type": "string"
          },
          {
            "description": "the host ID for the router",
            "name": "hostid",
            "type": "string"
          },
          {
            "description": "the name of VPC the router belongs to",
            "name": "vpcname",
            "type": "string"
          },
          {
            "description": "the second IPv6 DNS for the router",
            "name": "ip6dns2",
            "type": "string"
          },
          {
            "description": "the first DNS for the router",
            "name": "dns1",
            "type": "string"
          },
          {
            "description": "the name of the router",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the public IP address for the router",
            "name": "publicip",
            "type": "string"
          },
          {
            "description": "the date and time the router was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "the link local netmask for the router",
            "name": "linklocalnetmask",
            "type": "string"
          },
          {
            "description": "the ID of the corresponding guest network",
            "name": "guestnetworkid",
            "type": "string"
          },
          {
            "description": "the gateway for the router",
            "name": "gateway",
            "type": "string"
          },
          {
            "description": "the link local IP address for the router",
            "name": "linklocalip",
            "type": "string"
          },
          {
            "description": "VPC the router belongs to",
            "name": "vpcid",
            "type": "string"
          },
          {
            "description": "the id of the router",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the account associated with the router",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the template ID for the router",
            "name": "templateid",
            "type": "string"
          },
          {
            "description": "the list of nics associated with the router",
            "name": "nic",
            "response": [
              {
                "description": "the netmask of the nic",
                "name": "netmask",
                "type": "string"
              },
              {
                "description": "the traffic type of the nic",
                "name": "traffictype",
                "type": "string"
              },
              {
                "description": "device id for the network when plugged into the virtual machine",
                "name": "deviceid",
                "type": "string"
              },
              {
                "description": "the ip address of the nic",
                "name": "ipaddress",
                "type": "string"
              },
              {
                "description": "the ID of the nic",
                "name": "id",
                "type": "string"
              },
              {
                "description": "the gateway of the nic",
                "name": "gateway",
                "type": "string"
              },
              {
                "description": "true if nic is default, false otherwise",
                "name": "isdefault",
                "type": "boolean"
              },
              {
                "description": "Id of the vm to which the nic belongs",
                "name": "virtualmachineid",
                "type": "string"
              },
              {
                "description": "the isolation uri of the nic",
                "name": "isolationuri",
                "type": "string"
              },
              {
                "description": "true if nic is default, false otherwise",
                "name": "macaddress",
                "type": "string"
              },
              {
                "description": "the cidr of IPv6 network",
                "name": "ip6cidr",
                "type": "string"
              },
              {
                "description": "the broadcast uri of the nic",
                "name": "broadcasturi",
                "type": "string"
              },
              {
                "description": "the type of the nic",
                "name": "type",
                "type": "string"
              },
              {
                "description": "the IPv6 address of network",
                "name": "ip6address",
                "type": "string"
              },
              {
                "description": "the name of the corresponding network",
                "name": "networkname",
                "type": "string"
              },
              {
                "description": "the ID of the corresponding network",
                "name": "networkid",
                "type": "string"
              },
              {
                "description": "the gateway of IPv6 network",
                "name": "ip6gateway",
                "type": "string"
              },
              {
                "description": "the Secondary ipv4 addr of nic",
                "name": "secondaryip",
                "type": "list"
              }
            ],
            "type": "set"
          },
          {
            "description": "the version of template",
            "name": "version",
            "type": "string"
          },
          {
            "description": "if this router is an redundant virtual router",
            "name": "isredundantrouter",
            "type": "boolean"
          }
        ]
      },
      {
        "description": "list the vm nics  IP to NIC",
        "isasync": false,
        "name": "listNics",
        "params": [
          {
            "description": "list nic of the specific vm's network",
            "length": 255,
            "name": "networkid",
            "related": "createNetwork,listNetscalerLoadBalancerNetworks,listPaloAltoFirewallNetworks,listNiciraNvpDeviceNetworks,listNetworks,updateNetwork,updateNetwork,createNetwork",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "the ID of the vm",
            "length": 255,
            "name": "virtualmachineid",
            "related": "stopVirtualMachine,listVirtualMachines,detachIso,updateVMAffinityGroup,revertToVMSnapshot,deployVirtualMachine,migrateVirtualMachine,recoverVirtualMachine,updateDefaultNicForVirtualMachine,migrateVirtualMachineWithVolume,addNicToVirtualMachine,startVirtualMachine,listVirtualMachines,updateVirtualMachine,destroyVirtualMachine,removeNicFromVirtualMachine,removeNicFromVirtualMachine,deployVirtualMachine,destroyVirtualMachine,addNicToVirtualMachine,updateVirtualMachine,rebootVirtualMachine,updateVMAffinityGroup,revertToVMSnapshot,attachIso,resetPasswordForVirtualMachine,assignVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,resetSSHKeyForVirtualMachine,resetPasswordForVirtualMachine,detachIso,changeServiceForVirtualMachine,attachIso,updateDefaultNicForVirtualMachine,startVirtualMachine,stopVirtualMachine",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "the ID of the nic to to list IPs",
            "length": 255,
            "name": "nicid",
            "related": "listNics",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list resources by display flag; only ROOT admin is eligible to pass this parameter",
            "length": 255,
            "name": "fordisplay",
            "required": false,
            "since": "4.4",
            "type": "boolean"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          }
        ],
        "related": "",
        "response": [
          {
            "description": "the netmask of the nic",
            "name": "netmask",
            "type": "string"
          },
          {
            "description": "the ip address of the nic",
            "name": "ipaddress",
            "type": "string"
          },
          {
            "description": "the gateway of IPv6 network",
            "name": "ip6gateway",
            "type": "string"
          },
          {
            "description": "true if nic is default, false otherwise",
            "name": "macaddress",
            "type": "string"
          },
          {
            "description": "the cidr of IPv6 network",
            "name": "ip6cidr",
            "type": "string"
          },
          {
            "description": "the Secondary ipv4 addr of nic",
            "name": "secondaryip",
            "type": "list"
          },
          {
            "description": "the ID of the corresponding network",
            "name": "networkid",
            "type": "string"
          },
          {
            "description": "the ID of the nic",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the isolation uri of the nic",
            "name": "isolationuri",
            "type": "string"
          },
          {
            "description": "Id of the vm to which the nic belongs",
            "name": "virtualmachineid",
            "type": "string"
          },
          {
            "description": "the gateway of the nic",
            "name": "gateway",
            "type": "string"
          },
          {
            "description": "the type of the nic",
            "name": "type",
            "type": "string"
          },
          {
            "description": "the traffic type of the nic",
            "name": "traffictype",
            "type": "string"
          },
          {
            "description": "true if nic is default, false otherwise",
            "name": "isdefault",
            "type": "boolean"
          },
          {
            "description": "the broadcast uri of the nic",
            "name": "broadcasturi",
            "type": "string"
          },
          {
            "description": "the name of the corresponding network",
            "name": "networkname",
            "type": "string"
          },
          {
            "description": "device id for the network when plugged into the virtual machine",
            "name": "deviceid",
            "type": "string"
          },
          {
            "description": "the IPv6 address of network",
            "name": "ip6address",
            "type": "string"
          }
        ]
      },
      {
        "description": "Create a new keypair and returns the private key",
        "isasync": false,
        "name": "createSSHKeyPair",
        "params": [
          {
            "description": "Name of the keypair",
            "length": 255,
            "name": "name",
            "required": true,
            "type": "string"
          },
          {
            "description": "an optional project for the ssh key",
            "length": 255,
            "name": "projectid",
            "related": "activateProject,updateProject,suspendProject,listProjectAccounts,listProjects",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "an optional domainId for the ssh key. If the account parameter is used, domainId must also be used.",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "an optional account for the ssh key. Must be used with domainId.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          }
        ],
        "related": "",
        "response": [
          {
            "description": "Private key",
            "name": "privatekey",
            "type": "string"
          }
        ]
      },
      {
        "description": "Authorizes a particular egress rule for this security group",
        "isasync": true,
        "name": "authorizeSecurityGroupEgress",
        "params": [
          {
            "description": "the cidr list associated",
            "length": 255,
            "name": "cidrlist",
            "required": false,
            "type": "list"
          },
          {
            "description": "an optional domainId for the security group. If the account parameter is used, domainId must also be used.",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "The name of the security group. Mutually exclusive with securityGroupId parameter",
            "length": 255,
            "name": "securitygroupname",
            "required": false,
            "type": "string"
          },
          {
            "description": "error code for this icmp message",
            "length": 255,
            "name": "icmpcode",
            "required": false,
            "type": "integer"
          },
          {
            "description": "an optional project of the security group",
            "length": 255,
            "name": "projectid",
            "related": "activateProject,updateProject,suspendProject,listProjectAccounts,listProjects",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "user to security group mapping",
            "length": 255,
            "name": "usersecuritygrouplist",
            "required": false,
            "type": "map"
          },
          {
            "description": "end port for this egress rule",
            "length": 255,
            "name": "endport",
            "required": false,
            "type": "integer"
          },
          {
            "description": "an optional account for the security group. Must be used with domainId.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "The ID of the security group. Mutually exclusive with securityGroupName parameter",
            "length": 255,
            "name": "securitygroupid",
            "related": "createSecurityGroup",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "type of the icmp message being sent",
            "length": 255,
            "name": "icmptype",
            "required": false,
            "type": "integer"
          },
          {
            "description": "start port for this egress rule",
            "length": 255,
            "name": "startport",
            "required": false,
            "type": "integer"
          },
          {
            "description": "TCP is default. UDP is the other supported protocol",
            "length": 255,
            "name": "protocol",
            "required": false,
            "type": "string"
          }
        ],
        "related": "authorizeSecurityGroupIngress",
        "response": [
          {
            "description": "the id of the security group rule",
            "name": "ruleid",
            "type": "string"
          },
          {
            "description": "the code for the ICMP message response",
            "name": "icmpcode",
            "type": "integer"
          },
          {
            "description": "the starting IP of the security group rule",
            "name": "startport",
            "type": "integer"
          },
          {
            "description": "the ending IP of the security group rule ",
            "name": "endport",
            "type": "integer"
          },
          {
            "description": "security group name",
            "name": "securitygroupname",
            "type": "string"
          },
          {
            "description": "the protocol of the security group rule",
            "name": "protocol",
            "type": "string"
          },
          {
            "description": "the list of resource tags associated with the rule",
            "name": "tags",
            "response": [
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "the CIDR notation for the base IP address of the security group rule",
            "name": "cidr",
            "type": "string"
          },
          {
            "description": "account owning the security group rule",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the type of the ICMP message response",
            "name": "icmptype",
            "type": "integer"
          }
        ],
        "since": "3.0.0"
      },
      {
        "description": "Lists storage pools.",
        "isasync": false,
        "name": "listStoragePools",
        "params": [
          {
            "description": "the storage pool path",
            "length": 255,
            "name": "path",
            "required": false,
            "type": "string"
          },
          {
            "description": "the ID of the storage pool",
            "length": 255,
            "name": "scope",
            "related": "cancelStorageMaintenance,enableStorageMaintenance,createStoragePool,listStoragePools,findStoragePoolsForMigration",
            "required": false,
            "type": "string"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "the Pod ID for the storage pool",
            "length": 255,
            "name": "podid",
            "related": "updatePod",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "the IP address for the storage pool",
            "length": 255,
            "name": "ipaddress",
            "required": false,
            "type": "string"
          },
          {
            "description": "list storage pools belongig to the specific cluster",
            "length": 255,
            "name": "clusterid",
            "related": "addCluster,updateCluster",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "the Zone ID for the storage pool",
            "length": 255,
            "name": "zoneid",
            "related": "createZone,updateZone,listZones,listZones",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "the ID of the storage pool",
            "length": 255,
            "name": "id",
            "related": "cancelStorageMaintenance,enableStorageMaintenance,createStoragePool,listStoragePools,findStoragePoolsForMigration",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "the name of the storage pool",
            "length": 255,
            "name": "name",
            "required": false,
            "type": "string"
          }
        ],
        "related": "cancelStorageMaintenance,enableStorageMaintenance,createStoragePool,findStoragePoolsForMigration",
        "response": [
          {
            "description": "the name of the cluster for the storage pool",
            "name": "clustername",
            "type": "string"
          },
          {
            "description": "the storage pool capabilities",
            "name": "storagecapabilities",
            "type": "map"
          },
          {
            "description": "the Zone name of the storage pool",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "IOPS CloudStack can provision from this storage pool",
            "name": "capacityiops",
            "type": "long"
          },
          {
            "description": "the name of the storage pool",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the storage pool type",
            "name": "type",
            "type": "string"
          },
          {
            "description": "true if this pool is suitable to migrate a volume, false otherwise",
            "name": "suitableformigration",
            "type": "boolean"
          },
          {
            "description": "the ID of the storage pool",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the Pod name of the storage pool",
            "name": "podname",
            "type": "string"
          },
          {
            "description": "the Zone ID of the storage pool",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the storage pool path",
            "name": "path",
            "type": "string"
          },
          {
            "description": "the overprovisionfactor for the storage pool",
            "name": "overprovisionfactor",
            "type": "string"
          },
          {
            "description": "the date and time the storage pool was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "the host's currently used disk size",
            "name": "disksizeused",
            "type": "long"
          },
          {
            "description": "the total disk size of the storage pool",
            "name": "disksizetotal",
            "type": "long"
          },
          {
            "description": "the tags for the storage pool",
            "name": "tags",
            "type": "string"
          },
          {
            "description": "the scope of the storage pool",
            "name": "scope",
            "type": "string"
          },
          {
            "description": "the IP address of the storage pool",
            "name": "ipaddress",
            "type": "string"
          },
          {
            "description": "the host's currently allocated disk size",
            "name": "disksizeallocated",
            "type": "long"
          },
          {
            "description": "the Pod ID of the storage pool",
            "name": "podid",
            "type": "string"
          },
          {
            "description": "the ID of the cluster for the storage pool",
            "name": "clusterid",
            "type": "string"
          },
          {
            "description": "the state of the storage pool",
            "name": "state",
            "type": "storagepoolstatus"
          },
          {
            "description": "the hypervisor type of the storage pool",
            "name": "hypervisor",
            "type": "string"
          }
        ]
      },
      {
        "description": "Find hosts suitable for migrating a virtual machine.",
        "isasync": false,
        "name": "findHostsForMigration",
        "params": [
          {
            "description": "find hosts to which this VM can be migrated and flag the hosts with enough CPU/RAM to host the VM",
            "length": 255,
            "name": "virtualmachineid",
            "related": "stopVirtualMachine,listVirtualMachines,detachIso,updateVMAffinityGroup,revertToVMSnapshot,deployVirtualMachine,migrateVirtualMachine,recoverVirtualMachine,updateDefaultNicForVirtualMachine,migrateVirtualMachineWithVolume,addNicToVirtualMachine,startVirtualMachine,listVirtualMachines,updateVirtualMachine,destroyVirtualMachine,removeNicFromVirtualMachine,removeNicFromVirtualMachine,deployVirtualMachine,destroyVirtualMachine,addNicToVirtualMachine,updateVirtualMachine,rebootVirtualMachine,updateVMAffinityGroup,revertToVMSnapshot,attachIso,resetPasswordForVirtualMachine,assignVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,resetSSHKeyForVirtualMachine,resetPasswordForVirtualMachine,detachIso,changeServiceForVirtualMachine,attachIso,updateDefaultNicForVirtualMachine,startVirtualMachine,stopVirtualMachine",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          }
        ],
        "related": "",
        "response": [
          {
            "description": "true if the host is disconnected. False otherwise.",
            "name": "disconnected",
            "type": "date"
          },
          {
            "description": "the outgoing network traffic on the host",
            "name": "networkkbswrite",
            "type": "long"
          },
          {
            "description": "the cluster ID of the host",
            "name": "clusterid",
            "type": "string"
          },
          {
            "description": "the management server ID of the host",
            "name": "managementserverid",
            "type": "long"
          },
          {
            "description": "the amount of the host's CPU after applying the cpu.overprovisioning.factor ",
            "name": "cpuwithoverprovisioning",
            "type": "string"
          },
          {
            "description": "the cpu average load on the host",
            "name": "averageload",
            "type": "long"
          },
          {
            "description": "the host hypervisor",
            "name": "hypervisor",
            "type": "hypervisortype"
          },
          {
            "description": "the IP address of the host",
            "name": "ipaddress",
            "type": "string"
          },
          {
            "description": "the host's currently allocated disk size",
            "name": "disksizeallocated",
            "type": "long"
          },
          {
            "description": "the host type",
            "name": "type",
            "type": "type"
          },
          {
            "description": "the amount of the host's CPU currently allocated",
            "name": "cpuallocated",
            "type": "string"
          },
          {
            "description": "capabilities of the host",
            "name": "capabilities",
            "type": "string"
          },
          {
            "description": "the host version",
            "name": "version",
            "type": "string"
          },
          {
            "description": "the cluster type of the cluster that host belongs to",
            "name": "clustertype",
            "type": "string"
          },
          {
            "description": "the date and time the host was removed",
            "name": "removed",
            "type": "date"
          },
          {
            "description": "the total disk size of the host",
            "name": "disksizetotal",
            "type": "long"
          },
          {
            "description": "the ID of the host",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the incoming network traffic on the host",
            "name": "networkkbsread",
            "type": "long"
          },
          {
            "description": "the date and time the host was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "the OS category name of the host",
            "name": "oscategoryname",
            "type": "string"
          },
          {
            "description": "the amount of the host's CPU currently used",
            "name": "cpuused",
            "type": "string"
          },
          {
            "description": "the cluster name of the host",
            "name": "clustername",
            "type": "string"
          },
          {
            "description": "the resource state of the host",
            "name": "resourcestate",
            "type": "string"
          },
          {
            "description": "the state of the host",
            "name": "state",
            "type": "status"
          },
          {
            "description": "true if this host has enough CPU and RAM capacity to migrate a VM to it, false otherwise",
            "name": "hasenoughcapacity",
            "type": "boolean"
          },
          {
            "description": "the Pod ID of the host",
            "name": "podid",
            "type": "string"
          },
          {
            "description": "events available for the host",
            "name": "events",
            "type": "string"
          },
          {
            "description": "the Zone ID of the host",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "true if local storage is active, false otherwise",
            "name": "islocalstorageactive",
            "type": "boolean"
          },
          {
            "description": "true if migrating a vm to this host requires storage motion, false otherwise",
            "name": "requiresStorageMotion",
            "type": "boolean"
          },
          {
            "description": "the amount of the host's memory currently used",
            "name": "memoryused",
            "type": "long"
          },
          {
            "description": "the Zone name of the host",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the amount of the host's memory currently allocated",
            "name": "memoryallocated",
            "type": "long"
          },
          {
            "description": "the OS category ID of the host",
            "name": "oscategoryid",
            "type": "string"
          },
          {
            "description": "the date and time the host was last pinged",
            "name": "lastpinged",
            "type": "date"
          },
          {
            "description": "the CPU number of the host",
            "name": "cpunumber",
            "type": "integer"
          },
          {
            "description": "comma-separated list of tags for the host",
            "name": "hosttags",
            "type": "string"
          },
          {
            "description": "the CPU speed of the host",
            "name": "cpuspeed",
            "type": "long"
          },
          {
            "description": "the memory total of the host",
            "name": "memorytotal",
            "type": "long"
          },
          {
            "description": "true if the host is Ha host (dedicated to vms started by HA process; false otherwise",
            "name": "hahost",
            "type": "boolean"
          },
          {
            "description": "the Pod name of the host",
            "name": "podname",
            "type": "string"
          },
          {
            "description": "the name of the host",
            "name": "name",
            "type": "string"
          },
          {
            "description": "true if this host is suitable(has enough capacity and satisfies all conditions like hosttags, max guests vm limit etc) to migrate a VM to it , false otherwise",
            "name": "suitableformigration",
            "type": "boolean"
          },
          {
            "description": "the hypervisor version",
            "name": "hypervisorversion",
            "type": "string"
          }
        ]
      },
      {
        "description": "Updates a hypervisor capabilities.",
        "isasync": false,
        "name": "updateHypervisorCapabilities",
        "params": [
          {
            "description": "the max number of Guest VMs per host for this hypervisor.",
            "length": 255,
            "name": "maxguestslimit",
            "required": false,
            "type": "long"
          },
          {
            "description": "set true to enable security group for this hypervisor.",
            "length": 255,
            "name": "securitygroupenabled",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "ID of the hypervisor capability",
            "length": 255,
            "name": "id",
            "related": "listHypervisorCapabilities,updateHypervisorCapabilities",
            "required": false,
            "type": "uuid"
          }
        ],
        "related": "listHypervisorCapabilities",
        "response": [
          {
            "description": "the maximum number of Hosts per cluster for this hypervisor",
            "name": "maxhostspercluster",
            "type": "integer"
          },
          {
            "description": "true if security group is supported",
            "name": "securitygroupenabled",
            "type": "boolean"
          },
          {
            "description": "the hypervisor type",
            "name": "hypervisor",
            "type": "hypervisortype"
          },
          {
            "description": "the maximum number of guest vms recommended for this hypervisor",
            "name": "maxguestslimit",
            "type": "long"
          },
          {
            "description": "the maximum number of Data Volumes that can be attached for this hypervisor",
            "name": "maxdatavolumeslimit",
            "type": "integer"
          },
          {
            "description": "the ID of the hypervisor capabilities row",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the hypervisor version",
            "name": "hypervisorversion",
            "type": "string"
          },
          {
            "description": "true if storage motion is supported",
            "name": "storagemotionenabled",
            "type": "boolean"
          }
        ],
        "since": "3.0.0"
      },
      {
        "description": "Dedicates a guest vlan range to an account",
        "isasync": false,
        "name": "dedicateGuestVlanRange",
        "params": [
          {
            "description": "domain ID of the account owning a VLAN",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "account who will own the VLAN",
            "length": 255,
            "name": "account",
            "required": true,
            "type": "string"
          },
          {
            "description": "project who will own the VLAN",
            "length": 255,
            "name": "projectid",
            "related": "activateProject,updateProject,suspendProject,listProjectAccounts,listProjects",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "guest vlan range to be dedicated",
            "length": 255,
            "name": "vlanrange",
            "required": true,
            "type": "string"
          },
          {
            "description": "physical network ID of the vlan",
            "length": 255,
            "name": "physicalnetworkid",
            "related": "createPhysicalNetwork",
            "required": true,
            "type": "uuid"
          }
        ],
        "related": "listDedicatedGuestVlanRanges",
        "response": [
          {
            "description": "the ID of the guest VLAN range",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the account of the guest VLAN range",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the domain name of the guest VLAN range",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the domain ID of the guest VLAN range",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the guest VLAN range",
            "name": "guestvlanrange",
            "type": "string"
          },
          {
            "description": "the project id of the guest vlan range",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the zone of the guest vlan range",
            "name": "zoneid",
            "type": "long"
          },
          {
            "description": "the project name of the guest vlan range",
            "name": "project",
            "type": "string"
          },
          {
            "description": "the physical network of the guest vlan range",
            "name": "physicalnetworkid",
            "type": "long"
          }
        ]
      },
      {
        "description": "Adds VM to specified network by creating a NIC",
        "isasync": true,
        "name": "addNicToVirtualMachine",
        "params": [
          {
            "description": "IP Address for the new network",
            "length": 255,
            "name": "ipaddress",
            "required": false,
            "type": "string"
          },
          {
            "description": "Virtual Machine ID",
            "length": 255,
            "name": "virtualmachineid",
            "related": "stopVirtualMachine,listVirtualMachines,detachIso,updateVMAffinityGroup,revertToVMSnapshot,deployVirtualMachine,migrateVirtualMachine,recoverVirtualMachine,updateDefaultNicForVirtualMachine,migrateVirtualMachineWithVolume,addNicToVirtualMachine,startVirtualMachine,listVirtualMachines,updateVirtualMachine,destroyVirtualMachine,removeNicFromVirtualMachine,removeNicFromVirtualMachine,deployVirtualMachine,destroyVirtualMachine,addNicToVirtualMachine,updateVirtualMachine,rebootVirtualMachine,updateVMAffinityGroup,revertToVMSnapshot,attachIso,resetPasswordForVirtualMachine,assignVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,resetSSHKeyForVirtualMachine,resetPasswordForVirtualMachine,detachIso,changeServiceForVirtualMachine,attachIso,updateDefaultNicForVirtualMachine,startVirtualMachine,stopVirtualMachine",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "Network ID",
            "length": 255,
            "name": "networkid",
            "related": "createNetwork,listNetscalerLoadBalancerNetworks,listPaloAltoFirewallNetworks,listNiciraNvpDeviceNetworks,listNetworks,updateNetwork,updateNetwork,createNetwork",
            "required": true,
            "type": "uuid"
          }
        ],
        "related": "stopVirtualMachine,listVirtualMachines,detachIso,updateVMAffinityGroup,revertToVMSnapshot,deployVirtualMachine,migrateVirtualMachine,recoverVirtualMachine,updateDefaultNicForVirtualMachine,migrateVirtualMachineWithVolume,startVirtualMachine,listVirtualMachines,updateVirtualMachine,destroyVirtualMachine,removeNicFromVirtualMachine,removeNicFromVirtualMachine,deployVirtualMachine,destroyVirtualMachine,addNicToVirtualMachine,updateVirtualMachine,rebootVirtualMachine,updateVMAffinityGroup,revertToVMSnapshot,attachIso,resetPasswordForVirtualMachine,assignVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,resetSSHKeyForVirtualMachine,resetPasswordForVirtualMachine,detachIso,changeServiceForVirtualMachine,attachIso,updateDefaultNicForVirtualMachine,startVirtualMachine,stopVirtualMachine",
        "response": [
          {
            "description": "the name of the service offering of the virtual machine",
            "name": "serviceofferingname",
            "type": "string"
          },
          {
            "description": "the read (io) of disk on the vm",
            "name": "diskioread",
            "type": "long"
          },
          {
            "description": "device type of the root volume",
            "name": "rootdevicetype",
            "type": "string"
          },
          {
            "description": "the project id of the vm",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the speed of each cpu",
            "name": "cpuspeed",
            "type": "integer"
          },
          {
            "description": "Vm details in key/value pairs.",
            "name": "details",
            "type": "map"
          },
          {
            "description": "true if vm contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory.",
            "name": "isdynamicallyscalable",
            "type": "boolean"
          },
          {
            "description": " an alternate display text of the template for the virtual machine",
            "name": "templatedisplaytext",
            "type": "string"
          },
          {
            "description": "OS type id of the vm",
            "name": "ostypeid",
            "type": "long"
          },
          {
            "description": "the name of the disk offering of the virtual machine",
            "name": "diskofferingname",
            "type": "string"
          },
          {
            "description": "the incoming network traffic on the vm",
            "name": "networkkbsread",
            "type": "long"
          },
          {
            "description": "the vgpu type used by the virtual machine",
            "name": "vgpu",
            "type": "string"
          },
          {
            "description": "the list of resource tags associated with vm",
            "name": "tags",
            "response": [
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "the password (if exists) of the virtual machine",
            "name": "password",
            "type": "string"
          },
          {
            "description": "public IP address id associated with vm via Static nat rule",
            "name": "publicip",
            "type": "string"
          },
          {},
          {
            "description": "the project name of the vm",
            "name": "project",
            "type": "string"
          },
          {
            "description": "the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.",
            "name": "templateid",
            "type": "string"
          },
          {
            "description": "an alternate display text of the ISO attached to the virtual machine",
            "name": "isodisplaytext",
            "type": "string"
          },
          {
            "description": "the list of nics associated with vm",
            "name": "nic",
            "response": [
              {
                "description": "true if nic is default, false otherwise",
                "name": "macaddress",
                "type": "string"
              },
              {
                "description": "the cidr of IPv6 network",
                "name": "ip6cidr",
                "type": "string"
              },
              {
                "description": "the ID of the nic",
                "name": "id",
                "type": "string"
              },
              {
                "description": "true if nic is default, false otherwise",
                "name": "isdefault",
                "type": "boolean"
              },
              {
                "description": "Id of the vm to which the nic belongs",
                "name": "virtualmachineid",
                "type": "string"
              },
              {
                "description": "the type of the nic",
                "name": "type",
                "type": "string"
              },
              {
                "description": "the broadcast uri of the nic",
                "name": "broadcasturi",
                "type": "string"
              },
              {
                "description": "the traffic type of the nic",
                "name": "traffictype",
                "type": "string"
              },
              {
                "description": "the ID of the corresponding network",
                "name": "networkid",
                "type": "string"
              },
              {
                "description": "the netmask of the nic",
                "name": "netmask",
                "type": "string"
              },
              {
                "description": "the isolation uri of the nic",
                "name": "isolationuri",
                "type": "string"
              },
              {
                "description": "the IPv6 address of network",
                "name": "ip6address",
                "type": "string"
              },
              {
                "description": "the name of the corresponding network",
                "name": "networkname",
                "type": "string"
              },
              {
                "description": "the Secondary ipv4 addr of nic",
                "name": "secondaryip",
                "type": "list"
              },
              {
                "description": "the ip address of the nic",
                "name": "ipaddress",
                "type": "string"
              },
              {
                "description": "the gateway of IPv6 network",
                "name": "ip6gateway",
                "type": "string"
              },
              {
                "description": "the gateway of the nic",
                "name": "gateway",
                "type": "string"
              },
              {
                "description": "device id for the network when plugged into the virtual machine",
                "name": "deviceid",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "the user's name who deployed the virtual machine",
            "name": "username",
            "type": "string"
          },
          {
            "description": "list of affinity groups associated with the virtual machine",
            "name": "affinitygroup",
            "response": [
              {
                "description": "the description of the affinity group",
                "name": "description",
                "type": "string"
              },
              {
                "description": "the type of the affinity group",
                "name": "type",
                "type": "string"
              },
              {
                "description": "the ID of the affinity group",
                "name": "id",
                "type": "string"
              },
              {
                "description": "the project name of the affinity group",
                "name": "project",
                "type": "string"
              },
              {
                "description": "the name of the affinity group",
                "name": "name",
                "type": "string"
              },
              {
                "description": "the project ID of the affinity group",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "the domain ID of the affinity group",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "virtual machine IDs associated with this affinity group",
                "name": "virtualmachineIds",
                "type": "list"
              },
              {
                "description": "the account owning the affinity group",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the domain name of the affinity group",
                "name": "domain",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "true if high-availability is enabled, false otherwise",
            "name": "haenable",
            "type": "boolean"
          },
          {
            "description": "the name of the availability zone for the virtual machine",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the number of cpu this virtual machine is running with",
            "name": "cpunumber",
            "type": "integer"
          },
          {
            "description": "the ID of the availablility zone for the virtual machine",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the write (bytes) of disk on the vm",
            "name": "diskkbswrite",
            "type": "long"
          },
          {
            "description": "list of security groups associated with the virtual machine",
            "name": "securitygroup",
            "response": [
              {
                "description": "the ID of the security group",
                "name": "id",
                "type": "string"
              },
              {
                "description": "the account owning the security group",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the number of virtualmachines associated with this securitygroup",
                "name": "virtualmachinecount",
                "type": "integer"
              },
              {
                "description": "the domain name of the security group",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "the list of resource tags associated with the rule",
                "name": "tags",
                "response": [
                  {
                    "description": "resource type",
                    "name": "resourcetype",
                    "type": "string"
                  },
                  {
                    "description": "the ID of the domain associated with the tag",
                    "name": "domainid",
                    "type": "string"
                  },
                  {
                    "description": "customer associated with the tag",
                    "name": "customer",
                    "type": "string"
                  },
                  {
                    "description": "id of the resource",
                    "name": "resourceid",
                    "type": "string"
                  },
                  {
                    "description": "the account associated with the tag",
                    "name": "account",
                    "type": "string"
                  },
                  {
                    "description": "the project id the tag belongs to",
                    "name": "projectid",
                    "type": "string"
                  },
                  {
                    "description": "the domain associated with the tag",
                    "name": "domain",
                    "type": "string"
                  },
                  {
                    "description": "tag value",
                    "name": "value",
                    "type": "string"
                  },
                  {
                    "description": "tag key name",
                    "name": "key",
                    "type": "string"
                  },
                  {
                    "description": "the project name where tag belongs to",
                    "name": "project",
                    "type": "string"
                  }
                ],
                "type": "set"
              },
              {
                "description": "the list of virtualmachine ids associated with this securitygroup",
                "name": "virtualmachineids",
                "type": "set"
              },
              {
                "description": "the project id of the group",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "the project name of the group",
                "name": "project",
                "type": "string"
              },
              {
                "description": "the description of the security group",
                "name": "description",
                "type": "string"
              },
              {
                "description": "the list of egress rules associated with the security group",
                "name": "egressrule",
                "response": [
                  {
                    "description": "the code for the ICMP message response",
                    "name": "icmpcode",
                    "type": "integer"
                  },
                  {
                    "description": "the ending IP of the security group rule ",
                    "name": "endport",
                    "type": "integer"
                  },
                  {
                    "description": "security group name",
                    "name": "securitygroupname",
                    "type": "string"
                  },
                  {
                    "description": "the list of resource tags associated with the rule",
                    "name": "tags",
                    "response": [
                      {
                        "description": "resource type",
                        "name": "resourcetype",
                        "type": "string"
                      },
                      {
                        "description": "the account associated with the tag",
                        "name": "account",
                        "type": "string"
                      },
                      {
                        "description": "the domain associated with the tag",
                        "name": "domain",
                        "type": "string"
                      },
                      {
                        "description": "id of the resource",
                        "name": "resourceid",
                        "type": "string"
                      },
                      {
                        "description": "tag value",
                        "name": "value",
                        "type": "string"
                      },
                      {
                        "description": "the project id the tag belongs to",
                        "name": "projectid",
                        "type": "string"
                      },
                      {
                        "description": "the ID of the domain associated with the tag",
                        "name": "domainid",
                        "type": "string"
                      },
                      {
                        "description": "tag key name",
                        "name": "key",
                        "type": "string"
                      },
                      {
                        "description": "the project name where tag belongs to",
                        "name": "project",
                        "type": "string"
                      },
                      {
                        "description": "customer associated with the tag",
                        "name": "customer",
                        "type": "string"
                      }
                    ],
                    "type": "set"
                  },
                  {
                    "description": "the protocol of the security group rule",
                    "name": "protocol",
                    "type": "string"
                  },
                  {
                    "description": "account owning the security group rule",
                    "name": "account",
                    "type": "string"
                  },
                  {
                    "description": "the CIDR notation for the base IP address of the security group rule",
                    "name": "cidr",
                    "type": "string"
                  },
                  {
                    "description": "the type of the ICMP message response",
                    "name": "icmptype",
                    "type": "integer"
                  },
                  {
                    "description": "the id of the security group rule",
                    "name": "ruleid",
                    "type": "string"
                  },
                  {
                    "description": "the starting IP of the security group rule",
                    "name": "startport",
                    "type": "integer"
                  }
                ],
                "type": "set"
              },
              {
                "description": "the domain ID of the security group",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the name of the security group",
                "name": "name",
                "type": "string"
              },
              {
                "description": "the list of ingress rules associated with the security group",
                "name": "ingressrule",
                "response": [
                  {
                    "description": "security group name",
                    "name": "securitygroupname",
                    "type": "string"
                  },
                  {
                    "description": "account owning the security group rule",
                    "name": "account",
                    "type": "string"
                  },
                  {
                    "description": "the ending IP of the security group rule ",
                    "name": "endport",
                    "type": "integer"
                  },
                  {
                    "description": "the protocol of the security group rule",
                    "name": "protocol",
                    "type": "string"
                  },
                  {
                    "description": "the id of the security group rule",
                    "name": "ruleid",
                    "type": "string"
                  },
                  {
                    "description": "the starting IP of the security group rule",
                    "name": "startport",
                    "type": "integer"
                  },
                  {
                    "description": "the list of resource tags associated with the rule",
                    "name": "tags",
                    "response": [
                      {
                        "description": "the domain associated with the tag",
                        "name": "domain",
                        "type": "string"
                      },
                      {
                        "description": "the account associated with the tag",
                        "name": "account",
                        "type": "string"
                      },
                      {
                        "description": "tag key name",
                        "name": "key",
                        "type": "string"
                      },
                      {
                        "description": "id of the resource",
                        "name": "resourceid",
                        "type": "string"
                      },
                      {
                        "description": "tag value",
                        "name": "value",
                        "type": "string"
                      },
                      {
                        "description": "resource type",
                        "name": "resourcetype",
                        "type": "string"
                      },
                      {
                        "description": "the project name where tag belongs to",
                        "name": "project",
                        "type": "string"
                      },
                      {
                        "description": "the project id the tag belongs to",
                        "name": "projectid",
                        "type": "string"
                      },
                      {
                        "description": "customer associated with the tag",
                        "name": "customer",
                        "type": "string"
                      },
                      {
                        "description": "the ID of the domain associated with the tag",
                        "name": "domainid",
                        "type": "string"
                      }
                    ],
                    "type": "set"
                  },
                  {
                    "description": "the code for the ICMP message response",
                    "name": "icmpcode",
                    "type": "integer"
                  },
                  {
                    "description": "the type of the ICMP message response",
                    "name": "icmptype",
                    "type": "integer"
                  },
                  {
                    "description": "the CIDR notation for the base IP address of the security group rule",
                    "name": "cidr",
                    "type": "string"
                  }
                ],
                "type": "set"
              }
            ],
            "type": "set"
          },
          {
            "description": "public IP address id associated with vm via Static nat rule",
            "name": "publicipid",
            "type": "string"
          },
          {
            "description": "the ID of the service offering of the virtual machine",
            "name": "serviceofferingid",
            "type": "string"
          },
          {
            "description": "the group name of the virtual machine",
            "name": "group",
            "type": "string"
          },
          {
            "description": "the memory allocated for the virtual machine",
            "name": "memory",
            "type": "integer"
          },
          {
            "description": "the account associated with the virtual machine",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the user's ID who deployed the virtual machine",
            "name": "userid",
            "type": "string"
          },
          {
            "description": "true if the password rest feature is enabled, false otherwise",
            "name": "passwordenabled",
            "type": "boolean"
          },
          {
            "description": "device ID of the root volume",
            "name": "rootdeviceid",
            "type": "long"
          },
          {
            "description": "the read (bytes) of disk on the vm",
            "name": "diskkbsread",
            "type": "long"
          },
          {
            "description": "the ID of the disk offering of the virtual machine",
            "name": "diskofferingid",
            "type": "string"
          },
          {
            "description": "the ID of the virtual machine",
            "name": "id",
            "type": "string"
          },
          {
            "description": "Os type ID of the virtual machine",
            "name": "guestosid",
            "type": "string"
          },
          {
            "description": "the name of the ISO attached to the virtual machine",
            "name": "isoname",
            "type": "string"
          },
          {
            "description": "the ID of the domain in which the virtual machine exists",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the hypervisor on which the template runs",
            "name": "hypervisor",
            "type": "string"
          },
          {
            "description": "user generated name. The name of the virtual machine is returned if no displayname exists.",
            "name": "displayname",
            "type": "string"
          },
          {
            "description": "the group ID of the virtual machine",
            "name": "groupid",
            "type": "string"
          },
          {
            "description": "instance name of the user vm; this parameter is returned to the ROOT admin only",
            "name": "instancename",
            "type": "string"
          },
          {
            "description": "the name of the host for the virtual machine",
            "name": "hostname",
            "type": "string"
          },
          {
            "description": "the write (io) of disk on the vm",
            "name": "diskiowrite",
            "type": "long"
          },
          {
            "description": "the date when this virtual machine was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "the name of the template for the virtual machine",
            "name": "templatename",
            "type": "string"
          },
          {
            "description": "the virtual network for the service offering",
            "name": "forvirtualnetwork",
            "type": "boolean"
          },
          {
            "description": "an optional field whether to the display the vm to the end user or not.",
            "name": "displayvm",
            "type": "boolean"
          },
          {
            "description": "the name of the virtual machine",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the amount of the vm's CPU currently used",
            "name": "cpuused",
            "type": "string"
          },
          {
            "description": "the ID of the ISO attached to the virtual machine",
            "name": "isoid",
            "type": "string"
          },
          {
            "description": "the name of the domain in which the virtual machine exists",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "State of the Service from LB rule",
            "name": "servicestate",
            "type": "string"
          },
          {
            "description": "the state of the virtual machine",
            "name": "state",
            "type": "string"
          },
          {
            "description": "ssh key-pair",
            "name": "keypair",
            "type": "string"
          },
          {
            "description": "the outgoing network traffic on the host",
            "name": "networkkbswrite",
            "type": "long"
          },
          {
            "description": "the ID of the host for the virtual machine",
            "name": "hostid",
            "type": "string"
          }
        ]
      },
      {
        "description": "Lists all static routes",
        "isasync": false,
        "name": "listStaticRoutes",
        "params": [
          {
            "description": "list static routes by vpc id",
            "length": 255,
            "name": "vpcid",
            "related": "createVPC,listVPCs,listVPCs,restartVPC,createVPC,updateVPC",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false",
            "length": 255,
            "name": "listall",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "List resources by tags (key/value pairs)",
            "length": 255,
            "name": "tags",
            "required": false,
            "type": "map"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "list static routes by gateway id",
            "length": 255,
            "name": "gatewayid",
            "related": "createPrivateGateway",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "list only resources belonging to the domain specified",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
            "length": 255,
            "name": "isrecursive",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "list objects by project",
            "length": 255,
            "name": "projectid",
            "related": "activateProject,updateProject,suspendProject,listProjectAccounts,listProjects",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "list resources by account. Must be used with the domainId parameter.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "list static route by id",
            "length": 255,
            "name": "id",
            "related": "listStaticRoutes",
            "required": false,
            "type": "uuid"
          }
        ],
        "related": "",
        "response": [
          {
            "description": "VPC gateway the route is created for",
            "name": "gatewayid",
            "type": "string"
          },
          {
            "description": "the account associated with the static route",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the ID of static route",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the state of the static route",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the ID of the domain associated with the static route",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "VPC the static route belongs to",
            "name": "vpcid",
            "type": "string"
          },
          {
            "description": "the domain associated with the static route",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "static route CIDR",
            "name": "cidr",
            "type": "string"
          },
          {
            "description": "the project id of the static route",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the project name of the static route",
            "name": "project",
            "type": "string"
          },
          {
            "description": "the list of resource tags associated with static route",
            "name": "tags",
            "response": [
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              },
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              }
            ],
            "type": "list"
          }
        ]
      },
      {
        "description": "Lists all public ip addresses",
        "isasync": false,
        "name": "listPublicIpAddresses",
        "params": [
          {
            "description": "list resources by display flag; only ROOT admin is eligible to pass this parameter",
            "length": 255,
            "name": "fordisplay",
            "required": false,
            "since": "4.4",
            "type": "boolean"
          },
          {
            "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
            "length": 255,
            "name": "isrecursive",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "list only resources belonging to the domain specified",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list only source NAT IP addresses",
            "length": 255,
            "name": "issourcenat",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "List IPs belonging to the VPC",
            "length": 255,
            "name": "vpcid",
            "related": "createVPC,listVPCs,listVPCs,restartVPC,createVPC,updateVPC",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "lists all public IP addresses by VLAN ID",
            "length": 255,
            "name": "vlanid",
            "related": "listVlanIpRanges,dedicatePublicIpRange,createVlanIpRange",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list only IPs used for load balancing",
            "length": 255,
            "name": "forloadbalancing",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "lists IP address by ID",
            "length": 255,
            "name": "id",
            "related": "associateIpAddress,restartNetwork,updateIpAddress,listPublicIpAddresses,listPublicIpAddresses,associateIpAddress",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list only static NAT IP addresses",
            "length": 255,
            "name": "isstaticnat",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "limits search results to allocated public IP addresses",
            "length": 255,
            "name": "allocatedonly",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "lists all public IP addresses by physical network ID",
            "length": 255,
            "name": "physicalnetworkid",
            "related": "createPhysicalNetwork",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false",
            "length": 255,
            "name": "listall",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "List resources by tags (key/value pairs)",
            "length": 255,
            "name": "tags",
            "required": false,
            "type": "map"
          },
          {
            "description": "list objects by project",
            "length": 255,
            "name": "projectid",
            "related": "activateProject,updateProject,suspendProject,listProjectAccounts,listProjects",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "lists all public IP addresses by state",
            "length": 255,
            "name": "state",
            "required": false,
            "type": "string"
          },
          {
            "description": "the virtual network for the IP address",
            "length": 255,
            "name": "forvirtualnetwork",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "lists all public IP addresses by zone ID",
            "length": 255,
            "name": "zoneid",
            "related": "createZone,updateZone,listZones,listZones",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "lists all public IP addresses associated to the network specified",
            "length": 255,
            "name": "associatednetworkid",
            "related": "createNetwork,listNetscalerLoadBalancerNetworks,listPaloAltoFirewallNetworks,listNiciraNvpDeviceNetworks,listNetworks,updateNetwork,updateNetwork,createNetwork",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list resources by account. Must be used with the domainId parameter.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "lists the specified IP address",
            "length": 255,
            "name": "ipaddress",
            "required": false,
            "type": "string"
          }
        ],
        "related": "associateIpAddress,restartNetwork,updateIpAddress,listPublicIpAddresses,associateIpAddress",
        "response": [
          {
            "description": "purpose of the IP address. In Acton this value is not null for Ips with isSystem=true, and can have either StaticNat or LB value",
            "name": "purpose",
            "type": "string"
          },
          {
            "description": "is public IP portable across the zones",
            "name": "isportable",
            "type": "boolean"
          },
          {
            "description": "the domain ID the public IP address is associated with",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "true if this ip is system ip (was allocated as a part of deployVm or createLbRule)",
            "name": "issystem",
            "type": "boolean"
          },
          {
            "description": "public IP address id",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the account the public IP address is associated with",
            "name": "account",
            "type": "string"
          },
          {
            "description": "VPC the ip belongs to",
            "name": "vpcid",
            "type": "string"
          },
          {
            "description": "virutal machine (dnat) ip address (not null only for static nat Ip)",
            "name": "vmipaddress",
            "type": "string"
          },
          {
            "description": "is public ip for display to the regular user",
            "name": "fordisplay",
            "type": "boolean"
          },
          {
            "description": "the ID of the VLAN associated with the IP address. This parameter is visible to ROOT admins only",
            "name": "vlanid",
            "type": "string"
          },
          {
            "description": "the name of the zone the public IP address belongs to",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "true if this ip is for static nat, false otherwise",
            "name": "isstaticnat",
            "type": "boolean"
          },
          {
            "description": "the project id of the ipaddress",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the project name of the address",
            "name": "project",
            "type": "string"
          },
          {
            "description": "public IP address",
            "name": "ipaddress",
            "type": "string"
          },
          {
            "description": "the virtual network for the IP address",
            "name": "forvirtualnetwork",
            "type": "boolean"
          },
          {
            "description": "the ID of the Network associated with the IP address",
            "name": "associatednetworkid",
            "type": "string"
          },
          {
            "description": "the ID of the Network where ip belongs to",
            "name": "networkid",
            "type": "string"
          },
          {
            "description": "the VLAN associated with the IP address",
            "name": "vlanname",
            "type": "string"
          },
          {
            "description": "the list of resource tags associated with ip address",
            "name": "tags",
            "response": [
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              }
            ],
            "type": "list"
          },
          {
            "description": "State of the ip address. Can be: Allocatin, Allocated and Releasing",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the domain the public IP address is associated with",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "virutal machine name the ip address is assigned to (not null only for static nat Ip)",
            "name": "virtualmachinename",
            "type": "string"
          },
          {
            "description": "true if the IP address is a source nat address, false otherwise",
            "name": "issourcenat",
            "type": "boolean"
          },
          {
            "description": "virutal machine display name the ip address is assigned to (not null only for static nat Ip)",
            "name": "virtualmachinedisplayname",
            "type": "string"
          },
          {
            "description": "the physical network this belongs to",
            "name": "physicalnetworkid",
            "type": "string"
          },
          {
            "description": "virutal machine id the ip address is assigned to (not null only for static nat Ip)",
            "name": "virtualmachineid",
            "type": "string"
          },
          {
            "description": "the name of the Network associated with the IP address",
            "name": "associatednetworkname",
            "type": "string"
          },
          {
            "description": "the ID of the zone the public IP address belongs to",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "date the public IP address was acquired",
            "name": "allocated",
            "type": "date"
          }
        ]
      },
      {
        "description": "Updates an ISO file.",
        "isasync": false,
        "name": "updateIso",
        "params": [
          {
            "description": "true if the template type is routing i.e., if template is used to deploy router",
            "length": 255,
            "name": "isrouting",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "the name of the image file",
            "length": 255,
            "name": "name",
            "required": false,
            "type": "string"
          },
          {
            "description": "Details in key/value pairs using format details[i].keyname=keyvalue. Example: details[0].hypervisortoolsversion=xenserver61",
            "length": 255,
            "name": "details",
            "required": false,
            "type": "map"
          },
          {
            "description": "true if the template requres HVM, false otherwise; available only for updateTemplate API",
            "length": 255,
            "name": "requireshvm",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "the display text of the image",
            "length": 4096,
            "name": "displaytext",
            "required": false,
            "type": "string"
          },
          {
            "description": "the ID of the OS type that best represents the OS of this image.",
            "length": 255,
            "name": "ostypeid",
            "related": "addGuestOs,listOsTypes",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "true if image is bootable, false otherwise; available only for updateIso API",
            "length": 255,
            "name": "bootable",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "the format for the image",
            "length": 255,
            "name": "format",
            "required": false,
            "type": "string"
          },
          {
            "description": "true if template/ISO contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory",
            "length": 255,
            "name": "isdynamicallyscalable",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "the ID of the image file",
            "length": 255,
            "name": "id",
            "related": "listIsos,registerIso,updateTemplate,copyTemplate,registerTemplate,registerTemplate,prepareTemplate,listTemplates,createTemplate,updateIso,registerIso,createTemplate,copyTemplate,listIsos,copyIso",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "sort key of the template, integer",
            "length": 255,
            "name": "sortkey",
            "required": false,
            "type": "integer"
          },
          {
            "description": "true if the image supports the password reset feature; default is false",
            "length": 255,
            "name": "passwordenabled",
            "required": false,
            "type": "boolean"
          }
        ],
        "related": "listIsos,registerIso,updateTemplate,copyTemplate,registerTemplate,registerTemplate,prepareTemplate,listTemplates,createTemplate,registerIso,createTemplate,copyTemplate,listIsos,copyIso",
        "response": [
          {
            "description": "the hypervisor on which the template runs",
            "name": "hypervisor",
            "type": "string"
          },
          {
            "description": "true if the template is extractable, false otherwise",
            "name": "isextractable",
            "type": "boolean"
          },
          {
            "description": "the type of the template",
            "name": "templatetype",
            "type": "string"
          },
          {
            "description": "the list of resource tags associated with tempate",
            "name": "tags",
            "response": [
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              },
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "the ID of the zone for this template",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the project name of the template",
            "name": "project",
            "type": "string"
          },
          {
            "description": "the ID of the OS type for this template.",
            "name": "ostypeid",
            "type": "string"
          },
          {
            "description": "the ID of the domain to which the template belongs",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "additional key/value details tied with template",
            "name": "details",
            "type": "map"
          },
          {
            "description": "the format of the template.",
            "name": "format",
            "type": "imageformat"
          },
          {
            "description": "the name of the OS type for this template.",
            "name": "ostypename",
            "type": "string"
          },
          {
            "description": "the ID of the secondary storage host for the template",
            "name": "hostid",
            "type": "string"
          },
          {
            "description": "the name of the secondary storage host for the template",
            "name": "hostname",
            "type": "string"
          },
          {
            "description": "true if this template is a featured template, false otherwise",
            "name": "isfeatured",
            "type": "boolean"
          },
          {
            "description": "the project id of the template",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "true if the template is managed across all Zones, false otherwise",
            "name": "crossZones",
            "type": "boolean"
          },
          {
            "description": "the account id to which the template belongs",
            "name": "accountid",
            "type": "string"
          },
          {
            "description": "the name of the domain to which the template belongs",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "true if template is sshkey enabled, false otherwise",
            "name": "sshkeyenabled",
            "type": "boolean"
          },
          {
            "description": "true if the ISO is bootable, false otherwise",
            "name": "bootable",
            "type": "boolean"
          },
          {
            "description": "the name of the zone for this template",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "checksum of the template",
            "name": "checksum",
            "type": "string"
          },
          {
            "description": "the date this template was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "the size of the template",
            "name": "size",
            "type": "long"
          },
          {
            "description": "the template display text",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "true if this template is a public template, false otherwise",
            "name": "ispublic",
            "type": "boolean"
          },
          {
            "description": "the status of the template",
            "name": "status",
            "type": "string"
          },
          {
            "description": "the template ID",
            "name": "id",
            "type": "string"
          },
          {
            "description": "true if the reset password feature is enabled, false otherwise",
            "name": "passwordenabled",
            "type": "boolean"
          },
          {
            "description": "the tag of this template",
            "name": "templatetag",
            "type": "string"
          },
          {
            "description": "the template ID of the parent template if present",
            "name": "sourcetemplateid",
            "type": "string"
          },
          {
            "description": "true if template contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory",
            "name": "isdynamicallyscalable",
            "type": "boolean"
          },
          {
            "description": "the template name",
            "name": "name",
            "type": "string"
          },
          {
            "description": "true if the template is ready to be deployed from, false otherwise.",
            "name": "isready",
            "type": "boolean"
          },
          {
            "description": "the account name to which the template belongs",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the date this template was removed",
            "name": "removed",
            "type": "date"
          }
        ]
      },
      {
        "description": "Lists OpenDyalight controllers",
        "isasync": false,
        "name": "listOpenDaylightControllers",
        "params": [
          {
            "description": "the ID of a OpenDaylight Controller",
            "length": 255,
            "name": "id",
            "related": "addOpenDaylightController,listOpenDaylightControllers,deleteOpenDaylightController",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "the Physical Network ID",
            "length": 255,
            "name": "physicalnetworkid",
            "related": "createPhysicalNetwork",
            "required": false,
            "type": "uuid"
          }
        ],
        "related": "addOpenDaylightController,deleteOpenDaylightController",
        "response": [
          {
            "description": "the physical network to which this controller belongs to",
            "name": "physicalnetworkid",
            "type": "string"
          },
          {
            "description": "the username to authenticate to the controller",
            "name": "username",
            "type": "string"
          },
          {
            "description": "the url of the controller api",
            "name": "url",
            "type": "string"
          },
          {
            "description": "device id of the controller",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the name assigned to the controller",
            "name": "name",
            "type": "string"
          }
        ]
      },
      {
        "description": "Deletes a counter",
        "isasync": true,
        "name": "deleteCounter",
        "params": [
          {
            "description": "the ID of the counter",
            "length": 255,
            "name": "id",
            "related": "listCounters,createCounter",
            "required": true,
            "type": "uuid"
          }
        ],
        "response": [
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          }
        ]
      },
      {
        "description": "Changes the default NIC on a VM",
        "isasync": true,
        "name": "updateDefaultNicForVirtualMachine",
        "params": [
          {
            "description": "Virtual Machine ID",
            "length": 255,
            "name": "virtualmachineid",
            "related": "stopVirtualMachine,listVirtualMachines,detachIso,updateVMAffinityGroup,revertToVMSnapshot,deployVirtualMachine,migrateVirtualMachine,recoverVirtualMachine,updateDefaultNicForVirtualMachine,migrateVirtualMachineWithVolume,startVirtualMachine,listVirtualMachines,updateVirtualMachine,destroyVirtualMachine,removeNicFromVirtualMachine,removeNicFromVirtualMachine,deployVirtualMachine,destroyVirtualMachine,addNicToVirtualMachine,updateVirtualMachine,rebootVirtualMachine,updateVMAffinityGroup,revertToVMSnapshot,attachIso,resetPasswordForVirtualMachine,assignVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,resetSSHKeyForVirtualMachine,resetPasswordForVirtualMachine,detachIso,changeServiceForVirtualMachine,attachIso,updateDefaultNicForVirtualMachine,startVirtualMachine,stopVirtualMachine",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "NIC ID",
            "length": 255,
            "name": "nicid",
            "related": "",
            "required": true,
            "type": "uuid"
          }
        ],
        "related": "stopVirtualMachine,listVirtualMachines,detachIso,updateVMAffinityGroup,revertToVMSnapshot,deployVirtualMachine,migrateVirtualMachine,recoverVirtualMachine,migrateVirtualMachineWithVolume,startVirtualMachine,listVirtualMachines,updateVirtualMachine,destroyVirtualMachine,removeNicFromVirtualMachine,removeNicFromVirtualMachine,deployVirtualMachine,destroyVirtualMachine,addNicToVirtualMachine,updateVirtualMachine,rebootVirtualMachine,updateVMAffinityGroup,revertToVMSnapshot,attachIso,resetPasswordForVirtualMachine,assignVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,resetSSHKeyForVirtualMachine,resetPasswordForVirtualMachine,detachIso,changeServiceForVirtualMachine,attachIso,updateDefaultNicForVirtualMachine,startVirtualMachine,stopVirtualMachine",
        "response": [
          {
            "description": "the date when this virtual machine was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "public IP address id associated with vm via Static nat rule",
            "name": "publicip",
            "type": "string"
          },
          {
            "description": "Os type ID of the virtual machine",
            "name": "guestosid",
            "type": "string"
          },
          {
            "description": "the amount of the vm's CPU currently used",
            "name": "cpuused",
            "type": "string"
          },
          {
            "description": "the number of cpu this virtual machine is running with",
            "name": "cpunumber",
            "type": "integer"
          },
          {
            "description": "an optional field whether to the display the vm to the end user or not.",
            "name": "displayvm",
            "type": "boolean"
          },
          {
            "description": "list of security groups associated with the virtual machine",
            "name": "securitygroup",
            "response": [
              {
                "description": "the description of the security group",
                "name": "description",
                "type": "string"
              },
              {
                "description": "the project id of the group",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "the list of egress rules associated with the security group",
                "name": "egressrule",
                "response": [
                  {
                    "description": "the id of the security group rule",
                    "name": "ruleid",
                    "type": "string"
                  },
                  {
                    "description": "the code for the ICMP message response",
                    "name": "icmpcode",
                    "type": "integer"
                  },
                  {
                    "description": "the list of resource tags associated with the rule",
                    "name": "tags",
                    "response": [
                      {
                        "description": "tag key name",
                        "name": "key",
                        "type": "string"
                      },
                      {
                        "description": "the project id the tag belongs to",
                        "name": "projectid",
                        "type": "string"
                      },
                      {
                        "description": "id of the resource",
                        "name": "resourceid",
                        "type": "string"
                      },
                      {
                        "description": "the project name where tag belongs to",
                        "name": "project",
                        "type": "string"
                      },
                      {
                        "description": "resource type",
                        "name": "resourcetype",
                        "type": "string"
                      },
                      {
                        "description": "the domain associated with the tag",
                        "name": "domain",
                        "type": "string"
                      },
                      {
                        "description": "the ID of the domain associated with the tag",
                        "name": "domainid",
                        "type": "string"
                      },
                      {
                        "description": "the account associated with the tag",
                        "name": "account",
                        "type": "string"
                      },
                      {
                        "description": "customer associated with the tag",
                        "name": "customer",
                        "type": "string"
                      },
                      {
                        "description": "tag value",
                        "name": "value",
                        "type": "string"
                      }
                    ],
                    "type": "set"
                  },
                  {
                    "description": "the protocol of the security group rule",
                    "name": "protocol",
                    "type": "string"
                  },
                  {
                    "description": "the starting IP of the security group rule",
                    "name": "startport",
                    "type": "integer"
                  },
                  {
                    "description": "account owning the security group rule",
                    "name": "account",
                    "type": "string"
                  },
                  {
                    "description": "the ending IP of the security group rule ",
                    "name": "endport",
                    "type": "integer"
                  },
                  {
                    "description": "the type of the ICMP message response",
                    "name": "icmptype",
                    "type": "integer"
                  },
                  {
                    "description": "security group name",
                    "name": "securitygroupname",
                    "type": "string"
                  },
                  {
                    "description": "the CIDR notation for the base IP address of the security group rule",
                    "name": "cidr",
                    "type": "string"
                  }
                ],
                "type": "set"
              },
              {
                "description": "the ID of the security group",
                "name": "id",
                "type": "string"
              },
              {
                "description": "the list of resource tags associated with the rule",
                "name": "tags",
                "response": [
                  {
                    "description": "the domain associated with the tag",
                    "name": "domain",
                    "type": "string"
                  },
                  {
                    "description": "id of the resource",
                    "name": "resourceid",
                    "type": "string"
                  },
                  {
                    "description": "resource type",
                    "name": "resourcetype",
                    "type": "string"
                  },
                  {
                    "description": "customer associated with the tag",
                    "name": "customer",
                    "type": "string"
                  },
                  {
                    "description": "tag key name",
                    "name": "key",
                    "type": "string"
                  },
                  {
                    "description": "the account associated with the tag",
                    "name": "account",
                    "type": "string"
                  },
                  {
                    "description": "the project name where tag belongs to",
                    "name": "project",
                    "type": "string"
                  },
                  {
                    "description": "tag value",
                    "name": "value",
                    "type": "string"
                  },
                  {
                    "description": "the project id the tag belongs to",
                    "name": "projectid",
                    "type": "string"
                  },
                  {
                    "description": "the ID of the domain associated with the tag",
                    "name": "domainid",
                    "type": "string"
                  }
                ],
                "type": "set"
              },
              {
                "description": "the project name of the group",
                "name": "project",
                "type": "string"
              },
              {
                "description": "the list of virtualmachine ids associated with this securitygroup",
                "name": "virtualmachineids",
                "type": "set"
              },
              {
                "description": "the domain name of the security group",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "the list of ingress rules associated with the security group",
                "name": "ingressrule",
                "response": [
                  {
                    "description": "the CIDR notation for the base IP address of the security group rule",
                    "name": "cidr",
                    "type": "string"
                  },
                  {
                    "description": "the list of resource tags associated with the rule",
                    "name": "tags",
                    "response": [
                      {
                        "description": "the project name where tag belongs to",
                        "name": "project",
                        "type": "string"
                      },
                      {
                        "description": "resource type",
                        "name": "resourcetype",
                        "type": "string"
                      },
                      {
                        "description": "the account associated with the tag",
                        "name": "account",
                        "type": "string"
                      },
                      {
                        "description": "the domain associated with the tag",
                        "name": "domain",
                        "type": "string"
                      },
                      {
                        "description": "id of the resource",
                        "name": "resourceid",
                        "type": "string"
                      },
                      {
                        "description": "tag key name",
                        "name": "key",
                        "type": "string"
                      },
                      {
                        "description": "tag value",
                        "name": "value",
                        "type": "string"
                      },
                      {
                        "description": "the ID of the domain associated with the tag",
                        "name": "domainid",
                        "type": "string"
                      },
                      {
                        "description": "customer associated with the tag",
                        "name": "customer",
                        "type": "string"
                      },
                      {
                        "description": "the project id the tag belongs to",
                        "name": "projectid",
                        "type": "string"
                      }
                    ],
                    "type": "set"
                  },
                  {
                    "description": "the id of the security group rule",
                    "name": "ruleid",
                    "type": "string"
                  },
                  {
                    "description": "the code for the ICMP message response",
                    "name": "icmpcode",
                    "type": "integer"
                  },
                  {
                    "description": "the protocol of the security group rule",
                    "name": "protocol",
                    "type": "string"
                  },
                  {
                    "description": "the type of the ICMP message response",
                    "name": "icmptype",
                    "type": "integer"
                  },
                  {
                    "description": "account owning the security group rule",
                    "name": "account",
                    "type": "string"
                  },
                  {
                    "description": "the starting IP of the security group rule",
                    "name": "startport",
                    "type": "integer"
                  },
                  {
                    "description": "the ending IP of the security group rule ",
                    "name": "endport",
                    "type": "integer"
                  },
                  {
                    "description": "security group name",
                    "name": "securitygroupname",
                    "type": "string"
                  }
                ],
                "type": "set"
              },
              {
                "description": "the number of virtualmachines associated with this securitygroup",
                "name": "virtualmachinecount",
                "type": "integer"
              },
              {
                "description": "the account owning the security group",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the domain ID of the security group",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the name of the security group",
                "name": "name",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "Vm details in key/value pairs.",
            "name": "details",
            "type": "map"
          },
          {
            "description": "the project id of the vm",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the read (io) of disk on the vm",
            "name": "diskioread",
            "type": "long"
          },
          {
            "description": "the name of the template for the virtual machine",
            "name": "templatename",
            "type": "string"
          },
          {
            "description": "the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.",
            "name": "templateid",
            "type": "string"
          },
          {
            "description": "the account associated with the virtual machine",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the ID of the domain in which the virtual machine exists",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the read (bytes) of disk on the vm",
            "name": "diskkbsread",
            "type": "long"
          },
          {
            "description": "the write (io) of disk on the vm",
            "name": "diskiowrite",
            "type": "long"
          },
          {
            "description": "the ID of the virtual machine",
            "name": "id",
            "type": "string"
          },
          {
            "description": " an alternate display text of the template for the virtual machine",
            "name": "templatedisplaytext",
            "type": "string"
          },
          {
            "description": "user generated name. The name of the virtual machine is returned if no displayname exists.",
            "name": "displayname",
            "type": "string"
          },
          {
            "description": "OS type id of the vm",
            "name": "ostypeid",
            "type": "long"
          },
          {
            "description": "the group name of the virtual machine",
            "name": "group",
            "type": "string"
          },
          {
            "description": "the ID of the disk offering of the virtual machine",
            "name": "diskofferingid",
            "type": "string"
          },
          {
            "description": "the incoming network traffic on the vm",
            "name": "networkkbsread",
            "type": "long"
          },
          {
            "description": "the name of the domain in which the virtual machine exists",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the list of resource tags associated with vm",
            "name": "tags",
            "response": [
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "the list of nics associated with vm",
            "name": "nic",
            "response": [
              {
                "description": "Id of the vm to which the nic belongs",
                "name": "virtualmachineid",
                "type": "string"
              },
              {
                "description": "the ID of the corresponding network",
                "name": "networkid",
                "type": "string"
              },
              {
                "description": "the gateway of IPv6 network",
                "name": "ip6gateway",
                "type": "string"
              },
              {
                "description": "the ip address of the nic",
                "name": "ipaddress",
                "type": "string"
              },
              {
                "description": "the traffic type of the nic",
                "name": "traffictype",
                "type": "string"
              },
              {
                "description": "the broadcast uri of the nic",
                "name": "broadcasturi",
                "type": "string"
              },
              {
                "description": "the cidr of IPv6 network",
                "name": "ip6cidr",
                "type": "string"
              },
              {
                "description": "the IPv6 address of network",
                "name": "ip6address",
                "type": "string"
              },
              {
                "description": "true if nic is default, false otherwise",
                "name": "isdefault",
                "type": "boolean"
              },
              {
                "description": "the isolation uri of the nic",
                "name": "isolationuri",
                "type": "string"
              },
              {
                "description": "the type of the nic",
                "name": "type",
                "type": "string"
              },
              {
                "description": "true if nic is default, false otherwise",
                "name": "macaddress",
                "type": "string"
              },
              {
                "description": "the ID of the nic",
                "name": "id",
                "type": "string"
              },
              {
                "description": "the Secondary ipv4 addr of nic",
                "name": "secondaryip",
                "type": "list"
              },
              {
                "description": "the name of the corresponding network",
                "name": "networkname",
                "type": "string"
              },
              {
                "description": "the gateway of the nic",
                "name": "gateway",
                "type": "string"
              },
              {
                "description": "device id for the network when plugged into the virtual machine",
                "name": "deviceid",
                "type": "string"
              },
              {
                "description": "the netmask of the nic",
                "name": "netmask",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "true if high-availability is enabled, false otherwise",
            "name": "haenable",
            "type": "boolean"
          },
          {
            "description": "the name of the ISO attached to the virtual machine",
            "name": "isoname",
            "type": "string"
          },
          {
            "description": "public IP address id associated with vm via Static nat rule",
            "name": "publicipid",
            "type": "string"
          },
          {
            "description": "the name of the service offering of the virtual machine",
            "name": "serviceofferingname",
            "type": "string"
          },
          {
            "description": "true if the password rest feature is enabled, false otherwise",
            "name": "passwordenabled",
            "type": "boolean"
          },
          {
            "description": "State of the Service from LB rule",
            "name": "servicestate",
            "type": "string"
          },
          {
            "description": "device ID of the root volume",
            "name": "rootdeviceid",
            "type": "long"
          },
          {
            "description": "list of affinity groups associated with the virtual machine",
            "name": "affinitygroup",
            "response": [
              {
                "description": "virtual machine IDs associated with this affinity group",
                "name": "virtualmachineIds",
                "type": "list"
              },
              {
                "description": "the name of the affinity group",
                "name": "name",
                "type": "string"
              },
              {
                "description": "the project ID of the affinity group",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "the project name of the affinity group",
                "name": "project",
                "type": "string"
              },
              {
                "description": "the type of the affinity group",
                "name": "type",
                "type": "string"
              },
              {
                "description": "the domain ID of the affinity group",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the ID of the affinity group",
                "name": "id",
                "type": "string"
              },
              {
                "description": "the description of the affinity group",
                "name": "description",
                "type": "string"
              },
              {
                "description": "the domain name of the affinity group",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "the account owning the affinity group",
                "name": "account",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "the ID of the service offering of the virtual machine",
            "name": "serviceofferingid",
            "type": "string"
          },
          {
            "description": "the vgpu type used by the virtual machine",
            "name": "vgpu",
            "type": "string"
          },
          {
            "description": "the write (bytes) of disk on the vm",
            "name": "diskkbswrite",
            "type": "long"
          },
          {
            "description": "the outgoing network traffic on the host",
            "name": "networkkbswrite",
            "type": "long"
          },
          {
            "description": "the password (if exists) of the virtual machine",
            "name": "password",
            "type": "string"
          },
          {
            "description": "the virtual network for the service offering",
            "name": "forvirtualnetwork",
            "type": "boolean"
          },
          {
            "description": "the ID of the host for the virtual machine",
            "name": "hostid",
            "type": "string"
          },
          {
            "description": "the name of the disk offering of the virtual machine",
            "name": "diskofferingname",
            "type": "string"
          },
          {
            "description": "the user's ID who deployed the virtual machine",
            "name": "userid",
            "type": "string"
          },
          {
            "description": "the state of the virtual machine",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the group ID of the virtual machine",
            "name": "groupid",
            "type": "string"
          },
          {
            "description": "the ID of the availablility zone for the virtual machine",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the speed of each cpu",
            "name": "cpuspeed",
            "type": "integer"
          },
          {
            "description": "instance name of the user vm; this parameter is returned to the ROOT admin only",
            "name": "instancename",
            "type": "string"
          },
          {
            "description": "the name of the availability zone for the virtual machine",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "device type of the root volume",
            "name": "rootdevicetype",
            "type": "string"
          },
          {
            "description": "the name of the virtual machine",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the name of the host for the virtual machine",
            "name": "hostname",
            "type": "string"
          },
          {
            "description": "the ID of the ISO attached to the virtual machine",
            "name": "isoid",
            "type": "string"
          },
          {
            "description": "the user's name who deployed the virtual machine",
            "name": "username",
            "type": "string"
          },
          {
            "description": "the project name of the vm",
            "name": "project",
            "type": "string"
          },
          {
            "description": "the memory allocated for the virtual machine",
            "name": "memory",
            "type": "integer"
          },
          {
            "description": "ssh key-pair",
            "name": "keypair",
            "type": "string"
          },
          {
            "description": "true if vm contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory.",
            "name": "isdynamicallyscalable",
            "type": "boolean"
          },
          {},
          {
            "description": "the hypervisor on which the template runs",
            "name": "hypervisor",
            "type": "string"
          },
          {
            "description": "an alternate display text of the ISO attached to the virtual machine",
            "name": "isodisplaytext",
            "type": "string"
          }
        ]
      },
      {
        "description": "Deletes a user for an account",
        "isasync": false,
        "name": "deleteUser",
        "params": [
          {
            "description": "id of the user to be deleted",
            "length": 255,
            "name": "id",
            "related": "listUsers,getUser,lockUser,createUser,updateUser,enableUser,disableUser",
            "required": true,
            "type": "uuid"
          }
        ],
        "response": [
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          }
        ]
      },
      {
        "description": "Deletes network device.",
        "isasync": false,
        "name": "deleteNetworkDevice",
        "params": [
          {
            "description": "Id of network device to delete",
            "length": 255,
            "name": "id",
            "related": "addHost,reconnectHost,addBaremetalHost,cancelHostMaintenance,prepareHostForMaintenance",
            "required": true,
            "type": "uuid"
          }
        ],
        "response": [
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          },
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          }
        ]
      },
      {
        "description": "Creates a port forwarding rule",
        "isasync": true,
        "name": "createPortForwardingRule",
        "params": [
          {
            "description": "VM guest nic secondary IP address for the port forwarding rule",
            "length": 255,
            "name": "vmguestip",
            "required": false,
            "type": "string"
          },
          {
            "description": "the starting port of port forwarding rule's public port range",
            "length": 255,
            "name": "publicport",
            "required": true,
            "type": "integer"
          },
          {
            "description": "the network of the virtual machine the port forwarding rule will be created for. Required when public IP address is not associated with any guest network yet (VPC case).",
            "length": 255,
            "name": "networkid",
            "related": "createNetwork,listNetscalerLoadBalancerNetworks,listPaloAltoFirewallNetworks,listNiciraNvpDeviceNetworks,listNetworks,updateNetwork,updateNetwork,createNetwork",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "if true, firewall rule for source/end public port is automatically created; if false - firewall rule has to be created explicitly. If not specified 1) defaulted to false when PF rule is being created for VPC guest network 2) in all other cases defaulted to true",
            "length": 255,
            "name": "openfirewall",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "an optional field, whether to the display the rule to the end user or not",
            "length": 255,
            "name": "fordisplay",
            "required": false,
            "since": "4.4",
            "type": "boolean"
          },
          {
            "description": "the ending port of port forwarding rule's private port range",
            "length": 255,
            "name": "privateendport",
            "required": false,
            "type": "integer"
          },
          {
            "description": "the cidr list to forward traffic from",
            "length": 255,
            "name": "cidrlist",
            "required": false,
            "type": "list"
          },
          {
            "description": "the ID of the virtual machine for the port forwarding rule",
            "length": 255,
            "name": "virtualmachineid",
            "related": "stopVirtualMachine,listVirtualMachines,detachIso,updateVMAffinityGroup,revertToVMSnapshot,deployVirtualMachine,migrateVirtualMachine,recoverVirtualMachine,migrateVirtualMachineWithVolume,startVirtualMachine,listVirtualMachines,updateVirtualMachine,destroyVirtualMachine,removeNicFromVirtualMachine,removeNicFromVirtualMachine,deployVirtualMachine,destroyVirtualMachine,addNicToVirtualMachine,updateVirtualMachine,rebootVirtualMachine,updateVMAffinityGroup,revertToVMSnapshot,attachIso,resetPasswordForVirtualMachine,assignVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,resetSSHKeyForVirtualMachine,resetPasswordForVirtualMachine,detachIso,changeServiceForVirtualMachine,attachIso,updateDefaultNicForVirtualMachine,startVirtualMachine,stopVirtualMachine",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "the IP address id of the port forwarding rule",
            "length": 255,
            "name": "ipaddressid",
            "related": "associateIpAddress,restartNetwork,updateIpAddress,listPublicIpAddresses,associateIpAddress",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "the protocol for the port forwarding rule. Valid values are TCP or UDP.",
            "length": 255,
            "name": "protocol",
            "required": true,
            "type": "string"
          },
          {
            "description": "the starting port of port forwarding rule's private port range",
            "length": 255,
            "name": "privateport",
            "required": true,
            "type": "integer"
          },
          {
            "description": "the ending port of port forwarding rule's private port range",
            "length": 255,
            "name": "publicendport",
            "required": false,
            "type": "integer"
          }
        ],
        "related": "listPortForwardingRules,updatePortForwardingRule",
        "response": [
          {
            "description": "the public ip address for the port forwarding rule",
            "name": "ipaddress",
            "type": "string"
          },
          {
            "description": "the VM ID for the port forwarding rule",
            "name": "virtualmachineid",
            "type": "string"
          },
          {
            "description": "the protocol of the port forwarding rule",
            "name": "protocol",
            "type": "string"
          },
          {
            "description": "the VM display name for the port forwarding rule",
            "name": "virtualmachinedisplayname",
            "type": "string"
          },
          {
            "description": "the ID of the port forwarding rule",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the cidr list to forward traffic from",
            "name": "cidrlist",
            "type": "string"
          },
          {
            "description": "the starting port of port forwarding rule's private port range",
            "name": "privateport",
            "type": "string"
          },
          {
            "description": "the starting port of port forwarding rule's public port range",
            "name": "publicport",
            "type": "string"
          },
          {
            "description": "the id of the guest network the port forwarding rule belongs to",
            "name": "networkid",
            "type": "string"
          },
          {
            "description": "the VM name for the port forwarding rule",
            "name": "virtualmachinename",
            "type": "string"
          },
          {
            "description": "the public ip address id for the port forwarding rule",
            "name": "ipaddressid",
            "type": "string"
          },
          {
            "description": "the state of the rule",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the ending port of port forwarding rule's private port range",
            "name": "publicendport",
            "type": "string"
          },
          {
            "description": "is firewall for display to the regular user",
            "name": "fordisplay",
            "type": "boolean"
          },
          {
            "description": "the list of resource tags associated with the rule",
            "name": "tags",
            "response": [
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              }
            ],
            "type": "list"
          },
          {
            "description": "the ending port of port forwarding rule's private port range",
            "name": "privateendport",
            "type": "string"
          },
          {
            "description": "the vm ip address for the port forwarding rule",
            "name": "vmguestip",
            "type": "string"
          }
        ]
      },
      {
        "description": "load template into primary storage",
        "isasync": false,
        "name": "prepareTemplate",
        "params": [
          {
            "description": "template ID of the template to be prepared in primary storage(s).",
            "length": 255,
            "name": "templateid",
            "related": "listIsos,registerIso,updateTemplate,copyTemplate,registerTemplate,registerTemplate,prepareTemplate,listTemplates,createTemplate,registerIso,createTemplate,copyTemplate,listIsos,copyIso",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "storage pool ID of the primary storage pool to which the template should be prepared. If it is not provided the template is prepared on all the available primary storage pools.",
            "length": 255,
            "name": "storageid",
            "related": "cancelStorageMaintenance,enableStorageMaintenance,createStoragePool,findStoragePoolsForMigration",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "zone ID of the template to be prepared in primary storage(s).",
            "length": 255,
            "name": "zoneid",
            "related": "createZone,updateZone,listZones,listZones",
            "required": true,
            "type": "uuid"
          }
        ],
        "related": "listIsos,registerIso,updateTemplate,copyTemplate,registerTemplate,registerTemplate,listTemplates,createTemplate,registerIso,createTemplate,copyTemplate,listIsos,copyIso",
        "response": [
          {
            "description": "true if the ISO is bootable, false otherwise",
            "name": "bootable",
            "type": "boolean"
          },
          {
            "description": "true if the template is managed across all Zones, false otherwise",
            "name": "crossZones",
            "type": "boolean"
          },
          {
            "description": "true if the template is ready to be deployed from, false otherwise.",
            "name": "isready",
            "type": "boolean"
          },
          {
            "description": "true if template is sshkey enabled, false otherwise",
            "name": "sshkeyenabled",
            "type": "boolean"
          },
          {
            "description": "checksum of the template",
            "name": "checksum",
            "type": "string"
          },
          {
            "description": "the tag of this template",
            "name": "templatetag",
            "type": "string"
          },
          {
            "description": "true if this template is a public template, false otherwise",
            "name": "ispublic",
            "type": "boolean"
          },
          {
            "description": "the ID of the zone for this template",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the account id to which the template belongs",
            "name": "accountid",
            "type": "string"
          },
          {
            "description": "the name of the secondary storage host for the template",
            "name": "hostname",
            "type": "string"
          },
          {
            "description": "true if this template is a featured template, false otherwise",
            "name": "isfeatured",
            "type": "boolean"
          },
          {
            "description": "the list of resource tags associated with tempate",
            "name": "tags",
            "response": [
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              },
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "the name of the zone for this template",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "true if the reset password feature is enabled, false otherwise",
            "name": "passwordenabled",
            "type": "boolean"
          },
          {
            "description": "the template ID of the parent template if present",
            "name": "sourcetemplateid",
            "type": "string"
          },
          {
            "description": "the template name",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the date this template was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "the ID of the domain to which the template belongs",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the type of the template",
            "name": "templatetype",
            "type": "string"
          },
          {
            "description": "the hypervisor on which the template runs",
            "name": "hypervisor",
            "type": "string"
          },
          {
            "description": "the project name of the template",
            "name": "project",
            "type": "string"
          },
          {
            "description": "true if template contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory",
            "name": "isdynamicallyscalable",
            "type": "boolean"
          },
          {
            "description": "the status of the template",
            "name": "status",
            "type": "string"
          },
          {
            "description": "the template ID",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the ID of the secondary storage host for the template",
            "name": "hostid",
            "type": "string"
          },
          {
            "description": "the size of the template",
            "name": "size",
            "type": "long"
          },
          {
            "description": "the format of the template.",
            "name": "format",
            "type": "imageformat"
          },
          {
            "description": "the account name to which the template belongs",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the template display text",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "true if the template is extractable, false otherwise",
            "name": "isextractable",
            "type": "boolean"
          },
          {
            "description": "the ID of the OS type for this template.",
            "name": "ostypeid",
            "type": "string"
          },
          {
            "description": "the name of the OS type for this template.",
            "name": "ostypename",
            "type": "string"
          },
          {
            "description": "the project id of the template",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "additional key/value details tied with template",
            "name": "details",
            "type": "map"
          },
          {
            "description": "the date this template was removed",
            "name": "removed",
            "type": "date"
          },
          {
            "description": "the name of the domain to which the template belongs",
            "name": "domain",
            "type": "string"
          }
        ]
      },
      {
        "description": "Dedicates a zones.",
        "isasync": true,
        "name": "dedicateZone",
        "params": [
          {
            "description": "the name of the account which needs dedication. Must be used with domainId.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "the ID of the zone",
            "length": 255,
            "name": "zoneid",
            "related": "createZone,updateZone,listZones,listZones",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "the ID of the containing domain",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain",
            "required": true,
            "type": "uuid"
          }
        ],
        "related": "",
        "response": [
          {
            "description": "the domain ID to which the Zone is dedicated",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the Dedication Affinity Group ID of the zone",
            "name": "affinitygroupid",
            "type": "string"
          },
          {
            "description": "the Name of the Zone",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the ID of the dedicated resource",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the ID of the Zone",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the Account Id to which the Zone is dedicated",
            "name": "accountid",
            "type": "string"
          }
        ]
      },
      {
        "description": "Assigns virtual machine or a list of virtual machines to a load balancer rule.",
        "isasync": true,
        "name": "assignToLoadBalancerRule",
        "params": [
          {
            "description": "the list of IDs of the virtual machine that are being assigned to the load balancer rule(i.e. virtualMachineIds=1,2,3)",
            "length": 255,
            "name": "virtualmachineids",
            "related": "stopVirtualMachine,listVirtualMachines,detachIso,updateVMAffinityGroup,revertToVMSnapshot,deployVirtualMachine,migrateVirtualMachine,recoverVirtualMachine,migrateVirtualMachineWithVolume,startVirtualMachine,listVirtualMachines,updateVirtualMachine,destroyVirtualMachine,removeNicFromVirtualMachine,removeNicFromVirtualMachine,deployVirtualMachine,destroyVirtualMachine,addNicToVirtualMachine,updateVirtualMachine,rebootVirtualMachine,updateVMAffinityGroup,revertToVMSnapshot,attachIso,resetPasswordForVirtualMachine,assignVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,resetSSHKeyForVirtualMachine,resetPasswordForVirtualMachine,detachIso,changeServiceForVirtualMachine,attachIso,updateDefaultNicForVirtualMachine,startVirtualMachine,stopVirtualMachine",
            "required": false,
            "type": "list"
          },
          {
            "description": "the ID of the load balancer rule",
            "length": 255,
            "name": "id",
            "related": "listPortForwardingRules,updatePortForwardingRule",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "VM ID and IP map, vmidipmap[0].vmid=1 vmidipmap[0].ip=10.1.1.75",
            "length": 255,
            "name": "vmidipmap",
            "required": false,
            "since": "4.4",
            "type": "map"
          }
        ],
        "response": [
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          },
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          }
        ]
      },
      {
        "description": "Lists all pending asynchronous jobs for the account.",
        "isasync": false,
        "name": "listAsyncJobs",
        "params": [
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "list resources by account. Must be used with the domainId parameter.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false",
            "length": 255,
            "name": "listall",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
            "length": 255,
            "name": "isrecursive",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "the start date of the async job",
            "length": 255,
            "name": "startdate",
            "required": false,
            "type": "tzdate"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "list only resources belonging to the domain specified",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain",
            "required": false,
            "type": "uuid"
          }
        ],
        "related": "queryAsyncJobResult",
        "response": [
          {
            "description": "  the created date of the job",
            "name": "created",
            "type": "date"
          },
          {
            "description": "the instance/entity object related to the job",
            "name": "jobinstancetype",
            "type": "string"
          },
          {
            "description": "the async command executed",
            "name": "cmd",
            "type": "string"
          },
          {
            "description": "the user that executed the async command",
            "name": "userid",
            "type": "string"
          },
          {
            "description": "the account that executed the async command",
            "name": "accountid",
            "type": "string"
          },
          {
            "description": "the result reason",
            "name": "jobresult",
            "type": "responseobject"
          },
          {
            "description": "the result code for the job",
            "name": "jobresultcode",
            "type": "integer"
          },
          {
            "description": "the current job status-should be 0 for PENDING",
            "name": "jobstatus",
            "type": "integer"
          },
          {
            "description": "the result type",
            "name": "jobresulttype",
            "type": "string"
          },
          {
            "description": "the progress information of the PENDING job",
            "name": "jobprocstatus",
            "type": "integer"
          },
          {
            "description": "the unique ID of the instance/entity object related to the job",
            "name": "jobinstanceid",
            "type": "string"
          }
        ]
      },
      {
        "description": "Archive one or more alerts.",
        "isasync": false,
        "name": "archiveAlerts",
        "params": [
          {
            "description": "archive by alert type",
            "length": 255,
            "name": "type",
            "required": false,
            "type": "string"
          },
          {
            "description": "end date range to archive alerts (including) this date (use format \"yyyy-MM-dd\" or the new format \"yyyy-MM-ddThh:mm:ss\")",
            "length": 255,
            "name": "enddate",
            "required": false,
            "type": "date"
          },
          {
            "description": "the IDs of the alerts",
            "length": 255,
            "name": "ids",
            "related": "listAlerts",
            "required": false,
            "type": "list"
          },
          {
            "description": "start date range to archive alerts (including) this date (use format \"yyyy-MM-dd\" or the new format \"yyyy-MM-ddThh:mm:ss\")",
            "length": 255,
            "name": "startdate",
            "required": false,
            "type": "date"
          }
        ],
        "response": [
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          }
        ]
      },
      {
        "description": "Stops an Internal LB vm.",
        "isasync": true,
        "name": "stopInternalLoadBalancerVM",
        "params": [
          {
            "description": "the ID of the internal lb vm",
            "length": 255,
            "name": "id",
            "related": "changeServiceForRouter,destroyRouter,listInternalLoadBalancerVMs,stopInternalLoadBalancerVM,listRouters",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "Force stop the VM. The caller knows the VM is stopped.",
            "length": 255,
            "name": "forced",
            "required": false,
            "type": "boolean"
          }
        ],
        "related": "changeServiceForRouter,destroyRouter,listInternalLoadBalancerVMs,listRouters",
        "response": [
          {
            "description": "the domain associated with the router",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the version of template",
            "name": "version",
            "type": "string"
          },
          {
            "description": "the public IP address for the router",
            "name": "publicip",
            "type": "string"
          },
          {
            "description": "the hypervisor on which the template runs",
            "name": "hypervisor",
            "type": "string"
          },
          {
            "description": "the project id of the ipaddress",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the version of scripts",
            "name": "scriptsversion",
            "type": "string"
          },
          {
            "description": "the first DNS for the router",
            "name": "dns1",
            "type": "string"
          },
          {
            "description": "the second IPv6 DNS for the router",
            "name": "ip6dns2",
            "type": "string"
          },
          {
            "description": "the network domain for the router",
            "name": "networkdomain",
            "type": "string"
          },
          {
            "description": "the Pod ID for the router",
            "name": "podid",
            "type": "string"
          },
          {
            "description": "the ID of the corresponding link local network",
            "name": "linklocalnetworkid",
            "type": "string"
          },
          {
            "description": "the state of redundant virtual router",
            "name": "redundantstate",
            "type": "string"
          },
          {
            "description": "the id of the router",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the public MAC address for the router",
            "name": "publicmacaddress",
            "type": "string"
          },
          {
            "description": "the guest MAC address for the router",
            "name": "guestmacaddress",
            "type": "string"
          },
          {
            "description": "the account associated with the router",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the ID of the service offering of the virtual machine",
            "name": "serviceofferingid",
            "type": "string"
          },
          {
            "description": "the guest IP address for the router",
            "name": "guestipaddress",
            "type": "string"
          },
          {
            "description": "the link local IP address for the router",
            "name": "linklocalip",
            "type": "string"
          },
          {
            "description": "the name of the service offering of the virtual machine",
            "name": "serviceofferingname",
            "type": "string"
          },
          {
            "description": "the Zone name for the router",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the template ID for the router",
            "name": "templateid",
            "type": "string"
          },
          {
            "description": "the public netmask for the router",
            "name": "publicnetmask",
            "type": "string"
          },
          {
            "description": "the list of nics associated with the router",
            "name": "nic",
            "response": [
              {
                "description": "true if nic is default, false otherwise",
                "name": "isdefault",
                "type": "boolean"
              },
              {
                "description": "device id for the network when plugged into the virtual machine",
                "name": "deviceid",
                "type": "string"
              },
              {
                "description": "the isolation uri of the nic",
                "name": "isolationuri",
                "type": "string"
              },
              {
                "description": "the type of the nic",
                "name": "type",
                "type": "string"
              },
              {
                "description": "the netmask of the nic",
                "name": "netmask",
                "type": "string"
              },
              {
                "description": "the cidr of IPv6 network",
                "name": "ip6cidr",
                "type": "string"
              },
              {
                "description": "the Secondary ipv4 addr of nic",
                "name": "secondaryip",
                "type": "list"
              },
              {
                "description": "the broadcast uri of the nic",
                "name": "broadcasturi",
                "type": "string"
              },
              {
                "description": "the ID of the corresponding network",
                "name": "networkid",
                "type": "string"
              },
              {
                "description": "true if nic is default, false otherwise",
                "name": "macaddress",
                "type": "string"
              },
              {
                "description": "the ip address of the nic",
                "name": "ipaddress",
                "type": "string"
              },
              {
                "description": "the IPv6 address of network",
                "name": "ip6address",
                "type": "string"
              },
              {
                "description": "the gateway of IPv6 network",
                "name": "ip6gateway",
                "type": "string"
              },
              {
                "description": "the ID of the nic",
                "name": "id",
                "type": "string"
              },
              {
                "description": "the name of the corresponding network",
                "name": "networkname",
                "type": "string"
              },
              {
                "description": "the gateway of the nic",
                "name": "gateway",
                "type": "string"
              },
              {
                "description": "the traffic type of the nic",
                "name": "traffictype",
                "type": "string"
              },
              {
                "description": "Id of the vm to which the nic belongs",
                "name": "virtualmachineid",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "the second DNS for the router",
            "name": "dns2",
            "type": "string"
          },
          {
            "description": "the state of the router",
            "name": "state",
            "type": "state"
          },
          {
            "description": "the name of VPC the router belongs to",
            "name": "vpcname",
            "type": "string"
          },
          {
            "description": "the project name of the address",
            "name": "project",
            "type": "string"
          },
          {
            "description": "the name of the router",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the Zone ID for the router",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the link local netmask for the router",
            "name": "linklocalnetmask",
            "type": "string"
          },
          {
            "description": "if this router is an redundant virtual router",
            "name": "isredundantrouter",
            "type": "boolean"
          },
          {
            "description": "the host ID for the router",
            "name": "hostid",
            "type": "string"
          },
          {
            "description": "the date and time the router was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "role of the domain router",
            "name": "role",
            "type": "string"
          },
          {
            "description": "the hostname for the router",
            "name": "hostname",
            "type": "string"
          },
          {
            "description": "the link local MAC address for the router",
            "name": "linklocalmacaddress",
            "type": "string"
          },
          {
            "description": "the first IPv6 DNS for the router",
            "name": "ip6dns1",
            "type": "string"
          },
          {
            "description": "true if the router template requires upgrader",
            "name": "requiresupgrade",
            "type": "boolean"
          },
          {
            "description": "the gateway for the router",
            "name": "gateway",
            "type": "string"
          },
          {
            "description": "the ID of the corresponding guest network",
            "name": "guestnetworkid",
            "type": "string"
          },
          {
            "description": "the domain ID associated with the router",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the ID of the corresponding public network",
            "name": "publicnetworkid",
            "type": "string"
          },
          {
            "description": "the guest netmask for the router",
            "name": "guestnetmask",
            "type": "string"
          },
          {
            "description": "the name of the corresponding guest network",
            "name": "guestnetworkname",
            "type": "string"
          },
          {
            "description": "VPC the router belongs to",
            "name": "vpcid",
            "type": "string"
          }
        ]
      },
      {
        "description": "Creates a domain",
        "isasync": false,
        "name": "createDomain",
        "params": [
          {
            "description": "Domain UUID, required for adding domain from another Region",
            "length": 255,
            "name": "domainid",
            "required": false,
            "type": "string"
          },
          {
            "description": "creates domain with this name",
            "length": 255,
            "name": "name",
            "required": true,
            "type": "string"
          },
          {
            "description": "assigns new domain a parent domain by domain ID of the parent.  If no parent domain is specied, the ROOT domain is assumed.",
            "length": 255,
            "name": "parentdomainid",
            "related": "listDomains,listDomainChildren,listDomains,createDomain",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "Network domain for networks in the domain",
            "length": 255,
            "name": "networkdomain",
            "required": false,
            "type": "string"
          }
        ],
        "related": "listDomains,listDomainChildren,listDomains",
        "response": [
          {
            "description": "the total number of public ip addresses this domain can acquire",
            "name": "iplimit",
            "type": "string"
          },
          {
            "description": "the total volume being used by this domain",
            "name": "volumetotal",
            "type": "long"
          },
          {
            "description": "the total number of vpcs available to be created for this domain",
            "name": "vpcavailable",
            "type": "string"
          },
          {
            "description": "the total primary storage space (in GiB) owned by domain",
            "name": "primarystoragetotal",
            "type": "long"
          },
          {
            "description": "the ID of the domain",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the network domain",
            "name": "networkdomain",
            "type": "string"
          },
          {
            "description": "the total number of networks available to be created for this domain",
            "name": "networkavailable",
            "type": "string"
          },
          {
            "description": "the total volume which can be used by this domain",
            "name": "volumelimit",
            "type": "string"
          },
          {
            "description": "the domain ID of the parent domain",
            "name": "parentdomainid",
            "type": "string"
          },
          {
            "description": "the total number of virtual machines available for this domain to acquire",
            "name": "vmavailable",
            "type": "string"
          },
          {
            "description": "the total number of snapshots available for this domain",
            "name": "snapshotavailable",
            "type": "string"
          },
          {
            "description": "the total number of projects being administrated by this domain",
            "name": "projecttotal",
            "type": "long"
          },
          {
            "description": "the total number of snapshots stored by this domain",
            "name": "snapshottotal",
            "type": "long"
          },
          {
            "description": "the total number of vpcs owned by domain",
            "name": "vpctotal",
            "type": "long"
          },
          {
            "description": "the total volume available for this domain",
            "name": "volumeavailable",
            "type": "string"
          },
          {
            "description": "the total number of cpu cores available to be created for this domain",
            "name": "cpuavailable",
            "type": "string"
          },
          {
            "description": "the path of the domain",
            "name": "path",
            "type": "string"
          },
          {
            "description": "the name of the domain",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the total number of vpcs the domain can own",
            "name": "vpclimit",
            "type": "string"
          },
          {
            "description": "the total memory (in MB) owned by domain",
            "name": "memorytotal",
            "type": "long"
          },
          {
            "description": "the total primary storage space (in GiB) available to be used for this domain",
            "name": "primarystorageavailable",
            "type": "string"
          },
          {
            "description": "the total secondary storage space (in GiB) available to be used for this domain",
            "name": "secondarystorageavailable",
            "type": "string"
          },
          {
            "description": "the total number of public ip addresses allocated for this domain",
            "name": "iptotal",
            "type": "long"
          },
          {
            "description": "the total number of projects the domain can own",
            "name": "projectlimit",
            "type": "string"
          },
          {
            "description": "the total number of networks the domain can own",
            "name": "networklimit",
            "type": "string"
          },
          {
            "description": "the total primary storage space (in GiB) the domain can own",
            "name": "primarystoragelimit",
            "type": "string"
          },
          {
            "description": "the total secondary storage space (in GiB) the domain can own",
            "name": "secondarystoragelimit",
            "type": "string"
          },
          {
            "description": "the total number of projects available for administration by this domain",
            "name": "projectavailable",
            "type": "string"
          },
          {
            "description": "the total number of virtual machines that can be deployed by this domain",
            "name": "vmlimit",
            "type": "string"
          },
          {
            "description": "the total number of virtual machines deployed by this domain",
            "name": "vmtotal",
            "type": "long"
          },
          {
            "description": "the level of the domain",
            "name": "level",
            "type": "integer"
          },
          {
            "description": "the total number of snapshots which can be stored by this domain",
            "name": "snapshotlimit",
            "type": "string"
          },
          {
            "description": "the total number of templates which have been created by this domain",
            "name": "templatetotal",
            "type": "long"
          },
          {
            "description": "the total number of networks owned by domain",
            "name": "networktotal",
            "type": "long"
          },
          {
            "description": "the state of the domain",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the total number of cpu cores owned by domain",
            "name": "cputotal",
            "type": "long"
          },
          {
            "description": "whether the domain has one or more sub-domains",
            "name": "haschild",
            "type": "boolean"
          },
          {
            "description": "the total number of templates available to be created by this domain",
            "name": "templateavailable",
            "type": "string"
          },
          {
            "description": "the total memory (in MB) the domain can own",
            "name": "memorylimit",
            "type": "string"
          },
          {
            "description": "the total number of public ip addresses available for this domain to acquire",
            "name": "ipavailable",
            "type": "string"
          },
          {
            "description": "the total number of cpu cores the domain can own",
            "name": "cpulimit",
            "type": "string"
          },
          {
            "description": "the total secondary storage space (in GiB) owned by domain",
            "name": "secondarystoragetotal",
            "type": "long"
          },
          {
            "description": "the total number of templates which can be created by this domain",
            "name": "templatelimit",
            "type": "string"
          },
          {
            "description": "the domain name of the parent domain",
            "name": "parentdomainname",
            "type": "string"
          },
          {
            "description": "the total memory (in MB) available to be created for this domain",
            "name": "memoryavailable",
            "type": "string"
          }
        ]
      },
      {
        "description": "Deleting resource tag(s)",
        "isasync": true,
        "name": "deleteTags",
        "params": [
          {
            "description": "Delete tags matching key/value pairs",
            "length": 255,
            "name": "tags",
            "required": false,
            "type": "map"
          },
          {
            "description": "Delete tag by resource type",
            "length": 255,
            "name": "resourcetype",
            "required": true,
            "type": "string"
          },
          {
            "description": "Delete tags for resource id(s)",
            "length": 255,
            "name": "resourceids",
            "required": true,
            "type": "list"
          }
        ],
        "response": [
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          }
        ],
        "since": "4.0.0"
      },
      {
        "description": "Restarts the network; includes 1) restarting network elements - virtual routers, DHCP servers 2) reapplying all public IPs 3) reapplying loadBalancing/portForwarding rules",
        "isasync": true,
        "name": "restartNetwork",
        "params": [
          {
            "description": "The ID of the network to restart.",
            "length": 255,
            "name": "id",
            "related": "createNetwork,listNetscalerLoadBalancerNetworks,listPaloAltoFirewallNetworks,listNiciraNvpDeviceNetworks,listNetworks,updateNetwork,updateNetwork,createNetwork",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "If cleanup old network elements",
            "length": 255,
            "name": "cleanup",
            "required": false,
            "type": "boolean"
          }
        ],
        "related": "associateIpAddress,updateIpAddress,listPublicIpAddresses,associateIpAddress",
        "response": [
          {
            "description": "public IP address id",
            "name": "id",
            "type": "string"
          },
          {
            "description": "is public ip for display to the regular user",
            "name": "fordisplay",
            "type": "boolean"
          },
          {
            "description": "the name of the Network associated with the IP address",
            "name": "associatednetworkname",
            "type": "string"
          },
          {
            "description": "the name of the zone the public IP address belongs to",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "virutal machine id the ip address is assigned to (not null only for static nat Ip)",
            "name": "virtualmachineid",
            "type": "string"
          },
          {
            "description": "virutal machine display name the ip address is assigned to (not null only for static nat Ip)",
            "name": "virtualmachinedisplayname",
            "type": "string"
          },
          {
            "description": "the ID of the VLAN associated with the IP address. This parameter is visible to ROOT admins only",
            "name": "vlanid",
            "type": "string"
          },
          {
            "description": "the account the public IP address is associated with",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the project name of the address",
            "name": "project",
            "type": "string"
          },
          {
            "description": "the domain the public IP address is associated with",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "date the public IP address was acquired",
            "name": "allocated",
            "type": "date"
          },
          {
            "description": "true if this ip is for static nat, false otherwise",
            "name": "isstaticnat",
            "type": "boolean"
          },
          {
            "description": "the VLAN associated with the IP address",
            "name": "vlanname",
            "type": "string"
          },
          {
            "description": "the virtual network for the IP address",
            "name": "forvirtualnetwork",
            "type": "boolean"
          },
          {
            "description": "State of the ip address. Can be: Allocatin, Allocated and Releasing",
            "name": "state",
            "type": "string"
          },
          {
            "description": "public IP address",
            "name": "ipaddress",
            "type": "string"
          },
          {
            "description": "purpose of the IP address. In Acton this value is not null for Ips with isSystem=true, and can have either StaticNat or LB value",
            "name": "purpose",
            "type": "string"
          },
          {
            "description": "the ID of the zone the public IP address belongs to",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "VPC the ip belongs to",
            "name": "vpcid",
            "type": "string"
          },
          {
            "description": "virutal machine name the ip address is assigned to (not null only for static nat Ip)",
            "name": "virtualmachinename",
            "type": "string"
          },
          {
            "description": "the list of resource tags associated with ip address",
            "name": "tags",
            "response": [
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              }
            ],
            "type": "list"
          },
          {
            "description": "virutal machine (dnat) ip address (not null only for static nat Ip)",
            "name": "vmipaddress",
            "type": "string"
          },
          {
            "description": "the project id of the ipaddress",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the ID of the Network associated with the IP address",
            "name": "associatednetworkid",
            "type": "string"
          },
          {
            "description": "the physical network this belongs to",
            "name": "physicalnetworkid",
            "type": "string"
          },
          {
            "description": "the domain ID the public IP address is associated with",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the ID of the Network where ip belongs to",
            "name": "networkid",
            "type": "string"
          },
          {
            "description": "is public IP portable across the zones",
            "name": "isportable",
            "type": "boolean"
          },
          {
            "description": "true if the IP address is a source nat address, false otherwise",
            "name": "issourcenat",
            "type": "boolean"
          },
          {
            "description": "true if this ip is system ip (was allocated as a part of deployVm or createLbRule)",
            "name": "issystem",
            "type": "boolean"
          }
        ]
      },
      {
        "description": "Logs a user into the CloudStack. A successful login attempt will generate a JSESSIONID cookie value that can be passed in subsequent Query command calls until the \"logout\" command has been issued or the session has expired.",
        "isasync": false,
        "name": "login",
        "params": [
          {
            "description": "Username",
            "length": 255,
            "name": "username",
            "required": true,
            "type": "string"
          },
          {
            "description": "Path of the domain that the user belongs to. Example: domain=/com/cloud/internal. If no domain is passed in, the ROOT (/) domain is assumed.",
            "length": 255,
            "name": "domain",
            "required": false,
            "type": "string"
          },
          {
            "description": "The id of the domain that the user belongs to. If both domain and domainId are passed in, \"domainId\" parameter takes precendence",
            "length": 255,
            "name": "domainId",
            "required": false,
            "type": "long"
          },
          {
            "description": "Hashed password (Default is MD5). If you wish to use any other hashing algorithm, you would need to write a custom authentication adapter See Docs section.",
            "length": 255,
            "name": "password",
            "required": true,
            "type": "string"
          }
        ],
        "related": "",
        "response": [
          {
            "description": "the account name the user belongs to",
            "name": "account",
            "type": "string"
          },
          {
            "description": "Session key that can be passed in subsequent Query command calls",
            "name": "sessionkey",
            "type": "string"
          },
          {
            "description": "first name of the user",
            "name": "firstname",
            "type": "string"
          },
          {
            "description": "the time period before the session has expired",
            "name": "timeout",
            "type": "integer"
          },
          {
            "description": "user time zone",
            "name": "timezone",
            "type": "string"
          },
          {
            "description": "the account type (admin, domain-admin, read-only-admin, user)",
            "name": "type",
            "type": "string"
          },
          {
            "description": "Is user registered",
            "name": "registered",
            "type": "string"
          },
          {
            "description": "User ID",
            "name": "userid",
            "type": "string"
          },
          {
            "description": "Username",
            "name": "username",
            "type": "string"
          },
          {
            "description": "Domain ID that the user belongs to",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "last name of the user",
            "name": "lastname",
            "type": "string"
          }
        ]
      },
      {
        "description": "Lists all hypervisor capabilities.",
        "isasync": false,
        "name": "listHypervisorCapabilities",
        "params": [
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "the hypervisor for which to restrict the search",
            "length": 255,
            "name": "hypervisor",
            "required": false,
            "type": "string"
          },
          {
            "description": "ID of the hypervisor capability",
            "length": 255,
            "name": "id",
            "related": "listHypervisorCapabilities",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          }
        ],
        "related": "",
        "response": [
          {
            "description": "the maximum number of guest vms recommended for this hypervisor",
            "name": "maxguestslimit",
            "type": "long"
          },
          {
            "description": "true if security group is supported",
            "name": "securitygroupenabled",
            "type": "boolean"
          },
          {
            "description": "the maximum number of Data Volumes that can be attached for this hypervisor",
            "name": "maxdatavolumeslimit",
            "type": "integer"
          },
          {
            "description": "the hypervisor type",
            "name": "hypervisor",
            "type": "hypervisortype"
          },
          {
            "description": "the hypervisor version",
            "name": "hypervisorversion",
            "type": "string"
          },
          {
            "description": "the maximum number of Hosts per cluster for this hypervisor",
            "name": "maxhostspercluster",
            "type": "integer"
          },
          {
            "description": "the ID of the hypervisor capabilities row",
            "name": "id",
            "type": "string"
          },
          {
            "description": "true if storage motion is supported",
            "name": "storagemotionenabled",
            "type": "boolean"
          }
        ],
        "since": "3.0.0"
      },
      {
        "description": "Adds backup image store.",
        "isasync": false,
        "name": "addImageStore",
        "params": [
          {
            "description": "the details for the image store. Example: details[0].key=accesskey&details[0].value=s389ddssaa&details[1].key=secretkey&details[1].value=8dshfsss",
            "length": 255,
            "name": "details",
            "required": false,
            "type": "map"
          },
          {
            "description": "the Zone ID for the image store",
            "length": 255,
            "name": "zoneid",
            "related": "createZone,updateZone,listZones,listZones",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "the image store provider name",
            "length": 255,
            "name": "provider",
            "required": true,
            "type": "string"
          },
          {
            "description": "the name for the image store",
            "length": 255,
            "name": "name",
            "required": false,
            "type": "string"
          },
          {
            "description": "the URL for the image store",
            "length": 255,
            "name": "url",
            "required": false,
            "type": "string"
          }
        ],
        "related": "addSecondaryStorage,listImageStores,updateCloudToUseObjectStore,listSwifts,addImageStoreS3",
        "response": [
          {
            "description": "the scope of the image store",
            "name": "scope",
            "type": "scopetype"
          },
          {
            "description": "the Zone ID of the image store",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the provider name of the image store",
            "name": "providername",
            "type": "string"
          },
          {
            "description": "the name of the image store",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the ID of the image store",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the protocol of the image store",
            "name": "protocol",
            "type": "string"
          },
          {
            "description": "the Zone name of the image store",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the details of the image store",
            "name": "details",
            "type": "set"
          },
          {
            "description": "the url of the image store",
            "name": "url",
            "type": "string"
          }
        ],
        "since": "4.2.0"
      },
      {
        "description": "Get SolidFire Account ID",
        "isasync": false,
        "name": "getSolidFireAccountId",
        "params": [
          {
            "description": "Storage Pool UUID",
            "length": 255,
            "name": "storageid",
            "required": true,
            "type": "string"
          },
          {
            "description": "CloudStack Account UUID",
            "length": 255,
            "name": "accountid",
            "required": true,
            "type": "string"
          }
        ],
        "related": "",
        "response": [
          {
            "description": "SolidFire Account ID",
            "name": "solidFireAccountId",
            "type": "long"
          }
        ]
      },
      {
        "description": "Lists all network services provided by CloudStack or for the given Provider.",
        "isasync": false,
        "name": "listSupportedNetworkServices",
        "params": [
          {
            "description": "network service provider name",
            "length": 255,
            "name": "provider",
            "required": false,
            "type": "string"
          },
          {
            "description": "network service name to list providers and capabilities of",
            "length": 255,
            "name": "service",
            "required": false,
            "type": "string"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          }
        ],
        "related": "",
        "response": [
          {
            "description": "the list of capabilities",
            "name": "capability",
            "response": [
              {
                "description": "can this service capability value can be choosable while creatine network offerings",
                "name": "canchooseservicecapability",
                "type": "boolean"
              },
              {
                "description": "the capability name",
                "name": "name",
                "type": "string"
              },
              {
                "description": "the capability value",
                "name": "value",
                "type": "string"
              }
            ],
            "type": "list"
          },
          {
            "description": "the service provider name",
            "name": "provider",
            "response": [
              {
                "description": "the provider name",
                "name": "name",
                "type": "string"
              },
              {
                "description": "true if individual services can be enabled/disabled",
                "name": "canenableindividualservice",
                "type": "boolean"
              },
              {
                "description": "the destination physical network",
                "name": "destinationphysicalnetworkid",
                "type": "string"
              },
              {
                "description": "uuid of the network provider",
                "name": "id",
                "type": "string"
              },
              {
                "description": "services for this provider",
                "name": "servicelist",
                "type": "list"
              },
              {
                "description": "the physical network this belongs to",
                "name": "physicalnetworkid",
                "type": "string"
              },
              {
                "description": "state of the network provider",
                "name": "state",
                "type": "string"
              }
            ],
            "type": "list"
          },
          {
            "description": "the service name",
            "name": "name",
            "type": "string"
          }
        ],
        "since": "3.0.0"
      },
      {
        "description": "Deletes a particular ingress rule from this security group",
        "isasync": true,
        "name": "revokeSecurityGroupIngress",
        "params": [
          {
            "description": "The ID of the ingress rule",
            "length": 255,
            "name": "id",
            "related": "authorizeSecurityGroupIngress",
            "required": true,
            "type": "uuid"
          }
        ],
        "response": [
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          }
        ]
      },
      {
        "description": "Lists dedicated guest vlan ranges",
        "isasync": false,
        "name": "listDedicatedGuestVlanRanges",
        "params": [
          {
            "description": "zone of the guest VLAN range",
            "length": 255,
            "name": "zoneid",
            "related": "createZone,updateZone,listZones,listZones",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "the domain ID with which the guest VLAN range is associated.  If used with the account parameter, returns all guest VLAN ranges for that account in the specified domain.",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "the account with which the guest VLAN range is associated. Must be used with the domainId parameter.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "the dedicated guest vlan range",
            "length": 255,
            "name": "guestvlanrange",
            "required": false,
            "type": "string"
          },
          {
            "description": "physical network id of the guest VLAN range",
            "length": 255,
            "name": "physicalnetworkid",
            "related": "createPhysicalNetwork",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "list dedicated guest vlan ranges by id",
            "length": 255,
            "name": "id",
            "related": "listDedicatedGuestVlanRanges",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "project who will own the guest VLAN range",
            "length": 255,
            "name": "projectid",
            "related": "activateProject,updateProject,suspendProject,listProjectAccounts,listProjects",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          }
        ],
        "related": "",
        "response": [
          {
            "description": "the project id of the guest vlan range",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the project name of the guest vlan range",
            "name": "project",
            "type": "string"
          },
          {
            "description": "the ID of the guest VLAN range",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the domain name of the guest VLAN range",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the domain ID of the guest VLAN range",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the zone of the guest vlan range",
            "name": "zoneid",
            "type": "long"
          },
          {
            "description": "the physical network of the guest vlan range",
            "name": "physicalnetworkid",
            "type": "long"
          },
          {
            "description": "the guest VLAN range",
            "name": "guestvlanrange",
            "type": "string"
          },
          {
            "description": "the account of the guest VLAN range",
            "name": "account",
            "type": "string"
          }
        ]
      },
      {
        "description": "Adds a network serviceProvider to a physical network",
        "isasync": true,
        "name": "addNetworkServiceProvider",
        "params": [
          {
            "description": "the list of services to be enabled for this physical network service provider",
            "length": 255,
            "name": "servicelist",
            "required": false,
            "type": "list"
          },
          {
            "description": "the destination Physical Network ID to bridge to",
            "length": 255,
            "name": "destinationphysicalnetworkid",
            "related": "createPhysicalNetwork",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "the Physical Network ID to add the provider to",
            "length": 255,
            "name": "physicalnetworkid",
            "related": "createPhysicalNetwork",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "the name for the physical network service provider",
            "length": 255,
            "name": "name",
            "required": true,
            "type": "string"
          }
        ],
        "related": "listTrafficTypes,listNetworkServiceProviders",
        "response": [
          {
            "description": "the destination physical network",
            "name": "destinationphysicalnetworkid",
            "type": "string"
          },
          {
            "description": "the physical network this belongs to",
            "name": "physicalnetworkid",
            "type": "string"
          },
          {
            "description": "state of the network provider",
            "name": "state",
            "type": "string"
          },
          {
            "description": "uuid of the network provider",
            "name": "id",
            "type": "string"
          },
          {
            "description": "true if individual services can be enabled/disabled",
            "name": "canenableindividualservice",
            "type": "boolean"
          },
          {
            "description": "the provider name",
            "name": "name",
            "type": "string"
          },
          {
            "description": "services for this provider",
            "name": "servicelist",
            "type": "list"
          }
        ],
        "since": "3.0.0"
      },
      {
        "description": "Lists all network ACL items",
        "isasync": false,
        "name": "listNetworkACLs",
        "params": [
          {
            "description": "list network ACL items by ACL ID",
            "length": 255,
            "name": "aclid",
            "related": "listNetworkACLLists,createNetworkACLList",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false",
            "length": 255,
            "name": "listall",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "list network ACL items by action",
            "length": 255,
            "name": "action",
            "required": false,
            "type": "string"
          },
          {
            "description": "list network ACL items by protocol",
            "length": 255,
            "name": "protocol",
            "required": false,
            "type": "string"
          },
          {
            "description": "List resources by tags (key/value pairs)",
            "length": 255,
            "name": "tags",
            "required": false,
            "type": "map"
          },
          {
            "description": "list network ACL items by traffic type - ingress or egress",
            "length": 255,
            "name": "traffictype",
            "required": false,
            "type": "string"
          },
          {
            "description": "list network ACL items by network ID",
            "length": 255,
            "name": "networkid",
            "related": "createNetwork,listNetscalerLoadBalancerNetworks,listPaloAltoFirewallNetworks,listNiciraNvpDeviceNetworks,listNetworks,updateNetwork,updateNetwork,createNetwork",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "list resources by display flag; only ROOT admin is eligible to pass this parameter",
            "length": 255,
            "name": "fordisplay",
            "required": false,
            "since": "4.4",
            "type": "boolean"
          },
          {
            "description": "list resources by account. Must be used with the domainId parameter.",
            "length": 255,
            "name": "account",
            "required": false,
            "type": "string"
          },
          {
            "description": "defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.",
            "length": 255,
            "name": "isrecursive",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "list only resources belonging to the domain specified",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "Lists network ACL Item with the specified ID",
            "length": 255,
            "name": "id",
            "related": "listNetworkACLs,createNetworkACL,updateNetworkACLItem",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "list objects by project",
            "length": 255,
            "name": "projectid",
            "related": "activateProject,updateProject,suspendProject,listProjectAccounts,listProjects",
            "required": false,
            "type": "uuid"
          }
        ],
        "related": "createNetworkACL,updateNetworkACLItem",
        "response": [
          {
            "description": "the ending port of ACL's port range",
            "name": "endport",
            "type": "string"
          },
          {
            "description": "the cidr list to forward traffic from",
            "name": "cidrlist",
            "type": "string"
          },
          {
            "description": "error code for this icmp message",
            "name": "icmpcode",
            "type": "integer"
          },
          {
            "description": "Number of the ACL Item",
            "name": "number",
            "type": "integer"
          },
          {
            "description": "Action of ACL Item. Allow/Deny",
            "name": "action",
            "type": "string"
          },
          {
            "description": "the starting port of ACL's port range",
            "name": "startport",
            "type": "string"
          },
          {
            "description": "the ID of the ACL Item",
            "name": "id",
            "type": "string"
          },
          {
            "description": "is rule for display to the regular user",
            "name": "fordisplay",
            "type": "boolean"
          },
          {
            "description": "type of the icmp message being sent",
            "name": "icmptype",
            "type": "integer"
          },
          {
            "description": "the state of the rule",
            "name": "state",
            "type": "string"
          },
          {
            "description": "the protocol of the ACL",
            "name": "protocol",
            "type": "string"
          },
          {
            "description": "the traffic type for the ACL",
            "name": "traffictype",
            "type": "string"
          },
          {
            "description": "the list of resource tags associated with the network ACLs",
            "name": "tags",
            "response": [
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              },
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              }
            ],
            "type": "list"
          },
          {
            "description": "the ID of the ACL this item belongs to",
            "name": "aclid",
            "type": "string"
          }
        ]
      },
      {
        "description": "Delete site to site vpn gateway",
        "isasync": true,
        "name": "deleteVpnGateway",
        "params": [
          {
            "description": "id of customer gateway",
            "length": 255,
            "name": "id",
            "related": "updateVpnGateway,createVpnGateway,listVpnGateways",
            "required": true,
            "type": "uuid"
          }
        ],
        "response": [
          {
            "description": "true if operation is executed successfully",
            "name": "success",
            "type": "boolean"
          },
          {
            "description": "any text associated with the success or failure",
            "name": "displaytext",
            "type": "string"
          }
        ]
      },
      {
        "description": "Copies a template from one zone to another.",
        "isasync": true,
        "name": "copyTemplate",
        "params": [
          {
            "description": "ID of the zone the template is currently hosted on. If not specified and template is cross-zone, then we will sync this template to region wide image store.",
            "length": 255,
            "name": "sourcezoneid",
            "related": "createZone,updateZone,listZones,listZones",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "ID of the zone the template is being copied to.",
            "length": 255,
            "name": "destzoneid",
            "related": "createZone,updateZone,listZones,listZones",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "Template ID.",
            "length": 255,
            "name": "id",
            "related": "listIsos,registerIso,updateTemplate,copyTemplate,registerTemplate,registerTemplate,listTemplates,createTemplate,registerIso,createTemplate,copyTemplate,listIsos,copyIso",
            "required": true,
            "type": "uuid"
          }
        ],
        "related": "listIsos,registerIso,updateTemplate,registerTemplate,registerTemplate,listTemplates,createTemplate,registerIso,createTemplate,copyTemplate,listIsos,copyIso",
        "response": [
          {
            "description": "the ID of the secondary storage host for the template",
            "name": "hostid",
            "type": "string"
          },
          {
            "description": "additional key/value details tied with template",
            "name": "details",
            "type": "map"
          },
          {
            "description": "true if the ISO is bootable, false otherwise",
            "name": "bootable",
            "type": "boolean"
          },
          {
            "description": "true if this template is a public template, false otherwise",
            "name": "ispublic",
            "type": "boolean"
          },
          {
            "description": "the date this template was removed",
            "name": "removed",
            "type": "date"
          },
          {
            "description": "the name of the zone for this template",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the template ID of the parent template if present",
            "name": "sourcetemplateid",
            "type": "string"
          },
          {
            "description": "true if the template is extractable, false otherwise",
            "name": "isextractable",
            "type": "boolean"
          },
          {
            "description": "true if this template is a featured template, false otherwise",
            "name": "isfeatured",
            "type": "boolean"
          },
          {
            "description": "the ID of the zone for this template",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the date this template was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "true if the template is managed across all Zones, false otherwise",
            "name": "crossZones",
            "type": "boolean"
          },
          {
            "description": "the name of the domain to which the template belongs",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "true if the template is ready to be deployed from, false otherwise.",
            "name": "isready",
            "type": "boolean"
          },
          {
            "description": "the account name to which the template belongs",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the size of the template",
            "name": "size",
            "type": "long"
          },
          {
            "description": "true if template contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory",
            "name": "isdynamicallyscalable",
            "type": "boolean"
          },
          {
            "description": "the project id of the template",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the account id to which the template belongs",
            "name": "accountid",
            "type": "string"
          },
          {
            "description": "the template ID",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the project name of the template",
            "name": "project",
            "type": "string"
          },
          {
            "description": "the name of the OS type for this template.",
            "name": "ostypename",
            "type": "string"
          },
          {
            "description": "the list of resource tags associated with tempate",
            "name": "tags",
            "response": [
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              },
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "the template name",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the ID of the OS type for this template.",
            "name": "ostypeid",
            "type": "string"
          },
          {
            "description": "the status of the template",
            "name": "status",
            "type": "string"
          },
          {
            "description": "checksum of the template",
            "name": "checksum",
            "type": "string"
          },
          {
            "description": "the template display text",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "true if the reset password feature is enabled, false otherwise",
            "name": "passwordenabled",
            "type": "boolean"
          },
          {
            "description": "the format of the template.",
            "name": "format",
            "type": "imageformat"
          },
          {
            "description": "true if template is sshkey enabled, false otherwise",
            "name": "sshkeyenabled",
            "type": "boolean"
          },
          {
            "description": "the tag of this template",
            "name": "templatetag",
            "type": "string"
          },
          {
            "description": "the ID of the domain to which the template belongs",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the type of the template",
            "name": "templatetype",
            "type": "string"
          },
          {
            "description": "the name of the secondary storage host for the template",
            "name": "hostname",
            "type": "string"
          },
          {
            "description": "the hypervisor on which the template runs",
            "name": "hypervisor",
            "type": "string"
          }
        ]
      },
      {
        "description": "Creates a service offering.",
        "isasync": false,
        "name": "createServiceOffering",
        "params": [
          {
            "description": "Hypervisor snapshot reserve space as a percent of a volume (for managed storage using Xen or VMware)",
            "length": 255,
            "name": "hypervisorsnapshotreserve",
            "required": false,
            "since": "4.4",
            "type": "integer"
          },
          {
            "description": "is this a system vm offering",
            "length": 255,
            "name": "issystem",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "details for planner, used to store specific parameters",
            "length": 255,
            "name": "serviceofferingdetails",
            "required": false,
            "type": "map"
          },
          {
            "description": "the tags for this service offering.",
            "length": 255,
            "name": "tags",
            "required": false,
            "type": "string"
          },
          {
            "description": "bytes read rate of the disk offering",
            "length": 255,
            "name": "bytesreadrate",
            "required": false,
            "type": "long"
          },
          {
            "description": "the total memory of the service offering in MB",
            "length": 255,
            "name": "memory",
            "required": false,
            "type": "integer"
          },
          {
            "description": "the storage type of the service offering. Values are local and shared.",
            "length": 255,
            "name": "storagetype",
            "required": false,
            "type": "string"
          },
          {
            "description": "provisioning type used to create volumes. Valid values are thin, sparse, fat.",
            "length": 255,
            "name": "provisioningtype",
            "required": false,
            "type": "string"
          },
          {
            "description": "bytes write rate of the disk offering",
            "length": 255,
            "name": "byteswriterate",
            "required": false,
            "type": "long"
          },
          {
            "description": "io requests write rate of the disk offering",
            "length": 255,
            "name": "iopswriterate",
            "required": false,
            "type": "long"
          },
          {
            "description": "the name of the service offering",
            "length": 255,
            "name": "name",
            "required": true,
            "type": "string"
          },
          {
            "description": "the CPU speed of the service offering in MHz.",
            "length": 255,
            "name": "cpuspeed",
            "required": false,
            "type": "integer"
          },
          {
            "description": "the host tag for this service offering.",
            "length": 255,
            "name": "hosttags",
            "required": false,
            "type": "string"
          },
          {
            "description": "the HA for the service offering",
            "length": 255,
            "name": "offerha",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "the display text of the service offering",
            "length": 255,
            "name": "displaytext",
            "required": true,
            "type": "string"
          },
          {
            "description": "the ID of the containing domain, null for public offerings",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains",
            "required": false,
            "type": "uuid"
          },
          {
            "description": "the CPU number of the service offering",
            "length": 255,
            "name": "cpunumber",
            "required": false,
            "type": "integer"
          },
          {
            "description": "true if the virtual machine needs to be volatile so that on every reboot of VM, original root disk is dettached then destroyed and a fresh root disk is created and attached to VM",
            "length": 255,
            "name": "isvolatile",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "whether compute offering iops is custom or not",
            "length": 255,
            "name": "customizediops",
            "required": false,
            "since": "4.4",
            "type": "boolean"
          },
          {
            "description": "min iops of the compute offering",
            "length": 255,
            "name": "miniops",
            "required": false,
            "since": "4.4",
            "type": "long"
          },
          {
            "description": "The deployment planner heuristics used to deploy a VM of this offering. If null, value of global config vm.deployment.planner is used",
            "length": 255,
            "name": "deploymentplanner",
            "required": false,
            "type": "string"
          },
          {
            "description": "io requests read rate of the disk offering",
            "length": 255,
            "name": "iopsreadrate",
            "required": false,
            "type": "long"
          },
          {
            "description": "restrict the CPU usage to committed service offering",
            "length": 255,
            "name": "limitcpuuse",
            "required": false,
            "type": "boolean"
          },
          {
            "description": "the system VM type. Possible types are \"domainrouter\", \"consoleproxy\" and \"secondarystoragevm\".",
            "length": 255,
            "name": "systemvmtype",
            "required": false,
            "type": "string"
          },
          {
            "description": "max iops of the compute offering",
            "length": 255,
            "name": "maxiops",
            "required": false,
            "since": "4.4",
            "type": "long"
          },
          {
            "description": "data transfer rate in megabits per second allowed. Supported only for non-System offering and system offerings having \"domainrouter\" systemvmtype",
            "length": 255,
            "name": "networkrate",
            "required": false,
            "type": "integer"
          }
        ],
        "related": "updateServiceOffering,listServiceOfferings",
        "response": [
          {
            "description": "is this a the systemvm type for system vm offering",
            "name": "systemvmtype",
            "type": "string"
          },
          {
            "description": "true if disk offering uses custom iops, false otherwise",
            "name": "iscustomizediops",
            "type": "boolean"
          },
          {
            "description": "the max iops of the disk offering",
            "name": "maxiops",
            "type": "long"
          },
          {
            "description": "io requests read rate of the service offering",
            "name": "diskIopsReadRate",
            "type": "long"
          },
          {
            "description": "the clock rate CPU speed in Mhz",
            "name": "cpuspeed",
            "type": "integer"
          },
          {
            "description": "the id of the service offering",
            "name": "id",
            "type": "string"
          },
          {
            "description": "deployment strategy used to deploy VM.",
            "name": "deploymentplanner",
            "type": "string"
          },
          {
            "description": "the tags for the service offering",
            "name": "tags",
            "type": "string"
          },
          {
            "description": "is this a  default system vm offering",
            "name": "defaultuse",
            "type": "boolean"
          },
          {
            "description": "provisioning type used to create volumes. Valid values are thin, sparse, fat.",
            "name": "provisioningtype",
            "type": "string"
          },
          {
            "description": "the ha support in the service offering",
            "name": "offerha",
            "type": "boolean"
          },
          {
            "description": "the memory in MB",
            "name": "memory",
            "type": "integer"
          },
          {
            "description": "the domain id of the service offering",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "additional key/value details tied with this service offering",
            "name": "serviceofferingdetails",
            "type": "map"
          },
          {
            "description": "an alternate display text of the service offering.",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "the number of CPU",
            "name": "cpunumber",
            "type": "integer"
          },
          {
            "description": "the storage type for this service offering",
            "name": "storagetype",
            "type": "string"
          },
          {
            "description": "data transfer rate in megabits per second allowed.",
            "name": "networkrate",
            "type": "integer"
          },
          {
            "description": "true if the vm needs to be volatile, i.e., on every reboot of vm from API root disk is discarded and creates a new root disk",
            "name": "isvolatile",
            "type": "boolean"
          },
          {
            "description": "the min iops of the disk offering",
            "name": "miniops",
            "type": "long"
          },
          {
            "description": "is true if the offering is customized",
            "name": "iscustomized",
            "type": "boolean"
          },
          {
            "description": "is this a system vm offering",
            "name": "issystem",
            "type": "boolean"
          },
          {
            "description": "Domain name for the offering",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "the name of the service offering",
            "name": "name",
            "type": "string"
          },
          {
            "description": "restrict the CPU usage to committed service offering",
            "name": "limitcpuuse",
            "type": "boolean"
          },
          {
            "description": "bytes write rate of the service offering",
            "name": "diskBytesWriteRate",
            "type": "long"
          },
          {
            "description": "io requests write rate of the service offering",
            "name": "diskIopsWriteRate",
            "type": "long"
          },
          {
            "description": "Hypervisor snapshot reserve space as a percent of a volume (for managed storage using Xen or VMware)",
            "name": "hypervisorsnapshotreserve",
            "type": "integer"
          },
          {
            "description": "the date this service offering was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "the host tag for the service offering",
            "name": "hosttags",
            "type": "string"
          },
          {
            "description": "bytes read rate of the service offering",
            "name": "diskBytesReadRate",
            "type": "long"
          }
        ]
      },
      {
        "description": "lists network that are using a nicira nvp device",
        "isasync": false,
        "name": "listNiciraNvpDeviceNetworks",
        "params": [
          {
            "description": "",
            "length": 255,
            "name": "pagesize",
            "required": false,
            "type": "integer"
          },
          {
            "description": "List by keyword",
            "length": 255,
            "name": "keyword",
            "required": false,
            "type": "string"
          },
          {
            "description": "",
            "length": 255,
            "name": "page",
            "required": false,
            "type": "integer"
          },
          {
            "description": "nicira nvp device ID",
            "length": 255,
            "name": "nvpdeviceid",
            "related": "addNiciraNvpDevice,listNiciraNvpDevices",
            "required": true,
            "type": "uuid"
          }
        ],
        "related": "createNetwork,listNetscalerLoadBalancerNetworks,listPaloAltoFirewallNetworks,listNetworks,updateNetwork,updateNetwork,createNetwork",
        "response": [
          {
            "description": "network offering id the network is created from",
            "name": "networkofferingid",
            "type": "string"
          },
          {
            "description": "the second DNS for the network",
            "name": "dns2",
            "type": "string"
          },
          {
            "description": "true if network supports specifying ip ranges, false otherwise",
            "name": "specifyipranges",
            "type": "boolean"
          },
          {
            "description": "the domain name of the network owner",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "The vlan of the network. This parameter is visible to ROOT admins only",
            "name": "vlan",
            "type": "string"
          },
          {
            "description": "the owner of the network",
            "name": "account",
            "type": "string"
          },
          {
            "description": "the project name of the address",
            "name": "project",
            "type": "string"
          },
          {
            "description": "true if network is system, false otherwise",
            "name": "issystem",
            "type": "boolean"
          },
          {
            "description": "If a network is enabled for 'streched l2 subnet' then represents zones on which network currently spans",
            "name": "zonesnetworkspans",
            "type": "set"
          },
          {
            "description": "an optional field, whether to the display the network to the end user or not.",
            "name": "displaynetwork",
            "type": "boolean"
          },
          {
            "description": "the traffic type of the network",
            "name": "traffictype",
            "type": "string"
          },
          {
            "description": "the type of the network",
            "name": "type",
            "type": "string"
          },
          {
            "description": "true if network can span multiple zones",
            "name": "strechedl2subnet",
            "type": "boolean"
          },
          {
            "description": "related to what other network configuration",
            "name": "related",
            "type": "string"
          },
          {
            "description": "the list of resource tags associated with network",
            "name": "tags",
            "response": [
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              },
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              }
            ],
            "type": "list"
          },
          {
            "description": "the network CIDR of the guest network configured with IP reservation. It is the summation of CIDR and RESERVED_IP_RANGE",
            "name": "networkcidr",
            "type": "string"
          },
          {
            "description": "VPC the network belongs to",
            "name": "vpcid",
            "type": "string"
          },
          {
            "description": "the project id of the ipaddress",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the name of the network",
            "name": "name",
            "type": "string"
          },
          {
            "description": "the displaytext of the network",
            "name": "displaytext",
            "type": "string"
          },
          {
            "description": "the network domain",
            "name": "networkdomain",
            "type": "string"
          },
          {
            "description": "the network's gateway",
            "name": "gateway",
            "type": "string"
          },
          {
            "description": "state of the network",
            "name": "state",
            "type": "string"
          },
          {
            "description": "true network requires restart",
            "name": "restartrequired",
            "type": "boolean"
          },
          {
            "description": "the id of the network",
            "name": "id",
            "type": "string"
          },
          {
            "description": "name of the network offering the network is created from",
            "name": "networkofferingname",
            "type": "string"
          },
          {
            "description": "acl type - access type to the network",
            "name": "acltype",
            "type": "string"
          },
          {
            "description": "true if network is default, false otherwise",
            "name": "isdefault",
            "type": "boolean"
          },
          {
            "description": "the gateway of IPv6 network",
            "name": "ip6gateway",
            "type": "string"
          },
          {
            "description": "zone id of the network",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "Broadcast domain type of the network",
            "name": "broadcastdomaintype",
            "type": "string"
          },
          {
            "description": "the first DNS for the network",
            "name": "dns1",
            "type": "string"
          },
          {
            "description": "the list of services",
            "name": "service",
            "response": [
              {
                "description": "the service name",
                "name": "name",
                "type": "string"
              },
              {
                "description": "the list of capabilities",
                "name": "capability",
                "response": [
                  {
                    "description": "the capability value",
                    "name": "value",
                    "type": "string"
                  },
                  {
                    "description": "can this service capability value can be choosable while creatine network offerings",
                    "name": "canchooseservicecapability",
                    "type": "boolean"
                  },
                  {
                    "description": "the capability name",
                    "name": "name",
                    "type": "string"
                  }
                ],
                "type": "list"
              },
              {
                "description": "the service provider name",
                "name": "provider",
                "response": [
                  {
                    "description": "uuid of the network provider",
                    "name": "id",
                    "type": "string"
                  },
                  {
                    "description": "services for this provider",
                    "name": "servicelist",
                    "type": "list"
                  },
                  {
                    "description": "the provider name",
                    "name": "name",
                    "type": "string"
                  },
                  {
                    "description": "the physical network this belongs to",
                    "name": "physicalnetworkid",
                    "type": "string"
                  },
                  {
                    "description": "true if individual services can be enabled/disabled",
                    "name": "canenableindividualservice",
                    "type": "boolean"
                  },
                  {
                    "description": "the destination physical network",
                    "name": "destinationphysicalnetworkid",
                    "type": "string"
                  },
                  {
                    "description": "state of the network provider",
                    "name": "state",
                    "type": "string"
                  }
                ],
                "type": "list"
              }
            ],
            "type": "list"
          },
          {
            "description": "the physical network id",
            "name": "physicalnetworkid",
            "type": "string"
          },
          {
            "description": "display text of the network offering the network is created from",
            "name": "networkofferingdisplaytext",
            "type": "string"
          },
          {
            "description": "list networks available for vm deployment",
            "name": "canusefordeploy",
            "type": "boolean"
          },
          {
            "description": "ACL Id associated with the VPC network",
            "name": "aclid",
            "type": "string"
          },
          {
            "description": "Cloudstack managed address space, all CloudStack managed VMs get IP address from CIDR",
            "name": "cidr",
            "type": "string"
          },
          {
            "description": "true if users from subdomains can access the domain level network",
            "name": "subdomainaccess",
            "type": "boolean"
          },
          {
            "description": "true if network offering is ip conserve mode enabled",
            "name": "networkofferingconservemode",
            "type": "boolean"
          },
          {
            "description": "the domain id of the network owner",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "list networks that are persistent",
            "name": "ispersistent",
            "type": "boolean"
          },
          {
            "description": "the network's IP range not to be used by CloudStack guest VMs and can be used for non CloudStack purposes",
            "name": "reservediprange",
            "type": "string"
          },
          {
            "description": "the name of the zone the network belongs to",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the cidr of IPv6 network",
            "name": "ip6cidr",
            "type": "string"
          },
          {
            "description": "the network's netmask",
            "name": "netmask",
            "type": "string"
          },
          {
            "description": "availability of the network offering the network is created from",
            "name": "networkofferingavailability",
            "type": "string"
          },
          {
            "description": "broadcast uri of the network. This parameter is visible to ROOT admins only",
            "name": "broadcasturi",
            "type": "string"
          }
        ]
      },
      {
        "description": "Change ownership of a VM from one account to another. This API is available for Basic zones with security groups and Advanced zones with guest networks. A root administrator can reassign a VM from any account to any other account in any domain. A domain administrator can reassign a VM to any account in the same domain.",
        "isasync": false,
        "name": "assignVirtualMachine",
        "params": [
          {
            "description": "domain id of the new VM owner.",
            "length": 255,
            "name": "domainid",
            "related": "listDomains,listDomainChildren,listDomains",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "list of new network ids in which the moved VM will participate. In case no network ids are provided the VM will be part of the default network for that zone. In case there is no network yet created for the new account the default network will be created.",
            "length": 255,
            "name": "networkids",
            "related": "createNetwork,listNetscalerLoadBalancerNetworks,listPaloAltoFirewallNetworks,listNetworks,updateNetwork,updateNetwork,createNetwork",
            "required": false,
            "type": "list"
          },
          {
            "description": "list of security group ids to be applied on the virtual machine. In case no security groups are provided the VM is part of the default security group.",
            "length": 255,
            "name": "securitygroupids",
            "related": "createSecurityGroup",
            "required": false,
            "type": "list"
          },
          {
            "description": "id of the VM to be moved",
            "length": 255,
            "name": "virtualmachineid",
            "related": "stopVirtualMachine,listVirtualMachines,detachIso,updateVMAffinityGroup,revertToVMSnapshot,deployVirtualMachine,migrateVirtualMachine,recoverVirtualMachine,migrateVirtualMachineWithVolume,startVirtualMachine,listVirtualMachines,updateVirtualMachine,destroyVirtualMachine,removeNicFromVirtualMachine,removeNicFromVirtualMachine,deployVirtualMachine,destroyVirtualMachine,addNicToVirtualMachine,updateVirtualMachine,rebootVirtualMachine,updateVMAffinityGroup,revertToVMSnapshot,attachIso,resetPasswordForVirtualMachine,assignVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,resetSSHKeyForVirtualMachine,resetPasswordForVirtualMachine,detachIso,changeServiceForVirtualMachine,attachIso,updateDefaultNicForVirtualMachine,startVirtualMachine,stopVirtualMachine",
            "required": true,
            "type": "uuid"
          },
          {
            "description": "account name of the new VM owner.",
            "length": 255,
            "name": "account",
            "required": true,
            "type": "string"
          }
        ],
        "related": "stopVirtualMachine,listVirtualMachines,detachIso,updateVMAffinityGroup,revertToVMSnapshot,deployVirtualMachine,migrateVirtualMachine,recoverVirtualMachine,migrateVirtualMachineWithVolume,startVirtualMachine,listVirtualMachines,updateVirtualMachine,destroyVirtualMachine,removeNicFromVirtualMachine,removeNicFromVirtualMachine,deployVirtualMachine,destroyVirtualMachine,addNicToVirtualMachine,updateVirtualMachine,rebootVirtualMachine,updateVMAffinityGroup,revertToVMSnapshot,attachIso,resetPasswordForVirtualMachine,resetSSHKeyForVirtualMachine,restoreVirtualMachine,resetSSHKeyForVirtualMachine,resetPasswordForVirtualMachine,detachIso,changeServiceForVirtualMachine,attachIso,updateDefaultNicForVirtualMachine,startVirtualMachine,stopVirtualMachine",
        "response": [
          {
            "description": "the name of the template for the virtual machine",
            "name": "templatename",
            "type": "string"
          },
          {
            "description": "an alternate display text of the ISO attached to the virtual machine",
            "name": "isodisplaytext",
            "type": "string"
          },
          {
            "description": "the vgpu type used by the virtual machine",
            "name": "vgpu",
            "type": "string"
          },
          {
            "description": "public IP address id associated with vm via Static nat rule",
            "name": "publicipid",
            "type": "string"
          },
          {
            "description": "ssh key-pair",
            "name": "keypair",
            "type": "string"
          },
          {
            "description": "the ID of the host for the virtual machine",
            "name": "hostid",
            "type": "string"
          },
          {
            "description": "OS type id of the vm",
            "name": "ostypeid",
            "type": "long"
          },
          {
            "description": "the state of the virtual machine",
            "name": "state",
            "type": "string"
          },
          {
            "description": "true if the password rest feature is enabled, false otherwise",
            "name": "passwordenabled",
            "type": "boolean"
          },
          {
            "description": "the name of the ISO attached to the virtual machine",
            "name": "isoname",
            "type": "string"
          },
          {
            "description": "the list of resource tags associated with vm",
            "name": "tags",
            "response": [
              {
                "description": "resource type",
                "name": "resourcetype",
                "type": "string"
              },
              {
                "description": "the ID of the domain associated with the tag",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "id of the resource",
                "name": "resourceid",
                "type": "string"
              },
              {
                "description": "tag key name",
                "name": "key",
                "type": "string"
              },
              {
                "description": "tag value",
                "name": "value",
                "type": "string"
              },
              {
                "description": "the domain associated with the tag",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "customer associated with the tag",
                "name": "customer",
                "type": "string"
              },
              {
                "description": "the project id the tag belongs to",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "the project name where tag belongs to",
                "name": "project",
                "type": "string"
              },
              {
                "description": "the account associated with the tag",
                "name": "account",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "the project name of the vm",
            "name": "project",
            "type": "string"
          },
          {
            "description": "the ID of the service offering of the virtual machine",
            "name": "serviceofferingid",
            "type": "string"
          },
          {
            "description": "the name of the disk offering of the virtual machine",
            "name": "diskofferingname",
            "type": "string"
          },
          {
            "description": "the ID of the availablility zone for the virtual machine",
            "name": "zoneid",
            "type": "string"
          },
          {
            "description": "the account associated with the virtual machine",
            "name": "account",
            "type": "string"
          },
          {
            "description": "device type of the root volume",
            "name": "rootdevicetype",
            "type": "string"
          },
          {
            "description": "user generated name. The name of the virtual machine is returned if no displayname exists.",
            "name": "displayname",
            "type": "string"
          },
          {
            "description": "true if vm contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory.",
            "name": "isdynamicallyscalable",
            "type": "boolean"
          },
          {
            "description": "the read (bytes) of disk on the vm",
            "name": "diskkbsread",
            "type": "long"
          },
          {
            "description": "the project id of the vm",
            "name": "projectid",
            "type": "string"
          },
          {
            "description": "the virtual network for the service offering",
            "name": "forvirtualnetwork",
            "type": "boolean"
          },
          {
            "description": "the read (io) of disk on the vm",
            "name": "diskioread",
            "type": "long"
          },
          {
            "description": "the user's name who deployed the virtual machine",
            "name": "username",
            "type": "string"
          },
          {
            "description": "the ID of the domain in which the virtual machine exists",
            "name": "domainid",
            "type": "string"
          },
          {
            "description": "the memory allocated for the virtual machine",
            "name": "memory",
            "type": "integer"
          },
          {
            "description": "the password (if exists) of the virtual machine",
            "name": "password",
            "type": "string"
          },
          {
            "description": "State of the Service from LB rule",
            "name": "servicestate",
            "type": "string"
          },
          {
            "description": "true if high-availability is enabled, false otherwise",
            "name": "haenable",
            "type": "boolean"
          },
          {
            "description": "the incoming network traffic on the vm",
            "name": "networkkbsread",
            "type": "long"
          },
          {},
          {
            "description": "the write (bytes) of disk on the vm",
            "name": "diskkbswrite",
            "type": "long"
          },
          {
            "description": "the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.",
            "name": "templateid",
            "type": "string"
          },
          {
            "description": "device ID of the root volume",
            "name": "rootdeviceid",
            "type": "long"
          },
          {
            "description": "the group ID of the virtual machine",
            "name": "groupid",
            "type": "string"
          },
          {
            "description": "Vm details in key/value pairs.",
            "name": "details",
            "type": "map"
          },
          {
            "description": "the ID of the virtual machine",
            "name": "id",
            "type": "string"
          },
          {
            "description": "the write (io) of disk on the vm",
            "name": "diskiowrite",
            "type": "long"
          },
          {
            "description": "the name of the service offering of the virtual machine",
            "name": "serviceofferingname",
            "type": "string"
          },
          {
            "description": "the outgoing network traffic on the host",
            "name": "networkkbswrite",
            "type": "long"
          },
          {
            "description": "the ID of the ISO attached to the virtual machine",
            "name": "isoid",
            "type": "string"
          },
          {
            "description": "the name of the host for the virtual machine",
            "name": "hostname",
            "type": "string"
          },
          {
            "description": "the ID of the disk offering of the virtual machine",
            "name": "diskofferingid",
            "type": "string"
          },
          {
            "description": "the date when this virtual machine was created",
            "name": "created",
            "type": "date"
          },
          {
            "description": "the name of the availability zone for the virtual machine",
            "name": "zonename",
            "type": "string"
          },
          {
            "description": "the list of nics associated with vm",
            "name": "nic",
            "response": [
              {
                "description": "the netmask of the nic",
                "name": "netmask",
                "type": "string"
              },
              {
                "description": "true if nic is default, false otherwise",
                "name": "isdefault",
                "type": "boolean"
              },
              {
                "description": "the gateway of IPv6 network",
                "name": "ip6gateway",
                "type": "string"
              },
              {
                "description": "Id of the vm to which the nic belongs",
                "name": "virtualmachineid",
                "type": "string"
              },
              {
                "description": "true if nic is default, false otherwise",
                "name": "macaddress",
                "type": "string"
              },
              {
                "description": "the broadcast uri of the nic",
                "name": "broadcasturi",
                "type": "string"
              },
              {
                "description": "device id for the network when plugged into the virtual machine",
                "name": "deviceid",
                "type": "string"
              },
              {
                "description": "the ip address of the nic",
                "name": "ipaddress",
                "type": "string"
              },
              {
                "description": "the IPv6 address of network",
                "name": "ip6address",
                "type": "string"
              },
              {
                "description": "the ID of the corresponding network",
                "name": "networkid",
                "type": "string"
              },
              {
                "description": "the ID of the nic",
                "name": "id",
                "type": "string"
              },
              {
                "description": "the type of the nic",
                "name": "type",
                "type": "string"
              },
              {
                "description": "the traffic type of the nic",
                "name": "traffictype",
                "type": "string"
              },
              {
                "description": "the cidr of IPv6 network",
                "name": "ip6cidr",
                "type": "string"
              },
              {
                "description": "the name of the corresponding network",
                "name": "networkname",
                "type": "string"
              },
              {
                "description": "the isolation uri of the nic",
                "name": "isolationuri",
                "type": "string"
              },
              {
                "description": "the Secondary ipv4 addr of nic",
                "name": "secondaryip",
                "type": "list"
              },
              {
                "description": "the gateway of the nic",
                "name": "gateway",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": " an alternate display text of the template for the virtual machine",
            "name": "templatedisplaytext",
            "type": "string"
          },
          {
            "description": "the number of cpu this virtual machine is running with",
            "name": "cpunumber",
            "type": "integer"
          },
          {
            "description": "an optional field whether to the display the vm to the end user or not.",
            "name": "displayvm",
            "type": "boolean"
          },
          {
            "description": "list of affinity groups associated with the virtual machine",
            "name": "affinitygroup",
            "response": [
              {
                "description": "the name of the affinity group",
                "name": "name",
                "type": "string"
              },
              {
                "description": "the project ID of the affinity group",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "virtual machine IDs associated with this affinity group",
                "name": "virtualmachineIds",
                "type": "list"
              },
              {
                "description": "the description of the affinity group",
                "name": "description",
                "type": "string"
              },
              {
                "description": "the ID of the affinity group",
                "name": "id",
                "type": "string"
              },
              {
                "description": "the domain name of the affinity group",
                "name": "domain",
                "type": "string"
              },
              {
                "description": "the project name of the affinity group",
                "name": "project",
                "type": "string"
              },
              {
                "description": "the domain ID of the affinity group",
                "name": "domainid",
                "type": "string"
              },
              {
                "description": "the type of the affinity group",
                "name": "type",
                "type": "string"
              },
              {
                "description": "the account owning the affinity group",
                "name": "account",
                "type": "string"
              }
            ],
            "type": "set"
          },
          {
            "description": "the name of the domain in which the virtual machine exists",
            "name": "domain",
            "type": "string"
          },
          {
            "description": "list of security groups associated with the virtual machine",
            "name": "securitygroup",
            "response": [
              {
                "description": "the number of virtualmachines associated with this securitygroup",
                "name": "virtualmachinecount",
                "type": "integer"
              },
              {
                "description": "the project name of the group",
                "name": "project",
                "type": "string"
              },
              {
                "description": "the description of the security group",
                "name": "description",
                "type": "string"
              },
              {
                "description": "the project id of the group",
                "name": "projectid",
                "type": "string"
              },
              {
                "description": "the list of egress rules associated with the security group",
                "name": "egressrule",
                "response": [
                  {
                    "description": "account owning the security group rule",
                    "name": "account",
                    "type": "string"
                  },
                  {
                    "description": "the protocol of the security group rule",
                    "name": "protocol",
                    "type": "string"
                  },
                  {
                    "description": "the id of the security group rule",
                    "name": "ruleid",
                    "type": "string"
                  },
                  {
                    "description": "the ending IP of the security group rule ",
                    "name": "endport",
                    "type": "integer"
                  },
                  {
                    "description": "the CIDR notation for the base IP address of the security group rule",
                    "name": "cidr",
                    "type": "string"
                  },
                  {
                    "description": "the type of the ICMP message response",
                    "name": "icmptype",
                    "type": "integer"
                  },
                  {
                    "description": "the list of resource tags associated with the rule",
                    "name": "tags",
                    "response": [
                      {
                        "description": "the ID of the domain associated with the tag",
                        "name": "domainid",
                        "type": "stri