// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appsync

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateApiKey = "CreateApiKey"

// CreateApiKeyRequest generates a "aws/request.Request" representing the
// client's request for the CreateApiKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApiKey for more information on using the CreateApiKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateApiKeyRequest method.
//    req, resp := client.CreateApiKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateApiKey
func (c *AppSync) CreateApiKeyRequest(input *CreateApiKeyInput) (req *request.Request, output *CreateApiKeyOutput) {
	op := &request.Operation{
		Name:       opCreateApiKey,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apis/{apiId}/apikeys",
	}

	if input == nil {
		input = &CreateApiKeyInput{}
	}

	output = &CreateApiKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApiKey API operation for AWS AppSync.
//
// Creates a unique key that you can distribute to clients who are executing
// your API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation CreateApiKey for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and then try again.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource specified in the request was not found. Check the resource,
//   and then try again.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request exceeded a limit. Try your request again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request exceeded a limit. Try your request again.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal AWS AppSync error occurred. Try your request again.
//
//   * ErrCodeApiKeyLimitExceededException "ApiKeyLimitExceededException"
//   The API key exceeded a limit. Try your request again.
//
//   * ErrCodeApiKeyValidityOutOfBoundsException "ApiKeyValidityOutOfBoundsException"
//   The API key expiration must be set to a value between 1 and 365 days from
//   creation (for CreateApiKey) or from update (for UpdateApiKey).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateApiKey
func (c *AppSync) CreateApiKey(input *CreateApiKeyInput) (*CreateApiKeyOutput, error) {
	req, out := c.CreateApiKeyRequest(input)
	return out, req.Send()
}

// CreateApiKeyWithContext is the same as CreateApiKey with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApiKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) CreateApiKeyWithContext(ctx aws.Context, input *CreateApiKeyInput, opts ...request.Option) (*CreateApiKeyOutput, error) {
	req, out := c.CreateApiKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataSource = "CreateDataSource"

// CreateDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataSource for more information on using the CreateDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDataSourceRequest method.
//    req, resp := client.CreateDataSourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateDataSource
func (c *AppSync) CreateDataSourceRequest(input *CreateDataSourceInput) (req *request.Request, output *CreateDataSourceOutput) {
	op := &request.Operation{
		Name:       opCreateDataSource,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apis/{apiId}/datasources",
	}

	if input == nil {
		input = &CreateDataSourceInput{}
	}

	output = &CreateDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataSource API operation for AWS AppSync.
//
// Creates a DataSource object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation CreateDataSource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and then try again.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Another modification is in progress at this time and it must complete before
//   you can make your change.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource specified in the request was not found. Check the resource,
//   and then try again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal AWS AppSync error occurred. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateDataSource
func (c *AppSync) CreateDataSource(input *CreateDataSourceInput) (*CreateDataSourceOutput, error) {
	req, out := c.CreateDataSourceRequest(input)
	return out, req.Send()
}

// CreateDataSourceWithContext is the same as CreateDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) CreateDataSourceWithContext(ctx aws.Context, input *CreateDataSourceInput, opts ...request.Option) (*CreateDataSourceOutput, error) {
	req, out := c.CreateDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFunction = "CreateFunction"

// CreateFunctionRequest generates a "aws/request.Request" representing the
// client's request for the CreateFunction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFunction for more information on using the CreateFunction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFunctionRequest method.
//    req, resp := client.CreateFunctionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateFunction
func (c *AppSync) CreateFunctionRequest(input *CreateFunctionInput) (req *request.Request, output *CreateFunctionOutput) {
	op := &request.Operation{
		Name:       opCreateFunction,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apis/{apiId}/functions",
	}

	if input == nil {
		input = &CreateFunctionInput{}
	}

	output = &CreateFunctionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFunction API operation for AWS AppSync.
//
// Creates a Function object.
//
// A function is a reusable entity. Multiple functions can be used to compose
// the resolver logic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation CreateFunction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Another modification is in progress at this time and it must complete before
//   you can make your change.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource specified in the request was not found. Check the resource,
//   and then try again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal AWS AppSync error occurred. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateFunction
func (c *AppSync) CreateFunction(input *CreateFunctionInput) (*CreateFunctionOutput, error) {
	req, out := c.CreateFunctionRequest(input)
	return out, req.Send()
}

// CreateFunctionWithContext is the same as CreateFunction with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFunction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) CreateFunctionWithContext(ctx aws.Context, input *CreateFunctionInput, opts ...request.Option) (*CreateFunctionOutput, error) {
	req, out := c.CreateFunctionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGraphqlApi = "CreateGraphqlApi"

// CreateGraphqlApiRequest generates a "aws/request.Request" representing the
// client's request for the CreateGraphqlApi operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGraphqlApi for more information on using the CreateGraphqlApi
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGraphqlApiRequest method.
//    req, resp := client.CreateGraphqlApiRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateGraphqlApi
func (c *AppSync) CreateGraphqlApiRequest(input *CreateGraphqlApiInput) (req *request.Request, output *CreateGraphqlApiOutput) {
	op := &request.Operation{
		Name:       opCreateGraphqlApi,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apis",
	}

	if input == nil {
		input = &CreateGraphqlApiInput{}
	}

	output = &CreateGraphqlApiOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGraphqlApi API operation for AWS AppSync.
//
// Creates a GraphqlApi object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation CreateGraphqlApi for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and then try again.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request exceeded a limit. Try your request again.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Another modification is in progress at this time and it must complete before
//   you can make your change.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal AWS AppSync error occurred. Try your request again.
//
//   * ErrCodeApiLimitExceededException "ApiLimitExceededException"
//   The GraphQL API exceeded a limit. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateGraphqlApi
func (c *AppSync) CreateGraphqlApi(input *CreateGraphqlApiInput) (*CreateGraphqlApiOutput, error) {
	req, out := c.CreateGraphqlApiRequest(input)
	return out, req.Send()
}

// CreateGraphqlApiWithContext is the same as CreateGraphqlApi with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGraphqlApi for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) CreateGraphqlApiWithContext(ctx aws.Context, input *CreateGraphqlApiInput, opts ...request.Option) (*CreateGraphqlApiOutput, error) {
	req, out := c.CreateGraphqlApiRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResolver = "CreateResolver"

// CreateResolverRequest generates a "aws/request.Request" representing the
// client's request for the CreateResolver operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateResolver for more information on using the CreateResolver
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateResolverRequest method.
//    req, resp := client.CreateResolverRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateResolver
func (c *AppSync) CreateResolverRequest(input *CreateResolverInput) (req *request.Request, output *CreateResolverOutput) {
	op := &request.Operation{
		Name:       opCreateResolver,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apis/{apiId}/types/{typeName}/resolvers",
	}

	if input == nil {
		input = &CreateResolverInput{}
	}

	output = &CreateResolverOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateResolver API operation for AWS AppSync.
//
// Creates a Resolver object.
//
// A resolver converts incoming requests into a format that a data source can
// understand and converts the data source's responses into GraphQL.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation CreateResolver for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Another modification is in progress at this time and it must complete before
//   you can make your change.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource specified in the request was not found. Check the resource,
//   and then try again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal AWS AppSync error occurred. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateResolver
func (c *AppSync) CreateResolver(input *CreateResolverInput) (*CreateResolverOutput, error) {
	req, out := c.CreateResolverRequest(input)
	return out, req.Send()
}

// CreateResolverWithContext is the same as CreateResolver with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResolver for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) CreateResolverWithContext(ctx aws.Context, input *CreateResolverInput, opts ...request.Option) (*CreateResolverOutput, error) {
	req, out := c.CreateResolverRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateType = "CreateType"

// CreateTypeRequest generates a "aws/request.Request" representing the
// client's request for the CreateType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateType for more information on using the CreateType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTypeRequest method.
//    req, resp := client.CreateTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateType
func (c *AppSync) CreateTypeRequest(input *CreateTypeInput) (req *request.Request, output *CreateTypeOutput) {
	op := &request.Operation{
		Name:       opCreateType,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apis/{apiId}/types",
	}

	if input == nil {
		input = &CreateTypeInput{}
	}

	output = &CreateTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateType API operation for AWS AppSync.
//
// Creates a Type object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation CreateType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and then try again.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Another modification is in progress at this time and it must complete before
//   you can make your change.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource specified in the request was not found. Check the resource,
//   and then try again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal AWS AppSync error occurred. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateType
func (c *AppSync) CreateType(input *CreateTypeInput) (*CreateTypeOutput, error) {
	req, out := c.CreateTypeRequest(input)
	return out, req.Send()
}

// CreateTypeWithContext is the same as CreateType with the addition of
// the ability to pass a context and additional request options.
//
// See CreateType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) CreateTypeWithContext(ctx aws.Context, input *CreateTypeInput, opts ...request.Option) (*CreateTypeOutput, error) {
	req, out := c.CreateTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApiKey = "DeleteApiKey"

// DeleteApiKeyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApiKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApiKey for more information on using the DeleteApiKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApiKeyRequest method.
//    req, resp := client.DeleteApiKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteApiKey
func (c *AppSync) DeleteApiKeyRequest(input *DeleteApiKeyInput) (req *request.Request, output *DeleteApiKeyOutput) {
	op := &request.Operation{
		Name:       opDeleteApiKey,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apis/{apiId}/apikeys/{id}",
	}

	if input == nil {
		input = &DeleteApiKeyInput{}
	}

	output = &DeleteApiKeyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApiKey API operation for AWS AppSync.
//
// Deletes an API key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation DeleteApiKey for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and then try again.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource specified in the request was not found. Check the resource,
//   and then try again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal AWS AppSync error occurred. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteApiKey
func (c *AppSync) DeleteApiKey(input *DeleteApiKeyInput) (*DeleteApiKeyOutput, error) {
	req, out := c.DeleteApiKeyRequest(input)
	return out, req.Send()
}

// DeleteApiKeyWithContext is the same as DeleteApiKey with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApiKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) DeleteApiKeyWithContext(ctx aws.Context, input *DeleteApiKeyInput, opts ...request.Option) (*DeleteApiKeyOutput, error) {
	req, out := c.DeleteApiKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataSource = "DeleteDataSource"

// DeleteDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataSource for more information on using the DeleteDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDataSourceRequest method.
//    req, resp := client.DeleteDataSourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteDataSource
func (c *AppSync) DeleteDataSourceRequest(input *DeleteDataSourceInput) (req *request.Request, output *DeleteDataSourceOutput) {
	op := &request.Operation{
		Name:       opDeleteDataSource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apis/{apiId}/datasources/{name}",
	}

	if input == nil {
		input = &DeleteDataSourceInput{}
	}

	output = &DeleteDataSourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDataSource API operation for AWS AppSync.
//
// Deletes a DataSource object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation DeleteDataSource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and then try again.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Another modification is in progress at this time and it must complete before
//   you can make your change.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource specified in the request was not found. Check the resource,
//   and then try again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal AWS AppSync error occurred. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteDataSource
func (c *AppSync) DeleteDataSource(input *DeleteDataSourceInput) (*DeleteDataSourceOutput, error) {
	req, out := c.DeleteDataSourceRequest(input)
	return out, req.Send()
}

// DeleteDataSourceWithContext is the same as DeleteDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) DeleteDataSourceWithContext(ctx aws.Context, input *DeleteDataSourceInput, opts ...request.Option) (*DeleteDataSourceOutput, error) {
	req, out := c.DeleteDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFunction = "DeleteFunction"

// DeleteFunctionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFunction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFunction for more information on using the DeleteFunction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFunctionRequest method.
//    req, resp := client.DeleteFunctionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteFunction
func (c *AppSync) DeleteFunctionRequest(input *DeleteFunctionInput) (req *request.Request, output *DeleteFunctionOutput) {
	op := &request.Operation{
		Name:       opDeleteFunction,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apis/{apiId}/functions/{functionId}",
	}

	if input == nil {
		input = &DeleteFunctionInput{}
	}

	output = &DeleteFunctionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFunction API operation for AWS AppSync.
//
// Deletes a Function.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation DeleteFunction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Another modification is in progress at this time and it must complete before
//   you can make your change.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource specified in the request was not found. Check the resource,
//   and then try again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal AWS AppSync error occurred. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteFunction
func (c *AppSync) DeleteFunction(input *DeleteFunctionInput) (*DeleteFunctionOutput, error) {
	req, out := c.DeleteFunctionRequest(input)
	return out, req.Send()
}

// DeleteFunctionWithContext is the same as DeleteFunction with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFunction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) DeleteFunctionWithContext(ctx aws.Context, input *DeleteFunctionInput, opts ...request.Option) (*DeleteFunctionOutput, error) {
	req, out := c.DeleteFunctionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGraphqlApi = "DeleteGraphqlApi"

// DeleteGraphqlApiRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGraphqlApi operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGraphqlApi for more information on using the DeleteGraphqlApi
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGraphqlApiRequest method.
//    req, resp := client.DeleteGraphqlApiRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteGraphqlApi
func (c *AppSync) DeleteGraphqlApiRequest(input *DeleteGraphqlApiInput) (req *request.Request, output *DeleteGraphqlApiOutput) {
	op := &request.Operation{
		Name:       opDeleteGraphqlApi,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apis/{apiId}",
	}

	if input == nil {
		input = &DeleteGraphqlApiInput{}
	}

	output = &DeleteGraphqlApiOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteGraphqlApi API operation for AWS AppSync.
//
// Deletes a GraphqlApi object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation DeleteGraphqlApi for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and then try again.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Another modification is in progress at this time and it must complete before
//   you can make your change.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource specified in the request was not found. Check the resource,
//   and then try again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal AWS AppSync error occurred. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteGraphqlApi
func (c *AppSync) DeleteGraphqlApi(input *DeleteGraphqlApiInput) (*DeleteGraphqlApiOutput, error) {
	req, out := c.DeleteGraphqlApiRequest(input)
	return out, req.Send()
}

// DeleteGraphqlApiWithContext is the same as DeleteGraphqlApi with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGraphqlApi for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) DeleteGraphqlApiWithContext(ctx aws.Context, input *DeleteGraphqlApiInput, opts ...request.Option) (*DeleteGraphqlApiOutput, error) {
	req, out := c.DeleteGraphqlApiRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResolver = "DeleteResolver"

// DeleteResolverRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResolver operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResolver for more information on using the DeleteResolver
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteResolverRequest method.
//    req, resp := client.DeleteResolverRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteResolver
func (c *AppSync) DeleteResolverRequest(input *DeleteResolverInput) (req *request.Request, output *DeleteResolverOutput) {
	op := &request.Operation{
		Name:       opDeleteResolver,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apis/{apiId}/types/{typeName}/resolvers/{fieldName}",
	}

	if input == nil {
		input = &DeleteResolverInput{}
	}

	output = &DeleteResolverOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteResolver API operation for AWS AppSync.
//
// Deletes a Resolver object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation DeleteResolver for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Another modification is in progress at this time and it must complete before
//   you can make your change.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource specified in the request was not found. Check the resource,
//   and then try again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal AWS AppSync error occurred. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteResolver
func (c *AppSync) DeleteResolver(input *DeleteResolverInput) (*DeleteResolverOutput, error) {
	req, out := c.DeleteResolverRequest(input)
	return out, req.Send()
}

// DeleteResolverWithContext is the same as DeleteResolver with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResolver for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) DeleteResolverWithContext(ctx aws.Context, input *DeleteResolverInput, opts ...request.Option) (*DeleteResolverOutput, error) {
	req, out := c.DeleteResolverRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteType = "DeleteType"

// DeleteTypeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteType for more information on using the DeleteType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTypeRequest method.
//    req, resp := client.DeleteTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteType
func (c *AppSync) DeleteTypeRequest(input *DeleteTypeInput) (req *request.Request, output *DeleteTypeOutput) {
	op := &request.Operation{
		Name:       opDeleteType,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apis/{apiId}/types/{typeName}",
	}

	if input == nil {
		input = &DeleteTypeInput{}
	}

	output = &DeleteTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteType API operation for AWS AppSync.
//
// Deletes a Type object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation DeleteType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and then try again.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Another modification is in progress at this time and it must complete before
//   you can make your change.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource specified in the request was not found. Check the resource,
//   and then try again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal AWS AppSync error occurred. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteType
func (c *AppSync) DeleteType(input *DeleteTypeInput) (*DeleteTypeOutput, error) {
	req, out := c.DeleteTypeRequest(input)
	return out, req.Send()
}

// DeleteTypeWithContext is the same as DeleteType with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) DeleteTypeWithContext(ctx aws.Context, input *DeleteTypeInput, opts ...request.Option) (*DeleteTypeOutput, error) {
	req, out := c.DeleteTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDataSource = "GetDataSource"

// GetDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the GetDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDataSource for more information on using the GetDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDataSourceRequest method.
//    req, resp := client.GetDataSourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetDataSource
func (c *AppSync) GetDataSourceRequest(input *GetDataSourceInput) (req *request.Request, output *GetDataSourceOutput) {
	op := &request.Operation{
		Name:       opGetDataSource,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apis/{apiId}/datasources/{name}",
	}

	if input == nil {
		input = &GetDataSourceInput{}
	}

	output = &GetDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDataSource API operation for AWS AppSync.
//
// Retrieves a DataSource object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation GetDataSource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and then try again.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Another modification is in progress at this time and it must complete before
//   you can make your change.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource specified in the request was not found. Check the resource,
//   and then try again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal AWS AppSync error occurred. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetDataSource
func (c *AppSync) GetDataSource(input *GetDataSourceInput) (*GetDataSourceOutput, error) {
	req, out := c.GetDataSourceRequest(input)
	return out, req.Send()
}

// GetDataSourceWithContext is the same as GetDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See GetDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) GetDataSourceWithContext(ctx aws.Context, input *GetDataSourceInput, opts ...request.Option) (*GetDataSourceOutput, error) {
	req, out := c.GetDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFunction = "GetFunction"

// GetFunctionRequest generates a "aws/request.Request" representing the
// client's request for the GetFunction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFunction for more information on using the GetFunction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFunctionRequest method.
//    req, resp := client.GetFunctionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetFunction
func (c *AppSync) GetFunctionRequest(input *GetFunctionInput) (req *request.Request, output *GetFunctionOutput) {
	op := &request.Operation{
		Name:       opGetFunction,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apis/{apiId}/functions/{functionId}",
	}

	if input == nil {
		input = &GetFunctionInput{}
	}

	output = &GetFunctionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFunction API operation for AWS AppSync.
//
// Get a Function.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation GetFunction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Another modification is in progress at this time and it must complete before
//   you can make your change.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource specified in the request was not found. Check the resource,
//   and then try again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetFunction
func (c *AppSync) GetFunction(input *GetFunctionInput) (*GetFunctionOutput, error) {
	req, out := c.GetFunctionRequest(input)
	return out, req.Send()
}

// GetFunctionWithContext is the same as GetFunction with the addition of
// the ability to pass a context and additional request options.
//
// See GetFunction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) GetFunctionWithContext(ctx aws.Context, input *GetFunctionInput, opts ...request.Option) (*GetFunctionOutput, error) {
	req, out := c.GetFunctionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGraphqlApi = "GetGraphqlApi"

// GetGraphqlApiRequest generates a "aws/request.Request" representing the
// client's request for the GetGraphqlApi operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGraphqlApi for more information on using the GetGraphqlApi
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGraphqlApiRequest method.
//    req, resp := client.GetGraphqlApiRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetGraphqlApi
func (c *AppSync) GetGraphqlApiRequest(input *GetGraphqlApiInput) (req *request.Request, output *GetGraphqlApiOutput) {
	op := &request.Operation{
		Name:       opGetGraphqlApi,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apis/{apiId}",
	}

	if input == nil {
		input = &GetGraphqlApiInput{}
	}

	output = &GetGraphqlApiOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGraphqlApi API operation for AWS AppSync.
//
// Retrieves a GraphqlApi object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation GetGraphqlApi for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and then try again.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource specified in the request was not found. Check the resource,
//   and then try again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal AWS AppSync error occurred. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetGraphqlApi
func (c *AppSync) GetGraphqlApi(input *GetGraphqlApiInput) (*GetGraphqlApiOutput, error) {
	req, out := c.GetGraphqlApiRequest(input)
	return out, req.Send()
}

// GetGraphqlApiWithContext is the same as GetGraphqlApi with the addition of
// the ability to pass a context and additional request options.
//
// See GetGraphqlApi for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) GetGraphqlApiWithContext(ctx aws.Context, input *GetGraphqlApiInput, opts ...request.Option) (*GetGraphqlApiOutput, error) {
	req, out := c.GetGraphqlApiRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIntrospectionSchema = "GetIntrospectionSchema"

// GetIntrospectionSchemaRequest generates a "aws/request.Request" representing the
// client's request for the GetIntrospectionSchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIntrospectionSchema for more information on using the GetIntrospectionSchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetIntrospectionSchemaRequest method.
//    req, resp := client.GetIntrospectionSchemaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetIntrospectionSchema
func (c *AppSync) GetIntrospectionSchemaRequest(input *GetIntrospectionSchemaInput) (req *request.Request, output *GetIntrospectionSchemaOutput) {
	op := &request.Operation{
		Name:       opGetIntrospectionSchema,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apis/{apiId}/schema",
	}

	if input == nil {
		input = &GetIntrospectionSchemaInput{}
	}

	output = &GetIntrospectionSchemaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIntrospectionSchema API operation for AWS AppSync.
//
// Retrieves the introspection schema for a GraphQL API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation GetIntrospectionSchema for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeGraphQLSchemaException "GraphQLSchemaException"
//   The GraphQL schema is not valid.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource specified in the request was not found. Check the resource,
//   and then try again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal AWS AppSync error occurred. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetIntrospectionSchema
func (c *AppSync) GetIntrospectionSchema(input *GetIntrospectionSchemaInput) (*GetIntrospectionSchemaOutput, error) {
	req, out := c.GetIntrospectionSchemaRequest(input)
	return out, req.Send()
}

// GetIntrospectionSchemaWithContext is the same as GetIntrospectionSchema with the addition of
// the ability to pass a context and additional request options.
//
// See GetIntrospectionSchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) GetIntrospectionSchemaWithContext(ctx aws.Context, input *GetIntrospectionSchemaInput, opts ...request.Option) (*GetIntrospectionSchemaOutput, error) {
	req, out := c.GetIntrospectionSchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResolver = "GetResolver"

// GetResolverRequest generates a "aws/request.Request" representing the
// client's request for the GetResolver operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResolver for more information on using the GetResolver
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResolverRequest method.
//    req, resp := client.GetResolverRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetResolver
func (c *AppSync) GetResolverRequest(input *GetResolverInput) (req *request.Request, output *GetResolverOutput) {
	op := &request.Operation{
		Name:       opGetResolver,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apis/{apiId}/types/{typeName}/resolvers/{fieldName}",
	}

	if input == nil {
		input = &GetResolverInput{}
	}

	output = &GetResolverOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResolver API operation for AWS AppSync.
//
// Retrieves a Resolver object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation GetResolver for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Another modification is in progress at this time and it must complete before
//   you can make your change.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource specified in the request was not found. Check the resource,
//   and then try again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetResolver
func (c *AppSync) GetResolver(input *GetResolverInput) (*GetResolverOutput, error) {
	req, out := c.GetResolverRequest(input)
	return out, req.Send()
}

// GetResolverWithContext is the same as GetResolver with the addition of
// the ability to pass a context and additional request options.
//
// See GetResolver for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) GetResolverWithContext(ctx aws.Context, input *GetResolverInput, opts ...request.Option) (*GetResolverOutput, error) {
	req, out := c.GetResolverRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSchemaCreationStatus = "GetSchemaCreationStatus"

// GetSchemaCreationStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetSchemaCreationStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSchemaCreationStatus for more information on using the GetSchemaCreationStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSchemaCreationStatusRequest method.
//    req, resp := client.GetSchemaCreationStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetSchemaCreationStatus
func (c *AppSync) GetSchemaCreationStatusRequest(input *GetSchemaCreationStatusInput) (req *request.Request, output *GetSchemaCreationStatusOutput) {
	op := &request.Operation{
		Name:       opGetSchemaCreationStatus,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apis/{apiId}/schemacreation",
	}

	if input == nil {
		input = &GetSchemaCreationStatusInput{}
	}

	output = &GetSchemaCreationStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSchemaCreationStatus API operation for AWS AppSync.
//
// Retrieves the current status of a schema creation operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation GetSchemaCreationStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and then try again.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource specified in the request was not found. Check the resource,
//   and then try again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal AWS AppSync error occurred. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetSchemaCreationStatus
func (c *AppSync) GetSchemaCreationStatus(input *GetSchemaCreationStatusInput) (*GetSchemaCreationStatusOutput, error) {
	req, out := c.GetSchemaCreationStatusRequest(input)
	return out, req.Send()
}

// GetSchemaCreationStatusWithContext is the same as GetSchemaCreationStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetSchemaCreationStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) GetSchemaCreationStatusWithContext(ctx aws.Context, input *GetSchemaCreationStatusInput, opts ...request.Option) (*GetSchemaCreationStatusOutput, error) {
	req, out := c.GetSchemaCreationStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetType = "GetType"

// GetTypeRequest generates a "aws/request.Request" representing the
// client's request for the GetType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetType for more information on using the GetType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTypeRequest method.
//    req, resp := client.GetTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetType
func (c *AppSync) GetTypeRequest(input *GetTypeInput) (req *request.Request, output *GetTypeOutput) {
	op := &request.Operation{
		Name:       opGetType,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apis/{apiId}/types/{typeName}",
	}

	if input == nil {
		input = &GetTypeInput{}
	}

	output = &GetTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetType API operation for AWS AppSync.
//
// Retrieves a Type object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation GetType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and then try again.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Another modification is in progress at this time and it must complete before
//   you can make your change.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource specified in the request was not found. Check the resource,
//   and then try again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal AWS AppSync error occurred. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetType
func (c *AppSync) GetType(input *GetTypeInput) (*GetTypeOutput, error) {
	req, out := c.GetTypeRequest(input)
	return out, req.Send()
}

// GetTypeWithContext is the same as GetType with the addition of
// the ability to pass a context and additional request options.
//
// See GetType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) GetTypeWithContext(ctx aws.Context, input *GetTypeInput, opts ...request.Option) (*GetTypeOutput, error) {
	req, out := c.GetTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListApiKeys = "ListApiKeys"

// ListApiKeysRequest generates a "aws/request.Request" representing the
// client's request for the ListApiKeys operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApiKeys for more information on using the ListApiKeys
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListApiKeysRequest method.
//    req, resp := client.ListApiKeysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListApiKeys
func (c *AppSync) ListApiKeysRequest(input *ListApiKeysInput) (req *request.Request, output *ListApiKeysOutput) {
	op := &request.Operation{
		Name:       opListApiKeys,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apis/{apiId}/apikeys",
	}

	if input == nil {
		input = &ListApiKeysInput{}
	}

	output = &ListApiKeysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApiKeys API operation for AWS AppSync.
//
// Lists the API keys for a given API.
//
// API keys are deleted automatically sometime after they expire. However, they
// may still be included in the response until they have actually been deleted.
// You can safely call DeleteApiKey to manually delete a key before it's automatically
// deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation ListApiKeys for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and then try again.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource specified in the request was not found. Check the resource,
//   and then try again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal AWS AppSync error occurred. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListApiKeys
func (c *AppSync) ListApiKeys(input *ListApiKeysInput) (*ListApiKeysOutput, error) {
	req, out := c.ListApiKeysRequest(input)
	return out, req.Send()
}

// ListApiKeysWithContext is the same as ListApiKeys with the addition of
// the ability to pass a context and additional request options.
//
// See ListApiKeys for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) ListApiKeysWithContext(ctx aws.Context, input *ListApiKeysInput, opts ...request.Option) (*ListApiKeysOutput, error) {
	req, out := c.ListApiKeysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDataSources = "ListDataSources"

// ListDataSourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListDataSources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataSources for more information on using the ListDataSources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDataSourcesRequest method.
//    req, resp := client.ListDataSourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListDataSources
func (c *AppSync) ListDataSourcesRequest(input *ListDataSourcesInput) (req *request.Request, output *ListDataSourcesOutput) {
	op := &request.Operation{
		Name:       opListDataSources,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apis/{apiId}/datasources",
	}

	if input == nil {
		input = &ListDataSourcesInput{}
	}

	output = &ListDataSourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataSources API operation for AWS AppSync.
//
// Lists the data sources for a given API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation ListDataSources for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and then try again.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource specified in the request was not found. Check the resource,
//   and then try again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal AWS AppSync error occurred. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListDataSources
func (c *AppSync) ListDataSources(input *ListDataSourcesInput) (*ListDataSourcesOutput, error) {
	req, out := c.ListDataSourcesRequest(input)
	return out, req.Send()
}

// ListDataSourcesWithContext is the same as ListDataSources with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataSources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) ListDataSourcesWithContext(ctx aws.Context, input *ListDataSourcesInput, opts ...request.Option) (*ListDataSourcesOutput, error) {
	req, out := c.ListDataSourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListFunctions = "ListFunctions"

// ListFunctionsRequest generates a "aws/request.Request" representing the
// client's request for the ListFunctions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFunctions for more information on using the ListFunctions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFunctionsRequest method.
//    req, resp := client.ListFunctionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListFunctions
func (c *AppSync) ListFunctionsRequest(input *ListFunctionsInput) (req *request.Request, output *ListFunctionsOutput) {
	op := &request.Operation{
		Name:       opListFunctions,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apis/{apiId}/functions",
	}

	if input == nil {
		input = &ListFunctionsInput{}
	}

	output = &ListFunctionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFunctions API operation for AWS AppSync.
//
// List multiple functions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation ListFunctions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and then try again.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource specified in the request was not found. Check the resource,
//   and then try again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal AWS AppSync error occurred. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListFunctions
func (c *AppSync) ListFunctions(input *ListFunctionsInput) (*ListFunctionsOutput, error) {
	req, out := c.ListFunctionsRequest(input)
	return out, req.Send()
}

// ListFunctionsWithContext is the same as ListFunctions with the addition of
// the ability to pass a context and additional request options.
//
// See ListFunctions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) ListFunctionsWithContext(ctx aws.Context, input *ListFunctionsInput, opts ...request.Option) (*ListFunctionsOutput, error) {
	req, out := c.ListFunctionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGraphqlApis = "ListGraphqlApis"

// ListGraphqlApisRequest generates a "aws/request.Request" representing the
// client's request for the ListGraphqlApis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGraphqlApis for more information on using the ListGraphqlApis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGraphqlApisRequest method.
//    req, resp := client.ListGraphqlApisRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListGraphqlApis
func (c *AppSync) ListGraphqlApisRequest(input *ListGraphqlApisInput) (req *request.Request, output *ListGraphqlApisOutput) {
	op := &request.Operation{
		Name:       opListGraphqlApis,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apis",
	}

	if input == nil {
		input = &ListGraphqlApisInput{}
	}

	output = &ListGraphqlApisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGraphqlApis API operation for AWS AppSync.
//
// Lists your GraphQL APIs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation ListGraphqlApis for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and then try again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal AWS AppSync error occurred. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListGraphqlApis
func (c *AppSync) ListGraphqlApis(input *ListGraphqlApisInput) (*ListGraphqlApisOutput, error) {
	req, out := c.ListGraphqlApisRequest(input)
	return out, req.Send()
}

// ListGraphqlApisWithContext is the same as ListGraphqlApis with the addition of
// the ability to pass a context and additional request options.
//
// See ListGraphqlApis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) ListGraphqlApisWithContext(ctx aws.Context, input *ListGraphqlApisInput, opts ...request.Option) (*ListGraphqlApisOutput, error) {
	req, out := c.ListGraphqlApisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListResolvers = "ListResolvers"

// ListResolversRequest generates a "aws/request.Request" representing the
// client's request for the ListResolvers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResolvers for more information on using the ListResolvers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResolversRequest method.
//    req, resp := client.ListResolversRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListResolvers
func (c *AppSync) ListResolversRequest(input *ListResolversInput) (req *request.Request, output *ListResolversOutput) {
	op := &request.Operation{
		Name:       opListResolvers,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apis/{apiId}/types/{typeName}/resolvers",
	}

	if input == nil {
		input = &ListResolversInput{}
	}

	output = &ListResolversOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResolvers API operation for AWS AppSync.
//
// Lists the resolvers for a given API and type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation ListResolvers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and then try again.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource specified in the request was not found. Check the resource,
//   and then try again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal AWS AppSync error occurred. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListResolvers
func (c *AppSync) ListResolvers(input *ListResolversInput) (*ListResolversOutput, error) {
	req, out := c.ListResolversRequest(input)
	return out, req.Send()
}

// ListResolversWithContext is the same as ListResolvers with the addition of
// the ability to pass a context and additional request options.
//
// See ListResolvers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) ListResolversWithContext(ctx aws.Context, input *ListResolversInput, opts ...request.Option) (*ListResolversOutput, error) {
	req, out := c.ListResolversRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListResolversByFunction = "ListResolversByFunction"

// ListResolversByFunctionRequest generates a "aws/request.Request" representing the
// client's request for the ListResolversByFunction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResolversByFunction for more information on using the ListResolversByFunction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResolversByFunctionRequest method.
//    req, resp := client.ListResolversByFunctionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListResolversByFunction
func (c *AppSync) ListResolversByFunctionRequest(input *ListResolversByFunctionInput) (req *request.Request, output *ListResolversByFunctionOutput) {
	op := &request.Operation{
		Name:       opListResolversByFunction,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apis/{apiId}/functions/{functionId}/resolvers",
	}

	if input == nil {
		input = &ListResolversByFunctionInput{}
	}

	output = &ListResolversByFunctionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResolversByFunction API operation for AWS AppSync.
//
// List the resolvers that are associated with a specific function.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation ListResolversByFunction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and then try again.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource specified in the request was not found. Check the resource,
//   and then try again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal AWS AppSync error occurred. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListResolversByFunction
func (c *AppSync) ListResolversByFunction(input *ListResolversByFunctionInput) (*ListResolversByFunctionOutput, error) {
	req, out := c.ListResolversByFunctionRequest(input)
	return out, req.Send()
}

// ListResolversByFunctionWithContext is the same as ListResolversByFunction with the addition of
// the ability to pass a context and additional request options.
//
// See ListResolversByFunction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) ListResolversByFunctionWithContext(ctx aws.Context, input *ListResolversByFunctionInput, opts ...request.Option) (*ListResolversByFunctionOutput, error) {
	req, out := c.ListResolversByFunctionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTypes = "ListTypes"

// ListTypesRequest generates a "aws/request.Request" representing the
// client's request for the ListTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTypes for more information on using the ListTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTypesRequest method.
//    req, resp := client.ListTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListTypes
func (c *AppSync) ListTypesRequest(input *ListTypesInput) (req *request.Request, output *ListTypesOutput) {
	op := &request.Operation{
		Name:       opListTypes,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apis/{apiId}/types",
	}

	if input == nil {
		input = &ListTypesInput{}
	}

	output = &ListTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTypes API operation for AWS AppSync.
//
// Lists the types for a given API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation ListTypes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and then try again.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Another modification is in progress at this time and it must complete before
//   you can make your change.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource specified in the request was not found. Check the resource,
//   and then try again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal AWS AppSync error occurred. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListTypes
func (c *AppSync) ListTypes(input *ListTypesInput) (*ListTypesOutput, error) {
	req, out := c.ListTypesRequest(input)
	return out, req.Send()
}

// ListTypesWithContext is the same as ListTypes with the addition of
// the ability to pass a context and additional request options.
//
// See ListTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) ListTypesWithContext(ctx aws.Context, input *ListTypesInput, opts ...request.Option) (*ListTypesOutput, error) {
	req, out := c.ListTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartSchemaCreation = "StartSchemaCreation"

// StartSchemaCreationRequest generates a "aws/request.Request" representing the
// client's request for the StartSchemaCreation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartSchemaCreation for more information on using the StartSchemaCreation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartSchemaCreationRequest method.
//    req, resp := client.StartSchemaCreationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/StartSchemaCreation
func (c *AppSync) StartSchemaCreationRequest(input *StartSchemaCreationInput) (req *request.Request, output *StartSchemaCreationOutput) {
	op := &request.Operation{
		Name:       opStartSchemaCreation,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apis/{apiId}/schemacreation",
	}

	if input == nil {
		input = &StartSchemaCreationInput{}
	}

	output = &StartSchemaCreationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartSchemaCreation API operation for AWS AppSync.
//
// Adds a new schema to your GraphQL API.
//
// This operation is asynchronous. Use to determine when it has completed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation StartSchemaCreation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and then try again.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Another modification is in progress at this time and it must complete before
//   you can make your change.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource specified in the request was not found. Check the resource,
//   and then try again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal AWS AppSync error occurred. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/StartSchemaCreation
func (c *AppSync) StartSchemaCreation(input *StartSchemaCreationInput) (*StartSchemaCreationOutput, error) {
	req, out := c.StartSchemaCreationRequest(input)
	return out, req.Send()
}

// StartSchemaCreationWithContext is the same as StartSchemaCreation with the addition of
// the ability to pass a context and additional request options.
//
// See StartSchemaCreation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) StartSchemaCreationWithContext(ctx aws.Context, input *StartSchemaCreationInput, opts ...request.Option) (*StartSchemaCreationOutput, error) {
	req, out := c.StartSchemaCreationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApiKey = "UpdateApiKey"

// UpdateApiKeyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApiKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApiKey for more information on using the UpdateApiKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApiKeyRequest method.
//    req, resp := client.UpdateApiKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateApiKey
func (c *AppSync) UpdateApiKeyRequest(input *UpdateApiKeyInput) (req *request.Request, output *UpdateApiKeyOutput) {
	op := &request.Operation{
		Name:       opUpdateApiKey,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apis/{apiId}/apikeys/{id}",
	}

	if input == nil {
		input = &UpdateApiKeyInput{}
	}

	output = &UpdateApiKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApiKey API operation for AWS AppSync.
//
// Updates an API key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation UpdateApiKey for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and then try again.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource specified in the request was not found. Check the resource,
//   and then try again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request exceeded a limit. Try your request again.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal AWS AppSync error occurred. Try your request again.
//
//   * ErrCodeApiKeyValidityOutOfBoundsException "ApiKeyValidityOutOfBoundsException"
//   The API key expiration must be set to a value between 1 and 365 days from
//   creation (for CreateApiKey) or from update (for UpdateApiKey).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateApiKey
func (c *AppSync) UpdateApiKey(input *UpdateApiKeyInput) (*UpdateApiKeyOutput, error) {
	req, out := c.UpdateApiKeyRequest(input)
	return out, req.Send()
}

// UpdateApiKeyWithContext is the same as UpdateApiKey with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApiKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) UpdateApiKeyWithContext(ctx aws.Context, input *UpdateApiKeyInput, opts ...request.Option) (*UpdateApiKeyOutput, error) {
	req, out := c.UpdateApiKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataSource = "UpdateDataSource"

// UpdateDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataSource for more information on using the UpdateDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDataSourceRequest method.
//    req, resp := client.UpdateDataSourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateDataSource
func (c *AppSync) UpdateDataSourceRequest(input *UpdateDataSourceInput) (req *request.Request, output *UpdateDataSourceOutput) {
	op := &request.Operation{
		Name:       opUpdateDataSource,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apis/{apiId}/datasources/{name}",
	}

	if input == nil {
		input = &UpdateDataSourceInput{}
	}

	output = &UpdateDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDataSource API operation for AWS AppSync.
//
// Updates a DataSource object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation UpdateDataSource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and then try again.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Another modification is in progress at this time and it must complete before
//   you can make your change.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource specified in the request was not found. Check the resource,
//   and then try again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal AWS AppSync error occurred. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateDataSource
func (c *AppSync) UpdateDataSource(input *UpdateDataSourceInput) (*UpdateDataSourceOutput, error) {
	req, out := c.UpdateDataSourceRequest(input)
	return out, req.Send()
}

// UpdateDataSourceWithContext is the same as UpdateDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) UpdateDataSourceWithContext(ctx aws.Context, input *UpdateDataSourceInput, opts ...request.Option) (*UpdateDataSourceOutput, error) {
	req, out := c.UpdateDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFunction = "UpdateFunction"

// UpdateFunctionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFunction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFunction for more information on using the UpdateFunction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFunctionRequest method.
//    req, resp := client.UpdateFunctionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateFunction
func (c *AppSync) UpdateFunctionRequest(input *UpdateFunctionInput) (req *request.Request, output *UpdateFunctionOutput) {
	op := &request.Operation{
		Name:       opUpdateFunction,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apis/{apiId}/functions/{functionId}",
	}

	if input == nil {
		input = &UpdateFunctionInput{}
	}

	output = &UpdateFunctionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFunction API operation for AWS AppSync.
//
// Updates a Function object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation UpdateFunction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Another modification is in progress at this time and it must complete before
//   you can make your change.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource specified in the request was not found. Check the resource,
//   and then try again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal AWS AppSync error occurred. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateFunction
func (c *AppSync) UpdateFunction(input *UpdateFunctionInput) (*UpdateFunctionOutput, error) {
	req, out := c.UpdateFunctionRequest(input)
	return out, req.Send()
}

// UpdateFunctionWithContext is the same as UpdateFunction with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFunction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) UpdateFunctionWithContext(ctx aws.Context, input *UpdateFunctionInput, opts ...request.Option) (*UpdateFunctionOutput, error) {
	req, out := c.UpdateFunctionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGraphqlApi = "UpdateGraphqlApi"

// UpdateGraphqlApiRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGraphqlApi operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGraphqlApi for more information on using the UpdateGraphqlApi
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGraphqlApiRequest method.
//    req, resp := client.UpdateGraphqlApiRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateGraphqlApi
func (c *AppSync) UpdateGraphqlApiRequest(input *UpdateGraphqlApiInput) (req *request.Request, output *UpdateGraphqlApiOutput) {
	op := &request.Operation{
		Name:       opUpdateGraphqlApi,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apis/{apiId}",
	}

	if input == nil {
		input = &UpdateGraphqlApiInput{}
	}

	output = &UpdateGraphqlApiOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGraphqlApi API operation for AWS AppSync.
//
// Updates a GraphqlApi object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation UpdateGraphqlApi for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and then try again.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Another modification is in progress at this time and it must complete before
//   you can make your change.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource specified in the request was not found. Check the resource,
//   and then try again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal AWS AppSync error occurred. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateGraphqlApi
func (c *AppSync) UpdateGraphqlApi(input *UpdateGraphqlApiInput) (*UpdateGraphqlApiOutput, error) {
	req, out := c.UpdateGraphqlApiRequest(input)
	return out, req.Send()
}

// UpdateGraphqlApiWithContext is the same as UpdateGraphqlApi with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGraphqlApi for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) UpdateGraphqlApiWithContext(ctx aws.Context, input *UpdateGraphqlApiInput, opts ...request.Option) (*UpdateGraphqlApiOutput, error) {
	req, out := c.UpdateGraphqlApiRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateResolver = "UpdateResolver"

// UpdateResolverRequest generates a "aws/request.Request" representing the
// client's request for the UpdateResolver operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateResolver for more information on using the UpdateResolver
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateResolverRequest method.
//    req, resp := client.UpdateResolverRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateResolver
func (c *AppSync) UpdateResolverRequest(input *UpdateResolverInput) (req *request.Request, output *UpdateResolverOutput) {
	op := &request.Operation{
		Name:       opUpdateResolver,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apis/{apiId}/types/{typeName}/resolvers/{fieldName}",
	}

	if input == nil {
		input = &UpdateResolverInput{}
	}

	output = &UpdateResolverOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateResolver API operation for AWS AppSync.
//
// Updates a Resolver object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation UpdateResolver for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Another modification is in progress at this time and it must complete before
//   you can make your change.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource specified in the request was not found. Check the resource,
//   and then try again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal AWS AppSync error occurred. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateResolver
func (c *AppSync) UpdateResolver(input *UpdateResolverInput) (*UpdateResolverOutput, error) {
	req, out := c.UpdateResolverRequest(input)
	return out, req.Send()
}

// UpdateResolverWithContext is the same as UpdateResolver with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResolver for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) UpdateResolverWithContext(ctx aws.Context, input *UpdateResolverInput, opts ...request.Option) (*UpdateResolverOutput, error) {
	req, out := c.UpdateResolverRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateType = "UpdateType"

// UpdateTypeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateType for more information on using the UpdateType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTypeRequest method.
//    req, resp := client.UpdateTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateType
func (c *AppSync) UpdateTypeRequest(input *UpdateTypeInput) (req *request.Request, output *UpdateTypeOutput) {
	op := &request.Operation{
		Name:       opUpdateType,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apis/{apiId}/types/{typeName}",
	}

	if input == nil {
		input = &UpdateTypeInput{}
	}

	output = &UpdateTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateType API operation for AWS AppSync.
//
// Updates a Type object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS AppSync's
// API operation UpdateType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request is not well formed. For example, a value is invalid or a required
//   field is missing. Check the field values, and then try again.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Another modification is in progress at this time and it must complete before
//   you can make your change.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The resource specified in the request was not found. Check the resource,
//   and then try again.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   You are not authorized to perform this operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal AWS AppSync error occurred. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateType
func (c *AppSync) UpdateType(input *UpdateTypeInput) (*UpdateTypeOutput, error) {
	req, out := c.UpdateTypeRequest(input)
	return out, req.Send()
}

// UpdateTypeWithContext is the same as UpdateType with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppSync) UpdateTypeWithContext(ctx aws.Context, input *UpdateTypeInput, opts ...request.Option) (*UpdateTypeOutput, error) {
	req, out := c.UpdateTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Describes an API key.
//
// Customers invoke AWS AppSync GraphQL API operations with API keys as an identity
// mechanism. There are two key versions:
//
// da1: This version was introduced at launch in November 2017. These keys always
// expire after 7 days. Key expiration is managed by Amazon DynamoDB TTL. The
// keys ceased to be valid after February 21, 2018 and should not be used after
// that date.
//
//    * ListApiKeys returns the expiration time in milliseconds.
//
//    * CreateApiKey returns the expiration time in milliseconds.
//
//    * UpdateApiKey is not available for this key version.
//
//    * DeleteApiKey deletes the item from the table.
//
//    * Expiration is stored in Amazon DynamoDB as milliseconds. This results
//    in a bug where keys are not automatically deleted because DynamoDB expects
//    the TTL to be stored in seconds. As a one-time action, we will delete
//    these keys from the table after February 21, 2018.
//
// da2: This version was introduced in February 2018 when AppSync added support
// to extend key expiration.
//
//    * ListApiKeys returns the expiration time in seconds.
//
//    * CreateApiKey returns the expiration time in seconds and accepts a user-provided
//    expiration time in seconds.
//
//    * UpdateApiKey returns the expiration time in seconds and accepts a user-provided
//    expiration time in seconds. Key expiration can only be updated while the
//    key has not expired.
//
//    * DeleteApiKey deletes the item from the table.
//
//    * Expiration is stored in Amazon DynamoDB as seconds.
type ApiKey struct {
	_ struct{} `type:"structure"`

	// A description of the purpose of the API key.
	Description *string `locationName:"description" type:"string"`

	// The time after which the API key expires. The date is represented as seconds
	// since the epoch, rounded down to the nearest hour.
	Expires *int64 `locationName:"expires" type:"long"`

	// The API key ID.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation
func (s ApiKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApiKey) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *ApiKey) SetDescription(v string) *ApiKey {
	s.Description = &v
	return s
}

// SetExpires sets the Expires field's value.
func (s *ApiKey) SetExpires(v int64) *ApiKey {
	s.Expires = &v
	return s
}

// SetId sets the Id field's value.
func (s *ApiKey) SetId(v string) *ApiKey {
	s.Id = &v
	return s
}

// The authorization config in case the HTTP endpoint requires authorization.
type AuthorizationConfig struct {
	_ struct{} `type:"structure"`

	// The authorization type required by the HTTP endpoint.
	//
	//    * AWS_IAM: The authorization type is Sigv4.
	//
	// AuthorizationType is a required field
	AuthorizationType *string `locationName:"authorizationType" type:"string" required:"true" enum:"AuthorizationType"`

	// The AWS IAM settings.
	AwsIamConfig *AwsIamConfig `locationName:"awsIamConfig" type:"structure"`
}

// String returns the string representation
func (s AuthorizationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizationConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuthorizationConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuthorizationConfig"}
	if s.AuthorizationType == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizationType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizationType sets the AuthorizationType field's value.
func (s *AuthorizationConfig) SetAuthorizationType(v string) *AuthorizationConfig {
	s.AuthorizationType = &v
	return s
}

// SetAwsIamConfig sets the AwsIamConfig field's value.
func (s *AuthorizationConfig) SetAwsIamConfig(v *AwsIamConfig) *AuthorizationConfig {
	s.AwsIamConfig = v
	return s
}

// The AWS IAM configuration.
type AwsIamConfig struct {
	_ struct{} `type:"structure"`

	// The signing region for AWS IAM authorization.
	SigningRegion *string `locationName:"signingRegion" type:"string"`

	// The signing service name for AWS IAM authorization.
	SigningServiceName *string `locationName:"signingServiceName" type:"string"`
}

// String returns the string representation
func (s AwsIamConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsIamConfig) GoString() string {
	return s.String()
}

// SetSigningRegion sets the SigningRegion field's value.
func (s *AwsIamConfig) SetSigningRegion(v string) *AwsIamConfig {
	s.SigningRegion = &v
	return s
}

// SetSigningServiceName sets the SigningServiceName field's value.
func (s *AwsIamConfig) SetSigningServiceName(v string) *AwsIamConfig {
	s.SigningServiceName = &v
	return s
}

type CreateApiKeyInput struct {
	_ struct{} `type:"structure"`

	// The ID for your GraphQL API.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// A description of the purpose of the API key.
	Description *string `locationName:"description" type:"string"`

	// The time from creation time after which the API key expires. The date is
	// represented as seconds since the epoch, rounded down to the nearest hour.
	// The default value for this parameter is 7 days from creation time. For more
	// information, see .
	Expires *int64 `locationName:"expires" type:"long"`
}

// String returns the string representation
func (s CreateApiKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApiKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApiKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateApiKeyInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *CreateApiKeyInput) SetApiId(v string) *CreateApiKeyInput {
	s.ApiId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateApiKeyInput) SetDescription(v string) *CreateApiKeyInput {
	s.Description = &v
	return s
}

// SetExpires sets the Expires field's value.
func (s *CreateApiKeyInput) SetExpires(v int64) *CreateApiKeyInput {
	s.Expires = &v
	return s
}

type CreateApiKeyOutput struct {
	_ struct{} `type:"structure"`

	// The API key.
	ApiKey *ApiKey `locationName:"apiKey" type:"structure"`
}

// String returns the string representation
func (s CreateApiKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApiKeyOutput) GoString() string {
	return s.String()
}

// SetApiKey sets the ApiKey field's value.
func (s *CreateApiKeyOutput) SetApiKey(v *ApiKey) *CreateApiKeyOutput {
	s.ApiKey = v
	return s
}

type CreateDataSourceInput struct {
	_ struct{} `type:"structure"`

	// The API ID for the GraphQL API for the DataSource.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// A description of the DataSource.
	Description *string `locationName:"description" type:"string"`

	// Amazon DynamoDB settings.
	DynamodbConfig *DynamodbDataSourceConfig `locationName:"dynamodbConfig" type:"structure"`

	// Amazon Elasticsearch Service settings.
	ElasticsearchConfig *ElasticsearchDataSourceConfig `locationName:"elasticsearchConfig" type:"structure"`

	// HTTP endpoint settings.
	HttpConfig *HttpDataSourceConfig `locationName:"httpConfig" type:"structure"`

	// AWS Lambda settings.
	LambdaConfig *LambdaDataSourceConfig `locationName:"lambdaConfig" type:"structure"`

	// A user-supplied name for the DataSource.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Relational database settings.
	RelationalDatabaseConfig *RelationalDatabaseDataSourceConfig `locationName:"relationalDatabaseConfig" type:"structure"`

	// The AWS IAM service role ARN for the data source. The system assumes this
	// role when accessing the data source.
	ServiceRoleArn *string `locationName:"serviceRoleArn" type:"string"`

	// The type of the DataSource.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"DataSourceType"`
}

// String returns the string representation
func (s CreateDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDataSourceInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.DynamodbConfig != nil {
		if err := s.DynamodbConfig.Validate(); err != nil {
			invalidParams.AddNested("DynamodbConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.ElasticsearchConfig != nil {
		if err := s.ElasticsearchConfig.Validate(); err != nil {
			invalidParams.AddNested("ElasticsearchConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.HttpConfig != nil {
		if err := s.HttpConfig.Validate(); err != nil {
			invalidParams.AddNested("HttpConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.LambdaConfig != nil {
		if err := s.LambdaConfig.Validate(); err != nil {
			invalidParams.AddNested("LambdaConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *CreateDataSourceInput) SetApiId(v string) *CreateDataSourceInput {
	s.ApiId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDataSourceInput) SetDescription(v string) *CreateDataSourceInput {
	s.Description = &v
	return s
}

// SetDynamodbConfig sets the DynamodbConfig field's value.
func (s *CreateDataSourceInput) SetDynamodbConfig(v *DynamodbDataSourceConfig) *CreateDataSourceInput {
	s.DynamodbConfig = v
	return s
}

// SetElasticsearchConfig sets the ElasticsearchConfig field's value.
func (s *CreateDataSourceInput) SetElasticsearchConfig(v *ElasticsearchDataSourceConfig) *CreateDataSourceInput {
	s.ElasticsearchConfig = v
	return s
}

// SetHttpConfig sets the HttpConfig field's value.
func (s *CreateDataSourceInput) SetHttpConfig(v *HttpDataSourceConfig) *CreateDataSourceInput {
	s.HttpConfig = v
	return s
}

// SetLambdaConfig sets the LambdaConfig field's value.
func (s *CreateDataSourceInput) SetLambdaConfig(v *LambdaDataSourceConfig) *CreateDataSourceInput {
	s.LambdaConfig = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDataSourceInput) SetName(v string) *CreateDataSourceInput {
	s.Name = &v
	return s
}

// SetRelationalDatabaseConfig sets the RelationalDatabaseConfig field's value.
func (s *CreateDataSourceInput) SetRelationalDatabaseConfig(v *RelationalDatabaseDataSourceConfig) *CreateDataSourceInput {
	s.RelationalDatabaseConfig = v
	return s
}

// SetServiceRoleArn sets the ServiceRoleArn field's value.
func (s *CreateDataSourceInput) SetServiceRoleArn(v string) *CreateDataSourceInput {
	s.ServiceRoleArn = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateDataSourceInput) SetType(v string) *CreateDataSourceInput {
	s.Type = &v
	return s
}

type CreateDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// The DataSource object.
	DataSource *DataSource `locationName:"dataSource" type:"structure"`
}

// String returns the string representation
func (s CreateDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataSourceOutput) GoString() string {
	return s.String()
}

// SetDataSource sets the DataSource field's value.
func (s *CreateDataSourceOutput) SetDataSource(v *DataSource) *CreateDataSourceOutput {
	s.DataSource = v
	return s
}

type CreateFunctionInput struct {
	_ struct{} `type:"structure"`

	// The GraphQL API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The FunctionDataSource name.
	//
	// DataSourceName is a required field
	DataSourceName *string `locationName:"dataSourceName" type:"string" required:"true"`

	// The Function description.
	Description *string `locationName:"description" type:"string"`

	// The version of the request mapping template. Currently the supported value
	// is 2018-05-29.
	//
	// FunctionVersion is a required field
	FunctionVersion *string `locationName:"functionVersion" type:"string" required:"true"`

	// The Function name. The function name does not have to be unique.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The Function request mapping template. Functions support only the 2018-05-29
	// version of the request mapping template.
	//
	// RequestMappingTemplate is a required field
	RequestMappingTemplate *string `locationName:"requestMappingTemplate" min:"1" type:"string" required:"true"`

	// The Function response mapping template.
	ResponseMappingTemplate *string `locationName:"responseMappingTemplate" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFunctionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFunctionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFunctionInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.DataSourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceName"))
	}
	if s.FunctionVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionVersion"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.RequestMappingTemplate == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestMappingTemplate"))
	}
	if s.RequestMappingTemplate != nil && len(*s.RequestMappingTemplate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestMappingTemplate", 1))
	}
	if s.ResponseMappingTemplate != nil && len(*s.ResponseMappingTemplate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResponseMappingTemplate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *CreateFunctionInput) SetApiId(v string) *CreateFunctionInput {
	s.ApiId = &v
	return s
}

// SetDataSourceName sets the DataSourceName field's value.
func (s *CreateFunctionInput) SetDataSourceName(v string) *CreateFunctionInput {
	s.DataSourceName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateFunctionInput) SetDescription(v string) *CreateFunctionInput {
	s.Description = &v
	return s
}

// SetFunctionVersion sets the FunctionVersion field's value.
func (s *CreateFunctionInput) SetFunctionVersion(v string) *CreateFunctionInput {
	s.FunctionVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFunctionInput) SetName(v string) *CreateFunctionInput {
	s.Name = &v
	return s
}

// SetRequestMappingTemplate sets the RequestMappingTemplate field's value.
func (s *CreateFunctionInput) SetRequestMappingTemplate(v string) *CreateFunctionInput {
	s.RequestMappingTemplate = &v
	return s
}

// SetResponseMappingTemplate sets the ResponseMappingTemplate field's value.
func (s *CreateFunctionInput) SetResponseMappingTemplate(v string) *CreateFunctionInput {
	s.ResponseMappingTemplate = &v
	return s
}

type CreateFunctionOutput struct {
	_ struct{} `type:"structure"`

	// The Function object.
	FunctionConfiguration *FunctionConfiguration `locationName:"functionConfiguration" type:"structure"`
}

// String returns the string representation
func (s CreateFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFunctionOutput) GoString() string {
	return s.String()
}

// SetFunctionConfiguration sets the FunctionConfiguration field's value.
func (s *CreateFunctionOutput) SetFunctionConfiguration(v *FunctionConfiguration) *CreateFunctionOutput {
	s.FunctionConfiguration = v
	return s
}

type CreateGraphqlApiInput struct {
	_ struct{} `type:"structure"`

	// The authentication type: API key, AWS IAM, or Amazon Cognito user pools.
	//
	// AuthenticationType is a required field
	AuthenticationType *string `locationName:"authenticationType" type:"string" required:"true" enum:"AuthenticationType"`

	// The Amazon CloudWatch Logs configuration.
	LogConfig *LogConfig `locationName:"logConfig" type:"structure"`

	// A user-supplied name for the GraphqlApi.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The OpenID Connect configuration.
	OpenIDConnectConfig *OpenIDConnectConfig `locationName:"openIDConnectConfig" type:"structure"`

	// The Amazon Cognito user pool configuration.
	UserPoolConfig *UserPoolConfig `locationName:"userPoolConfig" type:"structure"`
}

// String returns the string representation
func (s CreateGraphqlApiInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGraphqlApiInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGraphqlApiInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGraphqlApiInput"}
	if s.AuthenticationType == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthenticationType"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.LogConfig != nil {
		if err := s.LogConfig.Validate(); err != nil {
			invalidParams.AddNested("LogConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OpenIDConnectConfig != nil {
		if err := s.OpenIDConnectConfig.Validate(); err != nil {
			invalidParams.AddNested("OpenIDConnectConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.UserPoolConfig != nil {
		if err := s.UserPoolConfig.Validate(); err != nil {
			invalidParams.AddNested("UserPoolConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationType sets the AuthenticationType field's value.
func (s *CreateGraphqlApiInput) SetAuthenticationType(v string) *CreateGraphqlApiInput {
	s.AuthenticationType = &v
	return s
}

// SetLogConfig sets the LogConfig field's value.
func (s *CreateGraphqlApiInput) SetLogConfig(v *LogConfig) *CreateGraphqlApiInput {
	s.LogConfig = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateGraphqlApiInput) SetName(v string) *CreateGraphqlApiInput {
	s.Name = &v
	return s
}

// SetOpenIDConnectConfig sets the OpenIDConnectConfig field's value.
func (s *CreateGraphqlApiInput) SetOpenIDConnectConfig(v *OpenIDConnectConfig) *CreateGraphqlApiInput {
	s.OpenIDConnectConfig = v
	return s
}

// SetUserPoolConfig sets the UserPoolConfig field's value.
func (s *CreateGraphqlApiInput) SetUserPoolConfig(v *UserPoolConfig) *CreateGraphqlApiInput {
	s.UserPoolConfig = v
	return s
}

type CreateGraphqlApiOutput struct {
	_ struct{} `type:"structure"`

	// The GraphqlApi.
	GraphqlApi *GraphqlApi `locationName:"graphqlApi" type:"structure"`
}

// String returns the string representation
func (s CreateGraphqlApiOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGraphqlApiOutput) GoString() string {
	return s.String()
}

// SetGraphqlApi sets the GraphqlApi field's value.
func (s *CreateGraphqlApiOutput) SetGraphqlApi(v *GraphqlApi) *CreateGraphqlApiOutput {
	s.GraphqlApi = v
	return s
}

type CreateResolverInput struct {
	_ struct{} `type:"structure"`

	// The ID for the GraphQL API for which the resolver is being created.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The name of the data source for which the resolver is being created.
	DataSourceName *string `locationName:"dataSourceName" type:"string"`

	// The name of the field to attach the resolver to.
	//
	// FieldName is a required field
	FieldName *string `locationName:"fieldName" type:"string" required:"true"`

	// The resolver type.
	//
	//    * UNIT: A UNIT resolver type. A UNIT resolver is the default resolver
	//    type. A UNIT resolver enables you to execute a GraphQL query against a
	//    single data source.
	//
	//    * PIPELINE: A PIPELINE resolver type. A PIPELINE resolver enables you
	//    to execute a series of Function in a serial manner. You can use a pipeline
	//    resolver to execute a GraphQL query against multiple data sources.
	Kind *string `locationName:"kind" type:"string" enum:"ResolverKind"`

	// The PipelineConfig.
	PipelineConfig *PipelineConfig `locationName:"pipelineConfig" type:"structure"`

	// The mapping template to be used for requests.
	//
	// A resolver uses a request mapping template to convert a GraphQL expression
	// into a format that a data source can understand. Mapping templates are written
	// in Apache Velocity Template Language (VTL).
	//
	// RequestMappingTemplate is a required field
	RequestMappingTemplate *string `locationName:"requestMappingTemplate" min:"1" type:"string" required:"true"`

	// The mapping template to be used for responses from the data source.
	ResponseMappingTemplate *string `locationName:"responseMappingTemplate" min:"1" type:"string"`

	// The name of the Type.
	//
	// TypeName is a required field
	TypeName *string `location:"uri" locationName:"typeName" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateResolverInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResolverInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResolverInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResolverInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.FieldName == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldName"))
	}
	if s.RequestMappingTemplate == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestMappingTemplate"))
	}
	if s.RequestMappingTemplate != nil && len(*s.RequestMappingTemplate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestMappingTemplate", 1))
	}
	if s.ResponseMappingTemplate != nil && len(*s.ResponseMappingTemplate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResponseMappingTemplate", 1))
	}
	if s.TypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("TypeName"))
	}
	if s.TypeName != nil && len(*s.TypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *CreateResolverInput) SetApiId(v string) *CreateResolverInput {
	s.ApiId = &v
	return s
}

// SetDataSourceName sets the DataSourceName field's value.
func (s *CreateResolverInput) SetDataSourceName(v string) *CreateResolverInput {
	s.DataSourceName = &v
	return s
}

// SetFieldName sets the FieldName field's value.
func (s *CreateResolverInput) SetFieldName(v string) *CreateResolverInput {
	s.FieldName = &v
	return s
}

// SetKind sets the Kind field's value.
func (s *CreateResolverInput) SetKind(v string) *CreateResolverInput {
	s.Kind = &v
	return s
}

// SetPipelineConfig sets the PipelineConfig field's value.
func (s *CreateResolverInput) SetPipelineConfig(v *PipelineConfig) *CreateResolverInput {
	s.PipelineConfig = v
	return s
}

// SetRequestMappingTemplate sets the RequestMappingTemplate field's value.
func (s *CreateResolverInput) SetRequestMappingTemplate(v string) *CreateResolverInput {
	s.RequestMappingTemplate = &v
	return s
}

// SetResponseMappingTemplate sets the ResponseMappingTemplate field's value.
func (s *CreateResolverInput) SetResponseMappingTemplate(v string) *CreateResolverInput {
	s.ResponseMappingTemplate = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *CreateResolverInput) SetTypeName(v string) *CreateResolverInput {
	s.TypeName = &v
	return s
}

type CreateResolverOutput struct {
	_ struct{} `type:"structure"`

	// The Resolver object.
	Resolver *Resolver `locationName:"resolver" type:"structure"`
}

// String returns the string representation
func (s CreateResolverOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResolverOutput) GoString() string {
	return s.String()
}

// SetResolver sets the Resolver field's value.
func (s *CreateResolverOutput) SetResolver(v *Resolver) *CreateResolverOutput {
	s.Resolver = v
	return s
}

type CreateTypeInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The type definition, in GraphQL Schema Definition Language (SDL) format.
	//
	// For more information, see the GraphQL SDL documentation (http://graphql.org/learn/schema/).
	//
	// Definition is a required field
	Definition *string `locationName:"definition" type:"string" required:"true"`

	// The type format: SDL or JSON.
	//
	// Format is a required field
	Format *string `locationName:"format" type:"string" required:"true" enum:"TypeDefinitionFormat"`
}

// String returns the string representation
func (s CreateTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTypeInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.Definition == nil {
		invalidParams.Add(request.NewErrParamRequired("Definition"))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *CreateTypeInput) SetApiId(v string) *CreateTypeInput {
	s.ApiId = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *CreateTypeInput) SetDefinition(v string) *CreateTypeInput {
	s.Definition = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *CreateTypeInput) SetFormat(v string) *CreateTypeInput {
	s.Format = &v
	return s
}

type CreateTypeOutput struct {
	_ struct{} `type:"structure"`

	// The Type object.
	Type *Type `locationName:"type" type:"structure"`
}

// String returns the string representation
func (s CreateTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTypeOutput) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *CreateTypeOutput) SetType(v *Type) *CreateTypeOutput {
	s.Type = v
	return s
}

// Describes a data source.
type DataSource struct {
	_ struct{} `type:"structure"`

	// The data source ARN.
	DataSourceArn *string `locationName:"dataSourceArn" type:"string"`

	// The description of the data source.
	Description *string `locationName:"description" type:"string"`

	// Amazon DynamoDB settings.
	DynamodbConfig *DynamodbDataSourceConfig `locationName:"dynamodbConfig" type:"structure"`

	// Amazon Elasticsearch Service settings.
	ElasticsearchConfig *ElasticsearchDataSourceConfig `locationName:"elasticsearchConfig" type:"structure"`

	// HTTP endpoint settings.
	HttpConfig *HttpDataSourceConfig `locationName:"httpConfig" type:"structure"`

	// AWS Lambda settings.
	LambdaConfig *LambdaDataSourceConfig `locationName:"lambdaConfig" type:"structure"`

	// The name of the data source.
	Name *string `locationName:"name" type:"string"`

	// Relational database settings.
	RelationalDatabaseConfig *RelationalDatabaseDataSourceConfig `locationName:"relationalDatabaseConfig" type:"structure"`

	// The AWS IAM service role ARN for the data source. The system assumes this
	// role when accessing the data source.
	ServiceRoleArn *string `locationName:"serviceRoleArn" type:"string"`

	// The type of the data source.
	//
	//    * AMAZON_DYNAMODB: The data source is an Amazon DynamoDB table.
	//
	//    * AMAZON_ELASTICSEARCH: The data source is an Amazon Elasticsearch Service
	//    domain.
	//
	//    * AWS_LAMBDA: The data source is an AWS Lambda function.
	//
	//    * NONE: There is no data source. This type is used when you wish to invoke
	//    a GraphQL operation without connecting to a data source, such as performing
	//    data transformation with resolvers or triggering a subscription to be
	//    invoked from a mutation.
	//
	//    * HTTP: The data source is an HTTP endpoint.
	//
	//    * RELATIONAL_DATABASE: The data source is a relational database.
	Type *string `locationName:"type" type:"string" enum:"DataSourceType"`
}

// String returns the string representation
func (s DataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataSource) GoString() string {
	return s.String()
}

// SetDataSourceArn sets the DataSourceArn field's value.
func (s *DataSource) SetDataSourceArn(v string) *DataSource {
	s.DataSourceArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DataSource) SetDescription(v string) *DataSource {
	s.Description = &v
	return s
}

// SetDynamodbConfig sets the DynamodbConfig field's value.
func (s *DataSource) SetDynamodbConfig(v *DynamodbDataSourceConfig) *DataSource {
	s.DynamodbConfig = v
	return s
}

// SetElasticsearchConfig sets the ElasticsearchConfig field's value.
func (s *DataSource) SetElasticsearchConfig(v *ElasticsearchDataSourceConfig) *DataSource {
	s.ElasticsearchConfig = v
	return s
}

// SetHttpConfig sets the HttpConfig field's value.
func (s *DataSource) SetHttpConfig(v *HttpDataSourceConfig) *DataSource {
	s.HttpConfig = v
	return s
}

// SetLambdaConfig sets the LambdaConfig field's value.
func (s *DataSource) SetLambdaConfig(v *LambdaDataSourceConfig) *DataSource {
	s.LambdaConfig = v
	return s
}

// SetName sets the Name field's value.
func (s *DataSource) SetName(v string) *DataSource {
	s.Name = &v
	return s
}

// SetRelationalDatabaseConfig sets the RelationalDatabaseConfig field's value.
func (s *DataSource) SetRelationalDatabaseConfig(v *RelationalDatabaseDataSourceConfig) *DataSource {
	s.RelationalDatabaseConfig = v
	return s
}

// SetServiceRoleArn sets the ServiceRoleArn field's value.
func (s *DataSource) SetServiceRoleArn(v string) *DataSource {
	s.ServiceRoleArn = &v
	return s
}

// SetType sets the Type field's value.
func (s *DataSource) SetType(v string) *DataSource {
	s.Type = &v
	return s
}

type DeleteApiKeyInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The ID for the API key.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApiKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApiKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApiKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApiKeyInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *DeleteApiKeyInput) SetApiId(v string) *DeleteApiKeyInput {
	s.ApiId = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteApiKeyInput) SetId(v string) *DeleteApiKeyInput {
	s.Id = &v
	return s
}

type DeleteApiKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteApiKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApiKeyOutput) GoString() string {
	return s.String()
}

type DeleteDataSourceInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The name of the data source.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDataSourceInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *DeleteDataSourceInput) SetApiId(v string) *DeleteDataSourceInput {
	s.ApiId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteDataSourceInput) SetName(v string) *DeleteDataSourceInput {
	s.Name = &v
	return s
}

type DeleteDataSourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDataSourceOutput) GoString() string {
	return s.String()
}

type DeleteFunctionInput struct {
	_ struct{} `type:"structure"`

	// The GraphQL API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The Function ID.
	//
	// FunctionId is a required field
	FunctionId *string `location:"uri" locationName:"functionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFunctionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFunctionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFunctionInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.FunctionId == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionId"))
	}
	if s.FunctionId != nil && len(*s.FunctionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *DeleteFunctionInput) SetApiId(v string) *DeleteFunctionInput {
	s.ApiId = &v
	return s
}

// SetFunctionId sets the FunctionId field's value.
func (s *DeleteFunctionInput) SetFunctionId(v string) *DeleteFunctionInput {
	s.FunctionId = &v
	return s
}

type DeleteFunctionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFunctionOutput) GoString() string {
	return s.String()
}

type DeleteGraphqlApiInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGraphqlApiInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGraphqlApiInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGraphqlApiInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGraphqlApiInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *DeleteGraphqlApiInput) SetApiId(v string) *DeleteGraphqlApiInput {
	s.ApiId = &v
	return s
}

type DeleteGraphqlApiOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteGraphqlApiOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGraphqlApiOutput) GoString() string {
	return s.String()
}

type DeleteResolverInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The resolver field name.
	//
	// FieldName is a required field
	FieldName *string `location:"uri" locationName:"fieldName" type:"string" required:"true"`

	// The name of the resolver type.
	//
	// TypeName is a required field
	TypeName *string `location:"uri" locationName:"typeName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteResolverInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResolverInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResolverInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResolverInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.FieldName == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldName"))
	}
	if s.FieldName != nil && len(*s.FieldName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FieldName", 1))
	}
	if s.TypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("TypeName"))
	}
	if s.TypeName != nil && len(*s.TypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *DeleteResolverInput) SetApiId(v string) *DeleteResolverInput {
	s.ApiId = &v
	return s
}

// SetFieldName sets the FieldName field's value.
func (s *DeleteResolverInput) SetFieldName(v string) *DeleteResolverInput {
	s.FieldName = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *DeleteResolverInput) SetTypeName(v string) *DeleteResolverInput {
	s.TypeName = &v
	return s
}

type DeleteResolverOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteResolverOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResolverOutput) GoString() string {
	return s.String()
}

type DeleteTypeInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The type name.
	//
	// TypeName is a required field
	TypeName *string `location:"uri" locationName:"typeName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTypeInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.TypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("TypeName"))
	}
	if s.TypeName != nil && len(*s.TypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *DeleteTypeInput) SetApiId(v string) *DeleteTypeInput {
	s.ApiId = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *DeleteTypeInput) SetTypeName(v string) *DeleteTypeInput {
	s.TypeName = &v
	return s
}

type DeleteTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTypeOutput) GoString() string {
	return s.String()
}

// Describes an Amazon DynamoDB data source configuration.
type DynamodbDataSourceConfig struct {
	_ struct{} `type:"structure"`

	// The AWS Region.
	//
	// AwsRegion is a required field
	AwsRegion *string `locationName:"awsRegion" type:"string" required:"true"`

	// The table name.
	//
	// TableName is a required field
	TableName *string `locationName:"tableName" type:"string" required:"true"`

	// Set to TRUE to use Amazon Cognito credentials with this data source.
	UseCallerCredentials *bool `locationName:"useCallerCredentials" type:"boolean"`
}

// String returns the string representation
func (s DynamodbDataSourceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DynamodbDataSourceConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DynamodbDataSourceConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DynamodbDataSourceConfig"}
	if s.AwsRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsRegion"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *DynamodbDataSourceConfig) SetAwsRegion(v string) *DynamodbDataSourceConfig {
	s.AwsRegion = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *DynamodbDataSourceConfig) SetTableName(v string) *DynamodbDataSourceConfig {
	s.TableName = &v
	return s
}

// SetUseCallerCredentials sets the UseCallerCredentials field's value.
func (s *DynamodbDataSourceConfig) SetUseCallerCredentials(v bool) *DynamodbDataSourceConfig {
	s.UseCallerCredentials = &v
	return s
}

// Describes an Elasticsearch data source configuration.
type ElasticsearchDataSourceConfig struct {
	_ struct{} `type:"structure"`

	// The AWS Region.
	//
	// AwsRegion is a required field
	AwsRegion *string `locationName:"awsRegion" type:"string" required:"true"`

	// The endpoint.
	//
	// Endpoint is a required field
	Endpoint *string `locationName:"endpoint" type:"string" required:"true"`
}

// String returns the string representation
func (s ElasticsearchDataSourceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticsearchDataSourceConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ElasticsearchDataSourceConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ElasticsearchDataSourceConfig"}
	if s.AwsRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsRegion"))
	}
	if s.Endpoint == nil {
		invalidParams.Add(request.NewErrParamRequired("Endpoint"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *ElasticsearchDataSourceConfig) SetAwsRegion(v string) *ElasticsearchDataSourceConfig {
	s.AwsRegion = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *ElasticsearchDataSourceConfig) SetEndpoint(v string) *ElasticsearchDataSourceConfig {
	s.Endpoint = &v
	return s
}

// A function is a reusable entity. Multiple functions can be used to compose
// the resolver logic.
type FunctionConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the DataSource.
	DataSourceName *string `locationName:"dataSourceName" type:"string"`

	// The Function description.
	Description *string `locationName:"description" type:"string"`

	// The ARN of the Function object.
	FunctionArn *string `locationName:"functionArn" type:"string"`

	// A unique ID representing the Function object.
	FunctionId *string `locationName:"functionId" type:"string"`

	// The version of the request mapping template. Currently only the 2018-05-29
	// version of the template is supported.
	FunctionVersion *string `locationName:"functionVersion" type:"string"`

	// The name of the Function object.
	Name *string `locationName:"name" type:"string"`

	// The Function request mapping template. Functions support only the 2018-05-29
	// version of the request mapping template.
	RequestMappingTemplate *string `locationName:"requestMappingTemplate" min:"1" type:"string"`

	// The Function response mapping template.
	ResponseMappingTemplate *string `locationName:"responseMappingTemplate" min:"1" type:"string"`
}

// String returns the string representation
func (s FunctionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FunctionConfiguration) GoString() string {
	return s.String()
}

// SetDataSourceName sets the DataSourceName field's value.
func (s *FunctionConfiguration) SetDataSourceName(v string) *FunctionConfiguration {
	s.DataSourceName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *FunctionConfiguration) SetDescription(v string) *FunctionConfiguration {
	s.Description = &v
	return s
}

// SetFunctionArn sets the FunctionArn field's value.
func (s *FunctionConfiguration) SetFunctionArn(v string) *FunctionConfiguration {
	s.FunctionArn = &v
	return s
}

// SetFunctionId sets the FunctionId field's value.
func (s *FunctionConfiguration) SetFunctionId(v string) *FunctionConfiguration {
	s.FunctionId = &v
	return s
}

// SetFunctionVersion sets the FunctionVersion field's value.
func (s *FunctionConfiguration) SetFunctionVersion(v string) *FunctionConfiguration {
	s.FunctionVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *FunctionConfiguration) SetName(v string) *FunctionConfiguration {
	s.Name = &v
	return s
}

// SetRequestMappingTemplate sets the RequestMappingTemplate field's value.
func (s *FunctionConfiguration) SetRequestMappingTemplate(v string) *FunctionConfiguration {
	s.RequestMappingTemplate = &v
	return s
}

// SetResponseMappingTemplate sets the ResponseMappingTemplate field's value.
func (s *FunctionConfiguration) SetResponseMappingTemplate(v string) *FunctionConfiguration {
	s.ResponseMappingTemplate = &v
	return s
}

type GetDataSourceInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The name of the data source.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDataSourceInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *GetDataSourceInput) SetApiId(v string) *GetDataSourceInput {
	s.ApiId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetDataSourceInput) SetName(v string) *GetDataSourceInput {
	s.Name = &v
	return s
}

type GetDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// The DataSource object.
	DataSource *DataSource `locationName:"dataSource" type:"structure"`
}

// String returns the string representation
func (s GetDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDataSourceOutput) GoString() string {
	return s.String()
}

// SetDataSource sets the DataSource field's value.
func (s *GetDataSourceOutput) SetDataSource(v *DataSource) *GetDataSourceOutput {
	s.DataSource = v
	return s
}

type GetFunctionInput struct {
	_ struct{} `type:"structure"`

	// The GraphQL API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The Function ID.
	//
	// FunctionId is a required field
	FunctionId *string `location:"uri" locationName:"functionId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFunctionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFunctionInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.FunctionId == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionId"))
	}
	if s.FunctionId != nil && len(*s.FunctionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *GetFunctionInput) SetApiId(v string) *GetFunctionInput {
	s.ApiId = &v
	return s
}

// SetFunctionId sets the FunctionId field's value.
func (s *GetFunctionInput) SetFunctionId(v string) *GetFunctionInput {
	s.FunctionId = &v
	return s
}

type GetFunctionOutput struct {
	_ struct{} `type:"structure"`

	// The Function object.
	FunctionConfiguration *FunctionConfiguration `locationName:"functionConfiguration" type:"structure"`
}

// String returns the string representation
func (s GetFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionOutput) GoString() string {
	return s.String()
}

// SetFunctionConfiguration sets the FunctionConfiguration field's value.
func (s *GetFunctionOutput) SetFunctionConfiguration(v *FunctionConfiguration) *GetFunctionOutput {
	s.FunctionConfiguration = v
	return s
}

type GetGraphqlApiInput struct {
	_ struct{} `type:"structure"`

	// The API ID for the GraphQL API.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetGraphqlApiInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGraphqlApiInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGraphqlApiInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGraphqlApiInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *GetGraphqlApiInput) SetApiId(v string) *GetGraphqlApiInput {
	s.ApiId = &v
	return s
}

type GetGraphqlApiOutput struct {
	_ struct{} `type:"structure"`

	// The GraphqlApi object.
	GraphqlApi *GraphqlApi `locationName:"graphqlApi" type:"structure"`
}

// String returns the string representation
func (s GetGraphqlApiOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGraphqlApiOutput) GoString() string {
	return s.String()
}

// SetGraphqlApi sets the GraphqlApi field's value.
func (s *GetGraphqlApiOutput) SetGraphqlApi(v *GraphqlApi) *GetGraphqlApiOutput {
	s.GraphqlApi = v
	return s
}

type GetIntrospectionSchemaInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The schema format: SDL or JSON.
	//
	// Format is a required field
	Format *string `location:"querystring" locationName:"format" type:"string" required:"true" enum:"OutputType"`
}

// String returns the string representation
func (s GetIntrospectionSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIntrospectionSchemaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIntrospectionSchemaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIntrospectionSchemaInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *GetIntrospectionSchemaInput) SetApiId(v string) *GetIntrospectionSchemaInput {
	s.ApiId = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *GetIntrospectionSchemaInput) SetFormat(v string) *GetIntrospectionSchemaInput {
	s.Format = &v
	return s
}

type GetIntrospectionSchemaOutput struct {
	_ struct{} `type:"structure" payload:"Schema"`

	// The schema, in GraphQL Schema Definition Language (SDL) format.
	//
	// For more information, see the GraphQL SDL documentation (http://graphql.org/learn/schema/).
	Schema []byte `locationName:"schema" type:"blob"`
}

// String returns the string representation
func (s GetIntrospectionSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIntrospectionSchemaOutput) GoString() string {
	return s.String()
}

// SetSchema sets the Schema field's value.
func (s *GetIntrospectionSchemaOutput) SetSchema(v []byte) *GetIntrospectionSchemaOutput {
	s.Schema = v
	return s
}

type GetResolverInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The resolver field name.
	//
	// FieldName is a required field
	FieldName *string `location:"uri" locationName:"fieldName" type:"string" required:"true"`

	// The resolver type name.
	//
	// TypeName is a required field
	TypeName *string `location:"uri" locationName:"typeName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetResolverInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResolverInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResolverInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResolverInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.FieldName == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldName"))
	}
	if s.FieldName != nil && len(*s.FieldName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FieldName", 1))
	}
	if s.TypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("TypeName"))
	}
	if s.TypeName != nil && len(*s.TypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *GetResolverInput) SetApiId(v string) *GetResolverInput {
	s.ApiId = &v
	return s
}

// SetFieldName sets the FieldName field's value.
func (s *GetResolverInput) SetFieldName(v string) *GetResolverInput {
	s.FieldName = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *GetResolverInput) SetTypeName(v string) *GetResolverInput {
	s.TypeName = &v
	return s
}

type GetResolverOutput struct {
	_ struct{} `type:"structure"`

	// The Resolver object.
	Resolver *Resolver `locationName:"resolver" type:"structure"`
}

// String returns the string representation
func (s GetResolverOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResolverOutput) GoString() string {
	return s.String()
}

// SetResolver sets the Resolver field's value.
func (s *GetResolverOutput) SetResolver(v *Resolver) *GetResolverOutput {
	s.Resolver = v
	return s
}

type GetSchemaCreationStatusInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSchemaCreationStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSchemaCreationStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSchemaCreationStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSchemaCreationStatusInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *GetSchemaCreationStatusInput) SetApiId(v string) *GetSchemaCreationStatusInput {
	s.ApiId = &v
	return s
}

type GetSchemaCreationStatusOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about the status of the schema creation operation.
	Details *string `locationName:"details" type:"string"`

	// The current state of the schema (PROCESSING, ACTIVE, or DELETING). Once the
	// schema is in the ACTIVE state, you can add data.
	Status *string `locationName:"status" type:"string" enum:"SchemaStatus"`
}

// String returns the string representation
func (s GetSchemaCreationStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSchemaCreationStatusOutput) GoString() string {
	return s.String()
}

// SetDetails sets the Details field's value.
func (s *GetSchemaCreationStatusOutput) SetDetails(v string) *GetSchemaCreationStatusOutput {
	s.Details = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetSchemaCreationStatusOutput) SetStatus(v string) *GetSchemaCreationStatusOutput {
	s.Status = &v
	return s
}

type GetTypeInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The type format: SDL or JSON.
	//
	// Format is a required field
	Format *string `location:"querystring" locationName:"format" type:"string" required:"true" enum:"TypeDefinitionFormat"`

	// The type name.
	//
	// TypeName is a required field
	TypeName *string `location:"uri" locationName:"typeName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTypeInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.TypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("TypeName"))
	}
	if s.TypeName != nil && len(*s.TypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *GetTypeInput) SetApiId(v string) *GetTypeInput {
	s.ApiId = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *GetTypeInput) SetFormat(v string) *GetTypeInput {
	s.Format = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *GetTypeInput) SetTypeName(v string) *GetTypeInput {
	s.TypeName = &v
	return s
}

type GetTypeOutput struct {
	_ struct{} `type:"structure"`

	// The Type object.
	Type *Type `locationName:"type" type:"structure"`
}

// String returns the string representation
func (s GetTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTypeOutput) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *GetTypeOutput) SetType(v *Type) *GetTypeOutput {
	s.Type = v
	return s
}

// Describes a GraphQL API.
type GraphqlApi struct {
	_ struct{} `type:"structure"`

	// The API ID.
	ApiId *string `locationName:"apiId" type:"string"`

	// The ARN.
	Arn *string `locationName:"arn" type:"string"`

	// The authentication type.
	AuthenticationType *string `locationName:"authenticationType" type:"string" enum:"AuthenticationType"`

	// The Amazon CloudWatch Logs configuration.
	LogConfig *LogConfig `locationName:"logConfig" type:"structure"`

	// The API name.
	Name *string `locationName:"name" type:"string"`

	// The OpenID Connect configuration.
	OpenIDConnectConfig *OpenIDConnectConfig `locationName:"openIDConnectConfig" type:"structure"`

	// The URIs.
	Uris map[string]*string `locationName:"uris" type:"map"`

	// The Amazon Cognito user pool configuration.
	UserPoolConfig *UserPoolConfig `locationName:"userPoolConfig" type:"structure"`
}

// String returns the string representation
func (s GraphqlApi) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GraphqlApi) GoString() string {
	return s.String()
}

// SetApiId sets the ApiId field's value.
func (s *GraphqlApi) SetApiId(v string) *GraphqlApi {
	s.ApiId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *GraphqlApi) SetArn(v string) *GraphqlApi {
	s.Arn = &v
	return s
}

// SetAuthenticationType sets the AuthenticationType field's value.
func (s *GraphqlApi) SetAuthenticationType(v string) *GraphqlApi {
	s.AuthenticationType = &v
	return s
}

// SetLogConfig sets the LogConfig field's value.
func (s *GraphqlApi) SetLogConfig(v *LogConfig) *GraphqlApi {
	s.LogConfig = v
	return s
}

// SetName sets the Name field's value.
func (s *GraphqlApi) SetName(v string) *GraphqlApi {
	s.Name = &v
	return s
}

// SetOpenIDConnectConfig sets the OpenIDConnectConfig field's value.
func (s *GraphqlApi) SetOpenIDConnectConfig(v *OpenIDConnectConfig) *GraphqlApi {
	s.OpenIDConnectConfig = v
	return s
}

// SetUris sets the Uris field's value.
func (s *GraphqlApi) SetUris(v map[string]*string) *GraphqlApi {
	s.Uris = v
	return s
}

// SetUserPoolConfig sets the UserPoolConfig field's value.
func (s *GraphqlApi) SetUserPoolConfig(v *UserPoolConfig) *GraphqlApi {
	s.UserPoolConfig = v
	return s
}

// Describes an HTTP data source configuration.
type HttpDataSourceConfig struct {
	_ struct{} `type:"structure"`

	// The authorization config in case the HTTP endpoint requires authorization.
	AuthorizationConfig *AuthorizationConfig `locationName:"authorizationConfig" type:"structure"`

	// The HTTP URL endpoint. You can either specify the domain name or IP, and
	// port combination, and the URL scheme must be HTTP or HTTPS. If the port is
	// not specified, AWS AppSync uses the default port 80 for the HTTP endpoint
	// and port 443 for HTTPS endpoints.
	Endpoint *string `locationName:"endpoint" type:"string"`
}

// String returns the string representation
func (s HttpDataSourceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HttpDataSourceConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpDataSourceConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HttpDataSourceConfig"}
	if s.AuthorizationConfig != nil {
		if err := s.AuthorizationConfig.Validate(); err != nil {
			invalidParams.AddNested("AuthorizationConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizationConfig sets the AuthorizationConfig field's value.
func (s *HttpDataSourceConfig) SetAuthorizationConfig(v *AuthorizationConfig) *HttpDataSourceConfig {
	s.AuthorizationConfig = v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *HttpDataSourceConfig) SetEndpoint(v string) *HttpDataSourceConfig {
	s.Endpoint = &v
	return s
}

// Describes an AWS Lambda data source configuration.
type LambdaDataSourceConfig struct {
	_ struct{} `type:"structure"`

	// The ARN for the Lambda function.
	//
	// LambdaFunctionArn is a required field
	LambdaFunctionArn *string `locationName:"lambdaFunctionArn" type:"string" required:"true"`
}

// String returns the string representation
func (s LambdaDataSourceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaDataSourceConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaDataSourceConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaDataSourceConfig"}
	if s.LambdaFunctionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LambdaFunctionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLambdaFunctionArn sets the LambdaFunctionArn field's value.
func (s *LambdaDataSourceConfig) SetLambdaFunctionArn(v string) *LambdaDataSourceConfig {
	s.LambdaFunctionArn = &v
	return s
}

type ListApiKeysInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The maximum number of results you want the request to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListApiKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApiKeysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApiKeysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApiKeysInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *ListApiKeysInput) SetApiId(v string) *ListApiKeysInput {
	s.ApiId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListApiKeysInput) SetMaxResults(v int64) *ListApiKeysInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApiKeysInput) SetNextToken(v string) *ListApiKeysInput {
	s.NextToken = &v
	return s
}

type ListApiKeysOutput struct {
	_ struct{} `type:"structure"`

	// The ApiKey objects.
	ApiKeys []*ApiKey `locationName:"apiKeys" type:"list"`

	// An identifier to be passed in the next request to this operation to return
	// the next set of items in the list.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListApiKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApiKeysOutput) GoString() string {
	return s.String()
}

// SetApiKeys sets the ApiKeys field's value.
func (s *ListApiKeysOutput) SetApiKeys(v []*ApiKey) *ListApiKeysOutput {
	s.ApiKeys = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApiKeysOutput) SetNextToken(v string) *ListApiKeysOutput {
	s.NextToken = &v
	return s
}

type ListDataSourcesInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The maximum number of results you want the request to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDataSourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDataSourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDataSourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDataSourcesInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *ListDataSourcesInput) SetApiId(v string) *ListDataSourcesInput {
	s.ApiId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDataSourcesInput) SetMaxResults(v int64) *ListDataSourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataSourcesInput) SetNextToken(v string) *ListDataSourcesInput {
	s.NextToken = &v
	return s
}

type ListDataSourcesOutput struct {
	_ struct{} `type:"structure"`

	// The DataSource objects.
	DataSources []*DataSource `locationName:"dataSources" type:"list"`

	// An identifier to be passed in the next request to this operation to return
	// the next set of items in the list.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDataSourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDataSourcesOutput) GoString() string {
	return s.String()
}

// SetDataSources sets the DataSources field's value.
func (s *ListDataSourcesOutput) SetDataSources(v []*DataSource) *ListDataSourcesOutput {
	s.DataSources = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataSourcesOutput) SetNextToken(v string) *ListDataSourcesOutput {
	s.NextToken = &v
	return s
}

type ListFunctionsInput struct {
	_ struct{} `type:"structure"`

	// The GraphQL API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The maximum number of results you want the request to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListFunctionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFunctionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFunctionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFunctionsInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *ListFunctionsInput) SetApiId(v string) *ListFunctionsInput {
	s.ApiId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFunctionsInput) SetMaxResults(v int64) *ListFunctionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFunctionsInput) SetNextToken(v string) *ListFunctionsInput {
	s.NextToken = &v
	return s
}

type ListFunctionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of Function objects.
	Functions []*FunctionConfiguration `locationName:"functions" type:"list"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListFunctionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFunctionsOutput) GoString() string {
	return s.String()
}

// SetFunctions sets the Functions field's value.
func (s *ListFunctionsOutput) SetFunctions(v []*FunctionConfiguration) *ListFunctionsOutput {
	s.Functions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFunctionsOutput) SetNextToken(v string) *ListFunctionsOutput {
	s.NextToken = &v
	return s
}

type ListGraphqlApisInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results you want the request to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListGraphqlApisInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGraphqlApisInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGraphqlApisInput) SetMaxResults(v int64) *ListGraphqlApisInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGraphqlApisInput) SetNextToken(v string) *ListGraphqlApisInput {
	s.NextToken = &v
	return s
}

type ListGraphqlApisOutput struct {
	_ struct{} `type:"structure"`

	// The GraphqlApi objects.
	GraphqlApis []*GraphqlApi `locationName:"graphqlApis" type:"list"`

	// An identifier to be passed in the next request to this operation to return
	// the next set of items in the list.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListGraphqlApisOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGraphqlApisOutput) GoString() string {
	return s.String()
}

// SetGraphqlApis sets the GraphqlApis field's value.
func (s *ListGraphqlApisOutput) SetGraphqlApis(v []*GraphqlApi) *ListGraphqlApisOutput {
	s.GraphqlApis = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGraphqlApisOutput) SetNextToken(v string) *ListGraphqlApisOutput {
	s.NextToken = &v
	return s
}

type ListResolversByFunctionInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The Function ID.
	//
	// FunctionId is a required field
	FunctionId *string `location:"uri" locationName:"functionId" type:"string" required:"true"`

	// The maximum number of results you want the request to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// An identifier that was returned from the previous call to this operation,
	// which you can use to return the next set of items in the list.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListResolversByFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResolversByFunctionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResolversByFunctionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResolversByFunctionInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.FunctionId == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionId"))
	}
	if s.FunctionId != nil && len(*s.FunctionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *ListResolversByFunctionInput) SetApiId(v string) *ListResolversByFunctionInput {
	s.ApiId = &v
	return s
}

// SetFunctionId sets the FunctionId field's value.
func (s *ListResolversByFunctionInput) SetFunctionId(v string) *ListResolversByFunctionInput {
	s.FunctionId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolversByFunctionInput) SetMaxResults(v int64) *ListResolversByFunctionInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolversByFunctionInput) SetNextToken(v string) *ListResolversByFunctionInput {
	s.NextToken = &v
	return s
}

type ListResolversByFunctionOutput struct {
	_ struct{} `type:"structure"`

	// An identifier that can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of resolvers.
	Resolvers []*Resolver `locationName:"resolvers" type:"list"`
}

// String returns the string representation
func (s ListResolversByFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResolversByFunctionOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolversByFunctionOutput) SetNextToken(v string) *ListResolversByFunctionOutput {
	s.NextToken = &v
	return s
}

// SetResolvers sets the Resolvers field's value.
func (s *ListResolversByFunctionOutput) SetResolvers(v []*Resolver) *ListResolversByFunctionOutput {
	s.Resolvers = v
	return s
}

type ListResolversInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The maximum number of results you want the request to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The type name.
	//
	// TypeName is a required field
	TypeName *string `location:"uri" locationName:"typeName" type:"string" required:"true"`
}

// String returns the string representation
func (s ListResolversInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResolversInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResolversInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResolversInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.TypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("TypeName"))
	}
	if s.TypeName != nil && len(*s.TypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *ListResolversInput) SetApiId(v string) *ListResolversInput {
	s.ApiId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolversInput) SetMaxResults(v int64) *ListResolversInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolversInput) SetNextToken(v string) *ListResolversInput {
	s.NextToken = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *ListResolversInput) SetTypeName(v string) *ListResolversInput {
	s.TypeName = &v
	return s
}

type ListResolversOutput struct {
	_ struct{} `type:"structure"`

	// An identifier to be passed in the next request to this operation to return
	// the next set of items in the list.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The Resolver objects.
	Resolvers []*Resolver `locationName:"resolvers" type:"list"`
}

// String returns the string representation
func (s ListResolversOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResolversOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolversOutput) SetNextToken(v string) *ListResolversOutput {
	s.NextToken = &v
	return s
}

// SetResolvers sets the Resolvers field's value.
func (s *ListResolversOutput) SetResolvers(v []*Resolver) *ListResolversOutput {
	s.Resolvers = v
	return s
}

type ListTypesInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The type format: SDL or JSON.
	//
	// Format is a required field
	Format *string `location:"querystring" locationName:"format" type:"string" required:"true" enum:"TypeDefinitionFormat"`

	// The maximum number of results you want the request to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTypesInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *ListTypesInput) SetApiId(v string) *ListTypesInput {
	s.ApiId = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *ListTypesInput) SetFormat(v string) *ListTypesInput {
	s.Format = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTypesInput) SetMaxResults(v int64) *ListTypesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTypesInput) SetNextToken(v string) *ListTypesInput {
	s.NextToken = &v
	return s
}

type ListTypesOutput struct {
	_ struct{} `type:"structure"`

	// An identifier to be passed in the next request to this operation to return
	// the next set of items in the list.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The Type objects.
	Types []*Type `locationName:"types" type:"list"`
}

// String returns the string representation
func (s ListTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTypesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTypesOutput) SetNextToken(v string) *ListTypesOutput {
	s.NextToken = &v
	return s
}

// SetTypes sets the Types field's value.
func (s *ListTypesOutput) SetTypes(v []*Type) *ListTypesOutput {
	s.Types = v
	return s
}

// The CloudWatch Logs configuration.
type LogConfig struct {
	_ struct{} `type:"structure"`

	// The service role that AWS AppSync will assume to publish to Amazon CloudWatch
	// logs in your account.
	//
	// CloudWatchLogsRoleArn is a required field
	CloudWatchLogsRoleArn *string `locationName:"cloudWatchLogsRoleArn" type:"string" required:"true"`

	// The field logging level. Values can be NONE, ERROR, or ALL.
	//
	//    * NONE: No field-level logs are captured.
	//
	//    * ERROR: Logs the following information only for the fields that are in
	//    error:
	//
	// The error section in the server response.
	//
	// Field-level errors.
	//
	// The generated request/response functions that got resolved for error fields.
	//
	//    * ALL: The following information is logged for all fields in the query:
	//
	// Field-level tracing information.
	//
	// The generated request/response functions that got resolved for each field.
	//
	// FieldLogLevel is a required field
	FieldLogLevel *string `locationName:"fieldLogLevel" type:"string" required:"true" enum:"FieldLogLevel"`
}

// String returns the string representation
func (s LogConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LogConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LogConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LogConfig"}
	if s.CloudWatchLogsRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CloudWatchLogsRoleArn"))
	}
	if s.FieldLogLevel == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldLogLevel"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLogsRoleArn sets the CloudWatchLogsRoleArn field's value.
func (s *LogConfig) SetCloudWatchLogsRoleArn(v string) *LogConfig {
	s.CloudWatchLogsRoleArn = &v
	return s
}

// SetFieldLogLevel sets the FieldLogLevel field's value.
func (s *LogConfig) SetFieldLogLevel(v string) *LogConfig {
	s.FieldLogLevel = &v
	return s
}

// Describes an OpenID Connect configuration.
type OpenIDConnectConfig struct {
	_ struct{} `type:"structure"`

	// The number of milliseconds a token is valid after being authenticated.
	AuthTTL *int64 `locationName:"authTTL" type:"long"`

	// The client identifier of the Relying party at the OpenID identity provider.
	// This identifier is typically obtained when the Relying party is registered
	// with the OpenID identity provider. You can specify a regular expression so
	// the AWS AppSync can validate against multiple client identifiers at a time.
	ClientId *string `locationName:"clientId" type:"string"`

	// The number of milliseconds a token is valid after being issued to a user.
	IatTTL *int64 `locationName:"iatTTL" type:"long"`

	// The issuer for the OpenID Connect configuration. The issuer returned by discovery
	// must exactly match the value of iss in the ID token.
	//
	// Issuer is a required field
	Issuer *string `locationName:"issuer" type:"string" required:"true"`
}

// String returns the string representation
func (s OpenIDConnectConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OpenIDConnectConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OpenIDConnectConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OpenIDConnectConfig"}
	if s.Issuer == nil {
		invalidParams.Add(request.NewErrParamRequired("Issuer"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthTTL sets the AuthTTL field's value.
func (s *OpenIDConnectConfig) SetAuthTTL(v int64) *OpenIDConnectConfig {
	s.AuthTTL = &v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *OpenIDConnectConfig) SetClientId(v string) *OpenIDConnectConfig {
	s.ClientId = &v
	return s
}

// SetIatTTL sets the IatTTL field's value.
func (s *OpenIDConnectConfig) SetIatTTL(v int64) *OpenIDConnectConfig {
	s.IatTTL = &v
	return s
}

// SetIssuer sets the Issuer field's value.
func (s *OpenIDConnectConfig) SetIssuer(v string) *OpenIDConnectConfig {
	s.Issuer = &v
	return s
}

// The pipeline configuration for a resolver of kind PIPELINE.
type PipelineConfig struct {
	_ struct{} `type:"structure"`

	// A list of Function objects.
	Functions []*string `locationName:"functions" type:"list"`
}

// String returns the string representation
func (s PipelineConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PipelineConfig) GoString() string {
	return s.String()
}

// SetFunctions sets the Functions field's value.
func (s *PipelineConfig) SetFunctions(v []*string) *PipelineConfig {
	s.Functions = v
	return s
}

// The Amazon RDS HTTP endpoint configuration.
type RdsHttpEndpointConfig struct {
	_ struct{} `type:"structure"`

	// AWS Region for RDS HTTP endpoint.
	AwsRegion *string `locationName:"awsRegion" type:"string"`

	// AWS secret store ARN for database credentials.
	AwsSecretStoreArn *string `locationName:"awsSecretStoreArn" type:"string"`

	// Logical database name.
	DatabaseName *string `locationName:"databaseName" type:"string"`

	// Amazon RDS cluster identifier.
	DbClusterIdentifier *string `locationName:"dbClusterIdentifier" type:"string"`

	// Logical schema name.
	Schema *string `locationName:"schema" type:"string"`
}

// String returns the string representation
func (s RdsHttpEndpointConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RdsHttpEndpointConfig) GoString() string {
	return s.String()
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *RdsHttpEndpointConfig) SetAwsRegion(v string) *RdsHttpEndpointConfig {
	s.AwsRegion = &v
	return s
}

// SetAwsSecretStoreArn sets the AwsSecretStoreArn field's value.
func (s *RdsHttpEndpointConfig) SetAwsSecretStoreArn(v string) *RdsHttpEndpointConfig {
	s.AwsSecretStoreArn = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *RdsHttpEndpointConfig) SetDatabaseName(v string) *RdsHttpEndpointConfig {
	s.DatabaseName = &v
	return s
}

// SetDbClusterIdentifier sets the DbClusterIdentifier field's value.
func (s *RdsHttpEndpointConfig) SetDbClusterIdentifier(v string) *RdsHttpEndpointConfig {
	s.DbClusterIdentifier = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *RdsHttpEndpointConfig) SetSchema(v string) *RdsHttpEndpointConfig {
	s.Schema = &v
	return s
}

// Describes a relational database data source configuration.
type RelationalDatabaseDataSourceConfig struct {
	_ struct{} `type:"structure"`

	// Amazon RDS HTTP endpoint settings.
	RdsHttpEndpointConfig *RdsHttpEndpointConfig `locationName:"rdsHttpEndpointConfig" type:"structure"`

	// Source type for the relational database.
	//
	//    * RDS_HTTP_ENDPOINT: The relational database source type is an Amazon
	//    RDS HTTP endpoint.
	RelationalDatabaseSourceType *string `locationName:"relationalDatabaseSourceType" type:"string" enum:"RelationalDatabaseSourceType"`
}

// String returns the string representation
func (s RelationalDatabaseDataSourceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RelationalDatabaseDataSourceConfig) GoString() string {
	return s.String()
}

// SetRdsHttpEndpointConfig sets the RdsHttpEndpointConfig field's value.
func (s *RelationalDatabaseDataSourceConfig) SetRdsHttpEndpointConfig(v *RdsHttpEndpointConfig) *RelationalDatabaseDataSourceConfig {
	s.RdsHttpEndpointConfig = v
	return s
}

// SetRelationalDatabaseSourceType sets the RelationalDatabaseSourceType field's value.
func (s *RelationalDatabaseDataSourceConfig) SetRelationalDatabaseSourceType(v string) *RelationalDatabaseDataSourceConfig {
	s.RelationalDatabaseSourceType = &v
	return s
}

// Describes a resolver.
type Resolver struct {
	_ struct{} `type:"structure"`

	// The resolver data source name.
	DataSourceName *string `locationName:"dataSourceName" type:"string"`

	// The resolver field name.
	FieldName *string `locationName:"fieldName" type:"string"`

	// The resolver type.
	//
	//    * UNIT: A UNIT resolver type. A UNIT resolver is the default resolver
	//    type. A UNIT resolver enables you to execute a GraphQL query against a
	//    single data source.
	//
	//    * PIPELINE: A PIPELINE resolver type. A PIPELINE resolver enables you
	//    to execute a series of Function in a serial manner. You can use a pipeline
	//    resolver to execute a GraphQL query against multiple data sources.
	Kind *string `locationName:"kind" type:"string" enum:"ResolverKind"`

	// The PipelineConfig.
	PipelineConfig *PipelineConfig `locationName:"pipelineConfig" type:"structure"`

	// The request mapping template.
	RequestMappingTemplate *string `locationName:"requestMappingTemplate" min:"1" type:"string"`

	// The resolver ARN.
	ResolverArn *string `locationName:"resolverArn" type:"string"`

	// The response mapping template.
	ResponseMappingTemplate *string `locationName:"responseMappingTemplate" min:"1" type:"string"`

	// The resolver type name.
	TypeName *string `locationName:"typeName" type:"string"`
}

// String returns the string representation
func (s Resolver) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Resolver) GoString() string {
	return s.String()
}

// SetDataSourceName sets the DataSourceName field's value.
func (s *Resolver) SetDataSourceName(v string) *Resolver {
	s.DataSourceName = &v
	return s
}

// SetFieldName sets the FieldName field's value.
func (s *Resolver) SetFieldName(v string) *Resolver {
	s.FieldName = &v
	return s
}

// SetKind sets the Kind field's value.
func (s *Resolver) SetKind(v string) *Resolver {
	s.Kind = &v
	return s
}

// SetPipelineConfig sets the PipelineConfig field's value.
func (s *Resolver) SetPipelineConfig(v *PipelineConfig) *Resolver {
	s.PipelineConfig = v
	return s
}

// SetRequestMappingTemplate sets the RequestMappingTemplate field's value.
func (s *Resolver) SetRequestMappingTemplate(v string) *Resolver {
	s.RequestMappingTemplate = &v
	return s
}

// SetResolverArn sets the ResolverArn field's value.
func (s *Resolver) SetResolverArn(v string) *Resolver {
	s.ResolverArn = &v
	return s
}

// SetResponseMappingTemplate sets the ResponseMappingTemplate field's value.
func (s *Resolver) SetResponseMappingTemplate(v string) *Resolver {
	s.ResponseMappingTemplate = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *Resolver) SetTypeName(v string) *Resolver {
	s.TypeName = &v
	return s
}

type StartSchemaCreationInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The schema definition, in GraphQL schema language format.
	//
	// Definition is automatically base64 encoded/decoded by the SDK.
	//
	// Definition is a required field
	Definition []byte `locationName:"definition" type:"blob" required:"true"`
}

// String returns the string representation
func (s StartSchemaCreationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartSchemaCreationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartSchemaCreationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartSchemaCreationInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.Definition == nil {
		invalidParams.Add(request.NewErrParamRequired("Definition"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *StartSchemaCreationInput) SetApiId(v string) *StartSchemaCreationInput {
	s.ApiId = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *StartSchemaCreationInput) SetDefinition(v []byte) *StartSchemaCreationInput {
	s.Definition = v
	return s
}

type StartSchemaCreationOutput struct {
	_ struct{} `type:"structure"`

	// The current state of the schema (PROCESSING, ACTIVE, or DELETING). When the
	// schema is in the ACTIVE state, you can add data.
	Status *string `locationName:"status" type:"string" enum:"SchemaStatus"`
}

// String returns the string representation
func (s StartSchemaCreationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartSchemaCreationOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *StartSchemaCreationOutput) SetStatus(v string) *StartSchemaCreationOutput {
	s.Status = &v
	return s
}

// Describes a type.
type Type struct {
	_ struct{} `type:"structure"`

	// The type ARN.
	Arn *string `locationName:"arn" type:"string"`

	// The type definition.
	Definition *string `locationName:"definition" type:"string"`

	// The type description.
	Description *string `locationName:"description" type:"string"`

	// The type format: SDL or JSON.
	Format *string `locationName:"format" type:"string" enum:"TypeDefinitionFormat"`

	// The type name.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s Type) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Type) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Type) SetArn(v string) *Type {
	s.Arn = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *Type) SetDefinition(v string) *Type {
	s.Definition = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Type) SetDescription(v string) *Type {
	s.Description = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *Type) SetFormat(v string) *Type {
	s.Format = &v
	return s
}

// SetName sets the Name field's value.
func (s *Type) SetName(v string) *Type {
	s.Name = &v
	return s
}

type UpdateApiKeyInput struct {
	_ struct{} `type:"structure"`

	// The ID for the GraphQL API.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// A description of the purpose of the API key.
	Description *string `locationName:"description" type:"string"`

	// The time from update time after which the API key expires. The date is represented
	// as seconds since the epoch. For more information, see .
	Expires *int64 `locationName:"expires" type:"long"`

	// The API key ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateApiKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApiKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApiKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApiKeyInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *UpdateApiKeyInput) SetApiId(v string) *UpdateApiKeyInput {
	s.ApiId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateApiKeyInput) SetDescription(v string) *UpdateApiKeyInput {
	s.Description = &v
	return s
}

// SetExpires sets the Expires field's value.
func (s *UpdateApiKeyInput) SetExpires(v int64) *UpdateApiKeyInput {
	s.Expires = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateApiKeyInput) SetId(v string) *UpdateApiKeyInput {
	s.Id = &v
	return s
}

type UpdateApiKeyOutput struct {
	_ struct{} `type:"structure"`

	// The API key.
	ApiKey *ApiKey `locationName:"apiKey" type:"structure"`
}

// String returns the string representation
func (s UpdateApiKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApiKeyOutput) GoString() string {
	return s.String()
}

// SetApiKey sets the ApiKey field's value.
func (s *UpdateApiKeyOutput) SetApiKey(v *ApiKey) *UpdateApiKeyOutput {
	s.ApiKey = v
	return s
}

type UpdateDataSourceInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The new description for the data source.
	Description *string `locationName:"description" type:"string"`

	// The new Amazon DynamoDB configuration.
	DynamodbConfig *DynamodbDataSourceConfig `locationName:"dynamodbConfig" type:"structure"`

	// The new Elasticsearch Service configuration.
	ElasticsearchConfig *ElasticsearchDataSourceConfig `locationName:"elasticsearchConfig" type:"structure"`

	// The new HTTP endpoint configuration.
	HttpConfig *HttpDataSourceConfig `locationName:"httpConfig" type:"structure"`

	// The new AWS Lambda configuration.
	LambdaConfig *LambdaDataSourceConfig `locationName:"lambdaConfig" type:"structure"`

	// The new name for the data source.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The new relational database configuration.
	RelationalDatabaseConfig *RelationalDatabaseDataSourceConfig `locationName:"relationalDatabaseConfig" type:"structure"`

	// The new service role ARN for the data source.
	ServiceRoleArn *string `locationName:"serviceRoleArn" type:"string"`

	// The new data source type.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"DataSourceType"`
}

// String returns the string representation
func (s UpdateDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDataSourceInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.DynamodbConfig != nil {
		if err := s.DynamodbConfig.Validate(); err != nil {
			invalidParams.AddNested("DynamodbConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.ElasticsearchConfig != nil {
		if err := s.ElasticsearchConfig.Validate(); err != nil {
			invalidParams.AddNested("ElasticsearchConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.HttpConfig != nil {
		if err := s.HttpConfig.Validate(); err != nil {
			invalidParams.AddNested("HttpConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.LambdaConfig != nil {
		if err := s.LambdaConfig.Validate(); err != nil {
			invalidParams.AddNested("LambdaConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *UpdateDataSourceInput) SetApiId(v string) *UpdateDataSourceInput {
	s.ApiId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateDataSourceInput) SetDescription(v string) *UpdateDataSourceInput {
	s.Description = &v
	return s
}

// SetDynamodbConfig sets the DynamodbConfig field's value.
func (s *UpdateDataSourceInput) SetDynamodbConfig(v *DynamodbDataSourceConfig) *UpdateDataSourceInput {
	s.DynamodbConfig = v
	return s
}

// SetElasticsearchConfig sets the ElasticsearchConfig field's value.
func (s *UpdateDataSourceInput) SetElasticsearchConfig(v *ElasticsearchDataSourceConfig) *UpdateDataSourceInput {
	s.ElasticsearchConfig = v
	return s
}

// SetHttpConfig sets the HttpConfig field's value.
func (s *UpdateDataSourceInput) SetHttpConfig(v *HttpDataSourceConfig) *UpdateDataSourceInput {
	s.HttpConfig = v
	return s
}

// SetLambdaConfig sets the LambdaConfig field's value.
func (s *UpdateDataSourceInput) SetLambdaConfig(v *LambdaDataSourceConfig) *UpdateDataSourceInput {
	s.LambdaConfig = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateDataSourceInput) SetName(v string) *UpdateDataSourceInput {
	s.Name = &v
	return s
}

// SetRelationalDatabaseConfig sets the RelationalDatabaseConfig field's value.
func (s *UpdateDataSourceInput) SetRelationalDatabaseConfig(v *RelationalDatabaseDataSourceConfig) *UpdateDataSourceInput {
	s.RelationalDatabaseConfig = v
	return s
}

// SetServiceRoleArn sets the ServiceRoleArn field's value.
func (s *UpdateDataSourceInput) SetServiceRoleArn(v string) *UpdateDataSourceInput {
	s.ServiceRoleArn = &v
	return s
}

// SetType sets the Type field's value.
func (s *UpdateDataSourceInput) SetType(v string) *UpdateDataSourceInput {
	s.Type = &v
	return s
}

type UpdateDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// The updated DataSource object.
	DataSource *DataSource `locationName:"dataSource" type:"structure"`
}

// String returns the string representation
func (s UpdateDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDataSourceOutput) GoString() string {
	return s.String()
}

// SetDataSource sets the DataSource field's value.
func (s *UpdateDataSourceOutput) SetDataSource(v *DataSource) *UpdateDataSourceOutput {
	s.DataSource = v
	return s
}

type UpdateFunctionInput struct {
	_ struct{} `type:"structure"`

	// The GraphQL API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The FunctionDataSource name.
	//
	// DataSourceName is a required field
	DataSourceName *string `locationName:"dataSourceName" type:"string" required:"true"`

	// The Function description.
	Description *string `locationName:"description" type:"string"`

	// The function ID.
	//
	// FunctionId is a required field
	FunctionId *string `location:"uri" locationName:"functionId" type:"string" required:"true"`

	// The version of the request mapping template. Currently the supported value
	// is 2018-05-29.
	//
	// FunctionVersion is a required field
	FunctionVersion *string `locationName:"functionVersion" type:"string" required:"true"`

	// The Function name.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The Function request mapping template. Functions support only the 2018-05-29
	// version of the request mapping template.
	//
	// RequestMappingTemplate is a required field
	RequestMappingTemplate *string `locationName:"requestMappingTemplate" min:"1" type:"string" required:"true"`

	// The Function request mapping template.
	ResponseMappingTemplate *string `locationName:"responseMappingTemplate" min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFunctionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFunctionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFunctionInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.DataSourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceName"))
	}
	if s.FunctionId == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionId"))
	}
	if s.FunctionId != nil && len(*s.FunctionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionId", 1))
	}
	if s.FunctionVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionVersion"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.RequestMappingTemplate == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestMappingTemplate"))
	}
	if s.RequestMappingTemplate != nil && len(*s.RequestMappingTemplate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestMappingTemplate", 1))
	}
	if s.ResponseMappingTemplate != nil && len(*s.ResponseMappingTemplate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResponseMappingTemplate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *UpdateFunctionInput) SetApiId(v string) *UpdateFunctionInput {
	s.ApiId = &v
	return s
}

// SetDataSourceName sets the DataSourceName field's value.
func (s *UpdateFunctionInput) SetDataSourceName(v string) *UpdateFunctionInput {
	s.DataSourceName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateFunctionInput) SetDescription(v string) *UpdateFunctionInput {
	s.Description = &v
	return s
}

// SetFunctionId sets the FunctionId field's value.
func (s *UpdateFunctionInput) SetFunctionId(v string) *UpdateFunctionInput {
	s.FunctionId = &v
	return s
}

// SetFunctionVersion sets the FunctionVersion field's value.
func (s *UpdateFunctionInput) SetFunctionVersion(v string) *UpdateFunctionInput {
	s.FunctionVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateFunctionInput) SetName(v string) *UpdateFunctionInput {
	s.Name = &v
	return s
}

// SetRequestMappingTemplate sets the RequestMappingTemplate field's value.
func (s *UpdateFunctionInput) SetRequestMappingTemplate(v string) *UpdateFunctionInput {
	s.RequestMappingTemplate = &v
	return s
}

// SetResponseMappingTemplate sets the ResponseMappingTemplate field's value.
func (s *UpdateFunctionInput) SetResponseMappingTemplate(v string) *UpdateFunctionInput {
	s.ResponseMappingTemplate = &v
	return s
}

type UpdateFunctionOutput struct {
	_ struct{} `type:"structure"`

	// The Function object.
	FunctionConfiguration *FunctionConfiguration `locationName:"functionConfiguration" type:"structure"`
}

// String returns the string representation
func (s UpdateFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFunctionOutput) GoString() string {
	return s.String()
}

// SetFunctionConfiguration sets the FunctionConfiguration field's value.
func (s *UpdateFunctionOutput) SetFunctionConfiguration(v *FunctionConfiguration) *UpdateFunctionOutput {
	s.FunctionConfiguration = v
	return s
}

type UpdateGraphqlApiInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The new authentication type for the GraphqlApi object.
	AuthenticationType *string `locationName:"authenticationType" type:"string" enum:"AuthenticationType"`

	// The Amazon CloudWatch Logs configuration for the GraphqlApi object.
	LogConfig *LogConfig `locationName:"logConfig" type:"structure"`

	// The new name for the GraphqlApi object.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The OpenID Connect configuration for the GraphqlApi object.
	OpenIDConnectConfig *OpenIDConnectConfig `locationName:"openIDConnectConfig" type:"structure"`

	// The new Amazon Cognito user pool configuration for the GraphqlApi object.
	UserPoolConfig *UserPoolConfig `locationName:"userPoolConfig" type:"structure"`
}

// String returns the string representation
func (s UpdateGraphqlApiInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGraphqlApiInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGraphqlApiInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGraphqlApiInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.LogConfig != nil {
		if err := s.LogConfig.Validate(); err != nil {
			invalidParams.AddNested("LogConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OpenIDConnectConfig != nil {
		if err := s.OpenIDConnectConfig.Validate(); err != nil {
			invalidParams.AddNested("OpenIDConnectConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.UserPoolConfig != nil {
		if err := s.UserPoolConfig.Validate(); err != nil {
			invalidParams.AddNested("UserPoolConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *UpdateGraphqlApiInput) SetApiId(v string) *UpdateGraphqlApiInput {
	s.ApiId = &v
	return s
}

// SetAuthenticationType sets the AuthenticationType field's value.
func (s *UpdateGraphqlApiInput) SetAuthenticationType(v string) *UpdateGraphqlApiInput {
	s.AuthenticationType = &v
	return s
}

// SetLogConfig sets the LogConfig field's value.
func (s *UpdateGraphqlApiInput) SetLogConfig(v *LogConfig) *UpdateGraphqlApiInput {
	s.LogConfig = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateGraphqlApiInput) SetName(v string) *UpdateGraphqlApiInput {
	s.Name = &v
	return s
}

// SetOpenIDConnectConfig sets the OpenIDConnectConfig field's value.
func (s *UpdateGraphqlApiInput) SetOpenIDConnectConfig(v *OpenIDConnectConfig) *UpdateGraphqlApiInput {
	s.OpenIDConnectConfig = v
	return s
}

// SetUserPoolConfig sets the UserPoolConfig field's value.
func (s *UpdateGraphqlApiInput) SetUserPoolConfig(v *UserPoolConfig) *UpdateGraphqlApiInput {
	s.UserPoolConfig = v
	return s
}

type UpdateGraphqlApiOutput struct {
	_ struct{} `type:"structure"`

	// The updated GraphqlApi object.
	GraphqlApi *GraphqlApi `locationName:"graphqlApi" type:"structure"`
}

// String returns the string representation
func (s UpdateGraphqlApiOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGraphqlApiOutput) GoString() string {
	return s.String()
}

// SetGraphqlApi sets the GraphqlApi field's value.
func (s *UpdateGraphqlApiOutput) SetGraphqlApi(v *GraphqlApi) *UpdateGraphqlApiOutput {
	s.GraphqlApi = v
	return s
}

type UpdateResolverInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The new data source name.
	DataSourceName *string `locationName:"dataSourceName" type:"string"`

	// The new field name.
	//
	// FieldName is a required field
	FieldName *string `location:"uri" locationName:"fieldName" type:"string" required:"true"`

	// The resolver type.
	//
	//    * UNIT: A UNIT resolver type. A UNIT resolver is the default resolver
	//    type. A UNIT resolver enables you to execute a GraphQL query against a
	//    single data source.
	//
	//    * PIPELINE: A PIPELINE resolver type. A PIPELINE resolver enables you
	//    to execute a series of Function in a serial manner. You can use a pipeline
	//    resolver to execute a GraphQL query against multiple data sources.
	Kind *string `locationName:"kind" type:"string" enum:"ResolverKind"`

	// The PipelineConfig.
	PipelineConfig *PipelineConfig `locationName:"pipelineConfig" type:"structure"`

	// The new request mapping template.
	//
	// RequestMappingTemplate is a required field
	RequestMappingTemplate *string `locationName:"requestMappingTemplate" min:"1" type:"string" required:"true"`

	// The new response mapping template.
	ResponseMappingTemplate *string `locationName:"responseMappingTemplate" min:"1" type:"string"`

	// The new type name.
	//
	// TypeName is a required field
	TypeName *string `location:"uri" locationName:"typeName" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateResolverInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResolverInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateResolverInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateResolverInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.FieldName == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldName"))
	}
	if s.FieldName != nil && len(*s.FieldName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FieldName", 1))
	}
	if s.RequestMappingTemplate == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestMappingTemplate"))
	}
	if s.RequestMappingTemplate != nil && len(*s.RequestMappingTemplate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestMappingTemplate", 1))
	}
	if s.ResponseMappingTemplate != nil && len(*s.ResponseMappingTemplate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResponseMappingTemplate", 1))
	}
	if s.TypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("TypeName"))
	}
	if s.TypeName != nil && len(*s.TypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *UpdateResolverInput) SetApiId(v string) *UpdateResolverInput {
	s.ApiId = &v
	return s
}

// SetDataSourceName sets the DataSourceName field's value.
func (s *UpdateResolverInput) SetDataSourceName(v string) *UpdateResolverInput {
	s.DataSourceName = &v
	return s
}

// SetFieldName sets the FieldName field's value.
func (s *UpdateResolverInput) SetFieldName(v string) *UpdateResolverInput {
	s.FieldName = &v
	return s
}

// SetKind sets the Kind field's value.
func (s *UpdateResolverInput) SetKind(v string) *UpdateResolverInput {
	s.Kind = &v
	return s
}

// SetPipelineConfig sets the PipelineConfig field's value.
func (s *UpdateResolverInput) SetPipelineConfig(v *PipelineConfig) *UpdateResolverInput {
	s.PipelineConfig = v
	return s
}

// SetRequestMappingTemplate sets the RequestMappingTemplate field's value.
func (s *UpdateResolverInput) SetRequestMappingTemplate(v string) *UpdateResolverInput {
	s.RequestMappingTemplate = &v
	return s
}

// SetResponseMappingTemplate sets the ResponseMappingTemplate field's value.
func (s *UpdateResolverInput) SetResponseMappingTemplate(v string) *UpdateResolverInput {
	s.ResponseMappingTemplate = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *UpdateResolverInput) SetTypeName(v string) *UpdateResolverInput {
	s.TypeName = &v
	return s
}

type UpdateResolverOutput struct {
	_ struct{} `type:"structure"`

	// The updated Resolver object.
	Resolver *Resolver `locationName:"resolver" type:"structure"`
}

// String returns the string representation
func (s UpdateResolverOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResolverOutput) GoString() string {
	return s.String()
}

// SetResolver sets the Resolver field's value.
func (s *UpdateResolverOutput) SetResolver(v *Resolver) *UpdateResolverOutput {
	s.Resolver = v
	return s
}

type UpdateTypeInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The new definition.
	Definition *string `locationName:"definition" type:"string"`

	// The new type format: SDL or JSON.
	//
	// Format is a required field
	Format *string `locationName:"format" type:"string" required:"true" enum:"TypeDefinitionFormat"`

	// The new type name.
	//
	// TypeName is a required field
	TypeName *string `location:"uri" locationName:"typeName" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTypeInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.TypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("TypeName"))
	}
	if s.TypeName != nil && len(*s.TypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *UpdateTypeInput) SetApiId(v string) *UpdateTypeInput {
	s.ApiId = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *UpdateTypeInput) SetDefinition(v string) *UpdateTypeInput {
	s.Definition = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *UpdateTypeInput) SetFormat(v string) *UpdateTypeInput {
	s.Format = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *UpdateTypeInput) SetTypeName(v string) *UpdateTypeInput {
	s.TypeName = &v
	return s
}

type UpdateTypeOutput struct {
	_ struct{} `type:"structure"`

	// The updated Type object.
	Type *Type `locationName:"type" type:"structure"`
}

// String returns the string representation
func (s UpdateTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTypeOutput) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *UpdateTypeOutput) SetType(v *Type) *UpdateTypeOutput {
	s.Type = v
	return s
}

// Describes an Amazon Cognito user pool configuration.
type UserPoolConfig struct {
	_ struct{} `type:"structure"`

	// A regular expression for validating the incoming Amazon Cognito user pool
	// app client ID.
	AppIdClientRegex *string `locationName:"appIdClientRegex" type:"string"`

	// The AWS Region in which the user pool was created.
	//
	// AwsRegion is a required field
	AwsRegion *string `locationName:"awsRegion" type:"string" required:"true"`

	// The action that you want your GraphQL API to take when a request that uses
	// Amazon Cognito user pool authentication doesn't match the Amazon Cognito
	// user pool configuration.
	//
	// DefaultAction is a required field
	DefaultAction *string `locationName:"defaultAction" type:"string" required:"true" enum:"DefaultAction"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `locationName:"userPoolId" type:"string" required:"true"`
}

// String returns the string representation
func (s UserPoolConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserPoolConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserPoolConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UserPoolConfig"}
	if s.AwsRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsRegion"))
	}
	if s.DefaultAction == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultAction"))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppIdClientRegex sets the AppIdClientRegex field's value.
func (s *UserPoolConfig) SetAppIdClientRegex(v string) *UserPoolConfig {
	s.AppIdClientRegex = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *UserPoolConfig) SetAwsRegion(v string) *UserPoolConfig {
	s.AwsRegion = &v
	return s
}

// SetDefaultAction sets the DefaultAction field's value.
func (s *UserPoolConfig) SetDefaultAction(v string) *UserPoolConfig {
	s.DefaultAction = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *UserPoolConfig) SetUserPoolId(v string) *UserPoolConfig {
	s.UserPoolId = &v
	return s
}

const (
	// AuthenticationTypeApiKey is a AuthenticationType enum value
	AuthenticationTypeApiKey = "API_KEY"

	// AuthenticationTypeAwsIam is a AuthenticationType enum value
	AuthenticationTypeAwsIam = "AWS_IAM"

	// AuthenticationTypeAmazonCognitoUserPools is a AuthenticationType enum value
	AuthenticationTypeAmazonCognitoUserPools = "AMAZON_COGNITO_USER_POOLS"

	// AuthenticationTypeOpenidConnect is a AuthenticationType enum value
	AuthenticationTypeOpenidConnect = "OPENID_CONNECT"
)

const (
	// AuthorizationTypeAwsIam is a AuthorizationType enum value
	AuthorizationTypeAwsIam = "AWS_IAM"
)

const (
	// DataSourceTypeAwsLambda is a DataSourceType enum value
	DataSourceTypeAwsLambda = "AWS_LAMBDA"

	// DataSourceTypeAmazonDynamodb is a DataSourceType enum value
	DataSourceTypeAmazonDynamodb = "AMAZON_DYNAMODB"

	// DataSourceTypeAmazonElasticsearch is a DataSourceType enum value
	DataSourceTypeAmazonElasticsearch = "AMAZON_ELASTICSEARCH"

	// DataSourceTypeNone is a DataSourceType enum value
	DataSourceTypeNone = "NONE"

	// DataSourceTypeHttp is a DataSourceType enum value
	DataSourceTypeHttp = "HTTP"

	// DataSourceTypeRelationalDatabase is a DataSourceType enum value
	DataSourceTypeRelationalDatabase = "RELATIONAL_DATABASE"
)

const (
	// DefaultActionAllow is a DefaultAction enum value
	DefaultActionAllow = "ALLOW"

	// DefaultActionDeny is a DefaultAction enum value
	DefaultActionDeny = "DENY"
)

const (
	// FieldLogLevelNone is a FieldLogLevel enum value
	FieldLogLevelNone = "NONE"

	// FieldLogLevelError is a FieldLogLevel enum value
	FieldLogLevelError = "ERROR"

	// FieldLogLevelAll is a FieldLogLevel enum value
	FieldLogLevelAll = "ALL"
)

const (
	// OutputTypeSdl is a OutputType enum value
	OutputTypeSdl = "SDL"

	// OutputTypeJson is a OutputType enum value
	OutputTypeJson = "JSON"
)

const (
	// RelationalDatabaseSourceTypeRdsHttpEndpoint is a RelationalDatabaseSourceType enum value
	RelationalDatabaseSourceTypeRdsHttpEndpoint = "RDS_HTTP_ENDPOINT"
)

const (
	// ResolverKindUnit is a ResolverKind enum value
	ResolverKindUnit = "UNIT"

	// ResolverKindPipeline is a ResolverKind enum value
	ResolverKindPipeline = "PIPELINE"
)

const (
	// SchemaStatusProcessing is a SchemaStatus enum value
	SchemaStatusProcessing = "PROCESSING"

	// SchemaStatusActive is a SchemaStatus enum value
	SchemaStatusActive = "ACTIVE"

	// SchemaStatusDeleting is a SchemaStatus enum value
	SchemaStatusDeleting = "DELETING"
)

const (
	// TypeDefinitionFormatSdl is a TypeDefinitionFormat enum value
	TypeDefinitionFormatSdl = "SDL"

	// TypeDefinitionFormatJson is a TypeDefinitionFormat enum value
	TypeDefinitionFormatJson = "JSON"
)
