////////////////////////////////////////////////////////
//
// GEM - Graphics Environment for Multimedia
//
// Implementation file
//
// Copyright (c) 2002-2011 IOhannes m zmölnig. forum::für::umläute. IEM. zmoelnig@iem.at
//      zmoelnig@iem.at
//  For information on usage and redistribution, and for a DISCLAIMER
//  *  OF ALL WARRANTIES, see the file, "GEM.LICENSE.TERMS"
//
//  this file has been generated...
////////////////////////////////////////////////////////

#include "GEMglLightf.h"

CPPEXTERN_NEW_WITH_THREE_ARGS ( GEMglLightf, t_floatarg, A_DEFFLOAT,
                                t_floatarg, A_DEFFLOAT, t_floatarg, A_DEFFLOAT);

/////////////////////////////////////////////////////////
//
// GEMglViewport
//
/////////////////////////////////////////////////////////
// Constructor
//
GEMglLightf :: GEMglLightf      (t_floatarg arg0, t_floatarg arg1,
                                 t_floatarg arg2) :
  light(static_cast<GLenum>(arg0)),
  pname(static_cast<GLenum>(arg1)),
  param(static_cast<GLfloat>(arg2))
{
  m_inlet[0] = inlet_new(this->x_obj, &this->x_obj->ob_pd, &s_float,
                         gensym("light"));
  m_inlet[1] = inlet_new(this->x_obj, &this->x_obj->ob_pd, &s_float,
                         gensym("pname"));
  m_inlet[2] = inlet_new(this->x_obj, &this->x_obj->ob_pd, &s_float,
                         gensym("param"));
}
/////////////////////////////////////////////////////////
// Destructor
//
GEMglLightf :: ~GEMglLightf ()
{
  inlet_free(m_inlet[0]);
  inlet_free(m_inlet[1]);
  inlet_free(m_inlet[2]);
}

/////////////////////////////////////////////////////////
// Render
//
void GEMglLightf :: render(GemState *state)
{
  glLightf (light, pname, param);
}

/////////////////////////////////////////////////////////
// Variables
//
void GEMglLightf :: lightMess (t_float arg1)    // FUN
{
  light = static_cast<GLenum>(arg1);
  setModified();
}

void GEMglLightf :: pnameMess (t_float arg1)    // FUN
{
  pname = static_cast<GLenum>(arg1);
  setModified();
}

void GEMglLightf :: paramMess (t_float arg1)    // FUN
{
  param = static_cast<GLfloat>(arg1);
  setModified();
}


/////////////////////////////////////////////////////////
// static member functions
//

void GEMglLightf :: obj_setupCallback(t_class *classPtr)
{
  class_addmethod(classPtr,
                  reinterpret_cast<t_method>(&GEMglLightf::lightMessCallback),
                  gensym("light"), A_DEFFLOAT, A_NULL);
  class_addmethod(classPtr,
                  reinterpret_cast<t_method>(&GEMglLightf::pnameMessCallback),
                  gensym("pname"), A_DEFFLOAT, A_NULL);
  class_addmethod(classPtr,
                  reinterpret_cast<t_method>(&GEMglLightf::paramMessCallback),
                  gensym("param"), A_DEFFLOAT, A_NULL);
};

void GEMglLightf :: lightMessCallback (void* data, t_float arg0)
{
  GetMyClass(data)->lightMess ( static_cast<t_float>(arg0));
}
void GEMglLightf :: pnameMessCallback (void* data, t_float arg0)
{
  GetMyClass(data)->pnameMess ( static_cast<t_float>(arg0));
}
void GEMglLightf :: paramMessCallback (void* data, t_float arg0)
{
  GetMyClass(data)->paramMess ( static_cast<t_float>(arg0));
}
