/*
 * Copyright (C) 2003-2013 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>

#include <gtk/gtk.h>

#include "glue-gui-gtk.h"
#include "glue-gui-gtk-change.h"
#include "glue.h"

#include "pci_ti_1520_gui_gtk.h"

#define COMP		pci_ti_1520
#define SCOMP		"pci_ti_1520"
#define GUI_GTK_(x)	pci_ti_1520_gui_gtk_ ## x

struct cpssp {
	GtkWidget *change[2];

	struct sig_string *port_change[2];
};

/*
 * Simulator Callbacks
 */
static void
GUI_GTK_(change0)(void *_cpssp, const char *path)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	gui_gtk_change_set(GUI_GTK_CHANGE(cpssp->change[0]), path);
}

static void
GUI_GTK_(change1)(void *_cpssp, const char *path)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	gui_gtk_change_set(GUI_GTK_CHANGE(cpssp->change[1]), path);
}

/*
 * GUI Callbacks
 */
static void
GUI_GTK_(insert_event)(GtkWidget *w, const char *string, gpointer _cpssp)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;
	int i;

	for (i = 0; cpssp->change[i] != w; i++) {
		assert(i < 2);
	}

	sig_string_set(cpssp->port_change[i], cpssp, string);
}

static void
GUI_GTK_(remove_event)(GtkWidget *w, const char *string, gpointer _cpssp)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;
	int i;

	for (i = 0; cpssp->change[i] != w; i++) {
		assert(i < 2);
	}

	sig_string_set(cpssp->port_change[i], cpssp, "");
}

void *
GUI_GTK_(create)(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_cardbus_conn *port_card0,
	struct sig_cardbus_conn *port_card1,
	struct sig_pci_conn *port_pci,
	struct sig_string *port_change0,
	struct sig_string *port_change1
)
{
	static const struct sig_string_funcs change0_funcs = {
		.set = GUI_GTK_(change0),
	};
	static const struct sig_string_funcs change1_funcs = {
		.set = GUI_GTK_(change1),
	};
	struct cpssp *cpssp;
	GtkWidget *hbox;
	int i;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	hbox = gtk_hbox_new(FALSE, 1);

	for (i = 0; i < 2; i++) {
		cpssp->change[i] = gui_gtk_change_new("Cardbus-Card");
		GTK_WIDGET_UNSET_FLAGS(cpssp->change[i], GTK_CAN_FOCUS);
		g_signal_connect(G_OBJECT(cpssp->change[i]), "change-inserted",
				G_CALLBACK(GUI_GTK_(insert_event)), cpssp);
		g_signal_connect(G_OBJECT(cpssp->change[i]), "change-removed",
				G_CALLBACK(GUI_GTK_(remove_event)), cpssp);
		gtk_widget_show(cpssp->change[i]);
		gtk_box_pack_end(GTK_BOX(hbox), cpssp->change[i],
				TRUE, FALSE, 1);
	}

	gtk_widget_show(hbox);
	gui_gtk_comp_add(page, SCOMP, name, hbox, FALSE, FALSE, NULL);

	/* Out */
	cpssp->port_change[0] = port_change0;
	cpssp->port_change[1] = port_change1;

	/* In */
	sig_string_connect(port_change0, cpssp, &change0_funcs);
	sig_string_connect(port_change1, cpssp, &change1_funcs);

	return cpssp;
}

void
GUI_GTK_(destroy)(void *_cpssp)
{
	//struct cpssp *cpssp = _cpssp;
}

void
GUI_GTK_(suspend)(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;

	generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

void
GUI_GTK_(resume)(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;

	/* FIXME */
	generic_resume(cpssp, sizeof(*cpssp), fComp);
}
