/*
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "glue-aui-gen.h"
#include "glue-shm.h"

#include "loudspeaker_aui.h"

struct cpssp {
	AuiGenChannel *left;
	AuiGenChannel *right;
};

/*
 * Simulator Callbacks
 */
static void
loudspeaker_aui_audio_sound_left_samples_set(void *_cpssp, int16_t *samples)
{
	struct cpssp *cpssp = _cpssp;

	aui_gen_channel_play(cpssp->left, samples);
}

static void
loudspeaker_aui_audio_sound_right_samples_set(void *_cpssp, int16_t *samples)
{
	struct cpssp *cpssp = _cpssp;

	aui_gen_channel_play(cpssp->right, samples);
}

void *
loudspeaker_aui_create(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_sound *port_sound_in_left,
	struct sig_sound *port_sound_in_right,
	struct sig_sound *port_audio_sound_left,
	struct sig_sound *port_audio_sound_right
)
{
	static const struct sig_sound_funcs audio_sound_left_funcs = {
		.samples_set = loudspeaker_aui_audio_sound_left_samples_set,
	};
	static const struct sig_sound_funcs audio_sound_right_funcs = {
		.samples_set = loudspeaker_aui_audio_sound_right_samples_set,
	};
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->left = aui_gen_channel_new("left");
	cpssp->right = aui_gen_channel_new("right");

	sig_sound_connect(port_audio_sound_left, cpssp, &audio_sound_left_funcs);
	sig_sound_connect(port_audio_sound_right, cpssp, &audio_sound_right_funcs);

	return cpssp;
}

void
loudspeaker_aui_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
loudspeaker_aui_suspend(void *_cpssp, FILE *fp)
{

}

void
loudspeaker_aui_resume(void *_cpssp, FILE *fp)
{

}
