/*
 * Copyright (C) 2014 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>

#include "config.h"

#include "glue-gui.h"

#include "led3_gui.h"

#ifdef HAVE_GTK
#include "led3_gui_gtk.h"
#endif

void *
led3_gui_create(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_std_logic *port_led_red,
	struct sig_std_logic *port_led_green,
	struct sig_std_logic *port_led_blue,
	struct sig_opt_rgb *port_opt_led
)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return led3_gui_gtk_create(page, name,
				port_manage,
				port_led_red,
				port_led_green,
				port_led_blue,
				port_opt_led);
		break;
#endif
	case GUI_NULL:
		return (void *) 1;
	default:
		assert(0);
	}
}

void
led3_gui_destroy(void *_cpssp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		led3_gui_gtk_destroy(_cpssp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
led3_gui_suspend(void *_cpssp, FILE *fComp)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		led3_gui_gtk_suspend(_cpssp, fComp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
led3_gui_resume(void *_cpssp, FILE *fComp)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		led3_gui_gtk_resume(_cpssp, fComp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
