.\" dpkg manual page - dpkg-source(1)
.\"
.\" Copyright © 1995-1996 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 2000 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2006-2007 Frank Lichtenheld <djpig@debian.org>
.\" Copyright © 2006-2015 Guillem Jover <guillem@debian.org>
.\" Copyright © 2008-2011 Raphaël Hertzog <hertzog@debian.org>
.\" Copyright © 2010 Joey Hess <joeyh@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-source 1 %RELEASE_DATE% %VERSION% "suite dpkg"
.nh
.SH NOM
dpkg\-source \- Outil de manipulation des paquets sources Debian (.dsc).
.
.SH SYNOPSIS
\fBdpkg\-source\fP [\fIoption\fP...] \fIcommande\fP
.
.SH DESCRIPTION
\fBdpkg\-source\fP empaquette ou dépaquette une archive source Debian.

Aucune de ces commandes ne permet la combinaison de plusieurs options en une
seule et elles ne permettent pas d'indiquer la valeur d'une option dans un
argument séparé.
.
.SH COMMANDES
.TP 
\fB\-x \fP, \fB\-\-extract\fP \fInom\-de\-fichier\fP.dsc [\fIrépertoire\-de\-sortie\fP]
Cette option sert à extraire un paquet source (\fB\-\-extract\fP depuis
dpkg\ 1.17.14). Un seul argument sans option doit être donné\ : le nom du
fichier de contrôle des sources Debian (\fB.dsc\fP). Un deuxième argument sans
option peut également être donné pour indiquer le répertoire où extraire le
paquet source\ : ce répertoire ne doit pas déjà exister. Quand aucun
répertoire n'est indiqué, le paquet source est extrait dans un répertoire
\fIsource\fP\-\fIversion\fP du répertoire courant.

\fBdpkg\-source\fP lit, dans le fichier de contrôle, les noms des fichiers qui
composent le paquet source\ ; il suppose qu'ils sont dans le même répertoire
que le fichier \fB.dsc\fP.

Les fichiers extraits du paquet auront leurs propriétaires et permissions
définis à ceux attendus s'ils avaient été simplement créés. Les répertoires
et les fichiers exécutables auront une permission égale à 0777 et les
simples fichiers à 0666, les deux étant modifiées par le masque (umask) de
celui qui fait l'extraction. Si le répertoire parent est «\ setgid\ », les
répertoires extraits le seront aussi et tous les fichiers et répertoires
hériteront de sa propriété de groupe.

Si le paquet source utilise un format non standard (actuellement, cela
signifie tous les formats sauf le «\ 1.0\ »), son nom sera enregistré dans
\fBdebian/source/format\fP de sorte que la construction du paquet source
utilise le même format par défaut.

.TP 
\fB\-b\fP, \fB\-\-build\fP \fIrépertoire\fP [\fIparamètres\-dans\-un\-format\-spécifique\fP]
Construit un paquet source (\fB\-\-build\fP depuis dpkg\ 1.17.14). Le premier
argument sans option est pris comme nom du répertoire contenant
l'arborescence des sources debianisée (c'est\-à\-dire avec un sous\-répertoire
debian et peut\-être des modifications sur les fichiers d'origine). Selon le
format du paquet source utilisé pour construire le paquet, d'autres
paramètres peuvent être acceptés.

\fBdpkg\-source\fP va construire le paquet source dans le premier format trouvé
dans la liste suivante\ : le(s) format(s) indiqué(s) avec le paramètre de la
ligne de commande \fI\-\-format\fP, le format indiqué dans
\fBdebian/source/format\fP, «\ 1.0\ ». L'utilisation de «\ 1.0\ » comme dernier
recours est obsolète et sera retirée dans le futur. Le format source devrait
toujours être indiqué dans \fBdebian/source/format\fP. Voir la section
\fBFORMATS DE PAQUET SOURCE\fP pour une description plus détaillée des
différents formats de paquet source.

.TP 
\fB\-\-print\-format\fP \fIrépertoire\fP
Affiche le format source qui serait utilisé pour construire le paquet source
si \fBdpkg\-source \-\-build \fP\fIrépertoire\fP était utilisé (dans les mêmes
conditions et avec les mêmes options\ ; depuis dpkg\ 1.15.5).

.TP 
\fB\-\-before\-build\fP \fIrépertoire\fP
Exécute le point d'entrée correspondant du format de paquet source (depuis
dpkg\ 1.15.8). Ce point d'entrée doit être utilisé avant toute construction
du paquet (\fBdpkg\-buildpackage\fP l'utilise très tôt, avant même
\fBdebian/rules clean\fP). Cette commande est idempotente et peut être lancée
plusieurs fois. Tous les formats source ne mettent pas en œuvre ce
branchement et ceux qui le font préparent l'arborescence source pour la
construction, par exemple en garantissant que les correctifs Debian sont
appliqués.

.TP 
\fB\-\-after\-build\fP \fIrépertoire\fP
Exécute le point d'entrée correspondant du format de paquet source (depuis
dpkg\ 1.15.8). Ce point d'entrée doit être utilisé après toute construction
du paquet (\fBdpkg\-buildpackage\fP l'utilise en dernier). Cette commande est
idempotente et peut être lancée plusieurs fois. Tous les formats source ne
mettent pas en œuvre ce branchement et ceux qui le font s'en servent pour
défaire ce qui a été fait par \fB\-\-before\-build\fP.

.TP 
\fB\-\-commit\fP [\fIrépertoire\fP] ...
Enregistre les modifications dans l'arborescence source décompressée dans
\fIrépertoire\fP (depuis dpkg\ 1.16.1). Cette commande peut accepter des
paramètres supplémentaires selon le format source. Elle provoquera une
erreur pour les formats où cette opération n'a pas de signification.

.TP 
\fB\-?\fP, \fB\-\-help\fP
Affiche un message d'aide puis quitte. Les options de construction et
d'extraction spécifiques au format peuvent être montrées avec l'option
\fB\-\-format\fP.
.TP 
\fB\-\-version\fP
Affiche le numéro de version puis quitte.
.
.SH OPTIONS
.SS "Options de construction générique"
.TP 
\fB\-c\fP\fIfichier\-de\-contrôle\fP
Indique le principal fichier de contrôle des sources où trouver les
renseignements. Par défaut, c'est le fichier \fBdebian/control\fP. Lorsqu'un
chemin relatif est fourni, on considère qu'il est relatif au répertoire le
plus élevé de l'arborescence source.
.TP 
\fB\-l\fP\fIfichier\-des\-changements\fP
Indique le journal des modifications où trouver des renseignements. Par
défaut, c'est le fichier \fBdebian/changelog\fP. Lorsqu'un chemin relatif est
fourni, on considère qu'il est relatif au répertoire le plus élevé de
l'arborescence source.
.TP 
\fB\-F\fP\fIformat\-du\-fichier\-des\-changements\fP
Indique le format du fichier des changements. Voir \fBdpkg\-parsechangelog\fP(1)
pour plus d'informations à propos des formats gérés.
.TP 
\fB\-\-format=\fP\fIvaleur\fP
Utilise le format indiqué pour la construction du paquet source (depuis
dpkg\ 1.14.17). Ce choix remplace le format indiqué dans
\fBdebian/source/format\fP.
.TP 
\fB\-V\fP\fInom\fP\fB=\fP\fIvaleur\fP
Fixe la valeur d'une variable de substitution. Consultez \fBdeb\-substvars\fP(5)
pour une discussion sur la valeur de substitution.
.TP 
\fB\-T\fP\fIfichier\-substvars\fP
Lit les variables de substitution dans \fIfichier\-substvars\fP\ ; par défaut
aucun fichier n'est lu. Cette option peut être utilisée plusieurs fois pour
lire des variables de substitution depuis plusieurs fichiers (depuis
dpkg\ 1.15.6).
.TP 
\fB\-D\fP\fIchamp\fP\fB=\fP\fIvaleur\fP
Remplace ou ajoute en sortie un champ dans le fichier de contrôle.
.TP 
\fB\-U\fP\fIchamp\fP
Supprime en sortie un champ dans le fichier de contrôle.
.TP 
\fB\-Z\fP\fIcompression\fP, \fB\-\-compression\fP=\fIcompression\fP
Spécifie le niveau de compression à utiliser pour les fichiers archive et
diff créés (\fB\-\-compression\fP depuis dpkg\ 1.15.5). Notez que cette option ne
causera pas la recompression des archives existantes, cela ne concerne que
les nouveaux fichiers. Les valeurs acceptées sont les suivantes\ : \fIgzip\fP,
\fIbzip2\fP, \fIlzma\fP et \fIxz\fP. L'option par défaut est \fIxz\fP pour les
formats\ 2.0 et plus récents, et \fIgzip\fP pour le format\ 1.0. \fIxz\fP n'est géré
que depuis dpkg\ 1.15.5.
.TP 
\fB\-z\fP\fIniveau\fP, \fB\-\-compression\-level\fP=\fIniveau\fP
Niveau de compression à utiliser (\fB\-\-compression\-level\fP depuis
dpkg\ 1.15.5). Comme avec \fB\-Z\fP cela ne concerne que les fichiers
nouvellement créés. Les valeurs prises possibles sont les suivantes\ : \fI1\fP à
\fI9\fP, \fIbest\fP et \fIfast\fP. La valeur par défaut est \fI9\fP pour gzip et bzip2,
\fI6\fP pour xz et lzma.
.TP 
\fB\-i\fP[\fIexpression\-rationnelle\fP], \fB\-\-diff\-ignore\fP[=\fIexpression\-rationnelle\fP]
Il est possible de donner une expression rationnelle Perl pour filtrer les
fichiers qui doivent être éliminés de la liste des fichiers pour le «\ diff\ »
(\fB\-\-diff\-ignore\fP depuis dpkg\ 1.15.6). Cette liste est créée avec une
commande «\ find\ ». Si le fichier source en construction est un fichier
source de version\ 3 utilisant un système de suivi de versions, cette option
est utile pour ignorer les modifications non envoyées. Utiliser \fB\-i\fP\fI.*\fP
les ignorera toutes.

L'option \fB\-i\fP active cette fonction avec une expression rationnelle par
défaut (en préservant toutes les modifications faites avec l'expression
rationnelle par défaut par une utilisation précédente de
\fB\-\-extend\-diff\-ignore\fP) qui couvre les fichiers de contrôle des plus usuels
systèmes de gestion de version, les fichiers de sauvegarde, les fichiers
d'échange et les répertoires utilisés par Libtool. Il ne peut y avoir qu'une
seule expression rationnelle active\ ; avec de multiples options \fB\-i\fP, seule
la dernière mentionnée sera prise en compte.

C'est très utile pour supprimer des fichiers qui sont inclus dans le diff,
par exemple, si vous maintenez un source avec un système de contrôle de
version et que voulez construire un paquet source sans inclure des fichiers
et répertoires additionnels qu'il contient généralement (par exemple CVS/,
\&.cvsignore, .svn/). L'expression rationnelle par défaut est déjà très
exhaustive, mais si avez besoin de la remplacer, veuillez noter que par
défaut, il sait vérifier n'importe quelle partie d'un chemin, donc si vous
voulez trouver le début d'un nom de fichier ou des noms de fichiers
complets, vous devrez fournir les caractères spéciaux vous\-même (par exemple
«\ (^|/)\ », «\ ($|/)\ »).
.TP 
\fB\-\-extend\-diff\-ignore\fP=\fIexpression\-rationnelle\fP
L'expression rationnelle Perl indiquée complétera la valeur par défaut
utilisée par \fB\-\-diff\-ignore\fP et sa valeur courante si elle est définie
(depuis dpkg\ 1.15.6). Cela est effectué en concaténant
«\ \fB|\fP\fIexpression\-rationnelle\fP\ » à la valeur existante. Cette option est
pratique dans \fBdebian/source/options\fP pour exclure certains fichiers
auto\-créés de la création automatique de correctifs.
.TP 
\fB\-I\fP[\fImotif\-fichier\fP], \fB\-\-tar\-ignore\fP[=\fImotif\-fichier\fP]
Avec cette option, le fichier est passé à l'option \fB\-\-exclude\fP de \fBtar\fP(1)
quand on veut créer un fichier .orig.tar ou .tar (\fB\-\-tar\-ignore\fP depuis
dpkg\ 1.15.6). Par exemple, \fB\-I\fPCVS fera que tar sautera les répertoires du
CVS quand il doit créer un fichier .tar.gz. On peut répéter cette option
pour exclure à partir de plusieurs motifs.

\fB\-I\fP ajoute par défaut des options \fB\-\-exclude\fP qui élimineront les
fichiers et les répertoires de contrôles des systèmes les plus connus de
contrôle de version, les fichiers d'échange et de sauvegarde et les
répertoires utilisés par Libtool.
.PP
\fBNote\fP\ : même si elles ont des rôles similaires, \fB\-i\fP et \fB\-I\fP ont une
syntaxe et une sémantique très différentes. \fB\-i\fP ne peut être spécifié
qu'une fois et reçoit une expression rationnelle compatible avec le langage
Perl qui est appliquée sur chaque chemin relatif complet de chaque
fichier. \fB\-I\fP peut être spécifié plusieurs fois et prend un motif de nom de
fichier avec les méta\-caractères du shell. Le motif est appliqué au chemin
relatif complet mais aussi à chaque partie du chemin individuellement. La
sémantique exacte de l'option \fB\-\-exclude\fP de tar est un peu compliquée,
voir https://www.gnu.org/software/tar/manuel/tar.html#wildcards pour une
documentation plus complète.

L'expression rationnelle et le motif par défaut pour les deux options
peuvent être trouvés dans la sortie de la commande \fB\-\-help\fP.
.SS "Options d'extraction génériques"
.TP 
\fB\-\-no\-copy\fP
Ne copie pas l'archive d'origine à côté de l'extraction du paquet source
(depuis dpkg\ 1.14.17).
.TP 
\fB\-\-no\-check\fP
Ne vérifie pas les signatures et les sommes de contrôle avant de
dépaqueter(depuis dpkg\ 1.14.17).
.TP 
\fB\-\-no\-overwrite\-dir\fP
Ne pas remplacer le répertoire d'extraction s'il existe déjà (depuis
dpkg\ 1.18.8)
.TP 
\fB\-\-require\-valid\-signature\fP
Refuse de décompresser le paquet source s'il ne contient pas de signature
OpenPGP pouvant être vérifiée (depuis dpkg\ 1.15.0) soit avec le fichier de
clés \fItrustedkeys.gpg\fP de l'utilisateur, un des fichiers de clés propre à
un distributeur ou un des fichiers de clés officiels de Debian
(\fI/usr/share/keyrings/debian\-keyring.gpg\fP et
\fI/usr/share/keyrings/debian\-maintainers.gpg\fP).
.TP 
\fB\-\-require\-strong\-checksums\fP
Refuse de décompresser le paquet source s'il ne contient pas de somme de
contrôle robuste (depuis dpkg\ 1.18.7). Actuellement, \fBSHA\-256\fP est le seul
type de somme de contrôle considéré comme robuste.
.TP 
\fB\-\-ignore\-bad\-version\fP
Transforme la vérification des mauvaises versions des paquets source en
avertissement non fatal (since dpkg\ 1.17.7). Cette option sera seulement
nécessaire quand on extrait des anciens paquets source avec des versions
cassées, pour préserver la compatibilité avec les versions précédentes.

.SH "FORMATS DE PAQUET SOURCE"
Si vous ne savez pas quel format source utiliser, il est conseillé de
choisir soit «\ 3.0 (quilt)\ » soit «\ 3.0 (native)\ ». Voir
https://wiki.debian.org/Projects/DebSrc3.0 pour plus d'informations sur la
mise en œuvre de ces formats dans Debian.

.SS "Format\ : 1.0"
Un paquet source dans ce format se compose soit d'un \fB.orig.tar.gz\fP associé
à un \fB.diff.gz\fP ou un simple \fB.tar.gz\fP (dans ce cas, le paquet est appelé
natif \fInative\fP). L'archive tar originale pourrait être accompagnée de façon
facultative d'une signature amont séparée \fB.orig.tar.gz.asc\fP, extraction
prise en charge depuis dpkg\ 1.18.5.

\fBExtraction\fP

Extraire un paquet natif revient à une simple extraction de l'archive tar
dans le répertoire cible. L'extraction d'un paquet non natif consiste au
dépaquetage du \fB.orig.tar.gz\fP puis l'application des correctifs contenus
dans le \fB.diff.gz\fP. La date de tous les fichiers correctifs est réglée à
celle du moment de l'extraction depuis le paquet source (cela évite les
horodatages faux menant à des problèmes lorsque des fichiers générés
automatiquement sont modifiés). Le diff peut créer de nouveaux fichiers
(tout le répertoire debian est créé de cette façon) mais ne peut pas
supprimer de fichiers (les fichiers vides seront laissés là).

\fBConstruction\fP

Construire un paquet natif revient simplement à créer une archive tar avec
le répertoire du source. La création d'un paquet non natif consiste à
extraire l'archive d'origine dans un répertoire séparé «\ .orig\ » puis à
régénérer le \fB.diff.gz\fP en comparant le \fIrépertoire\fP du paquet source avec
le répertoire «\ .orig\ ».

\fBOptions de construction (avec \-\-build)\fP\ :

Si l'on donne un second argument, ce sera le nom du répertoire source
d'origine ou le nom du fichier tar ou bien une chaîne vide si le paquet est
un «\ Debian pure souche\ » et n'a donc pas de fichiers «\ diffs\ » pour sa
«\ debianisation\ ». S'il n'y a pas de second argument, \fBdpkg\-source\fP cherche
le fichier tar des sources d'origine
\fIpaquet\fP\fB_\fP\fIversion\-amont\fP\fB.orig.tar.gz\fP ou bien le répertoire source
d'origine \fIrépertoire\fP\fB.orig\fP selon les paramètres \fB\-sX\fP.

Les options \fB\-sa\fP, \fB\-sp\fP, \fB\-sk\fP, \fB\-su\fP et \fB\-sr\fP ne remplacent pas les
fichiers tar ou les répertoires existants. Pour cela, il faut utiliser les
options \fB\-sA\fP, \fB\-sP\fP, \fB\-sK\fP, \fB\-sU\fP et \fB\-sR.\fP
.PP
.TP 
\fB\-sk\fP
Spécifie que le source d'origine est attendu sous forme tar\ ; par défaut,
\fIpaquet\fP\fB_\fP\fIversion\-amont\fP\fB.orig.tar\fP\fIextension\fP. Il le laisse en place
en tant que fichier tar ou le copie dans le répertoire en cours s'il n'y est
pas déjà. Le fichier sera dépaqueté dans \fIrépertoire\fP\fB.orig\fP pour la
génération du fichier diff.
.TP 
\fB\-sp\fP
Comme \fB\-sk\fP mais supprimera le répertoire à nouveau par la suite.
.TP 
\fB\-su\fP
Quand on spécifie que le source d'origine est un répertoire\ ; la valeur par
défaut est le répertoire \fIpaquet\fP\fB\-\fP\fIversion\-amont\fP\fB.orig\fP et
\fBdpkg\-source\fP crée une nouvelle archive du source d'origine.
.TP 
\fB\-sr\fP
Comme \fB\-su\fP mais supprimera ce répertoire après utilisation.
.TP 
\fB\-ss\fP
Indique que le source d'origine est disponible à la fois comme un répertoire
et comme un fichier tar. \fBdpkg\-source\fP se servira du répertoire pour créer
le «\ diff\ », mais du fichier tar pour créer le fichier \fB.dsc\fP. Aussi, faire
attention avec cette option. Si le répertoire et le fichier tar ne
correspondent pas, il en résulte une mauvaise archive source.
.TP 
\fB\-sn\fP
Indique de ne pas chercher de source d'origine et de ne pas créer de
«\ diff\ ». Le second argument, s'il existe, doit être une chaîne vide. Cela
sert pour les paquets Debian pure souche qui n'ont pas un source d'origine
distincte et donc pas de fichier «\ diff\ » de debianisation.
.TP 
\fB\-sa\fP or \fB\-sA\fP
Indique comme source d'origine soit un fichier tar, soit un répertoire —\ le
deuxième argument, s'il existe, doit être l'un d'eux ou bien une chaîne vide
(cela revient à utiliser l'option \fB\-sn)\fP. Quand un fichier tar existe, il
est dépaqueté pour créer le fichier «\ diff\ »\ ; ensuite il est supprimé (cela
revient à utiliser l'option \fB\-sp)\fP\ ; quand un répertoire est trouvé, il est
dépaqueté et \fBdpkg\-source\fP crée le source d'origine et supprime ensuite ce
répertoire (cela revient à utiliser l'option \fB\-sr)\fP\ ; quand ni l'un ni
l'autre n'est trouvé, \fBdpkg\-source\fP suppose que le paquet ne possède pas de
fichier «\ diff\ » de debianisation, mais seulement une simple archive source
(cela revient à utiliser l'option \fB\-sn\fP). Quand les deux sont trouvés,
\fBdpkg\-source\fP ignore le répertoire et le remplace si l'option \fB\-sA\fP a été
spécifiée (cela revient à utiliser l'option \fB\-sP)\fP ou il provoque une
erreur si l'option \fB\-sa\fP a été spécifiée. L'option par défaut est \fB\-sA\fP.
.TP 
\fB\-\-abort\-on\-upstream\-changes\fP
Ce processus échoue si le fichier de différences contient des modifications
apportées à des fichiers en dehors du sous\-répertoire debian (depuis
dpkg\ 1.15.8). Cette option n'est pas autorisée dans \fBdebian/source/options\fP
mais peut être utilisée dans \fBdebian/source/local\-options\fP.
.PP

\fBoptions d'extraction (avec \-\-extract)\fP\ :

Dans tous ces cas, l'arborescence existante des sources d'origine est
supprimée.
.TP 
\fB\-sp\fP
Quand on extrait le répertoire source d'origine (s'il existe), il est
conservé en tant que fichier tar. S'il n'est pas déjà dans le répertoire
courant ou si ce répertoire contient un fichier différent, le fichier tar
est copié dans ce répertoire. (\fBCela est le comportement par défaut\fP).
.TP 
\fB\-su\fP
Dépaquetage de l'arborescence du répertoire source d'origine.
.TP 
\fB\-sn\fP
Assure que le répertoire source d'origine ne sera ni copié dans le
répertoire en cours, ni dépaqueté. Si une arborescence source d'origine est
présente dans le répertoire courant, elle est toujours supprimée.
.PP
Toutes les options \fB\-s\fP\fIX\fP s'excluent mutuellement. Si vous en indiquez
plusieurs, seule la dernière sera prise en compte.
.TP 
\fB\-\-skip\-debianization\fP
Passe l'étape d'application du fichier de différences Debian aux sources
amont (depuis dpkg\ 1.15.1).
.
.SS "Format\ : 2.0"
Extraction prise en charge depuis dpkg\ 1.13.9, construction depuis
dpkg\ 1.14.8. Aussi connu sous le nom de «\ wig&pen\ ». Ce format n'est pas
recommandé pour une utilisation massive, le format «\ 3.0 (quilt)\ » le
remplace. Wig&pen a été la première spécification d'une nouvelle génération
de format de paquet source.

Le comportement de ce format est le même que pour le format «\ 3.0 (quilt)\ »
sauf qu'il n'utilise pas de liste explicite de correctifs. Tous les fichiers
dans \fBdebian/patches/\fP correspondant à l'expression rationnelle Perl
\fB[\ew\-]+\fP doivent être des correctifs valables\ : ils sont appliqués au
moment de l'extraction.

Lors de la construction d'un nouveau paquet source, toute modification
apportée au source amont est enregistrée dans un correctif nommé
\fBzz_debian\-diff\-auto\fP.
.
.SS "Format\ : 3.0 (native)"
Pris en charge depuis dpkg\ 1.14.17. Ce format est une extension du format de
paquet natif tel que défini dans le format\ 1.0. Il gère toutes les méthodes
de compression et ignore par défaut tout fichier et répertoire spécifique à
VCS ainsi que de nombreux fichiers temporaires (voir la valeur par défaut
associée à l'option \fB\-I\fP dans la sortie de \fB\-\-help\fP).
.
.SS "Format\ : 3.0 (quilt)"
Supported since dpkg 1.14.17.  A source package in this format contains at
least an original tarball (\fB.orig.tar.\fP\fIext\fP where \fIext\fP can be \fBgz\fP,
\fBbz2\fP, \fBlzma\fP and \fBxz\fP) and a debian tarball (\fB.debian.tar.\fP\fIext\fP). It
can also contain additional original tarballs
(\fB.orig\-\fP\fIcomponent\fP\fB.tar.\fP\fIext\fP).  \fIcomponent\fP can only contain
alphanumeric (‘a\-zA\-Z0\-9’) characters and hyphens (‘\-’).  Optionally each
original tarball can be accompanied by a detached upstream signature
(\fB.orig.tar.\fP\fIext\fP\fB.asc\fP and \fB.orig\-\fP\fIcomponent\fP\fB.tar.\fP\fIext\fP\fB.asc\fP),
extraction supported since dpkg 1.17.20, building supported since dpkg
1.18.5.

.PP
\fBExtraction\fP
.PP
L'archive principale tar d'origine est extraite tout d'abord, puis toutes
les autres archives tar d'origine sont extraites dans des sous\-répertoires
dont le nom est formé à partir de la partie \fIcomposant\fP de leur
nom. L'archive tar Debian est extraite du répertoire source, après la
suppression de tout répertoire \fBdebian\fP existant. Notez que l'archive tar
Debian doit contenir un sous\-répertoire \fBdebian\fP, mais elle peut également
contenir des fichiers binaires en dehors de ce répertoire (voir l'option
\fB\-\-include\-binaries\fP).
.PP
Toutes les modifications figurant dans
\fBdebian/patches/\fP\fIdistributeur\fP\fB.series\fP ou \fBdebian/patches/series\fP sont
alors appliquées, où \fIdistributeur\fP sera le nom en minuscule du
distributeur actuel, ou Debian s'il n'y a pas de distributeur défini. Si
l'ancien fichier est utilisé et qu'il n'y en a pas de plus récent (ou si
c'est un lien symbolique), alors celui\-ci est remplacé par un lien
symbolique vers l'ancien. Cette disposition vise à simplifier l'utilisation
de \fBquilt\fP pour gérer l'ensemble des correctifs. Les fichiers de séries
propres au distributeur sont destinés à permettre de sérialiser plusieurs
branches de développement en se basant sur le distributeur, d'une manière
déclarative, de préférence au codage ouvert de cette gestion dans
\fBdebian/rules\fP. Cela est particulièrement utile quand le source à besoin de
correctifs de manière conditionnelle car les fichiers affectés n’ont pas de
gestion interne d’inclusion conditionnelle. Notez toutefois que si
\fBdpkg\-source\fP analyse correctement les fichiers de séries avec les options
utilisées pour l'application du correctif (stockées sur chaque ligne après
le nom du correctif et une ou plusieurs espaces), il n'ignore pas ces
options et s'attendra toujours à ce que les correctifs puissent être
appliqués avec l'option \fB\-p1\fP de \fBpatch\fP. Il va donc émettre un
avertissement lorsqu'il rencontrera ces options, et la construction est
susceptible d'échouer.
.PP
La date de tous les fichiers correctifs est celle du moment où se déroule
l'extraction du paquet source (cela évite les horodatages faux menant à des
problèmes lorsque des fichiers générés automatiquement sont modifiés).
.PP
Au contraire du comportement par défaut de \fBquilt\fP, les correctifs doivent
s'appliquer sans décalage («\ fuzz\ »). Quand cela n'est pas le cas, il est
suggéré de les rafraîchir avec \fBquilt\fP sinon \fBdpkg\-source\fP se terminera
avec une erreur en tentant de les appliquer.
.PP
Similaire au comportement par défaut de \fBquilt\fP, les modifications peuvent
aussi supprimer des fichiers.
.PP
Le fichier \fB.pc/applied\-patches\fP est créé si certains correctifs ont été
appliqués au cours de l'extraction.
.PP
\fBConstruction\fP
.PP
Les originaux de toutes les archives tar trouvées dans le répertoire courant
sont extraits dans un répertoire temporaire en suivant la même logique que
pour le dépaquetage, le répertoire debian est copié dans le répertoire
temporaire, et tous les correctifs excepté le correctif automatique
\fBdebian\-changes\-\fP\fIversion\fP ou \fBdebian\-changes\fP, selon
\fB\-\-single\-debian\-patch\fP) sont appliquées. Le répertoire temporaire est
comparé à celui du paquet source. Si le fichier de différences n'est pas
vide, la construction échoue à moins que \fB\-\-single\-debian\-patch\fP ou
\fB\-\-auto\-commit\fP  aient été utilisés, et dans ce cas le diff est stocké dans
le correctif automatique. Si le correctif automatique est créé ou supprimé,
il est ajouté ou supprimé dans le fichier «\ series\ » et les métadonnées de
\fBquilt\fP.

Tout changement dans un fichier binaire ne peut être indiqué dans le diff et
va déboucher sur un échec à moins que le responsable ne décide délibérément
d'inclure cette modification binaire dans l'archive tar Debian (en le
listant dans \fBdebian/source/include\-binaries\fP). La construction pourra
également échouer si des fichiers binaires sont trouvés dans le
sous\-répertoire debian sans être indiqué dans la liste blanche de
\fBdebian/source/include\-binaries\fP.

Le répertoire debian mis à jour et la liste des binaires modifiés sont
ensuite utilisés pour recréer l'archive tar debian.

Le diff généré automatiquement n'inclut pas les changements spécifiques sur
les fichiers VCS ainsi sur que de nombreux fichiers temporaires (pour la
valeur par défaut associée à l'option \fB\-i\fP, voir la sortie de
\fB\-\-help\fP). En particulier, le répertoire \fB.pc\fP utilisé par \fBquilt\fP est
ignoré lors de la génération automatique du correctif.

Note\ : \fBdpkg\-source\fP \fB\-\-before\-build\fP (et \fB\-\-build\fP) prendront soin
d'appliquer les correctifs indiqués dans le fichier series afin qu'un paquet
soit toujours construit avec toutes les corrections appliquées. Pour
effectuer cette détection, il recherche la liste des correctifs non
appliqués (ils sont mentionnés dans le fichier \fBseries\fP mais pas dans
\&\fB.pc/applied\-patches\fP) et si le premier de cette liste peut être appliqué
sans erreur, il les applique tous. L'option \fB\-\-no\-preparation\fP peut être
utilisée pour désactiver ce comportement.

.PP
\fBEnregistrement des modifications\fP
.TP 
\fB\-\-commit\fP [\fIrépertoire\fP] [\fInom\-du\-correctif\fP] [\fIfichier\-de\-correctif\fP]
Crée un correctif correspondant aux modifications locales non gérées par le
système de gestion de correctifs \fBquilt\fP et les intègre dans la liste des
correctifs sous le nom \fInom\-du\-correctif\fP. Si le nom est omis, il sera
demandé interactivement. Si \fIfichier\-de\-correctifs\fP est indiqué, il est
utilisé comme fichier de modifications locales à intégrer. Une fois intégré,
un éditeur est lancé afin de permettre d'ajouter des méta\-informations dans
l'en\-tête du correctif.

Le fait de passer \fIfichier\-de\-correctifs\fP est essentiellement utile après
un échec de construction qui prégénère ce fichier. Sur ces bases, le fichier
est supprimé après intégration. Veuillez également noter que les
modifications contenues dans le fichier de correctifs doivent déjà être
appliquées dans l'arborescence et que les fichiers modifiés par le correctif
ne doivent pas comporter de modifications supplémentaires.

Si la création de correctif détecte des fichiers binaires modifiés, ils
seront ajoutés automatiquement à \fBdebian/source/include\-binaries\fP afin de
pouvoir être inclus dans l'archive debian (de façon analogue à ce que ferait
\fBdpkg\-source \-\-include\-binaries \-\-build\fP).
.PP
\fBOptions de construction\fP
.TP 
\fB\-\-allow\-version\-of\-quilt\-db=\fP\fIversion\fP
Autorise \fBdpkg\-source\fP à construire le fichier si la version des
métadonnées de \fBquilt\fP est celle indiquée, même si \fBdpkg\-source\fP n'en n'a
pas connaissance (depuis dpkg\ 1.15.5.4). En fait, cela indique que la
version indiquée des métadonnées de \fBquilt\fP est compatible avec la
version\ 2 que \fBdpkg\-source\fP gère. La version des métadonnées de \fBquilt\fP
est conservée dans \fB.pc/.version\fP.
.TP 
\fB\-\-include\-removal\fP
N'ignore pas les fichiers supprimés et les inclut dans le fichier de
modifications généré automatiquement.
.TP 
\fB\-\-include\-timestamp\fP
Inclut la date dans le correctif généré automatiquement.
.TP 
\fB\-\-include\-binaries\fP
Ajoute tous les binaires modifiés dans l'archive tar debian. Les ajoute
aussi à \fBdebian/source/include\-binaries\fP\ : elles seront ajoutées par défaut
dans les constructions suivantes aussi cette option n'est donc plus
nécessaire.
.TP 
\fB\-\-no\-preparation\fP
N'essaye pas de préparer l'arbre de la construction en appliquant les
correctifs qui ne sont apparemment pas appliqués (depuis dpkg\ 1.14.8).
.TP 
\fB\-\-single\-debian\-patch\fP
Utilise \fBdebian/patches/debian\-changes\fP au lieu de
\fBdebian/patches/debian\-changes\-\fP\fIversion\fP comme nom du correctif
automatique créé au cours de la construction (depuis dpkg\ 1.15.5.4). Cette
option est particulièrement pratique lorsque le paquet est géré avec un
outil de gestion de versions et qu'un jeu de correctifs ne peut être créé de
façon fiable. Dans ce cas, les différences avec la version amont doivent
être conservées dans un correctif unique. Cette option serait indiquée dans
\fBdebian/source/local\-options\fP et accompagnée par un fichier
\fBdebian/source/local\-patch\-header\fP qui explique la meilleure méthode pour
revoir les corrections spécifiques à Debian, par exemple dans le
gestionnaire de versions utilisé.
.TP 
\fB\-\-create\-empty\-orig\fP
Crée automatiquement l'archive principale tar d'origine vide si elle est
manquante et qu'il existe des archives tar d'origine additionnelles (depuis
dpkg\ 1.15.6). Cette option peut être utilisée lorsque le paquet source est
une collection de différents sources amont et qu'il n'existe pas de logiciel
«\ principal\ ».
.TP 
\fB\-\-no\-unapply\-patches, \-\-unapply\-patches\fP
Par défaut, \fBdpkg\-source\fP retire automatiquement les correctifs dans le
point d'entrée \fB\-\-after\-build\fP s'ils ont été appliqués pendant
\fB\-\-before\-build\fP (\fB\-\-unapply\-patches\fP depuis dpkg\ 1.15.8,
\fB\-\-no\-unapply\-patches\fP depuis dpkg\ 1.16.5). Ces options permettent de
désactiver ou activer unilatéralement ce retrait des correctifs. Elles ne
sont permises que dans \fBdebian/source/local\-options\fP afin que tous les
paquets source créés aient le même comportement par défaut.
.TP 
\fB\-\-abort\-on\-upstream\-changes\fP
Ce processus échouera si un correctif automatique a été créé (depuis
dpkg\ 1.15.8). Cette option peut servir à vérifier que toutes les
modifications ont été enregistrées correctement dans des correctifs \fBquilt\fP
distincts avant la construction du paquet source. Elle n'est pas autorisée
dans \fBdebian/source/options\fP mais peut prendre place dans
\fBdebian/source/local\-options\fP.
.TP 
\fB\-\-auto\-commit\fP
Pas d'échec du processus de construction si un correctif automatique a été
créé\ : il est enregistré automatiquement dans le fichier series de \fBquilt\fP.

.PP
\fBOptions d'extraction\fP
.TP 
\fB\-\-skip\-debianization\fP
Passe l'étape d'extraction de l'archive tar debian des sources amont (depuis
dpkg\ 1.15.1).
.TP 
\fB\-\-skip\-patches\fP
Ne pas appliquer des correctifs à la fin de l'extraction (depuis
dpkg\ 1.14.18).
.
.SS "Format\ : 3.0 (custom)"
Pris en charge depuis dpkg\ 1.14.17. Ce format est particulier. Il ne
représente pas un réel format de paquet source mais peut être utilisé pour
créer des paquets sources avec des fichiers arbitraires.
.PP
\fBOptions de construction\fP
.PP
Tous les arguments qui ne sont pas des options sont pris pour des fichiers à
intégrer dans le paquet source généré. Ils doivent exister et être de
préférence dans le répertoire courant. Au moins un fichier doit être donné.
.TP 
\fB\-\-target\-format=\fP\fIvaleur\fP
\fBRequired\fP. Définit le format réel du paquet source généré. Le fichier
généré .dsc contiendra cette valeur dans son champ \fBformat\fP et non «\ 3.0
(custom)\ ».
.
.SS "Format\ : 3.0 (git)"
Pris en charge depuis dpkg\ 1.14.17. Ce format est expérimental.
.PP
Un paquet source qui utilise ce format est constitué d'un seul ensemble d'un
dépôt git \fB.git\fP qui contient les sources du paquet. Il peut également
exister un fichier \fI.gitshallow\fP qui donne les révisions d'un clone git
«\ shallow\ ».
.PP
\fBExtraction\fP
.PP
Cet ensemble est cloné sous forme d'un dépôt git dans le répertoire
cible. S'il existe un fichier \fI.gitshallow\fP, il est installé en tant que
\&\fI.git/shallow\fP dans le dépôt git cloné.
.PP
Veuillez noter que, par défaut, le nouveau dépôt aura la même branche
récupérée que celle qui était récupérée dans les sources d'origine (souvent
«\ master\ » mais cela peut être tout à fait autre chose). Toutes les autres
branches seront disponibles sous \fIremotes/origin\fP.
.PP
\fBConstruction\fP
.PP
Avant d'aller plus loin, quelques vérifications sont effectuées afin de
s'assurer qu'il n'existe aucun changement non ignoré non soumis.
.PP
\fBgit\-bundle\fP(1) permet de créer un ensemble à partir du dépôt git. Par
défaut, toutes les branches et étiquettes du dépôt sont incluses dans cet
ensemble.
.PP
\fBOptions de construction\fP
.TP 
\fB\-\-git\-ref=\fP\fIréf\fP
Permet d'indiquer une référence git à inclure dans l'ensemble
git. L'utilisation de cette option désactive le comportement par défaut qui
est d'inclure toutes les branches et étiquettes. Cette option peut être
utilisée plusieurs fois. Le paramètre \fIréf\fP peut être le nom d'une branche
ou une étiquette à inclure. Il peut également être tout paramètre que l'on
peut passer à \fBgit\-rev\-list\fP(1). Par exemple, pour n'inclure que la branche
«\ master\ », on peut utiliser \fB\-\-git\-ref=\fPmaster. Pour inclure toutes les
étiquettes et toutes les branches, sauf la branche privée, on peut utiliser
\-\fBgit\-ref=\fP\-\-all \fB\-\- git\-ref=\fP^private.
.TP 
\fB\-\-git\-depth=\fP\fInombre\fP
Crée un clone «\ shallow\ » dont l'historique est tronqué au nombre indiqué de
révisions.
.SS "Format\ : 3.0 (bzr)"
Pris en charge depuis dpkg\ 1.14.17. Ce format est expérimental. Il crée une
archive tar contenant le dépôt bzr correspondant.
.PP
\fBExtraction\fP
.PP
L'archive tar est décompressée puis bzr est utilisé afin de récupérer la
branche courante.
.PP
\fBConstruction\fP
.PP
Avant d'aller plus loin, quelques vérifications sont effectuées afin de
s'assurer qu'il n'existe aucun changement non ignoré non soumis.
.PP
Ensuite, la partie spécifique du répertoire source du gestionnaire de
versions est copiée dans un répertoire temporaire. Avant que ce répertoire
temporaire ne soit empaqueté dans une archive tar, divers nettoyages sont
effectués pour économiser de l'espace.
.SH DIAGNOSTICS
.SS "aucun format source indiqué dans debian/source/format"
Le fichier \fBdebian/source/format\fP devrait toujours exister et indiquer le
format source souhaité. Pour préserver la compatibilité avec d'anciennes
versions, le format «\ 1.0\ » est implicite quand le fichier n'existe pas. Il
est déconseillé de dépendre de ce comportement qui pourrait être modifié
dans de futures versions de \fBdpkg\-source\fP, qui échoueront alors en
l'absence d'une mention explicite de format.

Cela est dû au fait que le format «\ 1.0\ » n'est plus le format recommandé,
qu'il est conseillé de choisir un des formats les plus récents («\ 3.0
(quilt)\ » ou «\ 3.0 (native)\ ») mais que dpkg\-source ne le fera pas
automatiquement. Si vous souhaitez continuer à utiliser l'ancien format, il
est nécessaire d'être explicite et indiquer «\ 1.0\ » dans
\fBdebian/source/format\fP.
.SS "le fichier de différences modifie les fichiers amont suivants"
Lors de l'utilisation du format source «\ 1.0\ », il est déconseillé de
modifier directement les fichiers amont car les modifications restent alors
cachées et souvent non documentées dans le fichier diff.gz. Au contraire, il
est conseillé de conserver les modifications sous forme de correctifs dans
le répertoire debian et de les appliquer au moment de la construction. Pour
éviter ces opérations plus complexes, vous pouvez également choisir le
format «\ 3.0 (quilt)\ » qui permet ces opérations de manière native.
.SS "impossible d'identifier les changements de \fIfichier\fP"
Les modifications des sources amont sont en général conservées dans des
fichiers de correctifs mais certaines modifications ne peuvent être
représentées sous forme de tels fichiers qui ne peuvent modifier que des
fichiers texte. Si vous essayez de remplacer un fichier avec un objet d'un
type différent (par exemple remplacer un fichier par un lien ou un
répertoire), ce message d'erreur s'affichera.
.SS "le fichier \fIfichier\fP, nouvellement créé, ne sera pas représenté dans le fichier de différences"
Les fichiers vides ne peuvent pas être créés avec des correctifs. En
conséquence, la modification n'est pas enregistrée dans le paquet source, ce
qui provoque cet avertissement.
.SS "le mode exécutable \fIpermissions\fP de \fIfichier\fP ne sera pas représenté dans le fichier de différences"
Les fichiers de correctifs n'enregistrent pas les permissions de fichiers
et, en conséquence, les permissions des exécutables ne sont pas enregistrées
dans le paquet source, ce qui provoque cet avertissement.
.SS "le mode spécial \fIpermissions\fP de \fIfichier\fP ne sera pas représenté dans le fichier de différences"
Les fichiers correctifs n'enregistrent pas les permissions de fichiers et,
en conséquence, les permissions modifiées ne sont pas enregistrées dans le
paquet source, ce qui provoque cet avertissement.
.
.SH ENVIRONNEMENT
.TP 
\fBDPKG_COLORS\fP
Définit le mode de couleur (depuis dpkg\ 1.18.5). Les valeurs actuellement
acceptées sont \fBauto\fP (par défaut), \fBalways\fP et \fBnever\fP.
.TP 
\fBDPKG_NLS\fP
Si cette variable est définie, elle sera utilisée pour décider l'activation
de la prise en charge des langues (NLS –\ Native Language Support), connu
aussi comme la gestion de l'internationalisation (ou i18n) (depuis
dpkg\ 1.19.0). Les valeurs permises sont\ : \fB0\fP et \fB1\fP (par défaut).
.TP 
\fBSOURCE_DATE_EPOCH\fP
Si cette option est utilisée, elle sera utilisée comme horodatage (en
seconde à partir de «\ l'epoch\ ») pour fixer le «\ mtime\ » dans les entrées du
fichier \fBtar\fP(5).
.TP 
\fBVISUAL\fP
.TQ
\fBEDITOR\fP
Utilisé par les modules de format source «\ 2.0\ » et «\ 3.0 (quilt)\ ».
.TP 
\fBGIT_DIR\fP
.TQ
\fBGIT_INDEX_FILE\fP
.TQ
\fBGIT_OBJECT_DIRECTORY\fP
.TQ
\fBGIT_ALTERNATE_OBJECT_DIRECTORIES\fP
.TQ
\fBGIT_WORK_TREE\fP
Utilisés par les modules de format source «\ 3.0 (git)\ ».
.
.SH FICHIERS
.SS debian/source/format
Ce fichier contient sur une seule ligne le format à utiliser pour construire
le paquet source (les formats acceptés sont décrits plus haut). Il ne doit
pas contenir d'espace avant ou après l'indication du format.
.SS debian/source/include\-binaries
Ce fichier contient une liste de fichiers binaires (un par ligne) qui
doivent être inclus dans l'archive tar debian. Les espaces placées avant ou
après ces noms sont supprimées. Les lignes commençant par «\ \fB#\fP\ » sont des
commentaires et sont ignorées, ainsi que les lignes vides.
.SS debian/source/options
Ce fichier contient la liste des options qui seront automatiquement ajoutées
au jeu d'options de ligne de commande lors de l'appel à \fBdpkg\-source
\-\-build\fP ou \fBdpkg\-source \-\-print\-format\fP. Des options comme
\fB\-\-compression\fP et \fB\-\-compression\-level\fP conviennent bien pour ce fichier.
.P
Chaque option doit être placée sur une ligne distincte. Les lignes vides et
les lignes commençant par le caractère «\ \fB#\fP\ » sont ignorées. Les
caractères initiaux «\ \fB\-\-\fP\ » doivent être retirés et les options courtes ne
peuvent pas être utilisées. Des espaces optionnelles sont autorisées autour
du symbole «\ \fB=\fP\ », ainsi que des guillemets optionnels autour de la valeur
d'une option donnée. Voici un exemple d'un tel fichier\ :
.P
  # autoriser dpkg\-source à créer un fichier debian.tar.bz2 avec la
  #compression maximale
  compression = "bzip2"
  compression\-level = 9
  # utiliser debian/patches/debian\-changes comme correctif automatique
  single\-debian\-patch
  # ignorer les modifications dans config.{sub,guess}
  extend\-diff\-ignore = "(^|/)(config.sub|config.guess)$"
.P
Note\ : les options de \fBformat\fP ne sont pas acceptées dans ce fichier. Vous
devriez utiliser \fBdebian/source/format\fP à la place.
.SS debian/source/local\-options
Identique à \fBdebian/source/options\fP mais n'est pas enregistré dans le
paquet source créé. Ce fichier peut être utile pour conserver une préférence
propre au responsable ou au dépôt de gestionnaire de versions où le paquet
source est géré.
.SS "debian/source/local\-patch\-header \fRet\fP debian/source/patch\-header"
Texte en format libre qui sera ajouté au début du correctif automatique créé
dans les formats «\ 2.0\ » et «\ 3.0 (quilt)\ ». \fBlocal\-patch\-header\fP n'est pas
inclus dans le paquet source créé alors que \fBpatch\-header\fP l'est.
.SS debian/patches/\fIdistributeur\fP.series
.SS debian/patches/series
Ce fichier comporte la liste de toutes les correctifs qui ont été appliqués
(dans l'ordre indiqué) aux sources amont. Les espaces situées avant et après
les noms sont ignorées. L'argument \fIdistributeur\fP sera le nom en minuscules
du distributeur ou \fBdebian\fP si aucun distributeur n'est défini. Si le
fichier de séries propre au distributeur n'existe pas, le fichier de séries
sans distributeur sera utilisé. Les lignes commençant par «\ \fB#\fP\ » sont des
commentaires et sont ignorées, ainsi que les lignes vides. Les autres lignes
débutent par le nom du fichier de correctifs (relatif au répertoire
\fBdebian/patches/\fP) et se terminent à la première espace ou à la fin de la
ligne. Des options facultatives de \fBquilt\fP peuvent être ajoutées jusqu'à la
fin de la ligne ou jusqu'au premier caractère «\ \fB#\fP\ » précédé par une ou
plusieurs espaces (ce qui indique le début d'un commentaire se terminant à
la fin de la ligne).
.SH BOGUES
Le moment où se déroule le remplacement d'un champ par rapport à certaines
déterminations de champ affichées sur la sortie standard est plutôt
embrouillé.
.SH "VOIR AUSSI"
.ad l
\fBdeb\-src\-control\fP(5), \fBdeb\-changelog\fP(5), \fBdsc\fP(5).
.SH TRADUCTION
Ariel VARDI <ariel.vardi@freesbee.fr>, 2002.
Philippe Batailler, 2006.
Nicolas François, 2006.
Veuillez signaler toute erreur à <debian\-l10n\-french@lists.debian.org>.
