// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

package org.chromium.chrome.browser.share.screenshot;

import android.app.Activity;
import android.graphics.Bitmap;

import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;

import org.chromium.base.Callback;
import org.chromium.chrome.browser.share.share_sheet.ChromeOptionShareCallback;
import org.chromium.chrome.browser.tab.Tab;
/**
 * Coordinator for displaying the screenshot share sheet dialog.
 */
public class ScreenshotShareSheetDialogCoordinator {
    private final ScreenshotShareSheetDialog mDialog;
    private final FragmentManager mFragmentManager;
    private final Bitmap mScreenshot;

    /**
     * Constructs a new Screenshot Dialog.
     *
     * @param activity The parent activity.
     * @param dialog The Share Sheet dialog to use as fallback.
     * @param screenshot The Bitmap of the screenshot to share.
     * @param tab The Tab which contains the content to share.
     * @param shareCallback Callback called when falling back to the share sheet.
     * @param installCallback Callback called when the image editor is installed and run.
     */
    public ScreenshotShareSheetDialogCoordinator(Activity activity,
            ScreenshotShareSheetDialog dialog, Bitmap screenshot, Tab tab,
            ChromeOptionShareCallback shareCallback, Callback<Runnable> installCallback) {
        mFragmentManager = ((FragmentActivity) activity).getSupportFragmentManager();
        mDialog = dialog;
        mScreenshot = screenshot;
        mDialog.init(mScreenshot, tab, shareCallback, installCallback);
    }

    /**
     * Show the main share sheet dialog.
     */
    @VisibleForTesting(otherwise = VisibleForTesting.PROTECTED)
    public void showShareSheet() {
        mDialog.show(mFragmentManager, null);
    }
}
