// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_CHROMEOS_PLATFORM_KEYS_KEY_PERMISSIONS_USER_PRIVATE_TOKEN_KPM_SERVICE_FACTORY_H_
#define CHROME_BROWSER_CHROMEOS_PLATFORM_KEYS_KEY_PERMISSIONS_USER_PRIVATE_TOKEN_KPM_SERVICE_FACTORY_H_

#include <memory>

#include "base/memory/singleton.h"
#include "chrome/browser/chromeos/platform_keys/key_permissions/key_permissions_manager.h"
#include "components/keyed_service/content/browser_context_keyed_service_factory.h"
#include "components/keyed_service/core/keyed_service.h"

class Profile;

namespace user_prefs {
class PrefRegistrySyncable;
}

namespace chromeos {
namespace platform_keys {

// This is a service which holds the user-specific KeyPermissionsManager for a
// Profile.
class UserPrivateTokenKeyPermissionsManagerService : public KeyedService {
 public:
  explicit UserPrivateTokenKeyPermissionsManagerService(Profile* profile);
  UserPrivateTokenKeyPermissionsManagerService(
      const UserPrivateTokenKeyPermissionsManagerService&) = delete;
  UserPrivateTokenKeyPermissionsManagerService& operator=(
      const UserPrivateTokenKeyPermissionsManagerService&) = delete;
  ~UserPrivateTokenKeyPermissionsManagerService() override;

  // KeyedService
  void Shutdown() override;

  virtual KeyPermissionsManager* key_permissions_manager();

 protected:
  // Used by FakeUserPrivateTokenKeyPermissionsManagerService
  UserPrivateTokenKeyPermissionsManagerService();

 private:
  std::unique_ptr<KeyPermissionsManager> key_permissions_manager_;
};

class UserPrivateTokenKeyPermissionsManagerServiceFactory
    : public BrowserContextKeyedServiceFactory {
 public:
  static UserPrivateTokenKeyPermissionsManagerService* GetForBrowserContext(
      content::BrowserContext* context);

  static UserPrivateTokenKeyPermissionsManagerServiceFactory* GetInstance();

  UserPrivateTokenKeyPermissionsManagerServiceFactory();
  UserPrivateTokenKeyPermissionsManagerServiceFactory(
      const UserPrivateTokenKeyPermissionsManagerServiceFactory&) = delete;
  UserPrivateTokenKeyPermissionsManagerServiceFactory& operator=(
      const UserPrivateTokenKeyPermissionsManagerServiceFactory&) = delete;
  ~UserPrivateTokenKeyPermissionsManagerServiceFactory() override;

 private:
  friend struct base::DefaultSingletonTraits<
      UserPrivateTokenKeyPermissionsManagerServiceFactory>;

  // BrowserContextKeyedServiceFactory:
  KeyedService* BuildServiceInstanceFor(
      content::BrowserContext* context) const override;
  bool ServiceIsCreatedWithBrowserContext() const override;
  bool ServiceIsNULLWhileTesting() const override;
  void RegisterProfilePrefs(
      user_prefs::PrefRegistrySyncable* registry) override;
};

}  // namespace platform_keys
}  // namespace chromeos

#endif  // CHROME_BROWSER_CHROMEOS_PLATFORM_KEYS_KEY_PERMISSIONS_USER_PRIVATE_TOKEN_KPM_SERVICE_FACTORY_H_
