/***************************************************************************
 *   copyright       : (C) 2009-2017 by Pascal Brachet                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <QtGui>

#include "consolehighlighter.h"

ConsoleHighlighter::ConsoleHighlighter(QTextDocument *parent, bool blackschema)
    : QSyntaxHighlighter(parent)
{
MessageFormat.setFontWeight(QFont::Bold);
EntreeFormat.setFontWeight(QFont::Bold);

if (blackschema)
  {
  MessageFormat.setForeground(QColor("#D7B54F"));
  EntreeFormat.setForeground(QColor("#AACC00"));
  }
else
  {
  MessageFormat.setForeground(QColor(0x00, 0x00, 0xCC));
  EntreeFormat.setForeground(QColor(0x80, 0x00, 0x00));
  }
}

void ConsoleHighlighter::highlightBlock(const QString &text)
{

QString t;
QRegExp rxMessage("\\*\\*\\*(.*)\\*\\*\\*");
if ((rxMessage.indexIn(text)!=-1) || text.startsWith("Trac") )
	{
	setFormat(0, text.length(),MessageFormat);
	}
else if (text.startsWith("Entrer ")) 
	{
	setFormat(0, text.length(),EntreeFormat);
	}
}
