---
description: How to unfold supercell band structures
authors: OR
---
<!--- This is the source file for this topics. Can be edited. -->

This page gives hints on how to unfold supercell band structures with the ABINIT package.

## Introduction

Supercells are often used in ab initio calculations to model compound alloys,
surfaces and defects. Band structure plots obtained from supercell
calculations are difficult to interpret and compare to the reference band
structure of a corresponding primitive crystallographic unit due to the zone
folding. The purpose of the executable file [[help:fold2bloch]] is to assist
with interpretation of supercell electronic structure calculations by
recovering the Bloch character of electronic eigenstates perturbed by
disorder. In general, there is no single wave-vector **k** associated with a
particular eigenvalue E, but rather a distribution of k's. This distribution
is also known as a Bloch spectral density or spectral weight. The spectral
weight w n( **k** ) amounts to a Bloch **k** -character of the n'th energy
eigenstates εn and fulfills the normalization ∑ **k** wn( **k** )=1. In the
case of a non-local basis set, such as plane waves, the spectral weight can be
constructed from the Fourier expansion coefficients by gathering them in
groups associated with a particular Bloch wave vector in the primitive cell
[[cite:Wang1998]], [[cite:Popescu2010]], [[cite:Popescu2012]],
[[cite:Allen2013]], [[cite:Medeiros2014]]

wn( **k** )= ∑ **G** |C n, **K** ( **G** )|2 for all **G** that fulfill **K**
+ **G** = **k** + **g** ,

where Cn, **K** ( **G** ) refers to plane wave coefficients for nth eigenstate
with the wave vector **K** within the first Brillouin zone (BZ) of the
supercell, **G** and **g** are the reciprocal lattice vectors of the supercell
and primitive cell, respectively. More technical details on this unfolding
procedure are available in [[cite:Rubel2014]]. It should be noted that the
primitive and supercell reciprocal lattices should be commensurate as required
by the above equation. This condition implies that a supercell needs to be
generated by translation of the primitive cell along its lattice vectors in
real space using a desired multiplicity N x×Ny×Nz . Care should be taken when
working with lattices whose conventional unit cell is different from the
primitive cell (e.g., zinc-blende or rock salt structures).

A prerequisite for unfolding is the presence of wave function files (e.g.,
abo_WFK) that can be generated in a way similar to standard band structure
calculations. The only difference from the conventional band structure
calculation is the k-path selection approach. For instance, when aiming for
the band structure plot with Γ(0,0,0)-Z(0,0,1/2) path in the primitive
Brillouin zone (BZ), the [[kptbounds]] in supercell BZ should include
Z-(0,0,-1/2)-Γ(0,0,0)-Z(0,0,1/2). At first, the part Z--Γ seems redundant
lying outside of the range of interest. However, it is easy to show that those
wave vectors contribute to the range Γ-Z after unfolding. For instance, let us
consider a k-point (0,0,-K) in the 1×1×3 supercell. This point ``unfolds" into
3 k-points in the primitive BZ: (0,0,(-K-1)/3), (0,0,-K/3), and
(0,0,(-K+1)/3). The first two points are irrelevant for the purpose of the
plot as they do not belong to the Γ-Z segment, but the last point falls into
the range of interest and needs to be included.

Once the wave function file is prepared, the unfolding proceeds by invoking
fold2Bloch abo_WFK Nx:Ny:Nz that generates an output file abo_WFK.f2b. The
output file contains 5 columns: the list of unfolded wave vectors (kx,ky,kz)
in the primitive BZ, the corresponding eigenvalue εn (Ha) and the Bloch
spectral weight wn.

A MATLAB script _ubs_dots.m_ is designed to assist with plotting the unfolded
band structure. The unfolded band structure plot is represented as a scatter
plot where the size and colour of the markers carry information about the
Bloch character of energy bands. Users are asked to provide details about the
k-path, name of the fold2Bloch output file abo_WFK.f2b, position of the Fermi
energy, and reciprocal lattice vectors that can be found in the main output
file ab_out.out.



## Related Input Variables

{{ related_variables }}

## Selected Input Files

{{ selected_input_files }}

## Tutorials

* [[lesson:fold2bloch|The lesson on unfolding supercell band structures]]

