/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "k8s.io/api/core/v1"
	corev1 "k8s.io/client-go/applyconfigurations/core/v1"
	gentype "k8s.io/client-go/gentype"
	typedcorev1 "k8s.io/client-go/kubernetes/typed/core/v1"
)

// fakeNamespaces implements NamespaceInterface
type fakeNamespaces struct {
	*gentype.FakeClientWithListAndApply[*v1.Namespace, *v1.NamespaceList, *corev1.NamespaceApplyConfiguration]
	Fake *FakeCoreV1
}

func newFakeNamespaces(fake *FakeCoreV1) typedcorev1.NamespaceInterface {
	return &fakeNamespaces{
		gentype.NewFakeClientWithListAndApply[*v1.Namespace, *v1.NamespaceList, *corev1.NamespaceApplyConfiguration](
			fake.Fake,
			"",
			v1.SchemeGroupVersion.WithResource("namespaces"),
			v1.SchemeGroupVersion.WithKind("Namespace"),
			func() *v1.Namespace { return &v1.Namespace{} },
			func() *v1.NamespaceList { return &v1.NamespaceList{} },
			func(dst, src *v1.NamespaceList) { dst.ListMeta = src.ListMeta },
			func(list *v1.NamespaceList) []*v1.Namespace { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.NamespaceList, items []*v1.Namespace) { list.Items = gentype.FromPointerSlice(items) },
		),
		fake,
	}
}
